<?php
require_once("/lamp/www/quantix/inc/config.php");

echo "Testing SLP37-401 matching\n";
echo "==========================\n\n";

$test_text = "SLP37-401 - RoG1BQ -B";
echo "Original text: $test_text\n";

// Test normalization (from link_pms_propiedades.php)
$norm = strtolower(trim(preg_replace('/[^a-z0-9\s\-]/i', ' ', $test_text)));
echo "Normalized: '$norm'\n\n";

// Test Pattern 0 regex
$pattern0 = '/^([a-z]{2,4})(\d{2,3})\s*[\-]\s*(\d{2,4})/i';
if (preg_match($pattern0, $norm, $matches)) {
    echo "✓ Pattern 0 MATCHED!\n";
    print_r($matches);
    echo "\n";

    $abbr = $matches[1];
    $building_num = $matches[2];
    $unit_num = $matches[3];

    echo "Extracted:\n";
    echo "  Abbreviation: $abbr\n";
    echo "  Building: $building_num\n";
    echo "  Unit: $unit_num\n\n";

    // Test abbreviation mapping
    $abbr_map = [
        'slp' => 'san luis potosi',
        'vs' => 'versalles',
        'ver' => 'veracruz',
        'pe' => 'paseo de la reforma'
    ];

    $street = $abbr_map[strtolower($abbr)] ?? $abbr;
    $full_building = $street . ' ' . $building_num;

    echo "Mapped:\n";
    echo "  Street: $street\n";
    echo "  Full building: $full_building\n\n";

    // Now check if we have this property
    $sql = "SELECT propiedad_id, nombre_propiedad, direccion
            FROM propiedad
            WHERE nombre_propiedad LIKE " . strit("%$full_building%$unit_num%") . "
               OR nombre_propiedad LIKE " . strit("%$street%$building_num%$unit_num%");

    echo "Checking database for property...\n";
    echo "SQL: $sql\n\n";

    $results = ia_sqlArrayIndx($sql);

    if (count($results) > 0) {
        echo "✓ Found " . count($results) . " matching properties:\n";
        foreach ($results as $prop) {
            echo "  - {$prop['nombre_propiedad']} (ID: {$prop['propiedad_id']})\n";
        }
    } else {
        echo "❌ No matching properties found\n";

        // Try broader search
        echo "\nTrying broader search...\n";
        $sql2 = "SELECT propiedad_id, nombre_propiedad
                FROM propiedad
                WHERE nombre_propiedad LIKE " . strit("%San Luis Potosí 37%");
        $all_slp37 = ia_sqlArrayIndx($sql2);
        echo "All SLP37 properties:\n";
        foreach ($all_slp37 as $prop) {
            echo "  - {$prop['nombre_propiedad']}\n";
        }
    }
} else {
    echo "❌ Pattern 0 DID NOT match\n";
    echo "Testing individual components:\n\n";

    // Test parts
    if (preg_match('/^([a-z]{2,4})/', $norm, $m)) {
        echo "  Abbr part: '{$m[1]}'\n";
    }
    if (preg_match('/(\d{2,3})/', $norm, $m)) {
        echo "  Building part: '{$m[1]}'\n";
    }
    if (preg_match('/\-\s*(\d{2,4})/', $norm, $m)) {
        echo "  Unit part: '{$m[1]}'\n";
    }
}
?>
