<?php
/**
 * Test script to verify get_unmatched SQL query works
 */

require_once('cfdi_matcher_bootstrap.php');

echo "Testing get_unmatched query...\n\n";

// Get latest iteration ID
$latest_iter_sql = "SELECT iteration_id FROM cfdi_matcher_iterations
                    ORDER BY iteration_id DESC LIMIT 1";
$latest_iter = ia_sqlArrayIndx($latest_iter_sql)[0] ?? null;

if (!$latest_iter) {
    die("ERROR: No iterations found in database\n");
}

$iteration_id = $latest_iter['iteration_id'];
echo "✓ Latest iteration ID: $iteration_id\n\n";

// Test the unmatched query (FIXED: correct column names)
$sql = "SELECT
    i.eleyeme_cfdi_emitido_id as invoice_id,
    i.Fecha_Emision as invoice_date,
    i.Total as amount,
    i.Nombre_Receptor as client_name,
    i.RFC_Receptor as client_rfc,
    i.Estado_de_Cuenta as estado,
    CONCAT(COALESCE(i.Serie, ''), '-', COALESCE(i.Folio, '')) as folio,

    CASE
        WHEN i.Estado_de_Cuenta IS NOT NULL AND i.Estado_de_Cuenta != '' THEN 1
        ELSE 0
    END as has_estado

FROM eleyeme_cfdi_emitidos i
WHERE i.Fecha_Emision >= '2024-01-01'
AND i.eleyeme_cfdi_emitido_id NOT IN (
    SELECT invoice_id FROM cfdi_matcher_results
    WHERE iteration_id = ?
)
ORDER BY i.Fecha_Emision DESC
LIMIT 10";

$stmt = $gIAsql_link->prepare($sql);
if (!$stmt) {
    die("ERROR: Failed to prepare statement: " . $gIAsql_link->error . "\n");
}

$stmt->bind_param('i', $iteration_id);
$stmt->execute();
$result = $stmt->get_result();
$invoices = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

echo "✓ Query executed successfully\n";
echo "✓ Found " . count($invoices) . " unmatched invoices\n\n";

if (count($invoices) > 0) {
    echo "First 3 unmatched invoices:\n";
    echo "═══════════════════════════════════════════════════════════════\n";

    for ($i = 0; $i < min(3, count($invoices)); $i++) {
        $inv = $invoices[$i];
        echo "  Folio: " . ($inv['folio'] ?? 'N/A') . "\n";
        echo "  Client: " . $inv['client_name'] . "\n";
        echo "  RFC: " . $inv['client_rfc'] . "\n";
        echo "  Date: " . $inv['invoice_date'] . "\n";
        echo "  Amount: $" . number_format($inv['amount'], 2) . "\n";
        echo "  Estado: " . ($inv['estado'] ?: '[empty]') . "\n";
        echo "  Has Estado: " . ($inv['has_estado'] ? 'YES' : 'NO') . "\n";
        echo "  ───────────────────────────────────────────────────────────\n";
    }
} else {
    echo "🎉 All invoices matched! No unmatched records.\n";
}

// Test count query for full stats
$count_sql = "SELECT COUNT(*) as total FROM eleyeme_cfdi_emitidos i
              WHERE i.Fecha_Emision >= '2024-01-01'
              AND i.eleyeme_cfdi_emitido_id NOT IN (
                  SELECT invoice_id FROM cfdi_matcher_results
                  WHERE iteration_id = ?
              )";

$stmt = $gIAsql_link->prepare($count_sql);
$stmt->bind_param('i', $iteration_id);
$stmt->execute();
$total_result = $stmt->get_result();
$total_row = $total_result->fetch_assoc();
$stmt->close();

echo "\n✓ Total unmatched invoices: " . $total_row['total'] . "\n";

echo "\n═══════════════════════════════════════════════════════════════\n";
echo "  Test Complete - Query Works! ✓\n";
echo "═══════════════════════════════════════════════════════════════\n";
