<?php
require_once('../inc/config.php');
?><!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Error reporter</title>
<?php
    global $gIaHeader;
    $gIaHeader->html_head_add(array( 'jqgrid','ia' ));
    $gIaHeader->html_head_echo(); 
?>
<!--suppress CssUnusedSymbol -->
    <style>
    input:read-only {border:none;background-color: whitesmoke;}
    input:-moz-read-only {border:none;background-color: whitesmoke;}
    textarea:read-only {border:none;background-color: whitesmoke;white-space: normal;}
    textarea:-moz-read-only {border:none;background-color: whitesmoke;white-space: normal;}
    TD.CaptionTD {color:blue;vertical-align:top;border:1px silver solid;overflow-x: hidden;}
    TD.DataTD {vertical-align:top;white-space: normal;}
    TD {vertical-align: top;}
    .FormGrid TABLE TBODY TR TD:empty {display: none;}
    .FormGrid {empty-cells:hide;color:red}
    .statusBug {color:red}
    .form-view-data {border:1px silver solid!important;white-space: pre-wrap!important;}
</style>
    <link rel="stylesheet" type="text/css" media="screen" href="../js2/tablesorter-master/dist/css/theme.basic.css"/>
    <script src="../js2/tablesorter-master/dist/js/jquery.tablesorter.min.js"></script>
</head>
<body>
<div id="loadingMask" style="width: 100%; height: 100%; position: fixed; background: #fff; z-index: 999;display:none">Loading...</div>
<?php
$f = new iacase_base();
$f->table = 'icac_error';
$f->label = 'Errores detectados';
$f->permiso_insert = $f->permiso_export = false;
$f->toolbar_set();
$f->display_toolbar();

if(!empty($_REQUEST['fixAll'])) {
    ia_query("UPDATE icac_error SET status='Fixed' WHERE status='Bug' /*icac_error.php*/");
}


try {
    $error_type = [];
    foreach(ia_sqlVector("SELECT /*icac_error.php*/ DISTINCT error_type FROM icac_error ORDER BY error_type") as $error)
        $error_type[] = "'$error':'$error'";
    unset($error);
    $error_type_combo = "'':''," . implode(",", $error_type);
    unset($error_type);

} catch(Exception $e) {
    $error_type_combo = "'':'', 'php':'php','Sql':'Sql','js':'js', 'json':'json', 'pcre':'pcre', 'libxml':'libxml','exception':'exception','manual','manual'";
}

function stats($monthsAgo):void {
    $since = Date('Y-m-d', strtotime("$monthsAgo MONTHS AGO"));
    $method = __METHOD__;

    $queries = [
        'Bugs Injected vs Fixed' =>
        "
                SELECT /*$method*/ 
                    DATE_FORMAT(bugs.last_seen, '%Y/%m %M') as Mes,
                    COUNT(*) as '# All Live Bugs: Detected', 
                    SUM(bugs.seen_times) as '# ALl live Detected Bugs: Seen',
                    '' as  '# New  live Bugs: this month', 
                    '' as  '# New live Bugs: Seen this month',
                    '' as  '# Fixed Bugs this month', 
                    '' as  '# Fixed Bugs Seen this month'
                FROM icac_error bugs
                WHERE bugs.last_seen >= DATE_SUB(CURRENT_DATE, INTERVAL $monthsAgo MONTH ) AND bugs.status = 'Bug'
                GROUP BY 1, 4, 5, 6, 7
            UNION    
                SELECT /*$method*/ 
                    DATE_FORMAT(bugs.first_seen, '%Y/%m %M') as Mes,
                    '' as '# Bugs Detected', 
                    '' as '# Detected Bugs Seen',            
                    COUNT(*) as '# New Bugs', 
                    SUM(bugs.seen_times) as '# New Bugs Seen',
                    '' as  '# Fixed Bugs', 
                    '' as  '# Fixed Bugs Seen'
                FROM icac_error bugs
                WHERE bugs.first_seen >= DATE_SUB(CURRENT_DATE, INTERVAL $monthsAgo MONTH ) AND bugs.status = 'Bug'
                GROUP BY 1, bugs.Status
            UNION
                SELECT IFNULL(DATE_FORMAT(fix.last_fixed, '%Y/%m %M'), '(Forced)') as Mes,
                    '' as '# Bugs Detected', '' as '# Detected Bugs Seen',               
                    '' as  '# New Bugs', '' as  '# New Bugs Seen',
                    COUNT(*) as '# Fixed', SUM(fix.seen_times) as '# Fixed Bug Seen'
                FROM icac_error fix
                WHERE fix.last_fixed >= DATE_SUB(CURRENT_DATE, INTERVAL $monthsAgo MONTH ) AND fix.status = 'Fixed'
                GROUP BY 1              
            ORDER BY 1 DESC",
    ];
    $doHR = "open";
    foreach($queries as $caption => $sql) {
        $records = ia_sqlArrayIndx($sql);
        if($doHR == "open") {
            $result = [];
            foreach($records as $r) {
                $key = $r['Mes'];
                if(!array_key_exists($key, $result)) {
                    $result[$key] = $r;
                    continue;
                }
                foreach($r as $k => $v) {
                    if(!empty($v))
                        $result[$key][$k] = $v;
                }
            }
            $records = $result;
        }
        echo "<details $doHR class='default'><summary>$caption</summary><div>" .
          iaTableIt::getTableIt($records, "<h3>Por $caption</h3>", $caption) .
          "</div></details>";
        if($doHR === "open") {
            echo "<hr>";
            $doHR = "";
        }
    }
}

?>
<table id="list"></table>
<div id="listPager"></div>

<fieldset style="margin:2em;padding:1em;border:4px groove seashell;width:fit-content"><legend><b>Bugs Stats 4 Months</b></legend>
        <?php stats(4); ?>
</fieldset>

<div style="margin: 1em auto;border-top: 1px silver solid;">
<form method="POST" style="margin: 1em;">
    Notas y tips
    <ul style="line-height: 2em;">
        <li>Cambiar el status en el server de bugs arreglados a Fixed o se deben ignorar a Won't Fix</li>
        <?php
               echo '<li><input type="submit" name="fixAll" value="🕱 DANGER: Pasa todos los Bug a Fixed 🕱" 
                    style="all: revert;color:red;font-weight: bold;padding:0.5em;
                    background-image: linear-gradient(to bottom, #e4e4e4, #f7f7f7);border: 1px solid red;cursor:pointer" /></li>';
         ?>
    </ul>
</form>
</div>

<script>
let icac_error = {
    colTemplate: {align: "left", editable: true,editoptions: { readonly: "readonly" } },
    templateDate: {width: 150, align: "center",
        searchoptions: { sopt: ["ge",  "le", "eq", "ne", ], dataInit: function(elem) {
                $(elem).datepicker({
                    dateFormat: "yy-mm-dd",
                    autoSize: true,
                    changeYear: true,
                    changeMonth: true,
                    showButtonPanel: true,
                    showWeek: false
                });
            },}
    },
    templateInt:{align: "right",width: 96,sorttype: "int",formatter: 'integer',formatoptions: { thousandsSeparator: ',' },
        searchoptions: { sopt: ["ge",  "le", "eq", "ne", ] }
    },
    templateString: {align: "left",edittype: "text", searchoptions: { sopt: ["cn", "eq", "ne"]} },
    templateText: {align: "left",edittype: "textarea", searchoptions: { sopt: ["cn","bw"]}, width:500,
         // formatter:textFormatter,
         formatter:iaHtmlFormatter, unformat:iaHtmlUnFormatter,
         classes:"vAlignTop"
        
    },
    templateSelect: {type:"select", formatter:"select", edittype:"select", searchoptions: { sopt: ["eq"]},stype:'select', searchOperators:false}
};

  function reformatForm(form, prefix) {
    $($(`#${prefix}_file`).children("td.DataTD")[0]).attr('colspan','7').children("input").css({width:'95%'});
    $($(`#${prefix}_error_message`).children("td.DataTD")[0]).attr('colspan','9').children("textarea").css({width:'95%'});
    $($(`#${prefix}_note`).children("td.DataTD")[0]).attr('colspan','9').children("textarea").css({width:'95%'});
    let dialog=form.closest('div.ui-jqdialog');
    dialog.width(window.innerWidth - 196);
  }

</script>
<!--suppress ES6ConvertVarToLetConst -->
<script>
var br;
var gridhandler = $gridx = $("#list");
jQuery(function($){
    $gridx.jqGrid({
        url:"ajax/jqgrid_icac_error.php",
        editurl:"ajax/jqgrid_icac_error.php",
        datatype: "json",
        mtype:"POST",
        loadonce: false,
        loadui:"disable", 
        colModel: [
                {name: "icac_error_id", label:"ID",key: true, hidden: true,editable: true,search:false,sortable:false,
                    'BusquedaRapida':{'no_busqueda_rapida': true}
                },
                {name: "iacsel",index:"iacsel", label:"&Sigma;" ,colmenu: false
                    ,template:iacJqGridSelect().iacselColTemplate,width:80,ctrl:true,ctrlId:'#iactoolbarselect',
                    ctrlButtonset:true,sumCols:false
                },
                {name:"Actions", label:"&nbsp;", formatter:'actions',width:100,search:false,sortable:false,editable: false,editoptions:{readonly:null,display:'none'},
                    formatoptions:{delbutton : true,},formoptions:{rowpos:8,colpos:1,display:"none"},
                    'BusquedaRapida':{'no_busqueda_rapida': true}
                },
                {name: "last_seen", label: "Last Seen", template: icac_error.templateDate, width:180, formoptions:{rowpos:2,colpos:3},
                    'BusquedaRapida':{
                        'type':'ba_fecha',
                        'input': 'last_seen',
                        'field': 'last_seen',
                        'group': 'F R E C U E N T E S'
                    }
                },
                {name: "first_seen", label: "First Seen", template: icac_error.templateDate, width:180, formoptions:{rowpos:2,colpos:4},
                    'BusquedaRapida':{
                        'type':'ba_fecha',
                        'input': 'first_seen',
                        'field': 'first_seen',
                        'group': 'F R E C U E N T E S'
                    }
                },
                {name: "seen_times", label: "Seen #", width:150, template: icac_error.templateInt, formoptions:{rowpos:2,colpos:5},
                    'BusquedaRapida': {
                        'type':'ba_input',
                        'input': 'seen_times',
                        'field': 'seen_times',
                        'group': 'F R E C U E N T E S'
                    }
                },

                {name: "status", label: "Status", template: icac_error.templateSelect, width: 205,align:'center',
                    editoptions: {value:{'Bug':'Bug','Fixed':'Fixed','Wont Fix':'Wont Fix','Info':'Info'} },
                    searchoptions: {multiple:false, size:1,  value:{'':'', 'Bug':'Bug','Fixed':'Fixed','Wont Fix':'Wont Fix','Info':'Info'},
                        sopt: ["in", "eq"]
                    }, // ,defaultValue:"Bug"
                    size:'1',
                    formoptions:{rowpos:2,colpos:1},
                    cellattr: function(index, cellvalue) { return (cellvalue === 'Bug') ? ' class="statusBug bold"' : 'class="bold"'; },
                    'BusquedaRapida': {
                        'group': 'F R E C U E N T E S'
                    }
                },
                {name: "error_type", label: "Tipo", template: icac_error.templateSelect, width: 215,align:'center',
                    editoptions: { value:{<?=$error_type_combo?>}, readonly:"readonly" },
                    searchoptions: {multiple:false, size:1, value:{<?=$error_type_combo?>},
                        sopt:['in', 'eq', 'ne']
                    },
                    multiple:false,size:'1',
                    formoptions:{rowpos:2,colpos:2},
                    'BusquedaRapida': {
                        'group': 'F R E C U E N T E S'
                    }
                },

                {name: "error_message", label: "Error",
                    template:icac_error.templateText,classes:'',width: 800,
                    //template:colFmt.text,

                    formoptions:{rowpos:4,colpos:1},
                    editable: false,
                    'BusquedaRapida' : {
                        'type': 'ba_tagify',
                        'input': 'error_message',
                        'field': 'error_message',
                        'group': 'F R E C U E N T E S'
                    }
                },

                {name: "file", label: "File", template: icac_error.templateString, width: 300, formoptions:{rowpos:3,colpos:1,}, classes:"jqgRZ",
                    'BusquedaRapida' : {
                        'type': 'ba_tagify',
                        'input': 'file',
                        'field': 'file',
                        'group': 'F R E C U E N T E S'
                    }
                },
                {name: "line", label: "Line", template: icac_error.templateInt, width:150, formoptions:{rowpos:3,colpos:5}, 'BusquedaRapida':{'no_busqueda_rapida': true}},

                {name: "usuario", label: "User", template: icac_error.templateString, width: 200, formoptions:{rowpos:5,colpos:1},
                    'BusquedaRapida' : {
                        'type': 'ba_tagify',
                        'input': 'usuario',
                        'field': 'usuario',
                        'group': 'F R E C U E N T E S'
                    }
                },
                {name: "note", label: "Notas", template:icac_error.templateText, edittype:'textarea', editoptions:{rows:10, cols:30, readonly: false,
                        'dataInit' : function (elem) { $(elem).focus();}}, formoptions:{rowpos:7,colpos:1,elemprefix:'* edit *'},
                        'BusquedaRapida':{'no_busqueda_rapida': true}},
                {name: "last_fixed", label: "Fixed", template: icac_error.templateDate, formoptions:{rowpos:6,colpos:1},
                    'BusquedaRapida': {
                        'type':'ba_input',
                        'input': 'note',
                        'field': 'note',
                        'group': 'F R E C U E N T E S'
                    }},
                {name: "fixes", label: "# Fixes", template: icac_error.templateInt, width: 150, formoptions:{rowpos:6,colpos:2},
                    'BusquedaRapida': {
                        'type':'ba_input',
                        'input': 'fixes',
                        'field': 'fixes',
                        'group': 'F R E C U E N T E S'
                    }},

            ],
            autoencode:true,

            ignoreCase:true,
            multiSort : true,

            //scrollrows:true,
            scrollingRows:false,
            hoverrows:true,
            height:window.innerHeight - 300 < 200 ? 200 : window.innerHeight - 270,
            width:$gridx.parent().width()-8,
            cmTemplate: icac_error.colTemplate,
            rowNum: 150,
            rowList: [ 10, 20, 25, 30, 40, 50, 100, 150, 200, 10000],
            viewrecords: true,
            pager: '#listPager',
            rownumbers: true,

            sortname: "last_seen",
            sortorder: "desc",

            caption: "Errors detected",
            postData:{
                filters:{
                    groupOp:'AND', rules:[{field:"status",op:"eq",data:"Bug"}]
                }
            },
            loadComplete:function(data){
                var g = $(this);
                if(typeof g.data('firstLoad') === 'undefined' ){
                    g.data('firstLoad', true);
                    $(".ui-pg-selbox").find('option[value="0"]').text('Todos');
                    $("#gs_status").find("option[value='Bug']").prop('selected', 'selected');
                }
            },
            beforeProcessing: function(data, status, xhr){
                //Ph. 14-04-2025
                //gzipping rows
                data.rows = decompressPayload(data.rows);

                if(typeof $gridParams === 'undefined')
                    $gridParams = gridhandler.jqGrid('getGridParam');
            },


    })
        .jqGrid('gridResize',{minWidth:150,maxWidth:3000,minHeight:80, maxHeight:3000})

        .jqGrid('filterToolbar',{stringResult: true, defaultSearch:'cn',searchOperators:true,autosearch:true,searchOnEnter:true,loadFilterDefaults: true } )

        .jqGrid('navGrid','#listPager', // .jqGrid('navGrid','#gridpager',{parameters},prmEdit, prmAdd, prmDel, prmSearch, prmView);
         {add:false,edit:true,del:false,view:true,search:true,refresh:true,refreshstate:'currentfilter',},
             {/* edit form bottom navigation */
                recreateForm:true,closeOnEscape:true,dataheight:'auto',reloadAfterSubmit:true,
                afterSubmit:function(response,postdata){
                    try{
                        var result=JSON.parse( response.responseText.replace(/(\r\n|\n|\r)/gm,'') );
                        if(result.success) {
                            $gridx.jqGrid('setRowData', result.row.icac_error_id, result.row);
                            alert(result.msg);
                        }
                        return [result.success,result.msg];
                    } catch(er){
                        return [false,'Server dice: '+er+'\r\n='+response.responseText.replace(/(\r\n|\n|\r)/gm,'')+'='];
                    }
                }
                ,beforeShowForm:function(form){reformatForm(form, "tr");}
             }
            ,{/* add form bottom navigation */}
            ,{/* del  bottom navigation */}
            ,{/* search  bottom navigation */
                closeOnEscape:true,modal:true,overlay:0,multipleSearch:true,multipleGroup:true,recreateFilter:true,top:200,left:100}
            ,{/* view form */
                closeOnEscape:true,dataheight:'auto',beforeShowForm:function(form){reformatForm(form, "trv");}
            }
        )

        .jqGrid('navButtonAdd','#listPager',{caption:'Excel',title:'Exportar a Excel', buttonicon:'ui-icon-calculator',
            onClickButton: function(){ arrIgnore = []; arrIgnore.push('pwd','Actions'); exportReport('list', arrIgnore, 'XLS', 'errors_detected.xls', 'Errors detected');}})

        .on("jqGridInlineAfterSaveRow", function(a, ev, e, r){
            var row = JSON.parse(e.responseText).row;
            $(this).jqGrid('setRowData', row.icac_error_id, row);
        });


        jqGridRowResizer.addNavigatorButtons($gridx);

    gridhandler.jqGrid('bindKeys');

});
</script>

<script>
history.replaceState({content: document.title}, document.title, document.location.href); // prevent refresh/back with post
</script>

<details class="default"><summary>SQL Queries</summary><div>
<pre class="code">
            'Bugs por Tipo' => "
                SELECT /*$method*/ CONCAT( YEAR(last_seen), '-', LPAD(MONTH(last_seen), 2, '0' )) as Mes, status, error_type, COUNT(*) as Num,
                    SUM(seen_times) as seen_times, MIN(first_seen) as first_seen, MAX(last_seen) as last_seen
                FROM icac_error
                WHERE last_seen >= '$since' AND status = 'Bug'
                GROUP BY 1, 2, 3
                ORDER BY 1 DESC, 2, 3
                ",

        'Bugs Vivos por Archivo' => "
            SELECT /*$method*/
                CONCAT( YEAR(last_seen), '-',LPAD(MONTH(last_seen), 2, '0' ) ) as Mes,  file, status, error_type, COUNT(*) as Num,
                SUM(seen_times) as seen_times, MIN(first_seen) as first_seen, MAX(last_seen) as last_seen
            FROM icac_error
            WHERE last_seen >= '$since' AND status = 'Bug'
            GROUP BY file, status, error_type
            ORDER BY 1 DESC, status, COUNT(*) DESC, file, error_type
            ",

        'Arreglados por Tipo' =>"
            SELECT /*$method*/ CONCAT( YEAR(last_seen), '-', LPAD(MONTH(last_seen), 2, '0' )) as Mes, status, error_type, COUNT(*) as Num,
                SUM(seen_times) as seen_times, MIN(first_seen) as first_seen
            FROM icac_error
            WHERE last_seen >= '$since' AND status = 'Fixed'
            GROUP BY 1, 2, 3
            ORDER BY 1 DESC, 2, 3
            ",

        'Arreglados por Archivo' => "
        SELECT /*$method*/
            CONCAT( YEAR(last_seen), '-',LPAD(MONTH(last_seen), 2, '0' ) ) as Mes,  file, status, error_type, COUNT(*) as Num,
            SUM(seen_times) as seen_times, MIN(first_seen) as first_seen, MAX(last_seen) as last_seen
        FROM icac_error
        WHERE last_seen >= '$since' AND status = 'Fixed'
        GROUP BY file, status, error_type
        ORDER BY 1 DESC, status, COUNT(*) DESC, file, error_type
        ",
</pre>
</div></details>

<?php include('footer.php'); ?>
<script>
    var busqueda_desde_iacase=true;
    jQuery(function($){
        // $('#loadingMask').fadeOut(0);
        $vitex_globales["busqueda_rapida_automatica"] = true;
        $vitex_globales["permiso_busqueda"]=true;

        br= new BusquedaRapida(gridhandler.jqGrid('getGridParam').colModel, true);
        br.init();
    });
</script>
</body>
</html>
