<?php
/** @noinspection PhpRedundantOptionalArgumentInspection */
/** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection HtmlUnknownAnchorTarget */
/** @noinspection HtmlFormInputWithoutLabel */
/** @noinspection CssUnusedSymbol */
/** @noinspection CssUnknownTarget */
/** @noinspection ES6ConvertVarToLetConst */

// =======================================================
// INDEX.PHP — QUANTIX ENTRY POINT
// =======================================================
// This file is intentionally layered.
// Do NOT refactor blindly.
// =======================================================

require_once('../inc/config.php');
//require_once('brain.php');
global $gIaHeader, $verJS, $gProgramName, $gSqlClass, $gIAParametros,$toolBarColor,
       $gPermisadorClick, $gPermisoClick,
       $gActivaModuloBodegas, $gPermisosbodega,$bodega_tab_color, $gIconoSoloTipoRony;

leeParametrosVitex();

?><!DOCTYPE html><html lang="es-MX">
<head>
<meta charset="UTF-8" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
<meta http-equiv="content-type" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />
<title><?php echo $gProgramName; ?>: Menú principal de QuantiX.</title>
<?php
$gIaHeader->html_head_add( ['jqgrid', 'auotNumeric','ia','fckeditor']);
$gIaHeader->html_head_echo();
?>
<link rel="stylesheet" type="text/css" href="../js2/password-strength-meter/dist/password.min.css?<?php echo $verJS;?>"/>
<script src="../js2/password-strength-meter/dist/password.min.js?<?php echo $verJS;?>"></script>

<script>
    var _user_id = <?=$_SESSION['usuario_id']?>;

    var _app = 'index';

    jQuery(function($){
        let indexTabs = $("#indexTabs");
        indexTabs.show().tabs();
    });
</script>
    <?php
//    inicializa_catalogos_globales();
    //Redirección para quitar el POST.
    if(!empty($_POST))
    {
        echo <<<REDIRECTA
        <script>
        window.location = "index.php";
        </script>
REDIRECTA;
        die();
    }
    ?>
</head>
<body>
<div id="loadingMask" style="width: 100%; height: 100%; position: fixed; background: transparent !important; z-index: 9999;"></div>
<div id="qx-topbar">
<?php

// =======================================================
// LEGACY TOPBAR (FROZEN)
// -------------------------------------------------------
// Contains:
// - Welcome message
// - Home shortcut
// - Theme toggle
// - Change Password trigger
// - Logout
//
// ⚠️ DO NOT MODIFY BEHAVIOR
// ⚠️ DO NOT REMOVE INLINE JS
// ⚠️ ONLY CSS MAY BE ADDED LATER
// =======================================================


echo "<div class='flexRow' style='justify-content:space-between;'>
    <div class='flexItem flexItemBodega'>
        <table class='iactoolbar' style='margin-bottom:12px; background:$toolBarColor' id='iactoolbartable' >
            <tr>\r\n<td>Bienvenido <b>".ucfirst( $_SESSION['usuario'] )."</b><br>
                    <a href='../backoffice/index.php' target='_blank' id='iaHome' class='toolbar_iahome tooltip_toolbar_wohtml' title='Abrir $gProgramName en otra pestaña'><img src='../img/icons/Home.png' alt='Home' /><br/><strong>$gProgramName Inicio</strong></a>
<td></table></div><div class='flexItem flexItemBodega menusIndex'>
        <a href='JavaScript:;' onclick='cambiarPwd(true, \"Cambiar mi Password\")' title='Cambiar Password' id='menuChangePws'>Cambiar Psw</a>
        <a href='index.php?dologout=1' title='Salir del sistema' id='menuSalir'>Salir</a>
        <button id='qx-theme-toggle' aria-label='Toggle dark mode'>🌙</button>
    </div>
    
</div>";
// LEGACY TOPBAR (FROZEN)
// =======================================================


// =======================================================
// QUANTIX DASHBOARD (SAFE TO EVOLVE)
// -------------------------------------------------------
// This is the modern UI surface.
// - Vanilla JS
// - Scoped CSS
// - No dependency on legacy toolbars
//
// ✅ SAFE TO MODIFY
// ✅ SAFE TO REPLACE
// =======================================================

?>
</div>
<div id="qx-dashboard">
<div id="quantix-2025" class="qx-header">

    <header >
        <h1>QuantiX</h1>
        <p class="qx-sub">Systems. Not menus.</p>
    </header>

    <main class="qx-grid">

        <!-- BINTECH -->
        <section class="qx-card blue" data-open>
            <div class="qx-card-head">
                <span class="qx-dot"></span>
                <h2>Bintech Robot UP</h2>
            </div>
            <div class="qx-card-body">
                <a href="alumnos_becados.php">Alumnos Becados</a>
                <a href="helper/merge_alumnos_becados.php" style="background:#27ae60;color:white;font-weight:bold;">Merge Alumnos Becados</a>
            </div>
        </section>

        <!-- MRW -->
        <section class="qx-card orange">
            <div class="qx-card-head">
                <span class="qx-dot"></span>
                <h2>MrW · Reporte Propietarios</h2>
            </div>
            <div class="qx-card-body">
                <a href="propietario.php">Propietarios</a>
                <a href="propiedad.php">Propiedades</a>
                <a href="helper/expand_propiedades_info.php" style="background:#9b59b6;color:white;font-weight:bold;">🏢 Property Expansion Report</a>
                <a href="helper/fill_postal_codes.php" style="background:#27ae60;color:white;font-weight:bold;">📮 Fill Postal Codes</a>
                <a href="helper/link_propiedades_propietarios.php" style="background:#3498db;color:white;font-weight:bold;">🔗 Link Propiedades ↔ Propietarios</a>
                <a href="helper/link_propiedades_pms.php" style="background:#3498db;color:white;font-weight:bold;">🔗 Link Propiedades ↔ PMS (Preview)</a>
                <a href="helper/link_pms_propiedades.php" style="background:#e74c3c;color:white;font-weight:bold;">🔄 Link PMS → Propiedades (Production)</a>
                <a href="airbnb_transaction.php">Airbnb Transactions</a>
                <a href="agoda_transaction.php">Agoda Transactions</a>
                <a href="booking_transaction.php">Booking Transactions</a>
                <a href="casitamx_transaction.php">CasitaMX Transactions</a>
                <a href="hostify_reserva.php">Hostify Reservations</a>
                <a href="cloudbeds_reserva.php">Cloudbeds Reservations</a>
            </div>
        </section>

        <!-- ARI BEN -->
        <section class="qx-card purple">
            <div class="qx-card-head">
                <span class="qx-dot"></span>
                <h2>Ari Ben</h2>
            </div>
            <div class="qx-card-body">
                <a href="eleyeme_cfdi_emitidos.php">Eleyeme CFDI Emitidos</a>
                <a href="empresa.php">Empresas Registradas</a>
                <a href="banco_cuenta.php">Cuentas Bancarias Registradas</a>
                <a href="../cobranza/edocta.php">Movimientos Bancarios</a>
                <a href="../cobranza/file2edoctaall.php">Importar Estados de Cuenta</a>
            </div>
        </section>

    </main>

</div>
</div>


<style>
    #quantix-2025 {
        max-width: 1100px;
        min-height: 300px;
        margin: 40px auto;
        font-family: Inter, system-ui, sans-serif;
        color: #0f172a;
        border-radius: 10px;
        padding-left: 15px;
        padding-right: 15px;
        padding-bottom: 25px;
        border: 1px solid rgba(142, 183, 255, 0.6);
    }

    .qx-header {
        margin-bottom: 40px;
        margin-left: 0.5em;
        text-align: center;
        position: relative;
        background-image: url('../img/quantix_logo_v2.png');
        background-repeat: no-repeat;
        background-position: center top;
        background-size: 600px auto;
        transition: filter 0.3s ease;
        filter: drop-shadow(0 4px 12px rgba(59, 130, 246, 0.15));
    }

    .qx-header:hover {
        filter: drop-shadow(0 6px 18px rgba(59, 130, 246, 0.25));
    }

    .qx-header h1 {
        font-size: 36px;
        margin: 0;
    }
    .qx-sub {
        color: #64748b;
        margin-top: 4px;
        margin-left: 0;
    }

    .qx-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
    }

    .qx-card {
        border-radius: 14px;
        padding: 20px;
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.96), rgba(188, 201, 222, 0.96));
        border: 1px solid #8EB7FFFF;
        transition: transform .25s ease, box-shadow .25s ease;
        box-shadow: 0 8px 30px rgba(142, 183, 255, 0.6);
    }

    .qx-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 30px rgba(142, 183, 255, 0.2);
    }

    .qx-card-head {
        display: flex;
        align-items: center;
        gap: 10px;
        cursor: pointer;
    }

    .qx-card h2 {
        font-size: 18px;
        margin: 0;
    }

    .qx-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
    }

    .qx-card-body {
        margin-top: 16px;
        display: none;
        flex-direction: column;
        gap: 10px;
    }

    .qx-card.open .qx-card-body {
        display: flex;
    }

    .qx-card-body a {
        padding: 10px 14px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 500;
        color: white;
        transition: opacity .15s ease, transform .15s ease;
    }
    .qx-card-body a:hover {
        opacity: .9;
        transform: translateX(4px);
    }

    /* COLORS */
    .blue   .qx-dot, .blue   a { background: #3b82f6; }
    .orange .qx-dot, .orange a { background: #f59e0b; }
    .purple .qx-dot, .purple a { background: #8b5cf6; }

    /* RESPONSIVE LOGO */
    @media (max-width: 640px) {
        .qx-header {
            background-size: 400px auto;
            padding-top: 280px; /* 400px width = ~267px height + margin */
        }
    }

    @media (max-width: 480px) {
        .qx-header {
            background-size: 300px auto;
            padding-top: 220px; /* 300px width = 200px height + margin */
        }
    }
</style>
<style>
    /* ===================== */
    /* QUANTIX DARK MODE     */
    /* ===================== */

    #quantix-2025.dark {
        background: transparent;
        color: #e5e7eb;
        border: 1px solid rgba(61, 63, 66, 0.6);
    }

    #quantix-2025.dark .qx-header h1 {
        color: #f8fafc;
    }

    #quantix-2025.dark .qx-sub {
        color: #9ca3af;
    }

    #quantix-2025.dark .qx-header {
        filter: drop-shadow(0 6px 20px rgba(59, 130, 246, 0.4));
        opacity: 0.92;
    }

    #quantix-2025.dark .qx-header:hover {
        opacity: 1;
        filter: drop-shadow(0 8px 24px rgba(59, 130, 246, 0.6));
    }

    /* Cards */
    #quantix-2025.dark .qx-card {
        background: linear-gradient(180deg, rgba(0, 54, 141, 0.96), rgba(70, 82, 98, 0.96));
        border: 1px solid rgb(0, 0, 0);
        box-shadow: 0 8px 30px rgba(82, 82, 82, 0.6);
    }

    #quantix-2025.dark .qx-card:hover {
        box-shadow: 0 14px 40px rgba(73, 68, 68, 0.2);
    }

    /* Head */
    #quantix-2025.dark .qx-card-head h2 {
        color: #e5e7eb;
    }

    /* Actions */
    #quantix-2025.dark .qx-card-body a {
        background: rgba(255,255,255,0.06);
        color: #f9fafb;
        backdrop-filter: blur(6px);
    }

    /* Project colors (subtle glow, not neon) */
    #quantix-2025.dark .blue a   { background: rgba(59,130,246,0.22); }
    #quantix-2025.dark .orange a { background: rgba(245,158,11,0.22); }
    #quantix-2025.dark .purple a { background: rgba(139,92,246,0.22); }

    #quantix-2025.dark .qx-dot.blue   { background: #3b82f6; }
    #quantix-2025.dark .qx-dot.orange { background: #f59e0b; }
    #quantix-2025.dark .qx-dot.purple { background: #8b5cf6; }

    /* Hover micro-lift */
    #quantix-2025.dark .qx-card-body a:hover {
        background: rgba(255,255,255,0.12);
        transform: translateX(6px);
    }

    /* Smooth everything */
    #quantix-2025,
    #quantix-2025 * {
        transition:
                background-color 180ms ease,
                color 180ms ease,
                box-shadow 180ms ease,
                transform 160ms ease,
                opacity 120ms ease;
    }
</style>
<style>
    #qx-theme-toggle {
        position: fixed;
        border: 1px solid rgba(0, 0, 0, 0.08) !important;
        background: linear-gradient(180deg, rgb(97 97 97 / 85%), rgba(245, 247, 250, 0.85)) !important;
        border-radius: 10px;
        padding: 8px 12px;
        cursor: pointer;
        font-size: 14px;
        backdrop-filter: blur(6px);
        right: 15px !important;
        top: 0px !important;
    }

    #quantix-2025.dark + #qx-theme-toggle,
    #quantix-2025.dark #qx-theme-toggle {
        background: linear-gradient(180deg, rgb(97 97 97 / 85%), rgba(245, 247, 250, 0.85)) !important;
    }
</style>

<style>
    /* ===============================
       QUANTIX CANVAS NORMALIZATION
       =============================== */

    body {
        background: #f8fafc;
    }

    #quantix-2025.dark body,
    #quantix-2025.dark {
        background: #0b0f14;
    }
</style>

<style>
    /* ===============================
       TOPBAR VISUAL ALIGNMENT
       =============================== */

    #qx-topbar {
        padding: 14px 18px;
        margin-bottom: 28px;
        border-bottom: 1px solid rgba(0,0,0,0.06);
    }

    /* Dark mode */
    #quantix-2025.dark #qx-topbar {
        border-bottom: 1px solid rgba(255,255,255,0.08);
    }
</style>
<style>
    /* ===============================
       DASHBOARD SPACING & FLOW
       =============================== */

    #qx-dashboard {
        padding: 0 18px 40px;
    }

    /* Title clarity */
    #qx-dashboard h1 {
        margin-top: 0;
    }
</style>
<style>
    /* ===============================
       DARK MODE LEGACY AWARENESS
       =============================== */

    #quantix-2025.dark a,
    #quantix-2025.dark span,
    #quantix-2025.dark td {
        color: #e5e7eb;
    }

    #quantix-2025.dark .iactoolbar {
        background: transparent;
    }

    #quantix-2025.dark #menuChangePws,
    #quantix-2025.dark #menuSalir {
        color: #cbd5f5;
    }

    /* ==========================================
   QUANTIX TOPBAR — UNDENIABLE EDITION
   ========================================== */

    #qx-topbar .iactoolbar {
        /* Neutralize legacy gradient */
        background: linear-gradient(180deg, rgb(97 97 97 / 85%), rgba(245, 247, 250, 0.85)) !important;

        border-radius: 14px;
        border: 1px solid rgba(0,0,0,0.06);
        box-shadow:
                0 8px 24px rgba(0,0,0,0.08),
                inset 0 1px 0 rgba(255,255,255,0.6);

        padding: 12px 16px;
        backdrop-filter: blur(10px);
        transition: box-shadow 180ms ease, background 180ms ease;
    }

    /* Typography cleanup */
    #qx-topbar .iactoolbar td {
        font-weight: 500;
        color: #0f172a;
    }

    /* Welcome text */
    #qx-topbar .iactoolbar b {
        font-weight: 700;
    }

    /* Home link */
    #qx-topbar #iaHome {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        margin-top: 6px;
        text-decoration: none;
        color: #2563eb;
    }

    #qx-topbar #iaHome strong {
        font-weight: 600;
    }

    /* Theme toggle button */
    #qx-topbar #qx-theme-toggle {
        margin-left: 12px;
        border: none;
        background: rgba(0,0,0,0.04);
        border-radius: 10px;
        padding: 6px 10px;
        cursor: pointer;
        font-size: 14px;
        transition: background 120ms ease, transform 120ms ease;
    }

    #qx-topbar #qx-theme-toggle:hover {
        background: rgba(0,0,0,0.08);
        transform: translateY(-1px);
    }

    /* ==========================================
       DARK MODE VARIANT
       ========================================== */

    #quantix-2025.dark #qx-topbar .iactoolbar {
        background: linear-gradient(
                180deg,
                rgba(17,24,39,0.92),
                rgba(11,15,20,0.92)
        ) !important;

        border: 1px solid rgba(255,255,255,0.08);
        box-shadow:
                0 12px 36px rgba(0,0,0,0.8),
                inset 0 1px 0 rgba(255,255,255,0.05);
    }

    #quantix-2025.dark #qx-topbar .iactoolbar td {
        color: #e5e7eb;
    }

    #quantix-2025.dark #qx-topbar #iaHome {
        color: #93c5fd;
    }

    #quantix-2025.dark #qx-topbar #qx-theme-toggle {
        background: rgba(255,255,255,0.08);
    }

    #quantix-2025.dark #qx-topbar #qx-theme-toggle:hover {
        background: rgba(255,255,255,0.14);
    }

</style>


<!-- ================= DASHBOARD SCRIPTS ================= -->
<script>
    // dashboard JS
    (function(){
        const cards = document.querySelectorAll('#quantix-2025 .qx-card');

        cards.forEach((card, index) => {
            const head = card.querySelector('.qx-card-head');
            head.addEventListener('click', () => {
                const open = card.classList.contains('open');
                cards.forEach(c => c.classList.remove('open'));
                if (!open) {
                    card.classList.add('open');
                    // Remember which card is open
                    localStorage.setItem('quantix-open-card', index);
                } else {
                    // Clear if closing the card
                    localStorage.removeItem('quantix-open-card');
                }
            });
        });

        // Restore previously open card, or open default
        const savedCardIndex = localStorage.getItem('quantix-open-card');
        if (savedCardIndex !== null && cards[savedCardIndex]) {
            cards[savedCardIndex].classList.add('open');
        } else {
            document.querySelector('#quantix-2025 .qx-card[data-open]')?.classList.add('open');
        }
    })();

    (function () {
        const root = document.getElementById('quantix-2025');
        const toggle = document.getElementById('qx-theme-toggle');

        const saved = localStorage.getItem('quantix-theme');
        if (saved === 'dark') root.classList.add('dark');

        toggle.addEventListener('click', () => {
            root.classList.toggle('dark');
            const mode = root.classList.contains('dark') ? 'dark' : 'light';
            localStorage.setItem('quantix-theme', mode);
        });
    })();
</script>

<?php

// QUANTIX DASHBOARD (SAFE TO EVOLVE)
// =======================================================


// =======================================================
// LEGACY MODALS / UTILITIES (FROZEN)
// -------------------------------------------------------
// Contains jQuery UI dialogs:
// - Change Password (#cambiaPwd)
//
// ⚠️ DO NOT MOVE OUTSIDE THIS CONTAINER
// ⚠️ DO NOT RENAME IDS
// =======================================================

?>
<div id="qx-modals">
<div id="cambiaPwd" style="display:none;">
<fieldset><legend>Cambiar mi password</legend>
<div class="flexRow">
    <div class="flexItem">
        <label for="pwdActual">Mi password actual: </label><input type="password" value="" required id="pwdActual" data-class='dontUpperCase'>
    </div>
    <div class="flexItem">
        <label for="pwdNuevo">Nuevo password: </label><input type="password" value="" required id="pwdNuevo" data-class='dontUpperCase' pattern=".{8,}" />
    </div>
    <div class="flexItem">
        <label for="pwdNuevo2">Otra vez: </label><input type="password" value="" required id="pwdNuevo2" data-class='dontUpperCase' pattern=".{8,}" />
        <img alt="pwd" src="../img/20-preview.png" style="cursor:pointer" onclick="showHidePwds();" />
    </div>
</div>
</fieldset>
</div>
</div>
<!-- ================= LEGACY SCRIPTS ================= -->
<script>
    // cambiarPwd, legacy helpers
    function showHidePwds() {
        var pwdActual=$("#pwdActual"), cual = pwdActual.attr('type') === 'text' ? 'password' : 'text';
        pwdActual.attr('type', cual);
        $("#pwdNuevo").attr('type', cual);
        $("#pwdNuevo2").attr('type', cual);
    }
    function cambiarPwd(esOpcional, title) {
        var options = esOpcional ?
            {
                title:title,
                closeText: "No cambiarlo",
                buttons:{"No cambiarlo":function() { $( this ).dialog( "close" ); }},
                classes: {"ui-dialog": "ui-corner-all","ui-dialog-titlebar": "ui-corner-all"}
            }
            :
            {
                title:title,
                classes: {"ui-dialog": "ui-corner-all","ui-dialog-titlebar": "ui-corner-all dialogNoClose"}
            };

        return $("#cambiaPwd").dialog($.extend(true, {
                modal:true,
                width:790,
                open: function() { $('#pwdActual').focus(); },
                closeOnEscape: esOpcional,
                buttons:{
                    "Cambiar":function(ev) {
                        cambiaPwd(this, ev.currentTarget);
                    }
                }
            }, options)
        );
    }
    function cambiaPwd(dlg, e) {
        $(e).button( "option", "disabled", true );
        var pwdActual=$("#pwdActual").val().trim(), pwdNuevo = $("#pwdNuevo").val().trim(), pwdNuevo2 = $("#pwdNuevo2").val().trim();
        if(pwdActual==='') {
            avisaError("Su password actual es un dato requerido!", "pwdActual");
            enableButton();
            return false;
        }
        if(pwdNuevo==='') {
            ia.alertError("Su nuevo password un dato requerido");
            enableButton();
            return false;
        }

        if(pwdNuevo.length < 8) {
            ia.alertError("Su nuevo password debe tener al menos 8 carácteres");
            enableButton();
            return false;
        }
        if(pwdNuevo2==='') {
            ia.alertError("Escribir otra ves el nuevo password es requerido");
            enableButton();
            return false;
        }
        if(pwdNuevo2!==pwdNuevo) {
            ia.alertError("La confirmación del password nuevo no coinicde");
            enableButton();
            return false;
        }
        if(pwdNuevo===pwdActual) {
            ia.alertError("El password nuevo debe ser diferente al actual");
            enableButton();
            return false;
        }

        $.ajax({
            url:'ajax/usuario_cambia_password.php',
            method:'POST',
            data:{pwdActual:pwdActual,pwdNuevo:pwdNuevo,pwdNuevo2:pwdNuevo2},
            cache:false,
            dataType:'json',
        })
            .done(function(data) {
                if(data.ok) {
                    $( dlg ).dialog( "close" );
                    ia.alertInfo('¡Password cambiado!');
                    $("#pwdActual").val('');
                    $("#pwdNuevo").val('');
                    $("#pwdNuevo2").val('');
                } else {
                    if(typeof data.msg !== 'undefined')
                        ia.alertError(data.msg);
                    else
                        ia.alertError("Error inesperado, intente mas tarde");
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError("Error inesperado, intente mas tarde");
                console.log('cambiaPwd Error: ', errorThrown);
            })
            .always(function() {
                enableButton();
            });

        function avisaError(message, focusId) {
            let promise = ia.alertError(message);
            promise.always(function(){console.log("set focus", focusId); $("#" + focusId).focus(); });
        }
        function enableButton() {
            $(e).button( "option", "disabled", false );
        }
    }

    jQuery(function($){
        $("#pwdNuevo").on('change',function(){
            if($(this).val().length >= 8) {
                this.setCustomValidity('');
            } else {
                this.setCustomValidity('Al menos 8 caracteres');
            }
        });
        $('#pwdNuevo').password({
            shortPass: 'Muy corto, al menos 8 caracteres',
            badPass: 'Debil: Intenta letras y números',
            goodPass: 'Mediano; Intenta signos de puntación',
            strongPass: 'Strong password',
            containsField: 'The password contains your username',
            enterPass: 'Nuevo password',
            showPercent: false,
            showText: true,
            animate: true,
            animateSpeed: 'fast',
            field: false,
            fieldPartialMatch: true,
            minimumLength: 8
        });
        <?php
        $forzaPrimeraVez = $_SESSION['ultimo_cambio_password'] <= '2020-08-13 13';
        if($forzaPrimeraVez || ($_SESSION['ultimo_cambio_password'] <= Date('Y-m-d', strtotime("$gIAParametros[password_forza_cambiar_dias] days ago")))
            || (isset($_SESSION['forza_cambio_password']) && $_SESSION['forza_cambio_password'] === 'Si')
        ) {
            $desde = $gIAParametros['password_forza_cambiar_dias'] > 5 ? $gIAParametros['password_forza_cambiar_dias'] - 4 : $gIAParametros['password_forza_cambiar_dias'];
            if (
                $_SESSION['ultimo_cambio_password'] <= Date('Y-m-d', strtotime("$desde days ago"))) {
                echo "cambiarPwd(false, 'Ya es obligatorio cambiar tu contraseña ¡Ahorita!');";
            } else {
                echo "cambiarPwd(true, 'Toca cambiar tu contraseña');";
            }
        }
        ?>

    });

</script>
<div id="IA_ERROR" style="display:none;"></div>
<div id="IA_INFO" style="display:none;"></div>
<script>
    if(!divIDError) var divIDError = 'IA_ERROR';
    if(!divIDInfo)  var divIDInfo = 'IA_INFO';
    vx_asyncFunction(function(){
        _app = 'index';
    }, 500, this);

</script>
<style> .ui-widget-content a{ text-shadow: none;}</style>
<p class="default" id="pageInfo" style="margin:0.3em 2em;display:none;"><div>
<?php
include('footer.php');
// LEGACY MODALS / UTILITIES (FROZEN)
// =======================================================
?>
</div></p>

</body>
</html>