<?php

namespace vitex\warmup;

// si da muchos errores: "already loaded" comentar include(../inc/config.php) pues realpath() no estaría jalando
require_once('../inc/config.php');
ignore_user_abort(false);

// guarda los settings que puso config.php
$ini['error_reporting'] = error_reporting(E_ALL );
$ini['display_errors'] = ini_set('display_errors',"1");
$ini['html_errors'] = ini_set('html_errors',"1");
$ini["date.timezone"] = ini_set("date.timezone", "America/Mexico_City");

require_once('../inc/warmUp.php');

llenaOpCache();
function llenaOpCache() {

    $ignore_user_abort = ignore_user_abort(true);
    $set_time_limit = set_time_limit(60*8);
    $warmUp = new WarmUp();
    //$warmUp->check_opcache();
    $warmUp->fill_opcache(SCANDIR_SORT_ASCENDING, null, true);
    echo $warmUp->lint_summary();
    ignore_user_abort($ignore_user_abort);
    set_time_limit($set_time_limit);
}

echo phpIniAdvice($ini, file_exists( '../../showErrors.vin'));

function phpIniAdvice(array $ini, bool $developmentMode) {

    $response = [];
    $shouldBeOff = [
        'auto_append_file',
        'auto_prepend_file',
        'allow_url_include',
        // 'allow_url_fopen',
        // 'enable_dl',
        'expose_php',
       // ver abajo 'display_errors',

        'implicit_flush',

        'mysqli.reconnect',
        'mysqlnd.collect_statistics',

        'session.auto_start',
        'session.use_trans_sid',

    ];

    $shouldBeOn = [
        'auto_globals_jit',
        'enable_post_data_reading',
        'file_uploads',

        'engine',
        'ignore_repeated_errors',
        'log_errors',
        'report_memleaks',

        //  'cgi.force_redirect',

        'opcache.enable',
        'opcache.enable_cli',
        'opcache.use_cwd',
        'opcache.revalidate_path',
        'opcache.save_comments',

        'session.use_cookies',
        'session.use_only_cookies',

    ];

    if($developmentMode && empty($ini['display_errors'])) {
        $response[] = '<i>display_errors:</i> recommended On';
    } elseif(!$developmentMode && !empty($ini['display_errors'])) {
        $response[] = '<i>display_errors:</i> recommended Off';
    }

    foreach($shouldBeOff as $iniSetting) {
        if(!empty(ini_get($iniSetting)))
            $response[] = "<i>$iniSetting:</i> recommended Off";
    }
    foreach($shouldBeOn as $iniSetting) {
        if(empty(ini_get($iniSetting)))
            $response[] = "<i>$iniSetting:</i> recommended On";
    }
    $error_reporting = $ini['error_reporting'];
    if($developmentMode && $error_reporting != E_ALL)
        $response[] = "<i>error_reporting:</i> recommended E_ALL";
    elseif($error_reporting === 0 || $error_reporting === '0')
        $response[] = "<i>error_reporting:</i> recommended E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED (prod)";
    if(empty(ini_get('error_log')))
        $response[] = "<i>error_log:</i> recommended set a full file path";

    $shouldBeValue = [
        'arg_separator.input' => '&',
        'default_charset' => "UTF-8",
    ];
    foreach($shouldBeValue as $iniSetting => $value)
        if(strcasecmp(ini_get($iniSetting), $value))
            $response[] = "<i>$iniSetting:</i> expecting '" .  htmlentities($value) .
                "' found: '" .
                htmlentities(ini_get($iniSetting)) ."'";


    if(empty($response))
        return '';
    return "<div>Check php.ini settings<ol class='compact'><li>" .
        implode('<li>', $response) .
        "</ol></div>";
}

if(!empty($_ENV)) // debe ser despues de leerlas con getenv('x',...)
    echo "<pre>Environment variables available to script: " . print_r($_ENV, true) . "</pre>";
