<?php
 /*
  * 1.- En el archivo deseado incluir este.
  * 2.- Poner onclick="containerCalc.dialog(this)" para la calculadora o onclick="containerProductInput.dialog()" para la tablita
  *
  */
    $containerCapacityEdit = usuarioTipoRony() || Permisador::puede('producto_cantidad_por_container') === 'R/W';
    $containerEditTrueFalse = $containerCapacityEdit ? "true" : "false";
    // if(usuarioTipoRony)  ProductoCostsBodega->costsActuales en un ajax cuando abren el container calc
?>
<script src="../js2/autoNumeric-next.js"></script>
<script type="text/javascript" src="../js2/pdfmake.min.js"></script>
<script type="text/javascript" src="../js2/vfs_fonts.min.js"></script>
<!--suppress CssUnusedSymbol -->
<style>
    .calcCIF {margin:0 1em;padding:0;text-align:right;}
    .calcCIFT {margin:0 1em;padding:0;text-align:right;}
    .boxPlot1Container {margin:0.3em;padding:0.3em; min-width: 8em; width:fit-content;}
    .boxPlot1Plot      {margin:0 1em 0 1em;padding:0; border:3px silver outset;height:1.5em }
    .boxPlot1Legend    {margin:0;padding:0; font-size:0.7em;
        font-family: "SFMono-Regular",  lato, sans-serif;
        display:flex;flex-direction:row;flex-wrap:nowrap;gap:0.5em; justify-content:space-between;
    }
    .boxPlot1Legend p {text-align: center;margin:0;padding:0;font-size:0.9em;color:black}
    @media print {
        .noprint {display:none}
        .noPrint {display:none}
        .printOnly {display:initial}
        .printonly {display:initial}
        .copyClipBloard {display:none}
        .jqgrid_actions {display:none}
        .iactoolbar {display:none}
        BODY {background-color: transparent!important;}
        DIV {background-color: transparent!important;}
        .content_add_producto {background-color: transparent!important;}
        .content_add_productos_color {background-color: transparent!important;}
        DIV {background-color: transparent!important;}
        TABLE, FIGURE {
            page-break-inside: avoid;
        }
        INPUT {
            border:none!important;
            background-color: inherit;
            color:inherit;
        }
        SELECT {
            appearance: none;
            border:none;
            background-color: transparent;
            color:inherit;
        }
        BUTTON {display:none}
    }
    .containerCalcTecla {font-weight: 100;font-size:0.8em;padding-bottom: 0;margin-bottom: 0.3em}
    .containerCalcCenter {vertical-align:bottom;}
    TABLE.contCalc {border-collapse: collapse;border:1px silver solid}
    TABLE.contCalc > THEAD > TR > TH {border-collapse: collapse;border:1px silver solid;vertical-align: center;padding:0.3em;
        font-weight: bold;text-align: center;}
    TABLE.contCalc > TBODY > TR > TD {border-collapse: collapse;border:1px silver solid;vertical-align: middle;padding:0.3em}
    .calcClear {}
    .calcContainerBelow {color:red}
    .calcContainerAbove {}
    .calcContainerError {}
    .calcContainerUnits {text-align: center}
    .calcContainerQty {width:8em;text-align:right}
    .calcContainerNumContainers {width:5em;text-align:right}
    .calcContainerContainerCapacity {width:8em;text-align:right}
    INPUT[name='container_quantity'] {text-align: right;}
    .divAsInput {padding:0.3em;background-color: lightyellow}
</style>
<?php if(usuarioTipoRony() || Permisador::puede('producto_cantidad_por_container') !== 'Nada') { ?>
<div id="cantCalcDialog" title="Calculadora de Contenedores" style="display: none">
    <fieldset style="width:fit-content"><legend><span id="contCalc_exportToolbar"></span>
            <i style="color:blue;cursor:pointer" title="Grid con Máximo por Container de cada producto"
               onclick="containerProductInput.dialog(this)" class="fa-duotone fa-table noprint"></i>
            <i style="color:blue;cursor:pointer" title="Clear, borrar datos capturados" onclick="containerCalc.clear()" class="fa-duotone fa-broom-wide"></i>
            <?php
                if(usuarioTipoRony() || Permisador::puede_consultar_permisos() !== 'Nada')
                    echo '<span class="pointer" title="Permisos para la calculadora de Containers y editar Capacidad de container por Producto" onclick="permisador._trae({url:\'producto_cantidad_por_container\'})"> <span class="ui-icon ui-icon-key permisador"></span></span>';
                if(usuarioTipoRony())
                    echo "<i data-titulo='Parametros Contenedores'  title='Parametros Contenedores'
                        data-tema='china' data-subtema='containers' 
                        class='fa-regular fa-gear-complex pointer' onclick='iacParam.dialogParams(this)' style='color: blue;'></i>";
            ?>
        </legend>
        <form method="dialog" autocomplete="off"><input type="hidden" value="1" name="_temp" autocomplete="off">
        <table id="contCalc" class="contCalc" >
            <thead><tr><th>Producto</th><th>Units</th><th class="containerCalcCenter">Quantity<p class="containerCalcTecla">Tab</p></th><th># Containers</th>
                <th> Per Container
                    <i style="color:blue;cursor:pointer" title="Grid con Máximo por Container de cada producto"
                       onclick="containerProductInput.dialog(this)" class="fa-duotone fa-table noprint"></i>
                </th>
                <th></th>
                <th class="containerCalcCenter"><button title="Agregar un renglón de artículo" type="button" onclick="containerCalc.add_row()"><i class="fa-duotone fa-file-circle-plus noprint" style="color:green;font-size:1.4em"></i></button>
                    <p class="containerCalcTecla">Enter</p>
                </th></tr></thead>
            <tbody id="calcContTbody" data-uniqueindex="0"></tbody>
            <tfoot>
            <tr>
                <th class="izq" colspan="2" id="calcContTotUnits" style="vertical-align: top"></th>
                <th class="der" id="calcContTotQuantity" style="vertical-align: top"></th>
                <th class="der" style="vertical-align: top"><div style="text-align: center" id="calcContTotContainers"></div></th>
                <th style="vertical-align: top;">
                    <div style='margin:0 0.5em;padding:0;display:flex;flex-direction:row;justify-content:space-around;align-items:center;flex-wrap: nowrap; border:3px lightblue outset;width:130px;height:1.5em;'>
                        <div style='background-color:red;text-align:left;vertical-align:middle;width:100%;height:99%;'>
                            <div id="calBPPercent" style='background-color:green;width:0;height:100%;text-align:right;color:white;font-weight:800;vertical-align: center'>0%</div>
                        </div>
                    </div>
                </th>
                <th><span id="calcContTotContainersOk" style="font-weight:800;color:#FF0000;font-size:1.5em"></span></th>
            </tr>
            </tfoot>
        </table>
        </form>
    </fieldset>
</div>

<!--suppress ES6ConvertVarToLetConst -->
    <script id="containerCalc_script">
    let containerCalc = {
        container_max_kilos: <?php global $gIAParametros; echo $gIAParametros['container_max_kilos']; ?>,
        weight_per_m: {} ,
        canEdit: <?=$containerEditTrueFalse?>,
        canEditStr: "<?=$containerEditTrueFalse?>",
        autoNumId: {},
        productData: {},
        clear: function() {
            $(".calcContainerQty").off("keydown", containerCalc.lastEnterAdd);
            $("#calcContTbody").html("");
            containerCalc.add_row();
        },
        productDataRead: function() {
            $.ajax({
                url: '../backoffice/ajax/producto_general_acciones.php',
                method: 'POST',
                cache: false,
                dataType: 'json',
                data: {accion:'container_quantity_key_value'},
            })
                .done(function(data, textStatus, jqXHR) {
                    if (!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                        return;
                    }
                    containerCalc.productData = data.key_value;
                    containerCalc.weight_per_m = data.weight_per_m;
                    containerCalc.recalc();
                    document.body.style.cursor = '';
                });
        },
        productDataRead2: async function() {
            try {
                const response = await fetch('../backoffice/ajax/producto_general_acciones.php?accion=container_quantity_key_value&t=1', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    cache: 'no-cache'
                });
                const data = await response.json();

                if (!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.error("ajax status wrong: ", data);
                    return;
                }
                if(data.productos_cat)
                    $vitex_globales.g_cat_producto_general = data.productos_cat;
                containerCalc.productData = data.key_value;
                containerCalc.weight_per_m = data.weight_per_m;
                containerCalc.recalc();
                document.body.style.cursor = '';

            } catch (error) {
                console.error("Error en productDataRead2:", error);
                ia.alertError("Error inesperado, intente más tarde.", "Error");
            }
        },

        productDataRead: function() {
            $.ajax({
                url: '../backoffice/ajax/producto_general_acciones.php',
                method: 'POST',
                cache: false,
                dataType: 'json',
                data: {accion:'container_quantity_key_value'},
            })
            .done(function(data, textStatus, jqXHR) {
                if (!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax status wrong: " + this.url, data);
                    return;
                }
                containerCalc.productData = data.key_value;
                containerCalc.weight_per_m = data.weight_per_m;
                containerCalc.recalc();
                document.body.style.cursor = '';
            });
        },
        dialog: function(el) {
           containerCalc.productDataRead2();
            if(typeof el !== 'undefined')
                el.style.cursor = 'wait';
            document.body.style.cursor = 'wait';
            let $cantCalcDialog = $("#cantCalcDialog");
            if($cantCalcDialog.is(":visible")) {
                $("#cantCalcDialog").dialog('close');
                return;
            }
            closeAllDialog();

            $cantCalcDialog.dialog({
                width: 1200,
                height: 630,
                closeOnEscape: true,
                open: async function() {
                    await containerCalc.productDataRead2();
                    if(typeof el !== 'undefined')
                        el.style.cursor = '';
                    if($("#calcContTbody").children().length === 0)
                        containerCalc.add_row();

                }
            });
        },
        dialogNotaContainer: function(el) {
            if(typeof el !== 'undefined')
                el.style.cursor = 'wait';
            document.body.style.cursor = 'wait';
            let $cantCalcDialog = $("#cantCalcDialog");
            if($cantCalcDialog.is(":visible")) {
                $("#cantCalcDialog").dialog('close');
                return;
            }
            closeAllDialog();
            if(typeof nota_bodega === 'undefined' || typeof NOTA_BODEGA_INFO === 'undefined') {
                var contenedor = "";
                var productoGeneralId = $('#producto_general_id').val() || $("#id").val() || "";
            } else {
                var contenedor = $("#numero_contenedor").val() || nota_bodega.numero_contenedor;
                var productoGeneralId = $('#producto_general_id').val() || NOTA_BODEGA_INFO.producto_general_id;
            }

            const tableItems = $('#table-items-list tr')
            var totals = {
                rollos: 0,
                quantity: 0,
                colores: tableItems.length
            };

            // Iterar sobre los elementos 'tr' dentro de la tabla con ID 'table-items-list'
            tableItems.each(function() {
                let rawInfo = $(this).attr('data-item')
                let dataItem = JSON.parse(rawInfo);

                // Sumar los valores de 'rollos' y 'quantity'
                totals.rollos += parseFloat(dataItem.rollos) || 0;
                totals.quantity += parseFloat(dataItem.quantity) || 0;
            });

            $cantCalcDialog.dialog({
                width: 1300,
                height: 600,
                closeOnEscape: true,
                open: async function () {
                    await containerCalc.productDataRead2();
                    containerCalc.productData[productoGeneralId].total_qty = totals.quantity
                    containerCalc.addRowWithInfo(containerCalc.productData[productoGeneralId])
                }
            });
        },
        exportJson: function() {
            let rows = [];
            $("#contCalc").find("TBODY").find("TR").each(function(){
                let td = $(this).children("TD");
                rows.push({
                    'producto_general_id': $("#contCalcProd_" +this.rowIndex).val(),
                    'producto':  $(td[0]).children("SELECT").text(),
                    'units': td[1].innerText,
                    'quantity': $(td[2]).children("INPUT").val().replaceAll(",", ""),
                    'used': td[3].innerText.replaceAll("%", ""),
                    'capacity': td[4].innerText.replaceAll(",", ""),
                });
            });
            return rows;
        },
        exportTable: function() {
            let tr = [];
            let rows = containerCalc.exportJson();
            for(let r of rows) {
                tr.push(`
                    <td>${r[producto]}
                    <td style="text-align:center" class="cen">${r[units]}
                    <td style="text-align:right" class="der">${numFormatter(r[quantity], 2)}
                    <td style="text-align:right" class="der">${numFormatter(r[used], 2)}
                    <td style="text-align:right" class="der">${numFormatter(r[capacity], 2)}
                `);
            }
            return `<table id="contCalcTable" class="contCalc" >
                <thead><tr><th>Producto</th><th>Units</th><th>Quantity</th><th># Containers</th><th>Per Container</th></thead>
                <tbody><tr>${tr.join("<tr>")}</tbody>
                <tfoot></tfoot>
                </table>
            `;

        },
        init: function() {
            $("#contCalc_exportToolbar").html(exporter.toolBar("#contCalc",
                {
                    'pdf_fromjpg': true,
                    'pdf_table': false,
                    'copyClipBloard': true,
                    title:'Calculadora Containers',
                }
            ));
            if(!containerCalc.canEdit) {
                $("#contCalcCapacityEditable").remove();
            }
        },
        clear_row(el) {
            $(".calcContainerQty").off("keydown", containerCalc.lastEnterAdd);
            let $tr = $(el).parents("TR").first();
            if($("#calcContTbody").children("TR").length > 1)
                $tr.remove();
            else {
                let selectProducto = $tr.children().find(".buscador_productos")[0];
                selectProducto.selectize.clear();
                selectProducto.selectize.refreshItems();
                $tr.children().find("INPUT.calcContainerQty").val("");
                $tr.children("TD.calcClear").removeClass("calcContainerBelow calcContainerAbove calcContainerError").html("");
                $tr.children().find("INPUT.calcContainerQty").css({"border-color": ""});
                $tr.children("TD.calcContainerContainerCapacity").css({"border-color": ""});
            }
            $(".calcContainerQty").last().on("keydown", containerCalc.lastEnterAdd);
            containerCalc.calcTable();
        },
        lastEnterAdd: function(ev) {
            if(ev.which === 13) {
                ev.preventDefault();
                containerCalc.add_row();
                try {
                    let currentElement = document.activeElement;
                    let form = currentElement.form;
                    let index = Array.prototype.indexOf.call(form, currentElement);
                    form[(index + 2) % form.length].focus();
                } catch(err) {
                    console.log("taka error tabbing", err)
                }
            }
        },
        addRowWithInfo: function(selectedItem) {
            $(".calcContainerQty").off("keydown", containerCalc.lastEnterAdd);

            if($("#calcContTbody").children("tr").length > 0)
                $("#calcContTbody").empty();

            let $tBody = $("#calcContTbody"),
                numRows = parseInt($tBody.data('uniqueindex')) + 1,
                $trTemplate = `
            <tr id="TRcalcCont_${numRows}" data-uniquerow="${numRows}" class="${selectedItem.producto_general_id || ''}">
                <td>
                    <select class="buscador_productos" style="width:32em!important;" data-placeholder="Seleccione producto "
                        id="contCalcProd_${numRows}" data-init=""></select>
                    <p class="calcCIF" id="calcCIF_${numRows}"></p>
                </td>
                <td class="calcContainerUnits calcClear">${selectedItem.unidad || ''}</td>
                <td>
                    <input class="auto calcContainerQty" autocomplete="off" aria-autocomplete="none" role="presentation"
                           onchange="containerCalc.quantityChange(this)"
                           onkeyup="containerCalc.quantityChange(this)"
                           data-uniquerow="${numRows}" value="${selectedItem.total_qty || ''}" id="contCalcQty_${numRows}" type="text">
                    <p class="calcCIFT" id="calcCIF_T_${numRows}"></p>
                </td>
                <td class="calcContainerNumContainers calcClear"></td>
                <td class="calcContainerContainerCapacity calcClear" data-uniquerow="${numRows}"
                    id="contCalcCapacity_${numRows}" contentEditable="false">${selectedItem.container_quantity || ''}</td>
                <td id="duda_container_capacity_${numRows}">${selectedItem.dudas}</td>
                <td>
                    <i class="fa-duotone fa-eraser noprint" style="color:red;cursor:pointer;font-size:1.4em"
                       title="Borrar" onclick="containerCalc.clear_row(this);"></i>
                </td>
            </tr>`;

            $tBody.data('uniqueindex', numRows).append($trTemplate);
            let $tr = $tBody.children("tr").last();
            containerCalc.autoNumId[`contCalcQty_${numRows}`] = new AutoNumeric(`#contCalcQty_${numRows}`, {
                decimalPlaces: "2",
                maximumValue: "999999.99",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                formulaMode: true,
                modifyValueOnWheel: false,
                modifyValueOnUpDownArrow: false,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            });

            let capacityId = `contCalcCapacity_${numRows}`;
            containerCalc.autoNumId[capacityId] = new AutoNumeric(`#${capacityId}`, {
                decimalPlaces: "2",
                maximumValue: "999999.99",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                formulaMode: true,
                modifyValueOnWheel: false,
                modifyValueOnUpDownArrow: false,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            });

            $(`#${capacityId}`).off('blur', containerCalc.capacityChange).on('blur', containerCalc.capacityChange);

            let $selectProducto = $tr.children().find(".buscador_productos");
            $selectProducto.append($('<option>', {
                value: selectedItem.producto_general_id,
                text: `${selectedItem.producto}`.trim(),
                selected: true
            }));

            let selectProducto = $selectProducto.selectize()[0];
            containerCalc.autoNumId[selectProducto.id] = selectProducto;
            // Destruir y volver a inicializar selectize para el ítem seleccionado
            selectProducto.selectize.destroy();
            $selectProducto.selectize({
                create: false,
                placeholder: $selectProducto.data('placeholder') || 'Seleccione un producto',
                plugins: ["remove_button"],
                delimiter: ",",
                persist: false,
                calcContRow: numRows,
                onChange: function(value) {
                    let $tr = $(`#TRcalcCont_${this.settings.calcContRow}`);
                    if ($tr.length === 0) return;
                    $tr.data('producto', selectedItem);
                    $tr.children("td.calcContainerUnits").html(selectedItem.unidad || '');
                    $tr.children("td.calcContainerUnits").html(selectedItem.unidad || '');
                    containerCalc.autoNumId[`contCalcCapacity_${this.settings.calcContRow}`].set(selectedItem.container_quantity || '');
                    containerCalc.calcRow($tr);
                }
            });
            selectProducto.selectize.setValue(selectedItem.producto_general_id);
            $(".calcContainerQty").last().on("keydown", containerCalc.lastEnterAdd);
            containerCalc.calcRow($(`#TRcalcCont_${numRows}`))
        },


        add_row(producto_general_id) {
            $(".calcContainerQty").off("keydown", containerCalc.lastEnterAdd);
            let $tBody = $("#calcContTbody"),
                numRows = parseInt($tBody.data('uniqueindex')) + 1,
                $trTemplate =
                    `<tr id="TRcalcCont_${numRows}" data-uniquerow=${numRows}><td>
                    <select class="buscador_productos" style="width:24em;" data-placeholder="Seleccione producto ..."
                        id="contCalcProd_${numRows}" data-init=""></select><p class="calcCIF" id="calcCIF_${numRows}"></p>
                <td class="calcContainerUnits calcClear">
                <td><input class="auto calcContainerQty" autocomplete="off" aria-autocomplete="none" role="presentation"
                            onchange="containerCalc.quantityChange(this)"
                            onkeyup="containerCalc.quantityChange(this)"
                         data-uniquerow=${numRows} value=""  id="contCalcQty_${numRows}" type="text" value=""><p class="calcCIFT" id="calcCIF_T_${numRows}"></p>
                <td class="calcContainerNumContainers calcClear">
                <td class="calcContainerContainerCapacity calcClear" data-uniquerow=${numRows}
                    id="contCalcCapacity_${numRows}" contentEditable="false">
                <td class="calcDudaContainerContainerCapacity calcClear" id="duda_container_capacity_${numRows}">
                <td><i class="fa-duotone fa-eraser noprint" style="color:red;cursor:pointer;font-size:1.4em" title="Borrar" onclick="containerCalc.clear_row(this);"></i>`;
            $tBody.data('uniqueindex', numRows).append($trTemplate);
            let $tr = $tBody.children("TR").last();

            containerCalc.autoNumId[`contCalcQty_${numRows}`] = new AutoNumeric(`#contCalcQty_${numRows}` , {
                decimalPlaces: "2",
                maximumValue: "999999.99",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                formulaMode: true,
                modifyValueOnWheel:false,
                modifyValueOnUpDownArrow:false,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            });
            let capacityId = `contCalcCapacity_${numRows}`;
            containerCalc.autoNumId[capacityId] = new AutoNumeric(`#${capacityId}` , {
                decimalPlaces: "2",
                maximumValue: "999999.99",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                formulaMode: true,
                modifyValueOnWheel:false,
                modifyValueOnUpDownArrow:false,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            });
            $(`#${capacityId}`).off('blur', containerCalc.capacityChange).on('blur', containerCalc.capacityChange);
            let $selectProducto = $tr.children().find(".buscador_productos");


            for(let itm in containerCalc.productData)
                if(containerCalc.productData.hasOwnProperty(itm)) {
                    $selectProducto.append($('<option>',{value: itm, text:  containerCalc.productData[itm].producto }));
                }

            let selectProducto = $selectProducto.selectize()[0];
            containerCalc.autoNumId[selectProducto.id] = selectProducto;
            selectProducto.selectize.destroy();
            $selectProducto.selectize({
                create: $selectProducto.data('create') === '',
                placeholder: $selectProducto.data('placeholder') || 'Seleccione un producto',
                plugins: ["remove_button"],
                delimiter: ",",
                persist: false,
                calcContRow: numRows,
                onChange: function(value) {
                    let $tr = $(`#TRcalcCont_${this.settings.calcContRow}`);
                    if($tr.length === 0)
                        return;
                    let producto = containerCalc.productData[value] || {};
                    $tr.data('producto', producto);
                    $tr.children("TD.calcContainerUnits").html(producto.unidad || '');
                    containerCalc.autoNumId[`contCalcCapacity_${this.settings.calcContRow}`].set(producto.container_quantity || '');
                    containerCalc.calcRow($tr);
                }
            });
            selectProducto.selectize.clear();
            selectProducto.selectize.refreshItems();
            $(".calcContainerQty").last().on("keydown", containerCalc.lastEnterAdd);
        },
        quantityChange:function(el) {
            containerCalc.calcRow($(`#TRcalcCont_${el.dataset.uniquerow}`));
        },
        recalc: function() {
            $("#calcContTbody").children("TR").each(function(){
                try {
                    let $this = $(this), numRows = $this.data('uniquerow'), producto = $this.data('producto');
                    if (typeof containerCalc.productData[producto.producto_general_id] !== 'object')
                        return;
                    let container_quantity = containerCalc.productData[producto.producto_general_id].container_quantity;
                    if (!isNaN(container_quantity))
                        containerCalc.autoNumId[`contCalcCapacity_${numRows}`].set(container_quantity);
                    containerCalc.calcRow(this);
                } catch(err) { console.log("ERROR", err);}
            });
        },
        capacityChange:function(event) {
            let value = containerCalc.autoNumId[event.target.id].get();
            let producto_general_id = containerCalc.autoNumId[`contCalcProd_${event.target.dataset.uniquerow}`].selectize.getValue();
            if(typeof containerCalc.productData[producto_general_id] !== 'undefined') {
                containerCalc.productData[producto_general_id].container_quantity = value;
                $.ajax({
                    url: '../backoffice/ajax/producto_general_acciones.php',
                    method: 'POST',
                    cache: false,
                    processData: true, // en true pasa data (object) a ulr_encoded string, en false manda el object
                    dataType: 'json',
                    data: {accion:'container_quantity_set', producto_general_id, value},
                })
                .done(function(data, textStatus, jqXHR) {
                    if(!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                    console.log('ajax failed: ' + this.url, arguments);
                })
            }
            containerCalc.calcRow($(`#TRcalcCont_${event.target.dataset.uniquerow}`));
        },
        calcRow: function(tr) {

            let $tr = $(tr), numRows = $tr.data("uniquerow");

            // if($vitex_globales.tipo_rony)
            // si es usuario tipo rony: poner cif unitario/cif*qty paso 1 clear  $(`#calcCIF_${numRows}`).html("")

            $tr.children("TD.calcClear").removeClass("calcContainerBelow calcContainerAbove calcContainerError");
            $tr.children("TD.calcContainerNumContainers").html("");
            $tr.children().find("INPUT.calcContainerQty").css({"border-color":""});
            $tr.children("TD.calcContainerContainerCapacity").css({"border-color":""});

            let q = $(`#contCalcQty_${numRows}`)?.val()?.trim();
            let c = $(`#contCalcCapacity_${numRows}`)?.html()?.trim();
            if(q === '' && c === '') {
                $tr.children().find("INPUT.calcContainerQty").css({"border-color":""});
                $tr.children("TD.calcContainerNumContainers").html("");
                containerCalc.calcTable();
                return;
            }
            let quantity = containerCalc.autoNumId[`contCalcQty_${numRows}`].get();
            let capacity = containerCalc.autoNumId[`contCalcCapacity_${numRows}`].get();
            let tempProducto = $tr.data('producto');
            if(tempProducto!==null && typeof tempProducto !== 'undefined' && tempProducto.hasOwnProperty("dudas") && typeof tempProducto.dudas === 'string')
                if(tempProducto.dudas.indexOf("container_quantity") > -1)
                    $tr.children("TD.calcDudaContainerContainerCapacity").html("<span title='Duda en el Loading Capacity o Per Container!' style='font-size:1.2em;display: inline-block; color:red;font-weight:800;border-radius: 50%;width:1em;height:1em;background-color: yellow;border: 1px red solid;text-align: center'>?</span>");
                else
                    $tr.children("TD.calcDudaContainerContainerCapacity").html("<span style='color:red;font-weight:800;border-radius: 50%;width:2em;height:2em;'>&nbsp;</span>");
            else
                $tr.children("TD.calcDudaContainerContainerCapacity").html("<span style='color:red;font-weight:800;border-radius: 50%;width:2em;height:2em;'>&nbsp;</span>");
            if(isNaN(quantity) || quantity < 0) {
                $tr.children().find("INPUT.calcContainerQty").css({"border-color":"red"});
                $tr.children("TD.calcContainerNumContainers").html("<span style='color:red;font-weight:800'>N/A</span>");
                containerCalc.calcTable();
                return;
            }

            // if($vitex_globales.tipo_rony)
            // si es usuario tipo rony: poner cif unitario/cif*qty paso 2 poner  $(`#calcCIF_${numRows}`).html("");

            if(isNaN(capacity) || capacity <= 0) {
                $tr.children("TD.calcContainerContainerCapacity").css({"border-color":"red"});
                $tr.children("TD.calcContainerNumContainers").html("<span style='color:red;font-weight:800'>N/A</span>");
                containerCalc.calcTable();
                return;
            }
            let containers = Math.round( quantity/capacity*100)/100;
            let frac = containers % 1;

            let classContainers = '';
            $tr.children("TD.calcContainerNumContainers").html(numFormatter(containers, 2)).addClass(classContainers);

            containerCalc.calcTable();
        },
        calcTable:function() {
            let ok = true;
            let aviso = '';
            let totales = {
                productos: 0.00,
                productos_units: {},
                quanity_units: {},
                kilos_units: {},
                kilos: 0.00,
                containers: 0.00,
                productos_ya:{}
            }
            $("#calcContTbody").children("TR").each(function(){
                let $tr = $(this), numRows = $tr.data("uniquerow");
                let producto_general_id = '';
                let p = $tr.data('producto');
                if(p !== null && typeof p === 'object' && p.hasOwnProperty('producto_general_id'))
                    producto_general_id = p.producto_general_id;
                let u = $tr.children("TD.calcContainerUnits").html();
                if(u === '')
                    u = '-';
                if(!totales.productos_ya.hasOwnProperty(producto_general_id)) {
                    totales.productos_ya[producto_general_id] = producto_general_id;
                    if (typeof totales.productos_units[u] === 'undefined')
                        totales.productos_units[u] = 1;
                    else
                        totales.productos_units[u]++;
                }
                let quantity = parseFloat( containerCalc.autoNumId[`contCalcQty_${numRows}`].get() );
                if(typeof totales.quanity_units[u] === 'undefined')
                    totales.quanity_units[u] = 0.00;
                if(typeof totales.kilos_units[u] === 'undefined')
                    totales.kilos_units[u] = 0.00;
                if(!isNaN(quantity)) {
                    totales.quanity_units[u] += quantity;
                    if(u === 'Kg') {
                        totales.kilos_units[u] += quantity;
                        totales.kilos += quantity;
                    } else {
                        let factorConversion = containerCalc.weight_per_m[producto_general_id] || 0;
                        if(isNaN(factorConversion) || factorConversion === '' || factorConversion <= 0) {
                            aviso = "&cross;";
                        } else {
                            totales.kilos_units[u] += parseFloat(factorConversion) * quantity;
                            totales.kilos += parseFloat(factorConversion) * quantity;
                        }
                    }
                }
                let ch = $tr.children("TD.calcContainerNumContainers").text();
                let c = parseFloat(ch);
                if(!isNaN(c))
                    totales.containers += c;
                else if(ch === 'N/A')
                    ok = false;
            });
            var arr = [];
            for(let u in totales.productos_units)
                if(totales.productos_units.hasOwnProperty(u)) {
                    if(u === 'mts')
                        arr.push(`${numFormatter(totales.productos_units[u], 0)} producto${totales.productos_units[u] === 1 ? '' : 's'} de ${u}:
                            <span style='padding-left:0.5em'>${numFormatter(totales.kilos_units[u], 2)} Kg <i style='font-weight: 100;font-size:0.8em'>aprox</i></span>`);
                    else
                        arr.push(`${numFormatter(totales.productos_units[u], 0)} producto${totales.productos_units[u] === 1 ? '' : 's'} de ${u}`);
                }
            arr.push(`<span title="Pasando todo a kilos, para ver si sobrepasa 25 Toneladoas, ¡por el Tren!">${numFormatter(totales.kilos, 2)} KILOS TOTALES</span>`);

            $("#calcContTotUnits").html(arr.join("<p>"));
            arr = [];
            for(let u in totales.quanity_units)
                if(totales.quanity_units.hasOwnProperty(u))
                    arr.push(numFormatter(totales.quanity_units[u], 2) + " " + u);
            $("#calcContTotQuantity").html(arr.join("<p>"));
            $("#calcContTotContainers").html( numFormatter( totales.containers, 2));
            $("#calcContTotContainersOk").html( ok ? "" + aviso : "&cross;" );
            let frac = totales.containers % 1;
            let per = totales.containers >= 1 &&  frac < 0.009 ? 100 :  frac * 100;
            $("#calBPPercent").css({width:`${per}%`}).html(numFormatter(per, 2) + '%');
        },
        calcula: function(producto_general_id, quantity) {
            let info = containerCalc.productData[producto_general_id] || null;
            if(info === null) {
                 containerCalc.productDataRead();
            }
            info = containerCalc.productData[producto_general_id] || null;
            if(info === null)
                return 0;
            let div = quantity/info.container_quantity;
            return isNaN(div) || div === Infinity ? 0 : div;
        },
    }
    jQuery(function($) {containerCalc.init();})
</script>
<script id="containerTable_script">
    let containerProductInput = {
        gridPager: '#contMaxGridPager',
        resize: function() {
            let div = document.getElementById("contMaxDiv");
            $("#contMaxGrid")
                .jqGrid('setGridWidth', div.clientWidth - 40)
                .jqGrid('setGridHeight', div.clientHeight - 160);
        },
        dialog: function(el) {
            el.style.cursor = 'wait';
            document.body.style.cursor = 'wait';
            $("BODY").css("cursor", "wait");
            let d = $("#contMaxDiv");
            if(d.length > 0) {
                try {d.dialog('close');} catch(er) {d.remove();}
                return;
            }
            let colModel = [
                    {name: "producto_general_id", key: true, hidden: true},
                    {name:'producto', label:'Producto',
                        align: 'left', width:295, firstsortorder:'asc',
                        searchoptions: {  defaultSearch: 'cn', sopt: [ 'cn', 'eq','bw', 'ew',], autocomplete: "off", autofill: "off"},
                        formatter: function(cellvalue, options, rowObject) {
                            return `${cellvalue}  <b>${rowObject.dudas.indexOf("container_quantity")>=0 ? "<b style='color:red;font-size:2em'>?</b>" : ""}</b>`;
                        }
                    },
                    { name:'unidad', label:'Unidad', align: 'center', width: 70,
                        formatoptions: {classes:"dontUpperCase notSelectize",},
                        edittype: 'select',
                        editoptions: {value: "<?php echo units2grid(); ?>"},
                        search: true,
                        stype: 'select',
                        searchoptions: {
                            clearSearch: true,
                            search:true,
                            searchOperMenu: false,
                            sopt: ['eq'],
                            value: ":;<?php echo units2grid(); ?>",
                            size: '1',
                            multiple: false,
                            autocomplete:"off",
                            defaultsearch:"eq",
                        }
                    },

                    {name:"container_quantity_default", label:"Aproximado por Sistema", align: 'right', width:111,
                        formatter: 'number',
                        formatoptions: {decimalSeparator: ".", thousandsSeparator: ",", decimalPlaces: 0,defaultValue: ''},
                        stype: "text",
                        searchtype: "number",
                        sorttype: "number",
                        searchrules:{number:true, },
                        searchoptions: {  defaultSearch: 'eq', sopt: [ 'eq', 'ge','gt', 'le', 'lt',]},
                    },
                    {name:'container_quantity', label:'Loading Capacity',
                    align: 'right', width:111, classes: containerCalc.canEdit ? "divAsInput" : "",
                    editable: false, // containerCalc.canEdit,
                    edittype: "text",
                    editoptions: {defaultValue: 0, min:"0", type:"number", size: "9", dataInit:function(e) {
                        console.log("editing",e);
                            $(e).on('keypress', function(eventKey){
                                let validKeys = [
                                    "0","1","2","3","4","5","6","7","8","9","0",
                                    "Delete", "Backspace", "ArrowLeft", "ArrowRight", "Escape"];
                                if(validKeys.includes(eventKey.key))
                                    return;
                                eventKey.stopPropagation();
                                eventKey.stopImmediatePropagation();
                                eventKey.preventDefault();
                                return false;
                            }).on("blur", function(ev) {
                                let $self = $("#contMaxGrid"), p = $self.jqGrid("getGridParam");
                                $self.jqGrid("saveCell", p.iRow, p.iCol);
                            });
                        }},
                    editrules: { maxValue: 99999999, minimumValue: 0, required:false},

                    formatter: 'number',
                    formatoptions: {decimalSeparator: ".", thousandsSeparator: ",", decimalPlaces:0,defaultValue: ''},
                    stype: "text",
                    searchtype: "number",
                    sorttype: "number",
                    searchrules:{number:true, },
                    searchoptions: {  defaultSearch: 'eq', sopt: [ 'eq', 'ge','gt', 'le', 'lt',]},
                },
                    {name:'container_quantity_costs', label:'💰 Costs Loading Capacity',
                    align: 'right', width:111, classes: containerCalc.canEdit ? "divAsInput" : "",
                    editable: false, //containerCalc.canEdit,
                    edittype: "text",
                    editoptions: {defaultValue: 0, min:"0", type:"number", size: "9", dataInit:function(e) {
                            console.log("editing",e);
                            $(e).on('keypress', function(eventKey){
                                let validKeys = [
                                    "0","1","2","3","4","5","6","7","8","9","0",
                                    "Delete", "Backspace", "ArrowLeft", "ArrowRight", "Escape"];
                                if(validKeys.includes(eventKey.key))
                                    return;
                                eventKey.stopPropagation();
                                eventKey.stopImmediatePropagation();
                                eventKey.preventDefault();
                                return false;
                            }).on("blur", function(ev) {
                                let $self = $("#contMaxGrid"), p = $self.jqGrid("getGridParam");
                                $self.jqGrid("saveCell", p.iRow, p.iCol);
                            });
                        }},
                    editrules: { maxValue: 99999999, minimumValue: 0, required:false},

                    formatter: 'number',
                    formatoptions: {decimalSeparator: ".", thousandsSeparator: ",", decimalPlaces:0,defaultValue: ''},
                    stype: "text",
                    searchtype: "number",
                    sorttype: "number",
                    searchrules:{number:true, },
                    searchoptions: {  defaultSearch: 'eq', sopt: [ 'eq', 'ge','gt', 'le', 'lt',]},
                },
                    {name:'dudas', label:'Dudas',
                        formatter: function(cellvalue, options, rowObject) {
                            if(typeof cellvalue !== 'string' || cellvalue.length === 0)
                                return "";
                            return cellvalue.replace(/,/g, ", ").replace(/_/g, " ")
                                .replace(/\b[a-z]/g, function(letter) {return letter.toUpperCase();})
                                .replace(/Moq/gi, "MOQ")
                                .replace(/gsm/gi, "GSM")
                                .replace(/igi/gi, "IGI")
                                .replace(/usd/gi, "USD")
                                .replace(/Container Quantity/gi, "<b style='color:red'>Per Container</b>")
                        },
                    }
                ];
            let $dialog = $("<div id='contMaxDiv'  title='Cantidad de cada Producto que cabe en un Container.'><table id='contMaxGrid'></table><div id='contMaxGridPager'></div></div>");
            $("BODY").append($dialog);
            $.ajax({
                url: '../backoffice/ajax/producto_general_acciones.php',
                method: 'POST',
                cache: false,
                dataType: 'json',
                data: {accion:'container_quantity_list'},
            })
                .done(function(data, textStatus, jqXHR) {
                    if(!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                        return;
                    }
                    var gridData = data.gridData;
                    $dialog.dialog({
                        modal: true,
                        closeOnEscape: true,
                        width: 1050,
                        height: 900,
                        resizeStop: function() {containerProductInput.resize();},
                        close: function() { containerCalc.productDataRead(); this.remove();},
                        open: function() {
                            $("#contMaxGrid").jqGrid({
                                regional: 'es',
                                datatype: 'local',
                                data: gridData,
                                colModel: colModel,
                                cmTemplate: {
                                    autosize: true, autosize_headers: true, fixed: true,
                                    edittype: 'text', stype: 'text',
                                    editable: false, search: true, sortable: true,
                                },
                                colMenu: false,
                                width: 1100,
                                height: 300,

                                cellEdit: containerCalc.canEdit,
                                cellsubmit: "remote",
                                cellurl: "../backoffice/ajax/producto_general_acciones.php?accion=container_quantity_set",
                                editNextRowCell: false,
                                restoreCellonFail: true,

                                rowNum: gridData.length,
                                pager: containerProductInput.gridPager,
                                pgtext: '',
                                pgbuttons: false,
                                pginput: false,
                                recordtext: "{2} Artículos",
                                viewrecords: true,

                                rownumbers: true,
                                rownumWidth: 48,
                                headertitles: true,
                                autoencode: false,
                                autoResizing: false,
                                autowidth: false,
                                shrinkToFit: false,
                                ignoreCase: true,
                                search: true,
                                viewsortcols: [true, 'vertical', true],
                                sortable: true,
                                sortname: 'producto',
                                sortorder: 'ASC',
                                useNameForSearch: true,
                                viewable: true,
                                scrollrows: true,
                                gridview: true,
                                gridComplete:function() {
                                    containerProductInput.resize();
                                },
                            })
                            .jqGrid('filterToolbar', {stringResult: true, defaultSearch: 'cn', searchOperators: true, autosearch: true, searchOnEnter: false})
                            .jqGrid('navGrid', containerProductInput.gridPager, {closeOnEscape: true, add: false, edit: false, del: false, view: false, search: false, refresh: false},)
                            .jqGrid('navButtonAdd', containerProductInput.gridPager, {
                                caption: '🗚',
                                title: 'Incrementar Font Size',
                                buttonicon: 'ui-icon-arrowthick-1-n',
                                onClickButton: function () {
                                    let $tBody = $(this).find("TBODY");
                                    $tBody.css({
                                        'font-size': parseFloat($tBody.css('font-size')) * 1.025
                                    });
                                }
                            })
                            .jqGrid('navButtonAdd', containerProductInput.gridPager, {
                                caption: '🗛',
                                title: 'Reducir Font Size',
                                buttonicon: 'ui-icon-arrowthick-1-s',
                                onClickButton: function () {
                                    let $tBody = $(this).find("TBODY");
                                    $tBody.css({
                                        'font-size': parseFloat($tBody.css('font-size')) * 0.975
                                    });
                                }
                            })
                            .jqGrid('navSeparatorAdd',containerProductInput.gridPager)

                                .jqGrid('navButtonAdd',containerProductInput.gridPager,{caption:'Excel',title:'Exportar a Excel', buttonicon:'ui-icon-calculator',
                                    onClickButton: function(){ $(this).jqGrid('exportToCsv', {
                                            separator: ",",
                                            separatorReplace : "",
                                            quote : '"',
                                            escquote : '"',
                                            newLine : "\r\n",
                                            replaceNewLine : " ",
                                            includeCaption : true,
                                            includeLabels : true,
                                            includeGroupHeader : true,
                                            includeFooter: true,
                                            includeHeader: true,
                                            fileName : "product_per_container.csv",
                                            mimetype : "text/csv;charset=utf-8",
                                            onBeforeExport : null,
                                            returnAsString : false,
                                            loadIndicator : true,
                                            treeindent : ' '

                                    }); }})
                                .jqGrid('navButtonAdd',containerProductInput.gridPager,{caption:'PDF',title:'Exportar a PDF', buttonicon:'ui-icon-document-b',
                                    onClickButton: function(){ $(this).jqGrid('exportToPdf', {
                                        title: "Product Estimated Quantity Per Container",
                                        orientation: 'portrait',
                                        pageSize: 'letter',
                                        description: null,
                                        onBeforeExport: null,
                                        download: 'download',
                                        includeLabels : true,
                                        includeGroupHeader : true,
                                        includeFooter: true,
                                        includeHeader: true,
                                        fileName : "product_per_container.pdf",
                                        mimetype : "application/pdf",
                                        loadIndicator : true,
                                        visibleTreeNodes: false,
                                        treeindent : "-"
                                    });}});

                            $("BODY").css("cursor", "");
                            el.style.cursor = '';
                        }, // open function
                    });  // $dialog.dialog

                }) // ajax.done
                .fail(function(jqXHR, textStatus, errorThrown) {
                    ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                    console.log('ajax failed', arguments);
                }) // ajax fail
            ;
        },
    }
</script>
<?php } else { ?>
    <script>
        let containerCalc = {
            dialog:function(el){
                $("<div><h1>Sin Permiso</h1>").dialog({
                    closeOnEscape:true,
                    buttons: {Cerrrar: function() {$(this).dialog( "close" );}},
                    close: function(){$(this).remove();}
                });
            }
        };
        let containerProductInput = {
            dialog:function(el){
                $("<div><h1>Sin Permiso</h1>").dialog({
                    closeOnEscape:true,
                    buttons: {Cerrrar: function() {$(this).dialog( "close" );}},
                    close: function(){$(this).remove();}
                });
            }
        };
    </script>
<?php }
unset($containerCapacityEdit, $containerEditTrueFalse);
?>
