$(function () {
    $d.initDatePicker('.input_date');
    $('#dialogo_salidas_bodega').change(function () {
        $('#icon_clean_bodega_ventas')._show();
    });
    $('#dialogo_salidas_tienda').change(function () {
        $('#icon_clean_tienda_ventas')._show();
    });
    $('#dialogo_salidas_producto').change(function () {
        $('#icon_clean_producto_ventas')._show();
    });
    $('#dialogo_salidas_color').change(function () {
        $('#icon_clean_color_ventas')._show();
    });
    $('#dialogo_salidas_fecha_init').change(function () {
        $('#icon_clean_fecha_init_ventas')._show();
    });
    $('#dialogo_salidas_fecha_end').change(function () {
        $('#icon_clean_fecha_end_ventas')._show();
    });
    $('#btn_clean_all_controls_ventas').button();
});
var dialogoReporteVentas = {
    showDialogoSalidas: function () {
        var _me = this;

        var dialogo_reporte_ventas = $('#content_reportes_ventas');
        if (dialogo_reporte_ventas.hasClass('ui-dialog-content') && dialogo_reporte_ventas.dialog('isOpen')) {
            dialogo_reporte_ventas.dialog('close');
            return;
        }
        closeAllDialog();

        var buttons = [
            {
                text: "PDF",
                icon: "ui-icon-document",
                click: function () {_me.generaReporteSalidas(this, 'pdf')}
            },
            {
                text: "EXCEL",
                icon: "ui-icon-calculator",
                click: function () {_me.generaReporteSalidas(this, 'excel')}
            },
            {
                text: "JPG",
                icon: "ui-icon-image",
                click: function () {_me.generaReporteSalidas(this, 'jpg')}
            },
            {
                text: "PRINT",
                icon: "ui-icon-print",
                click: function () {_me.generaReporteSalidas(this, 'print')}
            },
        ];
        if (typeof ClipboardItem !== 'undefined') {
            buttons.push({
                text: "COPY",
                icon: "ui-icon-copy",
                click: function () {_me.generaReporteSalidas(this, 'copy')}
            });
        }
        dialogo_reporte_ventas.dialog({
            autoOpen: true,
            modal: false,
            width: 1030,
            height: 780,
            draggable: true,
            resizable: true,
            title: 'REPORTES DE TIENDAS',
            open: function() {
                runAfterFetchingCatalogs(() => {
                    dialogoReporteVentas.cleanAllControls();

                }, 'dialogoReporteVentas_cleanAllControls');

                $('#option_ambos').prop('checked', false);
                $('#option_ventas').prop('checked', false);
                $('#option_devoluciones').prop('checked', false);
                $('.frs').on('change', dialogoReporteVentas.setTipoReporteResumen);
                $('.snd').on('change', dialogoReporteVentas.setTipoReporteResumen);
                $('#details').on('change', dialogoReporteVentas.setDetailsResumen);
                $('#option_ambos_r')
                    .prop('checked', false)
                    .on('change', dialogoReporteVentas.setVisibilitySeparar);
                $('#option_ventas_r')
                    .prop('checked', true)
                    .on('change', dialogoReporteVentas.setVisibilitySeparar);

                $('#option_devoluciones_r')
                    .prop('checked', false)
                    .on('change', dialogoReporteVentas.setVisibilitySeparar);
                $('#dialogo_salidas_fecha_extra_control_today').trigger('click');
                $('#dialogo_salidas_bodega').on('change', dialogoReporteVentas.setBodegaResumen);
                $('#dialogo_salidas_tienda').on('change', dialogoReporteVentas.setTiendaResumen);
                $('#dialogo_salidas_producto').on('change', dialogoReporteVentas.setProductoResumen);
                $('input[name="por_bodega_producto"]').on('change', dialogoReporteVentas.setSBPor);
                $('#dialogo_salidas_fecha_init').on('change', dialogoReporteVentas.setFechaInitResumen);
                $('#dialogo_salidas_fecha_end').on('change', dialogoReporteVentas.setFechaEndResumen);
                $('#r_sn_precio').on('click', () => { dialogoReporteVentas.setRCPrecio('0') } );
                $('#r_con_precio').on('click', () => { dialogoReporteVentas.setRCPrecio('1') } );

                // $('[name=option_ventas_devoluciones]').on('change', function (e) {
                //     let id_opc=e.target.id;
                //     if(id_opc==='option_ventas_r') $('#detalles_report').show();
                //     else {
                //         $('#detalles_report').hide();
                //         $('#details').prop('checked', false);}
                // });
                // let $selector = $(this);
                // $(document).on('mousedown.mydialog', function(e) {
                //     // Close when user clicks elsewhere
                //     if($selector.dialog('isOpen') && !$.contains($selector.dialog('widget')[0], e.target) && !$("#ui-datepicker-div").is(":visible")){
                //         $selector.dialog('close');
                //     }
                // });
            },
            close: function() {
                dialogoReporteVentas.cleanAllControls();
                // dialogConsultarExistencia.hideDialogoSalidas(this);
            },
            buttons: buttons
        });
        // poniendo acordeon 
        $('#acordeon_r_tiendas').accordion({
            collapsible: true,
            heightStyle: "content"
        });
        
        //abriendo ultimo elemento del acordeon
        $('#acordeon_r_tiendas').accordion("option", "active", 1);
    },
    setRCPrecio: function (val) {
        if(val==='1')
            $('#option_ventas_r').trigger('click');
        else{
            $('#option_ventas').trigger('click');
        }
        
    },
    setFechaInitResumen: function (event) {
        let fecha_init = event.target.value;
        if (fecha_init.length === 0){
            $('#reporte_t_fecha_i').text('-');
            return;
        }
        $('#reporte_t_fecha_i').text(fecha_init);
    },
    setFechaEndResumen: function (event) {
        let fecha_end = event.target.value;
        if (event.target.value.length === 0){
            //obteniendo fecha con luxon de hoy
            let fecha_end = luxon.DateTime.local().setZone('America/Mexico_City').toFormat('dd-MM-yyyy', { zone: 'America/Mexico_City' });


            $('#reporte_t_fecha_f').text(fecha_end);
            return;
        }    
        $('#reporte_t_fecha_f').text(fecha_end);
    },
    setBodegaResumen: function () {
        //obteniendo bodegas seleccionadas con selectize
        let bodegas = $('#dialogo_salidas_bodega').val();
        if (bodegas.length === 0){
            $('#resumen_bodegas p').text('TODAS');
            return;
        }
        //obteniendo bodegas de vitex gloables
        let bodegas_vitex = $vitex_globales.g_cat_bodega;
        //arreglo para almacenar nombres de bodegas
        let bodegas_nombre = [];

       //recorriendi array de bodegas seleccionadas
       bodegas.forEach(bodega => {
        //filtrando bodegas de vitex globales
        let bodegas_filtradas = bodegas_vitex.filter(bod => bod.bodega_id === bodega);
        if(bodegas_filtradas.length > 0) bodegas_nombre.push(bodegas_filtradas[0].bodega);
       });
       //convirtiendo arreglo a string
        let bodegas_string = bodegas_nombre.join(', ');

        //asignando valor a resumen de bodegas
        $('#resumen_bodegas p').text(bodegas_string);

    },
    setVisibilitySeparar: function (event) {
        if($("#option_ambos_r").is(':checked')){
            $('#div_separar').removeClass('none');
        }
        else
            $('#div_separar').addClass('none');
        
    },
    setProductoResumen: function () {
        //obteniendo productos seleccionadas con selectize
        let productos = $('#dialogo_salidas_producto').val();
        if (productos.length === 0){
            $('#resumen_productos p').text('TODOS');
            return;
        }

        //obteniendo productos de vitex gloables
        let productos_vitex = $vitex_globales.g_cat_producto_general;
        //arreglo para almacenar nombres de productos
        let productos_nombre = [];

         //recorriendi array de productos seleccionadas
            productos.forEach(producto => {
                //filtrando productos de vitex globales
                let productos_filtradas = productos_vitex.filter(prod => prod.producto_general_id === producto);
                if(productos_filtradas.length > 0) productos_nombre.push(productos_filtradas[0].producto);
            });
            //convirtiendo arreglo a string
                let productos_string = productos_nombre.join(', ');
        
                //asignando valor a resumen de productos
                $('#resumen_productos p').text(productos_string);
    },
    setTiendaResumen: function () {
        //obteniendo tiendas seleccionadas con selectize
        let tiendas = $('#dialogo_salidas_tienda').val();
        if (tiendas.length === 0){
            $('#resumen_tiendas p').text('TODAS');
            return;
        }
        //obteniendo tiendas de vitex gloables
        let tiendas_vitex = $vitex_globales.g_cat_tienda;
        //arreglo para almacenar nombres de tiendas
        let tiendas_nombre = [];

       //recorriendi array de tiendas seleccionadas
       tiendas.forEach(tienda => {
        //filtrando tiendas de vitex globales
        let tiendas_filtradas = tiendas_vitex.filter(tien => tien.tienda_id === tienda);
        if(tiendas_filtradas.length > 0) tiendas_nombre.push(tiendas_filtradas[0].clave);
       });
       //convirtiendo arreglo a string
        let tiendas_string = tiendas_nombre.join(', ');

        //asignando valor a resumen de tiendas
        $('#resumen_tiendas p').text(tiendas_string);
    },
    setTipoReporteResumen: function (event) {
        if($(event.target).hasClass('frs')){
            $('#reporte_t_tipo span').text('Reporte sin Precio');
            $('#r_subtotal_por').hide();
            $('#r_solo_totales').hide();
            $('#details').prop('checked', false);
            $('#p_producto').prop('checked', true);
        }
        else{
            $('#reporte_t_tipo span').text('Tipo: Reporte con Precio');
            $('#r_subtotal_por').show();
            $('#r_solo_totales').show();
        }

        let datalbl=$(event.target).attr('data-lbl');
        $('#categoria_reporte span').text(datalbl);
    },
    setSBPor: function (event) {
        if($(event.target).attr('id')==='p_bodega'){
            $('#r_subtotal_por span').text('Bodega');
        }
        else{
            $('#r_subtotal_por span').text('Producto');
        }
    },
    setDetailsResumen: function (event) {
        if($(event.target).is(':checked')){
            $('#r_solo_totales span').text('Si');
        }
        else{
            $('#r_solo_totales span').text('No');
        }
    },
    generaReporteSalidas: function (dialog = null, type = 'pdf') {
        $('.container_flex').hide();
        $('#acordeon_r_tiendas').hide();

        var tipo_reporte = $('[name=option_ventas_devoluciones]:checked').val();
        let id=$('[name=option_ventas_devoluciones]:checked').attr('id');

        var label_wait = "Cargando reporte";
        if (!empty(tipo_reporte)) {
            if (tipo_reporte.strcasecmp('ventas') === 0)
                label_wait = "Cargando reporte de Ventas";

            if (tipo_reporte.strcasecmp('devoluciones') === 0)
                label_wait = "Cargando reporte de Devoluciones";

        }

        $('#load_reporte_ventas').html('<h3 style="text-align: center;">'+label_wait+'<br><img src="../img/load_content.gif" width="100" /></h3>');
        $('#load_reporte_ventas').show();

        
        let formData = new FormData();
        let input_date_init = $('#dialogo_salidas_fecha_init'),
            input_date_end = $('#dialogo_salidas_fecha_end'),
            input_bodega = $('#dialogo_salidas_bodega'),
            input_tienda = $('#dialogo_salidas_tienda'),
            input_producto = $('#dialogo_salidas_producto'),
            input_color = $('#dialogo_salidas_color');
        if (!empty(input_date_init.val()))
            formData.append('date_between[0]', input_date_init.val());


        if (!empty(input_date_end.val()))
            formData.append('date_between[1]', input_date_end.val());


        if (!empty(input_bodega.val())) {
            input_bodega.val().forEach(value => {
                formData.append('bodegas[]', value);
            });
        } else {
            formData.append('bodegas', '');
        }
        if (!empty(input_tienda.val())) {
            input_tienda.val().forEach(value => {
                formData.append('tiendas[]', value);
            });
        } else {
            formData.append('tiendas', '');
        }

        if (!empty(input_producto.val())) {
            input_producto.val().forEach(value => {
                formData.append('productos[]', value);
            });
        }

        formData.append('tipo_reporte', tipo_reporte);
        if(id.endsWith('_r')) formData.append('reportePrecio', 1);
        else formData.append('reportePrecio', 0);

        let datails=$('#details:checked').length;
        let p_bodega=$('#p_bodega:checked').length;

        let separar=$('#separar:checked').length;


        formData.append('p_bodega', p_bodega);
        formData.append('details', datails);
        formData.append('separar', separar);
        // if (!empty(input_color.val())) {
        //     input_color.val().forEach(value => {
        //         formData.append('colores[]', value);
        //     });
        // }


        formData.append('accion', 'reporteSalidas');
        formData.append('type', type);
        const request = {
            url: getUrlForAjax('reportes_acciones.php'),
            form_data: formData,
        };

        var hideWait = function () {
            $('#load_reporte_ventas').hide();
            $('.container_flex').show();
            $('#acordeon_r_tiendas').show();
            $('#load_reporte_ventas').html('');
        }

        let callbackRequestFile = (reponse, req) => {
            console.log(reponse);
            let name_file = request.name_file ||'';
            if (empty(name_file)) {
                var disposition = req.getResponseHeader('Content-Disposition');
                if (disposition && disposition.indexOf('attachment') !== -1) {
                    var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                    var matches = filenameRegex.exec(disposition);
                    if (matches != null && matches[1]) name_file = matches[1].replace(/['"]/g, '');
                }
            }
            let blobFile = new Blob([reponse], {type: 'application/octetstream'});
            let blobUrl = window.URL.createObjectURL(blobFile);
            let link=document.createElement('a');
            link.href = blobUrl;
            link.download = name_file;
            link.click();
            link.remove();
            window.URL.revokeObjectURL(blobUrl);

            hideWait();
        };
        if (type === 'print' || type === 'jpg' || type === 'copy') {
            request.responseType = 'text';
        }

        if (type === 'print') {
            callbackRequestFile = (response) => {
                this.callbackPrint(response);
                hideWait();
            }
        }
        if (type === 'jpg') {
            callbackRequestFile = (response) => {
                this.callbackJPG(response);
                hideWait();
            }
        }
        if (type === 'copy') {
            callbackRequestFile = (response) => {
                this.callbackCopy(response);
                hideWait();
            }
        }
        requestFile(request, callbackRequestFile);
    },
    callbackPrint: function (response) {
        var div = document.createElement('div');
        div.style.display = 'none';
        div.innerHTML =  response;
        div.id = 'div_reporte_ventas_print';
        document.body.appendChild(div);
        const IA_PRINT_NOTE=$("#div_reporte_ventas_print"), title=$("TITLE"), titula='Salidas de Bodega a Tienda', titleAnterior = title.html();
        IA_PRINT_NOTE.printThis({
            debug: false,               // show the iframe for debugging
            importCSS: true,            // import parent page css
            importStyle: true,         // import style tags
            printContainer: false,       // print outer container/$.selector
            pageTitle: titula,              // add title to print page
            // loadCSS: getUrlBase("backoffice/view/component/commons/table_ventas_prints.css"), // path to additional css file - use an array [] for multiple
            removeInline: false,        // remove inline styles from print elements
            removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
            printDelay: 400,            // variable print delay erea 333
            header: null,               // prefix to html o null
            footer: null,               // postfix to html o null / (new Date()).toDateString()
            base: false,                // preserve the BASE tag or accept a string for the URL
            formValues: true,           // preserve input/form values
            canvas: false,              // copy canvas content
            doctypeString: '',       // enter a different doctype for older markup
            removeScripts: false,       // remove script tags from print content
            copyTagClasses: false,      // copy classes from the html & body tag
            beforePrintEvent: null,     // function for printEvent in iframe
            beforePrint: null,          // function called before iframe is filled
            afterPrint: function(){
                title.html(titleAnterior);
                div.remove();
            }            // function called before iframe is removed
        });
        // div.remove();
    },
    callbackJPG: function (response) {
        var div = document.createElement('div');
        div.innerHTML =  response;
        div.id = 'div_reporte_ventas_print';
        console.log(div)
        document.body.appendChild(div);

        try {
            const fileName = $("#content_reportes_ventas").dialog('option', 'title').replaceAll("[\:\,\.\'\"\`\*\?\;\/\(\)\[\]\{\}]", '_');
            html2canvas(document.querySelector('#div_reporte_ventas_print')).then(function (canvas) {
                saveAs(canvas.toDataURL(), fileName + '.png');
                div.remove();
            });
        }catch(e) {
            console.log(e);
            html2canvas(document.querySelector('#div_reporte_ventas_print')).then(function (canvas) {
                saveAs(canvas.toDataURL(), 'salidas.png');
                div.remove();
            });
        }
    },
    callbackCopy: function (response) {
        var div = document.createElement('div');
        div.innerHTML =  response;
        div.id = 'div_reporte_ventas_print';
        // div.style.display = 'none';
        document.body.appendChild(div);
        html2canvas(document.querySelector('#div_reporte_ventas_print')).then(function (canvas) {
            canvas2Clipboard(canvas);
            div.remove();
        });
        $.notify("¡Copiado!", {
            className: 'info',
            autoHideDelay: 2000
        });
    },

    setDate: function (option = 'today') {
        let date_init = '', date_end = '', current_date = new Date();
        switch (option) {
            case "today":
                date_init = date_end = '0';
                break;
            case 'yesterday':
                date_init = date_end = '-1';
                break;
            case 'this_week':
                    date_init = getMondayOfCurrentWeek(current_date);
                    date_end = getSundayOfCurrentWeek(current_date);
                break;
            case 'this_month':
                date_init = getDayOfMonth(current_date, 'primero');
                date_end = getDayOfMonth(current_date, 'ultimo');
                break;
            case 'last_month':
                date_init = getDayOfMonth(current_date, 'primero', 'pasado');
                date_end = getDayOfMonth(current_date, 'ultimo', 'pasado');
                break;
            case 'this_year':
                date_init = getThisYear(current_date);
                date_end = getLastDayOfCurrentMonth(current_date);
                break;
        }

        $('#dialogo_salidas_fecha_init').datepicker('setDate', date_init);
        //obteniendo fecha de inicio
        let fecha_init = $('#dialogo_salidas_fecha_init').val();
        $('#reporte_t_fecha_i').text(fecha_init);
        $('#dialogo_salidas_fecha_end').datepicker('setDate', date_end);
        //obteniendo fecha de fin
        let fecha_end = $('#dialogo_salidas_fecha_end').val();
        $('#reporte_t_fecha_f').text(fecha_end);
        $('#icon_clean_fecha_init_ventas')._show();
        $('#icon_clean_fecha_end_ventas')._show();
    },

    clearInputBodega: function () {
        var select = $('#dialogo_salidas_bodega')[0];
        if(select) {
            select.selectize.clear();
            select.selectize.refreshItems();
        }
        $('#icon_clean_bodega_ventas')._hide();
    },
    clearInputTienda: function () {
        var select = $('#dialogo_salidas_tienda')[0];
        if(select) {
            select.selectize.clear();
            select.selectize.refreshItems();
        }
        $('#icon_clean_tienda_ventas')._hide();
    },
    clearInputProducto: function () {
        var select = $('#dialogo_salidas_producto')[0];
        if(select) {
            select.selectize.clear();
            select.selectize.refreshItems();
        }
        $('#icon_clean_producto_ventas')._hide();
    },
    clearInputColor:function () {
        /*var select = $('#dialogo_salidas_color')[0];
        select.selectize.clear();
        select.selectize.refreshItems();
        $('#icon_clean_color_ventas')._hide();*/
    },
    clearInputFechaInit: function () {
        $('#dialogo_salidas_fecha_init').val('');
        $('#icon_clean_fecha_init_ventas')._hide();
        $('#dialogo_salidas_fecha_extra_controls input[type=radio]:checked').prop('checked', false)
        $('#reporte_t_fecha_i').text('-');
    },
    clearInputFechaEnd: function () {
        $('#dialogo_salidas_fecha_end').val('');
        $('#icon_clean_fecha_end_ventas')._hide();
        $('#dialogo_salidas_fecha_extra_controls input[type=radio]:checked').prop('checked', false)
        //obteniendo fecha con luxon de hoy
        let fecha_end = luxon.DateTime.local().setZone('America/Mexico_City').toFormat('dd-MM-yyyy', { zone: 'America/Mexico_City' });

        $('#reporte_t_fecha_f').text(fecha_end);
    },
    cleanAllControls: function () {

        this.clearInputBodega();
        this.clearInputTienda();
        this.clearInputProducto();
        this.clearInputColor();
        this.clearInputFechaInit();
        this.clearInputFechaEnd();
    }
};