<!--
    --Paso 1: Incluir el archivo que llama los estilos creados en la base de datos 
        (abajo de donde se incluye el config.php)
        require_once("../backoffice/StylerGetStyle.php");
    --Paso 2: Se crea la instancia de la clase StylerGetStyle
        $styler = new StylerGetStyle();
    --Paso 3: Buscar la etiqueta style y hacer un foreach para recorrer los estilos
        <style>
                foreach ($styler as $style) {
                    echo $style['json_styles'];
                }
        </style> (obvio abrir primero < ?php y cerrar ?>);

    --Paso 5: incluir la librería y estilos de spectrum
        <link rel="stylesheet" href="../js2/spectrum/spectrum.css">
        <script src="../js2/spectrum/spectrum.js"></script>
    --Paso 6: En el archivo donde se quiere usar el styler, se incluye el archivo styler_widget.php
        require_once("../backoffice/view/component/commons/styler_widget.php");
    --Paso 7: Si es un grid de debe agregar en el app relacionado con el grid
        gridhandler.jqGrid("colMenuAdd", "all", {
                 id: "styler",
                 title: "Coloreame",
                 icon: "ui-icon-palette",
                 funcname: function(jqGrid_column_name) {
                     let col= `.ui-widget.ui-widget-content TD[aria-describedby="${this.id}_${jqGrid_column_name}"]`;
                     styler.dialog({jqGrid_column_name,col},col);
                 }
             })
    NOTA: En caso de no tener activo el ColMenu activarselo en el grid sn el listme_prerender de la app
             --$grid->set_option('colMenu', true);
                     $grid->set_option('cmTemplate',
            '{coloptions:{sorting:false, columns:false, columns_selectAll:false,filtering:false, freeze:false, grouping:false, }}');
            Si no esta en una app en la definicion del grid se agrega
                   colMenu:true,
    NOTA 2: toma por parámetro el nombre con el que se identificará en la bd en el campo del columna de la tabla estilos_grid
             tambien el col debe llevar las clases a las que se les desea ganar en especifidad en css y el elemento al que se desea poner la clase 
             (ejemplo: .ui-widget.ui-widget-content TD[aria-describedby="listme_1_nombre"]);
    


-->
<!--suppress CssUnusedSymbol -->
<style id="styler_css">
    #styler LABEL {cursor:pointer}
    .stylerColorClick {border:3px #d1cbd1 inset;background-color: #e6e6e6;}
    .stylerStatusButton {display:none}
    .stylerStatusButton + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 inset; background-color: #e6e6e6}
    .stylerStatusButton:checked + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 outset;background-color: silver}
    .stylerLabelHasChecked {}
    INPUT[name="styler_text-decoration"]:checked {box-shadow: 0 0 0 3px blue;cursor:pointer}
</style>
<!--suppress HtmlFormInputWithoutLabel -->
<div id="styler" title="Styler" style="display:none">
    <fieldset>
        <div style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start">
            <fieldset><legend>Ejemplo</legend>
                <div id="styler_ejemplo" style="border:1px silver solid;width:8em">Text 1,234.56</div>
            </fieldset>
            <fieldset style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start"><legend>Texto</legend>
                <div>
                    <input type="text" class="spectrumColorPicker" id="styler_color" value="#000">
                    <input id="styler_font-weight" type="checkbox" class="stylerStatusButton"
                           value="900"><label title="Negrita, Bold" for="styler_font-weight" style="font-weight: bold">B</label
                    ><input id="styler_font-style" type="checkbox" class="stylerStatusButton"
                            value="italic"><label title="Cursiva, Italica" for="styler_font-style" style="font-style:italic">I</label
                    >
                    <input id="styler_text-align_left" name="styler_text-align" type="radio" class="stylerStatusButton"
                           checked="checked"
                            value="left"><label title="Alinear a la izquierda" for="styler_text-align_left" style="text-align: left;padding-left:0.1em;padding-right:0.9em">&equiv;</label
                    ><input id="styler_text-align_center" name="styler_text-align" type="radio" class="stylerStatusButton"
                            value="center"><label title="Centrado" for="styler_text-align_center" style="text-align: center">&equiv;</label
                    ><input id="styler_text-align_right" name="styler_text-align" type="radio" class="stylerStatusButton"
                            value="right"><label title="Alinear a la derecha" for="styler_text-align_right" style="text-align: right;padding-right:0.1em;padding-left:0.9em">&equiv;</label>
                        <select id="styler_font-size" class="notSelectize">
                            <option data-style="0.7em" value="0.7em">-40%</option>
                            <option data-style="0.8em" value="0.8em">-20%</option>
                            <option data-style="0.9em" value="0.9em">-10%</option>
                            <option data-style="1.0em" value="1.0em">Normal</option>
                            <option data-style="1.2em" value="1.2em">110%</option>
                            <option data-style="1.5em" value="1.25em">120%</option>
                            <option data-style="1.5em" value="1.3em">130%</option>
                            <option data-style="1.5em" value="1.4em">140%</option>
                            <option data-style="1.5em" value="1.5em">150%</option>
                            <option data-style="1.7em" value="1.75em">175%</option>
                            <option data-style="2em" value="2em">200%</option>
                            <option data-style="2.5em" value="2.5em">250%</option>
                        </select>
                </div>
            </fieldset>
            <fieldset><legend>Fondo</legend>
                <input id="styler_background-color1" type="text" class="spectrumColorPicker resetsNone" value="">
                <select id="styler_background-per1" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                    <option>10%</option><option>20%</option><option>30%</option>
                    <option>40%</option><option>50%</option><option>60%</option>
                    <option>70%</option><option>80%</option><option>90%</option>
                </select>
                <p>
                    <input id="styler_background-color2" class="spectrumColorPicker resetsNone" value="">
                    <select id="styler_background-per2" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>30%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <input id="styler_background-color3" class="spectrumColorPicker resetsNone" value="">

                    <select id="styler_background-per3" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>30%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <input id="styler_background-color4" class="spectrumColorPicker resetsNone" value="">
                    <select id="styler_background-per4" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>25%</option>
                        <option>30%</option><option>33%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <select class="notSelectize" id="styler_background_gradient">
                        <option value="">Solid</option>
                        <option value="conic-gradient">Cónico</option>
                        <option value="repeating-conic-gradient">Cónico R</option>
                        <option value="linear-gradient">Lineal</option>
                        <option value="repeating-linear-gradient">Lineal R</option>
                        <option value="radial-gradient">Radial</option>
                        <option value="repeating-radial-gradient">Radial R</option>
                    </select>
                    <select id="styler_background_gradient_tag" class="notSelectize">
                    </select>
            </fieldset>
            <div>
                <label>Margen<br><select id="styler_padding" class="notSelectize">
                        <option style="padding:inherit" value="inherit">Default</option>
                        <option value="0.3em">Poco</option>
                        <option value="0.5em">Mediano</option>
                        <option value="1em">Grande</option>
                    </select>
                </label>
            </div>
            <fieldset><legend>Énfasis</legend>
                <div>
                    <div><select id="styler_text-emphasis-style" class="notSelectize">
                            <option value="none">Sin</option>
                            <option value="'✄'">✄</option>
                            <option value="'⚐'">⚐</option>
                            <option value="'⚑'">⚑</option>
                            <option value="'☂'">☂</option>
                            <option value="'♪'">♪</option>
                            <option value="'+'">+</option>
                            <option value="'*'">*</option>
                            <option value="'^'">^</option>
                            <option value="'|'">|</option>
                            <option value="'~'">~</option>
                            <option value="'´'">´</option>
                            <option value="'`'">`</option>
                            <option value="'✦'">✦</option>
                            <option value="double circle open">Ojo</option>
                        </select>
                        <input id="styler_text-emphasis-color" type="text" class="spectrumColorPicker" value="">
                        <input id="styler_text-emphasis-position_over" name="styler_text-emphasis-position" type="radio"
                               class="stylerStatusButton" value="over" checked="checked"><label
                                title="Poner en énfasis arriba. Tipo cambié el margen"
                                for="styler_text-emphasis-position_over"><sup>&OverBracket;</sup></label
                        ><input id="styler_text-emphasis-position_under" name="styler_text-emphasis-position" type="radio" class="stylerStatusButton"
                                value="under"><label title="Poner en énfasis abajo.  Tipo cambié el margen" for="styler_text-emphasis-position_under"
                        ><sub>&UnderBracket;</sub></label>
                    </div>
            </div>
            </fieldset>
            <fieldset><legend>Lineado</legend>
                <table style="border:4px inset silver;padding-left:0.5em;padding-right:0.5em" class="notSelectize">
                <tr>
                    <td><label class="stylerLabelHasChecked"><input type="radio" checked="checked" name="styler_text-decoration" value="none"> Normal</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:line-through"><input type="radio" name="styler_text-decoration" value="line-through"> Tachado</label>
                    <td>
                        <input id="styler_text-decoration-color" class="spectrumColorPicker" value="">
                    <td>
                        <select class="notSelectize" id="styler_text-decoration-thickness">
                                <option style="text-decoration-thickness:from-font" value="from-font">Ancho</option>
                                <option style="text-decoration-thickness:1px" value="1px">1px</option>
                                <option style="text-decoration-thickness:4px" value="2px">2px</option>
                                <option style="text-decoration-thickness:4px" value="3px">3px</option>
                                <option style="text-decoration-thickness:4px" value="4px">4px</option>
                                <option style="text-decoration-thickness:5px" value="4px">5px</option>
                                <option style="text-decoration-thickness:6px" value="4px">6px</option>
                            </select>
                </tr>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline solid"><input type="radio" name="styler_text-decoration" value="underline solid"> Subrayado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline double"><input type="radio" name="styler_text-decoration" value="underline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline dotted"><input type="radio" name="styler_text-decoration" value="underline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline wavy"><input type="radio" name="styler_text-decoration" value="underline wavy"> Ondulado</label>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline solid;" ><input type="radio" name="styler_text-decoration" value="overline solid"> Testado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline double" ><input type="radio" name="styler_text-decoration" value="overline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline dotted" ><input type="radio" name="styler_text-decoration" value="overline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline wavy" ><input type="radio" name="styler_text-decoration" value="overline wavy"> Ondulado</label>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline" ><input type="radio" name="styler_text-decoration" value="underline overline solid"> Marcado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline double" ><input type="radio" name="styler_text-decoration" value="underline overline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline dotted" ><input type="radio" name="styler_text-decoration" value="underline overline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline wavy" ><input type="radio" name="styler_text-decoration" value="underline overline wavy"> Ondulado</label>
            </table>
            </fieldset>
        </div>
    </fieldset>
</div>
<script id="styler_js_code">
    let styler = {
        defaults: {
            borders:false, // allow border styling
            element_id: null, // addclass cssName to element_id
            jqGrid_column_name: null, // add class tojqGrid.jqGrid_column_name
            counter: 0,
            dialog: {},
            save:{url:'../backoffice/ajax/styler_actions.php', data:{'accion':'stylerColumnSet'}}
        },
        needInit: true,
        settings: {},

        dialog: function(options, cssName) {
            console.log("styler.dialog in", new Date());
            styler.settings = {};
            $.extend(styler.settings, styler.defaults, {cssName:cssName  || ""}, options || {});
            styler.settings.done = false;
            if(styler.needInit)
                styler._dialog_init(styler.settings);
            styler.setValues(styleSheetsHelper.getStyleObject( styler.settings.cssName));
            styler._formatForm();
            $("#styler").dialog($.extend({},
                {
                    close: function() {
                        let styles = styler.getStyles();
                        let styleLine = styler.getStyleLine(styles);
                        let sendEvent ='stylerCancel';
                        if(styler.settings.done) {
                            sendEvent = 'stylerDone';
                            if (cssName.length) {
                                let contador=  parseInt(styler.defaults.counter);
                                if(contador !== 0){
                                    let ant_cont= contador - 1;
                                    $(cssName).removeClass(function(index, className) {
                                    // Encuentra todas las clases que comienzan con "prueba"
                                    var classesToRemove = className.split(' ').filter(function(cls) {
                                        return cls.startsWith('prueba');
                                    });

                                    // Devuelve las clases que deben eliminarse
                                    return classesToRemove.join(' ');
                                });
                                }
                                $(cssName).addClass(`prueba_${options.jqGrid_column_name}_${contador}`);
                                const cssOverClass= cssName+`.prueba_${options.jqGrid_column_name}_${contador}`;
                                styler.saveStyles(options.jqGrid_column_name, styler.getStyles(), styler.getURL(), cssName);
                                styleSheetsHelper.setStyle(cssOverClass, styleLine, styler);
                                styler.settings.cssNameAdded = true;
                                styler.defaults.counter= parseInt(styler.defaults.counter) + 1;
                                // console.log("setStyle", styler.defaults.counter);

                            }
                        }
                        $("#styler").trigger(sendEvent, {styles, styleLine, settings:styler.settings});
                        $("#styler").dialog("destroy");
                    },
                    closeOnEscape: true,
                    width: "95%", height: window.innerHeight - 200,
                    buttons: [
                        {
                            text: 'Ok',
                            icon: "ui-icon-check",
                            click: function () {
                                styler.settings.done = true;
                                //console.log(styler.settings);
                                $("#styler").dialog( "close" );
                                //console.log(styler.getStyles());

                            }
                        },
                        {
                            text: "Cancel",
                            id:"dialogme_cancel",
                            title:"Cerrar el dialogo sin cambios",
                            icon: "ui-icon-close",
                            click: function () {
                                $("#styler").dialog("close");
                            }
                        },
                        {
                            text: "Reset",
                            id:"dialogme_reset",
                            title:"Reset, clear all styles",
                            icon: "ui-icon-erase",
                            click: function () {
                                styler.clearStyles();
                            }
                        },
                    ],
                },
                styler.settings.dialog
            )).dialog("moveToTop");
        },

        getStyles:function() {
            let $styler = $("#styler");
            let styles = {
                'color': $("#styler_color", $styler).val(),
                'text-emphasis-color': $("#styler_text-emphasis-color", $styler).val(),
                'font-weight': $("#styler_font-weight", $styler).is(":checked") ? "900" : '400',
                'font-style': $("#styler_font-style", $styler).is(":checked") ? "italic" : 'normal',
                'font-size': $("#styler_font-size", $styler).val(),
                'text-align': $("input[name='styler_text-align']:checked", $styler).val(),
                'padding': $("#styler_padding", $styler).val(),

                'text-decoration': $("input[name='styler_text-decoration']:checked", $styler).val(),
                'text-decoration-thickness': $("#styler_text-decoration-thickness", $styler).val(),
                'text-decoration-color': $("#styler_text-decoration-color", $styler).val(),
                'text-emphasis-style': $("#styler_text-emphasis-style", $styler).val(),
                'text-emphasis-position': $("input[name='styler_text-emphasis-position']:checked").val(),
                'text-decoration-skip-ink': 'none',
                'background-color': '',
                'background': '',
            };
            if(styles["text-decoration-color"] === "" || styles["text-decoration-color"] === "none")
                styles["text-decoration-color"] = "inherit";
            let bk = [];
            for(let i=1; i<=4; ++i) {
                let backgroundColor = $(`#styler_background-color${i}`, $styler).val();
                if(typeof backgroundColor === "undefined" || backgroundColor.length === 0)
                    continue;
                bk.push( backgroundColor + ' ' + $(`#styler_background-per${i}`, $styler).val());
            }
            let gradient = $("#styler_background_gradient", $styler).val();
            if(gradient === ''){
                $("#styler_background-color2").spectrum("disable");
                $("#styler_background-color3").spectrum("disable");
                $("#styler_background-color4").spectrum("disable");
            }else{
                $("#styler_background-color2").spectrum("enable");
                $("#styler_background-color3").spectrum("enable");
                $("#styler_background-color4").spectrum("enable");
            }
            // console.log(`________set para grad ${gradient}`, bk);
            if(bk.length === 1 && gradient === '') {
                styles['background'] = $("#styler_background-color1", $styler).val();
                $("#styler_background-color2").spectrum("set", null);
                $("#styler_background-color3").spectrum("set", null);
                $("#styler_background-color4").spectrum("set", null);
            } else if(bk.length > 1) {
                $("#styler_background-color2").spectrum("enable");

                if(gradient === '')
                    gradient = 'linear-gradient';
                let angle = $("#styler_background_gradient_tag", $styler).val();
                if(angle === null)
                    angle = '';
                if(angle.length)
                    angle += ',';
                styles['background'] = `${gradient}(${angle} ${bk.join(', ')})`; // ${angle}
            }
            if(styles['text-decoration-color'] === '')
                styles['text-decoration-color'] = 'none';
            for(let s in styles)
                if(styles.hasOwnProperty(s) && styles[s] === '')
                    delete(styles[s]);
            return styles;
        },

        getURL: function(){
            let rutaActual = window.location.pathname; // Obtiene la ruta de la página sin el dominio ni los parámetros

            // Dividir la ruta en segmentos utilizando el carácter de barra "/"
            let segmentos = rutaActual.split('/');

            // Eliminar elementos vacíos del array resultante
            segmentos = segmentos.filter(function(segmento) {
                return segmento.trim() !== '';
            });

            // Obtener el último segmento (última carpeta)
            let ultimaCarpeta = segmentos[segmentos.length - 1];

            return ultimaCarpeta.replace(".php", "");
           
        },

        saveStyles: function (colDB, estilos, ruta, col) {
          //console.log(colDB, estilos);  

          $.ajax({
              url: styler.defaults.save.url,
              type: 'POST',
              data: {
                  accion: 'stylerColumnSet',
                  colDB,
                  estilos: JSON.stringify(estilos),
                  ruta,
                  col
              },
              success: function (data) {
                  // console.log(data);
              },
              error: function (jqXHR, textStatus, errorThrown) {
                  console.log(jqXHR, textStatus, errorThrown);
              }
          });
        },

        getStyleLine: function(styles) {
            let cssClass = [];
            for(let c in styles)
                if(styles.hasOwnProperty(c)) {
                    if (styles[c] === '')
                        cssClass.push(`${c}:inherit`);
                    else
                        cssClass.push(`${c}:${styles[c]}`);
                }
            return cssClass.join(';');
        },

        clearStyles:function() {
            $("input[name='styler_text-decoration'][value='none']").prop('checked',true);
            $("input[name='styler_text-align'][value='left']").prop('checked',true);
            $("input[name='styler_text-emphasis-position'][value='over']").prop('checked',true);
            $("SELECT").each(function(){
                try {
                    $(this).children("OPTION").first()[0].selected = true;
                } catch(er) {}
            });
            $("INPUT[type='checkbox']", $("#styler")).each(function(){this.checked = false;});
            $(".spectrumColorPicker").each(function(){$(this).spectrum("set",'black');});
            $(".resetsNone").each(function(){$(this).spectrum("set",'white');});
            styler._formatForm();
        },

        setValues:function(values) {
            let $styler = $("#styler");
            for(let k in values)
                if(values.hasOwnProperty(k)) {
                    let id = `styler_${k}`;
                    let $el = $(`#${id}`, $styler);
                    if($el.length) {
                        switch ($el[0].type) {
                            case 'checkbox':
                                $el[0].checked = $el.val() === values[k];
                                break;
                            default:
                                if($el.hasClass("spectrumColorPicker"))
                                    $el.spectrum("set",values[k]);
                                else
                                    $el.val(values[k]);
                        }
                        continue;
                    }
                    if(document.getElementsByName(id)) {
                        // console.log("____ " + id + " found radio setting", values[k])
                        $(`input[name='${id}'][value='${values[k]}']`).prop('checked',true);
                    }
                }
        },

        _dialog_init: function(options) {
            console.log("styler.dialog init", new Date());
            $('select').addClass('notSelectize').removeClass('selectized');
            styler.needInit = false;
            let $styler = $("#styler");
            $(".spectrumColorPicker", $styler).spectrum({
                preferredFormat: "hex",
                chooseText: "Ok",
                cancelText: "Cancela",
                showInput: true,
                showAlpha: true,
                allowEmpty: true,
                change: function() {
                    styler._formatForm();
                },
                replacercssName: "stylerColorClick",

                clickoutFiresChange: true,
                showPaletteOnly: true,
                showPalette: true,
                hideAfterPaletteSelect: true,
                togglePaletteOnly: true,
                togglePaletteMoreText: '>>',
                togglePaletteLessText: '<<',
                palette: [
                    '000000', '7E8C8D', '95A5A6', '808080', 'ECF0F1', 'CED4D9', 'FFFF99', 'FFFF66', 'FBEE33',
                    'F0E68C', 'FAFAD2', 'FFFF00', '169179', '008000', '00D000', '98FB98', '7CFC00', 'BFEDD2',
                    '236FA1', '34495E', '00BFFF', '0000FF', 'C2E0F4', 'B0E0E6', '843FA1', '4B0082', '000080',
                    'B96AD9', '6495ED', 'ECCAFA', 'BA372A', 'B22222', 'FF0000', 'DC143C', 'F8CAC6', 'E67E23',
                    'FFFFFF','rgba(256, 256, 256, 0)',
                ],
            });

            $("SELECT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
            $("INPUT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
            let gradientTag = {
                'conic-gradient': ['',
                    'at left top', 'at left center', 'at left bottom',
                    'at center top', 'at center center', 'at center bottom',
                    'at right top', 'at right center', 'at right bottom',
                    // from 0deg at 0% 25%,
                ],
                'repeating-conic-gradient': ['',
                    'at left top', 'at left center', 'at left bottom',
                    'at center top', 'at center center', 'at center bottom',
                    'at right top', 'at right center', 'at right bottom',
                ],
                'linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom',
                    // .25turn 45deg,
                ],
                'repeating-linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom' ],
                'radial-gradient': ['',
                    'circle at center', 'circle at left', 'circle at right',
                    'ellipse at center', 'ellipse at left', 'ellipse at right',
                ],
                'repeating-radial-gradient': ['',
                    'circle at center', 'circle at left', 'circle at right',
                    'ellipse at center', 'ellipse at left', 'ellipse at right',
                ],
            };
            styler._dependantSelects(
                document.getElementById('styler_background_gradient'),
                document.getElementById('styler_background_gradient_tag'),
                gradientTag
            );
           
            styler.setColorSelect(options);
            console.log("styler.dialog init DONE", new Date());
        },

        setColorSelect: function(options){
            $('.spectrumColorPicker').spectrum("set", null);
            let color = $(options.col).css("color");
            let bg_color = $(options.col).css("background");
            let font_w = $(options.col).css("font-weight");
            let font_s = $(options.col).css("font-style");
            let font_size = $(options.col).css("font-size");
            let parent_font = $(options.col).parent().parent().parent().css("font-size");
            let align = $(options.col).css("text-align");
            let padding= $(options.col).css("padding");
            let txt_decoration= $(options.col).css("text-decoration");
            let txt_decoration_border= $(options.col).css("text-decoration-thickness");
            let txt_decoration_color= $(options.col).css("text-decoration-color");
            let txt_emphasis_style= $(options.col).css("text-emphasis-style");
            let txt_emphasis_color= $(options.col).css("text-emphasis-color");
            let txt_emphasis_position= $(options.col).css("text-emphasis-position");
            let tipo_decoration= txt_decoration.replace(txt_decoration_border, "").replace(txt_decoration_color, "").replace("  "," ").trim();
            let bg_colors_g= $(options.col).css("background-image");


            $(`#styler_text-emphasis-position_${txt_emphasis_position}`).prop("checked", true);

            if(txt_emphasis_style==="none") $("#styler_text-emphasis-style").val("none");
            else $("#styler_text-emphasis-style").val(txt_emphasis_style.replace(/"/g, "'"))

            if(txt_decoration.includes('none')){
                 $("input[name='styler_text-decoration'][value='none']").prop("checked", true);
            }else{
                $(`#styler_text-decoration-thickness option[value='${txt_decoration_border}']`).prop("selected", true);

                if(txt_decoration_color==="rgb(34, 34, 34)" || tipo_decoration===""){
                    $("#styler_text-decoration-color").spectrum("set", null);
                }else{
                    $("#styler_text-decoration-color").spectrum("set", txt_decoration_color);
                }


                if(tipo_decoration==="line-through solid")tipo_decoration= tipo_decoration.replace(" solid", "");
                $(`input[name='styler_text-decoration'][value='${tipo_decoration}']`).prop("checked", true);

            }


            if(parseInt(padding)===0) $("#styler_padding").val("inherit");
            else if(parseInt(padding)===4) $("#styler_padding").val("0.3em");
            else if(parseInt(padding)===8) $("#styler_padding").val("0.5em");
            else if(parseInt(padding)===12 || parseInt(padding)===16) $("#styler_padding").val("1em");

            if(align==="left") $("#styler_text-align_left").prop("checked", true);
            else if(align==="center") $("#styler_text-align_center").prop("checked", true);
            else if(align==="right") $("#styler_text-align_right").prop("checked", true);

            let fontAnt= (parseInt(font_size) / parseInt(parent_font)  ).toFixed(1);
            // console.log("styler.setColorSelect font Anterior size", fontAnt);
            $(`#styler_font-size`).find(`option[data-style="${fontAnt}em"]`).prop("selected", true);
            
            if(font_s==="italic") $("#styler_font-style").prop("checked", true);
            else $("#styler_font-style").prop("checked", false);

            if(font_w==="900") $("#styler_font-weight").prop("checked", true);
            else $("#styler_font-weight").prop("checked", false);

            const bg_colors= bg_color.split(' r');
            $('#styler_background-color1').spectrum("set", null);

            
            if(bg_colors[0].includes("rgba(0, 0, 0, 0)") || bg_colors.length>1) {
                $('#styler_background-color1').spectrum("set", "#fff");

                if(bg_colors[0].includes("none") || bg_colors.length===1){
                    if(bg_colors[0]==='rgba(0, 0, 0, 0) none' || bg_colors[0]==='none' || bg_color[0] === 'rgba(0, 0, 0, 0)') $('#styler_background-color1').spectrum("set", null);
                    else $('#styler_background-color1').spectrum("set", bg_colors[0]);
                    $("#styler_background_gradient").val(``); 
                    $("#styler_ejemplo").css("background", bg_colors[0]);

                   }else{


                        let regex = /^(.*?)(?=\()/; 

                        let match_grad = bg_colors_g.match(regex);
                        let textoAntesDelParentesis_grad = match_grad[1].trim();

                        if (match_grad) $("#styler_background_gradient").val(`${textoAntesDelParentesis_grad}`); 
                        let obteniendoDeg = bg_colors_g.replace(`rgba(0, 0, 0, 0)`).replace(`${textoAntesDelParentesis_grad}(`, "").replace(`))`, ")");

                        const coloresArrayDeg = obteniendoDeg.match(/rgb\(\d+,\s*\d+,\s*\d+\)/g);

                        
                        if(coloresArrayDeg){
                            coloresArrayDeg.forEach((only, index) => {
                                $(`#styler_background-color${index+1}`).spectrum("set", only);
                            });
                        }
                   }

                
            }else{

                if(bg_colors[0]==="none") $('#styler_background-color1').spectrum("set", null);
                else $('#styler_background-color1').spectrum("set", bg_colors[0]);
                $("#styler_background_gradient").val(``); 
                $("#styler_ejemplo").css("background", bg_colors[0]);

            }
           
            $("#styler_color").spectrum("set", color);


            if(txt_emphasis_color==="rgb(34, 34, 34)" || txt_emphasis_style ==='none'){
                $("#styler_text-emphasis-color").spectrum("set", null);
            }else{
                $("#styler_text-emphasis-color").spectrum("set", txt_emphasis_color);
            }

        },

        _formatForm: function() {
            let $styler = $("#styler");
            const styles = styler.getStyles();
            $("INPUT[name='styler_text-decoration']", $styler).each(function() {
                $(this).parent().css(
                    {
                        'text-decoration-color': styles['text-decoration-color'],
                        'text-decoration-thickness': styles['text-decoration-thickness'],
                    }
                );
            });
            $("#styler_ejemplo").css(styles);
            $styler.trigger('stylerChange', {styles, styleString:styler.getStyleLine(styles), settings:styler.settings});
        },

        _dependantSelects: function(parent, child, parentChildValues) {
            parent.addEventListener('change', function populate_child(event){
                child.innerHTML = '';
                let lst = parentChildValues[event.target.value] || [];
                for(let k of lst)
                    child.innerHTML += '<option>'+ k +'</option>';

            });
        },
    }
    Object.freeze(styler);
</script>

