<?php
    require_once("../../../../inc/config.php");
    if(!usuarioTipoRony() && Permisador::puede_consultar_permisos() ==='Nada')
        die();
?>
<div id="Permisos">
    <h1>Permisos</h1>
    <div class="d-flex_permisos">
        <div>
            <h3>Permisos Generales</h3>
            <ol class="permiso_generales">
                <?php
                $permisos_generales = Permisador::getPERMISOS();
                $permisos_generales['pedidos_a_china'] = [
                    'label' => 'Pedidos',
                    'grupo' => 'China'
                ];
                unset($permisos_generales['puede_registrar_todas_bodegas']);

                foreach($permisos_generales as &$p) {
                    $p['label'] = ucfirst(trim(
                        preg_replace('/^hacer|^puede|^permisos|^permiso de |^permiso/iS', '', $p['label'])
                    ));
                    if(!array_key_exists('grupo', $p))
                        $p['grupo'] = '';
                }

                uasort($permisos_generales, function($a, $b) {
                    $da = strcasecmp($a['grupo'], $b['grupo']);
                    if($da === 0)
                        return strcasecmp($a['label'], $b['label']);
                    return $da;
                });
                $array_permisos_no_mostrar = [
                    'puede_revisar_gastos_cuentat',
                    'puede_gasto', 'puede_inversion_privada',
                    'puede_nueva_inversion_informativa', 'puede_nueva_inversion_interes',
                    'puede_registrar_todas_bodegas', 'puede_solo_consultar_bodegas', 'notas_por_bodega',
                ];
                $prevGrupo = null;
                foreach($permisos_generales as $key => $generales) {
                    if(in_array($key, $array_permisos_no_mostrar))
                        continue;
                    if(str_starts_with($key, 'javascript:'))
                        continue;
                    if($prevGrupo !== $generales['grupo']) {
                        if($prevGrupo !== null) {
                            echo "</ol></fieldset>";
                        }
                        $prevGrupo = $generales['grupo'];
                        echo "<fieldset><legend>$prevGrupo</legend><ol>";
                    }
                    $link = str_replace(' ', '_', $key);
                    echo strim("<li class='pointer' onclick=\"permisador._trae({url:'$link'})\">
                            <span class='ui-icon ui-icon-key permisador'></span> {$generales['label']}");
                }
                echo "</ol></fieldset>";
                ?>
            </ol>
        </div>
        <div>
            <h3>Permisos de Busqueda</h3>
            <ol class="permiso_generales">
                <?php $permisos_busqueda=ia_sqlArrayIndx(
                    "SELECT * FROM permiso_nombre where permiso_nombre Like 'puede_busqueda_rapida%' ORDER BY permiso_nombre") ;
                foreach($permisos_busqueda as $busqueda) {
                    $label = ucwords(str_ireplace(['_', 'puede'], ' ', $busqueda["permiso_nombre"]) );
                    $link = str_replace('puede_busqueda_rapida_', '', $busqueda["permiso_nombre"]) . '_busqueda.php';
                    echo strim("<li class='pointer' onclick=\"permisador._trae({url:'$link'})\">
                            <span class='ui-icon ui-icon-key permisador'></span> {$label}");
                }
                ?>
            </ol>
        </div>
    </div>
</div>
