<?php
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpRedundantOptionalArgumentInspection */

use JetBrains\PhpStorm\NoReturn;

include_once("../inc/config.php");
include_once("../inc/xlsxwriter.class.php");


class ExcelExporter {


    public function __construct() {
        $request = json_decode($_REQUEST['report'] ?? "", true);
        $this->reporteEstadoCuentaCash($request);
    }

    public function reporteEstadoCuentaCash($request) {
        $header = [
            'Fecha' => '@',
            'Withdrawal' => '#,##0.00;[Red]-#,##0.00;""',
            'Deposit' => '#,##0.00;[Red]-#,##0.00;""',
            'Balance' => '#,##0.00;[Red]-#,##0.00',
            'Hora' => '@'
        ];
        $col_options = [
          'freeze_rows' => 1,
          'widths' => [17.1, empty($request['hayWithdrawal']) ? 0 : 21.7, 21.7, 31],
          'font' => 'Calibri','font-size'=>14,'valign'=>'top', 'halign'=>'center', 'font-style' => 'bold',
        ];
        $row_options = [
          ['halign'=>'left','font' => 'Calibri','font-size'=>14, 'valign'=>'center', 'height'=>30, 'border' => 'left,right,top,bottom', 'border-color'=>'#000','border-style'=>'thin'],
          ['halign'=>'right', 'font-style' => 'bold','font' => 'Calibri','font-size'=>14,"color" => '#F00', 'valign'=>'center', 'height'=>30, 'border' => 'left,right,top,bottom', 'border-color'=>'#000','border-style'=>'thin'],
          ['halign'=>'right', 'font-style' => 'bold','font' => 'Calibri','font-size'=>14, 'valign'=>'center', 'height'=>30, 'border' => 'left,right,top,bottom', 'border-color'=>'#000','border-style'=>'thin'],
          ['halign'=>'right', 'font-style' => 'bold','font' => 'Calibri',"color" => empty($request['moneda']) ? "#0000FF" : "#15510C", 'font-size'=>15, 'valign'=>'center', 'height'=>30, 'border' => 'left,right,top,bottom', 'border-color'=>'#000','border-style'=>'thin'],
            ['halign'=>'left','font' => 'Calibri','font-size'=>14, 'valign'=>'center', 'height'=>30, 'border' => 'left,right,top,bottom', 'border-color'=>'#000','border-style'=>'thin'],
        ];
        $writer = new XLSXWriter();

        foreach(['orderd', 'reversed'] as $set) {
            $rows = $request[$set] ?? [];
            $first = reset($rows)['fecha'] ?? 'Sheet1';
            $last = end($rows)['fecha'] ?? '';
            if($first === $last)
                $last = '';
            $sheetName = $set[0] . " " . $first . ( empty($last) ? '' : " al $last") ;
            $writer->writeSheetHeader($sheetName, $header, $col_options );
            foreach($rows as $row) {
                $writer->writeSheetRow($sheetName,
                  [
                    'Fecha' => str_replace(["-20", "-"], ["/", "/"], $row['fecha']),
                    'Withdrawal' => $row['withdrawal'],
                    'Deposit' => $row['deposit'],
                    'Balance' => $row['balance'],
                    'Hora' => $row['hora'],
                  ],
                  $row_options);
            }
        }
        $this->download($writer,  "Excel Cash " . ($request['cuenta'] ?? "") . " " . ($request['moneda'] ?? '') );
    }


    protected function download($writer, $fileName = 'export.xlsx') {
        $fileName = trim(
          XLSXWriter::sanitize_filename(
          str_replace([".xls", ".xlsx"], "",  $fileName)
        ) . "_" . Date('Y_m_d') . ".xlsx");

        header('Content-Disposition: attachment; filename="'. $fileName .'"');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        $writer->writeToStdOut();
        ia_errores_a_dime();
        die();
    }

}
$excelExporter = new ExcelExporter();

