<?php
    //marzo2025
    require_once('../../inc/config.php');
    session_write_close();
    global $gIAParametros;
    global $gIAsql;
    $gIAsql['trace'] = true;

    $usuario = $_SESSION['usuario'];
    $usuario_id = $_SESSION['usuario_id'];
	$accion = param("accion");
    $fechalimite = '';
    $tabla = 'banco_cuenta_mov';
    $tablav = 'mov_verificado';
    if(param("banco_cuenta_id"))
        $bcnombre = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = "  . strit(param("banco_cuenta_id")));
    else
        $bcnombre = 'CUENTA NO ESPECIFICADA';

	$arrBCMacciones = array (	"Status"	=>	"",
                                "accion"	=>	$accion,
                                "numMovimientosModificados"	=>	"",
                                "Error"	=>	"",
                                "BancoCuentaMov" => array());

    $now = date('Y-m-d H:i:s');

    //Calculamos las fechas límites pasado y futuro para la captura.
    $fechaLimitePasadoPar = $gIAParametros['fecha_limite_atras_captura_banco']; //fecha límite pasada;
    $tiempoLimitePasadoPar = $gIAParametros['tiempo_limite_atras_captura_banco']; //tiempo limite pasado (días);
    //$tiempoLimitePasadoPar--;

    $fechaLimiteFuturoPar = $gIAParametros['fecha_limite_adelante_captura_banco']; //fecha límite futuro;
    $tiempoLimiteFuturoPar = $gIAParametros['tiempo_limite_adelante_captura_banco']; //tiempo limite futuro (días);
    //$tiempoLimiteFuturoPar++;

    //Primero la fecha pasada. Leemos el parámetro de fecha pasada, leemos el número de días límite hacía atrás y que sea mayor ése usamos.
    $fechaLimitePasadoPar = new DateTime($fechaLimitePasadoPar);
    $fechaMenosTLP = new DateTime(date('Y-m-d'));

    $fechaMenosTLP->modify("-$tiempoLimitePasadoPar days");

    $flpReal = '';
    if($fechaMenosTLP > $fechaLimitePasadoPar)
        $flpReal = $fechaMenosTLP;//->format('Y-m-d');
    else
    {
        //$fechaLimitePasadoPar->modify('-1 days');
        $flpReal = $fechaLimitePasadoPar;//->format('Y-m-d');
    }

    //Fecha futura. Leemos el parámetro de fecha futura, leemos el número de días límite hacía adelante y que sea menor ése usamos.
    $fechaLimiteFuturoPar = new DateTime($fechaLimiteFuturoPar);
    $fechaMasTLF = new DateTime(date('Y-m-d'));

    $fechaMasTLF->modify("+$tiempoLimiteFuturoPar days");

    $flfReal = '';
    if($fechaMasTLF < $fechaLimiteFuturoPar)
        $flfReal = $fechaMasTLF;//->format('Y-m-d');
    else
    {
        //$fechaLimiteFuturoPar->modify('+1 days');
        $flfReal = $fechaLimiteFuturoPar;//->format('Y-m-d');
    }

    if(usuarioTipoRony($_SESSION['usuario_id']))
    {
        $flfReal = new DateTime('2099-01-01');
        $flpReal = new DateTime('1900-01-01');
    }

    switch($accion)
    {
        case 'Bloquear':


            $fechalimite = param("fechalimite");
            $banco_cuenta_id = param("banco_cuenta_id");
            if($fechalimite == '')
            {
                $arrBCMacciones['Error'] = 'La fecha es inválida.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            if($banco_cuenta_id == '' || $banco_cuenta_id == '0' || $banco_cuenta_id == 0)
            {
                $arrBCMacciones['Error'] = 'La cuenta del banco es inválida.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            if(!usuarioTipoRony($_SESSION['usuario_id']))
            {
                $arrBCMacciones['Error'] = 'No tiene permiso para esta acción.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            $fechalimite = date('Y-m-d', strtotime($fechalimite));
            $nowmodbloq = date('Y-m-d H:i:s');

            $bcmbloqsql = array();

            $bcmbloqsql[] = "UPDATE $tabla SET puede_editar = 'No', verificado = 'Si', ultimo_cambio = '$nowmodbloq', ultimo_cambio_por = '$usuario' WHERE fecha <= ". strit($fechalimite) ." AND banco_cuenta_id = ". strit($banco_cuenta_id);
            $bcmbloqsql[] = "UPDATE $tablav SET puede_editar = 'No', verificado = 'Si', ultimo_cambio = '$nowmodbloq', ultimo_cambio_por = '$usuario' WHERE fecha <= ". strit($fechalimite) ." AND banco_cuenta_id = ". strit($banco_cuenta_id);
            if(!ia_transaction($bcmbloqsql,'Bloquear Movimientos'))
            {

                $arrBCMacciones['Error'] = 'Bloqueo exitoso.';
                $arrBCMacciones['Status'] = 'OK';
                $arrBCMacciones['numMovimientosModificados'] = affected_rows();
                Logme($tabla, '', $usuario, '111', "Cuenta: <b>$bcnombre. Bloquea los movimientos</b> desde la fecha <b>$fechalimite</b> hacia atras.");

                //Aqui debe llevar codigo para el Log...
            }
            //echo print_r($bcmbloqsql, true);

        break;

        case 'EliminarMasivamente':

            //$gIAsql['trace']=true;

            $fechalimite = param("fechalimite");
            $banco_cuenta_id = param("banco_cuenta_id");

            $Original = param("ECO");

            if($Original != 'NO')
            {
                $bcmid_name = 'banco_cuenta_mov_id';
                $bcmvid_name = 'mov_verificado_id';
                $tbl = $tabla;
                $tblv = $tablav;
                $Original = true;
            }
            else
            {
                $bcmvid_name = 'banco_cuenta_mov_id';
                $bcmid_name = 'mov_verificado_id';
                $tbl = $tablav;
                $tblv = $tabla;
                $Original = false;
            }

            if($fechalimite == '')
            {
                $arrBCMacciones['Error'] = 'La fecha es inválida.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }
            if($banco_cuenta_id == '' || $banco_cuenta_id == '0' || $banco_cuenta_id == 0)
            {
                $arrBCMacciones['Error'] = 'La cuenta del banco es inválida.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }
            $fechalimite = date('Y-m-d', strtotime($fechalimite));
            $nowem = date('Y-m-d H:i:s');
            $oknumop = 3; //En principio sólo hay que borrar un solo movimiento y actualizar el saldo de la cuenta.
            $ok = 0;


            $ultimobcmid = ia_singleread("SELECT $bcmid_name FROM $tbl WHERE banco_cuenta_id=". strit($banco_cuenta_id) ." AND fecha <= ". strit($fechalimite) ." ORDER BY fecha DESC LIMIT 1");
            $ultimobcmsaldo = CalculaBancoCuentaSaldodesdeunMovimiento($banco_cuenta_id, $ultimobcmid, $Original); //Codigo de tabla de verificacion...
            $ultimobcmes = '';
            $ultimobcmdonde = '';
            if($ultimobcmsaldo >= 0)
            {    $ultimobcmes = 'Deposito'; $ultimobcmdonde = 'deposit';}
            else
            {    $ultimobcmes = 'Retiro'; $ultimobcmdonde = 'withdrawal';}


            $cmnt = 'Eliminación Masiva de Mov Bancario y generacion de un mov con saldo resumido.';
            ia_begin($cmnt);


            $bcmemsql = "DELETE FROM $tbl WHERE fecha <= ". strit($fechalimite) ." AND banco_cuenta_id = ". strit($banco_cuenta_id) ." AND $bcmid_name != ". strit($ultimobcmid);
            if(!ia_query($bcmemsql,true,false))
                $ok++;
            $arrBCMacciones['numMovimientosModificados'] = affected_rows();
            if(!ia_query("DELETE FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_id = ". strit($ultimobcmid) ,true,false)) //Borro el banco_cuenta_mov_link.
                $ok++;

            $bcm_sql = "UPDATE $tbl SET es = '$ultimobcmes', link_vale = 'ND', withdrawal = '0', cash = '0', deposit = '0', usado = '0', $ultimobcmdonde = '$ultimobcmsaldo', remarks = 'Saldo resumido de los movimientos anteriores eliminados.', ultimo_cambio = '$nowem', ultimo_cambio_por = '$usuario' WHERE $bcmid_name = '$ultimobcmid'";
            if(!ia_query($bcm_sql,true,false)) //Actualizo al banco_cuenta_mov, le resto el Quantity del Usado.
                $ok++;

            //echo "<pre>".print_r($gIAsql,true)."</pre>";

            if($ok == $oknumop)
            {
                //Todas las trasacciones fueron exitosas.
                if(!ia_commit($cmnt))
                {
                    $arrBCMacciones['Error'] = 'Eliminación exitosa.';
                    $arrBCMacciones['Status'] = 'OK';

                    Logme($tbl, $ultimobcmid, $usuario, '113', "Cuenta: <b>$bcnombre.</b> <li><b>Elimina masivamente</b> movimientos bancarios desde la fecha <b>$fechalimite</b> hacia atras.<li>Un movimiento queda con un saldo resumido de <b>". echonf($ultimobcmsaldo, true) ."</b> en <b>$ultimobcmdonde</b>. ID: $ultimobcmid.");
                    ia_query("UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($banco_cuenta_id),true,false);
                }
                else
                {
                    ia_errores_a_dime();
                    $arrBCMacciones['Error'] = 'Error al eliminar los movimientos. En el commit ocurri&oacute; un error.';
                    $arrBCMacciones['Status'] = 'Error';
                    $arrBCMacciones['numMovimientosModificados'] = '0';
                }
            }
            else
            {
                ia_rollback($cmnt);
                ia_errores_a_dime();
                $arrBCMacciones['Error'] = 'Error al eliminar los movimientos. En alguna instrucción de SQL ocurri&oacute; un error.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
            }
            /*$myFile = "../envioemmov.txt";
        	$fh = fopen($myFile, 'w') or die("can't open file");
        	$bleh = ($_SERVER["REQUEST_METHOD"] == 'POST') ? $_POST : $_GET;
        	fwrite($fh, json_encode($bleh) . $bcm_sql);
        	fclose($fh);*/

        break;

        case 'Leer':
           
            
            $banco_cuenta_mov_id = param("banco_cuenta_mov_id");

            $Original = param("Original");
            //$oo = $Original;
            if($Original != 'NO')
                $Original = true;
            else
                $Original = false;

            if($banco_cuenta_mov_id == '' || strlen($banco_cuenta_mov_id) < 32)
            {
                $arrBCMacciones['Error'] = 'El ID del movimiento bancario es inválido.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            $BancoCuentaMov = new BancoCuentaMov;
            $BancoCuentaMov->Original = $Original;
	        if(!$BancoCuentaMov->leeBancoCuentaMov($banco_cuenta_mov_id))
            {
                $arrBCMacciones['Error'] = 'El movimiento bancario no existe.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
            }
            else
            {
                $arrBCMacciones['Error'] = 'Lectura del movimiento bancario exitoso.';
                $arrBCMacciones['Status'] = 'OK';
                $arrBCMacciones['BancoCuentaMov'] = get_object_vars($BancoCuentaMov);
            }

            /*$myFile = "../enviomodmovaccleer.txt";
        			$fh = fopen($myFile, 'w') or die("can't open file");
        			$bleh = 'id: ' . $banco_cuenta_mov_id . "\r\n\r\n" . 'Original: ' . $Original;
        			fwrite($fh, $bleh);
        			fclose($fh);*/

        break;

        case 'Modificar':

            $BancoCuentaMov = new BancoCuentaMov;

            if(param("Origen") == 'form')
            {
                $JSONBancoCuentaMov = param("JSONBancoCuentaMov");
                $JSONBancoCuentaMov = json_decode($JSONBancoCuentaMov);

                ia_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");

            }
            else
            {
                $PARAMS = ($_SERVER["REQUEST_METHOD"] == 'POST') ? $_POST : $_GET;
                $bcmovparams = array();

                foreach ( $PARAMS as $key=>$value )
                    $bcmovparams[$key] = param($key);

                $Original = $bcmovparams["Original"];
                $SuperUser = usuarioTipoRony($_SESSION['usuario_id']) ? true:false;

                if(!PasalaVerificacion($bcmovparams))
                    break;

                $bcmovparams = json_encode($bcmovparams);
                $JSONBancoCuentaMov = json_decode($bcmovparams);

                //$JSONBancoCuentaMov->banco_cuenta_mov_id = $JSONBancoCuentaMov->banco_cuenta_mov_id;

                if($Original == 'SI')
                    $Original = true;
                else if($Original == 'NO')
                    $Original = false;

                $BancoCuentaMov->Original = $Original;
            }

            $banco_cuenta_mov_id = property_exists($JSONBancoCuentaMov,'banco_cuenta_mov_id')?$JSONBancoCuentaMov->banco_cuenta_mov_id:(property_exists($JSONBancoCuentaMov,'mov_verificado_id')?$JSONBancoCuentaMov->mov_verificado_id:null);

            if($banco_cuenta_mov_id == '' || strlen($banco_cuenta_mov_id) < 32)
            {
                $arrBCMacciones['Error'] = 'El ID del movimiento bancario es inválido.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }
   

   	        if(!$BancoCuentaMov->leeBancoCuentaMov($banco_cuenta_mov_id))
            {
                $arrBCMacciones['Error'] = 'El movimiento bancario no existe.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            if(empty($BancoCuentaMov->banco_cuenta_id)) {
                $arrBCMacciones['Error'] = 'banco_cuenta_id no llego.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;    
            }

            $puede = puedeCuentaBancaria('',$BancoCuentaMov->banco_cuenta_id,'',false,$Original?'SI':'NO');
            if($puede['quePuede'] === 'Nada' || $puede['quePuede'] === 'Consultar' || $puede['quePuede'] === 'Capturar') {
                $arrBCMacciones['Error'] = 'Sin Permiso.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }


            $JSONBancoCuentaMov->cash = property_exists($JSONBancoCuentaMov, 'cash') ? limpiaCantidad($JSONBancoCuentaMov->cash) : $BancoCuentaMov->cash;
            $JSONBancoCuentaMov->deposit = property_exists($JSONBancoCuentaMov, 'deposit') ? limpiaCantidad($JSONBancoCuentaMov->deposit) : $BancoCuentaMov->deposit;
            $JSONBancoCuentaMov->withdrawal = property_exists($JSONBancoCuentaMov, 'withdrawal') ? limpiaCantidad($JSONBancoCuentaMov->withdrawal) : $BancoCuentaMov->withdrawal;

            $quantity = $JSONBancoCuentaMov->cash + $JSONBancoCuentaMov->deposit - $JSONBancoCuentaMov->withdrawal;

            if(abs($quantity) < $BancoCuentaMov->usado)
    		{
                $arrBCMacciones['Status'] = 'SaveERRORUSADO';
                $arrBCMacciones['Error'] = 'La cantidad del movimiento no puede ser menor a la cantidad usada por los links. Por favor, revisa Cash, Deposit y Withdrawal.';
                break;
            }

            $BancoCuentaMov->cash = property_exists($JSONBancoCuentaMov, 'cash') ? limpiaCantidad($JSONBancoCuentaMov->cash) : $BancoCuentaMov->cash;
            $BancoCuentaMov->deposit = property_exists($JSONBancoCuentaMov, 'deposit') ? limpiaCantidad($JSONBancoCuentaMov->deposit) : $BancoCuentaMov->deposit;
            $BancoCuentaMov->withdrawal = property_exists($JSONBancoCuentaMov, 'withdrawal') ? limpiaCantidad($JSONBancoCuentaMov->withdrawal) : $BancoCuentaMov->withdrawal;
            $BancoCuentaMov->es = property_exists($JSONBancoCuentaMov, 'es') ? $JSONBancoCuentaMov->es : $BancoCuentaMov->es;
            $BancoCuentaMov->banco_mov_tipo_id = property_exists($JSONBancoCuentaMov, 'banco_mov_tipo_id') ? $JSONBancoCuentaMov->banco_mov_tipo_id : $BancoCuentaMov->banco_mov_tipo_id;
            $BancoCuentaMov->numero = property_exists($JSONBancoCuentaMov, 'numero') ? addslashes($JSONBancoCuentaMov->numero) : $BancoCuentaMov->numero;
            $BancoCuentaMov->ultimo_cambio_por = $usuario;
            $BancoCuentaMov->idex100 = limpiaCantidad($JSONBancoCuentaMov->idex100);
            $BancoCuentaMov->ivacobradox100 = limpiaCantidad($JSONBancoCuentaMov->ivacobradox100);
            $BancoCuentaMov->factura = addslashes($JSONBancoCuentaMov->factura);
            //echo "<pre>".print_r($BancoCuentaMov, true)."</pre>";
            //Por error en el Jqgrid
            if(!property_exists($JSONBancoCuentaMov,'remarks'))
                $JSONBancoCuentaMov->remarks = $BancoCuentaMov->remarks;
            $BancoCuentaMov->remarks = addslashes(preparaRemarksBCM($banco_cuenta_mov_id, $JSONBancoCuentaMov->remarks, "", "", $remarks_ok, true, false, false));
            $BancoCuentaMov->puede_editar = addslashes($JSONBancoCuentaMov->puede_editar);
            if(!property_exists($JSONBancoCuentaMov,'link_vale'))
                $JSONBancoCuentaMov->link_vale = $BancoCuentaMov->link_vale;
            if($BancoCuentaMov->link_vale != $JSONBancoCuentaMov->link_vale)
            {
                $BancoCuentaMov->remarks .= "<li>$usuario cambi&oacute status a $JSONBancoCuentaMov->link_vale";
            }
            $BancoCuentaMov->link_vale = $JSONBancoCuentaMov->link_vale;


            if($BancoCuentaMov->verificado == $JSONBancoCuentaMov->verificado)
            {
                if($BancoCuentaMov->guardaBancoCuentaMov($banco_cuenta_mov_id))
                    $arrBCMacciones['Status'] = 'OK';
                else
                {
                    $arrBCMacciones['Error'] = 'Ocurrió un error en la actualización.';
                    $arrBCMacciones['Status'] = 'Error';
                    $arrBCMacciones['numMovimientosModificados'] = '0';
                }
            }
            else
            {
                if($BancoCuentaMov->guardaBancoCuentaMov($banco_cuenta_mov_id, true))
                    $arrBCMacciones['Status'] = 'OK';
                else
                {
                    $arrBCMacciones['Error'] = 'Ocurrió un error en la actualización.';
                    $arrBCMacciones['Status'] = 'Error';
                    $arrBCMacciones['numMovimientosModificados'] = '0';
                }
            }
            $arrBCMacciones['BancoCuentaMov'] = get_object_vars($BancoCuentaMov);


            ia_query("UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($BancoCuentaMov->banco_cuenta_id),true,false);
            /*$myFile = "../enviomodmovacciones.txt";
        			$fh = fopen($myFile, 'w') or die("can't open file");
        			$bleh = json_encode($JSONBancoCuentaMov) . "\r\n\r\n" . 'lm_tienda_id: ' . $lm_tienda_id . "\r\n\r\n" . 'lm_docto: ' . $lm_docto;
        			fwrite($fh, $bleh);
        			fclose($fh);*/

        break;

        case 'RompeLink':


            $bcml_id = param("banco_cuenta_mov_link_id");

            $cmnt = 'Rotura de Link entre banco_cuenta_mov y algún documento.';

            //Modificamos para saber si borramos a cuenta o sólo rompemos link.

            $bcml_arr = ia_singleton("SELECT * FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_link_id='$bcml_id'");


            if(is_array($bcml_arr) && !empty($bcml_arr) && array_key_exists('link_to',$bcml_arr) && ($bcml_arr['link_to'] == 'cheque_pago' || $bcml_arr['link_to'] == 'pagare_pago'))
            {
                borraDocumentoPago(str_replace('_pago','',$bcml_arr['link_to']),$bcml_arr['link'],'SI');
                $arrBCMacciones['Error'] = 'Rotura de link exitosa.';
                $arrBCMacciones['Status'] = 'OK';
            }
            else
            {
                if(is_array($bcml_arr) && !empty($bcml_arr) && array_key_exists('link_to',$bcml_arr) && $bcml_arr['link_to'] == 'vale')
                {
                    $vale_usos=ia_singleread("SELECT COUNT(vale_uso_id) FROM vale_uso WHERE vale_id=".strit($bcml_arr['link']));
                    if($vale_usos > 0)
                    {
                        $arrBCMacciones['Error'] = 'No se puede <strong>romper el link</strong> de un <strong>Vale que ya se ha usado</strong>.';
                        $arrBCMacciones['Status'] = 'Error';
                        break;
                    }
                }

                ia_begin($cmnt);

                if($rlb_arr = RompeLinkBancario($bcml_id, $usuario))
                {
                    if($rlb_arr['acta_tbl'] == 'banco_cuenta_mov')
                    {
                        $sql="UPDATE banco_cuenta_trans SET status='CANCELADA', banco_cuenta_mov_link_id='', activo='No', alta_por='$usuario', alta_db='$now',
                referencia = CONCAT('<li>TRANSFERENCIA ENTRE CUENTAS BANCARIAS CANCELADA POR <strong>$usuario</strong>.<br/>',referencia) WHERE banco_cuenta_mov_link_id=".strit($bcml_id);
                        ia_query($sql);
                    }
                    //Todas las trasacciones fueron exitosas.
                    if(!ia_commit($cmnt))
                    {
                        $Quantity = $rlb_arr['Quantity']; $acta_tbl = $rlb_arr['acta_tbl']; $bcm_id = $rlb_arr['bcm_id'];
                        $bcnombre = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = "  . strit($rlb_arr['banco_cuenta_id']));
                        Logme('banco_cuenta_mov', $bcm_id, $usuario, '110', "Cuenta: <b>$bcnombre. Rompe link</b> entre mov. bancario y <b>$acta_tbl</b> por la cantidad de <b>". echonf($Quantity, true) ."</b>.");
                        if($rlb_arr['actapadre'] != '') //Si hubo un movimiento en en documento
                            Logme($rlb_arr['actapadre'], $rlb_arr['actapadre_id'], $usuario, '2', "Actualiza <b>". $rlb_arr['actapadre'] ."</b> en total_payments por la cantidad de <b>". echonf($Quantity, true) ."</b>, porque se rompe link desde Estado de Cuenta.");
                        if($rlb_arr['acta'] != '') //Si hubo un movimiento en en documento
                            Logme($rlb_arr['acta'], $rlb_arr['actapadre_id'], $usuario, '3', "Borra un a cuenta por la cantidad de <b>". echonf($Quantity, true) ."</b>, porque se rompe link desde Estado de Cuenta.");
                        if($rlb_arr['cuentat_id'] != '') //Si hubo un movimiento en en documento
                            Logme('cuentat', $rlb_arr['cuentat_id'], $usuario, '2', "Se cancela el movimiento por la cantidad de <b>". echonf($Quantity, true) ."</b>, porque se rompe link desde Estado de Cuenta. cuentat_mov_id: <b>". $rlb_arr['cuentat_mov'] ."</b>");
                        $arrBCMacciones['Error'] = 'Rotura de link exitosa.';
                        $arrBCMacciones['Status'] = 'OK';
                        ia_query("UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($rlb_arr['banco_cuenta_id']),true,false);

                        //Cancelamos el vale.
                        if($bcml_arr['link_to'] == 'vale')
                        {
                            cancelaVale($rlb_arr['actapadre_id']);
                        }
                    }
                    else
                    {
                        $arrBCMacciones['Error'] = 'Error al romper el link. En el commit ocurri&oacute; un error.';
                        $arrBCMacciones['Status'] = 'Error';
                    }
                }
                else
                {
                    ia_rollback($cmnt);
                    $arrBCMacciones['Error'] = 'Error al romper el link. En alguna instrucción de SQL ocurri&oacute; un error. ' . $ok .' / '. $oknumop;
                    $arrBCMacciones['Status'] = 'Error';
                }
            }
        break;

        case 'Insertar':
            $JSONBancoCuentaMov = param("JSONBancoCuentaMov");
            $Original = param("Original");
            //$oo = $Original;
            if($Original == 'SI')
                $Original = true;
            else if($Original == 'NO')
                $Original = false;

        	$JSONBancoCuentaMov = json_decode($JSONBancoCuentaMov);
            $now = date('Y-m-d H:i:s');
            $nowMoment = new DateTime(date('H:i:s'));
            $nummaxMovimientos = sizeof($JSONBancoCuentaMov);
        	$BancoCuentaMov = false;

            $fecha_mas_antigua = "";


            /*$myFile = "../envioinsertmov.txt";
        			$fh = fopen($myFile, 'w') or die("can't open file");
        			$bleh = 'JSONBancoCuentaMov=' . json_encode($JSONBancoCuentaMov) . '&accion=' . $accion . '&Original=SI';
        			fwrite($fh, $bleh);
        			fclose($fh);*/

            $numMovimientosEnviados = 0;
            $numMovimientosGuardados = 0;
            $numMovimientosVerificados = 0;

            $arrBCMacciones['numMovimientosVerificados'] = $numMovimientosVerificados;

            //Revisión de fechas antes de insertar los nuevos movimientos.
            if(!empty($JSONBancoCuentaMov) && is_array($JSONBancoCuentaMov)) foreach($JSONBancoCuentaMov as $k=>$vMov)
            {

                if(empty($vMov->banco_cuenta_id))
                {
                    unset($JSONBancoCuentaMov[$k]);
                    continue;
                }

                $dateMov = new DateTime(date('Y-m-d', strtotime($vMov->fecha)));

                if($dateMov > $flfReal)
                {
                    $JSONBancoCuentaMov[$k]->fecha = date('Y-m-d', strtotime($now));
                    $JSONBancoCuentaMov[$k]->remarks .= "LA FECHA DEL MOVIMIENTO ERA MAYOR AL LÍMITE PERMITIDO, SE CORRIGIÓ.<br/>";
                    continue;
                }

                if($dateMov < $flpReal)
                {
                    $JSONBancoCuentaMov[$k]->fecha = date('Y-m-d', strtotime($now));
                    $JSONBancoCuentaMov[$k]->remarks .= "LA FECHA DEL MOVIMIENTO ERA MENOR AL LÍMITE PERMITIDO, SE CORRIGIÓ.<br/>";
                    continue;
                }
            }
            $bc_id = 0;
            $esRony = usuarioTipoRony(uid: $usuario_id, real_rony: true);
            $esusuarioTipoRony = usuarioTipoRony(uid: $usuario_id, real_rony: false);
            // dd_($JSONBancoCuentaMov);
            /////////////////////////////////////////////////////////////
            if(!empty($JSONBancoCuentaMov) && is_array($JSONBancoCuentaMov))
            foreach($JSONBancoCuentaMov as $i=>$vMov)
            {
                //if(($vMov->fecha != '') && (($vMov->cash != '') || ($vMov->deposit != '') || ($vMov->withdrawal != '')))
                if(!empty($vMov->fecha) && (!empty($vMov->cash) || !empty($vMov->deposit) || !empty($vMov->withdrawal)))
            	{
                    $numMovimientosEnviados++;
                    $BancoCuentaMov = new BancoCuentaMov;

                    if($Original)
                    {
                        $BancoCuentaMov->banco_cuenta_mov_id = ia_guid();
                        $BancoCuentaMov->link_vale = $vMov->link_vale;
                    }
                    else
                    {
                        $BancoCuentaMov->Original = false;
                        $BancoCuentaMov->mov_verificado_id = ia_guid();
                    }
                    $nowMoment->modify("+1 seconds");
                	$bc_id = $BancoCuentaMov->banco_cuenta_id = addslashes($vMov->banco_cuenta_id);
                    $fecha_movimiento = $vMov->fecha;
                	$BancoCuentaMov->fecha = addslashes($vMov->fecha)." ".$nowMoment->format('H:i:s');
                	$BancoCuentaMov->es = addslashes($vMov->es);
                	$BancoCuentaMov->cash = addslashes($vMov->cash);
                    $BancoCuentaMov->deposit = addslashes($vMov->deposit);
                    $BancoCuentaMov->withdrawal = addslashes($vMov->withdrawal);
                	$BancoCuentaMov->banco_mov_tipo_id = addslashes($vMov->banco_mov_tipo_id);
                	$BancoCuentaMov->numero = addslashes($vMov->numero);

                    $BancoCuentaMov->banco_id = ia_singleread("SELECT `banco_id` FROM `banco_cuenta` WHERE `banco_cuenta_id` = " . strit($vMov->banco_cuenta_id));

                    $BancoCuentaMov->idex100 = addslashes($vMov->idex100);
                	$BancoCuentaMov->remarks = addslashes($vMov->remarks);
                    $BancoCuentaMov->alta_db = date('Y-m-d') ." ".$nowMoment->format('H:i:s');
                	$BancoCuentaMov->alta_por = $usuario;
                    $BancoCuentaMov->alta_tipo = 'manual';

                    $BancoCuentaMov->fecha_hora = addslashes($vMov->fecha_hora??'');
                    $BancoCuentaMov->puede_borrar = 'Si';

                    $BancoCuentaMov->tiempo_restante_para_borrar = $gIAParametros['tiempo_limite_para_borrar_movimientos_banco'].' min';
                    // Agregar numero_original
                    $BancoCuentaMov->numero_original = addslashes($vMov->numero_original??'');

                    $bancos_capturan_withdrawals = array_filter(explode(",", $gIAParametros['banco_cuenta_capturar_withdrawals']??''));
                    $capturar_withdrawals = false;
                    if ($esusuarioTipoRony || in_array($bc_id, $bancos_capturan_withdrawals))
                        $capturar_withdrawals = true;

                    if (strcasecmp($BancoCuentaMov->es, 'Retiro') == 0 && !$capturar_withdrawals) {
                        continue;
                    }

                    $BancoCuentaMov->calculaCamposAutomaticos();


                    // proceso para calcular alta_db atraves del fecha_hora
                    if (strcasecmp($BancoCuentaMov->es, 'Retiro') == 0) {
                        $BancoCuentaMov->link_vale = 'ND';
                    }
                    if (empty($BancoCuentaMov->fecha_hora)) { // si la hora viene vacia, buscamos el ultimo movimiento de ese día y le aumentamos 1 seg, se convierte en nuestro alta_db
                        // buscamos el ultimo movimiento del dia;
                        $to_time = strtotime($fecha_movimiento);
                        $date_movi = date('Y-m-d', $to_time);
                        $fecha_mov_moment = new DateTime($date_movi);
                        $fecha_mov_moment->modify('+1 day');
                        $next_day = $fecha_mov_moment->format('Y-m-d');
                        $select = "SELECT banco_cuenta_mov_id, banco_cuenta_id, fecha, es, deposit, withdrawal, alta_db, alta_por, alta_db_real FROM banco_cuenta_mov WHERE banco_cuenta_id = ".strit($bc_id)." AND fecha BETWEEN '$date_movi' AND '$next_day' ORDER BY fecha DESC LIMIT 1";
                        $ultimo_registro = ia_singleton($select);

                        $ultima_fecha = $ultimo_registro['fecha'] ?? $fecha_movimiento;
                        $nowMoment_2 = new DateTime($ultima_fecha);
                        $nowMoment_2->modify("+1 seconds");
                        $nueva_fecha = $nowMoment_2->format('Y-m-d H:i:s');

                        $BancoCuentaMov->fecha = $nueva_fecha;

                    }
                    else { // si la hora no está vacia, ponemos la hora como timestamp de alta_db
                        $BancoCuentaMov->fecha = $fecha_movimiento ." ". $BancoCuentaMov->fecha_hora;
                    }

                    //VCA PONER ND 22-12-2020 PARA DEPÓSITOS SOLAMENTE
                    // global $gIAParametros;
                    //Ahora revisamos si la cuenta bancaria está en los párametros del sistema

                    if (strcasecmp($BancoCuentaMov->es, 'Deposito') == 0) {
                        $cpnd_csv = $gIAParametros['banco_cuenta_poner_deposito_ND'];
                        $cpnd_arr = explode(",", $cpnd_csv);
                        $cpnd_arr = array_flip($cpnd_arr);


                        if (array_key_exists($bc_id, $cpnd_arr))
                            $BancoCuentaMov->link_vale = 'ND';

                        // Set para valor link_vale dependiendo el estado que tenga el banco_cuenta para depostios a mano
                        $bc_q_a_mano = explode(",", $gIAParametros['banco_cuenta_poner_deposito_Q_a_mano'] ?? '');
                        $bc_nd_a_mano = explode(",", $gIAParametros['banco_cuenta_poner_deposito_ND_a_mano'] ?? '');

                        if (in_array($bc_id, $bc_q_a_mano))
                            $BancoCuentaMov->link_vale = 'Q';


                        if (in_array($bc_id, $bc_nd_a_mano))
                            $BancoCuentaMov->link_vale = 'ND';
                    }

                    //Ph. 26 Marzo 2025
                    $banco_cuenta_permite_inversion_manual = explode(",", $gIAParametros['banco_cuenta_permite_inversion_manual'] ?? '');
                    if (in_array($bc_id, $banco_cuenta_permite_inversion_manual)) {// I have to code permissions and shit
                        $BancoCuentaMov_link_vale = $BancoCuentaMov->assignContextualLinkVale($BancoCuentaMov->remarks, $BancoCuentaMov->banco_mov_tipo_id);

                        $BancoCuentaMov->link_vale = $BancoCuentaMov_link_vale ?? $BancoCuentaMov->link_vale;

                        if (empty($BancoCuentaMov->link_vale) && strcasecmp($BancoCuentaMov->es, 'Deposito') == 0) {
                            // Assign 'link_vale' if it is not set

                            $cpnd_csv = $gIAParametros['banco_cuenta_poner_deposito_ND'];
                            $cpnd_arr = explode(",", $cpnd_csv);
                            $cpnd_arr = array_flip($cpnd_arr);


                            if (array_key_exists($bc_id, $cpnd_arr))
                                $BancoCuentaMov->link_vale = 'ND';

                        }
                    }

                    // dd_($BancoCuentaMov->es, $BancoCuentaMov->remarks, $BancoCuentaMov->alta_tipo, $BancoCuentaMov->plantilla_id, strcasecmp($BancoCuentaMov->es, 'Retiro'));
                    if($BancoCuentaMov->insertaBancoCuentaMov(true, false, true))
                    {
                        $arrBCMacciones['Status'] = 'InsertOK';
                        $arrBCMacciones['numMovimientosEnviados'] = $numMovimientosEnviados;
                        $arrBCMacciones['numMovimientosGuardados'] = ++$numMovimientosGuardados;

                        //Extra: Actualizamos el registro de banco_cuenta y ponemos en ultima_conciliacion NOW();
                        ia_query("UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($BancoCuentaMov->banco_cuenta_id),true,false);
                        if($Original)
                        {
                            if($BancoCuentaMov->mov_verificado_id != '')
                                $arrBCMacciones['numMovimientosVerificados'] = ++$numMovimientosVerificados;
                        }
                        else
                        {
                            if($BancoCuentaMov->banco_cuenta_mov_id != '')
                                $arrBCMacciones['numMovimientosVerificados'] = ++$numMovimientosVerificados;
                        }
                        // aplicamos la plantilla en retiro si es que tuviera
                        if (strcasecmp($BancoCuentaMov->es, 'Retiro') == 0 && !empty($BancoCuentaMov->plantilla_id)) {
                            app_plantilla_withdrawals_de_banco::apply_template($BancoCuentaMov->plantilla_id, $BancoCuentaMov->banco_cuenta_mov_id, (array)$BancoCuentaMov, true, "", true);
                            @async_ws_update_plantillas_withdrawals();
                        }
                        $fecha_mas_antigua = empty($fecha_mas_antigua) || strtotime($BancoCuentaMov->fecha) < strtotime($fecha_mas_antigua) ? $BancoCuentaMov->fecha : $fecha_mas_antigua;
                    }
                    else
                    {
                        $arrBCMacciones['Status'] = 'InsertERROR';
                        $arrBCMacciones['numMovimientosEnviados'] = $numMovimientosEnviados;
                        $arrBCMacciones['numMovimientosGuardados'] = $numMovimientosGuardados;
                        $arrBCMacciones['numMovimientosVerificados'] = $numMovimientosVerificados;
                    }
                }
            }
//            arreglaLinksPendientes("ACTUALIZAR EL ESTADO DE CUENTA");

            $banco_cuenta_mov_bingo = findReliableBankTransanctionforBalance(banco_cuenta_id: $bc_id, fecha_referencia: $fecha_mas_antigua);
            updateBalanceonBankAccount(banco_cuenta_mov_reference: $banco_cuenta_mov_bingo, debug: $debug = false);
            //            $arrBCMacciones['findReliableBankTransanctionforBalance'] = "<pre>banco_cuenta_mov_bingo: ".print_r($banco_cuenta_mov_bingo /*$el_array de lo que sea*/,true)."</pre>";

            $sql = array();

            $sql[] = "CALL actualiza_banco_cuenta_saldos('$bc_id')";

            ia_transaction($sql);

            async_actualizaIngresos();
            @async_ws_actualizaGastosPorRevisar();
            ia_errores_a_dime();
            file_debug_reporte();
        break;

        case 'LeeraCuentasResumido':

            $bcm_id = $banco_cuenta_mov_id = param("banco_cuenta_mov_id");

            $Original = param("Original");
            //$oo = $Original;
            if($Original == 'SI')
                $Original = true;
            else if($Original == 'NO')
                $Original = false;
            else
                $Original = true;

            if($banco_cuenta_mov_id == '' || strlen($banco_cuenta_mov_id) < 32)
            {
                $arrBCMacciones['Error'] = 'El ID del movimiento bancario es inválido.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
                break;
            }

            $BancoCuentaMov = new BancoCuentaMov;
            $BancoCuentaMov->Original = $Original;
	        if(!$BancoCuentaMov->leeBancoCuentaMov($banco_cuenta_mov_id))
            {
                $arrBCMacciones['Error'] = 'El movimiento bancario no existe.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['numMovimientosModificados'] = '0';
            }
            else
            {
                $arrBCMacciones['Error'] = 'Lectura del movimiento bancario exitoso.';
                $arrBCMacciones['Status'] = 'OK';
                $arrBCMacciones['BancoCuentaMov'] = get_object_vars($BancoCuentaMov);
                $arrBCMacciones['BancoCuentaMov']['remarks'] = utf8_encode($arrBCMacciones['BancoCuentaMov']['remarks']);
                $arrBCMacciones['aCuentas'] = generaaCuentasdeBancoMov($bcm_id, 'array');
            }
        break;

        case 'PuedeEditar':

            $banco_cuenta_mov_id = param("banco_cuenta_mov_id");

            $Original = param("Original",param("ECO"));
            //$oo = $Original;
            if($Original != 'NO')
                $Original = true;
            else
                $Original = false;


            $bcmPuedeEditar = array(    'link_vale'=>false,
                                        'cash'=>false,
                                        'deposit'=>false,
                                        'withdrawal'=>false,
                                        'fecha'=>false);


            if($banco_cuenta_mov_id == '' || strlen($banco_cuenta_mov_id) < 32)
            {
                $arrBCMacciones['Error'] = 'El ID del movimiento bancario es inválido.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['bcmPuedeEditar'] = $bcmPuedeEditar;
                break;
            }

            $BancoCuentaMov = new BancoCuentaMov;
            $BancoCuentaMov->Original = $Original;
	        if(!$BancoCuentaMov->leeBancoCuentaMov($banco_cuenta_mov_id))
            {
                $arrBCMacciones['Error'] = 'El movimiento bancario no existe.';
                $arrBCMacciones['Status'] = 'Error';
                $arrBCMacciones['bcmPuedeEditar'] = $bcmPuedeEditar;
                $arrBCMacciones['BancoCuentaMov'] = get_object_vars($BancoCuentaMov);
                break;
            }

            //Caso 1: tiene link, está bloqueado o ya pasó su tiempo para modificar.
            if($BancoCuentaMov->link_vale == 'LT' || $BancoCuentaMov->puede_editar == 'No' || diferenciadeTiempo($BancoCuentaMov->fecha,'','dias') >= $gIAParametros['tiempo_para_modificar_banco_mov'])
            {
                $bcmPuedeEditar['link_vale'] = false;
                $bcmPuedeEditar['cash'] = false;
                $bcmPuedeEditar['deposit'] = false;
                $bcmPuedeEditar['withdrawal'] = false;
                $bcmPuedeEditar['fecha'] = false;
            }
            else if($BancoCuentaMov->link_vale == 'SBC' /** || $BancoCuentaMov->verificado == 'Si' **/)
            {
                $bcmPuedeEditar['link_vale'] = false;
                $bcmPuedeEditar['cash'] = false;
                $bcmPuedeEditar['deposit'] = false;
                $bcmPuedeEditar['withdrawal'] = false;
                $bcmPuedeEditar['fecha'] = false;
            }
            else
            {
                $bcmPuedeEditar['link_vale'] = false;
                $bcmPuedeEditar['fecha'] = true;
                if($BancoCuentaMov->withdrawal > 0)
                {
                    $bcmPuedeEditar['withdrawal'] = true;
                    $bcmPuedeEditar['cash'] = false;
                    $bcmPuedeEditar['deposit'] = false;
                }
                if($BancoCuentaMov->cash > 0)
                {
                    $bcmPuedeEditar['withdrawal'] = false;
                    $bcmPuedeEditar['cash'] = true;
                    $bcmPuedeEditar['deposit'] = false;
                }
                if($BancoCuentaMov->deposit > 0)
                {
                    $bcmPuedeEditar['withdrawal'] = false;
                    $bcmPuedeEditar['cash'] = false;
                    $bcmPuedeEditar['deposit'] = true;
                }
            }

            if(usuarioTipoRony($_SESSION['usuario_id']))
            {
                if($BancoCuentaMov->link_vale != 'LT' && $BancoCuentaMov->link_vale != 'BL')
                {

                    $bcmPuedeEditar['link_vale'] = true;

                    if($BancoCuentaMov->withdrawal > 0)
                    {
                        $bcmPuedeEditar['withdrawal'] = true;
                        $bcmPuedeEditar['cash'] = false;
                        $bcmPuedeEditar['deposit'] = false;
                    }
                    if($BancoCuentaMov->cash > 0 || $BancoCuentaMov->deposit > 0)
                    {
                        $bcmPuedeEditar['withdrawal'] = false;
                        $bcmPuedeEditar['cash'] = true;
                        $bcmPuedeEditar['deposit'] = true;
                    }
                }
                else
                {
                    $bcmPuedeEditar['withdrawal'] = false;
                    $bcmPuedeEditar['cash'] = false;
                    $bcmPuedeEditar['deposit'] = false;
                    $bcmPuedeEditar['fecha'] = false;
                    $bcmPuedeEditar['link_vale'] = false;
                }
            }

            if($BancoCuentaMov->alta_tipo == 'auto')
            {
                $bcmPuedeEditar['withdrawal'] = false;
                $bcmPuedeEditar['cash'] = false;
                $bcmPuedeEditar['deposit'] = false;
                $bcmPuedeEditar['fecha'] = false;
            }

            $arrBCMacciones['Error'] = 'Lectura del movimiento bancario exitoso.';
            $arrBCMacciones['Status'] = 'OK';
            $arrBCMacciones['bcmPuedeEditar'] = $bcmPuedeEditar;


            /*$myFile = "../enviomodmovaccleer.txt";
        			$fh = fopen($myFile, 'w') or die("can't open file");
        			$bleh = 'id: ' . $banco_cuenta_mov_id . "\r\n\r\n" . 'Original: ' . $Original;
        			fwrite($fh, $bleh);
        			fclose($fh);*/

        break;


    }
    echo json_encode($arrBCMacciones);
    ia_errores_a_dime();


    function PasalaVerificacion($bcmp)
    {
        global $arrBCMacciones;

        if(!array_key_exists('cash', $bcmp) || !array_key_exists('deposit', $bcmp) || !array_key_exists('withdrawal', $bcmp))
            return true;
        $es = $bcmp["es"];
        $cash = $bcmp["cash"];
        $deposit = $bcmp["deposit"];
        $withdrawal = $bcmp["withdrawal"];
        $banco_mov_tipo_id = $bcmp["banco_mov_tipo_id"];



        //$bmtiposql = "SELECT * FROM `banco_mov_tipo` WHERE `banco_mov_tipo_id` = $banco_mov_tipo_id";
        //$bmtipoarray = ia_singleton($bmtiposql);



        if($es == 'Deposito')
        {
            //Sólo Cash y Deposit se permiten.
            if($withdrawal > 0)
            {
                $arrBCMacciones['Status'] = 'SaveERRORTIPO';
                $arrBCMacciones['Error'] = 'El tipo de movimiento es Depósito, y Withdrawal tiene un monto.';
                return false;
            }
            return true;
        }
        else
        {
            //Sólo Withdrawal se permite.
            if($cash > 0 || $deposit > 0)
            {
                $arrBCMacciones['Status'] = 'SaveERRORTIPO';
                $arrBCMacciones['Error'] = 'El tipo de movimiento es Retiro, y Cash o Deposit tienen un monto.';
                return false;
            }
            return true;
        }

    }
