<?php
namespace core;
use PDO;
/**
 *
 */
class conexion
{
    public $conexion = null;
    public $table = null;
    public $time_zone = "America/Mexico_City";
    public $tz = null;
    protected $querySelector;
    // public $sql = null;
    function __construct()
    {
        try {
            $dsn = 'mysql:host=localhost;port=3306;dbname=xxxx';
            $this->conexion = new PDO($dsn, 'xxx', 'xxx', array( PDO::ATTR_PERSISTENT => false));
            $this->conexion->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
            // $this->tz = (new \DateTime('now', new \DateTimeZone($this->time_zone)))->format('P');
            // $this->conexion->exec("SET time_zone='$this->tz';");
            // $this->conexion->query("SET CHARACTER SET utf8");
        } catch (\PDOException $e){
            echo $e->getMessage();
        }
    }

    public function getResults($sql)
    {
        try {
            $stmt = $this->conexion->prepare($sql);
            if (!$stmt->execute()) {
                $this->errors = $stmt->errorInfo();
                $this->errors['query'] = $sql;
                echo json_encode($this->errors);
                return false;
            }
            $results = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $results;
        } catch (\PDOException $e) {
            echo "<h5>ERROR: {$e->getMessage()}</h5>";
            throw $e;
            return false;
        }       
    }

    public function getResult($sql)
    {
        $stmt = $this->conexion->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(\PDO::FETCH_ASSOC);
        if (!empty($result)) {
            return $result;
        } else {
            return null;
        }
    }

    public function trasaction($sql_array = [])
    {
        try {
            $this->conexion->beginTransaction();
            // Aquí va el for para los querys;
            foreach ($sql_array as $sql) {
                // $sql = "INSERT INTO usuario (user_id, amount) VALUES (2020202, 'jaja')";
                $stmt = $this->conexion->prepare($sql);
                $stmt->execute();
            }
            $this->conexion->commit();
            return true;
        } catch (\PDOException $e) {            
            $this->conexion->rollBack();
            echo "<h5>ERROR: {$e->getMessage()}</h5>";
            throw $e;
            return false;
        }        
    }

    public function getTables()
    {
        $sql = "SELECT TABLE_NAME AS `name`, CREATE_TIME AS `created_at`, UPDATE_TIME AS `updated_at` FROM information_schema.tables
                WHERE table_schema = '" . db_name ."' ORDER BY TABLE_NAME ASC";
        $stmt = $this->conexion->prepare($sql);
        if (!$stmt->execute()) {
            $this->errors = $stmt->errorInfo();
            $this->errors['query'] = $sql;
            echo json_encode($this->errors);
            return false;
        }
        $results = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $results;
    }
    public function getTable($name)
    {
        $sql = "DESC $name";
        $stmt = $this->conexion->prepare($sql);
        if (!$stmt->execute()) {
            $this->errors = $stmt->errorInfo();
            $this->errors['query'] = $sql;
            echo json_encode($this->errors);
            return false;
        }
        $results = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $results;
    }

    public function createTable($table_name, $fields)
    {
        $create = "CREATE";
        $sql = "$create TABLE $table_name (";

        $type = '';
        foreach ($fields as $key => $field) {
            $type = $this->setType($field->type, isset($field->is_pk) ?$field->is_pk: false, isset($field->is_null) ?$field->is_null: false, isset($field->is_auin) ?$field->is_auin: false, $field->value_default, ($field->type == 'ENUM') ? $field->value_enum: '');
            $sql .= "$field->field $type, ";
        }
        $sql = substr($sql, 0, -2);
        $sql .= ")";
        $stmt = $this->conexion->prepare($sql);
        if (!$stmt->execute()) {
            $errors = $stmt->errorInfo();
            $errors['query'] = $sql;
            return $errors;
        }
        return true;
    }

    public function dropTable($table)
    {
        $sql = "DROP TABLE $table";
        $stmt = $this->conexion->prepare($sql);
        if (!$stmt->execute()) {
            $errors = $stmt->errorInfo();
            $errors['query'] = $sql;
            return $errors;
        }
        return true;
    }

    public function getDdl($table)
    {
        $sql = "SHOW CREATE TABLE $table";
        $stmt = $this->conexion->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(\PDO::FETCH_ASSOC);
    }

    public function getFields()
    {
        $sql = $this->querySelector->getFieldsQuery();
        $fields = $this->execute($sql);

        if (count($fields) == 0) {
            echo json_encode(['ERROR' => "No existe tabla '$this->table' en base de datos"]);
            exit;
        }

        $fieldsReturn = [];
        foreach ($fields as $key => $field) {
            $field = (object)$field;
            array_push($fieldsReturn, $field->FIELD);
        }
        return $fieldsReturn;
    }

    public function execute($sql)
    {
        $stmt = $this->conexion->prepare($sql);
        $stmt->execute();
        $results = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $results;
    }

    public function makeFakerData($table='', $primary_key = null, $insert_in_primarykey = true, $number_of_register = 2)
    {
        $this->table = $table;
        $fields = array_diff($this->getFields(), fieldsFromControl);

        $primary_key = $primary_key == null ? $table . '_id' : $primary_key;

        if (!$insert_in_primarykey) {
            $position = array_search($primary_key, $fields);
            unset($fields[$position]);
        }
        $fields_insert = implode(', ', $fields);

        $sql = "INSERT INTO $this->table ($fields_insert) VALUES ";

        for ($i = 0; $i < $number_of_register; $i++) {
            $sql .= "(";
            foreach($fields as $field) {
                if (!in_array($field, fieldsFromControl)) {
                    $string = generateRandomString(5);
                    $sql .= "'$string', ";
                }                
            }
            $sql = substr($sql, 0, -2);
            $sql .= "), ";
        }
        $sql = substr($sql, 0, -2);

        $stmt = $this->conexion->prepare($sql);

        if (!$stmt->execute()) {
            $errors = $stmt->errorInfo();
            $errors['query'] = $sql;
            return $errors;
        }
        return true;
    }

    public function count()
    {
      $total = $this->getResult("SELECT COUNT(*) total FROM $this->table")['total'];
      return $total;
    }
    public function setType($_type, $is_pk = false, $is_null = false, $is_autoinc = false, $default = '', $enums = '')
    {
        $type_ = "";
        $pk = (!$is_pk) ? '' : 'PRIMARY KEY';
        $default_ = ($default == '') ? '' : "DEFAULT " . (strtolower($default) != 'now()' ? "'$default'" : $default);
        $nullable = (!$is_null) ? 'NOT NULL' : 'NULL';
        $autoInc = (!$is_autoinc) ? '' : 'AUTO_INCREMENT';
        $enums = explode(",", $enums);
        $enums_ = "";
        foreach ($enums as $key => $enum) {
            $enums_.= "'$enum', ";
        }
        $enums_ = substr($enums_, 0, -2);
        switch ($_type) {
            case 'VARCHAR':
                $type_ = "VARCHAR(100) $pk $nullable $default_ $autoInc";
                break;
            case 'ENUM':
                $type_ = "ENUM($enums_) $pk $nullable $default_ $autoInc";
                break;
            default:
                $type_ = "$_type $pk $nullable $default_ $autoInc";
                break;
        }
        return $type_;
    }

    public function getModel()
    {
        $sql = $this->querySelector->getModelQuery();

        $fields = $this->execute( $sql );
        if (count($fields) == 0) {
            echo json_encode(['ERROR' => "No existe tabla '$this->table' en base de datos"]);
            exit;
        }
        $colModel = [];
        foreach ($fields as $key => $field) {
            $field = (object)$field;
            $colModel[$field->FIELD] = [
                'key' => $field->FIELD,
                'label' => ucfirst(str_replace('_', ' ', $field->FIELD)),
                'required' => $field->IS_NULLABLE == 'NO' ? true: false,
                'dbType' => $field->DATA_TYPE,
                'type' => getTypeField($field->DATA_TYPE),
            ];
            /* array_push($colModel, [
                'key' => $field->FIELD,
                'label' => ucfirst(str_replace('_', ' ', $field->FIELD)),
                'required' => $field->IS_NULLABLE == 'NO' ? true: false,
                'dbType' => $field->DATA_TYPE,
                'type' => getTypeField($field->DATA_TYPE),
            ]); */
        }
        return $colModel;
    }
}
