<?php
//marzo2020
use JetBrains\PhpStorm\NoReturn;

/**
     * BancoCuentaMov
     *
     * @package Vitex Cobranza
     * @author Victor Cazares
     * @copyright 2014
     * @version $Id$
     * @access public
     */
    #[AllowDynamicProperties] class BancoCuentaMov
 	{

		/*****************************/
		//Datos del Movimiento Bancario
		/*****************************/

		var $banco_cuenta_mov_id;
        var $banco_cuenta_id;
        var $fecha;
        var $fecha_hora;
        var $es;
        var $cash;
        var $deposit;
        var $withdrawal;
        var $banco_mov_tipo_id;
        var $numero;
        var $banco_id;

        var $verificado;
        var $verificado_el;
        var $verificado_por;
        var $mov_verificado_id;

        var $idex100 = 0.00;
        var $factura;
        var $ivacobradox100;
        var $ivacobradototal;
        var $remarks;
        var $alta_db;
        var $alta_por;
        var $ultimo_cambio;
        var $ultimo_cambio_por;

        var $Original = true;
        var $tblOriginal = 'banco_cuenta_mov';
        var $tblVerif = 'mov_verificado';

        var $id = '';
        var $vid = '';
        var $tbl = '';

        var $usado;
        var $puede_editar;
        var $link_vale;

        var $OldQuantity = 0.00;

        var $alta_tipo;

        var $tipo_cash_nota;
        var $cash_nota_num;
        var $tienda;
        var $empresa;
        var $cliente;
        var $factura_numero;

        var $withdrawal_autorizado = 'No';
        var $withdrawal_autorizado_el;
        var $withdrawal_autorizado_por;

        var $extraInsertSQL = array();

        var $categoria_gasto_id;
        var $fecha1;
        var $bc_empresa_id;
        var $numero_original;
        var $go;
        var $moneda_id;
        var $referencia_monex;

        var $puede_borrar;
        var $tiempo_restante_para_borrar;
        var $poliza_contabilidad;
        var string $remarks_title = "";
        var string $referencia_original = "";
        var string $numero_original_tagged = "";
        var array $afterInsertInstructions = [];
        var string $plantilla_id = '';
        var string $banco_diccionario_dato_id = '';
        var string $banco_diccionario_dato_remarks = '';
        var string $plantilla_withdrawals_remarks = '';

		function leeBancoCuentaMov($UUID)
		{

			if($UUID == '' || $UUID == NULL)
				return FALSE;

            if($this->Original)
				$bcmsql = "SELECT * FROM $this->tblOriginal WHERE banco_cuenta_mov_id = ".strit($UUID);
			else
				$bcmsql = "SELECT * FROM $this->tblVerif WHERE mov_verificado_id = ".strit($UUID);

			$bcmarray = ia_singleton($bcmsql);

			if (!$bcmarray)
			    return FALSE;
            $this->banco_cuenta_mov_id = $bcmarray['banco_cuenta_mov_id'];
            $this->banco_cuenta_id = $bcmarray['banco_cuenta_id'];
            $this->fecha = $bcmarray['fecha'];
            $this->es = $bcmarray['es'];
            $this->cash = $bcmarray['cash'];
            $this->deposit = $bcmarray['deposit'];
            $this->withdrawal = $bcmarray['withdrawal'];
            $this->banco_mov_tipo_id = $bcmarray['banco_mov_tipo_id'];
            $this->numero = mb_convert_encoding($bcmarray['numero'], 'ISO-8859-1', 'UTF-8');
            $this->banco_id = $bcmarray['banco_id'];
            $this->verificado = $bcmarray['verificado'];
            $this->verificado_el = $bcmarray['verificado_el'];
            $this->verificado_por = $bcmarray['verificado_por'];
            $this->mov_verificado_id = $bcmarray['mov_verificado_id'];
            $this->idex100 = $bcmarray['idex100'];
            $this->factura = mb_convert_encoding($bcmarray['factura'], 'ISO-8859-1', 'UTF-8');

            $this->ivacobradox100 = $bcmarray['ivacobradox100'];


            $this->remarks = mb_convert_encoding($bcmarray['remarks'], 'ISO-8859-1', 'UTF-8');
            $this->alta_db = $bcmarray['alta_db'];
            $this->alta_por = $bcmarray['alta_por'];
            $this->ultimo_cambio = $bcmarray['ultimo_cambio'];
            $this->ultimo_cambio_por = $bcmarray['ultimo_cambio_por'];

            $this->usado = $bcmarray['usado'];
            $this->puede_editar = $bcmarray['puede_editar'];
            $this->link_vale = $bcmarray['link_vale'];

            $this->alta_tipo = $bcmarray['alta_tipo'];

            $this->OldQuantity = $this->cash + $this->deposit - $this->withdrawal;
            $this->ivacobradototal = $this->OldQuantity * $this->ivacobradox100 / 100;

            if($this->Original)
            {    $this->id = 'banco_cuenta_mov_id'; $this->tbl = 'banco_cuenta_mov'; $this->vid = 'mov_verificado_id';}
            else
            {    $this->id = 'mov_verificado_id'; $this->tbl = 'mov_verificado'; $this->vid = 'banco_cuenta_mov_id';}

            $this->tipo_cash_nota = $bcmarray['tipo_cash_nota'];
            $this->cash_nota_num = $bcmarray['cash_nota_num'];
            $this->tienda = !empty($bcmarray['tienda_id']) ? ia_singleread("SELECT tienda FROM tienda WHERE tienda_id=".strit($bcmarray['tienda_id'])) : '';
            $this->empresa = !empty($bcmarray['empresa_id']) ? ia_singleread("SELECT empresa FROM empresa WHERE empresa_id=".strit($bcmarray['empresa_id'])) : '';;
            $this->cliente = $bcmarray['cliente'];
            $this->factura_numero = $bcmarray['factura_numero'];

            $this->withdrawal_autorizado = $bcmarray['withdrawal_autorizado'];
            $this->withdrawal_autorizado_el = $bcmarray['withdrawal_autorizado_el'];
            $this->withdrawal_autorizado_por = $bcmarray['withdrawal_autorizado_por'];

            $this->categoria_gasto_id = $bcmarray['categoria_gasto_id'];
            $this->fecha1 = $bcmarray['fecha1'];
            $this->bc_empresa_id = $bcmarray['bc_empresa_id'];

            $this->numero_original = $bcmarray['numero_original'];
            $this->numero_original_tagged = $bcmarray['numero_original_tagged']??'';
            $this->moneda_id = $bcmarray['moneda_id'];
            $this->referencia_monex = $bcmarray['referencia_monex'];
            $this->fecha_hora = $bcmarray['fecha_hora'];
            $this->puede_borrar = $bcmarray['puede_borrar'];
            $this->tiempo_restante_para_borrar = $bcmarray['tiempo_restante_para_borrar'];
            $this->poliza_contabilidad = $bcmarray['poliza_contabilidad'];

            $this->plantilla_id = $bcmarray['plantilla_id']??'';
            $this->banco_diccionario_dato_id = $bcmarray['banco_diccionario_dato_id']??'';
            $this->banco_diccionario_dato_remarks = $bcmarray['banco_diccionario_dato_remarks']??'';
            $this->plantilla_withdrawals_remarks = $bcmarray['plantilla_withdrawals_remarks']??'';

            $this->arreglaCamposparaleeBancoCuentaMov();


			return TRUE;
		}

        function guardaBancoCuentaMov($UUID, $EliminoVerif = false, $do=true)
		{
            //global $gIAsql;

            //$gIAsql['trace']=true;

            global $gIAsql;
            if($UUID != $this->banco_cuenta_mov_id && $UUID != $this->mov_verificado_id)
            {
				return FALSE;
            }

            $this->ultimo_cambio = date('Y-m-d H:i:s');
            $this->arreglaCamposparaguardaBancoCuentaMov();
            $mFecha = date('Y-m-d', strtotime($this->fecha));

            $cmnt = 'Modificacion Mov Bancario';
            $sql = array();

            $sql[] = "UPDATE $this->tblOriginal /** $cmnt **/ SET
                fecha = '$this->fecha',
                es = '$this->es',
                banco_mov_tipo_id = '$this->banco_mov_tipo_id',
                cash = '$this->cash',
                deposit = '$this->deposit',
                withdrawal = '$this->withdrawal',
                numero = '$this->numero', 
                numero_original = '$this->numero_original',
                usado = '$this->usado',
                puede_editar = '$this->puede_editar',
                link_vale = '$this->link_vale',
                idex100 = '$this->idex100',
                factura = '$this->factura',
                ivacobradox100 = '$this->ivacobradox100',
                remarks = '$this->remarks',
                ultimo_cambio = '$this->ultimo_cambio',
                ultimo_cambio_por = '$this->ultimo_cambio_por',
                fecha1 = '$this->fecha',
                moneda_id = '$this->moneda_id',
                referencia_monex = '$this->referencia_monex',
                fecha_hora = '$this->fecha_hora',
                puede_borrar = '$this->puede_borrar',
                tiempo_restante_para_borrar = '$this->tiempo_restante_para_borrar',
                banco_diccionario_dato_remarks = '$this->banco_diccionario_dato_remarks',
                WHERE banco_cuenta_mov_id = '$this->banco_cuenta_mov_id'";

            if(!empty($this->extraInsertSQL))
                $sql = array_merge($sql, $this->extraInsertSQL);

            $this->extraInsertSQL = array();

            if($do)
                if(ia_transaction($sql))
    			{
                    ia_errores_a_dime();
                    if($gIAsql['trace'])
                        ia_errores_a_dime("sql_trace=".print_r($gIAsql['sql_trace'],true));
                    return false;
                }
                else
                    return true;

            return $sql;
		}

        function insertaBancoCuentaMov($do=true, $imp=false, $agrega_asignacion = false): bool|array
        {
            global $gIAsql;
            $method = " /** " . __METHOD__ ." **/ ";

            $this->arreglaCamposparaguardaBancoCuentaMov();

            if(empty($this->banco_cuenta_mov_id))
                $this->banco_cuenta_mov_id = ia_guid();

            $oknumop = 1; //En principio sólo hay insertar un movimiento
            $ok = 0;
            $sql = array();

            if(empty($this->alta_tipo))
                $this->alta_tipo = 'manual';

            $complete_insert_a_s = ", asignacion, supervision, asig_semaforo_rony, asig_semaforo_usuarios, html_asignaciones";
            $complete_values_a_s = ", 'ZZZZZZZZZZZZ', 'ZZZZZZZZZZZZ', '', '', ''";
            $querys_asignacion = [];
            $data_asignacion = [];
            if ($agrega_asignacion) {
                $complete_insert_a_s = ", asignacion, supervision, asig_semaforo_rony, asig_semaforo_usuarios, html_asignaciones";
                $asignacion = new AsignacionEstatus('banco_cuenta_mov');
                $asignacion->asignaGastoSupervision($this->banco_cuenta_mov_id, $querys_asignacion, $data_asignacion, 'banco_cuenta_mov_supervision');
                $semaforo = calculaSemaforo(null, $data_asignacion['asignacion'], 'banco_cuenta_mov');
                $data_asignacion['asig_semaforo_rony'] = $semaforo['rony'];
                $data_asignacion['asig_semaforo_usuarios'] = isset($semaforo['otros']) ? json_encode($semaforo['otros']) : '';
                $fecha_revision = date('Y-m-d H:i:s');
                $data_asignacion['html_asignaciones'] = strit(asignacion_2_html("banco_cuenta_mov_asignacion", $data_asignacion['asignacion'], $this->banco_cuenta_mov_id, true, $fecha_revision));
                $complete_values_a_s = ", '$data_asignacion[asignacion]', '$data_asignacion[supervision]', '$data_asignacion[asig_semaforo_rony]', '$data_asignacion[asig_semaforo_usuarios]', $data_asignacion[html_asignaciones]";
            }

            $tmp1 = "INSERT INTO $method $this->tblOriginal (
                    banco_cuenta_mov_id,
                    banco_cuenta_id,
                    fecha,
                
                    es,
                    cash,
                    deposit,
                    withdrawal,
                    banco_mov_tipo_id,
                    numero,
                    banco_id,
                    link_vale,
                    idex100,
                    factura,
                    remarks,
                    alta_por,
                    alta_tipo,
                    categoria_gasto_id,
                    fecha1,
                    bc_empresa_id, 
                    numero_original,
                   moneda_id,
                   withdrawal_autorizado,
                   referencia_monex, fecha_hora, puede_borrar, tiempo_restante_para_borrar,
                    alta_db, poliza_contabilidad, numero_original_tagged, banco_diccionario_dato_id, banco_diccionario_dato_remarks $complete_insert_a_s) ";
            $tmp2 = " VALUES ";
            $tmp3 = "('$this->banco_cuenta_mov_id',
                    '$this->banco_cuenta_id',
                    '$this->fecha',
                    
                    '$this->es',
                    '$this->cash',
                    '$this->deposit',
                    '$this->withdrawal',
                    '$this->banco_mov_tipo_id',
                    '$this->numero',
                    '$this->banco_id',
                    '$this->link_vale',
                    '$this->idex100',
                    '$this->factura',
                    '$this->remarks',
                    '$this->alta_por',
                    '$this->alta_tipo',
                    '$this->categoria_gasto_id',
                    '$this->fecha',
                    '$this->bc_empresa_id',
                    '$this->numero_original',
                    '$this->moneda_id',
                    '$this->withdrawal_autorizado',
                    '$this->referencia_monex',
                    '$this->fecha_hora',
                    '$this->puede_borrar',
                    '$this->tiempo_restante_para_borrar',
                    '$this->alta_db',
                    '$this->poliza_contabilidad',
                    '$this->numero_original_tagged',
                    '$this->banco_diccionario_dato_id', 
                    '$this->banco_diccionario_dato_remarks' 
                    $complete_values_a_s)";

            $onDuplicateClause = " ON DUPLICATE KEY UPDATE fecha1 = VALUES(fecha1) ";

            if($imp)
                $sql[] = $tmp3;
            else
                $sql[] = $tmp1.$tmp2.$tmp3.$onDuplicateClause;

            if(!$imp)
                $sql[] = "UPDATE $method banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($this->banco_cuenta_id);

            $sql['asignacion'] = [];
            if(!empty($this->extraInsertSQL))
                $sql['asignacion'] = $this->extraInsertSQL;


            if ($agrega_asignacion) {
                if ($do) {
                    $sql = array_merge($sql, $querys_asignacion, $sql['asignacion']);
                } else {
                    $sql['asignacion'] = array_merge($sql['asignacion'], $querys_asignacion);
                }
            }
            else
                $sql = array_merge($sql, $querys_asignacion, $sql['asignacion']);

            //Ph. 10-07-2025
            //Agrego un haz_insert_con_log por cada movimiento insertado para que siempre haya bitacora del primer movimiento, el insert.
            $bcm_enDB = array();

            $bcm_enDB['banco_cuenta_id'] = $this->banco_cuenta_id;
            $bcm_enDB['fecha'] = $this->fecha;
            $bcm_enDB['alta_tipo'] = $this->alta_tipo;
            $bcm_enDB['alta_por'] = $this->alta_por;
            $bcm_enDB['alta_db'] = $this->alta_db;
            $bcm_enDB['es'] = $this->es;
            if($this->es == 'Deposito')
                $bcm_enDB['deposit'] = $this->deposit;
            else
                $bcm_enDB['withdrawal'] = $this->withdrawal;
            $bcm_enDB['banco_mov_tipo_id'] = $this->banco_mov_tipo_id;

            $bcm_enDB['numero'] = $this->numero;
            $bcm_enDB['remarks'] = $this->remarks;
            $bcm_enDB['link_vale'] = $this->link_vale;
            $bcm_enDB['banco_diccionario_dato_remarks'] = $this->banco_diccionario_dato_remarks;
            $bcm_enDB['banco_diccionario_dato_id'] = $this->banco_diccionario_dato_id;

            $app_name = 'banco_cuenta_mov';
            $bcm_enDB_log = genera_array_kv_log($app_name, $bcm_enDB);

            $bcm_kv_log_arr = array('collection_id'=>$app_name, 'record_id'=>$this->banco_cuenta_mov_id, 'accion'=>'alta', 'enDB'=>$bcm_enDB_log, 'enND'=>'');
            $sql[] = haz_insert_con_log($bcm_kv_log_arr);

            if($do) {
                unset($sql['asignacion']);
//                echo "$this->banco_cuenta_mov_id: <pre>".print_r($sql, true)."</pre>";
//                die();
                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    if ($gIAsql['trace'])
                        ia_errores_a_dime("sql_trace=" . print_r($gIAsql['sql_trace'], true));

                    return false;
                } else
                    return true;
            }else {
                if (!$agrega_asignacion)
                    unset($sql['asignacion']);
                return $sql;
            }
        }

        function arreglaCamposparaleeBancoCuentaMov()
		{
            if(!empty($this->fecha)) $this->fecha = date('d-m-Y H:i:s', strtotime($this->fecha)); else $this->fecha = '';
            if(!empty($this->verificado_el)) $this->verificado_el = date('d-m-Y H:i:s', strtotime($this->verificado_el)); else $this->verificado_el = '';
            if(!empty($this->alta_db)) $this->alta_db = date('d-m-Y H:i:s', strtotime($this->alta_db)); else $this->alta_db = '';
            if(!empty($this->ultimo_cambio)) $this->ultimo_cambio = date('d-m-Y H:i:s', strtotime($this->ultimo_cambio)); else $this->ultimo_cambio = '';

            if(!empty($this->withdrawal_autorizado_el)) $this->withdrawal_autorizado_el = date('d-m-Y H:i:s', strtotime($this->withdrawal_autorizado_el)); else $this->withdrawal_autorizado_el = '';
            if(!empty($this->poliza_contabilidad)) $this->poliza_contabilidad = removeBrTags($this->poliza_contabilidad); else $this->poliza_contabilidad = '';

        }

        function arreglaCamposparaguardaBancoCuentaMov()
		{
            global $gIAParametros;

            if(!empty($this->fecha)) $this->fecha = date('Y-m-d H:i:s', strtotime($this->fecha)); else $this->fecha = NULL;
            if(!empty($this->fecha1)) $this->fecha1 = date('Y-m-d', strtotime($this->fecha1)); else $this->fecha1 = NULL;
            if(!empty($this->verificado_el)) $this->verificado_el = date('Y-m-d H:i:s', strtotime($this->verificado_el)); else $this->verificado_el = NULL;
            if(!empty($this->ultimo_cambio)) $this->ultimo_cambio = date('Y-m-d H:i:s', strtotime($this->ultimo_cambio)); else $this->ultimo_cambio = NULL;

            if(!empty($this->withdrawal_autorizado_el)) $this->withdrawal_autorizado_el = date('Y-m-d H:i:s', strtotime($this->withdrawal_autorizado_el)); else $this->withdrawal_autorizado_el = NULL;

            if(!empty($this->poliza_contabilidad)) $this->poliza_contabilidad = trimandAddNewLineandBR($this->poliza_contabilidad); else $this->poliza_contabilidad = NULL;

            if(empty($this->idex100)) $this->idex100 = 0.00;

            if(empty($this->moneda_id))
                $this->moneda_id = ia_singleread("SELECT moneda_id FROM banco_cuenta WHERE banco_cuenta_id = ".strit($this->banco_cuenta_id));

            //VCA: 07-Nov-2023 se siguen colando unos movimientos de monex a las autorizaciones de Rony. Intento forzarlo
            if($this->banco_id == 14) {//Son de monex. Los autorizamos automáticamente
                $this->withdrawal_autorizado = 'Si';
            }

            if($this->alta_tipo == 'auto' && empty($this->fecha_hora))
                $this->fecha_hora = date('H:i:s', strtotime($this->alta_db));


            $this->puede_borrar = 'Si';

            $this->tiempo_restante_para_borrar = $gIAParametros['tiempo_limite_para_borrar_movimientos_banco'].' min';
            $this->banco_diccionario_dato_remarks = !empty($this->banco_diccionario_dato_remarks) ? addslashes($this->banco_diccionario_dato_remarks) : "";
            $this->plantilla_withdrawals_remarks = !empty($this->plantilla_withdrawals_remarks) ? addslashes($this->plantilla_withdrawals_remarks) : "";
        }

        /**
         * @throws DateMalformedStringException
         */
        function calculaCamposAutomaticos(): bool
        {
            global $gIAsql, $arr_DicDatosBanco, $gIAParametros;
            $debug = false;

            if (empty($this->banco_cuenta_id)) {
                return false; // Exit if no bank account ID is provided
            }

            $this->banco_cuenta_mov_id = ia_guid(); // Generate unique ID for the movement

            // Initialize dictionary if it's not already loaded
            if (empty($arr_DicDatosBanco)) {
                $arr_DicDatosBanco = preparaDiccionarioDatosBanco();
            }

            // Set transaction type as either 'Retiro' (Withdrawal) or 'Deposito' (Deposit)
            $this->es = $this->withdrawal > 0 ? 'Retiro' : 'Deposito';

            $usuario_automatico = "sistema"; // Default system user
            $usuario_id_automatico = $_SESSION['usuario_id'] ?? null; // Automatic user ID from session
            $now = date('Y-m-d H:i:s'); // Current timestamp
            $debo_insertar = false;
            $ya_insertado = false;

            // Fetch company ID if not set
            if (empty($this->bc_empresa_id)) {
                $this->bc_empresa_id = $this->fetchEmpresaIdFromBancoCuenta($this->banco_cuenta_id);
            }

            // Handle manual input cases
            if ($this->alta_tipo == 'manual') {
                $palabra_ = $this->resolveManualWord($this->banco_mov_tipo_id);
                if (!empty($palabra_)) {
                    $this->remarks = $this->prependRemark($palabra_, $this->remarks);
                }
            }

            $esListo = false;

            // Process for 'Retiro' (withdrawal)
            if ($this->es == 'Retiro') {
                $esListo = $this->processRetiro($arr_DicDatosBanco, $now, $debo_insertar);
            }
            // Process for 'Deposito' (deposit)
            else {
                $esListo = $this->processDeposito($arr_DicDatosBanco, $now, $gIAParametros, $usuario_automatico, $debo_insertar, $esListo, $ya_insertado, $debug);
            }

            // Assign 'link_vale' if it is not set
            if (empty($this->link_vale)) {
                $this->link_vale = $this->assignLinkVale($this->banco_mov_tipo_id);
            }

            // Insert into BancoCuentaMov if needed
            if ($debo_insertar && !$ya_insertado) {
                if (!$this->insertaBancoCuentaMov(true, false, false)) {
                    ia_errores_a_dime();
                }
                $this->go = 'NO'; // Prevent further processing
            }

            file_debug_reporte(); // Log debug report
            ia_errores_a_dime();  // Report errors
            return true;
        }

        /**
         * Resolves the specific word based on `banco_mov_tipo_id` for manual entries.
         */
        private function resolveManualWord($banco_mov_tipo_id): string
        {
            return match ($banco_mov_tipo_id) {
                22 => 'INVERSION',
                21 => 'FIDUCIARIO',
                default => '',
            };
        }

        /**
         * Prepends a keyword to the remarks, ensuring it's included.
         */
        private function prependRemark($palabra_, $remarks)
        {
            if (!str_contains($remarks, $palabra_)) {
                return "$palabra_ $remarks<hr>";
            }
            return $remarks;
        }
        private function handleAddEmpresatoTitle($vddB = []): void
        {
            $doEmpresa = $vddB['accion_extra'] == 'ADDEMPRESATITLE' ? fetchEmpresaFromBancoCuenta($this->banco_cuenta_id)['empresa'] : '';
            $this->remarks_title = str_replace('%EMPRESANOMBRE%', $doEmpresa, $this->remarks_title);
        }

        /**
         * Obtiene la referencia original extraída de un número siguiendo una expresión regular.
         *
         * @param string $numeroOriginal El número original del cual se extraerá la referencia.
         * @param string $regExp La expresión regular que define cómo extraer la referencia.
         * @return string La referencia original extraída siguiendo la expresión regular proporcionada.
         */
        private function getReferenciaOriginal(string $numeroOriginal= '', string $regExp = ''): string
        {
            $isRegex = preg_match('/^\/.*\/$/', $regExp);
            if($isRegex)
                $regExp = '/\b(' . trim($regExp, '/') . ')\b(.*)/';
            else
                $regExp = '/(' . $regExp . ')(.*)/';
            preg_match($regExp, $numeroOriginal, $matches);
            return trim($matches[2] ?? "");
        }

        private function setRerenciaOriginal(string $numeroOriginal= '', string $regExp = ''): void
        {
            $this->referencia_original = $this->getReferenciaOriginal($numeroOriginal, $regExp);
        }
        /**
         * Appends the reference original to the remarks.
         */
        private function addRerencetoRemarks(): void
        {
            if($this->banco_mov_tipo_id != 6 && $this->banco_mov_tipo_id != 11)
                $this->remarks .= $this->referencia_original;
        }

        /**
         * Processes logic for 'Retiro' (withdrawal) entries.
         */
        public function processRetiro($arr_DicDatosBanco, $now, &$debo_insertar): bool
        {
            foreach ($arr_DicDatosBanco[$this->es] as $vddB) {
                foreach ($vddB['palabra_clave'] as $kw) {
                    if ($this->matchesBankAccount($vddB) && $this->matchesKeyword($kw, $vddB) && $this->matchesAmount($vddB)) {
                        $this->setRerenciaOriginal($this->numero_original, $kw);
                        $this->applyBancoDetails($vddB, $kw, $now); // detalle
                        $this->applyGlobalReplaces($vddB, $kw); // detalle con title
                        $this->handleAddEmpresatoTitle($vddB);
                        $this->addRerencetoRemarks();
                        $this->setPolizaContable();
                        $this->remarks = $this->remarks_title . trimandAddNewLineandBR($this->remarks);

                        // hacemos el set de la plantilla, si es que tiene
                        $this->plantilla_id = !empty($vddB['plantilla_withdrawals_de_banco_id']??'')?$vddB['plantilla_withdrawals_de_banco_id']:'';
                        $this->banco_diccionario_dato_id = $vddB['banco_diccionario_dato_id']??'';

                        if ($vddB['accion_extra'] == 'FIDUCIARIO') {
                            $this->handleFiduciarioAlta($now);
                        } elseif ($vddB['accion_extra'] == 'INVERSION') {
                            $this->handleInversionApertura($now);
                        }

                        if ($this->banco_id == 14) { // Auto-authorize Monex transactions
                            $this->withdrawal_autorizado = 'Si';
                            $debo_insertar = true;
                        }
                        return true; // Stop further processing
                    }
                }
            }
            $this->banco_mov_tipo_id = '17'; // Default value if no match
            return false;
        }

        /**
         * Processes logic for 'Deposito' (deposit) entries.
         * @throws DateMalformedStringException
         */
        private function processDeposito($arr_DicDatosBanco, $now, $gIAParametros, $usuario_automatico, &$debo_insertar, &$esListo, &$ya_insertado, $debug): bool
        {
            $this->numero_original = $this->numero_original ?? '';

            // Specific logic for Monex
            if ($this->banco_id == 14 && (str_contains($this->numero_original, "DE REVISION") || str_contains($this->numero_original, "GENERICO PRIVADO"))) {
                $this->go = 'NO'; // Skip this transaction
                return false;
            }

            foreach ($arr_DicDatosBanco[$this->es] as $vddB) {
                foreach ($vddB['palabra_clave'] as $kw) {
                    if ($this->matchesKeyword($kw, $vddB)) {
                        $this->applyBancoDetails($vddB, $kw, $now);
                        $this->applyGlobalReplaces($vddB);
                        $this->handleAddEmpresatoTitle($vddB);
                        if ($vddB['accion_extra'] == 'INVERSION' && $this->banco_id == 14) {
                            $debo_insertar = true;
                            $this->handleInversionReembolso($vddB, $gIAParametros, $usuario_automatico, $now, $debo_insertar, $esListo, $ya_insertado);
                        } elseif ($vddB['accion_extra'] == 'LINKPROPIAS') {
                            $debo_insertar = true;
                            $this->handleLinkCuentasPropias($vddB, $gIAParametros, $usuario_automatico, $now, $debo_insertar, $esListo, $ya_insertado, $kw, $debug);
                        }

                        file_debug_reporte(); // Log debug report
                        return true;
                    }
                }
            }

            $this->banco_mov_tipo_id = '2'; // Default deposit with commission
            return false;
        }

        private function matchesAmount($vddB): bool{
            $monto_maximo = $vddB['monto_maximo'] ?? 0;
            $monto_minimo = $vddB['monto_minimo'] ?? 0;

            if($monto_maximo == 0 && $monto_minimo == 0){
                return true;
            }

            $monto_maximo = $monto_maximo == 0 ? 999999999999.99 : $monto_maximo;

            $spaces_html = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            if ($this->alta_tipo == 'manual') {
                $monto_maximo = $monto_maximo * 1.31;
                $monto_minimo = $monto_minimo * 0.67;
                $this->banco_diccionario_dato_remarks .= "\r\n<li>alta_tipo: manual\r\n\r\n" .
                    "$spaces_html monto_maximo (por los incrementos y pruebas):\r\n$spaces_html<strong>" . echonf($vddB['monto_maximo'], true) . " * 1.31 = " . echonf($monto_maximo, true) . "</strong>\r\n\r\n" .
                    "$spaces_html monto_minimo (por las pruebas):\r\n$spaces_html<strong>" . echonf($vddB['monto_minimo'], true) . " * 0.67 = " . echonf($monto_minimo, true) . "</strong>";
            }
            else{
                $monto_maximo = $monto_maximo * 1.13;
                $monto_minimo = $monto_minimo * 0.99;
                $this->banco_diccionario_dato_remarks .= "\r\n<li>alta_tipo: automatico\r\n\r\n" .
                    "$spaces_html monto_maximo (por los incrementos):\r\n$spaces_html<strong>" . echonf($vddB['monto_maximo'], true) . "</strong> * 1.13 = <strong>" . echonf($monto_maximo, true) . "</strong>\r\n\r\n" .
                    "$spaces_html monto_minimo (por si las moscas):\r\n$spaces_html<strong>" . echonf($vddB['monto_minimo'], true) . "</strong> * 0.99 = <strong>" . echonf($monto_minimo, true) . "</strong>\r\n";
            }

            if($this->withdrawal >= $monto_minimo && $this->withdrawal <= $monto_maximo){
                $this->banco_diccionario_dato_remarks .= "\r\n<li>Pasó porque el monto está dentro de los límites:\r\n\r\n $spaces_html <strong>" .
                    echonf($this->withdrawal, true) . "</strong> >= <strong>" . echonf($monto_minimo, true) . " (monto_minimo)</strong>\r\n $spaces_html && <strong>" . echonf($this->withdrawal, true) . "</strong> <= <strong>" . echonf($monto_maximo, true) . " (monto_maximo)</strong>";
                return true;
            }

            if(!estoyEnServidor()){
                $this->banco_diccionario_dato_remarks .= "\r\n<li>Pasó porque no estoy en el servidor, estoy en => " . estoyEn();
                return true;
            }
            $this->banco_diccionario_dato_remarks .= "<li>No Pasó";
            return false;
        }

        private function matchesBankAccount($vddb): bool{
            if(is_array($vddb['banco_cuenta_no_aplica']) && array_key_exists($this->banco_cuenta_id, $vddb['banco_cuenta_no_aplica'])) {
                return false;
            }
            return true;
        }

        /**
         * Matches a keyword against the transaction number or remarks.
         */
        private function matchesKeyword($kw, $vddB): bool
        {
            // Check if $kw is a regex pattern (starts and ends with '/')
            $isRegex = preg_match('/^\/.*\/$/', $kw) || str_contains($kw, '*');
            $matchesKeyword = false;
            $matches = [];
            $match_ = "";
            $regex_match = '';
            $remarks_ref_original = $this->alta_tipo == "manual" ? "$this->remarks $this->numero_original" : $this->numero_original;
            if ($isRegex) {
                // Perform regex search if $kw is a regex pattern
                $kw = vx_parse_str_to_regex($kw);

                $matchesKeyword = preg_match($kw, $remarks_ref_original, $matches);
                $regex_match = base64_encode($kw);
                $match_ = '';
                if ($matchesKeyword) {
                    $match_ = ($matches[2]??'');
                    if (empty($match_)) {
                        foreach ($matches as $value) {
                            if (!empty($value)) {
                                $match_ = $value;
                                break;
                            }
                        }
                    }
                }
            } else {
                // Use str_contains for a simple substring search
                $matchesKeyword = str_contains($remarks_ref_original, $kw);
                $match_ = $matchesKeyword ? $kw : "";
//                echo "<pre>$kw: $match_" . print_r($this, true) . "</pre>";
////                die();
            }
            if($matchesKeyword) {
                $this->numero_original_tagged = str_replace($match_, '<a href="../backoffice/banco_diccionario_dato.php?id=' . $vddB['banco_diccionario_dato_id'] . '&iah=e&kw=' . $match_ . (!empty($regex_match) ? "&match=$regex_match" : "") . '" target="_blank" class="numero_original_tagged">' . $match_ . '</a>', $this->numero_original);
                $this->banco_diccionario_dato_remarks .= "\r\n<li>Hizo match con el texto: <i class='txt_shadow_orange'>" . base64_decode($regex_match) ."</i>\r\n";
            }
            else{
                $this->numero_original_tagged = $this->numero_original;
            }
            return $matchesKeyword;
        }


        public function matchesKeyword__($kw, $item_diccionario): bool
        {
            return $this->matchesKeyword($kw, $item_diccionario) && $this->matchesBankAccount($item_diccionario) && $this->matchesAmount($item_diccionario);
        }


        /**
         * Applies bank details from the dictionary entry.
         */
        public function applyBancoDetails($vddB, $kw, $now): void
        {
            $this->banco_mov_tipo_id = $vddB['banco_mov_tipo_id'];

            $this->remarks = trimandAddNewLineandBR($vddB['descripcion_a_poner']) . ($vddB['agregar_palabra_clave'] == 'Si' ? " " . $kw : "");

            if ($this->alta_tipo != 'manual') {
                $this->link_vale = $vddB['link_vale']??'';
            }

            $this->withdrawal_autorizado = $vddB['withdrawal_autorizado']??'';
            $this->categoria_gasto_id = $vddB['categoria_gasto_id']??'';

            if ($this->withdrawal_autorizado == 'Si') {
                $this->withdrawal_autorizado_el = $now;
                $this->withdrawal_autorizado_por = 'sistema';
            }
        }

        public function applyGlobalReplaces($vddB = [], $kw = ''): void
        {
            $this->withdrawal = floatval($this->withdrawal ?? 0);
            $this->deposit = floatval($this->deposit ?? 0);
            $globalReplaces = [
                '%TWOMONTHSAGO%' => getMonth("", date('Y-m-d', strtotime("-2 month", strtotime($this->fecha)))),
                '%TWOMONTHSAGOYEAR%' => date('Y', strtotime("-2 month", strtotime($this->fecha))),
                '%LASTMONTH%' => getMonth("", date('Y-m-d', strtotime("-1 month", strtotime($this->fecha)))),
                '%LASTMONTHYEAR%' => date('Y', strtotime("-1 month", strtotime($this->fecha))),
                '%MONTH%' => getMonth("", date('Y-m-d', strtotime($this->fecha))),
                '%YEAR%' => date('Y', strtotime($this->fecha)),
                '%FIRSTDAYMONTH%' => "01",
                '%FIRSTDAY%' => "01",
                '%LASTDAYMONTH%' => date('t', strtotime($this->fecha)), // Last day of the current month
                '%LASTDAY%' => date('t', strtotime($this->fecha)), // Last day of the current month
                '%FIRSTDAYLASTMONTH%' => "01",
                '%LASTDAYLASTMONTH%' => date('t', strtotime("-1 month", strtotime($this->fecha))), // Last day of last month
                '%FIRSTDAYTWOMONTHSAGO%' => "01",
                '%LASTDAYTWOMONTHSAGO%' => date('t', strtotime("-2 month", strtotime($this->fecha))), // Last day of two months ago

                // Week calculations
                '%THISWEEK%' => date('W', strtotime($this->fecha)), // Week number of the year
                '%FIRSTDAYTHISWEEK%' => date('j', strtotime("monday this week", strtotime($this->fecha))), // Day of the month for Monday
                '%LASTDAYTHISWEEK%' => date('j', strtotime("sunday this week", strtotime($this->fecha))), // Day of the month for Sunday

                '%WITHDRAWAL%' => number_format($this->withdrawal, 2, '.', ',') // monto del retiro
            ];



            $old_remarks = $this->remarks;
            // Perform the replacement
            $this->remarks = str_replace(array_keys($globalReplaces), array_values($globalReplaces), $this->remarks);
            $this->remarks = str_replace("'", "", $this->remarks);
            // if($this->remarks != $old_remarks) {
                if (!empty($vddB['nombre']))
                    $this->remarks_title = '<strong class="txt18pxfr txt_bold_red txt_centered" style="min-width: 335px;">' . $vddB['nombre'] . " %EMPRESANOMBRE% </strong><br>" . PHP_EOL;
            // }
        }

        /**
         * Assigns the 'link_vale' based on the 'banco_mov_tipo_id'.
         */
        private function assignLinkVale($banco_mov_tipo_id): string
        {
            return match ($banco_mov_tipo_id) {
                '6', '11', '10' => 'SYS',
                '2' => 'Q',
                default => 'ND',
            };
        }

        public function assignContextualLinkVale(string $context, int $banco_mov_tipo_id): ?string
        {
            $keywords = explode(',', strtoupper($context));

            foreach ($keywords as $keyword) {
                $keyword = trim($keyword);

                if (str_contains($keyword, 'SALVO') && $banco_mov_tipo_id === 2) {
                    return 'SBC';
                }

                if (str_contains($keyword, 'INVER') && $banco_mov_tipo_id === 22) {
                    return 'INV';
                }

                if (str_contains($keyword, 'FIDUC') && $banco_mov_tipo_id === 21) {
                    return 'FID';
                }
            }

            // HOLD gets a silent pass—no keywords, just ID.
            if ($banco_mov_tipo_id === 18) {
                return 'HOLD';
            }

            return null; // Alone. Forgotten. He looked, no one looked back.
        }


        private function setPolizaContable(): void
    {
        $this->poliza_contabilidad = $this->obtenPolizaContable($this->remarks);
    }
    private function obtenPolizaContable($str): string
    {
            $arrPoliza = ['',''];
            $strBenefic = '';
            $strVariante = [];

            if (strlen($str) === 0) {
                return "";
            }

            // Replace patterns in the string similar to JavaScript code
            $str = preg_replace('/\*+/', "@\r\n", $str);
            $str = preg_replace('/;+/', "@\r\n", $str);
            $str = preg_replace('/:+/', "@\r\n", $str);

            // Split the modified string by line breaks
            $strVariante = preg_split('/\r\n|\r|\n/', $str);

            // Process each line
            if (count($strVariante) > 0) {
                foreach ($strVariante as $ren => $line) {
                    $line = trim($line); // Trim each line
                    if (empty($line)) continue;

                    // Check if strBenefic is not set and line contains "@"
                    if (empty($strBenefic) && str_contains($line, "@")) {
                        $strBenefic = str_replace("@", "*", $line);
                        $arrPoliza[0] = trim($strBenefic);
                    }
                    // Append to the second element if the line is not empty
                    else {
                        $arrPoliza[1] .= str_replace("@", "", $line) . "\r\n";
                    }
                }
            }
            if(!empty($arrPoliza) && array_key_exists(0, $arrPoliza) && array_key_exists(1, $arrPoliza))
                return $arrPoliza[0] . "*****\n" . $arrPoliza[1];
            return "";
        }



        /**
         * @throws DateMalformedStringException
         */
        function handleLinkCuentasPropias($vddB, $gIAParametros, $usuario_automatico, $now, &$debo_insertar, &$esListo, &$ya_insertado, $kw, $debug = false): bool
        {

            global $gIAsql;
            $nowMoment = new DateTime($now);
            $nowMoment->modify("+1 second");//Puede ser lento.
            $now = $nowMoment->format('Y-m-d H:i:s');
            if($debug !== false)
                $debug = 1;

            $BancoT = $this->linkpropioHelperInitializeBancoT();

            // Detect the origin account
//            $BancoT->origen_banco_cuenta_id = $this->linkpropioHelperDetectCuentaOrigen($kw);

            // Detect the original movement
            $bcmo = $this->linkpropioHelperDetectMovimientoOrigen($BancoT, $kw, $this->numero_original);
            if (empty($bcmo)) {
                $esListo = false;
                return $esListo;
            }
            if($debug !== false) {
                ia_errores_a_dime($debug++ . "<pre>linkpropioHelperDetectMovimientoOrigen:" . PHP_EOL . print_r($bcmo, true) . "</pre>");
                sleep(1);
            }
            $this->linkpropioHelperUpdateBancoTWithMovimientoOrigen($BancoT, $bcmo);
            if($debug !== false) {
                ia_errores_a_dime($debug++ . "<pre>linkpropioHelperUpdateBancoTWithMovimientoOrigen:" . PHP_EOL . print_r($bcmo, true) . PHP_EOL . print_r($BancoT, true) . "</pre>");
                sleep(1);
            }
            // Ensure valid banco_cuenta_mov_id for origin
            if (empty($bcmo['banco_cuenta_mov_id']) || strlen($bcmo['banco_cuenta_mov_id']) < 32) {
                $esListo = false;
                return $esListo;
            }

            $sql = $this->insertaBancoCuentaMov(false, false, false);
            if($debug !== false) {
                ia_errores_a_dime($debug++ . "<pre>insertaBancoCuentaMov:" . PHP_EOL . print_r($sql, true) . "</pre>");
                sleep(1);
            }



            // Fetch account and company details for both origin and destination
            list($ctaBancariaDestino, $ctaBancariaOrigen, $empresaDestino, $empresaOrigen, $empidDestino, $empidOrigen, $destino_tipo_inversion_empresa_privada, $origen_tipo_inversion_empresa_privada, $origen_moneda_id, $destino_moneda_id) = $this->linkpropioHelperFetchAccountDetails($BancoT);

            // Prepare the transaction details based on whether the companies are the same
            list($cliente, $factura, $banco_mov_tipo_id, $factura_numero, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $iva_incluido, $ivacobradox100, $ivacobradototal, $remarksTitle) = $this->linkpropioHelperPrepareTransactionDetails($empidOrigen, $empidDestino, $destino_tipo_inversion_empresa_privada, $empresaDestino, $ctaBancariaOrigen, $ctaBancariaDestino);

            // Request the bank link
            $arrInfoLink = $this->linkpropioHelperRequestBankLink($BancoT, $bcmo, $cliente, $factura_numero, $factura, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $empidDestino, $iva_incluido, $ivacobradox100, $ivacobradototal, $usuario_automatico, $origen_moneda_id, $destino_moneda_id, $remarksTitle);

            // Process the link request response
            $link_exitoso = $this->linkpropioHelperProcessLinkResponse($arrInfoLink, $bcmo);
            if (!$link_exitoso) {
                $ya_insertado = false;
                $esListo = false;
                return $esListo;
            }
            if($debug !== false) {
                ia_errores_a_dime($debug++ . "<pre>arrInfoLink:" . PHP_EOL . print_r($arrInfoLink, true) . "</pre>");
                sleep(1);
            }
            $banco_cuenta_trans_id = ia_guid();

            // Prepare and execute the SQL statements
            $sql = array_merge($sql, $this->linkpropioHelperUpdateLinkvaleBCM($BancoT, $bcmo, $banco_mov_tipo_id, $usuario_automatico, $arrInfoLink));

            $bancoCuentaTrans = [];
            $sql[] = $this->linkpropioHelperInsertBancoCuentaTransfer($BancoT, $arrInfoLink, $cliente, $factura_numero, $factura, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $empidDestino, $iva_incluido, $ivacobradox100, $ivacobradototal, $usuario_automatico, $banco_cuenta_trans_id, $now, $bcmo, $bancoCuentaTrans, $remarksTitle);
            $sql[] = $this->linkpropioHelperHandleDiffCurrency($BancoT, $empidDestino, $empresaDestino, $banco_cuenta_trans_id);

            if($debug !== false) {
                ia_errores_a_dime($debug++ . "<pre>after linkpropioHelperHandleDiffCurrency:" . PHP_EOL . print_r($sql, true) . PHP_EOL . print_r($BancoT, true) . "</pre>");
                sleep(1);
            }


            if ($this->banco_id == 14){

                $ya_insertado = true;
                $this->go = 'NO'; // This makes the importer ignore this record

                if(ia_transaction($sql)) {
                    $ya_insertado = false;
                    file_debug_reporte();
                    ia_errores_a_dime();
                }
                // Additional transactions for currency exchange and remarks updates
                $sql_ = $this->linkpropioHelperGeneraRemarks($banco_cuenta_trans_id, $BancoT, $bcmo, $usuario_automatico, $bancoCuentaTrans);

                if($debug !== false) {
                    ia_errores_a_dime($debug++ . "<pre>linkpropioHelperGeneraRemarks:" . PHP_EOL . print_r($sql_, true) . "</pre>");
                    sleep(1);
                }

                if(ia_transaction($sql_)) {
                    file_debug_reporte();
                    ia_errores_a_dime();
                }
                $sql_ = [];
                $sql_[] = insert_update_links_al_banco_live(banco_cuenta_trans_id: $banco_cuenta_trans_id);
                if (ia_transaction($sql_)) {
                    file_debug_reporte();
                    ia_errores_a_dime();
                }
                $esListo = true;
                return $esListo;

            }elseif ($this->banco_id == 1) {
                $ya_insertado = true;
                $debo_insertar = false;
                $this->go = 'NO';

                if(ia_transaction($sql)) {
                    $ya_insertado = false;
                    file_debug_reporte();
                    ia_errores_a_dime();
                }

                $this->afterInsertInstructions[] = $banco_cuenta_trans_id;


                $esListo = true;
                return $esListo;
            }

            $esListo = true;
            return $esListo;
        }

        private function linkpropioHelperHandleDiffCurrency($BancoT, $empidDestino, $empresaDestino, $banco_cuenta_trans_id)
        {
            if($BancoT->origen_moneda_id!=$BancoT->destino_moneda_id) {
                $pre_refd = '';
                if (VARS_DEFAULT['tipo_cambio']['version_revisa_tc'] === 'v2') {
                    $tc_response_keys = VARS_DEFAULT['tipo_cambio']['response'];
                    $tc_estados = VARS_DEFAULT['tipo_cambio']['estado_tasa'];
                    $tc_response = revisaTipodeCambio($BancoT->tipo_cambio, true, $BancoT->tipo_cambio);
                    $tc_estado = $tc_estados[$tc_response];
                    $pre_refd = $tc_estado['message']."<br><br><span class='bg-warning text-danger bold ml-2'>TIPO DE CAMBIO ACEPTADO POR: <b class='txt_color_PESOS'>LINK AUTOMATICO</b></span>";
                }
                return registraMovimientoDivisa($pre_refd, $BancoT->tipo_cambio, 'NO', $BancoT->tipo_cambio, $empidDestino, $empresaDestino, $banco_cuenta_trans_id, 'banco_cuenta_trans', tc_by_pass: true);
            }
        }

        private function linkpropioHelperInsertBancoCuentaTransfer($BancoT, $arrInfoLink, $cliente, $factura_numero, $factura, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $empresa_id, $iva_incluido, $ivacobradox100, $ivacobradototal, $usuario_automatico, $banco_cuenta_trans_id, $now, $bcmo, &$banco_cuenta_trans, $remarksTitle): string|array
        {
            $nowMoment = new DateTime($now);
            $nowMoment->modify("+1 second");//Puede ser lento.
            $now = $nowMoment->format('Y-m-d H:i:s');

            $banco_cuenta_trans = [
                'banco_cuenta_trans_id'        => $banco_cuenta_trans_id,
                'origen_banco_cuenta_id'       => $BancoT->origen_banco_cuenta_id,
                'origen_fecha'                 => $BancoT->origen_fecha,
                'destino_banco_cuenta_id'      => $BancoT->destino_banco_cuenta_id,
                'destino_fecha'                => $BancoT->destino_fecha,
                'monto'                        => $BancoT->monto,
                'referencia'                   => $remarksTitle,
                'alta_db'                      => $now,
                'alta_por'                     => $usuario_automatico,
                'activo'                       => 'Si',
                'puede_borrar'                 => 'Si',
                'status'                       => 'COMPLETA',
                'banco_cuenta_mov_link_id'     => $arrInfoLink['link_id'],
                'numero_referencia'            => $arrInfoLink['ref_num'],
                'remarks'                      => $remarksTitle,
                'banco_cuenta_id'              => $BancoT->destino_banco_cuenta_id,
                'egreso'                       => $BancoT->monto,
                'deposit_fecha'                => $BancoT->destino_fecha,
                'quantity_total'               => $BancoT->monto,
                'cuentaT_tipo_mov_id'          => '2',
                'fecha'                        => $now,
                'fecha_capturado'              => $now,
                'factura'                      => $factura,
                'factura_numero'               => $factura_numero,
                'cliente'                      => $cliente,
                'tipo_cash_nota'               => $tipo_cash_nota,
                'cash_nota_num'                => $cash_nota_num,
                'cliente_rfc'                  => $cliente_rfc,
                'empresa_id'                   => $empresa_id,
                'iva_incluido'                 => $iva_incluido,
                'ivacobradox100'               => $ivacobradox100,
                'ivacobradototal'              => $ivacobradototal,
                'moneda_id'                    => $BancoT->destino_moneda_id,
                'origen_moneda_id'             => $BancoT->origen_moneda_id,
                'monto_origen'                 => $BancoT->monto_origen,
                'tipo_cambio'                  => ($BancoT->tipo_cambio == 0 ? $bcmo['tipo_cambio'] : $BancoT->tipo_cambio),
                'origen_mov_id'                => $bcmo['banco_cuenta_mov_id'],
                'ultimo_cambio_por'            => '', // Empty value
                'cuentaT_id'                   => '', // Empty value
                'contpaq_cliente_id'           => ''  // Empty value
            ];
            $insert_sql = ia_insert('banco_cuenta_trans', $banco_cuenta_trans);
            $banco_cuenta_trans['destino_moneda_id'] = $BancoT->destino_moneda_id;
            $banco_cuenta_trans['origen_empresa_id'] = $this->fetchEmpresaIdFromBancoCuenta($bcmo['banco_cuenta_id']);;
            return $insert_sql;
        }

// Helper to initialize the BancoT object with default values
    private function linkpropioHelperInitializeBancoT(): stdClass
    {
        $BancoT = new stdClass();
        $BancoT->origen_banco_cuenta_id = 0;
        $BancoT->destino_banco_cuenta_id = $this->banco_cuenta_id;
        $BancoT->banco_cuenta_id = $this->banco_cuenta_id;
        $BancoT->monto = $this->deposit;
        $BancoT->monto_origen = 0;
        $BancoT->origen_fecha = !empty($this->fecha) ? date('Y-m-d', strtotime($this->fecha)) : date('Y-m-d');
        $BancoT->destino_fecha = $BancoT->origen_fecha;
        $BancoT->origen_banco_cuenta_mov_id = "";
        $BancoT->destino_banco_cuenta_mov_id = $this->banco_cuenta_mov_id;
        $BancoT->origen_moneda_id = 0;
        $BancoT->destino_moneda_id = limpiaCantidad($this->moneda_id);
        $BancoT->moneda_id = limpiaCantidad($this->moneda_id);
        $BancoT->tipo_cambio = limpiaCantidad("0");
        return $BancoT;
    }

// Helper to detect the origin account
    private function linkpropioHelperDetectCuentaOrigen($kw): bool|array
    {
        return $this->detectaCuentaOrigen($kw);
    }

// Helper to detect the original movement
    private function linkpropioHelperDetectMovimientoOrigen(&$BancoT, $kw, $numero_original, $debug = false): bool|array
    {
        return $this->detectaMovimientoOrigen($BancoT, $kw, $numero_original, $debug);
    }

// Helper to update BancoT object with the movement origin details
    private function linkpropioHelperUpdateBancoTWithMovimientoOrigen(&$BancoT, $bcmo)
    {
        $BancoT->origen_banco_cuenta_id = $bcmo['banco_cuenta_id'];
        $BancoT->origen_banco_id = $bcmo['banco_id'];
        $BancoT->origen_moneda_id = $bcmo['moneda_id'];
        $BancoT->origen_fecha = $bcmo['fecha'];
        $BancoT->monto_origen = $bcmo['withdrawal'];
        $BancoT->origen_banco_cuenta_mov_id = $bcmo['banco_cuenta_mov_id'] ?? '';
        $BancoT->usdAmount = $bcmo['usdAmount'] ?? '';
        $BancoT->pesosAmount = $bcmo['pesosAmount'] ?? '';
        $BancoT->exchangeRate = $bcmo['exchangeRate'] ?? '';
        $BancoT->tipo_cambio = $bcmo['exchangeRate'] ?? '';
        $BancoT->referenceNumber = $bcmo['referenceNumber'] ?? '';

        return $BancoT;
    }

// Helper to fetch details of the origin and destination accounts and companies
    private function linkpropioHelperFetchAccountDetails($BancoT): array
    {
        $method = " /** " . __METHOD__ ." **/ ";
        $arrDestino = ia_singleton("SELECT $method bc.nombre as banco, bc.empresa_id, e.empresa as empresa, bc.tipo_inversion_empresa_privada, bc.moneda_id FROM banco_cuenta bc LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id WHERE bc.banco_cuenta_id = '$BancoT->destino_banco_cuenta_id'");
        $arrOrigen = ia_singleton("SELECT $method bc.nombre as banco, bc.empresa_id, e.empresa as empresa, bc.tipo_inversion_empresa_privada, bc.moneda_id FROM banco_cuenta bc LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id WHERE bc.banco_cuenta_id = '$BancoT->origen_banco_cuenta_id'");

        return [
            $arrDestino['banco'], $arrOrigen['banco'],
            $arrDestino['empresa'], $arrOrigen['empresa'],
            $arrDestino['empresa_id'], $arrOrigen['empresa_id'],
            $arrDestino['tipo_inversion_empresa_privada'], $arrOrigen['tipo_inversion_empresa_privada'],
            $arrDestino['moneda_id'], $arrOrigen['moneda_id'],
        ];
    }

// Helper to prepare transaction details based on company relationship
    private function linkpropioHelperPrepareTransactionDetails($empidOrigen, $empidDestino, $destino_tipo_inversion_empresa_privada, $empresaDestino, $ctaBancariaOrigen, $ctaBancariaDestino): array
    {
        $method = " /** " . __METHOD__ ." **/ ";
        if ($empidOrigen != $empidDestino) {
            $cliente = $empresaDestino;
            $factura_numero = "";
            $factura = "FACTURA";
            $tipo_cash_nota = "OTRO";
            $cash_nota_num = "NUESTRO";
            $cliente_rfc = "";
            $empresa_id = $empidDestino;
            $iva_incluido = "NO";
            $ivacobradox100 = "0";
            $ivacobradototal = 0;
            if ($destino_tipo_inversion_empresa_privada == "privada") {
                $factura = "ASIMILADOS";
            }
            $banco_mov_tipo_id = 24;

            $remarksTitle = "<strong class='txt18pxfr txt_bold_red txt_centered' style='min-width: 335px;'>PAGO DE {$factura}</strong>{$ctaBancariaOrigen} A {$ctaBancariaDestino}";

        } else {
            $cliente = "";
            $factura_numero = "";
            $factura = "NUESTRO";
            $tipo_cash_nota = "OTRO";
            $cash_nota_num = "PROPIAS";
            $cliente_rfc = "";
            $empresa_id = $empidDestino;
            $iva_incluido = "NO";
            $ivacobradox100 = 0;
            $ivacobradototal = 0;
            $banco_mov_tipo_id = 18;

            $remarksTitle = "<strong class='txt18pxfr txt_bold_red txt_centered' style='min-width: 335px;'>TRASPASO ENTRE CUENTAS PROPIAS</strong><br>DE {$ctaBancariaOrigen} A {$ctaBancariaDestino}";
        }





        return [$cliente, $factura, $banco_mov_tipo_id, $factura_numero, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $iva_incluido, $ivacobradox100, $ivacobradototal, $remarksTitle];
    }

// Helper to request the bank link
    private function linkpropioHelperRequestBankLink($BancoT, $bcmo, $cliente, $factura_numero, $factura, $tipo_cash_nota, $cash_nota_num, $cliente_rfc, $empresa_id, $iva_incluido, $ivacobradox100, $ivacobradototal, $usuario_automatico, $origen_moneda_id, $destino_moneda_id): array
    {
        // Fetch ghost movement variables
        $ghost_mov = get_object_vars($this);

        return SolicitaLinkBancario([
            'link' => $bcmo['banco_cuenta_mov_id'],
            'link_to' => 'banco_cuenta_mov',
            'tienda_id' => 0,
            'withdrawal' => 0,
            'deposit' => $BancoT->monto,
            'cash' => 0,
            'monto_acta' => $BancoT->monto,
            'fecha' => $BancoT->destino_fecha,
            'banco_mov_tipo_id' => '5',
            'banco_cuenta_id' => $BancoT->destino_banco_cuenta_id,
            'cliente' => $cliente,
            'factura_numero' => $factura_numero,
            'factura' => $factura,
            'tipo_cash_nota' => $tipo_cash_nota,
            'cash_nota_num' => $cash_nota_num,
            'cliente_rfc' => $cliente_rfc,
            'empresa_id' => $empresa_id,
            'iva_incluido' => $iva_incluido,
            'ivacobradox100' => $ivacobradox100,
            'ivacobradototal' => $ivacobradototal,
            'origen_moneda_id' => $BancoT->origen_moneda_id,
            'destino_moneda_id' => $BancoT->destino_moneda_id,
            'monto_origen' => $BancoT->monto_origen,
            'monto_destino' => $BancoT->monto,
            'tipo_cambio' => $BancoT->tipo_cambio,
            'banco_cuenta_mov_id' => addslashes($BancoT->destino_banco_cuenta_mov_id ?? "")
        ], $usuario_automatico, "NO", $ghost_mov);
    }

// Helper to process the link response
    private function linkpropioHelperProcessLinkResponse($arrInfoLink, $bcmo): bool
    {
        if (!empty($arrInfoLink['link_id'])) {
            return true;
        } else {
            return false;
        }
    }

// Helper to prepare and execute SQL statements for the transaction

    /**
     * Updates the 'banco_cuenta_mov' records with provided information.
     *
     * @param object $BancoT An object containing information about the bank transaction.
     * @param array $bcmo An array containing the current bank movement object.
     * @param int $banco_mov_tipo_id The ID representing the type of the bank movement.
     * @param string $usuario_automatico The identifier for the user making the automatic changes.
     * @param array $arrInfoLink Array containing additional information for updating the records.
     *
     * @return array A set of SQL update queries to be executed.
     */
    private function linkpropioHelperUpdateLinkvaleBCM(object $BancoT, array $bcmo, int $banco_mov_tipo_id, string $usuario_automatico, array $arrInfoLink): array
    {
        $sql = (array) $arrInfoLink['sql'];

        $sql[] = "UPDATE banco_cuenta_mov SET
                usado = '$BancoT->monto_origen',
                link_vale = IF(link_vale IN ('NAVIERA', 'GARANTIA'), link_vale, 'LT'),
                puede_editar = 'No',
                banco_mov_tipo_id = '$banco_mov_tipo_id',
                ultimo_cambio = CURRENT_TIMESTAMP,
                ultimo_cambio_por = '$usuario_automatico',
                withdrawal_autorizado = 'No',
                withdrawal_autorizado_por = '',
                withdrawal_autorizado_el = null
              WHERE banco_cuenta_mov_id = '{$bcmo['banco_cuenta_mov_id']}' LIMIT 1";

        $sql[] = "UPDATE banco_cuenta_mov SET
                link_vale = 'LT',
                banco_mov_tipo_id = '$banco_mov_tipo_id',
                ultimo_cambio = CURRENT_TIMESTAMP,
                ultimo_cambio_por = '$usuario_automatico'
              WHERE banco_cuenta_mov_id = '{$arrInfoLink['bcm_id']}' LIMIT 1";

        return $sql;
    }

// Helper to prepare additional SQL queries for currency exchange and remarks
    private function linkpropioHelperGeneraRemarks(string $banco_cuenta_trans_id = "", $BancoT = "", $bcmo = [], string $usuario_automatico = "", $bancoCuentaTrans = []): array
    {
        return globalLinkpropioHelperGeneraRemarks($banco_cuenta_trans_id, $BancoT, $bcmo,$usuario_automatico,$bancoCuentaTrans);
    }

    function esHSBC($text, &$BancoT, $numero_original, &$origen_monto, &$refencia = "", &$bcmo_arr = [], $debug = false): bool|int
    {
        $text = $numero_original;
        // Check if 'HSBC' is present in the text
        if (str_contains($text, 'HSBC')) {
            return 5; // Return true if either string is found
        } else {
            return false; // Return false if neither is found
        }
    }
    function esBanorte($text, &$BancoT, $numero_original, &$origen_monto, &$refencia = "", &$bcmo_arr = [], $debug = false): bool|int
    {
        $text = $numero_original;
        // Check if 'BNTE' or 'BANORTE' is present in the text
        if (str_contains($text, 'BANORTE') || str_contains($text, 'BNTE')) {
            return 3; // Return true if either string is found
        } else {
            return false; // Return false if neither is found
        }
    }
    function esBancomer($text, &$BancoT, $numero_original, &$origen_monto, &$refencia = "", &$bcmo_arr = [], $debug = false): bool|int
    {
        $text = $numero_original;
        // Check if 'BBVA' or 'BANCOMER' is present in the text
        if (str_contains($text, 'BBVA') || str_contains($text, 'BANCOMER')) {
            return 1; // Return true if either string is found
        } else {
            return false; // Return false if neither is found
        }
    }
    function esMonex($text, &$BancoT, $numero_original, &$origen_monto, &$refencia = "", &$bcmo_arr = [], $debug = false): bool|int
    {
        $method = " /** " . __METHOD__ ." **/ ";

        $text = $numero_original;
        // Check if the text contains both "COMPRA" and "DIVISAS"
        if (str_contains($text, 'COMPRA') && str_contains($text, 'DIVISAS')) {
            // Extract the USD quantity, handling both "PESO MEXICANO" and "DOLAR AMERICANO"
            if (preg_match('/(?:PESO MEXICANO|DOLAR AMERICANO) (\d+) USD/', $text, $usdMatch)) {
                $usdAmount = $usdMatch[1]; // USD quantity
            } else {
                $usdAmount = '';
            }

            // Extract the exchange rate using regex
            if (preg_match('/TIPO DE CAMBIO DE (\d+) (?:DIVISA|IMPORTE EN PESOS)/', $text, $exchangeMatch)) {
                $exchangeRate = $exchangeMatch[1]; // Exchange rate
            } else {
                $exchangeRate = '';
            }

            // Extract the reference number after "DIVISA 0"
            if (preg_match('/DIVISA 0 (\d+)/', $text, $referenceMatch)) {
                $referenceNumber = $referenceMatch[1]; // Reference number
            } else {
                $referenceNumber = '';
            }

            // Extract the amount in pesos after "IMPORTE EN PESOS"
            if (preg_match('/IMPORTE EN PESOS (\d+)/', $text, $pesosMatch)) {
                $pesosAmount = $pesosMatch[1]; // Amount in pesos
            } else {
                $pesosAmount = '';
            }


            if(!empty($usdAmount) && !empty($exchangeRate) && !empty($referenceNumber)) {
                $usdAmount = $this->formatQuantityWithDecimal($usdAmount);
                $pesosAmount = $this->formatQuantityWithDecimal($pesosAmount);
                $exchangeRate = $this->formatQuantityWithDecimal($exchangeRate, 6);
                $refencia = $referenceNumber;

                $origen_monto = empty($pesosAmount) ? $BancoT->monto : echonf($pesosAmount, true, 2, "");
                $sqlo = "SELECT $method banco_cuenta_mov.*, true AS se_puede_link FROM banco_cuenta_mov WHERE usado = 0 AND link_vale NOT IN ('BL', 'LT', 'LP', 'STOP') AND withdrawal = '$origen_monto' AND fecha LIKE '$BancoT->origen_fecha%' AND numero_original LIKE '%$referenceNumber%' AND banco_cuenta_id NOT IN ('$BancoT->destino_banco_cuenta_id') ORDER BY fecha LIMIT 1";
                $bcmo_arr = ia_singleton($sqlo);
                $banco_id = false;
                if(is_array($bcmo_arr) && !empty($bcmo_arr)) {
                    $bcmo_arr['usdAmount'] = $usdAmount;
                    $bcmo_arr['pesosAmount'] = $pesosAmount;
                    $bcmo_arr['exchangeRate'] = $exchangeRate;
                    $bcmo_arr['referenceNumber'] = $referenceNumber;
                    $BancoT = $this->linkpropioHelperUpdateBancoTWithMovimientoOrigen($BancoT, $bcmo_arr);
                    $banco_id = $bcmo_arr['banco_id'] ?? false;
                }
                if($debug !== false) {
                    ia_errores_a_dime("<pre>esMonex:" . PHP_EOL . "$pesosAmount, $usdAmount, $exchangeRate, $referenceNumber" . PHP_EOL . $sqlo . PHP_EOL . print_r($bcmo_arr, true) . PHP_EOL . print_r($BancoT, true) . "</pre>");
                    sleep(1);
                }
                return $banco_id;
            }
        }

        return false;
    }
    function formatQuantityWithDecimal($quantity, $decimal = 2): string
    {
        // Ensure that the quantity is treated as a string
        $quantity = strval($quantity);

        // Calculate the length of the integer part
        $integerPartLength = strlen($quantity) - $decimal;

        // If the length of the quantity is shorter than the decimal position, pad with zeros
        if ($integerPartLength <= 0) {
            $quantity = str_pad($quantity, $decimal + 1, '0', STR_PAD_LEFT);
            $integerPartLength = 1;
        }

        // Insert the decimal point at the correct position
        $formattedQuantity = substr($quantity, 0, $integerPartLength) . '.' . substr($quantity, $integerPartLength);

        return $formattedQuantity;
    }
    function detectaBanco($text, &$BancoT, $numero_original, &$origen_monto, &$refencia, &$bcmo_arr, $debug = false): string
    {
        $banco_id = false; // Initialize banco_id
        $banco_id_sql = ""; // Initialize SQL condition string

        // List of bank detection methods
        $bankDetectors = [
            'esBancomer',
            'esHSBC',
            'esBanorte',
            'esMonex',
            // Add more detection methods here
        ];

        foreach ($bankDetectors as $method) {
            // Check if the detection method exists, then call it
            if (method_exists($this, $method)) {
                $banco_id = $this->$method($text, $BancoT, $numero_original, $origen_monto, $refencia, $bcmo_arr, $debug); // Call the method and get the bank_id or false
                if (!empty($banco_id)) {
                    $banco_id_sql = " banco_id IN ('$banco_id') AND ";
                    break; // Exit loop once a bank is detected
                }
            }
        }

        return $banco_id_sql;
    }
    function detectaMovimientoOrigen(&$BancoT, $kw, $numero_original, $debug = false): bool|array
    {
        $method = " /** " . __METHOD__ ." **/ ";
         //!empty($BancoT->origen_banco_cuenta_id) ? " banco_cuenta_id = '$BancoT->origen_banco_cuenta_id' AND " : "";
        $refencia = "";
        $origen_monto = $BancoT->monto == 0 ? $BancoT->origen_monto : $BancoT->monto;
        $origen_fecha = date("Y-m-d", strtotime($BancoT->origen_fecha));
        $bcmo_arr = [];
        $banco_cuenta_origen_sql = $this->detectaBanco($kw, $BancoT, $numero_original, $origen_monto, $refencia, $bcmo_arr, $debug);

        if(!empty($bcmo_arr)) {
            $bcmo_arr['se_puede_link'] = true;
        }
        else {
            $where_sql = "$banco_cuenta_origen_sql usado = 0 AND link_vale NOT IN ('BL', 'LT', 'LP', 'STOP') AND withdrawal = '$origen_monto' AND fecha LIKE '$origen_fecha%' AND numero_original LIKE '%$refencia%' AND banco_cuenta_id NOT IN ('$BancoT->destino_banco_cuenta_id')";

            if(!empty($BancoT->origen_banco_cuenta_mov_id)) {
                $where_sql = " banco_cuenta_mov_id = '$BancoT->origen_banco_cuenta_mov_id' ";
            }
            $refencia = empty($refencia) ? $kw : $refencia;
            $sqlo = "SELECT $method banco_cuenta_mov.*, true AS se_puede_link 
                FROM banco_cuenta_mov 
                WHERE $where_sql 
                ORDER BY fecha 
                LIMIT 1";

            $bcmo_arr = ia_singleton($sqlo);
        }
        return $bcmo_arr;
    }
    function detectaCuentaOrigen($palabra_clave, $misma_moneda = true): bool|array
    {
        $banco_cuenta_id = 0;
        $moneda_id = $misma_moneda ? " AND moneda_id = " . strit($this->moneda_id) : " AND moneda_id <> " . strit($this->moneda_id) ;
        $sql_ = "SELECT banco_cuenta_id FROM banco_cuenta WHERE numero LIKE '%$palabra_clave%' $moneda_id DESC LIMIT 1";
        $banco_cuenta_id = ia_singleread($sql_);
        return $banco_cuenta_id;
    }

    function fetchEmpresaIdFromBancoCuenta($banco_cuenta_id){
        return ia_singleread("SELECT empresa_id FROM banco_cuenta WHERE banco_cuenta_id = " . strit($banco_cuenta_id));
    }

    function handleFiduciarioAlta($now): bool
    {
        // Prepare fiduciario data
        $arr_Fiduciario = $this->fiduciarioHelperPrepareFiduciarioArray($now);

        // Insert into fiduciario table
        $this->fiduciarioHelperInsertFiduciario($arr_Fiduciario);

        // Mark as completed
        return true;
    }

// Helper method to prepare fiduciario array
    private function fiduciarioHelperPrepareFiduciarioArray($now): array
    {
        return [
            'fiduciario_id' => ia_guid(),
            'banco_cuenta_id' => $this->banco_cuenta_id,
            'empresa_id' => $this->fetchEmpresaIdFromBancoCuenta($this->banco_cuenta_id),
            'banco_cuenta_mov_id' => $this->banco_cuenta_mov_id,
            'fecha_retiro' => date('Y-m-d H:i:s', strtotime($this->fecha)),
            'referencia_bancaria' => $this->numero,
            'monto_retiro' => $this->withdrawal,
            'saldo' => $this->withdrawal,
            'alta_db' => $now,
            'alta_por' => 'sistema'
        ];
    }

// Helper method to insert fiduciario record into the database
    private function fiduciarioHelperInsertFiduciario($arr_Fiduciario): void
    {
        $this->extraInsertSQL[] = ia_insert('fiduciario', $arr_Fiduciario);
    }


    function handleInversionApertura($now): bool {

        //Ph. 28 Marzo 2025
        global $gIAParametros;
        $banco_cuenta_permite_inversion_manual = explode(",", $gIAParametros['banco_cuenta_permite_inversion_manual'] ?? '');
        if ($this->alta_tipo == 'manual' && !in_array($this->banco_cuenta_id, $banco_cuenta_permite_inversion_manual)) {// I have to code permissions and shit
            $this->remarks = '';
            $esListo = true;
            return $esListo;
        }

        $arr_Inversion = $this->investHelperPrepareInversionArray($now);

        // Fetch bank account details
        $banco_cuenta = ia_singleton("SELECT * FROM banco_cuenta WHERE banco_cuenta_id = " . strit($this->banco_cuenta_id));

        // Add additional information to inversion array
        $arr_Inversion = $this->investHelperAddBankAccountDetailsToInversion($arr_Inversion, $banco_cuenta);

        // Generate SQL statements and execute
        $this->investHelperGenerateSQLStatements($arr_Inversion);

        // Log details to file (debugging)
        $this->investHelperLogInversionDetails();

        // Mark as completed
        return true;
    }

// Helper method to prepare the initial inversion array
    private function investHelperPrepareInversionArray($now): array
    {
        return [
            'inversion_id' => ia_guid(),
            'banco_cuenta_id' => $this->banco_cuenta_id,
            'banco_cuenta_mov_id' => $this->banco_cuenta_mov_id,
            'fecha_retiro' => date('Y-m-d H:i:s', strtotime($this->fecha)),
            'referencia_bancaria' => $this->numero_original ?? "",
            'monto_retiro' => $this->withdrawal,
            'saldo' => $this->withdrawal,
            'alta_db' => $now,
            'alta_por' => 'sistema',
            'bloqueado' => 'MODIFICADO',
            'indefinida' => 'Si',
            'capturado' => 'Si'
        ];
    }

// Helper method to add bank account details to inversion array
    private function investHelperAddBankAccountDetailsToInversion($arr_Inversion, $banco_cuenta)
    {
        $arr_Inversion['empresa_id'] = $banco_cuenta['empresa_id'];
        $arr_Inversion['tipo_inversion_empresa_privada'] = $banco_cuenta['tipo_inversion_empresa_privada'];
        $arr_Inversion['moneda_id'] = $banco_cuenta['moneda_id'];
        $arr_Inversion['banco_destino'] = ia_singleread("SELECT banco FROM banco WHERE banco_id = " . strit($banco_cuenta['banco_id']));

        return $arr_Inversion;
    }

// Helper method to generate and execute SQL statements
    private function investHelperGenerateSQLStatements($arr_Inversion): void
    {
        // Prepare SQL data
        $sql_ = [
            'remarks' => str_replace("'", "\"", genera_remarks_apertura_inversion($arr_Inversion)),
            'poliza_contabilidad' => str_replace("'", "\"", genera_poliza_contabilidad_inversion($arr_Inversion)),
            'link_vale' => 'INV'
        ];

        // Update banco_cuenta_mov table
        $this->extraInsertSQL[] = ia_update('banco_cuenta_mov', $sql_, ['banco_cuenta_mov_id' => $this->banco_cuenta_mov_id]);

        // Insert into inversion table
        $arr_Inversion['remarks'] = $sql_['remarks'];
        $this->extraInsertSQL[] = ia_insert('inversion', $arr_Inversion);

        // Generate remarks for retiro inversion and merge into SQL array
        $arr_aper_inv = genera_remarks_retiro_inversion($arr_Inversion['inversion_id'], $arr_Inversion['banco_cuenta_mov_id'], false, false, $arr_Inversion);
        $this->extraInsertSQL = array_merge($arr_aper_inv['sql'], $this->extraInsertSQL);
    }

// Helper method to log inversion details for debugging
    private function investHelperLogInversionDetails(): void
    {
        $myFile = "Inversion.txt";
        $fh = fopen($myFile, 'w') or die("can't open file");
        $log_data = print_r($this->extraInsertSQL, true) . "\r\n";
        fwrite($fh, $log_data);
        fclose($fh);
    }

    function handleInversionReembolso($vddB, $gIAParametros, $usuario_automatico, $now, &$debo_insertar, &$esListo, &$ya_insertado) {
        //Ph. 28 Marzo 2025
        global $gIAParametros;
        $banco_cuenta_permite_inversion_manual = explode(",", $gIAParametros['banco_cuenta_permite_inversion_manual'] ?? '');
        if ($this->alta_tipo == 'manual' && !in_array($this->banco_cuenta_id, $banco_cuenta_permite_inversion_manual)) {// I have to code permissions and shit
            $this->remarks = '';
            $esListo = true;
            return $esListo;
        }

        if ($vddB['accion_extra'] !== 'INVERSION' || $this->banco_id != 14) {
            $esListo = true;
            return $esListo;
        }

        $debo_insertar = true;
        $monto_reembolso = $this->deposit;
        $tasa_maxima_inversion = $gIAParametros['tasa_maxima_inversion'] ?? 10.00;
        $tasa_maxima_inversion = $tasa_maxima_inversion == 0 ? 10.00 : $tasa_maxima_inversion;
        $diferencia_maxima = $monto_reembolso * $tasa_maxima_inversion / 100 / 12;

        $sql_inv = $this->investHelperBuildInversionQuery($monto_reembolso, $diferencia_maxima);

        // Fetch the available investment
        $inv_enDB = ia_singleton($sql_inv);

        // No investment found or the refund amount is insufficient
        if (empty($inv_enDB) || $inv_enDB['monto_retiro'] > $monto_reembolso) {
            $esListo = true;
            return $esListo;
        }

        // Create the investment link
        $invlink = $this->investHelperCreateInvestmentLink($inv_enDB, $monto_reembolso, $now, $usuario_automatico);
        $nvoLinkInvID = $invlink['inversion_reembolso_id']; // Ensure $nvoLinkInvID has the correct value

        // Fetch ghost movement variables (debugging code commented out)
        $ghost_mov = get_object_vars($this);

        // Request banking link
        $arrInfoLink = $this->investHelperRequestBankLink($invlink, $usuario_automatico, $ghost_mov);
        if ($this->investHelperHasBankLinkErrors($arrInfoLink)) {
            $esListo = true;
            return $esListo;
        }

        // Execute SQL operations
        $sql = $this->investHelperPrepareSQL($arrInfoLink, $inv_enDB, $invlink, $now);

        if (!$this->insertaBancoCuentaMov(true, false, false) || ia_transaction($sql)) {
            ia_errores_a_dime();
            $esListo = true;
            return $esListo;
        }

        $ya_insertado = true;
        $this->go = 'NO'; // This makes the importer ignore this record

        // Generate and execute remark-related SQL
        $this->investHelperGenerateRemarks($inv_enDB['inversion_id'], $invlink, $arrInfoLink, $nvoLinkInvID);

        // Call insert_update_links_al_banco_live with the named parameter inversion_reembolso_id
        $sql_[] = insert_update_links_al_banco_live(inversion_reembolso_id: $nvoLinkInvID);
        if (ia_transaction($sql_)) {
            ia_errores_a_dime();
            $esListo = true;
            return $esListo;
        }

        // Log details to file (debugging)
        $this->investHelperLogInvestmentDetails($sql, $invlink, $arrInfoLink);

        return $esListo;
    }

// Helper method to build the SQL query for the investment
    private function investHelperBuildInversionQuery($monto_reembolso, $diferencia_maxima): string
    {
        $sql_inv = [];

        if (!empty($this->banco_cuenta_id)) {
            $sql_inv[] = "i.banco_cuenta_id = " . strit($this->banco_cuenta_id);
        }
        if (!empty($this->fecha)) {
            $sql_inv[] = "i.fecha_retiro <= " . strit($this->fecha);
        }
        if (!empty($monto_reembolso)) {
            $sql_inv[] = "i.monto_retiro <= " . strit($monto_reembolso) . " AND i.saldo <= " . strit($monto_reembolso) . " AND ($monto_reembolso - i.saldo) < $diferencia_maxima";
        }

        return "SELECT i.inversion_id, i.banco_cuenta_id, i.empresa_id, DATE_FORMAT(i.fecha_retiro, '%d-%m-%Y') as fecha_retiro, i.monto_retiro, i.monto_isr, i.duracion_dias, i.indefinida, b.nombre, i.saldo
            FROM inversion i
            LEFT JOIN banco_cuenta b ON i.banco_cuenta_id = b.banco_cuenta_id
            WHERE i.capturado = 'Si' AND i.terminado = 'No' AND i.tipo_ganancia_perdida = 'No' 
            AND (" . implode(' AND ', $sql_inv) . ")
            ORDER BY i.saldo, i.fecha_retiro LIMIT 1";
    }

// Helper method to create the investment link array
    private function investHelperCreateInvestmentLink($inv_enDB, $monto_reembolso, $now, $usuario_automatico): array
    {
        return [
            'inversion_reembolso_id' => ia_guid(),
            'banco_cuenta_id' => $inv_enDB['banco_cuenta_id'],
            'monto_reembolsado' => $inv_enDB['monto_retiro'],
            'monto_global_reembolso' => $monto_reembolso,
            'monto_isr' => 0.00,
            'monto_interes' => $monto_reembolso - $inv_enDB['monto_retiro'],
            'monto_interes_real' => $monto_reembolso - $inv_enDB['monto_retiro'],
            'fecha_deposito' => $this->fecha,
            'fecha' => $now,
            'alta_db' => $now,
            'alta_por' => $usuario_automatico,
            'empresa_id' => $this->empresa,
            'banco_cuenta_mov_id' => $this->banco_cuenta_mov_id,
        ];
    }

// Helper method to request banking link and handle response
    private function investHelperRequestBankLink($invlink, $usuario_automatico, $ghost_mov): array
    {
        return SolicitaLinkBancario([
            'link' => $invlink['inversion_reembolso_id'],
            'link_to' => 'inversion_reembolso',
            'tienda_id' => '',
            'withdrawal' => 0,
            'deposit' => $invlink['monto_global_reembolso'],
            'cash' => 0,
            'monto_acta' => $invlink['monto_global_reembolso'],
            'fecha' => $invlink['fecha_deposito'],
            'banco_mov_tipo_id' => 22,
            'banco_cuenta_id' => $invlink['banco_cuenta_id'],
            'idex100' => 0,
            'idetotal' => 0,
            'factura' => 'DEVOLUCION',
            'ivacobradox100' => 0,
            'ivacobradototal' => 0,
            'empresa_id' => $invlink['empresa_id'],
            'factura_numero' => 0,
            'cash_nota_num' => '',
            'cliente' => '',
            'tipo_cash_nota' => '',
            'cobra_iva' => '',
            'cash_num_cobro_iva' => ''
        ], $usuario_automatico, 'NO', $ghost_mov);
    }

// Helper method to check if there are errors in the banking link
    private function investHelperHasBankLinkErrors($arrInfoLink): bool
    {
        return $arrInfoLink['vale_acta'] === false || empty($arrInfoLink['link_id']) || empty($arrInfoLink['sql']);
    }

// Helper method to prepare SQL statements for execution
    private function investHelperPrepareSQL($arrInfoLink, $inv_enDB, $invlink, $now): array
    {
        $sql = [];
        $bcm_id = $arrInfoLink['bcm_id'];

        foreach ($arrInfoLink['sql'] as $s) {
            $sql[] = str_replace("#@#@BCMID#@#@", $bcm_id, $s);
        }

        // Add the refund row for the investment
        $invlink['banco_cuenta_mov_id'] = $bcm_id;
        $invlink['banco_cuenta_mov_link_id'] = $arrInfoLink['link_id'];
        $invlink['numero_referencia'] = $arrInfoLink['ref_num'];
        $invlink['inversion_id'] = $inv_enDB['inversion_id'];
        $invlink['empresa_id'] = $inv_enDB['empresa_id'];

        $sql[] = ia_insert('inversion_reembolso', $invlink);

        // Update investment status
        $inv_ND = [
            'bloqueado' => 'MODIFICADO',
            'fecha_terminado' => $now,
            'terminado' => 'Si',
            'inversion_reembolso_id' => $invlink['inversion_reembolso_id'],
            'monto_reembolsado' => $invlink['monto_reembolsado'],
            'fecha_reembolsado' => $invlink['fecha_deposito'],
            'saldo' => $inv_enDB['saldo'] - $invlink['monto_reembolsado'],
            'monto_interes' => $invlink['monto_interes'],
            'monto_isr' => $invlink['monto_isr'],
            'monto_interes_real' => $invlink['monto_interes'] - $invlink['monto_isr']
        ];

        $inv_sql = haz_update_con_log($inv_ND, $inv_enDB, 'inversion', 'inversion_id', $inv_enDB['inversion_id']);
        foreach ($inv_sql as $v) {
            $sql[] = $v;
        }

        return $sql;
    }

// Helper method to generate remarks and execute related SQL
    private function investHelperGenerateRemarks($inversion_id, $invlink, $arrInfoLink, $nvoLinkInvID): void
    {
        $sql_ = [];
        $arr_aper_inv = genera_remarks_retiro_inversion($inversion_id, "", false, false);
        $sql_ = array_merge($arr_aper_inv['sql'], $sql_);

        $arr_bcm_inv_link = genera_remarks_reembolso_inversion($invlink['banco_cuenta_mov_id'], false, false);
        $sql_ = array_merge($arr_bcm_inv_link['sql'], $sql_);

        // Correctly call insert_update_links_al_banco_live with named parameter inversion_reembolso_id
        $sql_[] = insert_update_links_al_banco_live(inversion_reembolso_id: $nvoLinkInvID);
        if (ia_transaction($sql_)) {
            ia_errores_a_dime();
        }
    }

// Helper method to log details to a file (for debugging)
    private function investHelperLogInvestmentDetails($sql, $invlink, $arrInfoLink): void
    {
        $myFile = "inversion_reembolso_link_automatico.txt";
        $fh = fopen($myFile, 'a') or die("can't open file");

        $log_data = "sql: " . print_r($sql, true) . "\r\n";
        $log_data .= "invlink: " . print_r($invlink, true) . "\r\n";
        $log_data .= "arrInfoLink: " . print_r($arrInfoLink, true) . "\r\n";

        fwrite($fh, $log_data);
        fclose($fh);
    }

}