<?php
//VCA 04-Feb-2021
//Estas funciones fueron llamadas de manera asincrona y llaman a otra funcion que ya hace el trabajo. Se llama igual sin el async.
/*
 * Executes a PHP page asynchronously so the current page does not have to wait for it to     finish running.
 * Async Task Execution via HTTP (get_async):
    Functions like async_actualizaLinksAlBancoLive() call get_async to execute tasks via HTTP asynchronously.
 */
/**
 * Sends an asynchronous GET request to a specified URL with optional parameters.
 *
 * @param string $url The URL to which the asynchronous GET request is sent.
 *                     Must be a valid URL string.
 * @param array $params Optional associative array of query parameters to include
 *                      in the GET request.
 * @return bool Returns true if the asynchronous request is successfully initiated,
 *              or false if there is an error (e.g., empty URL or socket connection error).
 */
function get_async(string $url, array $params = []): bool
{
    // Ensure URL is provided
    if (empty($url)) {
        async_ws_log_event("Error: URL is empty. Async call aborted.");
        return false;
    }

    set_time_limit(0);
    ignore_user_abort(true);

    // Prepare the query string
    $post_params = [];
    foreach ($params as $key => &$val) {
        if (is_array($val)) $val = implode(',', $val);
        $post_params[] = $key . '=' . urlencode($val ?? "");
    }
    $post_string = implode('&', $post_params);

    // Manual overrides for scheme, host, and port
    $scheme = ''; // Do not use SSL
    $host = 'localhost';
    $port = 80;

    // Parse the URL for path
    $parts = parse_url($url);
    $path = $parts['path'] ?? '/';

    // Connection timeout
    $timeout = 1; // Timeout in seconds

    // Open a stream socket
    $fp = @stream_socket_client(
        "{$scheme}{$host}:{$port}",
        $errno,
        $errstr,
        $timeout,
        STREAM_CLIENT_CONNECT | STREAM_CLIENT_ASYNC_CONNECT
    );

    if (!$fp) {
        async_ws_log_event("Error: Could not connect to {$host} on port {$port}. Reason: {$errstr} ({$errno}).");
        return false;
    }

    // Build the GET request
    $post_string = empty($post_string) ? '' : '?' . $post_string;
    $out = "GET {$path}{$post_string} HTTP/1.1\r\n";
    $out .= "Host: {$host}\r\n";
    $out .= "User-Agent: OnWhomTheMoonDothShine\r\n"; // Preserve your User-Agent
    $out .= "Connection: Close\r\n\r\n";

    // Set non-blocking and timeout
    stream_set_blocking($fp, false);
    stream_set_timeout($fp, $timeout);

    // Send the request and close the connection
    @fwrite($fp, $out);
    @fclose($fp);

    async_ws_log_event("Async request sent to {$url} with params: " . json_encode($params));
    return true;
}

function async_execute_task(string $script, array $params = []): bool
{
    global $gWebDir;

    $url = "https://localhost:1980/$gWebDir/backoffice/chron/{$script}.php";
    return get_async($url, $params);
}

function async_log_error(string $message): void
{
    async_ws_log_event("Error: $message");
}

function validate_id_param(string|array|null $param, string $key_name): string {
    if(is_array($param))
        $param = $param[$key_name] ?? $param[0] ?? '';
    return empty($param) ? '' : $param;
}

function async_actualizaLinksAlBancoLive(string|array|null $force = 'NO'): void
{
    $force = validate_id_param($force, 'force');
    async_execute_task("actualiza_links_al_banco_live", ['force' => $force]);
}

function async_generaCatalogos(array $catalogos = ['QWERTY']): void
{
    $catalogos_ = in_array('QWERTY', $catalogos, true) ? 'QWERTY' : $catalogos;
    async_execute_task("generacat", ['catalogos' => $catalogos_]);
}

function async_lock_nota_bodega(): void
{
    async_execute_task("lock_nota_bodega");
}

function async_actualiza_clientes_saldos(string|array|null $cliente_id = null): void
{
    $cliente_id = validate_id_param($cliente_id, 'cliente_id');
    async_execute_task("actualiza_clientes_saldos", ['cliente_id' => $cliente_id]);
}

function async_actualiza_clientes_saldos_grid(string|array|null $categoria_id = null): void
{
    $categoria_id = validate_id_param($categoria_id, 'categoria_id');
    async_execute_task("actualiza_clientes_saldos_grid", ['categoria_id' => $categoria_id]);
}

function async_actualizaFiduciariosAtrasados(): void
{
    async_execute_task("fidatrasados", ['catalogos' => ""]);
}

function async_releaseBackofficeFile2EdoCtaAllLock(): void
{
    async_execute_task("releasebackofficefile2edoctaalllock", ['catalogos' => ""]);
}
function async_actualizaInversionesAtrasadas(): void
{
    async_execute_task("invatrasadas", ['catalogos' => ""]);
}

function async_actualizaFacturasCanceladas(): void
{
    async_execute_task("facturas", ['catalogos' => ""]);
}

function async_actualizaGastosImportantes(): void
{
    async_execute_task("gastosimportantes", ['catalogos' => ""]);
}

function async_actualizaWithdrawalsImportantes(): void
{
    async_execute_task("withdrawalsimportantes", ['catalogos' => ""]);
}

function async_mergeCtaTMovs(): void
{
    async_execute_task("actualiza_cuentat_mov_live");
}

function async_actualizaIngresos(): void
{
    async_execute_task("actualiza_ingresos");
}

function async_checkAndRunAts(): void
{
    async_execute_task("checkAndRunAts");
}

function async_actualizaACuentasLive(string|array|null $force = 'NO'): void
{
    $force = validate_id_param($force, 'force');
    async_execute_task("actualiza_a_cuentas_live", ['force' => $force]);
}

function async_guardaConsulta(array|string $sqlData = ""): void
{
    async_execute_task("guardaconsulta", ['sqlData' => $sqlData]);
}

function async_guarda_despliega_autorizaciones(array|string $sqlData = ""): void
{
    async_execute_task("guarda_despliega_autorizaciones", ['sqlData' => $sqlData]);
}

function async_ejecuta_transaccion_sql(string $sqlData = ""): void
{
    async_execute_task("ejecuta_transaccion_sql", ['sqlData' => $sqlData]);
}

function async_actualizaGastosPorRevisar(): void
{
    async_execute_task("actualiza_gastos_por_revisar");
}

function async_actualizaConteoMovimientosDivisa(): void
{
    async_execute_task("actualiza_conteo_mov_divisa");
}

function async_generaHistorian(string $tabla, string $id, string $action, string $user_nick): void
{
    async_execute_task("genera_historian", [
        'tabla' => $tabla,
        'id' => $id,
        'action' => $action,
        'user_nick' => $user_nick,
    ]);
}

function async_disable_tc_temp_timeout(): void
{
    async_execute_task("disable_tc_temp_time_out");
}

function async_banco_cuenta_mov_puede_borrar(): void
{
    async_execute_task("banco_cuenta_mov", ['function' => 'timeout_puede_borrar']);
}

function async_updateMaxMinCountAll(): void
{
    async_execute_task("updateMaxMinCountAllBodegas");
}

function async_recalculaInconsistenciasEnNotas($cliente_id = '', $cliente_nombre = ''): void
{
    async_execute_task("recalculaInconsistenciasEnNotas", [
        'cliente_id' => $cliente_id,
        'cliente_nombre' => $cliente_nombre,
    ]);
}

function async_update_plantillas_withdrawals(): void
{
    async_execute_task("update_plantillas_withdrawals");
}

function async_update_plantillas_cuenta_t_gasto(): void
{
    async_execute_task("update_plantillas_cuenta_t_gasto");
}

function async_calculadora_puede_borrar_editar(): void
{
    async_execute_task("calculadora_puede_borrar_editar");
}
