<?php

/**
 * Class ATS
 *
 * The ATS class represents a task scheduling system.
 */
class ATS {
    // protected $retries = 10;
    protected int $cada_minutos = 10;
    protected string $func = ''; //Nombre de la función que se registrará
    protected string $es = 'script'; //Nombre de la función que se registrará
    protected array $args = [];

    // Updated constructor
    public function __construct(string $func = "", int $cada_minutos = 10, string $es = 'script', array $args = []){

        $function = __METHOD__;

        if($cada_minutos !== 0){
            $this->cada_minutos = $cada_minutos;
        }
        if(trim($func) !== ''){
            $this->func = $func;
        }
        if(trim($es) !== ''){
            $this->es = $es;
        }
        if(trim($es) == 'unica'){
            $this->cada_minutos = 1;
        }
        if(!empty($args)){
            $this->args = $args;
        }

    }

    /**
     * Registers a task in the ats table.
     *
     * This function creates a new entry in the ats table with the specified task details.
     *
     * @return bool Indicates whether the task registration was successful or not.
     */
    public function ats_registra():bool {

        $function = __METHOD__;
        $ats = array();
        if($this->es == 'unica'){
            $ats = ia_singleton("SELECT /*$function*/ * FROM ats WHERE funcion=" . strit($this->func));
        }

        $now = date('Y-m-d H:i:s');

        $ats['funcion'] = $this->func;
        $ats['es'] = $this->es;
        $ats['termino'] = 'No';
        $ats['corrio_el'] = $now;
        $ats['intervalo'] = "PT{$this->cada_minutos}M";
        $ats['siguiente_el'] = date('Y-m-d H:i:s', strtotime($now) + ($this->cada_minutos * 60));
        $ats['args'] = $ats['args']  ?? json_encode($this->args);

        $sql = ia_insert(table: 'ats', values: $ats, autoOnUpdate: true, comment: "/*" . __METHOD__ . "*/");

//        echo "<li>" . $sql;
//        echo "<pre>".print_r($ats, true)."</pre>";
        if(ia_query($sql))
            return false;

        return true;
    }

    /**
     * Marks the ATS as done and updates the necessary fields in the database.
     *
     * @return bool Returns true if the ATS was marked as done successfully, false otherwise.
     */
    public function ats_done(): bool
    {
        $function = __METHOD__;
        $ats = ia_singleton("SELECT /*$function*/ * FROM ats WHERE funcion=" . strit($this->func));

        if(empty($ats)){
            return false;
        }

        if($ats['es'] == 'unica'){
            $sql = "DELETE /*$function $this->func 'unica'*/ FROM ats WHERE funcion=" . strit($this->func);
        }
        else {
        $ats['siguiente_el'] = date('Y-m-d H:i:s', strtotime($ats['corrio_el']) + ($this->cada_minutos * 60));
        $ats['termino'] = 'Si';

        $sql = ia_update('ats', $ats, " funcion=" . strit($this->func));
        }
        if(ia_query($sql)){
            return false;
        }
        return true;
    }

    /**
     * Update the ats record with the given 'termino' value.
     *
     * @param string $termino [optional] The value to which the 'termino' column should be updated. Default is 'No'.
     *
     * @return bool True if the update was successful, false otherwise.
     */
    public function ats_update($termino = 'No' ): bool
    {
        $function = __METHOD__;
        $ats = ia_singleton("SELECT /*$function*/ * FROM ats WHERE funcion=" . strit($this->func));
        $ats['siguiente_el'] = date('Y-m-d H:i:s', strtotime($ats['corrio_el']) + ($this->cada_minutos * 60));
        $ats['termino'] = $termino;
        if($ats['es'] == 'unica'){
            $sql = "DELETE /*$function*/ * FROM ats WHERE funcion=" . strit($this->func);
        }
        else {
        $sql = ia_update('ats', $ats, " funcion=" . strit($this->func));
        }

        if(ia_query($sql)){
            return false;
        }
        return true;
    }

    /**
     * Checks and runs ATS (Automated Task Scheduler) scripts.
     * Queries the database for ATS scripts that have 'script' as their 'es' value,
     * orders them by the 'corrio_el' column,
     * and then executes the scripts based on certain conditions.
     *
     * @return void
     * @throws DateMalformedIntervalStringException
     */
    public static function checkAndRunAts(): void
    {
        $method = __METHOD__;
        $sql = "SELECT /*$method*/ * FROM ats WHERE es IN('script','unica') AND termino='No' ORDER BY corrio_el";
//echo "sql: $sql\n";

        $chrons = ia_sqlArray($sql, 'funcion');

        global $gDime;
        $gDime[__METHOD__ . " " . __LINE__ . " " . rand(1,9999)]=$chrons;

        $cada_minutos = 10;
        $cada_segundos = $cada_minutos * 60;

        $minutos_tolerancia = 2;
        $segundos_tolerancia = $minutos_tolerancia * 60;

        $segundos_ahora = strtotime(date('Y-m-d H:i:s'));

        foreach ($chrons as $chron) {
//    echo "<pre>".print_r($chron, true)."</pre>";
            $corrio_el = strtotime($chron['corrio_el']);
            $siguiente_el = strtotime($chron['siguiente_el']);

            if(!empty($chron['intervalo'])) {
                $intervalSpec = $chron['intervalo'];  // Example interval specification
                $interval = new DateInterval($intervalSpec);

                $cada_minutos = $interval->i;
                $cada_segundos = $cada_minutos * 60;
            }


            $seg_entre_corridas = abs($siguiente_el - $corrio_el);
            $seg_desde_ultima = abs($segundos_ahora - $corrio_el);

//            echo "<li>seg_entre_corridas: $seg_entre_corridas > cada_segundos: $cada_segundos".PHP_EOL;
//            echo "<li>seg_desde_ultima: $seg_desde_ultima > segundos_tolerancia: $segundos_tolerancia".PHP_EOL;
//            echo "<li>seg_desde_ultima: $seg_desde_ultima > cada_segundos: $cada_segundos".PHP_EOL;
//            echo "<pre>chron" . print_r($chron, true) . "</pre>";


            if ($chron['es'] == 'unica' || $seg_entre_corridas > $cada_segundos ||
                ($chron['termino'] == 'No' && $seg_desde_ultima > $segundos_tolerancia) ||
                ($chron['termino'] == 'Si' && $seg_desde_ultima > $cada_segundos)
            ) {

                if ($chron['es'] == 'unica' && $chron['termino'] == 'No') {
                    $args = json_decode($chron['args'], true);
                    if (json_last_error() !== JSON_ERROR_NONE) {
                        throw new RuntimeException("Invalid JSON in 'args': " . json_last_error_msg());
                    }

                    // Check for the specific exception
                    if ($chron['funcion'] === 'async_actualiza_clientes_saldos' &&
                        isset($args['es']) && $args['es'] === 'unica' &&
                        (empty($args['cliente_id']) || !is_array($args['cliente_id']))) {

                        // Delete the task from ATS
                        $deleteSql = "DELETE FROM ats WHERE funcion = " . strit($chron['funcion']);
                        if (ia_query($deleteSql)) {
                            throw new RuntimeException("Failed to delete ATS task for {$chron['funcion']}.");
                        }

                        ia_errores_a_dime("<li>Task for {$chron['funcion']} deleted due to empty 'cliente_id' with 'es' = 'unica'.</li>");
                        continue; // Skip this task
                    }

                    unset($args['es']);
//                    $real_args = $args['args'];

                    ia_errores_a_dime("<li>Executing: {call_user_func_array($chron[funcion], " . print_r($args, true) . ");}");

                    if (is_callable($chron['funcion'])) {
                        call_user_func_array($chron['funcion'], $args);
                    } else {
                        throw new RuntimeException("Function {$chron['funcion']} is not callable.");
                    }
                }


                else {
//                    echo "<li>ejecutando: {$chron['funcion']}";
                    $chron['funcion']();
                }
            }
        }
//ats_registra($func = 'async_actualizaACuentasLive', $this->cada_minutos = 100) es static no hay $this;

        file_debug_reporte("_ats");
        ia_errores_a_dime();
        global $gDime; $gDime = [];
    }
}
