<?php

function preparaRemarksBCM($bcm_id="", $remarks_ori="", $txt_color="", $blink="", &$remarks_ok=array(), $buscaRep=true, $doSQL=true, $debug=false, $monto = 0.00, $fuerza_titulo = "")
{
    $remarks = "";

//    if(empty($remarks_ori))
//        return $remarks;

    $infoDebug = "";

    if($debug)
        $infoDebug .= "<hr/><ul><li>remarks_ori: ".nl2br($remarks_ori);

//    $remarks_ori = strip_tags($remarks_ori);

    if($debug)
        $infoDebug .= "\r\n<li>remarks_ori strip_tagged: ".nl2br($remarks_ori);

    $arrReservadas = []; //array("COMISION BANCARIA");

    foreach ($arrReservadas as $res) {
        if (strpos($remarks_ori, $res) !== FALSE) {

            return $remarks = $remarks_ori;

        }
    }

    $arrRemarks = preg_split('/\r\n|\r|\n/', $remarks_ori);



    if(!sizeof($arrRemarks))
        return $remarks;

    if($debug)
        $infoDebug .= "\r\n<li><pre>arrRemarks:".print_r($arrRemarks, true)."</pre>";

    $titulo=""; $benefic=""; $descripcion="";

    //Recorremos el arreglo para encontrar titulo, beneficiario y descripción (de aquí sacamos el contenedor y lo demás para buscar los repetidos
    $k = 0;

    if($debug)
        $infoDebug .= "\r\n<ol>";

    foreach($arrRemarks as $line)
    {
        $done = false;
        $line = vx_trim($line);
        //no debería de incrementar $k si la línea está vacía.
        //OJO VCA 20-02-2020
        if(strlen($line) == 0) {
            $descripcion .= PHP_EOL;
            continue;
        }

        if($debug)
            $infoDebug .= "\r\n<li> $line";

        $carac = preg_match("/([;:,])/i", $line) === 1;

        if(!$carac && !strlen($titulo) && $k==0) {
            $titulo .= $line;
            $done = true;
            $k++;
            continue; // que ya no revise las siguientes condiciones.
        }
        $k++;
        /** Si tiene una coma, punto, punto y coma o dos puntos, es el beneficiario */
        if($carac) {
            if(!strlen($benefic))
            {
                $benefic .= $line.PHP_EOL;
                $done = true;
                continue;
            }
        }

        $descripcion .= $done ? "" : $line.PHP_EOL;

    }

    if($titulo == $remarks_ori && !$fuerza_titulo) {
        $titulo = '';
        $descripcion = $remarks_ori;
    }
    $titulo = $fuerza_titulo !== false ? $fuerza_titulo : $titulo;
    $descripcion = $fuerza_titulo !== false ? $remarks_ori : $descripcion;
    $benefic = $fuerza_titulo !== false ? "" : $benefic;

    if($debug)
        $infoDebug .= "\r\n</ol>";

    if($debug)
        $infoDebug .= "PREVIO: \r\n<li>titulo: $titulo"."<li>benefic: $benefic"."<li>descripcion: $descripcion<br><br></ul>";

    $remarks_ok = arreglaRemarksBCM($titulo, $benefic, $descripcion, $bcm_id, $buscaRep, $doSQL, $debug, $txt_color, $blink, $infoDebug, $fuerza_titulo);

    if ($debug)
        $infoDebug .= "\r\n<pre>preparaRemarksBCM remarks_ok: " .($fuerza_titulo === false ? " ms" : "me"). print_r($remarks_ok, true) . "</pre>";

    if($debug)
        $infoDebug .= "POST: \r\n<li>titulo: $remarks_ok[titulo]"."<li>benefic: [benefic]"."<li>descripcion: $remarks_ok[descripcion]<br><br></ul>";

    if($debug)
    {
        //06-Abril-2020
        global $gWebDir;
        $myFile = "C:\\wamp\\www\\$gWebDir\\backoffice\\txt\\$bcm_id.txt";
        $fh = fopen($myFile, 'a+') or die("can't open file");
        $bleh = $infoDebug;
        fwrite($fh, $bleh);
        fclose($fh);
    }



    return $remarks_ok["titulo"] . $remarks_ok["benefic"] . $remarks_ok["descripcion"];
}

function arreglaRemarksBCM($titulo="", $benefic="", $descripcion="", $bcm_id="", $buscaRep=true, $doSQL=true, $debug=false, $txt_color="", $blink="", &$infoDebug = "", $fuerza_titulo = "")
{
    $remarks_ok = array(
        'ori_remarks' => $titulo . $benefic . $descripcion,
        'ori_titulo' => $titulo,
        'categoria' => $titulo,
        'sub_categoria' => encuentraSubcategoria($descripcion),
        'contenedor' => '',
        'ori_benefic' => $benefic,
        'ori_descripcion' => $descripcion,
        'titulo' => $titulo,
        'benefic' => $benefic,
        'descripcion' => $descripcion,
        'link_vale' => "",
        'cont' => array(),
        'current_duplicates' => array(),
        'sql' => array());

    $sqlUpdt = array();

    $remarks = $remarks_ok['ori_remarks']; //strip_tags($remarks_ok['ori_remarks']); //Decidir con qué remarks vamos a trabajar.
    $cont = array();
    $naviera = false;

    $hayCont = encuentraContenedor($remarks_ok['ori_remarks'], $remarks_ok['cont'], $naviera);
    $remarks_ok['contenedor'] = $hayCont == true && array_key_exists(0, $remarks_ok['cont']) ? $remarks_ok['cont'][0] : '';

    //Encontramos Naviera y ponemos link_vale en NAVIERA.
    if ($naviera !== false && $fuerza_titulo === false) {
        $remarks_ok['link_vale'] = 'NAVIERA';
    }

    $sql_current_bcm = "SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'";
    $current_bcm = ia_singleton($sql_current_bcm);

    $tipoNR = array();
    if($fuerza_titulo === false) {
        $tieneTipoNR = encuentraTipoRemarksBCM($remarks, $tipoNR); //Según el diccionario de datos para gastos del banco.

        if ($debug)
            $infoDebug .= "\r\n<pre>TipoNR: " . print_r($tipoNR, true) . "</pre>";

        if ($tieneTipoNR !== false) {
            if ($tipoNR['titulo'] != $remarks_ok['ori_titulo']) {
                $remarks_ok['descripcion'] = (empty($remarks_ok['titulo']) ? "" : $remarks_ok['titulo']) . PHP_EOL . $remarks_ok['descripcion'];
                $remarks_ok['titulo'] = $tipoNR['titulo'];
            }
        }
        else {
            if (!empty($current_bcm['banco_diccionario_dato_id'])) {
                $banco_diccionario_dato = ia_singleton("SELECT * FROM banco_diccionario_dato WHERE banco_diccionario_dato_id = '$current_bcm[banco_diccionario_dato_id]'");
                if (!empty($banco_diccionario_dato)) {
                    $remarks_ok['titulo'] = $banco_diccionario_dato['nombre'];
                }
            }
        }
    }
    //Subtitulo en titulo
    $subentitulo = "";
    if (array_key_exists('st', $tipoNR) && strlen($tipoNR['st']) && $tipoNR['resalta_subtitulo'] == 'Si')
        $subentitulo = ' <strong class="txt16px txt_centered txt_color_blue">' . $tipoNR['st'] . '</strong>';

    $remarks_ok['titulo'] = empty($remarks_ok['titulo']) ? "" : '<strong class="txt18pxfr txt_bold_red txt_centered ' . ($fuerza_titulo !== false ? 'fuerza_titulo' : '') . ' ' . $txt_color . ' ' . $blink . '" style="min-width: 335px;">' . $remarks_ok['titulo'] . '</strong>' . $subentitulo . PHP_EOL;

    //NO hay que buscar los repetidos. Pero ya arregló los remarks según su tipo.
    if ($debug)
        $infoDebug .= "\r\n<pre>arreglaRemarksBCM remarks_ok: " . print_r($remarks_ok, true) . "</pre>";

    if (!$buscaRep) {
        return $remarks_ok;
    }

    /*
     * Pasos previos para liberar repetidos no relacionados
     * */
    // $sql_current_bcm = "SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'";
    // $current_bcm = ia_singleton($sql_current_bcm);

    if (!quieroBuscarGasto($remarks_ok['categoria'], $remarks_ok['sub_categoria'], $remarks_ok['contenedor'], $current_bcm['withdrawal'] ?? 0.00)) {
        $remarks_ok['sql'] = $sqlUpdt;
        return $remarks_ok;
    }



    $repetidos = trim($current_bcm['mov_repetido_id'] ?? '');
    $explode_repetidos = explode(",", $repetidos);

    $remarks_ok['current_duplicates'] = $repetidos !== "" ? $explode_repetidos : $remarks_ok['current_duplicates'];

    if (count($remarks_ok['current_duplicates']) > 0) {
        foreach ($remarks_ok['current_duplicates'] as $bcmid_repetido) {
            if ($bcm_id !== $bcmid_repetido)
            {
                $repetido = ia_singleton("SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcmid_repetido'");

                if(!is_array($repetido) || empty($repetido))
                    continue;
//                $repetido['remarks'] = str_replace("txt_bold_red txt_underline", "", $repetido['remarks']);
                $new_remarks = $repetido['remarks'];

                $repetidos = explode(",", trim($repetido['mov_repetido_id']));
                // Comprueba que el BCM se encuentre en los repetidos del repetido
                if (in_array($bcm_id, $repetidos)){
                    // Se obtiene la posicion para eliminarlo de repetidos del repetido
                    $position = array_search($bcm_id, $repetidos);
                    unset($repetidos[$position]);
                    // Se crean nuevos repetidos del repetido
                    $nuevos_repetidos = implode(",", $repetidos);
                    // Se valida que repetidos sea mayor a 1 para que pueda ser repetido y no se repita con el mismo
                    if (count($repetidos) < 2) {
//                        if ($nuevos_repetidos == $bcmid_repetido){
                        $new_remarks = str_replace("txt_bold_red txt_underline", "", $repetido['remarks']);
                        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido = 'No', mov_repetido_id = '', remarks = ". strit(ltrim(trim($new_remarks))) ." WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
//                        }
                    } else {
                        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET mov_repetido_id = '$nuevos_repetidos' WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
                    }
                }
//                print_r($repetido['mov_repetido_id']);
//                exit;
//                $new_remarks = $repetido['remarks'];
//                $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido = 'No', mov_repetido_id = '', remarks = ". strit(ltrim(trim($new_remarks))) ." WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
            } else {
                $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido = 'No', mov_repetido_id = '', remarks = ". strit(ltrim(trim($remarks_ok['titulo']))) ." WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
            }
        }
    }
    /*
     * Fin de pasos previos para liberar repetidos no relacionados
     * */

    $exceptions = ['CONTENEDOR'];
    $buscaContenedoresRepetidosPorImporte = true; // Para activar el proceso de busqueda de contenedores repetidos por importe, cambiar a true.
    $container_duplicates = null;
    if (in_array(trim($remarks), $exceptions)) {
        // Busca repetidos por importe de tipo contendor. Si no hay repetido por importe e valor es null
        if ($buscaContenedoresRepetidosPorImporte === true) {
            $container_duplicates = null;
            if (isContainer($remarks)) {
                $container_duplicates = buscaContenedorPorImporte($bcm_id, $current_bcm['withdrawal']);
                if ($container_duplicates != null){
                    $duplicates = explode(",", $container_duplicates);
                    $repIDs = $container_duplicates . ",$bcm_id";
                    foreach ($duplicates as $bcm_id_repetido) {
                        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id=" . strit($repIDs) . " WHERE banco_cuenta_mov_id=" . strit($bcm_id_repetido);
                    }
                    $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id=" . strit($repIDs) . ", remarks=".strit(ltrim(trim($remarks_ok['titulo']))). " WHERE banco_cuenta_mov_id=" . strit($bcm_id);
                }
                $remarks_ok['sql'] = $sqlUpdt;
                return $remarks_ok;
            }
        }
    }

    $buscar = array('VALOR_FACTURA' => array('enc'=>false,'val'=>""),
        'FACTURA' => array('enc'=>false,'val'=>""),
        'PEDIMENTO' => array('enc'=>false,'val'=>""),
        'CONTENEDOR' => array('enc'=>false,'val'=>array(),'dep'=>array('MONTO' => array('enc'=>false,'val'=>"")),),);


    /** @var  $re */ //Quité MONTO del $re. Tengo que agregarlo como dependiente de Contenedor
    $re = '/^\s*(VALOR FAC|VAL FAC|FACT|PEDIMENTO|CONTENE).*?\s(.*?(\s))/mi';

    preg_match_all($re, $remarks, $matches, PREG_SET_ORDER, 0);

    $hayBuscar = false;
    if(is_array($matches) && !empty($matches))
        foreach($matches as $match)
        {
            $llave = $match[1];
            $valor = $match[2];
            if(stripos($llave,"VAL") !== false)
            {
                $buscar['VALOR_FACTURA']['val'] = echonf(limpiaCantidad($valor), true, 2, "");
                $hayBuscar = true;
            }
            elseif(stripos($llave,"FAC") !== false)
            {
                $buscar['FACTURA']['val']= trim(ltrim($valor));
                $hayBuscar = true;
            }
            elseif(stripos($llave,"PEDIMENTO") !== false)
            {
                $buscar['PEDIMENTO']['val'] = trim(ltrim($valor));
                $hayBuscar = true;
            }
            elseif(stripos($llave,"CONTENE") !== false)
            {
                $buscar['CONTENEDOR']['val'][] = trim(ltrim($valor));
                $hayBuscar = true;
            }
            elseif(stripos($llave,"MONTO") !== false)
            {
                $buscar['MONTO']['val'] = echonf(limpiaCantidad($valor), true, 2, "");
                $hayBuscar = true;
            }
        }
    //Agrega los contenedores que encontró la función encuentraContenedor
    if($hayCont) {

        $hayBuscar = true;
        foreach ($remarks_ok['cont'] as $c)
            $buscar['CONTENEDOR']['val'][] = trim(ltrim($c));

//        echo "<pre>".print_r($remarks_ok,true)."</pre>";
//        exit;
        //Es naviera
        if ($naviera !== false) {
            $stepvar = null;
        } else {
            // echo "BUSCAR: " . gastoBuscar($remarks_ok['benefic'], $remarks_ok['descripcion']);
            // dd_($remarks_ok);
            if (gastoBuscar($remarks_ok['benefic'], $remarks_ok['descripcion'])){
                // echo "hee!";
                $container_duplicates = buscaContenedorPorImporte($bcm_id, $current_bcm['withdrawal'], $remarks_ok['contenedor']);
                // dd_($container_duplicates);
                if ($container_duplicates != null){
                    $duplicates = explode(",", $container_duplicates);
                    $repIDs = $container_duplicates . ",$bcm_id";
                    foreach ($duplicates as $bcm_id_repetido) {
                        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id=" . strit($repIDs) . " WHERE banco_cuenta_mov_id=" . strit($bcm_id_repetido);
                    }
                    $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id=" . strit($repIDs) . ", remarks=".strit(ltrim(trim($remarks_ok['titulo']))). " WHERE banco_cuenta_mov_id=" . strit($bcm_id);
                }
            }
        }
    }
    //NO hay repetidos. Pero ya arregló los remarks según su tipo.
    if(!$hayBuscar) {
        $remarks_ok['sql'] = $sqlUpdt;
        return $remarks_ok;
    }

    //$sqlUpdt = array();

    if($debug)
        $infoDebug .= "\r\n<pre>buscar: ".print_r($buscar, true)."</pre>";

    $sqlBuscar = "SELECT banco_cuenta_mov_id, remarks FROM banco_cuenta_mov WHERE banco_cuenta_mov_id <> " . strit($bcm_id);
    $remarksLike = " AND es='retiro' AND ( ";

    $valRepetido = array();

    foreach($buscar as $k=>$v) {
        if (empty($v['val'])) continue;

        if(!is_array($v['val']))
            $valRepetido[] = $v['val'];
        else
            foreach($v['val'] as $c)
                $valRepetido[] = trim(ltrim($c));

        switch ($k) {
            case "VALOR_FACTURA" :
                $valRepetido[] = echonf($v['val'], true);
                break;

            case "FACTURA" :
            case "PEDIMENTO" :
            case "CONTENEDOR" :
            case "MONTO" :
                break;

            default:
                break;
        }

        $valRepetido = array_unique($valRepetido, SORT_STRING);

        $remarksLike .= " (";

        foreach ($valRepetido as $vr)
            $remarksLike .= " IFNULL(remarks,'') LIKE " . strit("%$vr%") . " OR ";

        $remarksLike = substr($remarksLike, 0, -4) . " ) OR ";
    }

//    if (count($buscar['CONTENEDOR']['val']) == 0 and $isContainer) {
////        $remarksLike = $remarksLike . "remarks LIKE '%CONTENE%') AND remarks NOT LIKE ('%FIDUCI%') AND banco_mov_tipo_id NOT IN (6,11,21)";
//        $response['Status'] = 'Error';
//        $response["Error"] = 'Debe ingresar número de contenedor!';
//        die(json_encode($response));
//        exit;
//    }
    $remarksLike = substr($remarksLike, 0, -4) . ") AND remarks NOT LIKE ('%FIDUCI%') AND banco_mov_tipo_id NOT IN (6,11,21)";

    if($debug)
        $infoDebug .= "\r\n<li>sqlBuscar: $sqlBuscar $remarksLike";

    // dd_($sqlBuscar . $remarksLike);

    $arrDup = ia_sqlArray($sqlBuscar . $remarksLike, "banco_cuenta_mov_id");

    // echo "<pre>".print_r($arrDup, true)."</pre>";
    // exit;

    //if(empty($arrDup) || !is_array($arrDup))
    //return $remarks_ok;

    if($debug)
        $infoDebug .= "\r\n<pre>arrDup:".print_r($arrDup, true)."</pre>";

    $valFound = array();

    if(!empty($tipoNR['st']))
        $valRepetido[]=$tipoNR['st'];

    if($debug)
        $infoDebug .= "\r\n<pre>valRepetido:".print_r($valRepetido, true)."</pre>";

    $repIDs = "";


    //Aquí va el coloreo del subtitulo. Es para los gastos de contenedor.
    //if(!empty($tipoNR['st']))

    if (is_array($arrDup)) {
        foreach($arrDup as $dup)
        {
            $rem_old = $dup['remarks']; //quité strip tags
            $rem_new =  $remarks_ok['descripcion'];
            $tipoOR = array();
            $tieneTipoOR = encuentraTipoRemarksBCM($rem_old,$tipoOR); //Según el diccionario de datos para gastos del banco.

            if($debug)
                $infoDebug .= "\r\n<li>Old: $tieneTipoOR, New: $tieneTipoNR, Oldst: $tipoOR[st], Newst: $tipoNR[st]";

            //La validación es que sean del mismo tipo y del mismo subtitulo
            if($tieneTipoNR !== false && ($tieneTipoOR != $tieneTipoNR || $tipoOR['st'] != $tipoNR['st'])) //si el nuevo no tiene, entonces ya no compara, asume que se repiten.
            {
                //echo "<li>No son del mismo tipo. Old: $tieneTipoOR, New: $tieneTipoNR, Oldst: $tipoOR[st], Newst: $tipoNR[st]";
                continue;
            } //No son del mismo tipo.

            $rem_old = marcaRemarksDuplicados($rem_old, $valRepetido, $valFound);

            //Vamos a depurar
            $valFinal = array();

            foreach($valRepetido as $vr)
                foreach($valFound as $vf)
                    if(!array_key_exists($vr, $valFinal) && stripos($vr, $vf) !== false || stripos($vf, $vr) !== false)
                        $valFinal[$vr] = $vr;

            if($debug)
                $infoDebug .= PHP_EOL . "<pre>valFinal:".print_r($valFinal, true)."</pre>";

            $rem_new = marcaRemarksDuplicados($rem_new, $valFinal);

            $remarks_ok['descripcion'] = $rem_new;

            //Aqui agregamos los update.

            $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id='*#*#*#*#', remarks=".strit(ltrim(trim($rem_old))). " WHERE banco_cuenta_mov_id IN(" . strit($dup['banco_cuenta_mov_id']) . ", " . strit($bcm_id) . ")";

            $repIDs .= $dup['banco_cuenta_mov_id'] .",";
        }
    }

    //  echo "<pre>".print_r($dup, true)."</pre>";
    //         exit;

    if(strlen($repIDs)) {
        $repIDs .= $bcm_id;
//        // Si hay contenedores duplicados por importe, se concatenan para hacer referencia a ellos.
        $repIDs = $container_duplicates . ($container_duplicates != null ? ",": "") .$repIDs;
        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='Si', mov_repetido_id=" . strit($repIDs) . " WHERE banco_cuenta_mov_id=" . strit($bcm_id);

        foreach($sqlUpdt as $k=>&$v)
            $v = str_replace("*#*#*#*#", $repIDs, $v);
    }
    else{ //Aquí un update para quitar todos los lugares donde aparece como repetido.
        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET mov_repetido_id=REGEXP_REPLACE(mov_repetido_id, '($bcm_id,)|$bcm_id','') WHERE mov_repetido_id LIKE '%$bcm_id%'";
        $sqlUpdt[] = "UPDATE banco_cuenta_mov SET repetido='No', mov_repetido_id='' WHERE banco_cuenta_mov_id=" . strit($bcm_id);
    }


    if($debug)
        $infoDebug .= PHP_EOL .  "<pre>valFound:".print_r($valFound, true)."</pre>";

    $remarks_ok['sql'] = $sqlUpdt;

    if($debug)
        $infoDebug .= PHP_EOL .  "<pre>".print_r($sqlUpdt, true)."</pre>";

    if($doSQL)
        ia_transaction($sqlUpdt);

    return $remarks_ok;
}

/**
 * Determina si el BCM es contenedor
 * @param string $remarks cadena donde bucar
 * @return bool Es contenedor
 * */
function isContainer($remarks)
{
    $str_pos = strpos($remarks, 'CONTENE');
    if ($str_pos === false) {
        return false;
    }
    return true;
}

/**
 * Busca los contenedores repetidos por importe
 * @param string $bcm_id El banco_cuenta_mov_id del que se desea saber si hay repetidos
 * @param string $importe El importe (withdrawal) que se desa buscar como repetido
 * @return string|null Concatenación de los contenedores duplicados por importe
 * */
function buscaContenedorPorImporte($bcm_id, $importe = '0', $contenedor = '')
{
    $sql = "SELECT 
                *
            FROM banco_cuenta_mov
            WHERE banco_cuenta_mov_id <> '$bcm_id' 
              AND remarks LIKE '%CONTENE%' 
              AND remarks NOT LIKE '%FIDUCI%'
              AND withdrawal = '$importe'
              AND es = 'Retiro'";

    // dd_($sql);

    $containers = ia_sqlArray($sql, 'banco_cuenta_mov_id');
    if (count($containers) > 0) {
        return implode(",", array_keys($containers));
    }
    return null;
}

function gastoBuscar($benefic, $desc)
{
    $exceptions = ['LIMPIEZA', 'SERVICIO'];
    foreach ($exceptions as $exception) {
        $str_pos = strpos($benefic, $exception);
        $str_pos_2 = strpos($desc, $exception);
        if ($str_pos === false and $str_pos_2 === false) {
            continue;
        } else {
            return false;
        }
    }
    return true;

    /* $re = '/^\s*(LIMPIEZA DE 1 CONTENEDOR|LIMPIEZA DE UN CONTENEDOR|LIMPIEZA DE CONTENEDOR|LIMPIEZA DE).*?\s(.*?(\s))/mi';
     $array = null;
     preg_match_all($re, $str, $matches, PREG_SET_ORDER, 0);
     echo "gastoEsLimpieaza";
     print_r($matches);
     exit;*/
}

function encuentraTipoRemarksBCM($remarks = "", &$tipo = array())
{
    $ddbg = preparaDiccionarioDatosBancoGastos();

    $remarks = quitaacentos($remarks);
    $encontrado = false;
    $subtitulo = false;
    $tipo['st'] = "";
    foreach($ddbg['si_buscar'] as $k=>$r) {
        foreach($r['palabra_clave'] as $pc) {
            $encontrado = stripos($remarks, $pc);
            if ($encontrado !== false) {
                $tipo = $ddbg['si_buscar'][$k];
                $tipo['st'] = "";
                $tipo['kw_match'] = $pc;
                $encontrado = $k;
                //Para los gastos de contenedor se necesita una subcategoria, la llamé subtítulo.
                if(!empty($r['subtitulo']))
                    foreach($r['subtitulo'] as $st) {
                        $subtitulo = stripos($remarks, $st);
                        if($subtitulo !== false)
                            $tipo['st'] = $st;
                    }
                break 2;
            }
        }
    }

    return $encontrado;
}

function marcaRemarksDuplicados($remarks = "", $valRep = array(), &$valFound = array())
{
    $valStr = join("|", $valRep);
    $re = '/^.*\b(' . $valStr . ')\b.*$/mi';
    //$re = '/.*(' . $valStr . ').*$/mi';

    //echo "<li>re: $re";

    $result = preg_replace_callback($re, function($m) use (&$valFound){
        //echo "<pre>m:".print_r($m, true)."</pre>";
        $str = ltrim(trim(strip_tags($m[0])));
        $valFound[] = $str;
        return "<strong class=\"txt_bold_red txt_underline\">".$str."</strong>";
    }, $remarks);

    return $result;
}

function encuentraContenedor($str, &$cont, &$naviera)
{
    $encontrado = false;
    if(empty($str))
        return $encontrado;

    $palCont = stripos($str, "CONTENEDOR");

    $naviera = stripos($str, "NAVIER");

    $naviera = $naviera !== false ?  $naviera : stripos($str, "GARANT");

    if($palCont !== false)
    {
        $encontrado = true;
    }

    /**
    REGEX para encontrar algún numero de contenedor: /(([A-Za-z]){4}([0-9]){7})/m
    ( //Dentro de paréntesis para que sea un solo grupo de 11 caracteres
    ([A-Za-z]){4} //Un grupo de 4 caracteres del alfabeto y que sean contiguos
    ([0-9]){7} //Un grupo de 3 caracteres numéricos y que sean contiguos
    ) //Dentro de paréntesis para que sea un solo grupo de 11 caracteres
    /m //Para que la búsqueda sea multilínea

     **/
    //$pattern = '/[[:<:]]([^a-zA-Z]*[A-Za-z]){4}([0-9]){7}/m';
    $pattern = '/(([A-Za-z]){4}([0-9]){7})/m';
    $matches = array();

    preg_match_all($pattern, $str, $matches, 0, $palCont);


    if( !empty($matches) &&
        is_array($matches) &&
        array_key_exists(0, $matches) &&
        !empty($matches[0]) &&
        is_array($matches[0]))
    {

        foreach($matches[0] as $k=>$v)
        {
            $cont[] = $v;
            $encontrado = true;
        }

    }

    return $encontrado;
}

/**
 * CalculaBancoCuentaSaldodeunArraydeMovimientos()
 *
 * @param array &$arrMovs = Array de Movimientos Bancarios, se pasa por referencia.
 * @param int|string $indexBalance = Indice que ocupará el Saldo.
 * @param int|string $bcid = ID de la cuenta bancaria.
 * @param bool $Original = true = Original, false = Verificacion.
 */
function CalculaBancoCuentaSaldodeunArraydeMovimientos(array &$arrMovs = [], int|string $indexBalance="balance", int|string $bcid = "", bool $Original = true, $order = "DESC", $saldo_inicial = null): array
{
    $indexBalance="balance";
    $bcmid='banco_cuenta_mov_id';
    $deposit='deposit';
    $cash='cash';
    $withdrawal='withdrawal';

    if(empty($arrMovs))
        return $arrMovs;

    $arrLength = sizeof($arrMovs);
    $arrLength--;
    $arrLength_ = $arrLength;

    if($order == "DESC") {
        $arrMovs[$arrLength][$indexBalance] = ($saldo_inicial != null) ? $saldo_inicial : CalculaBancoCuentaSaldodesdeunMovimiento($bcid, $arrMovs[$arrLength][$bcmid], $Original);
        $arrLength--;

        while ($arrLength >= 0) {
            $arrMovs[$arrLength][$indexBalance] = number_format($arrMovs[$arrLength + 1][$indexBalance] + ($arrMovs[$arrLength][$cash] + $arrMovs[$arrLength][$deposit] - $arrMovs[$arrLength][$withdrawal]), 2, ".", "");
            $arrLength--;
        }
    }
    else{
        $arrLength = 0;
        $arrMovs[$arrLength][$indexBalance] = ($saldo_inicial != null) ? $saldo_inicial : CalculaBancoCuentaSaldodesdeunMovimiento($bcid, $arrMovs[$arrLength][$bcmid], $Original);
        $arrLength++;

        while ($arrLength <= $arrLength_) {

            $arrMovs[$arrLength][$indexBalance] = number_format( $tmp + ($arrMovs[$arrLength][$cash] + $arrMovs[$arrLength][$deposit] - $arrMovs[$arrLength][$withdrawal]), 2, ".", "");
            $arrLength++;
        }
    }
    return $arrMovs;
}

function CalculaBancoCuentaSaldodesdeunMovimiento($banco_cuenta_id, $banco_cuenta_mov_id, $Original=true)
{
    $balance = 0.00;
    if($banco_cuenta_id == '' || $banco_cuenta_mov_id == '')
        return $balance;

    if(empty($banco_cuenta_mov_id))
        return 0;
    else
    {
        if($Original) {
            $idField = 'banco_cuenta_mov_id'; $tbl = 'banco_cuenta_mov';
            $fecha = ia_singleread( "SELECT fecha FROM `$tbl` WHERE `banco_cuenta_mov_id` = ".strit($banco_cuenta_mov_id),false);
            //$sql =  "SELECT fecha FROM `$tbl` WHERE `banco_cuenta_mov_id` = ".strit($banco_cuenta_mov_id);
            //echo "$sql<br />";
        } else {
            $idField = 'mov_verificado_id'; $tbl = 'mov_verificado';
            $fecha = ia_singleread( "SELECT fecha FROM `$tbl` WHERE `mov_verificado_id` = ".strit($banco_cuenta_mov_id),false);
        }
    }
    if( !empty($fecha) )
    {
        $foundit=false;
        $balance = 0.00;
        $sql = "SELECT $idField, fecha, banco_cuenta_id, deposit, withdrawal FROM $tbl WHERE banco_cuenta_id = '$banco_cuenta_id' AND fecha <= '$fecha' ORDER BY fecha DESC, $idField DESC";
        //echo "$sql";
        $arr = ia_sqlArrayIndx($sql);
        if( !empty($arr) ) foreach($arr as $k=>$v) {
            if($v[$idField] == $banco_cuenta_mov_id)
                $foundit = true;
            if($foundit)
                $balance+= $v['deposit'] - $v['withdrawal'];
        }
    }
    //echo "$balance<br />";
    return $balance;
}

function HazLinkBancarioManualIncompleto($bcm_id, $Quantity, $lm_tienda_id, $lm_docto, $banco_id, $usuario)
{
    $bcml_id = ia_guid();

    $acta_id = ia_guid();

    $arr_tlm = TablaparaLinkManual($lm_docto);
    //print_r($arr_tlm);

    $acta_tbl = $arr_tlm["acta_tabla"];
    //$acta_tbl = $lm_docto . '_pago';
    $acta_id_nombre = $acta_tbl . '_id';

    $acta_fecha = date('Y-m-d H:i:s');
    $acta_quantity = $Quantity;
    $acta_moneda_id = 1;
    $acta_tipo_cambio = 1;
    $acta_metodo_pago_id = 1;
    $acta_banco_id = $banco_id;
    $acta_referencia = $arr_tlm["acta_comentarios"];
    $acta_comentario = $arr_tlm["acta_comentarios"];
    $acta_referencia .= 'Link manual desde Edo Cta. ';
    $acta_comentario .= 'Link manual desde Edo Cta. ';
    $acta_alta_db = $acta_fecha;
    $acta_alta_por = $usuario;


    $oknumop = 3; //Hay 3 queries. Insertar a cuenta, el banco_cuenta_mov_link, y actualizar el banco_cuenta_mov.
    $ok = 0;

    $acta_sql = "INSERT INTO $acta_tbl ($acta_id_nombre, fecha, quantity, moneda_id, tipo_cambio, metodo_pago_id, banco_id, banco_cuenta_mov_link_id, referencia, comentario, alta_db, alta_por) VALUES ('$acta_id', '$acta_fecha', '$acta_quantity', '$acta_moneda_id', '$acta_tipo_cambio', '$acta_metodo_pago_id', '$acta_banco_id', '$bcml_id', '$acta_referencia', '$acta_comentario', '$acta_alta_db', '$acta_alta_por')";
    if(!ia_query($acta_sql,true,false))//Inserto el a cuenta.
        $ok++;
    //echo $acta_sql . '<br>';

    $bcml_sql = "INSERT INTO banco_cuenta_mov_link (banco_cuenta_mov_link_id, banco_cuenta_mov_id, link_to, link, tienda_id, link_por, link_el) VALUES ('$bcml_id', '$bcm_id', '$acta_tbl', '$acta_id', '$lm_tienda_id', '$acta_alta_por', '$acta_alta_db')";
    if(!ia_query($bcml_sql,true,false))//Inserto el a cuenta.
        $ok++;
    //echo $bcml_sql . '<br>';

    $bcm_sql = "UPDATE banco_cuenta_mov SET usado = usado + $Quantity, link_vale = 'ND', puede_editar = 'No', ultimo_cambio = '$acta_alta_db', ultimo_cambio_por = '$acta_alta_por' WHERE banco_cuenta_mov_id = '$bcm_id'";
    if(!ia_query($bcm_sql,true,false)) //Actualizo al banco_cuenta_mov, le resto el Quantity del Usado.
        $ok++;
    //echo $bcm_sql . '<br>';

    if($ok == $oknumop)
        return $acta_tbl;
    else
        return false;
}

function esBancoChina($banco_cuenta_id='')
{
    if(empty($banco_cuenta_id))
        return false;

    $es=ia_singleread("SELECT banco_china FROM banco_cuenta WHERE banco_cuenta_id =".strit($banco_cuenta_id));

    if($es == 'Si')
        return true;
    else
        return false;
}

function generaaCuentasdeBancoMov($bcmid, $tr='str', $li='NO', $debug=false, $dep_banco_tans_id="", $bcml_id = '')
{
    //global $gIAsql;
    //$gIAsql['trace']=true;
    $infoDebug='';

    if(empty($bcmid))
        return;

    $banco_cuenta_mov_id = $bcmid;

    if($tr=='str')
        $acta_resumen = '';
    else
        $acta_resumen = array();

    $nl=$li=='SI'?'<li>':"\r\n<br>";
    $il=$li=='SI'?0:1;

    $Original = true;

    if($banco_cuenta_mov_id == '' || strlen($banco_cuenta_mov_id) < 32)
        return $acta_resumen;

    $BancoCuentaMov = new BancoCuentaMov;
    $BancoCuentaMov->Original = $Original;
    if(!$BancoCuentaMov->leeBancoCuentaMov($banco_cuenta_mov_id))
        return $acta_resumen;

    //Leemos los a cuentas de este movimiento bancario.
    if($BancoCuentaMov->link_vale == 'LT' && $BancoCuentaMov->withdrawal > 0)
        $bcml_arr = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_mov_link WHERE link_to='banco_cuenta_mov' AND link = ". strit($BancoCuentaMov->banco_cuenta_mov_id));
    else
        $bcml_arr = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_id = ". strit($BancoCuentaMov->banco_cuenta_mov_id));

    if (!empty($bcml_id))
        $bcml_arr = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_mov_link WHERE  banco_cuenta_mov_link_id =". strit($bcml_id));


    if ($debug)
        $infoDebug .= "\r\n<pre>generaaCuentasdeBancoMov bcml_arr: " . print_r($bcml_arr, true) . "</pre>";


    if($debug)
    {
        //28-ene-2021
        global $gWebDir;
        $myFile = "C:\\wamp\\www\\$gWebDir\\backoffice\\txt\\generaaCuentasdeBancoMov_$bcmid.txt";
        $fh = fopen($myFile, 'w') or die("can't open file");
        $bleh = $infoDebug;
        fwrite($fh, $bleh);
        fclose($fh);
    }

    if(is_array($bcml_arr) && !empty($bcml_arr))
        foreach($bcml_arr as $k=>$bcmlrow)
        {
            //Leemos la información de cada a cuenta y le metemos al arreglo $acta_arr. Es estándar para todos los tipos de documentos padre (cheque, nota, pagaré).
            $acta_arr = leeaCuenta($bcmlrow['link_to'], $bcmlrow['link'], $bcmlrow['banco_cuenta_mov_link_id'], $bcmlrow['tienda_id']);
            // dd_($acta_arr);

            if($acta_arr===false) continue;
            //print_r($acta_arr);
            $cactar = $k>=$il?$nl:'';

            $ar_pre = '';
            $ar_post = '';

            if(!empty($acta_arr['acta_moneda']) && $acta_arr['acta_moneda'] == 'USD')
            {
                $ar_pre = "<span class='actaUSD'>";
                $ar_post = "</span>";
            }

            $cactar .= $ar_pre;


            $class_moneda = $acta_arr['acta_moneda'] == "USD" ? "txt_shadow_verde" : "txt_shadow_azul_marino";

            $cactar .= $acta_arr['acta_numero'] != '' ? $acta_arr['acta_numero'].', ': '';
            $link_open = $acta_arr['link_open']??'';
            $cactar .= $acta_arr['acta_quantity'] != '' ? 'MONTO APLICADO: '.$link_open.'<strong class="'. $class_moneda .'">$'.number_format(floatval($acta_arr['acta_quantity']), 2, '.', ',').'</strong> ' : '';



            $txt_moneda = "<strong class='$class_moneda'>$acta_arr[acta_moneda]</strong> ";

            $cactar .= $txt_moneda;

            $link_close = $acta_arr['link_close']??'';
            $cactar .= $link_close;

            // $disponible = number_format(floatval(bcsub($BancoCuentaMov->deposit, $BancoCuentaMov->usado, 2)), 2);
            $usado=round($BancoCuentaMov->usado,2);
            $disponible=echonf(abs($BancoCuentaMov->deposit-$usado),true);
            $cactar .= "<br>DISPONIBLE: <strong class='$class_moneda'>$ $disponible</strong> $txt_moneda <br>";

            $cactar .= $acta_arr['acta_desc'] != '' ? $acta_arr['acta_desc'].' ' : ' ';
            $cactar .= $ar_post;

            $cactar .= !empty($acta_arr['actapadre_tiendaclv']) ? '('.$acta_arr['actapadre_tiendaclv'].')' : '';
            $cactar .= !empty($acta_arr['actapadre_number']) ? ' #'.$acta_arr['actapadre_number'].' ' : ' ';
            $cactar .= !empty($acta_arr['actapadre_quantity']) ? ' DE <strong>$'.number_format(floatval($acta_arr['actapadre_quantity']), 2, '.', ',').'</strong> ' : '';
            $cactar .= !empty($acta_arr['actapadre_moneda']) ? $acta_arr['actapadre_moneda'] : '';

            //$acta_resumen .= '.';

            if($bcmlrow['link_to'] == 'banco_cuenta_mov') {
                //Los remarks de las transferencias entre cuentas propias, los tomo del registro mismo de banco_cuenta_trans directamente. Ya están preparados =)
                if(!empty($dep_banco_tans_id))
                $cactar = ia_singleread("SELECT remarks FROM banco_cuenta_trans WHERE banco_cuenta_mov_link_id = " . strit($bcmlrow['banco_cuenta_mov_link_id']));
            }
            else{
                if ($bcmlrow['link_to'] == 'cuentat_mov') {
                    $cbenDB = ia_singleton("SELECT * FROM cuentat_a_banco WHERE banco_cuenta_mov_link_id=" . strit($bcmlrow['banco_cuenta_mov_link_id']));

                    $acta_arr['remarks'] .= !empty($cbenDB['remarks']) ? nl2br($cbenDB['remarks']) : '';
                    $acta_arr['actapadre_nombre'] .= !empty($cbenDB['tipo_cash_nota']) ? "<br>$cbenDB[tipo_cash_nota]: " : '';
                    $acta_arr['actapadre_nombre'] .= !empty($cbenDB['cash_nota_num']) ? "$cbenDB[cash_nota_num]" : '';
                    $acta_arr['actapadre_nombre'] .= !empty($cbenDB['cliente']) ? "<br>CLIENTE: $cbenDB[cliente]" : '';
                    $acta_arr['actapadre_nombre'] .= !empty($cbenDB['factura']) ? "<br>$cbenDB[factura]" : '';
                    $acta_arr['actapadre_nombre'] .= !empty($cbenDB['factura_numero']) ? ": $cbenDB[factura_numero]" : '';
                } else {
                    if (array_key_exists('acta_comentario', $acta_arr) && $bcmlrow['link_to'] != 'banco_cuenta_mov')
                        $acta_arr['remarks'] .= !empty($acta_arr['acta_comentario']) ? nl2br($acta_arr['acta_comentario']) : '';
                    else
                        $acta_arr['remarks'] = '';
                }

                $cactar .= $acta_arr['actapadre_nombre'] != '' ? '<br>' . $acta_arr['actapadre_nombre'] : '';
                $cactar .= $acta_arr['actapadre_nombre_cheque'] != '' ? '<br>' . 'Cheque a nombre de: ' . BoldaString($acta_arr['actapadre_nombre_cheque']) : '';
                $cactar .= $acta_arr['acta_ctaTmov'] != '' ? '<br>' . $acta_arr['acta_ctaTmov'] : '';

                // $cactar = strtoupper($cactar);
                $cactar = str_replace('ACUTE', 'acute', $cactar);
                $cactar = str_replace('ACTAUSD', 'actausd', $cactar);
                $cactar = str_replace('TXT_SHADOW_VERDE', 'txt_shadow_verde', $cactar);
                $cactar = str_replace('TXT_SHADOW_AZUL_MARINO', 'txt_shadow_azul_marino', $cactar);

                $cactar .= "<br />" . html_entity_decode($acta_arr['remarks']);


            }
            if($tr=='str')
                $acta_resumen .= $cactar;
            else
                $acta_resumen[] = $cactar;

        }

    /**
    echo "<pre>gIAsql".print_r($gIAsql, true)."</pre>";
    echo "<pre>bcml_arr".print_r($bcml_arr, true)."</pre>";
    echo "<pre>acta_arr".print_r($acta_arr, true)."</pre>";
    echo "<pre>acta_resumen".print_r($acta_resumen, true)."</pre>";
     **/

    return $acta_resumen;
}

function generayGuardaaCuentasdeBancoMov($bcm_id='', $debug=false, $guarda=true, $bcml=false, $mantieneRemarks = false, $bcml_id = '')
{
    if(empty($bcm_id))
        return;

    if($bcml) {
        // echo $sql;
        $sql = "SELECT banco_cuenta_mov_id FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_link_id = '$bcm_id'";
        $bcm_id = ia_singleread($sql);
    }

    $oldRemarks = ia_singleread("SELECT remarks FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'");

    // $actas = generaaCuentasdeBancoMov($bcm_id);
    $actas = generaaCuentasdeBancoMov($bcm_id, bcml_id:$bcml_id);


    //Aqui hacemos el cambio. Los remarks anteriores los pasamos a remarks_log.

//    $oldRemarks = empty($oldRemarks) ? "" : date('d-m-Y H:i:s').": $oldRemarks<hr/>";
    $oldRemarks = empty($oldRemarks) ? "" : "<hr/>$oldRemarks";

    $newRemarks = $actas . ($mantieneRemarks ? $oldRemarks : "");

    $oldRemarks = $newRemarks;// strtoupper($newRemarks);
    // $newRemarks = strtoupper($newRemarks);

    $oldRemarks = str_replace('ACUTE', 'acute', $oldRemarks);
    $newRemarks = str_replace('ACUTE', 'acute', $newRemarks);

    $links=generaListadoLinksBCM($bcm_id);

    $links=" ,detalle_links = ".strit($links);

    /**
     * JJDPL 22-03-2021
     * Se agrega función para generar link a cuentaT
     */
    $link_cuentaT = generaLinkAAcuentaT($bcm_id);

    $sql="UPDATE /** generayGuardaaCuentasdeBancoMov **/ banco_cuenta_mov SET
            remarks = ".strit($newRemarks).",
            remarks_log = CONCAT(remarks_log,".strit($oldRemarks)."),
            link_cuenta_t = ".strit($link_cuentaT)."
            $links
            WHERE banco_cuenta_mov_id=".strit($bcm_id);

    if($debug)
        echo "$newRemarks<br/><br/>$sql<br/><br/>";


    if($guarda)
    {
        if(ia_query($sql))
            ia_errores_a_dime($sql);
    }
    else
    {
        $arr = array();
        $arr['sql']=$sql;
        $arr['newRemarks']=$actas;
        $arr['oldRemarks']=$oldRemarks;
        $arr['link_cuentaT']=$link_cuentaT;
        return $arr;
    }

    return true;
}

function generaListadoLinksBCM($bcmID, $tr='str')
{
    if(empty($bcmID))
        return;

    if($tr=='str')
        $txtLinks = '';
    else
        $txtLinks = array();

    $bcmenDB = ia_singleton("SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcmID'");
    $fDeposit=$bcmenDB['deposit'];

    if($bcmenDB['link_vale'] == 'LT' && $bcmenDB['withdrawal'] > 0)
        $bcmlenDB = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_mov_link WHERE link_to='banco_cuenta_mov' AND link = ". strit($bcmID));
    else
        $bcmlenDB = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_id = ". strit($bcmID));

    if(is_array($bcmlenDB) && !empty($bcmlenDB))
        foreach($bcmlenDB as $k=>$bcml)
        {
            $acta_arr = leeaCuenta($bcml['link_to'], $bcml['link'], $bcml['banco_cuenta_mov_link_id'], $bcml['tienda_id']);
            if($acta_arr===false) continue;
            $txtLink = $acta_arr['acta_app_origen'].
                ($acta_arr['acta_app_origen']=="Link de CuentaT" ? " ".propdeCtaT($acta_arr['acta_cuentat_id'],'usuario',true).", ":", ");
            $txtLink .= "por: $bcml[link_por], ";
            $txtLink .= "el ".get_date_spanish(strtotime($bcml['link_el']), false, 'small_date','month_mini').", ";
            $fDeposit-=$acta_arr['acta_quantity_total'];
            $txtLink .= "$".echonf($acta_arr['acta_quantity_total'],true);
            $txtLink .= ($acta_arr['acta_quantity_total'] != $acta_arr['acta_quantity'] ? " ($".echonf($acta_arr['acta_quantity'],true)."), ":", ");
            $txtLink .= "RESTA $".echonf($fDeposit,true);
            $txtLink = strtoupper($txtLink);
            $href='';
            switch($bcml['link_to'])
            {
                case 'cheque_pago': case 'pagare_pago': case 'vale': case 'vale_pago': //VALE_PAGO_MULTIPLE
                $href="../backoffice/a_cuentas.php?doc_pago_id=$acta_arr[acta_id]";
                break;

                case 'cuentat_mov':
                    $href="../backoffice/cuentat_a_banco_list.php?cuentat_a_banco_id=$acta_arr[acta_id]";
                    break;

                case 'fiduciario_reembolso':
                    $href="../backoffice/fiduciario_reembolso.php?fiduciario_reembolso_id=$acta_arr[acta_id]";
                    break;

                case 'banco_cuenta_mov':
                    $href="../cobranza/edocta.php?banco_cuenta_id=$acta_arr[acta_banco_cuenta_id]&banco_cuenta_mov_id=$acta_arr[acta_id]";
                    break;
            }

            $txtLink = "<li><a href=\"$href\" target=\"_blank\">$txtLink</a>";

            if($tr=='str')
                $txtLinks.=$txtLink;
            else
                $txtLinks[]=$txtLink;
        }
    return $txtLinks;
}

function generayGuardaListadoLinksBCM($bcmID, $debug=false, $guarda=true)
{
    if(empty($bcmID))
        return;

    $sql='';
    $links = generaListadoLinksBCM($bcmID);
    if(!empty($links))
        $sql="UPDATE /** generayGuardaListadoLinksBCM **/ banco_cuenta_mov SET
        detalle_links = ".strit($links)."
        WHERE banco_cuenta_mov_id=".strit($bcmID);

    if($debug && !empty($links))
        echo "$links<br/><br/>";


    if($guarda && !empty($sql))
    {
        if(ia_query($sql))
            ia_errores_a_dime($sql);
    }
    else
    {
        $arr = array();
        $arr['sql']=$sql;
        $arr['links']=$actas;
        return $arr;
    }

    return true;
}

function bancoCuentaMovs($andWhere='',$orderby='')
{
    global $gIAsql;
    $gIAsql['trace'] = true;


    $sql = obtenSQLBancoCuentaMovs();

    //echo "<pre>sql".print_r($sql, true)."</pre>";

    if(!empty($andWhere))
    {
        if(strpos($andWhere, " AND (") == 0)
            $andWhere = substr($andWhere,5);

        $andWhere = " WHERE $andWhere ";
    }
    $sql .= $andWhere . " GROUP BY banco_cuenta_mov_id ".$orderby;

    //echo "<pre>sql".print_r($sql, true)."</pre>";die();

    $arrBCMovs = ia_sqlArrayIndx($sql,MYSQL_NUM);
    //$arrBCMovs = ia_sqlArray($sql,'0',MYSQL_NUM);
    //echo "<pre>".print_r($arrBCMovs, true)."</pre>";die();

    return $arrBCMovs;
}

function obtenSQLBancoCuentaMovs()
{
    $sql = "SELECT
b.banco_cuenta_mov_id AS banco_cuenta_mov_id,
b.balance as balance,
b.banco_id AS banco_id,
b.banco_cuenta_id AS banco_cuenta_id,
b.fecha AS fecha,
b.es AS es,
b.withdrawal AS withdrawal,
b.deposit AS deposit,
b.cash AS cash,
b.link_vale AS link_vale,
b.banco_mov_tipo_id AS banco_mov_tipo_id,
b.usado AS usado,
b.puede_editar AS puede_editar,
b.verificado AS verificado,
b.verificado_el AS verificado_el,
b.verificado_por AS verificado_por,
b.mov_verificado_id AS mov_verificado_id,
b.remarks AS remarks,
b.numero AS numero,
'' as actions,
b.cliente AS cliente,
l.link_por AS link_por,
b.tipo_cash_nota AS tipo_cash_nota,
b.cash_nota_num AS cash_nota_num,
b.alta_db AS alta_db,
b.alta_por AS alta_por,
b.ultimo_cambio AS ultimo_cambio,
b.ultimo_cambio_por AS ultimo_cambio_por,
b.idex100 AS idex100,
b.idetotal AS idetotal,
IF(deposit-withdrawal-(deposit*idex100/100)>0,deposit-withdrawal-(deposit*idex100/100),0) as netdeposit,
b.factura AS factura,
b.factura_numero AS factura_numero,
b.cobra_iva AS cobra_iva,
b.iva_incluido AS iva_incluido,
b.ivacobradox100 AS ivacobradox100,
b.ivacobradototal AS ivacobradototal,
b.cash_num_cobro_iva AS cash_num_cobro_iva,
b.tienda_id AS tienda_id,
b.empresa_id AS empresa_id,
l.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
l.link_to AS link_to,
l.link_el AS link_el,
l.link AS link,
b.poliza_contabilidad AS poliza_contabilidad,
l.tienda_id AS link_tienda_id,
b.categoria_gasto_id,
b.remarks_log AS remarks_log,
b.withdrawal_autorizado AS withdrawal_autorizado,
b.withdrawal_autorizado_el AS withdrawal_autorizado_el,
b.withdrawal_autorizado_por AS withdrawal_autorizado_por
FROM banco_cuenta_mov b
LEFT OUTER JOIN banco_cuenta_mov_link l
ON b.banco_cuenta_mov_id = l.banco_cuenta_mov_id";

    return $sql;
}

function banco_cuenta_saldos_refresh() {
    return false;
    return ia_query("
        INSERT INTO banco_cuenta_saldos(`banco_cuenta_id`,`saldo_actual`,`sbc`,`deposit_cash`,`deposit_total`,`withdrawal_total`,`Ultimo_Movimiento`,`Ultimo_cash`,`Ultimo_deposit`,`Ultimo_withdrawal`,`ultima_conciliacion`,`orden`,`nombre`)
        (
            SELECT
                bcm.banco_cuenta_id,
                SUM(bcm.cash + bcm.deposit - bcm.withdrawal) as saldo_actual,
                SUM(IF(bcm.link_vale='SBC',bcm.cash + bcm.deposit,0)) as sbc,
                SUM(bcm.cash+bcm.deposit) as deposit_cash,
                SUM(bcm.cash + bcm.deposit) as deposit_total,
                SUM(bcm.withdrawal) as withdrawal_total,
                MAX(fecha) as Ultimo_Movimiento,
                MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_cash,
                MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_deposit,
                MAX(IF(bcm.withdrawal>0,fecha,NULL)) as Ultimo_withdrawal,
                bc.ultima_conciliacion,
                bc.orden,
                bc.nombre
            FROM banco_cuenta_mov bcm JOIN banco_cuenta bc ON bcm.banco_cuenta_id = bc.banco_cuenta_id WHERE bc.vale = 'Active'
            GROUP BY bcm.banco_cuenta_id
        )
        ON DUPLICATE KEY UPDATE
            `saldo_actual`=VALUES(`saldo_actual`),
            `sbc`=VALUES(`sbc`),
            `deposit_cash`=VALUES(`deposit_cash`),
            `deposit_total`=VALUES(`deposit_total`),
            `withdrawal_total`=VALUES(`withdrawal_total`),
            `Ultimo_Movimiento`=VALUES(`Ultimo_Movimiento`),
            `Ultimo_cash`=VALUES(`Ultimo_cash`),
            `Ultimo_deposit`=VALUES(`Ultimo_deposit`),
            `Ultimo_withdrawal`=VALUES(`Ultimo_withdrawal`),
            `ultima_conciliacion`=VALUES(`ultima_conciliacion`),
            `orden`=VALUES(`orden`),
            `nombre`=VALUES(`nombre`)
        ");
}

function preparaTablaSaldosBanco()
{
    $sql = "SELECT banco_cuenta_id, orden, nombre, Ultimo_Movimiento, ultima_conciliacion, solicitud_de_importacion, solicitud_por, solicitud_el FROM banco_cuenta_saldos";
    $ctas = ia_sqlArray($sql, "banco_cuenta_id");

    uasort($ctas, function($a,$b) {
        if($a['orden'] === $b['orden'])
            return  strnatcasecmp($a['nombre'], $b['nombre']);
        return $a['orden'] > $b['orden'];
    });

    $html = "";

    $html .= "<div align='center' style='width:90%;margin-top:32px;'>
        <table id='saldosBancos' class='tabla tablesorter' align='center' style='width:1400px;'>
        <thead>
        <tr>
            <th class='cen lbl'>CUENTA</th>
            <th class='cen'>ÚLTIMO MOVIMIENTO</th>
            <th class='cen'>ACTUALIZADO HACE</th>
            <th class='cen'>SOLIC. DE ACTUALIZACIÓN</th>
            <th class='cen'>SOLIC. POR</th>
            <th class='cen'>SOLIC. HACE</th>
        </tr></thead><tbody>";

    foreach($ctas as $k => $c)
    {
        if(empty($c['ultima_conciliacion'])) {
            $fuch = $ultima_conc = $txt_difHoras = '';
        } else {
            $fuch = $c['ultima_conciliacion'];
            $fuch = strtotime($fuch);
            $txt_difHoras = txtHaceCuantoTiempo($fuch, $nowTime, $monedaClass);
            $ultima_conc = get_date_spanish($fuch, false,'small_date','month_mini') . " - " . date('H:i:s',$fuch);
        }
        $atitle = "title='".htmlentities($cuentaBancaria['banco'].' #cta: '.$cuentaBancaria['numero'],ENT_QUOTES)."'";
        echo "\r\n<tr class='$cuentaBancaria[vale]'>".
            "<td style='width:3%' class='der nocopy noprint white' style='color:white !important'>".trim($cuentaBancaria['orden']).
            "<td style='width:20%'>".
            "<a  class='asin $monedaClass'  $atitle href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$t[banco_cuenta_id]' target='_blank'><strong>".
            ia_htmlentities($cuentaBancaria['nombre'])."</strong></a>".

            "<td style='width:11%' class='der $monedaClass bold'>".echonf($t['saldo_actual'],true).
            "<td style='width:11%' class='der bold'>".echonf($t['saldo_actual']-$sbcActual,true).
            "<td style='width:11%' class='der bold txt_bold_red '>$txtsbcActual".
            "<td  class='cen'>".(empty($t['Ultimo_Movimiento']) ? '' :  get_date_spanish(strtotime($t['Ultimo_Movimiento']),false,'small_date','month_mini') ).
            "<td style='width:22%' class='der bold'>$txt_difHoras".
            "<td style='width:22%' class='cen bold'>$ultima_conc".

            "</tr>";

        return array($t['saldo_actual'], $sbcActual);
    }

}

function obtenNombreBancoCuenta($bcid)
{
    return ia_singleread("SELECT nombre  FROM banco_cuenta WHERE banco_cuenta_id = '$bcid'");
}

function genera_banco_cuenta_saldos()
{
    $arr_cuentas = ia_sqlArrayIndx("select * from banco_cuenta where vale = 'Active'");

    $sql = array();


    foreach ($arr_cuentas as $k => $v) {
        $bc_id = $v['banco_cuenta_id'];
        $sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=" . strit($bc_id);
        $sql[] = "CALL actualiza_banco_cuenta_saldos($bc_id)";

    }
//echo "<pre>".print_r($sql, true)."</pre>";
    ia_transaction($sql);

}

function encuentraSubcategoria($string = '')
{
    $subcategoria = null;
    if (!empty($string)) {
        $re_almacenaje = '/^\s*(ALMACENAJE |ALMACENAJE DE|ALMACENAJE|ALMACENAJE DE CONTENE).*?\s(.*?(\s))/mi';
        preg_match_all($re_almacenaje, $string, $matches_almacenaje, PREG_SET_ORDER);

        if (!empty($matches_almacenaje)) $subcategoria = 'ALMACENAJE';

        $re_limpieza = '/^\s*(LIMPIEZA |LIMPIEZA DE|LIMPIEZA|LIMPIEZA DE CONTENE).*?\s(.*?(\s))/mi';
        preg_match_all($re_limpieza, $string, $matches_limpieza, PREG_SET_ORDER);

        if (!empty($matches_limpieza)) $subcategoria = 'LIMPIEZA';

        /* if($carac) {
            if(!strlen($subcategoria))
            {
                $subcategoria .= $line.PHP_EOL;
                $done = true;
                continue;
            }
        } */
    }

    return $subcategoria;
}


function quieroBuscarGasto($categoria = null, $subcategoria = null, $value = null, $importe = null, $level = 'all')
{
    $catgeorias = ['GASTOS DE CONTENEDOR']; // Level = 1
    $sub_categorias = ['ALMACENAJE']; // Level = 2
    $values = ['EITU9144722']; // Level = 3
    $importes = [''];

    $search = true;

    switch ($level) {
        case 'all':
                if(in_array($categoria, $catgeorias) and in_array($subcategoria, $sub_categorias) and in_array($value, $values) and in_array($importe, $importes) ) {
                    $search = false;
                }
            break;
        case '1': case 1:
                if(in_array($categoria, $catgeorias)) {
                    $search = false;
                }
            break;
        case '2': case 2:
                if(in_array($categoria, $catgeorias) and in_array($subcategoria, $sub_categorias)) {
                    $search = false;
                }
            break;
        case '3': case 3:
                if(in_array($categoria, $catgeorias) and in_array($subcategoria, $sub_categorias) and in_array($value, $values)) {
                    $search = false;
                }
            break;
        
        default:
                if(in_array($categoria, $catgeorias) and in_array($subcategoria, $sub_categorias) and in_array($value, $values) and in_array($importe, $importes) ) {
                    $search = false;
                }
            break;
    }



    return $search;
}

function generaLinkAAcuentaT($bcm_id)
{
    if (empty($bcm_id)) return '';

    // Recuperamos de banco_cuenta_mov_link
    $sql = "SELECT * FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_id = '$bcm_id'";
    $bcml = ia_singleton($sql);

    if (empty($bcml)) return '';

    // Recuperamos cuenta_t_mov_id del a cuenta origen (link_to)
    $field_id = "cuenta_t_mov_id";
    $field_cuentaT_id = "cuentaT_id";
    $link_to = $bcml['link_to'];
    $link_to_id = $bcml['link_to'] . "_id";
    switch ($link_to) {
        case 'cuentat_mov':
            $field_id = "cuentaT_mov_id";
            break;
        default:
                $field_id = "cuenta_t_mov_id";
            break;
    }
    $sql = "SELECT $field_id, $field_cuentaT_id FROM $link_to WHERE $link_to_id = '$bcml[link]'";
    $acuenta = ia_singleton($sql);
    
    if (empty($acuenta)) return '';

    $cuenta_t_mov_id = $acuenta[$field_id];
    $cuentaT_id = $acuenta['cuentaT_id'];

    $sql = "SELECT usuario FROM cuentat WHERE cuentaT_id = $cuentaT_id";
    $cuentaT_usuario = ia_singleread($sql);

   /*  $sql = "SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'";
    $bcm_current = ia_singleton($sql); */

    $link_a_cuenat_t = '<a
                            href = "../backoffice/cuentat_mov.php?cuentat='.$cuentaT_id.'&selected_row_id='.$cuenta_t_mov_id.'"
                            rel = "opener refferer"
                            target = "_blank"
                            title="Ir al movimiento de CuentaT">'
                            .$cuentaT_usuario.
                        '</a>';
    return $link_a_cuenat_t;
}

function leeIngresosEmpesas()
{
    global $configReporte;
    global $deposit_custom_where;
    $method = __METHOD__;
    $html = "";

    // Salen o no las cuentas sin movimientos, etc...
    $configReporte = array(
        'HideActiveSinMovimiento' => false, // true no sale en el listado principal las cuentas sin movimientos, false si salen
        'HideSaldoCero' => true, // ocultar cuenta si tiene saldo 0 y sbc 0.
    );
    $usuarioTipoRony = usuarioTipoRony();
    //VCA 26-02-2021 No queremos la cuenta de Rony aquí
    $bcarrayPESOS = cuenta_banco_mov_options('r', '', false, '1', null, false, false, false, true);

    $sinRony = " bc.banco_cuenta_id NOT IN (SELECT banco_cuenta_id FROM banco_cuenta WHERE tipo_inversion_empresa_privada = 'privada' OR banco_id = '14') "; //" bc.banco_cuenta_id NOT IN ('39') "; // EL id de la cuenta de banco de Rony, ni las cuentas del banco Monex

    $puedeVer = array();
    foreach ($bcarrayPESOS as $b) // banco cuenta con permiso nada no vienen en $bcarrayPESOS
        $puedeVer[$b['banco_cuenta_id']] = $b['banco_cuenta_id'];
    $cuentas = ia_sqlArray("SELECT /*$method*/ 
    bc.banco_cuenta_id,
    bc.nombre,
    bc.orden,
    bc.vale,
    bc.moneda_id,
    bc.banco_china,
    bc.numero,
    bc.ultima_conciliacion,
    bc.banco_id,
    b.banco,
    e.empresa
    FROM banco_cuenta bc
    LEFT OUTER JOIN banco b ON bc.banco_id=b.banco_id LEFT OUTER JOIN empresa e ON e.empresa_id = bc.empresa_id
    WHERE $sinRony
    ORDER BY bc.nombre", "banco_cuenta_id");

    $sbc = ia_sqlArray("SELECT /*$method*/ banco_cuenta_id, sbc as deposit_this_month, deposit_today, deposit_this_year, ingreso_last_year, deposit_custom FROM banco_cuenta_saldos bc WHERE sbc > 0 AND $sinRony", "banco_cuenta_id");

    $sbc = $sbc == false ? array() : $sbc;

    /** OJO VCA saldo_actual cambiar por suma de depositos entre fechas y sin los que no deban de ir **/
    $cym = ia_sqlArray("SELECT /*$method*/ bcs.banco_cuenta_id, bcs.orden, bcs.nombre, bcs.deposit_this_month, bcs.deposit_today, bcs.deposit_this_year, bcs.ingreso_last_year, bcs.deposit_custom, bcs.Ultimo_Movimiento, bcs.Ultima_conciliacion, e.empresa
     FROM banco_cuenta_saldos bcs 
         JOIN banco_cuenta bc ON bc.banco_cuenta_id=bcs.banco_cuenta_id 
         JOIN empresa e ON e.empresa_id=bc.empresa_id
         WHERE $sinRony",
        "banco_cuenta_id");

    uasort($cym, function ($a, $b) {
        if ($a['empresa'] === $b['empresa'])
            return strnatcasecmp($a['orden'], $b['orden']);
        return strnatcasecmp($a['empresa'], $b['empresa']);
    });

    $sumGroupInitialValues = ['Total' => 0.00, 'Disponible' => 0.00, 'SBC' => 0.00, 'Ultimo_movimiento' => '', 'ultima_conciliacion' => '', 'deposit_today' => 0.00, 'deposit_custom' => 0.00];
    $sumGroup = []; // CAMBIO
    $sumaCuentas = 0.00;
    $sumaSBC = 0.00;
    $sumaDisp = 0.00;
    $sumaToday = 0.00;
    $sumaCustom = 0.00;
    $nowTime = strtotime('now');
    if (!empty($cym) && is_array($cym)) {
        foreach ($cym as $banco_cuenta_id => $t) {
            if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] == 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active'
                && $cuentas[$banco_cuenta_id]['moneda_id'] == 1
            ) {
                $groupBy = $cuentas[$banco_cuenta_id]['empresa'];
                if (!isset($sumGroup[$groupBy]))
                    $sumGroup[$groupBy] = $sumGroupInitialValues;

                $sumGroup[$groupBy]['deposit_today'] += $t['deposit_today'];
                $sumGroup[$groupBy]['Total'] += $t['deposit_this_month'];
                $sumGroup[$groupBy]['SBC'] += $t['ingreso_last_year'];
                $sumGroup[$groupBy]['Disponible'] += $t['deposit_this_year'];
                $sumGroup[$groupBy]['deposit_custom'] += $t['deposit_custom'];

                if ($t['Ultimo_Movimiento'] > $sumGroup[$groupBy]['Ultimo_movimiento'])
                    $sumGroup[$groupBy]['Ultimo_movimiento'] = $t['Ultimo_Movimiento'];
                if ($cuentas[$banco_cuenta_id]['ultima_conciliacion'] > $sumGroup[$groupBy]['ultima_conciliacion'])
                    $sumGroup[$groupBy]['ultima_conciliacion'] = $cuentas[$banco_cuenta_id]['ultima_conciliacion'];
            }
        }

        $html .= table_header_vb('bancos_saldo', '', '');
        foreach ($cym as $banco_cuenta_id => $t)
            if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] == 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active') {
                $saldos = @table_row_vb($banco_cuenta_id, $t, $sbc, 'txt_color_PESOS', $cuentas[$banco_cuenta_id], $nowTime, $sumGroup);
                $sumaCuentas += $saldos[0]; // $t['saldo_actual'];
                $sumaSBC += $saldos[2]; //
                $sumaDisp += $saldos[1]; //
                $sumaToday += $saldos[3]; //
                $html .= $saldos[4];
                $sumaCustom += $saldos[5]; //
            }
        $html .= table_footer_vb('txt_color_PESOS', '', $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom);

        // reporta cuentas en usd
        $hayusd = null;
        $sumaCuentas = 0;
        $sumaSBC = 0;
        $sumaDisp = 0;
        $sumaToday = 0;
        $sumaCustom = 0;
        $bcarrayUSD = cuenta_banco_mov_options('r', '', false, '2', null, false, false, false, true);
        $puedeVer = array();
        foreach ($bcarrayUSD as $b) // banco cuenta con permiso nada no vienen en $bcarrayUSD
            $puedeVer[$b['banco_cuenta_id']] = $b['banco_cuenta_id'];

        foreach ($cym as $banco_cuenta_id => $t) {
            if (isset($puedeVer[$banco_cuenta_id]) && $cuentas[$banco_cuenta_id]['moneda_id'] != 1) {
                if ($hayusd === null) {
                    $hayusd = true;
                    $html .= table_header_vb('bancos_saldo_usd', 'Cuentas en USD', 'txt_color_USD');

                    foreach ($cym as $banco_cuenta_id => $t)
                        //solo mostrar cuentas con permisos, en dolares y activas
                        if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] != 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active') {
                            $saldos = @table_row_vb($banco_cuenta_id, $t, $sbc, 'txt_color_USD', $cuentas[$banco_cuenta_id], $nowTime);
                            $sumaCuentas += $saldos[0]; // $t['saldo_actual'];
                            $sumaSBC += $saldos[2]; //
                            $sumaDisp += $saldos[1]; //
                            $sumaToday += $saldos[3]; //
                            $html .= $saldos[4];
                            $sumaCustom += $saldos[5]; //
                        }

                } // cuenta en USD o no pesos
            }
        }
        $html .= table_footer_vb('txt_color_USD', 'txt_color_USD', $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom);
    } // end if if(!empty($cym) && is_array($cym))
    return array("html" => $html, "cym" => $cym, "saldos" => $saldos);
}

function table_header_vb($table_id, $caption, $usdClass)
{
    global $deposit_custom_where;

    $html = "";
    $expandCollapse =
        "
          <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Mostrar detalles de todas las cuentas' onclick='expandAll(this)'>
          <span class='ui-icon ui-icon-plus'></span>
          </button>

          <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Ocultar detalles de todas las cuentas' onclick='collapseAll(this)'>
          <span class='ui-icon ui-icon-minus'></span>
          </button>
        ";
    if (usuarioTipoRony())
        $copy = "
            <div style='text-align:left' class='toolbar_exporter' id='toolbar_$table_id'>
              <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Copiar' data-clipboard-target='#$table_id'>
              <span class='ui-icon ui-icon-copy'></span>
              </button> $expandCollapse

            </div>";
    else
        $copy = "<div style='text-align:left'>$expandCollapse</div>";
    $headerStyle = " style='font-weight:bold;font-size: 17px;color:#0000FF' ";
    $headerBlack = " style='font-weight:bold;font-size: 17px;color:black' ";

    $headerStyle150 = " style='font-weight:bold;font-size: 17px; width:150px; text-align:center; '";
    $headerStyle200 = " style='font-weight:bold;font-size: 17px; width:200px; '";
    $headerStyle250 = " style='font-weight:bold;font-size: 17px; width:250px; '";
    $headerStyle450 = " style='font-weight:bold;font-size: 17px; width:400px; '";
    $headerBlack150 = " style='font-weight:bold;font-size: 17px; width:150px; text-align:center; '";
    $headerBlack110 = " style='font-weight:bold;font-size: 17px; width:110px; '";
    $headerBlack250 = " style='font-weight:bold;font-size: 17px; width:250px; '";

    $now = strtotime("now");
    $txt_this_year = date('Y');
    $txt_today = "HOY <br>" . get_date_spanish($now, false, 'small_date', 'month_mini');
    $txt_this_month = strtoupper(get_date_spanish($now, true, 'month', 'month_mini')) . " " . $txt_this_year;
    $txt_last_year = date('Y', strtotime("last year"));

    $json_custom_nombre = ia_singleread("SELECT deposit_custom_where FROM banco_cuenta_saldos WHERE banco_cuenta_id > 0 LIMIT 1");
    //error_log($txt_custom_nombre);
    $obj_custom_nombre = empty($json_custom_nombre) ? new stdClass(): json_decode($json_custom_nombre);

    $obj_custom_nombre->txt_mes = $obj_custom_nombre->txt_mes ?? '';
    $obj_custom_nombre->fecha_ini = $obj_custom_nombre->fecha_ini ?? '';
    $obj_custom_nombre->fecha_fin = $obj_custom_nombre->fecha_fin ?? '';
//    $obj_custom_nombre->mes = !empty($obj_custom_nombre->fecha_ini) && $obj_custom_nombre->txt_mes != "Mes" && $obj_custom_nombre->mes != "" ? date("n",strtotime($obj_custom_nombre->fecha_ini)) : '12';

    $txt_custom_nombre = property_exists($obj_custom_nombre,"txt_mes") ? strtoupper($obj_custom_nombre->txt_mes) : "";

    if(empty($txt_custom_nombre) &&
        (   property_exists($obj_custom_nombre,"fecha_ini") && !empty($obj_custom_nombre->fecha_ini) ||
            property_exists($obj_custom_nombre,"fecha_fin") && !empty($obj_custom_nombre->fecha_fin)))
    {
        if(property_exists($obj_custom_nombre,"fecha_ini"))
            $txt_custom_nombre .= "DEL " . strtoupper(get_date_spanish(strtotime($obj_custom_nombre->fecha_ini), false, 'small_date'));

        if(property_exists($obj_custom_nombre,"fecha_fin"))
            $txt_custom_nombre .= (!empty($txt_custom_nombre) ? "<br />" : "") . " AL " . strtoupper(get_date_spanish(strtotime($obj_custom_nombre->fecha_fin), false, 'small_date'));

    }

//    $obj_custom_nombre->mes = empty($obj_custom_nombre->mes) ? 12 : $obj_custom_nombre->mes;
    $txt_custom = "$txt_custom_nombre<div id='deposit_custom_dates' data-fecha_ini='$obj_custom_nombre->fecha_ini' data-fecha_fin='$obj_custom_nombre->fecha_fin' data-txt_mes='$obj_custom_nombre->txt_mes' data-mes='$obj_custom_nombre->mes'></div>";

    $html .= "<div id='div_$table_id' align='center' style='width:95%;margin-left:auto;margin-right:auto;margin-top:32px;'>$copy
            <table id='$table_id' class='tabla tablausd tablesorter' align='center' >" .
        "<caption>$caption</caption><thead>" .
        "<tr class='tablesorter-headerRow'>" .

        "<th class='cen lbl $usdClass' $headerStyle450>EMPRESA</th>" .

        "<th class='cen lbl $usdClass' $headerStyle250>CUENTA</th>" .

        "<th class='cen lbl $usdClass' $headerStyle150>$txt_today</th>" .
        "<th class='cen lbl $usdClass' $headerStyle150>$txt_this_month</th>" .
        "<th class='cen $usdClass' $headerBlack150>$txt_this_year</th>" .
        "<th class='group-false cen txt_bold_red ' style=' text-align:center; width:150px; font-weight:bold;font-size:17px;color:red !important'>$txt_last_year</th>" .
        "<th class='cen $usdClass' $headerBlack150>$txt_custom</th>" .

        "</tr></thead><tbody>";

    return $html;
}

function showCuenta($banco_cuenta_id, $t, $sbc)
{
    global $configReporte;
    $sbcActual = array_key_exists($banco_cuenta_id, $sbc) ? $sbc[$banco_cuenta_id]['deposit_this_month'] : 0.00;
    if ($configReporte['HideActiveSinMovimiento'] && (
        (empty($sbcActual) && empty($t['Ultimo_Movimiento']) && empty($t['deposit_this_month']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['deposit_this_month']))
        )) {
        return false;
    }
    if ($configReporte['HideSaldoCero'] && (empty($t['deposit_this_month']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['deposit_this_month']))) {
        return false;
    }

    return true;
}

function table_row_vb($banco_cuenta_id, $t, $sbc, $monedaClass, $cuentaBancaria, $nowTime, $sumGroup = [])
{
    global $configReporte;
    $html = "";
    static $prevGroupedBy = "\t";

    if (!showCuenta($banco_cuenta_id, $t, $sbc)) {
        return array(0, 0);
    }
    $sbcActual = array_key_exists($banco_cuenta_id, $sbc) ? $sbc[$banco_cuenta_id]['deposit_this_month'] : 0.00;
    $txtsbcActual = $sbcActual > 0 ? echonf($sbcActual, true) : '';
    /*
            if($configReporte['HideActiveSinMovimiento'] && (
                (empty($sbcActual) && empty($t['Ultimo_Movimiento']) && empty($t['saldo_actual']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['saldo_actual'])  )
            )) {
                return array(0, 0);
            }
            if($configReporte['HideSaldoCero'] && (empty($t['saldo_actual']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['saldo_actual'])  ) ) {
                return array(0, 0);
            }
    */

    $font = " tableSorterCo";

    if ($prevGroupedBy != $cuentaBancaria['empresa']) {
        $prevGroupedBy = $cuentaBancaria['empresa'];
        $grp = $sumGroup[$prevGroupedBy] ?? '';

        if (empty($grp['ultima_conciliacion'])) {
            $fuchG = $ultima_concG = $txt_difHorasG = '';
        } else {
            $fuchG = strtotime($grp['ultima_conciliacion']);
            $txt_difHorasG = txtHaceCuantoTiempo($fuchG, $nowTime, $monedaClass);
            $ultima_concG = get_date_spanish($fuchG, false, 'small_date', 'month_mini') . " - " . date('H:i:s', $fuchG);
        }

        $html .= "\r\n\r\n\r\n<tr class='tablesorter-hasChildRow Group1'><td colspan=2>
                <a href='#' class='toggle asin txt_color_PESOS'>&#x25b6; " .( $cuentaBancaria['empresa'] ?? '' ). "</a></td>";
        $html .= "<td class='der groupTotal txt_color_PESOS bold saldo_actual nwp'>" . echonf($grp['deposit_today'] ?? '', true) . "</td>";
        $html .= "<td class='der groupTotal txt_color_PESOS bold saldo_actual nwp'>" . echonf($grp['Total'] ?? '', true) . "</td>";
        $html .= "<td class='der groupTotal bold nwp'>" . echonf($grp['Disponible'] ?? '', true) . "</td>";
        $html .= "<td class='der bold txt_bold_red  groupTotal'>" . (($grp['SBC'] ?? 0) == 0 ? '' : echonf($grp['SBC'] ?? '', true)) . "</td>";
        $html .= "<td class='der groupTotal bold nwp'>" . echonf($grp['deposit_custom'] ?? '', true) . "</td>";

        $html .= "</tr>\r\n\r\n";

    }

    if (empty($cuentaBancaria['ultima_conciliacion'])) {
        $fuch = $ultima_conc = $txt_difHoras = '';
    } else {
        $fuch = $cuentaBancaria['ultima_conciliacion'];
        $fuch = strtotime($fuch);
        $txt_difHoras = txtHaceCuantoTiempo($fuch, $nowTime, $monedaClass);
        $ultima_conc = get_date_spanish($fuch, false, 'small_date', 'month_mini') . " - " . date('H:i:s', $fuch);
    }
    $collapsed = 'display:none;';
    $atitle = "title='" . htmlentities($cuentaBancaria['banco'] . ' #cta: ' . $cuentaBancaria['numero'], ENT_QUOTES) . "'";
    $html .= "\r\n<tr class='tablesorter-childRow $cuentaBancaria[vale]' >" .

        "<td style='$collapsed ' class='$monedaClass $font nwp'>&nbsp;" .
        "<td style='$collapsed ' class='$font nwp'>" .
        "<a  class='asin $monedaClass'  $atitle href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$t[banco_cuenta_id]' target='_blank'><strong>" .
        ia_htmlentities($cuentaBancaria['nombre']) . "</strong>" .
        "</a>" .
        "<td style='$collapsed' class='der $monedaClass bold saldo_actual $font nwp'>" . echonf($t['deposit_today'], true) .
        "<td style='$collapsed' class='der $monedaClass bold saldo_actual $font nwp'>" . echonf($t['deposit_this_month'], true) .
        "<td style='$collapsed' class='der bold $font'>" . echonf($t['deposit_this_year'], true) .
        "<td style='$collapsed' class='der bold txt_bold_red  $font $font'>" . echonf($t['ingreso_last_year'], true) .
        "<td style='$collapsed' class='der bold $font'>" . echonf($t['deposit_custom'], true) .


        "</tr>";

    return array($t['deposit_this_month'], $t['deposit_this_year'], $t['ingreso_last_year'], $t['deposit_today'], $html, $t['deposit_custom']);
}

function table_footer_vb($class1, $class2, $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom)
{
    $html = "</tbody><tfoot><tr>" .
        "<td colspan=2 class='der bold $class2' style='font-size:17px;font-weight:700'>SUMAS:" .
        "<td class='der bold $class1' style='font-size:17px;font-weight:700'>" . echonf($sumaToday, true) .
        "<td class='der bold $class1' style='font-size:17px;font-weight:700'>" . echonf($sumaCuentas, true) .
        "<td class='der bold' style='font-size:17px;font-weight:700'>" . echonf($sumaDisp, true) .
        "<td class='der txt_bold_red' style='font-size:17px;font-weight:700'>" . echonf($sumaSBC, true) .
        "<td class='der bold' style='font-size:17px;font-weight:700'>" . echonf($sumaCustom, true) .
        "</tr>" .
        "</tfoot></table></div>";

    return $html;
}


function leeFiduciariosEmpesas()
{
    global $configReporte;
    global $fiduciario_custom_where;

    $html = "";

    // Salen o no las cuentas sin movimientos, etc...
    $configReporte = array(
        'HideActiveSinMovimiento' => false, // true no sale en el listado principal las cuentas sin movimientos, false si salen
        'HideSaldoCero' => true, // ocultar cuenta si tiene saldo 0 y sbc 0.
    );
    $usuarioTipoRony = usuarioTipoRony();

    $bcarrayPESOS = cuenta_banco_mov_options('r', '', false, '1', null, false, false, false, true);


    $puedeVer = array();
    foreach ($bcarrayPESOS as $b) // banco cuenta con permiso nada no vienen en $bcarrayPESOS
        $puedeVer[$b['banco_cuenta_id']] = $b['banco_cuenta_id'];
    $cuentas = ia_sqlArray("SELECT
    bc.banco_cuenta_id,
    bc.nombre,
    bc.orden,
    bc.vale,
    bc.moneda_id,
    bc.banco_china,
    bc.numero,
    bc.ultima_conciliacion,
    bc.banco_id,
    b.banco,
    e.empresa
    FROM banco_cuenta bc
    LEFT OUTER JOIN banco b ON bc.banco_id=b.banco_id LEFT OUTER JOIN empresa e ON e.empresa_id = bc.empresa_id
    ORDER BY bc.nombre", "banco_cuenta_id");

    //$sbc = ia_sqlArray("SELECT banco_cuenta_id, sbc as deposit_this_month, fiduciario_all, deposit_this_year, deposit_last_year, deposit_custom FROM banco_cuenta_saldos WHERE sbc > 0", "banco_cuenta_id");


    $sbc = ia_sqlArray("SELECT banco_cuenta_id, sbc as 	fiduciario_all, fiduciario_this_month, fiduciario_this_year, fiduciario_last_year, fiduciario_custom FROM banco_cuenta_saldos WHERE sbc > 0", "banco_cuenta_id");

    /** OJO VCA saldo_actual cambiar por suma de depositos entre fechas y sin los que no deban de ir **/
    $cym = ia_sqlArray("SELECT bcs.banco_cuenta_id, bcs.orden, bcs.nombre, bcs.fiduciario_all, bcs.fiduciario_this_month, bcs.fiduciario_this_year, bcs.fiduciario_last_year, bcs.fiduciario_custom, fiduciario_all, bcs.Ultimo_Movimiento, bcs.Ultima_conciliacion, e.empresa FROM banco_cuenta_saldos bcs JOIN banco_cuenta bc ON  bc.banco_cuenta_id=bcs.banco_cuenta_id JOIN empresa e ON e.empresa_id=bc.empresa_id",
        "banco_cuenta_id");

    uasort($cym, function ($a, $b) {
        if ($a['empresa'] === $b['empresa'])
            return strnatcasecmp($a['orden'], $b['orden']);
        return strnatcasecmp($a['empresa'], $b['empresa']);
    });

    $sumGroupInitialValues = ['Total' => 0.00, 'Disponible' => 0.00, 'SBC' => 0.00, 'Ultimo_movimiento' => '', 'ultima_conciliacion' => '', 'fiduciario_all' => 0.00, 'fiduciario_this_month' => 0.00, 'fiduciario_this_year' => 0.00, 'fiduciario_last_year' => 0.00, 'fiduciario_custom' => 0.00];
    $sumGroup = []; // CAMBIO
    $sumaCuentas = 0.00;
    $sumaSBC = 0.00;
    $sumaDisp = 0.00;
    $sumaToday = 0.00;
    $sumaCustom = 0.00;
    $nowTime = strtotime('now');
    if (!empty($cym) && is_array($cym)) {
        foreach ($cym as $banco_cuenta_id => $t) {
            if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] == 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active'
                && $cuentas[$banco_cuenta_id]['moneda_id'] == 1
            ) {
                $groupBy = $cuentas[$banco_cuenta_id]['empresa'];
                if (!isset($sumGroup[$groupBy]))
                    $sumGroup[$groupBy] = $sumGroupInitialValues;

                $sumGroup[$groupBy]['fiduciario_all'] += $t['fiduciario_all'];
                $sumGroup[$groupBy]['Total'] += $t['fiduciario_this_month'];
                $sumGroup[$groupBy]['SBC'] += $t['fiduciario_last_year'];
                $sumGroup[$groupBy]['Disponible'] += $t['fiduciario_this_year'];
                $sumGroup[$groupBy]['fiduciario_custom'] += $t['fiduciario_custom'];

                if ($t['Ultimo_Movimiento'] > $sumGroup[$groupBy]['Ultimo_movimiento'])
                    $sumGroup[$groupBy]['Ultimo_movimiento'] = $t['Ultimo_Movimiento'];
                if ($cuentas[$banco_cuenta_id]['ultima_conciliacion'] > $sumGroup[$groupBy]['ultima_conciliacion'])
                    $sumGroup[$groupBy]['ultima_conciliacion'] = $cuentas[$banco_cuenta_id]['ultima_conciliacion'];
            }
        }

        $html .= fid_table_header_vb('bancos_saldo', '', '');
        foreach ($cym as $banco_cuenta_id => $t)
            if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] == 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active') {
                $saldos = fid_table_row($banco_cuenta_id, $t, $sbc, 'txt_color_PESOS', $cuentas[$banco_cuenta_id], $nowTime, $sumGroup);
                $sumaCuentas += $saldos[0]; // $t['saldo_actual'];
                $sumaSBC += $saldos[2]; //
                $sumaDisp += $saldos[1]; //
                $sumaToday += $saldos[3]; //
                $html .= $saldos[4];
                $sumaCustom += $saldos[5]; //
            }
        $html .= fid_table_footer('txt_color_PESOS', '', $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom);

        // reporta cuentas en usd
        $hayusd = null;
        $sumaCuentas = 0;
        $sumaSBC = 0;
        $sumaDisp = 0;
        $sumaToday = 0;
        $bcarrayUSD = array(); //cuenta_banco_mov_options('r', '', false, '2', null, false, false, false, true);
        $puedeVer = array();
        foreach ($bcarrayUSD as $b) // banco cuenta con permiso nada no vienen en $bcarrayUSD
            $puedeVer[$b['banco_cuenta_id']] = $b['banco_cuenta_id'];

        foreach ($cym as $banco_cuenta_id => $t) {
            if (isset($puedeVer[$banco_cuenta_id]) && $cuentas[$banco_cuenta_id]['moneda_id'] != 1) {
                if ($hayusd === null) {
                    $hayusd = true;
                    $html .= fid_table_header_vb('bancos_saldo_usd', 'Cuentas en USD', 'txt_color_USD');
                }
                foreach ($cym as $banco_cuenta_id => $t)
                    //solo mostrar cuentas con permisos, en dolares y activas
                    if ((isset($puedeVer[$banco_cuenta_id]) || $usuarioTipoRony) && $cuentas[$banco_cuenta_id]['moneda_id'] != 1 && $cuentas[$banco_cuenta_id]['vale'] == 'Active') {
                        $saldos = fid_table_row($banco_cuenta_id, $t, $sbc, 'txt_color_USD', $cuentas[$banco_cuenta_id], $nowTime);
                        $sumaCuentas += $saldos[0]; // $t['saldo_actual'];
                        $sumaSBC += $saldos[2]; //
                        $sumaDisp += $saldos[1]; //
                        $sumaToday += $saldos[3]; //
                        $html .= $saldos[4];
                        $sumaCustom += $saldos[5]; //
                    }
                $html .= fid_table_footer('txt_color_USD', 'txt_color_USD', $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom);
            } // cuenta en USD o no pesos
        }
    } // end if if(!empty($cym) && is_array($cym))

    ia_errores_a_dime();
    return $html;
}

function fid_table_header_vb($table_id, $caption, $usdClass)
{
    global $fiduciario_custom_where;

    $html = "";
    $expandCollapse =
        "
          <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Mostrar detalles de todas las cuentas' onclick='expandAll(this)'>
          <span class='ui-icon ui-icon-plus'></span>
          </button>

          <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Ocultar detalles de todas las cuentas' onclick='collapseAll(this)'>
          <span class='ui-icon ui-icon-minus'></span>
          </button>
        ";
    if (usuarioTipoRony())
        $copy = "
            <div style='text-align:left' class='toolbar_exporter' id='toolbar_$table_id'>
              <button type='button' class='copyit ui-corner-all' style='vertical-align: bottom;cursor:pointer;' title='Copiar' data-clipboard-target='#$table_id'>
              <span class='ui-icon ui-icon-copy'></span>
              </button> $expandCollapse

            </div>";
    else
        $copy = "<div style='text-align:left'>$expandCollapse</div>";
    $headerStyle = " style='font-weight:bold;font-size: 17px;color:#0000FF' ";
    $headerBlack = " style='font-weight:bold;font-size: 17px;color:black' ";

    $headerStyle150 = " style='font-weight:bold;font-size: 17px;color:#0000FF; width:150px; '";
    $headerStyle200 = " style='font-weight:bold;font-size: 17px;color:#0000FF; width:200px; '";
    $headerStyle250 = " style='font-weight:bold;font-size: 17px;color:#0000FF; width:250px; '";
    $headerStyle450 = " style='font-weight:bold;font-size: 17px;color:#0000FF; width:400px; '";
    $headerBlack150 = " style='font-weight:bold;font-size: 17px;color:black; width:150px; '";
    $headerBlack110 = " style='font-weight:bold;font-size: 17px;color:black; width:110px; '";
    $headerBlack250 = " style='font-weight:bold;font-size: 17px;color:black; width:250px; '";

    $now = strtotime("now");
    $txt_this_year = date('Y');
    $txt_today = "ACTIVOS";
    $txt_this_month = strtoupper(get_date_spanish($now, true, 'month', 'month_mini')) . " " . $txt_this_year;
    $txt_last_year = date('Y', strtotime("last year"));

    $json_custom_nombre = ia_singleread("SELECT fiduciario_custom_where FROM banco_cuenta_saldos WHERE banco_cuenta_id > 0 LIMIT 1");
    //error_log($txt_custom_nombre);
    $obj_custom_nombre = empty($json_custom_nombre) ? new stdClass(): json_decode($json_custom_nombre);

    $txt_custom_nombre = property_exists($obj_custom_nombre,"txt_mes") ? strtoupper($obj_custom_nombre->txt_mes) : "";

    if(empty($txt_custom_nombre) &&
        (   property_exists($obj_custom_nombre,"fecha_ini") && !empty($obj_custom_nombre->fecha_ini) ||
            property_exists($obj_custom_nombre,"fecha_fin") && !empty($obj_custom_nombre->fecha_fin)))
    {
        if(property_exists($obj_custom_nombre,"fecha_ini"))
            $txt_custom_nombre .= "DEL " . strtoupper(get_date_spanish(strtotime($obj_custom_nombre->fecha_ini), false, 'small_date'));

        if(property_exists($obj_custom_nombre,"fecha_fin"))
            $txt_custom_nombre .= (!empty($txt_custom_nombre) ? "<br />" : "") . " AL " . strtoupper(get_date_spanish(strtotime($obj_custom_nombre->fecha_fin), false, 'small_date'));

    }


    $txt_custom = "$txt_custom_nombre<div id='deposit_custom_dates'></div>";

    $html .= "<div id='div_$table_id' align='center' style='width:95%;margin-left:auto;margin-right:auto;margin-top:32px;'>$copy
            <table id='$table_id' class='tabla tablausd tablesorter' align='center' >" .
        "<caption>$caption</caption><thead>" .
        "<tr class='tablesorter-headerRow'>" .

        "<th class='cen lbl $usdClass' $headerStyle450>EMPRESA</th>" .

        "<th class='cen lbl $usdClass' $headerStyle250>CUENTA</th>" .

        "<th class='cen lbl $usdClass' $headerStyle150>$txt_today</th>" .
        "<th class='cen lbl $usdClass' $headerStyle150>$txt_this_month</th>" .
        "<th class='cen $usdClass' $headerBlack150>$txt_this_year</th>" .
        "<th class='group-false cen rojo' style='width:150px; font-weight:bold;font-size:17px;color:red !important'>$txt_last_year</th>" .
        "<th class='cen $usdClass' $headerBlack150>$txt_custom</th>" .

        "</tr></thead><tbody>";

    return $html;
}

function fid_showCuenta($banco_cuenta_id, $t, $sbc)
{
    global $configReporte;
    $sbcActual = array_key_exists($banco_cuenta_id, $sbc) ? $sbc[$banco_cuenta_id]['fiduciario_this_month'] : 0.00;
    if ($configReporte['HideActiveSinMovimiento'] && (
        (empty($sbcActual) && empty($t['Ultimo_Movimiento']) && empty($t['fiduciario_this_month']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['fiduciario_this_month']))
        )) {
        return false;
    }
    if ($configReporte['HideSaldoCero'] && (empty($t['fiduciario_this_month']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['fiduciario_this_month']))) {
        return false;
    }

    return true;
}

function fid_table_row($banco_cuenta_id, $t, $sbc, $monedaClass, $cuentaBancaria, $nowTime, $sumGroup = [])
{
    global $configReporte;
    $html = "";
    static $prevGroupedBy = "\t";

    if (!fid_showCuenta($banco_cuenta_id, $t, $sbc)) {
        return array(0, 0);
    }
    $sbcActual = array_key_exists($banco_cuenta_id, $sbc) ? $sbc[$banco_cuenta_id]['fiduciario_this_month'] : 0.00;
    $txtsbcActual = $sbcActual > 0 ? echonf($sbcActual, true) : '';
    /*
            if($configReporte['HideActiveSinMovimiento'] && (
                (empty($sbcActual) && empty($t['Ultimo_Movimiento']) && empty($t['saldo_actual']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['saldo_actual'])  )
            )) {
                return array(0, 0);
            }
            if($configReporte['HideSaldoCero'] && (empty($t['saldo_actual']) && empty($sbc[$banco_cuenta_id]) && empty($sbc[$banco_cuenta_id]['saldo_actual'])  ) ) {
                return array(0, 0);
            }
    */

    $font = " tableSorterCo";

    if ($prevGroupedBy != $cuentaBancaria['empresa']) {
        $prevGroupedBy = $cuentaBancaria['empresa'];
        $grp = $sumGroup[$prevGroupedBy];

        if (empty($grp['ultima_conciliacion'])) {
            $fuchG = $ultima_concG = $txt_difHorasG = '';
        } else {
            $fuchG = strtotime($grp['ultima_conciliacion']);
            $txt_difHorasG = txtHaceCuantoTiempo($fuchG, $nowTime, $monedaClass);
            $ultima_concG = get_date_spanish($fuchG, false, 'small_date', 'month_mini') . " - " . date('H:i:s', $fuchG);
        }

        $html .= "\r\n\r\n\r\n<tr class='tablesorter-hasChildRow Group1'><td colspan=2>
                <a href='#' class='toggle asin txt_color_PESOS'>&#x25b6; " . $cuentaBancaria['empresa'] . "</a></td>";
        $html .= "<td class='der groupTotal txt_color_PESOS bold saldo_actual nwp'>" . echonf($grp['fiduciario_all'], true) . "</td>";
        $html .= "<td class='der groupTotal txt_color_PESOS bold saldo_actual nwp'>" . echonf($grp['Total'], true) . "</td>";
        $html .= "<td class='der groupTotal bold nwp'>" . echonf($grp['Disponible'], true) . "</td>";
        $html .= "<td class='der bold rojo groupTotal'>" . ($grp['SBC'] == 0 ? '' : echonf($grp['SBC'], true)) . "</td>";
        $html .= "<td class='der groupTotal bold nwp'>" . echonf($grp['fiduciario_custom'], true) . "</td>";

        $html .= "</tr>\r\n\r\n";

    }

    if (empty($cuentaBancaria['ultima_conciliacion'])) {
        $fuch = $ultima_conc = $txt_difHoras = '';
    } else {
        $fuch = $cuentaBancaria['ultima_conciliacion'];
        $fuch = strtotime($fuch);
        $txt_difHoras = txtHaceCuantoTiempo($fuch, $nowTime, $monedaClass);
        $ultima_conc = get_date_spanish($fuch, false, 'small_date', 'month_mini') . " - " . date('H:i:s', $fuch);
    }
    $collapsed = 'display:none;';
    $atitle = "title='" . htmlentities($cuentaBancaria['banco'] . ' #cta: ' . $cuentaBancaria['numero'], ENT_QUOTES) . "'";
    $html .= "\r\n<tr class='tablesorter-childRow $cuentaBancaria[vale]' >" .

        "<td style='$collapsed ' class='$monedaClass $font nwp'>&nbsp;" .
        "<td style='$collapsed ' class='$font nwp'>" .
        "<a  class='asin $monedaClass'  $atitle href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$t[banco_cuenta_id]' target='_blank'><strong>" .
        ia_htmlentities($cuentaBancaria['nombre']) . "</strong>" .
        "</a>" .
        "<td style='$collapsed' class='der $monedaClass bold saldo_actual $font nwp'>" . echonf($t['fiduciario_all'], true) .
        "<td style='$collapsed' class='der $monedaClass bold saldo_actual $font nwp'>" . echonf($t['fiduciario_this_month'], true) .
        "<td style='$collapsed' class='der bold $font'>" . echonf($t['fiduciario_this_year'], true) .
        "<td style='$collapsed' class='der bold rojo $font $font'>" . echonf($t['fiduciario_last_year'], true) .
        "<td style='$collapsed' class='der bold $font'>" . echonf($t['fiduciario_custom'], true) .


        "</tr>";

    return array($t['fiduciario_this_month'], $t['fiduciario_this_year'], $t['fiduciario_last_year'], $t['fiduciario_all'], $html, $t['fiduciario_custom']);
}

function fid_table_footer($class1, $class2, $sumaCuentas, $sumaDisp, $sumaSBC, $sumaToday, $sumaCustom)
{
    $html = "";
    $html .= "</tbody><tfoot><tr>" .
        "<td colspan=2 class='der bold $class2' style='font-size:17px;font-weight:700'>SUMAS:" .
        "<td class='der bold $class1' style='font-size:17px;font-weight:700'>" . echonf($sumaToday, true) .
        "<td class='der bold $class1' style='font-size:17px;font-weight:700'>" . echonf($sumaCuentas, true) .
        "<td class='der bold' style='font-size:17px;font-weight:700'>" . echonf($sumaDisp, true) .
        "<td class='der rojo bold' style='font-size:17px;font-weight:700'>" . echonf($sumaSBC, true) .
        "<td class='der bold' style='font-size:17px;font-weight:700'>" . echonf($sumaCustom, true) .

        "</tr>" .
        "</tfoot></table></div>";

    return $html;
}

//Funciones de José
function buscaEnTablaSobreCampoElValor($in_table, $on_field, $this_value, $is_pk = false)
{
    $sql = "SELECT * FROM $in_table WHERE $on_field = '$this_value'";

    if ($is_pk) {
        $result = ia_singleton($sql);
    } else {
        $result = ia_sqlArray($sql, $on_field);
    }
    return $result;
}

function quitaIndiceRepetidoDeRepetidos ($bcmenDB, $bcm_id, &$sqlSet)
{
    // Se obtienen los repetidos actuales (antes de realizar cualquier otra acción)
    $repetidos_string = trim($bcmenDB['mov_repetido_id']);
    if ($repetidos_string !== ""){
        $current_duplicates = explode(",", $repetidos_string);
        if (count($current_duplicates) > 0) {
            foreach ($current_duplicates as $bcmid_repetido){
                if ($bcm_id !== $bcmid_repetido){
                    // Se busca el BCM con el que esta repetido
                    $bcmRepedido = buscaEnTablaSobreCampoElValor('banco_cuenta_mov', 'banco_cuenta_mov_id', $bcmid_repetido, true);
                    if (!isset($bcmRepedido['mov_repetido_id'])) {
                        return;
                    }
                    // Se obtienen los repetidos del BCM repetido
                    $repetidos = explode(",", trim($bcmRepedido['mov_repetido_id']));
                    // Comprueba que el BCM se encuentre en los repetidos del repetido
                    if (in_array($bcm_id, $repetidos)){
                        // Se obtiene la posicion para eliminarlo de repetidos del repetido
                        $position = array_search($bcm_id, $repetidos);
                        unset($repetidos[$position]);
                        // Se crean nuevos repetidos del repetido
                        $nuevos_repetidos = implode(",", $repetidos);
                        // Se valida que repetidos sea mayor a 1 para que pueda ser repetido y no se repita con el mismo
                        if (count($repetidos) < 2) {
                            if ($nuevos_repetidos == $bcmid_repetido){
                                $remarks = str_replace("txt_bold_red txt_underline", "", $bcmRepedido['remarks']);
                                $sqlSet[] = "UPDATE banco_cuenta_mov SET repetido = 'No', mov_repetido_id = '', remarks = ". strit(ltrim(trim($remarks))) ." WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
                            }
                        } else {
                            $sqlSet[] = "UPDATE banco_cuenta_mov SET mov_repetido_id = '$nuevos_repetidos' WHERE banco_cuenta_mov_id = '$bcmid_repetido'";
                        }
                    }
                }
            }
        }
        // Se quita el subrayado de remarks
        $bcmenDB['remarks'] = str_replace("txt_bold_red txt_underline", "", $bcmenDB['remarks']);
        $new_remarks = $bcmenDB['remarks'];
        $sqlSet[] = "UPDATE banco_cuenta_mov SET repetido = 'No', mov_repetido_id = '', remarks = ". strit(ltrim(trim($new_remarks))) ." WHERE banco_cuenta_mov_id = '$bcm_id'";
    }
}

/** Busca los BCM repetidos de la misma empresa el mismo mes
 * @param $bcm_id string El banco_cuenta_mov_id del que se desea saber si hay repetidos
 * @param $remarks array El array donde se retornaran los query´s de los repetidos
 * @return void
 */
function buscaRepetidoSAT($bcm_id, &$remarks)
{
    $sql = "SELECT
                    bcm.banco_cuenta_mov_id,
                    bcm.banco_cuenta_id,
                    DATE(bcm.fecha) fecha,
                    bc.empresa_id
                FROM banco_cuenta_mov bcm
                JOIN banco_cuenta bc ON bc.banco_cuenta_id = bcm.banco_cuenta_id
                WHERE banco_cuenta_mov_id = '$bcm_id'";
    $bcm_current = ia_singleton($sql);

    $date = $bcm_current['fecha'];
    $empresa_id = $bcm_current['empresa_id'];

    $sqlSearchDuplicates = "SELECT
                                    bcm.banco_cuenta_mov_id,
                                    bcm.banco_cuenta_id,
                                    DATE(bcm.fecha) fecha,
                                    bc.empresa_id
                                FROM banco_cuenta_mov bcm
                                JOIN banco_cuenta bc ON bc.banco_cuenta_id = bcm.banco_cuenta_id
                                WHERE bcm.banco_cuenta_mov_id <> '$bcm_id'
                                  AND bcm.remarks LIKE '%TRIBUTARIA%'
                                  AND es = 'Retiro'
                                  AND MONTH(DATE(bcm.fecha)) = MONTH('$date')
                                  AND YEAR(DATE(bcm.fecha)) = YEAR('$date')
                                  AND bc.empresa_id = $empresa_id";

    $duplicates = ia_sqlArray($sqlSearchDuplicates, 'banco_cuenta_mov_id');
    if (count($duplicates) > 0) {
        $mov_repetido_id = "$bcm_id," . implode(",", array_keys($duplicates));
        foreach ($duplicates as $key => $duplicate) {
            $remarks['sql'][] = "UPDATE banco_cuenta_mov SET repetido = 'Si', mov_repetido_id = '$mov_repetido_id' WHERE banco_cuenta_mov_id = '$key'";
        }
        $remarks['sql'][] = "UPDATE banco_cuenta_mov SET repetido = 'Si', mov_repetido_id = '$mov_repetido_id', remarks = ". strit(ltrim(trim($remarks['benefic']))) ." WHERE banco_cuenta_mov_id = '$bcm_id'";
    }
}

/** Determina si el BCM es de tipo SAT
 * @param string $ori_benefic el String donde buscar conincidencia
 * @return bool is SAT
 */
function isSAT($ori_benefic)
{
    $re = '/^\s*(SERVICIO DE ADMINISTRACIÓN TRIBUTARIA|SERVICIO DE ADMINISTRACIÓN).*?\s(.*?(\s))/';

    preg_match_all($re, $ori_benefic, $matches, PREG_SET_ORDER, 0);

    if (count($matches) == 0) return false;

    return true;
}

function updateBalanceonBankAccount($banco_cuenta_mov_reference = [], bool $debug = false):array|bool
{

    $fecha = $banco_cuenta_mov_reference['fecha'];
    $banco_cuenta_id = $banco_cuenta_mov_reference['banco_cuenta_id'];

    if(empty($banco_cuenta_id) || empty($fecha)){
        return false;
    }

    $banco_cuenta_mov_sql = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov WHERE fecha <= '$fecha' AND banco_cuenta_id = '$banco_cuenta_id' ORDER BY fecha DESC LIMIT 30";

    $banco_cuenta_mov_arr = ia_sqlArrayIndx($banco_cuenta_mov_sql);

    $banco_cuenta_mov_bingo = end($banco_cuenta_mov_arr);

    $saldo_inicial = [
        'saldo_inicial' => $banco_cuenta_mov_bingo['balance_prev'],
        'fecha_inicio' => $banco_cuenta_mov_bingo['fecha']
    ];

    if($debug)
        echo "<pre>saldo_inicial: ".print_r($saldo_inicial,true)."</pre>";

    $movs_sql = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov  WHERE banco_cuenta_id = '$banco_cuenta_id' AND fecha >= '$saldo_inicial[fecha_inicio]' ORDER BY fecha ASC";
    $movs_arr = ia_sqlArrayIndx($movs_sql);

    $movs_con_saldo_arr = CalculaBancoCuentaSaldodeunArraydeMovimientos_(arrMovs: $movs_arr, bcid: $banco_cuenta_id, saldo_inicial: $saldo_inicial['saldo_inicial'], debug: $debug);

    updateBalanceArray(movs_con_saldo_arr: $movs_con_saldo_arr, debug: $debug);
    return true;
}

/**
 * @param array $movs_con_saldo_arr
 * @param bool $debug
 * @return void
 */
function updateBalanceArray(array $movs_con_saldo_arr, bool $debug = false): void
{
    $update_sql = [];
    $indexBalance = "balance";
    $indexBalancePrev = "balance_prev";
    $indexBalanceOpDesc = "balance_op_desc";
    $bcmid = 'banco_cuenta_mov_id';
    foreach ($movs_con_saldo_arr as $key => $banco_cuenta_mov_con_saldo) {
        $update_sql_ = "UPDATE banco_cuenta_mov SET balance = '$banco_cuenta_mov_con_saldo[$indexBalance]', balance_prev = '$banco_cuenta_mov_con_saldo[$indexBalancePrev]', balance_op_desc = '$banco_cuenta_mov_con_saldo[$indexBalanceOpDesc]' WHERE banco_cuenta_mov_id = '$banco_cuenta_mov_con_saldo[$bcmid]'";

        if($debug)
            echo "<pre>$banco_cuenta_mov_con_saldo[banco_cuenta_id], $banco_cuenta_mov_con_saldo[fecha], $banco_cuenta_mov_con_saldo[banco_cuenta_mov_id]: " . print_r($update_sql_, true) . "</pre>";

        $update_sql[] = $update_sql_;
    }

    ia_transaction($update_sql);
    if($debug) {
        $blanks = str_pad('', 4080, '&nbsp;');
        echo $blanks;
        echo "<hr/>";
        ob_flush();
        flush();
    }
}

function findReliableBankTransanctionforBalance($banco_cuenta_id=0, $fecha_referencia = ''):array|bool
{
    if(empty($banco_cuenta_id)){
        return false;
    }

    $t=date('d-m-Y');
    $dayNum = strtolower(date("d",strtotime($t)));

    $fecha = strtolower(date("Y-m-$dayNum"));

    if($dayNum < 10){
        $fecha = strtolower(date("Y-m-01", strtotime("-1 month")));
    }

    if(!empty($fecha_referencia) && validateDate($fecha_referencia)){

        $fecha = strtolower(date("Y-m-d", strtotime("-1 month", strtotime($fecha_referencia))));
    }

    $banco_cuenta_mov_bingo = [];
    $banco_cuenta_mov_sql = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov  WHERE balance > 0 AND balance_prev > 0 AND balance_op_desc <> '' AND fecha > '$fecha' AND banco_cuenta_id = '$banco_cuenta_id' ORDER BY fecha ASC LIMIT 5";

    $banco_cuenta_mov_arr = ia_sqlArrayIndx($banco_cuenta_mov_sql);

    if(empty($banco_cuenta_mov_arr)){
        $banco_cuenta_mov_sql = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov  WHERE balance > 0 AND balance_prev > 0 AND balance_op_desc <> '' AND banco_cuenta_id = '$banco_cuenta_id' ORDER BY fecha DESC LIMIT 30";

        $banco_cuenta_mov_arr = ia_sqlArrayIndx($banco_cuenta_mov_sql);

        if(empty($banco_cuenta_mov_arr)){
            return false;
        }

        $banco_cuenta_mov_bingo = end($banco_cuenta_mov_arr);
    }
    else {
        reset($banco_cuenta_mov_arr);
        $banco_cuenta_mov_bingo = current($banco_cuenta_mov_arr);
    }

    $banco_cuenta_mov_arr_ = [];
    $banco_cuenta_mov_sql_ = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov WHERE balance > 0 AND balance_prev > 0 AND balance_op_desc <> '' AND fecha <= '$banco_cuenta_mov_bingo[fecha]' AND banco_cuenta_id = '$banco_cuenta_id' ORDER BY fecha DESC LIMIT 30";

    $banco_cuenta_mov_bingo_ = [];
    $banco_cuenta_mov_arr_ = ia_sqlArrayIndx($banco_cuenta_mov_sql_);
    $banco_cuenta_mov_bingo_ = end($banco_cuenta_mov_arr_);

    return empty($banco_cuenta_mov_bingo_) ? $banco_cuenta_mov_bingo : $banco_cuenta_mov_bingo_;
}


function updateBalanceonAllAccounts(bool $debug = false): void
{

    $saldos_iniciales_arr = [
        '2' => ['saldo_inicial' => '2277038.37', 'fecha_inicio' => '2020-01-01'],
        '5' => ['saldo_inicial' => '5258097.86', 'fecha_inicio' => '2020-01-01'],
        '8' => ['saldo_inicial' => '38722.07', 'fecha_inicio' => '2020-01-01'],
        '19' => ['saldo_inicial' => '4127237.24', 'fecha_inicio' => '2020-01-01'],
        '20' => ['saldo_inicial' => '282193.38', 'fecha_inicio' => '2020-01-01'],
        '21' => ['saldo_inicial' => '3411528.58', 'fecha_inicio' => '2020-01-01'],
        '34' => ['saldo_inicial' => '40161.20', 'fecha_inicio' => '2020-01-01'],
        '35' => ['saldo_inicial' => '54605.08', 'fecha_inicio' => '2020-01-01'],
        '36' => ['saldo_inicial' => '48652.01', 'fecha_inicio' => '2020-01-01'],
        '37' => ['saldo_inicial' => '789025.05', 'fecha_inicio' => '2020-01-01'],
        '38' => ['saldo_inicial' => '58600.16', 'fecha_inicio' => '2020-01-01'],
        '42' => ['saldo_inicial' => '198104.34', 'fecha_inicio' => '2020-01-01'],
        '43' => ['saldo_inicial' => '150323.32', 'fecha_inicio' => '2020-01-01'],
        '39' => ['saldo_inicial' => '2141721.55', 'fecha_inicio' => '2020-01-01']
    ];

    $banco_cuentas_sql = "SELECT * from banco_cuenta WHERE vale='Active' ORDER BY banco_cuenta_id";
    $banco_cuentas_arr = ia_sqlArrayIndx($banco_cuentas_sql);

    foreach ($banco_cuentas_arr as $k => $v) {
        if (array_key_exists($v['banco_cuenta_id'], $saldos_iniciales_arr)) {
            continue;
        }
        $saldos_iniciales_arr[$v['banco_cuenta_id']] = ['saldo_inicial' => '0.0', 'fecha_inicio' => '2020-01-01'];
    }


    foreach ($saldos_iniciales_arr as $banco_cuenta_id => $cuenta) {

        if($debug)
            echo "<pre>$banco_cuenta_id: " . print_r($cuenta /*$el_array de lo que sea*/, true) . "</pre>";

        $movs_sql = "SELECT banco_cuenta_mov_id,fecha, balance_prev, es, withdrawal, deposit, cash, balance_op_desc, balance, banco_id, banco_cuenta_id, numero FROM banco_cuenta_mov  WHERE banco_cuenta_id = '$banco_cuenta_id' AND fecha > '$cuenta[fecha_inicio]' ORDER BY fecha ASC";

        $movs_arr = ia_sqlArrayIndx($movs_sql);
//foreach ($movs_arr as $key => $banco_cuenta_mov) {
//        echo "<pre>$banco_cuenta_mov[banco_cuenta_mov_id]: ".print_r($banco_cuenta_mov /*$el_array de lo que sea*/,true)."</pre>";
//    }

        if($debug)
            echo "<li> =================================================================<br>Con saldo:";

        $movs_con_saldo_arr = CalculaBancoCuentaSaldodeunArraydeMovimientos_(arrMovs: $movs_arr, bcid: $banco_cuenta_id, saldo_inicial: $cuenta['saldo_inicial'], debug: $debug);

        updateBalanceArray(movs_con_saldo_arr: $movs_con_saldo_arr, debug: $debug);
    }
}
function CalculaBancoCuentaSaldodeunArraydeMovimientos_(array &$arrMovs = [], int|string $bcid = "", $saldo_inicial = null, bool $debug = false): array
{
    $indexBalance="balance";
    $indexBalancePrev="balance_prev";
    $indexBalanceOpDesc="balance_op_desc";
    $bcmid='banco_cuenta_mov_id';
    $deposit='deposit';
    $cash='cash';
    $withdrawal='withdrawal';

    if(empty($arrMovs))
        return $arrMovs;

    $arrLength = sizeof($arrMovs);
    $arrLength--;
    $arrLength_ = $arrLength;



    $arrLength = 0;
    $arrMovs[$arrLength][$indexBalancePrev] = ($saldo_inicial != null) ? $saldo_inicial : 0.00;


    do{
        $arrMovs[$arrLength][$indexBalance] = number_format( $arrMovs[$arrLength][$indexBalancePrev] + ($arrMovs[$arrLength][$cash] + $arrMovs[$arrLength][$deposit] - $arrMovs[$arrLength][$withdrawal]), 2, ".", "");

        $current_op = ($arrMovs[$arrLength][$cash] + $arrMovs[$arrLength][$deposit] - $arrMovs[$arrLength][$withdrawal]);
        $current_op_sign_class = $current_op >= 0 ? "balance_op_dep_sign" : "balance_op_with_sign";
        $current_op_class = $current_op >= 0 ? "balance_op_dep_text" : "balance_op_with_text";
        $current_op_sign_text = " <span class='$current_op_sign_class'>" . ( $current_op >= 0 ? "+" : "-") . "</span> ";

        $arrMovs[$arrLength][$indexBalanceOpDesc] = "<span class='balance_op_prev_text'>" . number_format($arrMovs[$arrLength][$indexBalancePrev], 2) . "</span>" . $current_op_sign_text . "<span class='$current_op_class'>" . number_format(abs($current_op), 2) . "</span><span class='bold'> = </span><span class='balance_op_text'>" . number_format($arrMovs[$arrLength][$indexBalance], 2) . "</span>";

        $arrMovs[$arrLength][$indexBalanceOpDesc] = addslashes($arrMovs[$arrLength][$indexBalanceOpDesc]);

        if(array_key_exists($arrLength + 1, $arrMovs)){
            $arrMovs[$arrLength + 1][$indexBalancePrev] = $arrMovs[$arrLength][$indexBalance];
        }
    }while (++$arrLength <= $arrLength_);

    return $arrMovs;
}