<?php

/** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection SqlResolve */
/** @noinspection SqlSignature */

function obtenCatalogo($nombreCatalogo ='', $genera=false, $extraId='', $printFiles = false, $categoria_id = -1, $debug = false)
{
    global $gIAsql;
    global $gDebugging;
    $gIAsql['trace']=true;

    if(empty($nombreCatalogo))
        return false;
    $nombre = $nombreCatalogo;
    $method = __METHOD__;
    $jsonData='';
    global $gWebDir;
    //$path = "C:\\wamp\\www\\$gWebDir\\backoffice\\json\\";
    $path = '/lamp/www/' . $gWebDir . '/backoffice/json/';
    $ext = "html";
    $fileName = $path.$nombreCatalogo.$extraId.".".$ext;
    //$fieldName = ''; $fieldDesc = '';
    //$vsTable = ''; $vsFieldID = '';
    if($debug){
        echo "<pre>" . print_r($fileName = $path.$nombreCatalogo.$extraId.".".$ext, true) . "</pre>";
    }
    $sqlComment = __METHOD__ . ' ' . $nombreCatalogo;
    switch($nombreCatalogo)
    {

        //Generales compartidos
        case 'propietario':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $tabla = 'propietario'; $fieldName = 'propietario_id'; $fieldDesc = 'propietario';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $tabla WHERE 1 ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'links_tipo_factura':
            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $array = arrayTipoFactura(true);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;
//Generales compartidos
        case 'banco_cuenta':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'banco_cuenta'; $fieldName = 'banco_cuenta_id'; $fieldDesc = 'nombre';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre WHERE $nombre.vale='Active' ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'banco':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'banco'; $fieldName = 'banco_id'; $fieldDesc = 'banco';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'banco_con_cuenta':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'banco'; $fieldName = 'banco_id'; $fieldDesc = 'banco';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre WHERE banco_id IN (SELECT banco_id FROM banco_cuenta WHERE vale = 'Active') ORDER BY 2";


                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;
        
        case 'banco_mov_tipo':case 'banco_mov_tipo_id':

        if(!$genera && file_exists($fileName))
            $jsonData = getSafeDataFromFile($fileName);
        if(strlen($jsonData) === 0)
        {
            $nombre = 'banco_mov_tipo'; $fieldName = 'banco_mov_tipo_id'; $fieldDesc = 'tipo';
            $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre WHERE vale='Active' ORDER BY 2";

            
            $array = ia_sqlArrayIndx($sql);
            jsonFile($fileName, $array);
            $jsonData = json_encode($array);
        }
        break;

        
        case 'empresa':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'empresa'; $fieldName = 'empresa_id'; $fieldDesc = 'empresa';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre WHERE vale='Active' ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'es_withdrawal_deposit':
            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $array = array(
                    array('label'=>'Withdrawal', 'value'=> 'Retiro', 'real_data'=> 'Retiro'),
                    array('label'=>'Deposit', 'value'=> 'Deposito', 'real_data'=> 'Deposito'),
                    array('label'=>'Deposit MST', 'value'=> 'Deposito', 'real_data'=> 'Deposito'),
                    array('label'=>'Deposit FACTURA', 'value'=> 'Deposito', 'real_data'=> 'Deposito')
                );
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'moneda':case 'moneda_id':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'moneda'; $fieldName = 'moneda_id'; $fieldDesc = 'moneda';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;

        case 'reporte_grid':
            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                //$nombre = 'reportes_grid';
                $sql = "SELECT /*$sqlComment*/  reporte_grid_id, nombre, descripcion, usuario, origen, '1' as permiso FROM reportes_grid WHERE 1 ORDER BY alta_db DESC";
                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;
        case 'tienda':

            if(!$genera && file_exists($fileName))
                $jsonData = getSafeDataFromFile($fileName);
            if(strlen($jsonData) === 0)
            {
                $nombre = 'tienda'; $fieldName = 'tienda_id'; $fieldDesc = 'clave';
                $sql = "SELECT /*$sqlComment*/  $fieldName, $fieldDesc, $fieldName as real_data, $fieldDesc as label, $fieldName as value FROM $nombre WHERE $nombre.vale='Active' ORDER BY 2";

                
                $array = ia_sqlArrayIndx($sql);
                jsonFile($fileName, $array);
                $jsonData = json_encode($array);
            }
            break;
    }
    return $jsonData;
}

function catalogosUnique() {
    $catalotos = catalogosDefault();
    $unicos = array_keys($catalotos);
    foreach($catalotos as $c)
        if(is_array($c))
            $unicos = array_merge($unicos, $c);
    return array_unique($unicos);
}

function catalogosDefault()
{
    return array(

        'propietario'=> array('propietario'),
        'tienda'=> array('tienda'),
        'empresa'=> array('empresa','banco_cuenta'),
        'moneda'=> array('moneda','moneda_id'),
        'banco'=> array('banco'),
        'banco_mov_tipo'=> array('banco_mov_tipo'),
        'banco_a_banco' => array('banco_a_banco_alta_por','banco_a_banco_bid_origen','banco_a_banco_bid_destino'),
        'banco_cuenta'=> array('banco_cuenta','banco_con_cuenta'),
        'es_withdrawal_deposit' => array('es_withdrawal_deposit'),
        'links'=> array('links_tipo_factura'),
        'reporte_grid'=> array('reporte_grid'),

    );
}

function generaCatalogos($nombre='QWERTY', $debug = false)
{
    global $arr_catalogos;
    global $gWebDir;

//    echo "<pre>".print_r($nombre,true)."</pre>";

    $pathCat = '/lamp/www/' . $gWebDir . '/backoffice/json/';
    if($debug)
        echo "<li>".$pathCat;

    valida_carpetas($pathCat, $gWebDir);

    $nombre = is_string($nombre) ? [$nombre] : $nombre;

    if(empty($nombre) || $nombre=='QWERTY' || (is_array($nombre) && in_array('QWERTY', $nombre))
    )
        $nombre = $arr_catalogos;
    if($debug)
        echo "<pre>".print_r($nombre,true)."</pre>";

    if(!is_array($nombre))
        $nombre = array($nombre=>$arr_catalogos[$nombre]);
    else if($nombre != $arr_catalogos)
    {
        $tmp=array();
        foreach($nombre as $v)
            $tmp[$v] = $arr_catalogos[$v];
        $nombre=$tmp;
    }
    $done=[];
    if(is_array($nombre) && !empty($nombre))
        foreach($nombre as $v)
            if(is_array($v) && !empty($v))
                foreach($v as $w)
                    if( !array_key_exists($w, $done)) {
                        $done[$w] = true;
                        obtenCatalogo($w, true);
                    }
    global $gDebugging;
    if($gDebugging) {
        $guarde = array_keys($done);
        asort($guarde);
        //ia_errores_a_dime("catalogos guardados: " . implode(", ", $guarde));
    }
}

function obtenCatalogos(array $catalogos = [])
{
    $ret = [];
    foreach ($catalogos as $catalogo) {
        if(!array_key_exists($catalogo, $ret))
            $ret[$catalogo] = obtenCatalogo($catalogo, true);
    }
    return $ret;
}