<?php
use Iac\inc\sql\IacSqlBuilder;
function clientes_saldos_grid($andWhere='',$orderby='',&$sumasGridServer=array())
{
    //$arr=array();
    global $vx_debug;
    global $gIAParametros;

    $orderbysplit = explode("/**#LIMIT#**/", $orderby);
    $limit = $limitsql = array_key_exists(1, $orderbysplit) ? $orderbysplit[1] : '';

    if(strlen($limit))
    {
        $limit = vx_trim(str_replace("LIMIT","",$limit));
        $limitsplit = explode(",",$limit);
    }

    /*if($sumasGridServer['iaGridInicial'] == 'NO')
    {
        $orderby = $orderbysplit[0];
    }*/

    if(!empty($andWhere))
    {
        if(strpos($andWhere, " AND (") === 0)
            $andWhere = substr($andWhere,5);

        $andWhere = str_replace("clientes_saldos_cat.",'',$andWhere);

        /** Aqui reemplazo los campos ambiguos **/
        $cyTN_arr = camposyTablasNormalizadas('clientes_saldos');
        $patterns = array_keys($cyTN_arr[0]['clientes_saldos']);
        $replacements = array_values($cyTN_arr[0]['clientes_saldos']);

        foreach($patterns as $k=>$v)
            $patterns[$k] = "/\\b$v\\b/";

        $andWhere = preg_replace($patterns,$replacements,$andWhere);
        //$orderby = preg_replace($patterns,$replacements,$orderby);

        /** ** ** **/
        //$andWhere = " $andWhere AND ";


        //ia_query("INSERT INTO dime (script,dime) VALUES ('sql',".strit($tmp."-".$andWhere).")");
    }

    //VCA 01-03-2021 Leemos el tipo de cambio y lo actualizamos en clientes_saldos_cat. Los campos de saldo se calculan automáticamente.
    $tc = obten_tc_live();
    $tc_usado = $tc->tc;
    ia_query("UPDATE cliente SET tipo_cambio='$tc_usado'");


    $sql = "SELECT cliente_id, nombre,
         tienda_id,
        SUM(saldo_cheques_pesos) AS saldo_cheques_pesos, 
        SUM(saldo_pagares_usd) AS saldo_pagares_usd, 
        SUM(saldo_vales_pesos) AS saldo_vales_pesos, 
        SUM(saldo_vales_usd) AS saldo_vales_usd, 
        MAX(ultima_compra) AS ultima_compra, 
        MAX(ultimo_pago) AS ultimo_pago, 
        SUM(saldo_cheques_usd) AS saldo_cheques_usd, 
        SUM(saldo_pagares_pesos) AS saldo_pagares_pesos, 
        SUM(cuantos_cheques) AS cuantos_cheques, 
        SUM(cuantos_pagares) AS cuantos_pagares, 
        SUM(cuantos_vales) AS cuantos_vales,
        MIN(cheque_mas_antiguo) AS cheque_mas_antiguo, 
        MIN(pagare_mas_antiguo) AS pagare_mas_antiguo, 
        MIN(vale_mas_antiguo) AS vale_mas_antiguo,
       	'$tc_usado' as tipo_cambio,
        SUM(saldo_compras_pesos) AS saldo_compras_pesos, 
        SUM(saldo_compras_usd) AS saldo_compras_usd,
        SUM(cuantos_compras) AS cuantos_compras,
        MIN(compra_mas_antigua) AS compra_mas_antigua
       /** ##get_select()## **/  
        FROM clientes_saldos_cat ";

    $andWhere = empty($andWhere) ? "" : " WHERE " . $andWhere;
    $andWhere.= " GROUP BY cliente_id ";

    $fin_arr=ia_sqlArrayIndx($sql.$andWhere.$orderby);


    // Para el cache //
    $sql1 = array();
//    ia_query("CREATE TABLE IF NOT EXISTS clientes_saldos_live LIKE clientes_saldos_cat");
//    ia_query("TRUNCATE TABLE clientes_saldos_live");
    $sql1[] = "CREATE TABLE IF NOT EXISTS clientes_saldos_live LIKE clientes_saldos_cat";
    $sql1[] = "TRUNCATE TABLE clientes_saldos_live";
    // ia_query("ALTER TABLE cuentat_mov_live ENGINE = MEMORY");
    //ia_query("ALTER TABLE cuentat_mov_tmp DROP INDEX consul_movs");
    foreach($fin_arr as $k => $cm)
    {
        $sql1[] = ia_insert("clientes_saldos_live", $cm, [],'', true);
        //$sql1[$k+1] = str_replace("clientes_saldos_cat", "clientes_saldos_live", $sql1[$k+1]);
    }
    //ia_query("ALTER TABLE cuentat_mov_tmp ADD INDEX consul_movs (banco_cuenta_mov_link_id, fecha, alta_db, contra_mov_id, app_origen, cuentaT_id, tienda_id) USING BTREE;");

    ia_transaction($sql1);


    if(strlen($limit)) {

        $sumasGridServer['rows'] = $limitsplit[1];
        $sumasGridServer['total_records'] = sizeof($fin_arr);
        $fin_arr = array_splice($fin_arr, $limitsplit[0], $limitsplit[1]);
    }
    else{
        $sumasGridServer['rows'] = $limit;
        $sumasGridServer['total_records'] = sizeof($fin_arr);
    }

    ia_query("INSERT INTO clientes_saldos_live(cliente_id, saldo_cliente_usd, saldo_cliente, saldo_cliente_moneda_id_calc)
SELECT cliente_id, SUM(saldo_cliente_usd) AS saldo_cliente_usd, SUM(saldo_cliente) AS saldo_cliente, MAX(saldo_cliente_moneda_id_calc) AS saldo_cliente_moneda_id_calc FROM (SELECT cliente_id, SUM((`saldo_cheques_pesos` / $tc_usado) + `saldo_cheques_usd` + (`saldo_pagares_pesos` / $tc_usado) + `saldo_pagares_usd` - (`saldo_vales_pesos` / $tc_usado) - `saldo_vales_usd`) AS saldo_cliente_usd, 
       if((SUM(`saldo_cheques_pesos`) > 0 OR  SUM(`saldo_pagares_pesos`) > 0 OR SUM(`saldo_vales_pesos`) > 0) AND (SUM(`saldo_cheques_usd`) > 0 OR SUM(`saldo_pagares_usd`) > 0 or SUM(`saldo_vales_usd`) > 0),SUM((`saldo_cheques_pesos` / $tc_usado) + `saldo_cheques_usd` + (`saldo_pagares_pesos` / $tc_usado) + `saldo_pagares_usd` - (`saldo_vales_pesos` / $tc_usado) - `saldo_vales_usd`),if(SUM(`saldo_cheques_pesos`) > 0 or SUM(`saldo_pagares_pesos`) > 0 or SUM(`saldo_vales_pesos`) > 0,SUM(COALESCE(`saldo_cheques_pesos`,0) + COALESCE(`saldo_pagares_pesos`,0) - COALESCE(`saldo_vales_pesos`,0)),SUM(COALESCE(`saldo_cheques_usd`,0) + COALESCE(`saldo_pagares_usd`,0) - COALESCE(`saldo_vales_usd`,0)))) AS saldo_cliente, if((SUM(`saldo_cheques_pesos`) > 0 or SUM(`saldo_pagares_pesos`) > 0 or SUM(`saldo_vales_pesos`) > 0 or SUM(`saldo_compras_pesos`) > 0) and (SUM(`saldo_cheques_usd`) > 0 or SUM(`saldo_pagares_usd`) > 0 or SUM(`saldo_vales_usd` > 0) or SUM(`saldo_compras_usd`) > 0),3,if(SUM(`saldo_cheques_pesos`) > 0 or SUM(`saldo_pagares_pesos`) > 0 or SUM(`saldo_vales_pesos`) > 0 or SUM(`saldo_compras_pesos`) > 0,1,2)) AS saldo_cliente_moneda_id_calc
FROM clientes_saldos_cat GROUP BY cliente_id) AS lol GROUP BY cliente_id
ON DUPLICATE KEY UPDATE saldo_cliente_usd = VALUES(saldo_cliente_usd), saldo_cliente = VALUES(saldo_cliente), saldo_cliente_moneda_id_calc = VALUES(saldo_cliente_moneda_id_calc);");
    //$sumasGridServer['iaarr_md5_solosumas'] = "cuentat_mov_tmp";

    if(true)
    {
        ia_errores_a_dime();

        //$time_elapsed_secs = microtime(true) - $start;
        //echo "time_elapsed_secs: $time_elapsed_secs";
        global $gWebDir;
        $myFile = "C:\\wamp\\www\\$gWebDir\\backoffice\\txt\\clientes_saldos_grid.txt";

        $fh = fopen($myFile, 'w') or die("can't open file");

        $bleh = "\r\n\r\nfin_arr: $sql $andWhere $orderby";

        fwrite($fh, $bleh);
        fclose($fh);
    }
    //ia_errores_a_dime();
    return $fin_arr;
}

/** VCA regenera el saldo de los clientes */
function actualiza_clientes_saldos($cliente_id = null, $fuerza = false, $debug = false): bool
{
    $method = "/** " . __FUNCTION__ . " **/";

    if(empty($cliente_id) && $fuerza)
        $sql_cliente_id = "SELECT $method cliente_id, nombre FROM cliente WHERE vale='Active' ORDER BY alta_db DESC";
    else
        $sql_cliente_id = "SELECT $method cliente_id, nombre FROM cliente WHERE vale='Active' AND cliente_id = ".strit($cliente_id);

    $arr_cliente_id = ia_sqlArray($sql_cliente_id, "cliente_id");
    $sql = ""; //array();

    if($debug)
        echo "<ol>" ;
    foreach ($arr_cliente_id as $k => $v) {
        if($debug) $start_time = microtime(true);
        calculaSaldoCliente($k, true, $debug);
        if($debug) {
            $end_time = microtime(true);
            $execution_time = $end_time - $start_time;
            echo "<li>$k _ $v[nombre]: " . $execution_time . " seconds ";
            $blanks = str_pad('', 4096, '&nbsp;');
            echo $blanks;
            ob_flush();
            flush();
        }
    }
    if($debug) echo "</ol>" ;

//    file_debug_reporte();
    return true;
}

function recalculaInconsistenciasEnNotas($cliente_id = '', $cliente_nombre = '', $tiendas = ''): void
{
    global $gDime;
    $method = __FUNCTION__;
    $sqlbuilder = new IacSqlBuilder();
    //VCA 01-08-2023 RONY pidió que al estar el cliente a mano y existir en la db no generara más inconsistencias.
    //Entonces intento arreglar las notas que tengan este nombre a mano y listo.

    $nombre = $cliente_nombre;

    $sql = "
            SELECT /*$method deduce nota_bodega_id a  recalcular */ nb.nota_bodega_id
            FROM nota_bodega nb
                     JOIN JSON_TABLE(cliente, '$[*]' COLUMNS (
                nombre VARCHAR(32) PATH '$.nombre',
                fue_error CHAR(2) PATH '$.fue_error')
                          ) clientes
            WHERE clientes.fue_error = 'No' AND clientes.nombre = " . strit($nombre) . "
              AND nb.tipo NOT IN ('Cancelacion', 'Borrado')
              AND nb.super_lock = 0 AND nb.traslado_match_lock = 0 AND nb.lock_por_tiempo = 0 AND nb.lock_por_nota_posterior_ajuste = 0
              AND nb.lock_por_tiempo_nota_ajuste = 0 AND nb.reset_lock = 0 AND nb.system_lock = 0";

    $notas_a_arreglar = ia_sqlVector($sql);

//        echo "<pre>sql" . print_r($sql, true) . "</pre>";
//        echo "<pre>notas_a_arreglar" . print_r($notas_a_arreglar, true) . "</pre>";

    $sql_update = [];
    foreach($notas_a_arreglar as $nota_bodega_id) {
        // si tiene el mismo nombre ponle el id
        $nota_en_db = NotaBodega::getByID_($nota_bodega_id);
        $clientes = json_decode($nota_en_db['cliente']??'{}', true);
        $nota = [];

        if(empty($clientes))
            $clientes = [];

        foreach($clientes as &$cliente){
            if(strcasecmp($nombre, strim($cliente['nombre'])) == 0){
                $cliente['cliente_id'] = $cliente_id;
            }
        }

        $nota['cliente'] =  json_encode($clientes);



        $sql_update[] = $sqlbuilder->update('nota_bodega', $nota, ['nota_bodega_id' => $nota_bodega_id]);
    }
    if(!empty($sql_update))
        ia_transaction($sql_update);

    foreach($notas_a_arreglar as $nota_bodega_id) {
        // recalcula la inconsistencia y destino match que?
        $nota = NotaBodega::getByID_($nota_bodega_id);
        $notaBodegaInconsistencias = new NotaBodegaInconsistencias($nota, es_alta: false, para_recalcular: true);
        $inconsistencias['clientes'] = $notaBodegaInconsistencias->cliente();
        $gDime[] = $inconsistencias;
        $notaBodegaInconsistencias->guardaInconsistencias($inconsistencias, 'clientes');
    }


    $sql = "
                SELECT /*$method deduce nota_bodega_id a  recalcular */ nb.nota_bodega_id
                FROM nota_bodega nb
                         JOIN JSON_TABLE(cliente, '$[*]' COLUMNS (
                    cliente_id VARCHAR(32) PATH '$.cliente_id',
                    fue_error CHAR(2) PATH '$.fue_error')
                              ) clientes
                WHERE clientes.fue_error = 'No' AND clientes.cliente_id = '$cliente_id'
                  AND nb.tipo NOT IN ('Cancelacion', 'Borrado')
                  AND nb.super_lock = 0 AND nb.traslado_match_lock = 0 AND nb.lock_por_tiempo = 0 AND nb.lock_por_nota_posterior_ajuste = 0
                  AND nb.lock_por_tiempo_nota_ajuste = 0 AND nb.reset_lock = 0 AND nb.system_lock = 0";

    $notas_a_recalcular = ia_sqlVector($sql);

    foreach($notas_a_recalcular as $nota_bodega_id) {
        // recalcula la inconsistencia otra vez y destino match que?
        $nota = NotaBodega::getByID_($nota_bodega_id);
        $notaBodegaInconsistencias = new NotaBodegaInconsistencias($nota, es_alta: false, para_recalcular: true);
        $inconsistencias['clientes'] = $notaBodegaInconsistencias->cliente();
        $gDime[] = $inconsistencias;
        $notaBodegaInconsistencias->guardaInconsistencias($inconsistencias, 'clientes');
    }

    $sql = "
        SELECT /*$method */ *
        FROM nota_bodega nb
            JOIN JSON_TABLE(cliente, '$[*]' COLUMNS (
                    cliente_id VARCHAR(32) PATH '$.cliente_id',
                    fue_error CHAR(2) PATH '$.fue_error')
          ) clientes
            JOIN inconsistencia_nota_bodega inb ON nb.nota_bodega_id = inb.nota_bodega_id AND inb.tipo_inconsistencia = 'clientes' AND inb.estado = 'activo'
        WHERE clientes.fue_error = 'No' AND clientes.cliente_id = '$cliente_id' 
          AND nb.tipo NOT IN ('Cancelacion', 'Borrado') AND nb.destino_match = 'No' 
    ";
    $notas_a_recalcular = ia_sqlArray($sql, 'nota_bodega_id');
     $gDime[] =  array_keys($notas_a_recalcular);
    foreach($notas_a_recalcular as  $nota) {
        // recalcula la inconsistencia aunque tenga lock, y el destino match que?
        $notaBodegaInconsistencias = new NotaBodegaInconsistencias($nota, es_alta: false, para_recalcular: true);
        $inconsistencias['clientes'] = $notaBodegaInconsistencias->cliente();
        $gDime[] = $inconsistencias;
        $notaBodegaInconsistencias->guardaInconsistencias($inconsistencias, 'clientes');
    }
    ia_errores_a_dime();
    file_debug_reporte("CTE_FIXER_");
}

function calculaSaldoCliente($cliente_id = '', $do_sql = true, $debug = false): array
{
    $function = __FUNCTION__;
    // Fetch parameters
    $parametros = ia_singleton("SELECT tolerancia_pago_documentos_pesos,
           tolerancia_pago_documentos_usd
    FROM iac_parametros");

    $toleranciaPagoDocumentosPesos = $parametros['tolerancia_pago_documentos_pesos'];
    $toleranciaPagoDocumentosUsd = $parametros['tolerancia_pago_documentos_usd'];

    $tc_sql = "SELECT /** $function **/ ROUND(tc, 4) tipoCambio FROM tc_log WHERE origen <> 'TEMPORAL' ORDER BY alta_db DESC LIMIT 1";

    $tipoCambio = ia_singleread($tc_sql);

    $datosCliente = ia_singleton("SELECT cliente_id, nombre, tienda_id FROM cliente WHERE cliente_id = '$cliente_id'");
    $datosCliente['tipoCambio'] = $tipoCambio;

    $sql = [];
    $sql_ = "DELETE FROM clientes_saldos_cat WHERE cliente_id = '$cliente_id'";
    ia_query($sql_);

    // Fetch data for cheques, pagares, vales, and compras
    $cheques = fetchFinancialData($cliente_id, 'cheque', $toleranciaPagoDocumentosPesos, $toleranciaPagoDocumentosUsd);
    $pagares = fetchFinancialData($cliente_id, 'pagare', $toleranciaPagoDocumentosPesos, $toleranciaPagoDocumentosUsd);
    $vales = fetchFinancialData($cliente_id, 'vale', $toleranciaPagoDocumentosPesos, $toleranciaPagoDocumentosUsd);
    $compras = fetchFinancialData($cliente_id, 'compra', $toleranciaPagoDocumentosPesos, $toleranciaPagoDocumentosUsd);

    $g_ultima_salida_bodega_sql = "SELECT MAX(fecha) FROM nota_bodega WHERE nota_bodega.tipo = 'Movimiento' 
                                     AND  MATCH (cliente_actual, cliente_actual_id) AGAINST ('$cliente_id')";
//    echo "<pre>cheques" . print_r($cheques, true) . "</pre>";
    $g_ultima_salida_bodega = ia_singleread($g_ultima_salida_bodega_sql);

    if(empty($cheques) && empty($pagares) && empty($vales) && empty($compras)){
        $sql[] = generateBodegaUpdateSQL($cliente_id, $g_ultima_salida_bodega);
    }
    else {

        $combined = [];

        foreach ([$cheques, $vales, $pagares, $compras] as $array) {
            foreach ($array as $key => $values) {
                if (!isset($combined[$key])) {
                    $combined[$key] = [];
                }
                $combined[$key] = array_merge($combined[$key], $values, $datosCliente);
            }
        }
        calculateConsolidatedData($combined);
        $totals = getSumOfValuesByCategory($combined);
        $totals['ultimaSalidaBodega'] = $g_ultima_salida_bodega;
//    echo "<pre>$g_ultima_salida_bodega" . print_r($combined, true) . "</pre>";
//        echo "<pre>totals" . print_r($totals, true) . "</pre>";
        $insert_sql = generateCobranzaInsertSQL($combined);
//    echo "<pre>generateInsertSQL" . print_r($insert_sql, true) . "</pre>";
        $sql = $insert_sql;

        $sql[] = generateCobranzaUpdateSQL($cliente_id, $totals);
    }
    if($debug)
        ia_errores_a_dime("<pre>$cliente_id" . print_r($sql, true) . "</pre>");

    if($do_sql && ia_transaction($sql))
        ia_errores_a_dime("fallo transaccion", file: __FILE__, line: __LINE__);

    return $sql;
}
function fetchFinancialData($cliente_id, $table, $toleranciaPesos, $toleranciaUsd): bool|array
{
    // Determine the correct date field based on the table
    $dateField = ($table === 'vale') ? 'vale.fecha' : "IF($table.new_date IS NULL, DATE($table.original_date), DATE($table.new_date))";

    $sql = "SELECT
            COALESCE(SUM(IF($table.paid = 0 AND $table.moneda_id = 1 AND ABS($table.quantity - $table.total_payments) >= $toleranciaPesos,
                    IF($table.quantity - $table.total_payments < 0, 0.00, $table.quantity - $table.total_payments), 0.00)), 0.00) AS {$table}SaldoPesos,
            COALESCE(SUM(IF($table.paid = 0 AND $table.moneda_id = 2 AND ABS($table.quantity - $table.total_payments) >= $toleranciaUsd,
                    IF($table.quantity - $table.total_payments < 0, 0.00, $table.quantity - $table.total_payments), 0.00)), 0.00) AS {$table}SaldoUsd,
            MIN(IF($table.paid = 0, $dateField, NULL)) AS {$table}MasAntiguo,
            DATE(MAX(IF($table.paid = 0, $table.ultimo_pago, NULL))) AS {$table}UltimoPago,
            DATE(MAX($table.alta_db)) AS {$table}MasReciente,
            IF(SUM($table.paid = 0) = 0, DATE(MAX($table.ultimo_pago)), NULL) AS {$table}UltimaLiquidacion,
            COUNT(*) AS {$table}CuantosTotales,
            SUM(IF($table.paid = 0, 1, 0)) AS {$table}Cuantos,
            SUM(IF($table.paid = 0, 0, 1)) AS {$table}CuantosPagados,
            SUM(IF($table.moneda_id = 1, $table.quantity, 0)) AS {$table}TotalesPesos,
            SUM(IF($table.moneda_id = 2, $table.quantity, 0)) AS {$table}TotalesUsd,
            categoria_id
        FROM
            $table
        WHERE
            cliente_id = '$cliente_id'
        GROUP BY categoria_id";

    return ia_sqlArray($sql, "categoria_id");
}
function calculateConsolidatedData(&$combined): void
{
    foreach ($combined as $categoria_id => &$data) {
        // Calculate documentoMasAntiguo
        $documentoMasAntiguo = min(
            $data['chequeMasAntiguo'] ?? '9999-12-31',
            $data['pagareMasAntiguo'] ?? '9999-12-31',
            $data['valeMasAntiguo'] ?? '9999-12-31',
            $data['compraMasAntiguo'] ?? '9999-12-31'
        );
        $data['documentoMasAntiguo'] = ($documentoMasAntiguo === '9999-12-31') ? null : $documentoMasAntiguo;

        // Calculate ultimaLiquidacion
        if (
            isset($data['ultimaLiquidacioncheque'], $data['ultimaLiquidacionpagare'], $data['ultimaLiquidacionvale'], $data['ultimaLiquidacioncompra'])
        ) {
            $ultimaLiquidacion = max(
                $data['chequeUltimaLiquidacion'] ?? '0000-01-01',
                $data['pagareUltimaLiquidacion'] ?? '0000-01-01',
                $data['valeUltimaLiquidacion'] ?? '0000-01-01',
                $data['compraUltimaLiquidacion'] ?? '0000-01-01'
            );
            $data['ultimaLiquidacion'] = ($ultimaLiquidacion === '0000-01-01') ? null : $ultimaLiquidacion;
        } else {
            $data['ultimaLiquidacion'] = null;
        }

        // Calculate ultimoPago
        $ultimoPago = max(
            $data['chequeUltimoPago'] ?? '0000-01-01',
            $data['pagareUltimoPago'] ?? '0000-01-01',
            $data['valeUltimoPago'] ?? '0000-01-01',
            $data['compraUltimoPago'] ?? '0000-01-01'
        );
        $data['ultimoPago'] = ($ultimoPago === '0000-01-01') ? null : $ultimoPago;

        // Calculate masReciente
        $docMasReciente = max(
            $data['chequeMasReciente'] ?? '0000-01-01',
            $data['pagareMasReciente'] ?? '0000-01-01',
            $data['valeMasReciente'] ?? '0000-01-01',
            $data['compraMasReciente'] ?? '0000-01-01'
        );
        $data['docMasReciente'] = ($docMasReciente === '0000-01-01') ? null : $docMasReciente;

        // Remove the individual date fields that are now consolidated
//            unset($data['chequeMasAntiguo'], $data['pagareMasAntiguo'], $data['valeMasAntiguo'], $data['compraMasAntiguo']);
        unset($data['chequeUltimaLiquidacion'], $data['pagareUltimaLiquidacion'], $data['valeUltimaLiquidacion'], $data['compraUltimaLiquidacion']);
        unset($data['chequeUltimoPago'], $data['pagareUltimoPago'], $data['valeUltimoPago'], $data['compraUltimoPago']);
    }
}
function generateCobranzaInsertSQL($combined): array {
    $insert_sql = [];
    $arrayOfArrays = [];

    foreach ($combined as $categoria_id => $saldos) {
        $arrayOfArrays[] = [
            'cliente_id' => addslashes($saldos['cliente_id']),
            'nombre' => addslashes($saldos['nombre']),
            'categoria_id' => addslashes($saldos['categoria_id']),
            'tienda_id' => addslashes($saldos['tienda_id']),
            'saldo_cheques_pesos' => $saldos['chequeSaldoPesos'] ?? 0.00,
            'saldo_cheques_usd' => $saldos['chequeSaldoUsd'] ?? 0.00,
            'saldo_pagares_pesos' => $saldos['pagareSaldoPesos'] ?? 0.00,
            'saldo_pagares_usd' => $saldos['pagareSaldoUsd'] ?? 0.00,
            'saldo_vales_pesos' => $saldos['valeSaldoPesos'] ?? 0.00,
            'saldo_vales_usd' => $saldos['valeSaldoUsd'] ?? 0.00,
            'cheque_mas_antiguo' => isset($saldos['chequeMasAntiguo']) ? addslashes($saldos['chequeMasAntiguo']) : null,
            'pagare_mas_antiguo' => isset($saldos['pagareMasAntiguo']) ? addslashes($saldos['pagareMasAntiguo']) : null,
            'vale_mas_antiguo' => isset($saldos['valeMasAntiguo']) ? addslashes($saldos['valeMasAntiguo']) : null,
            'doc_mas_antiguo' => isset($saldos['documentoMasAntiguo']) ? addslashes($saldos['documentoMasAntiguo']) : null,
            'ultima_liquidacion' => isset($saldos['ultimaLiquidacion']) ? addslashes($saldos['ultimaLiquidacion']) : null,
            'ultimo_pago' => isset($saldos['ultimoPago']) ? addslashes($saldos['ultimoPago']) : null,
            'ultima_compra' => isset($saldos['docMasReciente']) ? addslashes($saldos['docMasReciente']) : null,
            'cuantos_cheques' => $saldos['chequeCuantos'] ?? 0,
            'cuantos_pagares' => $saldos['pagareCuantos'] ?? 0,
            'cuantos_vales' => $saldos['valeCuantos'] ?? 0,
            'tipo_cambio' => $saldos['tipoCambio'] ?? 0.00,
            'saldo_compras_pesos' => $saldos['compraSaldoPesos'] ?? 0.00,
            'saldo_compras_usd' => $saldos['compraSaldoUsd'] ?? 0.00,
            'cuantos_compras' => $saldos['compraCuantos'] ?? 0,
            'compra_mas_antigua' => isset($saldos['compraMasAntiguo']) ? addslashes($saldos['compraMasAntiguo']) : null
        ];

        foreach($arrayOfArrays as $k => $v){
            $insert_sql[] = ia_insert(table: 'clientes_saldos_cat', values: $v, autoOnUpdate: true);
        }
    }

    // Remove the trailing comma and space
    return $insert_sql;
}
function getSumOfValuesByCategory($combined): array{
    $totals = [
        'chequeTotalesPesos' => 0.00,
        'chequeSaldoPesos' => 0.00,
        'pagareTotalesPesos' => 0.00,
        'pagareSaldoPesos' => 0.00,
        'valeTotalesPesos' => 0.00,
        'valeSaldoPesos' => 0.00,
        'compraTotalesPesos' => 0.00,
        'compraSaldoPesos' => 0.00,

        'chequeTotalesUsd' => 0.00,
        'chequeSaldoUsd' => 0.00,
        'pagareTotalesUsd' => 0.00,
        'pagareSaldoUsd' => 0.00,
        'valeTotalesUsd' => 0.00,
        'valeSaldoUsd' => 0.00,
        'compraTotalesUsd' => 0.00,
        'compraSaldoUsd' => 0.00,

        'chequeCuantos' => 0,
        'chequeCuantosPagados' => 0,
        'pagareCuantos' => 0,
        'pagareCuantosPagados' => 0,
        'valeCuantos' => 0,
        'valeCuantosPagados' => 0,
        'compraCuantos' => 0,
        'compraCuantosPagados' => 0,
    ];

    foreach ($combined as $categoria_id => $saldos) {
        // Sum up each category separately
        $totals['chequeTotalesPesos'] += $saldos['chequeTotalesPesos'] ?? 0.00;
        $totals['pagareTotalesPesos'] += $saldos['pagareTotalesPesos'] ?? 0.00;
        $totals['valeTotalesPesos'] += $saldos['valeTotalesPesos'] ?? 0.00;
        $totals['compraTotalesPesos'] += $saldos['compraTotalesPesos'] ?? 0.00;

        $totals['chequeTotalesUsd'] += $saldos['chequeTotalesUsd'] ?? 0.00;
        $totals['pagareTotalesUsd'] += $saldos['pagareTotalesUsd'] ?? 0.00;
        $totals['valeTotalesUsd'] += $saldos['valeTotalesUsd'] ?? 0.00;
        $totals['compraTotalesUsd'] += $saldos['compraTotalesUsd'] ?? 0.00;

        $totals['chequeSaldoPesos'] += $saldos['chequeSaldoPesos'] ?? 0.00;
        $totals['pagareSaldoPesos'] += $saldos['pagareSaldoPesos'] ?? 0.00;
        $totals['valeSaldoPesos'] += $saldos['valeSaldoPesos'] ?? 0.00;
        $totals['compraSaldoPesos'] += $saldos['compraSaldoPesos'] ?? 0.00;

        $totals['chequeSaldoUsd'] += $saldos['chequeSaldoUsd'] ?? 0.00;
        $totals['pagareSaldoUsd'] += $saldos['pagareSaldoUsd'] ?? 0.00;
        $totals['valeSaldoUsd'] += $saldos['valeSaldoUsd'] ?? 0.00;
        $totals['compraSaldoUsd'] += $saldos['compraSaldoUsd'] ?? 0.00;

        $totals['chequeCuantos'] += $saldos['chequeCuantos'] ?? 0;
        $totals['pagareCuantos'] += $saldos['pagareCuantos'] ?? 0;
        $totals['valeCuantos'] += $saldos['valeCuantos'] ?? 0;
        $totals['compraCuantos'] += $saldos['compraCuantos'] ?? 0;

        $totals['chequeCuantosPagados'] += $saldos['chequeCuantosPagados'] ?? 0;
        $totals['pagareCuantosPagados'] += $saldos['pagareCuantosPagados'] ?? 0;
        $totals['valeCuantosPagados'] += $saldos['valeCuantosPagados'] ?? 0;
        $totals['compraCuantosPagados'] += $saldos['compraCuantosPagados'] ?? 0;
    }

    $hayPesos = $totals['chequeSaldoPesos'] > 0 || $totals['pagareSaldoPesos'] > 0 || $totals['valeSaldoPesos'] > 0;
    $hayUsd = $totals['chequeSaldoUsd'] > 0 || $totals['pagareSaldoUsd'] > 0 || $totals['valeSaldoUsd'] > 0;

    if($hayPesos && $hayUsd)
        $totals['saldo_cliente_moneda_id_calc'] = 3;
    else if($hayPesos && !$hayUsd)
        $totals['saldo_cliente_moneda_id_calc'] = 1;
    else
        $totals['saldo_cliente_moneda_id_calc'] = 2;

    return $totals;
}
function generateBodegaUpdateSQL($cliente_id = '', $ultimaSalidaBodega = ''): string{
    return $updateSql = "UPDATE cliente cte SET 
        cte.ultima_salida_bodega = " . (empty($ultimaSalidaBodega) ? "NULL" : "'$ultimaSalidaBodega'") . ", " .
        "saldo_cheques_pesos = 0.00,
        saldo_cheques_usd = 0.00,
        saldo_pagares_pesos = 0.00,
        saldo_pagares_usd = 0.00,
        saldo_vales_pesos = 0.00,
        saldo_vales_usd = 0.00,
        saldo_total_ventas_pesos = 0.00,
        saldo_total_ventas_usd = 0.00,
        saldo_compras_pesos = 0.00,
        saldo_compras_usd = 0.00,
        
        cheques_totales_pesos = 0.00,
        cheques_totales_usd = 0.00,
        
        saldo_pesos = 0.00,
        saldo_usd = 0.00,
        saldo_total_pesos = 0.00,
        saldo_total_usd = 0.00,
      
        saldo_cheques_pesos      = 0.00,
        saldo_cheques_usd        = 0.00,
        saldo_pagares_pesos      = 0.00,
        saldo_pagares_usd        = 0.00,
        saldo_vales_pesos        = 0.00,
        saldo_vales_usd          = 0.00,
        
        pagares_totales_pesos    = 0.00,
        pagares_totales_usd      = 0.00,
        vales_totales_pesos      = 0.00,
        vales_totales_usd        = 0.00
        
        WHERE cte.cliente_id = '$cliente_id'";
}
function generateCobranzaUpdateSQL($cliente_id = '', $totals = []): string
{

    return $updateSql = "UPDATE cliente cte
        INNER JOIN (SELECT s.cliente_id,
                           SUM(s.saldo_cheques_pesos + s.saldo_pagares_pesos - s.saldo_vales_pesos)    saldo_pesos,
                           SUM(s.saldo_cheques_usd + s.saldo_pagares_usd - s.saldo_vales_usd)          saldo_usd,
                           SUM(s.saldo_cheques_pesos)                                            saldo_cheques_pesos,
                           SUM(s.saldo_cheques_usd)                                              saldo_cheques_usd,
                           SUM(s.saldo_pagares_pesos)                                            saldo_pagares_pesos,
                           SUM(s.saldo_pagares_usd)                                              saldo_pagares_usd,
                           SUM(s.saldo_vales_pesos)                                              saldo_vales_pesos,
                           SUM(s.saldo_vales_usd)                                                saldo_vales_usd,
                           MAX(s.ultima_compra)                                                  ultima_compra,


                           MIN(s.cheque_mas_antiguo)                                             cheque_mas_antiguo,
                           MIN(s.pagare_mas_antiguo)                                             pagare_mas_antiguo,
                           MIN(s.vale_mas_antiguo)                                               vale_mas_antiguo,
                           MIN(s.doc_mas_antiguo)                                                doc_mas_antiguo,
                           MAX(s.ultima_liquidacion)                                             ultima_liquidacion,
                           MAX(s.ultimo_pago)                                                    ultimo_pago,
                           SUM(s.saldo_compras_pesos)                                            saldo_compras_pesos,
                           SUM(s.saldo_compras_usd)                                              saldo_compras_usd,
                           SUM(s.compra_mas_antigua)                                             compra_mas_antigua

                    FROM clientes_saldos_cat s
                    GROUP BY cliente_id)
            sdo ON cte.cliente_id = sdo.cliente_id
    SET cte.cuantos_cheques          = $totals[chequeCuantos],
        cte.cuantos_pagares          = $totals[pagareCuantos],
        cte.cuantos_vales            = $totals[valeCuantos],
        cte.cuantos_cheques_pagados  = $totals[chequeCuantosPagados],
        cte.cuantos_pagares_pagados  = $totals[pagareCuantosPagados],
        cte.cuantos_vales_pagados    = $totals[valeCuantosPagados],
        cte.cheques_totales          = $totals[chequeCuantos] + $totals[chequeCuantosPagados],
        cte.pagares_totales          = $totals[pagareCuantos] + $totals[pagareCuantosPagados],
        cte.vales_totales            = $totals[valeCuantos] + $totals[valeCuantosPagados],
        cte.cheques_totales_pesos    = $totals[chequeTotalesPesos],
        cte.cheques_totales_usd      = $totals[chequeTotalesUsd],
        cte.pagares_totales_pesos    = $totals[pagareTotalesPesos],
        cte.pagares_totales_usd      = $totals[pagareTotalesUsd],
        cte.vales_totales_pesos      = $totals[valeTotalesPesos],
        cte.vales_totales_usd        = $totals[valeTotalesUsd],

        
        cte.saldo_pesos              = sdo.saldo_pesos,
        cte.saldo_usd                = sdo.saldo_usd,
        cte.saldo_cheques_pesos      = sdo.saldo_cheques_pesos,
        cte.saldo_cheques_usd        = sdo.saldo_cheques_usd,
        cte.saldo_pagares_pesos      = sdo.saldo_pagares_pesos,
        cte.saldo_pagares_usd        = sdo.saldo_pagares_usd,
        cte.saldo_vales_pesos        = sdo.saldo_vales_pesos,
        cte.saldo_vales_usd          = sdo.saldo_vales_usd,
        cte.ultima_compra            = sdo.ultima_compra,
        cte.saldo_total_pesos        = $totals[chequeSaldoPesos] + $totals[pagareSaldoPesos] - $totals[valeSaldoPesos],
        cte.saldo_total_usd          = $totals[chequeSaldoUsd] + $totals[pagareSaldoUsd] - $totals[valeSaldoUsd],

        cte.cheque_mas_antiguo       = sdo.cheque_mas_antiguo,
        cte.pagare_mas_antiguo       = sdo.pagare_mas_antiguo,
        cte.vale_mas_antiguo         = sdo.vale_mas_antiguo,
        cte.doc_mas_antiguo          = sdo.doc_mas_antiguo,
        cte.ultima_liquidacion       = sdo.ultima_liquidacion,
        cte.ultimo_pago              = sdo.ultimo_pago,


        cte.saldo_compras_pesos      = sdo.saldo_compras_pesos,
        cte.saldo_compras_usd        = sdo.saldo_compras_usd,
        cte.cuantos_compras          = $totals[compraCuantos],
        cte.cuantos_compras_pagados  = $totals[compraCuantosPagados],
        cte.compras_totales          = $totals[compraCuantos] + $totals[compraCuantosPagados],
        cte.compra_mas_antigua       = sdo.compra_mas_antigua,
        cte.ultima_salida_bodega     = '$totals[ultimaSalidaBodega]',

        cte.saldo_cliente_moneda_id_calc = '$totals[saldo_cliente_moneda_id_calc]'
    WHERE cte.cliente_id = '$cliente_id'";
}