<?php

function calculaGastosdeCuentaT($cuentaT_id='')
{
    global $gIAParametros;

    if(empty($cuentaT_id))
        return 0.00;

    $diasParaContabilizar = 0;

    $diasParaContabilizarParam = $gIAParametros['numero_dias_contabilizar_gastos_cuentat'];

    $diadelMes = date('d');
    $diasdelMes = date('t');

    if($diasParaContabilizarParam > $diasdelMes)
        $diasParaContabilizarParam = $diasdelMes;

    $diasParaContabilizar = $diadelMes % $diasParaContabilizarParam;

    if($diadelMes == 31 && $diasParaContabilizar<$diasParaContabilizarParam)
        $diasParaContabilizar = $diasParaContabilizarParam + $diasParaContabilizar;

    //echo "<pre>$diasParaContabilizar</pre>";
    //$diasParaContabilizar--;

    $diaCGInicial = '';
    $diaCGFinal = '';

    $diaCGInicial = new DateTime(date('Y-m-d'));
    $diaCGInicial->modify("-$diasParaContabilizar day");
    $diaCGInicial = $diaCGInicial->format('Y-m-d');

    $diaCGFinal = new DateTime(date('Y-m-d'));
    //$diaCGFinal->modify("+1 day");
    $diaCGFinal = $diaCGFinal->format('Y-m-d');

    //$sql="SELECT * FROM cuentat_gasto WHERE activo='Si' AND cuentaT_id='$cuentaT_id' AND fecha>'$diaCGInicial' AND fecha<='$diaCGFinal'";
    //$arr_gastosCtaT = ia_sqlArrayIndx($sql);

    //echo "diaCGInicial:$diaCGInicial<br />";
    //echo "diaCGFinal:$diaCGFinal<br />";
    $sql = "SELECT SUM(egreso) FROM cuentat_gasto WHERE activo='Si' AND cuentaT_id='$cuentaT_id' AND fecha between '$diaCGInicial' AND '$diaCGFinal'";
    //echo "sql:$sql<br />";
    $gastosAcumulados = ia_singleread($sql);

    return $gastosAcumulados;
}

function leeLimitesPCG($pID)
{
    $limPCG = array('monto_maximo' => 0.00,
        'periodicidad_mensual' => 0,
        'num_veces_utilizar' => 0,
        'fecha_primer_mov' => 0,
        'fecha_ultimo_mov' => 0,
        'num_veces_utilizado' => 0,
        'fecha_inicio_validez' => 0,
        'fecha_expiracion' => 0
    );
    if(empty($pID))
        return $limPCG;

    return ia_singleton("SELECT * FROM plantilla_cuentat_gasto WHERE plantilla_cuentat_gasto_id='$pID'");
}

function revisaLimitesPCG($pID='', $monto=0.00, $insert=true, $fecha_ref = "")
{
    $retVal = array('gastoAprobado' => false, 'PCGenDB' => array(), 'Error' => '');

    $now = empty($fecha_ref) ? strtotime("now") : strtotime($fecha_ref);

//    $fecha_ref = empty($fecha_ref) ? date('Y-m-d') : $fecha_ref;

    if(empty($pID) || empty($monto))
        return $retVal;

    $PCGenDB = ia_singleton("SELECT * FROM plantilla_cuentat_gasto WHERE plantilla_cuentat_gasto_id='$pID'");

    if($PCGenDB['tiene_restricciones'] == 'No')
        return array('gastoAprobado' => true, 'PCGenDB' => $PCGenDB, 'Error' => '');

    $PCGenDB['fecha_inicio_validez'] = !empty($PCGenDB['fecha_inicio_validez']) ? strtotime($PCGenDB['fecha_inicio_validez']) : false;
    $PCGenDB['fecha_expiracion'] = !empty($PCGenDB['fecha_expiracion']) ? strtotime($PCGenDB['fecha_expiracion']) : false;
    $monto = echonf($monto, true, 2, "");
    $monto_maximo = $PCGenDB['monto_maximo'];
    $PCGenDB['monto_maximo'] = echonf($PCGenDB['monto_maximo'], true, 2, "");
    $retVal['PCGenDB'] = $PCGenDB;

    //echo "<pre>".print_r($PCGenDB, true)."</pre>monto: $monto<br />now: $now";

    if(empty($PCGenDB))
        return $retVal;

    if(!empty($PCGenDB['fecha_inicio_validez']) && $PCGenDB['fecha_inicio_validez'] > $now)
    {
        //echo "fecha_inicio_validez: $PCGenDB[fecha_inicio_validez]<br />now: $now";
        //$retVal['Error'] = "fecha_inicio_validez: $PCGenDB[fecha_inicio_validez]<br />now: $now";
        $retVal['Error'] = "La platilla aún no se puede usar, tiene como fecha de inicio $PCGenDB[fecha_inicio_validez].";
        return $retVal;
    }

    if(!empty($PCGenDB['fecha_expiracion']) && $PCGenDB['fecha_expiracion'] < $now)
    {
        //echo "fecha_expiracion: $PCGenDB[fecha_expiracion]<br />now: $now";
        //$retVal['Error'] = "fecha_expiracion: $PCGenDB[fecha_expiracion]<br />now: $now";
        $retVal['Error'] = "La plantilla ya no se puede usar, tiene como fecha limite $PCGenDB[fecha_expiracion].";
        return $retVal;
    }

    if($monto_maximo > 0 && $monto > $PCGenDB['monto_maximo'])
    {
        //echo "monto: $monto<br />monto_maximo: $PCGenDB[monto_maximo]";
        //$retVal['Error'] = "monto: $monto<br />monto_maximo: $PCGenDB[monto_maximo]";
        $retVal['Error'] = "El monto que quiere aplicar excede el monto máximo de la plantilla.";
        return $retVal;
    }

    if($insert && !empty($PCGenDB['num_veces_utilizar']) && $PCGenDB['num_veces_utilizado'] > $PCGenDB['num_veces_utilizar'])
    {
        //echo "num_veces_utilizar: $PCGenDB[num_veces_utilizar]<br />num_veces_utilizado: $PCGenDB[num_veces_utilizado]";
        //$retVal['Error'] = "num_veces_utilizar: $PCGenDB[num_veces_utilizar]<br />num_veces_utilizado: $PCGenDB[num_veces_utilizado]";
        $retVal['Error'] = "La plantilla ya no se puede usar, solo se puede usar $PCGenDB[num_veces_utilizar] veces.";
        return $retVal;
    }

    if($insert && !empty($PCGenDB['periodicidad_semanal']))
    {
        $lunes = date('Y-m-d', strtotime('monday this week', $now)) . " 00:00:00";
        $domingo = date('Y-m-d', strtotime('sunday this week', $now)) ." 23:59:59";
        $sql = "SELECT COUNT(cuentat_gasto_id) FROM cuentat_gasto WHERE activo='Si' AND fecha BETWEEN '$lunes' AND '$domingo' AND plantilla_cuentat_gasto_id='$pID'";
        $vecesSemana = ia_singleread($sql);
//        echo "periodicidad_semanal<br>".$sql;
        if($vecesSemana >= $PCGenDB['periodicidad_semanal'])
        {
            //echo "periodicidad_semanal: $PCGenDB[periodicidad_semanal]<br />vecesSemana: $vecesSemana<br />lunes:$lunes<br />domingo:$domingo";
            //$retVal['Error'] = "periodicidad_semanal: $PCGenDB[periodicidad_semanal]<br />vecesSemana: $vecesSemana<br />lunes:$lunes<br />domingo:$domingo";
            $retVal['Error'] = "La plantilla ya no se puede usar esta semana, solo se puede usar $PCGenDB[periodicidad_semanal] veces por semana.";
            return $retVal;
        }
    }

    if($insert && !empty($PCGenDB['periodicidad_mensual']))
    {
        $mesActual = date("Y-m", $now);
        $primerdiamesActual = date('Y-m-01', strtotime($mesActual));
        $ultimodiamesActual = date('Y-m-t', strtotime($mesActual));

        $sql = "SELECT COUNT(cuentat_gasto_id) FROM cuentat_gasto WHERE activo='Si' AND fecha between '$primerdiamesActual' AND '$ultimodiamesActual' AND plantilla_cuentat_gasto_id='$pID'";

//        echo "periodicidad_mensual:<br>".$sql;

        $vecesMes = ia_singleread($sql);
        //$vecesMes = ia_singleread("SELECT COUNT(cuentat_gasto_id) FROM cuentat_gasto WHERE activo='Si' AND
        // fecha LIKE '$mesActual%' AND plantilla_cuentat_gasto_id='$pID'");
        if($vecesMes >= $PCGenDB['periodicidad_mensual'])
        {
            //echo "periodicidad_mensual: $PCGenDB[periodicidad_mensual]<br />vecesMes: $vecesMes<br />mesActual:$mesActual";
            //$retVal['Error'] = "periodicidad_mensual: $PCGenDB[periodicidad_mensual]<br />vecesMes: $vecesMes<br />mesActual:$mesActual";
            $retVal['Error'] = "La plantilla ya no se puede usar este mes, solo se puede usar $PCGenDB[periodicidad_mensual] veces por mes.";
            return $retVal;
        }
    }

    $retVal['gastoAprobado'] = true;

    return $retVal;

}

function generaHtmlPlantillasCtaG($aoh = 'h', $todas = false)
{
    if(empty($aoh))
        $aoh = 'h';

    $todas = $todas && usuarioTipoRony(1);

    $arrPlantillas = ia_sqlArray("SELECT * FROM plantilla_cuentat_gasto WHERE 1 ORDER BY tiene_restricciones DESC, orden ASC", "plantilla_cuentat_gasto_id");

    foreach($arrPlantillas as &$tmplt)
    {
        $tmplt['campos'] = substr(preg_replace('/\\\\n|\\\\t|\\\\/', '', $tmplt['campos']), 1, -1);
        $cAu = false;
        /* $campos = $tmplt['campos'];
        if (!empty($campos)) {
            if (!is_array($campos)) {
              $campos = str_replace(['"[', ']"'], ["[", "]"], $campos);
            }
          } */
        $tmp = json_decode($tmplt['campos']);
        foreach($tmp as $k=>&$f)
            if($f->type == 'campoAutomatico')
            {
                $cAu = true;
                $f->nombre = property_exists($f, 'nombre') ? ia_htmlentities($f->nombre) : 'SIN NOMBRE';
                foreach($f->values as $i=>&$v)
                    $v->result = ia_htmlentities(calculaFechaAutomaticaCTG($v->value));
            }
        if($cAu)
            $tmplt['campos'] = json_encode($tmp);
    }

    $dcr=''; $dsr=''; $html='';
    $restricciones_key = [
        'monto_maximo' => 'Monto máximo',
        'periodicidad_semanal' => 'Veces por semana',
        'periodicidad_mensual' => 'Veces por mes',
        'num_veces_utilizar' => 'Se puede usar solo ##_valor_## veces',
    ];

    foreach($arrPlantillas as $k=>$v)
    {
        if($v['activa']!='Si')
            continue;

        $title = '';
        $class = [];
        $icon_usar = "<i class='fa-solid fa-circle-plus txt_shadow_turquoise txt_1_6em' title='Usar<br> plantilla' style='float: right'></i>";
        if(!$todas && $v['pausado']=='Si')
        {
            $hl = "void(0)";
            $class[] = "disabled";
            $title = '<b class="text-danger">LA PLANTILLA YA NO SE PUEDE USAR</b><br>';
            $icon_usar = '';
        }
        else
        {
            $hl = "nuevoGastoCuentaT(\"$k\")";
        }
        if($v['tiene_restricciones'] == 'Si')
        {
            $title.= '<div style="width: 300px"><b class="text-orange">RESTRICCIONES</b>';
            foreach ($restricciones_key as $key => $label) {
                $val = $v[$key] ?? '';
                if ($val>0) {
                    $val = $key === 'monto_maximo' ? echonf($val, true): $val;
                    if ($key == 'num_veces_utilizar') {
                        $title .= "<li>".str_replace("##_valor_##", $val, $label);
                        continue;
                    }
                    $title.= "<li>".$label . ": <b>$val</b>";
                }
            }
            $title.="</div>";
            $arrPlantillas[$k]['restricciones'] = $title;
            $class = implode(" ", $class);
            $dcr.="<li id='$k' class='$class' style='padding:3px;'><a href='javascript:void(0);' onclick='$hl' style='text-decoration: none; width: 100%; line-height: 24px'><i class='fa-icon fa-duotone fa-solid fa-circle-info txt_shadow_blue txt_1_1em' title='$title'></i><strong style='background-color:#$v[bkgcolor]; color:#$v[color];'>&nbsp;$v[nombre]&nbsp;</strong>$icon_usar</a></li>";
        }
        else
        {
            $class = implode(" ", $class);
            $dsr.="<li id='$k' class='$class' style='padding:3px;'><a href='javascript:void(0);' onclick='$hl' style='text-decoration: none; width: 100%; line-height: 24px' title='$title'><strong style='background-color:#$v[bkgcolor]; color:#$v[color];'>&nbsp;$v[nombre]&nbsp;</strong>$icon_usar</a></li>";
        }
    }
    $html='<div id="plantillasSinRestriccion" class="clasificaFlexItem" style="float: left; text-align:left;">
            <div class="clasificaItemTitle clasificaFlexRow">
                <h3>SIN RESTRICCIONES</h3>
                <div>
                    <!--<input type="text" value="" placeholder="🔎" class="clasificaFind" data-clasificakey="Si"><span class="clasificaFindClear" data-clasificakey="Si">x</span>   
                    <span title="Pasar todos, los visibles, a Si" data-clasificaelementid="puede_gasto" data-clasificakey="Si" class="clasificaAllTo">↴</span>-->
                </div> 
            </div><ul class="clasificaItemList ui-sortable">'.$dsr.'</ul></div>';
    $html.='<div id="plantillasConRestriccion" class="clasificaFlexItem" style="float: left; text-align:left;">
                <div class="clasificaItemTitle clasificaFlexRow">
                <h3>CON RESTRICCIONES</h3>
                <div>
                    <!--<input type="text" value="" placeholder="🔎" class="clasificaFind" data-clasificakey="Si"><span class="clasificaFindClear" data-clasificakey="Si">x</span>   
                    <span title="Pasar todos, los visibles, a Si" data-clasificaelementid="puede_gasto" data-clasificakey="Si" class="clasificaAllTo">↴</span>-->
                </div> 
            </div><ul class="clasificaItemList ui-sortable">'.$dcr.'</ul></div>';

    $url_to_tmplt = getUrlTo('backoffice/plantilla_cuentat_gasto.php');
    $anchor = '';
    if (usuarioTipoRony()) {
        $anchor = '<a href="'.$url_to_tmplt.'" class="lbl bold" style="color: blue; font-size: 1.3em" target="_blank">Ir a las platillas de Gastos de Cuenta T</a>';
    }

    if($aoh=='a')
        return $arrPlantillas;

    return '<div class="clasificaFlexRow" style="margin-bottom: 4em;">'.$html.'</div>'.$anchor;
}

function calculaFechaAutomaticaCTG($str='mes')
{
    global $gIAData;
    switch ($str)
    {
        case 'numsemana':
            return date('W');
            break;

        case 'nummes':
            return date('m');
            break;

        case 'diassemana':
            $day = date('w') - 1;
            $lunes = strtotime('-'.$day.' days');
            $dom = strtotime('+'.(6-$day).' days');
            $week_start = date('d', $lunes);
            $week_end = date('d', $dom);
            $month1 = strtoupper($gIAData['monthLong'][date('n', $lunes)]);
            $month2 = strtoupper($gIAData['monthLong'][date('n', $dom)]);
            if($month1 == $month2)
                $ret = "DEL $week_start AL $week_end DE $month1.";
            else
                $ret = "DEL $week_start DE $month1 AL $week_end DE $month2.";
            return $ret;

            break;

        case 'diassemanapasada':
            $lunes = strtotime('monday last week');
            $dom = strtotime('sunday last week');
            $week_start = date('d', $lunes);
            $week_end = date('d', $dom);
            $month1 = strtoupper($gIAData['monthLong'][date('n', $lunes)]);
            $month2 = strtoupper($gIAData['monthLong'][date('n', $dom)]);
            if($month1 == $month2)
                $ret = "DEL $week_start AL $week_end DE $month1.";
            else
                $ret = "DEL $week_start DE $month1 AL $week_end DE $month2.";
            return $ret;
            break;

        case 'mes':
            return strtoupper($gIAData['monthLong'][date('n')]);
            break;
    }
}

function generaHtmlPlantillasWithdrawalsBanco($aoh = 'h', $todas = false)
{
    if(empty($aoh))
        $aoh = 'h';

    $todas = $todas && usuarioTipoRony();

    $arrPlantillas = ia_sqlArray("SELECT * FROM plantilla_withdrawals_de_banco WHERE 1 ORDER BY tiene_restricciones DESC, orden ASC", "plantilla_withdrawals_de_banco_id");

    foreach($arrPlantillas as &$tmplt)
    {
        $tmplt['campos'] = substr(preg_replace('/\\\\n|\\\\t|\\\\/', '', $tmplt['campos']), 1, -1);
        $cAu = false;
        $tmp = json_decode($tmplt['campos']);
        if (empty($tmp)) continue;

        foreach($tmp as $k=>&$f)
            if($f->type == 'campoAutomatico')
            {
                $cAu = true;
                $f->nombre = property_exists($f, 'nombre') ? ia_htmlentities($f->nombre) : 'SIN NOMBRE';
                foreach($f->values as $i=>&$v)
                    $v->result = ia_htmlentities(calculaFechaAutomaticaCTG($v->value));
            }
        if($cAu)
            $tmplt['campos'] = json_encode($tmp);
    }

    $dcr=''; $dsr=''; $html='';
    $restricciones_key = [
        'monto_maximo' => 'Monto máximo',
        'periodicidad_semanal' => 'Veces por semana',
        'periodicidad_mensual' => 'Veces por mes',
        'num_veces_utilizar' => 'Se puede usar solo ##_valor_## veces',
    ];

    foreach($arrPlantillas as $k=>$v)
    {
        //echo "<pre>".print_r($v, true)."</pre>";
        if($v['activa']!='Si')
            continue;

        $title = '';
        $class = [];
        $icon_usar = "<i class='fa-solid fa-circle-plus txt_shadow_turquoise txt_1_6em' title='Usar <br> plantilla' style='float: right'></i>";
        if(!$todas && $v['pausado']=='Si')
        {
            $hl = "void(0)";
            $class[] = "disabled";
            $title = '<b class="text-danger">LA PLANTILLA YA NO SE PUEDE USAR</b><br>';
            $icon_usar = '';
        }
        else
        {
            $btn = "add.png";
            //$hl = "llenaRemarksconPlantilla(\"$k\")";
            $hl = "plantillas.show_dialog_from_template(\"$k\")";
        }
        if($v['tiene_restricciones'] == 'Si')
        {
            $title.= '<div style="width: 300px"><b class="text-orange">RESTRICCIONES</b>';
            foreach ($restricciones_key as $key => $label) {
                $val = $v[$key] ?? '';
                if ($val>0) {
                    $val = $key === 'monto_maximo' ? echonf($val, true): $val;
                    if ($key == 'num_veces_utilizar') {
                        $title .= "<li>".str_replace("##_valor_##", $val, $label);
                        continue;
                    }
                    $title.= "<li>".$label . ": <b>$val</b>";
                }
            }
            $title.="</div>";
            $arrPlantillas[$k]['restricciones'] = $title;
            $class = implode(" ", $class);
            $dcr.="<li id='$k' class='$class' style='padding:3px;'><a href='javascript:void(0);' onclick='$hl' style='text-decoration: none; width: 100%; line-height: 24px'><i class='fa-icon fa-duotone fa-solid fa-circle-info txt_shadow_blue txt_1_1em' title='$title'></i><strong style='background-color:#$v[bkgcolor]; color:#$v[color];'>&nbsp;$v[nombre]&nbsp;</strong>
            $icon_usar</a></li>";
        }
        else
        {
            $class = implode(" ", $class);
            $dsr.="<li id='$k' class='$class' style='padding:3px;'><a href='javascript:void(0);' onclick='$hl' style='text-decoration: none; width: 100%; line-height: 24px' title='$title'><strong style='background-color:#$v[bkgcolor]; color:#$v[color];'>&nbsp;$v[nombre]&nbsp;</strong>
            $icon_usar</a></li>";
        }
    }
    $html='<div id="plantillasSinRestriccion" class="clasificaFlexItem" style="float: left; text-align:left;">
            <div class="clasificaItemTitle clasificaFlexRow">
                <h3>SIN RESTRICCIONES</h3>
                <div>
                    <!--<input type="text" value="" placeholder="🔎" class="clasificaFind" data-clasificakey="Si"><span class="clasificaFindClear" data-clasificakey="Si">x</span>   
                    <span title="Pasar todos, los visibles, a Si" data-clasificaelementid="puede_gasto" data-clasificakey="Si" class="clasificaAllTo">↴</span>-->
                </div> 
            </div><ul class="clasificaItemList ui-sortable">'.$dsr.'</ul></div>';
    $html.='<div id="plantillasConRestriccion" class="clasificaFlexItem" style="float: left; text-align:left;">
                <div class="clasificaItemTitle clasificaFlexRow">
                <h3>CON RESTRICCIONES</h3>
                <div>
                    <!--<input type="text" value="" placeholder="🔎" class="clasificaFind" data-clasificakey="Si"><span class="clasificaFindClear" data-clasificakey="Si">x</span>   
                    <span title="Pasar todos, los visibles, a Si" data-clasificaelementid="puede_gasto" data-clasificakey="Si" class="clasificaAllTo">↴</span>-->
                </div> 
            </div><ul class="clasificaItemList ui-sortable">'.$dcr.'</ul></div>';

    if($aoh=='a')
        return $arrPlantillas;

    return $html;
}


function revisaRestriccionesPlatillaWithdrawalsBanco($platilla, $monto_aplicar = 0.00, $fecha_ref = '',  $banco_cuenta_mov_id = '')
{
    $method = __METHOD__;
    $response = [
        'status' => true,
        'message' => 'No tiene restricciones', // HTML DE TODOS LOS ERRORES
        'restricciones' => [],
        'error' => '', // HTML DEL PRIMER ERROR
    ];
    /* if (strcasecmp($platilla['puede_pasar_restricciones'], 'Si') == 0)
        return $response; */

    $restricciones = [
        'nombre' => 'Nombre de la platilla',
        'activa' => 'No',
        'tiene_restricciones' => 'No',
        'monto_maximo' => '0',
        'periodicidad_mensual' => '0',
        'periodicidad_semanal' => '0',
        'num_veces_utilizar' => '0',
        'num_veces_utilizado' => '',
        'fecha_expiracion' => '',
        'fecha_inicio_validez' => '',
    ];
    $pk_field = "plantilla_withdrawals_de_banco_id";
    $platilla_id = $platilla[$pk_field] ?? '';
    $restricciones = ParamsHelper::get($restricciones, request:  $platilla);
    $errores = [];

    if (strcasecmp($restricciones['activa'], 'Si') !== 0) {
        $response['platilla_activa'] = false;
        $errores['activa'] = "La platilla $restricciones[nombre] no esta activa";
        // return $response;
    }

    if (strcasecmp($restricciones['tiene_restricciones'], 'No') === 0)
        return $response;

    if (!empty($fecha_ref)) {
        $fecha_ref = explode(" ", $fecha_ref)[0]??'';
    }

    $now = empty($fecha_ref) ? strtotime("now") : strtotime($fecha_ref);


    if (!empty($restricciones['fecha_inicio_validez']) && ($now < strtotime($restricciones['fecha_inicio_validez']))) {
        $label_fecha = getDateLabel($restricciones['fecha_inicio_validez']);
        $errores['fecha_inicio_validez'] = "La platilla $restricciones[nombre] aún no se puede usar, tiene como fecha de inicio $label_fecha.";
    }

    if (!empty($restricciones['fecha_expiracion']) && ($now > strtotime($restricciones['fecha_expiracion']))) {
        $label_fecha = getDateLabel($restricciones['fecha_expiracion']);
        $errores['fecha_expiracion'] = "La platilla $restricciones[nombre] ya no se puede usar, tiene como fecha limite $label_fecha.";
    }

    $monto_aplicar = limpiaCantidad($monto_aplicar);
    if ($restricciones['monto_maximo'] > 0 && bccomp($monto_aplicar, $restricciones['monto_maximo'], 2) == 1)
        $errores['monto_maximo'] = "El monto que quiere aplicar excede el monto máximo de la plantilla.";


    $select_count = "SELECT /*$method*/ COUNT($pk_field) FROM banco_cuenta_mov WHERE $pk_field = ".strit($platilla_id)." AND banco_cuenta_mov_id <> '$banco_cuenta_mov_id'";
    if (!empty($restricciones['num_veces_utilizar'])) {
        $veces_utilizado = ia_singleread($select_count);
        if ($veces_utilizado >= $restricciones['num_veces_utilizar'])
            $errores['num_veces_utilizar'] = "La platilla $restricciones[nombre] ya no se puede usar, solo se puede usar $restricciones[num_veces_utilizar] veces.";
    }

    if (!empty($restricciones['periodicidad_semanal'])) {
        $lunes = date('Y-m-d', strtotime('monday this week', $now)) . " 00:00:00";
        $domingo = date('Y-m-d', strtotime('sunday this week', $now)) ." 23:59:59";
        $select_semanal = $select_count." AND fecha BETWEEN '$lunes' AND '$domingo'";
        $veces_utilizado = ia_singleread($select_semanal);
        if ($veces_utilizado>= $restricciones['periodicidad_semanal'])
            $errores['periodicidad_semanal'] = "La platilla $restricciones[nombre] ya no se puede usar esta semana, solo se puede usar $restricciones[periodicidad_semanal] veces por semana.";
    }

    if (!empty($restricciones['periodicidad_mensual'])) {
        $mesActual = date("Y-m", $now);
        $primerdiamesActual = date('Y-m-01', strtotime($mesActual));
        $ultimodiamesActual = date('Y-m-t', strtotime($mesActual));
        $select_mensual = $select_count." AND fecha BETWEEN '$primerdiamesActual' AND '$ultimodiamesActual'";
        $veces_utilizado = ia_singleread($select_mensual);
        if ($veces_utilizado >= $restricciones['periodicidad_mensual'])
            $errores['periodicidad_mensual'] = "La platilla $restricciones[nombre] ya no se puede usar esta mes, solo se puede usar $restricciones[periodicidad_mensual] veces por mes.";
    }

    if (!empty($errores)) {
        $response['status'] = false;
        $response['restricciones'] = $errores;
        $response['message'] = "<li>".implode("</li><li>", $errores)."</li>";
        $response['error'] = reset($errores);
    }
    // d_($response);
    return $response;
}
