<?php

class StringCompareJaroWinkler
{
    public function compare($str1, $str2)
    {
        return $this->JaroWinkler($str1, $str2, $PREFIXSCALE = 0.1 );
    }

    private function getCommonCharacters( $string1, $string2, $allowedDistance ){

        $str1_len = mb_strlen($string1);
        $str2_len = mb_strlen($string2);
        $temp_string2 = $string2;

        $commonCharacters='';
        for( $i=0; $i < $str1_len; $i++){

            $noMatch = True;
            // compare if char does match inside given allowedDistance
            // and if it does add it to commonCharacters
            for( $j= max( 0, $i-$allowedDistance ); $noMatch && $j < min( $i + $allowedDistance + 1, $str2_len ); $j++){
                if( $temp_string2[$j] == $string1[$i] ){
                    $noMatch = False;
                    $commonCharacters .= $string1[$i];
                    $temp_string2[$j] = '';
                }
            }
        }
        return $commonCharacters;
    }

    private function Jaro( $string1, $string2 ){

        $str1_len = mb_strlen( $string1 );
        $str2_len = mb_strlen( $string2 );

        // theoretical distance
        $distance = (int) floor(min( $str1_len, $str2_len ) / 2.0);

        // get common characters
        $commons1 = $this->getCommonCharacters( $string1, $string2, $distance );
        $commons2 = $this->getCommonCharacters( $string2, $string1, $distance );

        if( ($commons1_len = mb_strlen( $commons1 )) == 0) return 0;
        if( ($commons2_len = mb_strlen( $commons2 )) == 0) return 0;
        // calculate transpositions
        $transpositions = 0;
        $upperBound = min( $commons1_len, $commons2_len );
        for( $i = 0; $i < $upperBound; $i++){
            if( $commons1[$i] != $commons2[$i] ) $transpositions++;
        }
        $transpositions /= 2.0;
        // return the Jaro distance
        return ($commons1_len/($str1_len) + $commons2_len/($str2_len) + ($commons1_len - $transpositions)/($commons1_len)) / 3.0;

    }

    private function getPrefixLength( $string1, $string2, $MINPREFIXLENGTH = 4 ){

        $n = min( array( $MINPREFIXLENGTH, mb_strlen($string1), mb_strlen($string2) ) );

        for($i = 0; $i < $n; $i++){
            if( $string1[$i] != $string2[$i] ){
                // return index of first occurrence of different characters
                return $i;
            }
        }
        // first n characters are the same
        return $n;
    }

    private function JaroWinkler($string1, $string2, $PREFIXSCALE = 0.1 ){

        $JaroDistance = $this->Jaro( $string1, $string2 );
        $prefixLength = $this->getPrefixLength( $string1, $string2 );
        return $JaroDistance + $prefixLength * $PREFIXSCALE * (1.0 - $JaroDistance);
    }
}



function query_select_doctos()
{
    $select_cheque = "SELECT
                        `cheque`.`tienda_id` AS `tienda_id`,
                        `cheque`.`moneda_id` AS `moneda_id`,
                        `cheque`.`numero` AS `numero`,
                        `cheque`.`cliente_id` AS `cliente_id`,
                        `cliente`.`nombre` AS `cliente`,
                        IF((`cheque`.`new_date` IS NULL),
                            `cheque`.`original_date`,
                            `cheque`.`new_date`) AS `fecha`,
                        `cheque`.`alta_db` AS `alta_db`,
                        `cheque`.`alta_por` AS `alta_por`,
                        `cheque`.`quantity` AS `quantity`,
                        `cheque`.`total_payments` AS `total_payments`,
                        IF(((`cheque`.`quantity` - `cheque`.`total_payments`) < 0),
                            0,
                            (`cheque`.`quantity` - `cheque`.`total_payments`)) AS `debe`,
                        IF((`cheque`.`moneda_id` = 1),
                            `cliente`.`saldo_pesos`,
                            `cliente`.`saldo_usd`) AS `saldo`,
                        `cheque`.`cuentaT_deliveredto_id` AS `cuentaT_deliveredto_id`,
                        `cheque`.`origen_cuentat_id` AS `origen_cuentat_id`,
                        `cheque`.`numero_sistema` AS `numero_sistema`,
                        `cheque`.`remarks` AS `remarks`,
                        `cheque`.`autorizado` AS `autorizado`,
                        `cheque`.`autorizado_por` AS `autorizado_por`,
                        `cheque`.`autorizado_el` AS `autorizado_el`,
                        `cheque`.`borrado` AS `borrado`,
                        `cheque`.`borrado_por` AS `borrado_por`,
                        `cheque`.`borrado_el` AS `borrado_el`,
                        `cheque`.`cheque_id` AS `doc_id`,
                        `cheque`.`cheque_id` AS `doc_origen_id`,
                        IF((((`cheque`.`origen_cuentat_id` IS NULL)
                                OR (`cheque`.`origen_cuentat_id` = ''))
                                AND ((`cheque`.`delivered_directo` = '1')
                                OR (`cheque`.`cuentaT_transferto_id` > 0)
                                OR (`cheque`.`cuentaT_deliveredto_id` > 0))),
                            'CHEQUE DD',
                            'CHEQUE') AS `origen`,
                        `cheque`.`paid` AS `paid`,
                        `cheque`.`delivered_directo` AS `delivered_directo`,
                        `cheque`.`ultimo_movimiento` AS `ultimo_movimiento`,
                        `cheque`.`desautorizado_el` AS `desautorizado_el`,
                        `cheque`.`numero_contenedor` AS `numero_contenedor`,
                        `cheque`.`lugar_de_entrada` AS `lugar_de_entrada`,
                        `cheque`.`tipo_de_tela` AS `tipo_de_tela`,
                        0 AS `banco_cuenta_id`,
                        NULL AS `deposit_fecha`,
                        0 AS `deposit_total`,
                        `cheque`.`moneda_id` AS `doc_moneda`,
                        `cheque`.`remarks_wot` AS `remarks_wot`,
                        `cheque`.`cuentat_mov_id` AS `cuentat_mov_id`,
                        0 AS `acta_quantity`,
                        `cheque`.`rechazado` AS `rechazado`,
                        `cheque`.`categoria_id` AS `categoria_id`,
                        `categoria`.`categoria` AS `categoria`,
                        `cheque`.`tipo` AS `tipo`,
                        `cheque`.`paid_when` AS `paid_when`,
                        `cheque`.`ultimo_pago` AS `ultimo_pago`
                    FROM
                        ((`cheque`
                    LEFT JOIN `cliente` ON ((`cheque`.`cliente_id` = `cliente`.`cliente_id`)))
                    LEFT JOIN `categoria` ON ((`cheque`.`categoria_id` = `categoria`.`categoria_id`)))";

    $select_cheque_log = "SELECT 
                            `cheque_log`.`tienda_id` AS `tienda_id`,
                            `cheque_log`.`moneda_id` AS `moneda_id`,
                            `cheque_log`.`numero` AS `numero`,
                            `cheque_log`.`cliente_id` AS `cliente_id`,
                            `cliente`.`nombre` AS `cliente`,
                            IF((`cheque_log`.`new_date` IS NULL),
                                `cheque_log`.`original_date`,
                                `cheque_log`.`new_date`) AS `fecha`,
                            `cheque_log`.`alta_db` AS `alta_db`,
                            `cheque_log`.`alta_por` AS `alta_por`,
                            `cheque_log`.`quantity` AS `quantity`,
                            `cheque_log`.`total_payments` AS `total_payments`,
                            IF(((`cheque_log`.`quantity` - `cheque_log`.`total_payments`) < 0),
                                0,
                                (`cheque_log`.`quantity` - `cheque_log`.`total_payments`)) AS `debe`,
                            IF((`cheque_log`.`moneda_id` = 1),
                                `cliente`.`saldo_pesos`,
                                `cliente`.`saldo_usd`) AS `saldo`,
                            `cheque_log`.`cuentaT_deliveredto_id` AS `cuentaT_deliveredto_id`,
                            `cheque_log`.`origen_cuentat_id` AS `origen_cuentat_id`,
                            `cheque_log`.`numero_sistema` AS `numero_sistema`,
                            `cheque_log`.`remarks` AS `remarks`,
                            `cheque_log`.`autorizado` AS `autorizado`,
                            `cheque_log`.`autorizado_por` AS `autorizado_por`,
                            `cheque_log`.`autorizado_el` AS `autorizado_el`,
                            `cheque_log`.`borrado` AS `borrado`,
                            `cheque_log`.`borrado_por` AS `borrado_por`,
                            `cheque_log`.`borrado_el` AS `borrado_el`,
                            `cheque_log`.`cheque_id` AS `doc_id`,
                            `cheque_log`.`cheque_id` AS `doc_origen_id`,
                            IF((((`cheque_log`.`origen_cuentat_id` IS NULL)
                                    OR (`cheque_log`.`origen_cuentat_id` = ''))
                                    AND (`cheque_log`.`delivered_directo` = '1')),
                                'CHEQUE DD',
                                'CHEQUE') AS `origen`,
                            `cheque_log`.`paid` AS `paid`,
                            `cheque_log`.`delivered_directo` AS `delivered_directo`,
                            `cheque_log`.`ultimo_movimiento` AS `ultimo_movimiento`,
                            `cheque_log`.`desautorizado_el` AS `desautorizado_el`,
                            `cheque_log`.`numero_contenedor` AS `numero_contenedor`,
                            `cheque_log`.`lugar_de_entrada` AS `lugar_de_entrada`,
                            `cheque_log`.`tipo_de_tela` AS `tipo_de_tela`,
                            0 AS `banco_cuenta_id`,
                            NULL AS `deposit_fecha`,
                            0 AS `deposit_total`,
                            `cheque_log`.`moneda_id` AS `doc_moneda`,
                            `cheque_log`.`remarks_wot` AS `remarks_wot`,
                            `cheque_log`.`cuentat_mov_id` AS `cuentat_mov_id`,
                            0 AS `acta_quantity`,
                            `cheque_log`.`rechazado` AS `rechazado`,
                            0 AS `categoria_id`,
                            'CATEGORIA' AS `categoria`,
                            `cheque_log`.`tipo` AS `tipo`,
                            `cheque_log`.`paid_when` AS `paid_when`,
                            NULL AS `ultimo_pago`
                        FROM
                            (`cheque_log`
                            LEFT JOIN `cliente` ON ((`cheque_log`.`cliente_id` = `cliente`.`cliente_id`)))";

    $select_pagare = "SELECT 
                        `pagare`.`tienda_id` AS `tienda_id`,
                        `pagare`.`moneda_id` AS `moneda_id`,
                        `pagare`.`numero` AS `numero`,
                        `pagare`.`cliente_id` AS `cliente_id`,
                        `cliente`.`nombre` AS `cliente`,
                        IF((`pagare`.`new_date` IS NULL),
                            `pagare`.`original_date`,
                            `pagare`.`new_date`) AS `fecha`,
                        `pagare`.`alta_db` AS `alta_db`,
                        `pagare`.`alta_por` AS `alta_por`,
                        `pagare`.`quantity` AS `quantity`,
                        `pagare`.`total_payments` AS `total_payments`,
                        IF(((`pagare`.`quantity` - `pagare`.`total_payments`) < 0),
                            0,
                            (`pagare`.`quantity` - `pagare`.`total_payments`)) AS `debe`,
                        IF((`pagare`.`moneda_id` = 1),
                            `cliente`.`saldo_pesos`,
                            `cliente`.`saldo_usd`) AS `saldo`,
                        `pagare`.`cuentaT_deliveredto_id` AS `cuentaT_deliveredto_id`,
                        `pagare`.`origen_cuentat_id` AS `origen_cuentat_id`,
                        `pagare`.`numero_sistema` AS `numero_sistema`,
                        `pagare`.`remarks` AS `remarks`,
                        `pagare`.`autorizado` AS `autorizado`,
                        `pagare`.`autorizado_por` AS `autorizado_por`,
                        `pagare`.`autorizado_el` AS `autorizado_el`,
                        `pagare`.`borrado` AS `borrado`,
                        `pagare`.`borrado_por` AS `borrado_por`,
                        `pagare`.`borrado_el` AS `borrado_el`,
                        `pagare`.`pagare_id` AS `doc_id`,
                        `pagare`.`pagare_id` AS `doc_origen_id`,
                        'PAGARE' AS `origen`,
                        `pagare`.`paid` AS `paid`,
                        `pagare`.`delivered_directo` AS `delivered_directo`,
                        `pagare`.`ultimo_movimiento` AS `ultimo_movimiento`,
                        `pagare`.`desautorizado_el` AS `desautorizado_el`,
                        `pagare`.`numero_contenedor` AS `numero_contenedor`,
                        `pagare`.`lugar_de_entrada` AS `lugar_de_entrada`,
                        `pagare`.`tipo_de_tela` AS `tipo_de_tela`,
                        0 AS `banco_cuenta_id`,
                        NULL AS `deposit_fecha`,
                        0 AS `deposit_total`,
                        `pagare`.`moneda_id` AS `doc_moneda`,
                        `pagare`.`remarks_wot` AS `remarks_wot`,
                        `pagare`.`cuentat_mov_id` AS `cuentat_mov_id`,
                        0 AS `acta_quantity`,
                        `pagare`.`rechazado` AS `rechazado`,
                        `pagare`.`categoria_id` AS `categoria_id`,
                        `categoria`.`categoria` AS `categoria`,
                        `pagare`.`tipo` AS `tipo`,
                        `pagare`.`paid_when` AS `paid_when`,
                        `pagare`.`ultimo_pago` AS `ultimo_pago`
                    FROM
                        ((`pagare`
                        LEFT JOIN `cliente` ON ((`pagare`.`cliente_id` = `cliente`.`cliente_id`)))
                        LEFT JOIN `categoria` ON ((`pagare`.`categoria_id` = `categoria`.`categoria_id`)))";

    $select_pagare_log = "SELECT 
                            `pagare_log`.`tienda_id` AS `tienda_id`,
                            `pagare_log`.`moneda_id` AS `moneda_id`,
                            `pagare_log`.`numero` AS `numero`,
                            `pagare_log`.`cliente_id` AS `cliente_id`,
                            `cliente`.`nombre` AS `cliente`,
                            IF((`pagare_log`.`new_date` IS NULL),
                                `pagare_log`.`original_date`,
                                `pagare_log`.`new_date`) AS `fecha`,
                            `pagare_log`.`alta_db` AS `alta_db`,
                            `pagare_log`.`alta_por` AS `alta_por`,
                            `pagare_log`.`quantity` AS `quantity`,
                            `pagare_log`.`total_payments` AS `total_payments`,
                            IF(((`pagare_log`.`quantity` - `pagare_log`.`total_payments`) < 0),
                                0,
                                (`pagare_log`.`quantity` - `pagare_log`.`total_payments`)) AS `debe`,
                            IF((`pagare_log`.`moneda_id` = 1),
                                `cliente`.`saldo_pesos`,
                                `cliente`.`saldo_usd`) AS `saldo`,
                            `pagare_log`.`cuentaT_deliveredto_id` AS `cuentaT_deliveredto_id`,
                            `pagare_log`.`origen_cuentat_id` AS `origen_cuentat_id`,
                            `pagare_log`.`numero_sistema` AS `numero_sistema`,
                            `pagare_log`.`remarks` AS `remarks`,
                            `pagare_log`.`autorizado` AS `autorizado`,
                            `pagare_log`.`autorizado_por` AS `autorizado_por`,
                            `pagare_log`.`autorizado_el` AS `autorizado_el`,
                            `pagare_log`.`borrado` AS `borrado`,
                            `pagare_log`.`borrado_por` AS `borrado_por`,
                            `pagare_log`.`borrado_el` AS `borrado_el`,
                            `pagare_log`.`pagare_id` AS `doc_id`,
                            `pagare_log`.`pagare_id` AS `doc_origen_id`,
                            'PAGARE' AS `origen`,
                            `pagare_log`.`paid` AS `paid`,
                            `pagare_log`.`delivered_directo` AS `delivered_directo`,
                            `pagare_log`.`ultimo_movimiento` AS `ultimo_movimiento`,
                            `pagare_log`.`desautorizado_el` AS `desautorizado_el`,
                            `pagare_log`.`numero_contenedor` AS `numero_contenedor`,
                            `pagare_log`.`lugar_de_entrada` AS `lugar_de_entrada`,
                            `pagare_log`.`tipo_de_tela` AS `tipo_de_tela`,
                            0 AS `banco_cuenta_id`,
                            NULL AS `deposit_fecha`,
                            0 AS `deposit_total`,
                            `pagare_log`.`moneda_id` AS `doc_moneda`,
                            `pagare_log`.`remarks_wot` AS `remarks_wot`,
                            `pagare_log`.`cuentat_mov_id` AS `cuentat_mov_id`,
                            0 AS `acta_quantity`,
                            `pagare_log`.`rechazado` AS `rechazado`,
                            0 AS `categoria_id`,
                            'CATEGORIA' AS `categoria`,
                            `pagare_log`.`tipo` AS `tipo`,
                            `pagare_log`.`paid_when` AS `paid_when`,
                            NULL AS `ultimo_pago`
                        FROM
                            (`pagare_log`
                            LEFT JOIN `cliente` ON ((`pagare_log`.`cliente_id` = `cliente`.`cliente_id`)))";

    $select_vale = "SELECT 
                        `vale`.`tienda_id` AS `tienda_id`,
                        `vale`.`moneda_id` AS `moneda_id`,
                        `vale`.`vale_number` AS `numero`,
                        `vale`.`cliente_id` AS `cliente_id`,
                        IF((`vale`.`cliente_id` IS NULL),
                            `vale`.`cliente`,
                            `cliente`.`nombre`) AS `cliente`,
                        `vale`.`fecha` AS `fecha`,
                        `vale`.`alta_db` AS `alta_db`,
                        `vale`.`alta_por` AS `alta_por`,
                        `vale`.`quantity` AS `quantity`,
                        `vale`.`total_payments` AS `total_payments`,
                        IF(((`vale`.`quantity` - `vale`.`total_payments`) < 0),
                            0,
                            (`vale`.`quantity` - `vale`.`total_payments`)) AS `debe`,
                        IF((`vale`.`moneda_id` = 1),
                            `cliente`.`saldo_pesos`,
                            `cliente`.`saldo_usd`) AS `saldo`,
                        `vale`.`dinero_en_cuentaT_id` AS `cuentaT_deliveredto_id`,
                        `vale`.`dinero_en_cuentaT_id` AS `origen_cuentat_id`,
                        `vale`.`numero_sistema` AS `numero_sistema`,
                        `vale`.`remarks` AS `remarks`,
                        `vale`.`autorizado` AS `autorizado`,
                        `vale`.`autorizado_por` AS `autorizado_por`,
                        `vale`.`autorizado_el` AS `autorizado_el`,
                        `vale`.`borrado` AS `borrado`,
                        `vale`.`borrado_por` AS `borrado_por`,
                        `vale`.`borrado_el` AS `borrado_el`,
                        `vale`.`vale_id` AS `doc_id`,
                        `vale`.`vale_id` AS `doc_origen_id`,
                        'VALE' AS `origen`,
                        `vale`.`paid` AS `paid`,
                        0 AS `delivered_directo`,
                        `vale`.`ultimo_movimiento` AS `ultimo_movimiento`,
                        `vale`.`desautorizado_el` AS `desautorizado_el`,
                        `vale`.`numero_contenedor` AS `numero_contenedor`,
                        `vale`.`lugar_de_entrada` AS `lugar_de_entrada`,
                        `vale`.`tipo_de_tela` AS `tipo_de_tela`,
                        0 AS `banco_cuenta_id`,
                        NULL AS `deposit_fecha`,
                        0 AS `deposit_total`,
                        `vale`.`moneda_id` AS `doc_moneda`,
                        `vale`.`remarks_wot` AS `remarks_wot`,
                        `vale`.`cuenta_t_mov_id` AS `cuentat_mov_id`,
                        0 AS `acta_quantity`,
                        `vale`.`rechazado` AS `rechazado`,
                        `vale`.`categoria_id` AS `categoria_id`,
                        `categoria`.`categoria` AS `categoria`,
                        `vale`.`tipo` AS `tipo`,
                        `vale`.`paid_when` AS `paid_when`,
                        `vale`.`ultimo_pago` AS `ultimo_pago`
                    FROM
                        ((`vale`
                        LEFT JOIN `cliente` ON ((`vale`.`cliente_id` = `cliente`.`cliente_id`)))
                        LEFT JOIN `categoria` ON ((`vale`.`categoria_id` = `categoria`.`categoria_id`)))";

    $select_vale_log = "SELECT 
                            `vale_log`.`tienda_id` AS `tienda_id`,
                            `vale_log`.`moneda_id` AS `moneda_id`,
                            `vale_log`.`vale_number` AS `numero`,
                            `vale_log`.`cliente_id` AS `cliente_id`,
                            IF((`vale_log`.`cliente_id` IS NULL),
                                `vale_log`.`cliente`,
                                `cliente`.`nombre`) AS `cliente`,
                            `vale_log`.`fecha` AS `fecha`,
                            `vale_log`.`alta_db` AS `alta_db`,
                            `vale_log`.`alta_por` AS `alta_por`,
                            `vale_log`.`quantity` AS `quantity`,
                            `vale_log`.`total_payments` AS `total_payments`,
                            IF(((`vale_log`.`quantity` - `vale_log`.`total_payments`) < 0),
                                0,
                                (`vale_log`.`quantity` - `vale_log`.`total_payments`)) AS `debe`,
                            IF((`vale_log`.`moneda_id` = 1),
                                `cliente`.`saldo_pesos`,
                                `cliente`.`saldo_usd`) AS `saldo`,
                            `vale_log`.`dinero_en_cuentaT_id` AS `cuentaT_deliveredto_id`,
                            `vale_log`.`dinero_en_cuentaT_id` AS `origen_cuentat_id`,
                            `vale_log`.`numero_sistema` AS `numero_sistema`,
                            `vale_log`.`remarks` AS `remarks`,
                            `vale_log`.`autorizado` AS `autorizado`,
                            `vale_log`.`autorizado_por` AS `autorizado_por`,
                            `vale_log`.`autorizado_el` AS `autorizado_el`,
                            `vale_log`.`borrado` AS `borrado`,
                            `vale_log`.`borrado_por` AS `borrado_por`,
                            `vale_log`.`borrado_el` AS `borrado_el`,
                            `vale_log`.`vale_id` AS `doc_id`,
                            `vale_log`.`vale_id` AS `doc_origen_id`,
                            'VALE' AS `origen`,
                            `vale_log`.`paid` AS `paid`,
                            0 AS `delivered_directo`,
                            `vale_log`.`ultimo_movimiento` AS `ultimo_movimiento`,
                            `vale_log`.`desautorizado_el` AS `desautorizado_el`,
                            `vale_log`.`numero_contenedor` AS `numero_contenedor`,
                            `vale_log`.`lugar_de_entrada` AS `lugar_de_entrada`,
                            `vale_log`.`tipo_de_tela` AS `tipo_de_tela`,
                            0 AS `banco_cuenta_id`,
                            NULL AS `deposit_fecha`,
                            0 AS `deposit_total`,
                            `vale_log`.`moneda_id` AS `doc_moneda`,
                            `vale_log`.`remarks_wot` AS `remarks_wot`,
                            `vale_log`.`cuenta_t_mov_id` AS `cuentat_mov_id`,
                            0 AS `acta_quantity`,
                            `vale_log`.`rechazado` AS `rechazado`,
                            0 AS `categoria_id`,
                            'CATEGORIA' AS `categoria`,
                            `vale_log`.`tipo` AS `tipo`,
                            `vale_log`.`paid_when` AS `paid_when`,
                            NULL AS `ultimo_pago`
                        FROM
                            (`vale_log`
                            LEFT JOIN `cliente` ON ((`vale_log`.`cliente_id` = `cliente`.`cliente_id`)))";

    $select_cheque_pago_log = "SELECT 
                                `ch`.`tienda_id` AS `tienda_id`,
                                `cp`.`moneda_id` AS `moneda_id`,
                                `ch`.`numero` AS `doc_numero`,
                                `ch`.`cliente_id` AS `cliente_id`,
                                `cli`.`nombre` AS `cliente`,
                                `cp`.`fecha` AS `fecha`,
                                `cp`.`alta_db` AS `alta_db`,
                                `cp`.`alta_por` AS `alta_por`,
                                `ch`.`quantity` AS `quantity`,
                                `ch`.`total_payments` AS `total_payments`,
                                IF(((`ch`.`quantity` - `ch`.`total_payments`) < 0),
                                    0,
                                    (`ch`.`quantity` - `ch`.`total_payments`)) AS `debe`,
                                IF((`ch`.`moneda_id` = 1),
                                    `cli`.`saldo_pesos`,
                                    `cli`.`saldo_usd`) AS `saldo`,
                                NULL AS `cuentaT_deliveredto_id`,
                                `cp`.`cuentaT_id` AS `origen_cuentat_id`,
                                `cp`.`numero_referencia` AS `numero_sistema`,
                                `cp`.`comentario` AS `remarks`,
                                `cp`.`autorizado` AS `autorizado`,
                                `cp`.`autorizado_por` AS `autorizado_por`,
                                `cp`.`autorizado_el` AS `autorizado_el`,
                                'Si' AS `borrado`,
                                `cp`.`alta_por` AS `borrado_por`,
                                `cp`.`fecha_borrado` AS `borrado_el`,
                                `cp`.`cheque_pago_log_id` AS `doc_id`,
                                `ch`.`cheque_id` AS `doc_origen_id`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'CHEQUE LINK',
                                    IF((`cp`.`metodo_pago_id` = 14),
                                        'CHEQUE VALE',
                                        'CHEQUE CASH')) AS `origen`,
                                `ch`.`paid` AS `paid`,
                                `ch`.`delivered_directo` AS `delivered_directo`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'LINK BORRADO',
                                    'A CUENTA BORRADO') AS `ultimo_movimiento`,
                                `cp`.`desautorizado_el` AS `desautorizado_el`,
                                '' AS `numero_contenedor`,
                                '' AS `lugar_de_entrada`,
                                '' AS `tipo_de_tela`,
                                `cp`.`banco_cuenta_id` AS `banco_cuenta_id`,
                                `cp`.`deposit_fecha` AS `deposit_fecha`,
                                `cp`.`deposit_total` AS `deposit_total`,
                                `ch`.`moneda_id` AS `doc_moneda`,
                                `ch`.`remarks_wot` AS `remarks_wot`,
                                `cp`.`cuenta_t_mov_id` AS `cuentat_mov_id`,
                                `cp`.`quantity_total` AS `acta_quantity`,
                                `cp`.`rechazado` AS `rechazado`,
                                0 AS `categoria_id`,
                                'CATEGORIA' AS `categoria`,
                                '' AS `tipo`,
                                NULL AS `paid_when`,
                                NULL AS `ultimo_pago`
                            FROM
                                ((`cheque_pago_log` `cp`
                                LEFT JOIN `cheque` `ch` ON ((`ch`.`cheque_id` = `cp`.`cheque_id`)))
                                LEFT JOIN `cliente` `cli` ON ((`ch`.`cliente_id` = `cli`.`cliente_id`)))";

    $select_pagare_pago_log = "SELECT 
                                `ch`.`tienda_id` AS `tienda_id`,
                                `cp`.`moneda_id` AS `moneda_id`,
                                `ch`.`numero` AS `doc_numero`,
                                `ch`.`cliente_id` AS `cliente_id`,
                                `cli`.`nombre` AS `cliente`,
                                `cp`.`fecha` AS `fecha`,
                                `cp`.`alta_db` AS `alta_db`,
                                `cp`.`alta_por` AS `alta_por`,
                                `ch`.`quantity` AS `quantity`,
                                `ch`.`total_payments` AS `total_payments`,
                                IF(((`ch`.`quantity` - `ch`.`total_payments`) < 0),
                                    0,
                                    (`ch`.`quantity` - `ch`.`total_payments`)) AS `debe`,
                                IF((`ch`.`moneda_id` = 1),
                                    `cli`.`saldo_pesos`,
                                    `cli`.`saldo_usd`) AS `saldo`,
                                NULL AS `cuentaT_deliveredto_id`,
                                `cp`.`cuentaT_id` AS `origen_cuentat_id`,
                                `cp`.`numero_referencia` AS `numero_sistema`,
                                `cp`.`comentario` AS `remarks`,
                                `cp`.`autorizado` AS `autorizado`,
                                `cp`.`autorizado_por` AS `autorizado_por`,
                                `cp`.`autorizado_el` AS `autorizado_el`,
                                'Si' AS `borrado`,
                                `cp`.`alta_por` AS `borrado_por`,
                                `cp`.`fecha_borrado` AS `borrado_el`,
                                `cp`.`pagare_pago_log_id` AS `doc_id`,
                                `ch`.`pagare_id` AS `doc_origen_id`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'PAGARE LINK',
                                    IF((`cp`.`metodo_pago_id` = 14),
                                        'PAGARE VALE',
                                        'PAGARE CASH')) AS `origen`,
                                `ch`.`paid` AS `paid`,
                                `ch`.`delivered_directo` AS `delivered_directo`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'LINK BORRADO',
                                    'A CUENTA BORRADO') AS `ultimo_movimiento`,
                                `cp`.`desautorizado_el` AS `desautorizado_el`,
                                '' AS `numero_contenedor`,
                                '' AS `lugar_de_entrada`,
                                '' AS `tipo_de_tela`,
                                `cp`.`banco_cuenta_id` AS `banco_cuenta_id`,
                                `cp`.`deposit_fecha` AS `deposit_fecha`,
                                `cp`.`deposit_total` AS `deposit_total`,
                                `ch`.`moneda_id` AS `doc_moneda`,
                                `ch`.`remarks_wot` AS `remarks_wot`,
                                `cp`.`cuenta_t_mov_id` AS `cuentat_mov_id`,
                                `cp`.`quantity_total` AS `acta_quantity`,
                                `cp`.`rechazado` AS `rechazado`,
                                0 AS `categoria_id`,
                                'CATEGORIA' AS `categoria`,
                                '' AS `tipo`,
                                NULL AS `paid_when`,
                                NULL AS `ultimo_pago`
                            FROM
                                ((`pagare_pago_log` `cp`
                                LEFT JOIN `pagare` `ch` ON ((`ch`.`pagare_id` = `cp`.`pagare_id`)))
                                LEFT JOIN `cliente` `cli` ON ((`ch`.`cliente_id` = `cli`.`cliente_id`)))";

    $select_vale_pago_log = "SELECT 
                                `ch`.`tienda_id` AS `tienda_id`,
                                `cp`.`moneda_id` AS `moneda_id`,
                                `ch`.`vale_number` AS `doc_numero`,
                                `ch`.`cliente_id` AS `cliente_id`,
                                `cli`.`nombre` AS `cliente`,
                                `cp`.`fecha` AS `fecha`,
                                `cp`.`alta_db` AS `alta_db`,
                                `cp`.`alta_por` AS `alta_por`,
                                `ch`.`quantity` AS `quantity`,
                                `ch`.`total_payments` AS `total_payments`,
                                IF(((`ch`.`quantity` - `ch`.`total_payments`) < 0),
                                    0,
                                    (`ch`.`quantity` - `ch`.`total_payments`)) AS `debe`,
                                IF((`ch`.`moneda_id` = 1),
                                    `cli`.`saldo_pesos`,
                                    `cli`.`saldo_usd`) AS `saldo`,
                                NULL AS `cuentaT_deliveredto_id`,
                                `cp`.`cuentaT_id` AS `origen_cuentat_id`,
                                `cp`.`numero_referencia` AS `numero_sistema`,
                                `cp`.`comentario` AS `remarks`,
                                `cp`.`autorizado` AS `autorizado`,
                                `cp`.`autorizado_por` AS `autorizado_por`,
                                `cp`.`autorizado_el` AS `autorizado_el`,
                                'Si' AS `borrado`,
                                `cp`.`alta_por` AS `borrado_por`,
                                `cp`.`fecha_borrado` AS `borrado_el`,
                                `cp`.`vale_pago_log_id` AS `doc_id`,
                                `ch`.`vale_id` AS `doc_origen_id`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'VALE PAGO LINK',
                                    'VALE PAGO CASH') AS `origen`,
                                `ch`.`paid` AS `paid`,
                                0 AS `delivered_directo`,
                                IF((`cp`.`banco_cuenta_id` > 0),
                                    'LINK BORRADO',
                                    'A CUENTA BORRADO') AS `ultimo_movimiento`,
                                NULL AS `desautorizado_el`,
                                '' AS `numero_contenedor`,
                                '' AS `lugar_de_entrada`,
                                '' AS `tipo_de_tela`,
                                `cp`.`banco_cuenta_id` AS `banco_cuenta_id`,
                                `cp`.`deposit_fecha` AS `deposit_fecha`,
                                `cp`.`deposit_total` AS `deposit_total`,
                                `ch`.`moneda_id` AS `doc_moneda`,
                                `ch`.`remarks_wot` AS `remarks_wot`,
                                `cp`.`cuenta_t_mov_id` AS `cuentat_mov_id`,
                                `cp`.`quantity_total` AS `acta_quantity`,
                                `cp`.`rechazado` AS `rechazado`,
                                0 AS `categoria_id`,
                                'CATEGORIA' AS `categoria`,
                                '' AS `tipo`,
                                NULL AS `paid_when`,
                                NULL AS `ultimo_pago`
                            FROM
                                ((`vale_pago_log` `cp`
                                LEFT JOIN `vale` `ch` ON ((`ch`.`vale_id` = CONVERT( `cp`.`vale_id` USING UTF8))))
                                LEFT JOIN `cliente` `cli` ON ((`ch`.`cliente_id` = `cli`.`cliente_id`)))";

    $select_cuentat_a_banco = "SELECT 
                                `cuentat_a_banco`.`tienda_id` AS `tienda_id`,
                                `cuentat_a_banco`.`moneda_id` AS `moneda_id`,
                                `cuentat_a_banco`.`numero_referencia` AS `doc_numero`,
                                '' AS `cliente_id`,
                                `cuentat_a_banco`.`cliente` AS `cliente`,
                                `cuentat_a_banco`.`fecha` AS `fecha`,
                                `cuentat_a_banco`.`ultimo_cambio` AS `alta_db`,
                                `cuentat_a_banco`.`ultimo_cambio_por` AS `alta_por`,
                                `cuentat_a_banco`.`egreso` AS `quantity`,
                                0 AS `total_payments`,
                                0 AS `debe`,
                                0 AS `saldo`,
                                NULL AS `cuentaT_deliveredto_id`,
                                IF((`cuentat_a_banco`.`afecta_cuentat` = 'NO'),
                                    NULL,
                                    `cuentat_a_banco`.`cuentaT_id`) AS `origen_cuentat_id`,
                                `cuentat_a_banco`.`numero_referencia` AS `numero_sistema`,
                                `cuentat_a_banco`.`remarks` AS `remarks`,
                                `cuentat_a_banco`.`autorizado` AS `autorizado`,
                                `cuentat_a_banco`.`autorizado_por` AS `autorizado_por`,
                                `cuentat_a_banco`.`autorizado_el` AS `autorizado_el`,
                                'Si' AS `borrado`,
                                `cuentat_a_banco`.`alta_por` AS `borrado_por`,
                                `cuentat_a_banco`.`alta_db` AS `borrado_el`,
                                `cuentat_a_banco`.`cuentat_a_banco_mov_id` AS `doc_id`,
                                `cuentat_a_banco`.`cuentat_a_banco_mov_id` AS `doc_origen_id`,
                                'CUENTA T' AS `origen`,
                                0 AS `paid`,
                                0 AS `delivered_directo`,
                                IF(((`cuentat_a_banco`.`deposit_total` > `cuentat_a_banco`.`egreso`)
                                        AND (`cuentat_a_banco`.`ide_amount` = 0)
                                        AND (`cuentat_a_banco`.`ide_percent` = 0)
                                        AND (`cuentat_a_banco`.`tarjeta_amount` = 0)
                                        AND (`cuentat_a_banco`.`tarjeta_percent` = 0)),
                                    'LINK PARCIAL BORRADO',
                                    'LINK BORRADO') AS `ultimo_movimiento`,
                                `cuentat_a_banco`.`desautorizado_el` AS `desautorizado_el`,
                                '' AS `numero_contenedor`,
                                '' AS `lugar_de_entrada`,
                                '' AS `tipo_de_tela`,
                                `cuentat_a_banco`.`banco_cuenta_id` AS `banco_cuenta_id`,
                                `cuentat_a_banco`.`deposit_fecha` AS `deposit_fecha`,
                                `cuentat_a_banco`.`deposit_total` AS `deposit_total`,
                                `cuentat_a_banco`.`moneda_id` AS `doc_moneda`,
                                `cuentat_a_banco`.`remarks` AS `remarks_wot`,
                                `cuentat_a_banco`.`cuentaT_mov_id` AS `cuentat_mov_id`,
                                0 AS `acta_quantity`,
                                `cuentat_a_banco`.`rechazado` AS `rechazado`,
                                0 AS `categoria_id`,
                                'CATEGORIA' AS `categoria`,
                                '' AS `tipo`,
                                NULL AS `paid_when`,
                                NULL AS `ultimo_pago`
                            FROM
                                `cuentat_a_banco`
                            WHERE
                                ((`cuentat_a_banco`.`activo` = 'No')
                                    AND (`cuentat_a_banco`.`factura_directa` = 'NO'))";


    $select =   $select_cheque .
        " UNION ALL ".
        $select_cheque_log .
        " UNION ALL ".
        $select_pagare .
        " UNION ALL ".
        $select_pagare_log .
        " UNION ALL ".
        $select_vale .
        " UNION ALL ".
        $select_vale_log .
        " UNION ALL ".
        $select_cheque_pago_log .
        " UNION ALL ".
        $select_pagare_pago_log .
        " UNION ALL ".
        $select_vale_pago_log .
        " UNION ALL ".
        $select_cuentat_a_banco;

    return $select;
}

function doctos_view_to_table()
{
    global $gIAsql;

    $querys = [];
    $querys[] = "DROP TABLE IF EXISTS doctos_live";

    $select_doctos = query_select_doctos();
    $querys[] = "CREATE TABLE doctos_live $select_doctos";
    // echo "<pre>". print_r($querys, true);

    if(ia_transaction($querys)) {
        ia_errores_a_dime('','','',true);
        $response['code'] = 409;
        $response['status'] = false;
        $response['message'] = 'Algo sucedio y no se paso la vista de doctos a tabla';
        echo json_encode($response);
        return false;
    }
    $response['code'] = 200;
    $response['status'] = true;
    $response['message'] = "OK! Se ha pasado la vista de doctos a una tabla (doctos_live: 'SELECT * FROM doctos_live')";
    echo json_encode($response);
    return true;
}

function insert_update_docto()
{
    echo "INSERTAR/UPDATE IN DOCTOS_LIVE";
}