<?php
function actualizaBancoRemarksdeFiduciario($fRID='', $guarda=true)
{
    if(empty($fRID))
        return;

    //$arr_BCM = ia_sqlArray("SELECT banco_cuenta_mov_id, remarks, remarks_log FROM banco_cuenta_mov_con_links WHERE link_to IS NOT NULL ORDER BY fecha DESC",'banco_cuenta_mov_id');
    $fRenDB = ia_singleton("SELECT * FROM fiduciario_reembolso WHERE fiduciario_reembolso_id=".strit($fRID));

    //echo "<pre>fRenDB".print_r($fRenDB, true) ."</pre>";
    $sql = array();
    $i=0;

    if(!empty($fRenDB) && is_array($fRenDB))
    {
        $fCenDBs = ia_sqlArray("SELECT * FROM fiduciario_contenedor WHERE fiduciario_reembolso_id = '$fRID'", 'fiduciario_contenedor_id');
        if(empty($fCenDBs))
            return;

        $fiduciarios = array('fND' => array(), 'fenDB' => array());
        $fC = 0;

        $remarksBCM =   str_pad("CONTENEDOR", 13, " ", STR_PAD_RIGHT)."\t".
            str_pad("PEDIMENTO", 17, " ", STR_PAD_RIGHT)."\t".
            str_pad("CONSTANCIA", 12, " ", STR_PAD_RIGHT)."\t".
            str_pad("ORIGINAL", 12, " ", STR_PAD_RIGHT)."\t".
            str_pad("INTERES", 12, " ", STR_PAD_RIGHT)."\t".
            str_pad("REEMBOLSO", 12, " ", STR_PAD_RIGHT)."\r\n\r\n";

        foreach($fCenDBs as $kk=>$vv)
        {
            $fID = $fCenDBs[$kk]['fiduciario_id'];
            if(($fC == 0 || $fC != $fID) && !array_key_exists($fID, $fiduciarios['fND']))
            {
                $fiduciarios['fND'][$fID] = ia_singleton("SELECT * FROM fiduciario WHERE fiduciario_id='$fID'");
                $fiduciarios['fND'][$fID]['contenedores_reembolsados'] = 0; //OJO. Es una columna virtual.
                $fiduciarios['fND'][$fID]['contenedores_cancelados'] = 0; //OJO. Es una columna virtual.
                $fiduciarios['sumaCont'][$fID]['Errores'] = ia_singleread("SELECT
                        SUM(CASE WHEN error='Si' THEN 1 ELSE 0 END) as Errores
                        FROM fiduciario_contenedor
                        WHERE fiduciario_id = '$fID'");
                //Por seguridad.
                if(empty($fiduciarios['sumaCont'][$fID]['Errores']))
                    $fiduciarios['sumaCont'][$fID]['Errores'] = 0;
                //echo "<pre>".print_r($fiduciarios[$fID],true)."</pre>";
            }

            $fC = $fID;

            if($vv['error'] == 'Si' || $vv['error'] == 'Tu')
            {
                $fiduciarios['fND'][$fID]['contenedores_cancelados']++;
            }
            else
            {
                $fiduciarios['fND'][$fID]['contenedores_reembolsados']++;
            }


            $remarksBCM.=   str_pad($fCenDBs[$kk]['numero_contenedor'], 13, " ", STR_PAD_RIGHT)."\t".
                str_pad($fCenDBs[$kk]['numero_pedimento'], 17, " ", STR_PAD_RIGHT)."\t".
                str_pad($fCenDBs[$kk]['numero_constancia'], 12, " ", STR_PAD_RIGHT)."\t".
                str_pad(echonf($fCenDBs[$kk]['monto_garantia'],true), 12, " ", STR_PAD_LEFT)."\t".
                str_pad(echonf($fCenDBs[$kk]['monto_intereses'],true), 12, " ", STR_PAD_LEFT)."\t".
                str_pad(echonf($fCenDBs[$kk]['monto_total_reembolsado'],true), 12, " ", STR_PAD_LEFT)."\r\n";
        }

        $cuantosFid = sizeof($fiduciarios['fND']);
        $tmpRemarks = "REEMBOLSO DE ".$cuantosFid." FIDUCIARIO".($cuantosFid>1?"S\r\n":"\r\n");

        //Preparo la explicación para el banco y los fiduciarios.
        foreach($fiduciarios['fND'] as $kkk=>$vvv)
        {
            $tmpRemarks.=   "MONTO ORIGINAL ".echonf($vvv['monto_retiro'],true);
            $tmpRemarks.=   " DEL DÍA ".strtoupper(get_date_spanish(strtotime($vvv['fecha_retiro']), false, 'small_date','month_mini'));
            $tmpRemarks.=   "\r\n(CONTENEDORES REEMBOLSADOS: ".($vvv['contenedores_reembolsados'] + $vvv['contenedores_cancelados'])." DE ".$vvv['contenedores'].")\r\n";
        }

        $remarksBCM = "$tmpRemarks" . PHP_EOL . "$remarksBCM";

        $txt_remarksBCM = strit($remarksBCM);

        $links=generaListadoLinksBCM($fRenDB['banco_cuenta_mov_id']);

        $txt_links=" ,detalle_links = ".strit($links);


        $poliza_contabilidad = genera_poliza_contabilidad_fiduciario($fRenDB, $remarksBCM);
        $txt_poliza_contabilidad = ", poliza_contabilidad = ".strit($poliza_contabilidad);

        $sql[]="UPDATE banco_cuenta_mov SET
            remarks = $txt_remarksBCM
            $txt_links
            $txt_poliza_contabilidad
            WHERE banco_cuenta_mov_id=".strit($fRenDB['banco_cuenta_mov_id']);

        $txt_remarksBCM = $links . $remarksBCM;
        $txt_remarksBCM = strit($txt_remarksBCM);

        $sql[]="UPDATE fiduciario_reembolso SET
            remarks = $txt_remarksBCM
            WHERE fiduciario_reembolso_id=".strit($fRenDB['fiduciario_reembolso_id']);
    }


    if($guarda)
    {
        ia_transaction($sql);
        ia_errores_a_dime();
    }
    else
        return $sql;
}

function actualizaFiduciariosAtrasados()
{
    global $gIAParametros;

    leeParametrosVitex();

    //Expirados con más de 175 días sin solicitud de reembolso.
    $sql1 = "SELECT COUNT(DISTINCT(fiduciario_id)) FROM fiduciario
            WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND terminado = 'No'
            AND solicitud_reembolso_fecha IS NULL
            OR fiduciario_id IN (
            SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL
            AND monto_reembolsado = 0
            AND monto_cancelado = 0 )";

    //Expirados con más de 175 días con solicitud de reembolso.
    $sql2 = "SELECT COUNT(DISTINCT(fiduciario_id)) FROM fiduciario
            WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND terminado = 'No'
            AND solicitud_reembolso_fecha IS NOT NULL
            OR fiduciario_id IN (
            SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND fiduciario_reembolso_id IS NULL
            AND solicitud_reembolso_fecha IS NOT NULL
            AND monto_reembolsado = 0
            AND monto_cancelado = 0 )";

    //Expirados con más de 178 días sin solicitud de reembolso.
    $sql3 = "SELECT COUNT(DISTINCT(fiduciario_id)) as ExpUrgente FROM fiduciario
            WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_flashear_tab_fiduciario]
            AND terminado = 'No'
            AND solicitud_reembolso_fecha IS NULL
            OR fiduciario_id IN (
            SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_flashear_tab_fiduciario]
            AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL
            AND monto_reembolsado = 0
            AND monto_cancelado = 0 )";

    //VCA 23-09-2021 Fiduciarios con Link sin revisar
    //$sql4 = "SELECT COUNT(bloqueado) FROM fiduciario WHERE bloqueado IN ('MODIFICADO','AMBOSMOD','CONTMOD')";
    $sql4 = "SELECT COUNT(bloqueado) FROM fiduciario WHERE fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE fiduciario_reembolso_id IS NOT NULL  AND bloqueado != 'CERRADO' )";
    $sql5 = "SELECT COUNT(error) FROM fiduciario WHERE error IN ('Si','Pa')";
    $sql6 = "SELECT COUNT(capturado) FROM fiduciario WHERE capturado IN ('No')";

    /** ** ** ** CONTENEDORES ** ** ** **/
    $sql7 = "SELECT COUNT(bloqueado) FROM fiduciario_contenedor WHERE bloqueado IN ('MODIFICADO','AMBOSMOD','CONTMOD')";
    $sql8 = "SELECT COUNT(error) FROM fiduciario_contenedor WHERE error IN ('Si','Pa')";
    $sql10 = "SELECT COUNT(fecha_retiro) FROM fiduciario_contenedor
        WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
        AND fiduciario_reembolso_id IS NULL
        AND solicitud_reembolso_fecha IS NULL
        AND monto_reembolsado = 0
        AND monto_cancelado = 0 ";
    $sql11 = "SELECT COUNT(fecha_retiro) FROM fiduciario_contenedor
        WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
        AND fiduciario_reembolso_id IS NULL
        AND solicitud_reembolso_fecha IS NOT NULL
        AND monto_reembolsado = 0
        AND monto_cancelado = 0 ";
    /** ** ** ** CONTENEDORES ** ** ** **/

    //Expirados con más de 175 días con solicitud de reembolso de hace más de 3 días.
    $sql12 = "SELECT COUNT(DISTINCT(fiduciario_id)) FROM fiduciario
            WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND terminado = 'No'
            AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > $gIAParametros[dias_despues_solicitar_reembolso]
            OR fiduciario_id IN (
            SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND fiduciario_reembolso_id IS NULL
            AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > $gIAParametros[dias_despues_solicitar_reembolso]
            AND monto_reembolsado = 0
            AND monto_cancelado = 0 )";

    //Expirados con más de 175 días con solicitud de reembolso de hace más de 3 días.
    $sql13 = "SELECT COUNT(fecha_retiro) FROM fiduciario_contenedor
            WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_solicitar_reembolso_fiduciario]
            AND fiduciario_reembolso_id IS NULL
            AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > $gIAParametros[dias_despues_solicitar_reembolso]
            AND monto_reembolsado = 0
            AND monto_cancelado = 0 ";

    //Expirados con más de 178 días sin solicitud de reembolso.
    $sql14 = "SELECT COUNT(fiduciario_id) FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > $gIAParametros[dias_para_flashear_tab_fiduciario]
            AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL
            AND monto_reembolsado = 0
            AND monto_cancelado = 0";


    $FidExp = ia_singleread($sql1);
    $FidExpSol = ia_singleread($sql2);
    $FidExpUrg = ia_singleread($sql3);
    $FidBloq = ia_singleread($sql4);
    $FidErr = ia_singleread($sql5);
    $FidCap = ia_singleread($sql6);

    $FidContBloq = ia_singleread($sql7);
    $FidContErr = ia_singleread($sql8);
    $FidContExp = ia_singleread($sql10);
    $FidContExpSol = ia_singleread($sql11);
    $FidContExpUrg = ia_singleread($sql14);

    $FidExpSolUrg = ia_singleread($sql12);
    $FidContExpSolUrg = ia_singleread($sql13);






    $sql = array();

    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidExp,    'expirados_sin_solicitud',  'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidExp";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidExpSol, 'expirados_con_solicitud',  'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidExpSol";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidExpUrg, 'expirados_urgentes',       'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidExpUrg";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidBloq,   'bloqueado',                'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidBloq";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidErr,    'error',                    'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidErr";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidCap,    'capturado',                'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidCap";

    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContBloq,       'bloqueado',                    'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContBloq";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContErr,        'error',                        'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContErr";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContExp,        'expirados_sin_solicitud',      'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContExp";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContExpSol,     'expirados_con_solicitud',      'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContExpSol";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidExpSolUrg,      'expirados_con_solicitud_urge', 'fiduciario') ON DUPLICATE KEY UPDATE valor=$FidExpSolUrg";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContExpSolUrg,  'expirados_con_solicitud_urge', 'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContExpSolUrg";
    $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $FidContExpUrg,     'expirados_urgentes',           'fiduciario_contenedor') ON DUPLICATE KEY UPDATE valor=$FidContExpUrg";

    /**
    $myFile = "actualizaFiduciariosAtrasados.txt";
    $fh = fopen($myFile, 'w') or die("can't open file");
    $bleh = "<pre>".print_r($sql, true)."</pre>";
    fwrite($fh, $bleh);
    fclose($fh);
     **/
    ia_transaction($sql);
}

function bloqueaFiduciarioContenedores($do='SI')
{
    global $gIAParametros;
    $sql=array();
    $ahora = new DateTime();
    $ahora->modify("-".$gIAParametros['tiempo_para_bloquear_contenedor_fiduciario']." hours");
    $fechaCapturados=$ahora->format('Y-m-d H:i:s');
    $sql[]="UPDATE fiduciario_contenedor SET puede_borrar='No' WHERE
        (fecha_capturado IS NOT NULL AND puede_borrar='Si' AND fecha_capturado<'$fechaCapturados') OR
        (fecha_capturado IS NULL AND puede_borrar='Si' AND numero_contenedor<>'' AND monto_garantia > 0 AND alta_db<'$fechaCapturados')";
    if($do=='SI')
    {
        if(ia_transaction($sql))
            ia_errores_a_dime();
        return true;
    }
    else
        return $sql;
}

function statusFiduciario($sF='',$sFC='',$cCM=0,$cualCambia='fiduciario')
{
    $matriz = array(
        'fiduciario'=>
            array(
                'ABIERTO'   =>array('ABIERTO'=>'ABIERTO',                     'CERRADO'=>'CERRADO',                     'MODIFICADO'=>'MODIFICADO'),
                'CERRADO'   =>array('ABIERTO'=>'ABIERTO',                     'CERRADO'=>'CERRADO',                     'MODIFICADO'=>'MODIFICADO'),
                'MODIFICADO'=>array('ABIERTO'=>'ABIERTO',                     'CERRADO'=>'CERRADO',                     'MODIFICADO'=>'MODIFICADO'),
                'AMBOSMOD'  =>array('ABIERTO'=>array('ABIERTO','CONTMOD'),    'CERRADO'=>array('CERRADO','CONTMOD'),    'MODIFICADO'=>array('MODIFICADO','AMBOSMOD')),
                'CONTMOD'   =>array('ABIERTO'=>array('ABIERTO','CONTMOD'),    'CERRADO'=>array('CERRADO','CONTMOD'),    'MODIFICADO'=>array('MODIFICADO','AMBOSMOD'))
            ),
        'fiduciario_contenedor'=>
            array(
                'ABIERTO'   =>array('ABIERTO'=>'ABIERTO',                     'CERRADO'=>'ABIERTO',                     'MODIFICADO'=>'CONTMOD'),
                'CERRADO'   =>array('ABIERTO'=>'CERRADO',                     'CERRADO'=>'CERRADO',                     'MODIFICADO'=>'CONTMOD'),
                'MODIFICADO'=>array('ABIERTO'=>'MODIFICADO',                  'CERRADO'=>'MODIFICADO',                  'MODIFICADO'=>'AMBOSMOD'),
                'AMBOSMOD'  =>array('ABIERTO'=>array('MODIFICADO','AMBOSMOD'),'CERRADO'=>array('MODIFICADO','AMBOSMOD'),'MODIFICADO'=>'AMBOSMOD'),
                'CONTMOD'   =>array('ABIERTO'=>array('ABIERTO','CONTMOD'),    'CERRADO'=>array('ABIERTO','CONTMOD'),    'MODIFICADO'=>'CONTMOD')
            )
    );


    if($cCM > 0)
        $cCM = 1;
    else
        $cCM = 0;

    /**
    echo "<br/>sF:$sF";
    echo "<br/>sFC:$sFC";
    echo "<br/>cCM:$cCM";
    echo "<br/>cualCambia:$cualCambia";
     **/

    //El segundo valor es error $sF porque quiere decir que mandaron datos erroneos.
    $status = array_key_exists($sF,$matriz[$cualCambia]) && array_key_exists($sFC,$matriz[$cualCambia][$sF]) ? $matriz[$cualCambia][$sF][$sFC] : $sF;

    $status = is_array($status) ? $matriz[$cualCambia][$sF][$sFC][$cCM] : $status;

    return $status;
}

/** Genera una genera_poliza_contabilidad_fiduciario.
 * @param array $fiduciario
 * @return string
 */
function genera_poliza_contabilidad_fiduciario(array $fiduciario, $remarks_set = ''): string
{
    $poliza_contabilidad = "";

    if(empty($fiduciario))
        return $poliza_contabilidad;

    $fID = $fiduciario['fiduciario_id'] ?? '';
    if (empty($fID))
        return $poliza_contabilidad;

    if (empty($remarks_set))
        return $poliza_contabilidad;

    if (str_contains($remarks_set, 'RETIRO POR FIDUCIARIO')) {
        $string = preg_replace('/<strong[^>]*>RETIRO POR FIDUCIARIO<\/strong>/i', '$1', $remarks_set);
        $string = preg_replace('/<br \/>RETIRO POR FIDUCIARIO/i', '$1<br/><br/>RETIRO POR FIDUCIARIO', $string);
    }
    if (str_contains($remarks_set, 'HONORARIOS FIDUCIARIO')) {
        $string = preg_replace('/<strong[^>]*>HONORARIOS FIDUCIARIO<\/strong>/i', '$1', $remarks_set);
        $string = preg_replace('/<br \/>HONORARIOS FIDUCIARIO/i', '$1<br/><br/>HONORARIOS FIDUCIARIO', $string);
    }
    return trim($string);

    /* $fiduciario_contenedores = ia_sqlArrayIndx("SELECT * FROM fiduciario_contenedor WHERE fiduciario_id = '$fID'");
        
    $poliza_contabilidad =   "\r\n#####\r\n".
        str_pad("CONTENEDOR", 13, " ", STR_PAD_RIGHT)."\t".
        str_pad("PEDIMENTO", 17, " ", STR_PAD_RIGHT)."\t".
        str_pad("CONSTANCIA", 12, " ", STR_PAD_RIGHT)."\t".
        str_pad("MONTO", 12, " ", STR_PAD_RIGHT)."\r\n\r\n";

    foreach($fiduciario_contenedores as $fiduciario_contenedor)
    {
        $poliza_contabilidad.=
                    str_pad($fiduciario_contenedor['numero_contenedor'], 13, " ", STR_PAD_RIGHT)."\t".
                    str_pad($fiduciario_contenedor['numero_pedimento'], 17, " ", STR_PAD_RIGHT)."\t".
                    str_pad($fiduciario_contenedor['numero_constancia'], 12, " ", STR_PAD_RIGHT)."\t".
                    str_pad(echonf($fiduciario_contenedor['monto_garantia'],true), 12, " ", STR_PAD_LEFT)."\r\n";
    }

    $banco_destino = $fiduciario['banco_destino'] ?? '';
    if($banco_destino == "BBVA")
        $banco_destino = "BBVA MÉXICO SA";
    elseif($banco_destino == "MONEX")
        $banco_destino = "MONEX GRUPO FINANCIERO SA DE CV";
    elseif($banco_destino == "HSBC")
        $banco_destino = "HSBC MÉXICO SA";

    return trim($poliza_contabilidad); */
}