<?php

/**
 * cuenta_banco_mov_options()
 * Trae <option >...</option> de cuentas de banco puede el usuario accesar
 * @param string $h e,a permiso de editar otro leer de leer
 * @param null|false $selected que opcion esta preseleccionada
 * @param bool $todas Muestra todas las cuentas sin importar qué
 * @param string $moneda_id moneda de las cuentas bancarias: 1 = Pesos, 2 = USD
 * @param array|null $b_id array de cuentas a elegir //era banco
 * @param bool $conChina Agrega o no los bancos de china
 * @param null|true $select
 * @param bool $linkalBanco
 * @param bool|string $sinRony Agrega o no la cuenta de Rony (ahora agrega o no las cuentas Privadas)
 * @return
 */
function cuenta_banco_mov_options(string $h='r', bool|null $selected=false, bool $todas=false, string $moneda_id='1', ?array $b_id=null, bool $conChina=false, bool|null $select=true, bool $linkalBanco=false, bool|string $sinRony=false) {
    // return ia_SqlOptions(  cuenta_banco_mov_list_sql($h,$todas,$moneda_id),$selected);

    //echo cuenta_banco_mov_list_sql($h,$todas,$moneda_id,$b_id,$conChina,$select,$linkalBanco);
    if($select)
        return ia_OptionsSetData( ia_sqlArray( cuenta_banco_mov_list_sql($h,$todas,$moneda_id,$b_id,$conChina,$select,$linkalBanco, $sinRony),'banco_cuenta_id'),$selected);
    else
    {
        //return ia_sqlArray(cuenta_banco_mov_list_sql($h,$todas,$moneda_id,$b_id,$conChina,$select),'banco_cuenta_id');
        return ia_sqlArrayIndx(cuenta_banco_mov_list_sql($h,$todas,$moneda_id,$b_id,$conChina,$select,$linkalBanco, $sinRony));
    }
}

/**
 * cuenta_banco_mov_list_sql()
 * Sql con cuentas de banco puede usar el usuario segun $h para estado de cuenta principal
 * @param string $h $h e,a permiso de editar otro leer de leer
 * @param mixed|null $b_id array de cuentas a elegir //era banco
 * @param bool $conChina Agrega o no los bancos de china
 * @param mixed|true $select
 * @param bool $linkalBanco
 * @param bool|string $sinRony Agrega o no la cuenta de Rony
 *@return sql con banco_cuenta_id, nombre de la cuenta unicamente las que puede ver el usuario para movimientos del estado de cuenta principal
 */
function cuenta_banco_mov_list_sql(string $h, $todas=false, $moneda_id='1', mixed $b_id=null, bool $conChina=false, mixed $select=true, bool $linkalBanco=false, bool|string $sinRony=false, string $order_by = " bc.nombre ASC ", $strict_parameters = false) {
    $conChina = empty($conChina) ? false : true;

    $join_empresa_banco = " LEFT JOIN empresa e on bc.empresa_id = e.empresa_id LEFT JOIN banco b on bc.banco_id = b.banco_id ";
    if($conChina)
        $conChina = usuarioTipoRony($_SESSION['usuario_id']) ? " (bc.banco_china='Si') " : " (bc.banco_china='Si' AND u.puede_banco_china='Si') ";
    else
        $conChina = " bc.banco_china='No' ";
    if(!$strict_parameters && (usuarioTipoRony($_SESSION['usuario_id']) || $todas)) //Abusado aqui con el usuario tipo Rony.
    {
        //$puede=" FORCE INDEX (con_china) JOIN iac_usr u ON u.iac_usr_id = $_SESSION[usuario_id] WHERE bc.vale='Active' ";
        $puede=" FORCE INDEX (con_china) $join_empresa_banco WHERE bc.vale='Active' ";
        //$puede .= " AND ( $conChina  OR $_SESSION[usuario_id]=1 ) ";
        if(!$todas)
            $puede .= " AND ( $conChina ) ";
    }
    else{
        if($linkalBanco)
            $puede = " $join_empresa_banco WHERE bc.vale='Active' ";
        else
            $puede=" FORCE INDEX (con_china) $join_empresa_banco
            JOIN banco_cuenta_mov_plantilla bcu ON bc.banco_cuenta_id=bcu.banco_cuenta_id
            JOIN plantilla p ON bcu.plantilla_id=p.plantilla_id
            JOIN iac_usr u ON u.plantilla_id=p.plantilla_id
            WHERE bc.vale='Active' AND bcu.puede<>'Nada' AND  iac_usr_id=".strit($_SESSION['usuario_id'])." AND ( $conChina  ) ";
        /**
        if($linkalBanco)
        $cualPermiso = " bcu.puede IN ('L/O', 'R/W') "; //CREO que hace falta L/R link and read. R/W tiene implicito el link. OJO VCA 26-SEP-2020 aquí continúas. comentar y no usar por el momento puedeCuentaBancaria().
        else
        $cualPermiso = " bcu.puede<>'Nada' ";

        $puede=" FORCE INDEX (con_china)
        JOIN banco_cuenta_mov_plantilla bcu ON bc.banco_cuenta_id=bcu.banco_cuenta_id
        JOIN plantilla p ON bcu.plantilla_id=p.plantilla_id
        JOIN iac_usr u ON u.plantilla_id=p.plantilla_id
        WHERE bc.vale='Active' AND $cualPermiso AND  iac_usr_id=".strit($_SESSION['usuario_id'])." AND ( $conChina  ) ";
         * * **/
    }
    if($moneda_id == 0)
        $moneda_id = "";
    else
        $moneda_id = " AND bc.moneda_id='$moneda_id' ";

    if(empty($b_id))
        $b_id = "";
    else
    {
        if(is_array($b_id))
        {
            $b_idTmp = '';
            foreach($b_id as $k=>$v)
                $b_idTmp .= "'$v',";
            $b_idTmp = substr($b_idTmp,0,-1);
            //$b_id = " AND bc.banco_id IN ($b_idTmp) ";
            $b_id = " AND bc.banco_cuenta_id IN ($b_idTmp) ";
        }
        else
            $b_id = " AND bc.banco_cuenta_id='$b_id' ";
        //$b_id = " AND bc.banco_id='$b_id' ";
    }

    if($sinRony === false)
        $sinRony = "";
    else if($sinRony === true)
        $sinRony = " AND bc.tipo_inversion_empresa_privada NOT IN ('privada') "; // VCA 27 Marzo 2023: ocupo el campo tipo_inversion_empresa_privada=empresa para saber si la cuenta es de Rony o no.
    else if($sinRony === 'SOLORONY')
        $sinRony = " AND bc.tipo_inversion_empresa_privada IN ('privada') ";


    $autocompleteTag = "";
    if(!$select)
        $autocompleteTag = " ,bc.nombre as label, bc.nombre as value ";
    //echo "SELECT /* vitex.php banco_cuenta_mov_list_sql */ bc.banco_cuenta_id, bc.nombre,banco_id FROM banco_cuenta bc $puede ORDER BY bc.orden, bc.nombre";
    $sql = "SELECT /* vitex.php banco_cuenta_mov_list_sql */
    bc.banco_cuenta_id,
    bc.nombre,
    bc.banco_id as banco,
    bc.banco_id ,
    bc.moneda_id,
    bc.numero,
    bc.empresa_id,
    bc.banco_china,
    bc.tipo_inversion_empresa_privada,
    bc.ingresar_depositos,
    bc.ingresar_depositos,
    b.banco,
    e.empresa
    $autocompleteTag
    FROM banco_cuenta bc $puede $moneda_id $b_id $sinRony ORDER BY /* bc.orden, */ $order_by";


    return $sql;
}

/**
 * cuenta_banco_mov_verifica_options()
 *
 * @param string $h $h e,a permiso de editar otro leer de leer
 * @param mixed $selected
 * @return
 */
function cuenta_banco_mov_verifica_options($h,$selected,$todas=false,$moneda_id='1') {
    return ia_SqlOptions(  cuenta_banco_mov_verifica_list_sql($h,$todas,$moneda_id),$selected);
}

/**
 * cuenta_banco_mov_verifica_list_sql()
 * Sql con cuentas de banco puede usar el usuario segun $h para verificar estado de cuenta
 * @param string $h $h e,a permiso de editar otro leer de leer
 * @return string Sql con cuentas de banco puede usar el usuario segun $h para verificar estado de cuenta
 */
function cuenta_banco_mov_verifica_list_sql($h,$todas=false,$moneda_id='1') {
    if(usuarioTipoRony($_SESSION['usuario_id']))
        $puede="  WHERE bc.vale='Active' ";
    //elseif($h=='e' || $h=='a')     // editar
    //$puede=" JOIN mov_verificado_plantilla bcu ON bc.banco_cuenta_id=bcu.banco_cuenta_id JOIN plantilla p ON bcu.plantilla_id=p.plantilla_id JOIN iac_usr u ON u.plantilla_id=p.plantilla_id WHERE bcu.puede ='R/W' AND  iac_usr_id=".strit($_SESSION['usuario_id']);
    else            // consultar
        $puede=" JOIN mov_verificado_plantilla bcu ON bc.banco_cuenta_id=bcu.banco_cuenta_id JOIN plantilla p ON bcu.plantilla_id=p.plantilla_id JOIN iac_usr u ON u.plantilla_id=p.plantilla_id WHERE bc.vale='Active' AND bcu.puede<>'Nada' AND iac_usr_id=".strit($_SESSION['usuario_id']);

    if($moneda_id == 0)
        $moneda_id = "";
    else
        $moneda_id = " AND bc.moneda_id='$moneda_id' ";

    $sql2return = "SELECT /* vitex.php cuenta_banco_mov_verifica_list_sql */ bc.banco_cuenta_id, bc.nombre,banco_id , bc.moneda_id, bc.numero, bc.empresa_id, bc.banco_china
    FROM banco_cuenta bc $puede $moneda_id ORDER BY bc.orden, bc.nombre";

    //echo "<br/>$sql2return<br/>";

    return $sql2return;
}

function arreglaLinksPendientes($origenLPA="")
{
    return;
    global $gIAsql;

    $gIAsql['trace'] = true;

    $arrTablas = array(array('tabla'=>'deuda_pago','tipo'=>'egreso'), array('tabla'=>'cheque_pago','tipo'=>'ingreso'),
        array('tabla'=>'pagare_pago','tipo'=>'ingreso') );
    if(VALE_PAGO_MULTIPLE) {
        $arrTablas[] = ['tabla'=>'vale_pago','tipo'=>'ingreso'];

    }else {
        $arrTablas[] = array('tabla'=>'vale','tipo'=>'ingreso');
    }

    $fechaLPA = date("Y-m-d H:i:s");
    $campoBancoCuenta = '';
    $campoQuantity = 'quantity'; //Por los vales en donde usamos quantity_recibido;

    $usuario = $_SESSION['usuario'];

    foreach($arrTablas as $k=>$vTabla)
    {
        $tablaPcLP = $vTabla['tabla'];
        $tipoPcLP = $vTabla['tipo'];

        if($tablaPcLP == 'vale')
            $campoQuantity = 'quantity_recibido';

        $campoBancoCuenta = 'banco_cuenta_id';

        $sqlLP = "SELECT * FROM $tablaPcLP WHERE $campoBancoCuenta != 0 AND (banco_cuenta_mov_link_id = 'pendiente')"; // OR banco_cuenta_mov_link_id = ''
        //echo "$sqlLP<br/>";
        $arrPcLP = ia_sqlArrayIndx($sqlLP);



        if(is_array($arrPcLP)) foreach($arrPcLP as $kPcLP=>$vPcLP)
        {
            //echo "$vTabla[tipo]<br/>";
            //echo print_r($arrPcLP, true);
            $usuario = $vPcLP['alta_por'];
            $sql = array();
            $tienda_idPcLP = array_key_exists('tienda_id',$vPcLP) ? $vPcLP['tienda_id'] : '0';
            $fechaPcLP = array_key_exists('deposit_fecha',$vPcLP) ? $vPcLP['deposit_fecha'] : $vPcLP['fecha'];
            $fechaPcLP = date('Y-m-d', strtotime($fechaPcLP));
            $banco_cuenta_idPcLP = $vPcLP[$campoBancoCuenta];
            $ide_percentPcLP = $vPcLP['ide_percent'];
            $importe_originalPcLP = $vPcLP['quantity_total'];

            $bcm_id = '';
            $link_num_ref = '';
            $referencia = '';

            //Para datos de la factura
            $lb_ide_amountPcLP       = array_key_exists('ide_amount',$vPcLP) ? $vPcLP['ide_amount'] : '';
            $lb_ivacobradox100PcLP   = array_key_exists('ivacobradox100',$vPcLP) ? $vPcLP['ivacobradox100'] : '';
            $lb_ivacobradototalPcLP  = array_key_exists('ivacobradototal',$vPcLP) ? $vPcLP['ivacobradototal'] : '';
            $lb_numCashNotaPcLP      = array_key_exists('cash_nota_num',$vPcLP) ? $vPcLP['cash_nota_num'] : '';
            $lb_tienda_idPcLP        = $tienda_idPcLP;
            $lb_clientePcLP          = array_key_exists('cliente',$vPcLP) ? $vPcLP['cliente'] : '';
            $lb_tipoFacturaPcLP      = array_key_exists('factura',$vPcLP) ? $vPcLP['factura'] : '';
            $lb_numFacturaPcLP       = array_key_exists('factura_numero',$vPcLP) ? $vPcLP['factura_numero'] : '';
            $lb_empresa_idPcLP       = array_key_exists('empresa_id',$vPcLP) ? $vPcLP['empresa_id'] : '';
            $lb_tipo_cash_notaPcLP   = array_key_exists('tipo_cash_nota',$vPcLP) ? $vPcLP['tipo_cash_nota'] : '';
            $lb_cobra_ivaPcLP        = array_key_exists('cobra_iva',$vPcLP) ? $vPcLP['cobra_iva'] : '';
            $lb_iva_incluidoPcLP     = array_key_exists('iva_incluido',$vPcLP) ? $vPcLP['iva_incluido'] : '';
            $lb_cash_num_cobro_ivaPcLP     = array_key_exists('cash_num_cobro_iva',$vPcLP) ? $vPcLP['cash_num_cobro_iva'] : '';


            if($tipoPcLP == 'ingreso')
            {
                $withdrawalPcLP = 0.00;
                $depositPcLP = $vPcLP['deposit_total'];
            }
            else
            {
                $withdrawalPcLP = $vPcLP['deposit_total'];
                $depositPcLP = 0.00;
            }

            $arrInfoLink= SolicitaLinkBancario(
                array('link'=>$vPcLP[$tablaPcLP.'_id']
                ,'link_to'=>$tablaPcLP
                ,'tienda_id'=>$tienda_idPcLP
                ,'withdrawal'=>$withdrawalPcLP
                ,'deposit'=>$depositPcLP
                ,'cash'=>0
                ,'monto_acta'=>$importe_originalPcLP
                ,'fecha'=>$fechaPcLP
                ,'banco_mov_tipo_id'=>''
                ,'banco_cuenta_id'=>$banco_cuenta_idPcLP
                ,'idex100'=>$ide_percentPcLP
                ,'idetotal'=>$lb_ide_amountPcLP
                ,'factura'=>$lb_tipoFacturaPcLP
                ,'ivacobradox100'=>$lb_ivacobradox100PcLP
                ,'ivacobradototal'=>$lb_ivacobradototalPcLP
                ,'empresa_id'=>$lb_empresa_idPcLP
                ,'factura_numero'=>$lb_numFacturaPcLP
                ,'cash_nota_num'=>$lb_numCashNotaPcLP
                ,'cliente'=>$lb_clientePcLP
                ,'tipo_cash_nota'=>$lb_tipo_cash_notaPcLP
                ,'cobra_iva'=>$lb_cobra_ivaPcLP
                ,'cash_num_cobro_iva'=>$lb_cash_num_cobro_ivaPcLP
                ,'iva_incluido'=>$lb_iva_incluidoPcLP)
                ,$usuario);

            $updateFields = '';

            if( array_key_exists('link_id',$arrInfoLink) && $arrInfoLink['link_id']===FALSE)
            {
                $vPcLP['banco_cuenta_mov_link_id']='pendiente';
                $vPcLP['comentario'] .= "<li>LPA($fechaLPA): ". $arrInfoLink['mensaje'];

            }
            elseif(array_key_exists('link_id',$arrInfoLink))
            {
                $vPcLP['comentario'] = "Tenía LINK PENDIENTE, se arregló el $fechaLPA al $origenLPA.";
                $vPcLP['banco_cuenta_mov_link_id']=$arrInfoLink['link_id'];
                $updateFields = ", deposit_fecha = '$arrInfoLink[deposit_fecha]' ";

                $bcm_id = $arrInfoLink['bcm_id'];
                $link_num_ref = $arrInfoLink['ref_num'];
                $referencia = $arrInfoLink['referencia'];
            }
            //Update del aCuenta
            $sql[] = "UPDATE $tablaPcLP SET
                banco_cuenta_mov_link_id = '$vPcLP[banco_cuenta_mov_link_id]',
                numero_referencia = '$link_num_ref',
                referencia = '$referencia',
                comentario = '$vPcLP[comentario]',
                ultimo_cambio = '$fechaLPA',
                ultimo_cambio_por = '$usuario',
                fecha_capturado = '$fechaLPA',
                $updateFields
                WHERE ".$tablaPcLP.'_id'." = '".$vPcLP[$tablaPcLP.'_id']."'";

            //Insert del contramovimiento en cuentaT.

            if( array_key_exists('link_id',$arrInfoLink) &&  $arrInfoLink['link_id']!=FALSE)
            {
                // Leemos el primer movimiento en cuentaT.

                $arrcuentaT = ia_singleton("SELECT * FROM cuentat_mov WHERE origen_mov_id = '".$vPcLP[$tablaPcLP.'_id']."'");

                if(is_array($arrcuentaT)){

                    $cuentaT_mov_id=ia_guid();
                    $comentario="LINK BANCARIO, DEL " . $arrcuentaT['remarks'] ."<br/>REFERENCIA: <strong>$arrInfoLink[ref_num]</strong>.";
                    $ctaTMovIDOriginal = $arrcuentaT['cuentaT_mov_id'];
                    $appOrigen = $arrcuentaT['app_origen'];

                    $sql[]="UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_id' WHERE cuentaT_mov_id='$ctaTMovIDOriginal'";


                    if($tipoPcLP == 'ingreso')
                    {
                        $sql[]="INSERT INTO cuentat_mov(
                                cuentaT_mov_id
                                ,cuentaT_id
                                ,fecha
                                ,cuentaT_tipo_mov_id
                                ,egreso
                                ,quantity_total
                                ,moneda_id
                                ,tipo_cambio
                                ,banco_cuenta_id
                                ,referencia
                                ,remarks
                                ,banco_cuenta_mov_link_id
                                ,alta_por
                                ,ultimo_cambio_por
                                ,esta_en
                                ,alta_db
                                ,ultimo_cambio
                                ,tipo
                                ,origen_mov_id
                                ,contra_mov_id
                                ,app_origen)
                                VALUES(
                                '$cuentaT_mov_id'
                                ,'$arrcuentaT[cuentaT_id]'
                                ,'$fechaLPA'
                                ,".stritc($vPcLP['metodo_pago_id'])
                            .stritc($vPcLP[$campoQuantity])
                            .stritc($vPcLP['quantity_total'])
                            .stritc($vPcLP['moneda_id'])
                            .stritc($vPcLP['tipo_cambio'])
                            .stritc($vPcLP[$campoBancoCuenta])
                            .stritc(array_key_exists('referencia',$vPcLP) ? $vPcLP['referencia'] : '')
                            .stritc($comentario)
                            .stritc($arrInfoLink['link_id'])
                            .stritc($usuario)
                            .stritc($usuario)
                            ."'done'
                                ,'$fechaLPA'
                                ,'$fechaLPA'
                                ,'Egreso'
                                ,'$ctaTMovIDOriginal'
                                ,'$ctaTMovIDOriginal'
                                ,'$appOrigen')";
                    }
                    else
                    {
                        $sql[]="INSERT INTO cuentat_mov(
                                cuentaT_mov_id
                                ,cuentaT_id
                                ,fecha
                                ,cuentaT_tipo_mov_id
                                ,monto
                                ,quantity_total
                                ,moneda_id
                                ,tipo_cambio
                                ,banco_cuenta_id
                                ,referencia
                                ,remarks
                                ,banco_cuenta_mov_link_id
                                ,alta_por
                                ,ultimo_cambio_por
                                ,esta_en
                                ,alta_db
                                ,ultimo_cambio
                                ,tipo
                                ,origen_mov_id
                                ,contra_mov_id
                                ,app_origen)
                                VALUES(
                                '$cuentaT_mov_id'
                                ,'$arrcuentaT[cuentaT_id]'
                                ,'$fechaLPA'
                                ,".stritc($vPcLP['metodo_pago_id'])
                            .stritc($vPcLP[$campoQuantity])
                            .stritc($vPcLP['quantity_total'])
                            .stritc($vPcLP['moneda_id'])
                            .stritc($vPcLP['tipo_cambio'])
                            .stritc($vPcLP[$campoBancoCuenta])
                            .stritc(array_key_exists('referencia',$vPcLP) ? $vPcLP['referencia'] : '')
                            .stritc($comentario)
                            .stritc($arrInfoLink['link_id'])
                            .stritc($usuario)
                            .stritc($usuario)
                            ."'done'
                                ,'$fechaLPA'
                                ,'$fechaLPA'
                                ,'Ingreso'
                                ,'$ctaTMovIDOriginal'
                                ,'$ctaTMovIDOriginal'
                                ,'$appOrigen')";
                    }
                }
                generayGuardaaCuentasdeBancoMov($bcm_id);
            }
            if(ia_transaction($sql))
            {
                ia_errores_a_dime();

                if($gIAsql['trace'])
                    ia_errores_a_dime("sql_trace=".print_r($gIAsql['sql_trace'],true));
            }

            //echo "<pre>".print_r($sql, true)."</pre>";
        }
    }

    //Aquí arreglamos los links pendientes de transferencias bancarias.
    $sqlLP = "SELECT * FROM banco_cuenta_trans_pend";
    $arrPcLP = ia_sqlArrayIndx($sqlLP);

    if(is_array($arrPcLP)) foreach($arrPcLP as $kPcLP=>$vPcLP)
    {
        //Primero buscamos el movimiento original. Haremos una función mejor.
        $usuario = $vPcLP['alta_por'];
        $vPcLP['origen_fecha'] = date('Y-m-d', strtotime($vPcLP['origen_fecha']));
        $vPcLP['destino_fecha'] = date('Y-m-d', strtotime($vPcLP['destino_fecha']));
        $sqlo = "SELECT banco_cuenta_mov_id FROM banco_cuenta_mov WHERE banco_cuenta_id = '$vPcLP[origen_banco_cuenta_id]' AND link_vale NOT IN ('BL', 'LT', 'STOP') AND withdrawal = $vPcLP[monto] AND fecha LIKE '$vPcLP[origen_fecha]%' ORDER BY alta_db ASC LIMIT 1";
        //echo "<pre>$sqlo</pre>";
        $bcmo_id = ia_singleread($sqlo);

        $link_exitoso = false;

        if(!empty($bcmo_id) && strlen($bcmo_id) == 32) //Sí encontramos el primero, ahora solicitamos el link bancario.
        {
            //Solicitamos el link bancario. Si no es existoso, entonces lo ponemos pendiente.
            $arrInfoLink = SolicitaLinkBancario(
                array('link'=>$bcmo_id
                ,'link_to'=>'banco_cuenta_mov'
                ,'tienda_id'=>0
                ,'withdrawal'=>0
                ,'deposit'=>$vPcLP['monto']
                ,'cash'=>0
                ,'monto_acta'=>$vPcLP['monto']
                ,'fecha'=>$vPcLP['destino_fecha']
                ,'banco_mov_tipo_id'=>'5'
                ,'banco_cuenta_id'=>$vPcLP['destino_banco_cuenta_id']
                ,'idex100'=>0.00)
                ,$usuario);
            //echo "<pre>".print_r($arrInfoLink,true)."</pre>";
            if(!empty($arrInfoLink['link_id']))
            {
                $link_exitoso = true;
                $bcm_id = $arrInfoLink['bcm_id'];
            }
            else
            {
                $link_exitoso = false;
                $link_detalle = $arrInfoLink['mensaje'];
            }
        }

        if($link_exitoso)
        {
            //$refo = empty($vPcLP['referencia']) ? "TRANSFERENCIA A ".ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$vPcLP[destino_banco_cuenta_id]'") : $vPcLP['referencia'];
            //$refd = empty($vPcLP['referencia']) ? "TRANSFERENCIA DESDE ".ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$vPcLP[origen_banco_cuenta_id]'") : $BancoT->referencia;
            $ctaBancariaDestino = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$vPcLP[destino_banco_cuenta_id]'");
            $ctaBancariaOrigen = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$vPcLP[origen_banco_cuenta_id]'");

            $bcmoID = "&banco_cuenta_mov_id=$bcmo_id";
            $bcmID = "&banco_cuenta_mov_id=$bcm_id";

            $refo = "<br/>LINK A <a title='$ctaBancariaDestino' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$vPcLP[destino_banco_cuenta_id]$bcmID' target='_blank'><strong>$ctaBancariaDestino</strong></a>";
            $refd = "<br/>LINK DESDE <a title='$ctaBancariaOrigen' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$vPcLP[origen_banco_cuenta_id]$bcmoID' target='_blank'><strong>$ctaBancariaOrigen</strong></a>";

            $refo = addslashes($refo);
            $refd = addslashes($refd);

            $sql[] = "UPDATE banco_cuenta_mov SET
                usado = '$vPcLP[monto]',
                link_vale = 'LT',
                puede_editar = 'No',
                banco_mov_tipo_id = '18',
                remarks = '$refo',
                ultimo_cambio = CURRENT_TIMESTAMP,
                ultimo_cambio_por = '$usuario' WHERE banco_cuenta_mov_id = '$bcmo_id' LIMIT 1";
            $sql[] = "UPDATE banco_cuenta_mov SET remarks = '$refd', banco_mov_tipo_id = '18', ultimo_cambio = CURRENT_TIMESTAMP, ultimo_cambio_por = '$usuario' WHERE banco_cuenta_mov_id = '$bcm_id' LIMIT 1";
            $sql[] = "DELETE FROM banco_cuenta_trans_pend WHERE banco_cuenta_trans_pend_id = '$vPcLP[banco_cuenta_trans_pend_id]' LIMIT 1";
            $sql[] = "UPDATE banco_cuenta_trans SET
                activo='Si',
                puede_borrar='No',
                status='COMPLETA',
                banco_cuenta_mov_link_id='$arrInfoLink[link_id]',
                numero_referencia='$arrInfoLink[ref_num]',
                remarks='$refd',
                fecha_capturado = CURRENT_TIMESTAMP
                WHERE banco_cuenta_mov_link_id = '$vPcLP[banco_cuenta_trans_pend_id]'";

        }
        else
        {
            $sql[] = "UPDATE banco_cuenta_trans_pend SET ultimo_cambio = CURRENT_TIMESTAMP, ultimo_cambio_por = '$usuario' WHERE banco_cuenta_trans_pend_id = '$vPcLP[banco_cuenta_trans_pend_id]' LIMIT 1";
        }
        //echo "<pre>".print_r($sql,true)."</pre>";

        if(ia_transaction($sql))
        {
            ia_errores_a_dime();

            if($gIAsql['trace'])
                ia_errores_a_dime("sql_trace=".print_r($gIAsql['sql_trace'],true));
        }
    }


}

function links_pendientes($andWhere='',$orderby='')
{
    $usuario = $_SESSION['usuario'];
    $su = usuarioTipoRony($_SESSION['usuario_id']) ? true:false;
    $usuario_id = $_SESSION['usuario_id'];
    if($su)
        $where = "AND banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente'";
    else
        $where = "AND banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente' AND alta_por = '$usuario'";

    $arr=array();
    $sql="(SELECT cheque_pago_id AS id, cheque_id AS docto_id, '' AS docto, 'cheque' AS tipo, fecha, quantity, quantity_total, deposit_total, banco_cuenta_id, comentario AS comentario, alta_por as usuario, moneda_id as moneda, tipo_cambio as TC FROM cheque_pago WHERE banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente' $where)
        UNION (SELECT pagare_pago_id AS id, pagare_id AS docto_id, '' AS docto, 'pagare' AS tipo, fecha, quantity, quantity_total, deposit_total, banco_cuenta_id, comentario AS comentario, alta_por as usuario, moneda_id as moneda, tipo_cambio as TC FROM pagare_pago WHERE banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente' $where)
        UNION (SELECT vale_id AS id, vale_id AS docto_id, '' AS docto, 'vale' AS tipo,  fecha, quantity_recibido as quantity, quantity_total, deposit_total, banco_cuenta_id, comentario AS comentario, alta_por as usuario, moneda_id as moneda, tipo_cambio as TC FROM vale WHERE banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente' $where)
        UNION (SELECT deuda_pago_id AS id, deuda_id AS docto_id, '' AS docto, 'deuda' AS tipo, fecha, quantity, quantity_total, deposit_total, banco_cuenta_id, comentario AS comentario, alta_por as usuario, moneda_id as moneda, tipo_cambio as TC FROM deuda_pago WHERE banco_cuenta_id != '' AND banco_cuenta_mov_link_id = 'pendiente' $where)
        UNION (SELECT banco_cuenta_trans_pend_id AS id, origen_banco_cuenta_id AS docto_id, '' AS docto, 'banco_cuenta_mov' AS tipo, alta_db AS fecha, monto AS quantity, monto AS quantity_total, monto AS deposit_total, destino_banco_cuenta_id AS banco_cuenta_id, referencia AS comentario, alta_por as usuario, '' AS moneda, '1.00' AS TC FROM banco_cuenta_trans_pend) ORDER BY tipo, fecha";
    $lps=ia_sqlArray($sql,'id');
    if($lps) foreach($lps as $k=>$d) {
        $id=$k;
        $arr[$id]=array('id'=>$k,'docto'=>'','tipo'=>"<a title='Ir al documento' href='../backoffice/$d[tipo].php?iah=e&id=$d[docto_id]' target='_blank'>$d[tipo]</a>"
        ,'fecha'=>$d['fecha'], 'quantity'=>$d['quantity'],'quantity_total'=>$d['quantity_total']
        ,'deposit_total'=>$d['deposit_total'],'banco_cuenta_id'=>$d['banco_cuenta_id'],'comentario'=>$d['comentario']
        ,'usuario'=>$d['usuario'],'moneda'=>$d['moneda'],'TC'=>$d['TC']
        );
        switch ($d['tipo'])
        {
            case 'cheque':
                $arr[$id]['docto']=leeaCuenta('cheque_pago', $id, '', '', 'label', true);
                break;

            case 'pagare':
                $arr[$id]['docto']=leeaCuenta('pagare_pago', $id, '', '', 'label', true);
                break;

            case 'deuda':
                $arr[$id]['docto']=leeaCuenta('deuda_pago', $id, '', '', 'label', true);
                break;

            case 'vale':
                if(VALE_PAGO_MULTIPLE) {
                    $arr[$id]['docto']=leeaCuenta('vale_pago', $id, '', '', 'label', true);
                } else {
                    $arr[$id]['docto']=leeaCuenta('vale', $id, '', '', 'label', true);
                }
                break;

            case 'banco_cuenta_mov':
                $bco = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$d[docto_id]'");
                $bcd = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$d[banco_cuenta_id]'");

                $pbco = puedeCuentaBancaria('',$d['docto_id'],'R/O');
                $pbcd = puedeCuentaBancaria('',$d['banco_cuenta_id'],'R/O');

                if($pbco['puede'])
                    $lbco = "<a title='$bco' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$d[docto_id]' target='_blank'>$bco</a>";
                else
                    $lbco = "$bco";

                if($pbcd['puede'])
                    $lbcd = "<a title='$bcd' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$d[banco_cuenta_id]' target='_blank'>$bcd</a>";
                else
                    $lbcd = "$bcd";

                $arr[$id]['docto']="TRANSFERENCIA DE <strong>$lbco</strong> A <strong>$lbcd</strong> POR <strong>$ ".echonf($d['quantity'],true)."</strong>";
                $arr[$id]['tipo']="Transferencia Bancaria";
                break;

            default:
                $arr[$id]['docto']='Sin información.';
                break;
        }
    }
    return $arr;
}

function hazLabeldeDocto($acta_arr, $padre=false)
{
    $label = '';
    $label .= $acta_arr['actapadre_tiendaclv'] != '' ? $acta_arr['actapadre_tiendaclv'].', ' : '';
    $label .= $acta_arr['acta_desc'] != '' ? $acta_arr['acta_desc'].'' : ' ';
    $label .= $acta_arr['actapadre_number'] != '' ? ':'.$acta_arr['actapadre_number'].', ' : ', ';
    if($padre)
        $label .= $acta_arr['actapadre_quantity'] != '' ? '$'.number_format($acta_arr['actapadre_quantity'], 2, '.', ',') : '';
    else
        $label .= $acta_arr['acta_quantity'] != '' ? '<strong>$'.number_format($acta_arr['acta_quantity'], 2, '.', ',').'</strong>' : '';
    $label .= '.';
    $label .= $acta_arr['actapadre_nombre'] != '' ? '<br>'.$acta_arr['actapadre_nombre'] : '';
    $label .= $acta_arr['actapadre_nombre_cheque'] != '' ? '<br>'.'Cheque a nombre de: ' . BoldaString($acta_arr['actapadre_nombre_cheque']) : '';
    $label .= $acta_arr['acta_ctaTmov'] != '' ? '<br>'.$acta_arr['acta_ctaTmov'] : '';

    return $label;
}

function tablapadre($tablahija)
{
    switch($tablahija)
    {   case 'cuentat_mov':  case 'banco_cuenta_mov': case 'fiduciario_reembolso': case 'vale'://VCA 28-ene-2021 vale_pago case 'vale':
        return $tablahija;
        break;

        default:
            $arr = explode("_", $tablahija);
            return $arr[0];
            break;
    }

}

function leeaCuenta($link_to, $lid, $bcml_id='', $tienda_id='', $return='arr', $monto_padre=false): bool|array|string
{
    $acta_arr_def = array (	"acta_numero"	=>	"",
        "acta_fecha"	=>	"",
        "acta_quantity"	=>	0.00,
        "acta_alta_por"	=>	"",
        "acta_moneda"	=>	"",
        "acta_tipo_cambio"	=>	0.00,
        "acta_desc"	=>	"",
        "acta_comentario"	=>	"",
        "acta_id"	=>	"",
        "acta_ctaTmov"	=>	"",
        "actapadre_nombre"	=>	"",
        "actapadre_nombre_cheque"	=>	"",
        "actapadre_fecha"	=>	"",
        "actapadre_tienda"	=>	"",
        "actapadre_tiendaclv"	=>	"",
        "actapadre_remarks"	=>	"",
        "actapadre_number"	=>	"",
        "actapadre_quantity"	=>	0.00,
        "actapadre_total_payments"	=>	0.00,
        "actapadre_moneda"	=>	"",
        "actapadre_id"	=>	"",
        "actapadre"	=>	"",
        "acta_cuentat_id"	=>	"",
        "acta_banco_cuenta_id"	=>	"",
        "acta_deposit_total"	=>	0.00,
        "acta_app_origen"	=>	"",
        "remarks"	=>	"",
        "acta_quantity_total"	=>	0.00,
        "link_open" => "",
        "link_close" => "",
    );

    if(empty($link_to) || empty($lid))
        return $acta_arr_def;

    $acta_id = $lid;
    $acta_tbl = $link_to;
    $acta_id_nombre = $acta_tbl . '_id';
    $actapadre_tbl = tablapadre($acta_tbl);
    $actapadre_id_nombre = $actapadre_tbl . '_id';
    $actapadre_id = '';

    //Leer el a cuenta y su padre son comunes. Excepto para vales. Ahí no nos interesan los acuentas, sólo el padre.
    $sql = "SELECT * FROM $acta_tbl WHERE $acta_id_nombre = ". strit($acta_id);
    $acta_arr = ia_singleton($sql);

    //echo "<pre>sql: $sql<br>acta_arr: ".print_r($acta_arr, true)."</pre>";

    if(empty($acta_arr))
        if($link_to=='cuentat_mov')
            $acta_arr = ia_singleton("SELECT * FROM cuentat_a_banco WHERE banco_cuenta_mov_link_id = ". strit($bcml_id));

    if(empty($acta_arr))
        return false;
    //print_r($acta_arr);
    //echo "<br/>".$acta_tbl;
    $acta_arr_def['actapadre'] = $actapadre_tbl;


    //JOSE toma el control 28-ene-2021

    if($acta_tbl == 'vale' || $acta_tbl == 'VALE')
    {
        $actapadre_arr = $acta_arr;
        $actapadre_id = array_key_exists($acta_tbl.'_id',$acta_arr) ? $acta_arr[$acta_tbl.'_id'] : 'N/A';
    }
    else
    {
        $actapadre_id = array_key_exists($actapadre_id_nombre,$acta_arr) ? $acta_arr[$actapadre_id_nombre] : 'N/A';
        $sql = "SELECT * FROM $actapadre_tbl WHERE $actapadre_id_nombre = ". strit($actapadre_id);
        $actapadre_arr = ia_singleton($sql);
    }

    // echo "<pre><br>: ".print_r($acta_arr_def, true)."</pre>";
    // echo "<pre>sql: $sql<br>actapadre_arr: ".print_r($actapadre_arr, true)."</pre>";

    //Llenamos los datos del a cuenta. Estos son comunes a todos.

    $acta_arr_def['acta_fecha'] = array_key_exists('fecha',$acta_arr) ? ia_htmlentities(date('d-m-Y', strtotime($acta_arr['fecha']))) : '';

    //Monto que afectó a la Cuenta T
    if(array_key_exists('quantity_ctat',$acta_arr))
        $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['quantity_ctat']);
    elseif(array_key_exists('quantity',$acta_arr))
        $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['quantity']);
    elseif(array_key_exists('monto',$acta_arr) && !empty($acta_arr['monto']))
        $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['monto']);

    //Monto Total, monto bruto, sin tomar en cuenta comisiones
    if(array_key_exists('quantity_total',$acta_arr))
        $acta_arr_def['acta_quantity_total'] = ia_htmlentities($acta_arr['quantity_total']);
    else
        $acta_arr_def['acta_quantity_total'] = $acta_arr_def['acta_quantity'];

    //Monto del depósito
    if(array_key_exists('deposit_total',$acta_arr))
        $acta_arr_def['acta_deposit_total'] = ia_htmlentities($acta_arr['deposit_total']);
    elseif(array_key_exists('deposit',$acta_arr))
    {
        if($acta_arr['deposit'] > 0)
            $acta_arr_def['acta_deposit_total'] = ia_htmlentities($acta_arr['deposit']);
        else
            $acta_arr_def['acta_deposit_total'] = ia_htmlentities($acta_arr['withdrawal']);
    }

    //Monto
    if($link_to == 'cuentat_mov')
    {
        if($acta_arr['tipo'] == 'Egreso')
            $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['egreso']);
        else
            $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['monto']);
        $actapadre_tbl = ''; //Rony pidió que se quitara el 29-12-2015 $actapadre_tbl = 'LINK DE CUENTA T'


        $link_open="<a href='../backoffice/cuentat_a_banco_list.php?cuentat_a_banco_id=$acta_arr[origen_mov_id]' target='_blank'>";
        $acta_arr_def['link_open'] = $link_open;
        $acta_arr_def['link_close'] = "</a>";
    }
    elseif($link_to == 'banco_cuenta_mov')
    {
        $acta_arr_def['acta_quantity'] = ia_htmlentities($acta_arr['withdrawal']);
        $acta_arr_def['acta_deposit_total'] = $acta_arr_def['acta_quantity_total'] = $acta_arr_def['acta_quantity'];
        $actapadre_tbl = 'TRANSFERENCIA ENTRE CUENTAS';

        $link_open="<a href='../cobranza/edocta.php?banco_cuenta_mov_id=$acta_arr[banco_cuenta_mov_id]' target='_blank'>";
        $acta_arr_def['link_open'] = $link_open;
        $acta_arr_def['link_close'] = "</a>";
    }

    $acta_arr_def['acta_alta_por'] = array_key_exists('alta_por',$acta_arr) ? ia_htmlentities($acta_arr['alta_por']) : 'N/A';
    $acta_arr_def['acta_moneda'] = array_key_exists('moneda_id',$acta_arr) ? ia_htmlentities(ia_singleread("SELECT moneda FROM moneda WHERE moneda_id = ". strit($acta_arr['moneda_id']))) : 'N/A';
    $acta_arr_def['acta_tipo_cambio'] = array_key_exists('tipo_cambio',$acta_arr) ? ia_htmlentities($acta_arr['tipo_cambio']) : 'N/A';
    $acta_arr_def['acta_desc'] = strtoupper($actapadre_tbl);
    $acta_arr_def['acta_id'] = $acta_id;

    $acta_arr_def['acta_app_origen'] = array_key_exists('app_origen',$acta_arr) ? ia_htmlentities($acta_arr['app_origen']) : 'N/A';

    if($link_to === 'cheque_pago' || $link_to === 'pagare_pago' || (VALE_PAGO_MULTIPLE && $link_to === 'vale_pago'))
        $acta_arr_def['acta_numero'] = array_key_exists('numero',$acta_arr) ? 'A CUENTA # '.ia_htmlentities($acta_arr['numero']) : '';

    if($link_to == 'banco_cuenta_mov')
        $acta_arr_def['acta_moneda'] = '';

    // JJ 29-01-2021
    // Aata comentario otiginal
    /* if(array_key_exists('comentario',$acta_arr))
        $acta_arr_def['acta_comentario'] = ia_htmlentities($acta_arr['comentario']);
    else if(array_key_exists('remarks',$acta_arr))
        $acta_arr_def['acta_comentario'] = ia_htmlentities($acta_arr['remarks']); */
    if(array_key_exists('comentario',$acta_arr)) {
        $comentario = '';
        if ($link_to === 'cheque_pago') {
            $link_open = "<a href='../backoffice/cheque.php?iah=e&id=$actapadre_arr[cheque_id]' target='_blank'>";
            $comentario = "$link_open Ir al Cheque #$actapadre_arr[numero]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } elseif ($link_to === 'pagare_pago') {
            $link_open = "<a href='../backoffice/pagare.php?iah=e&id=$actapadre_arr[pagare_id]' target='_blank'>";
            $comentario = "$link_open Ir al Pagaré #$actapadre_arr[numero]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } elseif ($link_to === 'vale_pago' || $link_to === 'vale') { //VCA Compatibilidad con el vale anterior.
            $link_open = "<a href='../backoffice/vale.php?iah=e&id=$actapadre_arr[vale_id]' target='_blank'>";
            $comentario = "$link_open Ir al Vale #$actapadre_arr[vale_number]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } else {
            $comentario = ia_htmlentities($acta_arr['comentario']);
        }
        $acta_arr_def['acta_comentario'] = $comentario;
    } elseif (array_key_exists('remarks',$acta_arr)) {
        $comentario = '';
        if ($link_to === 'cheque_pago') {
            $link_open = "<a href='../backoffice/cheque.php?iah=e&id=$actapadre_arr[cheque_id]' target='_blank'>";
            $comentario = "$link_open Ir al Cheque #$actapadre_arr[numero]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } elseif ($link_to === 'pagare_pago') {
            $link_open = "<a href='../backoffice/pagare.php?iah=e&id=$actapadre_arr[pagare_id]' target='_blank'>";
            $comentario = "$link_open Ir al Pagaré #$actapadre_arr[numero]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } elseif ($link_to === 'vale_pago' || $link_to === 'vale') { //VCA Compatibilidad con el vale anterior.
            $link_open = "<a href='../backoffice/vale.php?iah=e&id=$actapadre_arr[vale_id]' target='_blank'>";
            $comentario = "$link_open Ir al Vale #$actapadre_arr[vale_number]</a>";
            $acta_arr_def['link_open'] = $link_open;
            $acta_arr_def['link_close'] = "</a>";
        } else {
            $comentario = ia_htmlentities(isset($acta_arr['comentario']) ? $acta_arr['comentario'] : '');
        }
        $acta_arr_def['acta_comentario'] = $comentario;
    }


    if($link_to == 'banco_cuenta_mov')
        $acta_arr_def['acta_comentario'] = $acta_arr['remarks'];

    if($actapadre_id == '' || $actapadre_id == NULL)
        $acta_tbl = 'link_manual';

    switch($acta_tbl)
    {
        case 'cheque_pago':

            //Vamos a calcular el nombre en el Cheque.
            if(array_key_exists('cliente_id',$actapadre_arr)) if($actapadre_arr['cliente_id'] != '')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cliente_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id']))) : 'N/A';
            else if($actapadre_arr['cliente_proveedor_id'] != '')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cliente_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id']))) : 'N/A';
            else if($actapadre_arr['nombre'] != '') //El campo nombre está vacío, entonces hay que buscar al cliente o proveedor.
                $acta_arr_def['actapadre_nombre'] = array_key_exists('nombre',$actapadre_arr) ? ia_htmlentities($actapadre_arr['nombre']) : 'N/A';
            else
                $acta_arr_def['actapadre_nombre'] = 'Este cheque no tiene asociado ning&uacuten Cliente o Proveedor, ni tiene establecido un nombre.';

            if(array_key_exists('name_on_check',$actapadre_arr) && $actapadre_arr['name_on_check'] != 'Same as client')
                $acta_arr_def['actapadre_nombre_cheque'] = array_key_exists('nombre',$actapadre_arr) ? ia_htmlentities($actapadre_arr['nombre']) : 'N/A';

            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('original_date',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['original_date']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('numero',$actapadre_arr) ? ia_htmlentities($actapadre_arr['numero']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';
            $acta_arr_def['actapadre_moneda'] = array_key_exists('moneda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT moneda FROM moneda WHERE moneda_id = ". strit($actapadre_arr['moneda_id']))) : 'N/A';

            $acta_arr_def['acta_app_origen'] = 'A Cuenta Cheque';

            //Extra para saber si hay un registro en la cuentaT

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Sí hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['acta_ctaTmov'] .= 'Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true) . '</b>';
            }

            break;

        case 'nota_pago':


            //Vamos a calcular el nombre en el Cheque.
            if(array_key_exists('cliente_id',$actapadre_arr)) if($actapadre_arr['cliente_id'] != '')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cliente_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id']))) : 'N/A';
            else
                $acta_arr_def['actapadre_nombre'] = 'Esta nota no tiene asociado ning&uacuten Cliente o Proveedor, ni tiene establecido un nombre.';

            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('fecha',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['fecha']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('nota_number',$actapadre_arr) ? ia_htmlentities($actapadre_arr['nota_number']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('total_quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Si hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['actapadre_remarks'] .= '<br>Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true). '</b>';
            }

            break;

        case 'pagare_pago':

            //Vamos a calcular el nombre en el Cheque.
            if(array_key_exists('cliente_id',$actapadre_arr)) if($actapadre_arr['cliente_id'] != '')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cliente_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id']))) : 'N/A';
            else
                $acta_arr_def['actapadre_nombre'] = 'Este pagaré no tiene asociado ning&uacuten Cliente o Proveedor, ni tiene establecido un nombre.';

            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('fecha',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['fecha']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('numero',$actapadre_arr) ? ia_htmlentities($actapadre_arr['numero']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';
            $acta_arr_def['actapadre_moneda'] = array_key_exists('moneda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT moneda FROM moneda WHERE moneda_id = ". strit($actapadre_arr['moneda_id']))) : 'N/A';

            $acta_arr_def['acta_app_origen'] = 'A Cuenta Pagare';

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Si hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['actapadre_remarks'] .= '<br>Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true) . '</b>';
            }

            break;

        case 'link_manual':
            $acta_arr_def['actapadre_nombre'] = array_key_exists('acta_comentario',$actapadre_arr) ? $acta_arr_def['acta_comentario'] : 'N/A';
            $acta_arr_def['actapadre_tienda'] = ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($tienda_id)));
            $acta_arr_def['actapadre_tiendaclv'] = ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($tienda_id)));
            break;

        case 'cuentat_mov':

            //Vamos a leer datos de la CuentaT.
            if(array_key_exists('app_origen',$acta_arr) && $acta_arr['app_origen'] == 'Link Tarjetas de Credito')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cuentaT_id',$acta_arr) ? 'Link Tarjetas de Cr&eacutedito por parte de <b>' . propdeCtaT($acta_arr['cuentaT_id'],'usuario',true) . '</b>' : 'N/A';
            else
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cuentaT_id',$acta_arr) ? 'Dep&oacutesito de <b>' . propdeCtaT($acta_arr['cuentaT_id'],'usuario',true) . '</b>' : 'N/A'; //Rony pidió el cambio el 29-12-2015
            //$acta_arr_def['actapadre_nombre'] .= array_key_exists('cuentaT_tipo_mov_id',$acta_arr) ? '<br>Tipo de dep&oacutesito: <b>' . ia_htmlentities(ia_singleread("SELECT tipo FROM banco_mov_tipo WHERE banco_mov_tipo_id = ". strit($acta_arr['cuentaT_tipo_mov_id']))) . '</b>' : 'N/A';
            $acta_arr_def['actapadre_nombre'] .= (array_key_exists('tipo_cambio',$acta_arr) && is_numeric($acta_arr['tipo_cambio']) && $acta_arr['tipo_cambio'] > 1) ? '<br/>Tipo de Cambio: <b>'. echonf($acta_arr['tipo_cambio'], true).'</b>' : '';
            $acta_arr_def['acta_cuentat_id'] = array_key_exists('cuentaT_id',$acta_arr) ? $acta_arr['cuentaT_id']:null;
            $acta_arr_def['acta_app_origen'] = 'Link de CuentaT';

            $link_arr = ia_singleton("SELECT * FROM cuentat_a_banco WHERE banco_cuenta_mov_link_id = ". strit($acta_arr['banco_cuenta_mov_link_id']));

//            exit;
            //VCA 9-Nov-2023 Agrego el texto en dolares
        $moneda_banco_id=ia_singleread("SELECT moneda_id FROM banco_cuenta WHERE banco_cuenta_id = ". strit($acta_arr['banco_cuenta_id']));

        if($moneda_banco_id == 2 /*&& $acta_arr['afecta_cuentat'] ?? 'SI' == 'NO' && $acta_arr['factura'] ?? '' == 'DEVOLUCION'*/){
            $acta_arr_def['acta_moneda'] = 'USD';
        }
//            echo "<pre><br>: ".print_r($acta_arr_def, true)."</pre>";


            $acta_arr_def['acta_id'] = array_key_exists('cuentat_a_banco_mov_id',$link_arr) ? $link_arr['cuentat_a_banco_mov_id']:null;
            break;

        case 'vale_pago':
            //Vamos a calcular el nombre en el Vale.
            if(array_key_exists('cliente_id',$actapadre_arr)) if($actapadre_arr['cliente_id'] != '')
                $acta_arr_def['actapadre_nombre'] = array_key_exists('cliente_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id']))) : 'N/A';
            else
                $acta_arr_def['actapadre_nombre'] = 'Este vale no tiene asociado ning&uacuten Cliente o Proveedor, ni tiene establecido un nombre.';

            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('fecha',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['fecha']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('vale_number',$actapadre_arr) ? ia_htmlentities($actapadre_arr['vale_number']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';
            $acta_arr_def['actapadre_moneda'] = array_key_exists('moneda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT moneda FROM moneda WHERE moneda_id = ". strit($actapadre_arr['moneda_id']))) : 'N/A';

            $acta_arr_def['acta_app_origen'] = 'A Cuenta Vale';

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Si hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['actapadre_remarks'] .= '<br>Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true) . '</b>';
            }
            break;

        case 'vale':

            //Vamos a calcular el nombre en el Cheque.
            //print_r($actapadre_arr);
            if(array_key_exists('cliente_id',$actapadre_arr) && !empty($actapadre_arr['cliente_id']))
                $acta_arr_def['actapadre_nombre'] = ia_htmlentities(ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ". strit($actapadre_arr['cliente_id'])));
            elseif(array_key_exists('cliente',$actapadre_arr) && !empty($actapadre_arr['cliente']))
                $acta_arr_def['actapadre_nombre'] = ia_htmlentities($actapadre_arr['cliente']).(($actapadre_arr['cliente_de_paso'] == '1') ? ' <strong>(DE PASO)</strong>' : '');
            else
                $acta_arr_def['actapadre_nombre'] = 'Este vale no tiene asociado ning&uacuten Cliente, ni tiene establecido un nombre.';

            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('fecha',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['fecha']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('vale_number',$actapadre_arr) ? ia_htmlentities($actapadre_arr['vale_number']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';

            $acta_arr_def['acta_app_origen'] = 'Vale';

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Si hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['actapadre_remarks'] .= '<br>Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true) . '</b>';
            }

            break;

        case 'deuda_pago':

            //Vamos a calcular el nombre en el Cheque.
            if(array_key_exists('acreedor',$actapadre_arr))
                $acta_arr_def['actapadre_nombre'] = empty($actapadre_arr['acreedor']) ? 'N/A' : $actapadre_arr['acreedor'];

            if(array_key_exists('concepto',$actapadre_arr))
            {
                $acta_arr_def['actapadre_nombre'] = empty($acta_arr_def['actapadre_nombre']) ? $actapadre_arr['concepto'] : $acta_arr_def['actapadre_nombre'] . '<br/>' . $actapadre_arr['concepto'];
            }
            //Vamos a llenar los datos del padre.
            $acta_arr_def['actapadre_fecha'] = array_key_exists('fecha',$actapadre_arr) ? ia_htmlentities(date('d-m-Y', strtotime($actapadre_arr['fecha']))) : '';
            $acta_arr_def['actapadre_tienda'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT tienda FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_tiendaclv'] = array_key_exists('tienda_id',$actapadre_arr) ? ia_htmlentities(ia_singleread("SELECT clave FROM tienda WHERE tienda_id = ". strit($actapadre_arr['tienda_id']))) : 'N/A';
            $acta_arr_def['actapadre_remarks'] = array_key_exists('remarks',$actapadre_arr) ? ia_htmlentities($actapadre_arr['remarks']) : 'N/A';
            $acta_arr_def['actapadre_number'] = array_key_exists('numero_deuda',$actapadre_arr) ? ia_htmlentities($actapadre_arr['numero_deuda']) : 'N/A';
            $acta_arr_def['actapadre_quantity'] = array_key_exists('quantity',$actapadre_arr) ? ia_htmlentities($actapadre_arr['quantity']) : 'N/A';
            $acta_arr_def['actapadre_total_payments'] = array_key_exists('total_payments',$actapadre_arr) ? ia_htmlentities($actapadre_arr['total_payments']) : 'N/A';
            $acta_arr_def['actapadre_id'] = array_key_exists($actapadre_id_nombre,$actapadre_arr) ? ia_htmlentities($actapadre_arr[$actapadre_id_nombre]) : 'N/A';

            //Extra para saber si hay un registro en la cuentaT

            $ctaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE banco_cuenta_mov_link_id = ". strit($acta_id));
            if($ctaT_arr) //Sí hay un movimiento en la cuentaT con el ID del a cuenta.
            {
                $acta_arr_def['acta_ctaTmov'] .= 'Movimiento registrado en Cuenta T de <b>' . propdeCtaT($ctaT_arr['cuentaT_id'],'usuario',true) . '</b>';
            }

            break;

        case 'banco_cuenta_mov':

            //Vamos a leer datos de la CuentaT.
            $acta_arr_def['actapadre_nombre'] = array_key_exists('banco_cuenta_id',$acta_arr) ? 'Transferencia desde <b>' . ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$acta_arr[banco_cuenta_id]'") . '</b>' : 'N/A';
            //$acta_arr_def['actapadre_nombre'] .= array_key_exists('fecha',$acta_arr) ? '<br>El <b>' . ia_htmlentities(get_date_spanish(strtotime($acta_arr['fecha']))) . '</b>' : 'N/A';
            $link_arr = ia_singleton("SELECT * FROM  banco_cuenta_mov_link WHERE banco_cuenta_mov_link_id = ". strit($bcml_id));
            $acta_arr_def['actapadre_nombre'] .= array_key_exists('link_el',$link_arr) ? '<br>El <b>' . ia_htmlentities(get_date_spanish(strtotime($link_arr['link_el']))) . '</b> a las <b>' . date('H:i:s', strtotime($link_arr['link_el'])). '</b>' : '';
            $acta_arr_def['actapadre_nombre'] .= array_key_exists('link_por',$link_arr) ? '<br>Por <b>' . ia_htmlentities($link_arr['link_por']) . '</b>' : '';
            $acta_arr_def['acta_banco_cuenta_id'] = array_key_exists('banco_cuenta_id',$acta_arr) ? $acta_arr['banco_cuenta_id']:null;
            $acta_arr_def['acta_app_origen'] = "Link Cuentas Propias";
            break;

        case 'fiduciario_reembolso':

            //Vamos a leer datos de la CuentaT.
            $acta_arr_def['actapadre_nombre'] = "REEMBOLSO DE FIDUCIARIO";

            $bcm_arr = ia_singleton("SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = ". strit($acta_arr['banco_cuenta_mov_id']));

            $acta_arr_def['acta_banco_cuenta_id'] = array_key_exists('banco_cuenta_id',$bcm_arr) ? $bcm_arr['banco_cuenta_id']:null;
            $acta_arr_def['acta_deposit_total'] = array_key_exists('deposit',$bcm_arr) ? $bcm_arr['deposit']:null;
            $acta_arr_def['acta_quantity'] = array_key_exists('deposit',$bcm_arr) ? $bcm_arr['deposit']:null;
            $acta_arr_def['acta_quantity_total'] = array_key_exists('deposit',$bcm_arr) ? $bcm_arr['deposit']:null;
            $acta_arr_def['remarks'] = array_key_exists('remarks',$bcm_arr) ? $bcm_arr['remarks']:null;
            $acta_arr_def['acta_app_origen'] = "Reembolso de Fiducario";
            break;

    }

    if($return=='label')
        return  hazLabeldeDocto($acta_arr_def, $monto_padre);
    else
        return $acta_arr_def;
}

function TablaparaLinkManual($lm_docto)
{
    $arr_tlm = array (	"acta_tabla"	=>	"",
        "acta_comentarios"	=>	"");
    if($lm_docto == '')
        return $arr_tlm;

    switch ($lm_docto)
    {
        case 'cash':
            $arr_tlm["acta_tabla"] = 'cash_pago';
            //$arr_tlm["acta_comentarios"] = 'Pago de un CASH. ';
            break;

        case 'nota':
            $arr_tlm["acta_tabla"] = 'nota_pago';
            break;

        case 'pagare':
            $arr_tlm["acta_tabla"] = 'pagare_pago';
            break;

        case 'cheque':
            $arr_tlm["acta_tabla"] = 'cheque_pago';
            break;

        case 'vale':
            if(VALE_PAGO_MULTIPLE) {
                $arr_tlm["acta_tabla"] = 'vale_pago';
                break;
            }

        case 'deuda':
            $arr_tlm["acta_tabla"] = 'deuda_pago';
            break;

        default:
            $arr_tlm["acta_tabla"] = 'nota_pago';
            $arr_tlm["acta_comentarios"] = 'No se estableció documento. ';
            break;
    }

    return $arr_tlm;
}

function obtenOnHandCuentasT($cuentaTID='')
{
    global $gAppRelate;

    $todas = false;
    if(empty($cuentaTID))
        $todas = true;

    $arr_ctasTPuede = '';
    if($todas)
        $arr_ctasTPuede = cuentasTPuede('', 'ver_saldo_y_movimientos');
    else
        $arr_ctasTPuede = puedeCuentaT($cuentaTID,'','ver_saldo_y_movimientos');

    if($arr_ctasTPuede === false || $arr_ctasTPuede === "''")
        return false;

    if(!$todas)
        $arr_ctasTPuede = "'$cuentaTID'";

    $ctatTPref = $gAppRelate->cuentat_prefereida('', 'ver_saldo_y_movimientos');
    $ctatTPref = !empty($ctatTPref)?"'$ctatTPref',":"";

    $sqlOnHand = "SELECT cuentaT_id, usuario, on_hand_mx, on_hand_usd, transfering_mx, transfering_usd FROM cuentat WHERE vale='Active' AND cuentaT_id IN ($arr_ctasTPuede) ORDER BY FIELD(cuentaT_id, $ctatTPref $arr_ctasTPuede) ASC, cuentaT_id";

    //die($sqlOnHand);

    $arr_ctasTSaldo = ia_sqlArrayIndx($sqlOnHand);

    if(empty($arr_ctasTSaldo) || !is_array($arr_ctasTSaldo))
        return false;

    return $arr_ctasTSaldo;
}

function registraMovimientoDivisa($descripcion='', $tc_mov='', $doSQL = 'SI', $tc_over=0.00, $cliente_id='', $cliente_nombre='', $doc_id='', $doc_origen='', &$movimiento_divisa_id = '', $tc_temporal = '', $forza_ia_guid = false, $warning_forze = '', $tc_by_pass = false): bool|string
{
    $method = __METHOD__;
    $now = date('Y-m-d H:i:s');
    if ($forza_ia_guid)
    {
        $movimiento_divisa_id = ia_guid();
    }else{
        if(empty($movimiento_divisa_id)) {
            $movimiento_divisa_id_sql = "SELECT /** $method **/ movimiento_divisa_id, alta_db FROM movimiento_divisa WHERE doc_id = '{$doc_id}' AND doc_origen = '{$doc_origen}'";

            $movimiento_divisa = ia_singleton($movimiento_divisa_id_sql);
            $movimiento_divisa_id = $movimiento_divisa['movimiento_divisa_id'] ?? '';
            $now = $movimiento_divisa['alta_db'] ?? $now;
            if(empty($movimiento_divisa_id))
                $movimiento_divisa_id = ia_guid();
        }
    }



    $warning='NO';
    if(empty($descripcion) || empty($tc_mov))
        return false;

    global $gIAParametros;

    $descripcion = str_replace('<li>','',$descripcion);

    $revisa = revisaTipodeCambio($tc_mov, $tc_by_pass, $tc_over, en_registraMovimientoDivisa: true);

    if ($revisa === 'OK_TCTEMP')
        $descripcion.= "<br><br><span class='bg-warning text-danger bold ml-2'>ACEPTADO POR TIPO DE CAMBIO TEMPORAL: <b class='txt_color_PESOS'>$tc_mov</b></span>";

    /*if ($revisa === 'OK' && $tc_by_pass) {
        if ($doc_origen === 'banco_cuenta_trans') {
            $descripcion.= "<br><br><span class='bg-warning text-danger bold ml-2'>TIPO DE CAMBIO ACEPTADO POR: <b class='txt_color_PESOS'>LINK AUTOMATICO</b></span>";
        }
    }*/

    if ($doc_origen === 'iac_parametros')
        $revisa = 'PS';

    $revisa = !empty($warning_forze)?$warning_forze:$revisa;

    if (VARS_DEFAULT['tipo_cambio']['version_revisa_tc'] === 'v2') {
        $peligrosos_permitidos = ['LUA', 'LDA', 'LU', 'LD'];
        if (in_array($revisa, $peligrosos_permitidos)) {
            $set_revisa = 'W';
            if ($revisa === 'LUA' || $revisa === 'LU')
                $set_revisa = 'WU';
            if ($revisa === 'LDA' || $revisa === 'LD')
                $set_revisa = 'WD';
            registraMovimientoDivisa($descripcion, $tc_mov, 'SI', 0.00, $cliente_id, $cliente_nombre, $doc_id, $doc_origen, forza_ia_guid: true, warning_forze: $set_revisa);
        }
    }
    

    $warning = match ($revisa) {
        'W', 'WU', 'WD', 'WUA', 'WDA' => 'SI',
        'L', 'LU', 'LD', 'LUA', 'LDA' => 'PE',
        'PS' => 'PS',
        default => 'NO',
    };

    $tc_Sistema = max($gIAParametros['tc'], $tc_over);
    $tc_Sistema = $gIAParametros['tc'];


    $arr_MovDivisa = array();
    $arr_MovDivisa['movimiento_divisa_id'] = $movimiento_divisa_id;
    $arr_MovDivisa['descripcion'] = $descripcion;
    $arr_MovDivisa['tc_sistema'] = $tc_Sistema;

    if (!empty($tc_temporal))
        $arr_MovDivisa['tc_sistema'] = $tc_temporal;

    $arr_MovDivisa['tc_movimiento'] = $tc_mov;
    $arr_MovDivisa['warning'] = $warning;
    $arr_MovDivisa['warning_status'] = $warning=='NO'?'No Aplica':'Por revisar';
    $arr_MovDivisa['alta_db'] = $now;
    $arr_MovDivisa['alta_por'] = $_SESSION['usuario'];
    $arr_MovDivisa['cliente_id'] = $cliente_id;
    $arr_MovDivisa['cliente'] = $cliente_nombre;
    $arr_MovDivisa['doc_id'] = $doc_id;
    $arr_MovDivisa['doc_origen'] = $doc_origen;
    $arr_MovDivisa['tc_revision'] = $revisa;

    //if($warning && !usuarioTipoRony($_SESSION['usuario_id']))
    //registraBrainAviso($descripcion." - <a target='_blank' href='../backoffice/movimiento_divisa_list.php?movimiento_divisa_id=$arr_MovDivisa[movimiento_divisa_id]' data-movimiento_divisa_id='$arr_MovDivisa[movimiento_divisa_id]'><strong>Tipo de Cambio con Warning.</strong></a>", $now);

    $sql=ia_insert('movimiento_divisa',$arr_MovDivisa, autoOnUpdate: true);

    if($doSQL == 'SI')
    {
        $res = ia_query($sql);
        ia_errores_a_dime('','','registraMovimientoDivisa');
        @actualizaConteoMovimientosDivisa();
        return $res;
    }

    return $sql;
}

function registraBrainAviso($mensaje='', $now='', $tema='', $subtema='', $tipo='Especial')
{
    if(empty($mensaje))
        return false;

    if(empty($now))
        $now = date('Y-m-d H:i:s');

    $arr_BrainAviso = array();
    $arr_BrainAviso['brain_avisos_id'] = ia_guid();
    $arr_BrainAviso['por_quien'] = $_SESSION['usuario'];
    $arr_BrainAviso['mensaje'] = $mensaje;
    $arr_BrainAviso['revisado'] = 'Por revisar';
    $arr_BrainAviso['alta_db'] = $now = date('Y-m-d H:i:s');
    $arr_BrainAviso['tema'] = $tema;
    $arr_BrainAviso['subtema'] = $subtema;
    $arr_BrainAviso['tipo'] = $tipo;

    $sql=ia_insert('brain_avisos',$arr_BrainAviso);
    ia_query($sql);
    ia_errores_a_dime('','','registraBrainAviso');
}

/**
 * revisaTipodeCambio()
 * Revisa el tipo de cambio y contesta si está bien, hay warning o está fuera de rango.
 * @param float $tc tipo de cambio de la operación
 * @return string OK=bien. W=Warning. L=Fuera del Limite.
 */
function revisaTipodeCambio($tc=0, $byPass=false, $tc_over = 0.00, $ret_warning = false, $en_registraMovimientoDivisa = false): string
{
    $version = VARS_DEFAULT['tipo_cambio']['version_revisa_tc']??'v2';
    if (empty($version))
        return evaluateCurrencyExchangeRate($tc, $byPass, $tc_over, $ret_warning, $en_registraMovimientoDivisa);
    if ($version == 'v2')
        return evaluateCurrencyExchangeRate_v2($tc, $byPass, $tc_over, $ret_warning, $en_registraMovimientoDivisa);

    return evaluateCurrencyExchangeRate($tc, $byPass, $tc_over, $ret_warning, $en_registraMovimientoDivisa);
/*
    global $gIAParametros;
    $eval = 'OK'; //Tipo de Cambio dentro de los parámetros. OK. WU=Warning arriba. LU=Limite arriba. WD=Warning abajo. LD=Limite abajo.

    $tc_Sistema = $gIAParametros['tc'] < $tc_over ? $tc_over : $gIAParametros['tc'];

    $tc_Sistema = $byPass && $tc_over > 1 ? $tc_over : $tc_Sistema;
    $byPass = $byPass && $tc_over > 1 || ($byPass && usuarioTipoRony() && !$ret_warning) ? $byPass : false;

    $tc_WU = $tc_Sistema + ($gIAParametros['puntos_warning_arriba'] / 100);
    $tc_LU = $tc_Sistema + ($gIAParametros['puntos_limite_arriba'] / 100);
    $tc_WD = $tc_Sistema - ($gIAParametros['puntos_warning_abajo'] / 100);
    $tc_LD = $tc_Sistema - ($gIAParametros['puntos_limite_abajo'] / 100);

    if($byPass && usuarioTipoRony($_SESSION['usuario_id']))
        return $eval = 'OK';

    if($tc<$tc_LD || $tc>$tc_LU)
        return $eval = 'L';

    if($tc<=$tc_WD || $tc>=$tc_WU)
        return $eval = 'W';

    return $eval = 'OK';*/
}
/**
 * Function to check the currency rate.
 *
 * @param float|int $originalRate
 * @param bool $isBypassed
 * @param float $overrideRate
 * @param bool $returnWarning
 *
 * @return string
 */
function evaluateCurrencyExchangeRate(float|int $originalRate=0, bool $isBypassed=false, float $overrideRate = 0.00, bool $returnWarning = false, $en_registraMovimientoDivisa = false): string
{
    global $gIAParametros; // Global variable holding configuration parameters

    // Status for currency rate. Defines whether rate is inside specified parameters
    // 'OK': rate is within boundaries
    // 'WU': warning that rate is above warning boundary
    // 'LU': rate is above limit threshold
    // 'LUA': rate is above limit threshold and is allowed
    // 'WD': warning that rate is below warning boundary
    // 'LD': rate is below limit threshold
    // 'LDA': rate is below limit threshold and is allowed
    $rateStatus = 'OK';

    // Define system rate as maximum between parameters tc or override rate
    $systemRate = max($gIAParametros['tc'], $overrideRate);
    $systemRate = $isBypassed && $overrideRate > 1 ? $overrideRate : $systemRate;

    // Determine if the function is to be bypassed
    // $isBypassed = ($isBypassed && $overrideRate > 1 || ($isBypassed && usuarioTipoRony() && !$returnWarning));
    $isBypassed = ($isBypassed && $overrideRate > 1 || ($isBypassed && !$returnWarning));

    // If the function is bypassed and the user type is Rony
    if($isBypassed)
        return 'OK';

    // Evaluate the rate status
    $rateStatus = getRateStatus($originalRate);

    // Check currency rate warning and limit thresholds
    // if ($rateStatus !== 'OK')
    if ($rateStatus !== 'OK_TCTEMP')
    {
        $upperWarningRate = $systemRate + ($gIAParametros['puntos_warning_arriba'] / 100);
        $upperLimitRate = $systemRate + ($gIAParametros['puntos_limite_arriba'] / 100);
        $lowerWarningRate = $systemRate - ($gIAParametros['puntos_warning_abajo'] / 100);
        $lowerLimitRate = $systemRate - ($gIAParametros['puntos_limite_abajo'] / 100);

        // If the original rate is out of bounds, return 'L'
        if($originalRate<$lowerLimitRate || $originalRate>$upperLimitRate)
            return 'L';
        // If the original rate is within the warning boundaries, return 'W'
        if($originalRate<=$lowerWarningRate || $originalRate>=$upperWarningRate)
            return 'W';

        $rateStatus = 'OK';
    }

    if (!$en_registraMovimientoDivisa && $rateStatus === 'OK_TCTEMP')
        $rateStatus = 'OK';

    return $rateStatus;
}

function evaluateCurrencyExchangeRate_v2(float|int|string $originalRate=0, bool $isBypassed=false, float|int|string $overrideRate = 0.00, bool $returnWarning = false, $en_registraMovimientoDivisa = false): string
{
    global $gIAParametros; // Global variable holding configuration parameters

    // Status for currency rate. Defines whether rate is inside specified parameters
    // 'OK': rate is within boundaries
    // 'WU': warning that rate is above warning boundary
    // 'LU': rate is above limit threshold
    // 'WD': warning that rate is below warning boundary
    // 'LD': rate is below limit threshold
    $rateStatus = 'OK';

    // Define system rate as maximum between parameters tc or override rate
    $systemRate = max($gIAParametros['tc'], $overrideRate);
    $systemRate = $isBypassed && $overrideRate > 1 ? $overrideRate : $systemRate;

    // Determine if the function is to be bypassed
    // $isBypassed = ($isBypassed && $overrideRate > 1 || ($isBypassed && usuarioTipoRony() && !$returnWarning));
    $isBypassed = ($isBypassed && $overrideRate > 1 || ($isBypassed && !$returnWarning));

    // If the function is bypassed and the user type is Rony
    if($isBypassed)
        return 'OK';

    $tc_activo = $gIAParametros['tc_activo'] === 'Si';
    $tc_limite_abajo_activo = $gIAParametros['tc_limite_abajo_activo'] === 'Si';
    $tc_warn_abajo_activo = $gIAParametros['tc_warning_abajo_activo'] === 'Si';
    $tc_warn_arriba_activo = $gIAParametros['tc_warning_arriba_activo'] === 'Si';
    $tc_limite_arriba_activo = $gIAParametros['tc_limite_arriba_activo'] === 'Si';
    if (!$tc_activo) {
        $systemRate = $gIAParametros['tc_sistema'];
    }

    // Evaluate the rate status
    $originalRate = $originalRate + 0.00;
    $rateStatus = getRateStatus($originalRate);

    // Check currency rate warning and limit thresholds
    // if ($rateStatus !== 'OK')
    if ($rateStatus !== 'OK_TCTEMP')
    {
        // Los valores ya los tenemos guardados en DB ya no es necesario calcular
        $upperWarningRate = $gIAParametros['tc_warning_arriba'];
        $upperLimitRate = $gIAParametros['tc_limite_arriba'];
        $lowerWarningRate = $gIAParametros['tc_warning_abajo'];
        $lowerLimitRate = $gIAParametros['tc_limite_abajo'];

        // If the original rate is out of bounds, return 'LD'||'LDA'||'LU'||'LUA'
        $paso_limite_inferior = false;
        if ($originalRate<$lowerLimitRate) {
            // Limite abajo permitido
            if (!$tc_activo && $tc_limite_abajo_activo)
                return 'LDA';

            // TC activo Y limite abajo inactivo || TC inactivo Y limite abajo inactivo no mandan error
            // Y si warning abajo esta activo
            if (($tc_activo && !$tc_limite_abajo_activo) || (!$tc_activo && !$tc_limite_abajo_activo)) {
                if (!$tc_warn_abajo_activo)
                    return 'OK';
            }
            // Limite abajo
            if ($tc_limite_abajo_activo)
                return 'LD';
        }
        if ($originalRate>$upperLimitRate) {
            // Limite arriba permitido
            if (!$tc_activo && $tc_limite_arriba_activo)
                return 'LUA';

            // TC activo Y limite arriba inactivo || TC inactivo Y limite arriba inactivo no mandan error
            // Y si warning arriba esta activo
            if (($tc_activo && !$tc_limite_arriba_activo) || (!$tc_activo && !$tc_limite_arriba_activo)) {
                if (!$tc_warn_arriba_activo)
                    return 'OK';
            }

            // Limite arriba
            if ($tc_limite_arriba_activo)
                return 'LU';
        }

        // If the original rate is within the warning boundaries, return 'W'
        if ($originalRate<=$lowerWarningRate) {
            // Warning abajo permitido
            if (!$tc_activo && $tc_warn_abajo_activo)
                return 'WDA';

            // TC activo Y warning abajo inactivo || TC inactivo Y warning abajo inactivo no mandan error
            if (($tc_activo && !$tc_warn_abajo_activo) || (!$tc_activo && !$tc_warn_abajo_activo))
                return 'OK';
            
            // Warning abajo
            return 'WD';
        }

        if ($originalRate>=$upperWarningRate) {
            // Warning arriba permitido
            if (!$tc_activo && $tc_warn_arriba_activo)
                return 'WUA';

            // TC activo Y warning arriba inactivo || TC inactivo Y warning arriba inactivo no mandan error
            if (($tc_activo && !$tc_warn_arriba_activo) || (!$tc_activo && !$tc_warn_arriba_activo))
                return 'OK';

            // Warning arriba permitido
            return 'WU';
        }

        $rateStatus = 'OK';
    }

    if (!$en_registraMovimientoDivisa && $rateStatus === 'OK_TCTEMP')
        $rateStatus = 'OK';

    return $rateStatus;
}

/**
 * Function to get currency rate status for temporary rates
 *
 * @param float|int $originalRate
 * @param bool $calculateBoundaries
 * @return string
 */
function getRateStatus(float|int $originalRate=0, bool $calculateBoundaries=false): string
{
    // Retriving the temporary rates
    $tempRates = app_iac_parametros::get_TC_Temporales();
    if (empty($tempRates))
        return '';
    global $gIAParametros; // Global variable holding configuration parameters
    foreach ($tempRates as $tempRate)
    {
        // If boundaries are not to be calculated and originalRate equals tempRate, return 'OK'
        if(!$calculateBoundaries && $originalRate == $tempRate)
            return 'OK_TCTEMP';
        // If boundaries calculation is requested, continue with the original logic.
        if($calculateBoundaries) {
            // Defining rate boundaries for warning and limit thresholds
            $upperWarningTempRate = $tempRate + ($gIAParametros['puntos_warning_arriba'] / 100);
            $upperLimitTempRate = $tempRate + ($gIAParametros['puntos_limite_arriba'] / 100);
            $lowerWarningTempRate = $tempRate - ($gIAParametros['puntos_warning_abajo'] / 100);
            $lowerLimitTempRate = $tempRate - ($gIAParametros['puntos_limite_abajo'] / 100);
            // If the original rate is out of bounds, return 'L'
            if(($originalRate<$lowerLimitTempRate || $originalRate>$upperLimitTempRate))
                return 'L';
            // If the original rate is within the warning boundaries, return 'W'
            if(($originalRate<=$lowerWarningTempRate || $originalRate>=$upperWarningTempRate))
                return 'W';
        }
    }
    return '';
}

function extraeTCdeXE($manual=false, $debug=false, $preferred_api="currencylayer.com") //$preferred_api="currencylayer.com"
{
    global $gIAParametros;

    if (!$manual && php_uname('n') != "T550GRIS") {
        return false;
    }

    if (!$manual && $gIAParametros['actualiza_desde_xecom'] != 'Si') {
        if ($debug) echo 'Actualización automática INACTIVA.<br/>';
        return false;
    }

    $diaSemana = date('N');
    if (!$manual && (($diaSemana == 6 && $gIAParametros['actualiza_desde_xecom_en_sabado'] != 'Si') ||
            ($diaSemana == 7 && $gIAParametros['actualiza_desde_xecom_en_domingo'] != 'Si'))) {
        if ($debug) echo 'Es sábado o domingo y no debemos actualizar.<br/>';
        return false;
    }

    $horaActual = (int) date('Gis');
    $horaInicial = (int) str_replace(':','',$gIAParametros['hora_inicial_actualiza_desde_xecom']);
    $horaFinal = (int) str_replace(':','',$gIAParametros['hora_final_actualiza_desde_xecom']);

    if (!$manual && ($horaActual < $horaInicial || $horaActual > $horaFinal)) {
        if ($debug) echo 'Fuera de horario.<br/>';
        return false;
    }

    $tcUltimaActualizacion = ia_singleread("SELECT alta_db FROM tc_log ORDER BY alta_db DESC LIMIT 1");

    if (!$manual && (diferenciadeTiempo($tcUltimaActualizacion,'','minutos') < $gIAParametros['tiempo_para_actualizar_tc_desde_xecom']*60)) {
        if ($debug) echo "No ha pasado el tiempo suficiente para actualizar.<br/>";
        return false;
    }

    $tcXE = 0.00;
    $api_used = $preferred_api;

    // 🔹 **Function to get exchange rate from API**
    function getExchangeRate($api, $debug=false) {
        if ($api == "currencylayer.com") {
            $url = "http://apilayer.net/api/live?access_key=1a788acee0d6bf9d5b1307541c1f587e&currencies=USD,MXN&format=1";
        } elseif ($api == "alphavantage") {
            $url = 'https://www.alphavantage.co/query?function=CURRENCY_EXCHANGE_RATE&from_currency=USD&to_currency=MXN&apikey=9RPF6JQGVLJLOJ43';
        } else {
            return null;
        }

        $agent = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.12 Safari/537.36 OPR/56.0.3051.0 (Edition developer)';

        // Fetch Data
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FRESH_CONNECT  => true,
            CURLOPT_FORBID_REUSE   => true,
            CURLOPT_USERAGENT      => $agent,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2,
        ]);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Debugging Output
        if ($debug) echo "<pre>[$api Response] HTTP Code: $http_code\n".print_r($response, true)."</pre>";

        // Validate JSON Response
        $data = json_decode($response, true);
        if (!$data) return null; // Invalid JSON

        // 🔹 **Parse Data Based on API**
        if ($api == "currencylayer.com") {
            if (!isset($data['success']) || !$data['success'] || !isset($data['quotes']['USDMXN'])) return null;
            return [
                "rate" => floatval($data['quotes']['USDMXN']),
                "timestamp" => date("Y-m-d H:i:s", $data['timestamp'] ?? time())
            ];
        } elseif ($api == "alphavantage") {
            if (!isset($data["Realtime Currency Exchange Rate"]["5. Exchange Rate"])) return null;
            return [
                "rate" => floatval($data["Realtime Currency Exchange Rate"]["5. Exchange Rate"]),
                "timestamp" => date("Y-m-d H:i:s", strtotime($data["Realtime Currency Exchange Rate"]["6. Last Refreshed"] ?? "now"))
            ];
        }

        return null;
    }

    // 🔹 **Attempt Primary API First**
    $result = getExchangeRate($preferred_api, $debug);

    // 🔹 **Fallback to Secondary API if First Fails**
    if (!$result) {
        if ($debug) echo "⚠️ Primary API ($preferred_api) failed, switching to fallback.\n";
        $fallback_api = ($preferred_api == "currencylayer.com") ? "alphavantage" : "currencylayer.com";
        $result = getExchangeRate($fallback_api, $debug);
        $api_used = $fallback_api;
    }

    // 🔹 **Update Database or Handle Failure**
    if ($result) {
        $tcXE = $result["rate"];
        $tsXE = $result["timestamp"];
        actualizaTCenDB(true, $tcXE, $tsXE, $manual, $api_used, desde_api: true);
    } else {
        if ($debug) echo "❌ Error: No se pudo obtener el tipo de cambio de ninguna API.\n";
        actualizaTCenDB(false, 0.00, '', $manual);
    }

    if ($debug) echo "✅ Tipo de cambio ($api_used): $tcXE\n";

    return $tcXE;
}




function actualizaTCenDB($success=false, $tcXE=0.00, $tsXE='', $manual=false, $prov='xe.com', $es_temporal = false, $remarks_set = '', $desde_api = false)
{
    if($success && $tcXE==0.00)
        return false;

    global $gIAParametros;

    if($manual)
        $nombreApp = $_SESSION['usuario'];
    else
        $nombreApp = 'actualizaTCenDB';

    $arr_tc = array();
    $arr_tc['tc_log_id'] = ia_guid();
    $arr_tc['tc'] = $tcXE;
    $arr_tc['origen'] = strtoupper($prov);
    $arr_tc['origen_ts'] = $tsXE;
    if (empty($remarks_set)) {
        $remarks_set = $success?'TC actualizado con éxito de '.$arr_tc['origen']:'Error al leer el patrón para actualizar el TC de '.$arr_tc['origen'];
    }
    $arr_tc['remarks'] = $remarks_set;
    $arr_tc['exitoso'] = $success;
    $arr_tc['alta_db'] = $now = date('Y-m-d H:i:s');
    $arr_tc['alta_por'] = $nombreApp;

    $sqlTC = array();
    $sqlTC[] = ia_insert('tc_log',$arr_tc);
    if (!$es_temporal)
    {
        if($success)
        {
            $sqlTC[] = "UPDATE moneda SET tc='$tcXE', ultimo_cambio='$now', ultimo_cambio_por='$nombreApp' WHERE moneda_id=2";
            $sqlTC[] = "UPDATE iac_parametros SET tc='$tcXE'";
            if ($desde_api) {
                $systemRate = $tcXE;
                $values_set = [
                    'tc_sistema' => $tcXE,
                    'tc_limite_abajo' => $systemRate - ($gIAParametros['puntos_limite_abajo']/100),
                    'tc_warning_abajo' => $systemRate - ($gIAParametros['puntos_warning_abajo']/100),
                    'tc_warning_arriba' => $systemRate + ($gIAParametros['puntos_warning_arriba']/100),
                    'tc_limite_arriba' => $systemRate + ($gIAParametros['puntos_limite_arriba']/100),
                ];
                $sqlTC[] = ia_update('iac_parametros', $values_set, ['iac_parametros_id' => '1']);
                // $sqlTC[] = "UPDATE iac_parametros SET tc_sistema='$tcXE'";
            }
        }

        if(!$success && $gIAParametros['avisa_brain_si_hay_error_en_actualiza_desde_xecom'] == 'Si')
        {
            registraBrainAviso("<a target='_blank' href='../backoffice/tc_log.php?tc_log_id=$arr_tc[tc_log_id]'><strong>ERROR al actualizar el Tipo de Cambio desde CURRENCYLAYER.COM. Dia y hora: $now.</strong></a>", $now);
        }
    }

    ia_transaction($sqlTC);
    ia_errores_a_dime('','',$nombreApp);

    obtenCatalogo('tc', true);
    obtenCatalogo('tc', true);
    @async_ws_generaCatalogos(['tc_log_origen', 'tc_log_alta_por']);
    return true;
}

function obtenCuentasTToolbar()
{
    $ctasTSaldoHTML = '';
    return $ctasTSaldoHTML;
    $ctasTSaldo = obtenOnHandCuentasT();
    if(is_array($ctasTSaldo) && !empty($ctasTSaldo))
    {
        $ctasTSaldoHTML = "<div id='cuentasTToolbar' style='background-color: #ffffff;'>";
        $ctasTSaldoHTML .= "<table id='tablectasTSaldo' style='width: 280px;'>";
        $ctasTSaldoHTML .= "<tr><td colspan='2' class='tbctasTSaldo'><a href='../backoffice/cuentat_mov.php?cuentat=".$ctasTSaldo[0]['usuario']."' target='_blank'><strong>".$ctasTSaldo[0]['usuario']."</strong></a></td></tr><tr><td class='tbPESOS'>".echonf($ctasTSaldo[0]['on_hand_mx'],true)."</td><td class='tbUSD'>".echonf($ctasTSaldo[0]['on_hand_usd'],true)."</td></tr>";
        $ctasTSaldoHTML .= "</table>";
        if(sizeof($ctasTSaldo)>1)
        {
            $ctasTSaldoHTML .= "<a id='amuestraMasCuentasTToolbar' href='javascript:void(0);' onclick='muestraMasCuentasTToolbar(true);'><strong>Mostrar más Cuentas T </strong><img style='width: 16px !important; height: 16px !important;' src='../img/add.png' alt='Mostrar más Cuentas T' title='Mostrar más Cuentas T' /></a>";
            $ctasTSaldoHTML .= "<a id='aocultaMasCuentasTToolbar' href='javascript:void(0);' onclick='muestraMasCuentasTToolbar(false);' style='display:none;' ><strong>Ocultar las Cuentas T </strong><img style='width: 16px !important; height: 16px !important;' src='../img/delete.png' alt='Ocultar las Cuentas T' title='Ocultar las Cuentas T' /></a>";
            $ctasTSaldoHTML .= "<div id='divctasTSaldoMas' style='position: fixed; z-index:1001; display: none; overflow-x: hidden; overflow-y: scroll; height: 510px; background-color: #ffffff;'>";
            $ctasTSaldoHTML .= "<hr/><a href='../backoffice/cuenta_t.php' target='_blank' title='Resumen de todas las Cuentas T'><strong>Resumen de todas las Cuentas T</strong></a><hr/>";
            $ctasTSaldoHTML .= "<a href='../backoffice/cuentat_mov.php' target='_blank' title='Movimientos de todas las Cuentas T'><strong>Mov. de todas las Cuentas T</strong></a><hr/>";
            $ctasTSaldoHTML .= "<table id='tablectasTSaldoMas' style='width: 280px;'>";
            foreach($ctasTSaldo as $k=>$ctaT)
                if($k>0)
                    $ctasTSaldoHTML .= "<tr><td colspan='2' class='tbctasTSaldo'><a href='../backoffice/cuentat_mov.php?cuentat=".$ctaT['usuario']."' target='_blank'><strong>".$ctaT['usuario']."</strong></a></td></tr><tr><td class='tbPESOS'>".echonf($ctaT['on_hand_mx'],true)."</td><td class='tbUSD'>".echonf($ctaT['on_hand_usd'],true)."</td></tr>";
            $ctasTSaldoHTML .= "</table></div>";
        }
        $ctasTSaldoHTML .= "</div>";
    }
    else
        $ctasTSaldoHTML = '';

    return $ctasTSaldoHTML;
}

function cancelaVale($valeID='')
{
    if(empty($valeID))
        return false;

    $vale=new app_vale();
    $vale->id=$valeID;
    $vale->values=$vale->enDB=$vale->read_sql($valeID,'r');

    if(!is_array($vale->enDB) || empty($vale->enDB))
        return false;

    $vale->cancelaVale = 'SI';
    $vale->update();
}

function obtenCuentaTMovIDOriginal($origenID)
{
    if(empty($origenID))
        return false;

    $commentSQL = " /** obtenCuentaTMovIDOriginal **/";
    $sql = "SELECT $commentSQL cuentaT_mov_id FROM cuentat_mov WHERE origen_mov_id = ".strit($origenID)." ORDER BY alta_db DESC";

    $ID = ia_singleread($sql);

    if(!empty($ID))
        return $ID;
    else
        return false;
}

function arrayAppOrigen($select = false)
{
    $arrAppOrigen = array ( 'Ingreso Directo' => 'Ingreso Directo',
        'Gasto Cuenta T' => 'Gasto Cuenta T',
        'A Cuenta Cheque' => 'A Cuenta Cheque',
        'A Cuenta Compra' => 'A Cuenta Compra',
        'A Cuenta Gasto' => 'A Cuenta Gasto',
        'A Cuenta Nota' => 'A Cuenta Nota',
        'A Cuenta Pagare' => 'A Cuenta Pagare',
        'Cheque Delivered' => 'Cheque Delivered',
        'Pagare Delivered' => 'Pagare Delivered',
        'Vale' => 'Vale',
        'Link Directo al Banco' => 'Link Directo al Banco',
        'Link Directo a China' => 'Link Directo a China',
        'Transfer Cuenta T' => 'Transfer Cuenta T',
        'Ajuste Cuenta T' => 'Ajuste Cuenta T',
        'Gasto Tienda' => 'Gasto Tienda',
        'Gasto Proveedor' => 'Gasto Proveedor',
        'Link Tarjetas de Credito' => 'Link Tarjetas de Credito',
        'Vale Aplicado' => 'Vale Aplicado');
    if($select)
    {
        foreach($arrAppOrigen as $k=>$v)
        {
            $arrAppOrigenIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v,'real_data'=>$v);
        }
        return $arrAppOrigenIndex;
    }
    return $arrAppOrigen;
}

function arrayLinkOrigen($select = false)
{
    $arrLinkOrigen = array ( 'cuentat_mov' => 'Cuenta T',
        'banco_cuenta_mov' => 'Cuenta Bancaria',
        'cheque_pago' => 'Cheque',
        'pagare_pago' => 'Pagare',
        'vale' => 'Vale',
        'vale_pago' => 'Vale');

    if($select)
    {
        foreach($arrLinkOrigen as $k=>$v)
        {
            $arrLinkOrigenIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrLinkOrigenIndex;
    }
    return $arrLinkOrigen;
}

function arrayTablasCatalogos()
{
    $arrTablasCatalogos = array( 'banco' => array('banco_id','clave'),
        'banco_cuenta' => array('banco_cuenta_id','nombre'),
        'banco_mov_tipo' => array('banco_mov_tipo_id','tipo'),
        'cliente' => array('cliente_id','nombre'),
        'cuentat' => array('cuentaT_id','usuario'),
        'empresa' => array('empresa_id','empresa'),
        'moneda' => array('moneda_id','moneda'),
        'tienda' => array('tienda_id','clave'),
        'categoria_gasto' => array('categoria_gasto_id','nombre'),
        'metodo_pago_id' => array('metodo_pago_id','tipo'),
        'categoria' => array('categoria_id','categoria'),
        'plantilla_cuentat_gasto' => array('plantilla_cuentat_gasto_id','nombre'),);
    return $arrTablasCatalogos;
}

function arrayTipoFactura($select = false): array
{
    $arrTipoFactura = array ( 'MST' => 'MST',
        'FACTURA' => 'FACTURA',
        'FACTURA PENDIENTE' => 'FACTURA PENDIENTE',
        'NUESTRO' => 'NUESTRO',
        'DEVOLUCION' => 'DEVOLUCION',
        'ESPECIAL' => 'ESPECIAL',
        'ASIMILADOS' => 'ASIMILADOS',
    );
    if($select)
    {
        foreach($arrTipoFactura as $k=>$v)
        {
            $arrTipoFacturaIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrTipoFacturaIndex;
    }
    return $arrTipoFactura;
}

function arrayTipoFigura($select = false)
{
    $arrTipoFigura = array ( '01' => 'Operador',
        '02' => 'Propietario',
        '03' => 'Arrendador',
        '04' => 'Notificado',
    );
    if($select)
    {
        foreach($arrTipoFigura as $k=>$v)
        {
            $arrTipoFiguraIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrTipoFiguraIndex;
    }
    return $arrTipoFigura;
}

function arrayTipoWarning($select = false)
{
    $arrTipoFactura = array ( 'No Aplica' => 'Sin Warning',
        // 'Por revisar' => 'Con Warning',
        'Por revisar' => 'Por Revisar',
        'Revisado' => 'Autorizado' );
    if($select)
    {
        foreach($arrTipoFactura as $k=>$v)
        {
            $arrTipoFacturaIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$k,'real_data'=>$k);
        }
        return $arrTipoFacturaIndex;
    }
    return $arrTipoFactura;
}
function arrayStockCode($select = false): array
{
    $arrayStockCode = array();
    $arrayStockCodeIndex = array();
    $meta_commodity_arr = getCommodityMeta();
    $meta_commodity_keys = array_keys($meta_commodity_arr);
    foreach($meta_commodity_keys as $k=>$v){
        $arrayStockCode[$v] = $v;
    }

    if($select)
    {
        foreach($arrayStockCode as $k=>$v)
        {
            $arrayStockCodeIndex[] = array(0=>(string)$k,1=>(string)$v,'label'=>(string)$v,'value'=>(string)$k,'real_data'=>(string)$k);
        }
        return $arrayStockCodeIndex;
    }
    return $arrayStockCode;
}

function arrayStockCodeCurrency($select = false): array
{

    $arrayStockCodeCurrency = array();
    $arrayStockCodeCurrencyIndex = array();
    $meta_commodity_arr = getCommodityMeta();
    foreach($meta_commodity_arr as $meta_commodity) {
        $arrayStockCodeCurrency[$meta_commodity['currency']] = $meta_commodity['currency'];
    }
    $arrayStockCodeCurrency = array_unique($arrayStockCodeCurrency);

    if($select)
    {
        foreach($arrayStockCodeCurrency as $k=>$v)
        {
            $arrayStockCodeCurrencyIndex[] = array(0=>(string)$k,1=>(string)$v,'label'=>(string)$v,'value'=>(string)$k,'real_data'=>(string)$k);
        }
        return $arrayStockCodeCurrencyIndex;
    }
    return $arrayStockCodeCurrency;
}

function arrayStockFriendlyName($select = false): array
{

    $arrayStockFriendlyName = array();
    $arrayStockFriendlyNameIndex = array();
    $meta_commodity_arr = getCommodityMeta();
    foreach($meta_commodity_arr as $meta_commodity) {
        $arrayStockFriendlyName[$meta_commodity['friendly_name']] = $meta_commodity['friendly_name'];
    }
    $arrayStockFriendlyName = array_unique($arrayStockFriendlyName);

    if($select)
    {
        foreach($arrayStockFriendlyName as $k=>$v)
        {
            $arrayStockFriendlyNameIndex[] = array(0=>(string)$k,1=>(string)$v,'label'=>(string)$v,'value'=>(string)$k,'real_data'=>(string)$k);
        }
        return $arrayStockFriendlyNameIndex;
    }
    return $arrayStockFriendlyName;
}

function array_movimiento_divisa_warning_tipo($select = false): array
{
    $arrTipoFactura = array ( 'NO' => 'Sin Warning',
        'SI' => 'Warning',
        'PE' => 'Warning Rony',
        'TU' => 'Warning revisada',
        'TUR' => 'Warning Rony revisada',
        'PS' => 'Parametros',
        'All' => 'Todos'
        );


    if($select)
    {
        foreach($arrTipoFactura as $k=>$v)
        {
            $arrTipoFacturaIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$k,'real_data'=>$k);
        }
        return $arrTipoFacturaIndex;
    }
    return $arrTipoFactura;
}

function arrayTipoCashNota($select = false): array
{
    $arrTipoCashNota = array (  'CASH' => 'CASH',
        'NOTA' => 'NOTA',
        'OTRO' => 'OTRO',
        'VALE' => 'VALE'
        );
    if($select)
    {
        foreach($arrTipoCashNota as $k=>$v)
        {
            $arrTipoCashNotaIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrTipoCashNotaIndex;
    }
    return $arrTipoCashNota;
}

function array_bodega_tipo_cash_nota($select = false): array
{
    $arr_bodega_tipo_cash_nota = array (
        'CASH' => 'CASH',
        'NOTA' => 'NOTA',
        'PIÑA' => 'PIÑA',
        );
    if($select)
    {
        $arr_bodega_tipo_cash_nota_index = array();
        foreach($arr_bodega_tipo_cash_nota as $k=>$v)
        {
            $arr_bodega_tipo_cash_nota_index[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arr_bodega_tipo_cash_nota_index;
    }
    return $arr_bodega_tipo_cash_nota;
}

function arrayLinkVale($select = false): array
{
    $arrLinkVale = array (
        'ND'        => array('value'=>'ND','class'=>''),
        'Q'         => array('value'=>'Q','class'=>''),
        'LP'        => array('value'=>'LP','class'=>''),
        'LT'        => array('value'=>'LT','class'=>''),
        'SBC'       => array('value'=>'SBC','class'=>''),
        'RJ'        => array('value'=>'RJ','class'=>''),
        'SYS'       => array('value'=>'SYS','class'=>''),
        'PEND'      => array('value'=>'PEND','class'=>''),
        'INC'       => array('value'=>'INC','class'=>''),
        'NA'        => array('value'=>'NA','class'=>''),
        'ERROR'     => array('value'=>'ERROR','class'=>'option_ROJO'),
        'DEV'       => array('value'=>'DEV','class'=>''),
        'STOP'      => array('value'=>'STOP','class'=>'option_ROJO'),
        'CORRECTED' => array('value'=>'CORRECTED','class'=>''),
        'COMMENTS'  => array('value'=>'COMMENTS','class'=>'option_NEON'),
        'NEW'       => array('value'=>'NEW','class'=>''),
        'RONY'      => array('value'=>'RONY','class'=>'option_NEON'),
        'AA'        => array('value'=>'AA','class'=>'option_NEON'),
        'APP'       => array('value'=>'APP','class'=>''),
        'BLOCKED'   => array('value'=>'BLOCKED','class'=>'option_ROJO'),
        'CONTRACT'  => array('value'=>'CONTRACT','class'=>'option_NEON'),
        'RETORNO'   => array('value'=>'RETORNO','class'=>'option_NEON'),
        'GARANTIA'  => array('value'=>'GARANTIA','class'=>'option_NEON'),
        'NAVIERA'   => array('value'=>'NAVIERA','class'=>'option_NEON'),
        'HOLD'      => array('value'=>'HOLD','class'=>'option_ROJO'),
        'RETAIN'    => array('value'=>'RETAIN','class'=>'option_ROJO'),
        'FID'       => array('value'=>'FID','class'=>''),
        'INV'       => array('value'=>'INV','class'=>''));

    $arrLinkValeIndex = array();

    if($select)
    {
        foreach($arrLinkVale as $k=>$v)
        {
            $arrLinkValeIndex[] = array(0=>$k,1=>$v['value'],'label'=>$v['value'],'value'=>$v['value'],'class'=>$v['class']);
        }
        return $arrLinkValeIndex;
    }


    foreach($arrLinkVale as $k=>$v)
    {
        $arrLinkValeIndex[$k] = $v['value'];
    }
    return $arrLinkValeIndex;

}

function arrayUltimoMovimiento($select = false)
{
    $arrUltimoMovimiento = array ( 'ALTA' => 'ALTA',
        'BORRADO' => 'BORRADO',
        'FECHA' => 'FECHA',
        'QUANTITY' => 'QUANTITY');
    if($select)
    {
        foreach($arrUltimoMovimiento as $k=>$v)
        {
            $arrUltimoMovimientoIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrUltimoMovimientoIndex;
    }
    return $arrUltimoMovimiento;
}


function arrayStatusFiduciario($select = false)
{
    $arrTipoFactura = array (  'ABIERTO' => 'ABIERTO',
        'AMBOSMOD' => 'AMBOS MODIFICADOS',
        'MODIFICADO' => 'MODIFICADO',
        'CONTMOD' => 'CONTENEDOR MODIFICADO',
        'CERRADO' => 'CERRADO'
    );
    if($select)
    {
        foreach($arrTipoFactura as $k=>$v)
        {
            $arrTipoFacturaIndex[] = array(0=>$k,1=>$v,'label'=>$v,'value'=>$v);
        }
        return $arrTipoFacturaIndex;
    }
    return $arrTipoFactura;
}

/**
 * borraDocumentoPagos()
 * Borra todos los a cuentas de un documento.
 *
 * @param mixed $documento = 'cheque', 'pagare'
 * @param mixed $documentoID = '' ID de 32 caracteres.
 * @param mixed $ajustaCuentaT = 'NO' Bandera para saber si ajusta cuenta T o no.
 * @return
 */
function borraDocumentoPagos($documento = 'cheque', $documentoID = '', $ajustaCuentaT = 'NO')
{
    global $gIAsql;
    $gIAsql['trace'] = true;

    if(empty($documentoID))
        return false;

    $pk_field = $documento.'_id';


    // a cuenta de que cheque,pagare,...
    $cat=$documento;
    $collection['base_table']=$documento;
    $collection['pk_campo']=$pk_field;
    $collection['collection']=$collection['base_table'];

    $usuario = $_SESSION['usuario'];
    $now = date('Y-m-d H:i:s');


    $qtyEs='quantity';



    $itemID=$documentoID;
    // obten el item
    $item=ia_singleton("SELECT * FROM $collection[base_table] WHERE $collection[pk_campo]=".strit($itemID));
    if(empty($item))
    {
        //return false;
    }

    $cliente='';
    $sql=array();

    $cliente_id=$item['cliente_id'];
    if(empty($cliente_id)) $cliente_id=$item['cliente_proveedor_id'];
    if($cliente_id==0)
        $cliente=$item['name_on_check'];

    if($cliente_id>0)
        $cliente=ia_singleread("SELECT nombre FROM cliente WHERE cliente_id=".strit($cliente_id));
    $cliente=ia_htmlentities($cliente);


    $dpsql = "SELECT * FROM ".$documento."_pago WHERE ".$documento."_id=".strit($itemID)." ORDER BY alta_db ASC";
    $documentoPagos = ia_sqlArrayIndx($dpsql);

    if(is_array($documentoPagos)) foreach($documentoPagos as $k=>$vdocPago)
    {
        $pagoID=$vdocPago[$documento."_pago_id"];
        $tsql=borraDocumentoPago($documento, $pagoID, $ajustaCuentaT, 'NO');
        if(!empty($tsql))
            foreach($tsql as $qs)
                $sql[]=$qs;
    }

    if(!empty($sql))
        if(ia_transaction($sql))
            ia_errores_a_dime();
    return true;
}

/**
 * Borra un a cuenta de un documento.
 *
 * @param mixed $documento = 'cheque', 'pagare'
 * @param mixed $documentoPagoID = '' ID de 32 caracteres.
 * @param mixed $ajustaCuentaT = 'NO' Bandera para saber si ajusta cuenta T o no.
 * @return
 */
function borraDocumentoPago($documento = 'cheque', $documentoPagoID = '', $ajustaCuentaT = 'NO', $do = 'SI', $razon_cancelacion = ""): bool|array
{
    global $gIAsql;
    $gIAsql['sql_trace'] = true;

    if(empty($documentoPagoID))
        return false;

    $pk_field = $documento.'_id';

    $now = date('Y-m-d H:i:s');
    $usuario = $_SESSION['usuario'];

    $sql=array();
    $commentSQL = " /** borraDocumentoPago **/";

    // a cuenta de que cheque,pagare,...
    $cat=$documento;
    $collection['base_table']=$documento;
    $collection['pk_campo']=$pk_field;
    $collection['collection']=$collection['base_table'];

    $qtyEs='quantity';
    $sufijo_pago = $documento === 'vale' ? '_uso' : '_pago';
    $doc_pago_tabla = strtolower($documento.$sufijo_pago);

    $dpsql = "SELECT $commentSQL * FROM ".$documento.$sufijo_pago." WHERE ".$documento.$sufijo_pago."_id=".strit($documentoPagoID);
    $documentoPago = ia_singleton($dpsql);
    if(empty($documentoPago))
        return false;

    $itemID=$documentoPago[$documento."_id"];

    $cuentaT_mov_ori_id=$documentoPago["cuenta_t_mov_id"];

    $cuentat_mov_id_field = $documento === 'vale' ? "contra_mov_id" : "cuentaT_mov_id";

    $vs_doc = $documentoPago['vs_doc'] ?? $documento;
    $vs_doc = strtolower($vs_doc);

    $sql_cuentat = "SELECT * FROM cuentat_mov WHERE $cuentat_mov_id_field = '$cuentaT_mov_ori_id'";
//echo "<li>$sql_cuentat";
    $cuentaT_arr = ia_singleton("$sql_cuentat");
    $cuentaT_mov_ori_contra_id = $cuentaT_arr['contra_mov_id'];

//    echo "<pre>cuentaT_arr" . print_r($cuentaT_arr, true) . "</pre>";
//    echo "<pre>documentoPago" . print_r($documentoPago, true) . "</pre>";

    $app_origen = $cuentaT_arr['app_origen'] ?? ucfirst($collection['base_table']);

    if(empty($cuentaT_arr))
        return false;

    if(empty($cuentaT_mov_ori_id))
        return false;

    // obten el item
    $item=ia_singleton("SELECT $commentSQL * FROM $collection[base_table] WHERE $collection[pk_campo]=".strit($itemID));
    /**
    if(empty($item))
    {
    //return false;
    }
     * **/

    $cliente='';
    if (empty($item['cliente_id']) and !empty($item['cliente'])){
        $cliente = $item['cliente'];
    } else {
        $cliente_id=$item['cliente_id'];
        if(empty($cliente_id)) $cliente_id=$item['cliente_proveedor_id'];
        if($cliente_id==0)
            $cliente=$item['name_on_check'];
    
        if($cliente_id>0)
            $cliente=ia_singleread("SELECT $commentSQL nombre FROM cliente WHERE cliente_id=".strit($cliente_id));
        $cliente=ia_htmlentities($cliente);        
    }

    // obten el pago
    $pago=$documentoPago;

    $pago_log_id = ia_guid();
    $cuentaT_mov_canc_id=ia_guid();

    $monto_afecta_cheque=-$pago['quantity'];
    $catID=tablaid($collection['base_table']);

    if(empty($catID))
        if($cat=='cheque')
            $catID=1000;
        elseif($cat=='pagare')
            $catID=1001;
        elseif($cat=='vale')
            $catID=1002;
        elseif($cat=='nota')
            $catID=1003;

    $monedaacta_txt=$pago['moneda_id']==1?' PESOS':'';
    $monedadocto_txt=$item['moneda_id']==1?' PESOS':'';

    $monedaacta_txt=$pago['moneda_id']==1?' PESOS':'';
    $monedadocto_txt=$item['moneda_id']==1?' PESOS':'';

    $moneda_signo_acta=$pago['moneda_id']==1?'$':'USD';
    $moneda_signo_docto=$item['moneda_id']==1?'$':'USD';

    $monto_acta_txt = $monto_acta_link_txt = "";

    if($monedadocto_txt == '')
        $class = 'txt_color_USD';
    else
        $class = 'txt_color_PESOS';

    if($monedaacta_txt == '')
        $class_acta = 'txt_color_USD';
    else
        $class_acta = 'txt_color_PESOS';


    if($pago['moneda_id']!=$item['moneda_id'])
    {
        $monto_acta_txt = "POR <strong class=\"$class\">$moneda_signo_docto ".echonf(abs($monto_afecta_cheque),true)."$monedadocto_txt</strong>";
        $monto_acta_link_txt = "POR <strong class=\"$monedaacta_txt\">$moneda_signo_acta " .echonf(abs(-$pago['deposit_total']),true)."$monedaacta_txt (<strong class=\"$class\">$moneda_signo_docto> ".echonf(abs($monto_afecta_cheque),true)."$monedadocto_txt</strong>)</strong>";
    }
    else
    {
        $monto_acta_txt = "POR <strong class=\"$monedaacta_txt\">$moneda_signo_acta " .echonf(abs($monto_afecta_cheque),true). "$monedaacta_txt</strong>";
        $monto_acta_link_txt = "POR <strong class=\"$monedaacta_txt\">$moneda_signo_acta " .echonf(abs(-$pago['deposit_total']),true). "$monedaacta_txt</strong>";
    }

    // dd_($collection['base_table']);

    $field_number = $collection['base_table'] == 'vale' ? 'vale_number' : 'numero';
    $in = array_key_exists($field_number,$item) ? $item[$field_number] : $item[$field_number];
    $aDoc = "<a title='Abrir el $collection[base_table]' href='../backoffice/$collection[base_table].php?iah=e&id=$itemID' target='_blank'><strong>".strtoupper($collection['base_table'])." # $in</strong></a>";

    $note = $comentario =   "<li>SE ELIMINA EL <strong><em>A CUENTA</em></strong> $monto_acta_txt DEL <strong>***</strong>$aDoc, "
        ."CLIENTE: <strong>".$cliente."</strong>, <strong class=\"$class\">$moneda_signo_docto "
        .echonf($item['quantity'],true)."$monedadocto_txt</strong><strong>***</strong>.".
        "<br /><br /><span class=\"txt_080em\">USUARIO RESPONSABLE: </span><strong>$usuario</strong>.";

    $comentariopl = "<li>SE ROMPE LINK $monto_acta_link_txt DEL <strong><em>A CUENTA</em></strong> $monto_acta_txt DEL <strong>***</strong>$aDoc, "
        ."CLIENTE: <strong>".$cliente."</strong>, <strong class=\"$class\">$moneda_signo_docto "
        .echonf($item['quantity'],true)."$monedadocto_txt</strong>***.".
        "<br /><br/><span class=\"txt_080em\">USUARIO RESPONSABLE: </span>";


    $metodo_pago = ''; // VCA.
    $banco_cuenta_mov_id = array_key_exists( 'banco_cuenta_mov_link_id',$pago) ? $pago['banco_cuenta_mov_link_id'] : null;
    $pago['banco_cuenta_mov_link_id'] = ''; //VCA: Para activar el trigger de saldo de cuenta T.
    $tienda_id = empty($pago['tienda_id']) ? $item['tienda_id'] : $pago['tienda_id'];

    $cuentaT_mov_link_ori_id = "";

    /**Arreglo del totalpayments y saldo en cheques y pagares **/
    $tpsql = "SELECT /** Calculo total_payments **/ IF(ISNULL(SUM($qtyEs)),0,SUM($qtyEs)) FROM ".$documento."_pago WHERE $collection[pk_campo]=".strit($itemID)." AND ".$documento."_pago_id<>".strit($documentoPagoID);

    $doc_total_payments = ia_singleread($tpsql);

    $tuvoLink = false;

    if( !empty($banco_cuenta_mov_id ) && $banco_cuenta_mov_id != 'pendiente' && $banco_cuenta_mov_id != 'roto' )
    {
        //VCA
        $accion='RompeLink';
        $sinJSON=true;
        // regresa true si pudo false si no pudo
        $tuvoLink=RompeLinkBancario($banco_cuenta_mov_id ,$usuario,addslashes($comentariopl), $note, false);
        if(is_array($tuvoLink) && !empty($tuvoLink) && array_key_exists('sql', $tuvoLink) && is_array($tuvoLink['sql']))
        {
            foreach($tuvoLink['sql'] as $v)
                $sql[] = $v;
        }

        //echo "tuvoLink: <pre>".print_r($tuvoLink, true)."</pre>";

        // ** // ia_query("DELETE FROM $collection[base_table]_pago WHERE $collection[base_table]_pago_id=".strit($documentoPagoID)." LIMIT 1");
        $sql[]="DELETE $commentSQL FROM $collection[base_table]_pago WHERE $collection[base_table]_pago_id=".strit($documentoPagoID)." LIMIT 1";
        // ** // ia_query("UPDATE $collection[base_table] SET total_payments=total_payments+$monto_afecta_cheque, paid='0', paid_when=NULL WHERE $collection[pk_campo]=".strit($itemID )." LIMIT 1");
        $autorizado=$item['autorizado']=='Si'?true:false;
        $ultimo_mov="";

        //VCA bitácora de verificaciones. 24-11-2020
        //if($autorizado && !is_array($tuvoLink) && empty($tuvoLink))
        //$ultimo_mov=",ultimo_movimiento='A CUENTA BORRADO', desautorizado_el='$now', autorizado='No', autorizado_el=NULL";
        //$ultimo_mov=", desautorizado_el='$now', autorizado='No', autorizado_el=NULL";
        //VCA bitácora de verificaciones. 24-11-2020
        //OJO VCA aquí empieza el 25-11-2020
        //JJ validacion para definicion de campo de cuantat_mov_id, en vale tiene otro nombre
        $campoCuantaTMovId = trim($collection['base_table']) == 'vale' ? 'cuenta_t_mov_id': 'cuentat_mov_id';
        $saldos = "total_payments=$doc_total_payments,";
        if (trim($collection['base_table']) == 'vale') {
            //VCA 01-Jun-2021 Rony pidió que cuando se borre un vale_pago y el vale quede en cero, se ponga aplicado. Sólo él puede revivirlo, agregando un vale_pago solamente.
            $extra_aplicado = "";
            if($item['saldo'] - $pago['quantity'] <= 0)
                $extra_aplicado = " aplicado = 1, paid = 1, ";
            $saldos = "quantity = quantity - $pago[quantity], saldo = saldo - $pago[quantity]," . $extra_aplicado;
        }

        $sql[]="UPDATE $commentSQL $collection[base_table] SET
            $saldos
            paid='0',
            paid_when=NULL,
            ultimo_cambio='$now',
            ultimo_cambio_por='$usuario',
            
            $campoCuantaTMovId='$cuentaT_mov_canc_id'
            $ultimo_mov
            WHERE $collection[pk_campo]=".strit($itemID)." LIMIT 1";

        //if($ajustaCuentaT == 'SI') //Si tiene link bancario, se ajusta la cuenta T forzosamente. Estoy seguro de que después querrá lo contrario.
        //{
        $ajustaCuentaT = 'SI';

        $contra_mov_id = '';

        if(is_array($tuvoLink) && $tuvoLink != false)
        {
            //$cuentaT_arr = ia_singleton("SELECT $commentSQL /** Link ya roto **/ * FROM cuentat_mov WHERE cuentaT_mov_id = '$tuvoLink[link_roto_id]'");
            $cuentaT_arr = $tuvoLink['arr_cuentat_mov'];
            //$cuentaT_mov_ori_id = $tuvoLink['cuentat_mov'];
            $cuentaT_mov_link_ori_id = $tuvoLink['link_ori_id'];
            //De volada actualizo el movimiento de cuenta t original y lo marco como que si tiene contraparte.
            // ** // ia_query("UPDATE cuentat_mov SET activo='No' WHERE cuentaT_mov_id='$tuvoLink[cuentat_mov]'");
            $sql[]="UPDATE $commentSQL /** Link ya roto **/ cuentat_mov
SET activo='No', banco_cuenta_mov_link_id='$cuentaT_mov_ori_id', origen_mov_id = '$pago_log_id'
WHERE cuentaT_mov_id='$cuentaT_mov_ori_id' OR contra_mov_id='$cuentaT_mov_ori_id'";
            //Aqui falta el original.
            // // // // // // // // // // //
            $contra_mov_id = $tuvoLink['link_roto_id'];
            //generayGuardaaCuentasdeBancoMov($tuvoLink['banco_cuenta_mov_id']);
        }
        else
        {
            $cuentaT_arr = ia_singleton("SELECT * FROM cuentat_mov WHERE origen_mov_id = '$documentoPagoID' ORDER BY alta_db ASC");
        }

        //De volada actualizo el movimiento de cuenta t original y lo marco como que si tiene contraparte.
        // ** // ia_query("UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_canc_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_arr[cuentaT_mov_id]'");
        $sql[]="UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_canc_id', activo='No', banco_cuenta_mov_link_id='$cuentaT_mov_ori_id'  WHERE cuentaT_mov_id='$cuentaT_arr[cuentaT_mov_id]'";

        $cuentaT_arr['origen_mov_id'] = $cuentaT_arr['cuentaT_mov_id'];
        $dateTmp = new DateTime($cuentaT_arr['alta_db']);
        $dateTmp->modify('+1 second');
        $now=$dateTmp->format('Y-m-d H:i:s');

        if(empty($cuentaT_arr))
        {
            $cuentaT_arr['cuentaT_id']=$pago['cuentaT_id'];
            $cuentaT_arr['cuentaT_tipo_mov_id']=$pago['metodo_pago_id'];
            $cuentaT_arr['app_origen']=ucfirst($collection['base_table']);
        }

        $pago['comentario']=$comentario."<li>".$pago['comentario'];
        $sql[]="INSERT $commentSQL INTO cuentat_mov (cuentaT_mov_id,cuentaT_id,fecha
                ,cuentaT_tipo_mov_id
                ,egreso,quantity_total,moneda_id,tipo_cambio
                ,banco_cuenta_id,referencia,remarks
                ,banco_cuenta_mov_link_id
                ,alta_por,esta_en,alta_db,tipo,origen_mov_id,app_origen,fecha_deposito,deposit_total,contra_mov_id,activo,tienda_id)
                VALUES(".stritc($cuentaT_mov_canc_id).stritc($cuentaT_arr['cuentaT_id'])."'$now',"
            .stritc($cuentaT_arr['cuentaT_tipo_mov_id'])
            .stritc($pago['quantity_ctat']).stritc($pago['quantity_total']).stritc($pago['moneda_id']).stritc($pago['tipo_cambio'])
            .stritc($pago['banco_cuenta_id']).stritc($pago['referencia']).stritc($pago['comentario'])
            //.stritc($pago['banco_cuenta_mov_link_id'])
            .stritc($cuentaT_mov_ori_id)
            .stritc($usuario)."'done','$now','Egreso',"
            .stritc($cuentaT_arr['origen_mov_id'])
            .stritc($cuentaT_arr['app_origen'])
            .stritc($pago["deposit_fecha"])
            .stritc($pago['deposit_total'])
            .stritc($contra_mov_id)."'No', ".strit($tienda_id)." )";
        // ** //ia_query($sql);
        //}

        //HAck porque no doy cómo poner este uuid desde la funcion rompelinkbancario
        $sql[]="UPDATE cuentat_mov SET banco_cuenta_mov_link_id='$cuentaT_mov_ori_id' WHERE cuentaT_mov_id='$contra_mov_id'";
        $sql[] = "UPDATE  /** RompeLinkBancario borraDocumentoPago **/ cuentat_mov 
          SET contra_mov_id = '{$tuvoLink['arr_cuentat_mov']['contra_mov_id']}', 
              banco_cuenta_mov_link_id = '{$tuvoLink['arr_cuentat_mov']['contra_mov_id']}' 
          WHERE cuentaT_mov_id = '{$tuvoLink['arr_cuentat_mov']['origen_mov_id']}'";


//        echo "<pre>tuvoLink".print_r($tuvoLink, true)."</pre>";
//        echo "<pre>sql".print_r($sql, true)."</pre>";
        // ** //ia_query($sql);
    }
    else if($doc_pago_tabla !== 'vale_uso')
    {
        // ** // ia_query("DELETE FROM $collection[base_table]_pago WHERE $collection[base_table]_pago_id=".strit($documentoPagoID)." LIMIT 1");
        $sql[]="DELETE $commentSQL FROM $collection[base_table]_pago WHERE $collection[base_table]_pago_id=".strit($documentoPagoID)." LIMIT 1";
        // ** // ia_query("UPDATE $collection[base_table] SET total_payments=total_payments+$monto_afecta_cheque, paid='0', paid_when=NULL  WHERE $collection[pk_campo]=".strit($itemID )." LIMIT 1");
        //$total_payments=ia_singleread("SELECT SUM(quantity) FROM cheuqe_pago WHERE cheqie_id=IDDELDOC");

        //VCA bitácora de verificaciones. 24-11-2020
        //ultimo_movimiento='A CUENTA BORRADO',
//            autorizado='No',
//            autorizado_el=NULL,
//            desautorizado_el='$now',
        //$campoCuantaTMovId = trim($collection['base_table']) == 'vale' ? 'cuenta_t_mov_id': 'cuentat_mov_id';
        $campoCuantaTMovId = trim($collection['base_table']) == 'vale' ? ", cuenta_t_mov_id = '$cuentaT_mov_canc_id'": '';
        $saldos = "total_payments=$doc_total_payments,";
        if (trim($collection['base_table']) == 'vale') {
            //VCA 01-Jun-2021 Rony pidió que cuando se borre un vale_pago y el vale quede en cero, se ponga aplicado. Sólo él puede revivirlo, agregando un vale_pago solamente.
            $extra_aplicado = "";
            if($item['saldo'] - $pago['quantity'] <= 0)
                $extra_aplicado = " aplicado = 1, paid = 1, ";
            $saldos = "quantity = quantity - $pago[quantity], saldo = saldo - $pago[quantity]," . $extra_aplicado;
        }
        $sql[]="UPDATE $commentSQL $collection[base_table] SET
            $saldos
            paid='0',
            paid_when=NULL,
            ultimo_cambio='$now',
            ultimo_cambio_por='$usuario'
            $campoCuantaTMovId
            WHERE $collection[pk_campo]=".strit($itemID )." LIMIT 1";

        $razon_cancelacion = empty($razon_cancelacion)?'':"<br/><br/><span class=\"txt_080em\">MOTIVO DE CANCELACIÓN:</span> <span class=\"remarks_por_usuario motivo_cancelacion\">" . $razon_cancelacion . "</span>";
        $comentario_original = empty($pago['comentario'])?$razon_cancelacion:"$razon_cancelacion<hr class=\"dashed_red\"/><span class=\"txt_080em\">REMARKS ORIGINALES:</span> <span class=\"remarks_por_usuario\">" . $pago['comentario'] . "</span>";

        if(!empty($pago['vs_doc']) && !empty($pago['vs_doc_key']))
        {
            $pago['comentario']=$comentario.$comentario_original;//"<li>".$pago['comentario'];
            $ajustaCuentaT = 'NO';
        }
        else
        {
            $pago['comentario']=$comentario.$comentario_original.($ajustaCuentaT=="NO" ? "<br><br><span class='sin_ajustar_cuentat'>SIN AJUSTAR CUENTA T.</span>":"<br><br><span class='con_ajustar_cuentat'>SE AJUSTÓ CUENTA T.</span>");//"<li>".$pago['comentario'];
        }

        if($ajustaCuentaT=='NO')
        {
            /*$activo_txt="";
            $activo="Si";*/
            $activo_txt=", activo='No'";
            $activo="No";
        }
        else
        {
            $activo_txt=", activo='No'";
            $activo="No";
        }

        $cuentaT_sql = "SELECT * FROM cuentat_mov WHERE origen_mov_id = '$documentoPagoID'";

        //echo "<li>$cuentaT_sql"; //VCA OJO, ARREGLAR cuenta_t_mov_id de los vale_pago importados. Arreglado por José 20-02-2021

        $cuentaT_arr = ia_singleton($cuentaT_sql);

        //$cuentaT_mov_ori_id = $cuentaT_arr['cuentaT_mov_id'];
        //De volada actualizo el movimiento de cuenta t original y lo marco como que si tiene contraparte.
        // ** // ia_query("UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_canc_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_arr[cuentaT_mov_id]'");
        $sql[]="UPDATE $commentSQL cuentat_mov SET banco_cuenta_mov_link_id='$cuentaT_mov_ori_id', contra_mov_id='$cuentaT_mov_canc_id' $activo_txt WHERE cuentaT_mov_id='$cuentaT_arr[cuentaT_mov_id]'";

        $cuentaT_arr['origen_mov_id'] = $cuentaT_arr['cuentaT_mov_id'];

        if(empty($cuentaT_arr))
        {
            $cuentaT_arr['cuentaT_id']=$pago['cuentaT_id'];
            $cuentaT_arr['cuentaT_tipo_mov_id']=$pago['metodo_pago_id'];
            $cuentaT_arr['app_origen']=ucfirst($collection['base_table']);
        }

        //VCA 17-09-2021 El contramovimiento en compra es ingreso. No había sucedido antes.
        $tipo_cuentat_mov = 'Egreso';
        $monto_cuentat_mov = 0.00;
        $egreso_cuentat_mov = $ajustaCuentaT=='SI' ? $pago['quantity_ctat']: 0.00;
        if($documento == 'compra') {
            $tipo_cuentat_mov = 'Ingreso';
            $monto_cuentat_mov = $ajustaCuentaT=='SI' ? $egreso_cuentat_mov : 0.00;
            $egreso_cuentat_mov = 0.00;
        }
        $sql[]="INSERT INTO cuentat_mov (cuentaT_mov_id,cuentaT_id,fecha
                ,cuentaT_tipo_mov_id
                ,egreso,monto,quantity_total,moneda_id,tipo_cambio
                ,banco_cuenta_id,referencia,remarks
                ,banco_cuenta_mov_link_id
                ,alta_por,esta_en,alta_db,tipo,origen_mov_id,app_origen,contra_mov_id,fecha_deposito,deposit_total,activo,tienda_id)
                VALUES(".stritc($cuentaT_mov_canc_id).stritc($cuentaT_arr['cuentaT_id'])."'$now',"
            .stritc($cuentaT_arr['cuentaT_tipo_mov_id'])
            .stritc($egreso_cuentat_mov)
            .stritc($monto_cuentat_mov)
            .stritc($pago['quantity_total'])
            .stritc($pago['moneda_id'])
            .stritc($pago['tipo_cambio'])
            .stritc($pago['banco_cuenta_id'])
            .stritc($pago['referencia'])
            .stritc($pago['comentario'])
            .stritc($cuentaT_mov_ori_id)
            .stritc($usuario)
            ."'done','$now',"
            .stritc($tipo_cuentat_mov)
            .stritc($cuentaT_arr['origen_mov_id'])
            .stritc($cuentaT_arr['app_origen'])
            .stritc($cuentaT_arr['origen_mov_id'])
            .stritc($pago["deposit_fecha"])
            .stritc($pago['deposit_total'])
            .stritc($activo)
            .strit($tienda_id).")";
        // ** // ia_query($sql);

        // ** // ia_query($sql);
    }

    if($doc_pago_tabla !== 'vale_uso') {
        $sql[] = "INSERT INTO kv_record_log(collection_id,record_id,usuario,note,kv_accion_log_id,alta_db) VALUES("
            . stritc($catID) . stritc($itemID) . stritc($usuario) . stritc($note) . "11,NOW())";

        //Insertamos un registro en bitacora de a cuentas.
//    if(empty($pago['comentario']))
//        $pago['comentario']=$comentario.$pago['comentario'];
//    if($ajustaCuentaT == 'SI')
//        $pago["comentario"] .= "<br/>SE AJUSTÓ CUENTA T.";
        $sql[] = "INSERT INTO $collection[base_table]_pago_log (
        $collection[base_table]_pago_log_id,
        $collection[base_table]_pago_id,
        $collection[collection]_id,
        fecha_borrado,
        fecha,
        quantity,
        quantity_total,
        deposit_total,
        ide_percent,
        ide_amount,
        tarjeta_percent,
        tarjeta_amount,
        moneda_id,
        tipo_cambio,
        metodo_pago_id,
        banco_cuenta_id,
        banco_cuenta_mov_link_id,
        referencia,
        comentario,
        ultimo_cambio_por,
        alta_por,
        cuentaT_id,
        deposit_fecha,
        numero,
        comision_amount,
        comision_percent,
        ultimo_cambio,
        factura,
        ivacobradox100,
        ivacobradototal,
        empresa_id,
        factura_numero,
        cash_nota_num,
        cliente,
        tipo_cash_nota,
        cobra_iva,
        tienda_id,
        numero_referencia,
        cuenta_t_mov_id)
        VALUES(" .
            stritc($pago_log_id) .
            stritc($pago["$collection[base_table]_pago_id"]) .
            stritc($pago["$collection[base_table]_id"]) .
            stritc($now) .
            stritc($pago["fecha"]) .
            stritc($pago["quantity"]) .
            stritc($pago["quantity_total"]) .
            stritc($pago["deposit_total"]) .
            stritc($pago["ide_percent"]) .
            stritc($pago["ide_amount"]) .
            stritc($pago["tarjeta_percent"]) .
            stritc($pago["tarjeta_amount"]) .
            stritc($pago["moneda_id"]) .
            stritc($pago["tipo_cambio"]) .
            stritc($pago["metodo_pago_id"]) .
            stritc($pago["banco_cuenta_id"]) .
            stritc($pago["banco_cuenta_mov_link_id"]) .
            stritc($pago["referencia"]) .
            "'" . addslashes($pago["comentario"]) . "'," .
            stritc($usuario) .
            stritc($usuario) .
            stritc($pago["cuentaT_id"]) .
            stritc($pago["deposit_fecha"]) .
            stritc($pago['numero']) .
            stritc($pago['comision_amount']) .
            stritc($pago['comision_percent']) .
            stritc($now) .
            stritc($pago['factura']) .
            stritc($pago['ivacobradox100']) .
            stritc($pago['ivacobradototal']) .
            stritc($pago['empresa_id']) .
            stritc($pago['factura_numero']) .
            stritc($pago['cash_nota_num']) .
            stritc($pago['cliente']) .
            stritc($pago['tipo_cash_nota']) .
            stritc($pago['cobra_iva']) .
            stritc($pago['tienda_id']) .
            stritc($pago['numero_referencia']) .
            strit($cuentaT_mov_canc_id) . ")";
        // ** // ia_query($sql);
    }
    //@TODO: si es pago via sustituye. Revisar origen y contra id
    if(!empty($pago['vs_doc']) && !empty($pago['vs_doc_key']))
    {
        $vs_doc=strtolower($pago['vs_doc']);
        $pago['vs_pago_key'] = $doc_pago_tabla == 'vale_uso' ? $pago['vale_uso_id'] : $pago['vs_pago_key'];
        $vsDoc=ia_singleton("SELECT * FROM $vs_doc WHERE $vs_doc"."_id=".strit($pago['vs_doc_key']) );
        $vsPago=ia_singleton("SELECT * FROM $vs_doc"."_uso WHERE $vs_doc"."_uso_id=".strit($pago['vs_pago_key']) );
        //echo print_r($vsPago,true);

//        echo "<pre>vsDoc" . print_r($vsDoc, true) . "</pre>";
//        echo "<pre>vsPago" . print_r($vsPago, true) . "</pre>";

        //echo "SELECT * FROM $vs_doc"."_uso WHERE $vs_doc"."_uso_id=".strit($pago['vs_pago_key']);

        $vsPagoLog = $vsPago;
        $vsPagoLog['alta_por']=$usuario;
        $vsPagoLog['fecha_borrado']=$now;
        $vsPagoLog['comentario']=$comentario;
        $vsPagoLog['vale_uso_log_id']=ia_guid();
        $vsPagoLog['cuenta_t_mov_id']=$cuentaT_mov_canc_id;
        $sql[] = ia_insert($vs_doc.'_uso_log',$vsPagoLog);
        // ** // ia_query($sql);
        $aplicado = '';
        $update_origen_id = '';
        if($vs_doc == 'vale') {
            $aplicado = ',aplicado=0';
            $update_origen_id = ' ,origen_mov_id = ' . strit($pago['vs_doc_key']);
        }

        // ** // ia_query("UPDATE $vs_doc SET total_payments=total_payments-".strit($pago['quantity_total']).",paid=0, paid_when=NULL $aplicado  WHERE $vs_doc"."_id=".strit($pago['vs_doc_key'])." LIMIT 1" );
        //$total_payments=ia_singleread("SELECT SUM(quantity) FROM cheuqe_pago WHERE cheqie_id=IDDELDOC");

        /**Arreglo del totalpayments y saldo en cheques y pagares **/
        $tpsql = "SELECT /**Calculo total_payments **/ IF(isnull(SUM($qtyEs)),0,SUM($qtyEs)) FROM ".$vs_doc."_uso WHERE $vs_doc"."_id=".strit($pago['vs_doc_key'])." AND ".$vs_doc."_uso_id<>".strit($pago['vs_pago_key']);
//        echo "<li>".$tpsql;
        $doc_total_payments = ia_singleread($tpsql);

        $sql[]="UPDATE $vs_doc SET total_payments=$doc_total_payments,paid=0, paid_when=NULL $aplicado  WHERE $vs_doc"."_id=".strit($pago['vs_doc_key'])." LIMIT 1";
        // ** // ia_query("DELETE FROM $vs_doc"."_uso WHERE $vs_doc"."_uso_id=".strit($pago['vs_pago_key'])." LIMIT 1" );
        $sql[]="DELETE FROM $vs_doc"."_uso WHERE $vs_doc"."_uso_id=".strit($pago['vs_pago_key'])." LIMIT 1";

        $comentario = addslashes($comentario);
        $sql[]="UPDATE cuentat_mov SET activo = 'No', remarks = CONCAT('$comentario',remarks) $update_origen_id WHERE origen_mov_id = '$documentoPagoID' OR cuentaT_mov_id = '$cuentaT_mov_ori_id'";

        // Agregamos otro log para el vale que se uso para sustituir.
        $cat_id=32; //tablaid($this->parentClass); // El id de la tabla vale en el catálogo de tablas: tablas

        $cat_accion = 15; //Sustituye
        $now = date('Y-m-d H:i:s');

        $sql[]="INSERT INTO kv_record_log(collection_id,record_id,usuario,note,kv_accion_log_id,alta_db) VALUES("
            .stritc($cat_id).stritc($pago['vs_doc_key']).stritc($usuario).stritc($note).stritc($cat_accion).strit($now).")";
//        echo "<pre>sql" . print_r($sql, true) . "</pre>";
        //echo "$sql";

        // ** // ia_query($sql);
    }

    //FIX: VCA 14-07-2020 para que el movimiento en cuentat tenga el origen igual al contra.
//    $sql[] = "UPDATE /** FIX: contra=origen **/ cuentat_mov SET origen_mov_id='$cuentaT_mov_ori_id' WHERE cuentat_mov_id='$cuentaT_mov_ori_contra_id'";

//    echo "<pre>sql" . print_r($sql, true) . "</pre>";
    actualizaSaldosACuentas($sql,null,$documento,$itemID,$documentoPagoID);
    if($do=='SI')
    {

        if(ia_transaction($sql)) {
            ia_errores_a_dime('','','',true);
            return false;
        }
        if(is_array($tuvoLink) && $tuvoLink != false)
            generayGuardaaCuentasdeBancoMov($tuvoLink['banco_cuenta_mov_id'], false, true, false, true);
        return true;
    }
    else
        return $sql;

}

function buscaClientesconNombreParecido($nombreCliente='', $campo='nombre', $tabla='cliente', $cliente_id = '')
{
    if(empty($nombreCliente))
        return false;

    $onombreCliente = $nombreCliente = quitaespaciosintermedios($nombreCliente);

    $tmpNC = explode(" ",$nombreCliente);

    $cuantasPalabras = 0;
    if(sizeof($tmpNC)>1 && is_array($tmpNC) && !empty($tmpNC)) foreach($tmpNC as $k=>$v)
    {
        if(strlen($v) > 2)
        {
            $tmpNC[$k] = substr($v,0,2) . '%';
            $cuantasPalabras++;
        }
        else
            unset($tmpNC[$k]);
    }

    if($cuantasPalabras>1)
        $nombreCliente = implode(' ',$tmpNC);
    else
        $nombreCliente = '';

    $cliente_id = !empty($cliente_id) ? " AND cliente_id <> ".strit($cliente_id) : "";
    //Hay que revisar siempre la busqueda identica.
    $clientesql = "SELECT $campo FROM $tabla WHERE ($campo LIKE '$nombreCliente' OR $campo LIKE '$onombreCliente') $cliente_id";
    $arr_cliEncontrados = ia_sqlArrayIndx($clientesql);
    //echo "<pre>".print_r($arr_cliEncontrados,true)."</pre>";
    $txt_cliEncontrados = '';

    if(is_array($arr_cliEncontrados) && sizeof($arr_cliEncontrados) > 0) foreach($arr_cliEncontrados as $k=>$v)
    {
        //echo "<pre>".print_r($v,true)."</pre>";
        $txt_cliEncontrados.="<li><strong>$v[nombre]</strong>";
    }

    return $txt_cliEncontrados;
}

function marcaCerradoDocumento($doc, $doc_id, $do='SI')
{

    if(empty($doc) || empty($doc_id))
        return false;
    //VCA está provocando deadlock por el trigger que actualiza el saldo
    $sql = array();
    $sql[] = "SET @TRIGGER_DISABLED = 1;";
    $sql[] = "UPDATE /*marcacerradoDocumento*/ $doc SET abierto_por = '', abierto_el = null WHERE ".$doc."_id = '$doc_id'";
    $sql[] = "SET @TRIGGER_DISABLED = 0;";

    //ia_query("INSERT INTO dime (script,dime,usuario) VALUES ('sql".ia_guid()."',".strit($sql).",".strit($_SESSION['usuario']).")");

    if($do=='SI')
    {
        if(ia_transaction($sql))
            return false;
        else
            return true;
    }
    else
        return $sql[1];
}

function marcaAbiertoDocumento($doc, $doc_id, $usuario = '')
{

    if(empty($doc) || empty($doc_id))
        return false;

    $now = date('Y-m-d H:i:s');

    if(empty($usuario))
        $usuario = $_SESSION['usuario'];


    $sql = array();
    $sql[] = "SET @TRIGGER_DISABLED = 1;";

    $sql[] = "UPDATE /*marcaabiertoDocumento*/ $doc SET abierto_por = '$usuario', abierto_el = '$now' WHERE ".$doc."_id = '$doc_id'";
//    echo "MI POENE";
//    echo "<pre>".print_r($sql, true)."</pre>";
//    die();
//
    $sql[] = "SET @TRIGGER_DISABLED = 0;";

    if(ia_transaction($sql))
        return false;

    return true;

}

function debeCerrarDocumento($doc, $doc_id, $usuario = '')
{
    global $gIAParametros;

    if(empty($doc) || empty($doc_id))
        return false;

    if(empty($usuario))
        $usuario = $_SESSION['usuario'];

    if(no_hay_usuario_logeados())
        return false;

    $doc_abierto = ia_singleton("SELECT /*debeCerrarDocumento*/ abierto_el, abierto_por FROM $doc WHERE ".$doc."_id = '$doc_id'");

    if(empty($doc_abierto) || !is_array($doc_abierto))
        return false;

    if((diferenciadeTiempo($doc_abierto['abierto_el'],'','minutos') >= $gIAParametros['tiempo_para_cerrar_documento']))
        return true;

    return false;
}

function no_hay_usuario_logeados(): bool
{
    // if(estoyCompudeRony())
    //     return false;

    $Login_log = new Login_log();
    return $Login_log->without_me_count() == 0;
}

function estatusDocumento($doc, $doc_id)
{
    global $gIAParametros;

    if(empty($doc) || empty($doc_id))
        return false;

    if(empty($usuario))
        $usuario = $_SESSION['usuario'];

    $doc_abierto = ia_singleton("SELECT /*estatusDocumento*/ abierto_el, abierto_por, puede_borrar, alta_db, autorizado_el, autorizado, bloqueado_el  FROM $doc WHERE ".$doc."_id = '$doc_id'");


    if(empty($doc_abierto) || !is_array($doc_abierto)) {
        $doc_abierto['status'] = 'NO EXISTE';
        return $doc_abierto;
    }

    $autorizado = $doc_abierto['autorizado'] == 'Si' ? true:false;
    $puede_borrar = $doc_abierto['puede_borrar'] == 'Si' ? true:false;
    $puede_borrar_tiempo = diferenciadeTiempo($doc_abierto['alta_db'],'','minutos') <= $gIAParametros['tiempo_para_borrar_documento'] ? true:false;

    $bloqueado_el = !empty($doc_abierto['bloqueado_el']) ? strtotime($doc_abierto['bloqueado_el']) : -1;
    $autorizado_el = !empty($doc_abierto['autorizado_el']) ? strtotime($doc_abierto['autorizado_el']) : -1;
    $abierto_el = !empty($doc_abierto['abierto_el']) ? strtotime($doc_abierto['abierto_el']) : -1;
    $abierto_por = $doc_abierto['abierto_por'];
    $se_bloqueo_autorizo_mientras_abierto = false;

    $doc_abierto['lolz'] = array("bloqueado_el" => $bloqueado_el,
        "autorizado_el" => $autorizado_el,
        "abierto_el" => $abierto_el,
        "abierto_por" => $abierto_por);

    if($abierto_el > -1 && !empty($abierto_por) &&
        ($autorizado_el > -1 && ($abierto_el < $autorizado_el) ||
            $bloqueado_el > -1 && ($abierto_el < $bloqueado_el)))
        $se_bloqueo_autorizo_mientras_abierto = true;
//    $puede_borrar_tiempo = $puede_borrar ? $puede_borrar_tiempo : $puede_borrar;

//    $dif_autorizado = -1; $dif_abierto = -1;
//
//    if($autorizado || !$puede_borrar)// || !$puede_borrar_tiempo)
//        $dif_autorizado = diferenciadeTiempo($doc_abierto['autorizado_el'],'','minutos');
//
//    if(!empty($doc_abierto['abierto_por']) || !empty($doc_abierto['abierto_el']) )
//        $dif_abierto = diferenciadeTiempo($doc_abierto['abierto_el'],'','minutos');
//
//    if($dif_autorizado > 0 && $dif_abierto > 0 && $dif_autorizado <= $dif_abierto){
//        $se_bloqueo_autorizo_mientras_abierto = true;
//    }


//    echo "dif_autorizado: $dif_autorizado, dif_abierto: $dif_abierto, autorizado: $autorizado, puede_borrar: $puede_borrar, puede_borrar_tiempo: $puede_borrar_tiempo, se_bloqueo_autorizo_mientras_abierto: $se_bloqueo_autorizo_mientras_abierto";

    if($se_bloqueo_autorizo_mientras_abierto){
        $doc_abierto['status'] = 'RECARGAR';
    }
    else {
        if (!empty($doc_abierto['abierto_por']) || !empty($doc_abierto['abierto_el']) ) {
            if ((diferenciadeTiempo($doc_abierto['abierto_el'], '', 'minutos') >= $gIAParametros['tiempo_para_cerrar_documento']))
                $doc_abierto['status'] = 'EXPIRADO';
            else {

                $doc_abierto['status'] = 'ABIERTO';

            }
        } else
            $doc_abierto['status'] = 'CERRADO';
    }
//    ia_query("INSERT INTO dime (script,dime,usuario) VALUES ('estatusDocumento".ia_guid()."',".strit(print_r($doc_abierto, true). "dif_autorizado: $dif_autorizado, dif_abierto: $dif_abierto, autorizado: $autorizado, puede_borrar: $puede_borrar, puede_borrar_tiempo: $puede_borrar_tiempo").",".strit($_SESSION['usuario']).")");

    return $doc_abierto;
}


function esCuentaTde($cuentaTID='')
{
    if(empty($cuentaTID))
        return null;

    return strtolower(ia_singleread("SELECT es_de FROM cuentat WHERE cuentaT_id=".strit($cuentaTID)));
}

function tiendaIDdeCtaT($cuentaTID='')
{
    if(empty($cuentaTID))
        return null;

    return ia_singleread("SELECT tienda_id FROM cuentat WHERE cuentaT_id=".strit($cuentaTID));
}

function propdeCtaT($cuentaTID='',$prop='es_de',$upper=false)
{
    if(empty($cuentaTID))
        return null;

    $enDB = ia_singleton("SELECT * FROM cuentat WHERE cuentaT_id=".strit($cuentaTID));
    //echo "<pre>".print_r($enDB, true)."</pre>"; die();
    $str2func=$upper?"strtoupper":"strtolower";
    return array_key_exists($prop,$enDB) ? $str2func($enDB[$prop]):null;
}

function numRefLink()
{
    /*$guid = strtoupper(ia_guid());
    $guid = substr($guid,-9);

    $guid = date('z').$guid;
    return $guid;*/
    $ano = date('y');
    $dia = date('z');

    $base = $ano.$dia;
    $cons = ia_singleread("select iac_seq('$base')");

    return (string) $dia.$cons;
}


/**
 * Checks if a string contains HTML entities and decodes them if found.
 *
 * @param string $input The string to check and decode.
 * @return string The decoded string if HTML entities are found; otherwise, the original string.
 */
function decodeHtmlEntitiesIfNeeded(string $input): string {
    $decoded = htmlspecialchars_decode($input, ENT_QUOTES);

    // Compare the original string with the decoded version
    return $input !== $decoded ? $decoded : $input;
}


function preparaDiccionarioDatosBanco(): array
{

    $arrKW = array( 'Deposito'=>array(),
        'Retiro'=>array());

    $arrKWTemp = ia_sqlArrayIndx("SELECT * FROM banco_diccionario_dato WHERE activo='Si' ORDER BY orden ASC");
    //$arrKW['Retiro'] = ia_sqlArrayIndx("SELECT * FROM banco_diccionario_dato WHERE es='Retiro' AND activo='Si'");

    foreach($arrKWTemp as $k => &$kw2F)
    {
        if(array_key_exists('palabra_clave', $kw2F) && !empty($kw2F['palabra_clave']))
        {
            $tmpkW = explode(',',$kw2F['palabra_clave']);
            natsort($tmpkW);
            $tmpkW = array_values($tmpkW);
            if(!empty($tmpkW))
                foreach($tmpkW as $i=>$kw) $tmpkW[$i] = trim($kw);
            $kw2F['palabra_clave'] = $tmpkW;
            $kw2F['descripcion_a_poner'] = decodeHtmlEntitiesIfNeeded($kw2F['descripcion_a_poner']);

        }

        if(array_key_exists('banco_cuenta_no_aplica', $kw2F) && !empty($kw2F['banco_cuenta_no_aplica']))
        {
            $bc_sia = explode(',',$kw2F['banco_cuenta_no_aplica']);
            asort($bc_sia);
            $bc_sia = array_flip($bc_sia);

            if(!empty($bc_sia))
                foreach($bc_sia as $j=>&$bcs) $bcs = true;
            $kw2F['banco_cuenta_no_aplica'] = $bc_sia;

        }

        if($kw2F['es'] == 'Deposito')
            $arrKW['Deposito'][] = $kw2F;
        else
            $arrKW['Retiro'][] = $kw2F;
    }

    return $arrKW;
}

function preparaDiccionarioDatosBancoGastos($resalta_palabras = false)
{

    $arrKW = array(
        'si_buscar'=>array(),
        'no_buscar'=>array());

    $rp_txt = "";
    if($resalta_palabras)
        $rp_txt = " AND resalta_palabras = 'Si' ";

    $arrKWTemp = ia_sqlArrayIndx("SELECT * FROM banco_gasto_diccionario_dato WHERE activo='Si' $rp_txt");
    //$arrKW['Retiro'] = ia_sqlArrayIndx("SELECT * FROM banco_diccionario_dato WHERE es='Retiro' AND activo='Si'");

    foreach($arrKWTemp as $k => &$kw2F)
    {
        $kw2F['palabra_clave_org'] = $kw2F['palabra_clave'];
        if(array_key_exists('palabra_clave', $kw2F) && !empty($kw2F['palabra_clave']))
        {
            $tmpkW = explode(',',$kw2F['palabra_clave']);
            if(is_array($tmpkW)) foreach($tmpkW as $i=>$kw) $tmpkW[$i] = ltrim(trim($kw));
            $kw2F['palabra_clave'] = $tmpkW;
            $kw2F['palabra_clave_rp'] = implode(' ',$tmpkW);
        }

        if(array_key_exists('beneficiario', $kw2F) && !empty($kw2F['beneficiario']))
        {
            $tmpkW = explode(',',$kw2F['beneficiario']);
            if(is_array($tmpkW)) foreach($tmpkW as $i=>$kw) $tmpkW[$i] = ltrim(trim($kw));
            $kw2F['beneficiario'] = $tmpkW;
        }

        if(array_key_exists('subtitulo', $kw2F) && !empty($kw2F['subtitulo']))
        {
            $tmpkW = explode(',',$kw2F['subtitulo']);
            if(is_array($tmpkW)) foreach($tmpkW as $i=>$kw) $tmpkW[$i] = ltrim(trim($kw));
            $kw2F['subtitulo'] = $tmpkW;
        }

        if($kw2F['buscar_repetidos'] == 'Si')
            $arrKW['si_buscar'][] = $kw2F;
        else {
            if(!$resalta_palabras)
                $arrKW['no_buscar'][] = $kw2F;
            else
                $arrKW['no_buscar'][$kw2F['banco_gasto_diccionario_dato_id']] = $kw2F;
        }
    }

    return !$resalta_palabras ? $arrKW : $arrKW['no_buscar'];
}

function linksdeTodoalBancoLinksVale($valePagoWhere = "", $valeWhere = "", $orderby = "", $limit = "" ) {
    $valeWhere = empty($valeWhere) ? " WHERE " : $valeWhere . " AND ";
    $valePagoWhere = empty($valePagoWhere) ? " WHERE " : $valePagoWhere . " AND ";

    $sql = trim("
( SELECT d.vale_id AS link_id
    ,d.banco_cuenta_mov_link_id
    ,d.origen
    ,d.vale_id AS doc_id
    ,d.cuentaT_id
    ,d.tienda_id
    ,d.fecha
    ,d.banco_cuenta_id
    ,d.metodo_pago_id AS cuentaT_tipo_mov_id
    ,d.deposit_total AS deposit_total
    ,d.quantity_total AS quantity_total
    ,d.ide_amount
    ,d.ide_percent
    ,d.quantity_total AS egreso
    ,0.00 AS monto
    ,d.tipo_cash_nota
    ,d.cash_nota_num
    ,d.deposit_fecha
    ,d.deposit_cliente AS cliente
    ,d.factura
    ,d.factura_numero
    ,d.iva_incluido AS iva_incluido
    ,d.ivacobradox100
    ,if((d.iva_incluido = 'SI'),0.00,d.ivacobradototal) AS ivarealmentecobrado
    ,if((d.iva_incluido = 'NO'),0.00,d.ivacobradototal) AS ivacobradototal
    ,d.alta_db
    ,d.alta_por
    ,d.numero_referencia AS numero_referencia
    ,d.cash_num_cobro_iva
    ,d.empresa_id
    ,d.remarks
    ,'NO' AS puede_borrar
    ,if((d.cancelado = 1),'No','Si') AS activo
    ,afecta_cuentat AS afecta_cuentat
    ,d.comments AS comments
    ,d.autorizado AS autorizado
    ,d.rechazado AS rechazado
    ,d.revisado AS revisado
    ,d.autorizado_el AS autorizado_el
    ,d.autorizado_por AS autorizado_por
    ,d.MetodoPago AS MetodoPago
    ,d.FormaPago AS FormaPago
    ,d.UsoCFDI AS UsoCFDI
    ,d.iva_revisado AS iva_revisado
    ,d.iva_revisado_por AS iva_revisado_por
    ,d.iva_revisado_el AS iva_revisado_el
    ,d.ultimo_cambio
    ,d.ultimo_cambio_por
    ,d.cliente_rfc
    ,d.referencia
    ,d.cuenta_t_mov_id AS origen_mov_id
    ,'NO' AS factura_directa
    ,d.recibido_moneda_id AS moneda_id
FROM vale d $valeWhere (d.banco_cuenta_id > 0 and d.banco_cuenta_mov_link_id <> '') $orderby $limit ) ");

    if(VALE_PAGO_MULTIPLE) {
        $sql .= trim("\r\n
UNION ALL
( SELECT g.vale_pago_id AS link_id
    ,g.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
    ,g.origen AS origen
    ,g.vale_id AS doc_id
    ,g.cuentaT_id AS cuentaT_id
    ,g.tienda_id AS tienda_id
    ,g.fecha AS fecha
    ,g.banco_cuenta_id AS banco_cuenta_id
    ,g.metodo_pago_id AS cuentaT_tipo_mov_id
    ,g.deposit_total AS deposit_total
    ,g.quantity_total AS quantity_total
    ,g.ide_amount AS ide_amount
    ,g.ide_percent AS ide_percent
    ,g.quantity_ctat AS egreso
    ,0.00 AS monto
    ,g.tipo_cash_nota AS tipo_cash_nota
    ,g.cash_nota_num AS cash_nota_num
    ,g.deposit_fecha AS deposit_fecha
    ,g.cliente AS cliente
    ,g.factura AS factura
    ,g.factura_numero AS factura_numero
    ,g.iva_incluido AS iva_incluido
    ,g.ivacobradox100 AS ivacobradox100
    ,if((g.iva_incluido = 'SI'),0.00,g.ivacobradototal) AS ivarealmentecobrado
    ,if((g.iva_incluido = 'NO'),0.00,g.ivacobradototal) AS ivacobradototal
    ,g.alta_db AS alta_db
    ,g.alta_por AS alta_por
    ,g.numero_referencia AS numero_referencia
    ,g.cash_num_cobro_iva AS cash_num_cobro_iva
    ,g.empresa_id AS empresa_id
    ,g.comentario AS remarks
    ,g.puede_borrar AS puede_borrar
    ,g.activo AS activo
    ,afecta_cuentat AS afecta_cuentat
    ,g.comments AS comments
    ,g.autorizado AS autorizado
    ,g.rechazado AS rechazado
    ,g.revisado AS revisado
    ,g.autorizado_el AS autorizado_el
    ,g.autorizado_por AS autorizado_por
    ,g.MetodoPago AS MetodoPago
    ,g.FormaPago AS FormaPago
    ,g.UsoCFDI AS UsoCFDI
    ,g.iva_revisado AS iva_revisado
    ,g.iva_revisado_por AS iva_revisado_por
    ,g.iva_revisado_el AS iva_revisado_el
    ,g.ultimo_cambio AS ultimo_cambio
    ,g.ultimo_cambio_por AS ultimo_cambio_por
    ,g.cliente_rfc AS cliente_rfc
    ,g.referencia AS referencia
    ,g.cuenta_t_mov_id AS origen_mov_id
    ,'NO' AS factura_directa
    ,g.moneda_id AS moneda_id
FROM vale_pago g $valePagoWhere (g.banco_cuenta_id > 0 and g.banco_cuenta_mov_link_id <> '') $orderby $limit )");
    }

    return $sql;
}

function linksdeTodoalBanco($andWhere='',$orderby='',$origen='',&$sumasGridServer=array())
{
    global $gIAsql, $gIAParametros;

    if(!empty($andWhere))
    {
        if(strpos($andWhere, " AND (") == 0)
            $andWhere = substr($andWhere,5);

        //$andWhere = str_replace('(fecha','(c.fecha',$andWhere);

        $andWhere = " WHERE $andWhere ";
    }

    $chequeWhere = $andWhere;
    $chequeWhere = str_replace('cuentaT_tipo_mov_id','metodo_pago_id',$chequeWhere);
    $chequeWhere = str_replace('remarks','comentario',$chequeWhere);
    if($origen == "CANCELADOS")
        $chequeWhere = str_replace('egreso','quantity_ctat',$chequeWhere);
    else
        $chequeWhere = str_replace('egreso','quantity_total',$chequeWhere);
    //$chequeWhere = str_replace("afecta_cuentat='No'",'1=0',$chequeWhere);

    $valeWhere = $chequeWhere;
    $valeWhere = str_replace("activo='Si' AND",'',$valeWhere);
    $valeWhere = str_replace("activo='No' AND",'',$valeWhere);
    $valeWhere = str_replace("cliente","deposit_cliente",$valeWhere);
    $valeWhere = str_replace("quantity_ctat","quantity_total",$valeWhere);

    //$valePagoWhere = $valeWhere; // VALE_PAGO_MULTIPLE @TODO

    $sqllimit = $sumasGridServer['sqllimit'];
    $limit = $sumasGridServer['finallimit'];
    $orderby = $sumasGridServer['finalorderby'];
    $groupby = $sumasGridServer['finalgroupby'];

    $tablaOriginal = "links_al_banco_schema";
    $sql = obtenSQLlinksdeTodoalBanco($origen, $andWhere, $chequeWhere, $valeWhere, $limit, $orderby, $groupby, $tablaOriginal, $sumasGridServer['ianoLimitinSub']);

    //VCA sumasGridServer
    //Para la suma tengo que preparar el subquery que simula la vista.

//."\r\nsumasGridServer: $colSums".addslashes(print_r($sumasGridServer, true))."')");


    $COUNTsql = "SELECT /** linksdeTodoalBanco **/ COUNT(*) FROM ( ". $sql . " ) AS COUNT_TMP ";

    $sumasGridServer['total_records'] = ia_singleread($COUNTsql);

    $sumasGridServer['tablaOriginal'] = $tablaOriginal;
    $sumasGridServer['demasiadasLineasGrid'] = "NO";

    $tempTable4Sum = "aa_tmp".ia_guid();
    $arrsqlData = array('tempTable4Sum'=>$tempTable4Sum, 'sql' => $sql, 'func'=>"linksdeTodoalBanco", 'sumasGridServer'=>$sumasGridServer);

    $arrLinksTodo = array();

    if($sumasGridServer['total_records'] > $gIAParametros['numero_maximo_renglones_grid'] && $sumasGridServer['orGridTrigger'] == "NO" && $sumasGridServer['iaGridInicial'] == "NO")
    {
        $sumasGridServer['demasiadasLineasGrid'] = 'SI';
        $arrsqlData['sumasGridServer']['demasiadasLineasGrid'] = 'SI';
        $arrsqlData = json_encode($arrsqlData);

        async_guardaConsulta($arrsqlData);
    }
    else
    {
        $arrsqlData = json_encode($arrsqlData);
        guardaConsulta(json_decode($arrsqlData));
        $sqllimit = $sumasGridServer['ianoLimitinSub'] ? "" : $sqllimit;
        //$sumasGridServer['total_records'] = ia_singleread("SELECT COUNT(*) FROM $tempTable4Sum");
        $arrLinksTodo = ia_sqlArrayIndx("SELECT * FROM $tempTable4Sum $sqllimit");

    }

    $sumasGridServer['iactbl'] = $sumasGridServer['iasumFuncTable'] = $tempTable4Sum;
    /**
    $myFile = "linksdeTodoalBanco.txt";
    $fh = fopen($myFile, 'w') or die("can't open file");
    $bleh = "\r\n\r\narrsqlData<pre>".print_r(json_decode($arrsqlData), true)."</pre>";
    $bleh .= "\r\n\r\narrLinksTodo<pre>".print_r($arrLinksTodo, true)."</pre>";
    $bleh .= "\r\n\r\nsumasGridServer<pre>".print_r($sumasGridServer, true)."</pre>";
    fwrite($fh, $bleh);
    fclose($fh);
     **/

    return $arrLinksTodo;

}

function debeFlashearTab($depEn=array())
{
    global $gIAParametros;

    $debeFlashear = true;

    if($gIAParametros['flashear_tab_actualizar_bancos']=='No')
        return $debeFlashear = false;

    $now = new DateTime();
    $dbaIni = new DateTime($gIAParametros['hora_inicio_actualizar_bancos']);
    $dbaFin = new DateTime($gIAParametros['hora_fin_actualizar_bancos']);

    if ($now < $dbaIni || $now > $dbaFin)
        return $debeFlashear = false;

    $day = strtolower($now->format('D'));
    $diasSemana = array(
        array("mon",false),
        array("tue",false),
        array("wed",false),
        array("thu",false),
        array("fri",false),
        array("sat",false),
        array("sun",false)
    );
    $dbaSemana = $gIAParametros['dias_actualizar_bancos'];
    for($i=0;$i<strlen($dbaSemana);$i++){
        $diasSemana[$i][1]=$dbaSemana[$i]=="1"?true:false;
        $day=$day==$diasSemana[$i][0]?$i:$day;
    }

    if(!$diasSemana[$day][1])
        return $debeFlashear = false;


    if(!empty($depEn))
        foreach($depEn as $fila)
            foreach($fila as $d){
                $debeFlashear = array_key_exists('do_flash_tab', $d) ? $d['do_flash_tab'] : false;
                if($debeFlashear)
                    break;
            }
    return $debeFlashear;

}

function camposyTablasNormalizadas($origen='a_cuentas')
{
    $tn = array();
    $prefix = '';
    $arrCTN = array();

    switch($origen)
    {
        case 'links_al_banco':
            $tn[]='POZO';
            break;

        case 'a_cuentas':
            $tn['cheque_pago'] =
                array(  'doc_pago_id' => 'cp.cheque_pago_id',
                    'doc_id' => 'cp.cheque_id',
                    'fecha_borrado' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.numero',
                    'doc_saldo' => 'cp.saldo',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre',);

            $tn['pagare_pago'] =
                array(  'doc_pago_id' => 'cp.pagare_pago_id',
                    'doc_id' => 'cp.pagare_id',
                    'fecha_borrado' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.numero',
                    'doc_saldo' => 'cp.saldo',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre',);

            $tn['cheque_pago_log'] =
                array(  'doc_pago_id' => 'cp.cheque_pago_log_id',
                    'doc_id' => 'cp.cheque_id',
                    'cuenta_t_mov_id' => '^1=0',
                    'vs_doc' => '^1=0',
                    'vs_doc_key' => '^1=0',
                    'vs_pago_key' => '^1=0',
                    'puede_borrar' => '^1=0',
                    'quantity_ctat' => '^1=0',
                    'deposit_fecha' => '^1=0',
                    'comision_percent' => '^1=0',
                    'comision_amount' => '^1=0',
                    'factura' => '^1=0',
                    'ivacobradox100' => '^1=0',
                    'ivacobradototal' => '^1=0',
                    'empresa_id' => '^1=0',
                    'factura_numero' => '^1=0',
                    'cash_nota_num' => '^1=0',
                    'cliente' => '^1=0',
                    'tipo_cash_nota' => '^1=0',
                    'cobra_iva' => '^1=0',
                    'iva_incluido' => '^1=0',
                    'numero_referencia' => '^1=0',
                    'cash_num_cobro_iva' => '^1=0',
                    'cliente_rfc' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.numero',
                    'doc_saldo' => 'cp.saldo',
                    'activo' => '*No',
                    'origen' => '*Cheque',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre');

            $tn['pagare_pago_log'] =
                array(  'doc_pago_id' => 'cp.pagare_pago_log_id',
                    'doc_id' => 'cp.pagare_id',
                    'cuenta_t_mov_id' => '^1=0',
                    'vs_doc' => '^1=0',
                    'vs_doc_key' => '^1=0',
                    'vs_pago_key' => '^1=0',
                    'puede_borrar' => '^1=0',
                    'quantity_ctat' => '^1=0',
                    'deposit_fecha' => '^1=0',
                    'comision_percent' => '^1=0',
                    'comision_amount' => '^1=0',
                    'factura' => '^1=0',
                    'ivacobradox100' => '^1=0',
                    'ivacobradototal' => '^1=0',
                    'empresa_id' => '^1=0',
                    'factura_numero' => '^1=0',
                    'cash_nota_num' => '^1=0',
                    'cliente' => '^1=0',
                    'tipo_cash_nota' => '^1=0',
                    'cobra_iva' => '^1=0',
                    'iva_incluido' => '^1=0',
                    'numero_referencia' => '^1=0',
                    'cash_num_cobro_iva' => '^1=0',
                    'cliente_rfc' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.numero',
                    'doc_saldo' => 'cp.saldo',
                    'activo' => '*No',
                    'origen' => '*Pagare',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre',);

            $tn['vale'] =
                array(  'doc_pago_id' => 'cp.vale_id',
                    'doc_id' => 'cp.vale_id',
                    'fecha_borrado' => '^1=0',
                    'moneda_id' => 'recibido_moneda_id',
                    'vs_doc' => '^1=0',
                    'vs_doc_key' => '^1=0',
                    'vs_pago_key' => '^1=0',
                    'puede_borrar' => '^1=0',
                    'quantity_ctat' => 'quantity_recibido',
                    'numero' => '^1=0',
                    'cuentaT_deliveredto_id' => 'cp.dinero_en_cuentaT_id',
                    'doc_quantity' => 'cp.quantity',
                    'doc_moneda' => 'cp.moneda_id',
                    'doc_numero' => 'cp.vale_number',
                    'doc_saldo' => '(cp.quantity - cp.total_payments)',
                    'activo' =>"if((cp.cancelado = 1),'No','Si')",
                    'quantity' => '^1=0',
                    'origen_cuentat_id' => '^1=0',
                    'cliente_id' => 'cp.cliente_id',
                    'doc_cliente' => 'cli.nombre',);

            $tn['vale_pago'] =
                array(  'doc_pago_id' => 'cp.vale_pago_id',
                    'doc_id' => 'cp.vale_id',
                    'fecha_borrado' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.vale_number',
                    'doc_saldo' => 'cp.saldo',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre',);

            $tn['vale_pago_log'] =
                array(  'doc_pago_id' => 'cp.vale_pago_log_id',
                    'doc_id' => 'cp.vale_id',
                    'cuenta_t_mov_id' => '^1=0',
                    'vs_doc' => '^1=0',
                    'vs_doc_key' => '^1=0',
                    'vs_pago_key' => '^1=0',
                    'puede_borrar' => '^1=0',
                    'quantity_ctat' => '^1=0',
                    'deposit_fecha' => '^1=0',
                    'comision_percent' => '^1=0',
                    'comision_amount' => '^1=0',
                    'factura' => '^1=0',
                    'ivacobradox100' => '^1=0',
                    'ivacobradototal' => '^1=0',
                    'empresa_id' => '^1=0',
                    'factura_numero' => '^1=0',
                    'cash_nota_num' => '^1=0',
                    'cliente' => '^1=0',
                    'tipo_cash_nota' => '^1=0',
                    'cobra_iva' => '^1=0',
                    'iva_incluido' => '^1=0',
                    'numero_referencia' => '^1=0',
                    'cash_num_cobro_iva' => '^1=0',
                    'cliente_rfc' => '^1=0',
                    'doc_quantity' => 'ch.quantity',
                    'doc_moneda' => 'ch.moneda_id',
                    'doc_numero' => 'ch.vale_number',
                    'doc_saldo' => 'cp.saldo',
                    'activo' => '*No',
                    'origen' => '*Cheque',
                    'quantity' => 'cp.quantity',
                    'moneda_id' => 'cp.moneda_id',
                    'cliente_id' => 'ch.cliente_id',
                    'doc_cliente' => 'cli.nombre');

            $prefix = 'cp`.`';

            break;

        case 'cuentat_mov':
            $tn['cuentat_mov'] =
                array(  'cuentaT_mov_id' => 'c.cuentaT_mov_id',
                    'cuentaT_id' => 'c.cuentaT_id',
                    'fecha' => 'c.fecha',
                    'moneda_id' => 'c.moneda_id',
                    'alta_por' => 'c.alta_por',
                    'tipo_cambio' => 'c.tipo_cambio',
                    'cuentaT_tipo_mov_id' => 'c.cuentaT_tipo_mov_id',
                    'app_origen' => 'c.app_origen',
                    'monto' => 'c.monto',
                    'egreso' => 'c.egreso',
                    'saldo_corriente_mxp' => 'c.saldo_corriente_mxp',
                    'tienda_id' => 'c.tienda_id',
                    'remarks' => 'c.remarks',
                    'alta_db' => 'c.alta_db',
                    'banco_cuenta_id' => 'c.banco_cuenta_id',
                    'referencia' => 'c.referencia',
                    'quantity_total' => 'c.quantity_total',
                    'link_por' => 'c.link_por',
                    'link_el' => 'c.link_el',
                    'fecha_deposito' => 'bcm.fecha',
                    'idex100' => 'bcm.idex100',
                    'idetotal' => 'bcm.idetotal',
                    'tipo_cash_nota' => 'bcm.tipo_cash_nota',
                    'cash_nota_num' => 'bcm.cash_nota_num',
                    'cliente' => 'bcm.cliente',
                    'factura' => 'bcm.factura',
                    'cash_num_cobro_iva' => 'bcm.cash_num_cobro_iva',
                    'ivacobradox100' => 'bcm.ivacobradox100',
                    'ivacobradototal' => 'bcm.ivacobradototal',
                    'factura_numero' => 'bcm.factura_numero',
                    'activo' => 'c.activo',
                    'saldo_corriente_usd' => 'c.saldo_corriente_usd',
                    'deposit_total' => 'c.deposit_total',
                    'origen_mov_id' => 'c.origen_mov_id',
                    'contra_mov_id' => 'c.contra_mov_id',
                    'tipo' => 'c.tipo',

                );
            $prefix = 'c`.`';

            break;

        case 'clientes_saldos':
            $tn['clientes_saldos'] =
                array(
                    'doc_mas_antiguo' => 'MIN(doc_mas_antiguo)',
                    'saldo_cheques_pesos' => 'SUM(saldo_cheques_pesos)',
                    'saldo_cheques_usd' => 'SUM(saldo_cheques_usd)',
                    'saldo_pagares_pesos' => 'SUM(saldo_pagares_pesos)',
                    'saldo_pagares_usd' => 'SUM(saldo_pagares_usd)',
                    'saldo_vales_pesos' => 'SUM(saldo_vales_pesos)',
                    'saldo_vales_usd' => 'SUM(saldo_vales_usd)',
                    'saldo_total_ventas_pesos' => 'SUM(saldo_total_ventas_pesos)',
                    'saldo_total_ventas_usd' => 'SUM(saldo_total_ventas_usd)',
                    'cheque_mas_antiguo' => 'MIN(cheque_mas_antiguo)',
                    'pagare_mas_antiguo' => 'MIN(pagare_mas_antiguo)',
                    'vale_mas_antiguo' => 'MIN(vale_mas_antiguo)',
                    'ultima_liquidacion' => 'MAX(ultima_liquidacion)',
                    'ultima_compra' => 'MAX(ultima_compra)',
                    'ultimo_pago' => 'MAX(ultimo_pago)',
                    'cuantos_cheques' => 'SUM(cuantos_cheques)',
                    'cuantos_pagares' => 'SUM(cuantos_pagares)',
                    'cuantos_vales' => 'SUM(cuantos_vales)',
                );
            $prefix = '';

            break;

        default:

            break;
    }
    $arrCTN[0]=$tn;
    $arrCTN[1]=$prefix;

    return $arrCTN;

}

//VCA 30-11-2020 banco_cuenta_poner_deposito_ND
function leer_banco_cuenta_poner_deposito_ND(){

    $ret_arr_cuentas=array( "txt_cuenta_poner_deposito_ND" => "",
        "div_cuenta_poner_deposito_ND" => "",
        "div_cuenta_no_poner_deposito_ND" => "");

    $txt_cuenta_poner_deposito_ND="";
    $div_cuenta_poner_deposito_ND="";
    $div_cuenta_no_poner_deposito_ND="";

    //CODIGO PARA PERMISOS POR USUARIO
    $cpnd_sql = "SELECT banco_cuenta_poner_deposito_ND FROM iac_parametros WHERE iac_parametros_id = '1'";
    $cpnd_csv = ia_singleread($cpnd_sql);

    //echo "<li>$cpnd_csv";

    $cpnd_array = explode(",", $cpnd_csv);

    //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

    if(is_array($cpnd_array) && !empty($cpnd_array)) {
        $cpnd_in = "banco_cuenta_id IN ('" . join("','", $cpnd_array) . "')";
        $cpnd_not_in = "banco_cuenta_id NOT IN ('" . join("','", $cpnd_array) . "')";
    }
    else {
        $cpnd_in = "banco_cuenta_id = -1";
        $cpnd_not_in = "banco_cuenta_id > 0";
    }

    $cpnd_fin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_in ORDER BY 2";

    // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
    $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

    $cpnd_sin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_not_in ORDER BY 2";

    // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
    $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

    //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
    //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";


    $data = [];

    foreach($cpnd_fin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $txt_cuenta_poner_deposito_ND.=" $cuenta,";
        $div_cuenta_poner_deposito_ND.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="quita_cuenta('.$v['banco_cuenta_id'].',_poner_deposito_ND);">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';
        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'estado' => 'ND'
        ];
    }

    if(!empty($txt_cuenta_poner_deposito_ND))
        $txt_cuenta_poner_deposito_ND = substr_replace($txt_cuenta_poner_deposito_ND,"",-1);

    foreach($cpnd_sin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $div_cuenta_no_poner_deposito_ND.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="agrega_cuenta('.$v['banco_cuenta_id'].',_poner_deposito_ND);">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Poner depósitos en ND." title="Poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';
        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'estado' => 'Q'
        ];
    }

    $div_cuenta_poner_deposito_ND='<div id="vale_cuenta_poner_deposito_ND" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS CON DEPOSITOS EN <span class="txt_1_3em txt_shadow_rojo_quemado">ND</span><br><span class="txt_1_1em txt_shadow_rojo_quemado">(NO ACEPTA DEPÓSITOS EN Q)</span> =-</strong><hr/><br/>'.$div_cuenta_poner_deposito_ND.'</div>';
    $div_cuenta_no_poner_deposito_ND='<div id="vale_cuenta_no_poner_deposito_ND" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS CON DEPOSITOS EN <span class="txt_1_3em txt_shadow_violeta">Q</span> =-</strong><hr/><br/>'.$div_cuenta_no_poner_deposito_ND.'</div>';

    $ret_arr_cuentas=array( "txt_cuenta_poner_deposito_ND"   => "$txt_cuenta_poner_deposito_ND",
        "div_cuenta_poner_deposito_ND" => "$div_cuenta_poner_deposito_ND",
        "div_cuenta_no_poner_deposito_ND" => "$div_cuenta_no_poner_deposito_ND",
        'data' => $data
        );

    return $ret_arr_cuentas;
}

function leer_banco_cuenta_permite_inversion_manual(){

    $ret_arr_cuentas=array( "txt_cuenta_permite_inversion_manual" => "",
        "div_cuenta_permite_inversion_manual" => "",
        "div_cuenta_no_permite_inversion_manual" => "");

    $txt_cuenta_permite_inversion_manual="";
    $div_cuenta_permite_inversion_manual="";
    $div_cuenta_no_permite_inversion_manual="";

    //CODIGO PARA PERMISOS POR USUARIO
    $cpnd_sql = "SELECT banco_cuenta_permite_inversion_manual FROM iac_parametros WHERE iac_parametros_id = '1'";
    $cpnd_csv = ia_singleread($cpnd_sql);

    //echo "<li>$cpnd_csv";

    $cpnd_array = explode(",", $cpnd_csv);

    //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

    if(is_array($cpnd_array) && !empty($cpnd_array)) {
        $cpnd_in = "banco_cuenta_id IN ('" . join("','", $cpnd_array) . "')";
        $cpnd_not_in = "banco_cuenta_id NOT IN ('" . join("','", $cpnd_array) . "')";
    }
    else {
        $cpnd_in = "banco_cuenta_id = -1";
        $cpnd_not_in = "banco_cuenta_id > 0";
    }

    $cpnd_fin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_in ORDER BY 2";

    // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
    $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

    $cpnd_sin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_not_in ORDER BY 2";

    // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
    $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

    //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
    //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";


    $data = [];

    foreach($cpnd_fin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $txt_cuenta_permite_inversion_manual.=" $cuenta,";
        $div_cuenta_permite_inversion_manual.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="quita_cuenta_permite_inversion_manual('.$v['banco_cuenta_id'].',_permite_inversion_manual);">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';
        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'estado' => 'Si'
        ];
    }

    if(!empty($txt_cuenta_permite_inversion_manual))
        $txt_cuenta_permite_inversion_manual = substr_replace($txt_cuenta_permite_inversion_manual,"",-1);

    foreach($cpnd_sin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $div_cuenta_no_permite_inversion_manual.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="agrega_cuenta_permite_inversion_manual('.$v['banco_cuenta_id'].',_permite_inversion_manual);">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Poner depósitos en ND." title="Poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';
        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'estado' => 'No'
        ];
    }

    $div_cuenta_permite_inversion_manual='<div id="vale_cuenta_permite_inversion_manual" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS <span class="txt_1_3em txt_shadow_rojo_quemado">CON</span> INVERSIONES MANUALES<br><span class="txt_1_1em txt_shadow_rojo_quemado">(PERMITE INVERSIONES CUANDO SE CAPTURA MANUALMENTE)</span> =-</strong><hr/><br/>'.$div_cuenta_permite_inversion_manual.'</div>';
    $div_cuenta_no_permite_inversion_manual='<div id="vale_cuenta_no_permite_inversion_manual" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS <span class="txt_1_3em txt_shadow_violeta">SIN</span>INVERSIONES MANUALES =-</strong><hr/><br/>'.$div_cuenta_no_permite_inversion_manual.'</div>';

    $ret_arr_cuentas=array( "txt_cuenta_permite_inversion_manual"   => "$txt_cuenta_permite_inversion_manual",
        "div_cuenta_permite_inversion_manual" => "$div_cuenta_permite_inversion_manual",
        "div_cuenta_no_permite_inversion_manual" => "$div_cuenta_no_permite_inversion_manual",
        'data' => $data
        );

    return $ret_arr_cuentas;
}

//VCA 12-12-2020 banco_cuenta_no_aparece_depositar_en
function leer_banco_cuenta_no_aparece_depositar_en(){

    $ret_arr_cuentas=array( "txt_cuenta_no_aparece_depositar_en" => "",
        "div_cuenta_no_aparece_depositar_en" => "",
        "div_cuenta_aparece_depositar_en" => "");

    $txt_cuenta_no_aparece_depositar_en="";
    $div_cuenta_no_aparece_depositar_en="";
    $div_cuenta_aparece_depositar_en="";

    //CODIGO PARA PERMISOS POR USUARIO
    $cpnd_sql = "SELECT banco_cuenta_no_aparece_depositar_en FROM iac_parametros WHERE iac_parametros_id = '1'";
    $cpnd_csv = ia_singleread($cpnd_sql);

    //echo "<li>$cpnd_csv";

    $cpnd_array = explode(",", $cpnd_csv);

    //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

    if(is_array($cpnd_array) && !empty($cpnd_array)) {
        $cpnd_in = "banco_cuenta_id IN ('" . join("','", $cpnd_array) . "')";
        $cpnd_not_in = "banco_cuenta_id NOT IN ('" . join("','", $cpnd_array) . "')";
    }
    else {
        $cpnd_in = "banco_cuenta_id = -1";
        $cpnd_not_in = "banco_cuenta_id > 0";
    }

    $cpnd_fin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_in ORDER BY 2";

    // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
    $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

    $cpnd_sin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_not_in ORDER BY 2";

    // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
    $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

    //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
    //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";


    $data = [];
    foreach($cpnd_fin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $txt_cuenta_no_aparece_depositar_en.=" $cuenta,";
        $div_cuenta_no_aparece_depositar_en.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="quita_cuenta('.$v['banco_cuenta_id'].',_no_aparece_depositar_en);">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'aparecen' => 'No'
        ];

    }

    if(!empty($txt_cuenta_no_aparece_depositar_en))
        $txt_cuenta_no_aparece_depositar_en = substr_replace($txt_cuenta_no_aparece_depositar_en,"",-1);

    foreach($cpnd_sin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $div_cuenta_aparece_depositar_en.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="agrega_cuenta('.$v['banco_cuenta_id'].',_no_aparece_depositar_en);">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Poner depósitos en ND." title="Poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

        $data[] = [
            'banco_cuenta_id' => $v['banco_cuenta_id'],
            'cuenta' => $cuenta,
            'aparecen' => 'Si'
        ];
    }

    $div_cuenta_no_aparece_depositar_en='<div id="vale_cuenta_no_aparece_depositar_en" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS NO APARECEN EN DEPOSITA EN =-</strong><hr/><br/>'.$div_cuenta_no_aparece_depositar_en.'</div>';
    $div_cuenta_aparece_depositar_en='<div id="vale_cuenta_aparece_depositar_en" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= CUENTAS APARECEN EN DEPOSITA EN =-</strong><hr/><br/>'.$div_cuenta_aparece_depositar_en.'</div>';

    $ret_arr_cuentas=array( "txt_cuenta_no_aparece_depositar_en"   => "$txt_cuenta_no_aparece_depositar_en",
        "div_cuenta_no_aparece_depositar_en" => "$div_cuenta_no_aparece_depositar_en",
        "div_cuenta_aparece_depositar_en" => "$div_cuenta_aparece_depositar_en",
        "data" => $data
        );

    return $ret_arr_cuentas;
}
//VCA 12-12-2020 puede_bodega_destinos_especiales
function leer_origen_destino_especial(){

    $ret_arr_cuentas=array( "txt_requiere_autorizacion_origen_destino_especial" => "",
        "div_requiere_autorizacion_origen_destino_especial" => "",
        "div_no_requiere_autorizacion_origen_destino_especial" => "");

    $txt_requiere_autorizacion_origen_destino_especial="";
    $div_requiere_autorizacion_origen_destino_especial="";
    $div_no_requiere_autorizacion_origen_destino_especial="";

    //CODIGO PARA PERMISOS POR USUARIO
    $cpnd_sql = "SELECT origen_destino_especial FROM iac_parametros WHERE iac_parametros_id = '1'";
    $cpnd_csv = ia_singleread($cpnd_sql);

    //echo "<li>$cpnd_csv";

    $cpnd_array = explode(",", $cpnd_csv);

    //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

    if(is_array($cpnd_array) && !empty($cpnd_array)) {
        $cpnd_in = "origen_bodega_id IN ('" . join("','", $cpnd_array) . "')";
        $cpnd_not_in = "origen_bodega_id NOT IN ('" . join("','", $cpnd_array) . "')";
    }
    else {
        $cpnd_in = "origen_bodega_id = 'ABCXYZ'";
        $cpnd_not_in = "origen_bodega_id <> ''";
    }

    $cpnd_fin_sql = "SELECT origen_bodega_id, clave, clave as nombre FROM origen_bodega WHERE es <> 'CLIENTE' and activo = 'Si' AND $cpnd_in ORDER BY 2";

    // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
    $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

    $cpnd_sin_sql = "SELECT origen_bodega_id, clave, clave as nombre FROM origen_bodega WHERE es <> 'CLIENTE' and activo = 'Si' AND $cpnd_not_in ORDER BY 2";

    // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
    $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

    //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
    //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";



    foreach($cpnd_fin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $txt_requiere_autorizacion_origen_destino_especial.=" $cuenta,";
        $div_requiere_autorizacion_origen_destino_especial.='<div id="'.$v['origen_bodega_id'].'" data-origen_bodega_id="'.$v['origen_bodega_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" id="'.$v['origen_bodega_id'].'" onclick="quita_origen_destino_especial(this.id,_origen_destino_especial);">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

    }

    if(!empty($txt_requiere_autorizacion_origen_destino_especial))
        $txt_requiere_autorizacion_origen_destino_especial = substr_replace($txt_requiere_autorizacion_origen_destino_especial,"",-1);

    foreach($cpnd_sin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $div_no_requiere_autorizacion_origen_destino_especial.='<div id="'.$v['origen_bodega_id'].'" data-origen_bodega_id="'.$v['origen_bodega_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" id="'.$v['origen_bodega_id'].'" onclick="agrega_origen_destino_especial(this.id,_origen_destino_especial);">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Pedir Autorización" title="Pedir Autorización" /></a>&nbsp;&nbsp;</div>';
    }

    $div_requiere_autorizacion_origen_destino_especial='<div id="vale_requiere_autorizacion_origen_destino_especial" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= REQUIEREN AUTORIZACIÓN =-</strong><hr/><br/>'.$div_requiere_autorizacion_origen_destino_especial.'</div>';
    $div_no_requiere_autorizacion_origen_destino_especial='<div id="vale_no_requiere_autorizacion_origen_destino_especial" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= NO REQUIEREN AUTORIZACIÓN =-</strong><hr/><br/>'.$div_no_requiere_autorizacion_origen_destino_especial.'</div>';

    $ret_arr_cuentas=array( "txt_requiere_autorizacion_origen_destino_especial"   => "$txt_requiere_autorizacion_origen_destino_especial",
        "div_requiere_autorizacion_origen_destino_especial" => "$div_requiere_autorizacion_origen_destino_especial",
        "div_no_requiere_autorizacion_origen_destino_especial" => "$div_no_requiere_autorizacion_origen_destino_especial");

    return $ret_arr_cuentas;
}
//VCA 12-12-2020 puede_bodega_destinos_especiales
function leer_bodegas_no_existencia(){

    $ret_arr_cuentas=array(
        "txt_no_aparece_bodegas_no_existencia" => "",
        "div_no_aparece_bodegas_no_existencia" => "",
        "div_si_aparece_bodegas_no_existencia" => "");

    $txt_no_aparece_bodegas_no_existencia="";
    $div_no_aparece_bodegas_no_existencia="";
    $div_si_aparece_bodegas_no_existencia="";

    //CODIGO PARA PERMISOS POR USUARIO
    $cpnd_sql = "SELECT bodegas_no_existencia FROM iac_parametros WHERE iac_parametros_id = '1'";
    $cpnd_csv = ia_singleread($cpnd_sql);

    //echo "<li>$cpnd_csv";

    $cpnd_array = explode(",", $cpnd_csv);

    //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

    if(is_array($cpnd_array) && !empty($cpnd_array)) {
        $cpnd_in = "bodega_id IN ('" . join("','", $cpnd_array) . "')";
        $cpnd_not_in = "bodega_id NOT IN ('" . join("','", $cpnd_array) . "')";
    }
    else {
        $cpnd_in = "bodega_id = 'ABCXYZ'";
        $cpnd_not_in = "bodega_id <> ''";
    }

    $cpnd_fin_sql = "SELECT bodega_id, bodega, CONCAT(bodega, IF(label <> '', CONCAT(' (', label, ')'), '')) as nombre FROM bodega WHERE activo = 'Si' AND $cpnd_in ORDER BY 2";

    // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
    $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

    $cpnd_sin_sql = "SELECT bodega_id, bodega, CONCAT(bodega, IF(label <> '', CONCAT(' (', label, ')'), '')) as nombre FROM bodega WHERE activo = 'Si' AND $cpnd_not_in ORDER BY 2";

    // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
    $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

    //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
    //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";



    foreach($cpnd_fin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $txt_no_aparece_bodegas_no_existencia.=" $cuenta,";
        $div_no_aparece_bodegas_no_existencia.='<div id="'.$v['bodega_id'].'" data-bodega_id="'.$v['bodega_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" id="'.$v['bodega_id'].'" onclick="quita_bodegas_no_existencia(this.id,_bodegas_no_existencia);">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

    }

    if(!empty($txt_no_aparece_bodegas_no_existencia))
        $txt_no_aparece_bodegas_no_existencia = substr_replace($txt_no_aparece_bodegas_no_existencia,"",-1);

    foreach($cpnd_sin_arr as $k=>$v)
    {
        $cuenta=$v['nombre'];
        $div_si_aparece_bodegas_no_existencia.='<div id="'.$v['bodega_id'].'" data-bodega_id="'.$v['bodega_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" id="'.$v['bodega_id'].'" onclick="agrega_bodegas_no_existencia(this.id,_bodegas_no_existencia);">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Pedir Autorización" title="Pedir Autorización" /></a>&nbsp;&nbsp;</div>';
    }

    $div_no_aparece_bodegas_no_existencia='<div id="vale_no_aparece_bodegas_no_existencia" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= NO APARECEN =-</strong><hr/><br/>'.$div_no_aparece_bodegas_no_existencia.'</div>';
    $div_si_aparece_bodegas_no_existencia='<div id="vale_si_aparece_bodegas_no_existencia" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= SÍ APARECEN =-</strong><hr/><br/>'.$div_si_aparece_bodegas_no_existencia.'</div>';

    $ret_arr_cuentas=array( "txt_no_aparece_bodegas_no_existencia"   => "$txt_no_aparece_bodegas_no_existencia",
        "div_no_aparece_bodegas_no_existencia" => "$div_no_aparece_bodegas_no_existencia",
        "div_si_aparece_bodegas_no_existencia" => "$div_si_aparece_bodegas_no_existencia");

    return $ret_arr_cuentas;
}

function doSelectCatDoc($table, $catDoc, $label = 'Ir a categoría')
{

    $retSel="";
    if(empty($table))
        return $retSel;

    $xtraSql= usuarioTipoRony() ? " WHERE 1 ":" WHERE para_quien<>'RONY' ";

    $arrCat = ia_sqlArray("SELECT * FROM categoria $xtraSql AND activo='Si' AND origen='cobranza' ORDER BY categoria_id", "categoria_id");
    $retSel="<div id='divirCat' style='margin-top: px;'>
                    $label: <select id='irDocCat' class='ui-front'>";

    $cheque_dd = param('CDD', 'ALL');
    $cheque_dd = !empty($cheque_dd) ? $cheque_dd : 'NO';
    if($cheque_dd == 'SI')
        $table = "cheque_dd";
    $cheque_dd = "&CDD=$cheque_dd";

    //VCA Cheque DD
//    if(property_exists($this, "CDD") || $this instanceof app_cheque_dd)
//        $paramAdd.="&CDD=$this->CDD";

    foreach($arrCat as $k=>$v)
        $retSel.="<option value='$table.php?cat=$k$cheque_dd' style='color:blue' ".($k==$catDoc?"selected='selected'":"")." >$v[categoria]</option>";

    $retSel.="</select></div>";

    return $retSel;
}

/**
 * Para esperar a que se llene el cache y mandarlo.
 *
 * @param string $tabla
 * @param int $segundos
 * @param int $cuantas_veces
 * @param bool $force
 */
function haz_retraso_si_tabla_vacia($tabla = "", $segundos = 1, $cuantas_veces = 5, $force = false)
{
    if(empty($tabla))
        return;

    $veces = 0;
    $cuantas_veces = $force ? 10 : $cuantas_veces;
    do{
        //$tabla_vacia = ia_singleread("SELECT COUNT(*) FROM $tabla");
        $tabla_vacia = ia_singleread("SELECT /** haz_retraso_si_tabla_vacia $tabla **/ table_rows FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'vitex' AND TABLE_NAME='$tabla'");
        if(!$tabla_vacia)
            sleep($segundos);
    }while(!$tabla_vacia && $veces++ < $cuantas_veces);

    return;
}

function revisaMoneda($moneda = '1')
{
    $arrMonedasValidas = json_decode(obtenCatalogo('moneda_id'));
    $encontrado = false;

    foreach($arrMonedasValidas as $k=>$v)
        if(gettype($v) === "object" && $v->moneda_id == $moneda)
            $encontrado = true;

    return $encontrado;
}

function revisaTipoFactura($factura = 'MST')
{
    $arrTipoFacturaValidas = arrayTipoFactura();
    $encontrado = false;

    foreach($arrTipoFacturaValidas as $k=>$v)
        if($v == $factura)
            $encontrado = true;

    return $encontrado;
}

function revisaTipoCashNota($tipo = 'CASH')
{
    $arrTipoCashNotaValidas = arrayTipoCashNota();
    $encontrado = false;

    //return array_key_exists($tipo, $arrTipoCashNotaValidas);

    foreach($arrTipoCashNotaValidas as $k=>$v)
    {
        //echo "v: $v, tipo: $tipo\r\n";
        if($v == $tipo)
            $encontrado = true;
    }

    return $encontrado;
}

function revisaCamposCFDI33($valor = '', $campo = '')
{
    $encontrado = false;

    if(empty($valor) || empty($campo))
        return $encontrado;

    $campo = strtolower($campo);

    $arrValidos = json_decode(obtenCatalogo($campo));

    foreach($arrValidos as $k=>$v)
        if(gettype($v) === "object" && $v->value == $valor)
            $encontrado = true;

    return $encontrado;
}

function revisaActivoCatalogo($tabla='', $campo_id='', $valor_id='', $campo_activo='')
{
    if($campo_activo=="vale"){
        return ia_singleread("SELECT IF($campo_activo='Active',true,false) AS activo FROM $tabla WHERE $campo_id='$valor_id'");
    }else if($campo_activo=="activo"){
        return ia_singleread("SELECT IF($campo_activo='Si',true,false) AS activo FROM $tabla WHERE $campo_id='$valor_id'");
    }else if($campo_activo==''){
        return ia_singleread("SELECT IF($campo_id!='',true,false) AS activo FROM $tabla WHERE $campo_id='$valor_id'");
    }

}

function brtbNotificaciones($table='', $app = null)
{
    $html = '';

    switch($table)
    {
        case 'fiduciario_list':
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px; vertical-align: bottom; font-size: 35px;">
        <div id="fidExp" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'4\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_color_orange blink" alt="Fiduciarios Expirados" title="Fiduciarios Expirados" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 28px;">
        <div id="fidExpUrg" style="display:none; float:left;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'6\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_bold_brightred blink" alt="Fiduciarios Expirados Atrasados" title="Fiduciarios Expirados Atrasados" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 35px;">
        <div id="fidExpSol" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'5\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_bold_blue blink" alt="Fiduciarios Expirados con Solicitud de Reembolso" title="Fiduciarios Expirados con Solicitud de Reembolso" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 28px;">
        <div id="fidExpSolUrg" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'7\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_color_USD bold blink" alt="Fiduciarios Expirados con Solicitud de Reembolso Atrasada" title="Fiduciarios Expirados sin Link" ></span></a></div>
        </td>
        <td style="border:0px;"><div id="fidMod" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'1\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/50-lock-red.gif" width="50" height="50" alt="Fiduciarios con Link sin revisar" title="Fiduciarios con Link sin revisar"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidErr" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'2\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/48-error.gif" width="48" height="48" alt="Fiduciarios con Error" title="Fiduciarios con Error"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidCap" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'3\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/42-edit.gif" width="42" height="42" alt="Fiduciarios sin Capturar" title="Fiduciarios sin Capturar"/></a></div>
        </td>
    </tr></table>';
            break;

        case 'fiduciario_contenedor_list':
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px; vertical-align: bottom; font-size: 35px;">
        <div id="fidExp" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'4\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_color_orange blink" alt="Contenedores de Fiduciarios Expirados" title="Contenedores de Fiduciarios Expirados" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 28px;">
        <div id="fidExpUrg" style="display:none; float:left;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'6\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_bold_brightred blink" alt="Contenedores de Fiduciarios Expirados Atrasados" title="Contenedores de Fiduciarios Expirados Atrasados" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 35px;"><div id="fidExpSol" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'5\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_bold_blue blink" alt="Contenedores de Fiduciarios Expirados con Solicitud de Reembolso" title="Contenedores de Fiduciarios Expirados con Solicitud de Reembolso" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 28px;"><div id="fidExpSolUrg" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'7\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_color_USD bold blink" alt="Contenedores de Fiduciarios Expirados sin Link" title="Contenedores de Fiduciarios Expirados con Solicitud de Reembolso Atrasada" ></span></a></div>
        </td>
        <td style="border:0px;"><div id="fidMod" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'1\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/50-lock-red.gif" width="50" height="50" alt="Contenedores de Fiduciarios Modificados" title="Contenedores de Fiduciarios Modificados"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidErr" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'2\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/48-error.gif" width="48" height="48" alt="Contenedores de Fiduciarios con Error" title="Contenedores de Fiduciarios con Error"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidCap" style="display:none;"></div></td>
    </tr></table>';
            break;

        case 'inversion_list':
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px; vertical-align: bottom; font-size: 35px;">
        <div id="fidExp" style="display:none;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'4\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_color_orange blink" alt="Inversiones por vencer" title="Inversiones por vencer" ></span></a></div>
        </td>
        <td style="border:0px; vertical-align: bottom; font-size: 28px;">
        <div id="fidExpUrg" style="display:none; float:left;">
            <a class="brtb" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'6\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <span class="txt_bold_brightred blink" alt="Inversiones vencidas" title="Inversiones vencidas" ></span></a></div>
        </td>
        <td style="border:0px;"><div id="fidMod" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'1\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="linksTodayImg" src="../img/32-inversion-modificada.gif" width="32" height="32" alt="Inversiones con Link sin revisar" title="Inversiones con Link sin revisar"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidErr" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'2\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/48-error.gif" width="48" height="48" alt="Inversiones con Error" title="Inversiones con Error"/></a></div>
        </td>
        <td style="border:0px;"><div id="fidCap" style="display:none;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'3\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/42-edit.gif" width="42" height="42" alt="Inversiones sin Capturar" title="Inversiones sin Capturar"/></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a href="javascript:void(0);" onclick="if(c_cols_order ===  1 ) c_cols_order = 0; else c_cols_order = 1; cambiaOrdenCols(c_cols_order);">
            <img id="fidModImg" src="../img/32-interes.png" width="32" height="32" alt="Mostrar Tasa de Interés y Banco" title="Mostrar Tasa de Interés y Banco"/></a></div>
        </td>
    </tr></table>';
            break;

        case 'todo_a_banco_list':
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px;"><div id="linksToday" style="display:block;">
            <a id="aLinksToday" href="javascript:void(0);" onclick="linksDeHoy(\'mesactual\');" >
            <img id="linksTodayImg" src="../img/32-calendario.png" height="32" alt="Movimientos del Mes" title="Movimientos del Mes"/><br /></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(0);">
            <img id="linksTodayImg" src="../img/48-default-doc.png" width="48" height="48" alt="Cambiar Vista: Original" title="Cambiar Vista: Original"/></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(1);">
            <img id="linksTodayImg" src="../img/48-switch.png" width="48" height="48" alt="Cambiar Vista: Primero Comments" title="Cambiar Vista: Primero Comments"/></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(2);">
            <img id="linksTodayImg" src="../img/40-IVA.png" width="48" height="48" alt="Cambiar Vista: IVA" title="Cambiar Vista: Primero IVA"/></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a id="gotoLinks" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'18\'); ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);" >
            <img id="linksTodayImg" src="../img/48_links_sin_propias.png" width="48" height="48" alt="Sin afectar CuentaT y sin Propias" title="Sin afectar CuentaT y sin Propias"/></a></div>
        </td>
        <td style="border:0px;"><div id="OrderCols" style="display:block;">
            <a id="gotoInversiones" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'SI\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'19\'); ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);" >
            <img id="linksTodayImg" src="../img/32-inversiones.png" width="48" height="48" alt="Inversiones" title="Inversiones"/></a></div>
        </td>
    </tr></table>';
            break;

        case 'doctos':
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px;"><div id="SinAutorizar" style="display:block;">
            <a href="javascript:void(0);" onclick="doctosSinAutorizar();" >
            <img id="doctosSinAutorizar" src="../img/48-approve-docs.gif" height="42" width="42" alt="Movimientos sin Autorizar" title="Movimientos sin Autorizar"/></a></div>
        </td>
    </tr></table>';
            break;

        case 'cheque':
            $cheque_dd = param('CDD', 'ALL');
            $cheque_dd = !empty($cheque_dd) ? $cheque_dd : 'NO';
            if($cheque_dd != 'NO')
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px;"><div id="DDSinPagar" style="display:block; min-width: 60px;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'3\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);"  >
            <img id="DDSinPagar" src="../img/32_dd_not_paid.png" height="42" width="42" alt="Delivered Directo Sin Pagar"
            title="Delivered Directo Sin Pagar"/></a></div>
        </td>
        <td style="border:0px;"><div id="DDPagados" style="display:block; min-width: 60px;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'4\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="DDPagados" src="../img/32_dd_paid.png" height="42" width="42" alt="Delivered Directo Pagados"
            title="Delivered Directo Pagados"/></a></div>
        </td>
        <td style="border:0px;"><div id="DD" style="display:block; min-width: 60px;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'5\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="DD" src="../img/32_dd_all.png" height="42" width="42" alt="Delivered Directo Todos"
            title="Delivered Directo"/></a></div>
        </td>
        <td style="border:0px;">
            <div id="ctatGastoNoAuto" style="display:block;">
                <a style="text-decoration: none;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'6\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
        <img id="fidModImg" src="../img/64xg_astos.png" width="42" height="42" alt="Gastos" title="Gastos"/>
                </a>
            </div>
        </td>
        <td style="border:0px;">
            <div id="ctatGastoPend" style="display:block;">
                <a style="text-decoration: none;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'7\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
                    <img id="fidModImg" src="../img/64xn_ota.png" width="40" height="40" alt="Notas" title="Notas"/>
                </a>
            </div>
        </td>
        <td style="border:0px;">
            <div id="ctatGastoImp" style="display:block;">
                <a style="text-decoration: none;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'8\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
                    <img id="fidModImg" src="../img/64xn_ada.png" width="40" height="40" alt="Sin tipo" title="Sin tipo"/>
                </a>
            </div>
        </td>
    </tr></table>';
            break;

        case 'cuentat_gasto_list':
            $html =
                '<table style="width:100%;"><tr>
<td style="border:0px;"><div id="" style="display:block;">
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(0);" ><img id="width_toolbar_col_chooser" src="../img/32-default-doc.png" width="32" height="32" alt="Cambiar Vista: Original" title="Cambiar Vista: Original"/></a>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(1);" ><img id="width_toolbar_col_chooser" src="../img/48_supervisor.png" width="32" height="32" alt="Cambiar Vista: Asignación/Supervisión" title="Cambiar Vista: Asignación/Supervisión"/></a></div>
        </td>
        <td style="border:0px;"><div id="ctatGastoNoAuto" style="display:block;">
            <a style="text-decoration: none; min-width: 100px;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'4\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/42-revise.png" width="42" height="42" alt="No Rechazados, No Autorizados" title="No Rechazados, No Autorizados"/></a></div>
        </td>
        <td style="border:0px;"><div id="ctatGastoPend" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'5\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/40-letrap-carne.png" width="40" height="40" alt="Pendientes" title="Pendientes"/>
            <span class="bold txt21px" style="color:#e100b5;" alt="Pendientes" title="Pendientes" >&nbsp;&nbsp;</span></a></div>
        </td>
        <td style="border:0px;"><div id="ctatGastoImp" style="display:block;">
            <a style="text-decoration: none; min-width: 100px;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'6\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/40-letrai-verde.png" width="40" height="40" alt="Importantes" title="Importantes"/>
            <span class="bold txt21px" style="color:#000000;" alt="Importantes" title="Importantes" >&nbsp;&nbsp;</span></a></div>
        </td>
    </tr></table>';
            break;

        case 'factura_list':
            $html =
                '<table style="width:100%;">
                    <tr>
                        <td style="border:0px;" id="canceladas_sin_revision">
                            <div style="display:block;">
                                <a href="javascript:void(0);" onclick="cols_order_fedault==0 ? cols_order_fedault = 1: cols_order_fedault = 0; cambiaOrdenCols(cols_order_fedault)">
                                    <img id="fidModImg" src="../img/cancelados.png" height="60" width="60" alt="Mostrar Cancelados" style="width: 30px !important;height: 30px !important"
                                    title="Mostrar datos de cancelación"/>
                                </a>
                            </div>
                        </td>
                        <td style="border:0px;" id="canceladas_con_revision">
                        </td>
                    </tr>
                </table>';
            break;

        case 'clientes_saldos':
            $html =
                '<table style="width:100%;"><tr>
<td style="border:0px;"><div id="clientes_con_saldo" style="display:block;">
            <a href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'1\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);"  >
            <img id="fidModImg" src="../img/40_clientes_con_saldo_cat1_2.png" height="60" width="60" alt="Mostrar Clientes con Saldo" style="width: 30px !important;height: 30px !important"
            title="Mostrar Clientes con Saldo"/></a></div>
        </td>
        <td style="border:0px;"><div id="clientes_sin_saldo" style="display:block;">
            <a href="javascript:void(0);" onclick="$gridParams.postData.sidx = $gridParams.sortname = \'ultima_compra\'; $gridParams.postData.sord = $gridParams.sortorder = \'desc\'; limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'2\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);"  >
            <img id="fidModImg" src="../img/40_clientes_sin_saldo_cat1_2.png" height="60" width="60" alt="Mostrar Clientes sin Saldo" style="width: 30px !important;height: 30px !important"
            title="Mostrar Clientes sin Saldo"/></a></div>
        </td>
        <td style="border:0px;">
        <img src="../img/25-blank.png" />
        </td>
        <td style="border:0px;"><div id="cli_doc_mas_antiguo" style="display:block;">
            <a style="text-decoration: none; min-width: 100px;" href="javascript:void(0);" onclick="gridhandler.setGridParam({sortorder:\'asc\'}).jqGrid(\'sortGrid\', \'doc_mas_antiguo\', true);">
            <img id="fidModImg" src="../img/40_doc_mas_antiguo.png" width="42" height="42" alt="Ordenar por Documento más antiguo" title="Ordenar por Documento más antiguo" style="width: 30px !important;height: 30px !important"/></a></div>
        </td>
         <td style="border:0px;"><div id="mayor_saldo_pesos" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="gridhandler.setGridParam({sortorder:\'desc\'}).jqGrid(\'sortGrid\', \'saldo_cheques_pesos\', true);" >
            <img id="fidModImg" src="../img/40_mayor_saldo_pesos.png" width="40" height="40" alt="Ordenar por Mayor Saldo Cheques Pesos" title="Ordenar por Mayor Saldo Cheques Pesos" style="width: 30px !important;height: 30px !important"/></a></div>
        </td>
        <td style="border:0px;"><div id="mayor_saldo_usd" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="gridhandler.setGridParam({sortorder:\'desc\'}).jqGrid(\'sortGrid\', \'saldo_pagares_usd\', true);" >
            <img id="fidModImg" src="../img/40_mayor_saldo_usd.png" width="40" height="40" alt="Ordenar por Mayor Saldo Pagarés USD" title="Ordenar por Mayor Saldo Pagarés USD" style="width: 30px !important;height: 30px !important"/></a></div>
        </td>
         <td style="border:0px;"><div id="mayor_saldo_vales_pesos" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="gridhandler.setGridParam({sortorder:\'desc\'}).jqGrid(\'sortGrid\', \'saldo_vales_pesos\', true);" >
            <img id="fidModImg" src="../img/40_mayor_saldo_vales_pesos.png" width="40" height="40" alt="Ordenar por Mayor Saldo Vales Pesos" title="Ordenar por Mayor Saldo Vales Pesos" style="width: 30px !important;height: 30px !important"/></a></div>
        </td>
        <td style="border:0px;"><div id="mayor_saldo_vales_usd" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="gridhandler.setGridParam({sortorder:\'desc\'}).jqGrid(\'sortGrid\', \'saldo_vales_usd\', true);" >
            <img id="fidModImg" src="../img/40_mayor_saldo_vales_usd.png" width="40" height="40" alt="Ordenar por Mayor Saldo Vales USD" title="Ordenar por Mayor Saldo Vales USD" style="width: 30px !important;height: 30px !important"/></a></div>
        </td>
        
    </tr></table>';
            break;

        case 'gastos_banco_list':
            $editCont = param('ecc','No');
            $html =
                '<table style="width:100%;"><tr>
        <td style="border:0px;"><div id="" style="display:block;">
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(0);" ><img id="width_toolbar_col_chooser" src="../img/32-default-doc.png" width="32" height="32" alt="Cambiar Vista: Original" title="Cambiar Vista: Original"/></a>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(1);" ><img id="width_toolbar_col_chooser" src="../img/32-switch.png" width="32" height="32" alt="Cambiar Vista: Primero Comments" title="Cambiar Vista: Primero Comments"/></a>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(2);" ><img id="width_toolbar_col_chooser" src="../img/32-switch-1.png" width="32" height="32" alt="Cambiar Vista: Comments, Remarks, Referencia" title="Cambiar Vista: Comments, Remarks, Referencia"/></a>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(3);" ><img id="width_toolbar_col_chooser" src="../img/32-contabilidad.png" width="32" height="32" alt="Cambiar Vista: Póliza Contable" title="Cambiar Vista: Póliza Contable"/></a>
            <div style="clear:both;"></div>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(4);" ><img id="width_toolbar_col_chooser" src="../img/32-categorias.png" width="32" height="32" alt="Cambiar Vista: Categorías de Gastos" title="Cambiar Vista: Categorías de Gastos"/></a>
            <a href="javascript:void(0);" onclick="cambiaOrdenCols(5);" ><img id="width_toolbar_col_chooser" src="../img/48_supervisor.png" width="32" height="32" alt="Cambiar Vista: Asignación/Supervisión" title="Cambiar Vista: Asignación/Supervisión"/></a>'.
                (usuarioTipoRony() ?
            '<a href="withdrawals_de_banco_list.php?ecc='.($editCont=='No' ? 'Si' : 'No').'">
            <img id="width_toolbar_col_chooser" src="../img/editar.png" width="32" height="32" alt="'.($editCont=='No' ? 'Activar' : 'Desactivar').' Plantillas para llenar Remarks" title="'.($editCont=='No' ? 'Activar' : 'Desctivar').' Plantillas para llenar Remarks"/></a>' : '')

            .'</div>
        </td>
        <td style="border:0px;"><div id="withdrawalsPend" style="display:block;">
            <a style="text-decoration: none;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'1\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/40-letrap-carne.png" width="40" height="40" alt="Pendientes" title="Pendientes"/>
            <span class="bold txt18pxfr" style="color:#e100b5;" alt="Pendientes" title="Pendientes" >&nbsp;<br/>&nbsp;</span></a></div>
        </td>
        <td style="border:0px;"><div id="withdrawalsImp" style="display:block;">
            <a style="text-decoration: none; min-width: 100px;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'2\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/40-letrai-verde.png" width="40" height="40" alt="Importantes" title="Importantes"/>
            <span class="bold txt18pxfr" style="color:#000000;" alt="Importantes" title="Importantes" >&nbsp;<br/>&nbsp;</span></a></div>
        </td>
        '.
        (esRevisor() ?
        '<td style="border:0px;">
            <div id="asignaciones" style="float: left; border-radius: 25px; border: 1px solid darkorange; overflow: hidden; background: darkorange; padding: 5px; width: 26px; height: 29px;display: flex;align-items: center; font-size: 16px;">
                <a class="brtb" href="javascript:void(0);" title="Mis Asignaciones">
                    &#9983;A
                </a>
            </div>
        </td>' : '')

        .'<td style="border:0px;"><div id="withdrawalsRep" style="display:block;">
            <a style="text-decoration: none; min-width: 100px;" href="javascript:void(0);" onclick="limpiaBusquedaRapida(\'NO\'); $(\'#macro_sel\').selectize()[0].selectize.setValue(\'3\'); setTimeout(function(){ejecutaBusquedaRapida(\'SI\');setTimeout(function(){limpiaBusquedaRapida(\'NO\');},200);},10);" >
            <img id="fidModImg" src="../img/40-letrar-rojo.png" width="40" height="40" alt="Repetidos" title="Repetidos"/>
            <span class="txt_bold_red txt18pxfr" style="color:#000000;" alt="Repetidos" title="Repetidos" >&nbsp;&nbsp;<br/>&nbsp;&nbsp;</span></a></div>
        </td>
    </tr></table>';
            break;

        case 'nota_bodega':
            $bodegasPuedeConsultar = (new PermisosBodega())->bodegasPuedeConsultarMovimientos();
        case 'nota_bodega_verificacion':
            // dd_($app->es_salidas_para_tiendas);
            global $gPermisosbodega;
            $permisoBodega = $gPermisosbodega;
            if(empty($bodegasPuedeConsultar) || param('sin_verificar') === 'si')
                $bodegasPuedeConsultar = $permisoBodega->bodegasPuedeConsultarVerificarMovimientos();

            $bodegas =  $permisoBodega->getBodegasActivas();
            if ($app->es_salidas_para_tiendas??false) {
                $tienda_id = param('tienda_id');
                $origen_id = param('origen_id');
                if (empty($origen_id))
                    $origen_id = ia_singleread("SELECT origen_bodega_id FROM origen_bodega WHERE es = 'TIENDA' AND tienda_id = " . strit($tienda_id));

                $bodegas_para_tienda = ia_sqlVector("SELECT distinct bodega_id FROM nota_bodega  WHERE  (origen_id = ".strit($origen_id).")");
                $bodegas_consultar_tienda = [];
                foreach ($bodegas_para_tienda as $bodega_id)
                    $bodegas_consultar_tienda[$bodega_id] = $bodegas[$bodega_id];

                $bodegasPuedeConsultar = $bodegas_consultar_tienda;
            }

            // dd_($bodegasPuedeConsultar);

            $bodega_id = param('bodega_id');
            if (empty($bodega_id)) {
                $bodega_id = $origen_id = param('origen_id_salida',param('origen_id_traslado'));
                /*if (!empty($origen_id))
                    $bodega_id = OrigenBodega::_getById($origen_id)['bodega_id'];*/
            } else {
                $origen_id = OrigenBodega::_getBy(['es' => 'BODEGA', 'bodega_id' => $bodega_id])['origen_bodega_id']??'';
            }
            // $bodegas = json_decode(obtenCatalogo('bodega', false), true);  // @TODO pero en PERMISOS BODEGA QUE?
            // $bodegas = [];
            /*if ($table == 'nota_bodega')
                $bodegas = (new PermisosBodega())->bodegasPuedeConsultarMovimientos('');
            elseif ($table == 'nota_bodega_verificacion')
                $bodegas = (new PermisosBodega())->bodegasPuedeConsultarVerificarMovimientos('');*/

            // $bodegas =  $permisoBodega->getBodegasActivas(); // $bodegasPuede; //
            // $bodegasPuedeConsultar = $permisoBodega->bodegasPuedeConsultarMovimientos();
            $bodegasPuedeConsultar_keys = array_keys($bodegasPuedeConsultar);
            $bodegas_y_grupos = json_decode(obtenCatalogo('origen_bodega_grupo_2'), true);
            // dd_($bodegas_y_grupos);

            /*
            $grupos = array_filter($bodegas_y_grupos, function ($v, $k) {
                return strcasecmp($v['es'], 'GRUPO BODEGA') == 0;
            }, ARRAY_FILTER_USE_BOTH);*/

            // $bodegas_y_grupos = array_merge($grupos, $bodegas);
            // dd_($bodegas_y_grupos);

            // dd_($bodega_id, $bodegas_y_grupos);

            if(empty($bodegasPuedeConsultar))
                break;
            // dd_($bodegas);
            // $select = array2Select($bodegas, 'bodega_id', 'bodega', null ,'bodega_id', 'TODAS', false, true, [], [], null, false);
            if(count($bodegas_y_grupos) === 1)
                $select = "<select class='notSelectize highlightFilled' id='bodega_id'>";
            else
                $select = "<select class='notSelectize highlightFilled' id='bodega_id'><option value=''>TODAS</option>";

            $usuarioTipoRony = usuarioTipoRony();
            $usuarioSupervisor = usuarioSupervisaBodega();
            foreach ($bodegas_y_grupos as $bodega) {
                $id = $bodega['origen_bodega_id'];
                $bodega_id_self = $bodega['bodega_id'] ?? '';

                if (!$usuarioSupervisor && !in_array($bodega_id_self, $bodegasPuedeConsultar_keys))
                    continue;

                $selected = '';
                if ($id == $origen_id)
                    $selected = 'selected="true"';

                $color = "color:".($bodegas[$bodega_id_self]['color']??'000');
                $select.="<option value='$id' data-bodega_id='$bodega_id_self' style='$color; font-weight: bold'  $selected>".($bodega['bodega']??$bodega['label'] )."</option>";
                // color:$bodega[color];
            }

            $select.="</select>";
            $match = param('match');
            $checked = "";
            $class_active_match= "";
            if ($match == 'No'||$match == 'NO' ||$match == 'no') {
                $checked = "checked";
                $class_active_match= "box_top_toolbar_danger_active";
            }
            $soloSinMatch =  $table === 'nota_bodega_verificacion' ?
                "<div id='div_orden_original'>
                    <img id='fidModImg' src='../img/16-error.png' class='box_top_toolbar_danger $class_active_match box_top_toolbar' height='60' width='60' alt='O' style='width: 30px !important;height: 30px !important' title='SOLO SIN MATCH' onclick='$(\"#soloDiferentes\").click()'>
                    <input type='checkbox' name='soloDiferentes' id='soloDiferentes' value='1' style='display: none' $checked>
                </div>"
                :
                '';
            $div_a_destino ="";
            if (str_contains($_SERVER['REQUEST_URI'] ?? '', 'traslados.php')) {
                $destinos = obtenCatalogo('origen_bodega');
                $destinos = json_decode($destinos, true);
                $destinos_bodegas = array_values(array_filter($destinos, function ($destino) {
                    return ($destino['es'] == 'BODEGA');
                }));
                $select_destinos = array2Select($destinos_bodegas, 'origen_id', 'label', param('destino_id_traslado'),
                    identifier: 'select-origen_bodega_id', label: 'TODAS', isSelectize: false);
                $div_a_destino = "A $select_destinos";
            }

            $this_year = param('ano');

            $this_year_html = "<div style='float: left; vertical-align: center;  margin-right: 0.5em; margin-left: 1em;' class=''>
    <div style='float: left'>
    <label for='grid_ano'>A:<input placeholder='' type='text' role='textbox' name='ano' id='grid_ano' size='3' maxlength='4' class='ui-corner-all txt_right_aligned highlightFilled' autocomplete='off' value='$this_year' onchange='obtenerYear(this.value, this)'></label>
    </div>
</div>";

            $this_tienda_id = param('tienda_id');
            $this_destino_label = param('destino_label');

            $tiendas = obtenCatalogo('tienda');
            $tiendas_html = "<div style='float: left; vertical-align: center; margin-left: 0.5em;' class=''>
    <div style='float: left'>
    <label for='destino_label'>T:
    <input name='destino_label' id='destino_label' type='text' autocomplete='off' placeholder=''  class='input inputEntrada ui-autocomplete-input highlightFilled' data-campo='destino_label' value='$this_destino_label' style='width: 70px;'></label>
    <input name='destino_id' id='destino_id' type='hidden' value='$this_tienda_id'>
    </div>
</div>";

            $tipo_nota = ['' => '', 'CASH' => 'CASH', 'NOTA' => 'NOTA'];
            $this_tipo_nota = param('tipo_nota');
            $options = ia_Options_array($tipo_nota, $this_tipo_nota);
            $tipo_html = "<div style='float: left; vertical-align: center; margin-left: 0.5em;'><label for='c_tipo_nona'>N:<select class='notSelectize highlightFilled' name='c_tipo_nona' id='c_tipo_nona'>$options</select></label></div>";

            $button_save_filtro = "<a onclick='saveFilter();' style='margin-left: 1em'><i class='fa-icon fa-duotone fa-floppy-disk txt_shadow_azul_marino txt_1_3em' title='Guardar Consulta'></i></a>";
            if (!usuarioTipoRony()) {
                $button_save_filtro = '';
            }

            $button_filtrar = "<a onclick='recargaPaginaconAnoOrigen();' style='margin-left: 1em'><i class='fa-icon fa-duotone fa-right-to-bracket txt_shadow_azul_marino txt_1_3em' title='Recargar Notas'></i></a>";

            if (str_contains($_SERVER['REQUEST_URI'] ?? '', 'salidas_a_tienda_list.php')) {
                $tiendas_html = "";
                $this_year_html = "";

                $tienda_id = param('tienda_id');

                if (!empty($tienda_id)) {
                    $origen_bodega_id = ia_singleread("SELECT origen_bodega_id FROM origen_bodega WHERE es = 'TIENDA' AND tienda_id = '$tienda_id'");
                } else
                    $origen_bodega_id = param('origen_id');

                $destinos = json_decode(obtenCatalogo('origen_bodega'), true);
                if(usuarioTipoRony()) {
                    $destinos_tiendas = array_values(array_filter($destinos, function($destino) {
                        return $destino['es'] === 'TIENDA';
                    }));
                } else {
                    $destinosValidos = array_flip(PermisosBodegaCRUD::getConsultaSalidasTienda_origen_id());
                    $destinos_tiendas = array_values(array_filter($destinos, function ($destino) use($destinosValidos) {
                        return array_key_exists($destino['origen_bodega_id'], $destinosValidos);
                    }));
                }

                $div_a_destino = "A " .
                    array2Select($destinos_tiendas, 'origen_id', 'label', $origen_bodega_id,
                        identifier: 'select-origen_bodega_id', isSelectize: false, width: '90px');
            }

            $label = '<label for="bodega_id">BODEGA';
            $tienda_id = param('tienda_id');
            if (!empty($tienda_id))
                $label = '<label for="bodega_id">ORIGEN';

            $toolBar = new ToolBar(false);
            $toolBar->setModule('nota_bodega');
            $toolBar->preparaData();
            $html_toolbar = array(
                'element' => 'div_toolbar_nota_bodega',
                'view' => (string)$toolBar->render(null, true)
            );


            $html =
                "<script>
                $(function () {
                    var destino_label_tiendas = $tiendas;
                    \$d.iOSinitAutoComplete('#destino_label', destino_label_tiendas, '#destino_id', null, 70);
                    \$d.initOnlyNumbers('#grid_ano');
                    
                    /* $('#grid_ano').change(function () {
                        $('#filtros_toolbar_nota_bodega')[0].selectize.clear(false);
                    });
                    $('#destino_label').change(function () {
                        $('#filtros_toolbar_nota_bodega')[0].selectize.clear(false);
                    });
                    $('#c_tipo_nona').change(function () {
                        $('#filtros_toolbar_nota_bodega')[0].selectize.clear(false);
                    }); */
                });
                
                
                </script>
                <table style='width:100%;'>
                    <tr>
                        <td style='border:0;'>
                            <div style='display: flex;justify-content: center;align-items: center;'>
                                $label: $select</label>
                                $div_a_destino
                                $this_year_html
                                $tiendas_html
                                $tipo_html
                                $button_save_filtro
                                $button_filtrar
                            </div>
                            
                        </td>
                    </tr>
                    <tr>
                        <td style='display:flex;justify-content: space-around; border: 0;'>
                            $soloSinMatch
                            <div id='div_toolbar_nota_bodega'>
                                $html_toolbar[view]
                            </div>
                        </td>
                    </tr>
                </table>";



            break;
        case 'color':
            $productos = obtenCatalogo('producto_general', false);
            // $select = array2Select($productos, 'producto_general_id', 'label', null ,'select_producto_general_id', 'TODOS', isSelectize: false);
            $html =
                "<script>
                   var productos_generales = $productos;
                </script>
                <table style='width:100%;'>
                    <tr>
                        <td style='border:0px;'>
                            <div style='display: flex;justify-content: center;align-items: center;'>
                                Producto: <input type='text' name='select_producto_general_id' id='select_producto_general_id'>
                            </div>
                        </td>
                    </tr>
                </table>";
            break;
        case 'solicitud_carta_porte':
            $html =
                "<table style='width:100%;'>
                    <tr>
                        <td style='border:0px;'>
                            <div id='canceladas_sin_revision' style='display:block;'>
                                <a href='javascript:void(0);' onclick='mostrarTodas()'>
                                    <img id='fidModImg' src='../img/32-doc-azul.png' height='60' width='60' alt='Mostrar Canceladas' style='width: 30px !important;height: 30px !important' title='Mostrar Todas las Solicitudes'>
                                </a>
                            </div>
                        </td>
                        <td style='border:0px;'>
                            <div id='canceladas_sin_revision' style='display:block;'>
                                <a href='javascript:void(0);' onclick='mostrarCanceladas()'>
                                    <img id='fidModImg' src='../img/cancelados.png' height='60' width='60' alt='Mostrar Canceladas' style='width: 30px !important;height: 30px !important' title='Mostrar Solicitudes Caceladas'>
                                </a>
                            </div>
                        </td>
                    </tr>
                </table>";
            break;

        case 'ayudantes':
            $pedido_por = param('pedido_por', 'No');
            $html =
                "<table style='width:100%;'>
                    <tr>
                        <td style='border:0px;'>
                            <div style='display:block;'>
                                <a href='../bodega/ayudantes_list.php?pedido_por=$pedido_por'>
                                    <img src='../img/origen_ayudantes.png' height='60' width='60' alt='POR ORIGEN' style='width: 30px !important;height: 30px !important;     margin-top: 5px;' title='Mostrar por Origen'>
                                </a>
                            </div>
                        </td>
                        <td style='border:0px;'>
                            <div style='display:block;'>
                                <a href='../backoffice/ayudantes.php?pedido_por=$pedido_por'>
                                    <img src='../img/ayudante_origenes.png' height='60' width='80' alt='POR AYUDANTE' style='width: 40px !important;height: 40px !important' title='Mostrar por Ayudante'>
                                </a>
                            </div>
                        </td>
                    </tr>
                </table>";
            break;
        case 'pedido':
            $toolBar = new ToolBar(false);
            $toolBar->setModule('pedido');
            $toolBar->preparaData();
            $html_toolbar = array(
                'element' => 'div_toolbar_pedidos',
                'view' => (string)$toolBar->render()
            );
            $html =
                "<div id='div_toolbar_pedidos'>$html_toolbar[view]</div>";
            break;
        case 'ajuste':
            $toolBar = new ToolBar(false);
            $toolBar->setModule('ajuste');
            $toolBar->preparaData();
            $html_toolbar = array(
                'element' => 'div_toolbar_ajustes',
                'view' => (string)$toolBar->render()
            );
            $html =
                "<div id='div_toolbar_ajustes'>$html_toolbar[view]</div>";
            break;

        case 'tc_log':
            $toolBar = new ToolBar(false);
            $toolBar->setModule('tc_log');
            $toolBar->preparaData();
            $html_toolbar = array(
                'element' => 'div_toolbar_tc_log',
                'view' => (string)$toolBar->render()
            );
            $html = "<div id='div_toolbar_tc_log'>$html_toolbar[view]</div>";
            break;
    }

    return $html;
}

function delivered_pending_cheques($andWhere='',$orderby='',$usr_id=null,$contOnly=false,$brains=false) {
    global $gAppRelate;
    $cuentasT=ia_sqlArray("SELECT cuentaT_id,usuario FROM cuentat",'cuentaT_id');
    $bancos=ia_sqlArray("SELECT ".SQL_CACHE." banco_id,clave FROM banco",'banco_id');
    $tienda=ia_sqlArray("SELECT ".SQL_CACHE." tienda_id,clave FROM tienda",'tienda_id');
    $usuarios=ia_sqlArray("SELECT iac_usr_id,nick FROM iac_usr",'iac_usr_id');
    $clientes=array();

    if(empty($usr_id))
        $usr_id=$_SESSION['usuario_id'];

    if($brains ) // || $_SESSION['su'];
        $where='';
    else {
        $fieldInfo=array();

        /**
        $tmp=ia_sqlArray( $gAppRelate->cuentat_options_sql($usr_id),"cuentat_id");
        $in='';
        if(!empty($tmp)) foreach($tmp as $k=>$d)
        $in.=",$k";
        $in=substr($in,1);
        if(empty($in))
        $where = "AND c.cuentaT_deliveredto_id=-1";
        else
        $where = "AND c.cuentaT_deliveredto_id IN ($in)";
         **/
        $where = "AND ( c.cuentaT_deliveredto_id IN (". cuentasTPuede('','aceptar_delivered_cheques') .") OR c.cuentaT_transferto_id IN (". cuentasTPuede('','aceptar_delivered_cheques') .") )";
    }
    if($contOnly)
        $fields='COUNT(*) as hay,';
    else
        $fields="c.cheque_id,c.cliente_id,c.cliente_proveedor_id,c.name_on_check,c.nombre,c.quantity,c.moneda_id,c.banco_id,c.numero,c.cuentaT_deliveredto_id,c.tienda_id
            ,d.delivered_id,usuario_deliveres_id,cuentaT_deliversFrom_id,d.delivered";

    $sql="SELECT $fields
            FROM cheque c LEFT OUTER JOIN delivered d ON c.cheque_id=d.document AND d.document_type='cheque' AND d.delivered_status='Waiting' AND d.cuentaT_to_id=c.cuentaT_deliveredto_id
            WHERE /*c.paid=0 AND*/ c.accepted='Waiting' $where $andWhere $orderby
        ";

    //ia_query("INSERT INTO dime (script,dime) VALUES ('123',".strit($sql).")");

    //die($sql);
    if($contOnly)
        return ia_singleread($sql);

    $pending=ia_sqlArray($sql,'cheque_id');

    if($pending) {
        foreach($pending as $k=>$d) {
            $arr[$k]['cheque_id']=$k;

            /*
                            if(array_key_exists($d['cuentaT_deliveredto_id'],$cuentasT))
                                $arr[$k]['cuentaT_deliveredto_id']=$cuentasT[ $d['cuentaT_deliveredto_id']]['usuario'];
                            else
                                $arr[$k]['cuentaT_deliveredto_id']=$d['cuentaT_deliveredto_id'];
                            $arr[$k]['delivered']=$d['delivered'];
            */
            $nombre=array_key_exists('nombre',$d) ? $d['nombre'] : '';
            $arr[$k]['cliente']='';
            $arr[$k]['nombre']=$nombre;
            if(!empty($d['cliente_proveedor_id'])) {
                if(!array_key_exists($d['cliente_proveedor_id'],$clientes))
                    $clientes[$d['cliente_id']]=ia_singleread("SELECT nombre FROM cliente WHERE cliente_id=".strit($d['cliente_proveedor_id']));
                $arr[$k]['cliente']=$clientes[$d['cliente_proveedor_id']];
            }
            if(!empty($d['cliente_id'])) {
                if(!array_key_exists($d['cliente_id'],$clientes))
                    $clientes[$d['cliente_id']]=ia_singleread("SELECT nombre FROM cliente WHERE cliente_id=".strit($d['cliente_id']));
                $arr[$k]['cliente']=$clientes[$d['cliente_id']];
            }
            if( empty($nombre) ) {
                $d['nombre']=$arr[$k]['cliente'];
            }

            if($d['moneda_id']==2) {
                $arr[$k]['quantity_mxp']=0.00;
                $arr[$k]['quantity_usd']=$d['quantity'];
            } else {
                $arr[$k]['quantity_mxp']=$d['quantity'];
                if($d['quantity']==0)
                    $arr[$k]['quantity_mxp']=0.00;
                $arr[$k]['quantity_usd']=0.00;
            }

            //$arr[$k]['moneda_id'] = "$d[moneda_id]";
            $arr[$k]['moneda_id'] = $d['moneda_id']==1 ? 'MXP' : 'USD';

            if(array_key_exists($d['banco_id'],$bancos))
                $arr[$k]['banco_id']=$bancos[ $d['banco_id']]['clave'];
            else
                $arr[$k]['banco_id']=$d['banco_id'];

            $arr[$k]['numero']=$d['numero'];
            if(array_key_exists($d['tienda_id'],$tienda))
                $arr[$k]['tienda_id']=$tienda[ $d['tienda_id']]['clave'];
            else
                $arr[$k]['tienda_id']=$d['tienda_id'];

            if(array_key_exists($d['usuario_deliveres_id'],$usuarios))
                $arr[$k]['usuario_deliveres_id']=$usuarios[ $d['usuario_deliveres_id']]['nick'];
            else
                $arr[$k]['usuario_deliveres_id']=$d['usuario_deliveres_id'];

            if(array_key_exists($d['cuentaT_deliversFrom_id'],$cuentasT))
                $arr[$k]['cuentaT_deliversFrom_id']=$cuentasT[ $d['cuentaT_deliversFrom_id']]['usuario'];
            else
                $arr[$k]['cuentaT_deliversFrom_id']=$d['cuentaT_deliversFrom_id'];

            $arr[$k]['delivered']=$d['delivered'];

            if(array_key_exists($d['cuentaT_deliveredto_id'],$cuentasT))
                $arr[$k]['cuentaT_deliveredto_id']=$cuentasT[ $d['cuentaT_deliveredto_id']]['usuario'];
            else
                $arr[$k]['cuentaT_deliveredto_id']=$d['cuentaT_deliveredto_id'];

            $arr[$k]['delivered_id']=$d['delivered_id'];

        }
    } else {
        $arr = array();
    }
    return $arr;
}

function delivered_rechazados($andWhere='',$orderby='',$usr_id=null,$contOnly=false,$brains=false) {
    $cuentasT=ia_sqlArray("SELECT cuentaT_id,usuario FROM cuentat",'cuentaT_id');
    $usuarios=ia_sqlArray("SELECT iac_usr_id,nick FROM iac_usr",'iac_usr_id');
    $cheque=new app_cheque();
    $pagare=new app_pagare();

    $where='';
    if(empty($usr_id)) {
        $usr_id=$_SESSION['usuario_id'];
    }
    $where=' AND usuario_deliveres_id='.strit($usr_id);

    $arr=array();
    $sql="SELECT /* delivered_rechazados */ delivered_id,document_type,document ,cuentaT_to_id,usuario_accepts_id,accepted, delivered,usuario_deliveres_id,cuentaT_deliversFrom_id FROM delivered WHERE delivered_status='Rejected' AND revisado='Por revisar' $where $andWhere $orderby ";
//echo "<li>sql in func=$sql</li>";
    $rechazados=ia_sqlArray($sql,'delivered_id');
    if($rechazados) foreach($rechazados as $k=>$d) {
        $id=$k;
        $arr[$id]=array('delivered_id'=>$k,'rejected_document'=>'','document_type'=>"<a title='Ir al documento' href='$d[document_type].php?iah=e&id=$d[document]' target='_blank'>$d[document_type]</a>"
        ,'rejected_by'=>$d['usuario_accepts_id'], 'rejected_el'=>$d['accepted'],'cuentat_rejects'=>$d['cuentaT_to_id']
        ,'delivered_by'=>$d['usuario_deliveres_id'],'cuentat_deliveres'=>$d['cuentaT_deliversFrom_id'],'delivered_el'=>$d['delivered']
        ,'document'=>$d['document']
        );
        if($d['document_type']=='cheque') {
            $cheque->id=$d['document'];
            $cheque->enDB=$cheque->read_sql($d['document'],'r');
            $arr[$id]['rejected_document']=$cheque->label_record_summary();
        } else {
            $pagare->id=$d['document'];
            $pagare->enDB=$pagare->read_sql($d['document'],'r');
            $arr[$id]['rejected_document']=$pagare->label_record_summary();
        }
        if(array_key_exists($d['usuario_accepts_id'],$usuarios))
            $arr[$id]['rejected_by']=$usuarios[$d['usuario_accepts_id']]['nick'];
        if(array_key_exists($d['usuario_deliveres_id'],$usuarios))
            $arr[$id]['delivered_by']=$usuarios[$d['usuario_deliveres_id']]['nick'];

        if(array_key_exists($d['cuentaT_to_id'],$cuentasT))
            $arr[$id]['cuentat_rejects']=$cuentasT[$d['cuentaT_to_id']]['usuario'];
        if(array_key_exists($d['cuentaT_deliversFrom_id'],$cuentasT))
            $arr[$id]['cuentat_deliveres']=$cuentasT[$d['cuentaT_deliversFrom_id']]['usuario'];
    }
    return $arr;
}

function obtenSQLlinksdeTodoalBanco($origen = "", $andWhere = "", $chequeWhere = "", $valeWhere = "", $limit = "",
                                    $orderby= "", $groupby = "", &$tabla_original = "", $ianoLimitinSub='NO')
{
    $sql = "";

    $subLimit = $ianoLimitinSub == "SI" ? "" : $limit;

    switch($origen)
    {
        case 'FACTURA':
            $sql = "( SELECT a.cuentat_a_banco_mov_id AS link_id
            ,a.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,a.origen AS origen
            ,a.cuentaT_id AS cuentaT_id
            ,a.tienda_id AS tienda_id
            ,a.fecha AS fecha
            ,a.cliente AS cliente
            ,a.cliente_rfc AS cliente_rfc
            ,a.empresa_id AS empresa_id
            ,a.egreso AS egreso
            ,a.monto AS monto
            ,a.factura AS factura
            ,a.factura_numero AS factura_numero
            ,a.banco_cuenta_id AS banco_cuenta_id
            ,a.deposit_total AS deposit_total
            ,a.deposit_fecha AS deposit_fecha
            ,a.referencia AS referencia
            ,a.MetodoPago AS MetodoPago
            ,a.FormaPago AS FormaPago
            ,a.UsoCFDI AS UsoCFDI
            ,a.iva_incluido AS iva_incluido
            ,a.ivacobradox100 AS ivacobradox100
            ,if((a.iva_incluido = 'SI'),0.00,a.ivacobradototal) AS ivarealmentecobrado
            ,if((a.iva_incluido = 'NO'),0.00,a.ivacobradototal) AS ivacobradototal
            ,a.cash_num_cobro_iva AS cash_num_cobro_iva
            ,a.remarks AS remarks
            ,a.numero_referencia AS numero_referencia
            ,a.alta_db AS alta_db
            ,a.alta_por AS alta_por
            ,a.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,a.quantity_total AS quantity_total
            ,a.ide_amount AS ide_amount
            ,a.ide_percent AS ide_percent
            ,a.tipo_cash_nota AS tipo_cash_nota
            ,a.cash_nota_num AS cash_nota_num
            ,a.puede_borrar AS puede_borrar
            ,a.activo AS activo
            ,a.comments AS comments
            ,a.ultimo_cambio AS ultimo_cambio
            ,a.ultimo_cambio_por AS ultimo_cambio_por
            FROM cuentat_a_banco a $andWhere $orderby $limit )
            UNION ALL
            ( SELECT b.cheque_pago_id AS link_id
            ,b.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,b.origen AS origen
            ,b.cuentaT_id AS cuentaT_id
            ,b.tienda_id AS tienda_id
            ,b.fecha AS fecha
            ,b.cliente AS cliente
            ,b.cliente_rfc AS cliente_rfc
            ,b.empresa_id AS empresa_id
            ,b.quantity_ctat AS egreso
            ,0.00 AS monto
            ,b.factura AS factura
            ,b.factura_numero AS factura_numero
            ,b.banco_cuenta_id AS banco_cuenta_id
            ,b.deposit_total AS deposit_total
            ,b.deposit_fecha AS deposit_fecha
            ,b.referencia AS referencia
            ,b.MetodoPago AS MetodoPago
            ,b.FormaPago AS FormaPago
            ,b.UsoCFDI AS UsoCFDI
            ,b.iva_incluido AS iva_incluido
            ,b.ivacobradox100 AS ivacobradox100
            ,if((b.iva_incluido = 'SI'),0.00,b.ivacobradototal) AS ivarealmentecobrado
            ,if((b.iva_incluido = 'NO'),0.00,b.ivacobradototal) AS ivacobradototal
            ,b.cash_num_cobro_iva AS cash_num_cobro_iva
            ,b.comentario AS remarks
            ,b.numero_referencia AS numero_referencia
            ,b.alta_db AS alta_db
            ,b.alta_por AS alta_por
            ,b.metodo_pago_id AS cuentaT_tipo_mov_id
            ,b.deposit_total AS quantity_total
            ,b.ide_amount AS ide_amount
            ,b.ide_percent AS ide_percent
            ,b.tipo_cash_nota AS tipo_cash_nota
            ,b.cash_nota_num AS cash_nota_num
            ,b.puede_borrar AS puede_borrar
            ,b.activo AS activo
            ,b.comments AS comments
            ,b.ultimo_cambio AS ultimo_cambio
            ,b.ultimo_cambio_por AS ultimo_cambio_por

            FROM cheque_pago b $chequeWhere $orderby $limit )
            UNION ALL
            ( SELECT c.pagare_pago_id AS link_id
            ,c.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,c.origen AS origen
            ,c.cuentaT_id AS cuentaT_id
            ,c.tienda_id AS tienda_id
            ,c.fecha AS fecha
            ,c.cliente AS cliente
            ,c.cliente_rfc AS cliente_rfc
            ,c.empresa_id AS empresa_id
            ,c.quantity_ctat AS egreso
            ,0.00 AS monto
            ,c.factura AS factura
            ,c.factura_numero AS factura_numero
            ,c.banco_cuenta_id AS banco_cuenta_id
            ,c.deposit_total AS deposit_total
            ,c.deposit_fecha AS deposit_fecha
            ,c.referencia AS referencia
            ,c.MetodoPago AS MetodoPago
            ,c.FormaPago AS FormaPago
            ,c.UsoCFDI AS UsoCFDI
            ,c.iva_incluido AS iva_incluido
            ,c.ivacobradox100 AS ivacobradox100
            ,if((c.iva_incluido = 'SI'),0.00,c.ivacobradototal) AS ivarealmentecobrado
            ,if((c.iva_incluido = 'NO'),0.00,c.ivacobradototal) AS ivacobradototal
            ,c.cash_num_cobro_iva AS cash_num_cobro_iva
            ,c.comentario AS remarks
            ,c.numero_referencia AS numero_referencia
            ,c.alta_db AS alta_db
            ,c.alta_por AS alta_por
            ,c.metodo_pago_id AS cuentaT_tipo_mov_id
            ,c.deposit_total AS quantity_total
            ,c.ide_amount AS ide_amount
            ,c.ide_percent AS ide_percent
            ,c.tipo_cash_nota AS tipo_cash_nota
            ,c.cash_nota_num AS cash_nota_num
            ,c.puede_borrar AS puede_borrar
            ,c.activo AS activo
            ,c.comments AS comments
            ,c.ultimo_cambio AS ultimo_cambio
            ,c.ultimo_cambio_por AS ultimo_cambio_por

            FROM pagare_pago c $chequeWhere $orderby $limit ) $orderby $limit";

            // VALE_PAGO_MULTIPLE duda y vale?
            break;

        case "LINKS":
            $linksWhere = $andWhere;
            $andWhere = empty($andWhere) ? " WHERE " : $andWhere . " AND ";
            $chequeWhere = empty($chequeWhere) ? " WHERE " : $chequeWhere . " AND ";

            $sql = "( SELECT a.cuentat_a_banco_mov_id AS link_id
            ,a.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,a.origen AS origen
            ,a.cuentat_a_banco_mov_id AS doc_id
            ,a.cuentaT_id AS cuentaT_id
            ,a.tienda_id AS tienda_id
            ,a.fecha AS fecha
            ,a.banco_cuenta_id AS banco_cuenta_id
            ,a.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,a.deposit_total AS deposit_total
            ,a.quantity_total AS quantity_total
            ,a.ide_amount AS ide_amount
            ,a.ide_percent AS ide_percent
            ,a.egreso AS egreso
            ,a.monto AS monto
            ,a.tipo_cash_nota AS tipo_cash_nota
            ,a.cash_nota_num AS cash_nota_num
            ,a.deposit_fecha AS deposit_fecha
            ,a.cliente AS cliente
            ,a.factura AS factura
            ,a.factura_numero AS factura_numero
            ,a.iva_incluido AS iva_incluido
            ,a.ivacobradox100 AS ivacobradox100
            ,if((a.iva_incluido = 'SI'),0.00,a.ivacobradototal) AS ivarealmentecobrado
            ,if((a.iva_incluido = 'NO'),0.00,a.ivacobradototal) AS ivacobradototal
            ,a.alta_db AS alta_db
            ,a.alta_por AS alta_por
            ,a.numero_referencia AS numero_referencia
            ,a.cash_num_cobro_iva AS cash_num_cobro_iva
            ,a.empresa_id AS empresa_id
            ,a.remarks AS remarks
            ,a.puede_borrar AS puede_borrar
            ,a.activo AS activo
            ,a.afecta_cuentat AS afecta_cuentat
            ,a.comments AS comments
            ,a.autorizado AS autorizado
            ,a.rechazado AS rechazado
            ,a.revisado AS revisado
            ,a.autorizado_el AS autorizado_el
            ,a.autorizado_por AS autorizado_por
            ,a.MetodoPago AS MetodoPago
            ,a.FormaPago AS FormaPago
            ,a.UsoCFDI AS UsoCFDI
            ,a.iva_revisado AS iva_revisado
            ,a.iva_revisado_por AS iva_revisado_por
            ,a.iva_revisado_el AS iva_revisado_el
            ,a.ultimo_cambio AS ultimo_cambio
            ,a.ultimo_cambio_por AS ultimo_cambio_por
            ,a.cliente_rfc AS cliente_rfc
            ,a.referencia AS referencia
            ,a.origen_mov_id AS origen_mov_id
            ,a.factura_directa AS factura_directa
            ,a.moneda_id AS moneda_id
            FROM cuentat_a_banco a $andWhere (a.banco_cuenta_id > 0 AND a.banco_cuenta_mov_link_id <> '' ) $orderby $subLimit )
            UNION ALL
            ( SELECT b.cheque_pago_id AS link_id
            ,b.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,b.origen AS origen
            ,b.cheque_id AS doc_id
            ,b.cuentaT_id AS cuentaT_id
            ,b.tienda_id AS tienda_id
            ,b.fecha AS fecha
            ,b.banco_cuenta_id AS banco_cuenta_id
            ,b.metodo_pago_id AS cuentaT_tipo_mov_id
            ,b.deposit_total AS deposit_total
            ,b.quantity_total AS quantity_total
            ,b.ide_amount AS ide_amount
            ,b.ide_percent AS ide_percent
            ,b.quantity_ctat AS egreso
            ,0.00 AS monto
            ,b.tipo_cash_nota AS tipo_cash_nota
            ,b.cash_nota_num AS cash_nota_num
            ,b.deposit_fecha AS deposit_fecha
            ,b.cliente AS cliente
            ,b.factura AS factura
            ,b.factura_numero AS factura_numero
            ,b.iva_incluido AS iva_incluido
            ,b.ivacobradox100 AS ivacobradox100
            ,if((b.iva_incluido = 'SI'),0.00,b.ivacobradototal) AS ivarealmentecobrado
            ,if((b.iva_incluido = 'NO'),0.00,b.ivacobradototal) AS ivacobradototal
            ,b.alta_db AS alta_db
            ,b.alta_por AS alta_por
            ,b.numero_referencia AS numero_referencia
            ,b.cash_num_cobro_iva AS cash_num_cobro_iva
            ,b.empresa_id AS empresa_id
            ,b.comentario AS remarks
            ,b.puede_borrar AS puede_borrar
            ,b.activo AS activo
            ,afecta_cuentat AS afecta_cuentat
            ,b.comments AS comments
            ,b.autorizado AS autorizado
            ,b.rechazado AS rechazado
            ,b.revisado AS revisado
            ,b.autorizado_el AS autorizado_el
            ,b.autorizado_por AS autorizado_por
            ,b.MetodoPago AS MetodoPago
            ,b.FormaPago AS FormaPago
            ,b.UsoCFDI AS UsoCFDI
            ,b.iva_revisado AS iva_revisado
            ,b.iva_revisado_por AS iva_revisado_por
            ,b.iva_revisado_el AS iva_revisado_el
            ,b.ultimo_cambio AS ultimo_cambio
            ,b.ultimo_cambio_por AS ultimo_cambio_por
            ,b.cliente_rfc AS cliente_rfc
            ,b.referencia AS referencia
            ,b.cuenta_t_mov_id AS origen_mov_id
            ,'NO' AS factura_directa
            ,b.moneda_id AS moneda_id
            FROM cheque_pago b $chequeWhere (b.banco_cuenta_id > 0 AND b.banco_cuenta_mov_link_id <> '') $orderby $subLimit )
            UNION ALL
            ( SELECT c.pagare_pago_id AS link_id
            ,c.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,c.origen AS origen
            ,c.pagare_id AS doc_id
            ,c.cuentaT_id AS cuentaT_id
            ,c.tienda_id AS tienda_id
            ,c.fecha AS fecha
            ,c.banco_cuenta_id AS banco_cuenta_id
            ,c.metodo_pago_id AS cuentaT_tipo_mov_id
            ,c.deposit_total AS deposit_total
            ,c.quantity_total AS quantity_total
            ,c.ide_amount AS ide_amount
            ,c.ide_percent AS ide_percent
            ,c.quantity_ctat AS egreso
            ,0.00 AS monto
            ,c.tipo_cash_nota AS tipo_cash_nota
            ,c.cash_nota_num AS cash_nota_num
            ,c.deposit_fecha AS deposit_fecha
            ,c.cliente AS cliente
            ,c.factura AS factura
            ,c.factura_numero AS factura_numero
            ,c.iva_incluido AS iva_incluido
            ,c.ivacobradox100 AS ivacobradox100
            ,if((c.iva_incluido = 'SI'),0.00,c.ivacobradototal) AS ivarealmentecobrado
            ,if((c.iva_incluido = 'NO'),0.00,c.ivacobradototal) AS ivacobradototal
            ,c.alta_db AS alta_db
            ,c.alta_por AS alta_por
            ,c.numero_referencia AS numero_referencia
            ,c.cash_num_cobro_iva AS cash_num_cobro_iva
            ,c.empresa_id AS empresa_id
            ,c.comentario AS remarks
            ,c.puede_borrar AS puede_borrar
            ,c.activo AS activo
            ,afecta_cuentat AS afecta_cuentat
            ,c.comments AS comments
            ,c.autorizado AS autorizado
            ,c.rechazado AS rechazado
            ,c.revisado AS revisado
            ,c.autorizado_el AS autorizado_el
            ,c.autorizado_por AS autorizado_por
            ,c.MetodoPago AS MetodoPago
            ,c.FormaPago AS FormaPago
            ,c.UsoCFDI AS UsoCFDI
            ,c.iva_revisado AS iva_revisado
            ,c.iva_revisado_por AS iva_revisado_por
            ,c.iva_revisado_el AS iva_revisado_el
            ,c.ultimo_cambio AS ultimo_cambio
            ,c.ultimo_cambio_por AS ultimo_cambio_por
            ,c.cliente_rfc AS cliente_rfc
            ,c.referencia AS referencia
            ,c.cuenta_t_mov_id AS origen_mov_id
            ,'NO' AS factura_directa
            ,c.moneda_id AS moneda_id
            from pagare_pago c $chequeWhere (c.banco_cuenta_id > 0 and c.banco_cuenta_mov_link_id <> '') $orderby $subLimit )
            UNION ALL
            ".linksdeTodoalBancoLinksVale($chequeWhere,$valeWhere,$orderby,$subLimit)."
            UNION ALL
            ( SELECT e.cuentat_a_banco_tc_mov_id AS link_id
            ,e.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,e.origen AS origen
            ,e.cuentat_a_banco_tc_mov_id AS doc_id
            ,e.cuentaT_id AS cuentaT_id
            ,e.tienda_id AS tienda_id
            ,e.fecha AS fecha
            ,e.banco_cuenta_id AS banco_cuenta_id
            ,e.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,e.deposit_total AS deposit_total
            ,e.quantity_total AS quantity_total
            ,e.ide_amount AS ide_amount
            ,e.ide_percent AS ide_percent
            ,e.egreso AS egreso
            ,e.monto AS monto
            ,e.tipo_cash_nota AS tipo_cash_nota
            ,e.cash_nota_num AS cash_nota_num
            ,e.deposit_fecha AS deposit_fecha
            ,e.cliente AS cliente
            ,e.factura AS factura
            ,e.factura_numero AS factura_numero
            ,e.iva_incluido AS iva_incluido
            ,e.ivacobradox100 AS ivacobradox100
            ,if((e.iva_incluido = 'SI'),0.00,e.ivacobradototal) AS ivarealmentecobrado
            ,if((e.iva_incluido = 'NO'),0.00,e.ivacobradototal) AS ivacobradototal
            ,e.alta_db AS alta_db
            ,e.alta_por AS alta_por
            ,e.numero_referencia AS numero_referencia
            ,e.cash_num_cobro_iva AS cash_num_cobro_iva
            ,e.empresa_id AS empresa_id
            ,e.remarks AS remarks
            ,e.puede_borrar AS puede_borrar
            ,e.activo AS activo
            ,e.afecta_cuentat AS afecta_cuentat
            ,e.comments AS comments
            ,e.autorizado AS autorizado
            ,e.rechazado AS rechazado
            ,e.revisado AS revisado
            ,e.autorizado_el AS autorizado_el
            ,e.autorizado_por AS autorizado_por
            ,e.MetodoPago AS MetodoPago
            ,e.FormaPago AS FormaPago
            ,e.UsoCFDI AS UsoCFDI
            ,e.iva_revisado AS iva_revisado
            ,e.iva_revisado_por AS iva_revisado_por
            ,e.iva_revisado_el AS iva_revisado_el
            ,e.ultimo_cambio AS ultimo_cambio
            ,e.ultimo_cambio_por AS ultimo_cambio_por
            ,e.cliente_rfc AS cliente_rfc
            ,e.referencia AS referencia
            ,e.origen_mov_id AS origen_mov_id
            ,e.factura_directa AS factura_directa
            ,e.moneda_id AS moneda_id
            FROM cuentat_a_banco_tc e $linksWhere $orderby $subLimit )
            UNION ALL
            ( SELECT f.banco_cuenta_trans_id AS link_id
            ,f.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id
            ,f.origen AS origen
            ,f.banco_cuenta_trans_id AS doc_id
            ,f.cuentaT_id AS cuentaT_id
            ,f.tienda_id AS tienda_id
            ,f.fecha AS fecha
            ,f.banco_cuenta_id AS banco_cuenta_id
            ,f.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,f.deposit_total AS deposit_total
            ,f.quantity_total AS quantity_total
            ,f.ide_amount AS ide_amount
            ,f.ide_percent AS ide_percent
            ,f.egreso AS egreso
            ,f.monto AS monto
            ,f.tipo_cash_nota AS tipo_cash_nota
            ,f.cash_nota_num AS cash_nota_num
            ,f.deposit_fecha AS deposit_fecha
            ,f.cliente AS cliente
            ,f.factura AS factura
            ,f.factura_numero AS factura_numero
            ,f.iva_incluido AS iva_incluido
            ,f.ivacobradox100 AS ivacobradox100
            ,if((f.iva_incluido = 'SI'),0.00,f.ivacobradototal) AS ivarealmentecobrado
            ,if((f.iva_incluido = 'NO'),0.00,f.ivacobradototal) AS ivacobradototal
            ,f.alta_db AS alta_db
            ,f.alta_por AS alta_por
            ,f.numero_referencia AS numero_referencia
            ,f.cash_num_cobro_iva AS cash_num_cobro_iva
            ,f.empresa_id AS empresa_id
            ,f.remarks AS remarks
            ,f.puede_borrar AS puede_borrar
            ,f.activo AS activo
            ,f.afecta_cuentat AS afecta_cuentat
            ,f.comments AS comments
            ,f.autorizado AS autorizado
            ,f.rechazado AS rechazado
            ,f.revisado AS revisado
            ,f.autorizado_el AS autorizado_el
            ,f.autorizado_por AS autorizado_por
            ,f.MetodoPago AS MetodoPago
            ,f.FormaPago AS FormaPago
            ,f.UsoCFDI AS UsoCFDI
            ,f.iva_revisado AS iva_revisado
            ,f.iva_revisado_por AS iva_revisado_por
            ,f.iva_revisado_el AS iva_revisado_el
            ,f.ultimo_cambio AS ultimo_cambio
            ,f.ultimo_cambio_por AS ultimo_cambio_por
            ,f.cliente_rfc AS cliente_rfc
            ,f.referencia AS referencia
            ,f.origen_mov_id AS origen_mov_id
            ,f.factura_directa AS factura_directa
            ,f.moneda_id AS moneda_id
            from banco_cuenta_trans f $linksWhere $orderby $subLimit ) $orderby $limit ";

            $tabla_original = "links_al_banco_schema";
            break;

        case "CANCELADOS":
            $sql = "
            ( SELECT a.cuentat_a_banco_mov_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,a.origen AS origen
            ,a.cuentat_a_banco_mov_id AS doc_id
            ,a.cuentaT_id AS cuentaT_id
            ,a.tienda_id AS tienda_id
            ,a.alta_por AS alta_por
            ,a.alta_db AS alta_db
            ,a.fecha AS fecha
            ,a.egreso AS egreso
            ,a.monto AS monto
            ,a.remarks AS remarks
            ,a.banco_cuenta_id AS banco_cuenta_id
            ,a.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,a.numero_referencia AS numero_referencia
            ,a.quantity_total AS quantity_total
            ,a.ide_amount AS ide_amount
            ,a.ide_percent AS ide_percent
            ,a.deposit_fecha AS deposit_fecha
            ,a.activo AS activo
            from cuentat_a_banco a $andWhere $orderby $limit )
            UNION ALL
            ( SELECT b.cheque_pago_log_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,b.origen AS origen
            ,b.cheque_id AS doc_id
            ,b.cuentaT_id AS cuentaT_id
            ,b.tienda_id AS tienda_id
            ,b.alta_por AS alta_por
            ,b.alta_db AS alta_db
            ,b.fecha AS fecha
            ,b.quantity_total AS egreso
            ,0.00 AS monto
            ,b.comentario AS remarks
            ,b.banco_cuenta_id AS banco_cuenta_id
            ,b.metodo_pago_id AS cuentaT_tipo_mov_id
            ,b.numero_referencia AS numero_referencia
            ,b.quantity_total AS quantity_total
            ,b.ide_amount AS ide_amount
            ,b.ide_percent AS ide_percent
            ,b.deposit_fecha AS deposit_fecha
            ,b.activo AS activo
            from cheque_pago_log b $chequeWhere AND b.banco_cuenta_id > 0 $orderby $limit )
            UNION ALL
            ( SELECT c.pagare_pago_log_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,c.origen AS origen
            ,c.pagare_id AS doc_id
            ,c.cuentaT_id AS cuentaT_id
            ,c.tienda_id AS tienda_id
            ,c.alta_por AS alta_por
            ,c.alta_db AS alta_db
            ,c.fecha AS fecha
            ,c.quantity_total AS egreso
            ,0.00 AS monto
            ,c.comentario AS remarks
            ,c.banco_cuenta_id AS banco_cuenta_id
            ,c.metodo_pago_id AS cuentaT_tipo_mov_id
            ,c.numero_referencia AS numero_referencia
            ,c.quantity_total AS quantity_total
            ,c.ide_amount AS ide_amount
            ,c.ide_percent AS ide_percent
            ,c.deposit_fecha AS deposit_fecha
            ,c.activo AS activo
            from pagare_pago_log c $chequeWhere AND c.banco_cuenta_id > 0 $orderby $limit )
            UNION ALL
            ( SELECT d.vale_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,d.origen
            ,d.vale_id AS doc_id
            ,d.cuentaT_id
            ,d.tienda_id
            ,d.alta_por
            ,d.alta_db
            ,d.fecha
            ,d.quantity_total AS egreso
            ,0.00 AS monto
            ,d.remarks
            ,d.banco_cuenta_id
            ,d.metodo_pago_id AS cuentaT_tipo_mov_id
            ,d.numero_referencia AS numero_referencia
            ,d.quantity_total AS quantity_total
            ,d.ide_amount
            ,d.ide_percent
            ,d.deposit_fecha
            ,if((d.cancelado = 1),'No','Si') AS activo
            from vale d $valeWhere AND (d.cancelado=1 && d.banco_cuenta_id > 0) $orderby $limit )
            UNION ALL
            ( SELECT e.cuentat_a_banco_tc_mov_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,e.origen AS origen
            ,e.cuentat_a_banco_tc_mov_id AS doc_id
            ,e.cuentaT_id AS cuentaT_id
            ,e.tienda_id AS tienda_id
            ,e.alta_por AS alta_por
            ,e.alta_db AS alta_db
            ,e.fecha AS fecha
            ,e.egreso AS egreso
            ,e.monto AS monto
            ,e.remarks AS remarks
            ,e.banco_cuenta_id AS banco_cuenta_id
            ,e.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,e.numero_referencia AS numero_referencia
            ,e.quantity_total AS quantity_total
            ,e.ide_amount AS ide_amount
            ,e.ide_percent AS ide_percent
            ,e.deposit_fecha AS deposit_fecha
            ,e.activo AS activo
            from cuentat_a_banco_tc e $andWhere $orderby $limit )
            UNION ALL
            ( SELECT f.banco_cuenta_trans_id AS link_id
            ,'' AS banco_cuenta_mov_link_id
            ,f.origen AS origen
            ,f.banco_cuenta_trans_id AS doc_id
            ,f.cuentaT_id AS cuentaT_id
            ,f.tienda_id AS tienda_id
            ,f.alta_por AS alta_por
            ,f.alta_db AS alta_db
            ,f.fecha AS fecha
            ,f.egreso AS egreso
            ,f.monto AS monto
            ,f.remarks AS remarks
            ,f.banco_cuenta_id AS banco_cuenta_id
            ,f.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id
            ,f.numero_referencia AS numero_referencia
            ,f.quantity_total AS quantity_total
            ,f.ide_amount AS ide_amount
            ,f.ide_percent AS ide_percent
            ,f.deposit_fecha AS deposit_fecha
            ,f.activo AS activo
            from banco_cuenta_trans f $andWhere $orderby $limit ) $orderby $limit ";
            break;
    }

    return $sql;
}

function obten_tc_live()
{
    global $gIAParametros;

    $tc = array();
    $live = 'Error';

    $tcUltimaActualizacion = ia_singleread("SELECT MAX(alta_db) FROM tc_log WHERE origen <> 'TEMPORAL'");
    if(diferenciadeTiempo($tcUltimaActualizacion,'','minutos') > $gIAParametros['tiempo_para_actualizar_tc_desde_xecom']*60)
    {
        if(!extraeTCdeXE(false)) {
            $live = 'Error';
        }
        else{
            $live = 'OK';
        }

    }
    else
        $live = 'OK';

    $tc = json_decode(obtenCatalogo('tc_index'));
    $tc->tc = echonf($tc->tc, true, 4, "");
    $tc->alta_db = mysqlTimestamp2display($tc->alta_db);
    $tc->live = $live;

    return $tc;
}

// Helper function to obtain and process catalog
function getProcessedCatalog($catalogName): string
{
    return trim(preg_replace('/[\t\n\r\s]+/', ' ', obtenCatalogo($catalogName)));
}
function inicializa_catalogos_globales_(): array
{
    global $gIAParametros, $toolBarColor;
    // Determine user type and permissions
    $es_Rony = $_SESSION['usuario_id'] == '1';
    $es_usuario_tipoRony = usuarioTipoRony();
    $es_Rony_js = json_encode($es_Rony);
    $es_usuario_tipoRony_js = json_encode($es_usuario_tipoRony);

    // Other variables
    $tool_bar_color = jsit($toolBarColor);
    $tmpTipoRony = json_encode($es_usuario_tipoRony);
    
    $estoyEnServidor = estoyEnServidor();

    $vitex_globales = [];

    // Output global variables
    $vitex_globales['es_Rony'] = $es_Rony_js;
    $vitex_globales['es_usuario_tipoRony'] = $es_usuario_tipoRony_js;
   
    $vitex_globales['tipo_rony'] = $tmpTipoRony;
    $vitex_globales['nick'] = $_SESSION['usuario'];
    $vitex_globales['iac_usr_id'] = $_SESSION['usuario_id'];
    $vitex_globales['iac_parametros'] = [];
    $vitex_globales['dialog_banco_cuenta_opener'] = [];
    $vitex_globales['dialog_banco_cuenta_opener']['segundos_abierto_dialog_banco_cuenta_opener_ori'] = 15;
    $vitex_globales['toolBarColor'] = $tool_bar_color;
    $vitex_globales['estoyEnServidor'] = $estoyEnServidor;
    return $vitex_globales;
    



    // List of catalogs to process
    $catalogs = [
        'g_cat_producto_general' => 'producto_general',
        'g_cat_origen_bodega' => 'origen_bodega',
        'g_cat_origen_bodega_tienda' => 'origen_bodega_tienda',
        'g_cat_grupo' => 'grupo',
        'g_cat_bodega' => 'bodega',
        'g_cat_bodega2grupo' => 'bodega2grupo',
        'g_cat_color_alfabetico' => 'color_alfabetico',
        'g_cat_color_alfabetico_desc' => 'color_alfabetico_desc',
        'g_cat_color' => 'color',
        'g_cat_bodegas_y_grupos' => 'bodegas_y_grupos',
        'g_cat_empresa' => 'empresa',
        'g_cat_ayudantes_donde' => 'bodega_ayudantes_donde',
        'g_cat_ayudantes' => 'bodega_ayudantes',
        'g_cat_encargados' => 'bodega_encargados',
        'g_cat_ayudantes_2' => 'bodega_ayudantes_2',
        'g_cat_encargados_2' => 'bodega_encargados_2',
        'g_cat_ayudante_2_origen' => 'ayudante_2_origen',
        'g_cat_encargados_2_origen' => 'encargados_2_origen',
        'g_cat_origen_2_encargados' => 'origen_2_encargados',
        'g_cat_bodega_chofer' => 'bodega_chofer',
        'g_cat_banco_cuenta' => 'banco_cuenta',
    ];

    $processedCatalogs = [];
    foreach ($catalogs as $varName => $catalogName) {
        $processedCatalogs[$varName] = getProcessedCatalog($catalogName);
    }

    // Handle 'tienda' catalog separately
    $tiendas_cat = obtenCatalogo('tienda');
    $tiendas_array = json_decode($tiendas_cat, true);
    $tiendas_array[] = [
        'tienda_id' => '11ec6cb303b9307cad6b23073af2fe60',
        'clave' => 'WH',
        'real_data' => '11ec6cb303b9307cad6b23073af2fe60',
        'label' => 'WH',
        'value' => '11ec6cb303b9307cad6b23073af2fe60',
        'wh' => true,
    ];
    $processedCatalogs['g_cat_tienda'] = trim(preg_replace('/[\t\n\r\s]+/', ' ', $tiendas_cat));
    $processedCatalogs['g_cat_tienda_wh'] = trim(preg_replace('/[\t\n\r\s]+/', ' ', json_encode($tiendas_array)));

    

    // Obtain user's tiendas and bodegas
    $tiendas_bodegas_para_usuario = obtenCatalogo('bodegas_tiendas_por_usuario', extraId: $_SESSION['usuario_id']);
    $g_cat_bodega_usuario_session = $tiendas_bodegas_para_usuario['bodegas'];
    $g_cat_tienda_usuario_session = $tiendas_bodegas_para_usuario['tiendas'];
    $tiendas_bodegas_para_usuario_js = json_encode([
        'tiendas' => json_decode($g_cat_tienda_usuario_session, true),
        'bodegas' => json_decode($g_cat_bodega_usuario_session, true),
    ]);

    // User permissions
    $puede_consultar_todas_las_bodegas = (puedePermisoUsuario(nombrePermiso: "puede_solo_consultar_bodegas"));
    $puede_ver_salidas_a_todas_las_tiendas = (puedePermisoUsuario(nombrePermiso: "puede_ver_traslados"));

    // Notification for Carta Porte
    $usuarios_para_notificap_cp = ia_sqlVector("SELECT iac_usr_id FROM iac_usr WHERE notificar_nuevas_cartas_porte = 'Si'");
    $notificar_cp = !($es_Rony) && in_array($_SESSION['usuario_id'], $usuarios_para_notificap_cp);
    $notificar_cp_js = ($notificar_cp);

    // Users who can request reports
    $g_usuarios_pueden_pedir = ia_sqlVector("SELECT /*usuarios_pueden_pedir*/ iac_usr_id FROM permiso_usuario WHERE permiso_nombre = 'puede_reporte_ventas' AND puede= 'Pedir'");
    $g_usuarios_pueden_pedir_js = json_encode($g_usuarios_pueden_pedir);
    $g_usuario_puede_pedir = $es_usuario_tipoRony || in_array($_SESSION['usuario_id'], $g_usuarios_pueden_pedir);
    $g_usuario_puede_pedir_js = json_encode($g_usuario_puede_pedir);

    // Other variables
    $tool_bar_color = jsit($toolBarColor);
    static $outPutAgain = true;
    $tmpTipoRony = json_encode($es_usuario_tipoRony);
    $puede_consultar_permisos = ($es_usuario_tipoRony || Permisador::puede_consultar_permisos() !== 'Nada');
    $puede_prohibir_colores = ($es_usuario_tipoRony || Permisador::puede('puede_prohibir_colores', 'No', $_SESSION['usuario_id']) !== 'No');

    $estoyEnServidor = estoyEnServidor();

    $vitex_globales = [];
    // Output catalog variables
    foreach ($processedCatalogs as $varName => $value) {
        $vitex_globales[$varName] = $value;
    }

    // Output user-specific variables
    $vitex_globales['g_cat_tiendas_bodegas_para_usuario'] = $tiendas_bodegas_para_usuario_js;
    $vitex_globales['g_cat_bodega_para_usuario'] = $g_cat_bodega_usuario_session;
    $vitex_globales['g_cat_tienda_para_usuario'] = $g_cat_tienda_usuario_session;
    $vitex_globales['g_usuarios_pueden_pedir'] = $g_usuarios_pueden_pedir_js;

    // Output permissions
    $vitex_globales['puede_consultar_todas_las_bodegas'] = $puede_consultar_todas_las_bodegas;
    $vitex_globales['puede_ver_salidas_a_todas_las_tiendas'] = $puede_ver_salidas_a_todas_las_tiendas;
    $vitex_globales['consultar_permisos'] = $puede_consultar_permisos;
    $vitex_globales['puede_prohibir_colores'] = $puede_prohibir_colores;

    // Output global variables
    $vitex_globales['es_Rony'] = $es_Rony_js;
    $vitex_globales['es_usuario_tipoRony'] = $es_usuario_tipoRony_js;
    $vitex_globales['g_usuario_puede_pedir'] = $g_usuario_puede_pedir_js;
    $vitex_globales['tipo_rony'] = $tmpTipoRony;
    $vitex_globales['nick'] = $_SESSION['usuario'];
    $vitex_globales['iac_usr_id'] = $_SESSION['usuario_id'];
    $vitex_globales['iac_parametros'] = [];
    $vitex_globales['dialog_banco_cuenta_opener'] = [];
    $vitex_globales['dialog_banco_cuenta_opener']['segundos_abierto_dialog_banco_cuenta_opener_ori'] = 15;
    $vitex_globales['toolBarColor'] = $tool_bar_color;
    $vitex_globales['estoyEnServidor'] = $estoyEnServidor;

    foreach ($vitex_globales as $varName => $value) {
        if (str_starts_with($varName, 'g_')) {
            $encoded = is_array($value) ? json_encode($value) : $value;
            $compressed = gzcompress($encoded, 9);
            $base64 = base64_encode($compressed);
            $vitex_globales[$varName] = $base64;
        } else {
            $vitex_globales[$varName] = $value;
        }
    }

    return $vitex_globales;
}
function inicializa_catalogos_globales(): bool
{

    global $gIAParametros, $toolBarColor;
    // Determine user type and permissions
    $es_Rony = $_SESSION['usuario_id'] == '1';
    $es_usuario_tipoRony = usuarioTipoRony();
    $es_Rony_js = json_encode($es_Rony);
    $es_usuario_tipoRony_js = json_encode($es_usuario_tipoRony);

    // Other variables
    $tool_bar_color = jsit($toolBarColor);
    $tmpTipoRony = json_encode($es_usuario_tipoRony);
    
    $estoyEnServidor = estoyEnServidor();

    $vitex_globales = [];

    // Output global variables
    $vitex_globales['es_Rony'] = $es_Rony_js;
    $vitex_globales['es_usuario_tipoRony'] = $es_usuario_tipoRony_js;
   
    $vitex_globales['tipo_rony'] = $tmpTipoRony;
    $vitex_globales['nick'] = $_SESSION['usuario'];
    $vitex_globales['iac_usr_id'] = $_SESSION['usuario_id'];
    $vitex_globales['iac_parametros'] = [];
    $vitex_globales['dialog_banco_cuenta_opener'] = [];
    $vitex_globales['dialog_banco_cuenta_opener']['segundos_abierto_dialog_banco_cuenta_opener_ori'] = 15;
    $vitex_globales['toolBarColor'] = $tool_bar_color;
    $vitex_globales['estoyEnServidor'] = $estoyEnServidor;

    echo "\n<script>\n";
    // Output constants
    echo "const es_Rony = $es_Rony_js,\n";
    echo "      es_usuario_tipoRony = $es_usuario_tipoRony_js;\n";
    echo "\$vitex_globales = " . json_encode($vitex_globales) . ";\n";
    
    echo "</script>\n";
    return true;
    global $gIAParametros, $toolBarColor;

    /*// List of catalogs to process
    $catalogs = [
        'g_cat_producto_general' => 'producto_general',
        'g_cat_origen_bodega' => 'origen_bodega',
        'g_cat_origen_bodega_tienda' => 'origen_bodega_tienda',
        'g_cat_grupo' => 'grupo',
        'g_cat_bodega' => 'bodega',
        'g_cat_bodega2grupo' => 'bodega2grupo',
        'g_cat_color_alfabetico' => 'color_alfabetico',
        'g_cat_color_alfabetico_desc' => 'color_alfabetico_desc',
        'g_cat_color' => 'color',
        'g_cat_bodegas_y_grupos' => 'bodegas_y_grupos',
        'g_cat_empresa' => 'empresa',
        'g_cat_ayudantes_donde' => 'bodega_ayudantes_donde',
        'g_cat_ayudantes' => 'bodega_ayudantes',
        'g_cat_encargados' => 'bodega_encargados',
        'g_cat_ayudantes_2' => 'bodega_ayudantes_2',
        'g_cat_encargados_2' => 'bodega_encargados_2',
        'g_cat_ayudante_2_origen' => 'ayudante_2_origen',
        'g_cat_encargados_2_origen' => 'encargados_2_origen',
        'g_cat_origen_2_encargados' => 'origen_2_encargados',
        'g_cat_bodega_chofer' => 'bodega_chofer',
        'g_cat_banco_cuenta' => 'banco_cuenta',
    ];

    $processedCatalogs = [];
    foreach ($catalogs as $varName => $catalogName) {
        $processedCatalogs[$varName] = getProcessedCatalog($catalogName);
    }

    // Handle 'tienda' catalog separately
    $tiendas_cat = obtenCatalogo('tienda');
    $tiendas_array = json_decode($tiendas_cat, true);
    $tiendas_array[] = [
        'tienda_id' => '11ec6cb303b9307cad6b23073af2fe60',
        'clave' => 'WH',
        'real_data' => '11ec6cb303b9307cad6b23073af2fe60',
        'label' => 'WH',
        'value' => '11ec6cb303b9307cad6b23073af2fe60',
        'wh' => true,
    ];
    $processedCatalogs['g_cat_tienda'] = trim(preg_replace('/[\t\n\r\s]+/', ' ', $tiendas_cat));
    $processedCatalogs['g_cat_tienda_wh'] = trim(preg_replace('/[\t\n\r\s]+/', ' ', json_encode($tiendas_array)));*/

    // Determine user type and permissions
    $es_Rony = $_SESSION['usuario_id'] == '1';
    $es_usuario_tipoRony = usuarioTipoRony();
    $es_Rony_js = json_encode($es_Rony);
    $es_usuario_tipoRony_js = json_encode($es_usuario_tipoRony);

    // Obtain user's tiendas and bodegas
    $tiendas_bodegas_para_usuario = obtenCatalogo('bodegas_tiendas_por_usuario', extraId: $_SESSION['usuario_id']);
    $g_cat_bodega_usuario_session = $tiendas_bodegas_para_usuario['bodegas'];
    $g_cat_tienda_usuario_session = $tiendas_bodegas_para_usuario['tiendas'];
    $tiendas_bodegas_para_usuario_js = json_encode([
        'tiendas' => json_decode($g_cat_tienda_usuario_session, true),
        'bodegas' => json_decode($g_cat_bodega_usuario_session, true),
    ]);

    // User permissions
    $puede_consultar_todas_las_bodegas = json_encode(puedePermisoUsuario(nombrePermiso: "puede_solo_consultar_bodegas"));
    $puede_ver_salidas_a_todas_las_tiendas = json_encode(puedePermisoUsuario(nombrePermiso: "puede_ver_traslados"));

    // Notification for Carta Porte
    $usuarios_para_notificap_cp = ia_sqlVector("SELECT iac_usr_id FROM iac_usr WHERE notificar_nuevas_cartas_porte = 'Si'");
    $notificar_cp = !($es_Rony) && in_array($_SESSION['usuario_id'], $usuarios_para_notificap_cp);
    $notificar_cp_js = json_encode($notificar_cp);

    // Users who can request reports
    $g_usuarios_pueden_pedir = ia_sqlVector("SELECT /*usuarios_pueden_pedir*/ iac_usr_id FROM permiso_usuario WHERE permiso_nombre = 'puede_reporte_ventas' AND puede= 'Pedir'");
    $g_usuarios_pueden_pedir_js = json_encode($g_usuarios_pueden_pedir);
    $g_usuario_puede_pedir = $es_usuario_tipoRony || in_array($_SESSION['usuario_id'], $g_usuarios_pueden_pedir);
    $g_usuario_puede_pedir_js = json_encode($g_usuario_puede_pedir);

    // Other variables
    $tool_bar_color = jsit($toolBarColor);
    static $outPutAgain = true;
    $tmpTipoRony = json_encode($es_usuario_tipoRony);
    $puede_consultar_permisos = json_encode($es_usuario_tipoRony || Permisador::puede_consultar_permisos() !== 'Nada');
    $puede_prohibir_colores = json_encode($es_usuario_tipoRony || Permisador::puede('puede_prohibir_colores', 'No', $_SESSION['usuario_id']) !== 'No');

    $estoyEnServidor = estoyEnServidor() ? 'true' : 'false';
    if ($outPutAgain) {
        // Start outputting the JavaScript block
        echo "<script>\n";
//        echo "/** CATALOGOS GLOBALES */\n";
//
//        // Output catalog variables
//        foreach ($processedCatalogs as $varName => $value) {
//            echo "\$vitex_globales['$varName'] = $value;\n";
//        }
//
//        // Output user-specific variables
//        echo "\$vitex_globales['g_cat_tiendas_bodegas_para_usuario'] = $tiendas_bodegas_para_usuario_js;\n";
//        echo "\$vitex_globales['g_cat_bodega_para_usuario'] = $g_cat_bodega_usuario_session;\n";
//        echo "\$vitex_globales['g_cat_tienda_para_usuario'] = $g_cat_tienda_usuario_session;\n";
//        echo "\$vitex_globales['g_usuarios_pueden_pedir'] = $g_usuarios_pueden_pedir_js;\n";

        // Output permissions
        echo "/** PERMISOS GLOBALES */\n";
        echo "\$vitex_globales['puede_consultar_todas_las_bodegas'] = $puede_consultar_todas_las_bodegas;\n";
        echo "\$vitex_globales['puede_ver_salidas_a_todas_las_tiendas'] = $puede_ver_salidas_a_todas_las_tiendas;\n";
        echo "\$vitex_globales['consultar_permisos'] = $puede_consultar_permisos;\n";
        echo "\$vitex_globales['puede_prohibir_colores'] = $puede_prohibir_colores;\n";

        // Output global variables
        echo "/** VARS GLOBALES */\n";
        echo "\$vitex_globales['es_Rony'] = $es_Rony_js;\n";
        echo "\$vitex_globales['es_usuario_tipoRony'] = $es_usuario_tipoRony_js;\n";
        echo "\$vitex_globales['g_usuario_puede_pedir'] = $g_usuario_puede_pedir_js;\n";
        echo "\$vitex_globales['tipo_rony'] = $tmpTipoRony;\n";
        echo "\$vitex_globales['nick'] = '{$_SESSION['usuario']}';\n";
        echo "\$vitex_globales['iac_usr_id'] = '{$_SESSION['usuario_id']}';\n";
        echo "\$vitex_globales['iac_parametros'] = {};\n";
        echo "\$vitex_globales['dialog_banco_cuenta_opener'] = {};\n";
        echo "\$vitex_globales['dialog_banco_cuenta_opener'].segundos_abierto_dialog_banco_cuenta_opener_ori = 15;\n";
        echo "\$vitex_globales['toolBarColor'] = $tool_bar_color;\n";
        echo "\$vitex_globales['estoyEnServidor'] = $estoyEnServidor;\n";

        // Output constants
        echo "const es_Rony = $es_Rony_js,\n";
        echo "      es_usuario_tipoRony = $es_usuario_tipoRony_js,\n";
        echo "      puede_consultar_todas_las_bodegas = $puede_consultar_todas_las_bodegas,\n";
        echo "      puede_ver_salidas_a_todas_las_tiendas = $puede_ver_salidas_a_todas_las_tiendas,\n";
        echo "      g_usuario_puede_pedir = $g_usuario_puede_pedir_js;\n";

        // Output notification permissions
        echo "/** Permisos Notificaciones */\n";
        echo "notificar_carta_porte = $notificar_cp_js;\n";

        echo "</script>\n";
        $outPutAgain = false;
        ob_flush();
        flush();
    }
}


function estado_cuenta_cliente($cliente_id, $iacc = 'ia_case'): string
{

    global $gIAParametros;

    $tolerancia_pesos = $gIAParametros['tolerancia_pago_documentos_pesos'];
    $tolerancia_usd = $gIAParametros['tolerancia_pago_documentos_usd'];

    $sql_nombre_cliente = "SELECT nombre FROM cliente WHERE cliente_id = " . strit($cliente_id);

    $sql_saldo_cheques_pesos = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_pesos, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_cheques_pesos
    FROM cheque WHERE tipo NOT IN ('NOTA', 'GASTO') AND moneda_id = 1 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_notas_pesos = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_pesos, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_notas_pesos
    FROM cheque WHERE tipo IN ('NOTA', 'GASTO') AND moneda_id = 1 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_cheques_usd = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_usd, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_cheques_usd
    FROM cheque WHERE tipo NOT IN ('NOTA', 'GASTO') AND moneda_id = 2 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_notas_usd = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_usd, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_cheques_usd
    FROM cheque WHERE tipo IN ('NOTA', 'GASTO') AND moneda_id = 2 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_pagares_pesos = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_pesos, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_pagares_pesos
    FROM pagare WHERE moneda_id = 1 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_pagares_usd = "SELECT
    SUM(CASE WHEN paid = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_usd, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_pagares_usd
    FROM pagare WHERE moneda_id = 2 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_vales_pesos = "SELECT
    SUM(CASE WHEN paid = 0 AND aplicado = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_pesos, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_vales_pesos
    FROM vale WHERE anticipo_container = 0 AND moneda_id = 1 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_vales_usd = "SELECT
    SUM(CASE WHEN paid = 0 AND aplicado = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_usd, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_vales_usd
    FROM vale WHERE anticipo_container = 0 AND moneda_id = 2 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_vales_anticipo_container_pesos = "SELECT
    SUM(CASE WHEN paid = 0 AND aplicado = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_pesos, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_vales_pesos
    FROM vale WHERE anticipo_container = 1 AND moneda_id = 1 AND cliente_id = " . strit($cliente_id);

    $sql_saldo_vales_anticipo_container_usd = "SELECT
    SUM(CASE WHEN paid = 0 AND aplicado = 0 THEN IF(ABS(quantity - total_payments) < $tolerancia_usd, 0.00, IF(quantity - total_payments < 0, 0.00, quantity - total_payments)) END) saldo_vales_usd
    FROM vale WHERE anticipo_container = 1 AND moneda_id = 2 AND cliente_id = " . strit($cliente_id);


    $sql_cheques_pesos = "SELECT cheque_id as id,
    quantity - total_payments as quantity, 'PESOS' as moneda, 'cheque' as doc, numero, 'l Cheque' as nombre, quantity as ori_quantity, IF(new_date IS NULL, original_date, new_date) as fecha, tipo
    FROM cheque WHERE tipo NOT IN ('NOTA', 'GASTO') AND paid = 0 AND moneda_id = 1 AND cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_pesos ORDER BY IF(new_date IS NULL, original_date, new_date) ASC, quantity ASC, alta_db ASC";

    $sql_notas_pesos = "SELECT cheque_id as id,
    quantity - total_payments as quantity, 'PESOS' as moneda, 'cheque' as doc, numero, ' la Nota' as nombre, quantity as ori_quantity, IF(new_date IS NULL, original_date, new_date) as fecha, tipo
    FROM cheque WHERE tipo IN ('NOTA', 'GASTO') AND paid = 0 AND moneda_id = 1 AND cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_pesos ORDER BY IF(new_date IS NULL, original_date, new_date) ASC, quantity ASC, alta_db ASC";

    $sql_pagares_pesos = "SELECT pagare_id as id,
    quantity - total_payments as quantity, 'PESOS' as moneda, 'pagare' as doc, numero, 'l Pagaré' as nombre, quantity as ori_quantity, original_date as fecha, 'PAGARE' as tipo
    FROM pagare WHERE paid = 0 AND moneda_id = 1 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_pesos ORDER BY original_date ASC, quantity ASC, alta_db ASC";

    $sql_vales_pesos = "SELECT vale_id as id,
    quantity - total_payments as quantity, 'PESOS' as moneda, 'vale' as doc, vale_number as numero, 'l Vale' as nombre, quantity as ori_quantity, alta_db as fecha, 'VALE' as tipo
    FROM vale WHERE anticipo_container = 0 AND paid = 0 AND aplicado = 0 AND moneda_id = 1 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_pesos ORDER BY alta_db DESC";

    $sql_vales_anticipo_container_pesos = "SELECT vale_id as id,
    quantity - total_payments as quantity, 'PESOS' as moneda, 'vale' as doc, vale_number as numero, 'l Vale' as nombre, quantity as ori_quantity, alta_db as fecha, 'ANTICIPO CONTAINER' as tipo
    FROM vale WHERE anticipo_container = 1 AND paid = 0 AND aplicado = 0 AND moneda_id = 1 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_pesos ORDER BY alta_db DESC";

    $sql_cheques_usd = "SELECT cheque_id as id,
    quantity - total_payments as quantity, 'USD' as moneda, 'cheque' as doc, numero, 'l Cheque' as nombre, quantity as ori_quantity, IF(new_date IS NULL, original_date, new_date) as fecha, tipo
    FROM cheque WHERE tipo NOT IN ('NOTA', 'GASTO') AND paid = 0 AND moneda_id = 2 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_usd ORDER BY IF(new_date IS NULL, original_date, new_date) ASC, quantity ASC, alta_db ASC";

    $sql_notas_usd = "SELECT cheque_id as id,
    quantity - total_payments as quantity, 'USD' as moneda, 'cheque' as doc, numero, ' la Nota' as nombre, quantity as ori_quantity, IF(new_date IS NULL, original_date, new_date) as fecha, tipo
    FROM cheque WHERE tipo IN ('NOTA', 'GASTO') AND paid = 0 AND moneda_id = 2 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_usd ORDER BY IF(new_date IS NULL, original_date, new_date) ASC, quantity ASC, alta_db ASC";

    $sql_pagares_usd = "SELECT pagare_id as id,
    quantity - total_payments as quantity, 'USD' as moneda, 'pagare' as doc, numero, 'l Pagaré' as nombre, quantity as ori_quantity, original_date as fecha, 'PAGARE' as tipo
FROM pagare WHERE paid = 0 AND moneda_id = 2 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_usd ORDER BY original_date ASC, quantity ASC, alta_db ASC";

    $sql_vales_usd = "SELECT vale_id as id,
    quantity - total_payments as quantity, 'USD' as moneda, 'vale' as doc, vale_number as numero, 'l Vale' as nombre, quantity as ori_quantity, alta_db as fecha, 'VALE' as tipo
FROM vale WHERE anticipo_container = 0 AND paid = 0 AND aplicado = 0 AND moneda_id = 2 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_usd ORDER BY alta_db DESC";

    $sql_vales_anticipo_container_usd = "SELECT vale_id as id,
    quantity - total_payments as quantity, 'USD' as moneda, 'vale' as doc, vale_number as numero, 'l Vale' as nombre, quantity as ori_quantity, alta_db as fecha, 'ANTICIPO CONTAINER' as tipo
FROM vale WHERE anticipo_container = 1 AND paid = 0 AND aplicado = 0 AND moneda_id = 2 AND  cliente_id = '$cliente_id' AND ABS(quantity - total_payments) > $tolerancia_usd ORDER BY alta_db DESC";

    $nombre_cliente = strtoupper(ia_singleread($sql_nombre_cliente) ?? "");
    $saldo_cheques_pesos = ia_singleread($sql_saldo_cheques_pesos);
    $saldo_cheques_usd = ia_singleread($sql_saldo_cheques_usd);
    $saldo_pagares_pesos = ia_singleread($sql_saldo_pagares_pesos);
    $saldo_pagares_usd = ia_singleread($sql_saldo_pagares_usd);
    $saldo_vales_pesos = ia_singleread($sql_saldo_vales_pesos);
    $saldo_vales_usd = ia_singleread($sql_saldo_vales_usd);
    $saldo_vales_anticipo_container_pesos = ia_singleread($sql_saldo_vales_anticipo_container_pesos);
    $saldo_vales_anticipo_container_usd = ia_singleread($sql_saldo_vales_anticipo_container_usd);
    $saldo_notas_pesos = ia_singleread($sql_saldo_notas_pesos);
    $saldo_notas_usd = ia_singleread($sql_saldo_notas_usd);
    $arr_cheques_pesos = ia_sqlArrayIndx($sql_cheques_pesos);
    $arr_cheques_usd = ia_sqlArrayIndx($sql_cheques_usd);
    $arr_pagares_pesos = ia_sqlArrayIndx($sql_pagares_pesos);
    $arr_pagares_usd = ia_sqlArrayIndx($sql_pagares_usd);
    $arr_vales_pesos = ia_sqlArrayIndx($sql_vales_pesos);
    $arr_vales_usd = ia_sqlArrayIndx($sql_vales_usd);
    $arr_vales_anticipo_container_pesos = ia_sqlArrayIndx($sql_vales_anticipo_container_pesos);
    $arr_vales_anticipo_container_usd = ia_sqlArrayIndx($sql_vales_anticipo_container_usd);
    $arr_notas_pesos = ia_sqlArrayIndx($sql_notas_pesos);
    $arr_notas_usd = ia_sqlArrayIndx($sql_notas_usd);


    /*echo "<pre>$sql_saldo_cheques_pesos" . print_r($saldo_cheques_pesos, true) . "</pre>";
    echo "<pre>$sql_saldo_cheques_usd" . print_r($saldo_cheques_usd, true) . "</pre>";
    echo "<pre>$sql_cheques_pesos" . print_r($arr_cheques_pesos, true) . "</pre>";
    echo "<pre>$sql_cheques_usd" . print_r($arr_cheques_usd, true) . "</pre>";
    echo "<pre>$sql_saldo_pagares_pesos" . print_r($saldo_pagares_pesos, true) . "</pre>";
    echo "<pre>$sql_saldo_pagares_usd" . print_r($saldo_pagares_usd, true) . "</pre>";
    echo "<pre>$sql_pagares_pesos" . print_r($arr_pagares_pesos, true) . "</pre>";
    echo "<pre>$sql_pagares_usd" . print_r($arr_pagares_usd, true) . "</pre>";
    echo "<pre>$sql_saldo_vales_pesos" . print_r($saldo_vales_pesos, true) . "</pre>";
    echo "<pre>$sql_saldo_vales_usd" . print_r($saldo_vales_usd, true) . "</pre>";
    echo "<pre>$sql_vales_pesos" . print_r($arr_vales_pesos, true) . "</pre>";
    echo "<pre>$sql_vales_usd" . print_r($arr_vales_usd, true) . "</pre>";*/

    $saldo_pesos = $saldo_cheques_pesos + $saldo_notas_pesos + $saldo_pagares_pesos - $saldo_vales_pesos;
    $saldo_usd = $saldo_cheques_usd + $saldo_notas_usd + $saldo_pagares_usd - $saldo_vales_usd;

    $saldo_pesos_hidden = $saldo_pesos != 0 ? "block" : "none;";
    $saldo_usd_hidden = $saldo_usd != 0 ? "block" : "none;";
    $txt_saldo_pesos = "<table id='doctos_saldo_pesos' style='display: $saldo_pesos_hidden'><tr><td style='min-width: 150px;'><span class='bold lbl_doc_pesos'>SALDO PESOS</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_pesos' style='font-size: 1.35em;'>" . echonf($saldo_pesos, true) . "</span></td></tr></table>";
    $txt_saldo_usd = "<table id='doctos_saldo_usd'  style='display: $saldo_usd_hidden'><tr><td style='min-width: 150px;'><span class='bold lbl_doc_usd'>SALDO USD</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_usd' style='font-size: 1.35em;'>" . echonf($saldo_usd, true) . "</span></td></tr></table>";

    $arr_mons = array('cuantos' => 0, 'PESOS' => 0, 'USD' => 0);
    $arr_docs = array('notas_pesos' => array('mon' => 'PESOS'), 'notas_usd' => array('mon' => 'USD'), 'cheques_pesos' => array('mon' => 'PESOS'), 'cheques_usd' => array('mon' => 'USD'), 'pagares_pesos' => array('mon' => 'PESOS'), 'pagares_usd' => array('mon' => 'USD'), 'vales_pesos' => array('mon' => 'PESOS', 'signo' => '-'), 'vales_usd' => array('mon' => 'USD', 'signo' => '-'), 'vales_anticipo_container_pesos' => array('mon' => 'PESOS', 'lb' => 'vales_pesos', 'signo' => '-'), 'vales_anticipo_container_usd' => array('mon' => 'USD', 'lb' => 'vales_usd', 'signo' => '-'));
    $arr_todos = array();
    $arr_lineas = array();

    $max_height = $iacc == 'app_clientes_saldos' ? "1000px" : "160px";

    $rows_max = 0;
    $linea = 0;
    $clb = '';
    $totales = false;
    $width_wrapper = 0;
    $cww = 0;

    $flex_new_line = "<div style='flex-basis: 100%; height: 0; width: 100%;'>&nbsp;</div>";
    foreach ($arr_docs as $doc => $mon) {
        $lb = array_key_exists('lb', $mon) ? $mon['lb'] : '';
        if ($lb != $clb) {
            $linea++;
            $width_wrapper = $cww = 0;
            $rows_max = 0;
            $totales = false;
        }
        $clb = $lb;
        $c_docs = "arr_" . $doc;
        if (!empty($$c_docs)) {
            $arr_todos[$doc] = $$c_docs;
            $arr_lineas[$linea]['rows_max'] = $rows_max = max(sizeof($$c_docs), $rows_max);
            $arr_mons[$mon['mon']]++;
            $arr_mons['cuantos']++;
            $arr_todos[$doc]['cuantos'] = sizeof($$c_docs);
            $arr_todos[$doc]['linea'] = $linea;
            $arr_todos[$doc]['signo'] = $mon['signo'] ?? '';
            $arr_todos[$doc]['suma'] = doOperation('SUM', $arr_todos[$doc], 'quantity', false, false);
            $arr_todos[$doc]['lb'] = strtoupper(TableHelper::dashesToCamelCase($mon['lb'] ?? $doc));
            $totales = $linea > 0 || ($arr_mons['PESOS'] > 0 && $arr_mons['USD'] > 0);
            $cww += $linea == 0 ? 255 : 390;
            $arr_todos[$doc]['moneda'] = strtolower($mon['mon']);
            $arr_lineas[$linea]['docs'][$doc] = $arr_todos[$doc];
            $arr_lineas[$linea]['width'] = $width_wrapper = max($cww, $width_wrapper);
            $arr_lineas[$linea]['calc_totales'] = $totales;

        }


    }
//    echo "<pre>arr_todos" . print_r($arr_todos, true) . "</pre>";
//    echo "<pre>$totales " . !$totales  . print_r($arr_mons, true) . "</pre>";

    $margin_top = in_array($iacc, ['vale','pagare']) ? "30px" : "15px";
    $html = "<div class='dved' id='saldo_cliente_tabla' style='display:none; position:absolute; background: #ffffff; width:fit-content; white-space: nowrap; margin-top: $margin_top; padding: 0.5em; border:2px outset #cacaca; border-radius: 10px 10px 10px 10px; z-index: 995;'>
    <div id='saldo_cliente_tabla_toolbar' style='display: none; position: absolute;  background: #ffffff; width:fit-content; white-space: nowrap; margin-top: -32px; padding: 0.2em; border:2px outset whitesmoke; border-radius: 5px 5px 5px 5px; z-index: 994;'></div>
    <div id='saldo_cliente_tabla_maximize' style='display: block; float:right; background: #ffffff; width:fit-content; white-space: nowrap; margin-top: -30px; padding: 0.1em; border:2px outset whitesmoke; border-radius: 5px 5px 5px 5px; z-index: 994;'>
    
    <a class='tooltip_toolbar_wohtml' title='Restaurar' onclick='minimizar_saldo();'><i class='fa-icon fa-solid fa-window-minimize txt_1_2em'></i></a>
    <a class='tooltip_toolbar_wohtml' title='Restaurar' onclick='restaurar_saldo();'><i class='fa-icon fa-solid fa-window-restore txt_1_2em'></i></a>
    
    </div>
    <div style='margin-top: -20px;'>&nbsp;</div>
    <div style='margin-top: 0.4em;margin-bottom: 0.4em;padding-left: 0.5em; display: none;' id='saldo_cliente_nombre' class='bg_blue_pesos txt19px'>$nombre_cliente</div>";

    $txt_totales = array();
    $linea = -1;
    if(!empty($arr_todos)){

            $txt_saldo_pesos = "";
            $txt_saldo_usd = "";
            foreach ($arr_lineas as $linea => $_line_data) {
                $txt_totales[$linea] = "";
                foreach ($_line_data['docs'] as $_tipo => $_docs) {

                    if ($_line_data['calc_totales']) {

                        $txt_totales[$linea] .= "<table id='doctos_saldos_" . $_tipo . "' style='display: block;'>"; //($linea > -1 ? $div_line_close : '');

                        $txt_totales[$linea] .= "<tr><td style='min-width: 150px;'><span class='bold lbl_doc_" . $_docs['moneda'] . "'>" . $_docs['lb'] . "</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_" . $_docs['moneda'] . "' style='font-size: 1.35em;'>" . $_docs['signo'] . echonf($_docs['suma'], true) . "</span></td></tr>";

                        $txt_totales[$linea] .= "</table>";

                        $arr_lineas[$linea]['totales'] = $txt_totales[$linea];
                    }
                    else {
                        $saldo_pesos = $saldo_cheques_pesos + $saldo_notas_pesos + $saldo_pagares_pesos - $saldo_vales_pesos;
                        $saldo_usd = $saldo_cheques_usd + $saldo_notas_usd + $saldo_pagares_usd - $saldo_vales_usd;

                        $saldo_pesos_hidden = $arr_mons['PESOS'] > 0 ? "block" : "none;";
                        $saldo_usd_hidden = $arr_mons['USD'] > 0  ? "block" : "none;";
                        $txt_saldo_pesos = "<table id='doctos_saldo_pesos' style='display: $saldo_pesos_hidden'><tr><td style='min-width: 150px;'><span class='bold lbl_doc_pesos'>SALDO PESOS</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_pesos' style='font-size: 1.35em;'>" . echonf($saldo_pesos, true) . "</span></td></tr></table>";
                        $txt_saldo_usd = "<table id='doctos_saldo_usd'  style='display: $saldo_usd_hidden'><tr><td style='min-width: 150px;'><span class='bold lbl_doc_usd'>SALDO USD</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_usd' style='font-size: 1.35em;'>" . echonf($saldo_usd, true) . "</span></td></tr></table>";

                        $arr_lineas[$linea]['totales'] = $txt_saldo_pesos . $txt_saldo_usd;
                    }
                }
            }

//        $txt_saldo_pesos = $txt_totales;


//    echo "<pre>arr_todos" . print_r($arr_todos, true) . "</pre>";
//    echo "<pre>$totales " . !$totales  . print_r($txt_totales, true) . "</pre>";
//    echo "<pre>arr_lineas " . print_r($arr_lineas, true) . "</pre>";

//echo ia_htmlentities($div_line_close);
//    $linea = -1;

        $c_line_html = [];
        foreach ($arr_lineas as $linea => $_line_data) {
            $c_line_html = [];
            $c_line_html[] = $div_line = "<div style='width:" . $_line_data['width'] . "px; max-height:$max_height; overflow-y: auto; clear: both; display: flex; flex-flow: row wrap; justify-content: space-evenly; min-height: 70px;' id='doctos_detalle_" . $linea . "' >";

            if($linea > 0)
                $c_line_html[] = "<div style='width:" . $_line_data['width'] . "px; margin: 20px; '><hr style='border-color: #747474;'/></div>";

            foreach ($_line_data['docs'] as $_tipo => $_doc) {
//        echo "<pre>_doc" . print_r($_doc, true) . "</pre>";

                $c_doc_div = "";
                $_mon = "";
                $cuantos_docs = $_doc['cuantos'];
                $signo = $_doc['signo'] ?? "";
//            $c_doc_div = $div_line;


                for ($i = 0; $i < $_line_data['rows_max']; $i++) {
                    if (array_key_exists($i, $_doc)) {
                        $_mon = strtolower($_doc[$i]['moneda']);

                        $txt_saldo = $_doc[$i]['ori_quantity'] != $_doc[$i]['quantity'] ? ", qty original $ " . echonf($_doc[$i]['ori_quantity'], true) . ", saldo $ " . echonf($_doc[$i]['quantity'], true) : "";

                        $c_doc_div .= "<tr><td style='padding-right:1em; padding-left:1em;' class='txt_0_9em txt_bold_black txt_centered'>" . ia_htmlentities(mysqlDate2display(substr($_doc[$i]['fecha'], 0, 10))) . "</td><td class='txt_right_aligned bold tooltip_toolbar_wohtml' title='Ir a" . $_doc[$i]['nombre'] . " #" . $_doc[$i]['numero'] . "$txt_saldo' class='' >" .
                            "<a href='../backoffice/" . $_doc[$i]['doc'] . ".php?iah=e&id=" . $_doc[$i]['id'] . "' target='_blank' style='text-decoration: none; position: relative; display: inline-block;'><span class='bold lbl_doc_$_mon txt_1em'>$signo " . echonf($_doc[$i]['quantity'], true) . "</span><span style='position: absolute; top: -10px; left: -10px; right: -10px; bottom: -10px; z-index: 0;'></span></a></td></tr>";

//                $arr_todos[$_tipo]['suma'] += $_doc[$i]['quantity'];
                    } else
                        $c_doc_div .= "<tr><td colspan='2'>&nbsp;</td></tr>";
                }
                $c_thead = "<div class='' style='padding-left: 5px;padding-right: 5px;' id='div_doc_$_mon'><table id='tabla_doc_$_mon'><thead><tr><th colspan='2'>" . TableHelper::dashesToCamelCase($_tipo) . " (" . $cuantos_docs . ")</th></tr></thead><tbody>";
//    $c_doc_div .= "<tr><td><hr/></td></tr>";
                $saldo_doc = "saldo_" . $_tipo;
                $c_doc_div .= "</tbody>";
//                echo "<pre>_doc" . print_r($_doc, true) . "</pre>";

                if($_doc['cuantos'] > 1)
                    $c_doc_div .=  "<tfoot><tr><td colspan='2' class='txt_right_aligned bold lbl_doc_$_mon' style='cursor: auto;'>$signo " . echonf($$saldo_doc, true) . "</td></tr></tfoot>";

                $c_doc_div .= "</table></div>";
                $c_doc_div = $c_thead . $c_doc_div;
                $c_line_html[] = $c_doc_div;

            }
            $div_line_close = "</div>$flex_new_line<div style='clear: both; margin-top: 5px; margin-bottom: 15px;' class='txt_1_1em' id='doctos_saldo_" . $linea . "' >" . $_line_data['totales'] . "</div>";
            $c_line_html[] = $div_line_close;


            $html .= implode($c_line_html);
//        $html .= '</div>';
        }
    }


    $usuario = $_SESSION['usuario'];
    $now = date('Y-m-d H:i:s');
    $por = "por $usuario, el " . mysqlDateTime2display($now, true);

    if(!sizeof($arr_lineas))
        $flex_new_line = "<div style='width: 100%;'><table id='doctos_saldo_pesos' style=''><tr><td style='min-width: 150px;'><span class='bold lbl_doc_pesos'>SALDO</span></td><td style='min-width: 180px;' class='txt_right_aligned'><span class='bold lbl_doc_pesos' style='font-size: 1.35em;'>" . echonf(0.00, true) . "</span></td></tr></table></div><div style='clear: both; height: 0; width: 100%;'>&nbsp;</div>";
    $html .= "$flex_new_line<div style='margin-top: 0px; text-align: right;' class='txt_0_7em bold'><span id='saldo_cliente_por' style='display: block;'>$por</span></div></div>";

//    echo "<pre>$arr_lineas" . print_r($arr_lineas, true) . "</pre>";
    return $html;
}

function init_estado_cuenta_cliente($fileName = '', $detachinsertAfter = 'div_remarks', $doDetach = 'true', $cliente_id = '74867af2fe609f5c11ed2998a6dec652'): void
{
    echo "<div id='dialog_estado_cuenta_cliente'>" . estado_cuenta_cliente($cliente_id) . "</div>";

    global $gIAParametros;

    $segundos_abierto_edo_cta_cliente = $gIAParametros['segundos_abierto_edo_cta_cliente'];
    $segundos_abierto_edo_cta_cliente_activo = $gIAParametros['segundos_abierto_edo_cta_cliente_activo'];
    $tipo_cambio = $gIAParametros['tc'];
    $tolerancia_pago_documentos_pesos = $gIAParametros['tolerancia_pago_documentos_pesos'];
    $tolerancia_pago_documentos_usd = $gIAParametros['tolerancia_pago_documentos_usd'];

    $fileName = empty($fileName) ? $fileName = "estado cuenta " . ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = " . strit($cliente_id)) . " " . date("Ymd_Gis") : $fileName;
    $fileName = sanitizeFileName($fileName);

    echo <<< JSCODE
    <script>
    var cliente_saldo_exporter, prev_selected_row_id = '';
        \$vitex_globales['iac_parametros']['segundos_abierto_edo_cta_cliente_ori'] = $segundos_abierto_edo_cta_cliente;
        \$vitex_globales['iac_parametros']['segundos_abierto_edo_cta_cliente'] = -1;
        \$vitex_globales['iac_parametros']['segundos_abierto_edo_cta_cliente_activo'] ='$segundos_abierto_edo_cta_cliente_activo';
        \$vitex_globales['iac_parametros']['tc'] = $tipo_cambio;
        \$vitex_globales['iac_parametros']['tolerancia_pago_documentos_usd'] = $tolerancia_pago_documentos_usd;
        \$vitex_globales['iac_parametros']['tolerancia_pago_documentos_pesos'] = $tolerancia_pago_documentos_pesos;
    
    $(function() {
        vx_asyncFunction(function(){ 
            do_init_estado_cuenta_cliente();
            $('#div_categoria_id').css('z-index', '996');
        } , 0, this);
    });
    
    function do_init_estado_cuenta_cliente() {
        
        let \$saldo_cliente_tabla = $("#saldo_cliente_tabla");
        let _config = {

            'query_selector':'#saldo_cliente_tabla',
            'query_selector4pdf_table':'',
            'query_selector_wrapper':'#saldo_cliente_tabla',
            'image_copy_alert_element':'#doctos_detalle',
            'pre_func': pre_func,
            'post_func': post_func,
            'hideOnCopy': false,
            'cliente_nombre_ocultar': true,
            'fileName': '$fileName',
            'wrapper_width': \$saldo_cliente_tabla.css('width'),
            'new_window_url': "backoffice/cliente_saldo.php",
            'new_window_field': 'cliente_id',
            'new_window_value': '$cliente_id',
        };
        let doDetach = $doDetach;
        cliente_saldo_exporter = new canvas_exporter(_config);
                    
        if(doDetach)
            \$saldo_cliente_tabla.detach().insertAfter('#$detachinsertAfter').show();
        $("#saldo_cliente_tabla_toolbar").append(cliente_saldo_exporter.toolBar("#saldo_cliente_tabla",{},"cliente_saldo_exporter")).show();
        colapsar_saldo();
        \$saldo_cliente_tabla.css('cursor','grab').draggable({
            containment: "body",
            cursor: "grabbing",

            start: function (ev, ui) {
                $(this).css('cursor','grabbing');
                $(this).addClass('dragging');
            },
            stop: function (ev, ui) {
                $(this).css('cursor','grab');
                $(this).removeClass('dragging');

            },
        });
    }
    
    function pre_func(){
        cliente_saldo_exporter.config.wrapper_width = !$("div[id^='doctos_detalle']").is(":visible");
        cliente_saldo_exporter.config.era_colapsado = !$("div[id^='doctos_detalle']").is(":visible");
        expandir_saldo(); $("#saldo_cliente_tabla_maximize").hide(); $("#saldo_cliente_nombre").show();      
    }
    
    function post_func(){
        restaurar_saldo(); $("#saldo_cliente_tabla_maximize").show(); 
        if(cliente_saldo_exporter.config.cliente_nombre_ocultar)
            $("#saldo_cliente_nombre").hide(); 
        if(cliente_saldo_exporter.config.era_colapsado)
            colapsar_saldo();
    }
    
    function minimizar_saldo(){
        if(!$doDetach)
            return;
        cliente_saldo_exporter.config.minimizado = true;
        cliente_saldo_exporter.config.colapsado = false;
        // $("#saldo_cliente_tabla").css('width','fit-content');
        $("div[id^='doctos_detalle_0']").hide();
        $("div[id^='doctos_saldo_0']").hide();
    }
    
    function colapsar_saldo(){
        if(!$doDetach)
            return;
        cliente_saldo_exporter.config.colapsado = true;
        cliente_saldo_exporter.config.minimizado = false;
        // $("#saldo_cliente_tabla").css('width','fit-content');
        $("div[id^='doctos_detalle']").css('max-height', '160px');
        $("div[id^='doctos_detalle']").hide();
        $("div[id^='doctos_saldo_0']").show();
    }
    function restaurar_saldo(){
        
        if(!cliente_saldo_exporter.config.colapsado){
            colapsar_saldo();
            return;
        }
        
        let mh = $("div[id^='doctos_detalle']").css('max-height');
        if(mh !== '160px')
            $("div[id^='doctos_detalle']").css('max-height', '160px');
        else
            $("div[id^='doctos_detalle']").css('max-height', 'unset');
        
        
        cliente_saldo_exporter.config.colapsado = false;
        cliente_saldo_exporter.config.minimizado = false;
        $("div[id^='doctos_detalle']").show();
        $("div[id^='doctos_saldo_0']").show();
        
        $("#saldo_cliente_tabla").css('width','max-content');
        cliente_saldo_exporter.config.wrapper_width = $("#saldo_cliente_tabla").css('width');
        cliente_saldo_exporter.config.wrapper_height = $("#saldo_cliente_tabla").css('height');
    }
    function expandir_saldo(){
        cliente_saldo_exporter.config.colapsado = false;
        cliente_saldo_exporter.config.minimizado = false;
        $("#saldo_cliente_tabla").css('width','max-content');
        cliente_saldo_exporter.config.wrapper_width = $("#saldo_cliente_tabla").css('width');
        $("div[id^='doctos_detalle']").css('max-height', 'unset');
        cliente_saldo_exporter.config.wrapper_height = $("#saldo_cliente_tabla").css('height');
        $("div[id^='doctos_detalle']").show();
    }
    
    function actualiza_estado_cuenta_cliente(cliente_id = '', callback = null){
        if(!cliente_id.length){
            cliente_id = $("#cliente_id").val() || cliente_saldo_exporter.config.new_window_value;
            if(!cliente_id.length)
                return;
        }
        
        $.ajax({
            url: "ajax/cliente_acciones.php",
            dataType: "json",
            data: {
                cliente_id: cliente_id,
                accion: 'estado_cuenta_cliente',
                iacc: $("#iacc").val(),
            },
            beforeSend: function(jqXHR, settings){
                return true;
            }
        }).done(function(data){
            if(data.Status != 'OK') return;
            
            
            $("#saldo_cliente_tabla").replaceWith($(data.estado_cuenta_cliente_html));
            do_init_estado_cuenta_cliente();
            // $("#saldo_cliente_tabla").find("#saldo_cliente_nombre").replaceWith($(data.estado_cuenta_cliente_html).find("#saldo_cliente_nombre"));
            // $("#saldo_cliente_tabla").find("#doctos_saldo").replaceWith($(data.estado_cuenta_cliente_html).find("#doctos_saldo_pesos"));
            // // $("#saldo_cliente_tabla").find("#doctos_saldo_usd").replaceWith($(data.estado_cuenta_cliente_html).find("#doctos_saldo_usd"));
            // $("#saldo_cliente_tabla").find("#saldo_cliente_por").replaceWith($(data.estado_cuenta_cliente_html).find("#saldo_cliente_por"));
            //
            if(cliente_saldo_exporter.config.colapsado)
                colapsar_saldo();
            
            if(typeof callback === 'function')
                    callback();
            // $('#saldo_cliente_tabla').replaceWith(data.estado_cuenta_cliente_html);
        });
    }
        </script>
JSCODE;

    echo <<< NUEVOESTADOCUENTA
<script>
    function generaEstadoCuenta(id, tipo = 'dialog', cliente_id ='') {
        let rowData = gridhandler.jqGrid('getRowData',id);
        cliente_id = !cliente_id.length ? rowData['cliente_id'] : cliente_id;
        
        actualiza_estado_cuenta_cliente(cliente_id, function(){
            
            let \$saldo_cliente_tabla = $("#saldo_cliente_tabla");
            
            cliente_saldo_exporter.config.image_copy_alert_element_pos = 'left bottom';
            cliente_saldo_exporter.config.image_copy_alert_element = "#iaHome";
            cliente_saldo_exporter.config.fileName = "ESTADO DE CUENTA " + \$saldo_cliente_tabla.find("#saldo_cliente_nombre").text();
            
            \$saldo_cliente_tabla.show();
            
            switch(tipo){
                
                case 'imprimir':
            
                    cliente_saldo_exporter.print("#saldo_cliente_tabla");
                    \$saldo_cliente_tabla.hide();
                    break;
                    
                case 'jpg_copia':
            
                    cliente_saldo_exporter.imageCopy("#saldo_cliente_tabla");
                    \$saldo_cliente_tabla.hide();
                    break;
                
                case 'jpg_guarda':

                    cliente_saldo_exporter.imageSave("#saldo_cliente_tabla");
                    \$saldo_cliente_tabla.hide();
                    break;
                    
                case 'dialog':
                    
                    let \$dialog_estado_cuenta_cliente = $("#dialog_estado_cuenta_cliente");
                    // console.log("prev_selected_row_id", prev_selected_row_id);
                    // console.log("id", id);
                    if(prev_selected_row_id === id && \$dialog_estado_cuenta_cliente.data('uiDialog') && \$dialog_estado_cuenta_cliente.dialog('isOpen')){
                        \$dialog_estado_cuenta_cliente.dialog('close');
                        break;
                    }
                    if(\$dialog_estado_cuenta_cliente.data('uiDialog') && \$dialog_estado_cuenta_cliente.dialog('isOpen')){
                        \$dialog_estado_cuenta_cliente.dialog('close');
                    
                    }
                    clearInterval(\$vitex_globales['iac_parametros'].interval_set);
                    iacParam_initTimer();
                    restaurar_saldo();
                    
                    prev_selected_row_id = id;
                    
                    $("#saldo_cliente_nombre").show();
                    $("#saldo_cliente_tabla_maximize").hide();
                    cliente_saldo_exporter.config.wrapper_width = \$saldo_cliente_tabla.css('width');
                    cliente_saldo_exporter.config.wrapper_height = \$saldo_cliente_tabla.css('height');
                               
                    
                    \$dialog_estado_cuenta_cliente.dialog({
                        width: vx_utils.parseInt(cliente_saldo_exporter.config.wrapper_width) + 50, 
                        height: vx_utils.parseInt(cliente_saldo_exporter.config.wrapper_height) + 100,
                        title: $("#saldo_cliente_nombre").text() + " <span style='float: right;' id='timer_segundos_abierto_edo_cta_cliente'>"+\$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori+" seg.</span></h4>",
                        open: function() {
                            if(\$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_activo == 'Si'){
                                vx_asyncFunction(function(){
                                    clearInterval(\$vitex_globales['iac_parametros'].interval_set);
                                    \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente = \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori;
                                    iacParam_initTimer();
                                }, 0, this);
                            }
                            vx_asyncFunction(function(){
                                expandir_saldo();
                            }, 0, this);
                            vx_asyncFunction(function(){
                                $("#dialog_estado_cuenta_cliente").dialog( "option", "width", vx_utils.parseInt(cliente_saldo_exporter.config.wrapper_width) + 50);
                                $("#dialog_estado_cuenta_cliente").dialog( "option", "height", vx_utils.parseInt(cliente_saldo_exporter.config.wrapper_height) + 100);
                            }, 0, this);
                            
                            vx_asyncFunction(function(){
                                inicializa_ui_tooltip('#saldo_cliente_tabla .tooltip_toolbar_wohtml', 'ui_tooltip_box_top_toolbar_numero_compra_vacios', { my: 'left+30 top-50', at: 'left top' }, 30000);
                            }, 0, this);
                        },
                        close(){
                            clearInterval(\$vitex_globales['iac_parametros'].interval_set);
                            \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente = \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori;
                            $(this).dialog('destroy');
                        } 
                    });
                    break;
                    
                case 'new_win':
                    let url = getUrlBase("backoffice/cliente_saldo.php?cliente_id=" + cliente_id); 
                    
                    window.open(url);
                    
                    break;
            }
        });
    }
    
    
    function iacParam_initTimer() {
        if(\$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori == 0 || \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_activo == 'No')
            return;
        
        \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente = \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori;
        var \$dialog = $("#dialog_estado_cuenta_cliente");
        \$vitex_globales['iac_parametros'].interval_set = setInterval(function () {
            \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente = \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente-1;
            if (\$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente === 0) {
                clearInterval(\$vitex_globales['iac_parametros'].interval_set);
                \$dialog.dialog('close');
                \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente = \$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente_ori;
            }
            $("#timer_segundos_abierto_edo_cta_cliente").text((\$vitex_globales['iac_parametros'].segundos_abierto_edo_cta_cliente+" seg."));
        }, 1000);
    }
</script>
NUEVOESTADOCUENTA;
}