<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
error_reporting(-1);
ini_set('display_errors', 'On');

define("MONEX_BANCO_ID", 14);
function file2EdoCta($archivo='', $bc_id='', $mes="2014-01", $saldoBCUsuario=0.00, $b_id='', $auto=false, &$forceCuenta=false)
{
    global $gIAParametros, $gIAsql, $gSqlClass, $gDebugging;
    include_once('iacWorkday.php');

    $tmpsql = array();
    $sql = array();
    $feriados = new iacWorkday();
    $feriados->workday_set(0,false)->workday_set(6,false);    // domingo y sabado
    $feriados->mexico_oficial_holidays()->mexico_custom_holidays(); // dias oficiales y jueves/viernes santo
    $log_err = "";
    global $gWebDir;
    $file_err = "/lamp/www/$gWebDir/uploads/edocta/";

    $arrfile2EdoCta = array('Error'=>'',
        'Status'=>'',
        'Cuenta'=>'',
        'bc_id'=>[],
        'MovsInsertados'=>0,
        'MovsFallidos'=>0,
        'MovsExistentes'=>0,
        'ErrorCode'=>'0', /** 0 = bien, 1 = Banco no identificado, 2 = Cuenta no identificada, 3 = Saldo no coincide, 4 = Se pido un banco y el archivo no pertenece a él. **/
        'Action2Do'=>'' /** '' = bien, 'bc_id' = Solicitar cuenta, 'saldo' = Soliciar saldo **/);

    if(empty($archivo))
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Archivo corrupto.</span>';
        return $arrfile2EdoCta;
    }
    
    if((empty($bc_id) || empty($b_id)) && !$auto)
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Cuenta Equivocada.</span>';
        return $arrfile2EdoCta;
    }

    $failSafe = true;

    if($failSafe)
    {
        $year = date('Y') - 1;
        $m = date('n');
        if($m == 1)
            $mes = "$year-11-30";
        else
            $mes = "$year-12-31";
    }

    if($auto)
        $pathUF = "";//$gIAParametros['path_archivos_estado_de_cuenta']."\\";
    else {
        global $gWebDir;
        $pathUF = $file_err;
    }

    // Example usage
    $models = initializeModels();
    $arrBancoModel = $models['arrBancoModel'];
    $arrBCColModel = $models['arrBCColModel'];
    $arrBCColsNum = $models['arrBCColsNum'];
    $arrSaldosCol = $models['arrSaldosCol'];
    $arrEmpresas = $models['arrEmpresas'];

    //echo "<pre>".print_r($arrEmpresas, true)."</pre>";

    $saldoBCenArchivoAlter = 0.00;
    $saldoBCenArchivo = 0.00;

    $usuario = $_SESSION['usuario'];

    $fechaKey = $arrBCColModel['fecha']['index']['finalKey'];
    $referenciaKey = $arrBCColModel['referencia']['index']['finalKey'];
    $withdrawalKey = $arrBCColModel['withdrawal']['index']['finalKey'];
    $depositKey = $arrBCColModel['deposit']['index']['finalKey'];
    $balanceKey = $arrBCColModel['balance']['index']['finalKey'];
    $referencia_monex_key = $arrBCColModel['referencia_monex']['index']['finalKey'];

    $finalKeys = [
        'fecha' => $fechaKey,
        'referencia' => $referenciaKey,
        'withdrawal' => $withdrawalKey,
        'deposit' => $depositKey,
        'balance' => $balanceKey,
        'referencia_monex' => $referencia_monex_key
    ];

    $bIndex = false;

    $arrBancoCuentaMov = array();
    $iMovNvo = 0;
    $arrMovsNuevos = false;
    $arrMovsHeader = false;

    $maxCharRef = 10;

    if(!file_exists($pathUF.$archivo))
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Error al procesar el archivo. El Archivo no existe.</span>';
        return $arrfile2EdoCta;
    }

    //Detectamos el banco o al menos lo intentamos.

    if($auto)
    {
        /**if($b_id!='5')
        $b_id = false;
        $bIndex = false;**/
        $bIndex = $b_id;
        if($b_id == '5' || $b_id == 5)
            $bIndex = 3;
        else if($b_id == '14' || $b_id == 14)
            $bIndex = 4;
    }
    else
    {
        foreach($arrBancoModel as $k => $v)
            if($v['b_id'] == $b_id)
                $bIndex = $k;
    }

    if(empty($b_id))
        identificaBancoEdoCta($pathUF.$archivo, $arrBancoModel, $b_id, $bIndex);
    $bIndex = $b_id;
    if(empty($b_id))
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">No fue posible determinar el Banco.</span>';
        $arrfile2EdoCta['ErrorCode'] = '1';
        $arrfile2EdoCta['Action2Do'] = 'bc_id';
        return $arrfile2EdoCta;
    }
//    $arrBCColsNum['required'] = $arrBancoModel[$b_id]['minCols'];
    /*
            //Bloqueo de la cuenta.
            $myLock = new ProcessLock();
            //$s = md5($appCB.$CtaT->cuenta_bancaria.$CtaT->quantity.$CtaT->fecha_deposito);
            $s = md5($b_id);
            $gotLock = $myLock->aquire($s);

            if(!$gotLock)
            {
                $arrfile2EdoCta["Status"] = 'Error';
                $arrfile2EdoCta["Error"] = '<span class="txt_color_red bold">Concurrencia de Links.</span>';
                $arrfile2EdoCta['ErrorCode'] = '1';
                $arrfile2EdoCta['Action2Do'] = 'bc_id';
                return $arrfile2EdoCta;
            }
    */

    //echo "\r\nBanco: $b_id\r\n";
    //quitar false para xlsx
    if(stripos($pathUF.$archivo, "xlsx") !== false && ($b_id == 1 || $b_id == 3)) {//Aqui decidimos que es bancomer y traemos el arreglo de otra función. //VCA 12-03-2021 HSBC cambió su formato
        $arrMovsNuevos = xlsx2Array($pathUF . $archivo, '', false, $arrBCColsNum['required']);
    }
    else if($b_id == '5' || $b_id == 5) {
        $arrMovsNuevos = html2Array($pathUF . $archivo, $arrBancoModel[$bIndex], $arrBCColModel, $arrBCColsNum);
    }
    else {
        $arrMovsNuevos = csv2Array($pathUF . $archivo, $arrBancoModel[$bIndex]['delimiter']);
    }
    if(!is_array($arrMovsNuevos) || empty($arrMovsNuevos))
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Error al procesar el archivo. No se encontraron movimientos bancarios.</span>';
        return $arrfile2EdoCta;
    }


    /** Establecemos si la referencia es uno o más campos **/

    $arrBCColModel['referencia']['index']['array'] = $arrBancoModel[$bIndex]['refArray'];



    if(encuentraHeaderEdoCta($arrBCColModel, $arrBCColsNum, $arrMovsNuevos, $arrMovsHeader) === false)
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Error al procesar el archivo. No se encontró el inicio de los movimientos bancarios.</span>';
        return $arrfile2EdoCta;
    }

    /** Intentamos determinar la cuenta a la que pertenece el archivo **/
    //if($auto) $bc_id = false; /** Quitar **/
    //echo "bc_id before: $bc_id";
    if(empty($bc_id))
        $bc_id = identificaCuentaEdoCta($arrMovsNuevos, $arrMovsHeader, $arrBancoModel[$bIndex], $archivo, $arrBCColModel);
ia_errores_a_dime();
    if(empty($bc_id))
    {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">No fue posible determinar la Cuenta Bancaria.</span>';
        $arrfile2EdoCta['ErrorCode'] = '2';
        $arrfile2EdoCta['Action2Do'] = 'bc_id';
        $arrfile2EdoCta['b_id'] = $b_id;
    }
//    echo "Col Model $bc_id: <pre>".print_r($arrBCColModel, true)."</pre>";
//    echo "Nuevos Original: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//    echo "arrBCColsNum: <pre>".print_r($arrBCColsNum, true)."</pre>";


    /** 05-01-2017 Revisamos que la cuenta esté activa **/
    //$puede_banco_a_banco_list = Permisador::puede('banco_a_banco_list','No');
    $puedeEditar = puedeCuentaBancaria('', $bc_id);
    /**
    $puedeLeer = puedeCuentaBancaria('','','R/O',true);
    //echo "puedeEditar: <pre>".print_r($puedeEditar, true)."</pre>";
    if (!$puedeEditar['puede'] && !$puedeLeer['puede'])// && $puede_banco_a_banco_list === 'No') {
        $arrfile2EdoCta['Status'] = 'Error';
        $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">La Cuenta Bancaria no está activa o no tiene permiso.</span>';
        $arrfile2EdoCta['ErrorCode'] = '2';
        $arrfile2EdoCta['Action2Do'] = 'bc_id';
        $arrfile2EdoCta['b_id'] = $b_id;
        return $arrfile2EdoCta;
    }
    **/

    //VCA: 16-Octubre-2023 Truco sucio para las cuentas hermanas Pesos/USD;
    $bc_arr = array($bc_id);

    $arr_MovsNuevos[$bc_id] = $arrMovsNuevos;

    if($b_id == 14) {
        unset($arr_MovsNuevos[$bc_id]['USD']);
        $bc_arr[] = $bc_id + 1;
        $arr_MovsNuevos[$bc_id + 1] = array_key_exists('USD', $arrMovsNuevos) ? $arrMovsNuevos['USD'] : [];
    }



//    echo "arrMovsNuevos: <pre>".print_r($arr_MovsNuevos, true)."</pre>";
//    die();
    unset($arrMovsNuevos);
    unset($bc_id);
//    echo "arr_MovsNuevos: <pre>".print_r($arr_MovsNuevos, true)."</pre>";
//    echo "bc_arr: <pre>".print_r($bc_arr, true)."</pre>";unset($bc_id);
//
//    die();
    $sql_insert = array();
    foreach($bc_arr as $bc_id) {
        $arrBancoCuentaMov = array();
        $arrMovsNuevos = $arr_MovsNuevos[$bc_id];

//    echo "arr_MovsNuevos $bc_id: <pre>".print_r($arrMovsNuevos, true)."</pre>";
////    echo "bc_arr: <pre>".print_r($bc_arr, true)."</pre>";unset($bc_id);
//
//    die();
        $ctaBancariaNombre = ia_htmlentities(ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$bc_id'"));
        $arrfile2EdoCta['Cuenta'] .= $ctaBancariaNombre;
        $arrfile2EdoCta['bc_id'][] = $bc_id;

        if (!estandarizaColsEdoCta($arrMovsNuevos, $arrBCColModel, $saldoBCenArchivo, $arrBancoModel[$bIndex], $arrMovsHeader, $saldoBCenArchivoAlter, $arrSaldosCol)) {
            $arrfile2EdoCta['Status'] = 'Error';
            $arrfile2EdoCta['Error'] .= '<span class="txt_color_red bold">Error al procesar el archivo. No se pudo estandarizar las columnas.</span>';
//            $myLock->release();
            continue;
//            return $arrfile2EdoCta;
        }

        if($b_id == 14) {
            quita_movimientos_fantasma_monex($arrMovsNuevos, $referenciaKey);
            $bc_id_ok = revisa_movimientos_pertecen_a_cuenta_monex($arrMovsNuevos, $finalKeys, $bc_id, $bc_id_calc);

//            echo "arr_MovsNuevos $bc_id_ok: $bc_id !== $bc_id_calc: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//            $arrfile2EdoCta['Status'] = 'Error';
//            $arrMovsNuevos = array();
//            continue;
        }

//        die();
        //Aquí buscamos la fecha más antigua.
        uksort($arrMovsNuevos, function ($aKey, $bKey) use ($fechaKey, $arrMovsNuevos) {

            $timestampA = strtotime($arrMovsNuevos[$aKey][$fechaKey]);
            $timestampB = strtotime($arrMovsNuevos[$bKey][$fechaKey]);

            // First, compare by dates
            if ($timestampA != $timestampB) {
                return $timestampA - $timestampB;
            }

            // If dates are equal, compare by keys
            return $aKey - $bKey;
        });



        //VCA 22-05-2019
        if (empty($arrMovsNuevos)) {
            $arrfile2EdoCta['Status'] = 'OK';
            $arrfile2EdoCta['Error'] = "<strong>Estado de Cuenta Importado con Éxito.</strong><br/><br/><strong>Resumen:</strong><br/>
            <li>Cuenta: <strong>$ctaBancariaNombre</strong>.<br/>
            <strong>===========================================</strong>
            <br/>
            <li><span class='txt_color_red bold'>No hay movimientos para revisar.</span>
            <a href='../cobranza/edocta.php?banco_cuenta_id=$bc_id' title='Abrir el Estado de Cuenta Importado.' target='_blank'>
            Abrir <strong>$ctaBancariaNombre.</strong> <img src='/img/banco.png' alt='Bancos' title='Bancos'></a>";
//            return $arrfile2EdoCta;
//            $myLock->release();
            continue;
        }

        $arrMovsNuevos = array_values($arrMovsNuevos);



        $tmp1 = array_values(array_slice($arrMovsNuevos, -1))[0];
        $tmp2 = $arrMovsNuevos[0];

        $tmpt1 = new DateTime(date('Y-m-d', strtotime($tmp1[$fechaKey])));
        $tmpt2 = new DateTime(date('Y-m-d', strtotime($tmp2[$fechaKey])));

        $log_err .= "1 Mov: <pre>".print_r($tmp1, true)."</pre>";
        $log_err .= "2 Mov: <pre>".print_r($tmp2, true)."</pre>";

        $log_err .= "1 fecha: <pre>".print_r($tmpt1, true)."</pre>";
        $log_err .= "2 fecha: <pre>".print_r($tmpt2, true)."</pre>";

        $mes1 = $mes;

        if ($tmpt1 < $tmpt2)
            $mes = $tmp1[$fechaKey];
        else
            $mes = $tmp2[$fechaKey];


//        echo "log_err: <pre>".print_r($log_err, true)."</pre>";
//        echo "Nuevos Estandarizados: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//        echo "bc_arr: <pre>".print_r($bc_arr, true)."</pre>";
//        die();

        //if(array_key_exists(0, $arrMovsNuevos) && array_key_exists($balanceKey, $arrMovsNuevos[0]))
        //$saldoBCenArchivo = floatval(limpiaCantidad($arrMovsNuevos[0][$balanceKey]));
        if (!$auto && $saldoBCenArchivo != $saldoBCUsuario) {
            $arrfile2EdoCta['Status'] = 'Error';
            $arrfile2EdoCta['Error'] = "<span class=\"txt_color_red bold\">Saldo no coincide 123. $saldoBCenArchivo _ $saldoBCUsuario</span>";
//            return $arrfile2EdoCta;
//            $myLock->release();
            continue;
        }


        $sqlMovsAnt = "SELECT DATE(fecha) as '0', numero as '1', withdrawal as '2', (cash + deposit) as '3', '' as '4', banco_cuenta_mov_id, banco_cuenta_id, banco_id, fecha as fechaOri, alta_tipo, link_vale, 'NO' as 'matcheado', referencia_monex FROM banco_cuenta_mov WHERE banco_cuenta_id = '$bc_id' AND fecha >= '$mes' ORDER BY fechaOri DESC, banco_cuenta_mov_id DESC";
        $arrMovsAnt = ia_sqlArrayIndx($sqlMovsAnt);

//    echo "$sqlMovsAnt \r\nAnteriores Original: <pre>".print_r($arrMovsAnt, true)."</pre>";
//    die();

        if (!empty($arrMovsAnt))
            $hayMovsAnt = true;
        else {
            $mes = $mes1;
            $sqlMovsAnt = "SELECT DATE(fecha) as '0', numero as '1', withdrawal as '2', (cash + deposit) as '3', '' as '4', banco_cuenta_mov_id, banco_cuenta_id, banco_id, fecha as fechaOri, alta_tipo, link_vale, 'NO' as 'matcheado', referencia_monex FROM banco_cuenta_mov WHERE banco_cuenta_id = '$bc_id' /*AND fecha >= '$mes'*/ ORDER BY fechaOri ASC, banco_cuenta_mov_id DESC LIMIT 20";
            $arrMovsAnt = ia_sqlArrayIndx($sqlMovsAnt);
            if (empty($arrMovsAnt))
                $hayMovsAnt = false;
        }

        $log_err .= "$sqlMovsAnt \r\n";

        $nowMoment = new DateTime(date('H:i:s'));
        $today = date('Y-m-d');
        $arrPalabrasSBC = array('SALVO',
            'SALVO BUEN',
            'SALVO BUEN COBRO',
            'OTRO BANCO',
            'CHEQUES DE OTRO',
            'CHEQUES DE OTRO BANCO',
            'CHEQUE DE OTRO',
            'CHEQUE DE OTRO BANCO',
            'S.B.C.');

//        print_r ($arrMovsNuevos);
//        echo "\r\n";
//        print_r ($arrMovsAnt);
//        echo "\r\n";
//
//        die();


        foreach ($arrMovsNuevos as $kmovNvo => &$movNvo) {
            reset($arrMovsAnt); // Reset the cursor of the second array
            // dd_($movNvo);
            $igual = 0;
            $parecido = 0;
            $nowMoment->modify("+1 second");//Puede ser lento.
            $refOriginal = quitacaracraros($movNvo[$referenciaKey]);

            //Compara los movimientos tentativamente nuevos con los que tiene la BD.
            foreach ($arrMovsAnt as $kmovAnt => &$movAnt) {
                //echo "Anterior a Comparar: <pre>".print_r($movAnt, true)."</pre>";
//                $nowMoment->modify("+1 second");//Puede ser lento.
                //
                //Hacer una variable con $movNvo[$referenciaKey], $movAnt[$referenciaKey]
                //

                //$fechaRevisada = false;

                //Hacemos una verificación en putiza para arreglar los movimientos en fin de semana de banamex.
                if ($b_id == '2') {
                    if (isWeekend($movAnt[$fechaKey])) {
                        //$movAnt[$fechaKey] = sumaDias($movAnt[$fechaKey],2);
                        $movAnt[$fechaKey] = $feriados->nextWorkday($movAnt[$fechaKey]); // regresa 1 dia habil despues de la fecha
                        //echo "Anterior a Comparar: <pre>".print_r($arrMovsAnt[$kmovAnt], true)."</pre>";

                    }

                    /**
                     * foreach($arrPalabrasSBC as $ref)
                     * if(strpos($movAnt[$referenciaKey], $ref) !== false)
                     * {
                     * $fechaRevisada = true;
                     * break;
                     * }
                     **/
                }

                //$refSimilarity = 0.00;
                //$refCaracIguales = similar_text($movAnt[$referenciaKey], $movNvo[$referenciaKey], $refSimilarity);
                $refAnterior = $movAnt[$referenciaKey];
                $refNueva = $movNvo[$referenciaKey];
                $refNueva = limpiaReferenciaBancaria($refNueva);
                $refAnterior = limpiaReferenciaBancaria($refAnterior);

                $movNvo[$referenciaKey] = $refNueva;

//                    $log_err .=  "\r\nComparacion sólo fecha monto\r\n";
//                    $log_err .=  "1NVO: ".$refNueva."\r\n";
//                    $log_err .=  "1ANT: ".$refAnterior."\r\n";

                if ((/**$fechaRevisada ||**/ $movNvo[$fechaKey] == $movAnt[$fechaKey]) /*fecha*/
                    && (floatval($movNvo[$withdrawalKey]) == floatval($movAnt[$withdrawalKey])) /*cargo*/
                    && (floatval($movNvo[$depositKey]) == floatval($movAnt[$depositKey])) /*abono*/
                    && ($movAnt['matcheado'] == 'NO')/** ( $b_id == '2' && ($refSimilarity > 50 || $refCaracIguales > 30) ) || banamex es imposible.**/
                ) {
                    $log_err .= "\r\nComparacion sólo cadena de caracteres\r\n";
                    $log_err .= "\r\nPor comparar: \r\n$---------------movNvo:" . $movNvo[$referenciaKey] . "\r\n---------movAnt:" . $refAnterior . "---------\r\n";
                    $log_err .= "\r\nmovNvo:" . $movNvo[$referenciaKey] . ", $ " . floatval($movNvo[$depositKey]) . " movAnt:" . $movAnt[$referenciaKey] . ", $ " . floatval($movAnt[$depositKey]) . "\r\n";

                    //$refNueva = $movNvo[$referenciaKey];
                    //$log_err .=  "\r\n1NVO: ".$refNueva."\r\n";
                    //$log_err .=  "1ANT: ".$refAnterior."\r\n";

                    $log_err .= "\r\nNVO: " . $refNueva . "\r\n";
                    $log_err .= "ANT: " . $refAnterior . "\r\n";
                    $log_err .= "COMPARACION:" . strpos($refNueva, $refAnterior) . "\r\n";


                    if ($refAnterior == $refNueva || (strpos($refNueva, $refAnterior) == 0 && strpos($refNueva, $refAnterior) !== false) || (strpos($refAnterior, $refNueva) == 0 && strpos($refAnterior, $refNueva) !== false) || (conFin($refNueva, $refAnterior))) {
                        $log_err .= "\r\nmovNvo:" . $refNueva . ", $ " . floatval($movNvo[$depositKey]) . " movAnt:" . $refAnterior . ", $ " . floatval($movAnt[$depositKey]) . "\r\n";
                        if (0 == ($igual = hayIgual($arrMovsAnt, $refNueva, $referenciaKey, $log_err))) {
                            $log_err .= "\r\nHay igual: $---------------movNvo:" . $refNueva
                                . "\r\n---------movAnt:" . $refAnterior . "---------\r\n";
                            $parecido++;

                            $movAnt['matcheado'] = 'SI';
                            $arrfile2EdoCta['MovsExistentes']++;
                            $sql[] = "UPDATE banco_cuenta_mov SET numero=" . stritc($refNueva) . " numero_original=" . strit($refOriginal) . " WHERE banco_cuenta_mov_id = " . strit($movAnt['banco_cuenta_mov_id']);
                        } else {
                            $igual = 1;
                            $movAnt['matcheado'] = 'SI';
                            $arrfile2EdoCta['MovsExistentes']++;

                            $sql[] = "UPDATE banco_cuenta_mov SET numero_original=" . strit($refOriginal) . " WHERE banco_cuenta_mov_id = " . strit($movAnt['banco_cuenta_mov_id']);

                            if ($refAnterior != $refNueva)
                                $sql[] = "UPDATE banco_cuenta_mov SET numero=" . stritc($refNueva) . " numero_original=" . strit($refOriginal) . " WHERE banco_cuenta_mov_id = " . strit($movAnt['banco_cuenta_mov_id']);
                        }
                        $movAnt[$referenciaKey] = $movNvo[$referenciaKey] = $refNueva;
                        break;
                    }
                }
            }
            $log_err .= "\r\n>>>>>Parecidos: \r\n" . $parecido . "<<<>>>Iguales: " . $igual . "<<<<<<\r\n";
            //Si no encontró uno parecido, entonces sí es nuevo.
            if ($parecido == 0 && $igual == 0) /** if(!$movNvoExiste) **/ {
                $log_err .= "\r\n <pre>Nuevo mov: " . print_r($movNvo, true) . "</pre>\r\n";
                //InsertaNuevo();

                $nowMoment->modify("+1 second");//Puede ser lento.
                /** Opcion1 timestamp y sumar ints 1y lo farmateo con date**/
                /** Opcion 2, usar add en vez de modify y antes del loop crear un dateinterval con
                 * todo en 0 y seg en uno*/


                $BancoCuentaMovTmp = new BancoCuentaMov;
                $BancoCuentaMovTmp->banco_cuenta_id = $bc_id;
                $BancoCuentaMovTmp->moneda_id = ia_singleread("SELECT moneda_id FROM banco_cuenta WHERE banco_cuenta_id = " . strit($bc_id));
                $BancoCuentaMovTmp->fecha = $movNvo[$fechaKey] . " " . $nowMoment->format('H:i:s');
                $BancoCuentaMovTmp->deposit = $movNvo[$depositKey];
                $BancoCuentaMovTmp->withdrawal = $movNvo[$withdrawalKey];
                $BancoCuentaMovTmp->cash = 0.00;
                $BancoCuentaMovTmp->idex100 = 0.00;
                $BancoCuentaMovTmp->numero = $movNvo[$referenciaKey];
                $BancoCuentaMovTmp->numero_original = $refOriginal;
                $BancoCuentaMovTmp->banco_id = $b_id;
                $BancoCuentaMovTmp->alta_por = $usuario;
                $BancoCuentaMovTmp->alta_db = $today . " " . $nowMoment->format('H:i:s');

                $BancoCuentaMovTmp->alta_tipo = 'auto';

                $BancoCuentaMovTmp->go = 'SI';



                //VCA CTA RONY 20-11-2020
                //if($bc_id == 39 || $bc_id == '39')
                //$BancoCuentaMovTmp->link_vale = 'ND';
                //VCA 02-12-2020 Poner depósitos en ND
                //Ahora revisamos si la cuenta bancaria está en los párametros del sistema
                $cpnd_csv = ia_singleread("SELECT banco_cuenta_poner_deposito_ND FROM iac_parametros WHERE 1");
                $cpnd_arr = explode(",", $cpnd_csv);
                $cpnd_arr = array_flip($cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";

                if (array_key_exists($bc_id, $cpnd_arr))
                    $BancoCuentaMovTmp->link_vale = 'ND';

                $BancoCuentaMovTmp->calculaCamposAutomaticos();
                //echo "<pre>$kmovNvo" . print_r($BancoCuentaMovTmp, true) . "</pre>";

                $arrBancoCuentaMov[] = $BancoCuentaMovTmp;


            }
        }
        //Revisamos los manuales.

//            echo "Nuevos en Objetos: <pre>".print_r($arrBancoCuentaMov, true)."</pre>";
////            echo "Resumen: <pre>".print_r($arrfile2EdoCta, true)."</pre>";
//            die();


        $log_err .= "\r\n\r\nNuevos en Objetos: <pre>" . print_r($arrBancoCuentaMov, true) . "</pre>";

//        echo "<pre>".print_r($sql, true)."</pre>";
//        die();


        /** Quiere decir que todos los movimientos ya existían. **/
        if (empty($arrBancoCuentaMov) || $arrfile2EdoCta['MovsExistentes'] == sizeof($arrMovsNuevos)) {
            //$sql = array();
            //VCA 27-08-2020 se comenta porque se llama actualizaIngresos despues de llamar
            //$sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($bc_id);
            //$sql[] = "CALL actualiza_banco_cuenta_saldos($bc_id)";
            //async_actualizaIngresos(); se comenta porque se llama actualizaIngresos despues de llamar
            //echo "<pre>".print_r($sql, true)."</pre>";
            //die();
            // $sql = array_merge($sql, $sql_2);
            // dd_('ya existe', $sql);

            ia_transaction($sql);
            ia_errores_a_dime();

            $arrfile2EdoCta['Status'] = 'OK';
            $arrfile2EdoCta['Error'] = "<strong>Estado de Cuenta Importado con Éxito.</strong><br/><br/><strong>Resumen:</strong><br/>
            <li>Cuenta: <strong>$ctaBancariaNombre</strong>.<br/>
            <strong>===========================================</strong>
            <br/>
            <li>Movimientos Nuevos: <strong>" . sizeof($arrBancoCuentaMov) . "</strong>.
            <li>Movimientos Existentes: <strong>$arrfile2EdoCta[MovsExistentes]</strong>.<br/>
            <li>Movimientos con Error: <strong>$arrfile2EdoCta[MovsFallidos]</strong>.<br/><br/>
            <a href='../cobranza/edocta.php?banco_cuenta_id=$bc_id' title='Abrir el Estado de Cuenta Importado.' target='_blank'>
            Abrir <strong>$ctaBancariaNombre.</strong> <img src='/img/banco.png' alt='Bancos' title='Bancos'></a>";
//            return $arrfile2EdoCta;
//            $myLock->release();
            continue;
        }

        //$bc_saldo_actual = 0.00;
        //$bc_saldo_actual = limpiaCantidad(ia_singleread("SELECT SUM(cash)+SUM(deposit)-SUM(withdrawal) AS saldo_actual FROM banco_cuenta_mov WHERE banco_cuenta_id = $bc_id"));

        //if($hayMovsAnt)
        //Error en saldo 13/11/2020
//        ia_query("CALL actualiza_banco_cuenta_saldos($bc_id)");
        $bc_saldo_actual = limpiaCantidad(ia_singleread("SELECT saldo_actual FROM banco_cuenta_saldos WHERE banco_cuenta_id = $bc_id"));
        $bc_saldo_actual = empty($bc_saldo_actual) ? 0.00 : $bc_saldo_actual;
        //else
        //$bc_saldo_actual = 0.00;

//        echo "Nuevos en Objetos: <pre>".print_r($arrBancoCuentaMov, true)."</pre>";

        //echo "<br/>Saldo Inicial: ".($bc_saldo_actual);
        //echo "<br/>Saldo en el archivo: ".gettype($saldoBCenArchivo);

        $huboSBCHoy = false;

        foreach ($arrBancoCuentaMov as $k => &$movNvo)
            if ($movNvo->go == 'SI' || !empty($movNvo->afterInsertInstructions)) {
                if ($b_id == '2' && $movNvo->link_vale == 'SBC' && date('Y-m-d', strtotime($movNvo->fecha)) == $today) {
                    $huboSBCHoy .= '<li>MOVIMIENTO <strong>SALVO BUEN COBRO</strong> EL DÍA DE <strong>HOY: $ ' . echonf($movNvo->deposit - $movNvo->withdrawal) . '</strong><br/>';
                    continue;
                }
                $bc_saldo_actual += ($movNvo->deposit - $movNvo->withdrawal);
                $movNvo->bc_empresa_id = $arrEmpresas[$bc_id]['empresa_id'];
                //echo "<br/>Monto Mov: ".($movNvo->deposit - $movNvo->withdrawal);
            }

        //echo "<br/>Saldo Calculado: ".($bc_saldo_actual);
        //echo "<br/>Saldo en el archivo: ".($saldoBCenArchivo);

        $difenSaldoFinMes = 400.00;
        $salta_verif = false;
        $salta_verif = true;

        $diasMes = date("t");
        $diaHoy = date("j");

        ///if(abs($diasMes - $diaHoy) > 2)
        if (!$salta_verif && (!isWeekend() && $diaHoy > 2 && $diaHoy < 28))
            $difenSaldoFinMes = 0;

        $bc_saldo_actual = round($bc_saldo_actual, 2);
        $saldoBCenArchivo = round($saldoBCenArchivo, 2);
        $saldoBCenArchivoAlter = round($saldoBCenArchivoAlter, 2);

        if ($auto) {
            //Ph. 25-04-2025
            //Cámara ya se la saben, empresas y referencias. Eso ya valió verga.
            //$expectedEmpresaId = es la empresa que calculé con el nombre del archivo.
            // 🔥✨ Insert the gatekeeper before ANY execution begins

            $empresa_from_file = fetchEmpresaFromBancoCuenta($bc_id);

            if(empty($empresa_from_file) || empty($empresa_from_file['empresa_id']) || empty($empresa_from_file['banco_cuenta_id']))
            {
                $arrfile2EdoCta['Status'] = 'Error';
                $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">La empresa especificada en el archivo no existe en el catálogo.</span>';
                $arrfile2EdoCta['ErrorCode'] = '2';
                $arrfile2EdoCta['Action2Do'] = 'bc_id';
                $arrfile2EdoCta['b_id'] = $b_id;
                return $arrfile2EdoCta;
            }
            $expectedEmpresaId = $empresa_from_file['empresa_id'];
//            echo "<pre>fetchEmpresaFromBancoCuenta _ $bc_id _ $expectedEmpresaId: ".print_r( $empresa_from_file/*$el_array de lo que sea*/,true)."</pre>";

            if (!checkFileDoesBelongToEnterprise($arrBancoCuentaMov, $expectedEmpresaId, false)) {
                $arrfile2EdoCta['Status'] = 'Error';
                $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">🚫 Archivo etiquetado incorrectamente. No pertenece a la empresa esperada.</span>';
                $arrfile2EdoCta['ErrorCode'] = '2';
                $arrfile2EdoCta['Action2Do'] = 'bc_id';
                $arrfile2EdoCta['b_id'] = $b_id;
                return $arrfile2EdoCta;
            }

            $arrfile2EdoCta['Error'] = '<span class="lbl_doc_usd_hover bold">🧬 Access granted. Ábrete Sésamo.</span><br/>';
            // 🧬 Gatekeeper spoke: Access granted. Ábrete Sésamo.

            if ($b_id == 2 || $b_id == '2') {
                $saldoEncontrado = true;
                if ($saldoBCenArchivo != $bc_saldo_actual && $saldoBCenArchivoAlter != $bc_saldo_actual && (abs($saldoBCenArchivo - $bc_saldo_actual) > $difenSaldoFinMes || abs($saldoBCenArchivoAlter - $bc_saldo_actual) > $difenSaldoFinMes)) {
                    $saldoEncontrado = false;

                    //echo "<pre>".print_r($arrSaldosCol, true)."</pre>";
                    if (is_array($arrSaldosCol) && !empty($arrSaldosCol)) //Recorrer array de saldos.
                        foreach ($arrSaldosCol as $k => $vMov) {
                            //echo "<li>$vMov, $bc_saldo_actual, $difenSaldoFinMes";
                            if ($vMov == $bc_saldo_actual || abs($vMov - $bc_saldo_actual) < $difenSaldoFinMes) {
                                $saldoBCenArchivoAlter = $saldoBCenArchivo = $vMov;
                                $saldoEncontrado = true;
                            }
                        }
                }

                if (!$saldoEncontrado)
                    $arrfile2EdoCta['Status'] = 'Error';
                else
                    $saldoBCenArchivo = $saldoBCenArchivo == $bc_saldo_actual ? $saldoBCenArchivo : $saldoBCenArchivoAlter;
            } elseif ($b_id == 14 || $b_id == '14') {
                $saldoBCenArchivoAlter = $saldoBCUsuario = $saldoBCenArchivo = $bc_saldo_actual;
                $arrfile2EdoCta['Status'] = 'OK';
            } else {
                if ($saldoBCenArchivo != $bc_saldo_actual && (abs($saldoBCenArchivo - $bc_saldo_actual) > $difenSaldoFinMes))
                    $arrfile2EdoCta['Status'] = 'Error';
            }

            if (false && $arrfile2EdoCta['Status'] == 'Error') {
                $arrfile2EdoCta['Error'] = "<span class='txt_color_red bold'>Saldo final no coincide.</span><br/><br/>
                <li>Cuenta: <strong>$ctaBancariaNombre</strong>.
                <li>Saldo Calculado: <strong>" . echonf($bc_saldo_actual, true) . "</strong>.
                <li>Saldo en el archivo: <strong>" . echonf($saldoBCenArchivo, true) . "</strong>.<br/><br/>
                <li>Saldo en el archivo Alter: <strong>" . echonf($saldoBCenArchivoAlter, true) . "</strong>.<br/><br/>
                <a href='../cobranza/edocta.php?banco_cuenta_id=$bc_id' title='Abrir el Estado de Cuenta Importado.' target='_blank'>
                Abrir <strong>$ctaBancariaNombre.</strong> <img src='/img/banco.png' alt='Bancos' title='Bancos'></a>.";

                if (true) {
                    $file_err .= sanitizeFileName($ctaBancariaNombre . "_kaffe_" . $bc_id) . ".txt";
                    $fh = fopen($file_err, 'w');
                    fwrite($fh, $log_err . "\r\n\r\nSQL: <pre>" . print_r($sql, true) . "</pre>");
                    fclose($fh);
                }

                /**
                 * $file_err .= sanitizeFileName($ctaBancariaNombre."_".$bc_id).".txt";
                 * $fh = fopen($file_err, 'w');
                 * fwrite($fh, $log_err);
                 * fclose($fh);
                 * **/
                //"<pre>".print_r($arrBancoCuentaMov, true)."</pre>"; //Para cuando no coincide el saldo.
//                return $arrfile2EdoCta;
//                $myLock->release();
                continue;
            }
        } else {
            if ($saldoBCenArchivo != $bc_saldo_actual || $saldoBCenArchivo != $saldoBCUsuario || $bc_saldo_actual != $saldoBCUsuario) {
                $arrfile2EdoCta['Status'] = 'Error';
                $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Saldo final no coincide.</span>';
                $arrfile2EdoCta['ErrorCode'] = '3';
                $arrfile2EdoCta['Action2Do'] = 'saldo';
//                return $arrfile2EdoCta;
//                $myLock->release();
                continue;
            }
        }

        $function = __FUNCTION__;
        //Hacemos los inserts.
        $insertInto = "INSERT INTO /** $function **/ banco_cuenta_mov (banco_cuenta_mov_id, banco_cuenta_id, fecha, es, cash, deposit, withdrawal, banco_mov_tipo_id,numero, banco_id, link_vale, idex100, factura, remarks, alta_por, alta_tipo, categoria_gasto_id, fecha1, bc_empresa_id, numero_original, moneda_id, withdrawal_autorizado, referencia_monex, fecha_hora, puede_borrar, tiempo_restante_para_borrar, alta_db, poliza_contabilidad, numero_original_tagged, banco_diccionario_dato_id, banco_diccionario_dato_remarks, asignacion, supervision,  asig_semaforo_rony, asig_semaforo_usuarios, html_asignaciones)";

        $insertador = new \iac\inc\sql\IacSQLMultipleInsert($gSqlClass, $insertInto, ' ON DUPLICATE KEY UPDATE fecha1 = VALUES(fecha1)' , 5000, true);

        // $asignacion = new AsignacionEstatus('banco_cuenta_mov');

        // dd_($arrBancoCuentaMov);

        $asignaiones_querys = [];

        $afterInsertInstructions = [];
        $sql_para_plantillas = [];
        $movimientos_plantilla = ['Retiro' => [], 'Deposito' => []];

        $fecha_mas_antigua = "";

        foreach ($arrBancoCuentaMov as $k => &$movNvo) {
            if ($movNvo->go == 'SI') {
                $log_err . "\r\n\r\n$k:<pre>" . print_r($movNvo, true) . "</pre>";
                // debo agregarsht asignacion?
                // $tmpsql = $movNvo->insertaBancoCuentaMov(false,true);
                $tmpsql = $movNvo->insertaBancoCuentaMov(false, true, true);
                if (array_key_exists(0, $tmpsql))
                    $insertador->valuesString($tmpsql[0]);

                if (array_key_exists(1, $tmpsql))
                    $sql[] = $tmpsql[1];

                if (array_key_exists('asignacion', $tmpsql)) {
                    $asignaiones_querys = array_merge($asignaiones_querys, $tmpsql['asignacion']);
                }
                // $asignacion->asignaGastoSupervision('gasto_id', $sql, $gasto);

                $fecha_mas_antigua = empty($fecha_mas_antigua) || strtotime($movNvo->fecha) < strtotime($fecha_mas_antigua) ? $movNvo->fecha : $fecha_mas_antigua;
            }

            if(!empty($movNvo->afterInsertInstructions)) {
                // Execute each function dynamically
                foreach ($movNvo->afterInsertInstructions as $instruction) {
                    $afterInsertInstructions[] = $instruction;
                }
            }
            // aplicamos queries para plantillas para gastos del banco
            if ($movNvo->es === 'Retiro' && !empty($movNvo->plantilla_id)) {
                $movimientos_plantilla[$movNvo->es][$movNvo->banco_cuenta_mov_id] = $movNvo;
                /*$queries_plantilla = app_plantilla_withdrawals_de_banco::apply_template($movNvo->plantilla_id, $movNvo->banco_cuenta_mov_id, (array)$movNvo, false);
                if ($queries_plantilla != false)
                    $sql_para_plantillas = array_merge($sql_para_plantillas, $queries_plantilla);*/
            }
        }
        
        $sql_insert = array();
        $insertador->insertNow();
        $tmpsql_ = $insertador->get_allValues();
        if (is_array($tmpsql_) && !empty($tmpsql_))
            foreach ($tmpsql_ as $iq)
                $sql_insert[] = $iq;

        $sql_insert = array_merge($sql_insert, $asignaiones_querys);

        unset($sql_insert['asignacion']);

        $sql_insert = array_merge($sql_insert, $sql_para_plantillas);
//    dd_($sql_insert);
//        echo "<pre>change_to_your_description: ".print_r($sql_insert /*$el_array de lo que sea*/,true)."</pre>";
//        die();

        //$sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($bc_id);
        //$sql[] = "CALL actualiza_banco_cuenta_saldos($bc_id)";

        global $gSqlClass;
        //El problema es un deadlock que produce el array de updates. Es muy grande. Tiene que hacer update a tantos renglones.
        //Solución temporal, hacer los insert en una trasaction y los updates en el queryArray();

        if (ia_transaction($sql_insert)) //if(!$gSqlClass->queryArray($sql_insert))
        {
            //if(false && $gDebugging)
            if ($gDebugging) {
                $file_err .= sanitizeFileName($ctaBancariaNombre . "_" . $bc_id) . ".txt";
                $fh = fopen($file_err, 'w');
                fwrite($fh, $log_err . "\r\n\r\nSQL: <pre>" . print_r($sql, true) . "</pre>\r\n\r\nsql insert <pre>" . print_r($sql_insert, true) . "</pre>");
                fclose($fh);
            }
            //ia_transaction($sql);
            $arrfile2EdoCta['Status'] = 'Error';
            $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Error al insertar los Movimientos Nuevos.</span>';
            $arrfile2EdoCta['ErrorCode'] = '3';
            $arrfile2EdoCta['Action2Do'] = 'saldo';
//            return $arrfile2EdoCta;
            ia_errores_a_dime();
            continue;
        }
        //if(ia_transaction($sql))
        if (!$gSqlClass->queryArray($sql)) {
            //ia_transaction($sql);
            $arrfile2EdoCta['Status'] = 'Error';
            $arrfile2EdoCta['Error'] = '<span class="txt_color_red bold">Error al actualizar los Movimientos Existentes.</span>';
            $arrfile2EdoCta['ErrorCode'] = '3';
            $arrfile2EdoCta['Action2Do'] = 'saldo';
//            return $arrfile2EdoCta;
            ia_errores_a_dime();
            continue;
        }

        unset($instruction);
        if(!empty($afterInsertInstructions)) {
            // Execute each function dynamically
            foreach ($afterInsertInstructions as $instruction) {
                $ai_sql_ = globalLinkpropioHelperGeneraRemarks(banco_cuenta_trans_id: $instruction);
                if(ia_transaction($ai_sql_)) {
                    file_debug_reporte();
                    ia_errores_a_dime();
                }
            }
        }

        /** Actualiza depositos por cuenta: los únicos que cambian son deposit_today, deposit_this_month y deposit_this_year */

        /** Ahora sí aplicamos las plantillas */
        $sql_plantillas = [];
        foreach ($movimientos_plantilla['Retiro'] as $banco_cuenta_mov_id => $movimiento_nuevo){
            if(!empty($movimiento_nuevo->plantilla_id)) {
                $updates_plantillas = app_plantilla_withdrawals_de_banco::apply_template($movimiento_nuevo->plantilla_id, $movimiento_nuevo->banco_cuenta_mov_id, (array)$movimiento_nuevo, true, "", true);
                // if ($updates_plantillas != false)
                //     $sql_plantillas = array_merge($sql_plantillas, $updates_plantillas);
            }
        }

        $banco_cuenta_mov_bingo = findReliableBankTransanctionforBalance(banco_cuenta_id: $bc_id, fecha_referencia: $fecha_mas_antigua);
//        updateBalanceonBankAccount(banco_cuenta_mov_reference: $banco_cuenta_mov_bingo, debug: $debug = false);

        $arrfile2EdoCta['MovsInsertados'] += sizeof($arrBancoCuentaMov);
        $arrfile2EdoCta['MovsFallidos'] += $insertador->get_insertsErrorsNum();

        $arrfile2EdoCta['Status'] = 'OK';

        //$ctaBancariaSaldo = limpiaCantidad(ia_singleread("SELECT saldo_actual FROM banco_cuenta_saldos WHERE banco_cuenta_id = $bc_id"));

        //$ctaBancariaNombre = ia_htmlentities(ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id = '$bc_id'"));

        $lineaSaldos = "<li>Saldo final: <strong>".echonf($bc_saldo_actual, true)."</strong>.<br/>";
        if($auto)
            $lineaSaldos.="<li>Saldo en el archivo: <strong>".echonf($saldoBCenArchivo, true)."</strong>.<br/><br/>";
        else
            $lineaSaldos.="<li>Saldo usuario: <strong>".echonf($saldoBCUsuario, true)."</strong>.<br/>";

        $arrfile2EdoCta['Error'] .= "<strong>Estado de Cuenta Importado con Éxito.</strong><br/><br/><strong>Resumen:</strong><br/>
            <li>Cuenta: <strong>$ctaBancariaNombre</strong>.
            $lineaSaldos
            $huboSBCHoy
            <strong>===========================================</strong>
            <br/>
            <li>Movimientos Nuevos: <strong>$arrfile2EdoCta[MovsInsertados]</strong>.
            <li>Movimientos Existentes: <strong>$arrfile2EdoCta[MovsExistentes]</strong>.<br/>
            <li>Movimientos con Error: <strong>$arrfile2EdoCta[MovsFallidos]</strong>.<br/><br/>
            <a href='../cobranza/edocta.php?banco_cuenta_id=$bc_id' title='Abrir el Estado de Cuenta Importado.' target='_blank'>
            Abrir <strong>$ctaBancariaNombre.</strong> <img src='/img/banco.png' alt='Bancos' title='Bancos'></a><br/>";

    }
    //if(false && $gDebugging)
    if($gDebugging)
    {
        $file_err .= sanitizeFileName($ctaBancariaNombre."_".$bc_id).".txt";
        $fh = fopen($file_err, 'w');
        fwrite($fh, $log_err."\r\n\r\nSQL: <pre>".print_r($sql, true) . "</pre>\r\n\r\nsql insert <pre>".print_r($sql_insert, true) . "</pre>");
        fclose($fh);
    }

    if($b_id == 14)
        @async_ws_actualizaLinksAlBancoLive();

    @async_ws_update_plantillas_withdrawals();
    @async_ws_update_plantillas_cuenta_t_gasto();
    
    return $arrfile2EdoCta;
}

function csv2Array($archivo='', $delimiter='', $maxRows=false, $minCols=1, $conEncabezado=true, $trimResult=true): bool|array
{
    if(empty($archivo))
        return false;

    $arrFinal = array();

    clearstatcache();

    if(!file_exists($archivo)) {
        return false;

    }
    if (empty($delimiter))
        $delimiter = "\t";

    $fp = fopen($archivo, 'r');
    //REVISAR FP.
    if(!$fp)
        return false;

    flock($fp, LOCK_EX);

    if($maxRows === false)
        $maxRows = 100000000000000000000000000000000000000000;
    $i=0;

    while(!feof($fp) && $i<=$maxRows)
    {
        $line = fgets($fp);
        if($line === false) break;
        $line = mb_detect_encoding($line, 'UTF-8', true) ? $line : mb_convert_encoding($line, 'UTF-8', 'ISO-8859-1');
        $line = strip_tags($line);

        //echo $line;

        if($line=="\r\n" || strlen($line)<2)
            continue;

        $data = str_getcsv($line, $delimiter, '"', "\\");

        //echo "<pre>".print_r($data,true)."</pre>";
        if($i++==0 && !$conEncabezado)
            continue;

        if(sizeof($data) < $minCols-2)
            continue;

        //if($trimResult)
        if(is_array($data) && !empty($data))
            foreach($data as $k=>$col)
                $data[$k] = sanitizeString(vx_trim($col));
        $arrFinal[] = $data;
        $i++;
    }
    flock($fp, LOCK_UN);
    fclose($fp);

    //echo "<pre>".print_r($arrFinal,true)."</pre>";

    return $arrFinal;
}

function xlsx2Array($archivo='', $delimiter='', $maxRows=false, $minCols=1, $conEncabezado=true, $trimResult=true)
{
    if(empty($archivo))
        return false;

    $arrFinal = array();
    clearstatcache();
    if(!file_exists($archivo))
        return false;

    $i = 0; $rowDesc=0;
    $sizeData = 0;
    $newRow = array();

    if($xlsx = SimpleXLSX::parse($archivo))
    {
        foreach( $xlsx->rows() as $data )
        {
            $newRow = array();
            if($i++==0 && !$conEncabezado)
                continue;

            $sizeData = 0;
            //if($trimResult)
            if(is_array($data) && !empty($data)) {
                $rowDesc=0;
                foreach ($data as $k => $col) {
                    $col = sanitizeString(vx_trim($col));
                    if ($col == 'FECHA' || $col == 'DESCRIPCION' || $col == 'DESCRIPCIÓN' || $col == 'CARGO' || $col == 'ABONO' || $col == 'SALDO')
                        $rowDesc++;
                    if (strlen($col))
                        $sizeData++;
                    if (is_numeric($col) && ($k == 2 || $k == 3)) //Aquí viene el monto de la operación. Columna 3 ABONO, 2 CARGO
                        $col = abs(floatval($col));
                    $newRow[$k] = $col;

                }
                //echo "<pre>MOV PRE $k".print_r($newRow, true)."</pre>";
            }

            //VCA CTA RONY 20-11-2020
            //En el XLSX de RONY viene (0=>'FECHA',0=>'DESCRIPCIÓN,0=>'CARGO,0=>'ABONO,0=>'SALDO
            if($rowDesc >= $minCols)
            {
                $newRow[3] = "ABONO";
                $newRow[2] = "CARGO";
            }



            if($sizeData < $minCols)
                if($i==1 && $conEncabezado);
                else continue;

            $arrFinal[] = $newRow;
            $i++;
        }

    }
    else
    {
        ia_errores_a_dime(SimpleXLSX::parseError());
    }
    //echo "<pre>arrFinal:".print_r($arrFinal,true)."</pre>";
    return $arrFinal;
}

function encuentraHeaderEdoCta(&$arrBCColModel=array(), &$arrBCColsNum=array(), &$arrMovsNuevos=array(), &$arrMovsHeader=array())
{
    $method = __METHOD__;
    $inicioEncontrado = false;

    if(empty($arrBCColModel) || empty($arrBCColsNum) || empty($arrMovsNuevos))
        return $inicioEncontrado;

    /** Deducimos las columnas del array con el estado de cuenta del banco. **/
    /** Vamos a encontar el principio de los movimientos.**/
    /** ******************************************* **/

    foreach($arrMovsNuevos as $kMov => &$vMov)
    {
        if(is_array($vMov) && !empty($vMov)) {
//            echo "\r\n<br/><pre>".print_r($vMov, true)."</pre>";
            if(sizeof($vMov) < $arrBCColsNum['required'])
                continue;
            foreach ($vMov as $kCol => $vCol) {
//                echo "\r\n<br/>Mov $kMov, Col $vCol: <pre>".print_r($vMov, true)."</pre>";

                foreach ($arrBCColModel as $colName => $colDesc)
                    if (!$colDesc['index']['found'] || $colDesc['index']['array']) //Todavía no encontramos a esta columna o es un array y debemos buscarla muchas veces.
                    {
                        if (in_array($vCol, $colDesc['nombre']['match'], true)) {

//                            echo "\r\n<br/>$vCol: <pre>".print_r($colDesc['nombre']['match'], true)."</pre>";

                            $arrBCColModel[$colName]['index']['found'] = true;

                            if ($colDesc['index']['array']) { //Sí es un array, entonces buscamos más de un match.
                                if (!is_array($arrBCColModel[$colName]['index']['originKey']))
                                    $arrBCColModel[$colName]['index']['originKey'] = array();
                                $arrBCColModel[$colName]['index']['originKey'][] = $kCol;
                            } else //NO es un array, entonces buscamos sólo un match.
                                $arrBCColModel[$colName]['index']['originKey'] = $kCol;

                            $arrBCColsNum['found']++;
                            break;
                        }
                    }
            }
        }
        unset($arrMovsNuevos[$kMov]);
        if(!is_array($arrMovsHeader))
            $arrMovsHeader = array();
        $arrMovsHeader[] = $vMov;

        if($arrBCColsNum['found'] >= $arrBCColsNum['required'])
        {
            $inicioEncontrado = $kMov;
            $inicioEncontrado++;
            break;
        }
    }

    /**
    echo "Col Model: <pre>".print_r($arrBCColModel, true)."</pre>";
    echo "Col Num: <pre>".print_r($arrBCColsNum, true)."</pre>";

    die();
    **/

    return $inicioEncontrado;
}

function estandarizaColsEdoCta(&$arrMovsNuevos=array(), &$arrBCColModel=array(), &$saldoBCenArchivo=0.00, &$arrBancoModel=array(), &$arrMovsHeader=array(), &$saldoBCenArchivoAlter=0.00, &$arrSaldosCol=array())
{
    if(empty($arrMovsNuevos) || empty($arrBCColModel) || empty($arrBancoModel))
        return false;

    /** Vamos a sanear el array con los movimientos **/
    /** ******************************************* **/

    /** Primero revisamos que sea necesario hacer esta operación **/
    /**
    $doEstandariza = false;

    foreach($arrBCColModel as $colName => $colDesc)
    if($colDesc['index']['originKey'] != $colDesc['index']['finalKey'])
    $doEstandariza = true;

    if(!$doEstandariza)
    return true;
     **/

    $banco_id = $arrBancoModel['b_id'] ?? 0;
    $arrMovsNuevosTmp = array();

    $cmBIfK = $arrBCColModel['balance']['index']['finalKey'];
//    echo "Nuevos sin Header $bc_id: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//    echo "Headers arrBancoModel: <pre>".print_r($arrBancoModel, true)."</pre>";

    foreach($arrMovsNuevos as $k => &$v)
    {
        if(sizeof($v) < $arrBancoModel['minCols']-1) continue;

        $nvoMov = array();
        foreach($arrBCColModel as $colName => $colDesc)
        {
            $val = '';
            //VCA aqui se calcula la referencia
            if($colDesc['index']['array'] && is_array($colDesc['index']['originKey']))
            {
                if(is_array($colDesc['index']['originKey']) && !empty($colDesc['index']['originKey']))
                    foreach($colDesc['index']['originKey'] as $originKey)
                        $val .= (esPurosCeros($v[$originKey]) ? '' : $v[$originKey].' ');

//                if(strlen($val))
//                    $val = substr_replace($val ,"",-1);
            }
            else
            {
                $val = $v[$colDesc['index']['originKey']] ?? '';
            }

            switch($colName)
            {
                case 'fecha':
                    if(strlen($val)<6)
                        $val = date('Y')."/".$val;
                    $val = date('Y-m-d', strtotime(str_replace('/', '-', $val)));
                    break;

                case 'deposit':
                    $val = empty($val) || $val == '-' ? 0.00 : limpiaCantidad($val, false);
                    break;

                case 'withdrawal':
                    $val = empty($val) || $val == '-' ? 0.00 : limpiaCantidad($val, false);
                    break;

                case 'balance':
                    $val = empty($val) || $val == '-' ? 0.00 : limpiaCantidad($val);
                    break;

                case 'referencia_monex':
                    if($banco_id != MONEX_BANCO_ID) {
                        $val = '';
                        continue 2;
                    }else
                        $val = empty($val) ? "" : vx_trim($val);
                    break;
            }

            $nvoMov[$colDesc['index']['finalKey']] = $val;
        }
        if(empty($nvoMov[$arrBCColModel['deposit']['index']['finalKey']]) && empty($nvoMov[$arrBCColModel['withdrawal']['index']['finalKey']])) continue;
        $arrMovsNuevosTmp[] = $nvoMov;
    }

    /** ******************************************* **/
//    echo "Nuevos Original Tmp: <pre>".print_r($arrMovsNuevosTmp, true)."</pre>";
//    die();

    $arrMovsNuevos = null;
    $arrMovsNuevos = $arrMovsNuevosTmp;

    switch($arrBancoModel['b_id'])
    {
        case '1':
            $saldoBCenArchivo = $arrMovsNuevos[0][$cmBIfK] ?? 0.00;
            $arrMovsNuevos = array_reverse($arrMovsNuevos);
            break;

        case '2':
            //echo "<pre>".print_r($arrMovsHeader, true)."</pre>";
            $arrMovsNuevos = array_reverse($arrMovsNuevos);
            $saldoBCenArchivo = false;

            if(is_array($arrMovsHeader) && !empty($arrMovsHeader))
                foreach($arrMovsHeader as $k => $vMovHeader)
                {
                    if(is_array($vMovHeader) && !empty($vMovHeader))
                        foreach($vMovHeader as $kmh => $vMHCol)
                            if(in_array($vMHCol, $arrBancoModel['saldoFinal']))
                                if(array_key_exists($kmh+1, $vMovHeader))
                                {
                                    //echo "Header: <pre>".print_r($vMovHeader, true)."</pre>";
                                    $saldoBCenArchivo = limpiaCantidad($vMovHeader[$kmh+1]);
                                    break 2;
                                }
                }

            if($saldoBCenArchivo === false) //Tal vez sea un archivo con movimientos del día.
            {
                //echo "Calculo en Hoy 1: <pre>".print_r($arrMovsNuevos, true)."</pre>";
                //$arrMovsNuevos = array_reverse($arrMovsNuevos);
                //echo "Calculo en Hoy 2: <pre>".print_r($arrMovsNuevos, true)."</pre>";

                reset($arrMovsNuevos);
                $iK = key($arrMovsNuevos);
                end($arrMovsNuevos);
                $fK = key($arrMovsNuevos);
                reset($arrMovsNuevos);


                $saldoBCenArchivo = $arrMovsNuevos[$iK][$cmBIfK];
                $saldoBCenArchivoAlter = $arrMovsNuevos[$fK][$cmBIfK];

                //Este hack es por si el saldo final viene en otro lugar que no sea el principio, ni el final.

                if(is_array($arrMovsNuevos) && !empty($arrMovsNuevos))
                    foreach($arrMovsNuevos as $k => $vMov)
                        if(array_key_exists($cmBIfK, $vMov))
                            $arrSaldosCol[]=round($vMov[$cmBIfK], 2);

                //$arrMovsNuevos = array_reverse($arrMovsNuevos);
                //echo "$iK: $saldoBCenArchivo\r\n$fK: $saldoBCenArchivoAlter\r\n";
            }

            break;

        case '3':
            $arrMovsNuevos = array_reverse($arrMovsNuevos);
            $saldoBCenArchivo = array_key_exists(0, $arrMovsNuevos) && array_key_exists($cmBIfK,$arrMovsNuevos[0]) ? $arrMovsNuevos[0][$cmBIfK] : 0.00;
            break;

        case '5':
            if($arrBancoModel['rA'])
            {
                $saldoBCenArchivo = array_key_exists(0, $arrMovsNuevos) && array_key_exists($cmBIfK,$arrMovsNuevos[0]) ? $arrMovsNuevos[0][$cmBIfK] : 0.00;
                $arrMovsNuevos = array_reverse($arrMovsNuevos);
            }
            else
            {
                reset($arrMovsNuevos);
                end($arrMovsNuevos);
                $fE = key($arrMovsNuevos);

                $saldoBCenArchivo = $arrMovsNuevos[$fE][$cmBIfK];
                //$arrMovsNuevos = array_reverse($arrMovsNuevos);
            }

            break;

        case '14':
            $saldoBCenArchivo = $saldoBCenArchivoAlter = 0.01;
//            $arrMovsNuevos = array_reverse($arrMovsNuevos);
            break;

        default:
            $saldoBCenArchivo = array_key_exists(0, $arrMovsNuevos) && array_key_exists($cmBIfK,$arrMovsNuevos[0]) ? $arrMovsNuevos[0][$cmBIfK] : 0.00;
//            $arrMovsNuevos = array_reverse($arrMovsNuevos);
            break;


    }
//echo "Nuevos Original: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//              die();
    return true;
}

function identificaBancoEdoCta($archivoyPath='', &$arrBancoModel=array(), &$b_id=0, &$bIndex=0)
{
    //Hack para bancomer y sus errores 13-10-2016
    $fpp = pathinfo($archivoyPath);
    $ext=array_key_exists('extension',$fpp) ? strtolower($fpp['extension']):'';

    if($ext=='exp' || $ext=='xlsx')
    {
        //VCA 12-03-2021 HSBC cambió su formato
        if(stripos($fpp['filename'],'hsbc') !== false){
            $b_id=5;
//            $bIndex = 3;
            return true;
        }
        $b_id=1;
        return true;
    }

    foreach($arrBancoModel as $k => $vb_desc)
    {
        $arrPrimeraFila = csv2Array($archivoyPath, $vb_desc['delimiter'], 0);
        if(is_array($arrPrimeraFila) && sizeof($arrPrimeraFila))
        {
            if(sizeof($arrPrimeraFila[0]) == $vb_desc['minCols'])
                $b_id = $vb_desc['b_id'];

            if(empty($b_id))
                if(is_array($vb_desc['primeraLinea']) && array_key_exists(0, $arrPrimeraFila[0]) && in_array($arrPrimeraFila[0][0], $vb_desc['primeraLinea']))
                    $b_id = $vb_desc['b_id'];

            if(!empty($b_id))
            {
                $bIndex = $b_id;
                //echo "Primera Fila: <pre>".print_r($arrPrimeraFila, true)."</pre>";
                //echo "El Banco: <pre>".print_r($vb_desc, true)."</pre>";
                return true;
            }
        }
    }
    //echo "Primera Fila: <pre>".print_r($arrPrimeraFila, true)."</pre>";
    //echo "El Banco: <pre>".print_r($vb_desc, true)."</pre>";
    return true;
}

function identificaCuentaEdoCta(&$arrMovsNuevos=array(), $arrMovsHeader=array(), &$arrBancoModel=array(), $archivo='', &$arrBCColModel=array())
{
    $bc_id = false;

    if(empty($arrMovsNuevos) || empty($arrMovsHeader) || empty($arrBancoModel))
        return $bc_id;

    $noCta = '';

    switch($arrBancoModel['b_id'])
    {
        case '1': case '10': //Bancomer
            /** Este especificamente ya bailó porque no trae nada de info. Hay que identificarlo con sus movimientos **/
            if(strlen($archivo))
            {
                $archivo = strtoupper($archivo);
                //echo "Archivo: $archivo\r\n\r\n";
                if(is_array($arrBancoModel['fileName']) && !empty($arrBancoModel['fileName']))
                    foreach($arrBancoModel['fileName'] as $kpC => $posibleCuenta)
                    {
                        //echo "posibleCuenta: <pre>".print_r($posibleCuenta, true)."</pre>";
                        if(is_array($posibleCuenta['nombre']) && !empty($posibleCuenta['nombre']))
                            foreach($posibleCuenta['nombre'] as $kpN => $posibleNombre)
                            {
                                //echo "\r\nposibleNombre: $posibleNombre vs. $archivo";
                                $posNombre = strpos($archivo, $posibleNombre);
                                if($posNombre !== false)
                                {
                                    $bc_id = $posibleCuenta['bc_id'];
                                    //echo "\r\nposibleNombre $bc_id: $posibleNombre vs. $archivo";
                                    break 2;
                                }
                            }
                    }

                //TODO Agregar que use el primer renglón, ahí viene el número de cuenta.
                if(empty($bc_id)) //Si áun no encontramos el id de la cuenta. Ora hay que buscar en los movimientos.
                {
                    //Buscar en los movs.
                    $arrMovsAntxCta = false;
                    $arrMovsNuevosBBVA = $arrMovsNuevos;
                    $arrBCColModelBBVA = $arrBCColModel;
                    $saldoNuevo = 0.00;
                    if(!estandarizaColsEdoCta($arrMovsNuevosBBVA, $arrBCColModel, $saldoNuevo, $arrBancoModel))
                        break;

                    $fechaKey = $arrBCColModel['fecha']['index']['finalKey'];
                    $withdrawalKey = $arrBCColModel['withdrawal']['index']['finalKey'];
                    $depositKey = $arrBCColModel['deposit']['index']['finalKey'];
                    $balanceKey = $arrBCColModel['balance']['index']['finalKey'];

                    $sql = "SELECT banco_cuenta_id as bc_id FROM banco_cuenta WHERE banco_id = '$arrBancoModel[b_id]'";
                    $arrCuentasBBVA = ia_sqlArrayIndx($sql);

                    if(empty($arrCuentasBBVA))
                        break;

                    //echo "Cuentas BBVA: <pre>".print_r($arrCuentasBBVA, true)."</pre>";

                    reset($arrMovsNuevosBBVA);
                    $fE = key($arrMovsNuevosBBVA);
                    //echo "Primer Mov: <pre>".print_r($arrMovsNuevos[$fE], true)."</pre>";
                    if(array_key_exists($fE,$arrMovsNuevosBBVA) && array_key_exists($arrBCColModel['fecha']['index']['finalKey'],$arrMovsNuevosBBVA[$fE]))
                        $mes = $arrMovsNuevosBBVA[$fE][$arrBCColModel['fecha']['index']['finalKey']];

                    if(empty($mes))
                        break;


                    $sqlMovsAnt = "SELECT DATE(fecha) as '0', numero as '1', withdrawal as '2', (cash + deposit) as '3', '' as '4',
                        banco_cuenta_mov_id as bcm_id, banco_cuenta_id as bc_id, fecha as fechaOri FROM banco_cuenta_mov
                        WHERE banco_id = '$arrBancoModel[b_id]' AND fecha >= '$mes' ORDER BY fechaOri DESC, bcm_id DESC";
                    $arrMovsAnt = ia_sqlArrayIndx($sqlMovsAnt);

                    if(!is_array($arrMovsAnt) || empty($arrMovsAnt))
                        break;

                    //echo "Mov Anteriores Tochos: <pre>".print_r($arrMovsAnt, true)."</pre>";
                    foreach($arrCuentasBBVA as $kbc => $vbc)
                    {
                        //echo "\r\nBuscando en la Cuenta: $vbc[bc_id].";
                        $vbc_id = $vbc['bc_id'];
                        $arrMovsAntxCta = false;

                        $movMatch = false;
                        $arrMovsAntxCta = filtraArray($arrMovsAnt, 'bc_id', $vbc_id);

                        if(empty($arrMovsAntxCta))
                            continue;

                        //echo "Mov Anteriores x Cta: <pre>".print_r($arrMovsAntxCta, true)."</pre>";
                        foreach($arrMovsNuevosBBVA as $kmv => $movNvo)
                        {
                            foreach($arrMovsAntxCta as $kma => $movAnt)
                            {
                                if(($movAnt[$fechaKey] == $movNvo[$fechaKey]) /*fecha*/
                                    && ($movAnt[$withdrawalKey] == $movNvo[$withdrawalKey]) /*cargo*/
                                    && ($movAnt[$depositKey] == $movNvo[$depositKey]) /*abono*/ )
                                {
                                    $movMatch = array('anterior' => $kma, 'nuevo' => $kmv);
                                }
                            }
                        }

                        if($movMatch)
                        {
                            //echo "Match: <pre>".print_r($movMatch, true)."</pre>";
                            $saldoDB = CalculaBancoCuentaSaldodesdeunMovimiento($vbc_id, $arrMovsAntxCta[$movMatch['anterior']]['bcm_id']);
                            $saldoNuevo = $arrMovsNuevosBBVA[$movMatch['nuevo']][$balanceKey];

                            //echo "\r\nsaldoDB: $saldoDB saldoNuevo: $saldoNuevo";
                            if($saldoDB == $saldoNuevo)
                            {
                                $bc_id = $vbc_id;
                                break;
                            }
                            else
                                continue;
                        }
                        else
                        {
                            $ultimoMovAnt = array_pop($arrMovsAntxCta);

                            reset($arrMovsNuevosBBVA);
                            $fE = key($arrMovsNuevosBBVA);
                            $primerMovNvo = $arrMovsNuevosBBVA[$fE];

                            //echo "Ultimo Mov Anterior: <pre>".print_r($ultimoMovAnt, true)."</pre>";
                            //echo "Primero Nuevo: <pre>".print_r($primerMovNvo, true)."</pre>";

                            $saldoNuevo = $primerMovNvo[$withdrawalKey] + $primerMovNvo[$depositKey] + $ultimoMovAnt[$withdrawalKey] + $ultimoMovAnt[$depositKey];
                            if($primerMovNvo[$balanceKey] == $saldoNuevo)
                            {
                                $bc_id = $vbc_id;
                                break;
                            }
                            else
                                continue;
                        }
                    }
                }

            }
            break;

        case '2': //Banamex
            /** Este trae el numero de cuenta en el header. **/

            if(is_array($arrMovsHeader) && !empty($arrMovsHeader))
                foreach($arrMovsHeader as $k => $vMovHeader)
                {
                    if(is_array($vMovHeader) && !empty($vMovHeader))
                        foreach($vMovHeader as $kmh => $vMHCol)
                            if(in_array($vMHCol, $arrBancoModel['numeroCuenta']))
                                if(array_key_exists($kmh+1, $vMovHeader))
                                {
                                    //echo "Header: <pre>".print_r($vMovHeader, true)."</pre>";
                                    $noCta = $vMovHeader[$kmh+1];
                                    break 2;
                                }
                }

            if(strlen($noCta))
            {
                $sql = "SELECT banco_cuenta_id FROM banco_cuenta WHERE numero = '$noCta'";
                //echo "<br>$sql";
                $bc_id = ia_singleread($sql);
            }
            break;

        case '3': //Banorte
            /** Este trae el numero de cuenta en la primera columna de los movimientos **/
            //Hya veces que Banorte pone saltos de línea.

            if(is_array($arrMovsHeader) && !empty($arrMovsHeader))
                foreach($arrMovsHeader as $k => $vMovHeader)
                {
                    if(is_array($vMovHeader) && !empty($vMovHeader))
                        foreach($vMovHeader as $kmh => $vMHCol)
                            if(in_array($vMHCol, $arrBancoModel['numeroCuenta']))
                            {
                                //echo "Header: <pre>".print_r($vMovHeader, true)."</pre>";
                                //echo "\r\nk: $kmh";
                                reset($arrMovsNuevos);
                                $fE = key($arrMovsNuevos);
                                //echo "Primer Mov: <pre>".print_r($arrMovsNuevos[$fE], true)."</pre>";
                                if(array_key_exists($fE,$arrMovsNuevos) && array_key_exists($kmh,$arrMovsNuevos[$fE]))
                                {
                                    $noCta = $arrMovsNuevos[$fE][$kmh];
                                    break 2;
                                }
                            }
                }

            if(strlen($noCta))
            {
                $sql = "SELECT banco_cuenta_id FROM banco_cuenta WHERE numero = '$noCta'";
                //echo "<br>$sql";
                $bc_id = ia_singleread($sql);
            }
            break;

        case '5': //HSBC
            /** Este trae el numero de cuenta en el header o en la segunda columna de los movimientos. **/

            if(is_array($arrMovsHeader) && !empty($arrMovsHeader))
                foreach($arrMovsHeader as $k => $vMovHeader)
                {
                    if(is_array($vMovHeader) && !empty($vMovHeader))
                        foreach($vMovHeader as $kmh => $vMHCol)
                            if(in_array($vMHCol, $arrBancoModel['primeraLinea']))
                                if(array_key_exists($kmh+1, $vMovHeader))
                                {
                                    //echo "Header: <pre>".print_r($vMovHeader, true)."</pre>";
                                    $noCta = $vMovHeader[$kmh+1];
                                    break 2;
                                }
                }

            if(strlen($noCta))
            {
                $sql = "SELECT banco_cuenta_id FROM banco_cuenta WHERE numero = '$noCta'";
                //echo "<br>$sql";
                $bc_id = ia_singleread($sql);
            }
            else
            {
                /** Vamos a buscarlo en los movimientos **/

                if(is_array($arrMovsHeader) && !empty($arrMovsHeader))
                    foreach($arrMovsHeader as $k => $vMovHeader)
                    {
                        if(is_array($vMovHeader) && !empty($vMovHeader))
                            foreach($vMovHeader as $kmh => $vMHCol)
                                if(in_array($vMHCol, $arrBancoModel['numeroCuenta']))
                                {
                                    //echo "Header: <pre>".print_r($vMovHeader, true)."</pre>";
                                    //echo "\r\nk: $kmh";
                                    reset($arrMovsNuevos);
                                    $fE = key($arrMovsNuevos);
                                    //echo "Primer Mov: <pre>".print_r($arrMovsNuevos[$fE], true)."</pre>";
                                    if(array_key_exists($fE,$arrMovsNuevos) && array_key_exists($kmh,$arrMovsNuevos[$fE]))
                                    {
                                        $noCta = $arrMovsNuevos[$fE][$kmh];
                                        break 2;
                                    }
                                }
                    }
                if(strlen($noCta))
                {
                    $sql = "SELECT banco_cuenta_id FROM banco_cuenta WHERE numero = '$noCta'";
                    //echo "<br>$sql";
                    $bc_id = ia_singleread($sql);
                    $arrBancoModel['rA'] = true;
                }
            }
            break;

            //VCA: 14-Octubre-2023 NUEVO BANCO MONEX
        case '14': //MONEX
            /** Este especificamente ya bailó porque no trae nada de info. Hay que identificarlo con sus movimientos **/
            if(strlen($archivo))
            {
                $archivo = strtoupper($archivo);
//                echo "Archivo: $archivo\r\n\r\n";
                if(is_array($arrBancoModel['fileName']) && !empty($arrBancoModel['fileName']))
                    foreach($arrBancoModel['fileName'] as $kpC => $posibleCuenta)
                    {
                        //echo "posibleCuenta: <pre>".print_r($posibleCuenta, true)."</pre>";
                        if(is_array($posibleCuenta['nombre']) && !empty($posibleCuenta['nombre']))
                            foreach($posibleCuenta['nombre'] as $kpN => $posibleNombre)
                            {
                                //echo "\r\nposibleNombre: $posibleNombre vs. $archivo";
                                $posNombre = strpos($archivo, $posibleNombre);
                                if($posNombre !== false)
                                {
                                    $bc_id = $posibleCuenta['bc_id'];
                                    //echo "\r\nposibleNombre $bc_id: $posibleNombre vs. $archivo";
                                    break 2;
                                }
                            }
                    }

                //VCA: 14-Octubre-2024 Preparamos el array para que separe abono de cargo
                //VCA: 14-Octubre-2024 Preparamos el array para que separe moneda MXP y USD.

                if(!empty($bc_id)) //Si áun no encontramos el id de la cuenta. Ora hay que buscar en los movimientos.
                {
                    $arrBCColModel['deposit']['index']['found'] = true;
                    $fechaKey = $arrBCColModel['fecha']['index']['originKey'];
                    $depositKey = $arrBCColModel['deposit']['index']['originKey'] = $arrBCColModel['withdrawal']['index']['originKey'];
                    $balanceKey = $arrBCColModel['balance']['index']['originKey'];
                    $withdrawalKey = $arrBCColModel['withdrawal']['index']['originKey'] = 11;

                    $monedaKey = 0;
                    $arr_USD = [];
                    $hubo_usd = false;

                    foreach($arrMovsNuevos as $index => &$nuevo){


//                        echo "nuevo: <pre>".print_r($nuevo, true)."</pre>";
                        //echo "arrMovsHeader: <pre>".print_r($arrMovsHeader, true)."</pre>";
                        //die();
                        if(array_key_exists($depositKey, $nuevo)){
                            $monto = limpiaCantidad($nuevo[$depositKey]);
                            if($monto < 0) {
                                $nuevo[$withdrawalKey] = abs(limpiaCantidad($nuevo[$depositKey]));
                                $nuevo[$depositKey] = 0.00;
                            }
                            else{
                                $nuevo[$withdrawalKey] = 0.00;
                                $nuevo[$depositKey] = $monto;
                            }
                        }

                        if($nuevo[$monedaKey] == 'USD'){
                            $arr_USD[] = $nuevo;
                            $hubo_usd = true;
                            unset($arrMovsNuevos[$index]);
                        }
                    }

                    if($hubo_usd){
                        $arrMovsNuevos['USD'] = $arr_USD;
                    }
                }

            }
            break;
    }
//    echo "nuevos: <pre>".print_r($arrMovsNuevos, true)."</pre>";
//    die();
    return $bc_id;
}

function importaEdoCtadesdeDirectorio(&$forceCuenta=false)
{
    global $gIAParametros;
    $path4EdoCta = $gIAParametros['path_archivos_estado_de_cuenta'];

    $arrfile2EdoCta_IECD = array();

    $arrCtas2Do = $forceCuenta;

    //echo "<br/>$path4EdoCta";

    $directoryHandle = @opendir($path4EdoCta);
    //1) meter en un array el contenido del directorio para liberarlo.
    //2) cuando recorro array revisar con file_Exists y si no, continue.
    //3) clearstatcache();
    $arrDirectory = array();


    clearstatcache();
    while($contents = @readdir($directoryHandle))
    {
        $arrDirectory[] = $contents;
    }
    @closedir($directoryHandle);
    clearstatcache();


    foreach($arrDirectory as $contents)
    {
        if($contents != '.' && $contents != '..')
        {
            $path = $path4EdoCta . "\\" . $contents;

            //echo "<br/>$contents";
            clearstatcache();
            if(!file_exists($path))
                continue;

            if(!is_dir($path))
            {
                $contents_parts = @pathinfo($contents);
                $contentsExt = array_key_exists('extension',$contents_parts) ? strtolower($contents_parts['extension']):'';

                $contents_parts['extension'] = $contentsExt;
                //echo "Nombre Archivo: <pre>".print_r($contents_parts, true)."</pre>";

                $contents_parts['basename'] = strtoupper($contents_parts['basename'] ?? "");

                if(str_contains($contents_parts['basename'], 'RECHAZADO'))
                    continue;

                //VCA CTA RONY 20-11-2020
                //El archivo de rony viene en XLS.
                //VCA 13-Octubre-2023 monex
                if( $contentsExt == 'exp' || $contentsExt == 'txt' || $contentsExt == 'csv' || $contentsExt == 'html' ||
                    $contentsExt == 'htm' || $contentsExt == 'xls' || $contentsExt == 'xlsx')
                {
                    //echo "<br/>$contentsExt";
                    $b_id='';
                    $bc_id='';
                    if($contentsExt == 'html' || $contentsExt == 'htm' || $contentsExt == 'xls') {
                        if(str_contains($contents_parts['basename'], "MONEX") || str_contains($contents_parts['basename'], "MOVIMIENTOS") || str_contains($contents_parts['basename'], "CONTRATO"))
                            $b_id = '14';
                        else
                            $b_id = '5';
                    }
                    //VCA CTA RONY 20-11-2020
                    foreach(array('RONY','RON','ROYN','ORNY') as $str)
                        if(strpos($contents_parts['basename'], $str) !== false)
                        {
                            $b_id = 1;
                            $bc_id = 39;
                        }

                    $arrfile2EdoCta = array();

                    $arrfile2EdoCta  = file2EdoCta($contents, $bc_id, '', 0.00, $b_id, true, $arrCtas2Do);

                    $arrfile2EdoCtabc_id = $arrfile2EdoCta['bc_id'];
                    if(!empty($arrfile2EdoCtabc_id)) {
                        if(is_array($arrfile2EdoCtabc_id)) {
                            foreach ($arrfile2EdoCtabc_id as $bcid)
                                $sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=" . strit($bcid);
                        }
                        else
                            $sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=" . strit($bc_id);

                        ia_transaction($sql);
                    }

                        unset($_SESSION[$contents_parts['basename']]);
                        ia_errores_a_dime();

                        if($arrfile2EdoCta['Status'] == 'OK' && $arrfile2EdoCta['ErrorCode'] != '3')
                            mueveAIEC($path, $contents_parts, $arrfile2EdoCta);
                        else
                        {
                            $nombreRechazado = '';
                            if($arrfile2EdoCta['ErrorCode'] == '2') //No se pudo determinar la cuenta bancaria.
                            {
                                $nombreRechazado = "RECHAZADO - $contents_parts[filename].$contents_parts[extension]";
                                clearstatcache();
                                if(file_exists($path4EdoCta/$contents_parts["basename"])){
                                    @rename("$path4EdoCta/$contents_parts[basename]", "$path4EdoCta/$nombreRechazado");
                                }

                            }

                            $nombreRechazado = empty($nombreRechazado) ? $path : "$path4EdoCta\\$nombreRechazado";
                            $arrfile2EdoCta['Error'].="<br/><span class='txt_color_red bold'>
                            <a href='javascript:borrarArchivo(\"$nombreRechazado\");'>
                            <img src='../img/delete.png' alt='Borrar Archivo' title='Borrar Archivo'/></a>
                            Archivo: <a href='$nombreRechazado' target='_blank'>$nombreRechazado</a>
                            </span>";
                        }

                    if(($arrfile2EdoCta['Status'] == 'OK' && $arrfile2EdoCta['ErrorCode'] != '4') || $arrfile2EdoCta['Status'] == 'Error')
                    {
                        $arrfile2EdoCta_IECD[] = $arrfile2EdoCta;

                        //Aquí actualizamos la conciliación bancaria.
                        if(!empty($bc_id))
                            ia_query("UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=".strit($arrfile2EdoCta['bc_id']),true,false);

                    }
                }
                else
                    continue;
            }
            else
                continue;
        }
    }



    return $arrfile2EdoCta_IECD;
}

function html2Array($archivo='', $arrBancoModel=array(), $arrBCColModel=array(), $arrBCColsNum=array())
{
    //if(empty($archivo) || empty($arrBancoModel))
    //return false;

    require_once('simple_html_dom.php');

    $l_arrBancoModel = $arrBancoModel;
    $l_arrBCColModel = $arrBCColModel;
    $l_arrBCColsNum = $arrBCColsNum;

    $arrMovsNuevos = array();

    //echo "<br/>$archivo";
    //echo "Col Model:<pre>".print_r($l_arrBCColModel, true)."</pre>";
    //echo "Col Nums:<pre>".print_r($l_arrBCColsNum, true)."</pre>";
    $html = file_get_contents($archivo, FILE_USE_INCLUDE_PATH);
    //
    //echo "<br/>Encoding:".mb_detect_encoding($html);

    $encoding = mb_detect_encoding($html, mb_detect_order(), false);

    if($encoding == "UTF-8")
    {
        $html = mb_convert_encoding($html, 'UTF-8', 'UTF-8');
    }


    $html = iconv(mb_detect_encoding($html, mb_detect_order(), false), "UTF-8//IGNORE", $html);

    /**
    if(mb_detect_encoding($html,'UTF-8',true) != 'UTF-8')
    $html = iconv('UTF-16LE' , 'UTF-8' , $html);
    //echo "<br/>Encoding:".mb_detect_encoding($html);
     * **/

    $htmlObj = str_get_html($html);

    //$pito = $htmlObj;

    //echo $pito;

    $inicioEncontrado = false;

    foreach($htmlObj->find('table') as $table)
    {
        foreach($table->find('tr') as $tr)
        {
            foreach($tr->find('td') as $td)
            {

                $txt_td = sanitizeString(vx_trim(html_entity_decode($td->plaintext)));
                //$txt_td = str_replace('&NBSP;','', $txt_td);
                //echo "$txt_td | ";
                foreach($l_arrBCColModel as $colName => $colDesc)
                    if(!$colDesc['index']['found'] || $colDesc['index']['array']) //Todavía no encontramos a esta columna o es un array y debemos buscarla muchas veces.
                        if(in_array($txt_td, $colDesc['nombre']['match']))
                        {
                            $l_arrBCColModel[$colName]['index']['found'] = true;

                            $l_arrBCColsNum['found']++;
                            break;
                        }
            }
            //echo "<br/>";

            if($l_arrBCColsNum['found'] >= $l_arrBCColsNum['required'])
            {
                $inicioEncontrado = true;
                $tr->id = 'vitexInicioEdoCta';
                $table->id = 'vitexEdoCta';
                //echo $tr . '<br/><hr/>';
                break 2;
            }
        }
    }

    foreach($htmlObj->find('font') as $text)
    {
        foreach($l_arrBancoModel['primeraLinea'] as $cN)
        {
            $pT = sanitizeString(vx_trim(html_entity_decode($text->plaintext)));
            $poscN = strpos($pT, $cN);
            if($poscN !== false)
            {
                $realcN = '';
                $poscN+=strlen($cN);

                $lenpT = strlen($pT);
                while($poscN <= $lenpT)
                {

                    $charcN=substr($pT, $poscN++, 1);
                    //echo "<br/>$charcN";
                    if(is_numeric($charcN))
                        $realcN.=$charcN;
                    elseif($charcN==',')
                        break;
                }

                $arrMovsNuevos[] = array($cN, $realcN);
                break 2;
            }
        }
    }


    foreach($htmlObj->find('table') as $table)
        if($table->id=='vitexEdoCta')
        {
            foreach($table->find('tr') as $tr)
            {
                $arrTR = array();
                foreach($tr->find('td') as $td)
                    $arrTR[] = sanitizeString(vx_trim(html_entity_decode($td->plaintext)));

                $arrMovsNuevos[] = $arrTR;
            }

            break;
        }

    //echo "Movs Nuevos:<pre>".print_r($arrMovsNuevos, true)."</pre>";
    //die();

    //echo "Col Model Final:<pre>".print_r($l_arrBCColModel, true)."</pre>";
    //echo "Col Nums Final:<pre>".print_r($l_arrBCColsNum, true)."</pre>";

    return $arrMovsNuevos;

}

/**
 * Cleans up a given bank reference string by removing certain problematic phrases,
 * special characters, and unwanted spaces. The string is converted to uppercase
 * and then undesired patterns are filtered out.
 *
 * @param string $str The input bank reference string.
 *
 * @return string The cleaned-up bank reference string.
 */
function limpiaReferenciaBancaria($str = "")
{
    $str = strtoupper($str);  // Convert the input string to uppercase
    $arr = explode(" ", $str);  // Split the string into words by spaces

    $refProblematicas = array(
        'TRASPASO A CUENTA DE TERCEROS',
        'CHEQUE PAGADO NO',
        'DEPOSITO EFECTIVO PRACTIC',
        'DEPOSITO EN EFECTIVO',
        'DEPOSITO DE TERCEROS',
        'DEPOSITO POR CORRECCION',
        'PAGO CUENTA DE TERCERO',
        'TRASPASO ENTRE CUENTAS',
        'CHEQUE PAGADO NO',
        'SPEI RECIBIDO',
        'TRASPASO ENTRE CUENTAS',
        'DEP CHEQUES DE OTRO BANCO',
        'DEPOSITO CHEQUE',
        'DEP.CHEQUES DE OTRO BANCO',
        'CHEQUE PAGADO NO',
        'CHEQUE DEVUELTO',
        'CERTIFICACION DE CHEQUE',
        'DEP EFECTIVO','DEPOSITO CHQ','DEPOSITO EFECTIVO','DEPOSITO EFEC','DEP EFECTIVO','DEP EFEC','COMPRA ORDEN DE PAGO SPEI',
        'COMPENSACI',
        'RETIRO POR INVERSION CEDE INVERSION',
        'ABONO INTERESES CEDE INVERSION CAPITAL',
        'RETIRO POR TRANSFERENCIA',
        'RETIRO PARA CUBRIR COMPRA',
        'EN PROCESO DE REVISION',
        'DEPOSITO GENERADO',
        'DEPOSITO EN',
        'CLIENTE VENDE DIVISAS',
        'VENCIMIENTO DE COMPRA',
        'CLIENTE COMPRA DIVISAS',
        'COMPRA EN REPORTO',
        'IMSS/INF/AFORE',
        'DEPOSITO DE FIDUCIARIO',
        'GOBIERNO DEL D F SRI',
        'COMPRA FONDOS INVERSION',
        'APERTURA DE INVERSION',
        'HONORARIOS FIDUCIARIO',
        'RETIRO POR FIDUCIARIO',
        'RETIRO INV',
        'SAT',
        'DEPOSITO POR TRANSFERENCIA',
        'DEPOSITO EN BBVA',
        'CFE SUMINISTRADOR',
        'MUNICIPIO DE PUEBLA');

    // Remove any array elements that are just zeros
    foreach ($arr as $k => $v) {
        if (esPurosCeros($v)) {
            unset($arr[$k]);
        }
    }

    // Recombine the array into a string
    $str = implode(" ", $arr);

    // Check for problematic references and trim the string accordingly
    foreach ($refProblematicas as $rp) {
        $pos = strpos($str, $rp);
        if ($pos !== false) {
            $len = strlen($rp);
            $str = substr($str, 0, $pos + $len);  // Extract the part before and including the problematic reference
            break;  // No need to check further after a match is found
        }
    }

    // Replace non-alphanumeric characters (except space) and apostrophes
    $str = preg_replace('/[^a-zA-Z0-9 ]/', ' ', $str);

    // Remove single quotes
    $str = str_replace("'", '', $str);

    // Further sanitization (assuming sanitizeString is a custom function)
    $str = sanitizeString($str);

    // Final trim to clean up any extraneous spaces
    $str = vx_trim($str);

    return $str;
}
function esPurosCeros($str)
{
    $arr = str_split($str);

    //echo "<pre>".print_r($arr, true)."</pre>";

    foreach($arr as $v)
        if($v != '0')
            return false;

    return true;
}

/**
 * Actualiza los ingresos del banco (banco_cuenta_saldos): deposit_xxxxx contiene: ventas e intereses por inversiones y fiduciarios
 * (excluye regreso de inversiones, fiduciarios, transferencias entre cuentas propias, garantías).
 * También actualiza sado_actual ahora. Lo arregló Pepe 14-11-2020
 * los campos deposit_today, deposit_this_month, deposit_this_year, deposit_custom son calculados automáticamente.
 * @param string $fecha_ini
 * @param string $fecha_fin
 */
function actualizaIngresos($fecha_ini = "", $fecha_fin = "")
{
    //$sqlComment = "";//' /* vitex.' . __FUNCTION__ . '() */ ';
    $sql = [];

    $custom = false;

    if(!empty($fecha_ini) && !empty($fecha_fin)) {

        $fecha_ini = date('Y-m-d', strtotime($fecha_ini)) . " 00:00:00";
        $fecha_fin = date('Y-m-d', strtotime($fecha_fin)) . " 23:59:59";
        $custom = true;
    }

    $sql[] = "UPDATE banco_cuenta_saldos SET fiduciario_all = 0, fiduciario_this_month = 0, fiduciario_this_year = 0,
                fid_ingreso_today = 0, fid_ingreso_this_year = 0, fid_ingreso_this_month = 0,
                inv_ingreso_today = 0, inv_ingreso_this_year = 0, inv_ingreso_this_month = 0,
                ingreso_today = 0, ingreso_this_year = 0, ingreso_this_month = 0,
                inversion_this_year = 0, inversion_all = 0 " .
        ($custom ? ", ingreso_custom = 0,  fid_ingreso_custom = 0, inv_ingreso_custom = 0 " : "");

    $update_bcid = array();

    //Ingresos en el banco
    $rangoFechas = [
        'ingreso_today' => [date('Y-m-d') . " 00:00:00", date('Y-m-d') . " 23:59:59"],
        'ingreso_this_month' => [date('Y-m-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
        'ingreso_this_year' => [date('Y-01-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
    ];

    if($custom) {
        $rangoFechas['ingreso_custom'] = [$fecha_ini, $fecha_fin];
//        $rangoFechas['ingreso_last_year'] = [$fecha_ini, $fecha_fin];
    }
    $where_remarks = "";
    /**
     * AND bcm.remarks NOT LIKE '%SIN AFECTAR LA CUENTA T%' AND bcm.remarks NOT LIKE '%DEVUELT%' AND bcm.remarks NOT LIKE '%FIDUCI%'
    AND bcm.remarks NOT LIKE '%DEVOLUCI%' AND bcm.remarks NOT LIKE '%INVERSION%'
    AND bcm.numero NOT LIKE '%FIDUCI%' AND bcm.numero NOT LIKE '%DEV%' AND bcm.numero NOT LIKE '%INV%'
     *
     * queda a reserva el tipo 24 que es pagos entre empresas del grupo.
     */

    foreach($rangoFechas as $fieldName => $fechas) {
        $sqlNoFiduciario =
            "SELECT bcm.banco_cuenta_id, SUM(bcm.cash + bcm.deposit) as monto
          FROM banco_cuenta_mov bcm
          WHERE  bcm.fecha >= '$fechas[0]' AND bcm.fecha <= '$fechas[1]'
                AND bcm.es = 'Deposito'
                AND bcm.banco_mov_tipo_id NOT IN ('18','21','22','23','26')
                AND bcm.link_vale NOT IN ('SBC')
                AND (( (bcm.remarks IS NOT NULL AND bcm.remarks NOT LIKE '%FIDUCIARIO%') AND (bcm.remarks IS NOT NULL AND bcm.remarks NOT LIKE '%INVERSION%') AND (bcm.remarks IS NOT NULL AND bcm.remarks NOT LIKE '%DEVUELT%') AND (bcm.remarks IS NOT NULL AND bcm.remarks NOT LIKE '%SIN AFECTAR LA CUENTA T%') )) 
                AND (( (bcm.numero_original  IS NOT NULL AND bcm.numero_original  NOT LIKE '%INV%') AND (bcm.numero_original  IS NOT NULL AND bcm.numero_original  NOT LIKE '%FIDUCIARIO%') AND (bcm.numero_original  IS NOT NULL AND bcm.numero_original  NOT LIKE '%DEV%') )) 
                AND bcm.factura NOT IN ('DEVOLUCION')
                $where_remarks
          GROUP BY bcm.banco_cuenta_id";
        $cuentas = ia_sqlKeyValue($sqlNoFiduciario);
        if(!empty($cuentas))
            foreach($cuentas as $banco_cuenta_id => $monto) {
                //$sql[] = "UPDATE banco_cuenta_saldos SET $fieldName = $monto WHERE banco_cuenta_id = $banco_cuenta_id";

                if(!array_key_exists($banco_cuenta_id, $update_bcid))
                    $update_bcid[$banco_cuenta_id] = array();

                $update_bcid[$banco_cuenta_id][$fieldName] = $monto;
            }

    }
//    echo "<pre>".print_r($sqlNoFiduciario, true)."</pre>";
//    echo "<pre>".print_r($cuentas, true)."</pre>";
    //Fiduciarios
    $rangoFechas = [
        'fiduciario_all' => ["2000-01-01 00:00:00", "2050-12-31 23:59:59"],
        'fiduciario_this_month' => [date('Y-m-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
        'fiduciario_this_year' => [date('Y-01-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
    ];
/**
    if($custom)
        $rangoFechas['fiduciario_custom'] = [$fecha_ini, $fecha_fin];

    foreach($rangoFechas as $fieldName => $fechas) {
        if($fieldName == "fiduciario_all")
            $sqlNoFiduciario ="SELECT banco_cuenta_id,
                SUM(saldo) as monto
                FROM fiduciario
                WHERE terminado = 'No'
                GROUP BY banco_cuenta_id";
        else
            $sqlNoFiduciario = "SELECT banco_cuenta_id,
                SUM(monto_retiro) as monto
                FROM fiduciario
                WHERE fecha_retiro >= '$fechas[0]' AND fecha_retiro <= '$fechas[1]'
                GROUP BY banco_cuenta_id";

        $cuentas = ia_sqlKeyValue($sqlNoFiduciario);
        if(!empty($cuentas))
            foreach($cuentas as $banco_cuenta_id => $monto) {
                //$sql[] = "UPDATE banco_cuenta_saldos SET $fieldName = $monto WHERE banco_cuenta_id = $banco_cuenta_id";

                if(!array_key_exists($banco_cuenta_id, $update_bcid))
                    $update_bcid[$banco_cuenta_id] = array();

                $update_bcid[$banco_cuenta_id][$fieldName] = $monto;
            }
    }
**/
    //Ingresos por intereses de Fiduciario
//    $rangoFechas = [
//        'fid_ingreso_today' => [date('Y-m-d') . " 00:00:00", date('Y-m-d') . " 23:59:59"],
//        'fid_ingreso_this_month' => [date('Y-m-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
//        'fid_ingreso_this_year' => [date('Y-01-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
//    ];

//    if($custom)
//        $rangoFechas['fid_ingreso_custom'] = [$fecha_ini, $fecha_fin];
/**
    foreach($rangoFechas as $fieldName => $fechas) {
        $sqlNoFiduciario =
            "SELECT banco_cuenta_id, SUM(monto_interes) as monto
          FROM fiduciario_reembolso
          WHERE fecha_deposito >= '$fechas[0]' AND fecha_deposito <= '$fechas[1]' AND activo = 'Si'
          GROUP BY banco_cuenta_id";

        $cuentas = ia_sqlKeyValue($sqlNoFiduciario);
        if(!empty($cuentas))
            foreach($cuentas as $banco_cuenta_id => $monto) {
                //$sql[] = "UPDATE banco_cuenta_saldos SET $fieldName = $monto WHERE banco_cuenta_id = $banco_cuenta_id";

                if(!array_key_exists($banco_cuenta_id, $update_bcid))
                    $update_bcid[$banco_cuenta_id] = array();

                $update_bcid[$banco_cuenta_id][$fieldName] = $monto;
            }
    }
**/
    //Ingresos por intereses de Inversiones
//    $rangoFechas = [
//        'inv_ingreso_today' => [date('Y-m-d') . " 00:00:00", date('Y-m-d') . " 23:59:59"],
//        'inv_ingreso_this_month' => [date('Y-m-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
//        'inv_ingreso_this_year' => [date('Y-01-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
//    ];

//    if($custom)
//        $rangoFechas['inv_ingreso_custom'] = [$fecha_ini, $fecha_fin];
/**
    foreach($rangoFechas as $fieldName => $fechas) {
        $sqlNoFiduciario =
            "SELECT  banco_cuenta_id, SUM(monto_interes) as monto
          FROM inversion_reembolso
          WHERE fecha_deposito >= '$fechas[0]' AND fecha_deposito <= '$fechas[1]' AND activo = 'Si'
          GROUP BY banco_cuenta_id";

        $cuentas = ia_sqlKeyValue($sqlNoFiduciario);
        if(!empty($cuentas))
            foreach($cuentas as $banco_cuenta_id => $monto) {
                //$sql[] = "UPDATE banco_cuenta_saldos SET $fieldName = $monto WHERE banco_cuenta_id = $banco_cuenta_id";

                if(!array_key_exists($banco_cuenta_id, $update_bcid))
                    $update_bcid[$banco_cuenta_id] = array();

                $update_bcid[$banco_cuenta_id][$fieldName] = $monto;
            }
    }

    //Inversiones activas por cuenta
    $rangoFechas = array();
    $rangoFechas = [
        'inversion_all' => ["2000-01-01 00:00:00", "2050-12-31 23:59:59"],
        'inversion_this_year' => [date('Y-01-01') . " 00:00:00", date('Y-m-t') . " 23:59:59"],
    ];

    if($custom)
        $rangoFechas['inversion_custom'] = [$fecha_ini, $fecha_fin];

    foreach($rangoFechas as $fieldName => $fechas) {
        $sqlNoFiduciario =
            "SELECT  banco_cuenta_id, SUM(saldo) as monto
          FROM inversion
          WHERE fecha_retiro >= '$fechas[0]' AND fecha_retiro <= '$fechas[1]' AND terminado = 'No'
          GROUP BY banco_cuenta_id";

        $cuentas = ia_sqlKeyValue($sqlNoFiduciario);
        if(!empty($cuentas))
            foreach($cuentas as $banco_cuenta_id => $monto) {
                //$sql[] = "UPDATE banco_cuenta_saldos SET $fieldName = $monto WHERE banco_cuenta_id = $banco_cuenta_id";

                if(!array_key_exists($banco_cuenta_id, $update_bcid))
                    $update_bcid[$banco_cuenta_id] = array();

                $update_bcid[$banco_cuenta_id][$fieldName] = $monto;
            }
    }
**/
    foreach($update_bcid as $banco_cuenta_id => $campos){
        //$sql[] = ia_update("banco_cuenta_saldos", $campos, array("banco_cuenta_id" => $banco_cuenta_id));
        $campos["banco_cuenta_id"] = $banco_cuenta_id;
        $sql[] = ia_insert("banco_cuenta_saldos", $campos, array(),"", true);
    }

    $sql[] =
        "INSERT INTO banco_cuenta_saldos(banco_cuenta_id, saldo_actual, sbc, deposit_cash, deposit_total, 
                                      withdrawal_total, Ultimo_Movimiento, Ultimo_cash, Ultimo_deposit, Ultimo_withdrawal, 
                                      ultima_conciliacion, orden, nombre, banco_id, moneda_id)
        (SELECT
            bcm.banco_cuenta_id,
            SUM(bcm.cash + bcm.deposit - bcm.withdrawal) + bcsh.deposit_total - bcsh.withdrawal_total as saldo_actual,
            SUM(IF(bcm.link_vale='SBC',bcm.cash + bcm.deposit,0)) as sbc,
            SUM(bcm.cash+bcm.deposit) + bcsh.deposit_total as deposit_cash,
            SUM(bcm.cash + bcm.deposit) + bcsh.deposit_total as deposit_total,
            SUM(bcm.withdrawal) + bcsh.withdrawal_total as withdrawal_total,
            MAX(fecha) as Ultimo_Movimiento,
            MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_cash,
            MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_deposit,
            MAX(IF(bcm.withdrawal>0,fecha,NULL)) as Ultimo_withdrawal,
            bc.ultima_conciliacion,
            bc.orden,
            bc.nombre,
            bc.banco_id,
            bc.moneda_id
        FROM banco_cuenta_mov bcm 
            JOIN banco_cuenta bc ON bcm.banco_cuenta_id = bc.banco_cuenta_id 
            JOIN banco_cuenta_saldos_hist bcsh ON bc.banco_cuenta_id = bcsh.banco_cuenta_id 
        WHERE  bc.vale = 'Active' AND bcm.fecha >= '2023-01-01'
        GROUP BY bcm.banco_cuenta_id,bc.ultima_conciliacion,bc.orden, bc.nombre
        ) ON DUPLICATE KEY UPDATE
            saldo_actual=VALUES(saldo_actual),
            sbc=VALUES(sbc),
            deposit_cash=VALUES(deposit_cash),
            deposit_total=VALUES(deposit_total),
            withdrawal_total=VALUES(withdrawal_total),
            Ultimo_Movimiento=VALUES(Ultimo_Movimiento),
            Ultimo_cash=VALUES(Ultimo_cash),
            Ultimo_deposit=VALUES(Ultimo_deposit),
            Ultimo_withdrawal=VALUES(Ultimo_withdrawal),
            ultima_conciliacion=VALUES(ultima_conciliacion),
            orden=VALUES(orden),
            nombre=VALUES(nombre),
            banco_id=VALUES(banco_id),
            moneda_id=VALUES(moneda_id)";


    ia_transaction($sql);


//    ia_errores_a_dime();
//    ia_errores_a_dime("<pre>SQL" . print_r($sql, true) . "</pre>"."<pre>UP" . print_r($update_bcid, true) . "</pre>", "actualizaIngresos1");
    //echo "<pre>SQL" . print_r($sql, true) . "</pre>";
    //echo "<pre>UP" . print_r($update_bcid, true) . "</pre>";
    //echo "<pre>SQL1" . print_r($sql1, true) . "</pre>";

}


function mueveAIEC($archivo, $path_parts=array(), $arrfile2EdoCta=array())
{
    global $gIAParametros;

    $pathAIEC = $gIAParametros['path_archivos_estado_de_cuenta_importados'];
    clearstatcache();
    if(!file_exists($pathAIEC))
        @mkdir($pathAIEC);

    if(file_exists($pathAIEC) && !is_dir($pathAIEC))
    {
        @safeDeleteFile($pathAIEC);
        @mkdir($pathAIEC);
    }

    if(!file_exists($archivo))
        return false;

    if(strlen($path_parts['filename'])>15)
        $path_parts['basename'] = substr($path_parts['filename'],0,15).".$path_parts[extension]";

    $nvoNombre = date('Y-m-d H-i-s')."-$arrfile2EdoCta[Cuenta]-$path_parts[basename]";

    @rename("$archivo", "$pathAIEC/$nvoNombre");

    return true;

}

/**
 * Elimina los movimientos fantasma de Monex del array pasado por referencia.
 * Los movimientos fantasma son aquellos que contienen las palabras "DE REVISION" o "GENERICO PRIVADO" en la referencia.
 * Retorna el array sin los movimientos fantasma.
 *
 * @param array $arr_MovsNuevos El array de movimientos a filtrar (pasado por referencia)
 * @param int $referenciaKey El índice de la referencia en cada movimiento
 * @return array El array de movimientos sin los movimientos fantasma
 */
function quita_movimientos_fantasma_monex(&$arr_MovsNuevos = array(), $referenciaKey = 0){

    if(empty($arr_MovsNuevos) || $referenciaKey === 0)
        return $arr_MovsNuevos;

    foreach($arr_MovsNuevos as $k => $nvo_mov){
        if(str_contains($nvo_mov[$referenciaKey], "DE REVISION") || str_contains($nvo_mov[$referenciaKey], "GENERICO PRIVADO")) { //Son de monex.
            unset($arr_MovsNuevos[$k]);
        }
    }
    return $arr_MovsNuevos;
}

/**
 * Revisa si los movimientos pertenecen a una cuenta Monex.
 * Verifica si los movimientos existen en la cuenta bancaria proporcionada.
 * Si existen, se actualiza el valor de la variable $bc_id_calc con el valor de $bc_id.
 * Si no existen, se verifica si existen en otras cuentas bancarias.
 * Si existen en otras cuentas, se actualiza el valor de $bc_id_calc con el valor de la cuenta bancaria en la que se encontraron.
 * @param array $arrMovsNuevos Un array con los nuevos movimientos a revisar.
 * @param array $finalKeys Un array con las claves finales para los campos fecha, deposit, y withdrawal en los movimientos.
 * @param int $bc_id El ID de la cuenta bancaria a verificar.
 * @param int $bc_id_calc Una variable de salida que se actualiza con el ID de la cuenta bancaria en la que se encontraron los movimientos.
 * @return bool Retorna true si se encontraron los movimientos en la cuenta proporcionada, o false en caso contrario.
 */
function revisa_movimientos_pertecen_a_cuenta_monex($arrMovsNuevos = array(), $finalKeys = array(), $bc_id = 0, &$bc_id_calc = 0){
    if(empty($arrMovsNuevos) || empty($finalKeys) || empty($bc_id) )
        return false;

    $method = __METHOD__;

    $fecha_maxima = ia_singleread("SELECT MAX(DATE(fecha)) FROM banco_cuenta_mov WHERE banco_cuenta_id='$bc_id'");

    $cuantos_hoy = 0;
    $cuantos_anteriores = 0;
    $cuantos_propios = 0;

    /**
     * Represents an array of new movements.
     *
     * @var array $arrMovsNuevos An array containing new movements.
     * revisamos si el movimiento existe en la cuenta bancaria
     */
    foreach($arrMovsNuevos as $k => $nvo_mov){

        $fecha = $nvo_mov[$finalKeys['fecha']];
        $deposit = $nvo_mov[$finalKeys['deposit']];
        $withdrawal = $nvo_mov[$finalKeys['withdrawal']];

        $sql = "SELECT /** $method - misma cuenta **/ banco_cuenta_mov_id, fecha, deposit, withdrawal, banco_cuenta_id FROM banco_cuenta_mov WHERE DATE(fecha) = '$fecha' AND deposit = '$deposit' AND withdrawal = '$withdrawal'";
        $existe = ia_sqlArray($sql, 'banco_cuenta_id');

        if(array_key_exists( $bc_id, $existe) && sizeof($existe) == 1)
            $cuantos_propios++;
        else{
            if($fecha == $fecha_maxima) {
                $cuantos_hoy++;
            }else{
                $cuantos_anteriores++;
                $bc_id_calc = $existe['banco_cuenta_id'] ?? 0;
            }
        }
    }

//    echo "follaame: <pre>" . print_r($arrMovsNuevos, true) ."</pre>";
    if($cuantos_propios >= 1) {
//        echo "$sql - $cuantos_propios : <pre>" . print_r($existe, true) ."</pre>";
        $bc_id_calc = $bc_id;
        return true;
    }
    /**
     * @var array $arrMovsNuevos An array containing new movements.
     * No perteneció a la cuenta que nos pasaron.
     * revisamos si el movimiento existe en otras cuentas bancarias.
     */
//    echo "<pre>" . print_r("folla 1", true) ."</pre>";
    foreach($arrMovsNuevos as $k_ => $nvo_mov_){

        $fecha = $nvo_mov_[$finalKeys['fecha']];
        $deposit = $nvo_mov_[$finalKeys['deposit']];
        $withdrawal = $nvo_mov_[$finalKeys['withdrawal']];
//        echo "<li>$fecha - $fecha_maxima";
        if(strtotime($fecha) > strtotime($fecha_maxima))
            continue;

        $sql = "SELECT /** $method - otras cuentas $fecha_maxima **/ banco_cuenta_mov_id, DATE(fecha) AS fecha, deposit, withdrawal, banco_cuenta_id FROM banco_cuenta_mov WHERE DATE(fecha) = '$fecha' AND deposit = '$deposit' AND withdrawal = '$withdrawal' LIMIT 1";
        $existe = ia_singleton($sql);

//        echo "$sql - $cuantos_anteriores - $cuantos_hoy : <pre>" . print_r($existe, true) ."</pre>";

        if(empty($existe))
            continue;

        if($fecha == $fecha_maxima) {
//            echo "<li>$fecha - $fecha_maxima";
            $cuantos_hoy++;
        }else
            $cuantos_anteriores++;

        $bc_id_calc = $existe['banco_cuenta_id'];
    }

    return false;
}

function link_propias_busca_movimiento_origen($origen_banco_cuenta_id = '', $monto_origen = 0, $origen_fecha = '', $link_vale_not_in = "'BL', 'LT', 'STOP'"){
    $method = __METHOD__;
    $sqlo = "SELECT /** $method **/ banco_cuenta_mov_id, remarks FROM banco_cuenta_mov WHERE banco_cuenta_id = '$origen_banco_cuenta_id' AND usado = 0 AND link_vale NOT IN ($link_vale_not_in) AND withdrawal = '$monto_origen' AND fecha LIKE '$origen_fecha%' ORDER BY fecha ASC LIMIT 1";
    $existe = ia_sqlArrayIndx($sqlo);
    return $existe;
}

function globalLinkpropioHelperGeneraRemarks(string $banco_cuenta_trans_id = "", $BancoT = "", $bcmo = [], string $usuario_automatico = "", $bancoCuentaTrans = [], $debug = false): array
{
    $sql_ = [];

    $bancoCuentaTrans = fetchTransactionIfEmpty($banco_cuenta_trans_id, $bancoCuentaTrans);
    $usuario_automatico = $bancoCuentaTrans['alta_por'] == 'sistema' ? 'sistema' : $usuario_automatico;
    $bcmND_remarks = generaRemarksTransferCuentasPropias(bancoCuentaTransId: $banco_cuenta_trans_id, bancoCuentaTrans: $bancoCuentaTrans, usuario_automatico: $usuario_automatico, debug: $debug);
    $sql_[] = "UPDATE banco_cuenta_trans SET referencia = '" . addslashes($bcmND_remarks) . "', remarks = '" . addslashes($bcmND_remarks) . "' WHERE banco_cuenta_trans_id = " . strit($banco_cuenta_trans_id);

    $bcmo = fetchBancoCuentaMov($bancoCuentaTrans['origen_mov_id']);

    $bcml = fetchBancoCuentaMovLinkBasedOnIds($bancoCuentaTrans['banco_cuenta_mov_link_id']);
    $bcmd = fetchBancoCuentaMov($bcml['banco_cuenta_mov_id']);
    $txt_link_vale_update = "";
    $link_vale_original = $bcmo['link_vale'];
    $bcmo_id = $bcmo['banco_cuenta_mov_id'];
    $bcm_id = $bcmd['banco_cuenta_mov_id'];

    if( in_array($link_vale_original, array('NAVIERA', 'GARANTIA')))
        $txt_link_vale_update = " link_Vale = '$link_vale_original', ";


    $txt_poliza_contabilidad = ", poliza_contabilidad = ".strit(genera_poliza_contabilidad_transfer_cuentas_propias($banco_cuenta_trans_id, $bcmND_remarks));

    $sql_[] = "UPDATE banco_cuenta_mov SET $txt_link_vale_update remarks = '" . addslashes($bcmND_remarks) . "' $txt_poliza_contabilidad WHERE banco_cuenta_mov_id = ".strit($bcmo_id);
    $sql_[] = "UPDATE banco_cuenta_mov SET remarks = '" . addslashes($bcmND_remarks) . "' WHERE banco_cuenta_mov_id = ".strit($bcm_id);


    if($bancoCuentaTrans['origen_moneda_id'] != $bancoCuentaTrans['moneda_id']) {
        $movimiento_divisa_id_ = ia_singleread("SELECT movimiento_divisa_id FROM movimiento_divisa WHERE doc_id = '{$banco_cuenta_trans_id}' AND doc_origen = 'banco_cuenta_trans'");
        if(strlen($movimiento_divisa_id_)) {
            $plus_desc = "";
            $set_tc_revison = '';
            if (str_contains($bcmND_remarks, "LINK AUTOMATICO")) {
                $plus_desc = "<br><br><span class='bg-warning text-danger bold ml-2'>TIPO DE CAMBIO ACEPTADO POR: <b class='txt_color_PESOS'> LINK AUTOMATICO</b></span>";
                $set_tc_revison = ", tc_revision = 'OK_LINK_AUTOMATICO'";
            }

            $sql_[] = "UPDATE movimiento_divisa SET descripcion = '" . addslashes($bcmND_remarks.$plus_desc) . "' $set_tc_revison WHERE movimiento_divisa_id = " . strit($movimiento_divisa_id_);
        }

    }

    return $sql_;
}


// Function to create the arrBancoModel array
function createBancoModel()
{
    return array(
        '1' => array(
            'b_id' => 1,
            'nombre' => 'BBVA',
            'minCols' => 5,
            'delimiter' => "\t",
            'primeraLinea' => false,
            'refArray' => false,
            'numeroCuenta' => array('CUENTA:', 'NUMERO DE CUENTA'),
            'fileName' => createFileNamesForBanco1(),
            'saldoFinal' => array(),
            'rA' => true
        ),
        '10' => array(
            'b_id' => 10,
            'nombre' => 'SANTANDER',
            'minCols' => 5,
            'delimiter' => "\t",
            'primeraLinea' => false,
            'refArray' => false,
            'numeroCuenta' => array('CUENTA:', 'NUMERO DE CUENTA'),
            'fileName' => createFileNamesForBanco10(),
            'saldoFinal' => array(),
            'rA' => true
        ),
    );
}

// Function to create the fileName array for Banco 1
function createFileNamesForBanco1()
{
    return array(
        array('bc_id' => '2', 'nombre' => array('ELEYEME', 'ELYEME', 'ELEYEM', 'ELYEME')),
    );
}

// Function to create the fileName array for Banco 10 (santander)
function createFileNamesForBanco10()
{
    return array(
        array('bc_id' => '3', 'nombre' => array('ELEYEME', 'ELYEME', 'ELEYEM', 'ELYEME')),
    );
}

// Function to create the arrBCColModel array
function createBCColModel()
{
    return array(
        'fecha' => array(
            'index' => array('array' => false, 'finalKey' => 0, 'originKey' => false, 'found' => false),
            'nombre' => array(
                'match' => array('FECHA', 'DATE', 'DIA', 'FECHA POSTERIOR', 'FECHA DEL APUNTE', 'FECHA OPERACION', 'FECHA DE LIQUIDACION'),
                'ignore' => array(),
                'strict' => true
            )
        ),
        'referencia' => array(
            'index' => array('array' => false, 'finalKey' => 1, 'originKey' => false, 'found' => false),
            'nombre' => array(
                'match' => array('DESCRIPCION', 'DESCRIPCION DETALLADA', 'REFERENCIA', 'REFERENCE', 'REF', 'NOTES', 'REMARKS', 'DESCRIPTION', 'CONCEPTO', 'DETALLE', 'DETALLES', 'DETAILS', 'DETAIL', 'CONCEPTO / REFERENCIA', 'DESCRIPCI&OACUTE;N', 'NARRATIVA ADICIONAL', 'REFERENCIA DEL CLIENTE', 'EMISORA SERIE'),
                'ignore' => array(),
                'strict' => true
            )
        ),
        'withdrawal' => array(
            'index' => array('array' => false, 'finalKey' => 2, 'originKey' => false, 'found' => false),
            'nombre' => array(
                'match' => array('CARGO', 'CARGOS', 'RETIRO', 'RETIROS', 'WITHDRAWAL', 'WITHDRAWALS', 'IMPORTE DEL CARGO', 'IMPORTE DEL DEBITO', 'IMPORTE'),
                'ignore' => array(),
                'strict' => true
            )
        ),
        'deposit' => array(
            'index' => array('array' => false, 'finalKey' => 3, 'originKey' => false, 'found' => false),
            'nombre' => array(
                'match' => array('ABONO', 'ABONOS', 'DEPOSITO', 'DEPOSITOS', 'DEPOSIT', 'DEPOSITS', 'DEP&OACUTE;SITO', 'IMPORTE DEL ABONO', 'IMPORTE DE CREDITO', 'IMPORTE'),
                'ignore' => array(),
                'strict' => true
            )
        ),
        'balance' => array(
            'index' => array('array' => false, 'finalKey' => 4, 'originKey' => false, 'found' => false),
            'nombre' => array(
                'match' => array('SALDO ACTUAL EN LIBROS', 'SALDO', 'BALANCE'),
                'ignore' => array(),
                'strict' => true
            )
        ),
        'referencia_monex' => array(
            'index' => array('array' => false, 'finalKey' => 5, 'originKey' => 5, 'found' => true),
            'nombre' => array(
                'match' => array('REFERENCIA_MONEX'),
                'ignore' => array(),
                'strict' => true
            )
        )
    );
}

// Function to create the arrBCColsNum array
function createBCColsNum()
{
    return array(
        'required' => 4,
        'found' => 0
    );
}

// Function to create the arrSaldosCol array
function createSaldosCol()
{
    return array();
}

// Function to create the arrEmpresas array
function createEmpresas()
{
    global $gIAsql;
    return ia_sqlArray("SELECT banco_cuenta_id, empresa_id FROM banco_cuenta ORDER BY banco_cuenta_id", "banco_cuenta_id");
}

// Final function to initialize all models
function initializeModels()
{
    $arrBancoModel = createBancoModel();
    $arrBCColModel = createBCColModel();
    $arrBCColsNum = createBCColsNum();
    $arrSaldosCol = createSaldosCol();
    $arrEmpresas = createEmpresas();

    return array(
        'arrBancoModel' => $arrBancoModel,
        'arrBCColModel' => $arrBCColModel,
        'arrBCColsNum' => $arrBCColsNum,
        'arrSaldosCol' => $arrSaldosCol,
        'arrEmpresas' => $arrEmpresas
    );
}

/**
 * Helper function to read and filter directory files, and sort them using a randomly selected algorithm.
 * The random number generator is seeded with microseconds to improve randomization.
 *
 * @param string $path The directory path
 * @return array The array of filtered file information sorted based on the selected algorithm
 */
function getFilteredDirectoryFiles(string $path, int $max_items = 20): array
{
    $arrDirectoryFinal = array();
    $items = 0;

    $usuario = $_SESSION['usuario'];
    global $gIAParametros;

    $gIAParametros['path_archivos_estado_de_cuenta_enproceso'] = $gIAParametros['path_archivos_estado_de_cuenta'] . DIRECTORY_SEPARATOR ."proceso";
    $pathECEP = $gIAParametros['path_archivos_estado_de_cuenta_enproceso'];

    // Check if the path is a directory
    if (!is_dir($path)) {
        return $arrDirectoryFinal; // Return empty array if path is not a directory
    }

    // Open the directory
    $directoryHandle = @opendir($path);
    if ($directoryHandle === false) {
        return $arrDirectoryFinal; // Return empty array if directory cannot be opened
    }

    clearstatcache();
    while ((++$items < $max_items) && ($contents = @readdir($directoryHandle)) !== false) {
        if ($contents != '.' && $contents != '..') {
            $fullPath = $path . DIRECTORY_SEPARATOR . $contents;
            $userPath = $pathECEP . DIRECTORY_SEPARATOR . $usuario . DIRECTORY_SEPARATOR . $contents;
            clearstatcache();
            if (!file_exists($fullPath) || is_dir($fullPath)) {
                continue;
            }

            ensurePathExists($userPath);

            $contents_parts = pathinfo($contents);
            $contentsExt = isset($contents_parts['extension']) ? strtolower($contents_parts['extension']) : '';
            $basename = strtoupper($contents_parts['basename'] ?? "");

            // Skip files containing 'RECHAZADO'
            if (str_contains($basename, 'RECHAZADO')) {
                continue;
            }

            // Get file modification time
            $modTime = filemtime($fullPath);

            if(is_file($fullPath))
                @rename($fullPath, $userPath);
            // Store the file information
            $arrDirectoryFinal[] = array(
                'basename' => $basename,
                'modTime' => $modTime,
                'extension' => $contentsExt,
                'fullPath' => convertAllBackslashesToForwardSlashes($userPath), // Include the full path
                'userPath' => convertAllBackslashesToForwardSlashes($userPath), // Include the $userPath
            );
        }
    }

    @closedir($directoryHandle);
    clearstatcache();

    // Seed the random number generator with microseconds to improve randomization
    mt_srand((int)(microtime(true) * 1000000));

    // Randomly select a sorting algorithm
    $sortingAlgorithms = array('modTimeAsc', 'modTimeDesc', 'shuffle');
    $selectedAlgorithm = $sortingAlgorithms[array_rand($sortingAlgorithms)];

    // Apply the selected sorting algorithm
    switch ($selectedAlgorithm) {
        case 'modTimeAsc':
            // Sort by modification date ascending (oldest first)
            usort($arrDirectoryFinal, function($a, $b) {
                return $a['modTime'] - $b['modTime'];
            });
            break;

        case 'modTimeDesc':
            // Sort by modification date descending (newest first)
            usort($arrDirectoryFinal, function($a, $b) {
                return $b['modTime'] - $a['modTime'];
            });
            break;

        case 'shuffle':
            // Shuffle the files randomly
            shuffle($arrDirectoryFinal);
            break;
    }

    // Return the sorted array with full file information
    return array_slice($arrDirectoryFinal, 0, $max_items);
}

function getCuentasparaImportar(&$arrCuentas, &$ajax_id = "1")
{
    global $gIAParametros;
    $path4EdoCta = $gIAParametros['path_archivos_estado_de_cuenta'];
    $gIAParametros['path_archivos_estado_de_cuenta_enproceso'] = $gIAParametros['path_archivos_estado_de_cuenta'] . DIRECTORY_SEPARATOR ."proceso";

    $pathECEP = $gIAParametros['path_archivos_estado_de_cuenta_enproceso'];

    if (!empty($arrCuentas)) {
        $arrCuentas = json_decode($arrCuentas, true);
        return $arrCuentas[0] ?? $arrCuentas[$ajax_id] ?? [];
    }
// Step 1: Retrieve filenames from the directory using the helper function
    $arrDirectoryFinal = getFilteredDirectoryFiles(path: $path4EdoCta, max_items: 20);

// Use the function to initialize and distribute files
    $arrCuentas = initializeAndDistributeFiles($arrDirectoryFinal);

    return $arrCuentas[0] ?? $arrCuentas[$ajax_id] ?? [];
}

/**
 * Initializes the array of accounts and distributes files into branches with a maximum number of items per branch.
 *
 * @param array $arrDirectoryFinal The array of files to be distributed.
 * @param int   $arrBancosLength   The number of branches (default is 10).
 * @param int   $maxItemsPerBranch The maximum number of items per branch (default is 2).
 *
 * @return array The array of branches with files distributed into them.
 */
function initializeAndDistributeFiles(array $arrDirectoryFinal, int $arrBancosLength = 10, int $maxItemsPerBranch = 1): array
{
    $arrBancosLength = count($arrDirectoryFinal);// / 2;
    // Step 1: Initialize $arrCuentas
    $arrCuentas = [];
    for ($i = 1; $i <= $arrBancosLength + 1; $i++) {
        $arrCuentas[$i] = [];
    }

    // Step 2: Distribute files into branches with a maximum of $maxItemsPerBranch per branch
    $totalBranches = count($arrCuentas);
    if (!empty($arrDirectoryFinal)) {
        $branchIndex = 1;
        foreach ($arrDirectoryFinal as $fileInfo) {
            $attempts = 0;
            while ($attempts < $totalBranches) {
                // If the current branch has less than the maximum items, add the file
                if (count($arrCuentas[$branchIndex]) < $maxItemsPerBranch) {
                    $arrCuentas[$branchIndex][] = $fileInfo;
                    //$branchIndex++;
                    if ($branchIndex > $totalBranches) {
                        $branchIndex = 1;
                    }
                    break;
                } else {
                    // Move to the next branch
                    $branchIndex++;
                    if ($branchIndex > $totalBranches) {
                        $branchIndex = 1;
                    }
                    $attempts++;
                }
            }
            // If all branches are full, stop distributing files
            if ($attempts >= $totalBranches) {
                break;
            }
        }
    }

    // Step 3: Reverse the order of files in each branch
    foreach ($arrCuentas as $key => $files) {
        $arrCuentas[$key] = array_reverse($files);
    }

    return $arrCuentas;
}


/**
 * Converts any backslashes (single or multiple) to a single forward slash.
 *
 * @param string $input The input string containing backslashes.
 * @return string The string with backslashes converted to forward slashes.
 */
function convertAllBackslashesToForwardSlashes(string $input): string
{
    // Replace one or more backslashes with a single forward slash
    $input = preg_replace('/\\\\+/', '/', $input);
    $input = str_starts_with($input, '/') ? '/' . $input : $input;
    return $input;
}

/**
 * Imports bank account statements from an array of files.
 *
 * @param array  $arrCuentas Reference to the array containing account files.
 * @param int    $ajax_id    The ID used to index into $arrCuentas.
 * @param string &$b_id      Reference to the bank ID, which may be modified.
 * @param string &$bc_id     Reference to the bank account ID, which may be modified.
 *
 * @return array An array containing the results of the processed files.
 */
function importaEdoCtadesdeArray(array &$arrCuentas, int $ajax_id = 1, string &$b_id = '', string &$bc_id = ''): array
{
    global $gIAParametros, $gWebDir;
//    error_reporting(E_ALL & ~E_WARNING);

    // Define paths
    $path4EdoCta = $gIAParametros['path_archivos_estado_de_cuenta'];
    $gIAParametros['path_archivos_estado_de_cuenta_enproceso'] = $path4EdoCta . DIRECTORY_SEPARATOR . 'proceso';
    $pathECEP = $gIAParametros['path_archivos_estado_de_cuenta_enproceso'];

    // Initialize result array
    $arrfile2EdoCta_IECD = [];

    // Define allowed file extensions and keywords
    $allowedExtensions = ['exp', 'txt', 'csv', 'html', 'htm', 'xls', 'xlsx'];
    $specialExtensions = ['html', 'htm', 'xls'];
    $bbvaKeywords     = ['BBVA', 'BANCOMER'];
    $santanderKeywords      = ['SANTANDER', 'SANT', 'SATANDER'];


// Ensure the archive directory exists
    $pathECEP = convertAllBackslashesToForwardSlashes($pathECEP);
    if (!is_dir($pathECEP)) {
        mkdir($pathECEP);
    }

    if(!array_key_exists($ajax_id, $arrCuentas) && array_key_exists(0, $arrCuentas) ) {
        $ajax_id = 0;
    }

    if (is_array($arrCuentas) && !empty($arrCuentas[$ajax_id])) {
        foreach ($arrCuentas[$ajax_id] as $k => $fileInfo) {

            try {
                $method = __METHOD__;

                // Extract file information with null coalescing operator
                $contentsExt  = $fileInfo['extension'] ?? '';
                $filename     = $fileInfo['basename'] ?? '';
                $originalPath = convertAllBackslashesToForwardSlashes($fileInfo['fullPath'] ?? '');
                $tempFilePath = convertAllBackslashesToForwardSlashes($pathECEP . DIRECTORY_SEPARATOR . $filename);

                // Skip file if the extension is not allowed
                if (!in_array($contentsExt, $allowedExtensions, true)) {
                    continue;
                }

                // Determine $b_id based on file extension and content
                
                // Set $b_id and $bc_id if the filename contains any bbva keywords
                if (containsAny($filename, $bbvaKeywords)) {
                    $b_id  = '1';
                    $bc_id = '2';
                }

                if (containsAny($filename, $santanderKeywords)) {
                    $b_id  = '10';
                    $bc_id = '3';
                }

                // Attempt to move the file to the temporary folder
                if (is_file($originalPath) && @rename($originalPath, $tempFilePath)) {
                    // File moved successfully, process the file
                    $arrfile2EdoCta = file2EdoCta($tempFilePath, $bc_id, '', 0.00, $b_id, true, $arrCuentas[$ajax_id]);
                    // echo "<pre>tempFilePath: $tempFilePath " . print_r($tempFilePath, true) . "</pre>";

                    // Update bank account ID
                    $arrfile2EdoCtabc_id = $arrfile2EdoCta['bc_id'] ?? '';

                    // Update database if $bc_id is available
                    if (!empty($arrfile2EdoCtabc_id)) {
                        updateBankAccountConciliation($arrfile2EdoCtabc_id);
                    }

                    // Handle errors during file processing
                    if ($arrfile2EdoCta['Status'] !== 'OK') {
                        if ($arrfile2EdoCta['ErrorCode'] === '2') {
                            // Unable to determine the bank account
                            $filename = "RECHAZADO - $filename";
                            $arrfile2EdoCta['Error'] .= generateErrorHtml($filename);
                        }
                    }

                    if($arrfile2EdoCta['ErrorCode'] !== '3') {
                        // Prepare the filename and archive the processed file
                        $filename = prepareFilename($filename, $arrfile2EdoCta, $contentsExt);
                        archiveProcessedFile($tempFilePath, $filename, $gIAParametros);
                    }
                    else{
                        archiveProcessedFile($tempFilePath, $filename, $gIAParametros, $originalPath);
                    }
                    // Collect results based on processing status
                    if (shouldCollectResult($arrfile2EdoCta)) {
                        // Update processed file info in $arrCuentas
                        $arrCuentas[$ajax_id][$k]['processed'] = true;
                        $arrCuentas[$ajax_id][$k]['b_id']     = $b_id;
                        $arrCuentas[$ajax_id][$k]['bc_id']    = $bc_id;

                        // Add additional info to the result
                        $arrfile2EdoCta['arrCuentas'] = $arrCuentas[$ajax_id][$k];
                        $arrfile2EdoCta_IECD[]        = $arrfile2EdoCta;
                    }
                } else {
                    // Could not move the file; it may have been moved by another process
                    continue;
                }

                ia_errores_a_dime();
            }
            catch (Exception $e) {
                ia_errores_a_dime("Error en " . __METHOD__ . " - " . $e->getMessage());
                return "";
            }
        }
        unset($arrCuentas[$ajax_id]); // Remove processed entries
    }

    return $arrfile2EdoCta_IECD;
}

/**
 * Checks if the haystack contains any of the needles (case-insensitive).
 *
 * @param string $haystack The string to search in.
 * @param array  $needles  An array of substrings to search for.
 *
 * @return bool True if any needle is found in the haystack; false otherwise.
 */
function containsAny(string $haystack, array $needles): bool
{
    foreach ($needles as $needle) {
        if (stripos($haystack, $needle) !== false) {
            return true;
        }
    }
    return false;
}

/**
 * Updates the 'ultima_conciliacion' field for the given bank account IDs.
 *
 * @param mixed $bc_id The bank account ID or an array of IDs.
 *
 * @return void
 */
function updateBankAccountConciliation($bc_id): void
{
    $sql = [];
    if (is_array($bc_id)) {
        foreach ($bc_id as $bcid) {
            $sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=" . strit($bcid);
        }
    } else {
        $sql[] = "UPDATE banco_cuenta SET ultima_conciliacion=NOW() WHERE banco_cuenta_id=" . strit($bc_id);
    }
    ia_transaction($sql);
}

/**
 * Generates HTML error message for rejected files.
 *
 * @param string $filename The filename of the rejected file.
 *
 * @return string The generated HTML error message.
 */
function generateErrorHtml(string $filename): string
{
    $escapedFilename = htmlspecialchars($filename, ENT_QUOTES, 'UTF-8');
    return "<br/><span class='txt_color_red bold'>
        <a href='javascript:borrarArchivo(\"{$escapedFilename}\");'>
        <img src='../img/delete.png' alt='Borrar Archivo' title='Borrar Archivo'/></a>
        Archivo: <a href='{$escapedFilename}' target='_blank'>{$escapedFilename}</a>
        </span>";
}

/**
 * Prepares the filename for archiving.
 *
 * @param string $filename        The original filename.
 * @param array  $arrfile2EdoCta  The array containing processing results.
 * @param string $contentsExt     The file extension.
 *
 * @return string The prepared filename.
 */
function prepareFilename(string $filename, array $arrfile2EdoCta, string $contentsExt): string
{
    if (!stripos($filename, 'RECHAZADO')) {
        $bancoCuenta = $arrfile2EdoCta['Cuenta'] ?? '';
        if (strlen($filename) > 15) {
            $filename = substr($filename, 0, 15) . ".$contentsExt";
        }
        $filename = date('Y-m-d H-i-s') . "-{$bancoCuenta}-{$filename}";
    }
    return $filename;
}

/**
 * Archives the processed file to the designated folder.
 *
 * @param string $tempFilePath    The temporary file path.
 * @param string $filename        The filename to use in the archive.
 * @param array  $gIAParametros   Global parameters array.
 *
 * @return void
 */
function archiveProcessedFile(string $tempFilePath, string $filename, array $gIAParametros, $customPath = ''): void
{
    $archiveDir = $gIAParametros['path_archivos_estado_de_cuenta_importados'];
    $archiveDir .= DIRECTORY_SEPARATOR;
    // Ensure the archive directory exists
    if (!is_dir($archiveDir)) {
        mkdir($archiveDir);
    }
    $archivePath = $archiveDir . DIRECTORY_SEPARATOR . $filename;
    $archivePath = empty($customPath) ? $archivePath : $customPath;
    $archivePath = convertAllBackslashesToForwardSlashes($archivePath);
    $tempFilePath = convertAllBackslashesToForwardSlashes($tempFilePath);

    // Move the processed file to the archive folder
    if(is_file($tempFilePath))
        @rename($tempFilePath, $archivePath);
}

/**
 * Determines whether to collect the result based on the processing status.
 *
 * @param array $arrfile2EdoCta The array containing processing results.
 *
 * @return bool True if the result should be collected; false otherwise.
 */
function shouldCollectResult(array $arrfile2EdoCta): bool
{
    $status    = $arrfile2EdoCta['Status'] ?? '';
    $errorCode = $arrfile2EdoCta['ErrorCode'] ?? '';

    return ($status === 'OK' && $errorCode !== '4') || $status === 'Error';
}

//$expectedEmpresaId = es la empresa que calculé con el nombre del archivo.
function checkFileDoesBelongToEnterprise($arrBancoCuentaMov, $expectedEmpresaId, $debug = false) {
    $function_name = __FUNCTION__;
    foreach ($arrBancoCuentaMov as $mov) {
//        echo "<pre>arrBancoCuentaMov _ mov: ".print_r($mov /*$el_array de lo que sea*/,true)."</pre>";
        if (preg_match('/PAGO DE NOMINAIN\s+\d+\s+([A-ZÑ&]+)/', $mov->numero_original, $m)) {
            $detectedNombre = trim($m[1]);
            $realEmpresaSQL = "SELECT * FROM `empresa` WHERE empresa LIKE '%$detectedNombre%' OR razon_social LIKE '%$detectedNombre%' LIMIT 1";
            $realEmpresaArr = ia_singleton($realEmpresaSQL);
//            echo "<pre>$realEmpresaSQL: ".print_r($realEmpresaSQL /*$el_array de lo que sea*/,true)."</pre>";
//            echo "<pre>$realEmpresaArr: ".print_r($realEmpresaArr /*$el_array de lo que sea*/,true)."</pre>";
            // 🔒 Double-check the embedded empresa_id
            $realEmpresaId = $realEmpresaArr['empresa_id'];
            if (empty($realEmpresaId)) {
                return false;
            }

            if ($debug){
                echo "<hr>$function_name:<hr><br>";
                echo "<pre>arrBancoCuentaMov as mov: ".print_r( $mov ,true)."</pre>";
                echo "<pre>realEmpresaId: ".print_r( $realEmpresaId ,true)."</pre>";
                echo "<pre>expectedEmpresaId: ".print_r( $expectedEmpresaId ,true)."</pre>";
                echo "<pre>matches: ".print_r( $m ,true)."</pre>";
                echo "<pre>detectedNombre: ".print_r( $detectedNombre ,true)."</pre>";
                echo "<pre>mov->numero_original: ".print_r( $mov->numero_original ,true)."</pre>";
                echo "<hr>$function_name:<hr><br>";
            }

            if ($realEmpresaId != $expectedEmpresaId) {
                ia_errores_a_dime("❌ File mismatch: Movement labeled as '{$detectedNombre}' (empresa_id={$realEmpresaId}), but expected empresa_id={$expectedEmpresaId}.");
                return false;
            }
        }
    }
    return true;
}