<?php

function actualizaInversionesAtrasadas()
{
    global $gIAParametros;

    $tipo_inversion_empresa_privada = array('empresa', 'privada');

    foreach($tipo_inversion_empresa_privada as $tipo_inv) {

        //Por expirar: mañana expiran.
        $sql1 = "SELECT COUNT(DISTINCT(inversion_id)) FROM inversion
                WHERE (DATEDIFF(solicitud_reembolso_fecha,NOW()) - $gIAParametros[dias_para_solicitar_reembolso_inversion] = 0) AND indefinida <> 'Si' AND capturado = 'Si' AND terminado = 'No' AND (inversion_reembolso_id IS NULL OR inversion_reembolso_id = '') AND tipo_inversion_empresa_privada = '$tipo_inv'";

        //Expirados.
        $sql3 = "SELECT COUNT(DISTINCT(inversion_id)) as ExpUrgente FROM inversion
                WHERE (DATEDIFF(solicitud_reembolso_fecha,NOW()) - $gIAParametros[dias_para_solicitar_reembolso_inversion] < 0) AND indefinida <> 'Si' AND capturado = 'Si' AND terminado = 'No' AND (inversion_reembolso_id IS NULL OR inversion_reembolso_id = '') AND tipo_inversion_empresa_privada = '$tipo_inv'";

        $sql4 = "SELECT COUNT(bloqueado) FROM inversion WHERE bloqueado IN ('MODIFICADO','AMBOSMOD','CONTMOD') AND tipo_inversion_empresa_privada = '$tipo_inv'";
        $sql4 = "SELECT COUNT(bloqueado) FROM inversion WHERE bloqueado IN ('MODIFICADO','AMBOSMOD','CONTMOD') AND terminado = 'No' AND (inversion_reembolso_id = '' OR inversion_reembolso_id IS NULL) AND tipo_inversion_empresa_privada = '$tipo_inv'";
        $sql5 = "SELECT COUNT(error) FROM inversion WHERE error IN ('Si','Pa') AND tipo_inversion_empresa_privada = '$tipo_inv'";
        $sql6 = "SELECT COUNT(capturado) FROM inversion WHERE capturado IN ('No') AND tipo_inversion_empresa_privada = '$tipo_inv'";

        $InvExp = ia_singleread($sql1);

        $InvExpUrg = ia_singleread($sql3);
        $InvBloq = ia_singleread($sql4);
        $InvErr = ia_singleread($sql5);
        $InvCap = ia_singleread($sql6);

        $sql = array();

        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvExp,    'expirados_sin_solicitud',  'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvExp";

        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvExpUrg, 'expirados_urgentes',       'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvExpUrg";
        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvBloq,   'bloqueado',                'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvBloq";
        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvErr,    'error',                    'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvErr";
        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvCap,    'capturado',                'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvCap";

        // JJDPL 13-04-2021
        $sql_ = "SELECT COUNT(bloqueado) FROM inversion WHERE bloqueado IN ('MODIFICADO','AMBOSMOD','CONTMOD') AND terminado = 'Si' AND (inversion_reembolso_id != '' OR inversion_reembolso_id IS NOT NULL) AND tipo_inversion_empresa_privada = '$tipo_inv'";
        $InvModReem = ia_singleread($sql_);
        $sql[] = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $InvModReem, 'modificados_con_reembolso', 'inversion$tipo_inv') ON DUPLICATE KEY UPDATE valor=$InvModReem";

        /**
         * $myFile = "actualizainversionsAtrasados.txt";
         * $fh = fopen($myFile, 'w') or die("can't open file");
         * $bleh = "<pre>".print_r($sql, true)."</pre>";
         * fwrite($fh, $bleh);
         * fclose($fh);
         **/
//        echo "<pre>".print_r($sql, true)."</pre>";

        ia_transaction($sql);
    }
}

/**
 * @param string $bcm_id banco_cuenta_mov_id
 * @return bool
 */
function bcm_retiro_es_inversion($bcm_id = ''){
    $es = false;

    if(empty($bcm_id))
        return $es;

    $es = ia_singleread("SELECT COUNT(*) FROM inversion WHERE banco_cuenta_mov_id = " . strit($bcm_id));

    return $es;
}

/** Genera una descripción y detalle de los links que tiene una inversión.
 * Actualiza los remarks del retiro en el banco, la apertura de inversión y de los reembolsos de inversión.
 * Regresa un array con
 * @param string $inv_id
 * @param string $bcm_id
 * @param bool $do_SQL
 * @param bool $debug
 * @return array
 */
function genera_remarks_retiro_inversion($inv_id = '', $bcm_id = '', $do_SQL = false, $debug = false, $inv_en_DB = array(), $remarks_por_usuario = "")
{
    //@todo cambiar debug por guardar en un archivo (copiar codigo de los repetidos)
    $sql = array();
    $arr_ret = array();

    if(empty($bcm_id) && empty($inv_id))
        return $sql;

    $txt_bcm_id = !empty($bcm_id) ? " OR banco_cuenta_mov_id = " . strit($bcm_id) : "";
    //Traigo la inversión de la BD. La leo con su id con el id del retiro. Están ligados uno a uno.
    $inv_en_DB = empty($inv_en_DB) ? ia_singleton("SELECT * FROM inversion WHERE inversion_id = " . strit($inv_id) . $txt_bcm_id) : $inv_en_DB;

    $vx_remarks = $inv_en_DB['remarks'] ?? '';
    //$vx_remarks = ""; //Bug. no dejamos poner remarks por el momento.

    $vx_remarks = strpos($vx_remarks, "<hr>") !== false ? substr($vx_remarks, 0, strpos($vx_remarks, "<hr>")) : "";

    $bcm_id = empty($bcm_id) ? $inv_en_DB['banco_cuenta_mov_id'] : $bcm_id;
//    $bcm_retiro_en_DB = ia_singleton("SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = " . strit($bcm_id));

    $inv_id = $inv_en_DB['inversion_id'];
//    $bcm_id = $inv_en_DB['banco_cuenta_mov_id'];

    $remarks_aper_inv = "";
    $remarks_inv_links = "";
    $saldo = $inv_en_DB['monto_retiro']; //El capital que retitaron

    //Podemos referirnos a retiro, tanto como al retiro en el banco como al movimiento inversión.
    //Este retiro puede tener 0 o más links de reembolso.

    //En esta llave ponemos los remarks que lleva la apertura de inversión.
    //Que es: la descripción de la inversión más los links que tenga.
    $arr_ret['remarks_aper_inv'][$inv_id] = "";

    $ol = "</ol><ul>";
    $remarks_aper_inv = "APERTURA DE INVERSION" . (strpos($inv_en_DB['referencia_bancaria'],"MANUAL") !== false ? " MANUAL" : "");

    if($inv_en_DB['indefinida'] == 'Si')
    {
        $duracion = $ti_remarks = " INDEFINIDA";
    }
    else
    {
        $duracion = $inv_en_DB['duracion_dias'];
        $fecha_retiro = $inv_en_DB['fecha_retiro'];
        $fecha_expiracion = $inv_en_DB['solicitud_reembolso_fecha'];
        $fecha_expiracion = get_date_spanish(strtotime($fecha_expiracion), false, 'mini_date');
        $duracion = " A $duracion DIAS";
        $ti_remarks = "$duracion. (VENCE EL $fecha_expiracion)";
    }

    $remarks_aper_inv .= $ti_remarks;

    //Banco destino y tasa de interés pactada. Lo agregaremos al título que nos regresa preparaRemarksBCM();
    $remarks_extra = "<span class=\"bold txt12px\">$ti_remarks CON </span><span class=\"txt_bold_blue txt14px\">" . $inv_en_DB['banco_destino'] . "</span>, <span class=\"bold txt12px\">" . ($inv_en_DB['tipo_inversion'] ?? "") ."</span> <span class=\"txt_bold_blue txt14px\">" . echonf($inv_en_DB['tasa_interes_anual'] ?? 0.00, true) ." % </span>";

    $vx_remarks = !empty($vx_remarks) ? "<strong>$vx_remarks</strong><hr>" : "";
    //Leo los links
    $arr_links = ia_sqlArrayIndx("SELECT * FROM inversion_reembolso WHERE activo = 'Si' AND inversion_id = " .strit($inv_id) . " ORDER BY alta_db ASC");
    //echo "<pre>".print_r($arr_links, true)."</pre>";

    $saldo_final_anterior = '';
    $array_remarks_all = [];
    if(!empty($arr_links) && is_array($arr_links)){
        $style = count($arr_links)>1?'border-bottom: 2px dashed black !important;':'';
        $style = 'border-bottom: 2px dashed black !important;';
        foreach($arr_links as $k=>$inv_link_en_DB) {
            //echo "<pre>$k:".print_r($v, true)."</pre>";

            $saldo -= ($inv_link_en_DB['monto_reembolsado'] + $inv_link_en_DB['monto_interes'] - $inv_link_en_DB['monto_isr']);

            if($saldo < 0) {
                $saldo = 0;
            }

            $parcial = "";
            if($saldo == 0)
                $parcial = " TERMINADA";
            else
                $parcial = " PARCIAL";

            $remarks_por_link = '<table class="noborders" style="width: auto; padding: 0; '.$style.'"><tr><td class="noborders row_altura_10px" colspan="2">';

            $txt_inversion = "$" . echonf($inv_link_en_DB['monto_reembolsado'], true);
            $txt_intereses = "$" . echonf($inv_link_en_DB['monto_interes'], true);
            $txt_isr = "$" . echonf($inv_link_en_DB['monto_isr'], true);
            $txt_intereses_real = "$" . echonf($inv_link_en_DB['monto_interes'] - $inv_link_en_DB['monto_isr'], true);

            $parcial .= ( $inv_link_en_DB['monto_reembolsado'] != $inv_en_DB['monto_reembolsado'] ? PHP_EOL . "(". echonf($inv_en_DB['monto_reembolsado'], true) .")" : ""); //VCA Bajar para abajo.


            //Este link nos lleva a inversion_reembolso.php, donde se pueden cancelar los Links de Inversión
            $remarks_por_link .= "<a title=\"Ir al Link de Inversión\" href=\"../backoffice/inversion_reembolso.php?inversion_reembolso_id=$inv_link_en_DB[inversion_reembolso_id]\" target=\"_blank\"><span class=\"link_txt_shadow_black bold txt16px\">LINK DE INVERSIÓN$parcial </span></a></td></tr><tr>";

            $remarks_apertura = genera_remarks_apertura_inversion_sin_titulo($inv_en_DB);
            $saldo_inicial = 0;
            $saldo_final = 0;
            if ($k === 0) {
                $saldo_inicial = $inv_en_DB['monto_retiro'];
            }
            else {
                $saldo_inicial = $saldo_final_anterior;
            }
            $reembolso = $inv_link_en_DB['monto_reembolsado'];
            $interes = $inv_link_en_DB['monto_interes'];
            $interes = '0';
            $saldo_final = bcsub($saldo_inicial, bcadd($reembolso,$interes, 2), 2);
            $saldo_final_anterior = $saldo_final;

            $remarks_apertura.= "<br><span>SALDO INICIAL: <b class='txt14px'>$ ".echonf($saldo_inicial, true)."</b></span>";
            $remarks_apertura.= " | <span>SALDO FINAL: <b class='txt14px'>$ ".echonf($saldo_final, true)."</b></span>";

            $remarks_apertura = str_replace(["txt12px", "txt14px"], ["txt11px", "txt11px"], $remarks_apertura);

            $remarks_por_link .= "<td colspan='2' class='noborders row_altura_10px'>$remarks_apertura</td></tr><tr>";

            $a_dep_reem = "<a title=\"Ir al Depósito en el banco\" href=\"../cobranza/edocta.php?banco_cuenta_id=$inv_link_en_DB[banco_cuenta_id]&banco_cuenta_mov_id=$inv_link_en_DB[banco_cuenta_mov_id]\" target=\"_blank\"><span class=\"link_txt_shadow_azul_marino txt15px\">";
            $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_dep_reem ."DEPÓSITO:</span></a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_dep_reem$". echonf($inv_link_en_DB['monto_global_reembolso'], true) ."</span></a></td></tr><tr>";

            $a_todo_a_banco = "<a title=\"Ir a Todo al Banco\" href=\"../backoffice/todo_a_banco_list.php?cuentat_a_banco_id=$inv_link_en_DB[inversion_reembolso_id]\" target=\"_blank\"><span class=\"txt_bold_red txt15px\">";

            // $label_para_inversion = 'INVERSIÓN';
            $label_para_inversion = 'REEMBOLSO';
            $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_todo_a_banco ."$label_para_inversion:</span></a></td><td class=\"txt_right_aligned noborders row_altura_10px\"><span class=\"txt_bold_red txt15px\">$a_todo_a_banco$txt_inversion</span></a></td></tr><tr>";

            $a_aper_inver = "<a title=\"Ir a la apertura de inversión\" href=\"../backoffice/inversion_list.php?inversion_id=$inv_en_DB[inversion_id]\" target=\"_blank\"><span class=\"link_txt_shadow_naranja txt15px\">";
            $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_aper_inver ."INTERÉS:</a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_aper_inver$txt_intereses</span></a></td></tr>";

            $a_isr = "<a title=\"Ir a la apertura de inversión\" href=\"../backoffice/inversion_list.php?inversion_id=$inv_en_DB[inversion_id]\" target=\"_blank\"><span class=\"txt_bold_orange txt15px\">";
            // $remarks_por_link .= "<tr><td class=\"txt_left_aligned noborders row_altura_10px\">". $a_isr . "ISR:</span></a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_isr$txt_isr</span></a></td></tr>";

            $a_interes_real = "<a title=\"Ir al retiro del banco\" href=\"../backoffice/withdrawals_de_banco_list.php?bc_mov_id=$inv_en_DB[banco_cuenta_mov_id]\" target=\"_blank\"><span class=\"txt_bold_purple txt15px\">";
            // $remarks_por_link .= "<tr><td class=\"txt_left_aligned noborders row_altura_10px\">". $a_interes_real . "INT. REAL:</a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_interes_real$txt_intereses_real</span></a></td></tr>";

            $remarks_por_link.="</table>";

            $remarks_inv_links .= $remarks_por_link . PHP_EOL;
            $arr_ret['remarks_inv_links'][$inv_link_en_DB['inversion_reembolso_id']] = $remarks_por_link;

            $array_remarks_all[] = $remarks_por_link.PHP_EOL;

            $inv_link_ND = ['remarks' => $remarks_por_link];
            $sql_inv_link_remarks = haz_update_con_log($inv_link_ND, $inv_link_en_DB, "inversion_reembolso", "inversion_reembolso_id", $inv_link_en_DB['inversion_reembolso_id']);

            if(is_array($sql_inv_link_remarks) && !empty($sql_inv_link_remarks))
                foreach($sql_inv_link_remarks as $ilr)
                    $sql[] = $ilr;
        }

        $remarks_ok = array();

//        preparaRemarksBCM($bcm_id, $remarks_aper_inv . PHP_EOL . $remarks_inv_links, "", "", $remarks_ok, true, false);

        //Buscamos si quedó terminada y cambiamos {VENCE} por VENCIÓ o dejamos VENCE
//        if (strpos($remarks_ok['titulo'], "TERMINADA") !== false)
//            $remarks_extra = str_replace("{VENCE}", "VENCIÓ", $remarks_extra);
//        else
//            $remarks_extra = str_replace("{VENCE}", "VENCE", $remarks_extra);
        //echo "<pre>remarks_ok".print_r($remarks_ok, true)."</pre>";

//        $remarks_aper_inv = $remarks_ok['titulo'] . $remarks_extra . PHP_EOL . $remarks_inv_links;



        /*echo "<br>=====================================================<br>";
        echo $remarks_aper_inv;*/
        //echo $arr_return['remarks'];


    }
//    else{
        //if(empty($arr_links))
        // $remarks_aper_inv = genera_remarks_apertura_inversion($inv_en_DB);
//    }

    $remarks_inv_links = implode("",array_reverse($array_remarks_all));
    $remarks_aper_inv = "";

    $remarks_aper_inv .= PHP_EOL . $remarks_inv_links . genera_remarks_apertura_inversion($inv_en_DB);

    $remarks_aper_inv = "$vx_remarks<div style='width: 300px;'>" . $remarks_aper_inv . "</div>";

    $arr_ret['remarks_aper_inv'][$inv_id] = $remarks_aper_inv;
    $arr_ret['remarks_retiro_inv'][$bcm_id] = $remarks_aper_inv;

    $poliza_contabilidad = genera_poliza_contabilidad_inversion($inv_en_DB);

    $bcm_inv_ret_ND = ['remarks' => $remarks_aper_inv, 'poliza_contabilidad' => $poliza_contabilidad];
    $bcm_inv_ret_enDB = array();
    $sql_bcm_inv_ret_remarks = haz_update_con_log($bcm_inv_ret_ND, $bcm_inv_ret_enDB, "banco_cuenta_mov", "banco_cuenta_mov_id", $bcm_id);

    if(is_array($sql_bcm_inv_ret_remarks) && !empty($sql_bcm_inv_ret_remarks))
        foreach($sql_bcm_inv_ret_remarks as $r)
            $sql[] = $r;

    $aper_inv_ret_ND = ['remarks' => $remarks_aper_inv];
    $aper_inv_ret_enDB = array();
    $sql_aper_inv_ret_remarks = haz_update_con_log($aper_inv_ret_ND, $aper_inv_ret_enDB, "inversion", "inversion_id", $inv_id);

    if(is_array($sql_aper_inv_ret_remarks) && !empty($sql_aper_inv_ret_remarks))
        foreach($sql_aper_inv_ret_remarks as $q)
            $sql[] = $q;


    $arr_ret['sql'] = $sql;
//    $arr_ret['remarks_aper_inv'] = $remarks_aper_inv;

    if($do_SQL)
        if(ia_transaction($sql))
            ia_errores_a_dime();


    return $arr_ret;

}

/** Genera una descripción y detalle de la apertura de inversión.
 * @param array $inv_en_DB
 * @param bool $con_titulo
 * @return string
 */
function genera_remarks_apertura_inversion(array $inv_en_DB = array(), bool $con_titulo = true): string
{

    $remarks_aper_inv = "";

    if(empty($inv_en_DB))
        return $remarks_aper_inv;

    $inv_en_DB['indefinida'] = $inv_en_DB['indefinida'] ?? 'Si';
    $inv_en_DB['tasa_interes_anual'] = $inv_en_DB['tasa_interes_anual'] ?? 0;
    $inv_en_DB['tipo_inversion'] = $inv_en_DB['tipo_inversion'] ?? '';
    $inv_en_DB['solicitud_reembolso_fecha'] = $inv_en_DB['solicitud_reembolso_fecha'] ?? '';
    $inv_en_DB['duracion_dias'] = $inv_en_DB['duracion_dias'] ?? 0;


    $remarks_aper_inv = "<strong class='txt18pxfr txt_bold_red txt_centered' style='min-width: 335px;'>APERTURA DE INVERSIÓN CON ALTA</strong>";

    if (!$con_titulo)
        $remarks_aper_inv = "";

    $remarks_aper_inv .= "<br><b class='txt11px'>Fecha Retiro: </b>$inv_en_DB[fecha_retiro]";

    if($inv_en_DB['indefinida'] == 'Si')
    {
        $ti_remarks = "INDEFINIDA";
    }
    else
    {
        $duracion = $inv_en_DB['duracion_dias'] ?? 0;
        $fecha_expiracion = $inv_en_DB['solicitud_reembolso_fecha'] ?? '';
        $fecha_expiracion = empty($fecha_expiracion) ? '' : get_date_spanish(strtotime($fecha_expiracion), false, 'mini_date');
        $duracion = empty($duracion) ? '' : " A $duracion DIAS";
        $ti_remarks = empty($duracion) ? '' : "$duracion. (VENCE EL $fecha_expiracion)";
    }
    if ($con_titulo)
        $remarks_aper_inv .= PHP_EOL;

    //Banco destino y tasa de interés pactada. Lo agregaremos al título que nos regresa preparaRemarksBCM();
    $remarks_extra = "<a href='../backoffice/inversion_list.php?inversion_id=" . $inv_en_DB['inversion_id'] ."' target='_blank'><span class=\"bold txt12px\">$ti_remarks CON </span><span class=\"txt_bold_blue txt14px\">" . $inv_en_DB['banco_destino'] . "</span>, <span class=\"bold txt12px\">" . $inv_en_DB['tipo_inversion'] ."</span> <span class=\"txt_bold_blue txt14px\">" . echonf($inv_en_DB['tasa_interes_anual'], true) ." % </span></a>";

    //Monto de la inversión y su saldo
    $monto_retiro = $inv_en_DB['monto_retiro'];
    $saldo = $inv_en_DB['monto_retiro'] - ($inv_en_DB['monto_reembolsado'] ?? 0);

    $remarks_extra .= "<br><span class=\"txt14px\">INVERSIÓN ORIGINAL </span> <span class=\"bold txt14px\">$ " . echonf($monto_retiro, true) . "</span> , <span class=\"txt14px\">SALDO </span> <span class=\"txt14px\">$ " . echonf($saldo, true) . "</span>" . PHP_EOL;

    return $remarks_aper_inv . $remarks_extra;

}
/** Genera una genera_poliza_contabilidad_inversion de la apertura de inversión.
 * @param array $inv_en_DB
 * @param bool $con_titulo
 * @return string
 */
function genera_poliza_contabilidad_inversion(array $inv_en_DB = array()): string
{

    $poliza_contabilidad = "";

    if(empty($inv_en_DB))
        return $poliza_contabilidad;

    $monto_retiro = echonf($inv_en_DB['monto_retiro'], true);

    $banco_destino = $inv_en_DB['banco_destino'] ?? '';
    if($banco_destino == "BBVA")
        $banco_destino = "BBVA MÉXICO SA";
    elseif($banco_destino == "MONEX")
        $banco_destino = "MONEX GRUPO FINANCIERO SA DE CV";
    elseif($banco_destino == "HSBC")
        $banco_destino = "HSBC MÉXICO SA";

    $poliza_contabilidad = $banco_destino . "****" . PHP_EOL . PHP_EOL;
    $poliza_contabilidad .= "MONTO DE LA INVERSION: $ $monto_retiro" . PHP_EOL;
    $inv_fecha_retiro = fecha_en_espanol($inv_en_DB['fecha_retiro']);
    $poliza_contabilidad .= "FECHA DE RETIRO: " . $inv_fecha_retiro . PHP_EOL;
    $monto_reembolsado = ($inv_en_DB['monto_reembolsado'] ?? 0) + ($inv_en_DB['monto_interes'] ?? 0);
    if($monto_reembolsado > 0){
        $monto_reembolsado = echonf($monto_reembolsado, true);
        $inv_fecha_reembolsado = fecha_en_espanol($inv_en_DB['fecha_reembolsado']);
        $poliza_contabilidad .= "DEVOLUCIÓN: $ $monto_reembolsado" . PHP_EOL;
        $poliza_contabilidad .= "FECHA DE DEVOLUCIÓN: $inv_fecha_reembolsado" . PHP_EOL;
    }

    return trim($poliza_contabilidad);

}

function genera_remarks_apertura_inversion_sin_titulo($inv_en_DB = array()): string
{

    $remarks_aper_inv = "";

    if(empty($inv_en_DB))
        return $remarks_aper_inv;

    $inv_en_DB['indefinida'] = $inv_en_DB['indefinida'] ?? 'Si';
    $inv_en_DB['tasa_interes_anual'] = $inv_en_DB['tasa_interes_anual'] ?? 0;
    $inv_en_DB['tipo_inversion'] = $inv_en_DB['tipo_inversion'] ?? '';
    $inv_en_DB['solicitud_reembolso_fecha'] = $inv_en_DB['solicitud_reembolso_fecha'] ?? '';
    $inv_en_DB['duracion_dias'] = $inv_en_DB['duracion_dias'] ?? 0;


    $remarks_aper_inv = "<a href='../backoffice/inversion_list.php?inversion_id=" . $inv_en_DB['inversion_id'] ."' target='_blank' style='text-decoration: none' class='txt11px grid_tooltip_' title='Ir a la inversión'><b class='txt11px'>Fecha Retiro: </b>$inv_en_DB[fecha_retiro]<br>";

    if($inv_en_DB['indefinida'] == 'Si')
    {
        $ti_remarks = "INDEFINIDA";
    }
    else
    {
        $duracion = $inv_en_DB['duracion_dias'] ?? 0;
        $fecha_expiracion = $inv_en_DB['solicitud_reembolso_fecha'] ?? '';
        $fecha_expiracion = empty($fecha_expiracion) ? '' : get_date_spanish(strtotime($fecha_expiracion), false, 'mini_date');
        $duracion = empty($duracion) ? '' : " A $duracion DIAS";
        $ti_remarks = empty($duracion) ? '' : "$duracion. (VENCE EL $fecha_expiracion)";
    }

    //Banco destino y tasa de interés pactada. Lo agregaremos al título que nos regresa preparaRemarksBCM();
    $remarks_extra = "<span class=\"bold txt12px\">$ti_remarks CON </span><span class=\"txt_bold_blue txt14px\">" . $inv_en_DB['banco_destino'] . "</span>, <span class=\"bold txt12px\">" . $inv_en_DB['tipo_inversion'] ."</span> <span class=\"txt_bold_blue txt14px\">" . echonf($inv_en_DB['tasa_interes_anual'], true) ." % </span>";

    //Monto de la inversión y su saldo
    $monto_retiro = $inv_en_DB['monto_retiro'];
    $saldo = $inv_en_DB['monto_retiro'] - ($inv_en_DB['monto_reembolsado'] ?? 0);

    $remarks_extra .= "<br><span class=\"txt14px\">INVERSIÓN ORIGINAL </span> <span class=\"bold txt14px\">$ " . echonf($monto_retiro, true) . "</span>"; //.", <span class=\"txt14px\">SALDO </span> <span class=\"txt14px\">$ " . echonf($saldo, true) . "</span>" . PHP_EOL;

    /*$saldo_inicial = 0;
    $saldo_final = 0;
    $inv_link_en_DB = $arr_links[$index];
    if ($index === 0) {
        $saldo_inicial = $monto_retiro;
    }
    else {
    }
    $reembolso = $inv_link_en_DB['monto_reembolsado'];
    $intereses = $inv_link_en_DB['monto_interes'];
    $saldo_final = $saldo_inicial - ($reembolso+$intereses);
    $remarks_extra .= "<span class=\"txt14px\">Saldo Inicial </span> <span class=\"bold txt14px\">$ " . echonf($saldo_inicial, true) . "</span> , <span class=\"txt14px\">Saldo Final </span> <span class=\"txt14px\">$ " . echonf($saldo_final, true) . "</span></a>" . PHP_EOL;*/

    return $remarks_aper_inv . $remarks_extra;

}

/**
 * Genera los remarks de las inversiones pagadas con un depósito. Genera la consulta SQL y puede o no ejecutarla.
 *
 * @param string $bcm_id banco_cuenta_mov_id del del depósito que pagó la inversión.
 * @param bool $do_SQL
 * @param bool $debug
 * @return array $arr_return = array('remarks'=>'','sql'=>'','inv_link_remarks'=>array());
 */
function genera_remarks_reembolso_inversion(string $bcm_id = '', bool $do_SQL = false, bool $debug = false): array
{
    //@todo cambiar debug por guardar en un archivo (copiar codigo de los repetidos)
    $sql = array();
    $arr_ret = array();

    if(empty($bcm_id))
        return $sql;

     $preQuery= "SELECT COUNT(*) FROM inversion_reembolso WHERE activo='Si' AND banco_cuenta_mov_id = " . strit($bcm_id);
    $cntReembolso = ia_singleread($preQuery);
    // -- $inv_en_DB = ia_singleton("SELECT * FROM inversion WHERE inversion_id = " . strit($inv_id) . " OR banco_cuenta_mov_id = " . strit($bcm_id));
    if($cntReembolso == 0){
        return $arr_ret;
    }

    $bcm_reembolso_en_DB = ia_singleton("SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = " . strit($bcm_id));

    $bcm_id = $bcm_reembolso_en_DB['banco_cuenta_mov_id'];

    $remarks_reembolso_inv = "";
    $remarks_inv_links = "";

    //Podemos referirnos a retiro, tanto como al retiro en el banco como al movimiento inversión.
    //Este retiro puede tener 0 o más links de reembolso.

    //En esta llave ponemos los remarks que lleva la apertura de inversión.
    //Que es: la descripción de la inversión más los links que tenga.
    $arr_ret['remarks_reembolso_inv'][$bcm_id] = "";

    //Leo los links de este depósito $bcm_id
    $select = "SELECT * FROM inversion_reembolso WHERE activo = 'Si' AND banco_cuenta_mov_id = " .strit($bcm_id) . " ORDER BY alta_db ASC";
    $arr_links = ia_sqlArrayIndx($select);

    // dd_($select, array_column($arr_links, 'inversion_reembolso_id'),  $links_por_inversion);

    $remarks_inv_links = "";
    $saldo_final_anterior = '';
    $array_remarks_all = [];
    $divider = "<div style='display: block;border-bottom: 3px solid red;'></div>".PHP_EOL;
    if(!empty($arr_links) && is_array($arr_links)) {
        $links_por_inversion = objetivisa_($arr_links, 'inversion_id');
        if (count($links_por_inversion)==1)
            $divider = '';
        foreach ($links_por_inversion as $i => $links) {
            $style = count($links)>1?'border-bottom: 2px dashed black !important;':'';
            foreach($links as $k=>$inv_link_en_DB) {
                //echo "<pre>$k:".print_r($v, true)."</pre>";

                $remarks_por_link = "";
                //Leemos la inversión de este link de reembolso $inv_link_en_DB
                $inv_en_DB = ia_singleton("SELECT * FROM inversion WHERE inversion_id = " . strit($inv_link_en_DB["inversion_id"]));
                //El saldo es el monto de la apertura de inversión (el capital que invertimos)
                $saldo = $inv_en_DB['monto_retiro'];

                //Restamos del saldo, el monto del capital retornado, el interés y sumamos el ISR. Por ejemplo, invertimos 1000. Nos regresaron 1000 (capital) + 200 (interés) - 100 (ISR). Nos regresaron 1100, e invertimos 1000. El saldo será -100. Quiere decir que al menos nos regresaron el capital y 100 pesos más. La inversión quedó pagada.
                $saldo -= ($inv_link_en_DB['monto_reembolsado'] + $inv_link_en_DB['monto_interes'] - $inv_link_en_DB['monto_isr']);

                if($saldo < 0) {
                    $saldo = 0;
                }

                $parcial = "";
                if($saldo == 0)
                    $parcial = " TERMINADA";
                else
                    $parcial = " PARCIAL";

                /*$style = count($links)>1?'border-bottom: 2px dashed black !important;':'';
                $style = 'border-bottom: 2px dashed black !important;';*/

                $remarks_por_link = '<table class="noborders" style="width: auto; padding: 0; '.$style.'"><tr><td class="noborders row_altura_10px" colspan="2">';

                $txt_inversion = "$" . echonf($inv_link_en_DB['monto_reembolsado'], true);
                $txt_intereses = "$" . echonf($inv_link_en_DB['monto_interes'], true);
                $txt_isr = "$" . echonf($inv_link_en_DB['monto_isr'], true);
                $txt_intereses_real = "$" . echonf($inv_link_en_DB['monto_interes'] - $inv_link_en_DB['monto_isr'], true);

                $parcial .= ( $inv_link_en_DB['monto_reembolsado'] != $inv_en_DB['monto_reembolsado'] ? PHP_EOL . "(". echonf($inv_en_DB['monto_reembolsado'], true) .")" : ""); //VCA Bajar para abajo.


                //Este link nos lleva a inversion_reembolso.php, donde se pueden cancelar los Links de Inversión
                $remarks_por_link .= "<a title=\"Ir al Link de Inversión\" href=\"../backoffice/inversion_reembolso.php?inversion_reembolso_id=$inv_link_en_DB[inversion_reembolso_id]\" target=\"_blank\"><span class=\"link_txt_shadow_black bold txt16px\">LINK DE INVERSIÓN$parcial </span></a></td></tr><tr>";

                $remarks_apertura = genera_remarks_apertura_inversion_sin_titulo($inv_en_DB);
                $saldo_inicial = 0;
                $saldo_final = 0;
                if ($k === 0) {
                    $saldo_inicial = $inv_en_DB['monto_retiro'];
                }
                else {
                    $saldo_inicial = $saldo_final_anterior;
                }
                $reembolso = $inv_link_en_DB['monto_reembolsado'];
                $interes = $inv_link_en_DB['monto_interes'];
                $interes= '0';
                $saldo_final = bcsub($saldo_inicial, bcadd($reembolso,$interes, 2), 2);
                $saldo_final_anterior = $saldo_final;

                $remarks_apertura.= "<br><span>SALDO INICIAL: <b class='txt14px'>$ ".echonf($saldo_inicial, true)."</b></span>";
                $remarks_apertura.= " | <span>SALDO FINAL: <b class='txt14px'>$ ".echonf($saldo_final, true)."</b></span>";

                $remarks_apertura = str_replace(["txt12px", "txt14px"], ["txt11px", "txt11px"], $remarks_apertura);
                $remarks_por_link .= "<td colspan='2' class='noborders row_altura_10px'>$remarks_apertura</td></tr><tr>";

                $a_dep_reem = "<a title=\"Ir al Depósito en el banco\" href=\"../cobranza/edocta.php?banco_cuenta_id=$inv_link_en_DB[banco_cuenta_id]&banco_cuenta_mov_id=$inv_link_en_DB[banco_cuenta_mov_id]\" target=\"_blank\"><span class=\"link_txt_shadow_azul_marino txt15px\">";
                $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_dep_reem ."DEPÓSITO:</span></a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_dep_reem$". echonf($inv_link_en_DB['monto_global_reembolso'], true) ."</span></a></td></tr><tr>";

                $a_todo_a_banco = "<a title=\"Ir a Todo al Banco\" href=\"../backoffice/todo_a_banco_list.php?cuentat_a_banco_id=$inv_link_en_DB[inversion_reembolso_id]\" target=\"_blank\"><span class=\"txt_bold_red txt15px\">";
                $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_todo_a_banco ."REEMBOLSO:</span></a></td><td class=\"txt_right_aligned noborders row_altura_10px\"><span class=\"txt_bold_red txt15px\">$a_todo_a_banco$txt_inversion</span></a></td></tr><tr>";

                $a_aper_inver = "<a title=\"Ir a la apertura de inversión\" href=\"../backoffice/inversion_list.php?inversion_id=$inv_en_DB[inversion_id]\" target=\"_blank\"><span class=\"link_txt_shadow_naranja txt15px\">";
                $remarks_por_link .= "<td class=\"txt_left_aligned noborders row_altura_10px\">". $a_aper_inver ."INTERÉS:</a></td><td class=\"txt_right_aligned noborders row_altura_10px\">$a_aper_inver$txt_intereses</span></a></td></tr>";

                $remarks_por_link .= "</table>";

                $remarks_inv_links .= $remarks_por_link . PHP_EOL;
                $arr_ret['remarks_inv_links'][$inv_link_en_DB['inversion_reembolso_id']] = $remarks_por_link;

                $is_last = count($links)===($k+1);
                $array_remarks_all[] = $remarks_por_link . PHP_EOL . ($is_last?$divider:'');
            }
        }
    }


    $remarks_inv_links = implode("",array_reverse($array_remarks_all));

    $arr_ret['remarks_reembolso_inv'][$bcm_id] = $remarks_inv_links;

    /*echo "<br>=====================================================<br>";
    echo $remarks_inv_links;*/


    $bcm_inv_ret_ND = ['remarks' => $remarks_inv_links];
    $bcm_inv_ret_enDB = array();
    $sql_bcm_inv_ret_remarks = haz_update_con_log($bcm_inv_ret_ND, $bcm_inv_ret_enDB, "banco_cuenta_mov", "banco_cuenta_mov_id", $bcm_id);


    if(is_array($sql_bcm_inv_ret_remarks) && !empty($sql_bcm_inv_ret_remarks))
        foreach($sql_bcm_inv_ret_remarks as $q)
            $sql[] = $q;

    $arr_ret['sql'] = $sql;

    if($do_SQL)
        if(ia_transaction($sql))
            ia_errores_a_dime();


    return $arr_ret;

}