<?php
function tablaid($tabla)
{
    return ia_singleread("SELECT tabla_id FROM tablas WHERE tabla = ". strit($tabla));
}

function kvTablaID($tabla)
{
    return tablaid($tabla);
}

function kvAccionID($accion)
{
    return ia_singleread("SELECT kv_accion_log_id FROM kv_accion_log WHERE accion = ". strit($accion));
}

function kvRenglon($campo='',$valor='',$anterior='')
{
    return array('campo'=>$campo,'valor'=>$valor,'anterior'=>$anterior);
}

function kvTabla($arrCampos=array())
{
    $html = '';
    if(!empty($arrCampos) && is_array($arrCampos))
    {
        $html = "<table style=\"width:100%;\"><thead><tr><th style=\"width:25%;\" class=\"lbl\">Campo</th><th style=\"width:40%;\" class=\"lbl\">Valor Nuevo</th><th style=\"width:35%;\" class=\"lbl\">Valor Anterior</th></tr><tr><td colspan=\"3\"><hr/></td></tr></thead><tbody>";
        foreach($arrCampos as $campo)
        {
            $html.="<tr><td class=\"txt_bold_black\">$campo[campo]</td><td class=\"txt_bold_red\">$campo[valor]</td><td class=\"txt_bold_black\">$campo[anterior]</td></tr>";
        }
        $html .= "</tbody><tfoot><tr><td colspan=\"3\">&nbsp;</td></tr></tfoot></table>";
    }

    return $html;
}

function kvLogDefault()
{
    return array('kv_record_log' => null, 'collection_id' => '', 'record_id' => '', 'alta_db' => '', 'usuario' => '', 'kv_accion_log_id' => '', 'note' => '');
}

function kvLogInsert($arrCampos=array())
{
    $arrCampos['kv_record_log'] = null;
    return ia_insert('kv_record_log', $arrCampos);
}

function Logme($tabla = '', $record_id = '', $usuario = '', $accion_id = '', $note = '')
{
    $collection = tablaid($tabla);
    $logsql = "INSERT INTO kv_record_log (kv_record_log, collection_id, record_id, alta_db, usuario, kv_accion_log_id, note) VALUES (NULL, $collection, '$record_id', NULL, '$usuario', '$accion_id', '$note')";
    return !ia_query($logsql,true,false);
}

function haz_insert_con_log($arrPar = array('collection_id'=>'', 'record_id'=>'', 'accion'=>'alta', 'enDB'=>'', 'enND'=>'')): string
{
    $usuario = $_SESSION['usuario'];
    $now = date('Y-m-d H:i:s');
    /** Ultimo movimiento en deposita_en **/
    $kv_log_arr = kvLogDefault();
    $kv_log_arr['collection_id'] = kvTablaID($arrPar['collection_id']);
    $kv_log_arr['record_id'] = $arrPar['record_id'];
    $kv_log_arr['alta_db'] = $now;
    $kv_log_arr['usuario'] = $usuario;
    $kv_log_arr['kv_accion_log_id'] = kvAccionID($arrPar['accion']);
    $kv_log_arr['note'] = genera_html_kv_tabla_para_insert($arrPar['enDB']);


    return kvLogInsert($kv_log_arr);
    /** ***********************************/
}
function genera_array_kv_log($app_name, $bcm_enDB): array
{
    $app_name = "app_" . $app_name;
    $app = new $app_name;
    $modo = 'R/O';

    $bcm_enDB_log = [];

    foreach ($bcm_enDB as $k => $v) {
        $bcm_enDB_log[] = kvRenglon($app->label_field($k),
            $app->display($k, array(), $v, $modo, false, 'log'),
            $app->display($k, array(), $endb[$k] ?? '', $modo, false, 'log'));
    }

    return $bcm_enDB_log;
}

function genera_html_kv_tabla_para_insert($arrCampos=array()): string
{
    $html = '';
    if(!empty($arrCampos) && is_array($arrCampos))
    {
        $html = "<table style=\"width:100%;\"><thead><tr><th style=\"width:25%;\" class=\"lbl bold\">Campo</th><th style=\"width:75%;\" class=\"lbl bold\">Valor Nuevo</th><hr/></td></tr></thead><tbody>";
        foreach($arrCampos as $campo)
        {
            $html.="<tr><td class=\"txt_bold_black\">$campo[campo]</td><td class=\"txt_shadow_blue\" style=\"font-weight: normal !important;\">$campo[valor]</td></tr>";
        }
        $html .= "</tbody><tfoot><tr><td colspan=\"2\">&nbsp;</td></tr></tfoot></table>";
    }

    return $html;
}

/**
 * @param array $arr_ND Array con los datos nuevos.
 * @param array $arr_en_DB Array con los datos en la DB.
 * @param string $table tabla
 * @param string $pk_field campo id
 * @param string $id id del registro
 * @param array $arr_diff Array con los datos distintos.
 * @param bool $hacer_bitacora Genera o no la bitacora
 * @return array $sql
 */
function haz_update_con_log(&$arr_ND = array(), &$arr_en_DB = array(), $table = '', $pk_field = '', $id = '', &$arr_diff = array(), $hacer_bitacora = true)
{
    $sql = array();
    if(empty($arr_ND) || !is_array($arr_ND) || empty($table) || empty($pk_field) || empty($id) )
        return $sql;

    if(empty($arr_en_DB))
    {
        if(empty($table))
            return $sql;

        $arr_en_DB = ia_singleton("SELECT * FROM $table WHERE $pk_field=".strit($id));
        if(empty($arr_en_DB))
            return $sql;
    }

    $usuario = isset($_SESSION['usuario']) ? $_SESSION['usuario'] : 1;
    $now = date('Y-m-d H:i:s');

    ksort($arr_ND);
    ksort($arr_en_DB);
    //$arr_diff = array();
    $arr_log = array();
    compara2Arrays($arr_ND, $arr_en_DB, array(), true, $arr_diff, $arr_log, $table);

//echo "<pre>".print_r($arr_diff, true)."</pre>";


    $kv_log_arr = kvLogDefault();
    $kv_log_arr['alta_db'] = $now;
    $kv_log_arr['usuario'] = $usuario;

    if (!empty($arr_diff)) {
        $arr_diff['ultimo_cambio'] = $now;
        $arr_diff['ultimo_cambio_por'] = $usuario;
        $sql[] = ia_update($table, $arr_diff, " $pk_field=".strit($id));
        $kv_log_arr['collection_id'] = kvTablaID($table);
        $kv_log_arr['record_id'] = $id;
        $kv_log_arr['kv_accion_log_id'] = kvAccionID('Editar');
        $kv_log_arr['note'] = kvTabla($arr_log);

        if($hacer_bitacora)
            $sql[] = kvLogInsert($kv_log_arr);
    }

    return $sql;
}
