<?php

/**
 * SolicitaLinkBancario()
 *
 * @param   $arrMovData = array con los datos del movimiento: A Cuenta o Cuenta T.
 *          $arrMovData['link'] = ID del movimiento. OBLIGATORIO.
 *          $arrMovData['link_to'] = Desde donde se hace el link, nombre de la tabla. OBLIGATORIO.
 *          $arrMovData['tienda_id'] = tienda del movimiento. OBLIGATORIO.
 *          $arrMovData['withdrawal'] = withdrawal. Del movimiento bancario.
 *          $arrMovData['deposit'] = deposit. Del movimiento bancario.
 *          $arrMovData['cash'] = cash. Del movimiento bancario.
 *          $arrMovData['monto_acta'] = monto del a cuenta. Especial para link parcial. Si no pones éste o es cero, se asume que quieres Link Total.
 *          $arrMovData['fecha'] = fecha del movimiento bancario. En formato mysql: AAAA-MM-DD. OBLIGATORIO.
 *          $arrMovData['banco_mov_tipo_id'] = tipo de movimiento bancario, por ej. Transferencia, Efectivo, pago con tarjeta de credito, etc.
 *          $arrMovData['banco_cuenta_id'] = La cuenta bancaria. OBLIGATORIO.
 *          $arrMovData['idex100'] = Porcentaje de Comisión, si aplica.
 *          $arrMovData['idetotal'] = (idemonto)Monto de Comisión, si aplica. //No existe la columna. Tal vez en el futuro lo hagamos 11-Feb-2013. Ya existe la columna 01-05-2014.
 *          $arrMovData['factura'] = Concepto del a cuenta: FACTURA, MST, FACTURA PENDIENTE, DEVOLUCION
 *          $arrMovData['ivacobradox100'] = % de IVA cobrado.
 *          $arrMovData['ivacobradototal'] = Monto de IVA cobrado.
 *          $arrMovData['empresa_id'] = Empresa a la que pertenece la cuenta (puede no ser así)
 *          $arrMovData['factura_numero'] = Número de la factura
 *          $arrMovData['cash_nota_num'] = Número de CASH, NOTA, OTRO.
 *          $arrMovData['cliente'] = Cliente que hizo el pago.
 *          $arrMovData['tienda_id'] = Tienda a la que pertenece el pago.
 *          $arrMovData['tipo_cash_nota'] = Tipo de Venta: CASH, NOTA, OTRO.
 *          $arrMovData['cobra_iva'] = Bandera para saber si no se cobró IVA por especificación de quien registró la venta.
 *          $arrMovData['cash_num_cobro_iva'] = Número de CASH en que se cobró el IVA.
 *          $arrMovData['banco_cuenta_mov_id'] = ID del movimiento bancario al que se quiere hacer LINK. Esto es sólo para Link de TC.
 *          $arrMovData['origen_moneda_id'] = Moneda de la cuenta origen. Link entre cuentas con distinta moneda.
 *          $arrMovData['destino_moneda_id'] = Moneda de la cuenta destino. Link entre cuentas con distinta moneda.
 *          $arrMovData['monto_origen'] = Monto de la cuenta origen. Link entre cuentas con distinta moneda.
 *          $arrMovData['monto_destino'] = Monto de la cuenta destino. Link entre cuentas con distinta moneda.
 *          $arrMovData['tipo_cambio'] = Tipo de cambio. Link entre cuentas con distinta moneda.
 *          $arrMovData['ajusta_ctat'] = Para saber si afecta cuentat (inversiones).
 *              ##23-JUL-2018 También para Links, cuando hay multiples depósitos de la misma cantidad y fecha.
 * @param   $usuario = nick del usuario;
 * @return  array $arrInfoLink['vale_acta'] = true o false, dependiendo si el link fue exitoso o no.
 *          $arrInfoLink['mensaje'] = descripción del error. En link exitoso, va en blanco. En error una explicación del por qué no se hizo.
 *          $arrInfoLink['link_id'] = equivalente al anterior $banco_cuenta_mov_link_id = UUID del link del movimiento bancario, si el link fue exitoso. False si no se hizo el link.
 */

function SolicitaLinkBancario($arrMovData, $usuario, $doLink='SI', $ghost_mov = []): array
{

    global $gIAsql;
    global $gIAParametros;

    $fn = " /** SolicitaLinkBancario **/ ";

    $gIAsql['trace']=true;
    $sql=array();
    $sqlstr='';

    //Declaramos el array que vamos a regresar
    $arrInfoLink = array (	"vale_acta" =>	"",
        "mensaje"   =>	"",
        "link_id"	=>	"",
        "ref_num"   =>  "",
        "deposit_fecha"   =>  "");

    if(empty($usuario) || is_numeric($usuario))
        $usuario = $_SESSION['usuario'];

    //Verificamos que nos hayan mandado los parametros bien.
    if(!array_key_exists('link', $arrMovData) || !array_key_exists('link_to', $arrMovData) || !array_key_exists('tienda_id', $arrMovData) || !array_key_exists('banco_cuenta_id', $arrMovData) || !array_key_exists('fecha', $arrMovData))
    {
        $arrInfoLink['vale_acta'] = false;
        $arrInfoLink['mensaje'] = "DATOS INCOMPLETOS PARA HACER EL LINK.";
        $arrInfoLink['link_id'] = false;
        return $arrInfoLink;
    }

    if(empty($arrMovData['idex100']))
        $arrMovData['idex100'] = 0.00;

    //01-05-2014: Completamos las llaves que pueden no venir.
    if(!array_key_exists('idetotal', $arrMovData))
        $arrMovData['idetotal'] = 0.00;
    if(!array_key_exists('factura', $arrMovData))
        $arrMovData['factura'] = '';
    if(!array_key_exists('cash_nota_num', $arrMovData))
        $arrMovData['cash_nota_num'] = '';
    if(!array_key_exists('ivacobradox100', $arrMovData))
        $arrMovData['ivacobradox100'] = 0.00;
    if(!array_key_exists('ivacobradototal', $arrMovData))
        $arrMovData['ivacobradototal'] = 0.00;
    if(!array_key_exists('empresa_id', $arrMovData))
        $arrMovData['empresa_id'] = '';
    if(!array_key_exists('factura_numero', $arrMovData))
        $arrMovData['factura_numero'] = '';
    if(!array_key_exists('cliente', $arrMovData))
        $arrMovData['cliente'] = '';
    if(!array_key_exists('tienda_id', $arrMovData))
        $arrMovData['tienda_id'] = '';
    if(!array_key_exists('tipo_cash_nota', $arrMovData))
        $arrMovData['tipo_cash_nota'] = '';
    if(!array_key_exists('cobra_iva', $arrMovData))
        $arrMovData['cobra_iva'] = '';
    if(!array_key_exists('cash_num_cobro_iva', $arrMovData))
        $arrMovData['cash_num_cobro_iva'] = '';
    if(!array_key_exists('iva_incluido', $arrMovData))
        $arrMovData['iva_incluido'] = '';
    if(!array_key_exists('banco_mov_tipo_id', $arrMovData))
        $arrMovData['banco_mov_tipo_id'] = 2;

    $arrMovData['ajusta_ctat'] = empty($arrMovData['ajusta_ctat']) ? 'SI' : $arrMovData['ajusta_ctat'];

    //Link de TC o específico
    $bcmIDDestino = array_key_exists('banco_cuenta_mov_id', $arrMovData) ? $arrMovData['banco_cuenta_mov_id'] : '';

    $arrMovData['link_from'] = $arrMovData['link_from'] ?? $arrMovData['link_to'];

    //Agregamos la variable global para saber si hacemos el link estricto o relajado.
    global $gIAstrictlinking;

    $link_datetime = date('Y-m-d H:i:s');

    //$oknumop = 1;
    if(!array_key_exists('deposit', $arrMovData))
        $arrMovData['deposit']=0;
    if(!array_key_exists('cash', $arrMovData))
        $arrMovData['cash']=0;
    if(!array_key_exists('withdrawal', $arrMovData))
        $arrMovData['withdrawal']=0;

    $bcmov_quantity = $arrMovData['deposit'] + $arrMovData['cash'] - $arrMovData['withdrawal']; //Por el link parcial, debemos separar el monto del mov bancario del monto de link.
    $bcmov_quantity = round($bcmov_quantity,2);



    $bc_id = $arrMovData['banco_cuenta_id'];

    //Modificación 30-08-2012
    //Fecha de movimientos más recientes ya capturados en el Estado de Cuenta.
    $sqlstr="SELECT $fn max(fecha) as fecha FROM banco_cuenta_mov WHERE banco_cuenta_id='$arrMovData[banco_cuenta_id]'";
    $fecha_mov_mr = ia_singleread($sqlstr);
    if($fecha_mov_mr == '')
        $fecha_mov_mr = date('Y-m-d');

    //Revisamos si se quiere un link parcial, y si así es, entonces $link_quantity será igual  a$arrMovData['monto_acta'].
    //Deshabilitamos link parcial 18/06/2013.
    //Regresamo el link parcial 02/09/2016

    if(!empty($arrMovData['monto_acta']))
        $link_quantity = $arrMovData['monto_acta'];
    else
        $link_quantity = $bcmov_quantity;

    $link_quantity = round($link_quantity,2);

    //Nombre del movimiento: Pago a cuenta de Cheque, Pagaré, Deuda o Vale (a secas).
    $nombreMov = 'PAGO A CUENTA DE ';

    //Transferencias con tipo de cambio.
    $origen_moneda_id = array_key_exists('origen_moneda_id', $arrMovData) ? $arrMovData['origen_moneda_id'] : false;
    $destino_moneda_id = array_key_exists('destino_moneda_id', $arrMovData) ? $arrMovData['destino_moneda_id'] : false;
    $monto_origen = array_key_exists('monto_origen', $arrMovData) ? $arrMovData['monto_origen'] : false;
    $monto_destino = array_key_exists('monto_destino', $arrMovData) ? $arrMovData['monto_destino'] : false;
    $tipo_cambio = array_key_exists('tipo_cambio', $arrMovData) ? $arrMovData['tipo_cambio'] : false;

    switch($tp=tablapadre($arrMovData['link_to']))
    {
        case 'vale':
            $nombreMov = 'VALE';
            break;

        case 'cuentat_mov':
            if(empty($bcmIDDestino))
                $nombreMov = 'LINK DE CUENTA T';
            else
                $nombreMov = 'LINK DE TARJETAS DE CRÉDITO';
            break;

        case 'banco_cuenta_mov':
            $nombreMov = 'TRANSFERENCIA ENTRE CUENTAS';
            $link_quantity = $monto_destino;
            break;

        default:
            $nombreMov.=strtoupper($tp);
            break;
    }

    $tp = strtolower($tp);

    //Primero buscamos el movimiento y vemos si existe y está disponible o tiene link total o parcial.
    $sepuedelink = false;
    $arrcI = $arr_bcmenDB = $bcmenDB = array();


    //Revisamos que la fecha del depósito no sea anterior al límite establecido en los parámetros.
    //Ni que tampoco sea posterior al parámetro dias_limite_adelante_link_bancario
    $dateHoy = date('Y-m-d');
    $dateMov = $arrMovData['fecha'];

    if(!usuarioTipoRony() && //Si es Rony que se salte esa restricción
        diferenciadeTiempo($dateHoy, $dateMov, 'dias') > $gIAParametros['dias_limite_atras_link_bancario'] &&
        diferenciadeTiempo($dateHoy, $dateMov, 'dias') > $gIAParametros['dias_limite_adelante_link_bancario'])
    {
        $arrInfoLink['vale_acta'] = false;
        $arrInfoLink['mensaje'] = "<strong>LINK BANCARIO NO ACEPTADO.</strong><br/><br/><strong class=\"msgerr\">EXCEDE EL L&Iacute;MITE DE D&Iacute;AS</strong><br/><br/><strong>$nombreMov</strong> <strong class=\"msgerr\">NO SE ACEPTA.</strong>";
        $arrInfoLink['link_id'] = false;

        return $arrInfoLink;
    }
    //Buscamos el movimiento sólo con la fecha y la cantidad

    $primerdiamesfechaDeposito = date('Y-m-d', strtotime($arrMovData['fecha'])) . " 00:00:00";
    $ultimodiamesfechaDeposito = date('Y-m-d', strtotime($arrMovData['fecha'])) . " 23:59:59";

    if(empty($bcmIDDestino))
        $sqlstr="SELECT $fn * FROM banco_cuenta_mov WHERE banco_cuenta_id = '$bc_id' AND ((cash + deposit - withdrawal) = $bcmov_quantity) AND fecha between '$primerdiamesfechaDeposito' AND '$ultimodiamesfechaDeposito' ORDER BY fecha DESC, usado DESC";
    else
        $sqlstr="SELECT $fn * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcmIDDestino'";
    $arrInfoLink['sqlstr'] = $sqlstr;
    $arr_bcmenDB = ia_sqlArrayIndx($sqlstr);

    if((empty($arr_bcmenDB) || !is_array($arr_bcmenDB)) && empty($ghost_mov))
    {
        $arrInfoLink['vale_acta'] = false;
        $arrInfoLink['mensaje'] = "<strong>LINK BANCARIO NO ENCONTRADO.</strong>.<br/><br/><strong class=\"msgerr\">EL $nombreMov NO SE ACEPTA.</strong>";
        $arrInfoLink['link_id'] = false;
        return $arrInfoLink;
    }
    if(!empty($ghost_mov) && empty($arr_bcmenDB)){
        $arr_bcmenDB[] = $ghost_mov;
    }

    /** Se encontró uno o varios movimientos con la fecha y cantidad especificados.
     *  Vamos a buscar alguno disponible, y si no, entonces decimos cuál es el status del o los no disponibles. **/
    // Declaramos una variable para llevar registro de los movimientos que concuerdan y no se pueden tomar.
    $txt_bcm = '';
    $huboSBC = false;
    $cI = 0;

//    echo "<pre>arrMovData:" . print_r($arrMovData, true) . "</pre>";
    $bcmIDDestinoParam = $bcmIDDestino;
    if(is_array($arr_bcmenDB))
        foreach($arr_bcmenDB as $k=>$bcm)
        {
            /**
             * JJDPL: 15-07-2024 para mandar los movimientos al dialogo de despositos multiples (iguales)
             * La bandera se_puede_link es para decidir si se puede o no hacer link en ese movimiento,
             *      TRUE => SI SE PUEDE
             *      FALSE => NO SE PUEDE
            **/
            $bcm['se_puede_link'] = true; // Para saber si se puede hacer link en este movimiento

            /** Revisamos su estado **/
            switch ($bcm['link_vale'])
            {
                case 'LP':
                    /** Primero revisamos si lo que le queda disponible al mov bancario alcanza para el link.
                     *  Si sí le alcanza, entonces salimos del foreach. No necesitamos revisar más.
                     *  Si no le alcanza, leemos sus a cuentas y las mandamos en la respuesta. **/

                    $solicitado=$link_quantity;
                    $usado=round($bcm['usado'],2);
                    $disponible=round(abs($bcmov_quantity-$usado),2);
                    if($link_quantity<=$disponible)
                    {
                        $sepuedelink = true;
                        $arrcI[] = $bcmenDB = $bcm;//$bcmenDB = $bcm;
                        $bcmIDDestino = $bcm['banco_cuenta_mov_id']; //Ya sabemos el ID del movimiento bancario y nos ahorramos un select al final.
                        $cI++;
//                        break 2; //Ya encontramos un movimiento disponible. No necesitamos revisar más.
                    }
                    else{
                        $solicitado=echonf($solicitado,true);
                        $disponible=echonf($disponible,true);
                        $txt_actas = '';
                        $txt_actas = generaaCuentasdeBancoMov($bcm['banco_cuenta_mov_id'],'str','SI');
                        $txt_actas = empty($txt_actas) ? $txt_actas : "<ol>$txt_actas</ol>";
                        $txt_bcm .= "<li><strong class=\"msgerr\">MOV. BANCARIO CON LINKS PARCIALES. NO ALCANZA EL DISPONIBLE.</strong><br />
                SOLICITADO: $solicitado<br />DISPONIBLE: $disponible<br />
                <br/><strong>DETALLE:</strong>$txt_actas</li>";

                        /**
                         * JJDPL: 15-07-2024
                        **/
                        $bcm['se_puede_link'] = false;
                        $arrcI[] = $bcmenDB = $bcm;
                    }


//                    $sepuedelink = false;

                    break;

                //FIDUCIARIO
                //INVERSIONES 2020
                case 'FID':
                    if($arrMovData['link_to'] == 'fiduciario_reembolso') {//Revisamos que venga de fiduciario.
                        $sepuedelink = true;
                        $arrcI[] = $bcmenDB = $bcm;
                        $bcmIDDestino = $bcm['banco_cuenta_mov_id']; //Ya sabemos el ID del movimiento bancario y nos ahorramos un select al final.
                        if ($tp == 'vale')
                            break 2;
                        $cI++;
                    }
                    //$txt_bcm .= "<li><strong>MOVIMIENTO DE FIDUCIARIO.</strong></li>";
                    //break 2; //Ya encontramos un movimiento disponible. No necesitamos revisar más.
                    break;

                case 'Q':
                    $sepuedelink = true;
                    $arrcI[] = $bcmenDB = $bcm;
                    $bcmIDDestino = $bcm['banco_cuenta_mov_id']; //Ya sabemos el ID del movimiento bancario y nos ahorramos un select al final.
//                    if($tp=='vale')
//                        break 2;
                    $cI++;
                    //break 2; //Ya encontramos un movimiento disponible. No necesitamos revisar más.
                    break;

                case 'INV':
                    if($arrMovData['link_to'] == 'inversion_reembolso'){//Revisamos que venga de inversiones.
                        $sepuedelink = true;
                        $arrcI[] = $bcmenDB = $bcm;
                        $bcmIDDestino = $bcm['banco_cuenta_mov_id']; //Ya sabemos el ID del movimiento bancario y nos ahorramos un select al final.
                        if($tp=='vale')
                            break 2;
                        $cI++;
                    }
                    //$txt_bcm .= "<li><strong>MOVIMIENTO DE INVERSION.</strong></li>";
                    //break 2; //Ya encontramos un movimiento disponible. No necesitamos revisar más.
                    break;

                case 'SBC':
                    $txt_bcm .= "<li><strong>CHEQUE SALVO BUEN COBRO.</strong></li>";
                    $huboSBC = true;
                    $sepuedelink = false;
                    break;

                case 'ND':case 'NAVIERA':case 'CPP':
                    //VCA 15-12-2020 SolicitaLinkBancario permite hacer link desde Transfers propias aún cuando el depósito esté en ND.
                    //Sólo permite desde fiduciario_reembolso y propias
//                echo "<pre>".print_r($bcm, true)."</pre>";
//                echo "<pre>".print_r($arrMovData, true)."</pre>";
                    if( $arrMovData['link_to'] == 'banco_cuenta_mov' || //Desde Tranfers Propias
                        $arrMovData['link_from'] == 'tclink' || //Desde Link de Tarjetas de Crédito
                       ($arrMovData['link_to'] == 'cuentat_mov' && $arrMovData['ajusta_ctat'] == 'NO' && $arrMovData['factura'] == 'DEVOLUCION')
                    )
                    {
                        $sepuedelink = true;
                        $arrcI[] = $bcmenDB = $bcm;
                        $bcmIDDestino = $bcm['banco_cuenta_mov_id']; //Ya sabemos el ID del movimiento bancario y nos ahorramos un select al final.
                        $cI++;
                    }
                    else
                    {
                        $txt_bcm .= "<li><strong>MOV. BANCARIO NO DISPONIBLE.</strong></li>";
//                        $sepuedelink = false;
                        //break 2; //Ya encontramos un movimiento disponible. No necesitamos revisar más.
//                        break;
                    }
                    break;

                case 'LT':case 'BL':case 'RJ':

                //Ph. 25-04-2025
                //Debido a que Alejandra, Nancy y Magda trabajan con los ojos cerrados, quité el hack que permitía multiples links sin afactar la cuentat.
                //No me van a estar regañando a diario por estupideces de los demás.
                $txt_actas = '';
                $txt_actas = generaaCuentasdeBancoMov($bcm['banco_cuenta_mov_id'], 'str', 'SI');
                $txt_actas = empty($txt_actas) ? $txt_actas : "<ol>$txt_actas</ol>";
                $txt_actas = html_entity_decode($txt_actas);
                $txt_bcm .= "<li><strong>MOV. BANCARIO CON LINK TOTAL.</strong><br/><strong>DETALLE:</strong>$txt_actas</li>";;
                break;
            }
        }

    if(!$sepuedelink && $cI <= 1)
    {
        $arrInfoLink['vale_acta'] = false;
        $arrInfoLink['mensaje'] = $txt_bcm ."<hr/><strong class=\"msgerr\">EL $nombreMov NO SE ACEPTA.</strong>";
        $arrInfoLink['link_id'] = false;
        return $arrInfoLink;
    }

    /** Encontró más de un movimiento disponible con la misma cantidad y la misma. Los mandamos en un array para que elija el que quiere.**/
    /** VCA Agregamos una excepcion por si el vale y encontró más de un movimiento, que le ofrezca el listado que encontró */
    if($cI > 1 ) // && $tp!='vale' // && $tp!='banco_cuenta_mov'
    {

        foreach($arrcI as $k=>&$v){
            $v['fecha'] = date('d-m-Y', strtotime($v['fecha'])) . " " . $v['fecha_hora'];
        }

        $arrInfoLink['vale_acta'] = false;
        $arrInfoLink['mensaje'] = $txt_bcm ."<hr/><strong class=\"lbl\">MULTIPLES DEPÓSITOS CON LA MISMA CANTIDAD.</strong>";
        $arrInfoLink['link_id'] = false;
        $arrInfoLink['arrcI'] = $arrcI;
        $arrInfoLink['cI'] = $cI;
        return $arrInfoLink;
    }

    //VCA 02-06-2021 Agrego faltante_permitido_completar_link. Si le falta menos del faltante_permitido_completar_link para completar el link, entonces lo completa.
    $faltante_permitido = $gIAParametros['faltante_permitido_completar_link'];

    $link_quantity = abs($arrMovData['ajusta_ctat'] == 'NO' && $arrMovData['factura'] == 'DEVOLUCION' ? 0.00 : $link_quantity);
    $link_quantity_txt = empty($link_quantity) ? "deposit - usado" : "usado + $link_quantity";
    $updateFields=" link_vale = IF(usado+$link_quantity+$faltante_permitido>=deposit OR $link_quantity = 0,'LT','LP')
        , usado = $link_quantity_txt
        , idex100 = '$arrMovData[idex100]'
        , idetotal = '$arrMovData[idetotal]'
        , factura = '$arrMovData[factura]'
        , factura_numero = '$arrMovData[factura_numero]'
        , ivacobradox100 = '$arrMovData[ivacobradox100]'
        , ivacobradototal = '$arrMovData[ivacobradototal]'
        , empresa_id = '$arrMovData[empresa_id]'
        , cliente = '$arrMovData[cliente]'
        , tienda_id = '$arrMovData[tienda_id]'
        , cobra_iva = '$arrMovData[cobra_iva]'
        , tipo_cash_nota = '$arrMovData[tipo_cash_nota]'
        , cash_nota_num = '$arrMovData[cash_nota_num]'
        , cash_num_cobro_iva = '$arrMovData[cash_num_cobro_iva]'
        , iva_incluido = '$arrMovData[iva_incluido]'
        , puede_editar = 'No'
        , ultimo_cambio = '$link_datetime'
        , ultimo_cambio_por = '$usuario'
        , link_el = '$link_datetime'
        , link_por = '$usuario'
        , banco_mov_tipo_id = '$arrMovData[banco_mov_tipo_id]'
        WHERE banco_cuenta_id = '$bc_id' ";

    $sqlstr = "UPDATE $fn banco_cuenta_mov SET $updateFields AND banco_cuenta_mov_id = '$bcmIDDestino' ";

    $sql[]=$sqlstr;

    $bcml_id = ia_guid();
    $bcm_id = $bcmIDDestino;
    $link_to = $arrMovData['link_to'];
    $link = $arrMovData['link'];
    $tienda_id = $arrMovData['tienda_id'];

    $sqlstr = "INSERT $fn INTO banco_cuenta_mov_link
    (banco_cuenta_mov_link_id, banco_cuenta_mov_id, link_to, link, tienda_id, link_por, link_el)
    VALUES ('$bcml_id', '$bcm_id', '$link_to', '$link', '$tienda_id', '$usuario', '$link_datetime')";


    $sql[]=$sqlstr;
    if($doLink=='SI')
        if(ia_transaction($sql))
        {
            $arrInfoLink['vale_acta'] = false;
            $arrInfoLink['mensaje'] = "OCURRIÓ UN ERROR AL HACER EL LINK.";
            $arrInfoLink['link_id'] = false;
            $arrInfoLink['sql'] = $sql;
            return $arrInfoLink;
        }

    $arrInfoLink['disponible'] = $arrMovData['ajusta_ctat'] == 'NO' && $arrMovData['factura'] == 'DEVOLUCION'? 0.00 : (abs($bcmenDB['cash'] + $bcmenDB['deposit'] - $bcmenDB['withdrawal']) - ($bcmenDB['usado'] + $link_quantity));
    $arrInfoLink['vale_acta'] = true;
    $arrInfoLink['mensaje'] = "LINK EXITOSO.";
    $arrInfoLink['link_id'] = $bcml_id;
    $arrInfoLink['bcm_id'] = $bcm_id;
    $arrInfoLink['ref_num'] = numRefLink();
    $arrInfoLink['deposit_fecha'] = $bcmenDB['fecha'];
    $arrInfoLink['referencia'] = $bcmenDB['numero'];
    $arrInfoLink['bcmenDB'] = $bcmenDB=ia_singleton("SELECT $fn * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'");
    $arrInfoLink['sql'] = $sql;

    return $arrInfoLink;
}

/**
 * RompeLinkBancario()
 *
 * @param   $bcml_id = banco_cuenta_mov_link_id.
 * @return  $rlb_arr = un array con atributos para el log si la rotura del link fue exitosa y $doRLB==true. Si $doRLB==false, entonces el $sql_arr.
 *          false si ocurrio algun error.
 */

function RompeLinkBancario($bcml_id, $usuario='', $dedonde = "<li>LINK ROTO DESDE ESTADO DE CUENTA POR ", $comParaBancoMov="", $doRLB=true)
{
    //Revisar esta operacion

    if($bcml_id == '' || strlen($bcml_id) < 32)
        return false;

    global $gIAsql;
    $gIAsql['trace']=true;

    if(empty($usuario))
        $usuario = $_SESSION['usuario'];

    $commentSQL = " /** RompeLinkBancario **/";

    $rlb_arr = array();

    $bcml_arr = ia_singleton("SELECT $commentSQL * FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_link_id = ". strit($bcml_id));


    if(!array_key_exists('banco_cuenta_mov_id',$bcml_arr)) //Ya no existe el link bancario. Nada que hacer aquí.
        return false;

    $bcm_id = $bcml_arr['banco_cuenta_mov_id'];
    $bcm_arr = ia_singleton("SELECT $commentSQL * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = '$bcm_id'");
    $bc_cash = array_key_exists('cash',$bcm_arr) ? $bcm_arr['cash'] : 0.00;
    $bc_withdrawal = array_key_exists('withdrawal',$bcm_arr) ? $bcm_arr['withdrawal'] : 0.00;
    $bc_deposit = array_key_exists('deposit',$bcm_arr) ? $bcm_arr['deposit'] : 0.00;

    $acta_id = $bcml_arr['link'];
    $acta_tbl = $bcml_arr['link_to'];
    $acta_id_nombre = $acta_tbl . '_id';
    $actapadre_tbl = tablapadre($acta_tbl);
    $actapadre_id_nombre = $actapadre_tbl . '_id';

    $acta_arr = ia_singleton("SELECT $commentSQL * FROM $acta_tbl WHERE $acta_id_nombre = '$acta_id'");
    if(empty($acta_arr) && $acta_tbl=='cuentat_mov')
        $acta_arr = ia_singleton("SELECT * FROM cuentat_a_banco WHERE cuentat_a_banco_mov_id = '$acta_id'");


    //echo "<pre>".print_r($acta_arr,true)."</pre>";
    //echo "<pre>".print_r($ctaT_arr,true)."</pre>";

    $Quantity = 0;
    $QuantityCtaT = 0;
    $usado = 0;

    if(array_key_exists('quantity',$acta_arr))
        $Quantity = $acta_arr['quantity']; //Este monto es el que vamos a quitarle al total_payments del padre y a restar de usado en banco_cuenta_mov
    else if(array_key_exists('monto',$acta_arr))
        $Quantity = $acta_arr['monto'];
    else if(array_key_exists('monto_global_reembolso',$acta_arr)) // Inversiones 2020
        $Quantity = $acta_arr['monto_global_reembolso'];

    $QuantityCtaT = array_key_exists('quantity_ctat',$acta_arr) ? $acta_arr['quantity_ctat'] : 0.00;
    $usado = array_key_exists('quantity_total',$acta_arr) ? $acta_arr['quantity_total'] : $Quantity;

    switch($acta_tbl)
    {
        case 'cuentat_mov':
            if($acta_arr['tipo'] == 'Egreso')
                $Quantity = limpiaCantidad($acta_arr['egreso']);
            else
                $Quantity = limpiaCantidad($acta_arr['monto']);
            break;

        case 'banco_cuenta_mov':
            $Quantity = limpiaCantidad($acta_arr['withdrawal']);
            break;

        case 'fiduciario_reembolso':
            $Quantity = limpiaCantidad($acta_arr['monto_global_reembolso']);
            break;

        case 'inversion_reembolso':
            $usado = $Quantity = limpiaCantidad($acta_arr['monto_reembolsado'] + $acta_arr['monto_interes'] + $acta_arr['monto_isr']);
            break;

        case 'vale':
            $QuantityCtaT = limpiaCantidad($acta_arr['quantity_recibido']);
            break;

    }

    $actapadre_id = array_key_exists($actapadre_id_nombre,$acta_arr) ? $acta_arr[$actapadre_id_nombre] : '';

    $rlb_arr['banco_cuenta_id'] = $bc_id = array_key_exists('banco_cuenta_id',$bcm_arr) ? $bcm_arr['banco_cuenta_id'] : '0';
    $rlb_arr['acta_tbl'] = $acta_tbl;
    $rlb_arr['Quantity'] = $QuantityCtaT ? $QuantityCtaT : $Quantity;
    $rlb_arr['bcm_id'] = $bcm_id;
    $rlb_arr['acta'] = '';
    $rlb_arr['actapadre'] = $actapadre_tbl;
    $rlb_arr['actapadre_id'] = $actapadre_id;
    $rlb_arr['cuentat_id'] = '';
    $rlb_arr['cuentat_mov'] = '';
    $rlb_arr['link_roto_id'] = '';
    $rlb_arr['link_ori_id'] = '';
    $rlb_arr['banco_cuenta_mov_id'] = $bcml_arr['banco_cuenta_mov_id'];

    $bc_tc = array_key_exists('tipo_cambio',$acta_arr) ? $acta_arr['tipo_cambio'] : '0.00';



    $now = $ultimo_cambio = date('Y-m-d H:i:s');


    //Diferenciamos Ingreso y Egreso 9-1-13
    $cTcampoMonto = 'monto';
    $cTtipomov = 'Ingreso';
    $cTcampoMontoCP = 'egreso';
    $cTtipomovCP = 'Egreso';

    if(!array_key_exists('es',$bcm_arr))
        $bcm_arr['es'] = 'Ingreso';

    if($bcm_arr['es'] == 'Retiro')
    {
        $cTcampoMonto = 'egreso';
        $cTtipomov = 'Egreso';
        $cTcampoMontoCP = 'monto';
        $cTtipomovCP = 'Ingreso';
    }
    else
    {
        $cTcampoMonto = 'monto';
        $cTtipomov = 'Ingreso';
        $cTcampoMontoCP = 'egreso';
        $cTtipomovCP = 'Egreso';
    }
    ///////////////////////////////////////

    $sql = array();

    $quantity_total = 0;

    $updateFields=", idex100 = 0.00
        , idetotal = 0.00
        , factura = ''
        , factura_numero = ''
        , ivacobradox100 = 0.00
        , ivacobradototal = 0.00
        , empresa_id = NULL
        , cliente = ''
        , tienda_id = NULL
        , cobra_iva = NULL
        , tipo_cash_nota = NULL
        , cash_nota_num = NULL
        , cash_num_cobro_iva = NULL
        , iva_incluido = NULL ";

    if(esBancoChina($bc_id))
    {
        $updateFields = ", cash = 0.00, withdrawal = 0.00, 	deposit = 0.00 ";
        $comParaBancoMov .= ($bc_cash > 0 ? "<li>TENIA CASH $ ".echonf($bc_cash, true)." " : "");
        $comParaBancoMov .= ($bc_withdrawal > 0 ? "<li>TENIA WITHDRAWAL $ ".echonf($bc_withdrawal, true)." " : "");
        $comParaBancoMov .= ($bc_deposit > 0 ? "<li>TENIA DEPOSIT $ ".echonf($bc_deposit, true)." " : "");
        $comParaBancoMov .= ($bc_tc > 0 ? "<li>TIPO DE CAMBIO $ ".echonf($bc_tc, true)." " : "");
    }

    if($acta_tbl == 'banco_cuenta_mov')
    {
        $quantity_total = $Quantity;
        $bcm_sql = "UPDATE $commentSQL banco_cuenta_mov SET
        link_vale = 'ND'
        , usado = '0.00'
        , remarks = '<li>TRANSFERENCIA ENTRE CUENTAS BANCARIAS CANCELADA POR <strong>$usuario</strong>'
        $updateFields
        WHERE banco_cuenta_mov_id = '$acta_id'";
        $sql[] = $bcm_sql;
    }
    else
    {
        $sql[] = "UPDATE $commentSQL $acta_tbl SET banco_cuenta_mov_link_id = 'roto' WHERE $acta_id_nombre = '$acta_id' LIMIT 1";

        //Sólo si no existe el Documento padre borramos el a cuenta.
        //Quiere decir que era un link mocho, y no hay necesidad de dejarlo vivo.
        if(empty($actapadre_id) && $acta_tbl != 'cuentat_mov')
        {
            $quantity_total = $Quantity;

            $sql[] = "DELETE $commentSQL FROM $acta_tbl WHERE $acta_id_nombre = '$acta_id' LIMIT 1";
            $rlb_arr['acta'] = $acta_tbl;
        }
        else
        {
            //El Documento padre existe, entonces debemos hacer un Ingreso a la cuentaT.
            //Primero averiguo a qué cuentaT debo Ingresar el dinero.

            //25-1-14 Creo que debo averiguar el movimiento original en cuenta t.
            if($actapadre_tbl=='cheque' || $actapadre_tbl=='pagare' || $actapadre_tbl=='vale')
            {
                $ctaTMovIDOriginal = obtenCuentaTMovIDOriginal($acta_id);
                $sqlctat = "SELECT /* BUSCA MOV CTA T EN CHEQUE, PAGARE, VALE */ * FROM cuentat_mov WHERE origen_mov_id = '$ctaTMovIDOriginal' AND tipo = '$cTtipomovCP' AND $cTcampoMontoCP = '$QuantityCtaT'";
            }
            else
            {
                $sqlctat = "SELECT /* BUSCA MOV CTA T LINK AL BANCO, ETC. */ * FROM cuentat_mov WHERE (origen_mov_id = '$acta_id' OR cuentat_mov_id = '$acta_id') AND tipo = '$cTtipomovCP' AND $cTcampoMontoCP = '$Quantity'";
            }
            $cuentaT_arr = ia_singleton($sqlctat);


            /*$myFile = "valever.txt";
            $fh = fopen($myFile, 'w') or die("can't open file");
            fwrite($fh, $sqlctat . print_r($cuentaT_arr, true));*/


            if(array_key_exists('cuentaT_id', $cuentaT_arr)) //Verificamos que exista el movimiento original. Es muy importante.
            {
                $contra_mov_id = $cuentaT_arr['cuentaT_mov_id'];
                $rlb_arr['link_ori_id'] = $contra_mov_id;//$cuentaT_arr['contra_mov_id'];
                $actualizaCtaTMovOriginal = true;

                if($cuentaT_arr['app_origen']=='A Cuenta Cheque' || $cuentaT_arr['app_origen']=='A Cuenta Pagare' || $cuentaT_arr['app_origen']=='Cheque' || $cuentaT_arr['app_origen']=='Pagare' || $cuentaT_arr['app_origen']=='Vale')
                {
                    $cuentaT_arr['origen_mov_id']=$acta_id;
                    $contra_mov_id = '';
                    $actualizaCtaTMovOriginal = false;
                }
                else
                    $cuentaT_arr['origen_mov_id']=$cuentaT_arr['cuentaT_mov_id'];

                //$cuentaT_arr['cuentaT_mov_id'] = ia_guid();
                $cuentaT_mov_id = ia_guid();

                $cuentaT_arr['fecha'] = $ultimo_cambio;
                $cuentaT_arr['alta_db'] = $ultimo_cambio;
                $cuentaT_arr['alta_por'] = $usuario;
                $cuentaT_arr['ultimo_cambio'] = $ultimo_cambio;
                $cuentaT_arr['ultimo_cambio_por'] = $usuario;

                $cuentaT_arr['cuentaT_tipo_mov_id'] = 2;

                if($dedonde == "<li>LINK ROTO DESDE ESTADO DE CUENTA POR ")
                {
                    $cuentaT_arr['remarks'] = "$dedonde <strong>$usuario</strong><hr>".addslashes($cuentaT_arr['remarks']);
                }
                else if(!empty($dedonde))
                {
                    $ctaBancariaNombre = ia_htmlentities(ia_singleread("SELECT $commentSQL nombre FROM banco_cuenta WHERE banco_cuenta_id = '$cuentaT_arr[banco_cuenta_id]'"));
                    $ctaBancariaNombre = "CUENTA <a title='$ctaBancariaNombre' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$cuentaT_arr[banco_cuenta_id]' target='_blank'><strong>$ctaBancariaNombre</strong></a>";

                    $dedonde = stripslashes($dedonde);
                    $dedonde = str_replace('SE ROMPE LINK BANCARIO DEL', "SE ROMPE LINK BANCARIO $ctaBancariaNombre DEL",$dedonde);
                    $dedonde = addslashes($dedonde);

                    $cuentaT_arr['remarks'] = "$dedonde <strong>$usuario</strong>.";
                }

                $quantity_total = $cuentaT_arr['quantity_total'];

                $ctaT_sql = array();

                //Insertamos el contramovimiento, o sea, la cancelación.
                $sql[] = "INSERT $commentSQL INTO cuentat_mov (cuentaT_mov_id, cuentaT_id, fecha, cuentaT_tipo_mov_id, $cTcampoMonto, moneda_id, tipo_cambio, banco_cuenta_id, referencia, remarks, banco_cuenta_mov_link_id, cuentaT_deliveredto_id, esta_en, cuentaT_transferto_id, quantity_total, ultimo_cambio, ultimo_cambio_por, alta_db, alta_por, tipo, origen_mov_id, app_origen, fecha_deposito, deposit_total, contra_mov_id, activo) VALUES
                (   '$cuentaT_mov_id',
                    '$cuentaT_arr[cuentaT_id]',
                    '$cuentaT_arr[fecha]',
                    '$cuentaT_arr[cuentaT_tipo_mov_id]',
                    '$cuentaT_arr[$cTcampoMontoCP]',
                    '$cuentaT_arr[moneda_id]',
                    '$cuentaT_arr[tipo_cambio]',
                    '$cuentaT_arr[banco_cuenta_id]',
                    '$cuentaT_arr[referencia]',
                    '$cuentaT_arr[remarks]',
                    '$cuentaT_arr[cuentaT_mov_id]', NULL, 'user', NULL,
                    '$cuentaT_arr[quantity_total]',
                    '$cuentaT_arr[ultimo_cambio]',
                    '$cuentaT_arr[ultimo_cambio_por]',
                    '$cuentaT_arr[alta_db]',
                    '$cuentaT_arr[alta_por]',
                    '$cTtipomov',
                    '$cuentaT_arr[origen_mov_id]',
                    '$cuentaT_arr[app_origen]',
                    '$cuentaT_arr[fecha_deposito]',
                    '$cuentaT_arr[deposit_total]',
                    '$contra_mov_id','No')";

                //Actualizamos el movimiento original.
                if($actualizaCtaTMovOriginal)
                    $sql[] = "UPDATE $commentSQL cuentat_mov SET ultimo_cambio='$now', contra_mov_id='$cuentaT_mov_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_arr[cuentaT_mov_id]'";

                $rlb_arr['cuentat_id'] = $cuentaT_arr['cuentaT_id'];
                $rlb_arr['cuentat_mov'] = $cuentaT_arr['cuentaT_mov_id'];
                $rlb_arr['link_roto_id'] = $cuentaT_mov_id;
                $cuentaT_arr['cuentaT_mov_id'] = $cuentaT_mov_id;
                $rlb_arr['arr_cuentat_mov'] = $cuentaT_arr;

                /**
                fwrite($fh, "rlb: \r\n".print_r($rlb_arr, true)."\r\nSQL:". print_r($sql, true)."</pre>");
                fclose($fh);
                 **/
            }
        }
    }
//    $link_vale = $acta_tbl == 'banco_cuenta_mov' ? " link_vale = IF(usado-$usado=0,'Q','LP'), usado = 0 " : " link_vale = IF(usado-$usado=0,'Q','LP'), usado = usado-$usado ";

    if($acta_tbl === 'banco_cuenta_mov')
        $link_vale = " link_vale = 'Q', usado = 0 ";
    elseif($acta_tbl === 'inversion_reembolso'){
        $link_vale = " link_vale = IF(usado-$usado=0,'ND','LP'), usado = usado-$usado ";
    }
    else{
        $link_vale = " link_vale = IF(usado-$usado=0,'Q','LP'), usado = usado-$usado ";
    }
    $remarks = ", remarks = ".strit($comParaBancoMov);
    //$Quantity = 500;
    $sql[] = "UPDATE $commentSQL banco_cuenta_mov SET
        $link_vale
        , ultimo_cambio = '$ultimo_cambio'
        , ultimo_cambio_por = '$usuario'
        , link_el = NULL
        , link_por = '$usuario'
        $updateFields
        $remarks
        WHERE banco_cuenta_mov_id = '$bcm_id'";

    $sql[] = "DELETE $commentSQL FROM banco_cuenta_mov_link WHERE banco_cuenta_mov_link_id = ". strit($bcml_id) ." LIMIT 1"; //Borro el banco_cuenta_mov_link.

    $rlb_arr['sql'] = $sql;

    /**

    $myFile = "valever.txt";
    $fh = fopen($myFile, 'w') or die("can't open file");
    fwrite($fh, $sqlctat . print_r($sql, true));
     *
     * **/


    if($doRLB)
    {
        if(ia_transaction($sql))
        {
            ia_errores_a_dime();
            if($gIAsql['trace'])
                ia_errores_a_dime("sql_trace=".print_r($gIAsql['sql_trace'],true));
            return false;
        }
    }

    return $rlb_arr;
}
