<?php
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpMissingReturnTypeInspection */

function usuarioTipoRony($uid = null, $real_rony = false) {
    if(empty($uid))
        $uid = $_SESSION['usuario_id'] ?? "0";

    if($uid == 1)
        return true;
    if(empty($uid))
        return false;

    if($uid != 1 && $real_rony)
        return false;

    static $prevUid = null;
    static $prevPuede = false;
    if($prevUid == $uid) {
        return $prevPuede;
    }
    $prevUid = $uid;
    $esUsuarioTipoRony = ia_singleread("SELECT usuario_tipo_rony FROM iac_usr WHERE iac_usr_id = " . strit($uid));
    if($esUsuarioTipoRony === 'Si') { //Hay que decidir los usuarios.
        $prevPuede = true;
        return true;
    }
    $prevPuede=false;
    return false;
}

function usuarioSupervisaBodega($uid = null):bool {
    if(empty($uid))
        $uid = isset($_SESSION) ? $_SESSION['usuario_id'] : "0";
    if(usuarioTipoRony($uid))
        return true;
    if(empty($uid))
        return false;

    static $prevUid = null;
    static $prevPuede = false;
    if($prevUid == $uid) {
        return $prevPuede;
    }
    $prevUid = $uid;
    $function = __FUNCTION__;
    if(ia_singleread("SELECT /*$function*/ puede_supervisar_bodega FROM iac_usr WHERE iac_usr_id =" . strit($uid) ) === 'Si') {
        $prevPuede = true;
        return true;
    }
    $prevPuede=false;
    return false;
}

function usuarioConsultaExistenciaBodega($uid = null):bool {return puedePermisoUsuario(nombrePermiso: "puede_consultar_existencia");}

function puedeCatDoc($catDoc)
{
    return !usuarioTipoRony()
    && ia_singleread("SELECT para_quien FROM categoria WHERE categoria_id=".strit($catDoc)) === 'RONY' ?
        false :
        true;
}

function puedeCuentaT($cuentaTID='', $quienPuedeID='', $quePuede='')
{
    global $arr_permisoctasT;
    global $arr_ctasT;
    global $arr_tiendasPuede;

    $arrTiendasQuePuedeKeys = array('cheque_Editar'=>array('que'=>'cheque','puede'=>'Editar'),
        'cheque_Consultar'=>array('que'=>'cheque','puede'=>'Consultar'),
        'pagare_Editar'=>array('que'=>'pagare','puede'=>'Editar'),
        'pagare_Consultar'=>array('que'=>'pagare','puede'=>'Consultar'),
        'vale_Editar'=>array('que'=>'vale','puede'=>'Editar'),
        'vale_Consultar'=>array('que'=>'vale','puede'=>'Consultar'));
    $puede = false;

    if(empty($cuentaTID) || empty($quePuede))
        return false;

    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    //OPTIMIZE ANTES del $userProfile pues no se usa

    if(usuarioTipoRony($quienPuedeID)) //Confirmar si el superuser se salta esta verificación.
        return true;
// falta cuentasTPuede
    //OPTIMIZE SQL static var
    // $userProfile = ia_singleton("SELECT /*".__METHOD__." !*/ * FROM iac_usr WHERE iac_usr_id = ".strit($quienPuedeID));


    if($arr_permisoctasT == null || $arr_ctasT == null || $arr_tiendasPuede == null)
    {
        $sql = "SELECT /*puedeCuentaT*/  * FROM permiso_ctat WHERE iac_usr_id = " . strit($quienPuedeID);
        $arr_permisoctasT=ia_sqlArray($sql,'cuentaT_id');
        if($arr_permisoctasT === false)
            $arr_permisoctasT = [];
        $sql = "SELECT  /*puedeCuentaT*/  cuentaT_id, poner_delivered_cheques, poner_delivered_pagares, es_de, tienda_id FROM cuentat";
        $arr_ctasT=ia_sqlArray($sql,'cuentaT_id');
        if($arr_ctasT === false)
            $arr_ctasT = [];
        //CAMBIAPLANTILLATIENDAS
        $sql = "SELECT  /*puedeCuentaT*/  pc.tienda_id, pc.permiso_cheque, pc.permiso_pagare, pc.permiso_cobranza, t.cuentaT_id
                FROM plantilla_cobranza pc
                JOIN iac_usr u ON u.plantillatienda_id=pc.plantillatienda_id
                JOIN cuentat t ON pc.tienda_id=t.tienda_id
                WHERE t.tienda_id > 0 AND u.iac_usr_id= " . strit($quienPuedeID);
        $arr_tiendasPuedeTmp=ia_sqlArray($sql,'cuentaT_id');

        if(is_array($arr_tiendasPuedeTmp)) foreach($arr_tiendasPuedeTmp as $kT => $vT)
        {
            $arr_tiendasPuede['cheque'][$kT] = [];
            $arr_tiendasPuede['pagare'][$kT] = [];
            $arr_tiendasPuede['vale'][$kT] = [];

            $arr_tiendasPuede['cheque'][$kT]['Editar'] = $vT['permiso_cheque'] === 'Editar';
            $arr_tiendasPuede['pagare'][$kT]['Editar'] = $vT['permiso_pagare'] === 'Editar';
            $arr_tiendasPuede['vale'][$kT]['Editar'] = $vT['permiso_cobranza'] === 'Editar';

            $arr_tiendasPuede['cheque'][$kT]['Consultar'] = $vT['permiso_cheque'] === 'Consultar' || $vT['permiso_cheque'] === 'Editar';
            $arr_tiendasPuede['pagare'][$kT]['Consultar'] = $vT['permiso_pagare'] === 'Consultar' || $vT['permiso_pagare'] === 'Editar';
            $arr_tiendasPuede['vale'][$kT]['Consultar'] = $vT['permiso_cobranza'] === 'Consultar' || $vT['permiso_cobranza'] === 'Editar';
        }

        //echo "<pre>".print_r($arr_tiendasPuede, true)."</pre>";
        //echo "<pre>".print_r($arrTiendasQuePuedeKeys, true)."</pre>";
        //echo "<pre>".print_r($arr_ctasT, true)."</pre>";

        if(is_array($arr_ctasT)) foreach($arr_ctasT as $kctaTID => $vctaT)
        {
            //echo "<pre>$kctaTID + ".print_r($vctaT, true)."</pre>";
            if(array_key_exists($kctaTID,$arr_permisoctasT))
            {
                //echo "<pre>".print_r($arr_permisoctasT[$kctaTID], true)."</pre>";
                if(array_key_exists('poner_delivered_cheques',$arr_permisoctasT[$kctaTID]))
                    if($vctaT['poner_delivered_cheques'] === 'No')
                        $arr_permisoctasT[$kctaTID]['poner_delivered_cheques'] = $vctaT['poner_delivered_cheques'];
                if(array_key_exists('poner_delivered_pagares',$arr_permisoctasT[$kctaTID]))
                    if($vctaT['poner_delivered_pagares'] === 'No')
                        $arr_permisoctasT[$kctaTID]['poner_delivered_pagares'] = $vctaT['poner_delivered_pagares'];
            }
        }
    }

    if(!empty($arr_permisoctasT) && is_array($arr_permisoctasT))
    {
        //Metemos la revision de las tiendas 13-06-2014
        if(array_key_exists($quePuede,$arrTiendasQuePuedeKeys))
        {
            if(array_key_exists('que', $arrTiendasQuePuedeKeys[$quePuede]))
                if(array_key_exists($cuentaTID, $arr_tiendasPuede[$arrTiendasQuePuedeKeys[$quePuede]['que']]))
                    $puede = $arr_tiendasPuede[$arrTiendasQuePuedeKeys[$quePuede]['que']][$cuentaTID][$arrTiendasQuePuedeKeys[$quePuede]['puede']];
        }
        else
        {
            if(array_key_exists($cuentaTID,$arr_permisoctasT))
                if($arr_permisoctasT[$cuentaTID]['acceso'] === 'Si')
                    if(array_key_exists($quePuede,$arr_permisoctasT[$cuentaTID]))
                        $puede = $arr_permisoctasT[$cuentaTID][$quePuede] === 'Si' ? true : false;
        }
    }
    else
        $puede = false;

    //echo "<pre>".print_r($arr_permisoctasT, true)."</pre>";

    return $puede;
}

function puedeCuentaBancaria($quienPuedeID='', $banco_cuenta_id = '', $quePuede='R/W', $todas=false, $EdoCtaOriginal='SI')
{
    $arr_cB = [];

    $arr_cB['puede'] = true;
    $arr_cB['quePuede'] = 'Editar';
    
    return $arr_cB;

    $tablaBCMPlantilla = "banco_cuenta_mov_plantilla";
    if($EdoCtaOriginal != 'SI')
        $tablaBCMPlantilla = "mov_verificado_plantilla";

    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($banco_cuenta_id))
        $todas = true;

    $where = '';

    if(!$todas)
    {
        if(usuarioTipoRony($quienPuedeID))
            $where = " bc.banco_cuenta_id = " . strit($banco_cuenta_id);
        else
            $where = " AND bc.banco_cuenta_id = " . strit($banco_cuenta_id);
    }
    else
        if(usuarioTipoRony($quienPuedeID))
            $where = "1";

    if(usuarioTipoRony($quienPuedeID))
        $sql = "SELECT banco_cuenta_id, 'R/W' as puede FROM banco_cuenta bc WHERE /** bc.vale = 'active' **/ $where";
    else
        if($quePuede === 'R/W')
            /** @noinspection SqlResolve */
            $sql = "SELECT DISTINCT(bc.banco_cuenta_id), puede, bcu.vale FROM $tablaBCMPlantilla bc JOIN iac_usr u ON bc.plantilla_id=u.plantilla_id JOIN banco_cuenta bcu ON bcu.banco_cuenta_id=bc.banco_cuenta_id WHERE bcu.vale='Active' AND u.iac_usr_id=".strit($quienPuedeID)." AND bc.puede=".strit($quePuede).$where;
        else {
            /** @noinspection SqlResolve */
            $sql = "SELECT DISTINCT(bc.banco_cuenta_id), puede, bcu.vale FROM $tablaBCMPlantilla bc JOIN iac_usr u ON bc.plantilla_id=u.plantilla_id JOIN banco_cuenta bcu ON bcu.banco_cuenta_id=bc.banco_cuenta_id WHERE bcu.vale='Active' AND u.iac_usr_id=" . strit($quienPuedeID) . " AND bc.puede!='Nada'" . $where;
        }

//    echo "<pre>$sql</pre>";
    $arr_cB['cB']=ia_sqlArrayIndx($sql);

//    echo "<pre>".print_r($arr_cB, true)."</pre>";

    if(!empty($arr_cB['cB']))
    {
        $arr_cB['puede'] = true;
        switch($arr_cB['cB'][0]['puede'])
        {
            case 'R/W': $arr_cB['quePuede'] = 'Editar'; break;

            case 'R/O': $arr_cB['quePuede'] = 'Consultar'; break;

            case 'A/O': $arr_cB['quePuede'] = 'Capturar'; break;

            case 'D/O': $arr_cB['quePuede'] = 'Eliminar'; break;

            case 'L/O': $arr_cB['quePuede'] = 'Link'; break; //VCA 25-SEP-2020 PLANTILLA DE SOLO LINKS AL BANCO

            case 'Nada':
            default:
                $arr_cB['puede'] = false;
                $arr_cB['quePuede'] = 'Nada'; break;
        }
    }
    else
    {
        $arr_cB['puede'] = false;
        $arr_cB['quePuede'] = 'Nada';
    }
    return $arr_cB;

}

function obtenNombredelPermisoenCuentaT($table='', $fieldName='')
{
    if($table=='' || $fieldName=='')
        return false;
    //echo "<pre>T: $table, F: $fieldName</pre>";
//    if($table== 'compra_pago' || $fieldName === 'compra_pago')
//    die("<pre>T: $table, F: $fieldName</pre>");
    $arr_tpctast = [];
    $arr_tpctast['cheque']['cuentaT_deliveredto_id']    = 'poner_delivered_cheques';
    $arr_tpctast['cheque']['aceptar_delivered_cheques'] = 'aceptar_delivered_cheques';
    $arr_tpctast['cheque']['cuentaT_transferto_id']     = 'aceptar_delivered_cheques';
    $arr_tpctast['cheque']['origen_cuentat_id']         = 'elegir_cuentat_origen_cheques';
    $arr_tpctast['pagare']['cuentaT_deliveredto_id']    = 'poner_delivered_pagares';
    $arr_tpctast['pagare']['origen_cuentat_id']         = 'elegir_cuentat_origen_pagares';
    $arr_tpctast['pagare']['aceptar_delivered_pagares'] = 'aceptar_delivered_pagares';
    $arr_tpctast['cuentat']['origen_cuentat_id']        = 'poner_delivered_cheques'; //bug en grid de Cheques.
    $arr_tpctast['cheque_pago']['cuentaT_id']           = 'abonar_a_cheques';
    $arr_tpctast['pagare_pago']['cuentaT_id']           = 'abonar_a_pagares';
    $arr_tpctast['vale']['cuentaT_id']                  = 'emitido_por_en_vales';
    $arr_tpctast['vale_pago']['cuentaT_id']                  = 'emitido_por_en_vales';
    $arr_tpctast['iac_usr']['cuentat_preferida_id']     = 'acceso';
    //$arr_tpctast['cuentat']['cuentaT_id']               = 'ver_saldo_y_movimientos'; //bug en grid de cuentat_mov.
    //VCA 15-09-2021 nuevo permiso para ver saldo y movimientos.
    $arr_tpctast['cuentat']['cuentaT_id']               = 'puede_ver_cuentat'; //bug en grid de cuentat_mov.

    $arr_tpctast['cuentat_mov']['link_cuentat_a_banco'] = 'link_cuentat_a_banco'; //Manual, aquí iacase no manda esta tabla, ni el campo.
    $arr_tpctast['deuda_pago']['cuentaT_id']            = 'pagar_deudas';
    $arr_tpctast['gasto_pago']['cuentaT_id']            = 'pagar_gastos';
    //$arr_tpctast['cuentat_ingreso']['cuentaT_id']       = 'acceso';

    $arr_tpctast['cuentat_ingreso']['cuentaT_id']       = 'ingreso_directo';
    $arr_tpctast['compra_pago']['cuentaT_id']       = 'pagar_compras';

    return $arr_tpctast[$table][$fieldName];
}

function cuentasTPuede($quienPuedeID='', $quePuede='', $formato='csv')
{
    global $arr_ctasT;
    global $arr_permisoctasT;
    global $arr_tiendasPuede;

    $arrTiendasQuePuedeKeys = array('cheque_Editar'=>array('que'=>'cheque','puede'=>'Editar'),
        'cheque_Consultar'=>array('que'=>'cheque','puede'=>'Consultar'),
        'pagare_Editar'=>array('que'=>'pagare','puede'=>'Editar'),
        'pagare_Consultar'=>array('que'=>'pagare','puede'=>'Consultar'),
        'vale_Editar'=>array('que'=>'vale','puede'=>'Editar'),
        'vale_Consultar'=>array('que'=>'vale','puede'=>'Consultar'));

    $arr_ctasTPuede = [];
    $csv_ctasTPuede = '';

    if(empty($quePuede))
    {
        if($formato === 'csv')
        {
            return "''";
        }
        else
            return $arr_ctasTPuede;
    }

    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if($quienPuedeID != $_SESSION['usuario_id']) //Para app_iac_usr
    {
        $arr_permisoctasT = null;
        $arr_ctasT = null;
    }

    $userProfile = ia_singleton("SELECT /*".__METHOD__."*/ * FROM iac_usr WHERE iac_usr_id = ".strit($quienPuedeID));
    $usuarioTipoRony = usuarioTipoRony($quienPuedeID);


    if($arr_permisoctasT == null || $arr_ctasT == null)
    {

        $sql = "SELECT /*cuentasTPuede*/  * FROM permiso_ctat WHERE iac_usr_id =  " . strit($quienPuedeID);
        $arr_permisoctasT = ia_sqlArray($sql,'cuentaT_id');

        $sql = "SELECT /*cuentasTPuede*/  cuentaT_id, poner_delivered_cheques, poner_delivered_pagares FROM cuentat WHERE last_trasnfer_sent IS NOT NULL ORDER BY cuentaT_id DESC";
        $arr_ctasT=ia_sqlArray($sql,'cuentaT_id');
        //CAMBIAPLANTILLATIENDAS
        $sql = "SELECT  /*cuentasTPuede*/  pc.tienda_id, pc.permiso_cheque, pc.permiso_pagare, pc.permiso_cobranza, t.cuentaT_id
                FROM plantilla_cobranza pc
                JOIN iac_usr u ON u.plantillatienda_id=pc.plantillatienda_id
                JOIN cuentat t ON pc.tienda_id=t.tienda_id
                WHERE t.tienda_id > 0 AND u.iac_usr_id= " . strit($quienPuedeID) . " ORDER BY t.es_de";
        $arr_tiendasPuedeTmp=ia_sqlArray($sql,'cuentaT_id');

        if(is_array($arr_tiendasPuedeTmp)) foreach($arr_tiendasPuedeTmp as $kT => $vT)
        {
            $arr_tiendasPuede['cheque'][$kT] = [];
            $arr_tiendasPuede['pagare'][$kT] = [];
            $arr_tiendasPuede['vale'][$kT] = [];

            $arr_tiendasPuede['cheque'][$kT]['Editar'] = $vT['permiso_cheque'] === 'Editar';
            $arr_tiendasPuede['pagare'][$kT]['Editar'] = $vT['permiso_pagare'] === 'Editar';
            $arr_tiendasPuede['vale'][$kT]['Editar'] = $vT['permiso_cobranza'] === 'Editar';

            $arr_tiendasPuede['cheque'][$kT]['Consultar'] = $vT['permiso_cheque'] === 'Consultar' || $vT['permiso_cheque'] === 'Editar';
            $arr_tiendasPuede['pagare'][$kT]['Consultar'] = $vT['permiso_pagare'] === 'Consultar' || $vT['permiso_pagare'] === 'Editar';
            $arr_tiendasPuede['vale'][$kT]['Consultar'] = $vT['permiso_cobranza'] === 'Consultar' || $vT['permiso_cobranza'] === 'Editar';
        }

        //echo "<pre>arr_permisoctasT".print_r($arr_permisoctasT, true)."</pre>";
        //echo "<pre>arr_ctasT".print_r($arr_ctasT, true)."</pre>";

        //Aqui vamos a planchar los permisos de poner_delivered_cheques y poner_delivered_pagares
        if(is_array($arr_ctasT)) foreach($arr_ctasT as $kctaTID => $vctaT)
        {
            //echo "<pre>$kctaTID + ".print_r($vctaT, true)."</pre>";
            if(array_key_exists($kctaTID,$arr_permisoctasT))
            {

                //echo "<pre>".print_r($arr_permisoctasT[$kctaTID], true)."</pre>";
                if(array_key_exists('poner_delivered_cheques',$arr_permisoctasT[$kctaTID]))
                    if($vctaT['poner_delivered_cheques'] === 'No')
                        $arr_permisoctasT[$kctaTID]['poner_delivered_cheques'] = $vctaT['poner_delivered_cheques'];
                if(array_key_exists('poner_delivered_pagares',$arr_permisoctasT[$kctaTID]))
                    if($vctaT['poner_delivered_pagares'] === 'No')
                        $arr_permisoctasT[$kctaTID]['poner_delivered_pagares'] = $vctaT['poner_delivered_pagares'];
            }
            else if($usuarioTipoRony)
            {
                $arr_permisoctasT[$kctaTID] = [];
                $arr_permisoctasT[$kctaTID]['cuentaT_id'] = $kctaTID;
                $arr_permisoctasT[$kctaTID]['poner_delivered_cheques'] = 'Si';
                $arr_permisoctasT[$kctaTID]['poner_delivered_pagares'] = 'Si';
            }

        }
    }


    //Ahora revisamos uno a uno los permisos solicitados.
    if(!is_array($quePuede))
    {
        $tmp = [];
        $tmp[] = $quePuede;
        $quePuede = $tmp;
    }

    /**
    echo "<pre>qP: ".print_r($quePuede,true)."</pre>";
    echo "<pre>pcT: ".print_r($arr_permisoctasT,true)."</pre>";
    echo "<pre>tiendas: ".print_r($arr_tiendasPuede, true)."</pre>";
     **/


    $arr_ctaTPuede = [];
    if(is_array($arr_permisoctasT))
        foreach($arr_permisoctasT as $kctaTID=>$vctaT)
        {
            //Usuario Tipo Rony puede todo en todas las Cuentas T. 23/02/2015
            if($usuarioTipoRony)
            {
                $arr_ctaTPuede[$kctaTID]['cuentaT_id'] = $vctaT['cuentaT_id'];
                continue;
            }

            foreach($quePuede as $nPermiso)
            {
                //Metemos la revision de las tiendas 13-06-2014
                if(array_key_exists($nPermiso,$arrTiendasQuePuedeKeys))
                {
                    if(array_key_exists('que', $arrTiendasQuePuedeKeys[$nPermiso]))
                        if(array_key_exists($kctaTID, $arr_tiendasPuede[$arrTiendasQuePuedeKeys[$nPermiso]['que']]))
                            if($arr_tiendasPuede[$arrTiendasQuePuedeKeys[$nPermiso]['que']][$kctaTID][$arrTiendasQuePuedeKeys[$nPermiso]['puede']])
                                $arr_ctaTPuede[$kctaTID]['cuentaT_id'] = $vctaT['cuentaT_id'];
                }
                else
                {
                    if(array_key_exists($nPermiso,$vctaT))
                        if($nPermiso != 'poner_delivered_cheques' && $userProfile['cuentat_unica'] === 'Si' && !empty($userProfile['cuentat_preferida_id']))
                        {
                            if($vctaT[$nPermiso] === 'Si' && $kctaTID == $userProfile['cuentat_preferida_id'])
                                $arr_ctaTPuede[$kctaTID]['cuentaT_id'] = $vctaT['cuentaT_id'];
                        }
                        else
                            if($vctaT[$nPermiso] === 'Si')
                                $arr_ctaTPuede[$kctaTID]['cuentaT_id'] = $vctaT['cuentaT_id'];
                }
            }
        }


    //echo "<pre>TIENDAS".print_r($arr_tiendasPuede, true)."</pre>";
    //echo "<pre>TIENDAS KEY".print_r($arrTiendasQuePuedeKeys, true)."</pre>";

    //echo "<pre>PERMISO".print_r($quePuede, true)."</pre>";
    //echo "<pre>CUENTAT T".print_r($arr_ctaTPuede, true)."</pre>";
    //echo "<pre>".print_r($userProfile, true)."</pre>";

    //Movemos la cuenta T preferida si existe al primer lugar.
    if(sizeof($arr_ctaTPuede) > 1)
        arrayMovetoTop($arr_ctaTPuede,$userProfile['cuentat_preferida_id']);


    //echo "<pre>".print_r($arr_ctaTPuede, true)."</pre>";
    //Llenamos el CSV o el array con las que sí puede.
    if(is_array($arr_ctaTPuede)) foreach($arr_ctaTPuede as $k=>$v)
    {
        if($formato === 'csv')
            $csv_ctasTPuede.=stritc($v['cuentaT_id']);
        else
            $arr_ctasTPuede[$k] = $v['cuentaT_id'];
    }

    if($formato === 'csv')
    {
        if(strlen($csv_ctasTPuede)>0)
            $csv_ctasTPuede = substr_replace($csv_ctasTPuede ,"",-1);
        else
            $csv_ctasTPuede = "''";
        return $csv_ctasTPuede;
    }
    return $arr_ctasTPuede;
}

function tienePermisoEnVale($quienTienePermisoID='', $vale_id='')
{
    if(empty($vale_id))
        return false;
    $method = __FUNCTION__;
    $vale = ia_singleton("SELECT /*$method*/ * FROM vale WHERE vale_id=".strit($vale_id));
    //echo "<pre>".print_r($vale, true)."</pre>";
    if(empty($vale))
        return false;

    if(empty($quienTienePermisoID))
        $quienTienePermisoID = $_SESSION['usuario_id'];

    if(usuarioTipoRony($quienTienePermisoID))//== 1 || ia_singleread("SELECT tipo FROM iac_usr WHERE iac_usr_id = ".strit($quienTienePermisoID)) === 'Super user')
        return true;

    //$sql = "SELECT * FROM vale_permiso WHERE (iac_usr_id=".strit($quienTienePermisoID)." OR tienda_id IN (SELECT tienda_id FROM usuario_cobranza u WHERE permiso='editar' AND  u.iac_usr_id=".strit($quienTienePermisoID).")) AND vale_id = ".strit($vale_id);
    //CAMBIAPLANTILLATIENDAS
    $sql = "SELECT /*$method*/ * FROM vale_permiso vp WHERE
        ( vp.iac_usr_id=".strit($quienTienePermisoID)." OR
            vp.tienda_id IN (SELECT tienda_id FROM plantilla_cobranza p JOIN iac_usr u ON u.plantillatienda_id=p.plantillatienda_id WHERE p.permiso_cobranza='Editar' AND  u.iac_usr_id=".strit($quienTienePermisoID).")
        ) AND vp.vale_id = ".strit($vale_id);

    $arr_VPxU=ia_sqlArray($sql,'vale_permiso_id');
    //echo "<pre>$arr_VPxU</pre>";
    return !empty($arr_VPxU) || puedeCuentaT($vale['cuentaT_id'],$quienTienePermisoID,'emitido_por_en_vales');
}

function puedeClientes($quienPuedeID='', $quePuede='leer')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    $utr = usuarioTipoRony($quienPuedeID);

    if($utr)
        return true;

    $puedeClientes=ia_singleread("SELECT puede_clientes FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puedeClientes === 'No')
        return false;

    switch($quePuede){
        case 'leer':
            if($puedeClientes === 'Si' || $puedeClientes === 'RO')
                return true;
            break;

        case 'insertar':case 'editar':
        if($puedeClientes === 'Si')
            return true;
        break;

        case 'borrar':
            if($utr)
                return true;
            else
                return false;

    }
    //echo "<pre>$quePuede:$puedeClientes</pre>";

    if($puedeClientes === 'Si')
        return true;
    else
        return false;
}

function puedeGastosBanco($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return 'Si';
    $method = __FUNCTION__;
    return ia_singleread("SELECT /*$method*/ puede_gasto FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));
}

function puedeGastosCuentaT($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return true;

    // dd_("SELECT puede_gasto_ctat FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    $puede=ia_singleread("SELECT puede_gasto_ctat FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puede === 'Si')
        return true;
    else
        return false;
}

function puedeFiduciario($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return true;

    $puede=ia_singleread("SELECT puede_fiduciario FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puede === 'Si')
        return true;
    elseif($puede === 'RO')
        return 'RO';
    return false;
}

function puedeBancosChina($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return true;
    $method = __FUNCTION__;
    $puede=ia_singleread("SELECT /*$method*/ puede_banco_china FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puede === 'Si')
        return true;
    else
        return false;
}

/**
 * @param string $quienPuedeID
 * @param string $nombrePermiso
 * @param bool $valorReal
 * @return bool|string
 */
function puedePermisoUsuario($quienPuedeID='', $nombrePermiso='', $valorReal = false)
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'] ?? 0;

    if(empty($quienPuedeID) || empty($nombrePermiso))
        return false;

    if(usuarioTipoRony($quienPuedeID)){
        if(!$valorReal)
            return true;
        return 'Si';
    }
    /*
    $supervisorBodegaPuede = [
        'puede_ser_encargado_bodega' => true,
        'puede_solo_consultar_bodegas' => true,
        'puede_solicitar_traslado_efectivo' => true,
        'puede_ver_modulo_solicitar_traslado_efectivo' => true,
        'puede_ver_traslados_match' => true,
        'puede_origen_huerfano' => true,
        'puede_consultar_existencia' => true,
        'puede_bodega_destinos_especiales' => true,
    ];
    if(!empty($supervisorBodegaPuede[$nombrePermiso]) && usuarioSupervisaBodega($quienPuedeID)) {
        return $valorReal ? 'Si' : true;
    }
    */
    static $permiso = [];
    if(!isset($permiso[$quienPuedeID])) {
        $method = __FUNCTION__;
        $permiso[$quienPuedeID] = ia_singleton("SELECT /*$method*/ * FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));
    }
    if(!isset($permiso[$quienPuedeID][$nombrePermiso]))
        return $valorReal ? 'No' : false;
    return $valorReal ? $permiso[$quienPuedeID][$nombrePermiso] : $permiso[$quienPuedeID][$nombrePermiso] === 'Si';
}

function puedeIngresosDirectosCuentaT($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return true;

    $puede=ia_singleread("SELECT puede_ingreso_directo_a_cuentat FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puede === 'Si')
        return true;
    else
        return false;
}

/**
 * @param $vale_id
 * @return array
 */
function leerPermisosVale($vale_id)
{
    $arrPermisos=array( "txtPermisosXUsuario" => "",
        "divUsuariosconPermiso" => "",
        "divUsuariossinPermiso" => "");

    if(empty($vale_id))
        return $arrPermisos;

    $txtPermisosXUsuario="";
    $divUsuariosconPermiso="";
    $divUsuariossinPermiso="";

    //CODIGO PARA PERMISOS POR USUARIO
    $pxusql = "SELECT * FROM vale_permiso WHERE vale_id = " . strit($vale_id);
    $pxuarray = ia_sqlArrayIndx($pxusql);

    $tspsql = "SELECT t.tienda_id, t.clave FROM tienda t WHERE t.tienda_id NOT IN (SELECT v.tienda_id FROM vale_permiso v WHERE v.vale_id = " . strit($vale_id) .")";
//    echo "<li>$tspsql";
    $tsparray = ia_sqlArrayIndx($tspsql);

    $uspsql = "SELECT u.iac_usr_id, u.nick FROM iac_usr u WHERE u.vale='Active' AND u.iac_usr_id NOT IN (SELECT v.iac_usr_id FROM vale_permiso v WHERE v.vale_id =  " . strit($vale_id) .")";
    $usparray = ia_sqlArrayIndx($uspsql);

    $tarray = ia_sqlArray("SELECT t.tienda_id, t.clave FROM tienda t",'tienda_id');
    $uarray = ia_sqlArray("SELECT u.iac_usr_id, u.nick FROM iac_usr u WHERE u.vale='Active' ",'iac_usr_id');

    if(is_array($pxuarray)) foreach($pxuarray as $v)
    {
        if(!empty($v['tienda_id']))
        {
            $tienda=$tarray[$v['tienda_id']]['clave'];
            $txtPermisosXUsuario.=" T-$tienda,";
            $divUsuariosconPermiso.='<div id="'.$v['vale_permiso_id'].'" data-iac_usr_id="" data-tienda_id="'.$v['tienda_id'].'" data-nick="" data-clave="'.$tienda.'" data-vale_id="'.$vale_id.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding:5px"><strong>T-'.$tienda.'</strong><a href="javascript:void(0)" onclick="quitaPermiso('.$v['vale_permiso_id'].')">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Quitar Permiso a Tienda." title="Quitar Permiso a Tienda." /></a>&nbsp;&nbsp;</div>';
        }
        else
        {
            $nick=$uarray[$v['iac_usr_id']]['nick'];
            $txtPermisosXUsuario.=" $nick,";
            $divUsuariosconPermiso.='<div id="'.$v['vale_permiso_id'].'" data-iac_usr_id="'.$v['iac_usr_id'].'" data-tienda_id="" data-nick="'.$nick.'" data-clave="" data-vale_id="'.$vale_id.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding:5px"><strong>'.$nick.'</strong><a href="javascript:void(0)" onclick="quitaPermiso('.$v['vale_permiso_id'].')">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Quitar Permiso a Usuario." title="Quitar Permiso a Usuario." /></a>&nbsp;&nbsp;</div>';
        }
    }
    if(!empty($txtPermisosXUsuario)) $txtPermisosXUsuario = substr_replace($txtPermisosXUsuario,"",-1);

    if(is_array($tsparray)) foreach($tsparray as $v)
    {
        $tienda=$tarray[$v['tienda_id']]['clave'];
        $divUsuariossinPermiso.='<div id="" data-iac_usr_id="" data-tienda_id="'.$v['tienda_id'].'" data-nick="" data-clave="'.$tienda.'" data-vale_id="'.$vale_id.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding5px;"><strong>T-'.$tienda.'</strong><a href="javascript:void(0)" onclick="daPermisoTienda('.$v['tienda_id'].')">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Dar Permiso a Tienda." title="Dar Permiso a Tienda." /></a>&nbsp;&nbsp;</div>';
    }
    if(is_array($usparray)) foreach($usparray as $v)
    {
        $nick=$uarray[$v['iac_usr_id']]['nick'];
        $divUsuariossinPermiso.='<div id="" data-iac_usr_id="'.$v['iac_usr_id'].'" data-tienda_id="" data-nick="'.$nick.'" data-clave="" data-vale_id="'.$vale_id.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding:5px"><strong>'.$nick.'</strong><a href="javascript:void(0)" onclick="daPermisoUsuario('.$v['iac_usr_id'].')">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Dar Permiso a Usuario." title="Dar Permiso a Usuario." /></a>&nbsp;&nbsp;</div>';
    }

    $divUsuariosconPermiso='<div id="valeUsuariosconPermiso" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= USUARIOS Y TIENDAS CON PERMISO =-</strong><hr/><br/>'.$divUsuariosconPermiso.'</div>';
    $divUsuariossinPermiso='<div id="valeUsuariossinPermiso" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= USUARIOS Y TIENDAS SIN PERMISO =-</strong><hr/><br/>'.$divUsuariossinPermiso.'</div>';

     return ["txtPermisosXUsuario"   => $txtPermisosXUsuario,
        "divUsuariosconPermiso" => $divUsuariosconPermiso,
        "divUsuariossinPermiso" => $divUsuariossinPermiso];

}

function cuentas_banco_cuales_puede($que_puede='consultar', $tipo_empresa_privada=false, $strict_parameters=false)
{
    $que_puede = $que_puede === 'consultar';
    $sql = cuenta_banco_mov_list_sql('r',false, false, null, false, false, $que_puede, $tipo_empresa_privada, strict_parameters:$strict_parameters);
    return ia_sqlArray($sql,'banco_cuenta_id');
}

function obtenNickdelUsuario($uid)
{
    return ia_singleread("SELECT nick FROM iac_usr WHERE iac_usr_id = " . strit($uid));
}

function getAllParams()
{
    $_PARAMS = ($_SERVER["REQUEST_METHOD"] === 'POST') ? $_POST : $_GET;
    $params = [];

    foreach($_PARAMS as $key=>$value )
        if(str_contains($key, "remark"))
            $params[$key] = $_REQUEST[$key] ?? "";
        else
            $params[$key] = param($key);

    return $params;
}

function leeParametrosVitex($fuerza=false)
{
    $method = __METHOD__;
    global $gIAParametros;

    if(empty($gIAParametros) || $fuerza) {
        $gIAParametros = ia_singleton("SELECT /*$method*/ * FROM iac_parametros");

        $iac_usr_sql = "SELECT /*$method*/ * FROM iac_usr WHERE vale='Active'";
        $gIAParametros['iac_usr'] = ia_sqlArrayIndx($iac_usr_sql);

        $gIAParametros['do_flash_tab'] = false;
        $gIAParametros['use_ws_server'] = $gIAParametros['use_ws_server']??'' == 'No';
//        $gIAParametros =[...$gIAParametros,
//            ...ia_sqlKeyValue("SELECT  /*$method*/ parametro_id, JSON_UNQUOTE(JSON_EXTRACT(parametros, '$.valor')) FROM parametro"),
//            ...ia_sqlKeyValue("SELECT jt.* FROM parametro CROSS JOIN JSON_TABLE(parametros,'$[*]' COLUMNS (id VARCHAR(100) PATH '$.id',valor VARCHAR(100) PATH '$.valor')) AS jt")
//        ];
    }
}


function getParametros()
{

    $query = ia_sqlArrayIndx("SELECT parametro_id, JSON_UNQUOTE(JSON_EXTRACT(parametros, '$.valor')) as valor FROM parametro");
    $params_new_table = [];
    foreach ($query as  $value) {
        $params_new_table[$value['parametro_id']] = $value['valor'];
    }
    return $params_new_table;

}

function puedeInversion($quienPuedeID='')
{
    if(empty($quienPuedeID))
        $quienPuedeID = $_SESSION['usuario_id'];

    if(empty($quienPuedeID))
        return false;

    if(usuarioTipoRony($quienPuedeID))
        return true;

    $puede=ia_singleread("SELECT puede_inversion FROM iac_usr WHERE iac_usr_id =".strit($quienPuedeID));

    if($puede === 'Si')
        return true;
    else
        return false;
}

/**
 * @param string|int|null $user_id
 * @return bool
 */
function esRevisor($user_id = null) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    return puedeRevisarGastosCuentaT($user_id);
    /* $sql = "SELECT COUNT(*) registros_asignados FROM asignacion WHERE usuario_id = $user_id";
    $registros_asignados = ia_singleread($sql);
    if ($registros_asignados > 0) {
        return true;
    }
    return false; */
}

/**
 * @param null $user_id
 * @return bool
 */
function esRevisorBanco($user_id = null) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    return puedeRevisarGastosBanco($user_id);
    /* $sql = "SELECT COUNT(*) registros_asignados FROM asignacion WHERE usuario_id = $user_id";
    $registros_asignados = ia_singleread($sql);
    if ($registros_asignados > 0) {
        return true;
    }
    return false; */
}

/**
 * @param null $user_id
 * @return bool
 */
function puedeRevisarGastosCuentaT($user_id = null):bool {
    $method = __METHOD__;
    return ia_singleread(
        "SELECT /*$method*/ puede_revisar_gastos_cuentaT 
            FROM iac_usr 
            WHERE iac_usr_id = " . strit($user_id == null ? $_SESSION['usuario_id'] : $user_id)) === 'Si';
    // return esRevisor($user_id);
}

/**
 * @param null $user_id
 * @return bool
 */
function puedeRevisarGastosBanco($user_id = null) {
    if(usuarioTipoRony())
        return true;
    $method = __FUNCTION__;
    return ia_singleread(
            "SELECT /*$method*/ puede_revisar_movimientos_banco 
        FROM iac_usr 
        WHERE iac_usr_id = " . strit($user_id == null ? $_SESSION['usuario_id'] : $user_id)
        ) === 'Si';
    // return esRevisor($user_id);
}


function tengoActivaAlertaGastos($user_id = null)
{
    $method = __FUNCTION__;
    return ia_singleread(
        "SELECT /*$method*/ activa_alerta_gastos 
        FROM iac_usr 
        WHERE iac_usr_id = " . strit($user_id == null ? $_SESSION['usuario_id'] : $user_id)
    );
}

/**
 * Altas bajas y cambios a colores de los productos
 *
 * @param int|string $user_id
 * @return bool
 */
function puedeAdministrarColores($user_id = ''):bool {
    return puedeAdministrarProductosGenerales($user_id);
}

/**
 * Obtiene el permiso para saber si puede consultar colores de productos (R/O)
 * @return bool [true, false], el usuario tiene permiso (true => el usuario tiene permiso, false => el usuario no tiene permiso)
 */
function puedeConsultarColores($user_id = ''):bool
{
    return puedeConsultarProductosGenerales($user_id);
}

/**
 * Puede dar de alta, editar y quitar productos generales y sus colores
 *
 * @param int|string $user_id
 * @return bool
 */
function puedeAdministrarProductosGenerales($user_id = ''):bool
{
    return usuarioSupervisaBodega() || Permisador::puede('productos', 'Nada', $user_id) === 'R/W';
}

/**
 * Puede dar de alta, editar y quitar productos generales y sus colores
 *
 * @param int|string $user_id
 * @return bool
 */
function puedeConsultarProductosGenerales($user_id = ''):bool
{
    return usuarioSupervisaBodega() || Permisador::puede('productos', 'Nada', $user_id) !== 'Nada';
}

/**
 * Obtiene el permiso para saber si puede administrar productos_color (c_ud) Cambios a detalles
 * @return bool true tiene el permiso, false no lo tiene
 */
function puedeAdministrarProductosColor($user_id = ''):bool
{
    return puedeAdministrarProductosGenerales($user_id);
}

/**
 * Obtiene el permiso para saber si puede puede prohibir colores
 * @return bool true tiene el permiso, false no lo tiene
 */
function puedeProhibirColor($user_id = null):bool
{
    return usuarioTipoRony() || Permisador::puede('puede_prohibir_colores', 'No', $user_id ?? $_SESSION['usuario_id'])!=='No';
}
function puedeAsignarColor($user_id = null):bool
{
    return usuarioTipoRony() || Permisador::puede('puede_asignar_colores', 'No', $user_id ?? $_SESSION['usuario_id'])!=='No' ;
}

/**
 * Obtiene el permiso para saber si puede consultar detalles cambiados a producto color
 * @return bool true tiene el permiso, false no lo tiene
 */
function puedeConsultarProductosColor($user_id = ''):bool
{
    return puedeConsultarProductosGenerales($user_id);
}

function tiene_que_revisar_gastos_cuentat()
{
    return Permisador::puede('tiene_que_revisar_gastos_cuentat') === 'Si';
}
function puede_solicitar_tipo_cambio_tempral()
{
    if (usuarioTipoRony())
        return true;

    return Permisador::puede('crear_tc_temporal') === 'Si';
}

function puede_entrar_a_parametros()
{
    $usuarios_exception = [];
    // agregar más permisos que permiten entrar a iac_parametros
    if (
        in_array($_SESSION['usuario_id'], $usuarios_exception) ||
        Permisador::puede('crear_tc_temporal') === 'Si' // permiso para crear tc temporal
    )
        return true;

    return false;
}

function puede_entrar_a_costos_contenedor()
{
    return usuarioTipoRony() || Permisador::puede('entrar_impuestos_contenedor') === 'Si';
    /*return true;
    $usuarios_exception = ['129', '107'];
    // agregar más permisos que permiten entrar a iac_parametros
    if (
        usuarioTipoRony() ||
        in_array($_SESSION['usuario_id'], $usuarios_exception)
    )
        return true;

    return false*/;
}

function puede_entrar_a_precios_de_venta()
{
    return usuarioTipoRony() || Permisador::puede('entrar_precios_venta') === 'Si';
}

function puede_administrar_catalogos_impuestos_contenedor()
{
    return usuarioTipoRony() || Permisador::puede('administrar_catalogos_impuestos_contenedor') === 'Si';
}

function puede_ver_pedimentos_borrados()
{
    $usuarios_exception = ['129'];
    return usuarioTipoRony() || in_array($_SESSION['usuario_id'], $usuarios_exception);
}

function puede_entrar_a_estados()
{
    $usuarios_exception = ['129'];
    // agregar más permisos que permiten entrar a app_estado
    $_puede_entrar = (usuarioTipoRony()||in_array($_SESSION['usuario_id'], $usuarios_exception));
    if ($_puede_entrar)
        return true;

    $origen = param('origen');
    $puede_entrar_a_precios_de_venta = false;
    if ($origen === 'template_import_productos_pv')
        $puede_entrar_a_precios_de_venta = puede_entrar_a_precios_de_venta();

    return $_puede_entrar||$puede_entrar_a_precios_de_venta;
}