<?php
function productosOcultosActivoInactivo():string {
    $method = __FUNCTION__;
    return json_decode(ia_singleread(
      "SELECT user_json_data.data FROM user_json_data WHERE iac_usr_id=1 AND name='producto_oculto' AND tema='bodega_reporte_ventas'", '"Si"'
    ) );
}
function reporte_ventas_defaults(bool $saveToDefaults):array {
    unset($_REQUEST['maximize'], $_POST['maximize'], $_GET['maximize']);
    $userDefaults = usuario_defaults_get('bodega/bodega_reporte_ventas.php');
    unset($userDefaults['oculto'], $userDefaults['ocultos']);
    $recuerda =[
        'tipo' => 'Olla',
        'dias_entrega'=>80,
        'ver_qty_rolls' => 'Qty',
        'unidades_id' => '',
        'fecha_min' => '',
        'fecha_max' => '',
        'bodega_id_all' => 'all',
        'bodega_id' => '',

        'pedir' => '',
        'en_remate' => '',
        'es_saldo' => '',
        'super_lento' => '',
        'lento' => '',

         'oculto' => 'No',


        // 'escondido' => '',
        'con_existencia_quantity' => '',

        'producto_general_id' => '',
        'color_id' => '',

        'ver_articulos_ocultos' => '',

        'ver_unidad' => '1',
        'statusAndOr' => 'or',

        'ver_min_rollos' => '0',
        'ver_articulos_pedidos' => '',

    ];
    $sinFiltro = empty($_REQUEST['usuario_filtra']);
    $defaults = ['usaDefaults' => $sinFiltro];
    foreach($recuerda as $nombre => $valor) {
        if(!array_key_exists($nombre, $userDefaults))
            $userDefaults[$nombre] = $valor;
        if($sinFiltro)
            $defaults[$nombre] = $userDefaults[$nombre];
        else
            $defaults[$nombre] = $_REQUEST[$nombre] ?? $valor;
    }
    // global $gDime;
    $gDime['defaults saved era'] = $userDefaults;
    $gDime['recuerda'] = $recuerda;
    $gDime['_REQUEST'] = $_REQUEST;
    $gDime['defaults'] = $defaults;

    // válida los datos
    if(empty( $defaults['dias_entrega']) || !is_numeric( $defaults['dias_entrega']))
        $defaults['dias_entrega'] = $recuerda['dias_entrega'];
    if($userDefaults['tipo'] !== 'Olla' && $userDefaults['tipo'] !== 'Programacion')
        $defaults['tipo'] = $recuerda['tipo'];
    if($defaults['statusAndOr'] !== 'or' && $defaults['statusAndOr'] !== 'and')
        $defaults['statusAndOr'] = 'or';
    if(!empty($defaults['fecha_min']) && !empty($defaults['fecha_max']) && $defaults['fecha_min'] > $defaults['fecha_max']) {
        $temp = $defaults['fecha_min'];
        $defaults['fecha_min'] = $defaults['fecha_max'];
        $defaults['fecha_max'] = $temp;
    }
    if($saveToDefaults)
        usuario_defaults_set(
          array_intersect_key($defaults, $recuerda),
          'bodega/bodega_reporte_ventas.php'
        );
    return $defaults;
}

function getRecomiendaPedido(bool $paraOlla = true):string|false {
    if(usuarioTipoRony() || Permisador::puede('puede_reporte_ventas') === 'Pedir') {
        $tipo = $paraOlla ? "'Olla'" : "'Programacion'";
        $where = "activo='Si' AND tipo = $tipo AND iac_usr_id=" . strit($_SESSION['usuario_id'] ?? '0');
        $function = __FUNCTION__;
        $pedido_recomienda_id = ia_singleread("SELECT /*$function*/ pedido_recomienda_id FROM pedido_recomienda WHERE $where ORDER BY alta_db DESC LIMIT 1");
        if(!empty($pedido_recomienda_id))
            return $pedido_recomienda_id;
        if($pedido_recomienda_id === false)
            throw new Exception("DB Error");

        $insert = "INSERT /*$function*/ INTO pedido_recomienda(tipo, iac_usr_id, nombre) 
                VALUES($tipo," .strit($_SESSION['usuario_id']) . ',' . Date("'d/M/y H:i'") . ")";
        return ia_insertIded($insert);
    }
    return '';
}

function reporte_ventas_filtro_describe(BodegaReportes $bodegaReportes, array $defaults):array {

    $method = __FUNCTION__;
    unset($defaults['notas'], $defaults['Notas'], $defaults['tipo']);
    $bodegaReportes->notasArticuloWhereNew($defaults);
    $describe = $bodegaReportes->notasArticulosDescribeWhere;
    $describeOcultosArray = $bodegaReportes->ventas_no_salen_describe($defaults);
    if( !empty($describeOcultosArray))
        $describe[] = '<details class="default"><summary class="tooltip_grid" style="color:#FF00FF" title="Artículos que se muestran únicamente si tienen existencia<br>Click para verlos">¡Hay Artículos Ocultos!</summary><div>
            Estos únicamente se muestran si tienen existencia o pedido en china. 
            <ul class="ocultoColumn" style="color:#FF00FF"><li>' . implode("<li>", $describeOcultosArray) . "</ul>
            </div></details>";

    if($defaults['ver_articulos_pedidos'] !== 'todo' && $defaults['ver_articulos_pedidos'] !== '')
        $describe[] = "Mostrando Artículos: <b class='yaPedido'>" . ucwords(str_replace('_', ' ', $defaults['ver_articulos_pedidos']  )) . "</b>";
    $productosOcultosPedidos = ia_sqlVector(
        "
            SELECT /*$method*/ DISTINCT CONCAT(pg.producto, ' ', c.color)
            FROM pedido_items pei JOIN pedido p on pei.pedido_id = p.pedido_id
                JOIN producto_general pg on pei.producto_general_id = pg.producto_general_id
                JOIN producto_color_oculta pco on pg.producto_general_id = pco.producto_general_id AND pei.color_id=pco.color_id AND pco.activo='Si' AND pco.reporte = 'ReporteVentas'
                JOIN color c on pei.color_id = c.color_id
            WHERE p.mostrar_en_ventas = 'Si'
            UNION
            SELECT DISTINCT pg.producto
            FROM pedido_items pei JOIN pedido p on pei.pedido_id = p.pedido_id
                JOIN producto_general pg on pei.producto_general_id = pg.producto_general_id
                JOIN producto_color_oculta pco on pg.producto_general_id = pco.producto_general_id AND pco.color_id='' AND pco.activo='Si' AND pco.reporte = 'ReporteVentas'
            WHERE p.mostrar_en_ventas = 'Si'
            UNION
            SELECT DISTINCT c.color
            FROM pedido_items pei JOIN pedido p on pei.pedido_id = p.pedido_id
                JOIN producto_general pg on pei.producto_general_id = pg.producto_general_id
                JOIN producto_color_oculta pco on pco.producto_general_id='' AND pei.color_id=pco.color_id AND pco.activo='Si' AND pco.reporte = 'ReporteVentas'
                JOIN color c on pei.color_id = c.color_id
            WHERE p.mostrar_en_ventas = 'Si' ");
    if( !empty($productosOcultosPedidos))
        $describe[] = "<div style='color:red;width:fit-content;border:1px red solid;padding:0.3em'>" .
            implode(", ", $productosOcultosPedidos) . " Tienen <b>Pedido a China</b> con <b>Mostrar</b> en Ventas <b>Si</b> pero estan en <b>PRODUCTOS OCULTOS</b></div>";
    if($defaults['ver_min_rollos'] !== '' && $defaults['ver_min_rollos'] !== '0'  && $defaults['ver_min_rollos'] !== '1')
        $describe[] = "Artículos que <b>vendieron al menos " . $defaults['ver_min_rollos'] . " Rollos.</b>";
    $legend = empty($describe) ? "Sin Filtros" : '<span class="filtradoPorIcon">⚠️</span> Filtros/Avisos:';
    $describeLi = implode("<li>", $describe);
    $hay = count($describe);
    return  ['hay' => count($describe),  'html' => <<< HTML
        <fieldset id='filtradoPor' title="🕱 Avisos" 
            style='display:none;padding:1em;margin:1em;border:1px lightblue solid;width:fit-content;'>
            <legend>$legend
                <span title="Copiar artículos ocultos" data-clipboard-target='#filtradoPorLi' style="cursor:copy" class="ui-icon ui-icon-copy copyClipBloard noprint"></span>
                <span class="ui-icon ui-icon-print noprint" style="cursor:pointer;" onclick="printElement('#filtradoPor')"></span></legend>
            </legend>
            <ul id="filtradoPorLi"><li>$describeLi</li></ul>
        </fieldset><script>
           jQuery(function($){ let data={hayFiltros:"$hay"}; \$("#avisos").html(data.hayFiltros > 0 ? `<button type="button" style="color:red"><span>⚠️</span> !Hay \${data.hayFiltros} Filtros!</button>` : "<span style='color:black'>Sin Filtrar</span>"); });
        </script>
HTML
    ];
}

function reporte_ventas_filtro_display($bodegaReportes, $defaults):string {
    unset($defaults['tipo'], $defaults['fecha'], $defaults['bodega_id']);

    $filterIt = new FilterIt($defaults, $defaults);

    $filtros = reporte_ventas_filtro_describe($bodegaReportes, $defaults);
    $describeFiltro = $filtros['html'];
    $defaults['ver_min_rollos'] === '' ? '' : (int)$defaults['ver_min_rollos'];
    return strim("<form title='Filtrar por' id='ElFiltro' method='POST' style='margin:0.5em;padding:0.5em;border:1px blue solid;display:none'>
        <input type='hidden' name='usuario_filtra' value='1'>
        <input type='hidden' id='tipo' name='tipo' value='' form='ElFiltro'>
        <div id='ElFiltroDivScroll' style='overflow:auto;max-height:800px!important;padding:0;margin:0;'>
            <span style='visibility: hidden'><input type='text' autofocus></span>
            <div style='display:flex;flex-wrap: wrap;flex-direction:row;padding:0 0.5em'>" .
       $filterIt->filterDefault(true) .
        <<<EOF
         <fieldset style='width: fit-content;display:flex;flex-wrap: wrap;gap:1.5em;flex-direction:column;padding:1em 0.2em;margin:0'>
             <div>
                <input type="submit" id='repBuscar' value="Buscar (F6)" style="font-size:1.4em;padding:0.2em 1em;cursor:pointer;box-shadow: 0 0 9px #000022;" 
                    class="btnGenerar-comodin btnGenerar-comodin-change">
            </div>
            <div>
                <button type="button" value="Reset" onclick="resetFiltro()" 
                    style="font-size:1.1em;padding:0.2em 1em;cursor:pointer;background-color: silver;" 
                    class="btnGenerar-comodin btnGenerar-comodin-change" title="Borra que buscar para mostrar todo. No cambia el Default">Quita el Filtro
                </button>
            </div>
            <div>
                <p>F8 Filtar</p>
                <p>F9 Maximizar grid</p>
            </div>
            <div style="font-size:0.8em">
                <label style="background-color: lightpink;box-shadow: 0 0 9px #000022;padding:0.5em">
                <input type="checkbox" id="default_query" value="default_query" name="default_query">al buscar hazlo Mi Default 🕱</label>
            </div>
            <div>
                <button type="button" value="clear" 
                    onclick="resetFiltro();document.getElementById('default_query').checked=true;this.form.submit();" 
                    style="font-size:1.1em;padding:0.2em 1em;cursor:pointer;background-color: silver;" 
                    class="btnGenerar-comodin btnGenerar-comodin-change" title="Borra el default">Elimina mi Default<p style='color:red'>¡Borralo para ver Todo!
                </button>
            </div>
        </fieldset>
    </div></form></div><div id='describeFiltro'>$describeFiltro</div>
EOF
    );
}

