<?php
/**
 * get_date_spanish()
 *
 * @param mixed $time
 * @param bool $part
 * @param string $formatDate
 * @return
 */
function get_date_spanish($time, $part = false, $formatDate = '', $formatMonth='month', $formatDayWeek='', $formatYear='Y')
{
    $time = empty($time) ? strtotime("now") : $time;

    $month = array("","enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiempre", "octubre", "noviembre", "diciembre");
    $month_execute = "n";

    $month_mini = array("","ENE", "FEB", "MAR", "ABR", "MAY", "JUN", "JUL", "AGO", "SEP", "OCT", "NOV", "DIC");
    $month_mini_execute = "n";

    $day = array("domingo","lunes","martes","miércoles","jueves","viernes","sábado");
    $day_execute = "w";

    $day_mini = array("DOM","LUN","MAR","MIE","JUE","VIE","SAB");
    $day_mini_execute = "w";



    $print_hoy = array("month"=>"month", "month_mini"=>"month_mini");

    if( $part === false )
    {
        $strMonth = '';
        $strDayWeek = '';

        if($formatDate!='small_date')
            $formatMonth='month_mini';

        $strMonth = ${$formatMonth}[date(${$formatMonth.'_execute'},$time)];
        $strDayWeek = empty($formatDayWeek) ? '' : ${$formatDayWeek}[date(${$formatDayWeek.'_execute'},$time)] . ', ';

        switch($formatDate)
        {
            case 'small_date':
                return date("d", $time) . "-" . $strMonth . "-". date($formatYear,$time);
                break;

            case 'mini_date':
                return date("d", $time) . "-" . $strMonth . "-". date($formatYear,$time);
                break;

            default:
                return $strDayWeek . date("d", $time) . " de " . $strMonth . " de ". date($formatYear,$time);
                break;
        }


    }
    elseif( $part === true )
    {
        //if( ! empty( $print_hoy[$formatDate] ) && date("d-m-Y", $time ) == date("d-m-Y") ) return "HOY";
        if( !empty(${$formatDate}) && !empty(${$formatDate}[date(${$formatDate.'_execute'},$time)]))
            return ${$formatDate}[date(${$formatDate.'_execute'},$time)];
        else
            return date($formatDate, $time);
    }
    else
    {
        return date("d-m-Y H:i", $time);
    }
}

function echonf($iCantidad, $donotecho = false, $depth = 2, $thsep=",")
{
    if(!$donotecho)
        echo number_format(floatval($iCantidad) ?? 0, $depth, '.', $thsep);
    else
        return number_format(floatval($iCantidad) ?? 0, $depth, '.', $thsep);
}

function BoldaString($s)
{
    return '<strong>'.$s.'</strong>';
}

function EstilizaCampo($tabla, $campo, $id_nombre, $id_valor, $atributo = '')
{
    $tabla = strit($tabla);
    $campo = strit($campo);
    $id_nombre = strit($id_nombre);
    $id_valor = strit($id_valor);

    if($atributo == '')
    {
        $estilosql = "SELECT * FROM estilos WHERE tabla = $tabla AND campo = $campo AND id_nombre = $id_nombre AND id_valor = $id_valor";
        $estiloarray = ia_sqlArrayIndx($estilosql);
        $styletxt = '';
        if($estiloarray) foreach($estiloarray as $k=>$estilorow)
        {
            $styletxt .= "$estilorow[atributo]:$estilorow[valor];";
        }
        return $styletxt;

    }
    else
    {
        $atributo  = strit($atributo);

        $estilosql = "SELECT * FROM estilos WHERE tabla = $tabla AND campo = $campo AND id_nombre = $id_nombre AND id_valor = $id_valor AND atributo = $atributo";
        $estiloarray = ia_singleton($estilosql);

        return $estiloarray["valor"];
    }
}

/**
 * isValueonArray
 *
 * Busca un valor en un array.
 * @param   $arr = Array en donde buscaremos. Puede ser un array de arrays.
 * @param   $val = Valor a buscar.
 * @return  $foundit = (int) la posición en el array principal en donde se encontró el valor.
 *          false si no se encontró el valor.
 */
function isValueonArray($arr, $val)
{
    $foundit = false;
    if(is_array($arr) && !empty($arr)) foreach($arr as $k=>$v)
    {
        if(is_array($v))
        {
            $foundit = isValueonArray($v, $val);
            if($foundit !== false)
                $foundit = $k;
        }
        else if($v == $val)
            $foundit = $k;
        if($foundit !== false)
            break;
    }
    return $foundit;
}

/**
 * doOperation()
 *
 * Hace una operacion en un array.
 * @param   $type = Tipo de operacion: COUNT, SUM, MAX, MIN.
 * @param   $arr = el array. si se manda llamar desde el modulo reporteador, puede enviar un array de arrays, entonces hay que especificar en que key viene el valor con el que se quiere hacer la operacion.
 * @param   $options = un array con opciones. la primera es $v_pos, por si envia un array de array, saber en qué posición está el valor. Es un entero, por default es cero. El segundo es $c_zero, si quieres que el contador discrimine el valor 0.00. Es un bool, true sí hace diferencia y no toma en cuenta los ceros. Por default es false.
 * @return  $result = el resultado de la operación.
 *          false si ocurrió un error.
 */
// MONEDA 25/OCT
// Arr Dif 24-06-2022
function doOperation($type, $arr, $v_pos = false, $mon=array(), $arr_dif=array(), $arr_totales = false)
{
    if($type == '')
        return false;
    $type = strtoupper($type);
    $result = false;

    $moneda=false;
    if(is_array($mon) && !empty($mon))
    {
        $moneda=true;
        $result=array();
    }

    $dif=false;
    if(is_array($arr_dif) && !empty($arr_dif))
    {
        $dif=true;
        $result=array();
    }

//    echo "<pre>arr_totales <br />".print_r($arr_totales, true)."</pre>";

    if($moneda===false && $dif===false)
    {
        switch ($type)
        {
            case 'COUNT':
                $result = sizeof($arr);
                break;

            case 'COUNTWZERO':
                $result = 0;
                foreach($arr as $k=>$v)
                {
                    if(is_array($v))
                    {
                        if($v[$v_pos] > 0.00)
                            $result++;
                    }
                    else
                    {
                        if($v > 0.00)
                            $result++;
                    }
                }
                break;

            case 'SUM':
                $tmpsum = 0;
                foreach($arr as $k=>$v)
                {
                    if(is_array($v))
                    {
                        if(is_numeric($v[$v_pos]))
                            $tmpsum += $v[$v_pos];
                    }
                    else if($v_pos === false && is_numeric($v))
                        $tmpsum += $v;
                    /*else if(is_array($v) && is_string($v[1]))
                    {
                        $v = $v[1];
                        $tmpsum .= $v;
                    }*/

                }
                $result = $tmpsum;
                break;

            case 'MAX':

                if(is_array($arr[0]))
                {
                    $tmpmax = $arr[0][$v_pos];
                    foreach($arr as $k=>$v)
                        if($v[$v_pos] > $tmpmax) $tmpmax = $v[$v_pos];
                }
                else
                {
                    $tmpmax = $arr[0];
                    foreach($arr as $k=>$v)
                        if($v > $tmpmax) $tmpmax = $v;
                }
                $result = $tmpmax;
                break;

            case 'MIN':
                if(is_array($arr[0]))
                {
                    $tmpmin = $arr[0][$v_pos];
                    foreach($arr as $k=>$v)
                        if($v[$v_pos] < $tmpmin) $tmpmin = $v[$v_pos];
                }
                else
                {
                    $tmpmin = $arr[0];
                    foreach($arr as $k=>$v)
                        if($v < $tmpmin) $tmpmin = $v;
                }
                $result = $tmpmin;
                break;

            default:
                return false;
                break;
        }
    }
    elseif($moneda===true)
    {
        $result[0] = 0;
        $result[1] = 0;
        switch ($type)
        {
            case 'COUNT':
                foreach($arr as $k=>$v)
                {
                    if($mon[$k][$v_pos]=='PESOS')
                        $result[0]++;
                    else
                        $result[1]++;
                }
                break;

            case 'COUNTWZERO':
                foreach($arr as $k=>$v)
                {
                    if(is_array($v))
                    {
                        if($v[$v_pos] > 0.00)
                            if($mon[$k][$v_pos]=='PESOS')
                                $result[0]++;
                            else
                                $result[1]++;
                    }
                    else
                    {
                        if($v > 0.00)
                            if($mon[$k][$v_pos]=='PESOS')
                                $result[0]++;
                            else
                                $result[1]++;
                    }
                }
                break;

            case 'SUM':
                foreach($arr as $k=>$v)
                {
                    if(is_array($v))
                    {
                        if(is_numeric($v[$v_pos]))
                        {
                            if($mon[$k][$v_pos]=='PESOS')
                                $result[0] += $v[$v_pos];
                            else
                                $result[1] += $v[$v_pos];

                        }
                    }
                    else if(is_numeric($v))
                    {
                        if($mon[$k][$v_pos]=='PESOS')
                            $result[0] += $v;
                        else
                            $result[1] += $v;
                    }
                }
                break;

            default:
                return false;
                break;
        }
    }
    elseif($dif===true)
    {
        $result[0] = 0;
//        $result[1] = 0;
        $dif_en_totales = $arr_totales[at_ValDif];
        $dif_es_array = is_array($dif_en_totales);
        $hubo_ambos_estados = false;
        switch ($type)
        {
            case 'COUNT':
                foreach($arr as $k=>$v)
                {
                    if(strtolower($arr_dif[$k][$v_pos])==strtolower($arr_totales[at_ValDif]))
                        $result[0]++;
                }
                break;

            case 'COUNTWZERO':
                foreach($arr as $k=>$v)
                {
                    if(is_array($v))
                    {
                        if($v[$v_pos] > 0.00)
                            if(strtolower($arr_dif[$k][$v_pos])==strtolower($arr_totales[at_ValDif]))
                                $result[0]++;
                    }
                    else
                    {
                        if($v > 0.00)
                            if(strtolower($arr_dif[$k][$v_pos])==strtolower($arr_totales[at_ValDif]))
                                $result[0]++;
                    }
                }
                break;

            case 'SUM':
                foreach($arr as $k=>$v)
                {
                    $dif_en_buffer = strtolower($arr_dif[$k][$v_pos]);
                    if(is_array($v))
                    {
                        if(is_numeric($v[$v_pos]))
                        {

                            if($dif_es_array){
                                $op_en_totales = strtolower($dif_en_totales[$dif_en_buffer]);
//                                echo "<pre>$k: <br />".print_r($dif_en_totales, true)."</pre>";
//                                echo "<pre>dif_en_buffer:$dif_en_buffer, op_en_totales: $op_en_totales =======";

                                switch($op_en_totales){
                                    case "+":
                                        $result[0] += $v[$v_pos];
                                        $hubo_ambos_estados = true;
                                        break;
                                    case "-":
                                        $result[0] -= $v[$v_pos];
                                        break;
                                }
                            }
                            elseif(strtolower($dif_en_buffer)==strtolower($dif_en_totales)) {
//                                echo "<pre>$k: <br />".print_r($v, true)."</pre>";
//                                echo "<pre>v_pos:$v_pos, at_ValDif,".at_ValDif.": <br />".print_r($arr_dif[$k], true)."</pre>";
//                                echo "<li>".$arr_dif[$k][$v_pos] . " == " .$arr_totales[at_ValDif];
//                                echo "<li>val: ".$v[$v_pos];
                                $result[0] += $v[$v_pos];
                            }
                        }
                    }
                    else if(is_numeric($v))
                    {
                        if(strtolower($dif_en_buffer)==strtolower($dif_en_totales))
                            $result[0] += $v;
                    }
                }
                if(!$hubo_ambos_estados && $result[0] < 0)
                    $result[0] = $result[0] *-1;
                break;

            default:
                return false;
                break;
        }
    }
    //if(is_array($result))
    //$result = $result[1]; //Bug que no puedo explicar.
    return $result;
}

function generaArraydeunaColumna($arr, $col, $startingpos = 0, $stoppingpos = -1)
{
    if($stoppingpos == -1) $stoppingpos = count($arr);

    $arr_result = array();
    for($vertical=$startingpos;$vertical<$stoppingpos;$vertical++)
    {
        //VCA PHP 8 11-03-2021 sizeof(): Argument #1 ($var) must be of type Countable|array, string given
        $count_horizontal = count(empty($arr[$vertical]) ? array() : $arr[$vertical]);
        for($horizontal=0;$horizontal<$count_horizontal;$horizontal++)
        {
            if($horizontal == $col)
                $arr_result[]=$arr[$vertical][$horizontal];
        }
    }
    return $arr_result;
}

function arrayCopy(  $array )  // era array $array rjsb
{
    if(empty($array)) return array(); // rjsb
    $result = array();
    foreach( $array as $key => $val )
    {
        if( is_array( $val ) )
        {
            $result[$key] = arrayCopy( $val );
        }
        elseif ( is_object( $val ) )
        {
            $result[$key] = clone $val;
        }
        else
        {
            $result[$key] = $val;
        }
    }
    return $result;
}

/**
 * quitaespaciosintermedios()
 *
 * @param mixed $str
 * @return
 */
function quitaespaciosintermedios($str)
{
    $str = str_replace("\t",' ',$str ?? '');
    return trim(preg_replace('/\s\s+/', ' ', $str));
}

function arrayMovetoTop(&$array, $key)
{
    if(array_key_exists($key,$array))
    {
        $temp = array($key => $array[$key]);
        unset($array[$key]);
        $array = $temp + $array;
    }
}

function arrayMovetoBottom(&$array, $key)
{
    if(array_key_exists($key,$array))
    {
        $value = $array[$key];
        unset($array[$key]);
        $array[$key] = $value;
    }
}

/**
 * diferenciadeTiempo()
 *
 * @param mixed $fecha1 en formato ('Y-m-d H:i:s')
 * @param mixed $fecha2 en formato ('Y-m-d H:i:s')
 * @param mixed $formato posibles valores: 'minutos','horas','dias'
 * @return float $diferencia. Un entero con la diferencia entre la primera y la segunda fecha.
 */
function diferenciadeTiempo($fecha1='', $fecha2='', $formato='minutos', $origen_debug = "")
{
    $now = new DateTime();

    if(empty($fecha1) || $fecha1 == '0000-00-00 00:00:00')
        $fecha1 = $now->format('Y-m-d H:i:s');

    if(empty($fecha2) || $fecha2 == '0000-00-00 00:00:00')
        $fecha2 = $now->format('Y-m-d H:i:s');


    $fecha1 = new DateTime($fecha1);
    $fecha1->setTimezone(new DateTimeZone('-0500'));

    $fecha2 = new DateTime($fecha2);
    $fecha2->setTimezone(new DateTimeZone('-0500'));

    $intervalo = $fecha1->diff($fecha2);
//
//    echo "<br /><br />$origen_debug<br /><br /><pre>fecha1".print_r($fecha1,true)."</pre>";
//    echo "<pre>fecha2".print_r($fecha2,true)."</pre>";
//    echo "<pre>intervalo".print_r($intervalo,true)."</pre>";
    $diferencia = 0;

    switch($formato)
    {
        case 'minutos':
            //echo "calculando $formato s<br />";
            $diferencia += $intervalo->days * 24 * 60;
            $diferencia += $intervalo->h * 60;
            $diferencia += $intervalo->i;
            break;

        case 'horas':
            //echo "calculando $formato s<br />";
            $diferencia += $intervalo->days * 24;
            $diferencia += $intervalo->h;
            $diferencia += $intervalo->i / 60;
            break;

        case 'dias':
            //echo "calculando $formato s<br />";
            $diferencia += $intervalo->days;
            $diferencia += $intervalo->h / 24;
            $diferencia += $intervalo->i / 24 / 60;
            break;

        //si mandan un formato distinto, establecemos minutos.
        default:
            //echo "calculando $formato s por default<br />";
            $diferencia += $intervalo->days * 24 * 60;
            $diferencia += $intervalo->h * 60;
            $diferencia += $intervalo->i;
            break;
    }

    return $diferencia;
}

/**
 * limpiaCantidad()
 *
 * @param mixed $str
 * @param bool $negative
 * @return float
 */
function limpiaCantidad($str, $negative=true)
{
    $str = trim(ltrim($str ?? ''));
    if($negative)
        return (float) preg_replace("/[^\d\-.]+/", "", $str); //VCA 08-03-2021. A partir de PHP 7.4 se tiene que escapar el guión.
    else
        return (float) preg_replace("/[^\d.]+/", "", $str);
}

function limpiaCantidad_($str, $negative=true)
{
    $str = trim(ltrim($str ?? ''));
    if($negative)
        return preg_replace("/[^\d\-.]+/", "", $str); //VCA 08-03-2021. A partir de PHP 7.4 se tiene que escapar el guión.
    else
        return preg_replace("/[^\d.]+/", "", $str);
}

/**
 * Trims whitespace and control characters from a string or an array of strings.
 *
 * @param array|string $str The input string or array of strings to be trimmed.
 * @param bool $delws Optional. When set to true, whitespace is deleted. Otherwise, replaced with a single space. Defaults to false.
 * @return array|string Returns the trimmed string or array of strings.
 */
function vx_trim(array|string $str = '', bool $delws = false): array|string
{
    $replacement = $delws ? "" : " ";

    // Use null coalescing operator to handle null values
    $str = $str ?? '';

    // If the string is empty, return immediately
    if ($str === '') {
        return '';
    }

    if (is_array($str)) {
        foreach ($str as &$d) {
            $d = vx_trim($d, $delws);
        }
        return $str;
    }

    // Ensure valid UTF-8
    $str = iconv("UTF-8", "UTF-8//IGNORE", $str);

    // Apply the regex to remove control characters and special Unicode spaces
    $s1 = preg_replace('/[\x00-\x09\x0B\x0C\x0E-\x1F\x7F\pC]+/muS', '', $str);

    // Handle spaces depending on $delws
    if ($delws) {
        // Remove all types of whitespace if $delws is true
        $s1 = preg_replace('/\s+/u', '', $s1);
    } else {
        // Reduce multiple spaces to a single space if $delws is false
        $s1 = preg_replace('/[ ]{2,}/u', ' ', $s1);
    }

    // Fallback in case of regex failure
    if (preg_last_error()) {
        return trim(preg_replace('/[ ]{2,}/u', $replacement, $str));
    }

    return trim($s1);
}




function sanitizeString($str): string
{

    $a = array('&Aacute','&Eacute','&Iacute','&Oacute','&Uacute','&AACUTE','&EACUTE','&IACUTE','&OACUTE','&UACUTE','À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ',  'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ',  'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ',  'ĳ',  'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ',  'œ',  'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ',  'ǽ',  'Ǿ', 'ǿ');
    $b = array('A',      'E',      'I',      'O',      'U',       'A',      'E',      'I',      'O',      'U',      'A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');

    $cleanStr = str_replace($a, $b, $str);
    $cleanStr = strtoupper($cleanStr);
    return $cleanStr;
}

/**
 * quitaacentos()
 *
 * @param mixed $str
 * @return
 */
function quitaacentos($str)
{
    $a = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
    $b = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
    return str_replace($a, $b, $str);
}

function fechaMaxima($fecha, $maxima='')
{
    if(empty($fecha))
        return date('Y-m-d');

    if(empty($maxima))
        $maxima = date('Y-m-d');

    $fechaMov = new DateTime(date('Y-m-d', strtotime($fecha)));
    $fechaMax = new DateTime($maxima);

    if($fechaMov > $fechaMax)
        return $fechaMax->format('Y-m-d');
    else
        return date('Y-m-d', strtotime($fecha));
}

function sanitizeFileName($filename)
{

    $cleanFileName = strtr(str_replace(array(chr(0),chr(8),chr(27),">","<","|","&",",",";","\r","\n"),'',$filename), array('Š' => 'S','Ž' => 'Z','š' => 's','ž' => 'z','Ÿ' => 'Y','À' => 'A','Á' => 'A','Â' => 'A','Ã' => 'A','Ä' => 'A','Å' => 'A','Ç' => 'C','È' => 'E','É' => 'E','Ê' => 'E','Ë' => 'E','Ì' => 'I','Í' => 'I','Î' => 'I','Ï' => 'I','Ñ' => 'N','Ò' => 'O','Ó' => 'O','Ô' => 'O','Õ' => 'O','Ö' => 'O','Ø' => 'O','Ù' => 'U','Ú' => 'U','Û' => 'U','Ü' => 'U','Ý' => 'Y','à' => 'a','á' => 'a','â' => 'a','ã' => 'a','ä' => 'a','å' => 'a','ç' => 'c','è' => 'e','é' => 'e','ê' => 'e','ë' => 'e','ì' => 'i','í' => 'i','î' => 'i','ï' => 'i','ñ' => 'n','ò' => 'o','ó' => 'o','ô' => 'o','õ' => 'o','ö' => 'o','ø' => 'o','ù' => 'u','ú' => 'u','û' => 'u','ü' => 'u','ý' => 'y','ÿ' => 'y'));
    $cleanFileName = strtr($cleanFileName, array('Þ' => 'TH', 'þ' => 'th', 'Ð' => 'DH', 'ð' => 'dh', 'ß' => 'ss', 'Œ' => 'OE', 'œ' => 'oe', 'Æ' => 'AE', 'æ' => 'ae', 'µ' => 'u'));

    $cleanFileName = preg_replace(array('/[\s]/um', '/\.[\.]+/', '/[^\w_\.\-]/'), array('_', '.', ''), $cleanFileName);
    $cleanFileName = mb_strtolower($cleanFileName, mb_detect_encoding($cleanFileName)); //ojo
    return $cleanFileName;
}

function filtraArray($arr, $key, $val)
{
    $rarr = array();

    if(!is_array($arr) || empty($arr))
        return false;

    //echo "\r\nkey: $key, val: $val";
    foreach($arr as $k => &$v)
    {
        if(is_array($v))
        {
            foreach($v as $kv => $vv)
            {
                if($kv == $key && $vv == $val)
                {
                    //echo "\r\nkey: $key, val: $val";
                    //echo "\r\nkv: $kv, vv: $vv";
                    $rarr[] = $v;
                    break;
                }
            }
        }
        else
        {
            if($k == $key && $v == $val)
                $rarr[] = $v;
        }
    }

    return $rarr;
}

function concatena($strA, $strB)
{
    return "$strA $strB";
}

function deleteDirectory($directory, $justEmpty=false, $typeOfFile='', $olderThan=0): bool
{
    $dotypeOfFile = strlen($typeOfFile);
    $doDelete=true;
    $now = strtotime("now");

    if(str_ends_with($directory, "/") || str_ends_with($directory, "\\")) {
        $directory = substr($directory,0,-1);
    }

    if(!file_exists($directory) || !is_dir($directory)) {
        return false;
    } elseif(!is_readable($directory)) {
        return false;
    } else {
        $directoryHandle = opendir($directory);

        while ($contents = readdir($directoryHandle)) {
            if($contents != '.' && $contents != '..') {
                $path = $directory . "\\" . $contents;

                if(is_dir($path))
                {
                    deleteDirectory($path);
                }
                else
                {
                    if($olderThan)
                    {
                        $fileTime = file_exists($path) ? @filemtime($path) : strtotime("2050-12-31 23:59:59");

                        //echo "<li>$path. Created: $fileTime, now: $now, olderthan: $olderThan, dtf: $dtf|, contents: $contents, typeOfFile: $typeOfFile";
                        $doDelete = $now - $fileTime > $olderThan;
                    }
                    else
                        $doDelete = true;
                    $doEndsWith = endsWith($contents,$typeOfFile);
                    //echo ", doDelete: $doDelete|, endsWith: endsWith";
                    clearstatcache();
                    if($dotypeOfFile) {
                        if ($doEndsWith && $doDelete && file_exists($path)) unlink($path);
                        else continue;
                    }else
                        if($doDelete && file_exists($path)) unlink($path);
                }
            }
        }

        closedir($directoryHandle);

        if(!$justEmpty) {
            if(!rmdir($directory)) {
                return false;
            }
        }

        return true;
    }
}

function isWeekend($date='')
{
    if(empty($date))
        $date = date('Y-m-d');
    return (date('N', strtotime($date)) >= 6);
}

function sumaDias($date,$days)
{
    return date('Y-m-d', strtotime($date . "+$days days"));
}

/**
 * acentostoupper()
 *
 * @param mixed $str
 * @return
 */
function acentostoupper($str)
{
    $str = strtoupper($str);

    $str = str_replace("á","Á",$str);
    $str = str_replace("é","É",$str);
    $str = str_replace("í","Í",$str);
    $str = str_replace("ó","Ó",$str);
    $str = str_replace("ú","Ú",$str);

    $str = str_replace("à","Á",$str);
    $str = str_replace("è","É",$str);
    $str = str_replace("ì","Í",$str);
    $str = str_replace("ò","Ó",$str);
    $str = str_replace("ù","Ú",$str);

    $str = str_replace("'","*",$str);
    $str = str_replace("\"","*",$str);
    $str = str_replace("\<","*",$str);
    $str = str_replace("\>","*",$str);
    $str = str_replace("<","*",$str);
    $str = str_replace(">","*",$str);
    $str = str_replace("%","% ",$str);


    $str = str_replace("Ê","Ú",$str);

    return $str;

}

function htmltoupper($str)
{
//    return mb_strtoupper(html_entity_decode($str,ENT_COMPAT|ENT_HTML401,'UTF-8'),'UTF-8' );

    $str = html_entity_decode($str);
    $str = str_replace(["\\r","\\n"],' ',$str);
    $str = preg_replace_callback('/(.*)(\<[a-z\/].*\>)(.*)/miuU', function($matches){
        return(mb_strtoupper($matches[1])).$matches[2];
    }, $str);

    /**
    $trans = get_html_translation_table (HTML_ENTITIES);
    $trans = array_flip ($trans);
    $str = strtr ($str, $trans);
    $str = strtoupper($str);
    $str = htmlentities($str);
     **/
    return $str;
}

/**
 * quitacaracraros()
 *
 * @param mixed $str
 * @return
 */
function quitacaracraros($str, $pipes=false, $guionbajo=false, $punto=false)
{
    if($pipes || $guionbajo || $punto)
    {
        if($pipes)
            return preg_replace(array('/[^a-zA-Z0-9|.: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
        if($guionbajo)
            return preg_replace(array('/[^a-zA-Z0-9_.: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
        if($punto)
            return preg_replace(array('/[^a-zA-Z0-9..: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
    }
    else
        return preg_replace(array('/[^a-zA-Z0-9 -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
}

function arrayEstado($origen, $tipo='grid', $extra_where = "", $columnas_excluidas = array(), $addExtraWhere = true)
{
    $extra_where = empty($extra_where) ? "" : " AND $extra_where ";

    if(strpos($origen, "supervision") !== false || strpos($origen, "asignacion") !== false)
        $extra_where .= " AND " . " activo = 'Si'";

    if ($addExtraWhere == false) {
        $extra_where = '';
    }

    $sql = "SELECT estado.*, 'SI' as click FROM estado WHERE origen = '$origen' $extra_where ORDER BY orden ASC";
    $arrayEstado = ia_sqlArray($sql,'orden');



    /**
    $arrayEstado = array (
    '0'     => array('valor'=>'1___________', 'clave'=> 'BL', 'descripcion'=> 'Bloqueado', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '1'     => array('valor'=>'_1__________', 'clave'=> 'DEV', 'descripcion'=> 'Pedir Devolución', 'bkgcolor'=>'000000', 'color'=>'ffffff'),
    '2'     => array('valor'=>'__1_________', 'clave'=> 'CAN', 'descripcion'=> 'Pedir Cancelación', 'bkgcolor'=>'ff0000', 'color'=>'ffffff'),
    '3'     => array('valor'=>'___1________', 'clave'=> 'REG', 'descripcion'=> 'Capturado', 'bkgcolor'=>'ffffff', 'color'=>'000000'),
    '4'     => array('valor'=>'____1_______', 'clave'=> 'TER', 'descripcion'=> 'Terminado', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '5'     => array('valor'=>'_____1______', 'clave'=> 'ERR', 'descripcion'=> 'Error', 'bkgcolor'=>'ff0000', 'color'=>'000000'),
    '6'     => array('valor'=>'______1_____', 'clave'=> 'INC', 'descripcion'=> 'Incompleto', 'bkgcolor'=>'7800ff', 'color'=>'ffffff'),
    '7'     => array('valor'=>'_______1____', 'clave'=> 'REV', 'descripcion'=> 'Revisado', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '8'     => array('valor'=>'________1___', 'clave'=> '', 'descripcion'=> '', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '9'     => array('valor'=>'_________1__', 'clave'=> '', 'descripcion'=> '', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '10'    => array('valor'=>'__________1_', 'clave'=> '', 'descripcion'=> '', 'bkgcolor'=>'005baf', 'color'=>'ffffff'),
    '11'    => array('valor'=>'___________1', 'clave'=> '', 'descripcion'=> '', 'bkgcolor'=>'005baf', 'color'=>'ffffff'));
     **/

    foreach( $arrayEstado as $k => &$edo)
    {
        foreach($edo as $col => $val) {
            //echo "<li>$col";
            if (in_array($col, $columnas_excluidas))
                unset($edo[$col]);
        }
        if($edo['para_quien'] == 'rony' && !usuarioTipoRony())
            $edo['click'] = 'NO';

        // $arrayEstado[$k]['color_extra'] = json_decode($edo['color_extra']);
    }


    switch($origen)
    {
        default:
            $arrayEstado = $arrayEstado;
            break;
    }

    if($tipo != 'grid')
    {
        //Quitamos los elementos que están en blanco.
        foreach($arrayEstado as $k => &$edo)
        {
            if(strlen($edo['clave']) == 0)
                unset($arrayEstado[$k]);
        }
    }

//    if($origen== 'banco_cuenta_mov_supervision')
//    {
//        echo "<pre>".print_r($arrayEstado, true)."</pre>";
//        echo "<pre>".print_r($columnas_excluidas, true)."</pre>";
//        echo "<li>$sql";
//        echo "<li>$tipo";
//    }
    return $arrayEstado;
}

function estado2Html($origen, $valor)
{

    //echo "origen:$origen<br/>";
    //echo "valor:$valor<br/>";
    $estadoData = arrayEstado($origen);
    $estadoValor = str_split($valor);
    $html = '<div><table style="border-collapse:collapse; border-style: solid; border-width: 1px; border-color:gray;" class="estadoPersonalizadoRegistro">';
    $tRow = '';
    $numCols = 6;

    switch($origen)
    {
        case 'fiduciario':
            $numCols = 6;
            break;

        case 'fiduciario_contenedor':
            $numCols = 12;
            break;

        default:
            $numCols = 6;
            break;
    }

    // dd_($estadoData);


    foreach($estadoData as $i=>$cED)
    {
        $tCell = '<td';
        $onoff = '0';
        $cEDV = str_split($cED['valor']);

        if(!(($i-1)%$numCols)) $tRow .= '<tr>';

        foreach($cEDV as $j=>$cVal)
        {
            if($cVal == '1' && $estadoValor[$j] == '1')
                $onoff = '1';
        }

        $tcStyle = 'style=" ';

        if($onoff == '1')
        {
            $tcStyle .= "background-color: #$cED[bkgcolor] !important; ";
            $tcStyle .= "color: #$cED[color]; ";
        }
        else
        {
            $tcStyle .= 'background-color: #ffffff; ';
            $tcStyle .= 'color: #c0c0c0; ';
        }

        $tcStyle .= ' width:35px; border-collapse:collapse; border-style: solid; border-width: 1px; border-color:gray;"';

        $tCell = "$tCell $tcStyle ><strong>$cED[clave]</strong></td>";

        $tRow .= $tCell;
    }

    $html.="$tRow</table></div>";

    return $html;
    //if(($valor))
}

function compara2Arrays($post=array(),$endb=array(),$ignore=array(),$doLog=false,&$ret=array(),&$log=array(),$app_name='',$ignore4Log=array())
{
    if(!isset($ret))
        $ret = array();
    $ignore[] = 'ultimo_cambio'; $ignore[] = 'ultimo_cambio_por';
    $striptags = array('remarks','comentario','referencia','comments','poliza_contabilidad','numero_original_tagged','plantilla_withdrawals_remarks');

    $tmp = array();
    foreach($striptags as $k=>$v)
        if(array_key_exists($k,$post) && array_key_exists($k,$endb))
        {
            $tmp[$k] = array();
            $tmp[$k][0] = $post[$k];
            $post[$k] = vx_trim(strip_tags($post[$k]));
            $tmp[$k][1] = $endb[$k];
            $endb[$k] = vx_trim(strip_tags($endb[$k]));
        }
//            echo "<pre>tmp".print_r($tmp, true)."</pre>";
//            echo "<pre>post".print_r($post, true)."</pre>";
//            echo "<pre>endb".print_r($endb, true)."</pre>";
//            die();
    $post4c = array_diff_key($post,array_flip($ignore));
    $ret = array_udiff_assoc($post4c,$endb, function($a,$b){ /*echo "<li>a: $a <=> b: $b";*/ return $a != $b; });

    foreach($striptags as $k=>$v)
        if(array_key_exists($k,$ret))
            $ret[$k] = $tmp[$k][0];

    if($doLog)
    {
        global $gAppRelate;
        if(empty($gAppRelate))
            $gAppRelate=new appRelate();

        $app_name = "app_".$app_name;
        $app = new $app_name;
        $modo = 'R/O';



        foreach($ret as $k=>$v)
        {
            //if(!array_key_exists($k,$app->campos)) $app->campos[$k];
            if(in_array($k,$ignore4Log)) continue;
            $log[] = kvRenglon($app->label_field($k),
                $app->display($k,array(),$v,$modo,false,'log'),
                $app->display($k,array(),$endb[$k]??'',$modo,false,'log'));
        }
    }

    foreach($ignore as $i)
        if(array_key_exists($i, $post))
            $ret[$i] = $post[$i];
    //echo "<pre>".print_r($ret)."</pre>";
    return $ret;
}

function txtHaceCuantoTiempo($fuch, $nowTime, $monedaClass="txt_color_PESOS", $doClass=true, $diffCalcMin=false)
{
    $txt_difHoras = "";

    if($diffCalcMin === false)
    {
        if(empty($fuch))
            $fuch=strtotime("now");

        if(empty($nowTime))
            $nowTime=strtotime("now");


        $difOri = diferenciadeTiempo(date('Y-m-d H:i:s', $nowTime), date('Y-m-d H:i:s', $fuch), 'horas');
        $difHoras = intval($difOri);
        $difMins = diferenciadeTiempo(date('Y-m-d H:i:s', $nowTime), date('Y-m-d H:i:s', $fuch), 'minutos') % 60;
    }
    else
    {
        $difHoras = intval($diffCalcMin/60);
        $difMins = $diffCalcMin % 60;
    }

    $claIni = "<strong class='$monedaClass'>";
    $claFin = "</strong>";

    if(!$doClass)
    {
        $claIni = "";
        $claFin = "";
    }



    switch(true)
    {
        case ($difHoras < 1):
            //$difMins = intval(diferenciadeTiempo(date('Y-m-d H:i:s', $nowTime), date('Y-m-d H:i:s', $fuch)));
            $txt_difHoras = "$claIni$difMins min$claFin";
            break;

        case ($difHoras >= 72):
            if($doClass)
                $claIni = "<strong class='rojo'>";
            $txt_difHoras = "$claIni$difHoras hrs, $difMins min$claFin";
            break;

        case ($difHoras > 24):
            $txt_difHoras = "$claIni$difHoras hrs, $difMins min$claFin";
            break;

        case ($difHoras == 1):
            $txt_difHoras = "$claIni 0$difHoras hrs, $difMins min$claFin";
            break;


        case ($difHoras < 10):
            $txt_difHoras = "$claIni 0$difHoras hrs, $difMins min$claFin";
            break;

        default:
            $txt_difHoras = "$claIni$difHoras hrs, $difMins min$claFin";
            break;
    }

    return $txt_difHoras;
}

function startsWith($haystack, $needle)
{
    $length = strlen($needle);
    return (substr($haystack, 0, $length) === $needle);
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    return $length === 0 ||
        (substr($haystack, -$length) == $needle);
}

/**
 * jj 20-Enero-2020
 * */
function getDateLabel($inputDate = null, $lang = 'es', $addTime = false, $forza_numeros = false, $format = '')
{
    if (empty($format))
        $format = 'd/m/Y' . ($addTime ? ' H:i' : '');

    $inputDate = empty($inputDate) ? date($format): date_format(date_create($inputDate), $format);

    $time = $addTime ? explode(" ", $inputDate)[1] : '';
    $date = $addTime ? explode(" ", $inputDate)[0] : $inputDate;

    if (!$forza_numeros) {
        if (str_contains($format, 'd/m/Y')) {
            $intMont = intval(substr($date,3,2));
        } else {
            $intMont = intval(substr($date,4,2));
        }
        $meses = explode(" ","Null Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec");
        $meses_es = explode(" ","Null Ene Feb Mar Abr May Jun Jul Ago Sep Oct Nov Dic");
        $mes = $lang == 'es' ? $meses_es[$intMont] : $meses[$intMont];
        // $time = $addTime ? explode(" ", $inputDate)[1] : '';
        // $date = $addTime ? explode(" ", $inputDate)[0] : $inputDate;
        $inputDate = explode("/", $date);
        $inputDate[1] = $mes;
        return implode("/", $inputDate) . ($addTime ? "<small> $time Hrs.</small>" : '');
    } else {
        return $date . ($addTime ? "<small> $time Hrs.</small>" : '');
    }
    return $inputDate;
}


/**
 * Crea una o N Carpetas Recursivas, desde la carpeta de la aplicación hasta N niveles.
 * @param $elPath "c:\wamp\www\vitex\uploads\edocta\uuid"
 * @param $miApp "e.g. 'vitex'"
 * @return bool
 */
function valida_carpetas($elPath,$miApp){
    if(strpos($elPath, $miApp)){
        $antePath= explode($miApp,$elPath);
        $prePath= $antePath[1];
    }
    else{
        $prePath= $elPath;
    }
    if(!strpos($elPath, "/")){
        $prePath= str_replace("\\", "/", $prePath);
    }
    $pathseparado= explode("/",$prePath);
    $Base_Path= '/lamp/www/'.$miApp;
    $arrayDiscrimina= array(".","..");
    $cnt=0;
    $pathLoop="";
    foreach($pathseparado AS $key => $carpeta){
        if(! empty($carpeta)){
            if(! in_array($carpeta , $arrayDiscrimina)){
                if($cnt == 0){
                    $pathLoop= $Base_Path."/".$carpeta;
                }
                else{
                    $pathLoop.="/".$carpeta;
                }
                if(!file_exists($pathLoop)){
                    @mkdir($pathLoop);
                }
                $cnt++;
            }
        }
    }

    return true;
}

function hayIgual($arrmovAnt,$refNva,$referenciaKey,&$log_err){
    //echo "\r\n".print_r($arrmovAnt)."\r\n";
    $igual=0;
    foreach ($arrmovAnt as $key => $movAnt) {
        if($movAnt[$referenciaKey]==$refNva && $movAnt['matcheado'] == 'NO')
        {
            $log_err .= "\r\nHay igual?---------------".$movAnt[$referenciaKey]."---------".$refNva."---------\r\n";
            $igual=1;
        }
    }

    return $igual;

}


function conFin($movNvo,$movAnt)
{
    $igual=0;
    //$arrNVO =explode("/","DEP.CHEQUES DE OTRO BANCO/0013897 OCT12 09:17 MEXICO");
    //$arrANT= explode("/","DEP.CHEQUES DE OTRO BANCO/OCT12 09:17 MEXICO");

    $re = '/SUCURSAL\s*:\s*(\d+)|AUTORIZACION\s*:\s*(\d+)/miS';
    $n = $movNvo;
    $a = $movAnt;

    preg_match_all($re, $n, $arrNVO, PREG_SET_ORDER, 0);
    preg_match_all($re, $a, $arrANT, PREG_SET_ORDER, 0);



    if(isset($arrNVO[0][1]) && isset($arrNVO[1][2]))
    {

        // Print the entire match result
        //echo"<br>1.-";
        //echo ($arrNVO[0][1]);
        //echo"<br>2.-";
        //echo ($arrNVO[1][2]);
        //echo"<br>";
        //echo"<br>R.-";


        //echo"<br>1.-";
        //echo ($arrANT[0][1]);
        //echo"<br>2.-";
        //echo ($arrANT[1][2]);
        //echo"<br>";
        //echo"<br>R.-";

        //echo "<br>".intval($arrNVO[0][1])." == ".intval($arrANT[0][1]) ." && ". intval($arrNVO[1][2])." == ".intval($arrANT[1][2]);
        //echo "<br>";

        if(intval($arrNVO[0][1])==intval($arrANT[0][1]) && intval($arrNVO[1][2])==intval($arrANT[1][2]))
        {
            return true;
        }else
        {
            return false;
        }

    }else
    {

        $arrNVO =explode("/",$movNvo);
        $arrANT= explode("/",$movAnt);



        //echo"\r\n".$arrANT[0]."==".$arrNVO[0];

        if(array_key_exists(1, $arrANT) && array_key_exists(1, $arrNVO) && ($arrANT[0]==$arrNVO[0] || $arrANT[1]==$arrNVO[1]))
        {
            $dif1=0;
            $dif2=0;
            // echo"\r\n".$arrANT[0]."==".$arrNVO[0];
            $arrNVOfin =explode(" ",$arrANT[1]);
            $arrANTfin= explode(" ",$arrNVO[1]);
            //echo"\r\n";
            //echo"\r\n";
            //print_r($arrNVOfin);
            //echo"\r\n";
            //print_r($arrANTfin);

            if ($arrNVOfin[0]!=$arrANTfin[0])
            {
                $com_tam=count($arrNVOfin)-count($arrANTfin);

                if($com_tam<=0)
                {
                    $tam=count($arrNVOfin);
                    $dif1=$com_tam*(-1);
                }else{
                    $tam=count($arrANTfin);
                    $dif2=$com_tam;
                }

                for ($i=($tam-1); $i >=0 ; $i--)
                {
                    //echo"\r\n\r\n".$arrNVOfin[$i+$dif2]."==".$arrANTfin[$i+$dif1];

                    if($arrNVOfin[$i+$dif2]==$arrANTfin[$i+$dif1])
                    {
                        $igual++;
                    }
                }
                //echo "\r\n".(($igual/$tam)*100)."%";
                if((($igual/$tam)*100)>=50)
                {
                    return true;
                }else{
                    return false;
                }
            }else{
                return true;
            }

        }else
        {
            return false;
        }
    }



}


function comparaStrings($str1, $str2)
{
    $str1 = vx_trim(str_replace("/", " ", $str1));
    $str2 = vx_trim(str_replace("/", " ", $str2));

    $str1 = explode(" ", $str1);
    $str2 = explode(" ", $str2);

    return (float) comparaArrays($str1, $str2);
}

function comparaArrays($ngram1, $ngram2) {
    $sum = array_unique(array_merge($ngram1, $ngram2));
    $intersection = array_intersect($ngram1, $ngram2);

    //echo "<pre>sum: ".print_r($sum, true)."</pre>";
    //echo "<pre>intersection: ".print_r($intersection, true)."</pre>";
    $score = count($intersection) / count($sum);
    return (float) $score;
}

function limpiaTagsdeRemarks($string = "")
{
    //$st = htmlentities($string, null, 'utf-8');
    $st = $string;
    $st = str_replace(array("&lt;br /&gt;", "&lt;br/&gt;", "&lt;br&gt;", "&lt;br &gt;", "&nbsp;", "&lt;p&gt;")," ",$st);
    $st = html_entity_decode(html_entity_decode($st));
    //$st = htmlentities($string, null, 'utf-8');
    //$st = str_replace(array("&lt;br /&gt;", "&lt;br/&gt;", "&lt;br&gt;", "&lt;br &gt;", "&nbsp;", "&lt;p&gt;")," ",$st);
    //$st = html_entity_decode($st);
    $st = addslashes(strip_tags(vx_trim($st)));
    $st = preg_replace("/&nbsp;/",'',$st);
    $st = vx_trim($st);

    return $st;
}

function calculaPagina2Reg($totalRn, $primerRn, $ultimoRn, &$result)
{
    //$totalRn = 8500;
    $rowNum = 100;
    //$primerRn = 4230;
    //$ultimoRn = 4650;
    $pagina = 1;
    $yarife = false;
    $dif = 0;

    $paginas = max( ceil($totalRn / $rowNum ),1);
    $tmp = $ultimoRn;

    $ultimoRn = $ultimoRn > $primerRn ? $ultimoRn : $primerRn;
    $primerRn = $tmp != $ultimoRn ? $tmp : $primerRn;

    $dif = $ultimoRn > $primerRn ? $ultimoRn - $primerRn : $primerRn - $ultimoRn;
    $i = 0;

    $rowList = array(50,100,200,500,1000,2000,5000,10000000);
    $rlIndex = 0;
    /**
    echo "<li>dif ori: $dif";
    echo "<li>totalRn: $totalRn";
    echo "<li>primerRn: $primerRn";
    echo "<li>ultimoRn: $ultimoRn";
     **/


    do
    {
        foreach($rowList as $k=>$rowsDiff)
            if($rowsDiff > $dif)
            {
                $dif = $rowsDiff;
                $rlIndex = $k;
                break;
            }

        $paginas = max( ceil($totalRn / $dif ),1);

        $pag1 = max( floor ($primerRn / $dif),1);

        $pag2 = max( ceil ($ultimoRn / $dif),1);

        $yarife = (($pag2 - $pag1) == 1) || $pag2 == $pag1;

        $dif = !$yarife ? $dif : $rowList[$rlIndex+1];
        /**
        echo "<li>paginas: $paginas";
        echo "<li>pag1: $pag1";
        echo "<li>pag2: $pag2";
        echo "<li>dif: $dif";
        echo "<li>yarife: $yarife";



        $blanks = str_pad('',4096,'&nbsp;');
        echo $blanks;
        ob_flush(); flush();
         *
         * **/
        $i++;
    }while(!$yarife && $i < 8);


    $result['pageGrid'] = $pag1;
    $result['rowNum'] = $dif;

    return true;
}

function send_mail($emailAsunto="Error en Programa ",$emailCuerpoMensaje=''){
    require_once ("Mail.php");
    require_once ("Mail/mime.php");



    $html_message = '<p>'. $emailCuerpoMensaje .'</p>';
    $headers["Return-Path"] = "vitex@evinux.net";
    $headers["Sender"] = "vitex@evinux.net";
    $headers["From"] = "VITEX<vitex@evinux.net>";
    $headers["To"] = "VITEX TESTER<vitextest@gmail.com>";
    $headers["Subject"] = $emailAsunto;
    //$headers["Cc"] = "Rony Akiki <correo@host.com>";
    $headers["Reply-To"] = "VITEX<vitex@evinux.net>";
    //$headers["Read-Receipt-To"] = "VITEX<vitex@evinux.net>";
    //$headers["Return-Receipt-Requested"] = "VITEX<vitex@evinux.net>";
    $headers["X-Confirm-Reading-To"] = "VITEX<vitex@evinux.net>";
    $headers["X-Priority"] = "1 (Highest)";
    $headers["Importance"] = "High";
    $headers["Disposition-Notification-To"] = "VITEX<vitex@evinux.net>";


    $mime_params = array();

    $mime_params['eol'] = "\n";
    $mime_params['delay_file_io'] = true;
    $mime_params['head_encoding'] = "quoted-printable";
    $mime_params['text_encoding'] = "quoted-printable";
    $mime_params['html_encoding'] = "quoted-printable";
    $mime_params['head_charset'] = "UTF-8";
    $mime_params['text_charset'] = "UTF-8";
    $mime_params['html_charset'] = "UTF-8";

    $mime = new Mail_mime($mime_params);

    $mime->setHTMLBody(trim($html_message ?? ''));

    $message = $mime->get();
    $headers = $mime->headers($headers, true);


    $params["host"] = 'mail.evinux.net';
    $params["port"] = '587';
    $params["auth"] = TRUE; // note: there are *no delimiters*
    $params["username"] = 'vitex@evinux.net';
    $params["password"] = 'vit986532@';




    $mail_message = Mail::factory('smtp', $params);
    $send = $mail_message->send ('vitex@evinux.net', $headers, $message);


    if (PEAR::isError($send))
    {
        die();
    }
    else
    {
        //echo"Correo Enviado";
    }
}

function jsonFile($fileName, $array, $flags = 0) {
    $ignore = ignore_user_abort();
    ignore_user_abort(1);
    try {
        //VCA
        // los autocomplete grid combo boxes toman el md5!
        // $array['md5'] = md5(json_encode($array));
        $ret = file_put_contents($fileName, json_encode($array, $flags), LOCK_EX);
    } catch(Exception $e) {
        $ret = false;
    }
    ignore_user_abort($ignore);
    return $ret;
}

function dd_(...$vars)
{
    $separator = "<br/>================================================================================================<br/>";
    $print = [];
    foreach ($vars as $key => $var) {
        // $print[] = "<pre>\n\t<strong>VAR $key: (".gettype($var).") </strong>\n\t<h5>\n\t\t". print_r($var , true) . "\n\t</h5>\n</pre>\n$separator";
        // echo "\n<pre>\n\t<strong>VAR $key: (".gettype($var).") </strong>\n\t<h5>\n\t\t". print_r($var , true) . "\n\t</h5>\n</pre>\n$separator\n";
        if (gettype($var) === 'boolean') {
            $print[] = "<pre><strong>VAR $key: (".gettype($var).") </strong><h5>". var_export($var , true) . "</h5></pre>$separator";
            continue;
        }
        $print[] = "<pre><strong>VAR $key: (".gettype($var).") </strong><h5>". ia_htmlentities(print_r($var , true)) . "</h5></pre>$separator";
    }
    echo "\n".implode("\n", $print)."\n";
    die("<h5><b>END VARS TESTIE</b></h5><script>$(document).ready( function() { setTimeout(function() { $('#loadingMask').fadeOut(0); }, 10); });</script>");
}

function v_d(...$vars)
{
    dd_($vars);
}

function d_(...$vars)
{
    $separator = "<br/>================================================================================================<br/>";
    $print = [];
    foreach ($vars as $key => $var) {
        // $print[] = "<pre>\n\t<strong>VAR $key: (".gettype($var).") </strong>\n\t<h5>\n\t\t". print_r($var , true) . "\n\t</h5>\n</pre>\n$separator";
        // echo "\n<pre>\n\t<strong>VAR $key: (".gettype($var).") </strong>\n\t<h5>\n\t\t". print_r($var , true) . "\n\t</h5>\n</pre>\n$separator\n";
        if (gettype($var) === 'boolean') {
            $print[] = "<pre><strong>VAR $key: (".gettype($var).") </strong><h5>". var_export($var , true) . "</h5></pre>$separator";
            continue;
        }
        $print[] = "<pre><strong>VAR $key: (".gettype($var).") </strong><h5>". ia_htmlentities(print_r($var , true)) . "</h5></pre>$separator";
    }
    echo "\n".implode("\n", $print)."\n";
}

function renderView($view = null, $data = [])
{
    $dirViews = dirname(dirname(__DIR__)) . '/backoffice/view/';
    $data['date'] = date("Y-m-d H:i:s");
    $ini = array_key_exists('ini', $data) ? $data['ini'] : false;
    $path = $dirViews . $view . '.php';
    $path = str_replace('\\', '/', $path);
    extract($data);
    ob_start();
    include $path;
    // $view = ob_get_contents();
    $view = str_replace('\"','"',trim(ob_get_contents()));
    ob_end_clean();
    $view = vx_trim($view);
    // return preg_replace(array('/[^a-zA-Z0-9"\/<>=_.: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($view));
    // return preg_replace(array('/[^a-zA-Z0-9_.: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
    // return preg_replace(array('/[^a-zA-Z0-9..: -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
    // return preg_replace(array('/[^a-zA-Z0-9 -]/', '/[ -]+/', '/^-|-$/'),array('', ' ', ''), quitaacentos($str));
    // html_entity_decode
    return $view;
}

function includeView($view = null, $data = [])
{
    $dirViews = dirname(dirname(__DIR__)) . '/backoffice/view/';
    $path = $dirViews . $view . '.php';
    extract($data);
    ob_start();
    include $path;
    $view = str_replace('\"','"',trim(ob_get_contents()));
    ob_end_clean();
    $view = vx_trim($view);
    return $view;
}

function hex2rgb($color = '000000', $opacity = false) {
	$default = 'rgb(0, 0, 0)';
	//Return default if no color provided
	if(empty($color))
          return $default;

	//Sanitize $color if "#" is provided
    if ($color[0] == '#' ) {
        $color = substr( $color, 1 );
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
    } elseif ( strlen( $color ) == 3 ) {
        $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb =  array_map('hexdec', $hex);

    //Check if opacity is set(rgba or rgb)
    if($opacity){
        if(abs($opacity) > 1)
            $opacity = 1.0;
        $output = 'rgba('.implode(", ",$rgb).', '.$opacity.')';
    } else {
        $output = 'rgb('.implode(", ",$rgb).')';
    }

    //Return rgb(a) color string
    return $output;
}

function indexa_($datos, $key){
    /*$array = array_combine(array_column($datos, $key), $datos);*/
    $regresa = [];
    if($datos != null){
        foreach ($datos as $d) {
            $indice = $d[$key];
            $regresa[$indice] = $d;
        }
    }
    return $regresa;
}

function obtenNumeroRevisorGastosCuentaT($user_id = null, $tipo = 'asignacion', $posicion = null, $para_revisor = false) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $user_Estado = obtenEstadoRevisorGastosCuentaT($user_id, $tipo, $posicion, $para_revisor);
    return strpos($user_Estado, 'Z');
}

function obtenNumeroRevisorMovimientosBanco($user_id = null, $tipo = 'asignacion', $posicion = null, $para_revisor = false) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    /* if ($posicion != null) {
        revisaSiPuedeenPosicion($user_id, $tipo, $posicion);
    } */
    $user_Estado = obtenEstadoRevisorMovimientosBanco($user_id, $tipo , $posicion, $para_revisor);
    return strpos($user_Estado, 'Z');
}

function obtenEstadoRevisorGastosCuentaT($user_id = null, $tipo = 'asignacion', $posicion = null, $para_revisor = false) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $andPosicion = ($posicion != null) ? "AND posicion = '$posicion'": "";
    $order = "ORDER BY orden ASC";
    if ($para_revisor) {
        $order = "ORDER BY orden DESC";
    }
    $query = "SELECT usuario_id, descripcion nombre,valor, origen FROM estado WHERE usuario_id = $user_id AND origen = 'cuentat_gasto_$tipo' $andPosicion $order";
    $user_Estado = ia_singleton($query);
    return $user_Estado['valor'];

}

function obtenEstadoRevisorMovimientosBanco($user_id = null, $tipo = 'asignacion', $posicion = null, $para_revisor = false) {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $andPosicion = ($posicion != null) ? "AND posicion = '$posicion'": "";
    $order = "ORDER BY orden ASC";
    if ($para_revisor) {
        $order = "ORDER BY orden DESC";
    }
    $query = "SELECT usuario_id, descripcion nombre,valor, origen FROM estado WHERE usuario_id = $user_id AND origen = 'banco_cuenta_mov_$tipo' $andPosicion $order";
    // echo $query. "<br>";
    $user_Estado = ia_singleton($query);
    return $user_Estado['valor'] ?? false;

}

function obtenEstadoRevisorGastosCuentaTPermission($user_id = null, $tipo = 'asignacion') {
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $query = "SELECT usuario_id, descripcion nombre,valor, origen FROM estado WHERE activo = 'Si' AND usuario_id = $user_id AND origen = 'cuentat_gasto_$tipo'";
    $user_Estado = ia_singleton($query);
    if (empty($user_Estado)) {
        return false;
    }
    return $user_Estado['valor'] ?? true;
}

function obtenEstadoRevisorMovimientosBancoPermission($user_id = null, $tipo = 'asignacion') {

    //die($user_id . " _ " . $tipo);
    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $query = "SELECT usuario_id, descripcion nombre,valor, origen FROM estado WHERE activo = 'Si' AND usuario_id = $user_id AND origen = 'banco_cuenta_mov_$tipo'";
    $user_Estado = ia_singleton($query);

    //echo "<pre>$query".print_r($user_Estado, true)."</pre>";

    if (empty($user_Estado)) {
        return false;
    }
    return $user_Estado['valor'] ?? false;
}

function obtenPosicionesRevisor($user_id, $origen = 'banco_cuenta_mov', $tipo = 'asignacion')
{
    // $origen -> ['banco_cuenta_mov', 'cuentat_gasto']
    // $tipo -> ['asignacion', 'supervision']
    // $user_id -> id de usuario para obtener posiciones

    $user_id = ($user_id == null) ? $_SESSION['usuario_id'] : $user_id;
    $origen .= "_$tipo";

    $query = "SELECT posicion FROM estado WHERE usuario_id = $user_id AND origen = '$origen'";

    $posiciones = ia_sqlArrayIndx($query);

    if (empty($posiciones)) return [];

    return $posiciones;
}
/**
 * Calcula el semaforo de asignación para los revisores
 * @param mixed $user_id id de usuario
 * @param string $valor_asignacion valor de campo asignacion (Default ZZZZZZZZZZZZ)
 * @param string $app origen de la tabla estado ('cuentat_gasto', 'banco_cuenta_mov') default 'banco_cuenta_mov'
 * @param string $para_quien para quien se va a calcular el semaforo
 * @return array $semaforo dependiendo para quien
 */
function calculaSemaforo($user_id = null, $valor_asignacion = 'ZZZZZZZZZZZZ', $app = 'banco_cuenta_mov', $para_quien = 'todos')
{
    // $user_id -> ['todos', 'rony', 'otros']
    $arrSemaforo = [
        1 => [
            0 => "rojo",
            1 => "verde"
        ],
        2 => [
            0 => "rojo",
            1 => "naranja",
            2 => "verde"
        ],
        3 => [
            0 => "rojo",
            1 => "naranja",
            2 => "amarillo",
            3 => "verde"
        ],
        4 => [
            0 => "rojo",
            1 => "naranja",
            2 => "naranja",
            3 => "amarillo",
            4 => "verde"
        ],
        5 => [
            0 => "rojo",
            1 => "naranja",
            2 => "naranja",
            3 => "naranja",
            4 => "amarillo",
            5 => "verde"
        ],
        6 => [
            0 => "rojo",
            1 => "naranja",
            2 => "naranja",
            3 => "naranja",
            4 => "amarillo",
            5 => "amarillo",
            6 => "verde"
        ],
        7 => [
            0 => "rojo",
            1 => "naranja",
            2 => "naranja",
            3 => "naranja",
            4 => "naranja",
            5 => "amarillo",
            6 => "amarillo",
            7 => "verde"
        ],
        8 => [
            0 => "rojo",
            1 => "naranja",
            2 => "naranja",
            3 => "naranja",
            4 => "naranja",
            5 => "amarillo",
            6 => "amarillo",
            7 => "amarillo",
            8 => "verde"
        ]
    ];

    $semaforo_rony = '';
    $semaforo_usuarios = [];

    // supervisores
    /* Neccesito al menos el origen para obtener los revisores y supervisores */
    $supervisores = traeSupervisoresRevisores(null, 'supervisor', true, $app."_supervision");
    $arryPosicionesOmitirSupervisor = [];

    foreach($supervisores AS $key => $val){
        if ($app == 'banco_cuenta_mov') {
            $laposicion= obtenNumeroRevisorMovimientosBanco($val["usuario_id"]);
        }
        if ($app == 'cuentat_gasto') {
            $laposicion= obtenNumeroRevisorGastosCuentaT($val["usuario_id"]);
        }
        $arryPosicionesOmitirSupervisor[]= $laposicion;
    }


    $elCntareas=0;
    $yaRevisadas=0;
    if ($valor_asignacion != 'ZZZZZZZZZZZZ') {
        $cell_value = str_split($valor_asignacion);
        // EMPIEZA SEMAFORO PARA RONY
        if(empty($user_id)){
            foreach ($cell_value as $posicion => $caracter) {
                if (!in_array($posicion, $arryPosicionesOmitirSupervisor)) {
                    if( $caracter != "z" and $caracter != "Z") {
                        if ($caracter != 'A' and $caracter != 'D') {
                            $yaRevisadas++;
                        }
                        $elCntareas++;
                    }
                }
            }
            if ($elCntareas > 0) {
                $semaforo_rony = $arrSemaforo[$elCntareas][$yaRevisadas];
            }
        }
        // TERMINA SEMAFORO PARA RONY

        // EMPIEZA SEMAFORO PARA TODOS
        if(! empty($user_id) || $para_quien == 'todos'){
            $revisores = traeSupervisoresRevisores($user_id, 'revisor', true, $app."_asignacion");
           // echo "aqui"; print_r($revisores);
            $elCntareas=0;
            $yaRevisadas=0;
            // dd_($revisores);
            foreach ($revisores as $index => $revisor) {
                $posiciones_de_revision = obtenPosicionesRevisor( $revisor['usuario_id'], $app, 'asignacion');
                $elCntareas=0;
                $yaRevisadas=0;
                foreach ($posiciones_de_revision as $item => $posicion) {
                    if (!in_array($posicion['posicion'], $arryPosicionesOmitirSupervisor)) {
                        $caracter = $cell_value[$posicion['posicion']];
                        if( $caracter != "z" and $caracter != "Z") {
                            if ($caracter != 'A' and $caracter != 'D' and $caracter != 'Z') {
                                $yaRevisadas++;
                            }
                            $elCntareas++;
                        }
                    }
                }
                if ($elCntareas > 0) {
                    $semaforo_usuarios[$revisor['usuario_id']] = $arrSemaforo[$elCntareas][$yaRevisadas];
                }
            }
        }
        // TERMINA SEMAFORO PARA TODOS
    }

    $semaforo = [
        'rony' => $semaforo_rony,
        'otros' => $semaforo_usuarios // [69 => 'rojo', 1 => 'rojo', 107 => 'verde', 72 => 'naranja']
    ];

    if ($para_quien == 'rony' && empty($user_id)) {
        unset($semaforo['otros']);
    }
    if (! empty($user_id) ) {
        unset($semaforo['rony']);
    }
   /*  if ($para_quien == 'otros') {
        $semaforo = ['otros' => []];
    } */

    return $semaforo;
}

function quiesnEsSupervisor(){

}
/*
function revisaSiPuedeenPosicion($user_id = null, $tipo = 'asignacion', $posicion = null)
{

} */

function asignacion_2_html($origen, $valor, $r_id = '', $con_eventos = false, $fecha_revision = null, $posicion_revision = null,    $desactiva_usuario = null, $pos_desactiva = null)
{
    $estadoData = arrayEstado($origen);
    $estadoValor = str_split($valor);
    $numCols = 6;

    switch($origen)
    {
        case 'fiduciario':
            $numCols = 6;
            break;

        case 'fiduciario_contenedor':
            $numCols = 12;
            break;

        default:
            $numCols = 6;
            break;
    }

    $origen_prefix = str_replace("_asignacion", "", $origen);
    $origen_prefix = str_replace("_supervision", "", $origen_prefix);

    $div_table = '<div data-estado="'.$valor.'" class="estado-asignacion tablagen">';
    $divCell = '';
    $divRow = '';
    $divRowEnd = '';
    $dataVal = '';
    $posicion = 0;
    $data = "";
    $eventos = "";

    $activaDBLClick = false;
    $activaContextClick = true;

    foreach($estadoData as $i=>$cED)
    {
        if ($desactiva_usuario != null and $pos_desactiva != null) {
            if ($cED['usuario_id'] == $desactiva_usuario and $cED['posicion'] == $pos_desactiva) {
                $cED['usuario_id'] = 0;
                $cED['activo'] = 'No';
            }
        }
        $data = "";
        $dataVal = '';
        $tcStyle = 'style="width:40px !important; height:30px !important; display: flex; align-items: center; justify-content: center;';
        if ($cED['usuario_id'] != 0 and $cED['activo'] != 'No') {
            $divRow = '';
            $divRowEnd = '';
            $cEDV = str_split($cED['valor']);
            $colores = json_decode($cED['color_extra'], true);
            if (!(($i-1)%$numCols)) {
                $divRow = '<div class="fila"></div>';
            }

            foreach($cEDV as $j=>$cVal)
            {
                if ($cVal == 'Z' && $estadoValor[$j] == 'A') { // Asignado
                    $dataVal = 'A';
                    $posicion = $j;
                    $color = $colores['A'];
                    $tcStyle .= "background: radial-gradient(circle, #ffcdd2 0%, /* Light Red */ #ef6c6c 50%, /* Medium Red */ #fb0505 100%);
    color: #000000;
    text-shadow: 1px 1px 2px rgb(255 255 255);
";
                }
                if ($cVal == 'Z' && $estadoValor[$j] == 'B') { // Revisado
                    $dataVal = 'B';
                    $posicion = $j;
                    $color = $colores['B'];
//                    $tcStyle .= "background: linear-gradient(90deg, rgba(255,255,255,1) 0%, rgba(36,196,33,1) 14%, $color[background] 64%, rgba(18,107,16,1) 100%); color:$color[color];";
                    $tcStyle .= "background: radial-gradient(circle, #c9ffcd 0%, /* Light Green */ #78ca7c 50%, /* Medium Green */ #1b5e20 100%);
    color: #ffffff;
    text-shadow: 1px 1px 2px rgb(0 0 0);";                }
                if ($cVal == 'Z' && $estadoValor[$j] == 'C') { // Autorizado
                    $dataVal = 'C';
                    $posicion = $j;
                    $color = $colores['C'];
                    $tcStyle .= "background: radial-gradient(circle, #F3F9FF 0%, #EDF6FF 10%, $color[background] 100%); color: $color[color];";
                }
                if ($cVal == 'Z' && $estadoValor[$j] == 'D') { //
                    $dataVal = 'D';
                    $posicion = $j;
                    $color = $colores['D'];
                    $tcStyle .= "background: radial-gradient(circle, 
rgb(163, 148, 216) 0%, 
#b39ddb 25%, 
#9a67ea 50%, 
#7e57c2 75%, 
rgb(138, 43, 226) 100%);
color: #FFFFFF; /* White text */
text-shadow: 1px 1px 2px #000000; /* Black shadow for depth and readability */";
//                    $tcStyle .= "background: radial-gradient(circle, #FFFFFFFF 0%, #ffa2a2 10%, #ff0000 100%); color: $color[color];";
                }
                if ($cVal == 'Z' && $estadoValor[$j] == 'C') { // Autorizado
                    $dataVal = 'E';
                    $posicion = $j;
                    $color = $colores['E'];
                    $tcStyle .= "background: radial-gradient(circle, #ffa2fc 0%, #ffa2fc 10%, $color[background] 100%); color: $color[color];";
                }
                if ($cVal == 'Z' && $estadoValor[$j] == 'Z') { // No asignado
                    $dataVal = 'Z';
                    $posicion = $j;
                    $color = $colores['Z'];
                    $tcStyle .= "background: radial-gradient(circle, 
    #F5F5F5 0%, /* Very Light Gray */
    #E0E0E0 50%, /* Light Gray */
    #BDBDBD 100%); /* Silver */
color: #000000; /* Black text */
text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.7); /* White shadow */
";
                }
            }

            if ($con_eventos == true) {
                $title = $cED['descripcion'];
                if ($origen == 'banco_cuenta_mov_asignacion' || $origen == 'cuentat_gasto_asignacion') {
                    if ($dataVal== 'B' || $dataVal== 'E' || $dataVal== 'C') {
                        if (!empty($fecha_revision) and $posicion == $posicion_revision) {
                            $title = "Revisado: ($fecha_revision)";
                        } else {
                            $query = "SELECT revisado_el FROM asignacion WHERE cuentat_gasto_id = '$r_id' /*AND origen = '$origen_prefix'*/ AND posicion = $posicion";
                            $fecha = ia_singleread($query);
                            if (!empty($fecha)) {
                                $title = "Revisado: ($fecha)";
                            }
                        }
                    } else if($dataVal == 'A') {
                        if (!empty($fecha_revision) and $posicion == $posicion_revision) {
                            $title = "Asignado: ($fecha_revision)";
                        } else {
                            $query = "SELECT date(alta_db) FROM asignacion WHERE cuentat_gasto_id = '$r_id' /*AND origen = '$origen_prefix'*/ AND posicion = $posicion";
                            // echo $query . " -> ";
                            $fecha = ia_singleread($query);
                            if (!empty($fecha)) {
                                $title = "Asignado: ($fecha)";
                            }
                        }
                    }
                }
                // dd_($posicion, $posicion_revision);
                // echo $title . "<br>";
                // exit;

                /*$data = "title=\"$title\"
                id=\"$i-$r_id\"
                data-pos=\"$i\"
                data-orden=\"$cED[orden]\"
                data-celval=\"$valor\"
                data-val=\"$dataVal\"
                data-user=\"$cED[usuario_id]\"
                data-estadovalor=\"$cED[valor]\"
                data-colname=\"asignacion\"
                data-rid=\"$r_id\"
                data-indexpos=\"$cED[posicion]\"";*/

                $data = "title='$title' id='$i-$r_id' data-pos='$i'  data-orden='$cED[orden]'  data-celval='$valor' data-val='$dataVal' data-user='$cED[usuario_id]' data-estadovalor='$cED[valor]' data-colname='asignacion' data-rid='$r_id' data-indexpos='$cED[posicion]'";
                $tcStyle .= 'cursor:inherit;';

                $doble_click = "";
                if ($activaDBLClick)
                    $doble_click = "ondblclick=\"handleDBLClickAsignacion(this, $cED[posicion], `$r_id`, event)\"";

                $right_click = "";
                if ($activaContextClick)
                    $right_click = "oncontextmenu=\"handleContextClickAsignacion(this, $cED[posicion], `$r_id`); return false;\"";

                $eventos = "onmouseover=\"$(this).addClass(`ui-state-hover`);\" onmouseout=\"$(this).removeClass(`ui-state-hover`)\" onclick=\"handleClickAsignacion(this, `asignacion`, $cED[posicion], `$r_id`, event);\" $doble_click $right_click";
            }

            $tcStyle .='"';

            $divCell .= $divRow . "<div class=\"col-button asignacion\" $data $eventos><div $tcStyle><strong>$cED[clave]</strong></div></div>";
        }
    }
    $div_table .= $divCell . '</div>';
    return strim("<div>$div_table</div>");
}

function async_all(){
    @async_ws_actualiza_clientes_saldos();
    return;
    /**
    @async_ws_actualizaIngresos();
    @async_ws_mergeCtaTMovs();
    @async_ws_actualizaACuentasLive();
    @async_ws_actualizaFacturasCanceladas();
    @async_ws_actualizaFiduciariosAtrasados();
    @async_ws_actualizaGastosImportantes();
    @async_ws_actualizaWithdrawalsImportantes();
    @async_ws_actualizaInversionesAtrasadas();
    @async_ws_releaseBackofficeFile2EdoCtaAllLock();
    
    @async_ws_generaCatalogos();
    @async_ws_actualizaLinksAlBancoLive();
    @async_ws_actualizaGastosPorRevisar();
    @async_ws_actualizaConteoMovimientosDivisa();
    @async_ws_updateMaxMinCountAll();

    @async_ws_banco_cuenta_mov_puede_borrar();
    @async_ws_disable_tc_temp_timeout();
    @async_ws_banco_cuenta_mov_puede_borrar();
    **/
}

function fechaMysql2JS(&$fecha)
{
    if(empty($fecha))
        return "";

    if(!is_array($fecha))
        return date("d-m-Y",strtotime($fecha));
    else
    {
        foreach($fecha as $k=>$v)
        {
            if(!empty($v) && strpos($k,"fecha")!== false)
                $fecha[$k]=date("d-m-Y",strtotime($v));
        }

        return $fecha;
    }
}

function cmSelectValues($va, $id, $label=null)
{
    if (empty($label))
        $label = $id;
    $ret = "'':''";
    foreach ($va as $v)
        $ret .= ",'" . $v[$id] . "':'" . $v[$label] . "'";
    return $ret;
}

function activa_errores() {
    global $vx_debug;

    error_reporting(-1);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);

    if(!$vx_debug)
        return;

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    ini_set('display_errors', 'On');

}
function getTabsToAssignments()
{
    $sql = "SELECT
                iac_usr_id usuario_id, nombre,
                puede_revisar_gastos_cuentaT,
                puede_revisar_movimientos_banco,
                puede_ser_supervisor_banco,
                puede_ser_supervisor,
                activa_alerta_gastos
            FROM iac_usr
            WHERE
                puede_revisar_gastos_cuentaT = 'Si' OR
                puede_revisar_movimientos_banco = 'Si' OR
                puede_ser_supervisor_banco = 'Si' OR
                puede_ser_supervisor = 'Si'";
    $revisores_supervisores = ia_sqlArrayIndx($sql);
    $tabs = "";
    foreach ($revisores_supervisores as $index => $user) {
        $tienePermisoBanco = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
        $puedeRevisarBanco = puedeRevisarGastosBanco($user['usuario_id']);
        $tienePermisoGCT = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
        $puedeRevisarGCT = puedeRevisarGastosCuentaT($user['usuario_id']);
        $blink = $user['activa_alerta_gastos'] == 'Si' ? 'blink_revisor': '';
        if (($puedeRevisarBanco && $tienePermisoBanco !== false) || ($puedeRevisarGCT && $tienePermisoGCT !== false)) {
            $tabs .= "<li class='noselect $blink'>
                        <a href='#gastos-$user[usuario_id]'>Gastos ". ucfirst(strtolower($user['nombre']))."</a>
                        <button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id])' title='Activar/Desactivar alerta de gastos'></button>
                    </li>";
        }
    }
    return $tabs;
}

function getDivsToAssignments()
{
    $sql = "SELECT
                iac_usr_id usuario_id, nombre,
                puede_revisar_gastos_cuentaT,
                puede_revisar_movimientos_banco,
                puede_ser_supervisor_banco,
                puede_ser_supervisor,
                activa_alerta_gastos
            FROM iac_usr
            WHERE
                puede_revisar_gastos_cuentaT = 'Si' OR
                puede_revisar_movimientos_banco = 'Si' OR
                puede_ser_supervisor_banco = 'Si' OR
                puede_ser_supervisor = 'Si'";
    $revisores_supervisores = ia_sqlArrayIndx($sql);
    $divs = "";
    foreach ($revisores_supervisores as $index => $user) {
        $tienePermisoBanco = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
        $puedeRevisarBanco = puedeRevisarGastosBanco($user['usuario_id']);
        $tienePermisoGCT = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
        $puedeRevisarGCT = puedeRevisarGastosCuentaT($user['usuario_id']);
        $link_retiros_banco = "";
        $link_gastos_ct = "";
        if (($puedeRevisarBanco && $tienePermisoBanco !== false) || ($puedeRevisarGCT && $tienePermisoGCT !== false)) {
            if ($puedeRevisarBanco && $tienePermisoBanco !== false) {
                $pos = obtenNumeroRevisorMovimientosBanco($user['usuario_id']);
                $link_retiros_banco = "<li><a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>Asignaciones de <span class='txt_bold_orange' >Widthrawals</span></a></li><br />&nbsp;";
            }
            if ($puedeRevisarGCT && $tienePermisoGCT !== false) {
                $pos = obtenNumeroRevisorGastosCuentaT($user['usuario_id']);
                $link_gastos_ct .= "<li><a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>Asignaciones de <span class='txt_bold_brightred' >Gastos de Cuenta T</span></a></li><br />&nbsp;";
            }
            $divs .= "<div id='gastos-$user[usuario_id]'>
                        <ul class='tab'>
                            $link_retiros_banco
                            $link_gastos_ct
                        </ul>
                    </div>";
        }
    }
    return $divs;
}

function getLinksToAssignments()
{
    $sql = "SELECT
                iac_usr_id usuario_id, nombre,
                puede_revisar_gastos_cuentaT,
                puede_revisar_movimientos_banco,
                puede_ser_supervisor_banco,
                puede_ser_supervisor,
                activa_alerta_gastos
            FROM iac_usr
            WHERE
                puede_revisar_gastos_cuentaT = 'Si' OR
                puede_revisar_movimientos_banco = 'Si' OR
                puede_ser_supervisor_banco = 'Si' OR
                puede_ser_supervisor = 'Si'";
    $revisores_supervisores = ia_sqlArrayIndx($sql);

    // dd_($revisores_supervisores);

    $likns_retiros_banco = "";
    $likns_gastos_ct = "";

    foreach ($revisores_supervisores as $index => $user) {
        // dd_($user['usuario_id']);
        $estado_revisor = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
        // puedeRevisarGastosBanco() && $estado_revisor !== false)
        if (puedeRevisarGastosBanco($user['usuario_id']) && $estado_revisor !== false) {
            // <a href="cuentat_gasto_list.php$usuarioTipoRony ? '':'?normal=SI';>Gastos de Cuenta T</a>
            $pos = obtenNumeroRevisorMovimientosBanco($user['usuario_id']);
            $likns_retiros_banco .= "<li><a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>Asignaciones de <span class='txt_bold_orange' >Widthrawals de $user[nombre]</span></a></li><br />&nbsp;";
        }
        $estado_revisor = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
        if (puedeRevisarGastosCuentaT($user['usuario_id']) && $estado_revisor !== false) {
            $pos = obtenNumeroRevisorGastosCuentaT($user['usuario_id']);
            $likns_gastos_ct .= "<li><a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>Asignaciones de <span class='txt_bold_brightred' >Gastos de Cuenta T de $user[nombre]</span></a></li><br />&nbsp;";
        }

    }

    // $li_s = "<li>LINK TO 1</li><br />&nbsp;";

    return (!empty($likns_retiros_banco) || !empty($likns_gastos_ct) ? "<hr style='width: 400px; border-top-color: lightcoral; border-right-color: lightcoral; border-bottom-color: lightcoral; border-left-color: lightcoral; background-color: lightcoral;' align='left'><br>" : "") . $likns_retiros_banco . $likns_gastos_ct;
}

function traeSupervisoresyRevisores($profile = null)
{
    $where = "";
    if ($profile == null) {
       $where = "puede_revisar_gastos_cuentaT = 'Si' OR
       puede_revisar_movimientos_banco = 'Si' OR
       puede_ser_supervisor_banco = 'Si' OR
       puede_ser_supervisor = 'Si'";
    } elseif ($profile == 'revisor') {
        $where = "puede_revisar_gastos_cuentaT = 'Si' OR
        puede_revisar_movimientos_banco = 'Si'";
    } elseif ($profile == 'supervisor') {
        $where = "puede_ser_supervisor_banco = 'Si' OR
        puede_ser_supervisor = 'Si'";
    }

    $sql = "SELECT
                iac_usr_id usuario_id, nombre,
                puede_revisar_gastos_cuentaT,
                puede_revisar_movimientos_banco,
                puede_ser_supervisor_banco,
                puede_ser_supervisor,
                activa_alerta_gastos
            FROM iac_usr
            WHERE
                $where";

    return ia_sqlArrayIndx($sql);
}

function traeSupervisoresRevisores($user_id = null, $profile = null, $full = false, $origen = null)
{
    $function = __FUNCTION__;
    // if($profile == "revisor"){
        // dd_($origen);
    // }
    $where_complete = "";
    if ($user_id !== null) {
        // $us_id = $_SESSION['usuario_id'];
        $us_id = $user_id;
        $where[]= " usuario_id = $us_id";
    }
    $where_complete_profile = "";
    if ($profile != null) {
        $where[]= " (origen = '$profile')";
    }
    $where_complete_origen = "";
    if(!empty($origen)){
        $where_complete_origen= " AND e.origen='$origen'";
    }
    /* if ($profile == 'revisor') {
        $where_complete_profile = "WHERE puede_revisar_gastos_cuentaT = 'Si' OR puede_revisar_movimientos_banco = 'Si'";
    } */
    $where= implode(" AND ", $where);
    // echo
    $select = "SELECT /*$function*/
                    e.estado_id,
                    e.usuario_id, e.clave, u.nombre, e.activo, e.posicion, e.valor,
                    puede_revisar_gastos_cuentaT,
                    puede_revisar_movimientos_banco,
                    puede_ser_supervisor_banco,
                    puede_ser_supervisor,
                    -- activa_alerta_gastos,
                    IF((e.origen = 'banco_cuenta_mov_asignacion' OR e.origen = 'cuentat_gasto_asignacion'), 'revisor', 'supervisor') origen,
                    'No' ya_esta
                FROM estado e
                join iac_usr u on u.iac_usr_id = e.usuario_id
                WHERE usuario_id != 0 AND activo = 'Si' $where_complete_origen";

    if ($full == false)  {
        $select = "SELECT /*$function*/* FROM ($select) asignaciones
        WHERE $where 
        GROUP BY usuario_id, clave, origen
        ORDER BY usuario_id, origen";
    } else {
        $select = "SELECT /*$function*/ * FROM ($select) asignaciones
                WHERE $where
                ORDER BY usuario_id, origen desc";
    }
    // echo $select;
    // if($profile == "revisor"){
    //     dd_($select);
    // }
    return ia_sqlArrayIndx($select);
}

function getTableSupervisorsReviewers()
{
    activa_errores();
    // $revisores_supervisores = traeSupervisoresyRevisores();
    // dd_(esRevisor());
    $where_complete = "";
    $es_revisor = esRevisor();
    $us_id = null;
    if ($es_revisor) {
        $us_id = $_SESSION['usuario_id'];
    }

    $users = traeSupervisoresRevisores($us_id);
    // dd_($users);

    if (!empty($users)) {
        // $supervisores = isset($users['supervisor']) ? $users['supervisor'] : [];
        // $revisores = isset($users['revisor']) ? $users['revisor'] : [];

        // dd_($supervisores);

        // dd_($users);

        $td_supervisor_banco = "";
        $td_supervisor_cuant_t = "";
        $td_revisor_banco = "";
        $td_revisor_cuenta_t = "";
        $ya_estan = [];
        $key_search = "";
        $showSupervisor = true;
        foreach ($users as $index => $user) {
            // $td_supervisor_banco .= "";
            // $td_supervisor_cuant_t .= "";
            $blink = $user['activa_alerta_gastos'] == 'Si' ? 'blink_revisor': '';
            if (!in_array($user['usuario_id'], $ya_estan)) {
                if ($user['puede_ser_supervisor_banco'] == 'No' and $user['puede_ser_supervisor'] == 'No' and $es_revisor == true) {
                    $showSupervisor = false;
                }
                if ($user['puede_ser_supervisor_banco'] == 'Si' and $user['puede_ser_supervisor'] == 'No') {
                    $estado_revisor = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
                    if (puedeRevisarGastosBanco($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorMovimientosBanco($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de banco revisados";
                        if (tieneGastosPorRevisar($pos, 'banco_cuenta_mov')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de banco por revisar";
                        }
                        $td_supervisor_banco .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                            <span type='button' class='$class_con_gastos' title='$text_gastos'></span>    
                            <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                }
                if ($user['puede_ser_supervisor_banco'] == 'No' and $user['puede_ser_supervisor'] == 'Si') {
                    $estado_revisor = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
                    if (puedeRevisarGastosCuentaT($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorGastosCuentaT($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de Cuenat T revisados";
                        if (tieneGastosPorRevisar($pos, 'cuenta_t')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de cuenta T por revisar";
                        }
                        $td_supervisor_cuant_t .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                           <a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                           <span type='button' class='$class_con_gastos' title='$text_gastos'></span>    
                           <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                }
                if ($user['puede_ser_supervisor_banco'] == 'Si' and $user['puede_ser_supervisor'] == 'Si') {
                    $estado_revisor = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
                    if (puedeRevisarGastosBanco($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorMovimientosBanco($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de banco revisados";
                        if (tieneGastosPorRevisar($pos, 'banco_cuenta_mov')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de banco por revisar";
                        }
                        $td_supervisor_banco .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                            <span type='button' class='$class_con_gastos' title='$text_gastos'></span>    
                            <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                    $estado_revisor = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
                    if (puedeRevisarGastosCuentaT($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorGastosCuentaT($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de Cuenat T revisados";
                        if (tieneGastosPorRevisar($pos, 'cuenta_t')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de Cuenta T por revisar";
                        }
                        $td_supervisor_cuant_t .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                            <span type='button' class='$class_con_gastos' title='$text_gastos'></span>
                            <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                }

                if ($user['puede_ser_supervisor_banco'] == 'No' and $user['puede_revisar_movimientos_banco'] == 'Si') {
                    $estado_revisor = obtenEstadoRevisorMovimientosBancoPermission($user['usuario_id']);
                    if (puedeRevisarGastosBanco($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorMovimientosBanco($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de banco revisados";
                        if (tieneGastosPorRevisar($pos, 'banco_cuenta_mov')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de banco por revisar";
                        }
                        $td_revisor_banco .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold ui-tabs-anchor' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                            <span type='button' class='$class_con_gastos' title='$text_gastos'></span>
                            <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                }
                if ($user['puede_ser_supervisor'] == 'No' and $user['puede_revisar_gastos_cuentaT'] == 'Si') {
                    $estado_revisor = obtenEstadoRevisorGastosCuentaTPermission($user['usuario_id']);
                    if (puedeRevisarGastosCuentaT($user['usuario_id']) && $estado_revisor !== false) {
                        $pos = obtenNumeroRevisorGastosCuentaT($user['usuario_id']);
                        $class_con_gastos = "sin-gastos";
                        $text_gastos= "Gastos de Cuenta T revisados";
                        if (tieneGastosPorRevisar($pos, 'cuenta_t')) {
                            $class_con_gastos = "con-gastos";
                            $text_gastos = "Tiene gastos de Cuenat T por revisar";
                        }
                        $td_revisor_cuenta_t .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[usuario_id]&pos=$pos'>$user[nombre]</a>
                            <span type='button' class='$class_con_gastos' title='$text_gastos'></span>
                            <!--button type='button' class='btn-set-blink' onclick='setActiveAlert($user[usuario_id], false, this)' title='Activar/Desactivar alerta de gastos'></button-->
                        </div>";
                    }
                }
            }
            array_push($ya_estan, $user['usuario_id']);
        }
    }
    $contentSupervisor = "";
    if ($showSupervisor == true) {
        $contentSupervisor = "<div id='divSupervisor' class='cssAsignacion'>
                                <span class='titlesSuperAsig'>Banco</span>
                                <br><br>
                                $td_supervisor_banco
                            </div>
                            <span class='upperTitle'>Supervisor</span>
                            <div id='divAsginacion' class='cssSupervisor'>
                                <span class='titlesSuperAsig'>Cuenta  T</span>
                                <br><br>
                                $td_supervisor_cuant_t
                            </div>";
    }
    $divContent="<div class='divSuperAsig'>
                    $contentSupervisor
                    <div id='divSupervisor' class='cssAsignacion'>
                        <span class='titlesSuperAsig'>Banco</span>
                        <br><br>
                        $td_revisor_banco
                    </div>
                    <span class='upperTitle'>Revisor</span>
                    <div id='divAsginacion' class='cssSupervisorDer'>
                        <span class='titlesSuperAsig'>Cuenta  T</span>
                        <br><br>
                        $td_revisor_cuenta_t
                    </div>
                </div>";
    return $divContent;
}

function getTableSupervisorsReviewers_2()
{

    // dd_($supervisores, $revisores);
    global $gIAParametros;
    $td_supervisor_banco = "";
    $td_supervisor_cuant_t = "";
    $td_revisor_banco = "";
    $td_revisor_cuenta_t = "";

    $es_revisor = (esRevisor() || esRevisorBanco()) ? true: false;

    if (usuarioTipoRony())
        $es_revisor = false;

    if (!$es_revisor and !usuarioTipoRony()) return '';

    $us_id = null;
    $where_complete = "";
    if ($es_revisor) {
        $us_id = $_SESSION['usuario_id'];
        $where_complete = "AND campo_id = '$us_id'";
    }
    $select = "SELECT * FROM campos_exists WHERE tabla_exists IN ('supervisor', 'revisor') $where_complete";
    $users = ia_sqlArrayIndx($select);

    $suprvisores = [];
    $revisores = [];
    if (!empty($users)) {
        $users_2 = objetivisa_($users, 'tabla_exists');
        $suprvisores = isset($users_2['supervisor']) ? $users_2['supervisor'] : [];
        $revisores = isset($users_2['revisor']) ? $users_2['revisor'] : [];
    }

    $tipos = [];
    $ya_esta_en_supervisor_banco = [];
    $ya_esta_en_supervisor_ct = [];

    $gatos_pendientes = 0;
    $today = date('Y-m-d');

    $solo_es_supervisor = true;
    // $diff = date_diff(date_create('2021-07-01'), date_create($today));
    // $dias = dateDifference('2021-07-01', $today, '%a');
    // dd_($today, $dias, $dias>3);

    $supervisores = traeSupervisoresRevisores(null, 'supervisor', true);
    if (count($supervisores) > 0) {
        foreach ($suprvisores as $index => $user) {
            if ($user['activo'] == 'No') { continue;}
            array_push($tipos, $user['tabla_exists']);
            if ($user['tabla_exists'] == 'supervisor' and $user['tabla_origen'] == 'banco') {
                $class_con_gastos = "sin-gastos";
                $text_gastos= "Gastos de banco revisados";
                if ($user['valor'] != '0' || $user['valor'] != 0) {
                    $class_con_gastos = "con-gastos";
                    $text_gastos = "Tiene gastos de banco por revisar";
                }
                $span = "";
                if (dateDifference($user['fecha'], $today, '%a') > $gIAParametros['dias_para_avisar_supervisor']) {
                    $span = "<span type='button' class='$class_con_gastos' title='$text_gastos'></span>";
                }
                $td_supervisor_banco .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[campo_id]&pos=$user[posicion]&supervisor=SI'>$user[nombre]</a>
                            $span
                        </div><br>";
                $key = $user['campo_id'] . "_" . $user['posicion'];
                array_push($ya_esta_en_supervisor_banco, $key);
            }
            if ($user['tabla_exists'] == 'supervisor' and $user['tabla_origen'] == 'cuenta_t') {
                $class_con_gastos = "sin-gastos";
                $text_gastos= "Gastos de cuenta t revisados";
                if ($user['valor'] != '0' || $user['valor'] != 0) {
                    $class_con_gastos = "con-gastos";
                    $text_gastos = "Tiene gastos de cuenat t por revisar";
                }
                $span = "";
                if (dateDifference($user['fecha'], $today, '%a') > $gIAParametros['dias_para_avisar_supervisor']) {
                    $span = "<span type='button' class='$class_con_gastos' title='$text_gastos'></span>";
                }
                $td_supervisor_cuant_t .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                            <a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[campo_id]&pos=$user[posicion]&supervisor=SI'>$user[nombre]</a>
                            $span
                        </div><br>";
                $key = $user['campo_id'] . "_" . $user['posicion'];
                array_push($ya_esta_en_supervisor_ct, $key);
            }
        }
    }


    $revisoresCount = traeSupervisoresRevisores(null, 'revisor', true);
// echo "<pre>"; print_r($revisoresCount); echo "</pre>"; die();
    if (count($revisoresCount) > 0) {
        foreach ($revisores as $index => $user) {
            if ($user['activo'] == 'No') { continue;}

            if ($es_revisor == true) {
                $solo_es_supervisor = false;
            }
            if ($user['tabla_exists'] == 'revisor' and $user['tabla_origen'] == 'banco') {
                $key = $user['campo_id'] . "_" . $user['posicion'];
                // dd_($ya_esta_en_supervisor_banco, $user);
                // if (!in_array($key, $ya_esta_en_supervisor_banco)) {
                if ($es_revisor == true) {
                    $gatos_pendientes = $gatos_pendientes + intval($user['valor']);
                }
                $class_con_gastos = "sin-gastos";
                $text_gastos= "Gastos de banco revisados";
                if ($user['valor'] != '0' || $user['valor'] != 0) {
                    $class_con_gastos = "con-gastos";
                    $text_gastos = "Tiene gastos de banco por revisar";
                }
                $td_revisor_banco .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                                <a class='bold' href='withdrawals_de_banco_list.php?normal=NO&user_id=$user[campo_id]&pos=$user[posicion]'>$user[nombre]</a>
                                <span type='button' class='$class_con_gastos' title='$text_gastos'></span>    
                            </div><br>";
                // }
            }
            if ($user['tabla_exists'] == 'revisor' and $user['tabla_origen'] == 'cuenta_t') {
                $key = $user['campo_id'] . "_" . $user['posicion'];
                // if (!in_array($key, $ya_esta_en_supervisor_ct)) {
                if ($es_revisor == true) {
                    $gatos_pendientes = $gatos_pendientes + intval($user['valor']);
                }
                $class_con_gastos = "sin-gastos";
                $text_gastos= "Gastos de banco revisados";
                if ($user['valor'] != '0' || $user['valor'] != 0) {
                    $class_con_gastos = "con-gastos";
                    $text_gastos = "Tiene gastos de banco por revisar";
                }
                $td_revisor_cuenta_t .= "<div class='noselect ui-tabs-tab ui-corner-top ui-state-default ui-tab btn-asignacion'>
                                <a class='bold' href='cuentat_gasto_list.php?normal=NO&user_id=$user[campo_id]&pos=$user[posicion]'>$user[nombre]</a>
                                <span type='button' class='$class_con_gastos' title='$text_gastos'></span>    
                            </div><br>";
                // }
            }

        }
    }


    $contentSupervisor = "";
    $es_supervisor = false;
    if ($es_revisor == true) {
        if (in_array('supervisor', $tipos)) {
            $es_supervisor = true;
            if (count($supervisores) > 0) {
                $contentSupervisor = "<ul class='tab'>
                                        <div class='divSuperAsig'>
                                            <div id='divSupervisor' class='cssAsignacion'>
                                                <span class='titlesSuperAsig'>Banco</span>
                                                <br><br>
                                                $td_supervisor_banco
                                            </div>
                                            <span class='upperTitle'>Supervisor</span>
                                            <div id='divAsginacion' class='cssSupervisorDer'>
                                                <span class='titlesSuperAsig'>Cuenta  T</span>
                                                <br><br>
                                                $td_supervisor_cuant_t
                                            </div>
                                        </div>
                                    </ul>";
            }
        }
    } else {
        if (count($supervisores) > 0) {
            $contentSupervisor = "<ul class='tab'>
                                    <div class='divSuperAsig'>
                                        <div id='divSupervisor' class='cssAsignacion'>
                                            <span class='titlesSuperAsig'>Banco</span>
                                            <br><br>
                                            $td_supervisor_banco
                                        </div>
                                        <span class='upperTitle'>Supervisor</span>
                                        <div id='divAsginacion' class='cssSupervisorDer'>
                                            <span class='titlesSuperAsig'>Cuenta  T</span>
                                            <br><br>
                                            $td_supervisor_cuant_t
                                        </div>
                                    </div>
                                </ul>";
        }
    }
    if (count($revisoresCount) > 0) {
        $contentRevisor ="<ul class='tab'>
                            <div class='divSuperAsig'>
                                <div id='divSupervisor' class='cssAsignacion'>
                                    <span class='titlesSuperAsig'>Banco</span>
                                    <br><br>
                                    $td_revisor_banco
                                </div>
                                <span class='upperTitle'>Revisor</span>
                                <div id='divAsginacion' class='cssSupervisor'>
                                    <span class='titlesSuperAsig'>Cuenta  T</span>
                                    <br><br>
                                    $td_revisor_cuenta_t
                                </div>
                            </div>
                        </ul>";
    } else {
        $contentRevisor = '';
    }

    if (count($revisoresCount) === 0 and count($supervisores) === 0) {
        $divContent = '';
    } else {
        $divContent="<style>.conFlex{ display: flex; gap: 2em; }</style><div class='conFlex'>
                        $contentRevisor
                        $contentSupervisor
                    </div>
                    ";
    }

    $es_revisor = ($es_revisor) ? 'true': 'false';
    $es_supervisor = ($es_supervisor) ? 'true': 'false';
    $solo_es_supervisor = ($solo_es_supervisor) ? 'true': 'false';
    echo <<<TAB_Blink_Gastos
    <script>
        var  es_revisor = $es_revisor,
            gastos_pendientes = $gatos_pendientes,
            es_supervisor = $es_supervisor,
            solo_es_supevisor = $solo_es_supervisor;
        $(() => {
            // console.log(es_revisor, gastos_pendientes);
            if (es_revisor == true &&  gastos_pendientes > 0 && !es_supervisor) {
                $('#tab-gastos').append("<span type='button' class='con-gastos'></span>");
            }
            if (es_revisor == true &&  gastos_pendientes > 0 && !solo_es_supevisor) {
                $('#tab-gastos').append("<span type='button' class='con-gastos'></span>");
            }
        });
    </script>
TAB_Blink_Gastos;
    return $divContent;
}

function getPosEstado($id)
{
    $query = "SELECT * FROM estado WHERE estado_id = '$id'";
    $estado = ia_singleton($query);
    if (empty($estado)){
      return false;
    }
    return strpos($estado['valor'], 'Z');
}

function parseClauseIn($keys = [])
{
    if(empty($keys) || !is_array($keys))
        return "'\t'";

    $in_clause = '';
    foreach ($keys as $key) {
        $in_clause.= strit($key) . ", ";
    }
    if(strlen($in_clause))
        $in_clause = substr($in_clause, 0, -2);
    $in_clause = trim($in_clause);
    if(empty($in_clause))
        return "'\t'";
    return $in_clause;
}

function calculaEstadoDispobible ($origen)
{
    $query = "SELECT * FROM estado WHERE origen = '$origen' ORDER BY orden ASC";
    $estados = ia_sqlArrayIndx($query);
    if (!empty($estados)) {
        foreach ($estados as $item => $estado) {
            if ($estado['usuario_id'] == '0' || $estado['usuario_id'] == 0) {
                return $estado['estado_id'];
                break;
            }
        }
    }
}

function haz_update ($campos, $table, $pkField)
{
    $set_s = "";
    if (empty($campos)) return '';

    foreach ($campos as $campo => $valor) {
        if ($campo != $pkField) {
            $set_s .= fieldit($campo) . '=' . strit($valor) . ', ';
        }
    }
    $set_s = substr($set_s, 0, -2);
    $id = $campos[$pkField];
    return "UPDATE $table SET $set_s WHERE $pkField = '$id'";
}

function countUserEstado($origen, $user)
{
    $sql = "SELECT count(*) conteo FROM estado WHERE origen = '$origen' AND usuario_id = '$user'";

    return ia_singleread($sql);
}

function tieneGastosPorRevisar($pos, $origen, $return_total = false)
{
    $estado_base = '____________';
    $like_asignado = $estado_base;
    $like_rechazado = $estado_base;

    $like_asignado[$pos] = 'A';
    $like_rechazado[$pos] = 'D';
    if ($origen == 'cuenta_t') {
        $select = "SELECT count(*) totales FROM cuentat_gasto WHERE (asignacion LIKE '%$like_asignado%' OR asignacion LIKE '%$like_rechazado%') AND activo = 'Si'";
    } else {
        $select = "SELECT count(*) totales FROM banco_cuenta_mov WHERE (asignacion LIKE '%$like_asignado%' OR asignacion LIKE '%$like_rechazado%') AND es = 'retiro'";
    }
    // dd_($select, $origen);
    $count = ia_singleread($select);

    if ($return_total == true) return $count;

    if ($count > 0) return true;

    return false;
}

function getMinimumAssignmentDate($user_id, $origen, $posicion)
{
    $query = "SELECT DATE(MIN(alta_db)) fecha FROM asignacion WHERE usuario_id = $user_id AND origen = '$origen' AND posicion = $posicion AND estatus_revision = 'A' ORDER BY alta_db";

    return ia_singleread($query);
}

function dateDifference($date_1 , $date_2 , $differenceFormat = '%y Year %m Month %d Day' )
{
    // '%y Year %m Month %d Day'            => 1 Year 3 Month 14 Days
    // '%m Month %d Day'                    => 3 Month 14 Day
    // '%d Day %h Hours'                    =>  14 Day 11 Hours
    // '%d Day'                             =>  14 Days
    // '%h Hours %i Minute %s Seconds'      =>  11 Hours 49 Minute 36 Seconds
    // '%i Minute %s Seconds'               =>  49 Minute 36 Seconds
    // '%h Hours                            =>  11 Hours
    // '%a Days                             =>  468 Days
    $datetime1 = date_create($date_1);
    $datetime2 = date_create($date_2);

    $interval = date_diff($datetime1, $datetime2);

    return $interval->format($differenceFormat);
}


function objetivisa_($datos, $key, $is_unique = false){
    $regresa = [];
    if($datos != null){
        foreach ($datos as $d) {
            $indice = normaliza_($d[$key] ?? '');
            if ($is_unique) {
                $regresa[$indice] = $d;
            }
            else {
                $regresa[$indice][] = $d;
            }

        }
    }
    return $regresa;
}
function normaliza_($cadena){
    $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
    $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
//    $cadena = utf8_decode($cadena); //PHP 8.2
    $cadena = mb_convert_encoding($cadena, 'ISO-8859-1', 'UTF-8');
    $cadena = str_replace($originales, $modificadas, $cadena);
    // $cadena = strtolower($cadena);
//    return utf8_encode($cadena); PHP 8.2
    return mb_convert_encoding($cadena, 'UTF-8', 'ISO-8859-1');
}

function obten_array_norm_doctos(){

    return $normalize=array(
        'cheque'=>array(
            'tabla'=>'cheque',
            'from'=> "(cheque left join cliente on((cheque.cliente_id = cliente.cliente_id)) left join categoria on((cheque.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'cheque.tienda_id',
            'moneda_id'=>'cheque.moneda_id',
            'numero'=>'cheque.numero',
            'cliente_id' => 'cheque.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((cheque.new_date is null),cheque.original_date,cheque.new_date)',
            'alta_db'=>'cheque.alta_db',
            'alta_por' => 'cheque.alta_por',
            'quantity' => 'cheque.quantity',
            'total_payments'=>'cheque.total_payments',
            'debe' => 'if(((cheque.quantity - cheque.total_payments) < 0),0,(cheque.quantity - cheque.total_payments))',
            'saldo' => 'if((cheque.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'cheque.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'cheque.origen_cuentat_id',
            'numero_sistema' => 'cheque.numero_sistema',
            'remarks'=>'cheque.remarks',
            'autorizado' => 'cheque.autorizado',
            'autorizado_por' => 'cheque.autorizado_por',
            'autorizado_el' => 'cheque.autorizado_el',
            'borrado' => 'cheque.borrado',
            'borrado_por' => 'cheque.borrado_por',
            'borrado_el' => 'cheque.borrado_el',
            'doc_id' => 'cheque.cheque_id',
            'doc_origen_id' => 'cheque.cheque_id',
            'origen' => "if((((cheque.origen_cuentat_id is null) or (cheque.origen_cuentat_id = '')) and (cheque.delivered_directo = '1' OR cuentaT_transferto_id > 0 OR cuentaT_deliveredto_id > 0)),'CHEQUE DD','CHEQUE')",
            'paid' => 'cheque.paid',
            'delivered_directo' => 'cheque.delivered_directo',
            'ultimo_movimiento' => 'cheque.ultimo_movimiento',
            'desautorizado_el' => 'cheque.desautorizado_el',
            'numero_contenedor' => 'cheque.numero_contenedor',
            'lugar_de_entrada' => 'cheque.lugar_de_entrada',
            'tipo_de_tela' => 'cheque.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'cheque.moneda_id',
            'remarks_wot' => 'cheque.remarks_wot',
            'cuentat_mov_id' => 'cheque.cuentat_mov_id',
            'acta_quantity' => "IF(cheque.tipo = 'CHEQUE', cheque.quantity * -1, 0)",
            'rechazado' => 'cheque.rechazado',
            'categoria_id' => 'cheque.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'cheque.tipo',
            'paid_when' => 'cheque.paid_when',
            'ultimo_pago' => 'cheque.ultimo_pago',
            'tipo_cambio' => 'cheque.conversion_tipo_cambio',
            'puede_borrar' => 'cheque.puede_borrar',
            'bloqueado_el' => 'cheque.bloqueado_el',
            'set_origen_cuentat' => 'cheque.set_origen_cuentat',
            'puede_origen_cuentat' => 'cheque.puede_origen_cuentat',
            'ultimo_cambio' => 'cheque.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => 'cheque.puede_cambiar_tipo_cambio',
            'conversion_ultimo_cambio' => 'cheque.conversion_ultimo_cambio'
        ),
        'cheque_log'=>array(
            'tabla'=>'cheque_log',
            'from'=> "(cheque_log LEFT JOIN cliente ON((cheque_log.cliente_id = cliente.cliente_id)) left join categoria on((cheque_log.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'cheque_log.tienda_id',
            'moneda_id'=>'cheque_log.moneda_id',
            'numero'=>'cheque_log.numero',
            'cliente_id' => 'cheque_log.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((cheque_log.new_date is null),cheque_log.original_date,cheque_log.new_date)',
            'alta_db'=>'cheque_log.alta_db',
            'alta_por' => 'cheque_log.alta_por',
            'quantity' => 'cheque_log.quantity',
            'total_payments'=>'cheque_log.total_payments',
            'debe' => 'if(((cheque_log.quantity - cheque_log.total_payments) < 0),0,(cheque_log.quantity - cheque_log.total_payments))',
            'saldo' => 'if((cheque_log.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'cheque_log.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'cheque_log.origen_cuentat_id',
            'numero_sistema' => 'cheque_log.numero_sistema',
            'remarks'=>'cheque_log.remarks',
            'autorizado' => 'cheque_log.autorizado',
            'autorizado_por' => 'cheque_log.autorizado_por',
            'autorizado_el' => 'cheque_log.autorizado_el',
            'borrado' => 'cheque_log.borrado',
            'borrado_por' => 'cheque_log.borrado_por',
            'borrado_el' => 'cheque_log.borrado_el',
            'doc_id' => 'cheque_log.cheque_id',
            'doc_origen_id' => 'cheque_log.cheque_id',
            'origen' => "if((((cheque_log.origen_cuentat_id is null) or (cheque_log.origen_cuentat_id = '')) and (cheque_log.delivered_directo = '1' OR cuentaT_transferto_id > 0 OR cuentaT_deliveredto_id > 0)),'CHEQUE DD','CHEQUE')",
            'paid' => 'cheque_log.paid',
            'delivered_directo' => 'cheque_log.delivered_directo',
            'ultimo_movimiento' => 'cheque_log.ultimo_movimiento',
            'desautorizado_el' => 'cheque_log.desautorizado_el',
            'numero_contenedor' => 'cheque_log.numero_contenedor',
            'lugar_de_entrada' => 'cheque_log.lugar_de_entrada',
            'tipo_de_tela' => 'cheque_log.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'cheque_log.moneda_id',
            'remarks_wot' => 'cheque_log.remarks_wot',
            'cuentat_mov_id' => 'cheque_log.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'cheque_log.rechazado',
            'categoria_id' => 'cheque_log.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'cheque_log.tipo',
            'paid_when' => 'cheque_log.paid_when',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cheque_log.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cheque_log.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'pagare'=>array(
            'tabla'=>'pagare',
            'from'=> "(pagare LEFT JOIN cliente ON((pagare.cliente_id = cliente.cliente_id)) left join categoria on((pagare.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'pagare.tienda_id',
            'moneda_id'=>'pagare.moneda_id',
            'numero'=>'pagare.numero',
            'cliente_id' => 'pagare.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((pagare.new_date is null),pagare.original_date,pagare.new_date)',
            'alta_db'=>'pagare.alta_db',
            'alta_por' => 'pagare.alta_por',
            'quantity' => 'pagare.quantity',
            'total_payments'=>'pagare.total_payments',
            'debe' => 'if(((pagare.quantity - pagare.total_payments) < 0),0,(pagare.quantity - pagare.total_payments))',
            'saldo' => 'if((pagare.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'pagare.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'pagare.origen_cuentat_id',
            'numero_sistema' => 'pagare.numero_sistema',
            'remarks'=>'pagare.remarks',
            'autorizado' => 'pagare.autorizado',
            'autorizado_por' => 'pagare.autorizado_por',
            'autorizado_el' => 'pagare.autorizado_el',
            'borrado' => 'pagare.borrado',
            'borrado_por' => 'pagare.borrado_por',
            'borrado_el' => 'pagare.borrado_el',
            'doc_id' => 'pagare.pagare_id',
            'doc_origen_id' => 'pagare.pagare_id',
            'origen' => "'PAGARE'",
            'paid' => 'pagare.paid',
            'delivered_directo' => 'pagare.delivered_directo',
            'ultimo_movimiento' => 'pagare.ultimo_movimiento',
            'desautorizado_el' => 'pagare.desautorizado_el',
            'numero_contenedor' => 'pagare.numero_contenedor',
            'lugar_de_entrada' => 'pagare.lugar_de_entrada',
            'tipo_de_tela' => 'pagare.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'pagare.moneda_id',
            'remarks_wot' => 'pagare.remarks_wot',
            'cuentat_mov_id' => 'pagare.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'pagare.rechazado',
            'categoria_id' => 'pagare.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'pagare.tipo',
            'paid_when' => 'pagare.paid_when',
            'ultimo_pago' => 'pagare.ultimo_pago',
            'tipo_cambio' => 'pagare.conversion_tipo_cambio',
            'puede_borrar' => 'pagare.puede_borrar',
            'bloqueado_el' => 'pagare.bloqueado_el',
            'set_origen_cuentat' => 'pagare.set_origen_cuentat',
            'puede_origen_cuentat' => 'pagare.puede_origen_cuentat',
            'ultimo_cambio' => 'pagare.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => 'pagare.puede_cambiar_tipo_cambio',
            'conversion_ultimo_cambio' => 'pagare.conversion_ultimo_cambio'
        ),
        'pagare_log'=>array(
            'tabla'=>'pagare_log',
            'from'=> "(pagare_log LEFT JOIN cliente ON((pagare_log.cliente_id = cliente.cliente_id)) left join categoria on((pagare_log.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'pagare_log.tienda_id',
            'moneda_id'=>'pagare_log.moneda_id',
            'numero'=>'pagare_log.numero',
            'cliente_id' => 'pagare_log.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((pagare_log.new_date is null),pagare_log.original_date,pagare_log.new_date)',
            'alta_db'=>'pagare_log.alta_db',
            'alta_por' => 'pagare_log.alta_por',
            'quantity' => 'pagare_log.quantity',
            'total_payments'=>'pagare_log.total_payments',
            'debe' => 'if(((pagare_log.quantity - pagare_log.total_payments) < 0),0,(pagare_log.quantity - pagare_log.total_payments))',
            'saldo' => 'if((pagare_log.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'pagare_log.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'pagare_log.origen_cuentat_id',
            'numero_sistema' => 'pagare_log.numero_sistema',
            'remarks'=>'pagare_log.remarks',
            'autorizado' => 'pagare_log.autorizado',
            'autorizado_por' => 'pagare_log.autorizado_por',
            'autorizado_el' => 'pagare_log.autorizado_el',
            'borrado' => 'pagare_log.borrado',
            'borrado_por' => 'pagare_log.borrado_por',
            'borrado_el' => 'pagare_log.borrado_el',
            'doc_id' => 'pagare_log.pagare_id',
            'doc_origen_id' => 'pagare_log.pagare_id',
            'origen' => "'PAGARE'",
            'paid' => 'pagare_log.paid',
            'delivered_directo' => 'pagare_log.delivered_directo',
            'ultimo_movimiento' => 'pagare_log.ultimo_movimiento',
            'desautorizado_el' => 'pagare_log.desautorizado_el',
            'numero_contenedor' => 'pagare_log.numero_contenedor',
            'lugar_de_entrada' => 'pagare_log.lugar_de_entrada',
            'tipo_de_tela' => 'pagare_log.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'pagare_log.moneda_id',
            'remarks_wot' => 'pagare_log.remarks_wot',
            'cuentat_mov_id' => 'pagare_log.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'pagare_log.rechazado',
            'categoria_id' => 'pagare_log.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'pagare_log.tipo',
            'paid_when' => 'pagare_log.paid_when',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'pagare_log.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'pagare_log.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'vale'=>array(
            'tabla'=>'vale',
            'from'=> "(vale left join cliente on((vale.cliente_id = cliente.cliente_id)) left join categoria on((vale.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'vale.tienda_id',
            'moneda_id'=>'vale.moneda_id',
            'numero'=>'vale.vale_number',
            'cliente_id' => 'vale.cliente_id',
            'cliente' => 'if((vale.cliente_id is null), vale.cliente, cliente.nombre)',
            'fecha' => 'vale.fecha',
            'alta_db'=>'vale.alta_db',
            'alta_por' => 'vale.alta_por',
            'quantity' => 'vale.quantity',
            'total_payments'=>'vale.total_payments',
            'debe' => 'if(((vale.quantity - vale.total_payments) < 0),0,(vale.quantity - vale.total_payments))',
            'saldo' => 'if((vale.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'vale.dinero_en_cuentaT_id',
            'origen_cuentat_id' => 'vale.dinero_en_cuentaT_id',
            'numero_sistema' => 'vale.numero_sistema',
            'remarks'=>'vale.remarks',
            'autorizado' => 'vale.autorizado',
            'autorizado_por' => 'vale.autorizado_por',
            'autorizado_el' => 'vale.autorizado_el',
            'borrado' => 'vale.borrado',
            'borrado_por' => 'vale.borrado_por',
            'borrado_el' => 'vale.borrado_el',
            'doc_id' => 'vale.vale_id',
            'doc_origen_id' => 'vale.vale_id',
            'origen' => "'VALE'",
            'paid' => 'vale.paid',
            'delivered_directo' => '0',
            'ultimo_movimiento' => 'vale.ultimo_movimiento',
            'desautorizado_el' => 'vale.desautorizado_el',
            'numero_contenedor' => 'vale.numero_contenedor',
            'lugar_de_entrada' => 'vale.lugar_de_entrada',
            'tipo_de_tela' => 'vale.tipo_de_tela',
            'banco_cuenta_id' => 'vale.banco_cuenta_id',
            'deposit_fecha' => 'vale.deposit_fecha',
            'deposit_total' => 'vale.deposit_total',
            'doc_moneda' => 'vale.moneda_id',
            'remarks_wot' => 'vale.remarks_wot',
            'cuentat_mov_id' => 'vale.cuenta_t_mov_id',
            'acta_quantity' => 'vale.quantity_recibido',
            'rechazado' => 'vale.rechazado',
            'categoria_id' => 'vale.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'vale.tipo',
            'paid_when' => 'vale.paid_when',
            'ultimo_pago' => 'vale.ultimo_pago',
            'tipo_cambio' => 'vale.conversion_tipo_cambio',
            'puede_borrar' => 'vale.puede_borrar',
            'bloqueado_el' => 'vale.bloqueado_el',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'vale.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => 'vale.puede_cambiar_tipo_cambio',
            'conversion_ultimo_cambio' => 'vale.conversion_ultimo_cambio'
        ),
        'vale_log'=>array(
            'tabla'=>'vale_log',
            'from'=> "(vale_log LEFT JOIN cliente ON((vale_log.cliente_id = cliente.cliente_id)) left join categoria on((vale_log.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'vale_log.tienda_id',
            'moneda_id'=>'vale_log.moneda_id',
            'numero'=>'vale_log.vale_number',
            'cliente_id' => 'vale_log.cliente_id',
            'cliente' => 'if((vale_log.cliente_id is null), vale_log.cliente, cliente.nombre)',
            'fecha' => 'vale_log.fecha',
            'alta_db'=>'vale_log.alta_db',
            'alta_por' => 'vale_log.alta_por',
            'quantity' => 'vale_log.quantity',
            'total_payments'=>'vale_log.total_payments',
            'debe' => 'if(((vale_log.quantity - vale_log.total_payments) < 0),0,(vale_log.quantity - vale_log.total_payments))',
            'saldo' => 'if((vale_log.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'vale_log.dinero_en_cuentaT_id',
            'origen_cuentat_id' => 'vale_log.dinero_en_cuentaT_id',
            'numero_sistema' => 'vale_log.numero_sistema',
            'remarks'=>'vale_log.remarks',
            'autorizado' => 'vale_log.autorizado',
            'autorizado_por' => 'vale_log.autorizado_por',
            'autorizado_el' => 'vale_log.autorizado_el',
            'borrado' => 'vale_log.borrado',
            'borrado_por' => 'vale_log.borrado_por',
            'borrado_el' => 'vale_log.borrado_el',
            'doc_id' => 'vale_log.vale_id',
            'doc_origen_id' => 'vale_log.vale_id',
            'origen' => "'VALE'",
            'paid' => 'vale_log.paid',
            'delivered_directo' => '0',
            'ultimo_movimiento' => 'vale_log.ultimo_movimiento',
            'desautorizado_el' => 'vale_log.desautorizado_el',
            'numero_contenedor' => 'vale_log.numero_contenedor',
            'lugar_de_entrada' => 'vale_log.lugar_de_entrada',
            'tipo_de_tela' => 'vale_log.tipo_de_tela',
            'banco_cuenta_id' => 'vale_log.banco_cuenta_id',
            'deposit_fecha' => 'vale_log.deposit_fecha',
            'deposit_total' => 'vale_log.deposit_total',
            'doc_moneda' => 'vale_log.moneda_id',
            'remarks_wot' => 'vale_log.remarks_wot',
            'cuentat_mov_id' => 'vale_log.cuenta_t_mov_id',
            'acta_quantity' => '(vale_log.quantity_recibido * -1)',
            'rechazado' => 'vale_log.rechazado',
            'categoria_id' => 'vale_log.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'vale_log.tipo',
            'paid_when' => 'vale_log.paid_when',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => 'vale_log.conversion_tipo_cambio',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'vale_log.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'vale_log.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'compra'=>array(
            'tabla'=>'compra',
            'from'=> "(compra left join cliente on((compra.cliente_id = cliente.cliente_id)) left join categoria on((compra.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'compra.tienda_id',
            'moneda_id'=>'compra.moneda_id',
            'numero'=>'compra.numero',
            'cliente_id' => 'compra.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((compra.new_date is null),compra.original_date,compra.new_date)',
            'alta_db'=>'compra.alta_db',
            'alta_por' => 'compra.alta_por',
            'quantity' => 'compra.quantity',
            'total_payments'=>'compra.total_payments',
            'debe' => 'if(((compra.quantity - compra.total_payments) < 0),0,(compra.quantity - compra.total_payments))',
            'saldo' => 'if((compra.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'compra.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'compra.origen_cuentat_id',
            'numero_sistema' => 'compra.numero_sistema',
            'remarks'=>'compra.remarks',
            'autorizado' => 'compra.autorizado',
            'autorizado_por' => 'compra.autorizado_por',
            'autorizado_el' => 'compra.autorizado_el',
            'borrado' => 'compra.borrado',
            'borrado_por' => 'compra.borrado_por',
            'borrado_el' => 'compra.borrado_el',
            'doc_id' => 'compra.compra_id',
            'doc_origen_id' => 'compra.compra_id',
            'origen' => "'COMPRA'",
            'paid' => 'compra.paid',
            'delivered_directo' => 'compra.delivered_directo',
            'ultimo_movimiento' => 'compra.ultimo_movimiento',
            'desautorizado_el' => 'compra.desautorizado_el',
            'numero_contenedor' => 'compra.numero_contenedor',
            'lugar_de_entrada' => 'compra.lugar_de_entrada',
            'tipo_de_tela' => 'compra.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'compra.moneda_id',
            'remarks_wot' => 'compra.remarks_wot',
            'cuentat_mov_id' => 'compra.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'compra.rechazado',
            'categoria_id' => 'compra.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'compra.tipo',
            'paid_when' => 'compra.paid_when',
            'ultimo_pago' => 'compra.ultimo_pago',
            'tipo_cambio' => '0.00',
            'puede_borrar' => 'compra.puede_borrar',
            'bloqueado_el' => 'compra.bloqueado_el',
            'set_origen_cuentat' => 'compra.set_origen_cuentat',
            'puede_origen_cuentat' => 'compra.puede_origen_cuentat',
            'ultimo_cambio' => 'compra.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'compra_log'=>array(
            'tabla'=>'compra_log',
            'from'=> "(compra_log LEFT JOIN cliente ON((compra_log.cliente_id = cliente.cliente_id)) left join categoria on((compra_log.categoria_id = categoria.categoria_id)))",
            'where' => "",
            'tienda_id'=>'compra_log.tienda_id',
            'moneda_id'=>'compra_log.moneda_id',
            'numero'=>'compra_log.numero',
            'cliente_id' => 'compra_log.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((compra_log.new_date is null),compra_log.original_date,compra_log.new_date)',
            'alta_db'=>'compra_log.alta_db',
            'alta_por' => 'compra_log.alta_por',
            'quantity' => 'compra_log.quantity',
            'total_payments'=>'compra_log.total_payments',
            'debe' => 'if(((compra_log.quantity - compra_log.total_payments) < 0),0,(compra_log.quantity - compra_log.total_payments))',
            'saldo' => 'if((compra_log.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'compra_log.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'compra_log.origen_cuentat_id',
            'numero_sistema' => 'compra_log.numero_sistema',
            'remarks'=>'compra_log.remarks',
            'autorizado' => 'compra_log.autorizado',
            'autorizado_por' => 'compra_log.autorizado_por',
            'autorizado_el' => 'compra_log.autorizado_el',
            'borrado' => 'compra_log.borrado',
            'borrado_por' => 'compra_log.borrado_por',
            'borrado_el' => 'compra_log.borrado_el',
            'doc_id' => 'compra_log.compra_id',
            'doc_origen_id' => 'compra_log.compra_id',
            'origen' => "'COMPRA'",
            'paid' => 'compra_log.paid',
            'delivered_directo' => 'compra_log.delivered_directo',
            'ultimo_movimiento' => 'compra_log.ultimo_movimiento',
            'desautorizado_el' => 'compra_log.desautorizado_el',
            'numero_contenedor' => 'compra_log.numero_contenedor',
            'lugar_de_entrada' => 'compra_log.lugar_de_entrada',
            'tipo_de_tela' => 'compra_log.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'compra_log.moneda_id',
            'remarks_wot' => 'compra_log.remarks_wot',
            'cuentat_mov_id' => 'compra_log.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'compra_log.rechazado',
            'categoria_id' => 'compra_log.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'compra_log.tipo',
            'paid_when' => 'compra_log.paid_when',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'compra_log.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'compra_log.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'cheque_pago_log'=>array(
            'tabla'=>'cheque_pago_log',
            'from'=> "((cheque_pago_log cp LEFT JOIN cheque ch ON((ch.cheque_id = cp.cheque_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.numero',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'Si'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'cp.fecha_borrado',
            'doc_id' => 'cp.cheque_pago_log_id',
            'doc_origen_id' => 'ch.cheque_id',
            'origen' => "if((cp.banco_cuenta_id > 0),'CHEQUE LINK',if((cp.metodo_pago_id = 14), 'CHEQUE VALE', 'CHEQUE CASH'))",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'LINK BORRADO','A CUENTA BORRADO')",
            'desautorizado_el' => 'cp.desautorizado_el',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => '(cp.quantity_total * -1)',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "ch.tipo",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'pagare_pago_log'=>array(
            'tabla'=>'pagare_pago_log',
            'from'=> "((pagare_pago_log cp LEFT JOIN pagare ch ON((ch.pagare_id = cp.pagare_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.numero',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'Si'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'cp.fecha_borrado',
            'doc_id' => 'cp.pagare_pago_log_id',
            'doc_origen_id' => 'ch.pagare_id',
            'origen' => "if((cp.banco_cuenta_id > 0),'PAGARE LINK',if((cp.metodo_pago_id = 14), 'PAGARE VALE', 'PAGARE CASH'))",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'LINK BORRADO','A CUENTA BORRADO')",
            'desautorizado_el' => 'cp.desautorizado_el',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => '(cp.quantity_total * -1)',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "''",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'vale_pago_log'=>array(
            'tabla'=>'vale_pago_log',
            'from'=> "((vale_pago_log cp LEFT JOIN vale ch ON((ch.vale_id = cp.vale_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.vale_number',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'Si'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'cp.fecha_borrado',
            'doc_id' => 'cp.vale_pago_log_id',
            'doc_origen_id' => 'ch.vale_id',
            'origen' => "if(cp.banco_cuenta_id > 0,'VALE PAGO LINK', 'VALE PAGO CASH')",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'LINK BORRADO','A CUENTA BORRADO')",
            'desautorizado_el' => 'NULL',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => '(cp.quantity_total * -1)',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "''",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'compra_pago_log'=>array(
            'tabla'=>'compra_pago_log',
            'from'=> "((compra_pago_log cp LEFT JOIN compra ch ON((ch.compra_id = cp.compra_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.numero',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'Si'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'cp.fecha_borrado',
            'doc_id' => 'cp.compra_pago_log_id',
            'doc_origen_id' => 'ch.compra_id',
            'origen' => "'COMPRA CASH'",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'LINK BORRADO','A CUENTA BORRADO')",
            'desautorizado_el' => 'cp.desautorizado_el',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => 'cp.quantity_total',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "ch.tipo",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'cuentat_a_banco'=>array(
            'tabla'=>'cuentat_a_banco',
            'from'=> " cuentat_a_banco ",
            'where' => " ((cuentat_a_banco.activo = 'No') and (cuentat_a_banco.factura_directa = 'NO'))",
            'tienda_id'=>'cuentat_a_banco.tienda_id',
            'moneda_id'=>'cuentat_a_banco.moneda_id',
            'numero'=>'cuentat_a_banco.numero_referencia',
            'cliente_id' => "''",
            'cliente' => 'cuentat_a_banco.cliente',
            'fecha' => 'cuentat_a_banco.fecha',
            'alta_db'=>'cuentat_a_banco.ultimo_cambio',
            'alta_por' => 'cuentat_a_banco.ultimo_cambio_por',
            'quantity' => 'cuentat_a_banco.egreso',
            'total_payments'=> '0',
            'debe' => '0',
            'saldo' => '0',
            'cuentaT_deliveredto_id'=> 'NULL',
            'origen_cuentat_id' => "if((cuentat_a_banco.afecta_cuentat = 'NO'),NULL,cuentat_a_banco.cuentaT_id)",
            'numero_sistema' => 'cuentat_a_banco.numero_referencia',
            'remarks'=>'cuentat_a_banco.remarks',
            'autorizado' => 'cuentat_a_banco.autorizado',
            'autorizado_por' => 'cuentat_a_banco.autorizado_por',
            'autorizado_el' => 'cuentat_a_banco.autorizado_el',
            'borrado' => "'Si'",
            'borrado_por' => 'cuentat_a_banco.alta_por',
            'borrado_el' => 'cuentat_a_banco.alta_db',
            'doc_id' => 'cuentat_a_banco.cuentat_a_banco_mov_id',
            'doc_origen_id' => 'cuentat_a_banco.cuentat_a_banco_mov_id',
            'origen' => "'CUENTA T'",
            'paid' => '0',
            'delivered_directo' => '0',
            'ultimo_movimiento' => "IF(cuentat_a_banco.deposit_total > cuentat_a_banco.egreso AND cuentat_a_banco.ide_amount = 0 AND cuentat_a_banco.ide_percent = 0 AND cuentat_a_banco.tarjeta_amount = 0 AND cuentat_a_banco.tarjeta_percent = 0, 'LINK PARCIAL BORRADO', 'LINK BORRADO')",
            'desautorizado_el' => 'cuentat_a_banco.desautorizado_el',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cuentat_a_banco.banco_cuenta_id',
            'deposit_fecha' => 'cuentat_a_banco.deposit_fecha',
            'deposit_total' => 'cuentat_a_banco.deposit_total',
            'doc_moneda' => 'cuentat_a_banco.moneda_id',
            'remarks_wot' => 'cuentat_a_banco.remarks',
            'cuentat_mov_id' => 'cuentat_a_banco.cuentaT_mov_id',
            'acta_quantity' => "cuentat_a_banco.egreso",
            'rechazado' => 'cuentat_a_banco.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "''",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => '0.00',
            'puede_borrar' => "cuentat_a_banco.puede_borrar",
            'bloqueado_el' => 'cuentat_a_banco.ultimo_cambio',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cuentat_a_banco.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'cheque_pago'=>array(
            'tabla'=>'cheque_pago',
            'from'=> "((cheque_pago cp LEFT JOIN cheque ch ON((ch.cheque_id = cp.cheque_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.numero',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'No'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'NULL',
            'doc_id' => 'cp.cheque_pago_id',
            'doc_origen_id' => 'ch.cheque_id',
            'origen' => "if((cp.banco_cuenta_id > 0),'CHEQUE LINK',if((cp.metodo_pago_id = 14), 'CHEQUE VALE', 'CHEQUE CASH'))",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'A CUENTA T.C PACTADO','A CUENTA T.C PACTADO')",
            'desautorizado_el' => 'NULL',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => 'cp.quantity_total',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "ch.tipo",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => 'ch.conversion_tipo_cambio',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),
        'pagare_pago'=>array(
            'tabla'=>'pagare_pago',
            'from'=> "((pagare_pago cp LEFT JOIN pagare ch ON((ch.pagare_id = cp.pagare_id))) LEFT JOIN cliente cli ON((ch.cliente_id = cli.cliente_id)))",
            'where' => "",
            'tienda_id'=>'ch.tienda_id',
            'moneda_id'=>'cp.moneda_id',
            'numero'=>'ch.numero',
            'cliente_id' => 'ch.cliente_id',
            'cliente' => 'cli.nombre',
            'fecha' => 'cp.fecha',
            'alta_db'=>'cp.alta_db',
            'alta_por' => 'cp.alta_por',
            'quantity' => 'ch.quantity',
            'total_payments'=>'ch.total_payments',
            'debe' => 'if(((ch.quantity - ch.total_payments) < 0),0,(ch.quantity - ch.total_payments))',
            'saldo' => 'if((ch.moneda_id = 1),cli.saldo_pesos,cli.saldo_usd)',
            'cuentaT_deliveredto_id'=>'NULL',
            'origen_cuentat_id' => 'cp.cuentaT_id',
            'numero_sistema' => 'cp.numero_referencia',
            'remarks'=>'cp.comentario',
            'autorizado' => 'cp.autorizado',
            'autorizado_por' => 'cp.autorizado_por',
            'autorizado_el' => 'cp.autorizado_el',
            'borrado' => "'No'",
            'borrado_por' => 'cp.alta_por',
            'borrado_el' => 'NULL',
            'doc_id' => 'cp.pagare_pago_id',
            'doc_origen_id' => 'ch.pagare_id',
            'origen' => "if((cp.banco_cuenta_id > 0),'PAGARE LINK',if((cp.metodo_pago_id = 14), 'PAGARE VALE', 'PAGARE CASH'))",
            'paid' => 'ch.paid',
            'delivered_directo' => 'ch.delivered_directo',
            'ultimo_movimiento' => "if((cp.banco_cuenta_id > 0),'A CUENTA T.C PACTADO','A CUENTA T.C PACTADO')",
            'desautorizado_el' => 'NULL',
            'numero_contenedor' => "''",
            'lugar_de_entrada' => "''",
            'tipo_de_tela' => "''",
            'banco_cuenta_id' => 'cp.banco_cuenta_id',
            'deposit_fecha' => 'cp.deposit_fecha',
            'deposit_total' => 'cp.deposit_total',
            'doc_moneda' => 'ch.moneda_id',
            'remarks_wot' => 'ch.remarks_wot',
            'cuentat_mov_id' => 'cp.cuenta_t_mov_id',
            'acta_quantity' => 'cp.quantity_total',
            'rechazado' => 'cp.rechazado',
            'categoria_id' => '0',
            'categoria' => "'CATEGORIA'",
            'tipo' => "''",
            'paid_when' => 'NULL',
            'ultimo_pago' => 'NULL',
            'tipo_cambio' => 'ch.conversion_tipo_cambio',
            'puede_borrar' => "'No'",
            'bloqueado_el' => 'cp.alta_db',
            'set_origen_cuentat' => "''",
            'puede_origen_cuentat' => "'No'",
            'ultimo_cambio' => 'cp.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => "'No'",
            'conversion_ultimo_cambio' => "''"
        ),

        'docto_tc_pactado'=>array(
            'tabla'=>'docto_tc_pactado',
            'from'=> "(docto_tc_pactado d_tc LEFT JOIN pagare ON pagare.pagare_id = d_tc.doc_origen_id LEFT JOIN cliente ON pagare.cliente_id = cliente.cliente_id LEFT JOIN categoria ON pagare.categoria_id = categoria.categoria_id)",
            'where' => "",
            'tienda_id'=>'pagare.tienda_id',
            'moneda_id'=>'pagare.moneda_id',
            'numero'=>'pagare.numero',
            'cliente_id' => 'pagare.cliente_id',
            'cliente' => 'cliente.nombre',
            'fecha' => 'if((pagare.new_date is null),pagare.original_date,pagare.new_date)',
            'alta_db'=>'pagare.alta_db',
            'alta_por' => 'pagare.alta_por',
            'quantity' => 'pagare.quantity',
            'total_payments'=>'pagare.total_payments',
            'debe' => 'if(((pagare.quantity - pagare.total_payments) < 0),0,(pagare.quantity - pagare.total_payments))',
            'saldo' => 'if((pagare.moneda_id = 1),cliente.saldo_pesos,cliente.saldo_usd)',
            'cuentaT_deliveredto_id'=>'pagare.cuentaT_deliveredto_id',
            'origen_cuentat_id' => 'pagare.origen_cuentat_id',
            'numero_sistema' => 'pagare.numero_sistema',
            'remarks'=>'pagare.remarks',
            'autorizado' => 'd_tc.autorizado',
            'autorizado_por' => 'd_tc.autorizado_por',
            'autorizado_el' => 'd_tc.autorizado_el',
            'borrado' => 'pagare.borrado',
            'borrado_por' => 'pagare.borrado_por',
            'borrado_el' => 'pagare.borrado_el',
            'doc_id' => 'd_tc.docto_tc_pactado_id',
            'doc_origen_id' => 'pagare.pagare_id',
            'origen' => "'PAGARE TC'",
            'paid' => 'pagare.paid',
            'delivered_directo' => 'pagare.delivered_directo',
            'ultimo_movimiento' => 'd_tc.ultimo_movimiento',
            'desautorizado_el' => 'd_tc.desautorizado_el',
            'numero_contenedor' => 'pagare.numero_contenedor',
            'lugar_de_entrada' => 'pagare.lugar_de_entrada',
            'tipo_de_tela' => 'pagare.tipo_de_tela',
            'banco_cuenta_id' => '0',
            'deposit_fecha' => 'NULL',
            'deposit_total' => '0',
            'doc_moneda' => 'pagare.moneda_id',
            'remarks_wot' => 'pagare.remarks_wot',
            'cuentat_mov_id' => 'pagare.cuentat_mov_id',
            'acta_quantity' => '0',
            'rechazado' => 'd_tc.rechazado',
            'categoria_id' => 'pagare.categoria_id',
            'categoria' => 'categoria.categoria',
            'tipo' => 'pagare.tipo',
            'paid_when' => 'pagare.paid_when',
            'ultimo_pago' => 'pagare.ultimo_pago',
            'tipo_cambio' => 'd_tc.tc_pactado',
            'puede_borrar' => 'pagare.puede_borrar',
            'bloqueado_el' => 'pagare.bloqueado_el',
            'set_origen_cuentat' => 'pagare.set_origen_cuentat',
            'puede_origen_cuentat' => 'pagare.puede_origen_cuentat',
            'ultimo_cambio' => 'pagare.ultimo_cambio',
            'puede_cambiar_tipo_cambio' => 'pagare.puede_cambiar_tipo_cambio',
            'conversion_ultimo_cambio' => 'pagare.conversion_ultimo_cambio'
        ),

    );
}

function obten_sql_norm_doctos($origen='', $id=''){
    if(empty($origen))
        return "";

    $normalize = obten_array_norm_doctos();

    $sql1="SELECT ";

    foreach($normalize[$origen] as $col => $value) {
        if($col=='tabla' || $col=='from' || $col=='where') continue;

        $sql1 .= $value . " AS $col, ";
    }

    $sql1 = substr($sql1, 0,-2);

    if(!is_array($id))
        $id_in = "=".strit($id);
    else {
        $id_in = " IN ('" . implode("','", $id) . "') ";
    }

    return $sql1 .= " FROM ".$normalize[$origen]['from']." WHERE ".$normalize[$origen]['doc_id'] . $id_in . (empty($normalize[$origen]['where']) ? "" : " AND " . $normalize[$origen]['where']);

}

function delete_from_links_al_banco_live($id=''){
    if(empty($id))
        return ;

    $sql_delete = "DELETE FROM links_al_banco_live WHERE link_id = ".strit($id);

    return $sql_delete;
}

/**
 * @param string $cuentat_a_banco_mov_id
 * @param string $cheque_pago_id
 * @param string $pagare_pago_id
 * @param string $vale_pago_id
 * @param string $vale_id
 * @param string $cuentat_a_banco_tc_mov_id
 * @param string $banco_cuenta_trans_id
 * @param string $cheque_pago_log_id
 * @param string $pagare_pago_log_id
 * @param string $vale_pago_log_id
 * @param string $inversion_reembolso
 * @param string $origen
 * @return string $sql con un insert a links_al_banco_live
 */
function insert_update_links_al_banco_live($cuentat_a_banco_mov_id='', $cheque_pago_id= '', $pagare_pago_id = '', $vale_pago_id = '', $vale_id = '', $cuentat_a_banco_tc_mov_id = '', $banco_cuenta_trans_id = '', $cheque_pago_log_id = '', $pagare_pago_log_id = '', $vale_pago_log_id = '', $inversion_reembolso_id = '', $vale_log_id = '', $origen=''){

    $sql_doc = "(SELECT
      a.cuentat_a_banco_mov_id AS link_id,
      a.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
      a.origen AS origen,
      a.cuentat_a_banco_mov_id AS doc_id,
      a.cuentaT_id AS cuentaT_id,
      a.tienda_id AS tienda_id,
      a.fecha AS fecha,
      a.banco_cuenta_id AS banco_cuenta_id,
      a.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
      a.deposit_total AS deposit_total,
      a.quantity_total AS quantity_total,
      a.ide_amount AS ide_amount,
      a.ide_percent AS ide_percent,
      a.egreso AS egreso,
      a.monto AS monto,
      a.tipo_cash_nota AS tipo_cash_nota,
      a.cash_nota_num AS cash_nota_num,
      a.deposit_fecha AS deposit_fecha,
      a.cliente AS cliente,
      a.factura AS factura,
      a.factura_numero AS factura_numero,
      a.iva_incluido AS iva_incluido,
      a.ivacobradox100 AS ivacobradox100,
      IF((a.iva_incluido = 'SI'),0.00,a.ivacobradototal) AS ivarealmentecobrado,
      IF((a.iva_incluido = 'NO'),0.00,a.ivacobradototal) AS ivacobradototal,
      a.alta_db AS alta_db,
      a.alta_por AS alta_por,
      a.numero_referencia AS numero_referencia,
      a.cash_num_cobro_iva AS cash_num_cobro_iva,
      a.empresa_id AS empresa_id,
      a.remarks AS remarks,
      a.puede_borrar AS puede_borrar,
      a.activo AS activo,
      a.afecta_cuentat AS afecta_cuentat,
      a.comments AS comments,
      a.autorizado AS autorizado,
      a.rechazado AS rechazado,
      a.revisado AS revisado,
      a.autorizado_el AS autorizado_el,
      a.autorizado_por AS autorizado_por,
      a.MetodoPago AS MetodoPago,
      a.FormaPago AS FormaPago,
      a.UsoCFDI AS UsoCFDI,
      a.iva_revisado AS iva_revisado,
      a.iva_revisado_por AS iva_revisado_por,
      a.iva_revisado_el AS iva_revisado_el,
      a.ultimo_cambio AS ultimo_cambio,
      a.ultimo_cambio_por AS ultimo_cambio_por,
      a.cliente_rfc AS cliente_rfc,
      a.referencia AS referencia,
      a.origen_mov_id AS origen_mov_id,
      a.factura_directa AS factura_directa,
      a.moneda_id AS moneda_id,
      a.fecha_capturado AS fecha_capturado,
      a.json_file_attachments AS json_file_attachments,
      a.cancelacion_revisada AS cancelacion_revisada,
      a.cancelacion_revisada_por AS cancelacion_revisada_por,
      a.cancelacion_revisada_el AS cancelacion_revisada_el,
      a.cancelacion_el AS cancelacion_el
  FROM cuentat_a_banco a
  WHERE a.cuentat_a_banco_mov_id <> '' AND a.cuentat_a_banco_mov_id = '$cuentat_a_banco_mov_id')
 UNION ALL
 (SELECT
      b.cheque_pago_id AS link_id,
      b.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
      b.origen AS origen,
      b.cheque_id AS doc_id,
      b.cuentaT_id AS cuentaT_id,
      b.tienda_id AS tienda_id,
      b.fecha AS fecha,
      b.banco_cuenta_id AS banco_cuenta_id,
      b.metodo_pago_id AS cuentaT_tipo_mov_id,
      b.deposit_total AS deposit_total,
      b.quantity_total AS quantity_total,
      b.ide_amount AS ide_amount,
      b.ide_percent AS ide_percent,
      b.quantity_ctat AS egreso,
      0.00 AS monto,
      b.tipo_cash_nota AS tipo_cash_nota,
      b.cash_nota_num AS cash_nota_num,
      b.deposit_fecha AS deposit_fecha,
      b.cliente AS cliente,
      b.factura AS factura,
      b.factura_numero AS factura_numero,
      b.iva_incluido AS iva_incluido,
      b.ivacobradox100 AS ivacobradox100,
      IF((b.iva_incluido = 'SI'),0.00,b.ivacobradototal) AS ivarealmentecobrado,
      IF((b.iva_incluido = 'NO'),0.00,b.ivacobradototal) AS ivacobradototal,
      b.alta_db AS alta_db,
      b.alta_por AS alta_por,
      b.numero_referencia AS numero_referencia,
      b.cash_num_cobro_iva AS cash_num_cobro_iva,
      b.empresa_id AS empresa_id,
      b.comentario AS remarks,
      b.puede_borrar AS puede_borrar,
      b.activo AS activo,
      b.afecta_cuentat AS afecta_cuentat,
      b.comments AS comments,
      b.autorizado AS autorizado,
      b.rechazado AS rechazado,
      b.revisado AS revisado,
      b.autorizado_el AS autorizado_el,
      b.autorizado_por AS autorizado_por,
      b.MetodoPago AS MetodoPago,
      b.FormaPago AS FormaPago,
      b.UsoCFDI AS UsoCFDI,
      b.iva_revisado AS iva_revisado,
      b.iva_revisado_por AS iva_revisado_por,
      b.iva_revisado_el AS iva_revisado_el,
      b.ultimo_cambio AS ultimo_cambio,
      b.ultimo_cambio_por AS ultimo_cambio_por,
      b.cliente_rfc AS cliente_rfc,
      b.referencia AS referencia,
      b.cuenta_t_mov_id AS origen_mov_id,
      'NO' AS factura_directa,
      b.moneda_id AS moneda_id,
      b.fecha_capturado AS fecha_capturado,
      b.json_file_attachments AS json_file_attachments,
      b.cancelacion_revisada AS cancelacion_revisada,
      b.cancelacion_revisada_por AS cancelacion_revisada_por,
      b.cancelacion_revisada_el AS  cancelacion_revisada_el,
      b.cancelacion_el AS cancelacion_el
  FROM cheque_pago b
  WHERE b.banco_cuenta_id > 0 AND b.banco_cuenta_mov_link_id <> '' AND b.cheque_pago_id <> '' AND b.cheque_pago_id = '$cheque_pago_id')
 UNION ALL
 (SELECT
      c.pagare_pago_id AS link_id,
      c.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
      c.origen AS origen,
      c.pagare_id AS doc_id,
      c.cuentaT_id AS cuentaT_id,
      c.tienda_id AS tienda_id,
      c.fecha AS fecha,
      c.banco_cuenta_id AS banco_cuenta_id,
      c.metodo_pago_id AS cuentaT_tipo_mov_id,
      c.deposit_total AS deposit_total,
      c.quantity_total AS quantity_total,
      c.ide_amount AS ide_amount,
      c.ide_percent AS ide_percent,
      c.quantity_ctat AS egreso,
      0.00 AS monto,
      c.tipo_cash_nota AS tipo_cash_nota,
      c.cash_nota_num AS cash_nota_num,
      c.deposit_fecha AS deposit_fecha,
      c.cliente AS cliente,
      c.factura AS factura,
      c.factura_numero AS factura_numero,
      c.iva_incluido AS iva_incluido,
      c.ivacobradox100 AS ivacobradox100,
      IF((c.iva_incluido = 'SI'),0.00,c.ivacobradototal) AS ivarealmentecobrado,
      IF((c.iva_incluido = 'NO'),0.00,c.ivacobradototal) AS ivacobradototal,
      c.alta_db AS alta_db,
      c.alta_por AS alta_por,
      c.numero_referencia AS numero_referencia,
      c.cash_num_cobro_iva AS cash_num_cobro_iva,
      c.empresa_id AS empresa_id,
      c.comentario AS remarks,
      c.puede_borrar AS puede_borrar,
      c.activo AS activo,
      c.afecta_cuentat AS afecta_cuentat,
      c.comments AS comments,
      c.autorizado AS autorizado,
      c.rechazado AS rechazado,
      c.revisado AS revisado,
      c.autorizado_el AS autorizado_el,
      c.autorizado_por AS autorizado_por,
      c.MetodoPago AS MetodoPago,
      c.FormaPago AS FormaPago,
      c.UsoCFDI AS UsoCFDI,
      c.iva_revisado AS iva_revisado,
      c.iva_revisado_por AS iva_revisado_por,
      c.iva_revisado_el AS iva_revisado_el,
      c.ultimo_cambio AS ultimo_cambio,
      c.ultimo_cambio_por AS ultimo_cambio_por,
      c.cliente_rfc AS cliente_rfc,
      c.referencia AS referencia,
      c.cuenta_t_mov_id AS origen_mov_id,
      'NO' AS factura_directa,
      c.moneda_id AS moneda_id,
      c.fecha_capturado AS fecha_capturado,
      c.json_file_attachments AS json_file_attachments,
      c.cancelacion_revisada AS cancelacion_revisada,
      c.cancelacion_revisada_por AS cancelacion_revisada_por,
      c.cancelacion_revisada_el AS cancelacion_revisada_el,
      c.cancelacion_el AS cancelacion_el
  FROM pagare_pago c
  WHERE c.banco_cuenta_id > 0 AND c.banco_cuenta_mov_link_id <> '' AND c.pagare_pago_id <> '' AND c.pagare_pago_id = '$pagare_pago_id')
 UNION ALL
 (SELECT 
      j.vale_pago_id AS link_id,
      j.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
      j.origen AS origen,
      j.vale_id AS doc_id,
      j.cuentaT_id AS cuentaT_id,
      j.tienda_id AS tienda_id,
      j.fecha AS fecha,
      j.banco_cuenta_id AS banco_cuenta_id,
      j.metodo_pago_id AS cuentaT_tipo_mov_id,
      j.deposit_total AS deposit_total,
      j.quantity_total AS quantity_total,
      j.ide_amount AS ide_amount,
      j.ide_percent AS ide_percent,
      j.quantity_ctat AS egreso,
      0.00 AS monto,
      j.tipo_cash_nota AS tipo_cash_nota,
      j.cash_nota_num AS cash_nota_num,
      j.deposit_fecha AS deposit_fecha,
      j.cliente AS cliente,
      j.factura AS factura,
      j.factura_numero AS factura_numero,
      j.iva_incluido AS iva_incluido,
      j.ivacobradox100 AS ivacobradox100,
      IF((j.iva_incluido = 'SI'),0.00,j.ivacobradototal) AS ivarealmentecobrado,
      IF((j.iva_incluido = 'NO'),0.00,j.ivacobradototal) AS ivacobradototal,
      j.alta_db AS alta_db,
      j.alta_por AS alta_por,
      j.numero_referencia AS numero_referencia,
      j.cash_num_cobro_iva AS cash_num_cobro_iva,
      j.empresa_id AS empresa_id,
      j.comentario AS remarks,
      j.puede_borrar AS puede_borrar,
      j.activo AS activo,
      j.afecta_cuentat AS afecta_cuentat,
      j.comments AS comments,
      j.autorizado AS autorizado,
      j.rechazado AS rechazado,
      j.revisado AS revisado,
      j.autorizado_el AS autorizado_el,
      j.autorizado_por AS autorizado_por,
      j.MetodoPago AS MetodoPago,
      j.FormaPago AS FormaPago,
      j.UsoCFDI AS UsoCFDI,
      j.iva_revisado AS iva_revisado,
      j.iva_revisado_por AS iva_revisado_por,
      j.iva_revisado_el AS iva_revisado_el,
      j.ultimo_cambio AS ultimo_cambio,
      j.ultimo_cambio_por AS ultimo_cambio_por,
      j.cliente_rfc AS cliente_rfc,
      j.referencia AS referencia,
      j.cuenta_t_mov_id AS origen_mov_id,
      'NO' AS factura_directa,
      j.moneda_id AS moneda_id,
      j.fecha_capturado AS fecha_capturado,
      '' AS json_file_attachments,
      j.cancelacion_revisada AS cancelacion_revisada,
      j.cancelacion_revisada_por AS cancelacion_revisada_por,
      j.cancelacion_revisada_el AS cancelacion_revisada_el,
      j.cancelacion_el AS cancelacion_el
  FROM vale_pago j
  WHERE j.banco_cuenta_id > 0 AND j.banco_cuenta_mov_link_id <> '' AND j.vale_pago_id <> '' AND j.vale_pago_id = '$vale_pago_id')
 UNION ALL
 (SELECT
      d.vale_id AS link_id,
      d.banco_cuenta_mov_link_id,
      d.origen,
      d.vale_id AS doc_id,
      d.cuentaT_id,
      d.tienda_id,
      d.fecha,
      d.banco_cuenta_id,
      d.metodo_pago_id AS cuentaT_tipo_mov_id,
      d.deposit_total AS deposit_total,
      d.quantity_total AS quantity_total,
      d.ide_amount,
      d.ide_percent,
      d.quantity_total AS egreso,
      0.00 AS monto,
      d.tipo_cash_nota,
      d.cash_nota_num,
      d.deposit_fecha,
      IF((d.deposit_cliente is null OR d.deposit_cliente=''),IF((d.cliente_id is null),d.cliente,cliente.nombre), d.deposit_cliente) AS cliente,
      d.factura,
      d.factura_numero,
      d.iva_incluido AS iva_incluido,
      d.ivacobradox100,
      IF((d.iva_incluido = 'SI'),0.00,d.ivacobradototal) AS ivarealmentecobrado,
      IF((d.iva_incluido = 'NO'),0.00,d.ivacobradototal) AS ivacobradototal,
      d.alta_db,
      d.alta_por,
      d.numero_referencia AS numero_referencia,
      d.cash_num_cobro_iva,
      d.empresa_id,
      d.remarks,
      'NO' AS puede_borrar,
      IF((d.cancelado = 1),'No','Si') AS activo,
      d.afecta_cuentat AS afecta_cuentat,
      d.comments AS comments,
      d.autorizado AS autorizado,
      d.rechazado AS rechazado,
      d.revisado AS revisado,
      d.autorizado_el AS autorizado_el,
      d.autorizado_por AS autorizado_por,
      d.MetodoPago AS MetodoPago,
      d.FormaPago AS FormaPago,
      d.UsoCFDI AS UsoCFDI,
      d.iva_revisado AS iva_revisado,
      d.iva_revisado_por AS iva_revisado_por,
      d.iva_revisado_el AS iva_revisado_el,
      d.ultimo_cambio,
      d.ultimo_cambio_por,
      d.cliente_rfc,
      d.referencia,
      d.cuenta_t_mov_id AS origen_mov_id,
      'NO' AS factura_directa,
      d.recibido_moneda_id AS moneda_id,
      d.fecha_capturado AS fecha_capturado,
      d.json_file_attachments AS json_file_attachments,
      d.cancelacion_revisada,
      d.cancelacion_revisada_por,
      d.cancelacion_revisada_el,
      d.cancelacion_el
  FROM vale d LEFT JOIN cliente ON(d.cliente_id = cliente.cliente_id)
  WHERE d.banco_cuenta_id > 0 AND d.banco_cuenta_mov_link_id <> '' AND d.vale_id <> '' AND d.vale_id = '$vale_id')
UNION ALL
 (SELECT
      l.vale_id AS link_id,
      l.banco_cuenta_mov_link_id,
      l.origen,
      l.vale_id AS doc_id,
      l.cuentaT_id,
      l.tienda_id,
      l.fecha,
      l.banco_cuenta_id,
      l.metodo_pago_id AS cuentaT_tipo_mov_id,
      l.deposit_total AS deposit_total,
      l.quantity_total AS quantity_total,
      l.ide_amount,
      l.ide_percent,
      l.quantity_total AS egreso,
      0.00 AS monto,
      l.tipo_cash_nota,
      l.cash_nota_num,
      l.deposit_fecha,
      IF((l.deposit_cliente is null OR l.deposit_cliente=''),IF((l.cliente_id is null),l.cliente,cliente.nombre), l.deposit_cliente) AS cliente,
      l.factura,
      l.factura_numero,
      l.iva_incluido AS iva_incluido,
      l.ivacobradox100,
      IF((l.iva_incluido = 'SI'),0.00,l.ivacobradototal) AS ivarealmentecobrado,
      IF((l.iva_incluido = 'NO'),0.00,l.ivacobradototal) AS ivacobradototal,
      l.alta_db,
      l.alta_por,
      l.numero_referencia AS numero_referencia,
      l.cash_num_cobro_iva,
      l.empresa_id,
      l.remarks,
      'NO' AS puede_borrar,
      'No' AS activo,
      l.afecta_cuentat AS afecta_cuentat,
      l.comments AS comments,
      l.autorizado AS autorizado,
      l.rechazado AS rechazado,
      l.revisado AS revisado,
      l.autorizado_el AS autorizado_el,
      l.autorizado_por AS autorizado_por,
      l.MetodoPago AS MetodoPago,
      l.FormaPago AS FormaPago,
      l.UsoCFDI AS UsoCFDI,
      l.iva_revisado AS iva_revisado,
      l.iva_revisado_por AS iva_revisado_por,
      l.iva_revisado_el AS iva_revisado_el,
      l.ultimo_cambio,
      l.ultimo_cambio_por,
      l.cliente_rfc,
      l.referencia,
      l.cuenta_t_mov_id AS origen_mov_id,
      'NO' AS factura_directa,
      l.recibido_moneda_id AS moneda_id,
      l.fecha_capturado AS fecha_capturado,
      l.json_file_attachments AS json_file_attachments,
      l.cancelacion_revisada,
      l.cancelacion_revisada_por,
      l.cancelacion_revisada_el,
      l.cancelacion_el
  FROM vale_log l LEFT JOIN cliente ON(l.cliente_id = cliente.cliente_id)
  WHERE l.banco_cuenta_id > 0 AND l.vale_id <> '' AND l.vale_id = '$vale_log_id')
 UNION ALL
 (SELECT
     e.cuentat_a_banco_tc_mov_id AS link_id,
     e.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
     e.origen AS origen,
     e.cuentat_a_banco_tc_mov_id AS doc_id,
     e.cuentaT_id AS cuentaT_id,
     e.tienda_id AS tienda_id,
     e.fecha AS fecha,
     e.banco_cuenta_id AS banco_cuenta_id,
     e.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
     e.deposit_total AS quantity_total,
     e.quantity_total AS quantity_total,
     e.ide_amount AS ide_amount,
     e.ide_percent AS ide_percent,
     e.egreso AS egreso,
     e.monto AS monto,
     e.tipo_cash_nota AS tipo_cash_nota,
     e.cash_nota_num AS cash_nota_num,
     e.deposit_fecha AS deposit_fecha,
     e.cliente AS cliente,
     e.factura AS factura,
     e.factura_numero AS factura_numero,
     e.iva_incluido AS iva_incluido,
     e.ivacobradox100 AS ivacobradox100,
     IF((e.iva_incluido = 'SI'),0.00,e.ivacobradototal) AS ivarealmentecobrado,
     IF((e.iva_incluido = 'NO'),0.00,e.ivacobradototal) AS ivacobradototal,
     e.alta_db AS alta_db,
     e.alta_por AS alta_por,
     e.numero_referencia AS numero_referencia,
     e.cash_num_cobro_iva AS cash_num_cobro_iva,
     e.empresa_id AS empresa_id,
     e.remarks AS remarks,
     e.puede_borrar AS puede_borrar,
     e.activo AS activo,
     e.afecta_cuentat AS afecta_cuentat,
     e.comments AS comments,
     e.autorizado AS autorizado,
     e.rechazado AS rechazado,
     e.revisado AS revisado,
     e.autorizado_el AS autorizado_el,
     e.autorizado_por AS autorizado_por,
     e.MetodoPago AS MetodoPago,
     e.FormaPago AS FormaPago,
     e.UsoCFDI AS UsoCFDI,
     e.iva_revisado AS iva_revisado,
     e.iva_revisado_por AS iva_revisado_por,
     e.iva_revisado_el AS iva_revisado_el,
     e.ultimo_cambio AS ultimo_cambio,
     e.ultimo_cambio_por AS ultimo_cambio_por,
     e.cliente_rfc AS cliente_rfc,
     e.referencia AS referencia,
     e.origen_mov_id AS origen_mov_id,
     e.factura_directa AS factura_directa,
     e.moneda_id AS moneda_id,
     e.fecha_capturado AS fecha_capturado,
     e.json_file_attachments AS json_file_attachments,
     e.cancelacion_revisada,
     e.cancelacion_revisada_por,
     e.cancelacion_revisada_el,
     e.cancelacion_el
 FROM cuentat_a_banco_tc e
 WHERE e.cuentat_a_banco_tc_mov_id <> '' AND e.cuentat_a_banco_tc_mov_id = '$cuentat_a_banco_tc_mov_id')
 UNION ALL
 (SELECT
    f.banco_cuenta_trans_id AS link_id,
    f.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
    f.origen AS origen,
    f.banco_cuenta_trans_id AS doc_id,
    f.cuentaT_id AS cuentaT_id,
    f.tienda_id AS tienda_id,
    f.fecha AS fecha,
    f.banco_cuenta_id AS banco_cuenta_id,
    f.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
    f.deposit_total AS quantity_total,
    f.quantity_total AS quantity_total,
    f.ide_amount AS ide_amount,
    f.ide_percent AS ide_percent,
    f.egreso AS egreso,
    f.monto AS monto,
    f.tipo_cash_nota AS tipo_cash_nota,
    f.cash_nota_num AS cash_nota_num,
    f.deposit_fecha AS deposit_fecha,
    f.cliente AS cliente,
    f.factura AS factura,
    f.factura_numero AS factura_numero,
    f.iva_incluido AS iva_incluido,
    f.ivacobradox100 AS ivacobradox100,
    IF((f.iva_incluido = 'SI'),0.00,f.ivacobradototal) AS ivarealmentecobrado,
    IF((f.iva_incluido = 'NO'),0.00,f.ivacobradototal) AS ivacobradototal,
    f.alta_db AS alta_db,
    f.alta_por AS alta_por,
    f.numero_referencia AS numero_referencia,
    f.cash_num_cobro_iva AS cash_num_cobro_iva,
    f.empresa_id AS empresa_id,
    f.remarks AS remarks,
    f.puede_borrar AS puede_borrar,
    f.activo AS activo,
    f.afecta_cuentat AS afecta_cuentat,
    f.comments AS comments,
    f.autorizado AS autorizado,
    f.rechazado AS rechazado,
    f.revisado AS revisado,
    f.autorizado_el AS autorizado_el,
    f.autorizado_por AS autorizado_por,
    f.MetodoPago AS MetodoPago,
    f.FormaPago AS FormaPago,
    f.UsoCFDI AS UsoCFDI,
    f.iva_revisado AS iva_revisado,
    f.iva_revisado_por AS iva_revisado_por,
    f.iva_revisado_el AS iva_revisado_el,
    f.ultimo_cambio AS ultimo_cambio,
    f.ultimo_cambio_por AS ultimo_cambio_por,
    f.cliente_rfc AS cliente_rfc,
    f.referencia AS referencia,
    f.origen_mov_id AS origen_mov_id,
    f.factura_directa AS factura_directa,
    f.moneda_id AS moneda_id,
    f.fecha_capturado AS fecha_capturado,
    f.json_file_attachments AS json_file_attachments,
    f.cancelacion_revisada,
    f.cancelacion_revisada_por,
    f.cancelacion_revisada_el,
    f.cancelacion_el
  FROM banco_cuenta_trans f
  WHERE f.banco_cuenta_trans_id <> '' AND f.banco_cuenta_trans_id = '$banco_cuenta_trans_id')
 UNION ALL
 (SELECT
    g.cheque_pago_log_id AS link_id,
    g.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
    g.origen AS origen,
    g.cheque_id AS doc_id,
    g.cuentaT_id AS cuentaT_id,
    g.tienda_id AS tienda_id,
    g.fecha AS fecha,
    g.banco_cuenta_id AS banco_cuenta_id,
    g.metodo_pago_id AS cuentaT_tipo_mov_id,
    g.deposit_total AS deposit_total,
    g.quantity_total AS quantity_total,
    g.ide_amount AS ide_amount,
    g.ide_percent AS ide_percent,
    g.quantity_total AS egreso,
    0.00 AS monto,
    g.tipo_cash_nota AS tipo_cash_nota,
    g.cash_nota_num AS cash_nota_num,
    g.deposit_fecha AS deposit_fecha,
    g.cliente AS cliente,
    g.factura AS factura,
    g.factura_numero AS factura_numero,
    'NO' AS iva_incluido,
    g.ivacobradox100 AS ivacobradox100,
    g.ivacobradototal AS ivarealmentecobrado,
    g.ivacobradototal AS ivacobradototal,
    g.alta_db AS alta_db,
    g.alta_por AS alta_por,
    g.numero_referencia AS numero_referencia,
    null AS cash_num_cobro_iva,
    g.empresa_id AS empresa_id,
    g.comentario AS remarks,
    g.puede_borrar AS puede_borrar,
    g.activo AS activo,
    'NO' AS afecta_cuentat,
    '' AS comments,
    g.autorizado AS autorizado,
    g.rechazado AS rechazado,
    g.revisado AS revisado,
    g.autorizado_el AS autorizado_el,
    g.autorizado_por AS autorizado_por,
    g.MetodoPago AS MetodoPago,
    g.FormaPago AS FormaPago,
    g.UsoCFDI AS UsoCFDI,
    g.iva_revisado AS iva_revisado,
    g.iva_revisado_por AS iva_revisado_por,
    g.iva_revisado_el AS iva_revisado_el,
    g.ultimo_cambio AS ultimo_cambio,
    g.ultimo_cambio_por AS ultimo_cambio_por,
    '' AS cliente_rfc,
    g.referencia AS referencia,
    '' AS origen_mov_id,
    'NO' AS factura_directa,
    g.moneda_id AS moneda_id,
    g.alta_db AS fecha_capturado,
    g.json_file_attachments AS json_file_attachments,
    g.cancelacion_revisada,
    g.cancelacion_revisada_por,
    g.cancelacion_revisada_el,
    g.cancelacion_el
  FROM cheque_pago_log g
  WHERE g.banco_cuenta_id > 0 AND g.cheque_pago_log_id <> '' AND g.cheque_pago_log_id = '$cheque_pago_log_id')
 UNION ALL
 (SELECT
    h.pagare_pago_log_id AS link_id,
    h.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
    h.origen AS origen,
    h.pagare_id AS doc_id,
    h.cuentaT_id AS cuentaT_id,
    h.tienda_id AS tienda_id,
    h.fecha AS fecha,
    h.banco_cuenta_id AS banco_cuenta_id,
    h.metodo_pago_id AS cuentaT_tipo_mov_id,
    h.deposit_total AS deposit_total,
    h.quantity_total AS quantity_total,
    h.ide_amount AS ide_amount,
    h.ide_percent AS ide_percent,
    h.quantity_total AS egreso,
    0.00 AS monto,
    h.tipo_cash_nota AS tipo_cash_nota,
    h.cash_nota_num AS cash_nota_num,
    h.deposit_fecha AS deposit_fecha,
    h.cliente AS cliente,
    h.factura AS factura,
    h.factura_numero AS factura_numero,
    'NO' AS iva_incluido,
    h.ivacobradox100 AS ivacobradox100,
    ivacobradototal AS ivarealmentecobrado,
    ivacobradototal AS ivacobradototal,
    h.alta_db AS alta_db,
    h.alta_por AS alta_por,
    h.numero_referencia AS numero_referencia,
    null AS cash_num_cobro_iva,
    h.empresa_id AS empresa_id,
    h.comentario AS remarks,
    h.puede_borrar AS puede_borrar,
    h.activo AS activo,
    'NO' AS afecta_cuentat,
    '' AS comments,
    h.autorizado AS autorizado,
    h.rechazado AS rechazado,
    h.revisado AS revisado,
    h.autorizado_el AS autorizado_el,
    h.autorizado_por AS autorizado_por,
    h.MetodoPago AS MetodoPago,
    h.FormaPago AS FormaPago,
    h.UsoCFDI AS UsoCFDI,
    h.iva_revisado AS iva_revisado,
    h.iva_revisado_por AS iva_revisado_por,
    h.iva_revisado_el AS iva_revisado_el,
    h.ultimo_cambio AS ultimo_cambio,
    h.ultimo_cambio_por AS ultimo_cambio_por,
    '' AS cliente_rfc,
    h.referencia AS referencia,
    '' AS origen_mov_id,
    'NO' AS factura_directa,
    h.moneda_id AS moneda_id,
    h.alta_db AS fecha_capturado,
    h.json_file_attachments AS json_file_attachments,
    h.cancelacion_revisada,
    h.cancelacion_revisada_por,
    h.cancelacion_revisada_el,
    h.cancelacion_el
  FROM pagare_pago_log h
  WHERE h.banco_cuenta_id > 0 AND h.pagare_pago_log_id <> '' AND h.pagare_pago_log_id = '$pagare_pago_log_id')
 UNION ALL
 (SELECT /*VALE_PAGO_LOG*/
    k.vale_pago_log_id AS link_id,
    k.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
    k.origen AS origen,
    k.vale_id AS doc_id,
    k.cuentaT_id AS cuentaT_id,
    k.tienda_id AS tienda_id,
    k.fecha AS fecha,
    k.banco_cuenta_id AS banco_cuenta_id,
    k.metodo_pago_id AS cuentaT_tipo_mov_id,
    k.deposit_total AS deposit_total,
    k.quantity_total AS quantity_total,
    k.ide_amount AS ide_amount,
    k.ide_percent AS ide_percent,
    k.quantity_total AS egreso,
    0.00 AS monto,
    k.tipo_cash_nota AS tipo_cash_nota,
    k.cash_nota_num AS cash_nota_num,
    k.deposit_fecha AS deposit_fecha,
    k.cliente AS cliente,
    k.factura AS factura,
    k.factura_numero AS factura_numero,
    'NO' AS iva_incluido,
    k.ivacobradox100 AS ivacobradox100,
    ivacobradototal AS ivarealmentecobrado,
    ivacobradototal AS ivacobradototal,
    k.alta_db AS alta_db,
    k.alta_por AS alta_por,
    k.numero_referencia AS numero_referencia,
    '' AS cash_num_cobro_iva,
    k.empresa_id AS empresa_id,
    k.comentario AS remarks,
    k.puede_borrar AS puede_borrar,
    k.activo AS activo,
    'NO' AS afecta_cuentat,
    '' AS comments,
    k.autorizado AS autorizado,
    k.rechazado AS rechazado,
    k.revisado AS revisado,
    k.autorizado_el AS autorizado_el,
    k.autorizado_por AS autorizado_por,
    k.MetodoPago AS MetodoPago,
    k.FormaPago AS FormaPago,
    k.UsoCFDI AS UsoCFDI,
    k.iva_revisado AS iva_revisado,
    k.iva_revisado_por AS iva_revisado_por,
    k.iva_revisado_el AS iva_revisado_el,
    k.ultimo_cambio AS ultimo_cambio,
    k.ultimo_cambio_por AS ultimo_cambio_por,
    '' AS cliente_rfc,
    k.referencia AS referencia,
    '' AS origen_mov_id,
    'NO' AS factura_directa,
    k.moneda_id AS moneda_id,
    k.alta_db AS fecha_capturado,
    '' AS json_file_attachments,
    k.cancelacion_revisada,
    k.cancelacion_revisada_por,
    k.cancelacion_revisada_el,
    k.cancelacion_el
  FROM vale_pago_log k
  WHERE k.banco_cuenta_id > 0 AND k.vale_pago_log_id <> '' AND k.vale_pago_log_id = '$vale_pago_log_id')
 UNION ALL
 (SELECT
    i.inversion_reembolso_id AS link_id,
    i.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
    i.origen AS origen,
    i.inversion_id AS doc_id,
    0 AS cuentaT_id,
    null AS tienda_id,
    i.fecha AS fecha,
    i.banco_cuenta_id AS banco_cuenta_id,
    '22' AS cuentaT_tipo_mov_id,
    i.monto_global_reembolso AS quantity_total,
    i.monto_global_reembolso AS quantity_total,
    0.00 AS ide_amount,
    0.00 AS ide_percent,
    i.monto_reembolsado + i.monto_interes AS egreso,
    0.00 AS monto,
    i.tipo_cash_nota AS tipo_cash_nota,
    i.cash_nota_num AS cash_nota_num,
    i.fecha_deposito AS deposit_fecha,
    i.cliente AS cliente,
    i.factura AS factura,
    i.factura_numero AS factura_numero,
    'No' AS iva_incluido,
    0.00 AS ivacobradox100,
    0.00 AS ivarealmentecobrado,
    0.00 AS ivacobradototal,
    i.alta_db AS alta_db,
    i.alta_por AS alta_por,
    i.numero_referencia AS numero_referencia,
    null AS cash_num_cobro_iva,
    i.empresa_id AS empresa_id,
    i.remarks AS remarks,
    'No' AS puede_borrar,
    i.activo AS activo,
    'NO' AS afecta_cuentat,
    i.comments AS comments,
    i.autorizado AS autorizado,
    i.rechazado AS rechazado,
    i.revisado AS revisado,
    i.autorizado_el AS autorizado_el,
    i.autorizado_por AS autorizado_por,
    i.MetodoPago AS MetodoPago,
    i.FormaPago AS FormaPago,
    i.UsoCFDI AS UsoCFDI,
    'No' AS iva_revisado,
    '' AS iva_revisado_por,
    null AS iva_revisado_el,
    i.ultimo_cambio AS ultimo_cambio,
    i.ultimo_cambio_por AS ultimo_cambio_por,
    '' AS cliente_rfc,
    '' AS referencia,
    null AS origen_mov_id,
    'No' AS factura_directa,
    1 AS moneda_id,
    i.alta_db AS fecha_capturado,
    i.json_file_attachments AS json_file_attachments,
    i.cancelacion_revisada,
    i.cancelacion_revisada_por,
    i.cancelacion_revisada_el,
    i.cancelacion_el
FROM inversion_reembolso i
     WHERE i.inversion_reembolso_id <> '' AND i.inversion_reembolso_id = '$inversion_reembolso_id');";

    $arr_doc = ia_singleton($sql_doc);
//
//    echo "<li>$sql_doc";
//    echo "<pre>".print_r($arr_doc, true)."</pre>";

    $insert_sql = ia_insert('links_al_banco_live', $arr_doc, array(), "", true);

    return $insert_sql;
}

function normaliza_origen_doctos($origen = "", $cancelado = "NO"){
    if(empty($origen))
        return "";

    $origen = str_replace(array("gasto", "nota"), "cheque", $origen);

    if($origen != "vale")
        $origen = str_replace(array("vale", "link", "cash"), "pago", $origen);


    $origen = str_replace(" ", "_", $origen);

    $_log = "";
    if(strtoupper($cancelado) == "SI")
        $_log = "_log";

    $arr_equivalentes = array(
        'cheque'=>'cheque'
        ,'cheque_log'=>'cheque_log'
        ,'pagare'=>'pagare'
        ,'pagare_log'=>'pagare_log'
        ,'vale'=>'vale'
        ,'vale_log'=>'vale_log'
        ,'compra'=>'compra'
        ,'compra_log'=>'compra_log'
        ,'cheque_pago_log'=>'cheque_pago_log'
        ,'pagare_pago_log'=>'pagare_pago_log'
        ,'vale_pago_log'=>'vale_pago_log'
        ,'compra_pago_log'=>'compra_pago_log'
        ,'cuenta_t'=>'cuentat_a_banco'
        ,'cuenta_t_log'=>'cuentat_a_banco'
        ,'cheque_pago'=>'cheque_pago'
        ,'pagare_pago'=>'pagare_pago'
        ,'docto_tc_pactado'=>'docto_tc_pactado'
    );

    return $arr_equivalentes[$origen.$_log];
}

function spanAlertMovimientosConWarning()
{
    $query_cache = "SELECT valor FROM campos_exists WHERE tabla_origen = 'movimiento_divisa' AND tabla_exists = 'con_warning'";
    $con_warning = ia_singleread($query_cache);
    $con_warning = false;
    if ($con_warning === false ) {
        $query = "SELECT COUNT(*) FROM movimiento_divisa WHERE warning IN ('SI', 'PS') ORDER BY alta_db DESC";
        $con_warning = ia_singleread($query);
    }
    if ($con_warning > 0)
        return '<div type="button" class="alerta_movimeintos_warning parpadea tooltip_toolbar" title="<div class=\'ui_tooltip_box_top_toolbar_numero_compra_vacios bold\'>'.$con_warning.' Movimientos con Warning</div>"><a href="movimiento_divisa_list.php?warning_status=Por revisar" style="background: none"></a></div>';

    return '';
}
function spanAlertMovimientosConWarningParametros()
{

        $query = "SELECT COUNT(*) FROM movimiento_divisa WHERE warning = 'PS' ORDER BY alta_db DESC";
        $con_warning = ia_singleread($query);

    if ($con_warning > 0)
        return '<div type="button" class="alerta_movimeintos_warning parpadea"></div>';

    return '';
}

function estadosBodega2Html($estados = [], $current_estado = '0', $con_eventos = true, $onclick='productosGeneralesList.activaEstado(this)', $idContent = null, $rowId = null)
{
    if (!empty($idContent))
        $idContent = "id='$idContent'";
    $estadosHtml = "<div class='dvrd' style='display: inline-flex' $idContent><table class='estadoPersonalizadoRegistro' data-value='$current_estado'><tbody>";
    $j = 0;
    $defaults = [
        'color_inactive' => '#c0c0c0',
        'background_inactive' => '#ffffff',
        'color_default' => 'blue',
        'background_default' => '#ffffff',
    ];
    $defaults_estados = ['E1', 'E2', 'E3', 'E4', 'E5', 'E6', 'E7', 'E8', 'E9', 'E10', 'E11', 'E12', 'E13', 'E14', 'E15', 'E16', 'E17', 'E18', 'E19', 'E20'];
    foreach ($estados as $key => $estado) {
        // if (in_array($estado['clave'], $defaults_estados))
        //     continue;
        if ($j == 0) {
            $estadosHtml .= "<tr>";
        }
        $css_color = $defaults['color_inactive'];
        $css_background = $defaults['background_inactive'];
        $activo = 0;
        // if (isset($producto_o_pcolor['estado'])) {
            if ((int)$current_estado & (int)$estado['potencia']) {
                $css_color = $estado['color'] ?? $defaults['color_default'];
                $css_background = $estado['background'] ?? $defaults['background_default'];
                $activo = 1;
            }
        // }

        $eventos = '';
        $cursor = '';
        $border = '';
        if ($con_eventos) {
            $eventos = "onmouseover=\"$(this).addClass('ui-state-hover');\" onmouseout=\"$(this).removeClass('ui-state-hover')\" onclick='$onclick'";
            $cursor = 'cursor:pointer;';
        }

        if (empty($estado['icon'])) {
            $contentTD = "<strong style='vertical-align: middle;'>$estado[clave]</strong>";
        } else {
            $filter = '';
            if ($activo == 0) {
                $filter = 'filter: grayscale(100%);';
            } else {
                $border = 'border: 1px solid ' . ($estado['background'] ?? $defaults['background_default']) . " !important;";
            }
            $contentTD = "<img src='$estado[icon]' alt='$estado[clave]' width='18' style='$filter vertical-align: middle;' align='center'/>";
            $css_color = $defaults['color_inactive'];
            // $css_background = $defaults['background_inactive'];
        }
        $estadosHtml.= "<td id='$key' data-rowid='$rowId'
                                title='$estado[title]'
                                data-activo='$activo'
                                data-pos='$estado[posicion]'
                                data-orden='$estado[orden]'
                                data-colname='origen'
                                data-rid='$key'
                                data-color='$estado[color]'
                                data-background='$estado[background]'
                                data-potencia='$estado[potencia]'
                                $eventos
                                style='width:26px !important; height:23px !important; text-align: center; vertical-align: middle; padding: 0 2px 0 2px !important;$cursor background-color:$css_background;color:$css_color;$border'>
                                $contentTD
                            </td>";
        $j++;
        if ($j == 6) {
            $j = 0;
            $estadosHtml .= "</tr>";
        }
    }
    $estadosHtml .= "</tbody></table></div>";
    return $estadosHtml;
}

function array2jsArray($arr) {
    $js = '[';
    foreach($arr as $v)
        if($v === null)
            $js .= 'null,';
        elseif($v === true)
            $js .= 'true,';
        elseif($v === false)
            $js .= 'false,';
        elseif($v === 0)
            $js .= '0,';
        elseif(is_numeric($v))
            $js .= $v.',';
        else
            $js .= '"'.str_replace('"','\\"',$v).'",';
    return $js.']';
}

function bodega_id_select($dflt=null, $conTodas=false, $tag='', $selectid='select_toolbar_bodega_id', $con_grupos = true, $es_verificacion = false, $grupo_verificador = ''){

    $method = __FUNCTION__;
    if($dflt==null)
        $dflt=param('bodega_id');
    if($conTodas) {
        $todas="<option value='0'>Elige</option>";
    } else
        $todas='';
    global $gPermisosbodega;
    $bodegas =  $gPermisosbodega->getBodegasActivas(); // $bodegasPuede; //
    if(!$es_verificacion && empty($grupo_verificador)) {
        $bodegas_y_grupos = json_decode(obtenCatalogo('origen_bodega_grupo_2'), true);
    }
    else{
        $grupo = strit($grupo_verificador);
        $sql = "SELECT /*$method*/
                    origen_bodega.origen_bodega_id,
                    origen_bodega.clave,
                    CONCAT(clave, ' <span style=\'font-size:10px;\'>(', IF(origen_bodega.es = 'BODEGA', 'B', IF(origen_bodega.es = 'TIENDA', 'T', 'GB')), ')</span>') as label,
                    origen_bodega.origen_bodega_id as real_data,
                    origen_bodega.clave as value,
                    origen_bodega.origen_bodega_id as real_value,  -- Cambiado a un solo alias
                    origen_bodega.es,
                    origen_bodega.empresa_id,
                    origen_bodega.bodega_id,
                    bgvvb.bodega_grupo_verificador_id
                FROM origen_bodega
                JOIN bodega_grupo_verificador_verfica_bodega bgvvb ON bgvvb.bodega_id = origen_bodega.bodega_id
                WHERE activo = 'Si' 
                AND es IN('BODEGA', 'GRUPO BODEGA')
                AND bgvvb.bodega_grupo_verificador_id = $grupo ORDER BY es DESC, clave";
        $bodegas_y_grupos = ia_sqlArrayIndx($sql);
    }

// dd_($bodega_id, $bodegas_y_grupos);
    $select = "";
    $select_style = "";

    if(empty($bodegas))
        return false;
// dd_($bodegas);
// $select = array2Select($bodegas, 'bodega_id', 'bodega', null ,'bodega_id', 'TODAS', false, true, [], [], null, false);
    foreach ($bodegas_y_grupos as $bodega) {
        $selected = '';
        $id = $bodega['origen_bodega_id'];
        $bodega_id_self = $bodega['bodega_id'] ?? '';
        if(empty($bodega_id_self))
            continue;

        $color = "color:".($bodegas[$bodega_id_self]['color']??'000');

        $strike_text = $bodega_id_self == "74867af2fe60ad6b11ec6d7b3badcba6" /**Bodega amarilla**/ ? " -webkit-text-stroke: 1px black;" : "";

        if ($bodega_id_self == $dflt) {
            $selected = 'selected="true"';
            $select_style = "style='$color; font-weight: bold; " . ($bodega_id_self == "74867af2fe60ad6b11ec6d7b3badcba6" /**Bodega amarilla**/ ? $strike_text : "") . "'";
        }
        $select.="<option value='$id' data-bodega_id='$bodega_id_self' style='$color; font-weight: bold; $strike_text'  $selected>".($bodega['bodega']??$bodega['label'] )."</option>";
        // color:$bodega[color];
    }

    if(count($bodegas_y_grupos) === 1)
        $select = "<select class='notSelectize' name='$selectid' id='$selectid' $select_style $tag>" . $select;
    else
        $select = "<select class='notSelectize' name='$selectid' id='$selectid' $select_style $tag><option value='' style='color: black; font-weight: bold'>ELIGE BODEGA</option>" . $select;

    $select.="</select>";

    return $select;
}

function cuentat_es_de($cuentat_id = '')
{
    $es_de = "";
    if(empty($cuentat_id))
        return $es_de;

    $es_de = ia_singleread("SELECT es_de FROM cuentat WHERE cuentaT_id=".strit($cuentat_id));

    return $es_de;
}

function createHtmlForTabBodegaUsuario($id_usuario = '')
{

    if (empty($id_usuario))
        $id_usuario = $_SESSION['usuario_id'];

    $dir_save = dirname(__DIR__, 2)."\\backoffice\\view\\component\\index\\";
    $file_name = "html_for_tab_bodega_$id_usuario.html";
    $file_save = $dir_save.$file_name;
    return file_put_contents($file_save, getHtmlTabBodega($id_usuario));
}

function getHtmlTabBodega($id_usuario) {
    require(__DIR__ . '/../../backoffice/view/component/index/indexBodega.php');  return;
    global $gPermisadorClick;
    ob_start();
    ?>
    <style>

        DETAILS.default {
            display:unset;
            border-radius:unset;
            padding:unset;
            box-shadow:unset;
            background:unset;
            justify-content:unset;
            margin:unset;
            min-width:unset;
            max-width:unset;
        }
        DETAILS.default:after {none}
        DETAILS.default > summary {
            background:unset;
            left:unset;
            top:unset;
            position:unset;
            width:unset;
            padding:unset;
            border-radius:unset;
            color: darkgreen;
            text-shadow:none;
        }

        DETAILS.default > summary::after {
            content:unset;
            margin-left:unset;
        }
        DETAILS.default[open] {
            border-radius:unset;
            padding:unset;
            box-shadow:unset;
            background:unset;
            justify-content:unset;
        }
        DETAILS.default[open] > summary {
            background:unset;
            left:unset;
            top:unset;
            position:unset;
            width:unset;
            padding:unset;
            margin:unset;
            border-radius:unset;
            box-shadow:unset;
            color: darkgreen;
            text-shadow:none;
        }
        DETAILS.default[open] > summary:after {
            content:unset;;
            margin-left: 10px;
        }
        DETAILS.default > DIV {
            margin:1em;
            padding:1em;
            border:1px darkgreen solid;
        }
    </style>
    <fieldset class="flexRow" style="gap:0.5em;margin:0;padding:0;border:none;">
        <?php
        global $gDebugging;
        $mePregunto = false && $gDebugging && usuarioSupervisaBodega($id_usuario) ? me_pregunto_notas_bodega() : '';
        $dashboardCount['destino_match'] = ia_singleread(
            "SELECT COUNT(DISTINCT inb.nota_bodega_id)
                FROM inconsistencia_nota_bodega inb
                JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
                WHERE nb.tipo NOT IN('Cancelada', 'Borrado') AND nb.destino_fuerza_ok = 'No' AND
                      inb.estado='activo' AND inb.tipo_inconsistencia IN('clientes','ayudantes','pedido_por')");
        $trasladoDate = Date('Y-m-d', strtotime('1 month ago') );
        $dashboardCount['contra_nota'] = ia_singleread(
            "SELECT COUNT(DISTINCT inb.nota_bodega_id)
                FROM inconsistencia_nota_bodega inb
                JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
                WHERE nb.tipo = 'Traslado' AND nb.traslado_forza_ok = 'No' AND
                      inb.estado='activo' AND inb.tipo_inconsistencia IN('contra_nota')
                AND nb.fecha >= " .
            strit($trasladoDate)
        );

        $dashboardCount['numero_compra'] = ia_singleread(
            "SELECT COUNT(DISTINCT inb.nota_bodega_id)
                FROM inconsistencia_nota_bodega inb
                JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
                WHERE nb.tipo NOT IN('Cancelada', 'Borrado') AND nb.destino_fuerza_ok = 'No' AND
                      inb.estado='activo' AND inb.tipo_inconsistencia IN('numero_compra')");

        $son = ia_sqlArrayIndx(
            "SELECT
        CONCAT('bodega_id[]=', b.bodega_id, '&producto_general_id[]=', pg.producto_general_id, '&color_id[]=', c.color_id) as href,
        CONCAT_WS('\t', b.grupo, b.bodega, pg.producto, c.color,  
            IF(pb.existencia_rollos < 0 , '<span style=\"color:red\">', '<span>') , pb.existencia_rollos, ' rollos</span>', 
            IF(pb.existencia_quantity < 0 , '<span style=\"color:red\">', '<span>') , pb.existencia_quantity,
            u.unidad,'</span>'
            ) as txt,
        r.revisado_el
        FROM producto_bodega pb
            JOIN producto_general pg on pb.producto_general_id = pg.producto_general_id
            JOIN unidades u on pg.unidades_id = u.unidades_id
            JOIN color c on pb.color_id = c.color_id
            JOIN bodega b on pb.bodega_id = b.bodega_id
            
            LEFT OUTER JOIN revisador r ON r.tema = 'tab_bodega_producto_color_raro' AND
                r.id = CONCAT_WS('_', b.bodega_id, pg.producto_general_id, c.color_id) AND r.iac_usr_id='$_SESSION[usuario_id]'
        WHERE b.activo='Si' AND pg.activo='Si' AND c.activo='Si' AND (existencia_rollos < 0 OR existencia_quantity < 0)
        ORDER BY 2");
        $list = [''];
        $total = 0;
        $i = 0;
        $prevIndx = 1;
        $prev = '';
        foreach($son as $data) {
            $href = $data['href'];
            $text = $data['txt'];
            $t = explode("\t", $text);
            if($prev !== $t[0] . ' ' . $t[1]) {
                if(!empty($prev)) {
                    $list[$prevIndx -1] = "</div></details>";
                    $list[$prevIndx] = "<details class='default'>
                <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                        number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
                    $prevIndx = count($list);
                }
                $prev = $t[0] . ' ' . $t[1];
                $list[] = '';
                $list[] = '';
                $i = 0;
                $list[] = '';
                $list[] = '';
            }
            $total++;
            $i++;
            $parts = [];
            parse_str($href, $parts);
            $id = $parts['bodega_id'][0] . '_' . $parts['producto_general_id'][0] . '_' . $parts['color_id'][0];
            if(empty(empty($data['revisado_el']))) {
                $checked = 'checked="checked"';
                $title = " title='Lo revisaste el " . mysqlDateTime2display($data['revisado_el']) . "'";
            } else {
                $title = $checked = '';
            }
            $list[] = "<input $title type='checkbox' value='$id' $checked onclick=\"revisadorMarca('tab_bodega_producto_color_raro', this)\"> <a href='../bodega/bodega_articulo_rastrea.php?$href&por=trackit' target='_blank'
             style='font-weight:100!important;font-size:0.9em;text-shadow: none'>$text</a>";
            $list[] = '';
        }
        unset($list[0]);
        if($total > 0) {
            $list[$prevIndx] = "<details class='default'>
                    <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
            if($prevIndx > 0)
                $list[$prevIndx - 1] = "</div></details>";
        }
        $negativosList = "<dl><dt>" . implode("<dt>", $list) . "</dt></dl>";
        $dashboardCount['bodega_negativos'] = $total;
        $desdeNotasRevisar = Date('Y-m-d', strtotime("35 days ago"));
        $son =
            ia_sqlArrayIndx(
                "SELECT
                    CONCAT(
                        'producto_general_id[]=', pg.producto_general_id,
                        '&color_id[]=', c.color_id,
                        '&bodega_id[]=', b.bodega_id,
                        '&fecha_min=', DATE_SUB(bed.fecha, INTERVAL 30 DAY)
                    ) as href,
                    CONCAT_WS('\t',b.grupo, b.bodega, bed.fecha, pg.producto, c. color) as txt,
                    r.revisado_el
                FROM bodega_existencia_diaria bed
                    JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
                    JOIN color c on bed.color_id = c.color_id
                    JOIN bodega b on bed.bodega_id = b.bodega_id
                    LEFT OUTER JOIN revisador r ON r.tema = 'tab_bodega_producto_color_raro' AND
                        r.id = CONCAT_WS('_', b.bodega_id, pg.producto_general_id, c.color_id) AND r.iac_usr_id='$_SESSION[usuario_id]'
                WHERE bed.fecha >= '$desdeNotasRevisar' AND
                    pg.activo = 'Si' AND existencia_quantity<>0 AND  existencia_quantity  = -1 * salida_quantity AND existencia_rollos = -1 * salida_rollos
                ORDER BY b.grupo, b.bodega, bed.fecha DESC, pg.producto, c. color");
        $list = [''];
        $total = 0;
        $i = 0;
        $prevIndx = 1;
        $prev = '';
        foreach($son as $data) {
            $href = $data['href'];
            $text = $data['txt'];
            $t = explode("\t", $text);
            if($prev !== $t[0] . ' ' . $t[1]) {
                if(!empty($prev)) {
                    $list[$prevIndx -1] = "</div></details>";
                    $list[$prevIndx] = "<details class='default'>
                <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                        number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
                    $prevIndx = count($list);
                }
                $prev = $t[0] . ' ' . $t[1];
                $list[] = '';
                $list[] = '';
                $i = 0;
                $list[] = '';
                $list[] = '';
            }
            $list[] = '';
            $total++;
            $i++;
            $parts = [];
            parse_str($href, $parts);
            $id = $parts['bodega_id'][0] . '_' . $parts['producto_general_id'][0] . '_' . $parts['color_id'][0];
            if(empty(empty($data['revisado_el']))) {
                $checked = 'checked="checked"';
                $title = " title='Lo revisaste el " . mysqlDateTime2display($data['revisado_el']) . "'";
            } else {
                $title = $checked = '';
            }
            $list[] = "<input $title type='checkbox' value='$id' $checked onclick=\"revisadorMarca('tab_bodega_producto_color_raro', this)\"> <a href='../bodega/bodega_articulo_rastrea.php?$href' target='_blank'
            style='font-weight:100;font-size:0.9em;text-shadow: none'>$text</a>";
            $list[] = '';
        }
        unset($list[0]);
        if($total > 0) {
            $list[$prevIndx] = "<details class='default'>
                    <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
            if($prevIndx > 0)
                $list[$prevIndx - 1] = "</div></details>";
        }
        $rarosList = "<dl><dt>" . implode("<dt>", $list) . "</dt></dl>";
        $dashboardCount['raros'] = count($son);

        foreach($dashboardCount as &$count)
            $count = empty($count) ? "" :
                "<span style='font-size:1.2em;color:red;font-weight:800'>" .
                number_format($count, 0, '', ',') .
                "</span>";
        unset($count);
        global $gPermisosbodega;

        $bodegas_puede_consultar  = $gPermisosbodega->bodegasPuedeConsultarMovimientos();
        $bodegasHacerMovimientos = $gPermisosbodega->bodegasPuedeHacerMovimientos();
        $puede_consultar_Existencias = puedePermisoUsuario($id_usuario, nombrePermiso: "puede_consultar_existencia");
        $puede_editar_campos_cash_nota_bodega = puedePermisoUsuario($id_usuario, nombrePermiso: 'puede_editar_campos_cash_nota_bodega');
        $usuarioTipoRony = usuarioTipoRony();
        $bodegas_tab = true;

        //dd_($bodegasHacerMovimientos);
        if ($bodegas_tab || !empty($bodegas_puede_consultar) || !empty($bodegasHacerMovimientos)) { ?>
            <fieldset style="margin:0;padding:0.5em 0.3em;border-color:blue" class="indexBodegasPrincipal backgroundBodegasPrincipal">
                <legend class="indexLegendBodegasPrincipal">Bodegas Principales</legend>
                <ul class="tab tabBodega" style="padding-left:2em;box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);transition: 0.3s;">

                    <?php

                    if (!empty($bodegas_puede_consultar)) {
                        echo '<li><a class="txt_shadow_naranja txt_1_1em tooltip_toolbar" href="nota_bodega.php">Consultar Notas</a>&nbsp;&nbsp;&nbsp;&nbsp;<a class="txt_shadow_olivo tooltip_toolbar" href="nota_bodega.php?container=si">Entrada de Contenedor</a></li><br/>';
                    }

                    if($bodegas_tab || usuarioSupervisaBodega($id_usuario)) {
                        echo '<li><a class="txt_shadow_verde tooltip_toolbar" href="../bodega/bodega_reporte_ventas.php">Reporte: Ventas de Bodega</a>';
                        echo '<a href="../bodega/reporte_ventas_mensuales.php">🧿 Mensual</a><br />&nbsp;';
                    }

                    if ($puede_consultar_Existencias) {
                        echo '<li><a class="txt_shadow_azul_marino tooltip_toolbar" href = "javascript:dialogConsultarExistencia.show(true);" > Consultar Existencias Diálogo </a ></li ><br />';
                    }

                    if(usuarioTipoRony() || Permisador::puede('pedido_china', 'Nada', $id_usuario) !== 'Nada') {
                        echo '<li><a class="txt_shadow_rosa tooltip_toolbar" href="../pedido/pedido.php">China</a> ' . $gPermisadorClick;
                        echo '&nbsp;&nbsp;<a class="txt_shadow_rosa tooltip_toolbar" href="../pedido/pedido_items.php?activo=Si&mostrar_en_ventas=Si">Por Artículo</a><br />&nbsp;';
                    }
                    if($puede_consultar_Existencias) {
                        echo '<li><a href="producto_bodega.php">Consultar Existencias <span class="txt_bold_brightred">GRID</span></a></li><br/>';
                    }

                    if($bodegas_tab || !empty($bodegas_puede_consultar) ) {
                    if (!empty($bodegas_puede_consultar)) { ?>
                        <li><a href="nota_bodega.php">Consultar Notas</a></li><br/>
                        <!--<li><a href="nota_bodega.php">Consultar Notas Con Productos</a></li><br/>-->
                        <!--<li><a href="nota_bodega.php?modificadas=si">Consultar Notas Modificadas</a></li><br/>-->
                        <?php
                    }
                    ?>
                    <li><a class="txt_shadow_naranja txt_1_1em tooltip_toolbar" href='../bodega/destinoMatch2.php?inconsistencia_destino_match%5B%5D=ayudantes&inconsistencia_destino_match%5B%5D=clientes&inconsistencia_destino_match%5B%5D=pedido_por'>Destino Match</a>
                        <?php echo $dashboardCount['destino_match'];  ?>
                        <a href="../bodega/destinoMatch2.php?inconsistencia_destino_match_all=all&inconsistencia_destino_match%5B%5D=ayudantes&inconsistencia_destino_match%5B%5D=clientes&inconsistencia_destino_match%5B%5D=numero_compra&inconsistencia_destino_match%5B%5D=pedido_por" target="_self" title="Destino Match con Números de Compra" class="txt_shadow_violeta txt_1_1em tooltip_toolbar_wohtml"><strong>Con Números de Compra</strong></a>
                        <?php echo $dashboardCount['numero_compra'];  ?>
                        <br/><br/>
                        <?php if(usuarioTipoRony() || puedePermisoUsuario($id_usuario, "puede_ver_traslados_match")) { ?>
                    <li><a href='../bodega/traslados_match.php?diff_date_min=<?=$trasladoDate?>'>Traslado Match</a> <?=$gPermisadorClick?>
                        <?php echo $dashboardCount['contra_nota'];  ?>
                    </li><br/>
                <?php } ?>
                    <?php
                    if($dashboardCount['bodega_negativos'] !== '' || $dashboardCount['raros'] !== '') {
                        if($dashboardCount['raros'] !== '')
                            echo "<li><details class='default'>
                                <summary title='desde el $desdeNotasRevisar. Haga Click para desplegar'>
                               $dashboardCount[raros] Notas a Revisar Producto/Color ¿Correcto?</summary>
                               <div>$rarosList</div>
                           </details><br>&nbsp;";
                        if($dashboardCount['bodega_negativos'] !== '')
                            echo "<li><details class='default'>
                                        <summary title='Hazme Click Please'>
                                            $dashboardCount[bodega_negativos] Artículos con ∃ Negativa
                                            </summary>
                                            <div>$negativosList</div></details><br>&nbsp;";
                    }
                    ?>
                    <?php if (puedePermisoUsuario($id_usuario, nombrePermiso: "puede_autorizar_notas_ultimo_movimiento")): ?>
                        <li><a href="../bodega/nota_bodega_autorizacion.php">Autorizaciones</a></li><br/>
                    <?php endif;?>

                    <?php if(!empty($bodegas_puede_consultar)){ ?>
                        <li style="color: black !important;">
                            <form class="content_tab_ul_li" method="get" action="../bodega/traslados.php" id="form_traslados_entre_bodegas">
                                <label class="bold" for="origen_label_traslado2" style="color: black">Traslados de </label>
                                <input name="origen_label_traslado" id="origen_label_traslado2" type="text" autocomplete="off" class="input inputEntrada"
                                       data-campo="origen_label_traslado" value=""/>
                                <input name="origen_id_traslado" id="origen_id_traslado2" type="hidden" data-campo="bodega_id" value=""/>
                                <label for="destino_label_traslado2">A</label>
                                <input name="destino_label_traslado" id="destino_label_traslado2" type="text" autocomplete="off" class="input inputEntrada"
                                       data-campo="destino_label_traslado" value="" />
                                <input name="destino_id_traslado" id="destino_id_traslado2" type="hidden" data-campo="origen_id" value=""/>
                                <button>Ver</button>
                            </form>
                        </li><br/>
                        <script>
                            <?php
                            $catalogos = obtenCatalogos([ 'origen_bodega', 'origen_bodega_grupo_2']);
                            $destinos_bodegas = json_decode($catalogos['origen_bodega_grupo_2'], true);
                            ?>
                            var destinos = <?=json_encode($destinos_bodegas)?>;
                            $d.initAutoComplete('#origen_label_traslado2', destinos, '#origen_id_traslado', null, 120, 'origen', true);
                            $d.initAutoComplete('#destino_label_traslado2', destinos, '#destino_id_traslado', null, 120, 'origen', true);
                        </script>
                        <?php
                    }
                    if (!empty($bodegas_puede_consultar)){ ?>

                    <li><a href="../bodega/inconsistencias_notas.php">Inconsistencias de Notas</a>
                        <span style="font-size: larger;cursor:pointer;color: blueviolet;" title="Que genera una inconsistencia" onclick="helpOpen2()">&#x2754;
                        <sup style="font-size:0.3em;vertical-align:top">Ayuda</sup></span>
                        <?php
                        if(usuarioSupervisaBodega($id_usuario))
                            echo ' <a href="../bodega/reporte_incosistencias_tipo.php">🧿 Totales</a>';
                        }

                        echo "<br/>&nbsp;";






                        if($bodegas_tab || usuarioSupervisaBodega($id_usuario)) {
                            echo '<li><a href="../bodega/bodega_articulo_rastrea.php">Reporte: Artículo-color</a><br />&nbsp;';
                            echo '<li><a href="../bodega/bodega_reporte_numero_notas.php">🧿 Totales Bodega a Destino</a><br />&nbsp;';
                        }

                        if(usuarioSupervisaBodega($id_usuario)) {
                            echo '<li><a href="../bodega/grid_recaptura_por_usuario.php">Errores por Usuario</a>&nbsp;';
                            echo '&nbsp;&nbsp;&nbsp;&nbsp;<a href="../bodega/reporte_recaptura_por_usuario.php">🧿 Totales</a>&nbsp;';
                            echo "</lI><br/>";
                        }
                        }
                        $list_entradas = '';
                        if(!empty($bodegasHacerMovimientos)) {?>
                    <li style=" list-style: none;">
                        <details class="bodega" id="lista_entrada_salida_bodegas">
                            <summary class="Bodegas_titIndex"> Nueva nota</summary>
                            <div class="flexRow" style="gap:0.2em; justify-content: space-evenly;">
                                <div class="flexItem flexItemBodega">
                                    <ul class="tab tabBodega bodega_boxSalida">
                                        <li><h3 style="margin: 0">Salida</h3>
                                            <?php foreach ($bodegasHacerMovimientos as $key => $bodega) {
                                                // $sigNum = NotaBodega::getSiguienteNumero($key, 500);
                                                $list_entradas .= "<li style='margin-top: 1.3em;color:$bodega[color]'>" . getLabelBodega($bodega, [
                                                        'isAnchor' => true,
                                                        'urlAnchor' => "../bodega/alta_movimiento.php?bodega_id=".urlencode($key)."&movimientode=entrada",
                                                        'titleAnchor' => "Nueva Entrada en " . ia_htmlentities($bodega['bodega'])
                                                    ]) . // " [$sigNum]" . implode(", ", NotaBodega::numerosDeNotasFaltantes($key, 0, false)) .
                                                    "</li>";
                                                ?>
                                            <?php } // foreach ($bodegasHacerMovimientos) ?>
                                            <?=str_replace(['entrada', 'Entrada'], ['salida', 'Salida'], $list_entradas)?>
                                    </ul>
                                </div>
                                <div class="flexItem flexItemBodega">
                                    <ul class="tab tabBodega bodega_boxEntrada">
                                        <li><h3 style="margin: 0;">Entrada</h3>
                                            <?=$list_entradas?>
                                    </ul>
                                </div>
                            </div>
                        </details>

                        <?php } // if(!empty($bodegasHacerMovimientos))  ?>


                        <?php
                        $totalFaltan = 0;
                        $resumen = bodegasResumenNumeroNotas($bodegas_puede_consultar, $bodegasHacerMovimientos, $totalFaltan);
                        if($totalFaltan) {
                            $resumenExtra = "<span style='color:red;font-weight: 800'>Faltan de Capturar: " .
                                number_format($totalFaltan, 0, ',', '') . "</span>";
                            $ok = "<span style='color:red;font-size:2em;'>&cross;</span>";
                            $okGrande = '';
                        } else {
                            $resumenExtra = '¡Ok!';
                            $okGrande = $ok = "<span style='color:green;font-size:2em;'>✔</span>";
                        }
                        if(!empty($bodegasHacerMovimientos)) {
                            echo "<details class='bodega' id='resumenBodegasNotas' style='min-width: 400px'>
                            <summary class='Bodegas_titIndex'>$ok Captura de Notas: $resumenExtra</summary>
                            <div id='resumenBodegasNotasParaWidth' style='min-width: 400px;display:flex;align-items: center'>
                                <ul class='tab tabBodega bodega_boxResumen' id='resumenBodegasNotasParaWidth'>" .
                                $resumen .
                                "</ul>
                                <div style='vertical-align: middle;color:green;font-size:3em;'>$okGrande</div>
                            </div>
                        </details>";
                        }
                        ?>

                </ul>
                <?php echo $mePregunto; ?>
            </fieldset>
        <?php } else {
            if(puedePermisoUsuario($id_usuario, nombrePermiso: 'puede_editar_campos_cash_nota_bodega'))
                echo <<<HTML
        <fieldset style="margin:0;padding:0.5em 0.3em;border-color:blue" class="indexBodegasPrincipal backgroundBodegasPrincipal">
            <legend class="indexLegendBodegasPrincipal">Campos Cash</legend>
            <ul class="tab tabBodega" style="padding-left:2em;box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);transition: 0.3s;">
                <li><a href='../bodega/destinoMatch2.php?fecha_min_viewdate=&fecha_min=&fecha_max=&inconsistencia_destino_match%5B%5D=ayudantes&inconsistencia_destino_match%5B%5D=clientes&inconsistencia_destino_match%5B%5D=pedido_por'>Destino Match</a></li><br/>
            </ul>
        </fieldset>
HTML;
            else
                // espacio para que no cambie de lugar fieldset de verificacion
                echo "<div style='min-width:25em;width:25em'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>";
        }
        $bodegas_puede_consultar_verificaciones  = $gPermisosbodega->bodegasPuedeConsultarVerificarMovimientos();
        $bodegasHacerMovimientosVerificaciones = $gPermisosbodega->bodegasPuedeHacerVerificarMovimientos();
        $grupos_verificacion = GruposVerificacion::obtenGruposYBodegasPuedeUsuario($id_usuario);
        if (!empty($bodegas_puede_consultar_verificaciones) || !empty($bodegasHacerMovimientosVerificaciones)) { ?>
            <fieldset class="indexVerificacion backgroundVerificacion" style="margin:0;padding:0.1em 0.1em;">
                <legend class="indexLegendVerificacion">Verificación</legend>
                <ul class="tab tabBodega indexVerificacion" >
                    <?php if(!empty($bodegas_puede_consultar_verificaciones) ) { ?>
                        <li><!--suppress HtmlUnknownTarget -->
                            <a href="nota_bodega_verificacion.php">Consultar Verificaciones</a></li><br/>
                        <li><a href="nota_bodega.php?sin_verificar=si">Notas con NIGUNA verificación</a></li><br/>
                    <?php }
                    // $bodegasHacerMovimientosVerificaciones = $gPermisosbodega->bodegasPuedeHacerVerificarMovimientos();
                    $list_salidas = '';
                    $list_entradas = '';
                    if(!empty($grupos_verificacion)){
                        $noCuadran = GruposVerificacion::obtenCuantasNotasNoCuadran();

                        // dd_($bodegasHacerMovimientosVerificaciones);
                        foreach ($grupos_verificacion as $grupo_verificacion_id => $elAgrupado) {
                            $noCuadranPorBodega = GruposVerificacion::obtenCuantsNotasNoCuadranPorBodega($grupo_verificacion_id);
                            $faltanPorBodega = GruposVerificacion::obtenCuantasNotasFaltanPorBodegaEntradaSalida($grupo_verificacion_id);
                            $faltanPorVerificar =  number_format( array_sum($faltanPorBodega), 0, '', ',');
                            if($faltanPorVerificar !== '0')
                                $faltanPorVerificar = "<span style='color:red;font-weight: bold;font-size:larger'>$faltanPorVerificar</span>";
                            if(($noCuadran[$grupo_verificacion_id] ?? 0) > 0)
                                $noCuadranNum = "<span style='color:red;font-weight: bold;font-size:larger'>" . number_format( $noCuadran[$grupo_verificacion_id] ?? 0, 0, '', ',') . "</span>";
                            else
                                $noCuadranNum = '0';

                            $list_salidas = '';
                            $list_entradas = '';
                            ?>
                            <?php $nombreGrupoVerificador = GruposVerificacion::getField('grupo_verficiador', $grupo_verificacion_id); ?>
                            <fieldset class="indexVerificacion" id="grp_Verificacion" style="margin:0;padding:0.1em 0.1em;">
                                <legend class="indexVerificacion">Lugar: <span class="txtTituloLugar"><?php echo $nombreGrupoVerificador .
                                            "<span style='font-weight:100;font-size:smaller'>
                                <a class='hover-underline-animation' href='nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id'> Por Capturar!: $faltanPorVerificar</a>
                                <a class='hover-underline-animation' href='nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id&match=no'>No Cuadran: $noCuadranNum</a></span>" ;?>
                            </span></legend>
                                <li><a href="nota_bodega.php?sin_verificar=si&grupo_verificacion=<?=$grupo_verificacion_id?>">Notas que falta verificar por  <?=$nombreGrupoVerificador?></a></li><br/>
                                <li><a href="nota_bodega_verificacion.php?grupo_verificacion=<?=$grupo_verificacion_id?>">Notas Verificadas</a></li><br/>
                                <details id="bnv_<?=$grupo_verificacion_id?>" class="bodega detailBodegaVerificar">
                                    <summary class="Bodegas_titIndex indexVerificacion" > VERIFICACIÓN</summary>
                                    <div class="flexRow" style="gap:0.01em;">
                                        <div class="flexItem flexItemBodega">
                                            <ul class="tab tabBodega bodega_boxSalida_Verify">
                                                <h3 style="margin: 0">Salida</h3>
                                                <?php foreach ($elAgrupado as $bodega_id => $bodega) {
                                                    $faltanPorVerificar =  number_format( $faltanPorBodega[$bodega_id . '_salida'] ?? 0, 0, '', ',');
                                                    if($faltanPorVerificar !== '0')
                                                        $faltanPorVerificar = "<span style='color:red;font-size:larger;text-shadow: 1px 1px 2px #eaffe9, 0 0 0.1em #ffcba5, 0 0 0.1em #f8f8f8 !important;'>$faltanPorVerificar</span>";

                                                    $noCuadranEnLaBodega =  number_format( $noCuadranPorBodega[$bodega_id.'_salida'] ?? 0, 0, '', ',');
                                                    if($noCuadranEnLaBodega !== '0')
                                                        $noCuadranEnLaBodega = "<span style='color:red;font-size:larger'>$noCuadranEnLaBodega</span>";
                                                    $list_salidas .= "<li style='margin-top: 0.8em;color:$bodega[color]'>" . getLabelBodega($bodega, [
                                                            'isAnchor' => true,
                                                            'urlAnchor' => "../bodega/alta_verificacion.php?bodega_id=".urlencode($bodega_id)."&movimientode=salida&grupo_verificador=".$bodega['bodega_grupo_verificador_id'],
                                                            'titleAnchor' => "Nueva Salida en " . ia_htmlentities($bodega['bodega'])
                                                        ]) . "<p style='font-size:smaller'><a class='hover-underline-animation' href='nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Salida' style='padding-left: 20px;'> Por capturar: $faltanPorVerificar</a> <a class='hover-underline-animation' href='nota_bodega_verificacion.php?match=no&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Salida' style='padding-left: 20px;'>No Cuadran: $noCuadranEnLaBodega</a></p></li>";

                                                    $faltanPorVerificar =  number_format( $faltanPorBodega[$bodega_id . '_entrada'] ?? 0, 0, '', ',');
                                                    if($faltanPorVerificar !== '0')
                                                        $faltanPorVerificar = "<span style='color:red;font-size:larger;text-shadow: 1px 1px 2px #eaffe9, 0 0 0.1em #ffcba5, 0 0 0.1em #f8f8f8 !important;'>$faltanPorVerificar</span>";
                                                    $noCuadranEnLaBodega =  number_format( $noCuadranPorBodega[$bodega_id.'_entrada'] ?? 0, 0, '', ',');
                                                    if($noCuadranEnLaBodega !== '0')
                                                        $noCuadranEnLaBodega = "<span style='color:red;font-size:larger'>$noCuadranEnLaBodega</span>";
                                                    $list_entradas .= "<li style='margin-top: 0.8em;color:$bodega[color]'>" . getLabelBodega($bodega, [
                                                            'isAnchor' => true,
                                                            'urlAnchor' => "../bodega/alta_verificacion.php?bodega_id=".urlencode($bodega_id)."&movimientode=entrada&grupo_verificador=".$bodega['bodega_grupo_verificador_id'],
                                                            'titleAnchor' => "Nueva Entrada en " . ia_htmlentities($bodega['bodega'])
                                                        ]) . "<p style='font-size:smaller'><a class='hover-underline-animation' href='nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Entrada' style='padding-left: 20px;'> Por capturar: $faltanPorVerificar</a> <a class='hover-underline-animation' href='nota_bodega_verificacion.php?match=no&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Entrada' style='padding-left: 20px;'>No Cuadran: $noCuadranEnLaBodega</a></p></li>";
                                                    ?>
                                                <?php } // foreach ($bodegasHacerMovimientosVerificaciones) ?>
                                                <?php echo $list_salidas; ?>
                                            </ul>
                                        </div>
                                        <div class="flexItem flexItemBodega">
                                            <ul class="tab tabBodega bodega_boxEntrada_Verify">
                                                <h3 style="margin: 0;">Entrada</h3>
                                                <?=$list_entradas?>
                                            </ul>
                                        </div>
                                    </div>
                                </details>
                            </fieldset>
                            <br> &nbsp;
                            <?Php
                        }
                    }
                    ?>
                </ul>
            </fieldset>

        <?php } ?>

        <fieldset style="margin:0; margin-top:20px; padding:0.3em 0.3em;border-color:blue">
            <legend style="color:blue">Catálogos</legend>
            <ul class="tab tabBodega" style="box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);transition: 0.3s;">
                <?php if(usuarioSupervisaBodega($id_usuario)) { ?>
                <li><a href="bodega.php">Bodegas</a><br />&nbsp;
                <li><a href="../backoffice/ayudantes.php">Ayudantes y Pedido Por</a><br />&nbsp;
                <li><a href="../bodega/estado_bodega.php">Estados</a><br /><br /><br />
                    <span>Productos</span>
                    <ul class="tab">
                        <li><a href="producto_bodega.php">Productos registrados por Bodega</a><br />&nbsp;
                        <li><a href="producto_general.php">Productos generales</a></li><br/>
                        <!--  <li><a href="../bodega/productos_remate_list.php">Cambiar Saldo/Dead Stock, prices</a></li><br/> -->
                        <li><a href="../bodega/producto_color_saldo_lento.php">Recomienda Saldo/Lento <span style="font-size:0.7em">🧪 probando</span></a>&nbsp;</lI><br/>
                        <li><a href="color.php">Colores de los productos</a><br />&nbsp;
                    </ul>
                    <br/><span>Carta Porte</span>
                    <ul class="tab"><!--Carta Porte-->

                        <li><a href="cp_figuratransporte.php">Conductores</a><br />&nbsp;
                        <li><a href="cp_autotransporte.php">Transporte</a><br />&nbsp;
                        <li><a href="cp_cliente.php">Clientes</a><br />&nbsp;
                        <li><a href="cp_cliente_direccion.php">Direcciones</a><br />&nbsp;
                    </ul>
            </ul>
            <?php } else{ ?>
            <li><a href="../backoffice/ayudantes.php">Ayudantes y Pedido Por</a><br />&nbsp;
                <?php } ?>
        </fieldset>

    </fieldset>
    <div id="inconsistenciaCual" style="display: none"><?php echo InconsistenciaNotaBodega::explicaInconcistencias();?></div>

    <script>
        function helpOpen2() {
            $("#inconsistenciaCual").dialog({
                title:'¿Que causa una inconsistencia?',
                width:'fit-content',
            });
        }

        $(document).ready(function(){
            /*$( "#grp_Verificacion details" ).each(function( index ) {
                if(dialogConsultarExistencia.localStorageGet($(this).attr("id")) === '1'){
                    $("#"+ $(this).attr("id")).attr("open","true");
                }
            });*/

            // $("#lista_entrada_salida_bodegas").prop('open', dialogConsultarExistencia.localStorageGet("lista_entrada_salida_bodegas") === '1');

            // $("#resumenBodegasNotas").prop('open', dialogConsultarExistencia.localStorageGet("resumenBodegasNotas") === '1');

            $("#consulta_nota_bodega_numero").off('keypress', pata).one('keypress', pata)
                .off('blur', tab_bodega.consulta_nota_bodega_por_bodega_numero)
                .one('blur', tab_bodega.consulta_nota_bodega_por_bodega_numero);
            $("#tab_nota_bodega_consulta_num").prop('disabled', false);
            $("#tab_nota_bodega_consulta_last").prop('disabled', false);
        });
        /*$(".detailBodegaVerificar").on("toggle", function(){
            var $detail=$(this), detailID= $detail.attr("id");
            dialogConsultarExistencia.localStorageSet(detailID,$detail.prop("open") ? '1' : '');
        });*/
        /*$("#lista_entrada_salida_bodegas").on("toggle");
        $("#resumenBodegasNotas").on("toggle", function(){
            // dialogConsultarExistencia.localStorageSet("resumenBodegasNotas",$(this).prop("open") ? '1' : '');
        });*/

        /*$("#consulta_nota_bodega_numero").off('keypress', pata).one('keypress', pata)
            .off('blur', tab_bodega.consulta_nota_bodega_por_bodega_numero)
            .one('blur', tab_bodega.consulta_nota_bodega_por_bodega_numero);
        $("#tab_nota_bodega_consulta_num").prop('disabled', false);
        $("#tab_nota_bodega_consulta_last").prop('disabled', false);*/

        function revisadorMarca(tema, element) {
            $.ajax({
                url:'../backoffice/ajax/revisador.php',
                method:'POST',
                data:{ accion:'marcaRevisado', tema:tema, id:element.value, marca:element.checked ? 1 : 0},
                dataType:'json',
            })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log("revisadorMarca ajax error", arguments);
                });
        }
    </script>

    <?php
    return ob_get_clean();
}

function addAfterKey($add_item, $key, array $array_origin)
{
    $pos = array_search($key, array_keys($array_origin));
    if ($pos || $pos == 0) {
        return array_slice($array_origin, 0, $pos+1, true)+ $add_item+ array_slice($array_origin, $pos, null, true);
    }
    return $array_origin;
}

/**
 * Trae los vales que correspondan al pagaré o cheque que lo pide, filtrados por el cliente del mismo documento.
 * @param $tabla string vale los documentos que se piden
 * @param $id string id del cheque o pagaré
 * @param $data array con el quantity, cliente_id, etc.
 * @param $vDePaso int override para que muestre los clientes de paso
 * @return string
 */
function getDocparaVale(string $tabla, string $id, array $data, string $vDePaso = ''): string {
    //global $tiendas;
    global $gIAParametros;

    $docsEncontrados = '';
    $tbl=$tabla; //."_pago";
    $tblID=$tabla."_id";
    $extraCte='';
    $tiendaid='tienda_id,';
    $vDePaso = ''; //$vDePaso==1? ' cliente_de_paso=1' : '';
/*
    if($data['cliente_id']=='')
    {
        if(empty($vDePaso))
            $cte="(cliente_id IS NULL)";
        else
            $cte="( $vDePaso )";
    }
    else
    {
        if(empty($vDePaso))
            $cte="(cliente_id=".strit($data['cliente_id'])." )";
        else
            $cte="( $vDePaso )";
    }
    */
    $cte="(cliente_id=".strit($data['cliente_id'])." )";
    $selectCliente='';
    if($tabla=='cheque') {
        $number="numero as numero";
        $fecha='original_date as fecha';
        $debe='disponible_para_sustituir as debe';
        $total_payments='total_payments';
        $paid='AND paid=0 AND disponible_para_sustituir > 0';
        $selectCliente=",nombre,cliente_proveedor_id";
    }
    else {
        $number=$tabla."_number as numero";
        $fecha='fecha';
        $debe='quantity as debe';
        $total_payments='quantity as total_payments';
        $paid='';
    }
    if($tabla=='pagare') {
        $debe='disponible_para_sustituir as debe';
        $total_payments='total_payments';
        $paid='AND  paid=0 AND disponible_para_sustituir > 0';
    }
    if($tabla=='vale') {
        $uid=$_SESSION['usuario_id'];
        $debe='quantity-total_payments as debe';
        $total_payments='total_payments';
        $paid='AND paid=0 AND aplicado=0 AND cancelado=0 AND devuelto=0 AND quantity > total_payments';
        //$extraCte=" OR (cliente_de_paso=1 AND tienda_id=".strit($data['tienda_id']).") ";
        //$extraCte=" AND (cuentat_id IN (".cuentasTPuede().") OR abierto = '1' OR (vale_id IN (SELECT vale_id FROM vale_permiso WHERE iac_usr_id='$uid' OR tienda_id IN (SELECT tienda_id FROM usuario_cobranza WHERE permiso='editar' AND iac_usr_id='$uid'))))";
        if(usuarioTipoRony($_SESSION['usuario_id']))
            $extraCte = '';
        else
            //CAMBIAPLANTILLATIENDAS
            $extraCte=" AND (cuentat_id IN (".cuentasTPuede('','emitido_por_en_vales').") OR  abierto = '1' OR (vale_id IN (SELECT vale_id FROM vale_permiso WHERE iac_usr_id='$uid' OR tienda_id IN (SELECT p.tienda_id FROM plantilla_cobranza p JOIN iac_usr u ON u.plantillatienda_id=p.plantillatienda_id WHERE p.permiso_cobranza='editar' AND u.iac_usr_id='$uid'))))";
        $selectCliente=",cliente_de_paso,cliente";
        $tiendaid = 'conversion_tipo_cambio,';
        //echo "<pre>".$extraCte."</pre>";
        //die();
    }

    $sql="SELECT $tblID as id,no_aplicable,quantity,$total_payments,$debe,$number,$fecha,$tiendaid moneda_id,cliente_id $selectCliente
            FROM $tabla WHERE ($cte $extraCte) $paid  AND $tblID<>".strit($id) . " ORDER BY no_aplicable DESC, vale_number ASC";
//    echo "<pre>".$sql."</pre>";
    //die();
    $arr=ia_sqlArray($sql);

//    echo "<pre>arr" . print_r($data, true) . "</pre>";

    $docto_saldo = $data['quantity'] - $data['total_payments'];
    $doc_moneda = $data['moneda_id'];


//    die();

//ia_query("INSERT INTO dime(dime) VALUES(".strit($tabla."\r\n$sql"."\r\n").")");
    if($arr) foreach($arr as $k=>$d) {
        //$tienda= array_key_exists($d['tienda_id'],$tiendas) ? $tiendas[$d['tienda_id']]['clave'] : '';
        $cliente='';
        if(!empty($d['cliente_id']))
            $cliente=ia_singleread("SELECT nombre FROM cliente WHERE cliente_id=".strit($d['cliente_id']));
        if(array_key_exists('cliente',$d) && !empty($d['cliente']) )
            $cliente.=" ".ia_htmlentities($d['cliente']);
        if(array_key_exists('cliente_de_paso',$d) && !empty($d['cliente_de_paso']) )
            $cliente.=" (de paso)";



        $input_disabled = "";
        $input_disabled_class = "";



        if($d['conversion_tipo_cambio'] > 0) {
            $d['debe'] = echonf($d['debe']/* / $d['conversion_tipo_cambio']*/, true, 2, "");
            $d['moneda_id'] = 2;
            $moneda_final = 'USD';
        }

        if($d['moneda_id']==2)
            $moneda='USD';
        else
            $moneda='PESOS';

        $moneda_final = $moneda;

        $moneda_class_ = $moneda_class = $moneda=='USD'?'lbl_doc_usd':'lbl_doc_pesos';

        $d_quantity = $d['quantity'];
        $d_debe = $d['debe'];
        $d_total_payments = $d['total_payments'];
        $tr_border = "border_transparent";
        $title_ = "";
        $input_tag = "input";
        $val_ = "";
        $input_hidden = "<input type='hidden' data-conversion_tipo_cambio='$d[conversion_tipo_cambio]' value='$d[conversion_tipo_cambio]' id='acDoc_$tabla"."_conversion_tipo_cambio_$d[id]' />";
        $input_id = "acDoc_$tabla"."_$d[id]";
        $input_data_autonumeric = "data-autonumeric=\"{mNum:10,mDec:2,aSep:',',vMin:'0.00',vMax:'$d_debe'}\"";
//        $title_disp = "";

        if($d_debe != $d_quantity){
            $title_ = "Usado " . echonf($d_total_payments, true) . " $moneda, disponible " . echonf($d_debe, true) ." $moneda.";
        }
        else
            $title_ = "Disponible " . echonf($d_debe, true) ." $moneda.";

        if($data['doc_moneda'] == 1 && $d['moneda_id'] == 1 && $d['conversion_tipo_cambio'] > 1) {
            $input_disabled = " disabled=\"disabled\" ";
            $input_disabled_class = "input_disabled";
        }

        if($d['no_aplicable'] == 1){
            $input_disabled = " disabled=\"disabled\" ";
            $input_disabled_class = "";
            $d_quantity = $d_debe = 0;
            $tr_border = "border_gray_solid";
            $moneda_class = "txt_shadow_violeta";
            $title_ = "Vale no aplicable";
            $input_tag = "span";
            $val_ = "NO APLICABLE";
            $input_hidden = "";
            $input_id = "";
            $input_data_autonumeric = "";
        }

        $acta_moneda_id = $d['moneda_id'];
        $acta_tipo_cambio = $d['conversion_tipo_cambio'];
        $acta_tipo_cambio = !$acta_tipo_cambio ? $gIAParametros["tc"] : $acta_tipo_cambio;
        $acta_monto_max = $d_debe;
        $acta_monto_max_ori = $d_debe;

        if($acta_moneda_id != $doc_moneda && $acta_tipo_cambio > 0){
            if($doc_moneda == 1){
                $acta_monto_max = ($docto_saldo / $acta_tipo_cambio) + $gIAParametros['tolerancia_pago_documentos_usd'];
            }
            else{
                $acta_monto_max = ($docto_saldo * $acta_tipo_cambio) + $gIAParametros['tolerancia_pago_documentos_pesos'];
            }

        }
        else {

            if ($acta_moneda_id == 2) {
                $acta_monto_max = $docto_saldo + $gIAParametros['tolerancia_pago_documentos_usd'];
            } else {
                $acta_monto_max = $docto_saldo + $gIAParametros['tolerancia_pago_documentos_pesos'];
            }

        }
        $acta_monto_max = $acta_monto_max > $acta_monto_max_ori ? $acta_monto_max_ori : $acta_monto_max;
        $input_monto_maximo = "Máximo a utilizar " . number_format($acta_monto_max, 2, '.', ',') . " $moneda";

        $input_monto_doc = "<$input_tag autocomplete='off' size=12 type=text class='$moneda_class bold txt_right_aligned txt_1_1em vx_numeric ignore-val  $input_disabled_class' data-moneda_id='$d[moneda_id]' $input_data_autonumeric name='acDoc_$tabla"."_$d[id]' id='$input_id' data-total='1'  value='0.000' data-quantity='$d_quantity' data-debe='$d_debe' data-conversion_tipo_cambio='$d[conversion_tipo_cambio]' data-max='$d_debe' data-min='0' onchange='ia_validate_field(this)' onkeyup='set_monto_max_input_vale(this.id); return true;' onfocus='invalidaTodoslosDemasVales(this.id);' $input_disabled >$val_</$input_tag>$input_hidden";

        $docsEncontrados .= "
                    <tr class='$tr_border'>
                    <td class='txt_centered' style='height: 32px;'><a class='tooltip_toolbar_wohtml' title='Abrir el Vale' href='../backoffice/vale.php?iah=e&id=$d[id]' target='_blank' tabindex='-1'><strong class='bold txt_1_1em $moneda_class_'>".ia_htmlentities($d['numero'])."</strong></a>"
            ."<td><strong>$cliente</strong>"
            ."<td class='$moneda_class_ tooltip_toolbar_wohtml' style='text-align:right;' title = '$title_'><strong>".number_format($d['quantity'],2,'.',',')." $moneda</strong>"
            ."<td class='". ($d['conversion_tipo_cambio'] > 1?'txt_color_USD txt_1_1em':'txt_white') ."' style='text-align:right; color:".($d['conversion_tipo_cambio'] > 1?'#319e31':'white').";'><strong>$d[conversion_tipo_cambio]</strong>"
            ."<td class='txt_1_2em txt_right_aligned $moneda_class_' style='text-align:right;'><strong>".number_format($d['debe'],2,'.',',')." $moneda_final</strong>"
            ."<td class='txt_right_aligned' >$input_monto_doc"
            ."<td class='txt_1_2em txt_right_aligned $moneda_class_'><strong id='queda_$d[id]'>".number_format($d['debe'],2,'.',',')."</strong>"
            ."<td class='txt_1em $moneda_class_' style='padding: 0;'><strong>$moneda_final</strong>";
    }

    if($docsEncontrados != '')
        $docsEncontrados = "<tr><th style='width: 80px;'><strong>Vale Number</strong><th style='width:230px;'><strong>Cliente</strong><th style='width:220px; max-width:220px;'><strong>Monto original</strong><th style='width:150px;'><strong>Tipo Cambio</strong><th style='width:220px;max-width:220px;'><strong>Monto disponible</strong><th  style='width:220px;'>Usar<th style='width:190px;max-width:190px;'>Saldo<th style='width:40px;max-width:40px;'>&nbsp;<tr><td colspan='8'><hr /></td> ".$docsEncontrados;
    return $docsEncontrados;
}

function obten_remarks_banco_cuenta_trans($deposito_banco_cuenta_mov_id=""){

    $ret_arr = array(
        'referencia_destino' => "",
        'referencia_origen' => "",
        'sql' => array(),

    );

    $sql = array();

    $bcm_id = $bcmd_id = $deposito_banco_cuenta_mov_id;

    $sql_link = "SELECT * FROM banco_cuenta_mov_link WHERE link_to='banco_cuenta_mov' AND banco_cuenta_mov_id = ".strit($bcmd_id);
    $bc_link = ia_singleton($sql_link);
    $bcml_id = $bc_link['banco_cuenta_mov_link_id'] ?? '';

    $sql_trans = "SELECT * FROM banco_cuenta_trans WHERE banco_cuenta_mov_link_id = ".strit($bcml_id);
//    echo "<pre>$sql_trans</pre>";
    $bc_trans = ia_singleton($sql_trans);
//    echo "<pre>vddB" . print_r($bc_trans, true) . "</pre>";
    $bcmo_id = $bc_link['link'] ?? '';

//Primero buscamos el movimiento original. Haremos una función mejor.
    $sqlo = "SELECT * FROM banco_cuenta_mov WHERE banco_cuenta_mov_id = ".strit($bcmo_id);
//    echo "<pre>$sqlo</pre>";
    $bcmo = ia_singleton($sqlo);


    $refo_ = ""; //$bcmo['remarks'] ?? '';
    $refo_ = empty($refo_) ? $refo_ : "$refo_<br data-remarks='mitternacht' />";
    $refo_ = addslashes($refo_);

    if(empty($bcmo_id) || strlen($bcmo_id) < 32)
    {
        $arrTransaBancoacciones["Status"] = 'Error';
        $arrTransaBancoacciones["Error"] = "<strong>LINK NO ACEPTADO.<br/><br/>No se encontró el movimiento origen.</strong>";
        ia_errores_a_dime();
        die(json_encode($arrTransaBancoacciones));
    }

    $arrDestino = ia_singleton("SELECT bc.nombre as banco, bc.empresa_id, e.empresa as empresa FROM banco_cuenta bc LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id WHERE bc.banco_cuenta_id = '$bc_trans[destino_banco_cuenta_id]'");
    $arrOrigen = ia_singleton("SELECT bc.nombre as banco, bc.empresa_id, e.empresa as empresa FROM banco_cuenta bc LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id WHERE bc.banco_cuenta_id = '$bc_trans[origen_banco_cuenta_id]'");

    $ctaBancariaDestino = $arrDestino['banco'];
    $ctaBancariaOrigen = $arrOrigen['banco'];

    $empresaDestino = $arrDestino['empresa'];
    $empresaOrigen = $arrOrigen['empresa'];

    $empidDestino = $arrDestino['empresa_id'];
    $empidOrigen = $arrOrigen['empresa_id'];

    $bcmoID = "&banco_cuenta_mov_id=$bcmo_id";
    $bcmID = "&banco_cuenta_mov_id=$bcm_id";

    $banco_mov_tipo_id = 18;

//Ponemos la descripción de la transferencia. Principalmente por si es con distinta moneda.
    $txt_moneda_origen = $bc_trans['origen_moneda_id'] == 1 ? "PESOS" : "USD";
    $txt_moneda_destino = $bc_trans['moneda_id'] == 1 ? "PESOS" : "USD";
    $class_moneda_origen = $bc_trans['origen_moneda_id'] == 1 ? "txt_shadow_azul_marino" : "txt_shadow_verde";
    $class_moneda_destino = $bc_trans['moneda_id'] == 1 ? "txt_shadow_azul_marino" : "txt_shadow_verde";

    if($empidOrigen != $empidDestino)
    {
        //Datos extra por si es pago de una empresa a otra.
        $cliente =  $empresaDestino;
        $factura_numero = "123456";
        $factura = "FACTURA";
        $tipo_cash_nota = "OTRO";
        $cash_nota_num = "NUESTRO";
        $cliente_rfc = "";
        $empresa_id = $empidDestino;
        $iva_incluido = "NO";
        $ivacobradox100 = "0";
        $ivacobradototal = 0;

        $banco_cuenta = ia_singleton("SELECT tipo_inversion_empresa_privada FROM banco_cuenta WHERE banco_cuenta_id = ". strit($ctaBancariaDestino));

        $tipo_inversion_empresa_privada = $banco_cuenta['tipo_inversion_empresa_privada'] ?? 'empresa';

        $txt_factura = "FACTURA";
        if("privada"){
            $iva_incluido = "NO";
            $ivacobradox100 = "0";
            $ivacobradototal = 0;
            $txt_factura = "SEMANA";
            $factura = "ASIMILADOS";
        }


        $refd = $refo = "<strong class='txt18pxfr txt_bold_red txt_centered' style='min-width: 335px;'>" . strip_tags($bc_trans['referencia'])."</strong>\r\nPAGO DE <a title='$ctaBancariaOrigen' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$bc_trans[origen_banco_cuenta_id]$bcmoID' target='_blank' class='$class_moneda_origen'><strong>$empresaOrigen</strong></a> A <a title='$empresaDestino' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$bc_trans[destino_banco_cuenta_id]$bcmID' target='_blank' class='$class_moneda_destino'><strong>$empresaDestino</strong></a>\r\n<br />$txt_factura $factura_numero";

        $banco_mov_tipo_id = 24;
    }
    else
    {
        $cliente =  "";
        $factura_numero = "";
        $factura = "NUESTRO";
        $tipo_cash_nota = "OTRO";
        $cash_nota_num = "PROPIAS";
        $cliente_rfc = "";
        $empresa_id = $empidDestino;
        $iva_incluido = "NO";
        $ivacobradox100 = 0;
        $ivacobradototal = 0;

        $refd = $refo = "<strong class='txt18pxfr txt_bold_red txt_centered' style='min-width: 335px;'>TRASPASO ENTRE CUENTAS PROPIAS</strong><br>TRANSFERENCIA ENTRE CUENTAS PROPIAS, DE <a title='$ctaBancariaOrigen' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$bc_trans[origen_banco_cuenta_id]$bcmoID' target='_blank' class='$class_moneda_origen'><strong>$ctaBancariaOrigen</strong></a> A <a title='$ctaBancariaDestino' href='../cobranza/edocta.php?ACC=CB&ECO=SI&banco_cuenta_id=$bc_trans[destino_banco_cuenta_id]$bcmID' target='_blank' class='$class_moneda_destino'><strong>$ctaBancariaDestino</strong></a>";
    }



    if($bc_trans['origen_moneda_id']!=$bc_trans['moneda_id'])
    {
        $refd = $refo .= "<br><li>MONTO ORIGEN: <span class='bold $class_moneda_origen'>$ " . echonf($bc_trans['monto_origen'], true) . " $txt_moneda_origen</span><li>MONTO DESTINO: <span class='bold $class_moneda_destino'>$ " . echonf($bc_trans['monto'], true) . " $txt_moneda_destino</span> <li>TIPO DE CAMBIO: <strong>" . echonf($bc_trans['tipo_cambio'], true, 4)."</strong>";
    }
    else
    {
        $refd = $refo .= "\r\n<br /><li>MONTO: <span class='bold $class_moneda_destino'>$ " . echonf($bc_trans['monto'], true) . " $txt_moneda_destino</span>";
    }

//    $refo = addslashes($refo);
//    $refd = addslashes($refd);



    $ret_arr['referencia_origen'] = "$refo_ $refo";
    $ret_arr['referencia_destino'] = $refd;
//    echo $refo."<br><hr/>";
//    echo $refd;
    return $ret_arr;
}

function actualiza_china_orders_excel($debug = false): bool
{

    $method = __METHOD__;

//    $pathUF = "";

    $archivo = "\\\\T420SATA\\B\\VITEX_FILES\\CHINA ORDERS 2023.xlsx";
    $archivo_ori = "\\\\T420SATA\\Rony$\\WALLPAPER\\_IMPORT\\CHINA ORDERS 2023.xlsx";

    clearstatcache();
    if (!file_exists($archivo_ori)) {
        ia_errores_a_dime("<li>No existe el archivo: $archivo_ori", $method);
//        echo "<li>No existe el archivo pegador: $archivo";
        return false;
    }



    $lastModifiedTime = filemtime($archivo_ori);

    // Format the Unix timestamp to a readable date
    $formattedDate = date('Y-m-d H:i:s', $lastModifiedTime);

    if(!copy($archivo_ori,$archivo))
    {
        $errors= error_get_last();
        $msg = "COPY ERROR: ".$errors['type'];
        $msg .= "<br />\n".$errors['message'];
        ia_errores_a_dime("$msg", $method);
        $archivo = $archivo_ori; //failsafe
    }

    clearstatcache();
    if (!file_exists($archivo)) {
        ia_errores_a_dime("<li>No existe el archivo: $archivo", $method);
        return false;
    }

    if ($xlsx = SimpleXLSX::parse($archivo)) {

        $cuantas_hojas = $xlsx->sheetsCount();
        for ($i = 1; $i <= $cuantas_hojas; $i++) {
            if ($xlsx->sheetName($i) === 'CHINA') {
//            echo "EUREKA $i";
//            echo "<pre>".print_r($xlsx->rows($i), true)."</pre>";
                $count_mar = $xlsx->getCell($i, "E4");
                $sum_mar = $xlsx->getCell($i, "E5");

//                echo "<li>En el mar count: $count_mar";
//                echo "<li>En el mar sum: $sum_mar";
                $china_sql = [];
                $china_sql[] = ia_insert("campos_kv", array("concepto" => "EN EL MAR", "valor" => "$sum_mar", "fecha" => date("Y-m-d"), "alta_db" => "CURRENT_TIMESTAMP"), autoOnUpdate: true);
                $china_sql[] = ia_insert("campos_kv", array("concepto" => "LASTMODIFIEDTIME", "valor" => "$formattedDate", "fecha" => date("Y-m-d"), "alta_db" => "CURRENT_TIMESTAMP"), autoOnUpdate: true);
//                echo "<li>china_sql: $china_sql";

                if(ia_transaction($china_sql)){
                    ia_errores_a_dime("<li>Error al insertar: " . print_r($china_sql, true), $method);
                }

                if($debug){
                    $msg = "<li>En el mar count: $count_mar";
                    $msg .= "<li>En el mar sum: $sum_mar";
                    $msg .= "<li>china_sql: ". print_r($china_sql, true);
                    ia_errores_a_dime("$msg", $method);
                }
            }
        }
    }
    else{
        ia_errores_a_dime("<li>No se pudo parsear SimpleXLSX::parse($archivo)", $method);
    }

    return true;
}

/**
 * limpia_clientes_cobranza()
 *
 * This method updates the 'receive_cheques' flag for clients in the 'cliente' table
 * to 0, if the following conditions are met:
 * - 'receive_cheques' is currently set to 1
 * - 'cheques_totales' is 0
 * - 'pagares_totales' is 0
 * - 'vales_totales' is 0
 *
 * @return bool Returns true if the update operation is successful, false otherwise.
 */
function limpia_clientes_cobranza(): bool
{
    $sql = "update cliente set receive_cheques = 0, ultimo_cambio=NOW(), ultimo_cambio_por=". strit($_SESSION["usuario"]) ." where receive_cheques = 1 and cheques_totales = 0 and pagares_totales = 0 and vales_totales = 0";
    ia_query($sql);

    return true;
}

/**
 * checkHeadersforFireandForget()
 *
 * This method checks the headers for the "User-Agent" value and terminates the execution
 * if it does not match the expected value "OnWhomTheMoonDothShine".
 *
 * @return void
 */
function prepareForAsyncRequest(): void
{
    ignore_user_abort(true);
    session_write_close();

    if (!validUserAgent()) exit;

    header("Connection: close\r\n");
    header("Content-Encoding: none\r\n");
    header("Content-Length: 1");
    ### we just close connect above if webbrowser, or request waiting on answer ( we know we set CURLOP to not wait) ###
    ob_end_clean();
}

function validUserAgent(): bool
{
    $headers = getallheaders();
    $userAgent = $headers['User-Agent'] ?? '';
    return strcasecmp($userAgent, "OnWhomTheMoonDothShine") === 0;
}

function getParamssqlData(){
    $params = param("sqlData", array());
    $params = urldecode($params);
    return json_decode($params);
}


function cancela_y_agrega_cuentaTMov($item_db, &$diff, $cuentaT_mov_id, $mov_entrada_salida = 'entrada', $remarks_ctatmov = '', $app_origen = 'Ingreso Directo')
{
    $sql = [];
    // $usuario = $_SESSION['usuario'];
    if(isset($diff['fecha']) || isset($diff['monto']))
    {
        $cgCancID=ia_guid();
        $cgNvoID=ia_guid();
        $cuentat_mov_db = ia_singleton("SELECT * FROM cuentat_mov WHERE cuentaT_mov_id = '$cuentaT_mov_id'");

        $sql[]="UPDATE cuentat_mov SET contra_mov_id='$cgCancID', activo='No' WHERE cuentaT_mov_id='$cuentaT_mov_id'";
        $sql[]="UPDATE cuentat_mov_live SET contra_mov_id='$cgCancID', activo='No' WHERE cuentaT_mov_id='$cuentaT_mov_id'";

        $monto_set = $diff['monto']??$item_db['monto'];
        $remarks = prepareRemarks($diff, $item_db)['remarks']??'';

        $fecha_nuevo_mov = date('Y-m-d H:i:s');
        $fecha_cancelacion = addSeconds($fecha_nuevo_mov, -1);

        if (isset($diff['fecha'])) {
            $fecha_mov_original = $cuentat_mov_db['fecha'];
            $fecha_nueva = (explode(" ", $diff['fecha'])[0])." ". explode(" ", $fecha_mov_original)[1];
            if (strtotime($fecha_nueva)<strtotime($fecha_mov_original)) {
                $fecha_nuevo_mov = $fecha_nueva;
                $fecha_cancelacion = addSeconds($fecha_mov_original, 1);
            }
        }

        //Hacemos un Egreso para cancelar el movimiento en la cuenta T.
        $cuentat_mov = cuentat_mov_default_record(
                $cgCancID,
                $item_db['monto'],
                $mov_entrada_salida==='entrada'?'Egreso':'Ingreso',
                $item_db['moneda_id']??1,
                $item_db['tipo_cambio']??1,
                $fecha_cancelacion);
        $cuentat_mov["cuentaT_tipo_mov_id"]=$item_db['cuentaT_tipo_mov_id'];
        $cuentat_mov["cuentaT_id"]=$item_db['cuentaT_id'];
        $cuentat_mov["origen_mov_id"]=$item_db['activo_cuentaT_mov_id'];
        $cuentat_mov["contra_mov_id"]=$item_db['activo_cuentaT_mov_id'];
        $cuentat_mov["quantity_total"]=$item_db['monto'];
        $cuentat_mov["remarks"]=$remarks;
        $cuentat_mov["activo"]='No';
        $cuentat_mov["solo_rony"]='No';
        $cuentat_mov["app_origen"]=$app_origen;
        $sql[]=ia_insert('cuentat_mov',$cuentat_mov);

        //Hacemos nuevamente el gasto.
        //Registramos una entrada en la cuenta t.
        $cuentat_mov = cuentat_mov_default_record(
                $cgNvoID,
                $monto_set,
                $mov_entrada_salida==='entrada'?'Ingreso':'Egreso',
                $item_db['moneda_id']??1,
                $item_db['tipo_cambio']??1,
                $fecha_nuevo_mov);
        $cuentat_mov["cuentaT_tipo_mov_id"]=$item_db['cuentaT_tipo_mov_id'];
        $cuentat_mov["cuentaT_id"]=$item_db['cuentaT_id'];
        $cuentat_mov["origen_mov_id"]='';
        $cuentat_mov["quantity_total"] = $monto_set;
        $cuentat_mov["remarks"]=$remarks_ctatmov;
        $cuentat_mov["app_origen"]=$app_origen;
        $cuentat_mov["activo"]='Si';
        $cuentat_mov["solo_rony"]='No';
        $cuentat_mov["tienda_id"]=$item_db['tienda_id']??1; //1 es OFI
        $cuentat_mov["alta_db"]=$fecha_nuevo_mov;
        $sql[]=ia_insert('cuentat_mov',$cuentat_mov);

        $diff['activo_cuentaT_mov_id']=$cgNvoID;
    }

    return $sql;
}

function prepareRemarks($diff, $item_db, $fecha_completa = false)
{
    $labels = [];
    $campos_numero = ['monto', 'quantity', 'total', 'egreso', 'quantity_total'];
    $campos_fecha = ['fecha', 'alta_db', 'ultimo_cambio'];
    $usuario = $_SESSION['usuario'];

    $remarks = [];
    foreach ($diff as $key => $value) {
        $valor_db = $item_db[$key];
        $label = $labels[$key]??(str_replace(["_", "ID"], [" ", ""], strtoupper($key)));
        if (in_array($key, $campos_numero)) {
            $value = echonf(limpiaCantidad_($value), true);
        }
        if (in_array($key, $campos_fecha) && !$fecha_completa) {
            $valor_db = explode(" ", $valor_db)[0];
            $value = explode(" ", $value)[0];
        }
        $remarks[] = "$label de <b>$valor_db</b> A <b>$value</b>";
    }
    return [
        'remarks' => "$usuario CAMBIÓ ".implode("<br>", $remarks),
        'items' => $remarks
    ];
}

/**
 * sortByErrorAndDate()
 *
 * Sorts an array by 'fue_error' and 'alta_db' fields in descending order.
 * The 'fue_error' field is sorted such that 'No' comes before 'Si'.
 *
 * @param array $array The array to be sorted. Passed by reference.
 * @return void
 */
function sortByErrorAndDate(array &$array): void
{
    usort($array, function($a, $b) {
        // Sort by 'fue_error' DESC ('No' before 'Si')
        if ($a['fue_error'] !== $b['fue_error']) {
            return ($a['fue_error'] === 'No') ? -1 : 1;
        }
        // If 'fue_error' is the same, sort by 'alta_db' DESC
        return strcmp($b['alta_db'], $a['alta_db']);
    });
}

function updateMaxMinCountAll(): void
{
    $sql_numeros_bodegas = [];
    $sql_bodegas = ia_sqlArrayIndx("SELECT bodega_id FROM bodega WHERE activo='Si'");
    foreach($sql_bodegas as $key => $value){
        $bodega_id = $value['bodega_id'];
        $sql_numeros_bodegas[] = updateMaxMinCount($bodega_id, false);
    }
    unset($key);
    unset($value);

    $sql_bodega_grupo_verificador = ia_sqlArrayIndx("SELECT bodega_grupo_verificador_id FROM bodega_grupo_verificador WHERE 1 ORDER BY bodega_grupo_verificador_id");

    foreach($sql_bodegas as $key => $value){
        $bodega_id = $value['bodega_id'];
        foreach($sql_bodega_grupo_verificador as $keyv => $valuev){
            $bodega_grupo_verificador_id = $valuev['bodega_grupo_verificador_id'];
            $sql_numeros_bodegas[] = updateMaxMinCount($bodega_id, false, true, $bodega_grupo_verificador_id);
        }
    }
//    echo "<pre>" . print_r($sql_numeros_bodegas, true) . "</pre>";

    ia_transaction($sql_numeros_bodegas);
}

/**
 * Update the maximum and minimum count values for a given bodega.
 *
 * @param mixed $bodega_id The ID of the bodega.
 * @param bool $do_sql Optional. Whether or not to execute the SQL query. Defaults to true.
 * @param bool $es_verificacion Optional. Whether or not the bodega is a verification. Defaults to false.
 * @param int $bodega_verificador_id Optional. The ID of the bodega_verificador. Defaults to 0.
 * @return bool|string Returns false if the bodega_id is empty, otherwise returns true.
 */
function updateMaxMinCount($bodega_id, $do_sql = true, $es_verificacion = false, $bodega_verificador_id = 0): bool|string
{
    $method = __FUNCTION__;

    if (empty($bodega_id)) {
        return false;
    }

    $nota_bodega_tabla = !$es_verificacion ? "nota_bodega" : "nota_bodega_verificacion";
    $where_bodega_verificador = !$es_verificacion ? "" : " AND bodega_verificador_id = " . strit($bodega_verificador_id);

    // $numerosMinMax = ia_singleton(
    //     "SELECT /*$method numerosMinMax*/ MAX(numero_real) as max_num, MIN(numero_real) as min_num FROM $nota_bodega_tabla WHERE bodega_id = " . strit($bodega_id) . $where_bodega_verificador);

    $numerosMinMax['ultimo_cambio'] = Date('Y-m-d H:i:s');
    $numerosMinMax['ultimo_cambio_por'] = $_SESSION['usuario_id'];
    $numerosMinMax['bodega_id'] = $bodega_id;
    // $numerosMinMax['min_num'] = $numerosMinMax['min_num'] === '0' ? '1' : $numerosMinMax['min_num'];
    // $numerosMinMax["maximo_numero_all"] = ltrim($numerosMinMax['max_num'] ?? "0", '0 ');
    // $numerosMinMax["minimo_numero_all"] = ltrim($numerosMinMax['min_num'] ?? "0", '0 ');
    // $numerosMinMax["nv_all"] = ltrim($numerosMinMax['max_num'] ?? "0", '0 ');

    $numerosMinMaxEntradaSalida = ia_sqlSelectMultiKey(
        "SELECT /*$method numerosMinMaxEntradaSalida*/ entrada_salida as k1, count(*) total, MAX(numero_real) as max_num, MIN(numero_real) as min_num FROM $nota_bodega_tabla WHERE bodega_id = " . strit($bodega_id) . $where_bodega_verificador . " AND tipo NOT IN ('Cancelacion', 'Correccion', 'Borrado') GROUP BY entrada_salida", 1);

    $numerosMinMax["maximo_numero_entrada"] = ltrim($numerosMinMaxEntradaSalida['Entrada']['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_entrada"] = ltrim($numerosMinMaxEntradaSalida['Entrada']['min_num'] ?? "0", 0);
    $numerosMinMax["nv_entrada"] = ltrim($numerosMinMaxEntradaSalida['Entrada']['total'] ?? "0", 0);

    $numerosMinMax["maximo_numero_salida"] = ltrim($numerosMinMaxEntradaSalida['Salida']['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_salida"] = ltrim($numerosMinMaxEntradaSalida['Salida']['min_num'] ?? "0", 0);
    $numerosMinMax["nv_salida"] = ltrim($numerosMinMaxEntradaSalida['Salida']['total'] ?? "0", 0);

    $numerosTipos = ia_sqlArray(
        "SELECT /*$method numerosPorTipoNota*/ tipo, count(*) total, MAX(numero_real) max_num, MIN(numero_real) min_num FROM $nota_bodega_tabla WHERE bodega_id = " . strit($bodega_id) . $where_bodega_verificador . " GROUP BY tipo", 'tipo');

    $numerosMinMax["maximo_numero_movimiento"] = ltrim($numerosTipos["Movimiento"]['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_movimiento"] = ltrim($numerosTipos["Movimiento"]['min_num'] ?? "0", 0);
    $numerosMinMax["nv_movimiento"] = ltrim($numerosTipos["Movimiento"]['total'] ?? "0", 0);

    $numerosMinMax["maximo_numero_devolucion"] = ltrim($numerosTipos["Devolucion"]['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_devolucion"] = ltrim($numerosTipos["Devolucion"]['min_num'] ?? "0", 0);
    $numerosMinMax["nv_devolucion"] = ltrim($numerosTipos["Devolucion"]['total'] ?? "0", 0);

    $numerosMinMax["maximo_numero_ajuste"] = ltrim($numerosTipos['Correccion']['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_ajuste"] = ltrim($numerosTipos['Correccion']['min_num'] ?? "0", 0);
    $numerosMinMax["nv_ajuste"] = ltrim($numerosTipos['Correccion']['total'] ?? "0", 0);

    $numerosMinMax["maximo_numero_traslado"] = ltrim($numerosTipos["Traslado"]['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_traslado"] = ltrim($numerosTipos["Traslado"]['min_num'] ?? "0", 0);
    $numerosMinMax["nv_traslado"] = ltrim($numerosTipos["Traslado"]['total'] ?? "0", 0);

    $min_borrado = isset($numerosTipos['Borrado']) ? $numerosTipos['Borrado']['min_num'] : null;
    $max_borrado = isset($numerosTipos['Borrado']) ? $numerosTipos['Borrado']['max_num'] : null;
    $min_cancelacion = isset($numerosTipos['Cancelacion']) ? $numerosTipos['Cancelacion']['min_num'] : null;
    $max_cancelacion = isset($numerosTipos['Cancelacion']) ? $numerosTipos['Cancelacion']['max_num'] : null;


    /**
     * Todos
     * entradas, salidas, ajuste, cancelada, borrada
     * $total_sum
     */
    // Tipos que queremos sumar
    $tipos_a_sumar = ['Correccion', 'Cancelacion', 'Borrado'];
    $total_sum = 0;

    foreach ($tipos_a_sumar as $tipo) {
        if (isset($numerosTipos[$tipo])) {
            $total_sum += intval($numerosTipos[$tipo]['total']);
        }
    }

    foreach($numerosMinMaxEntradaSalida as $es){
        $total_sum += intval($es["total"]);
    }

    $min_num_total = PHP_INT_MAX; // Mínimo
    $max_num_total = PHP_INT_MIN; // Máximo

    foreach ($numerosTipos as $item) {
        $min_num_total = min($min_num_total, $item['min_num']);
        $max_num_total = max($max_num_total, $item['max_num']);
    }

    $numerosMinMax["maximo_numero_all"] = ltrim($max_num_total, '0 ');
    $numerosMinMax['max_num'] = ltrim($max_num_total, '0 ');
    $numerosMinMax["minimo_numero_all"] = ltrim($min_num_total, '0 ');
    $numerosMinMax['min_num'] = ltrim($min_num_total, '0 ');
    $numerosMinMax["nv_all"] = ltrim($total_sum, '0 ');

    $min = null;
    $max = null;
    $total = 0;

    if ($min_borrado !== null && $min_cancelacion !== null) {
        $min = min($min_borrado, $min_cancelacion);
        $max = max($max_borrado, $max_cancelacion);
        $total = (int)$numerosTipos['Borrado']['total'] + (int)$numerosTipos['Cancelacion']['total'];
    } elseif ($min_borrado !== null) {
        $min = $min_borrado;
        $max = $max_borrado;
        $total = (int)$numerosTipos['Borrado']['total'];
    } elseif ($min_cancelacion !== null) {
        $min = $min_cancelacion;
        $max = $max_cancelacion;
        $total = (int)$numerosTipos['Cancelacion']['total'];
    }

    $numerosMinMax["maximo_numero_cancelacion_borrado"] = ltrim($max ?? "0", 0);
    $numerosMinMax["minimo_numero_cancelacion_borrado"] = ltrim($min ?? "0", 0);
    $numerosMinMax["nv_cancelacion_borrado"] = ltrim($total, 0);

    $numerosInconsistencias = [];

    if(!$es_verificacion) {
        // $numerosInconsistencias = ia_singleton(
        //     "SELECT /*$method numerosInconsistencias*/ count(DISTINCT nb.nota_bodega_id) total, MAX(nb.numero_real) as max_num, MIN(nb.numero_real) as min_num
        //         FROM nota_bodega nb
        //             JOIN inconsistencia_nota_bodega inb ON nb.nota_bodega_id = inb.nota_bodega_id AND inb.estado = 'Activo'
        //         WHERE  nb.bodega_id = " . strit($bodega_id));

        $numerosInconsistencias = ia_singleton("select /*$method inconsistencias */  count(*) total, MAX(numero_real) as max_num, MIN(numero_real) as min_num  from nota_bodega where cuenta_inconsistencias > 0 AND bodega_id =" . strit($bodega_id));

    }

    $numerosMinMax["maximo_numero_inconsistencia"] = ltrim($numerosInconsistencias['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_inconsistencia"] = ltrim($numerosInconsistencias['min_num'] ?? "0", 0);
    $numerosMinMax["nv_inconsistencia"] = ltrim($numerosInconsistencias['total'] ?? "0", 0);


    // $numerosDestinoMatchFail = ia_singleton("select MAX(nota_bodega.numero_real) as max_num, MIN(nota_bodega.numero_real) as min_num, count(DISTINCT nota_bodega.nota_bodega_id) total from nota_bodega
	// JOIN inconsistencia_nota_bodega inb ON inb.nota_bodega_id = nota_bodega.nota_bodega_id
    // where nota_bodega.bodega_id = ".strit($bodega_id)." AND inb.tipo_inconsistencia IN ('ayudantes','clientes','pedido_por') AND inb.estado = 'activo'");

    /*
    $numerosDestinoMatchFail = ia_singleton(
        "SELECT COUNT(*) total, MAX(numero_real) as max_num, MIN(numero_real) as min_num
               FROM nota_bodega
               WHERE bodega_id = ".strit($bodega_id)." AND destino_match in ('No', 'Pendiente')");
*/

    $numerosDestinoMatchFail = ia_singleton("
                    select /*$method*/ COUNT(*) total, MAX(nb.numero_real) as max_num, MIN(nb.numero_real) as min_num 
                    from nota_bodega nb
                    where nb.bodega_id = ".strit($bodega_id)." AND nb.tipo NOT IN ( 'Correccion', 'Cancelacion','Borrado') AND
                        EXISTS(
                            SELECT 1
                            FROM inconsistencia_nota_bodega inb
                            WHERE inb.nota_bodega_id = nb.nota_bodega_id AND inb.estado = 'activo'
                              AND inb.tipo_inconsistencia IN ('ayudantes','clientes','pedido_por')
                        )
                ");

    $numerosMinMax["maximo_numero_destino_match_fail"] = ltrim($numerosDestinoMatchFail['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_destino_match_fail"] = ltrim($numerosDestinoMatchFail['min_num'] ?? "0", 0);
    $numerosMinMax["nv_destino_match_fail"] = ltrim($numerosDestinoMatchFail['total'] ?? "0", 0);


    $numerosPina = [];
    if(!$es_verificacion)
    $numerosPina = ia_singleton(
        "SELECT /*$method numerosPina*/ count(DISTINCT nota_bodega.nota_bodega_id) total, MAX(numero_real) as max_num, MIN(numero_real) as min_num FROM nota_bodega WHERE tipo_nota = 'PIÑA' AND bodega_id = " . strit($bodega_id));
    $numerosMinMax["maximo_numero_pina"] = ltrim($numerosPina['max_num'] ?? "0", 0);
    $numerosMinMax["minimo_numero_pina"] = ltrim($numerosPina['min_num'] ?? "0", 0);
    $numerosMinMax["nv_pina"] = ltrim($numerosPina['total'] ?? "0", 0);

    $numerosMinMax["es_verificacion"] = $es_verificacion;
    $numerosMinMax["bodega_verificador_id"] = $bodega_verificador_id;

    $sql_insert = ia_insert("numeros_bodegas", $numerosMinMax, [], "", true);

    if($do_sql)
        return ia_query($sql_insert);
    else
        return $sql_insert;
}

function fecha_en_espanol($fecha){
    return !empty($fecha) ? get_date_spanish(strtotime($fecha), false, 'mini_date') : '';
}

/**
 * Reads data from a file with retries and optional JSON decoding.
 *
 * @param string $fileName The name of the file to read data from.
 * @param bool $decode Optional. Whether to decode the file contents as JSON. Defaults to false.
 * @return string|null Returns the file content as a string, or decoded JSON if $decode is true.
 */
function getSafeDataFromFile(string $fileName, bool $decode = false): ?string
{
//    return file_get_contents($fileName);

    $maxRetries = 3; // Number of retry attempts
    $retryDelay = 100000; // 100 milliseconds in microseconds
    $attempts = 0; // Counter to track attempts

    // Loop to attempt reading the file
    while ($attempts < $maxRetries) {
        // Increment the attempt counter
        $attempts++;

        // Check if the file exists before attempting to read it
        if (file_exists($fileName)) {
            try {
                // Try to read the file contents
                $jsonData = file_get_contents($fileName);

                if ($jsonData === false) {
                    // If file_get_contents fails, throw an exception
                    throw new Exception("Error reading the file '$fileName'.");
                }

                if(!$decode)
                    return $jsonData;

                // Decode the JSON data
                $data = json_decode($jsonData, true);

                // Check for JSON parsing errors
                if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
                    // Return null in case of JSON decoding errors
                    throw new Exception("Error decoding JSON from file '$fileName': " . json_last_error_msg());
                }

                // If everything is successful, return the decoded data
                return $data;

            } catch (Exception $e) {
                // Log the error message
//                error_log("Attempt $attempts: " . $e->getMessage());
            }
        } else {
            // Log the error if the file doesn't exist
            break;
//            error_log("Attempt $attempts: File '$fileName' does not exist.");
        }

        // If it fails, wait 100 milliseconds before retrying
        usleep($retryDelay);
    }

    // If all attempts fail, return null
    return null;
}

function safeDeleteFile($fileName): bool
{
    // Check if the file exists before attempting to delete it
    if (!file_exists($fileName)) {
        // If the file doesn't exist, log the error and return immediately
//        error_log("File '$fileName' does not exist.");
        return false;
    }

    $maxRetries = 3;  // Number of retry attempts
    $retryDelay = 100000;  // 100 milliseconds in microseconds
    $attempts = 0;  // Counter to track attempts

    // Loop to attempt file deletion
    while ($attempts < $maxRetries) {
        // Increment the attempt counter
        $attempts++;

        try {
            // Try to delete the file
            if (unlink($fileName)) {
                // Return true if the file was successfully deleted
                return true;
            } else {
                // If unlink() fails, throw an exception
                throw new Exception("Error deleting the file '$fileName'.");
            }
        } catch (Exception $e) {
            // Log the error message and attempt count
//            error_log("Attempt $attempts: " . $e->getMessage());
        }

        // If deletion fails, wait 100 milliseconds before retrying
        usleep($retryDelay);
    }

    // If all attempts fail, return false
    return false;
}

function removeBrTags($str): array|string|null
{
    return preg_replace('/\s*<br\s*\/?>\s*/i', "\n", $str);
}

function trimAndAddNewLineAndBR(string $str): string
{
    // Replace all variations of line endings with "\n" and collapse multiple newlines into one
    $str = preg_replace("/\r\n|\r|\n/", "\n", $str);  // Normalize line endings to "\n"
    $str = preg_replace("/\n{2,}/", "\n", $str);      // Replace multiple newlines with a single "\n"

    // Split the string by single "\n", trim each line, and add "<br>\r\n" if not empty
    $result = array_filter(array_map(function($line) {
        $trimmedLine = trim($line);
        return $trimmedLine !== '' ? $trimmedLine . "<br>\r\n" : null;
    }, explode("\n", $str)));

    // Join the array back into a single string
    return removeDoubleBrTags(implode("", $result));
}

function removeDoubleBrTags($str): array|string|null
{
    return preg_replace('/(<br\s*\/?>\s*){2,}/i', '<br>', $str);
}

function firstNonEmpty(array $elements, $defaultValue = null) {
    foreach ($elements as $element) {
        if (!empty($element)) {
            return $element;
        }
    }
    return $defaultValue;
}

function details_parse_to_regex($options=[])
{
    $parse = [];
    $lis = [];
    foreach ($options as $regex) {
        $parse[$regex] = $regex;
        if (preg_match('/^\/.*\/$/', $regex) || str_contains($regex, '*')) {
            $parse[$regex] = htmlspecialchars(vx_parse_str_to_regex($regex));
        }
        $lis[] = "<b>$regex</b> => ".htmlspecialchars($parse[$regex]);
    }
    $lis = implode("<li>", $lis);
    $html = "<details class='default' style='margin: 1em'><summary>Diccionario de REGEX</summary><ul style='color:black;font-weight: normal'><li>$lis</ul></details>";
    return $html;
}

function vx_parse_str_to_regex($string): array|string
{
    $find_to_replace = [
        '|' => '/',
        // '*' => "\d+", // numeros
        '*' => '.*', // cualquier caracter
    ];
    $regex_parse = str_replace(array_keys($find_to_replace), array_values($find_to_replace), $string);
    if ($regex_parse[0] !=='/')
        $regex_parse = '/'.$regex_parse;

    if ($regex_parse[strlen($regex_parse)-1] !=='/')
        $regex_parse = $regex_parse.'/';
    
    return $regex_parse;
}

function ensurePathExists(string $path): bool
{
    // Determine the directory part of the path
    $directory = is_dir($path) ? $path : dirname($path);

    // Check if the directory already exists
    if (!is_dir($directory)) {
        // Attempt to create the directory recursively
        if (!mkdir($directory, 0755, true)) {
            // Return false if directory creation failed
            return false;
        }
    }

    // Return true if directory exists or was successfully created
    return true;
}
function vx_parse_str_to_regex_mysql($string): array|string
{
    $find_to_replace = [
        // '*' => "[0-9]+", // numeros
        '\d+' => "[0-9]+", // numeros
        '*' => '.*', // cualquier caracter
    ];
    return str_replace(array_keys($find_to_replace), array_values($find_to_replace), $string);
}

function obtenerFechaHoradeBackup(): array|string
{
    // If function estoyEnServidor() exists and returns true, return current datetime
    if (estoyEnServidor()) {
        return date('Y-m-d H:i:s');
    }

    // Path to the SQL backup folder
    $backupFolder = 'C:\\sqlbckup';

    // Get the latest SQL file
    $latestFile = null;
    $latestTime = null;

    foreach (glob("$backupFolder/*.sql") as $file) {
        // Extract datetime from filename
        if (preg_match('/(\d{4}-\d{2}-\d{2} \d{2}-\d{2}-\d{2})/', $file, $matches)) {
            $fileTime = str_replace('-', ':', $matches[1]); // Convert filename format to datetime format
            if ($latestTime === null || strtotime($fileTime) > strtotime($latestTime)) {
                $latestTime = $fileTime;
                $latestFile = $file;
            }
        }
    }

    // If no valid files found, return an error message
    return $latestTime ? $latestTime : 'No valid SQL backups found';
}

function runDBQueriesforComparing(): array
{
    // Define the SQL queries
    $queries = [
        ["table" => "a_cuentas_live", "count" => "doc_pago_id", "sum" => "quantity", "condition" => "activo = 'Si'"],
        ["table" => "ajuste", "count" => "ajuste_id", "sum" => "existencia_rollos_queda", "condition" => "cancelado = 'No'"],
        ["table" => "ayudantes", "count" => "ayudante_id", "sum" => null, "condition" => null],
        ["table" => "banco", "count" => "banco_id", "sum" => null, "condition" => null],
        ["table" => "banco_cuenta", "count" => "banco_cuenta_id", "sum" => null, "condition" => "vale = 'Active'"],
        ["table" => "banco_cuenta_mov", "count" => "banco_cuenta_mov_id", "sum" => "deposit + withdrawal", "condition" => null],
        ["table" => "banco_cuenta_mov_link", "count" => "banco_cuenta_mov_link_id", "sum" => null, "condition" => null],
        ["table" => "banco_cuenta_saldos", "count" => "banco_cuenta_id", "sum" => "saldo_actual", "condition" => "banco_cuenta_id > 0 AND banco_cuenta_id IN (SELECT banco_cuenta_id FROM banco_cuenta WHERE vale='Active')"],
        ["table" => "banco_cuenta_trans", "count" => "banco_cuenta_trans_id", "sum" => "monto", "condition" => "activo = 'Si'"],
        ["table" => "banco_diccionario_dato", "count" => "banco_diccionario_dato_id", "sum" => null, "condition" => null],
        ["table" => "banco_gasto_diccionario_dato", "count" => "banco_gasto_diccionario_dato_id", "sum" => null, "condition" => null],
        ["table" => "bodega", "count" => "bodega_id", "sum" => null, "condition" => "activo = 'Si'"],
        ["table" => "bodega_existencia_diaria", "count" => "existencia_rollos", "sum" => "existencia_rollos", "condition" => null],
        ["table" => "bodega_existencia_mensual", "count" => "bodega_existencia_mensual_id", "sum" => "existencia_rollos", "condition" => null],
        ["table" => "bodega_x_dia", "count" => "bodega_fecha_id", "sum" => "Existencia_Rollos", "condition" => null],
        ["table" => "cheque", "count" => "cheque_id", "sum" => "quantity", "condition" => null],
        ["table" => "cheque_log", "count" => "cheque_id", "sum" => null, "condition" => null],
        ["table" => "cheque_pago", "count" => "cheque_pago_id", "sum" => "quantity", "condition" => null],
        ["table" => "cheque_pago_log", "count" => "cheque_pago_log_id", "sum" => null, "condition" => null],
        ["table" => "cliente", "count" => "cliente_id", "sum" => "saldo_cliente_usd", "condition" => "vale = 'Active'"],
//        ["table" => "clientes_saldos_live", "count" => "cliente_id", "sum" => "saldo_cliente_usd", "condition" => null],
        ["table" => "color", "count" => "color_id", "sum" => null, "condition" => null],
        ["table" => "cuentat", "count" => "cuentaT_id", "sum" => "on_hand_mx", "condition" => null],
        ["table" => "cuentat_a_banco", "count" => "cuentat_a_banco_mov_id", "sum" => "egreso", "condition" => null],
        ["table" => "cuentat_a_banco_tc", "count" => "cuentat_a_banco_tc_mov_id", "sum" => "egreso", "condition" => null],
        ["table" => "cuentat_gasto", "count" => "cuentat_gasto_id", "sum" => "egreso", "condition" => null],
        ["table" => "cuentat_ingreso", "count" => "cuentat_ingreso_id", "sum" => "monto", "condition" => null],
        ["table" => "cuentat_mov", "count" => "cuentaT_mov_id", "sum" => "egreso + monto", "condition" => null],
        ["table" => "cuentat_mov_live", "count" => "cuentaT_mov_id", "sum" => "egreso + monto", "condition" => null],
        ["table" => "cuentat_transfer", "count" => "cuentat_transfer_id", "sum" => "monto", "condition" => null],
        ["table" => "empresa", "count" => "empresa_id", "sum" => null, "condition" => null],
        ["table" => "fiduciario", "count" => "fiduciario_id", "sum" => "saldo", "condition" => "terminado = 'No'"],
        ["table" => "fiduciario_contenedor", "count" => "fiduciario_contenedor_id", "sum" => "monto_garantia - monto_reembolsado", "condition" => "terminado = 'No'"],
        ["table" => "fiduciario_reembolso", "count" => "fiduciario_reembolso_id", "sum" => "monto_global_reembolso", "condition" => "activo = 'Si'"],
        ["table" => "inversion", "count" => "inversion_id", "sum" => "saldo", "condition" => "terminado = 'No'"],
        ["table" => "inversion_reembolso", "count" => "inversion_reembolso_id", "sum" => "monto_global_reembolso", "condition" => "activo = 'Si'"],
        ["table" => "links_al_banco_live", "count" => "link_id", "sum" => "egreso", "condition" => "activo = 'Si'"],
        ["table" => "lista_precios", "count" => "fecha_lista", "sum" => null, "condition" => "activo = 'Si'"],
        ["table" => "movimiento_divisa", "count" => "movimiento_divisa_id", "sum" => null, "condition" => null],
        ["table" => "nota_bodega", "count" => "nota_bodega_id", "sum" => "total_quantity", "condition" => "tipo NOT IN ('Cancelacion','Borrado')"],
        ["table" => "nota_bodega_verificacion", "count" => "nota_bodega_verificacion_id", "sum" => "total_quantity", "condition" => "tipo NOT IN ('Cancelacion','Borrado')"],
        ["table" => "pagare", "count" => "pagare_id", "sum" => "quantity", "condition" => null],
        ["table" => "pagare_log", "count" => "pagare_id", "sum" => "quantity", "condition" => null],
        ["table" => "pagare_pago", "count" => "pagare_pago_id", "sum" => "quantity", "condition" => null],
        ["table" => "pagare_pago_log", "count" => "pagare_pago_log_id", "sum" => "quantity", "condition" => null],
        ["table" => "pedido", "count" => "pedido_id", "sum" => "quantity", "condition" => "activo = 'Si'"],
        ["table" => "pedido_items", "count" => "pedido_item_id", "sum" => "quantity", "condition" => null],
        ["table" => "producto_bodega", "count" => "producto_bodega_id", "sum" => "existencia_quantity", "condition" => null],
        ["table" => "producto_general", "count" => "producto_general_id", "sum" => null, "condition" => "activo = 'Si'"],
        ["table" => "tienda", "count" => "tienda_id", "sum" => null, "condition" => "vale = 'Active'"]
    ];


    // Function to execute the SQL query using ia_singleton
    function runQuery($sql)
    {
        return ia_singleton($sql);
    }

    // Execute the queries and store results
    $results = [];
    foreach ($queries as $queryData) {
        $sql = "SELECT COUNT({$queryData['count']}) AS total_records";
        if ($queryData['sum']) {
            $sql .= ", SUM(ABS({$queryData['sum']})) AS total_sum";
        }
        $sql .= " FROM vitex.{$queryData['table']}";
        if ($queryData['condition']) {
            $sql .= " WHERE {$queryData['condition']}";
        }
        $sql .= ";";

        $results[] = ['table' => $queryData['table'], 'count_field' => $queryData['count'], 'sum_field' => $queryData['sum'], 'data' => runQuery($sql)];
    }

    return $results;
}

function runDBQueriesforComparingonServer(&$preferred_api = "t420sata", $debug = false)
{
    global $gIAParametros;

    // 🔹 **Function to get data from the API**
    function getDBonServer(&$api, $debug = false)
    {
        // Define server URLs
        $servers = [
            "t420sata" => "https://t420sata.dyndns-free.com:2019/vitex/compare_dbs.php",
            "t550gris" => "https://t550gris:2019/vitex/compare_dbs.php"
        ];

        // Check if API exists
        if (!isset($servers[$api])) {
            return null;
        }

        $url = $servers[$api];
        $agent = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.12 Safari/537.36 OPR/56.0.3051.0 (Edition developer)';

        // Fetch Data
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FRESH_CONNECT  => true,
            CURLOPT_FORBID_REUSE   => true,
            CURLOPT_USERAGENT      => $agent,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_TIMEOUT        => 5, // Set timeout to 5 seconds
        ]);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Debugging Output
        if ($debug) echo "<pre>[$api Response] HTTP Code: $http_code\n" . print_r($response, true) . "</pre>";

        // Validate JSON Response
        $data = json_decode($response, true);
        if (!$data || $http_code !== 200) return null; // Invalid JSON or failed request

        return $data;
    }

    // 🔹 **Try Primary Server First**
    $result = getDBonServer($preferred_api, $debug);

    // 🔹 **If Primary Fails, Try Fallback**
    if (!$result) {
        $fallback_api = ($preferred_api === "t420sata") ? "t550gris" : "t420sata";
        $result = getDBonServer($fallback_api, $debug);
    }

    return $result;
}


function doRunCompareDBs() {
    // Execute database queries
    $results = runDBQueriesforComparing();
    $server = "t550gris";
    $serverResults = runDBQueriesforComparingonServer($server, false) ?? [];
    $server = strtoupper($server);
    // Ensure `estoyEn()` exists
    $estoyEn = function_exists('estoyEn') ? estoyEn() : 'Unknown';


    // Initialize HTML table
    $tableHtml = '<table style="width:100%; min-width:700px;" class="table"><caption class="bold txt_1_5em">Fecha y hora del backup: ' . obtenerFechaHoradeBackup() . ' | <span class="bold txt_shadow_purpura">' . estoyEn() . '</span></caption>
    <tr>
        <th class="txt_centered" style="width: 250px;"></th>
        <th class="txt_centered" style="width: 100px;"><span class="bold txt_shadow_purpura">' . htmlspecialchars($estoyEn) . '</span></th>
        <th class="txt_centered" style="width: 250px;"><span class="bold txt_shadow_purpura">' . htmlspecialchars($estoyEn) . '</span></th>
        <th class="txt_centered" style="width: 100px;"><span class="bold txt_shadow_green_">' . htmlspecialchars($server) . '</span></th>
        <th class="txt_centered" style="width: 250px;"><span class="bold txt_shadow_green_">' . htmlspecialchars($server) . '</span></th>
        <th class="txt_centered" style="width: 200px;"></th>
    </tr>
    <tr>
        <th class="txt_centered" style="width: 250px;">Table</th>
        <th class="txt_centered" style="width: 100px;">Total Records</th>
        <th class="txt_centered" style="width: 250px;">Total Sum</th>
        <th class="txt_centered" style="width: 100px;">Total Records</th>
        <th class="txt_centered" style="width: 250px;">Total Sum</th>
        <th class="txt_centered" style="width: 200px;">Summing</th>
    </tr>';

    // Loop through results and compare
    $i = 0;
    foreach ($results as $result) {
        // Prevent Undefined Array Errors
        $serverResult = $serverResults[$i++] ?? ['data' => ['total_records' => 0, 'total_sum' => 0]];

        // Extract data safely
        $result_data_total_records = $result['data']['total_records'] ?? 0;
        $result_data_total_sum = $result['data']['total_sum'] ?? 0;
        $serverResult_data_total_records = $serverResult['data']['total_records'] ?? 0;
        $serverResult_data_total_sum = $serverResult['data']['total_sum'] ?? 0;
        $result_sum_field = $result['sum_field'] ?? '';
        $result_table = $result['table'] ?? '';

        // Determine color class
        $class_ok = "txt_shadow_trans_blue";
        $class_error = "txt_shadow_trans_red";
        $class_ = ($result_data_total_records == $serverResult_data_total_records && $result_data_total_sum == $serverResult_data_total_sum) ? $class_ok : $class_error;

        $result_data_total_records = $result_data_total_records == 0 ? '' : echonf($result_data_total_records, true, 0);
        $result_data_total_sum = $result_data_total_sum  == 0 ? '' : echonf($result_data_total_sum, true);
        $serverResult_data_total_records = $serverResult_data_total_records  == 0 ? '' : echonf($serverResult_data_total_records, true, 0);
        $serverResult_data_total_sum = $serverResult_data_total_sum  == 0 ? '' : echonf($serverResult_data_total_sum, true);
        // Append row to HTML table
        $tableHtml .= "
        <tr>
            <td>{$i} - " . htmlspecialchars($result_table) . "</td>
            <td class='bold txt_right_aligned {$class_}'>" . $result_data_total_records . "</td>
            <td class='bold txt_right_aligned {$class_}'>" . $result_data_total_sum . "</td>
            <td class='bold txt_right_aligned {$class_}'>" . $serverResult_data_total_records . "</td>
            <td class='bold txt_right_aligned {$class_}'>" . $serverResult_data_total_sum . "</td>
            <td class='txt_centered'> " . htmlspecialchars($result_sum_field) . "</td>
        </tr>";
    }

    $tableHtml .= '</table>';
    return $tableHtml;
}

function validateDate($date, $format = 'Y-m-d H:i:s')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}