<?php

// Utility function for creating and managing ATS instances
function manage_ats_execution(string $funcName, callable $executionCallback, int $interval = 10, array $args = []): void
{
    $atsInstance = new ATS(func: $funcName, cada_minutos: $interval, es: 'script', args: $args);
    $atsInstance->ats_registra();

    try {
        $executionCallback();
    } finally {
        $atsInstance->ats_done();
    }
}

// This function is going to be called only by the socket server.
function ws_actualizaLinksAlBancoLive(): void
{
    return;
    manage_ats_execution('async_actualizaLinksAlBancoLive', function () {
        actualizaLinksAlBancoLive();
        generaCatalogos('links');
        actualizaIngresos();
    }, 6000);
}

function ws_generaCatalogos($catalogos = ['QWERTY']): void
{
    generaCatalogos($catalogos);
}

function ws_actualizaIngresos(): void
{
    manage_ats_execution('async_actualizaIngresos', function () {
        actualizaIngresos();
        (new DepositarEn())->actualizaDepositarEn();
    });
}

function ws_checkAndRunAts(): void
{
    @ATS::checkAndRunAts();
}

function ws_actualizaGastosImportantes(): void
{
    manage_ats_execution('async_actualizaGastosImportantes', function () {
        actualizaGastosImportantes();
    });
}

function ws_actualizaFacturasCanceladas(): void
{
    manage_ats_execution('async_actualizaFacturasCanceladas', function () {
        actualizaFacturasCanceladas();
    });
}

function ws_actualizaWithdrawalsImportantes(): void
{
    manage_ats_execution('async_actualizaWithdrawalsImportantes', function () {
        actualizaWithdrawalsImportantes();
    });
}

function ws_mergeCtaTMovs(): void
{
    manage_ats_execution('async_mergeCtaTMovs', function () {
        mergeCtaTMovs4Async();
        generaCatalogos(['edocta_link_por', 'edocta_link_a']);
    });
}

function ws_guardaConsulta($sqlData = ""): void
{
    guardaConsulta(json_decode($sqlData));
}

function ws_guarda_despliega_autorizaciones($sqlData = ""): void
{
    genera_y_guarda_despliega_autorizaciones(json_decode($sqlData));
}

function ws_ejecuta_transaccion_sql($sqlData = ""): void
{
    ejecuta_transaccion_sql_desde_chron(json_decode($sqlData));
}

function ws_lock_nota_bodega(): void
{
    manage_ats_execution('async_lock_nota_bodega', function () {
        lock_nota_bodega();
    }, 20);
}

function ws_actualiza_clientes_saldos($cliente_id = null): void
{
//    $lockKey = "async_actualiza_clientes_saldos_$cliente_id";

    manage_ats_execution('async_actualiza_clientes_saldos', function () use ($cliente_id) {
//        $lock = new ProcessLock();
//
//        if ($lock->aquire(md5($lockKey))) {
//            try {
                actualiza_clientes_saldos($cliente_id, empty($cliente_id));
//            } finally {
//                $lock->release();
//            }
//        } else {
//            die();
//        }
    }, 1, ['es' => 'unica', 'args' => ['cliente_id' => $cliente_id]]);
}

function ws_actualiza_clientes_saldos_grid($categoria_id = null): void
{
    clientes_saldos_grid($categoria_id, "ORDER BY doc_mas_antiguo", $sumasGridServer);
}

function ws_actualizaFiduciariosAtrasados(): void
{
    manage_ats_execution('async_actualizaFiduciariosAtrasados', function () {
        actualizaFiduciariosAtrasados();
    });
}

function ws_actualizaInversionesAtrasadas(): void
{
    manage_ats_execution('async_actualizaInversionesAtrasadas', function () {
        actualizaInversionesAtrasadas();
    });
}

function ws_actualizaACuentasLive($force = 'NO'): void
{
//    $lockKey = "actualiza_a_cuentas_live";

    manage_ats_execution('async_actualizaACuentasLive', function () use ($force) {
//        $lock = new ProcessLock();
//
//        if ($lock->aquire(md5($lockKey))) {
//            try {
                actualizaACuentasLive($force);
//            } finally {
//                $lock->release();
//            }
//        } else {
//            exit();
//        }
    });
}

function ws_actualizaGastosPorRevisar(): void
{
    manage_ats_execution('async_actualizaGastosPorRevisar', function () {
        actualizaGastosPorRevisar();
    });
}

function ws_actualizaConteoMovimientosDivisa(): void
{
    manage_ats_execution('async_actualizaConteoMovimientosDivisa', function () {
        actualizaConteoMovimientosDivisa();
    });
}

function ws_generaHistorian(string $tabla, string $id, string $action, string $user_nick): void
{
    generaHistorian($tabla, $id, $action, $user_nick);
}

function ws_disable_tc_temp_timeout(): void
{
    manage_ats_execution('async_disable_tc_temp_timeout', function () {
        app_iac_parametros::disable_tc_temp_timeout();
    });
}

function ws_banco_cuenta_mov_puede_borrar(): void
{
    manage_ats_execution('async_banco_cuenta_mov_puede_borrar', function () {
        actualizaConteoMovimientosDivisa();
    });
}

function ws_updateMaxMinCountAll(): void
{
    updateMaxMinCountAll();
}

function ws_recalculaInconsistenciasEnNotas($cliente_id = '', $cliente_nombre = ''): void
{
    recalculaInconsistenciasEnNotas($cliente_id, $cliente_nombre);
}

function ws_update_plantillas_withdrawals(): void
{
    manage_ats_execution('async_update_plantillas_withdrawals', function () {
        app_plantilla_withdrawals_de_banco::bloquea_plantillas();
    });
}

function ws_update_plantillas_cuenta_t_gasto(): void
{
    manage_ats_execution('async_update_plantillas_cuenta_t_gasto', function () {
        app_plantilla_cuentat_gasto::bloquea_plantillas();
    });
}
