<?php

require_once __DIR__ . '/../../vendor/autoload.php';
use React\EventLoop\Loop;
use Ratchet\Client\WebSocket;

class WsClient
{
    private string $url;

    public function __construct(string $url = 'ws://127.0.0.1:2000')
    {
        $this->url = $url;
    }

    public function connectAndRun(array|string $message, bool $waitForResponse = false): void
    {
        $loop = Loop::get();

        \Ratchet\Client\connect($this->url, [], [], $loop)
            ->then(function (WebSocket $conn) use ($message, $loop, $waitForResponse) {
                $this->send_message($conn, $message);

                if ($waitForResponse) {
                    // Handle server response
                    $conn->on('message', function ($msg) use ($conn, $loop) {
                        ia_errores_a_dime("Received from server: $msg\n");
                        $conn->close();
                    });

                    $conn->on('close', function () use ($loop) {
                        $loop->stop();
                    });
                } else {
                    // Fire-and-forget: Close immediately without waiting
                    $conn->close();
                }
            })
            ->otherwise(function (\Exception $e) {
                ia_errores_a_dime("WebSocket connection failed: {$e->getMessage()}\n");
            });

        // Let the loop continue without stopping prematurely
    }

    private function send_message(WebSocket $conn, array|string $message): void
    {
        if (!is_string($message)) {
            $message = json_encode($message);
            if (json_last_error() !== JSON_ERROR_NONE) {
                ia_errores_a_dime("Error encoding message to JSON.\n");
                return;
            }
        }

        $conn->send($message);
        ia_errores_a_dime("Message sent: $message\n");
    }
}

/**
Javascript Client.

class WebSocketClient {
constructor(usuario_id, usuario, php_script) {
this.usuario_id = usuario_id;
this.usuario = usuario;
this.params = []; // Placeholder for dynamic parameters
this.func = []; // Placeholder for dynamic functions
this.php_script = php_script; // Placeholder for the name of the fallback script
this.accion = 'run_ws'; // Default action, can be set by the user
this.wsResponded = false;
this.ws = new WebSocket('ws://127.0.0.1:2000');

    // Ensure vitex_globales exists and set defaults if keys are missing
if (typeof $vitex_globales === 'undefined') {
$vitex_globales = {};
}
if (!$vitex_globales.hasOwnProperty('iac_parametros')) {
    $vitex_globales.iac_parametros = { run_ws: false };
        } else if (!$vitex_globales.iac_parametros.hasOwnProperty('run_ws')) {
    $vitex_globales.iac_parametros.run_ws = false;
}
if (!$vitex_globales.hasOwnProperty('run_ws')) {
    $vitex_globales.run_ws = false;
}

this.initializeWebSocket();
}

// Function to construct the URL for a cron job
getUrlForCron(fileRequest = '') {
let parts = fileRequest.split(".");
        if (parts.pop() !== 'php') {
            fileRequest += ".php";
        }
        return window.location.origin + '/' + window.location.pathname.split('/')[1] + '/backoffice/chron/' + fileRequest;
    }

    // Fallback function for async processing
    async_() {
        const url = this.getUrlForCron(this.php_script);
        console.log("Fallback: Calling", url, "with parameters:", this.params, "and function:", this.func);

        fetch(url, {
            method: 'POST',
            headers: {
    'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                params: this.params,
                func: this.func,
            }),
        })
        .then(response => {
    if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
    }
    return response.json(); // Assuming the response is JSON
})
        .then(data => {
    console.log("Response from fallback:", data);
})
        .catch(error => {
    console.error("Error during fallback call:", error);
});
    }

    // Initialize WebSocket connection and handlers
    initializeWebSocket() {
        // Check conditions to go directly to async_
        if (this.accion !== 'run_ws' || !$vitex_globales.iac_parametros.run_ws || !$vitex_globales.run_ws) {
            console.warn("Conditions met for direct fallback to async_...");
            this.async_();
            return;
        }

        this.ws.onopen = () => {
    console.log("WebSocket connection established.");

    const message = JSON.stringify({
                usuario_id: this.usuario_id,
                usuario: this.usuario,
                func: this.func,
                accion: this.accion, // Use the user-defined or default action
                func_params: JSON.stringify(this.params),
            });

            this.ws.send(message);

            // Set a timeout to check for WebSocket response
            setTimeout(() => {
        if (!this.wsResponded && message.includes(`"accion":"${this.accion}"`)) {
            console.warn("WebSocket did not respond in time. Falling back to async_...");
            this.async_();
        }
    }, 5000); // Adjust timeout duration as needed (5 seconds here)
        };

        this.ws.onmessage = (event) => {
    this.wsResponded = true; // Mark response as received
    console.log("Received from server:", event.data);
};

        this.ws.onerror = (error) => {
    console.error("WebSocket error:", error);
};

        this.ws.onclose = () => {
    console.log("WebSocket connection closed.");
};
    }
}

// Example usage:
const client = new WebSocketClient(10, 'lol', 'fallback_script');
client.accion = 'run_ws'; // Set the desired action if needed

**/

/**
Cliente PHP.
Vitex WebSocket: Funciones Requeridas para la Comunicación y Procesos Asíncronos
Este documento detalla las funciones necesarias para implementar procesos que interactúan con el servidor WebSocket o, en caso de falla, recurren a una ejecución asíncrona en su contraparte PHP. Cada función tiene un propósito definido, y se recomienda organizarlas en archivos separados según su responsabilidad, lo que facilita el mantenimiento, la comprensión y la modularidad del código.

1. Función para ser llamada únicamente por el servidor WebSocket

function ws_my_function($user_params = ""): void
{
    //Aquí se debe ejecutar el código
    my_function(json_decode($user_params));
}
•	Archivo recomendado: vitex_ws.php
•	Razón: Este archivo debe contener exclusivamente funciones destinadas a ser utilizadas por el servidor WebSocket. Esto facilita el mantenimiento y asegura que las responsabilidades estén bien separadas.
________________________________________
2. Llamada resiliente al WebSocket o a una función asíncrona (fallback en PHP)

function async_ws_my_function($user_params = ""): void
{
    execute_with_resilience('my_function', 'my_php_fallback_script', $user_params);
}
•	Archivo recomendado: vitex_async_ws.php
•	Razón: Este archivo puede agrupar funciones resilientes que intenten primero usar el WebSocket y luego caigan en un script PHP como respaldo. La separación en un archivo específico para este propósito mejora la claridad.
________________________________________
3. Ejecución asíncrona de tareas vía HTTP

function async_my_function(array|string $user_params = ""): void
{
    async_execute_task("my_php_fallback_script", ['user_params' => $user_params]);
}
•	Archivo recomendado: vitex_async.php
•	Razón: Este archivo puede contener todas las funciones destinadas a la ejecución asíncrona vía HTTP, centralizando las tareas asíncronas en un solo lugar para facilitar el manejo.

**/