// noinspection ES6ConvertVarToLetConst,JSDuplicatedDeclaration
/**
 * JJDPL: Si falla la BUSQUEDA RAPIDA
 *  Descomentar la linea 3391: num = this.obtenIndicedeElements
 *  Descomentar la line : Elements[group][num]={element:$div,id:$id,type:type,extraf,order:num,group:group}
 *  Comentar la linea : Elements[group][i_order]={element:$div,id:$id,type:type,extraf,order:i_order,group:group};
 *  Descomentar la linea : if (typeof busqueda_desde_iacase !== 'undefined' && busqueda_desde_iacase == true)
 */
var isonArray_i, isonArray_length, ia = ia || {}, vx_utils = vx_utils || {}, $vitex_globales = $vitex_globales || {};

function roundNumber(num, dec=2){
    var result=Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
    return result; 
}

function CommaFormatted(amount, depth = 2, delimiter = ','){
    if(!depth) depth=2;
    if(typeof delimiter=="undefined") delimiter=",";
    /* amount=roundNumber(amount, depth)
    amount=amount.toFixed(depth) */
    amount = toFixedTrunc(amount, depth);
    amount = toFixed(amount);

    var a=amount.split('.', depth), d=a[1], i=parseInt(a[0]), minus='', n, nn;
    if(isNaN(i)) return '';
    if(i < 0 || a[0].includes('-')) minus='-';
    i=Math.abs(i);
    n=new String(i);
    a=[];
    while (n.length > 3){
        nn=n.substr(n.length - 3);
        a.unshift(nn);
        n=n.substr(0, n.length - 3);
    }
    if(n.length > 0) a.unshift(n);
    n=a.join(delimiter);
    if(d.length < 1)
        amount=n;
    else
        amount=n + '.' + d;
    amount=minus + amount;
    return amount;
}
function CommaFormatted_original(amount, depth = 2, delimiter = ','){
    if(!depth) depth=2;
    if(typeof delimiter=="undefined") delimiter=",";
    amount=roundNumber(amount, depth)
    amount=amount.toFixed(depth)

    var a=amount.split('.', depth), d=a[1], i=parseInt(a[0]), minus='', n, nn;
    if(isNaN(i)) return '';
    if(i < 0) minus='-';
    i=Math.abs(i);
    n=new String(i);
    a=[];
    while (n.length > 3){
        nn=n.substr(n.length - 3);
        a.unshift(nn);
        n=n.substr(0, n.length - 3);
    }
    if(n.length > 0) a.unshift(n);
    n=a.join(delimiter);
    if(d.length < 1)
        amount=n;
    else
        amount=n + '.' + d;
    amount=minus + amount;
    return amount;
}

function round_up(amount, depth = 2) {
    var valor = stringToNumber(amount);
    const multiplier = Math.pow(10, depth || 0);
    return Math.ceil(valor * multiplier) / multiplier;
}

function numbersonly(e, decimal){
    var key;
    var keychar;
    if (window.event){
        key=window.event.keyCode;
    } else if (e){
        key=e.which;
    } else {
        return true;
    }
    keychar=String.fromCharCode(key);
    if ((key==null) || (key==0) || (key==8) || (key==9) || (key==13) || (key==27)){
        return true;
    } else if ((("0123456789").indexOf(keychar) > -1)){
        return true;
    } else if (decimal && ((keychar===".") || (keychar==="-"))){
        return true;
    } else
        return false;
}

function uppercase(){
    key=window.event.keyCode;
    if (((key > 0x60) && (key < 0x7B)) || ((key > 0xDF) && (key < 0xFD))) window.event.keyCode=key - 0x20;
    if (key==0xF1) window.event.keyCode=0xD1;
}

function strtrim(str){
    var str=str.replace(/^\s\s*/, ''),
        ws=/\s/,
        i=str.length;
    while (ws.test(str.charAt(--i)));
    return str.slice(0, i + 1);
}

function hasClass(ele, cls){
    return ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
}

function addClass(ele, cls){
    if (!this.hasClass(ele, cls)) ele.className += " " + cls;
}

function removeClass(ele, cls){
    if (hasClass(ele, cls)){
        var reg=new RegExp('(\\s|^)' + cls + '(\\s|$)');
        ele.className=ele.className.replace(reg, ' ');
    }
}

function FechaporDefault(ID){
    if (ID=='') return;
    if ($('#' + ID).val()===''){
        var now=new Date();
        //document.getElementById(ID).value=now.toString('dd-MM-yyyy');
        $('#' + ID).val($.datepicker.formatDate('dd-mm-yy', now));
    }
}

//VCA /////////////////////////////////////////////////////////
function VerificayCorrigeFecha(Fecha, campo, corrige, permiteVacio, formatoOrigen, formatoDestino){
    var FechaaCorregir=Fecha,
        CaracterDivisor='',
        aFecha,
        iDia,
        iMes,
        iAnio,
        sDia,
        sMes,
        sAnio,
        sFechaCorregida, sFechaCorregidaBW,
        sFechaCaret='dd-mm-AAAA',
        formatoFecha='mx',
        fechaAPDF = obtenFecha('mx');

    if (typeof _app!='undefined' && (_app==='edocta' || _app==='cuenta_t')){
        formatoFecha='mx';
        sFechaCaret='dd-mm-AAAA';
    } else {
        formatoFecha='mysql';
        sFechaCaret='AAAA-mm-dd';
    }

    if (!formatoOrigen) var formatoOrigen=formatoFecha;
    if (!formatoDestino) var formatoDestino=formatoFecha;

    if (!corrige) var corrige='SI';
    if (!permiteVacio) var permiteVacio='SI';
    if (FechaaCorregir.length===0){
        if (permiteVacio!=='SI') vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        return fechaAPDF;
    }
    if (FechaaCorregir.length < 6 && FechaaCorregir.length > 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }

    //Vamos a buscar el carácter con que están dividiendo la fecha.
    FechaaCorregir=FechaaCorregir.replace(/\//g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\*/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\./g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\_/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\+/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\\/g, '-');
    CaracterDivisor='-';
    aFecha=FechaaCorregir.split(CaracterDivisor);
    if (aFecha.length > 3){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }

    //'mx'
    iDia=aFecha[0];
    iMes=aFecha[1];
    iAnio=aFecha[2];

    if(parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0 || parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0)
    {
        iDia=aFecha[2];
        iMes=aFecha[1];
        iAnio=aFecha[0];

        if(parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0 || parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0)
            return Fecha;
        else
            formatoOrigen = 'mysql';
    }
    else
        formatoOrigen = 'mx';

    switch (formatoOrigen){
        case 'mx':
            iDia=aFecha[0];
            iMes=aFecha[1];
            iAnio=aFecha[2];
            sFechaCaret='dd-mm-AAAA';
            break;
        case 'mysql':
            iDia=aFecha[2];
            iMes=aFecha[1];
            iAnio=aFecha[0];
            sFechaCaret='AAAA-mm-dd';
            break;
    }
    if (isNaN(iDia) || isNaN(iMes) || isNaN(iAnio)){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    if (parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    if (parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    iDia=parseInt(iDia, 10);
    iMes=parseInt(iMes, 10);
    iAnio=parseInt(iAnio, 10);
    if(iAnio < 30)
        iAnio += 2000;
    else if(iAnio < 99)
        iAnio += 1900;
    if(iDia < 10)
        sDia='0' + iDia.toString();
    else
        sDia=iDia.toString();
    if(iMes < 10)
        sMes='0' + iMes.toString();
    else
        sMes=iMes.toString();

    sAnio=iAnio.toString();

    sFechaCorregida=sDia + '-' + sMes + '-' + sAnio;
    sFechaCorregidaBW=sAnio + '-' + sMes + '-' + sDia;

    //Metemos una verificación de restricción.
    if (typeof _app!='undefined' && _app==='edocta'){
        var cFecha=new Date(sFechaCorregidaBW + ' GMT-0600'),
            cFLPC=new Date(flpC + ' GMT-0600'),
            cFLFC=new Date(flfC + ' GMT-0600');
        if (cFecha < cFLPC || cFecha > cFLFC){
            console.log('min: ', cFLPC);
            console.log('max: ', cFLFC);
            //document.getElementById(campo).focus();
            vx_alert(divIDInfo, '<strong>Fecha fuera del rango permitido. Por favor, usa el calendario para elegir la fecha.</strong>', 'Captura de Estado de Cuenta.', campo, '', '', '');
            return fechaAPDF;
        }
    }
    if (corrige==='SI')
        document.getElementById(campo).value=sFechaCorregida;
    else
    {
        switch (formatoDestino){
            case 'mx':
                return sFechaCorregida;
            case 'mysql':
                return sFechaCorregidaBW;
        }
    }
    return sFechaCorregida;
}

function obtenFecha(formato, sep)
{
    var today = new Date(),
        dd = today.getDate();
    mm = today.getMonth()+1; //January is 0!
    yyyy = today.getFullYear();

    if(!formato) var formato = 'mx';
    if(!sep) var sep = '-';

    if(dd<10) {
        dd = '0'+dd
    }

    if(mm<10) {
        mm = '0'+mm
    }

    switch(formato)
    {
        case 'mx':
            return mm + sep + dd + sep + yyyy;


        case 'mysql':
            return yyyy + sep + mm + sep + dd;

    }

    return mm + sep + dd + sep + yyyy;
}
//VCA /////////////////////////////////////////////////////////

function trapEnterAsTab() // called from an onKeyDown in the body	statement
{
    evt=event || window.event;
    if (evt.keyCode==13 && TextAreaFocused==false /* enter */ ) evt.keyCode=9 /* tab */
    ;
}

function focusonTextArea(){
    TextAreaFocused=true;
}

function focusnotonTextArea(){
    TextAreaFocused=false;
}

function MostraruOcultarMenu(NombredelMenu, muo){
    muo=muo===undefined?'DEF':muo;

    if(muo==='DEF')
        $('#' + NombredelMenu).toggle('blind', 300);
    else
        $('#' + NombredelMenu).hide();
}

function nl2br(str){
    var breakTag='<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function vx_isOnArray(arr, val){
    for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
        if (arr[isonArray_i]==val) return isonArray_i;
    return -1;
}

function getposonArray(arr, val, pos){
    if (!pos) var pos=0;
    for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
        if (isArray(arr[isonArray_i])){
            if (arr[isonArray_i][pos]==val) return isonArray_i;
        } else
        if (arr[isonArray_i]==val) return isonArray_i;
    return false;
}

function InicializaWidthGrid(gh, forzar){
    if (!gh) var gh=gridhandler;
    if (!forzar) var forzar=false;
    if (!PrimeraVez || forzar){
        $(gh).setGridWidth($(gh).getGridParam('width') - 5, true);
        $(gh)[0].clearToolbar();
    }
    PrimeraVez=true;
}

function CambiaFormatoFecha(Fecha, formato){
    if (Fecha.length < 10) return '';
    if (!formato || formato.length===0) var formato='MySQL';
    var CaracterDivisor='-';
    var aFecha=Fecha.split(CaracterDivisor);
    var sDia=aFecha[0];
    var sMes=aFecha[1];
    var sAnio=aFecha[2];
    switch (formato){
        case 'MySQL':
            Fecha=sAnio + '-' + sMes + '-' + sDia;
            break;
        case 'JS':
            Fecha=sDia + '-' + sMes + '-' + sAnio;
            break;
        default:
            Fecha=sAnio + '-' + sMes + '-' + sDia;
            break;
    }
    return Fecha;
}

function RecuperaoEstableceEstilodeCampo(tabla, campo, id_nombre, id_valor, atributo, valor){
    if (!tabla || !campo || !id_nombre || !id_valor) return false;
    if (!valor) valor='read';
    if (!atributo) atributo='';
    if (window.XMLHttpRequest){
        xmlhttp=new XMLHttpRequest();
    } else {
        xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.open("POST", "ajax/iaestilos.php", false);
    xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    var parameters="tabla=" + tabla + "&campo=" + campo + "&id_nombre=" + id_nombre + "&id_valor=" + id_valor + "&atributo=" + atributo + "&valor=" + valor;
    xmlhttp.send(parameters);
    try { // Aquí va el código de respuesta del servidor. Tu código.
        var jsonresponse=eval('(' + xmlhttp.responseText + ')');
        if (jsonresponse.valor!=="Error") return jsonresponse;
    } catch (err){
        alert(err.message);
    }
}

function EstilizaCampos(){
    //var campos=$("*:[data-color=='1']");
    $('*[data-color="1"]').each(function(k, v){
        var attr_arr=RecuperaoEstableceEstilodeCampo($(v).attr('data-tabla'), $(v).attr('data-campo'), $(v).attr('data-id_nombre'), $(v).attr('data-id_valor'), '', 'read');
        $.each(attr_arr, function(a, b){
            $(v).css(b['atributo'], b['valor']);
        });
        //alert($(v).attr('data-tabla'));
    });
}

function isArray(obj){
    return obj.constructor==Array;
}

function spanishDate(d, time){
    if (!time) var time=false;
    var weekday=["Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"];
    var monthname=["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
    if (time) return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear() + " : " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
    else
        return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear();
}

function vx_alert(divID, mensaje, titulo, focusafter, width, extraCloseFunc, extraOpenFunc, autoClose, autoClosemSecs){
    if(divID.length === 0)
        divID = "ABC123";

    var $_divObj = $("#" + divID);

    if($_divObj.length === 0) {
        $("BODY").append("<div id='" + divID + "'>");
        $_divObj = $("#" + divID);
    }

    if (!focusafter) var focusafter='';
    if (!width) var width='400';
    if (!extraCloseFunc) var extraCloseFunc='';
    if (!extraOpenFunc) var extraOpenFunc='';
    if (!autoClose) var autoClose='NO';
    if (!autoClosemSecs) var autoClosemSecs=4500;
    if (typeof divIDError !== 'undefined' &&  divID!=divIDError && typeof divIDInfo !== 'undefined' && divID!=divIDInfo)
        autoClose='NO';
    else
        globDiv=divID;
        console.log("divID", divID);

        var timeoutId = 0;

    
    $_divObj.html('<br><br>' + mensaje + '<br><br>').dialog({
        stack: false,
        resizable: false,
        width: width,
        title: titulo,
        modal: true,
        open: function(event, ui){
            try {
                // jqBlockUI("",false, false, true);

                if (autoClose==='SI')
                    timeoutId = setTimeout(function(){
                    if ($('#' + globDiv).data('ui-dialog') && $('#' + globDiv).dialog('isOpen')) $('#' + globDiv).dialog('close');
                }, autoClosemSecs);
                if (extraOpenFunc!='')
                    eval(extraOpenFunc);

                queueMicrotask(()=> {
                    $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus(); //focus en el botón aceptar.
                });

            } catch (er){ console.log(er); }
            //setTimeout(function(){ $('.ui-dialog :button')[1].focus(); },300); //focus en el botón aceptar.

        },
        close: function(event, ui){
            try {
                // jqUnBlockUI();
                if (autoClose==='SI')
                    clearTimeout(timeoutId);
                if (extraCloseFunc!='' && typeof extraCloseFunc !== 'function')
                    eval(extraCloseFunc);
                else if(typeof extraCloseFunc === 'function')
                    extraCloseFunc();

                if(focusafter!=''){
                    let $_focusafterObj = $('#' + focusafter);
                    if ($_focusafterObj.hasClass('selectized')) $_focusafterObj.selectize()[0].selectize.open();
                    else $_focusafterObj.focus().select();

                    if ($_focusafterObj.hasClass('custom-select')) {
                        $_focusafterObj.customSelectColor.setValue('first');
                        setTimeout(function () {
                            $_focusafterObj.customSelectColor.setValue();
                        }, 1000)
                    }
                }
                $(this).dialog("close");
                // $(this).dialog("destroy");
                $_divObj.html('');

                $_divObj.remove();
            } catch (er){ console.log(er); };
        },
        buttons: {
            Aceptar: function(){
                $(this).dialog("close");
            }
        }
    });
}

function vx_alert_error(divID, mensaje, titulo, focusafter, width, extraCloseFunc, extraOpenFunc, autoClose, autoClosemSecs){
    if($("#" + divID).length === 0) $("BODY").append($("<div id='" + divID+ "' >"));
    if (!focusafter) var focusafter='';
    if (!width) var width='400';
    if (!extraCloseFunc) var extraCloseFunc='';
    if (!extraOpenFunc) var extraOpenFunc='';
    if (!autoClose) var autoClose='NO';
    if (!autoClosemSecs) var autoClosemSecs=4500;
    if (typeof divIDError !== 'undefined' &&  divID!=divIDError && typeof divIDInfo !== 'undefined' && divID!=divIDInfo)
        autoClose='NO';
    else
        globDiv=divID;

    
    $("#" + divID).html('<br><br><span class="ui-icon ui-icon-alert" style="float: left; margin-right: 1em; zoom: 150%; -moz-transform: scale(1.25); -webkit-zoom: 1.25; -ms-zoom: 1.25;"></span>' + mensaje + '<br><br>').dialog({
        stack: false,
        resizable: false,
        width: width,
        title: titulo,
        modal: true,
        open: function(event, ui){
            try {
                $zIndex = 99999;
                $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                    $(this).css('z-index',$zIndex++);
                });
                $zIndex-=2;
                $(".ui-widget-overlay").css('z-index',$zIndex);

                if (autoClose==='SI') setTimeout(function(){
                    if ($('#' + globDiv).data('ui-dialog') && $('#' + globDiv).dialog('isOpen')) $('#' + globDiv).dialog('close');
                }, autoClosemSecs);
                if (extraOpenFunc!='')
                    eval(extraOpenFunc);

                $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus(); //focus en el botón aceptar.

            } catch (er){ console.log(er); }
            //setTimeout(function(){ $('.ui-dialog :button')[1].focus(); },300); //focus en el botón aceptar.

        },
        close: function(event, ui){
            try {
                if (extraCloseFunc!='')
                {
                    if (typeof extraCloseFunc === 'function') {
                        extraCloseFunc();
                    } else {
                        eval(extraCloseFunc);
                    }
                }


                if(focusafter!=''){
                    if ($('#' + focusafter).hasClass('selectized')) $('#' + focusafter).selectize()[0].selectize.open();
                    else $('#' + focusafter).focus().select();
                }
                $(this).dialog("destroy");
                $("#" + divID).html('');

                $zIndex = 99999;
                $dS = $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable");
                $zIndex += $dS.length;

                $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                    $(this).css('z-index',$zIndex--);
                });
                $(".ui-widget-overlay").css('z-index',$zIndex);
            } catch (er){ console.log(er); };
        },
        buttons: {
            Aceptar: function(){
                $(this).dialog("close");
            }
        }
    }).prev(".ui-dialog-titlebar").css({"background":"#f93838","color":"#fef1ec"});
}

function agregaDiasaFecha(Fecha, Dias, formato){
    if (Dias==0 || Dias=='') return Fecha;
    Dias=parseInt(Dias, 10);
    if (!formato) formato='dmA';
    var CaracterDivisor='-';
    var aFecha=Fecha.split(CaracterDivisor);
    var sDia='';
    var sMes='';
    var sAnio='';
    switch (formato){
        case 'dmA':
            sDia=aFecha[0];
            sMes=aFecha[1];
            sAnio=aFecha[2];
            Fecha=sMes + '-' + sDia + '-' + sAnio;
            var hoy=Date.parse(Fecha);
            var nvaFecha=new Date(hoy);
            nvaFecha.setDate(nvaFecha.getDate() + Dias);
            Fecha=nvaFecha.getDate() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getFullYear();
            break;
        case 'Amd':
            sDia=aFecha[2];
            sMes=aFecha[1];
            sAnio=aFecha[0];
            Fecha=sMes + '-' + sDia + '-' + sAnio;
            var hoy=Date.parse(Fecha);
            var nvaFecha=new Date(hoy);
            nvaFecha.setDate(nvaFecha.getDate() + Dias);
            Fecha=nvaFecha.getFullYear() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getDate();
            break;
        default:
            break;
    }
    return Fecha;
}
$.fn.makeAbsolute=function(rebase){
    return this.each(function(){
        var el=$(this);
        var pos=el.position();
        el.css({
            position: "absolute",
            marginLeft: 0,
            marginTop: 0,
            top: pos.top,
            left: pos.left
        });
        if (rebase) el.remove().appendTo("body");
    });
};

function getMondayOfCurrentWeek(d){
    var day=d.getDay();
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day===0 ? -6 : 1) - day);
}

function getSundayOfCurrentWeek(d){
    var day=d.getDay();
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day===0 ? 0 : 7) - day);
}
//Get the First and Last day of Current Month

function getDayOfMonth(d, dia, mes){
    dia = typeof dia === "undefined" ? "" : dia;
    mes = typeof mes === "undefined" ? "actual" : mes;

    var _day=0, _month=0, _year=0;

    switch(mes)
    {
        case "actual":
            _month = 0;
            break;

        case "pasado":
            _month = -1;
            break;

        case "proximo":
            _month = 1;
            break;

        default:
            _month = 0;
            break;

    }

    switch(dia)
    {
        case "primero":
            _day = 1;
            break;

        case "ultimo":
            _day = 0;
            _month++;
            break;

        default:
            _day = 0;
            break;
    }

    return new Date(d.getFullYear() + _year, d.getMonth() + _month, _day);
}

function getFistDayOfCurrentMonth(d){
    return new Date(d.getFullYear(), d.getMonth(), 1);
}


function getLastDayOfCurrentMonth(d){
    return new Date(d.getFullYear(), d.getMonth() + 1, 0);
}

function getLastXDays(d,days){
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() - days);
}

//VCA OCT2019
function getThisYear(d){
    return new Date(d.getFullYear(), 0, 1);
}

//VCA OCT2019
function buildStringwithDelimeters(str, origDelim, finalDelim, campoID, paraSQL, colSQL, signo1, $campo = {}){
    if(typeof gridhandler === 'string')
        gridhandler=$(gridhandler);

    var finalStr='',
        tmpArr,
        tmpid = gridhandler.attr('id'),
        doctos = tmpid.search('doctos') >=0,
        cuentatgasto = tmpid.search('cuentatgasto') >=0 ,
        cuentat_mov = tmpid.search('cuentat_mov') >=0 ,
        matchAg = tmpid.search('pagare') >=0 || tmpid.search('cheque') >=0 || tmpid.search('vale') >=0 || tmpid.search('doctos') >=0 || tmpid.search('compra') >=0 || tmpid.search('cuentatgasto') >=0 || tmpid.search('cuentat_mov') >=0 || tmpid.search('banco_cuenta_mov') >=0 ? true : false,
        signo1 = $('#'+campoID+'_not')[0].checked ? "NOT LIKE" : "LIKE",
        exact_word = $('#'+campoID+'_exact')[0].checked,
    campo_nombre_final = "";


    if(!origDelim) var origDelim=';';
    if(!finalDelim) var finalDelim=' ';
    if(!paraSQL) var paraSQL='NO';
    if(typeof colSQL !== Object && typeof colSQL !== 'string')
        colSQL = colSQL[0];
    campo_nombre_final = colSQL;
    if(!campoID){
        var campoID='';
        tmpArr=str.split(origDelim);
    } else if (campoID.length && paraSQL==='SI'){
        //if ($('#' + campoID + '_and').is(':checked')) finalDelim=' AND ';
        //else if ($('#' + campoID + '_or').is(':checked')) finalDelim=' OR ';
        finalDelim=$('input:radio[name='+campoID+'_rad]:checked').val() || " OR "; //Un hack para que jale. Arreglar abajo.
        tmpArr=$('#' + campoID).val().split(origDelim);
    }

    if(!tmpArr.length)
        return finalStr;

    finalStr = "( ";

    $.each(tmpArr, function(k, v){
        //VCA Rony quiere que en los comentarios los numros los busque con comas y sin ellas
        let valor = v.trim(), val_first = valor.charAt(0), val_num = valor;

        if(!isNaN(val_first) || val_first === "$")
            val_num = valor.replace(/(\d+(.|,))+(\d)+/m, function (match, string, offset) {
            return CommaFormatted(vx_utils.parseFloat(match));
        });

        if (paraSQL==='SI')
        {
            if(colSQL.search('remarks') > -1 && (matchAg || doctos)) //Bug detectado colSQL.search('remarks') >= -1
            {
                if(!cuentat_mov)
                    campo_nombre_final = colSQL + "_wot";

                if((cuentat_mov || cuentatgasto) && !su)
                    campo_nombre_final = " IF(solo_rony='Si','', " + campo_nombre_final +") ";


                if (valor != val_num)
                    finalStr += "(" + campo_nombre_final + " IS NOT NULL AND (" + campo_nombre_final+" "+signo1+" '%" + protectSqlValue(valor)  + "%' OR " + campo_nombre_final+" "+signo1+" '%" + protectSqlValue(val_num)  + "%')) " + finalDelim + " ";
                else
                    finalStr += "(" + campo_nombre_final + " IS NOT NULL AND " + campo_nombre_final+" "+signo1+" '%" + protectSqlValue(valor)  + "%') " + finalDelim + " ";
            }
            else
            {
                let like_final = "(" + campo_nombre_final+" "+signo1+" '%" + protectSqlValue(valor)  + "%' OR " + campo_nombre_final+" "+signo1+" '%" + protectSqlValue(val_num)  + "%')",
                campo_nombre_final_ = ($campo.field_force.length ? $campo.field_force : campo_nombre_final),
                like_final_ = campo_nombre_final_ + " " +signo1+" '%" + protectSqlValue(valor)  + "%'";

                if(exact_word) {
                    like_final = "(" + campo_nombre_final + " " + signo1 + " '" + protectSqlValue(valor) + " %' OR " + campo_nombre_final + " " + signo1 + " '% " + protectSqlValue(valor) + "' OR " + campo_nombre_final + " " + signo1 + " '" + protectSqlValue(valor) + "' OR " + campo_nombre_final + " " + signo1 + " '" + protectSqlValue(val_num) + " %' OR " + campo_nombre_final + " " + signo1 + " '% " + protectSqlValue(val_num) + "' OR " + campo_nombre_final + " " + signo1 + " '" + protectSqlValue(val_num) + "')";

                    like_final_ = "(" + campo_nombre_final_ +" "+signo1+" '" + protectSqlValue(valor)  + " %' OR " + campo_nombre_final_ +" "+signo1+" '% " + protectSqlValue(valor)  + "' OR " + campo_nombre_final_ +" "+signo1+" '" + protectSqlValue(valor)  + "')";
                }

                if (valor != val_num)
                    finalStr += "(" + campo_nombre_final + " IS NOT NULL AND "+ like_final + ") " + finalDelim + " ";
                else
                    finalStr += "(" + campo_nombre_final_ + " IS NOT NULL AND " + like_final_ + ") " + finalDelim + " ";
            }
        }
        else
            finalStr=finalStr + v.trim() + finalDelim;
    });

    finalStr = finalStr.trim();
    finalStr=finalStr.substring(0, finalStr.length - finalDelim.length);

    if (paraSQL==='SI')
        finalStr += ")";

    return finalStr;
}
function protectSqlValue(str) {
    return str.replace(/([\\'])/gm, "S\\$1");
}
function pad(width, string, padding){
    return (width <= string.length) ? string : pad(width, padding + string, padding)
}

function vx_confirm_old(divID, mensaje, titulo, yesFunc, noFunc){
    var width='400';
    if (!noFunc) var noFunc='';
    if (!yesFunc) var yesFunc='';
    $("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        modal: true,
        resizable: false,
        width: width,
        title: titulo,
        open: function(event, ui){},
        close: function(event, ui){
            $(this).dialog("destroy");
            $("#" + divID).html('');
        },
        buttons: {
            'Sí': function(){
                if (yesFunc!='') try {
                    eval(yesFunc);
                } catch (er){
                    console.log(er);
                }
                $(this).dialog("close");
            },
            'No': function(){
                if (noFunc!='') try {
                    eval(noFunc);
                } catch (er){
                    console.log(er);
                }
                $(this).dialog("close");
            }
        }
    });
}

function obtenComparador(str, tipo, val){
    if (!tipo) var tipo='num';
    if (!str || str.length==0) return '=';
    var co='';
    if (tipo=='num') switch (str){
        case'eq':co='=';break;
        case'ne':co='!=';break;
        case'lt':co='<';break;
        case'le':co='<=';break;
        case'gt':co='>';break;
        case 'ge':co='>=';break;
        default:co='=';break;
    } else switch (str){
        case 'eq':co=" LIKE '" + val + "%' ";break;
        case 'ne':co=" NOT LIKE '" + val + "%' ";break;
        case 'lt':co=" < '" + val + " 00:00:00' ";break;
        case 'le':co=" <= '" + val + " 23:59:59' ";break;
        case 'gt':co=" > '" + val + " 23:59:59' ";break;
        case 'ge':co=" >= '" + val + " 00:00:00' ";break;
        default:co=" LIKE '" + val + "%' ";break;
    }
    return co;
}

function parseVxFloat(str){
    return vx_utils.parseFloat(str);
}


function vx_confirm(divID, mensaje, titulo, yesCallbackFunc, noCallbackFunc, width, onOpenFunc, onCloseFunc){
    divID=divID===undefined?'IA_INFO':divID;
    mensaje=mensaje===undefined?'':mensaje;
    titulo=titulo===undefined?'':titulo;
    width=width===undefined?'400':width;
    yesCallbackFunc=yesCallbackFunc===undefined?function(){return;}:yesCallbackFunc;
    noCallbackFunc=noCallbackFunc===undefined?function(){return;}:noCallbackFunc;
    onOpenFunc=onOpenFunc===undefined?function(){return;}:onOpenFunc;
    onCloseFunc=onCloseFunc===undefined?function(){return;}:onCloseFunc;


    $("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        modal: true,
        resizable: false,
        width: width,
        title: titulo,
        open: function(event, ui){
            try{
                $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus();
                onOpenFunc();
            } catch(er){ console.log(er); }
        },
        close: function(event, ui){
            try{
                $(this).dialog("destroy");
                $("#" + divID).html('');
                onCloseFunc();
            }catch(er){ console.log(er); }
        },
        buttons: {
            "Sí": function(){
                try{ yesCallbackFunc(); }
                catch(er){ console.log(er); }
                $(this).dialog("close");
            },
            "No": function(){
                try{ noCallbackFunc(); }
                catch(er){ console.log(er); }
                $(this).dialog("close");
            }
        }
    });
}

function vx_confirmation(question) {
    var defer = $.Deferred();
    $('<div></div>')
        .html(question)
        .dialog({
            autoOpen: true,
            modal: true,
            title: 'Por favor, confirma:',
            buttons: {
                "Sí": function () {
                    defer.resolve("true", this);//this text 'true' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                },
                "No": function () {
                    defer.resolve("false", this);//this text 'false' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                }
            },
            close: function () {
                $(this).remove();
            }
        });
    return defer.promise();
}

function vx_parseFloat(str){
    return vx_utils.parseFloat(str);
}

function strip_tags(str)
{
    if(!str || !str.length)
        return '';
    return str.replace(/<[^>]+>/g, '');
}

/**
 * Cross file utilities for working with arrays,
 * sorting and other fun stuff
 * @return {Object} vx_utils
 */
var vx_utils = {};
window.fbLoaded = {
    js: [],
    css: [],
}
window.fbEditors = {
    quill: {},
    tinymce: {},
}

// cleaner syntax for testing indexOf element
vx_utils.inArray = function(needle, haystack) {
    return haystack.indexOf(needle) !== -1
}

/**
 * Remove null or undefined values
 * @param  {Object} attrs {attrName: attrValue}
 * @return {Object}       Object trimmed of null or undefined values
 */
vx_utils.trimObj = function(attrs) {
    let xmlRemove = [null, undefined, '', false, 'false']
    for (let attr in attrs) {
        if (vx_utils.inArray(attrs[attr], xmlRemove)) {
            delete attrs[attr]
        } else if (Array.isArray(attrs[attr])) {
            if (!attrs[attr].length) {
                delete attrs[attr]
            }
        }
    }

    return attrs
}

/**
 * Test if attribute is a valid HTML attribute
 * @param  {String} attr
 * @return {Boolean}
 */
vx_utils.validAttr = function(attr) {
    let invalid = [
        'values',
        'enableOther',
        'other',
        'label',
        // 'style',
        'subtype',
    ]
    return !vx_utils.inArray(attr, invalid)
}

/**
 * Convert an attrs object into a string
 *
 * @param  {Object} attrs object of attributes for markup
 * @return {string}
 */
vx_utils.attrString = function(attrs) {
    let attributes = []

    for (let attr in attrs) {
        if (attrs.hasOwnProperty(attr) && vx_utils.validAttr(attr)) {
            attr = vx_utils.safeAttr(attr, attrs[attr])
            attributes.push(attr.name + attr.value)
        }
    }
    return attributes.join(' ')
}

/**
 * Convert attributes to markup safe strings
 * @param  {String} name  attribute name
 * @param  {String} value attribute value
 * @return {Object}       {attrName: attrValue}
 */
vx_utils.safeAttr = function(name, value) {
    name = vx_utils.safeAttrName(name)
    let valString

    if (value) {
        if (Array.isArray(value)) {
            valString = vx_utils.escapeAttr(value.join(' '))
        } else {
            if (typeof value === 'boolean') {
                value = value.toString()
            }
            valString = vx_utils.escapeAttr(value.replace(',', ' ').trim())
        }
    }

    value = value ? `="${valString}"` : ''
    return {
        name,
        value,
    }
}

vx_utils.safeAttrName = function(name) {
    let safeAttr = {
        className: 'class',
    }

    return safeAttr[name] || vx_utils.hyphenCase(name)
}

/**
 * Convert strings into lowercase-hyphen
 *
 * @param  {String} str
 * @return {String}
 */
vx_utils.hyphenCase = function(str) {
    str = str.replace(/[^\w\s\-]/gi, '');
    str = str.replace(/([A-Z])/g, function($1) {
        return '-' + $1.toLowerCase();
    })

    return str.replace(/\s/g, '-').replace(/^-+/g, '');
}

/**
 * convert a hyphenated string to camelCase
 * @param  {String} str
 * @return {String}
 */
vx_utils.camelCase = function(str) { return str.replace(/-([a-z])/g, (m, w) => w.toUpperCase()); }

/**
 * Determine content type
 * @param  {Node | String | Array | Object} content
 * @return {String}                         contentType for mapping
 */
vx_utils.contentType = function(content) {
    let type = typeof content;
    if (content instanceof Node || content instanceof HTMLElement) {
        type = 'node';
    } else if (Array.isArray(content)) {
        type = 'array';
    }

    return type;
}

/**
 * Bind events to an element
 * @param  {Object} element DOM element
 * @param  {Object} events  object full of events eg. {click: evt => callback}
 * @return {void}
 */
vx_utils.bindEvents = function(element, events) {
    if (events) {
        for (let event in events) {
            if (events.hasOwnProperty(event)) {
                element.addEventListener(event, function(evt){ return events[event](evt) });
            }
        }
    }
}

/**
 * Generate a unique name attribute
 * @param  {Object} field
 * @return {String}       name
 */
vx_utils.nameAttr = function(field) {
    let epoch = new Date().getTime();
    let prefix = field.type || vx_utils.hyphenCase(field.label);
    return prefix + '-' + epoch;
}

/**
 * Convert html element attributes to key/value object
 * @param  {Object} elem DOM element
 * @return {Object} ex: {attrName: attrValue}
 */
vx_utils.parseAttrs = function(elem) {
    let attrs = elem.attributes;
    let data = {};
    vx_utils.forEach(attrs, function(attr) {
        let attrVal = attrs[attr].value || '';
        if (attrVal.match(/false|true/g)) {
            attrVal = attrVal === 'true';
        } else if (attrVal.match(/undefined/g)) {
            attrVal = undefined;
        }

        if (attrVal) {
            data[attrs[attr].name] = attrVal;
        }
    })

    return data;
}

/**
 * Convert field options to optionData
 * @param  {NodeList} options  DOM elements
 * @return {Array} optionData array
 */
vx_utils.parseOptions = function(options) {
    let optionData = {};
    let data = [];

    for (let i = 0; i < options.length; i++) {
        optionData = vx_utils.parseAttrs(options[i]);
        optionData.label = options[i].textContent;
        data.push(optionData);
    }

    return data;
}

/**
 * Parse XML formData
 * @param  {String} xmlString
 * @return {Array}            formData array
 */
vx_utils.parseXML = function(xmlString) {
    const parser = new window.DOMParser();
    let xml = parser.parseFromString(xmlString, 'text/xml');
    let formData = [];

    if (xml) {
        let fields = xml.getElementsByTagName('field');
        for (let i = 0; i < fields.length; i++) {
            let fieldData = vx_utils.parseAttrs(fields[i]);
            const options = fields[i].getElementsByTagName('option');

            if (options && options.length) {
                fieldData.values = vx_utils.parseOptions(options);
            }

            formData.push(fieldData);
        }
    }

    return formData;
}

/**
 * Converts escaped HTML into usable HTML
 * @param  {String} html escaped HTML
 * @return {String}      parsed HTML
 */
vx_utils.parsedHtml = function(html) {
    let escapeElement = document.createElement('textarea');
    escapeElement.innerHTML = html;
    return escapeElement.textContent;
}

/**
 * Escape markup so it can be displayed rather than rendered
 * @param  {String} html markup
 * @return {String}      escaped html
 */
vx_utils.escapeHtml = function(html) {
    let escapeElement = document.createElement('textarea');
    escapeElement.textContent = html;
    return escapeElement.innerHTML;
}

// Escape an attribute
vx_utils.escapeAttr = function(str) {
    let match = {
        '"': '&quot;',
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
    };

    const replaceTag = tag => match[tag] || tag;

    return typeof str === 'string' ? str.replace(/["&<>]/g, replaceTag) : str;
}

// Escape attributes
vx_utils.escapeAttrs = function(attrs) {
    for (let attr in attrs) {
        if (attrs.hasOwnProperty(attr)) {
            attrs[attr] = vx_utils.escapeAttr(attrs[attr]);
        }
    }

    return attrs;
}

// forEach that can be used on nodeList
vx_utils.forEach = function(array, callback, scope) {
    for (let i = 0; i < array.length; i++) {
        callback.call(scope, i, array[i]) // passes back stuff we need
    }
}

/**
 * Remove duplicates from an array of elements
 * @param  {Array} array  array with possible duplicates
 * @return {Array}        array with only unique values
 */
vx_utils.unique = function(array) {
    return array.filter((elem, pos, arr) => arr.indexOf(elem) === pos);
}

/**
 * Removes a value from an array
 * @param  {String|Number} val
 * @param  {Array} arr
 */
vx_utils.remove = function(val, arr) {
    let index = arr.indexOf(val);

    if (index > -1) {
        arr.splice(index, 1);
    }
}

/**
 * Checks if remote resource is already loaded
 * @param  {String|Array} src  url of remote script or css
 * @param  {String}       type       'js' or 'css'
 * @return {Boolean}      isCached
 */
vx_utils.isCached = function(src, type = 'js') {
    let isCached = false;
    const cache = window.fbLoaded[$id];
    if (Array.isArray(src)) {
        isCached = src.every(s => vx_utils.inArray(s, cache));
    } else {
        isCached = vx_utils.inArray(src, cache);
    }
    return isCached;
}

/**
 * Appends stylesheets to the head
 * @param  {Array} scriptScr
 * @param  {String} path
 * @return {void}
 */
vx_utils.getStyles = function(scriptScr, path) {
    if (!Array.isArray(scriptScr)) {
        scriptScr = [scriptScr];
    }
    scriptScr.forEach(src => {
        // if a string is passed, assume a href URL
        let type = 'href';
        let key = src;
        let id = '';

        // if an object is passed, work out details from it's properties
        if (typeof src === 'object') {
            type = src.type || (src.style ? 'inline' : 'href');
            id = src.id;
            src = type === 'inline' ? src.style : src.href;
            key = id || src.href || src.style;
        }

        // check we haven't already loaded this css
        if (vx_utils.isCached(key, 'css')) {
            return;
        }

        // append the style into the head
        if (type === 'href') {
            let link = document.createElement('link');
            link.type = 'text/css';
            link.rel = 'stylesheet';
            link.href = (path || '') + src;
            document.head.appendChild(link);
        } else {
            $(`<style type="text/css">${src}</style>`)
                .attr('id', id)
                .appendTo($(document.head));
        }

        // record this is cached
        window.fbLoaded.css.push(key);
    })
}

/**
 * Capitalizes a string
 * @param  {String} str uncapitalized string
 * @return {String} str capitalized string
 */
vx_utils.capitalize = function(str) {
    return str.replace(/\b\w/g, function(m) {
        return m.toUpperCase();
    })
}

vx_utils.merge = function(obj1, obj2) {
    let mergedObj = Object.assign({}, obj1, obj2);
    for (let prop in obj2) {
        if (mergedObj.hasOwnProperty(prop)) {
            if (Array.isArray(obj2[prop])) {
                mergedObj[prop] = Array.isArray(obj1[prop]) ? vx_utils.unique(obj1[prop].concat(obj2[prop])) : obj2[prop];
            } else if (typeof obj2[prop] === 'object') {
                mergedObj[prop] = vx_utils.merge(obj1[prop], obj2[prop]);
            } else {
                mergedObj[prop] = obj2[prop];
            }
        }
    }
    return mergedObj;
}

vx_utils.addEventListeners = function(el, evts, fn) {
    return evts.split(' ').forEach(e => el.addEventListener(e, fn, false));
}

/**
 * Find the closest parent by class
 * @param  {Object} el  DOM element
 * @param  {String} cls class
 * @return {Object}     DOM Element
 */
vx_utils.closest = function(el, cls) {
    let className = cls.replace('.', '');
    while ((el = el.parentElement) && !el.classList.contains(className));
    return el;
}

/**
 * Convert converts messy `cl#ssNames` into valid `class-names`
 *
 * @param  {String} str
 * @return {String} hyphenated string
 */
vx_utils.makeClassName = function(str) {
    return vx_utils.hyphenCase(str.replace(/[^\w\s\-]/gi, ''));
}

/**
 * Make strings safe to be used as classes
 *
 * @param  {String} str string to be converted
 * @return {String}     converter string
 */
vx_utils.safename = function(str) {
    return str
        .replace(/\s/g, '-')
        .replace(/[^a-zA-Z0-9\[\]\_-]/g, '')
        .toLowerCase();
}

/**
 * Strips non-numbers from a number only input
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.forceNumber = function(str) {
    return str.replace(/[^0-9]/g, '');
}
/**
 * Converts a string into a decimal number.
 *
 * @param  {number|string} str string with possible number
 * @param depth
 * @param comma
 * @return {number|string}     string without non-numbers or comma formatted
 */
vx_utils.parseDecimal = function(str= '', depth = 2, comma = '') {
    if(typeof str === "string")
        if(!str || str.length===0)
            return 0.00;
        else
            str = parseFloat(str.replace(/[^-?0-9.]+/g, '').trim()); //.replace(/\,|\$| /g,'') //VCA 05-Feb-2021 Cambié el regex (/[^0-9.]+/g, '') para que regrese números negativos
    str = isNaN(str) ? 0.00 : str;

    str=roundNumber(str, depth);
    str=str.toFixed(depth);
    if(comma.length)
        return CommaFormatted(str, depth);
    else
        return Number(str);
}
/**
 * Converts a string into a float number.
 *
 * @param  {string} str string with possible number
 * @return {number}     string without non-numbers
 */
vx_utils.parseFloat = function(str) {
    if (typeof str === "string") {
        if (!str || str.length === 0) {
            return 0.00;
        }
        // Clean the string to retain only digits, negative sign, and the decimal point
        let cleanedStr = str.replace(/[^0-9.\-]+/g, '').trim();
        let parsed = parseFloat(cleanedStr); // Parse the cleaned string as a float
        return isNaN(parsed) ? 0.00 : parsed; // Return 0.00 if NaN
    }
    return isNaN(parseFloat(str)) ? 0.00 : parseFloat(str); // Fallback for non-string inputs
}

/**
 * Converts a string into an int number.
 *
 * @param  {string} str string with possible number
 * @return {number}     string without non-numbers
 */
vx_utils.parseInt = function(str) {
    if (typeof str === "string") {
        if (!str || str.length === 0) {
            return 0;
        }
        // Clean the string to retain only numeric characters and negative sign
        let cleanedStr = str.replace(/[^0-9\-]+/g, '').trim();
        let parsed = parseInt(cleanedStr, 10); // Use base 10 for parseInt
        return isNaN(parsed) ? 0 : parsed; // Return 0 if NaN
    }
    return isNaN(parseInt(str)) ? 0.00 : parseInt(str); // Fallback for non-string inputs
}

/**
 * Converts a string into string.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseText = function(str) {
    if(typeof str === "string")
        if(!str || str.length===0)
            return "";
    return str;
}
/**
 * Converts a string into string.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseCheckbox = function(str) {
    if(typeof str === "string")
        if(!str || str.length===0)
            return "";
    return str;
}
/**
 * Adds slashes like PHP.
 *
 * @param  {string} str string
 * @return {string}     string with slashes
 */
vx_utils.addslashes = function(str) {
    if(!str || str.length===0)
        return "";
    return str.replace(/\\/g, '\\\\').
    replace(/\u0008/g, '\\b').
    replace(/\t/g, '\\t').
    replace(/\n/g, '\\n').
    replace(/\f/g, '\\f').
    replace(/\r/g, '\\r').
    replace(/'/g, '\\\'').
    replace(/"/g, '\\"');
}

/**
 * Camelliza una cadena de caracteres.
 *
 * @param  {string} str string
 * @return {string}     string camellizado
 */
vx_utils.toCamelCase = function(str) {
    if(!str || str.length===0)
        return "";
    return str.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
}

vx_utils.obtenFecha = function() {
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth()+1; //January is 0!
    var yyyy = today.getFullYear();

    if(dd<10) {
        dd = '0'+dd
    }

    if(mm<10) {
        mm = '0'+mm
    }

    today = dd + '-' + mm + '-' + yyyy;
    return today;
}

/**
 *
 * @param color in HEX form #FFFFFF
 * @param amount positive lightens / negative darkens. (50% es bueno para el blanquear)
 * @returns {string}
 */
vx_utils.adjust_color = function(color, amount) {
    return '#' + color.replace(/^#/, '').replace(/../g, color => ('0'+Math.min(255, Math.max(0, parseInt(color, 16) + amount)).toString(16)).substr(-2));
}

vx_utils.toHtmlEntities = function(_str = '') {
    return _str.replace(/./gm, function (s) {
        // return "&#" + s.charCodeAt(0) + ";";
        return (s.match(/[a-z0-9\s]+/i)) ? s : "&#" + s.charCodeAt(0) + ";";
    });
}
vx_utils.fromHtmlEntities = function(_str) {
    return (_str+"").replace(/&#\d+;/gm,function(s) {
        return String.fromCharCode(s.match(/\d+/gm)[0]);
    })
}
vx_utils.isDefinedAndNotNull = function(value) {
    return typeof value !== "undefined" && value != null;
}
vx_utils.isFunctionDefined = function(value) {
    return value !== null && typeof value === 'function';
}


$.fn.reverse = [].reverse;

$.fn.ia = $.fn.ia || {};
$.fn.muestra = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.css('visibility')==='hidden')
            e.css({'visibility':'visible'}).data('iavisibility',1);
        if(e.css('display')==='none')
            if(wa)
                e.show(args);
            else
                e.show();
    });
};

$.fn.oculta = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.data('iavisibility')=='1')
            e.css({'visibility':'hidden'});
        else if(wa)
            e.hide(arguments);
        else
            e.hide();
    });
};

$.fn.muestraConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).muestra();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.muestra();
    });
};
$.fn.ocultaConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).oculta();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.oculta();
    });
};

$.fn.isHidden = function () {
    if(this.length === 1) {
        var el = $(this);
        return el.css('display')==='none' || el.css('visibility')==='hidden';
    }
    var r={};
    this.each(function() {
        var el = $(this);
        if(typeof el.type !== 'undefined' && el.type==='hidden')
            r = false;
        r = el.css('display')==='none' || el.css('visibility')==='hidden';
    });
    return r;
};

$.fn.valVisible = function(onHiddenReturn) {
    // only visible, onhidden dflt, unchecked checkedbox,
    // $("#valeIncome").find("INPUT").valVisible()
    var e = $(this);
    if(e.length === 0)
        return;
    var ret=[];
    this.each(function() {
        var e = $(this), name=e.attr('name'), r={};
        if(typeof name==='string' && name.length>0) {
            if(e.isHidden())
                r[this.id] = typeof onHiddenReturn === 'undefined' ? 0.00 : onHiddenReturn;
            else
                r[this.id] = myval(e);
            ret[ret.length] = r;
        }
    });
    return ret;
    function myval(el) {
        if(el.attr('type')==='checkbox' || el.attr('type')==='radio')
            if(el.prop('checked'))
                return el.val();
            else
                return;
        if(typeof el.data('autoNumeric') !== 'undefined')
            return el.autoNumeric('get');
        return el.val();
    }
};

function rgb2hex(rgb)
{
    if(rgb.search("rgb") === -1)
        return rgb;
    else
    {
        rgb = rgb.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+))?\)$/);
        function hex(x)
        {
            return ("0" + parseInt(x).toString(16)).slice(-2);
        }
        return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
    }
}

function rgba2hex(orig) {
    let a,
        rgb = orig.replace(/\s/g, '').match(/^rgba?\((\d+),(\d+),(\d+),?([^,\s)]+)?/i),
        alpha = (rgb && rgb[4] || "").trim(),
        hex = rgb ?
            (rgb[1] | 1 << 8).toString(16).slice(1) +
            (rgb[2] | 1 << 8).toString(16).slice(1) +
            (rgb[3] | 1 << 8).toString(16).slice(1) : orig;

    if (alpha !== "") {
        a = alpha;
    } else {
        a = 01;
    }
    // multiply before convert to HEX
    a = ((a * 255) | 1 << 8).toString(16).slice(1)
    hex = hex + a;

    return "#" + hex;
}

if(typeof limpiaBusquedaRapida === 'undefined')
    limpiaBusquedaRapida = function(cleanWhere){
        cleanWhere = typeof(cleanWhere) === 'undefined' ? 'SI' : cleanWhere;
        if(typeof br !== 'undefined')
            br.cleanAll(cleanWhere);
    };

if(typeof ejecutaBusquedaRapida === 'undefined')
    ejecutaBusquedaRapida = function(){
        if(typeof br !== 'undefined')
        br.SQLString();
    };


//'5','4','7'
///Raul 03_09_19
var BusquedaRapida = function (altcolmodel, setDataTypeToJsonLocal = false) {
    // console.log(altcolmodel);

    if(!$vitex_globales.hasOwnProperty("busqueda_rapida_automatica"))
        $vitex_globales.busqueda_rapida_automatica = false;

    var d = new Date(), $me=this,
    colmodel=[],
    place = $('#content'),
    stringSQL=[],
    json_catalogos = {},
    Elements={};

    /** Cache de catálogos de clientes **/
    var clientesCatalogos = {};

    if (!contentBA){
        var contentBA = '<fieldset name="busqueda_access_fs" id="busqueda_access_fs" class="lazy-content" style="visibility: hidden"><legend><strong>Búsqueda Rápida (F8)</strong></legend><div id="content" data-group="" data-order="0"></div></fieldset>';
    }
    if (!gridID){
        var gridID = $('.ui-jqgrid .ui-jqgrid-bdiv table')[0].id;
    }



    this.campos = new Object();
    this.ifields= new Object();
    this.setDataTypeToJsonLocal= setDataTypeToJsonLocal;
    this.inicializado = false;

    this.pre_init = function () {
        if (!place.length) {
            $('#gbox_'+gridID).after(contentBA);
            place = $('#content');
        }
        $.each($('.vx_autoBusquedaRapida'),function(a,b){
            var comp={}, $b = $(b);

            $b.data("type") === undefined ? "" : comp['type']=$b.data("type");
            $b.data("xtrasqlpost") === undefined ? "" : comp['xtrasqlpost']=$b.data("xtrasqlpost");
            $b.data("xtrasqlpre") === undefined ? "" : comp['xtrasqlpre']=$b.data("xtrasqlpre");
            $b.data("extraf") === undefined ? comp['extraf']="" : comp['extraf']=$b.data("extraf");
            $b.data("extraf2") === undefined ? comp['extraf2']="" : comp['extraf2']=$b.data("extraf2");
            $b.data("group") === undefined ? "" : comp['group']=$b.data("group");
            $b.data("groupx") === undefined ? "" : comp['groupx']=$b.data("groupx");
            $b.data("subtype") === undefined ? "" : comp['subtype']=$b.data("subtype");
            $b.data("top") === undefined ? "" : comp['top']=$b.data("top");
            $b.data("table") === undefined ? "" : comp['table']=$b.data("table");
            $b.data("extrafield") === undefined ? "" : comp['extrafield']=$b.data("extrafield");
            $b.data("wfield") === undefined ? "" : comp['wfield']=$b.data("wfield");
            $b.data("options") === undefined ? "" : comp['options']=$b.data("options");
            //se usa para asignar id del witget.
            $b.data("field") === undefined ? "" : comp['field']=$b.data("field");
            $b.data("alterField") === undefined ? "" : comp['alterField']=$b.data("alterField");
            $b.data("order") === undefined ? "" : comp['order']=$b.data("order");
            $b.data("extraf_asignacion") === undefined ? "" : comp['extraf_asignacion']=$b.data("extraf_asignacion");

            let ba_input = $(b).data("input"), campo_encontrado = -1;

            for(let i in colmodel) {
                if(colmodel[i]['index']==ba_input)
                    campo_encontrado = i;
            }

            if(campo_encontrado >= 0) {
                colmodel[campo_encontrado]['label'] = $(b).data("title");
                colmodel[campo_encontrado]['BusquedaRapida'] = comp;
                //console.log(colmodel[campo_encontrado]);
                // return true;
            }
            else
                colmodel.push({index:$(b).data("input"),label:$(b).data("title"),BusquedaRapida: comp});

        });
    };

    this.clone = function () {
        var inc = 0;
        for(let i in altcolmodel)
        {
            if (!altcolmodel.hasOwnProperty(i))
                continue;

            // if (!altcolmodel[i].hasOwnProperty('BusquedaRapida'))
            //     continue;

            if (altcolmodel[i].hasOwnProperty('BusquedaRapida') && altcolmodel[i].BusquedaRapida.hasOwnProperty('no_busqueda_rapida') && altcolmodel[i].BusquedaRapida.no_busqueda_rapida === true)
                continue;
            // if(!altcolmodel.hasOwnProperty(i) && altcolmodel[i].hasOwnProperty('BusquedaRapida') && altcolmodel[i].BusquedaRapida.hasOwnProperty('no_busqueda_rapida') && altcolmodel[i].BusquedaRapida.no_busqueda_rapida == true)
            //     continue;

            //La dejamos por los grids manuales. El orden no lo respeta cuando hay colmodel ='(
            //Arreglado, ya respeta el orden 4-Mayo-23
            if($vitex_globales.busqueda_rapida_automatica) {
                colmodel[inc] = altcolmodel[i];
            }
            inc++;
        }
    };

    this.init = async function (deletePrefix =  false, runAfterRender_ = null) {
        var urlSinParametros = window.location.pathname;

        await this.getPermiso(urlSinParametros);
        
        if(!$vitex_globales.permiso_busqueda) return;
        if(!$vitex_globales.hasOwnProperty("sin_busqueda_rapida"))
            $vitex_globales.sin_busqueda_rapida = false;
        if($vitex_globales.sin_busqueda_rapida)
            return;
        if(this.inicializado)
            return;
        this.clone();
        this.pre_init();

        var parts;

        if (typeof  giacwhere === 'undefined') {
            giacwhere="";
        }

        //var tam_pantalla=window.width-50;
        var tam_segundo='auto',
            grupos={"ba_fecha":"Fechas","ba_monto_between":"Montos","ba_monto":"Montos","ba_t_deposit":"Depositos","ba_bancos":"Bancos","ba_sn":"SI / NO","ba_atrasado":"Atrasados","ba_yes_no":"SI / NO","ba_tagify":"Tagify","ba_multi":"Multiselect","ba_cliente":"Cliente","ba_estado":"Estado","ba_o_estado":"Otro_Estado","ba_categorias":"Categoria","ba_group":"Grupo","ba_multi_color":"Plantilla","ba_tdoc":"Tipo_Documento","ba_link_banco":"Link Banco","ba_sn_especial":"SI / NO"},
            num=100;

            // console.log(colmodel);
    
        for(var i in colmodel) {
            //if(typeof colmodel[i].BusquedaRapida === "undefined")
            // if($vitex_globales.busqueda_rapida_automatica)
                this._deduce_tipo(colmodel[i]);

            if(colmodel[i].BusquedaRapida!=undefined && colmodel[i].BusquedaRapida.hasOwnProperty('type')) {
                let i_order = i;

            var options = {
                posFn       :   [],
                negFn       :   [],
                doPosFn     :   [],
                doNegFn     :   [],
                instances   :   [],
                fns         :   {
                    hoy         :   d,
                    ayer        :   getLastXDays(d, 1),
                    lunes       :   getMondayOfCurrentWeek(d),
                    domingo     :   getSundayOfCurrentWeek(d),
                    primero     :   getDayOfMonth(d, "primero"),
                    ultimo      :   getDayOfMonth(d, "ultimo"),
                    ultimos10   :   getLastXDays(d, 10),
                    pripasado   :   getDayOfMonth(d, "primero", "pasado"),
                    ultpasado   :   getDayOfMonth(d, "ultimo", "pasado"),
                    primeroano  :   getThisYear(d), //VCA OCT2019
                },
                cbs         :   [
                    {'nombre':'_cb_today', 'label':'Today', 'fn':'today', 'fi':'hoy', 'ff':'hoy'},
                    {'nombre':'_cb_yesterday', 'label':'Yesterday', 'fn':'yesterday', 'fi':'ayer', 'ff':'ayer'},
                    {'nombre':'_cb_thisweek', 'label':'This week', 'fn':'thisweek', 'fi':'lunes', 'ff':'domingo'},
                    {'nombre':'_cb_thismonth', 'label':'This month', 'fn':'thismonth', 'fi':'primero', 'ff':'ultimo'},
                    {'nombre':'_cb_lastmonth', 'label':'Last month', 'fn':'lastmonth', 'fi':'pripasado', 'ff':'ultpasado'},
                    {'nombre':'_cb_thisyear', 'label':'This year', 'fn':'thisyear', 'fi':'primeroano', 'ff':'hoy'},  //VCA OCT2019
                ],
                icbs        :   [],
                ifields     :   [],
                input       :   'input',
                field       :   'field',
                sqlString   :   '',
                tipodeBusqueda : 'AND',
                type : '',
                element : {}
            };


            if (deletePrefix) {
                parts =  colmodel[i].index.split(".");
                colmodel[i].index = parts[1]||parts[0];
            }
            var $id = colmodel[i].BusquedaRapida.index_br === undefined ?
                (colmodel[i].index === undefined ? "ba_"+colmodel[i].name : "ba_"+colmodel[i].index) :
                "ba_"+colmodel[i].BusquedaRapida.index_br;


            $id=$id.replace(".","_");

            this.campos[$id]={};

            var title = this.campos[$id].title = colmodel[i].label === undefined ? "" : colmodel[i].label;
            if(!title.length)
                continue;
            title = title.replaceAll('&oacute;', 'ó');
            title = title.replaceAll('&Oacute;', 'Ó');
            title = title.replaceAll('&Uacute;', 'Ú');
            title = title.replaceAll('&uacute;', 'ú');
            title = title.replaceAll('&Eacute;', 'É');
            title = title.replaceAll('&eacute;', 'é');

            this.campos[$id].$id = $id;//colmodel[i].index === undefined ? "" : "ba_"+colmodel[i].index;

            var type= this.campos[$id].type = colmodel[i].BusquedaRapida.type === undefined ? "" : colmodel[i].BusquedaRapida.type;
            var xtrasqlpost = this.campos[$id].xtrasqlpost = colmodel[i].BusquedaRapida.xtrasqlpost === undefined ? "" : colmodel[i].BusquedaRapida.xtrasqlpost ;
            var xtrasqlpre = this.campos[$id].xtrasqlpre = colmodel[i].BusquedaRapida.xtrasqlpre === undefined ? "" : colmodel[i].BusquedaRapida.xtrasqlpre ;
            var extraf = this.campos[$id].extraf = colmodel[i].BusquedaRapida.extraf === undefined ? "" : colmodel[i].BusquedaRapida.extraf ;
            var extraf2 = this.campos[$id].extraf2 = colmodel[i].BusquedaRapida.extraf2 === undefined ? "" : colmodel[i].BusquedaRapida.extraf2 ;
            var extraf_asignacion = this.campos[$id].extraf_asignacion = colmodel[i].BusquedaRapida.extraf_asignacion === undefined ? "" : colmodel[i].BusquedaRapida.extraf_asignacion ;
            var group = this.campos[$id].group = colmodel[i].BusquedaRapida.group === undefined ? "" : colmodel[i].BusquedaRapida.group ;
            var groupx = this.campos[$id].groupx = colmodel[i].BusquedaRapida.groupx === undefined ? "" : colmodel[i].BusquedaRapida.groupx ;
            var subtype = this.campos[$id].subtype = colmodel[i].BusquedaRapida.subtype === undefined ? "" : colmodel[i].BusquedaRapida.subtype ;
            var top = this.campos[$id].top = colmodel[i].BusquedaRapida.top === undefined ? "" : colmodel[i].BusquedaRapida.top ;
            var table = this.campos[$id].table = colmodel[i].BusquedaRapida.table === undefined ? "" : colmodel[i].BusquedaRapida.table ;
            var extrafield = this.campos[$id].extrafield = colmodel[i].BusquedaRapida.extrafield === undefined ? "" : colmodel[i].BusquedaRapida.extrafield ;
            var wfield = this.campos[$id].wfield = colmodel[i].BusquedaRapida.wfield === undefined ? "" : colmodel[i].BusquedaRapida.wfield ;
            var extras = this.campos[$id].extras = colmodel[i].BusquedaRapida.options === undefined ? "" : ",'"+colmodel[i].BusquedaRapida.options.replace(',','\',\'')+"'";
            var field = this.campos[$id].field = colmodel[i].BusquedaRapida.field === undefined ? (colmodel[i].name === undefined ? "lolz" : colmodel[i].name): colmodel[i].BusquedaRapida.field ;
            var alterField = this.campos[$id].alterField = colmodel[i].BusquedaRapida.alterField === undefined ? (colmodel[i].name === undefined ? "alterlolz" : colmodel[i].BusquedaRapida.alterField) : colmodel[i].BusquedaRapida.alterField ;
            var field_force = this.campos[$id].field_force = colmodel[i].BusquedaRapida.field_force === undefined ? "" : atob(colmodel[i].BusquedaRapida.field_force);
            var order = this.campos[$id].order = colmodel[i].BusquedaRapida.order === undefined ? "" : colmodel[i].BusquedaRapida.order;
            //Para asignar opciones una por cada witget
            //var opt = this.campos[$id].opt = colmodel[i].BusquedaRapida.opt === undefined ? "" : colmodel[i].BusquedaRapida.opt;
            var opt = this.campos[$id].opt = options;
            var $field = this.campos[$id].$field = field.split(",");
            //VCA
            var doPosFn = this.campos[$id].doPosFn = extraf.doPosFn === undefined ? "" : extraf.doPosFn;
            var doNegFn = this.campos[$id].doNegFn = extraf.doNegFn === undefined ? "" : extraf.doNegFn;
            var grouplbl = this.campos[$id].grouplbl = extraf.grouplbl === undefined ? "" : extraf.grouplbl;

            var num_neg = extraf.num_neg === undefined ? false : extraf.num_neg;

            this.campos[$id].relaxed_search = extraf.relaxed_search === undefined ? false : extraf.relaxed_search;

            //var group = this.campos[$id].group = colmodel[i].BusquedaRapida.group === undefined ? "" : colmodel[i].BusquedaRapida.group;
            //VCA
            var $fs_id=$id+'_bt_fs';
            var $tmpHtml = '';
            this.campos[$id].SQLString="";
            this.campos[$id].extraf = extraf;
            this.campos[$id].extraf2 = extraf2;

            //VCA /////////////////////////////////////////////////////////
            this.campos[$id].doPosFn = {};
            this.campos[$id].doNegFn = {};
            this.campos[$id].doPosOnChangeFn = {};
            this.campos[$id].doNegOnChangeFn = {};
            grouplbl=group;
            group=!this.campos[$id].group.length ? "" : this.campos[$id].group=this.campos[$id].group.replace(/ /g, '_');

            this.campos[$id].lastFocus = '';

            if(typeof gridhandler === 'string')
                gridhandler = $(gridhandler);

            if(typeof $gridParams === 'undefined')
                $gridParams = gridhandler.jqGrid('getGridParam');

            //Funcion por si SÍ hay onChange
            if((this.campos[$id].extraf.hasOwnProperty('posOnChangeFn') || this.campos[$id].extraf2.hasOwnProperty('posOnChangeFn')) && window.hasOwnProperty("posOnChangeFn_" + $id) && typeof window["posOnChangeFn_" + $id] === 'function')
            {
                this.campos[$id].posOnChangeFn = "posOnChangeFn_" + $id;
            }
            else
            {
                this.campos[$id].posOnChangeFn = "";
            }

            //Funcion por si NO hay onChange
            if(this.campos[$id].extraf.hasOwnProperty('negOnChangeFn') && window.hasOwnProperty("negOnChangeFn_" + $id) && typeof window["negOnChangeFn_" + $id] === 'function')
            {
                this.campos[$id].negOnChangeFn = "negOnChangeFn_" + $id;
            }
            else
            {
                this.campos[$id].negOnChangeFn = "";
            }

            //Funcion por SÍ se ejecuta el SQL
            if(this.campos[$id].extraf.hasOwnProperty('posFn') && window.hasOwnProperty("posFn_" + $id) && typeof window["posFn_" + $id] === 'function')
            {
                this.campos[$id].posFn = "posFn_" + $id;
            }
            else
            {
                this.campos[$id].posFn = "";
            }

            //Funcion por NO se ejecuta el SQL
            if(this.campos[$id].extraf.hasOwnProperty('negFn') && window.hasOwnProperty("negFn_" + $id) && typeof window["negFn_" + $id] === 'function')
            {
                this.campos[$id].negFn = "negFn_" + $id;
            }
            else
            {
                this.campos[$id].negFn = "";
            }

            //El elemento debe ejecutar el SQL incluso con valor en blanco
            this.campos[$id].emptyVal = this.campos[$id].extraf.hasOwnProperty('emptyVal') ? this.campos[$id].extraf.emptyVal : false; //VCA OCT2019
            this.campos[$id].empty_selected_val = this.campos[$id].extraf.hasOwnProperty('empty_selected_val') ? this.campos[$id].extraf.empty_selected_val : false; //VCA 15-06-2021
            this.campos[$id].altField = this.campos[$id].extraf.hasOwnProperty('altField') ? this.campos[$id].extraf.altField : false; //VCA OCT2019
            this.campos[$id].mDec = this.campos[$id].extraf.hasOwnProperty('mDec') ? this.campos[$id].extraf.mDec : "2"; //VCA OCT2019
            //VCA /////////////////////////////////////////////////////////

            var json = new Object();


            var $div = $('<div />',{
                'class':"dved"
            });

            var $divFlexOut = $('<div />',{
                'class':"busq_FlexItems"
            });

            var $divIntG = $('<div />',{
                'class':"busq_FlexRows"
            });

            if(!Elements.hasOwnProperty(group))
                Elements[group]=[];

            if(group!="")
            {
                if($('#g_'+group).length === 0)
                {
                    var fieldset = $('<fieldset></fieldset>').attr('class','black').attr('id','g_f_'+group),
                        legend = $('<legend>'+grouplbl+'</legend>').attr('class','lbl bold'),
                        divw = groupx.hasOwnProperty('width') ? groupx.width : tam_segundo,
                        div_g = $('<div />',{
                            'class':'busq_divGgroup',
                            'id':'g_'+group,
                        });

                    $(legend).appendTo(fieldset);
                    $(fieldset).appendTo(div_g);

                    $($divIntG).append(div_g);

                    place.append($divIntG);
                }
                //$gr = $('#g_f_'+group);
            }


            //Genera un div con el tipo de widget.
            switch(type){

                case "ba_oculto":

                 this.ifields[$id] = {
                        f_values :  $id + "_values"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id,
                            'style':"display:none;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';



                    $tmpHtml += '<div style="position: absolute; width: 90px;height: 50px;display: inline-block; margin-top: 0;"><input autocomplete="off" name="'+this.ifields[$id].f_values+'" id="'+this.ifields[$id].f_values+'" type="text" autocomplete="off" size="9" data-campo="'+$field+'" class="" /></div>';
                    $tmpHtml += '</td>';
                break;

                case "ba_macros":
                    this.ifields[$id] = {};

                    var $fs = $('<div class="dved" style="display: inline; float: left; position: relative;">').append($('#macros_fs')),
                        $le = '',
                        $table = '', $place;
                    $tmpHtml = '';
                    break;

                case "ba_separador":
                    this.ifields[$id] = {};


                    var opts = typeof this.campos[$id].extraf === "object" && Object.keys(this.campos[$id].extraf).length ? this.campos[$id].extraf : {'width':'100%'},
                        $fs = $('<div>').css(opts),
                        $le = '',
                        $table = '', $place;
                    $tmpHtml = '';
                break;

                case "ba_fecha":

                    this.ifields[$id] = {
                        f_fechaIni : $id + "_ini",
                        f_fechaFin : $id + "_fin",
                        f_horaIni : $id + "_time_ini",
                        f_horaFin : $id + "_time_fin"
                    };



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_dates",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%; padding: 0; margin-top: -15px;",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<tr><td><label class="txt13px" for="'+this.ifields[$id].f_fechaIni+'">Between</label>';
                    $tmpHtml += '<td><input autocomplete="off" name="'+this.ifields[$id].f_fechaIni+'" id="'+this.ifields[$id].f_fechaIni+'" type="text" autocomplete="off" size="12" maxlength="14" class="datepicker txt13px" />';
                    $tmpHtml += '<td><input autocomplete="off" name="'+this.ifields[$id].f_horaIni+'" id="'+this.ifields[$id].f_horaIni+'" type="text" autocomplete="off" size="4" class="auto txt13px" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';
                    $tmpHtml += '<tr><td><label class="txt13px" for="'+this.ifields[$id].f_fechaFin+'">and</label>';
                    $tmpHtml += '<td><input autocomplete="off" name="'+this.ifields[$id].f_fechaFin+'" id="'+this.ifields[$id].f_fechaFin+'" type="text" autocomplete="off" size="12" maxlength="14" class="datepicker txt13px" />';
                    $tmpHtml += '<td><input autocomplete="off" name="'+this.ifields[$id].f_horaFin+'" id="'+this.ifields[$id].f_horaFin+'" type="text" autocomplete="off" size="4" class="auto txt13px" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';


                break;

                case "ba_monto":

                    this.ifields[$id] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto :  $id + "_monto",
                        f_tipo :  $id + "_tipo"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place,

                    table = $("<table></table>").attr("style", "width:100%;"),

                    tr = $("<tr></tr>"),
                    td_1 = $("<td></td>").attr("style", "width:40%;"),
                    td_2 = $("<td></td>").attr("style", "width:60%;"),
                    auto_num_neg = num_neg ? ",vMin:-1000000000" : "";



                    $tmpHtml = '';


                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_comparador+'" id="'+this.ifields[$id].f_comparador+'" style="width:90px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select>';

                    td_1.append($tmpHtml);

                    $tmpHtml = '';


                    $tmpHtml += '<div style="vertical-align: top;"><input autocomplete="off" name="'+this.ifields[$id].f_monto+'" id="'+this.ifields[$id].f_monto+'" type="text" autocomplete="off" size="12" data-campo="'+$field+'" class="auto ignore-val txt13px" data-autonumeric="{mNum:10,mDec:'+this.campos[$id].mDec+auto_num_neg+',aSep:\',\'}"/></div>';
                    $tmpHtml += '</td>';

                    td_2.append($tmpHtml);

                    tr.append(td_1).append(td_2);
                    //table.append(tr);
                    $tmpHtml = tr.get(0).outerHTML; //Este es el html final. Ya se agrega a una tabla al final del script.
                    break;
                case "ba_t_deposit":

                    if(typeof extraf=="object")
                    {
                        json = (extraf);
                    }else{
                        json = JSON.parse(extraf);
                    }

                    this.ifields[$id] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto :  $id + "_monto",
                        f_tipo :  $id + "_tipo"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    //var tipo = json.tag.type;

                    table = $("<table></table>").attr("style", "width:100%;"),

                        tr = $("<tr></tr>"),
                        tr_1 = $("<tr></tr>"),
                        td_1 = $("<td></td>").attr("style", "width:40%;"),
                        td_2 = $("<td></td>").attr("style", "width:60%;"),
                        td_3 = $("<td colspan='2'></td>").attr("style", "width:40%;");

                    var select2="";
                    var sufijo = "_selectopts";
                    var sufijo2 = "_selectextra";

                    var select = $("<select></select>").attr("id", this.ifields[$id].f_tipo).attr('name',this.ifields[$id].f_tipo).attr('class','vx_autoBusquedaRapidaSelectize');
                    $.each(json.tag.options,function(index,json){
                        select.append($("<option></option>").attr("value", json.value).text(json.label));
                    });

                    td_3.append((select));
                    tr_1.append(td_3);

                    $tmpHtml = '';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_comparador+'" id="'+this.ifields[$id].f_comparador+'" style="width:90px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select>';

                    td_1.append($tmpHtml);

                    $tmpHtml = '';

                    $tmpHtml += '<div style="vertical-align: top;"><input autocomplete="off" name="'+this.ifields[$id].f_monto+'" id="'+this.ifields[$id].f_monto+'" type="text" autocomplete="off" size="12" data-campo="'+$field+'" class="auto ignore-val" data-autonumeric="{mNum:10,mDec:2,aSep:\',\'}"/></div>';
                    $tmpHtml += '</td>';

                    td_2.append($tmpHtml);

                    tr.append(td_1).append(td_2);

                    //table.append(tr);
                    $tmpHtml = tr_1.get(0).outerHTML + tr.get(0).outerHTML; //Este es el html final. Ya se agrega a una tabla al final del script.

                    break;

                case "ba_bancos":
                    json = JSON.parse(extraf);

                    this.ifields[$id] = {
                        f_banco :  $id + "f_banco"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    var select = $("<select></select>").attr("id", this.ifields[$id].f_banco).attr('name',this.ifields[$id].f_banco).attr('class','vx_autoBusquedaRapidaSelectize');

                    //Vamos a revisar si viene el atributo filePath o ya viene el objecto.
                    //viene el filePath
                    if(json.hasOwnProperty('filePath'))
                    {
                        var url = './json/'+json.filePath;
                        url=url.replace("./json/../","../");
                        var stringData = $.ajax({
                            url: url,
                            async: false
                        }).responseText;


                        json = JSON.parse(stringData);
                        for (var i in json) {
                            if(json.hasOwnProperty(i))
                                select.append($("<option></option>").attr("value", json[i].real_data).text(json[i].label));
                        }
                        $fs.append((select));

                    }
                    else
                    {
                        json=json.options[0];
                        for (var i in json) {

                            select.append($("<option></option>").attr("value", json[i].real_data).text(json[i].label));
                            $fs.append((select));
                        }


                    }

                    break;

                case "ba_sn_especial":

                    this.ifields[$id] = {
                        f_esp :  $id + "_esp"
                    };



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall", //VCA
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }),
                        arre = [];


                    if(typeof this.campos[$id].extraf === "object")
                        $.each(this.campos[$id].extraf, function () {
                            if (this.hasOwnProperty("value"))
                                arre[this.value.toLowerCase()] = {"label": this.label, "value": this.value, "g_var_sql": this.g_var_sql ? this.g_var_sql : ""};
                        });

                    if(!Object.keys(arre).length)
                    {
                        arre['0'] = {"label":"No importa","value":"0"};
                        arre['no'] = {"label":"No","value":"No"};
                        arre['nosin'] = {"label":"No Sin Propias","value":"NoSin"};
                        arre['si'] = {"label":"Sí","value":"Si"};
                    }

                    $tmpHtml = '';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_esp+'" id="'+this.ifields[$id].f_esp+'" style="width:120px;">';

                    for( var i in arre){
                        if(!arre.hasOwnProperty(i)) continue;
                        //console.log(i,arre[i]);
                        $tmpHtml += '<option value="'+arre[i].value+'" data-g_var_sql="'+arre[i].g_var_sql+'">'+arre[i].label+'</option>';
                    }
                    /**
                    $tmpHtml += '<option value="'+arre['0'].value+'">'+arre['0'].label+'</option>';
                    $tmpHtml += '<option value="'+arre['si'].value+'">'+arre['si'].label+'</option>';
                    $tmpHtml += '<option value="'+arre['no'].value+'">'+arre['no'].label+'</option>';
                     **/
                    $tmpHtml += '</select></td>';


                    break;

                case "ba_sn":

                    this.ifields[$id] = {
                        f_sn :  $id + "_sn"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall", //VCA
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_sn+'" id="'+this.ifields[$id].f_sn+'" style="width:120px;">';
                    $tmpHtml += '<option value="0">No importa</option>';
                    $tmpHtml += '<option value="Si">Sí</option>';
                    $tmpHtml += '<option value="No">No</option>';
                    $tmpHtml += '</select></td>';


                    break;

                case "ba_atrasado":
                    var arre=["Fiduciarios Expirados","Fiduciarios Expirados con Solicitud de Reembolso","Error en Contenedo"];

                    this.ifields[$id] = {
                        f_sn :  $id + "_fid_exp_reem"
                    };



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(arre[title]),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    if(title!=2)
                    {
                        $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_sn+'" id="'+this.ifields[$id].f_sn+'" style="width:120px;">';
                        $tmpHtml += '<option value="0">No</option>';
                        $tmpHtml += '<option value="1">Sí</option>';
                        $tmpHtml += '<option value="2">Atrasado</option>';
                        $tmpHtml += '</select></td>';
                    }else{
                        $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_sn+'" id="'+this.ifields[$id].f_sn+'" style="width:120px;">';
                        $tmpHtml += '<option value="0">Todos</option>';
                        $tmpHtml += '<option value="1">No</option>';
                        $tmpHtml += '<option value="2">Sí</option>';
                        $tmpHtml += '</select></td>';
                    }

                    break;

                case "ba_yes_no":

                    this.ifields[$id] = {
                        f_yes :  $id + "_yes",
                        f_no :  $id + "_no"
                    };



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<tr><td><form >';
                    $tmpHtml += '<input  name="'+this.ifields[$id].f_yes+'" id="'+this.ifields[$id].f_yes+'" type="radio" value="1" ><label for="'+this.ifields[$id].f_yes+'" style="cursor: pointer"> Yes</label><br>';
                    $tmpHtml += '<input  name="'+this.ifields[$id].f_yes+'" id="'+this.ifields[$id].f_no+'" type="radio" value="0" ><label for="'+this.ifields[$id].f_no+'" style="cursor: pointer"> No</label><br>';
                    $tmpHtml += '</form></td></tr>';

                    break;

                case "ba_tagify":

                    this.ifields[$id] = {
                        f_in_text :  $id + "",
                        f_in_rad : $id + "_rad"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:300px; height:130px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<div/>',{
                            'style':"width: 100%; margin-top: -20px;",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<input name="'+this.ifields[$id].f_in_text+'" id="'+this.ifields[$id].f_in_text+'" type="text" autocomplete="off" class="toTagify" size="25" data-campo="' + this.campos[$id].$field + '" />';
                    $tmpHtml+='<div style="position: absolute; width: 150px; height: 20px;display: inline-block; left: 50px; bottom: 43px;">';
                    $tmpHtml+='<input id="'+$id+'_exact" name="'+$id+'_exact" type="checkbox" class="checkbox_not" onchange="$(this).siblings(\'label\').removeClass(\'bold\'); if($(this).is(\':checked\')) $(this).siblings(\'label\').addClass(\'bold\');"><label for="'+$id+'_exact" class="_exact pointer txt_080em">Palabra completa</label><br>';
                    $tmpHtml+='<input onclick="if(this.checked){$('+this.ifields[$id].f_in_text+').change();}" name="'+this.ifields[$id].f_in_rad+'" id="'+$id+'_and" value="AND" type="radio"/>';
                    $tmpHtml+='<label class="txt13px" for="'+$id+'_and"><strong>AND</strong></label>';
                    $tmpHtml+='<input onclick="if(this.checked){$('+this.ifields[$id].f_in_text+').change();}" name="'+this.ifields[$id].f_in_rad+'" id="'+$id+'_or" value="OR" type="radio" checked="checked"/>';
                    $tmpHtml+='<label class="txt13px" for="'+$id+'_or"><strong>OR</strong></label></div>';
                    break;

                case "ba_multi": //VCA Agregar la validación de emptyVal

                    if(typeof extraf=="object"){
                        json=(extraf);
                    }else{
                        json=JSON.parse(extraf);
                    }

                    this.ifields[$id] = {
                        f_multi :  $id+"_id_sel"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            //'style':"width:417px; height:257px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place,
                        vxW = 0, vxH = 0, vxEl = 0, vxwEl = 0, $tmpHtml = '';


                    var select = $('<select   size="5" style="height: 200px; " multiple="multiple"></select>');
                    select.attr('id',this.ifields[$id].f_multi);
                    select.attr('name',this.ifields[$id].f_multi);

                    //select.css( 'width', '390px' );
                    select.addClass('multiselect');
                    //select.multiselect({ locale: 'es' });
                    //Vamos a revisar si viene el atributo filePath o ya viene el objecto.
                    //viene el filePath
                    if(json.hasOwnProperty('filePath'))
                    {
                        var furl='./json/'+json.filePath;
                        furl=furl.replace("./json/../","../");

                        var stringData = $.ajax({
                            url: furl,
                            async: false,
                            success: function(stringData) {
                                if(stringData!="")
                                {
                                    json = JSON.parse(stringData);
                                    vxEl = Object.keys(json).length; //VCA OCT2019
                                    for (var i in json) {
                                        if(json.hasOwnProperty(i) && i!='md5'){
                                            select.append($("<option></option>").attr("value", (!json[i].real_data || !json[i].real_data.length) && ($campos[$id].emptyVal || $campos[$id].empty_selected_val) ? "" : (!json[i].real_data ? json[i].label : json[i].real_data)).text(json[i].label));
                                            vxwEl = json[i].label.length > vxwEl ? json[i].label.length : vxwEl;
                                        }
                                    }

                                }

                            },
                            error: function(){
                                alert("Falta el catalogo: "+furl);
                            }

                        });



                    }
                    else
                    {

                        // {"options":[{[{"real_data":"data_algo","label":"label_algo"},{"real_data":"data_algo1","label":"label_algo1"}]}]}
                        if(json.hasOwnProperty('json_var') && typeof $vitex_globales[json.json_var] !== "undefined")
                            json = $vitex_globales[json.json_var];
                        else
                            json=json.options;

                        if (json == null || typeof json==='undefined') {
                            console.log(this.ifields[$id]);
                            json = [];
                        }

                        vxEl = Object.keys(json).length; //VCA OCT2019
                        let selectedOption = colmodel[i].BusquedaRapida.default || '';
                        for (var i in json)
                        {
                            if(json.hasOwnProperty(i) && (i!='md5' && i != 'isOnArray' && i != 'pushArray')){
                                let _label = json[i].label || json[i],
                                    _value = json[i].real_data || i;

                                let selected = selectedOption === _value ? " SELECTED='selected' " : ''; //" SELECTED='selected' ";//
                                if(_value.length && _label.length || (!_value.length && !_label.length && ($campos[$id].emptyVal || $campos[$id].empty_selected_val)))
                                    select.append($(`<option${selected}></option>`).attr("value", _value).text(_label));
                                vxwEl = _label.length > vxwEl ? _label.length : vxwEl;
                            }

                        }
                    }

                    //VCA SEP2019
                    vxH = vxEl < 8 ? 139 : 215;
                    vxW = (vxwEl * 20) + (vxEl > 7 ? 30 : 10); //VCA MAR2020
                    vxW = vxW < 240 ? 240 : (vxW > 460) ? 460 : vxW;
                    select.css('width', vxW + 'px').css('height', (vxH+10) + 'px');

                    $fs.css('width', (vxW+10)+ 'px').css('height', (vxH+20) + 'px');
                    $fs.append((select));
                    if(typeof $campos !== "undefined" && $campos[$id].hasOwnProperty("extraf") && $campos[$id].extraf.hasOwnProperty("campo_catalogo")) {

                        this.ifields[$id]["f_in_text"] = $id + "";
                        this.ifields[$id]["f_in_rad"] = $id + "_rad";

                        $tmpHtml += '<div style="position: absolute; width: 150px;height: 20px;display: inline-block; left: 40px; bottom: 25px;">';
                        $tmpHtml += '<input onclick="if(this.checked){$(' + this.ifields[$id].f_in_text + ').change();}" name="' + this.ifields[$id].f_in_rad + '" id="' + $id + '_and" value="AND" type="radio"/>';
                        $tmpHtml += '<label class="txt13px" for="' + $id + '_and"><strong>AND</strong></label>';
                        $tmpHtml += '<input onclick="if(this.checked){$(' + this.ifields[$id].f_in_text + ').change();}" name="' + this.ifields[$id].f_in_rad + '" id="' + $id + '_or" value="OR" type="radio" checked="checked"/>';
                        $tmpHtml += '<label class="txt13px" for="' + $id + '_or"><strong>OR</strong></label></div>';
                    }//VCA SEP2019

                break;

                case "ba_autocomplete_generico":
                case "ba_cliente":

                    this.ifields[$id] = {
                        f_cliente_i :  $id + "_in",
                        f_cliente_i_id :  $id + "_in_id",
                        f_cliente_c :  $id + "_che"
                    };


                    var height = '130px',class_tagify = "toTagify", mtop = "margin-top: -20px;";
                    if (!this.campos[$id].extraf.isTagify) {
                        height = '60px';
                        class_tagify = "";
                        mtop = "";
                    }

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:300px; height:"+height+";"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%;"+mtop,
                        }), $place;

                    $tmpHtml = '';

                    if (!this.campos[$id].extraf.isAjax) {
                        $tmpHtml+='<input class="txt13px bold '+class_tagify+'" autocomplete="off" name="'+this.ifields[$id].f_cliente_i+'" id="'+this.ifields[$id].f_cliente_i+'" type="text" autocomplete="off" size="30" data-campo="cliente" onfocus="if($(this).val()!=\'\') { $(this).autocomplete(\'search\',$(this).val()); } else {$(this).autocomplete(\'search\',\'#@@#\');}" ondblclick="$(this).autocomplete(\'search\',\'#@@#\');" onblur="" />';
                    } else {
                        $tmpHtml+='<input class="txt13px bold '+class_tagify+'" autocomplete="off" name="'+this.ifields[$id].f_cliente_i+'" id="'+this.ifields[$id].f_cliente_i+'" type="text" autocomplete="off" size="30" data-campo="cliente" onblur="" />';
                    }

                    $tmpHtml+='<input type="hidden" name="'+this.ifields[$id].f_cliente_i_id+'" id="'+this.ifields[$id].f_cliente_i_id+'" type="text" autocomplete="off" data-campo="cliente"  />';
                    $tmpHtml+='<br />';
                    if (!this.campos[$id].extraf.isAjax) {
                        $tmpHtml+='<input name="'+this.ifields[$id].f_cliente_c+'" id="'+this.ifields[$id].f_cliente_c+'" type="checkbox" data-filter="f1"  data-campo="aplicado" value="ON"  >';
                        $tmpHtml+='<label for="'+this.ifields[$id].f_cliente_c+'" class="txt13px">Mostrar Todos</label>';
                        $tmpHtml+='<br />';
                    }

                    if(type === 'ba_autocomplete_generico') {
                        let $tmpHtml_ = "";
                        $tmpHtml_ += '<div class="ba_and_or"><input onclick="if(this.checked){$(' + this.ifields[$id].f_in_text + ').change();}" name="' + this.ifields[$id].f_in_rad + '" id="' + $id + '_and" value="AND" type="radio"/>';
                        $tmpHtml_ += '<label class="txt13px" for="' + $id + '_and"><strong>AND</strong></label>';
                        $tmpHtml_ += '<input onclick="if(this.checked){$(' + this.ifields[$id].f_in_text + ').change();}" name="' + this.ifields[$id].f_in_rad + '" id="' + $id + '_or" value="OR" type="radio" checked="checked"/>';
                        $tmpHtml_ += '<label class="txt13px" for="' + $id + '_or"><strong>OR</strong></label></div>';

                        $table.append($tmpHtml_);
                    }

                    break;

                case "ba_estado":

                    this.ifields[$id] = {
                        f_estado :  $id + "_opt"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:350px; height:300px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;

                    $tmpHtml = '';
                    $tmpHtml+='<select class="selectopts multiselect" name="'+this.ifields[$id].f_estado+'" id="'+this.ifields[$id].f_estado+'" multiple="multiple" size="5" style="height: 250px; width:330px;" >';
                    $tmpHtml+='<option class="option_NEON" value="AA">AA</option>';
                    $tmpHtml+='<option class="option_NEON" value="COMMENTS">COMMENTS</option>';
                    $tmpHtml+='<option class="option_NEON" value="CONTRACT">CONTRACT</option>';
                    $tmpHtml+='<option class="option_NEON" value="GARANTIA">GARANTIA</option>';
                    $tmpHtml+='<option class="option_NEON" value="NAVIERA">NAVIERA</option>';
                    $tmpHtml+='<option class="option_NEON" value="RETORNO">RETORNO</option>';
                    $tmpHtml+='<option class="option_NEON" value="RONY">RONY</option>';
                    $tmpHtml+='<option class="option_ROJO" value="BLOCKED">BLOCKED</option>';
                    $tmpHtml+='<option class="option_ROJO" value="ERROR">ERROR</option>';
                    $tmpHtml+='<option class="option_ROJO" value="HOLD">HOLD</option>';
                    $tmpHtml+='<option class="option_ROJO" value="RETAIN">RETAIN</option>';
                    $tmpHtml+='<option class="option_ROJO" value="STOP">STOP</option>';
                    $tmpHtml+='<option value="APP">APP</option>';
                    $tmpHtml+='<option value="CORRECTED">CORRECTED</option>';
                    $tmpHtml+='<option value="DEV">DEVOLUCION</option>';
                    $tmpHtml+='<option value="FID">FIDUCIARIO</option>';
                    $tmpHtml+='<option value="INC">INC</option>';
                    $tmpHtml+='<option value="INV">INVERSION</option>';
                    $tmpHtml+='<option value="LT">LINK</option>';
                    $tmpHtml+='<option value="LP">PARCIAL</option>';
                    $tmpHtml+='<option value="NA">NA</option>';
                    $tmpHtml+='<option value="ND">ND</option>';
                    $tmpHtml+='<option value="NEW">NEW</option>';
                    $tmpHtml+='<option value="PEND">PEND</option>';
                    $tmpHtml+='<option value="Q">Q</option>';
                    $tmpHtml+='<option value="RJ">RJ</option>';
                    $tmpHtml+='<option value="SBC">SBC</option>';
                    $tmpHtml+='<option value="SYS">SYS</option>';
                    $tmpHtml+='</select>';
                    $tmpHtml+='<div style="left: 50px; position: absolute;bottom: 25px;"><a href="javascript:void(0);" onclick="$(\'#'+this.ifields[$id].f_estado+'\').closest(\'div\').find(\'[data-localekey=selectAll]\').click(); $(\'#'+this.ifields[$id].f_estado+' option[value=APP]\').prop(\'selected\',false); $(\'#'+this.ifields[$id].f_estado+'\').multiselect(\'refresh\');" class="toButton">-APP</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+this.ifields[$id].f_estado+'\').closest(\'div\').find(\'[data-localekey=selectAll]\').click(); $(\'#'+this.ifields[$id].f_estado+' option[value=APP]\').prop(\'selected\',false); $(\'#'+this.ifields[$id].f_estado+' option[value=RJ]\').prop(\'selected\',false); $(\'#'+this.ifields[$id].f_estado+'\').multiselect(\'refresh\');" class="toButton">-APP,RJ</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+this.ifields[$id].f_estado+'\').closest(\'div\').find(\'[data-localekey=deselectAll]\').click(); $(\'#'+this.ifields[$id].f_estado+' option[value=ND]\').prop(\'selected\',true); $(\'#'+this.ifields[$id].f_estado+' option[value=NA]\').prop(\'selected\',true); $(\'#'+this.ifields[$id].f_estado+'\').multiselect(\'refresh\');" class="toButton">+ND,NA</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+this.ifields[$id].f_estado+'\').closest(\'div\').find(\'[data-localekey=deselectAll]\').click(); $(\'#'+this.ifields[$id].f_estado+' option[value=ND]\').prop(\'selected\',true); $(\'#'+this.ifields[$id].f_estado+' option[value=NA]\').prop(\'selected\',true); $(\'#'+this.ifields[$id].f_estado+' option[value=SYS]\').prop(\'selected\',true); $(\'#'+this.ifields[$id].f_estado+'\').multiselect(\'refresh\');" class="toButton">+ND,NA,SYS</a></div>';

                    break;

                case "ba_o_estado":

                    this.ifields[$id] = {
                        f_o_estado :  $id + "_o_opt",
                        f_o_estado_and :  $id + "_and",
                        f_o_estado_or :  $id + "_or"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:260px; height:260px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+this.ifields[$id].f_o_estado+'" id="'+this.ifields[$id].f_o_estado+'" multiple="multiple" size="5" style="height: 240px; width:260px;">'+extraf;
                    $tmpHtml+='</select>';
                    $tmpHtml+='<div style="clear:both;"></div>';
                    $tmpHtml+='<div style=" right: 25px; position: absolute;  bottom: 46px;">';
                    $tmpHtml+='<input value="AND" name="'+this.ifields[$id].f_o_estado_and+'" id="'+this.ifields[$id].f_o_estado_and+'" type="radio" checked />';
                    $tmpHtml+='<label for="'+this.ifields[$id].f_o_estado_and+'"><strong>AND</strong></label>';
                    $tmpHtml+='<input value="OR" name="'+this.ifields[$id].f_o_estado_and+'" id="'+this.ifields[$id].f_o_estado_or+'" type="radio" />';
                    $tmpHtml+='<label for="'+this.ifields[$id].f_o_estado_or+'"><strong>OR</strong></label>';
                    break;

                case "ba_asignacion":

                    this.ifields[$id] = {
                        f_comparador :   $id + "_comp_sel",
                        f_o_estado :  $id + "_o_opt",
                        f_o_estado_and :  $id + "_and",
                        f_o_estado_or :  $id + "_or"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:280px; height:200px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    $tmpHtml += '<select class="selectopts selectopts-asig vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_comparador+'" id="'+this.ifields[$id].f_comparador+'" style="width:100%; margin-bottom: 1em;">';

                    if(typeof this.campos[$id].extraf_asignacion === "object")
                        $.each(this.campos[$id].extraf_asignacion, function () {
                            if (this.hasOwnProperty("value"))
                                $tmpHtml += '<option value="'+this.value+'">'+this.label.toUpperCase()+'</option>';
                        });
                    $tmpHtml+='</select>';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+this.ifields[$id].f_o_estado+'" id="'+this.ifields[$id].f_o_estado+'" multiple="multiple" size="5" style="height: 120px; width:280px;">'+extraf;
                    $tmpHtml+='</select>';
                    $tmpHtml+='<div style="clear:both;"></div>';
                    $tmpHtml+='<div style=" right: 25px; position: absolute;  bottom: 46px;">';
                    $tmpHtml+='<input value="AND" name="'+this.ifields[$id].f_o_estado_and+'" id="'+this.ifields[$id].f_o_estado_and+'" type="radio" checked />';
                    $tmpHtml+='<label for="'+this.ifields[$id].f_o_estado_and+'"><strong>AND</strong></label>';
                    $tmpHtml+='<input value="OR" name="'+this.ifields[$id].f_o_estado_and+'" id="'+this.ifields[$id].f_o_estado_or+'" type="radio" />';
                    $tmpHtml+='<label for="'+this.ifields[$id].f_o_estado_or+'"><strong>OR</strong></label>';
                    break;

                case "ba_categorias":

                    this.ifields[$id] = {
                        f_categorias :  $id + "_cat"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:349px; height:89px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;

                    $tmpHtml = '';
                    $tmpHtml+='<select id="'+this.ifields[$id].f_categorias+'" name="'+this.ifields[$id].f_categorias+'" class="notSelectize"  >';
                    $tmpHtml+='</select>';

                    break;

                case "ba_group":

                    this.ifields[$id] = {
                        f_group_yes :  $id + "_yes",
                        f_group_no :  $id + "_no",
                        f_group :  $id + "_group"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<tr><td><form >';
                    $tmpHtml += '<input  name="'+this.ifields[$id].f_group+'" id="'+this.ifields[$id].f_group_yes+'" type="radio" value="1" > Yes<br>';
                    $tmpHtml += '<input  name="'+this.ifields[$id].f_group+'" id="'+this.ifields[$id].f_group_no+'" type="radio" value="0" > No<br>';
                    $tmpHtml += '</form></td></tr>';

                    break;


                case "ba_multi_color":

                    this.ifields[$id] = {
                        f_multi :  $id + "_multi"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:407px; height:320px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100% ",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+this.ifields[$id].f_multi+'" id="'+this.ifields[$id].f_multi+'" multiple="multiple" size="5" style="height: 240px; width:390px;">'+extraf;

                    $tmpHtml += '</select>';

                    break;

                case "ba_tdoc":

                    this.ifields[$id] = {
                        f_tdoc_cheque :  $id + "_cheque_sel",
                        f_tdoc_pagare :  $id + "_pagare_sel",
                        f_tdoc_vale :  $id + "_vale_sel"
                    };


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_dates",
                            'id':$fs_id,
                            'style':"width:407px; height:320px;"
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100% ",
                        }), $place;
                    $tmpHtml = '';


                    $tmpHtml+='<table style="width: 100%;padding: 0;margin-top: -15px;margin-left: 20px;">';
                    $tmpHtml+='<tr>';
                    $tmpHtml+='<td><label for="origen_cheque_sel"><strong>Cheque: </strong></label>';
                    $tmpHtml+='<td>';
                    $tmpHtml+='<select class="selectopts vx_autoBusquedaRapidaSelectize" name="origen_cheque_sel" id="'+this.ifields[$id].f_tdoc_cheque+'" >';
                    $tmpHtml+='<option value="">Elige</option>';
                    $tmpHtml+='<option value="cc">Cheque Cash</option>';
                    $tmpHtml+='<option value="cl">Cheque Link</option>';
                    $tmpHtml+='<option value="cv">Cheque Vale</option>';
                    $tmpHtml+='<option value="ct">Cheque Todo</option>';
                    $tmpHtml+='</select>';
                    $tmpHtml+='<tr>';
                    $tmpHtml+='<td><label for="origen_pagare_sel"><strong>Pagaré: </strong></label>';
                    $tmpHtml+='<td>';
                    $tmpHtml+='<select class="selectopts vx_autoBusquedaRapidaSelectize" name="origen_pagare_sel" id="'+this.ifields[$id].f_tdoc_pagare+'" >';
                    $tmpHtml+='<option value="">Elige</option>';
                    $tmpHtml+='<option value="pc">Pagaré Cash</option>';
                    $tmpHtml+='<option value="pl">Pagaré Link</option>';
                    $tmpHtml+='<option value="pv">Pagaré Vale</option>';
                    $tmpHtml+='<option value="pt">Pagaré Todo</option>';
                    $tmpHtml+='</select>';
                    $tmpHtml+='<tr>';
                    $tmpHtml+='<td><label for="origen_vale_sel"><strong>Vale: </strong></label>';
                    $tmpHtml+='<td>';
                    $tmpHtml+='<select class="selectopts vx_autoBusquedaRapidaSelectize" name="origen_vale_sel" id="'+this.ifields[$id].f_tdoc_vale+'" >';
                    $tmpHtml+='<option value="">Elige</option>';
                    $tmpHtml+='<option value="vn">Vale Alta</option>';
                    $tmpHtml+='<option value="va">Vale Aplicado</option>';
                    $tmpHtml+='<option value="vt">Vale Todo</option>';
                    $tmpHtml+='</select>';
                    $tmpHtml+='</table>';


                    break;

                case "ba_selectized":

                    this.ifields[$id] = {
                        f_selectize :   $id + "_sel"

                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%;",
                        });

                    $tmpHtml = '<tr><td>';

                    $tmpHtml+='<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_selectize+'" id="'+this.ifields[$id].f_selectize+'"  size="5" style="width:120px;">'+extraf;
                    $tmpHtml+='</select>';

                    $tmpHtml += '</td></tr>';


                    break;

                case "ba_options":

                    this.ifields[$id] = {
                        f_selectize :   $id + "_sel"
                    };
                    var options = '';
                    var dataIsArrayMulti = (typeof extraf2.dataIsArrayMulti != 'undefined') ? extraf2.dataIsArrayMulti: false;
                    if(extraf.hasOwnProperty('filePath'))
                    {
                        var partes = $id.split("_");
                        var keyValue = partes[1] + '_id',
                            keyLabel = partes[1];
                        if (extraf.hasOwnProperty('value'))
                            keyValue = extraf.value;

                        if (extraf.hasOwnProperty('label'))
                            keyLabel = extraf.label;

                        var url = './json/' + extraf.filePath;
                        url=url.replace("./json/../","../");
                        var stringData = $.ajax({
                            url: url,
                            //  cache:false,
                            async: false
                        }).responseText;
                        var data = JSON.parse(stringData);
                        var width = 0;
                        data.forEach(function (ele) {
                            options += `<option value="${ele[keyValue]}">${ele[keyLabel]}</option>`;
                            if (ele[keyLabel].length > width)
                                width = ele[keyLabel].length;
                        });
                        width = (width * 9);
                    } else {
                        var width = 0;
                        if (dataIsArrayMulti) {
                            extraf.forEach(function (option) {
                                options += `<option value="${option.value}">${option.label}</option>`;
                                if (option.label.length > width)
                                    width = option.label.length;
                            });
                        } else {
                            Object.keys(extraf).forEach(function (key) {
                                options += `<option value="${extraf[key]}">${key}</option>`;
                                if (key.length > width)
                                    width = key.length;
                            });
                        }
                        width = (width * 9);
                    }

                    if (width < 120)
                        width = 120;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%;",
                        });

                    $tmpHtml = '<tr><td>';

                    $tmpHtml+='<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_selectize+'" id="'+this.ifields[$id].f_selectize+'"  size="5" style="width:'+width+'px;">';
                    $tmpHtml+=options;
                    $tmpHtml+='</select>';
                    $tmpHtml += '</td></tr>';
                    break;

                case "ba_input":
                    this.ifields[$id] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto :  $id + "_monto",
                        f_tipo :  $id + "_tipo"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }),
                        table = $("<table></table>").attr("style", "width:100%;");

                    var tr = $("<tr></tr>"),
                        td_1 = $("<td></td>").attr("style", "width:40%;"),
                        td_2 = $("<td></td>").attr("style", "width:60%;");


                    var type = 'text',
                        auto_num_neg = num_neg ? ",vMin:-1000000000" : "";
                    if (extraf.type)
                        type = extraf.type;

                    var class_number = '',
                        dataAutoNum = '';
                    if (type === 'autonumeric') {
                        class_number = 'auto';
                        dataAutoNum = 'data-autonumeric="{mNum:10,mDec:'+this.campos[$id].mDec+auto_num_neg+',aSep:\',\'}"';
                        type = 'text';
                    }

                    $tmpHtml = '';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_comparador+'" id="'+this.ifields[$id].f_comparador+'" style="width:90px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select>';

                    td_1.append($tmpHtml);

                    $tmpHtml = '';


                    $tmpHtml = '<div style="vertical-align: top;"> <input type="'+type+'" autocomplete="off" name="'+$id+'" id="'+$id+'" min="0" class="'+class_number+' ignore-val txt13px" data-campo="'+$field+'" '+dataAutoNum+'></div>';

                    td_2.append($tmpHtml);

                    tr.append(td_1).append(td_2);

                    $tmpHtml = tr.get(0).outerHTML; //Este es el html final. Ya se agrega a una tabla al final del script.

                    break;

                case "ba_monto_between":

                    this.ifields[$id] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto_1 :  $id + "_monto_1",
                        f_monto_2 :  $id + "_monto_2",
                        f_tipo :  $id + "_tipo"
                    };

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(title),
                        $table = $('<table />',{
                            'style':"width: 100%; margin-top: -10px;",
                        }), $place,

                        table = $("<table></table>").attr("style", "width:100%;"),

                        tr = $("<tr></tr>"),
                        td_1 = $("<td></td>").attr("style", "width:40%;"),
                        td_2 = $("<td></td>").attr("style", "width:60%;"),
                        auto_num_neg = num_neg ? ",vMin:-1000000000" : "";



                    $tmpHtml = '';


                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+this.ifields[$id].f_comparador+'" id="'+this.ifields[$id].f_comparador+'" style="width:90px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="bt">between</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select>';

                    td_1.append($tmpHtml);

                    $tmpHtml = '';


                    $tmpHtml += '<div style="vertical-align: top; margin-bottom: 5px;"><input autocomplete="off" name="'+this.ifields[$id].f_monto_1+'" id="'+this.ifields[$id].f_monto_1+'" type="text" autocomplete="off" size="12" data-campo="'+$field+'" class="auto ignore-val txt13px" data-autonumeric="{mNum:10,mDec:'+this.campos[$id].mDec+auto_num_neg+',aSep:\',\'}"/></div>';

                    $tmpHtml += '<div style="vertical-align: top; margin-bottom: 5px;"><input autocomplete="off" name="'+this.ifields[$id].f_monto_2+'" id="'+this.ifields[$id].f_monto_2+'" type="text" autocomplete="off" size="12" data-campo="'+$field+'" class="auto ignore-val txt13px" data-autonumeric="{mNum:10,mDec:'+this.campos[$id].mDec+auto_num_neg+',aSep:\',\'}" onchange="if(this.value.length) $(\'#'+this.ifields[$id].f_monto_2+'\').parent().parent().siblings().find(\'select.selectopts\')[0].selectize.setValue(\'bt\');"/></div>';

                    $tmpHtml += '</td>';

                    td_2.append($tmpHtml);

                    tr.append(td_1).append(td_2);
                    //table.append(tr);
                    $tmpHtml = tr.get(0).outerHTML; //Este es el html final. Ya se agrega a una tabla al final del script.
                    break;
            }



            if(type === 'ba_separador' || type === 'ba_macros')
                $div = $fs;
            else
            {
                $table.append($tmpHtml);
                $fs.append($le);

                //$div.css('clear', '');
                $div.append($fs);

                //Integra el boton not a on('change') para generar su sql
                var obj_not=$id+'_not';

                var not = '';
                if(type !== "ba_monto_between" && type !== "ba_monto" && type !== "ba_yes_no" && type !== "ba_sn" && /*type !== "ba_sn_especial" && */type !== "ba_group"){
                try{
                    this.ifields[$id].f_not=obj_not;
                }catch(err){
                    console.log(err.message+"---"+$id);
                }

                    not = '<label for="'+obj_not+'" class="vx_adcb_class">Not</label><input id="'+obj_not+'" name="'+obj_not+'" type="checkbox" class="checkbox_not"/>';
                }
                var subcontrol='<div class="ba_not">'+not+'<input type="radio" class="control_t_b" id="'+$id+'_t_b_and" name="'+$id+'_t_b" value="AND" checked><label for="'+$id+'_t_b_and" class="vx_adcb_class">AND</label><input type="radio" class="control_t_b" id="'+$id+'_t_b_or" name="'+$id+'_t_b" value="OR"><label for="'+$id+'_t_b_or" class="vx_adcb_class">OR</label></div>';
                // $table.append(subcontrol);
                $fs.append($table);
                $fs.append(subcontrol);

            }
            var $campos = this.campos,
                $ifields = this.ifields;
            //solo hacer si no es tipo separador
            if(type !== 'ba_separador' && type !== 'ba_macros'&& type !== 'ba_oculto') {
                //El botón de limpieza
                var $adiv = $('<div class="busq_btnCleanBoxOut"/>'),
                    $a = $('<a />', {
                    href: 'javascript:void(0);',
                    'class': 'vx_adcb_limpia',
                    'data-input': $id,
                    'data-fs': $fs_id,
                }).append($('<img />', {
                    src: '/'+gWebDir+'/img/16-erase.png',
                    title: 'Limpiar'
                })).on('click', function () { //Se le asigna el evento onclick para ejecutar la limpieza de su widget exclusivamente.
                    var $a_this = $(this), inst_id = $a_this.data('input'), $fs = $('#' + $a_this.data('fs')),
                        $tmp = $fs.find('input,i,button,select,label.vx_adcb_class,._exact');

                    switch ($campos[inst_id].type) {
                        case 'ba_multi':
                        case 'ba_multi_color':
                        case 'ba_estado':
                        case 'ba_o_estado':
                            $tmp.filter("[data-localekey=deselectAll]").click();
                            break;
                        case 'ba_asignacion':
                            $tmp.filter("[data-localekey=deselectAll]").click();
                            break;

                        case 'ba_tagify':
                        case 'ba_autocomplete_generico':
                            $tmp.filter("[class=tagify-remove]").click();
                            $tmp.filter("[id$='_or']").prop('checked', true);
                            $tmp.filter("[id$='_exact']").prop('checked', false);
                            break;

                        default:

                            //$tmp.filter("[class=control_t_b]").prop('checked', true);
                            $tmp.filter("[type=text]").val('');
                            $tmp.filter("[type=radio]").not('[class=control_t_b]').prop('checked', false);
                            $tmp.filter('select').val('');
                            $tmp.filter('select').not('.notSelectize').each(function () {
                                $(this).selectize()[0].selectize.reset2InitialValue();
                            });

                            break;
                    }

                        $tmp.filter("[name="+inst_id+"_not]").prop('checked', false);
                        $tmp.filter("[name="+inst_id+"_t_b]")[0].click();
                        $tmp.filter("label").removeClass('bold lbl');

                    $me.buildSQLString(inst_id);
                });
                //El botón de limpieza

                $adiv.append($a);
                $fs.append($adiv);


                if (type === "ba_categorias")
                    $me.init_categorias($ifields[$id].f_categorias);

                var $cbswrapper = $('<div style="position: absolute; bottom: 45px; padding-left: 5px;"/>');


                $($campos[$id].opt.cbs).each(function (k, v) {
                    var icbs = [],
                        id = $id,
                        icbsid = $id + this.nombre, tmpel = {}, tmplbl = {},
                        $cbdiv = $('<div style="padding:0; min-width: 95px; float: left;"/>');
                    icbs[icbsid] = {
                        fn: this.fn
                        , fi: this.fi
                        , ff: this.ff
                    };
                    //A la fecha agregamos los botones de los días.
                    if (type === "ba_fecha") {
                        tmpel = $('<input />', {
                            id: icbsid
                            , name: $id + "_vx_autoBusquedaRapida"
                            , value: 'ON'
                            , type: 'radio'
                            , checked: false
                            , 'class': "vx_adcb_class"
                            , 'style': 'padding: 0;'
                        }).on('change', function () {
                            $('#' + $ifields[id].f_fechaIni).datepicker('setDate', $campos[id].opt.fns[icbs[icbsid].fi]);
                            $('#' + $ifields[id].f_fechaFin).datepicker('setDate', $campos[id].opt.fns[icbs[icbsid].ff]);

                            //Para no lanzar el trigger de change:
                            //Ejecutamos las funciones OnChangeFn
                            if($campos[id].posOnChangeFn.length && typeof window[$campos[id].posOnChangeFn] === 'function')
                                window[$campos[id].posOnChangeFn]();

                            $me.buildSQLString(id);
                            $(this).parent().siblings().children("label").removeClass('bold lbl');
                            $("label[for='" + icbsid + "']").addClass('bold lbl');
                        });

                        tmplbl = $('<label />', {
                            'for': icbsid,
                            'class': "vx_adcb_class",
                            'style': 'padding: 0;'
                        }).html(this.label + '&nbsp;&nbsp;');
                    }
                    //VCA OCT2019
                    $cbdiv.append(tmpel).append(tmplbl);
                    $cbswrapper.append($cbdiv);
                    //$table.after($cbswrapper);

                    if (k < 4 && ((k + 1) % 3 === 0) && (type === "ba_t_deposit" || type === "ba_fecha"))
                        $('<div>').css({'clear': 'both'}).appendTo($cbswrapper);
                });

                $table.after($cbswrapper);

            }

            order = !isNaN(order) || order.length ? vx_utils.parseInt(order) : -1;

            $div= $($divFlexOut).append($div);
            // console.log($div, $divFlexOut);

            if(order>0)
            {
                Elements[group][this.obtenIndicedeElements(order, group, 'order')]={element:$div,id:$id,type:type,extraf,order:order,group:group};
            }else{
                // num = this.obtenIndicedeElementsV2(num, group);
                // num = this.obtenIndicedeElements(num, group);
                // Elements[group][num]={element:$div,id:$id,type:type,extraf,order:num,group:group};
                let orden_mezclado = this.obtenIndicedeElements(i_order, group);
                Elements[group][orden_mezclado]={element:$div,id:$id,type:type,extraf,order:orden_mezclado,group:group};
            }

        }
        }
        this.controles();
        this.Ordenar();
        this.inicializado = true;

        if(typeof busquedarapida_callback === 'function')
            schedulerPostTask(
                () => busquedarapida_callback(),
            );
        if(typeof runAfterRender_ === 'function')
            schedulerPostTask(() => {runAfterRender_();});
            // vx_asyncFunction(function() {busquedarapida_callback();},0, this);
    };
    this.getPermiso= async function (location) {
        let segmentos = location.split("/");

        // Obtener la última carpeta
        let ultimaCarpeta = segmentos[segmentos.length - 1];
       
       await $.ajax({
            url: getUrlForAjax('permisos_busqueda'),
            method: 'POST',
            cache: false,
            data: {
                accion: 'setPermiso',
                ultimaCarpeta: ultimaCarpeta,

            },
            processData: true,
            dataType: 'json',
        }).done(function(response, textStatus, jqXHR){
           $vitex_globales["permiso_busqueda"]=response.permiso;

        }).fail(function () {
            ia.alertError("Fallo obtener su permiso para la búsqueda rápida", "Sin Búsqueda Rápida");
            console.log("permisos_busqueda.done response",arguments);
        });

    }
    this.obtenIndicedeElementsV2 = function(num, group, order){
        var indice = 0;
        order = typeof order !== "undefined";

        if(order)
            return num;

        for(;indice<200;indice++){
            if(!Elements[group].hasOwnProperty(indice))
                break;
        }

        return indice;
    };

    this.obtenIndicedeElements = function(num, group, order){
        var indice = 130;
        order = typeof order !== "undefined";

        if(order && !Elements[group].hasOwnProperty(num))
            return num;

        for(;indice<250;indice++){
            if(!Elements[group].hasOwnProperty(indice))
                break;
        }

        return indice;
    };

    this.Ordenar=function(){
        // console.log(Elements);
        var $id="",
        type="",
        $campos = this.campos,
        $ifields = this.ifields;
        var $divFlexContent = $("<div />").addClass("busq_FlexRows divFlexContent");

        for(var i in Elements)
        {
            var $divFlexContentG = $("<div />").addClass("busq_FlexRows divFlexContentG");
            for(var x in Elements[i])
            {
                if(!Elements[i].hasOwnProperty(x))
                    continue;

                // console.log('indexElement->',Elements[i][x].element);
                $id = Elements[i][x].id;

                if(i=="" || i === "C_O_N_T_R_O_L_S" || !Elements[i][x]['group'].length){
                    $($divFlexContent).append(Elements[i][x].element);
                    $('#content').append($divFlexContent);
                }else{
                    $($divFlexContentG).append(Elements[i][x].element);
                    $('#g_f_'+i).append($divFlexContentG);
                }

                if(this.ifields.hasOwnProperty($id) && $id!=="controles"){
                    if(this.ifields[$id].hasOwnProperty('f_cliente_i') && this.ifields[$id].f_cliente_i==this.ifields[$id].f_cliente_i && this.ifields[$id].f_cliente_i!=undefined )
                    {
                        var extraf = $campos[$id].extraf;
                        var id = "#"+$ifields[$id].f_cliente_i;
                        var idx_ = $id;
                        if (extraf.isTagify)
                            id += "-tagify-input";

                        if (!$campos[$id].extraf.isAjax) {

                            if(!json_catalogos[$id])
                                $me.clientes_init_array((Elements[i][x].extraf),$id);

                            let max_items = $campos[$id].extraf.maxItems || 10;


                                setTimeout(function () {
                                    $me.cliente_init_autocomplete(idx_, id, max_items);
                                }, 2000);

                            if (!extraf.isTagify)
                                $me.cliente_init_autocomplete($id);
                        } else {
                            // console.log($campos[$id], $ifields[$id]);

                            var campos = extraf.campos,
                                campos = campos.split(",").map(function(item) {return item.trim();});
                                catalogo = extraf.catalogo,
                                pk =  extraf.pk,
                                order_by = extraf.order_by || '',
                                group_by = extraf.group_by || '',
                                configAutoComplete = {
                                    url: extraf.filePath||getUrlForAjax('catalogos_acciones.php'),
                                    accion: extraf.accion || 'buscar_valor',
                                    campos: campos,
                                    catalogo: catalogo,
                                    pk: pk,
                                    label: extraf.label || '',
                                    group_by: group_by,
                                    order_by: order_by.length ? order_by : extraf.label,
                                    minLength: 2,
                                    extra_where : extraf.extra_where ||'',
                                }
                                ;

                            // console.log(id);
                            setTimeout(function () {
                                // console.log('here', id +" activado");
                                $d.initAutoCompleteAjax(id, configAutoComplete, null, function (item) {
                                    $(id).blur().focus();
                                });
                            }, 3000)
                            
                        }
                    }
                    if(this.ifields[$id].hasOwnProperty('f_cliente_c') && this.ifields[$id].f_cliente_c==this.ifields[$id].f_cliente_c && this.ifields[$id].f_cliente_c!=undefined )
                    {
                        if (!$campos[$id].extraf.isAjax) {
                            if(typeof (Elements[i][x].extraf)=='string'){
                                $me.clientes_init_array(JSON.parse(Elements[i][x].extraf),$id);
                            }else if(typeof (Elements[i][x].extraf)==='object') {
                                $me.clientes_init_array((Elements[i][x].extraf),$id);
                            }
                        }
                    }
                }else{
                    $me.init_botones();
                }
            }
        }

        var clone_controllers = false;
        // if (typeof busqueda_desde_iacase !== 'undefined' && busqueda_desde_iacase == true)
            clone_controllers = true;

        if (clone_controllers) {
            var $controllers = $('#controles');
            var $parent_controllers = $controllers.parent('div');
            var $clone_controls = $controllers.clone();
            $controllers.remove();
            if ($parent_controllers.html() == null || $parent_controllers.html() === '')
                $parent_controllers.remove();

            if ($('#content div.busq_FlexRows:first .busq_FlexRows.divFlexContentG').length>0)
                $('#content div.busq_FlexRows:first .busq_FlexRows.divFlexContentG').prepend($clone_controls);
            else {
                $('div.busq_FlexRows:first').prepend($clone_controls);
            }
            // $('#content div.busq_FlexRows:first')
            // $('div.busq_FlexRows:first').prepend($clone_controls);
            // .prepend($('div.busq_FlexRows:first'));
            // $clone_controls.insertBefore($('#content  > div.busq_FlexRows:first-child'));
            // $clone_controls.insertBefore($('#content #g_f_F_R_E_C_U_E_N_T_E_S div.busq_FlexRows:first .busq_FlexItems:first'));
        }

        //VCA fire and forget en los inicializadores, para evitar bloquear la pantalla.
        for(var i in $campos)
        {
            $id = $campos[i].$id;


            //Se asigna a cada ifield cuando cambie haga el sql
            $.each($ifields[$id], function(k,v){
                var id=$id,
                    t_extraf=$campos[i].extraf,
                    $v = $('#'+v);
                //$('#'+v).on('change', function()
                //$v.on('input', function(){ $(this).change(); } );
                $v.on('blur', function(){ $(this).change(); } );
                $v.on('change', function()
                {
                    if($($ifields[id].f_cliente_c).is(':checked'))
                        $($ifields[id].f_cliente_c).attr('checked', true).prop('checked', true);
                    else
                        $($ifields[id].f_cliente_c).attr('checked', false).prop('checked', false);

                    if($campos[id].type === "ba_fecha") {
                        $("#"+id+"_bt_fs").find('label.vx_adcb_class').removeClass("lbl bold");
                        $("#"+id+"_bt_fs").find('input.vx_adcb_class').prop("checked", false);
                    }
                    if(v == $ifields[id].f_cliente_c)
                    {
                        if(typeof (t_extraf)=='string'){
                            br.clientes_init_array(JSON.parse(t_extraf),id);
                        }else if(typeof (t_extraf)=='object') {
                            br.clientes_init_array((t_extraf),id);
                        }
                    }

                    //Ejecutamos las funciones OnChangeFn
                    if($campos[id].posOnChangeFn.length && typeof window[$campos[id].posOnChangeFn] === 'function')
                        window[$campos[id].posOnChangeFn]();
                    queueMicrotask(function() {
                        br.buildSQLString(id);
                    });

                });
            });

        }

        schedulerPostTask(
            () =>{init_multiselect('busqueda_access_fs', true, false)},
            () =>{init_autoNumeric('busqueda_access_fs')},
            () =>{init_datepicker('busqueda_access_fs')},
            () =>{init_tagify('busqueda_access_fs')},
            () =>{init_boton('busqueda_access_fs')},
            () =>{$('.vx_autoBusquedaRapidaSelectize').filter('select:not(.notSelectize, [class^=ui-], [multiple])').selectize();},
            () =>{
                $("#busqueda_access_fs").muestra();
                $('#macros_fs').show();
                incializaHotKeysInputs("busqueda_access_fs");
                vx_asyncFunction(() =>{init_hotkeys($('#busqueda_access_fs').find('input'));},2000, this);
                },
        );


    };

    this.controles=function(){
        //var group=$('#content').data('group');
        var order=$('#content').data('order') === undefined ? '0' : $('#content').data('order');
        var group =  $('#content').data('group') === undefined ? '' : $('#content').data('group').replace(/ /g, '_');
        /*if("controles" !== grupo)
        {
            '#g_f_'+grupo
        }else{}*/
        //console.log("Grupo>>>> "+grupo);

        /*seteando permisos para la busqueda rápida 
        el permiso dado de alta en permisador_acciones deberá ser el archivo.php sin .php pero con _busqueda
        Ej: el permiso para ayudantes.php será ayudantes_busqueda en el archivo permisador_acciones de la funcion url2permisos
        */
        const urlSinParametros = window.location.pathname;

        const segmentos = urlSinParametros.split("/");

        let ultimaCarpeta = segmentos[segmentos.length - 1];

        ultimaCarpeta= ultimaCarpeta.replace('.php','');
        
        var buttons='';

        
        buttons+='<a href="javascript:void(0);" onclick="br.SQLString();" id="btn_ebr" class="ui-state-default ui-corner-all fm-button-icon-right busq_btnBuscar">Buscar (F6)<span class="ui-icon ui-icon-search"></span></a>';
        buttons+='<a href="javascript:void(0);" onclick="br.cleanAll();" id="btn_lbr" class="ui-state-default ui-corner-all fm-button-icon-left busq_btnClear"><span class="ui-icon ui-icon-arrowreturnthick-1-w"></span> Limpiar (F7)</a>';
        buttons+='<br /><br /><strong>Tipo de Búsqueda:</strong>';
        buttons+='<input name="but_control" value="AND" id="tb_and" type="radio" onclick="br.all_and_or();" checked />';
        buttons+='<label for="tb_and"><strong>AND</strong></label>';
        buttons+='<input name="but_control" value="OR" id="tb_or" type="radio" onclick="br.all_and_or();" />';
        buttons+='<label for="tb_or"><strong>OR</strong></label></div>'
        if($vitex_globales.tipo_rony || $vitex_globales.consultar_permisos)
            var div_key_permisos=$(`<div style="display: inline; margin-left: 10px;"><a href="/${ultimaCarpeta}_busqueda.php"></a><span onclick="permisador.dePrevA(this)" title="Permisos de usuarios para la Búsqueda Rápida" class="ui-icon ui-icon-key permisador"></span></div>`);

        //$controles = $('<div id="controles"></div>').attr('style',' display: inline; float: left; ').attr('id','controles').append( $('<fieldset></fieldset>').attr('class','black').attr('id','f_controles').append( $('<legend>Controles</legend>').attr('class','lbl bold') ).append(buttons));
        $controles = $('<div id="controles" class="busq_FlexItems"></div>').attr('id','controles').append(buttons);

        
        $('#busqueda_access_fs legend:first').append(div_key_permisos);

        if(!Elements.hasOwnProperty(group))
             Elements[group]=[];

        order = parseInt(order);

        if(Elements[group].hasOwnProperty(order))
        {
            //mover el elemento a mano.
            //hacer splice
            Elements[group].splice(order, 0, {element:$controles,id:"controles",type:"ba_controles",extraf:"",group:group});
        }
        else
            Elements[group][order]={element:$controles,id:"controles",type:"ba_controles",extraf:"",group:group};


        //var tam_segundo=tam_pantalla-(tam_pantalla*.18)+'px';


    };

    this.init_categorias = function(id) {
        //if (typeof jQuery.fn.tinymce === 'function') {
        if(typeof $.fn.Clasificator === 'function')
        {
            $('#'+id).Clasificator({
                'readurl':'ajax/categoria_gasto_do.php',
                editable:false,
                maxLevel:3,
                uniqueNameBy:'level',
                topOffsetScroll:200,
            }).Clasificator('selectHeirarchy',true);
        }
    };

    this.buildSQLString=function($id){
        var sqlS="", posDo=false, negDo=false,
            $campos = this.campos,
            $ifields = this.ifields;
        $campos[$id].SQLString = "";

        $campos[$id].doPosFn = {};
        $campos[$id].doNegFn = {};

        switch($campos[$id].type)
        {

            case "ba_oculto":
                var values=$('#'+$ifields[$id].f_values).val();
                $campos[$id].SQLString="";

                if(0!==values.length)
                {
                    $.each($campos[$id].$field, function(k,v){
                        $campos[$id].SQLString += v+" IN (" + values + ")   ";
                    });

                }else{
                    $campos[$id].SQLString = "";
                }
                //console.log($campos[$id].SQLString);

            break;

            case "ba_fecha":

                var adbt_ini=$('#'+$ifields[$id].f_fechaIni).val(),
                    adbt_fin=$('#'+$ifields[$id].f_fechaFin).val(),
                    adbtt_ini=$('#'+$ifields[$id].f_horaIni).val(),
                    adbtt_fin=$('#'+$ifields[$id].f_horaFin).val(), tmp_date;

                let adbt_fin_=adbt_fin,
                    adbt_ini_=adbt_ini;

                if(adbt_ini.length || adbt_fin.length)
                {
                    adbt_ini = adbt_ini.length ? br._cambiaFormatoFecha(adbt_ini) : '2000-01-01';
                    adbt_fin = adbt_fin.length ? br._cambiaFormatoFecha(adbt_fin) : '2100-12-31';

                    let dateFin = new Date(adbt_fin);
                    let dateIni = new Date(adbt_ini);

                    // Compare the dates with time
                    if (dateIni > dateFin) {
                        // console.log('dateIni has the older date.');
                        tmp_date = adbt_fin;
                        adbt_fin = adbt_ini;
                        adbt_ini = tmp_date;

                        $('#'+$ifields[$id].f_fechaIni).val(adbt_fin_);
                        $('#'+$ifields[$id].f_fechaFin).val(adbt_ini_);
                    }

                    adbtt_ini = adbtt_ini.length ? adbtt_ini + ":00:00" : "00:00:00";
                    adbtt_fin = adbtt_fin.length && adbtt_fin < '24' ? adbtt_fin + ":00:00" : "23:59:59";
                    var cont=0;
                    var sqltemp=new Array();
                    $.each($campos[$id].$field, function(k,v){
                        var signo1=">=";
                        var signo2="<=";
                        var signo3="AND";
                        if($('input[name="'+$id+'_not"]')[0].checked){
                            signo1="<";
                            signo2=">";
                            signo3="OR";
                        }
                        sqltemp[cont] = $campos[$id].xtrasqlpre + "(" + v + " "+signo1+" '"+adbt_ini+" "+adbtt_ini+"' "+signo3+" " + v + " "+signo2+" '"+adbt_fin+" "+adbtt_fin+"')" + $campos[$id].xtrasqlpost ;
                        cont++;
                    });
                    $campos[$id].SQLString="("+sqltemp.join(' OR ')+")";
                }else{
                    $campos[$id].SQLString = "";
                }
                //console.log($campos[$id].SQLString);

            break;

            case "ba_monto":
                var asm_monto=$('#'+$ifields[$id].f_monto).val(),
                asm_comp=$('#'+$ifields[$id].f_comparador + " option:selected").val(),
                asm_tipo=$('#'+$ifields[$id].f_tipo + " option:selected").val() || "";
                $campos[$id].SQLString="";

                if(""!=asm_monto.length)
                {
                    asm_monto = asm_monto.length ? vx_utils.parseFloat(asm_monto) : '';
                    //$('#'+$ifields[$id].f_monto).val(CommaFormatted(asm_monto));
                    if ($campos[$id].table=="")
                    {
                        //$campos[$id].SQLString = $campos[$id].xtrasqlpre + "(" + $campos[$id].field + " " + obtenComparador(asm_comp) + "'"+asm_monto+"') " + $campos[$id].xtrasqlpost ;
                        /*
                        $.each($campos[$id].$field, function(k,v){
                            $campos[$id].SQLString += "(" + v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"')   ";
                        });
                        */

                        $.each($campos[$id].$field, function(k,v){
                            $campos[$id].SQLString += "(" + ($campos[$id].field_force.length ? $campos[$id].field_force : v) + " " + obtenComparador(asm_comp) + "'"+asm_monto+"')   ";
                        });
                        $campos[$id].SQLString = $campos[$id].SQLString.length ? $campos[$id].SQLString.substring(0, $campos[$id].SQLString.length - 3) : $campos[$id].SQLString;
                        $campos[$id].SQLString = $campos[$id].xtrasqlpre + $campos[$id].SQLString + $campos[$id].xtrasqlpost;
                    }else{
                        $campos[$id].SQLString = $campos[$id].field+" IN (SELECT "+($campos[$id].extrafield.length ? $campos[$id].extrafield : $campos[$id].wfield)+" FROM "+$campos[$id].table+" WHERE "+$campos[$id].wfield+"='"+asm_monto+"')";
                    }

                }else{
                    $campos[$id].SQLString = "";
                }

            break;

            case "ba_monto_between":
                var asm_monto = asm_monto_1=$('#'+$ifields[$id].f_monto_1).val(),
                asm_monto_2=$('#'+$ifields[$id].f_monto_2).val(),
                asm_comp=$('#'+$ifields[$id].f_comparador + " option:selected").val();

                $campos[$id].SQLString="";

                if(asm_monto_1.length || asm_monto_2.length)
                {
                    asm_monto = asm_monto_1 = asm_monto_1.length ? vx_utils.parseFloat(asm_monto_1) : '';
                    asm_monto_2 = asm_monto_2.length ? vx_utils.parseFloat(asm_monto_2) : '';
                    //$('#'+$ifields[$id].f_monto).val(CommaFormatted(asm_monto));
                    if ($campos[$id].table=="")
                    {

                        if(asm_comp == 'bt'){
                            $campos[$id].SQLString += "(" + ($campos[$id].field_force.length ? $campos[$id].field_force : $campos[$id].$field) + " BETWEEN '" + asm_monto_1 + "' AND '" + asm_monto_2 +"')   ";
                        }
                        else {
                            $.each($campos[$id].$field, function (k, v) {
                                $campos[$id].SQLString += "(" + ($campos[$id].field_force.length ? $campos[$id].field_force : v) + " " + obtenComparador(asm_comp) + "'" + asm_monto + "')   ";
                            });
                        }

                        $campos[$id].SQLString = $campos[$id].SQLString.length ? $campos[$id].SQLString.substring(0, $campos[$id].SQLString.length - 3) : $campos[$id].SQLString;
                        $campos[$id].SQLString = $campos[$id].xtrasqlpre + $campos[$id].SQLString + $campos[$id].xtrasqlpost;
                    }else{
                        $campos[$id].SQLString = $campos[$id].field+" IN (SELECT "+($campos[$id].extrafield.length ? $campos[$id].extrafield : $campos[$id].wfield)+" FROM "+$campos[$id].table+" WHERE "+$campos[$id].wfield+"='"+asm_monto+"')";
                    }

                }else{
                    $campos[$id].SQLString = "";
                }

            break;

            case "ba_t_deposit":
                var asm_monto= $('#'+$ifields[$id].f_monto).val().length ? vx_utils.parseFloat($('#'+$ifields[$id].f_monto).val()) : '';
                asm_comp=$('#'+$ifields[$id].f_comparador + " option:selected").val(),
                asm_tipo=$('#'+$ifields[$id].f_tipo + " option:selected").val(),
                    //VCA Error al generar la consulta. Cuando se busca una cantidad en widthdrawl o deposit. Falta completar ((withdrawal <='50' && deposit ='0') or(deposit <='50'  && withdrawal ='0'))
                extra_campos = $campos[$id]['$field'];

                if(!asm_monto)
                    return sqlString = $campos[$id].SQLString;
                else
                    $('#'+$ifields[$id].f_monto).val(CommaFormatted(asm_monto));


                var sqlf=[];
                $.each($campos[$id].$field, function(k,v){
                    if(asm_tipo==v || asm_tipo==""){
                        let otros_campos_sql = "";
                        $.each(extra_campos, function(index,campo){
                            if(v == campo) return;
                            otros_campos_sql += " AND " + campo + " ='0'";
                        });
                        sqlf.push($campos[$id].xtrasqlpre + "(" + v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"' "+ otros_campos_sql +") " + $campos[$id].xtrasqlpost);
                    }
                });
                if(sqlf.length>1){
                    $campos[$id].SQLString="("+sqlf.join("or")+")";
                }else{
                    $campos[$id].SQLString=sqlf.join("or")
                    ;
                }
                

            break;

            case "ba_bancos":

                var banco_id=$('#'+$ifields[$id].f_banco).val();
                if (banco_id==0) {
                    $campos[$id].SQLString = "";
                }else{
                    var signo="=";
                    if($('input[name="'+$id+'_not"]')[0].checked){
                        signo="!=";
                    }
                    $campos[$id].SQLString = $campos[$id].xtrasqlpre + "("+$campos[$id].field+" "+signo+" '"+banco_id+"')  ";
                }

            break;

            case "ba_sn":

                var delivered=$('#'+$ifields[$id].f_sn).val(),
                    arre= ['0','no','si'],
                    dd = false;
                dd = $campos[$id].extraf.hasOwnProperty('cuentaT_deliveredto_id');
                ba_sn = delivered.toLowerCase();
                arre['0'] = $campos[$id].extraf.hasOwnProperty('TODOS') ? $campos[$id].extraf['TODOS'] : 'TODOS';
                arre['no'] = $campos[$id].extraf.hasOwnProperty('NO') ? $campos[$id].extraf['NO'] : 'NO';
                arre['si'] = $campos[$id].extraf.hasOwnProperty('SI') ? $campos[$id].extraf['SI'] : 'SI';
                

                switch(ba_sn)
                {

                    case "no":
                        if(dd)
                            $campos[$id].SQLString = arre[ba_sn] +" ";
                        else
                            $campos[$id].SQLString =" "+$campos[$id].field+" = '"+arre[ba_sn]+"' ";
                        negDo = true;
                        break;

                    case "si":
                        if(dd)
                            $campos[$id].SQLString = arre[ba_sn] +" ";
                        else
                            $campos[$id].SQLString =" "+$campos[$id].field+" = '"+arre[ba_sn]+"' ";
                        posDo = true;
                        break;

                    case "0":
                        $campos[$id].SQLString = (arre[ba_sn] === 'TODOS') ? "" : arre[ba_sn] +" ";
                        negDo = true;
                        break;
                    /*case "0":
                        $campos[$id].SQLString = (arre[ba_sn] === 'TODOS') ? "" : arre[ba_sn] +" ";
                        negDo = true;
                        break;*/
                }



            break;

            case "ba_sn_especial":


                //console.log($campos[$id].extraf);

                // Genérico
                /*var input_field = $('#'+$ifields[$id].f_esp+' option:selected');
                if(input_field && input_field.val().length)
                {
                    if(input_field.val() === '0'){
                        $campos[$id].SQLString = "";
                    }
                    $campos[$id].SQLString =" "+$campos[$id].field+" = '"+input_field.val()+"' ";

                }
                console.log(input_field, input_field.val());
                console.log($ifields[$id]);*/


                //Afecta_CuentaT
                if(typeof $campos[$id].extraf === "string" && $campos[$id].extraf.includes("act")){
                    var afctat_sel = $('#'+$ifields[$id].f_esp+' option:selected');
                    

                    if(afctat_sel && afctat_sel.val().length)
                    {
                        if(afctat_sel.val() === '0'){
                            $campos[$id].SQLString = "";
                        }
                        ///Agregar opcion al select
                        else if(afctat_sel.val() === 'NoSin'){
                            $campos[$id].SQLString = " (afecta_cuentat = 'NO' AND origen NOT IN ('PROP','INVERSION')) ";
                        }
                        else{
                            $campos[$id].SQLString = " afecta_cuentat='"+afctat_sel.val()+"' ";
                        }
                    }
                }
                //IVA incluido
                if(typeof $campos[$id].extraf === "string" && $campos[$id].extraf.includes("iva")){
                    var iisel = $('#'+$ifields[$id].f_esp+' option:selected');
                    if(iisel && iisel.val().length)
                    {
                        if(iisel.val() === '0')
                            $campos[$id].SQLString += "";
                        else{
                            
                            $campos[$id].SQLString = " iva_incluido = '"+iisel.val()+"' AND factura IN ('FACTURA', 'FACTURA PENDIENTE') ";
                        }

                    }
                }

                //+ IVA
                if(typeof $campos[$id].extraf === "string" && $campos[$id].extraf.includes("+iva")){
                    var misel = $('#'+$ifields[$id].f_esp+' option:selected');
                    

                    if(misel && misel.val().length)
                    {
                        switch(misel.val()){
                            case 'Si':
                                $campos[$id].SQLString = " iva_incluido = 'NO' AND ivacobradox100 > 0 AND ivacobradototal > 0 ";
                                break;

                            case 'No':
                                $campos[$id].SQLString = " ivacobradox100 = 0 AND ivacobradototal = 0 ";
                                break;

                            default:
                                $campos[$id].SQLString += "";
                                break;
                        }
                    }
                }

                //Con Factura
                if(typeof $campos[$id].extraf === "string" && $campos[$id].extraf.includes("factura")){
                    var cfsel = $('#'+$ifields[$id].f_esp+' option:selected');
                    
                    if(cfsel && cfsel.val().length)
                    {
                        switch(cfsel.val()){
                            case 'Si':
                                $campos[$id].SQLString = " factura <> 'DEVOLUCION' AND (factura IN ('FACTURA', 'FACTURA PENDIENTE') OR ivacobradox100 > 0) ";
                                break;

                            case 'No':
                                $campos[$id].SQLString = " (factura IN ('MST') OR ivacobradox100 <> 0) ";
                                break;

                            default:
                                $campos[$id].SQLString += "";
                                break;
                        }
                    }
                }

                //fiduciarios expirados
                if(typeof $campos[$id].extraf === "object" && $campos[$id].extraf.hasOwnProperty("fidExp")){
                    var cfsel = $('#'+$ifields[$id].f_esp+' option:selected');

                    if(cfsel && cfsel.val().length)
                    {
                        switch(cfsel.val()){
                            case 'Si':
                                $campos[$id].SQLString = fidExp;
                                break;

                            case 'No':
                                break;

                            case 'Urge':
                                $campos[$id].SQLString = fidExpUrg;
                                break;

                            default:
                                $campos[$id].SQLString = typeof window[cfsel.data('g_var_sql')] === "undefined" ? "" : window[cfsel.data('g_var_sql')];
                                break;
                        }
                    }
                }

                //fiduciarios modificados
                if(typeof $campos[$id].extraf === "object" && $campos[$id].extraf.hasOwnProperty("fidStatus")){
                    var cfsel = $('#'+$ifields[$id].f_esp+' option:selected');
                    var signo1="=",
                        signo2=" IN ",
                        signo3="";
                    if($('input[name="'+$id+'_not"]')[0].checked){
                        signo1="!=";
                        signo2=" NOT IN ";
                        signo3=" NOT ";
                    }

                    if(cfsel && cfsel.val().length)
                    {
                        switch(cfsel.val()){
                            case 'MODIFICADO':
                                $campos[$id].SQLString = "bloqueado "+signo2+ " ('MODIFICADO','AMBOSMOD','CONTMOD')";
                                break;

                            default:
                                $campos[$id].SQLString =" "+$campos[$id].field+" "+signo1+" '"+cfsel.val()+"' ";
                                break;
                        }
                    }
                }

                //fiduciarios expirados con solicitud de reembolso
                if(typeof $campos[$id].extraf === "object" && $campos[$id].extraf.hasOwnProperty("fidExpReem")){
                    var cfsel = $('#'+$ifields[$id].f_esp+' option:selected');
                    if(cfsel && cfsel.val().length)
                    {
                        switch(cfsel.val()){
                            case 'Si':
                                $campos[$id].SQLString = fidExpReem;
                                break;

                            case 'No':
                                break;

                            case 'Urge':
                                $campos[$id].SQLString = fidExpReemUrg;
                                break;
                        }
                    }
                }

                //Uno nuevo
                if(typeof $campos[$id].extraf === "object" && $campos[$id].extraf.hasOwnProperty("options")){
                    var cfsel = $('#'+$ifields[$id].f_esp+' option:selected');

                    if(cfsel && cfsel.val().length || $campos[$id].emptyVal || $campos[$id].empty_selected_val)
                    {
                        switch(cfsel.val()){
                            case '0':
                                break;

                            default:
                                $campos[$id].SQLString =" "+$campos[$id].field+" = '"+cfsel.val()+"' ";
                                break;
                        }
                    }
                }

                break;

            case "ba_atrasado":

                var delivered=$('#'+$ifields[$id].f_sn).val();
                var arre=["","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND solicitud_reembolso_fecha IS NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))","( DATEDIFF(NOW(),fecha_retiro) > 180 AND terminado = 'No' AND solicitud_reembolso_fecha IS NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 180 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))"];
                var arre2=["","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND solicitud_reembolso_fecha IS NOT NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NOT NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > 3 OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > 3 AND monto_reembolsado = 0 AND monto_cancelado = 0 ))"];
                var arre3=["","( fiduciario_id IN (SELECT fiduciario_id FROM fiduciario_contenedor WHERE error='No' ))","( fiduciario_id IN (SELECT fiduciario_id FROM fiduciario_contenedor WHERE error IN ('Si','Tu') ))"];

                switch(title)
                {
                    case 0:
                        $campos[$id].SQLString =arre[delivered];
                    break;

                    case 1:
                        $campos[$id].SQLString =arre2[delivered];
                    break;

                    case 2:
                        $campos[$id].SQLString =arre3[delivered];
                    break;
                }



            break;

            case "ba_yes_no":
                if(!$campos[$id].field.length)
                    break;
                var arre=['NO','SI'],
                yes_no=$('input:radio[name='+$ifields[$id].f_yes+']:checked').val();

                arre[0] = $campos[$id].extraf.hasOwnProperty('NO') ? $campos[$id].extraf['NO'] : 'NO';
                arre[1] = $campos[$id].extraf.hasOwnProperty('SI') ? $campos[$id].extraf['SI'] : 'SI';
                arre[2] = $campos[$id].extraf.hasOwnProperty('SI') || $campos[$id].extraf.hasOwnProperty('NO') ? true : false

                if(yes_no!=undefined){
                    //Porque hay campos de SI/NO YES/NO cuyo valor es 0,1 ó SI,NO
                    if(arre[2])
                        $campos[$id].SQLString ="("+arre[yes_no]+$campos[$id].extras+") ";
                    else
                    {
                        if($campos[$id].extraf.hasOwnProperty('resBinary'))
                            $campos[$id].SQLString ="(`"+$campos[$id].field+"`='"+yes_no+"' "+$campos[$id].extras+") ";
                        else
                            $campos[$id].SQLString ="(`"+$campos[$id].field+"`='"+yes_no+"' OR `"+$campos[$id].field+"` IN ('"+arre[yes_no]+"'"+$campos[$id].extras+")) ";
                    }
                }else{
                    $campos[$id].SQLString ="";
                }



            break;


            case "ba_tagify":
                var signo1="LIKE";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1="NOT LIKE";
                }

                if ($("#"+$ifields[$id].f_in_text).val()!=="")
                {

                    if ($campos[$id].table=="")
                    {
                        $campos[$id].SQLString = "("+ buildStringwithDelimeters('','','',$ifields[$id].f_in_text,'SI',$campos[$id].$field,signo1,$campos[$id]) + ")";
                        console.log('here',$ifields[$id].f_in_text )
                    }else{
                        
                        var valores=$("#"+$ifields[$id].f_in_text).val().split(",");
                        var sub="'%"+valores.join("%' "+$('input:radio[name='+$ifields[$id].f_in_rad+']:checked').val()+" "+$campos[$id].field+" "+signo1+" '%")+"%' ";
                        $campos[$id].SQLString = $campos[$id].field+" IN (SELECT "+($campos[$id].extrafield.length ? $campos[$id].extrafield : $campos[$id].wfield)+" FROM "+$campos[$id].table+" WHERE "+$campos[$id].wfield+" "+signo1+" "+ sub +")";
                    }
                }else{
                    $campos[$id].SQLString = "";
                }



            break;

            case "ba_multi":

                var m_selec=$("#"+$ifields[$id].f_multi).val(),
                    nueva_bc_id = m_selec.join('\',\''),
                    operador_pers = $campos[$id].extraf.hasOwnProperty("campo_catalogo") ? "LIKE" : "",

                    signo1= operador_pers.length ? operador_pers : "IN",
                    signo2=" <> ",
                    signo3="",
                    tmpSql = '';


                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1=operador_pers.length ?  "NOT " + operador_pers : "NOT IN";
                    signo2=" = ";
                    signo3=" NOT ";
                }

                // $gridParams.postData[$campos[$id].field] = m_selec;

                if(m_selec.length || $campos[$id].emptyVal || $campos[$id].empty_selected_val){

                    if($campos[$id].altField) {
                            tmpSql += "( " + $campos[$id].$field[0] + " " + signo3 + " IN ('" + nueva_bc_id + "')";

                            tmpSql += (tmpSql.length ? ( signo3.length ? " AND " : " OR ") : "") + " " + $campos[$id].$field[1] + " " + signo3 +" IN ('" + nueva_bc_id + "') )";
                        $campos[$id].SQLString = tmpSql;
                    }
                    else if(operador_pers.length){
                        for(let i_opt in m_selec){
                            if(m_selec.hasOwnProperty(i_opt))
                                tmpSql +=  (tmpSql.length ? $('input:radio[name='+$ifields[$id].f_in_rad+']:checked').val() : "") + " " + $campos[$id].$field + " " + operador_pers + " '%" + m_selec[i_opt] + "%' ";
                        }
                        $campos[$id].SQLString = tmpSql.length ? " (" + tmpSql + ") " : "";
                    }
                    else{
                        if (!m_selec.length && $campos[$id].emptyVal)
                            $campos[$id].SQLString = $campos[$id].field + " " + signo2 + " ''  ";
                        else if (m_selec.length)
                            $campos[$id].SQLString = $campos[$id].field + " " + signo1 + " ('" + nueva_bc_id + "')  ";
                    }
                    posDo = typeof banco_cuenta_id !== "undefined" ? (nueva_bc_id != banco_cuenta_id ? true : false) : true;

                    if($campos[$id].xtrasqlpre.length)
                        $campos[$id].SQLString = $campos[$id].xtrasqlpre + $campos[$id].SQLString + $campos[$id].xtrasqlpost;
                }else{
                    $campos[$id].SQLString="";
                    negDo = false;
                }


            break;

            case "ba_autocomplete_generico":
                $campos[$id].SQLString = "";
                var signo1="=",
                    signo2=" IN ",
                    signo3="";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1="!=";
                    signo2=" NOT IN ";
                    signo3=" NOT ";
                }

/*                var isJsonField = $campos[$id].extraf.hasOwnProperty('isJsonField') && $campos[$id].extraf.isJsonField == true,
                    json_field = $campos[$id].extraf.json_field, json_lbl = $campos[$id].extraf.json_lbl, json_id = $campos[$id].extraf.json_id,
                    json_table_pk = $campos[$id].extraf.json_table_pk, json_table = $campos[$id].extraf.json_table,
                str_extra_where = "(EXISTS(" +
                    "              SELECT 1" +
                    "              FROM nota_bodega nbj" +
                    "                JOIN JSON_TABLE(nbj.`" + json_field + "`, '$[*]' COLUMNS (\n" +
                    "                    fue_error VARCHAR(2) PATH '$.fue_error',\n" +
                    "                    lbl TEXT PATH '$." + json_lbl + "'\n" +
                    "                )) AS j\n" +
                    "              WHERE " + json_table + "." + json_table_pk + "=nbj." + json_table_pk + " AND \n" +
                    "          )) ";*/

                if($campos[$id].altField) {
                    var tmpSql = '';
                    if($("#" + $ifields[$id].f_cliente_i_id).val())
                        tmpSql += " " + $campos[$id].$field[0] + " " + signo3 + " LIKE '%" + $("#" + $ifields[$id].f_cliente_i_id).val().toUpperCase() + "%'";
                    if(!$("#" + $ifields[$id].f_cliente_i_id).val() && $("#" + $ifields[$id].f_cliente_i).val())
                        tmpSql += (tmpSql.length ? ( signo3.length ? " AND " : " OR ") : "") + " " + $campos[$id].$field[1] + " " + signo3 +" LIKE '%" + $("#" + $ifields[$id].f_cliente_i).val() + "%'";
                    $campos[$id].SQLString = tmpSql;
                }
                else if($("#"+$ifields[$id].f_cliente_i).val().length  && $("#"+$ifields[$id].f_cliente_i_id).val().length)
                {
                    $campos[$id].SQLString = " " + $campos[$id].field + " "+signo1+" '" + $("#" + $ifields[$id].f_cliente_i_id).val().toUpperCase() + "'";
                }
                else if($("#"+$ifields[$id].f_cliente_i).val().length  )
                {
                    var extraf = $campos[$id].extraf;
                    if (!extraf.isTagify) {
                        var extraf2 = $campos[$id].extraf2;
                        var fieldpk = extraf2.field ||$campos[$id].field;
                        var fieldWhereLike = extraf2.fieldWhereLike || fieldpk.replace("_id","");
                        var tableSeacrh = extraf2.tableSeacrh ||fieldWhereLike;
                        $campos[$id].SQLString = " "+$campos[$id].field+" "+signo2+" (SELECT "+fieldpk+" FROM "+tableSeacrh+" WHERE "+fieldWhereLike+" LIKE '%"+$("#"+$ifields[$id].f_cliente_i).val().toUpperCase()  +"%')";
                    } else {
                        var extraf2 = $campos[$id].extraf2;
                        var fieldpk = extraf2.field ||$campos[$id].field;
                        var fieldWhereLike = extraf2.fieldWhereLike || fieldpk.replace("_id","");
                        var tableSeacrh = extraf2.tableSeacrh ||fieldWhereLike;
                        
                        var where_like = [];
                        var values =$("#"+$ifields[$id].f_cliente_i).val().split(";");

                        if(_app === 'nota_bodega'){
                            let ponActual = fieldWhereLike.endsWith("_actual") ? "" : "";
                            let where_like_tmp = `MATCH (${fieldWhereLike}${ponActual}, cliente_actual_id) AGAINST('`;

                            values.forEach(function (value) {
                                value = value.toUpperCase();
                                where_like_tmp += `"${value}",`;
                            });
                            if (where_like_tmp.trim().length) {
                                where_like_tmp = where_like_tmp.slice(0, -1);
                            }
                            where_like_tmp += "')"
                            where_like = where_like_tmp;

                        }
                        else {
                            values.forEach(function (value) {
                                value = value.toUpperCase();
                                where_like.push(`(${fieldWhereLike} LIKE '%${value}%')`);
                            });
                            where_like = where_like.join(" OR ");
                        }
                        // $campos[$id].SQLString = " "+$campos[$id].field+" "+signo2+" (SELECT "+fieldpk+" FROM "+tableSeacrh+" WHERE "+where_like+")";
                        $campos[$id].SQLString = "( " + where_like + " )";
                    }
                    
                }else{
                    $campos[$id].SQLString = "";
                }

                break;
            case "ba_cliente":

                $campos[$id].SQLString = "";
                var signo1="=",
                signo2=" IN ",
                signo3="";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1="!=";
                    signo2=" NOT IN ";
                    signo3=" NOT ";
                }

                var isJsonField = $campos[$id].extraf.hasOwnProperty('isJsonField') && $campos[$id].extraf.isJsonField == true;
                //VCA el error Brajan:No funciona la limpieza del cliente en la busqueda rápida
                //Aquí está parte del problema, cuando limpia, no limpia el alter.
                //Llega aquí y el campo alterno tiene valor.
                //VCA OJO Aquí empieza el 01-12-2020
                if($campos[$id].altField) {
                    var tmpSql = '';
                    if($("#" + $ifields[$id].f_cliente_i_id).val())
                        tmpSql += " " + $campos[$id].$field[0] + " " + signo3 + " LIKE '%" + $("#" + $ifields[$id].f_cliente_i_id).val().toUpperCase() + "%'";
                    if(!$("#" + $ifields[$id].f_cliente_i_id).val() && $("#" + $ifields[$id].f_cliente_i).val())
                        tmpSql += (tmpSql.length ? ( signo3.length ? " AND " : " OR ") : "") + " " + $campos[$id].$field[1] + " " + signo3 +" LIKE '%" + $("#" + $ifields[$id].f_cliente_i).val() + "%'";
                    $campos[$id].SQLString = tmpSql;
                }
                else if($("#"+$ifields[$id].f_cliente_i).val().length  && $("#"+$ifields[$id].f_cliente_i_id).val().length)
                {
                    $campos[$id].SQLString = " " + $campos[$id].field + " "+signo1+" '" + $("#" + $ifields[$id].f_cliente_i_id).val().toUpperCase() + "'";
                }
                else if($("#"+$ifields[$id].f_cliente_i).val().length  )
                {
                    $campos[$id].SQLString = " "+$campos[$id].field+" "+signo2+" (SELECT "+$campos[$id].field+" FROM cliente WHERE nombre LIKE '%"+$("#"+$ifields[$id].f_cliente_i).val().toUpperCase()  +"%')";
                }else{
                    $campos[$id].SQLString = "";
                }

            break;


            case "ba_estado":
                var signo1="IN";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1="NOT IN";
                }

                if ($("#"+$ifields[$id].f_estado).val().length>0) {
                    $campos[$id].SQLString =  $campos[$id].field+" "+signo1+" (\'"+$("#"+$ifields[$id].f_estado).val().join('\',\'')+"\')";
                }else{
                     $campos[$id].SQLString = "";
                }


            break;

            case "ba_o_estado":


                if ($("#"+$ifields[$id].f_o_estado).val().length>0) {

                    $campos[$id].SQLString = $me.regex($id);
                }else{
                     $campos[$id].SQLString = "";
                }

            break;
            //OJO VCA Aquí comienzas el 21-04-2021
            case "ba_asignacion":


                if ($("#"+$ifields[$id].f_o_estado).val().length>0) {

                    $campos[$id].SQLString = $me.regex($id);
                }else{
                    $campos[$id].SQLString = "";
                }

                break;


            case "ba_categorias":

                var signo1="=";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1="!=";
                }
                var categoria=$('#'+$ifields[$id].f_categorias).val();
                if(categoria!="")
                {
                    $campos[$id].SQLString =  $campos[$id].field+" "+signo1+" \'"+categoria+"\'  ";
                }else{
                     $campos[$id].SQLString = "";
                }

            break;

            case "ba_group"://VCA falta negar este modulo
            var s_n=$("input:radio[name="+$ifields[$id].f_group+"]:checked").val();

            if(s_n!=undefined)
            {
                this.Agrupar(s_n,$campos[$id].field,$campos[$id].top,$campos[$id].extrafield);
            }else
            {
                this.Agrupar(0,$campos[$id].field,$campos[$id].top,$campos[$id].extrafield);
            }

            break;

            case "ba_multi_color":
//VCA falta negar este modulo
                if ($("#"+$ifields[$id].f_multi).val().length>0) {
                    $campos[$id].SQLString =  $campos[$id].field+" IN (\'"+$("#"+$ifields[$id].f_multi).val().join('\',\'')+"\')";
                }else{
                     $campos[$id].SQLString = "";
                }

            break;

            case "ba_tdoc":
                var consulta=["","",""],glue=[" "," "];
                //VCA falta negar este modulo

                var signo1="";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1=" NOT ";
                }
            if($('#'+$ifields[$id].f_tdoc_cheque).val().length){
                switch($('#'+$ifields[$id].f_tdoc_cheque).val()){
                case 'ct': consulta[0] = signo1 + " ( origen = 'cheque') "; break;
                case 'cc': consulta[0] = signo1 + " ( origen = 'cheque' AND metodo_pago_id = '1') "; break;
                case 'cl': consulta[0] = signo1 + " ( origen = 'cheque' AND metodo_pago_id = '2') "; break;
                case 'cv': consulta[0] = signo1 + " ( origen = 'cheque' AND metodo_pago_id = '14') "; break;
                }
                //local_iacwhere += " OR ";
            }
            else{
                consulta[0]="";
            }

            if($('#'+$ifields[$id].f_tdoc_pagare).val().length){
                switch($('#'+$ifields[$id].f_tdoc_pagare).val()){
                case 'pt': consulta[1] = signo1 + " ( origen = 'pagare') "; break;
                case 'pc': consulta[1] = signo1 + " ( origen = 'pagare' AND metodo_pago_id = '1') "; break;
                case 'pl': consulta[1] = signo1 + " ( origen = 'pagare' AND metodo_pago_id = '2') "; break;
                case 'pv': consulta[1] = signo1 + " ( origen = 'pagare' AND metodo_pago_id = '14') "; break;
                }
                //local_iacwhere += " OR ";
            }
            else{
                consulta[1]="";
            }

            if($('#'+$ifields[$id].f_tdoc_vale).val().length){
                switch($('#'+$ifields[$id].f_tdoc_vale).val()){
                case 'vn': consulta[2] = signo1 + " ( origen = 'vale') "; break;
                case 'va': consulta[2] = signo1 + " ( metodo_pago_id = '14') "; break;
                case 'vt': consulta[2] = signo1 + " ( origen = 'vale' OR metodo_pago_id = '14') "; break;
                }
                //local_iacwhere += " OR ";
            }
            else{
                consulta[2]="";
            }

            if(($('#'+$ifields[$id].f_tdoc_cheque).val().length>0 || $('#'+$ifields[$id].f_tdoc_pagare).val().length>0) && $('#'+$ifields[$id].f_tdoc_vale).val().length>0)
                glue[1] = signo1.length ? " AND " : " OR ";

            if($('#'+$ifields[$id].f_tdoc_cheque).val().length>0 && $('#'+$ifields[$id].f_tdoc_pagare).val().length>0 )
                glue[0] = signo1.length ? " AND " : " OR ";

            if(consulta[0].length || consulta[1].length || consulta[2].length)
                $campos[$id].SQLString =" ("+consulta[0]+glue[0]+consulta[1]+glue[1]+consulta[2]+") ";
            else
                $campos[$id].SQLString ="";

            //console.log($campos[$id].SQLString);
            break;

            case "ba_selectized":

                var val=$('#'+$ifields[$id].f_selectize + " option:selected").val();
                var text=$('#'+$ifields[$id].f_selectize + " option:selected").text();

                var signo1=" = ";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1=" <> ";
                }



                if(""!=val.length)
                {
                    if($campos[$id].val_text!=1)
                    {
                        $campos[$id].SQLString = $campos[$id].field+" "+signo1+" '"+val+"' ";
                    }else{
                        $campos[$id].SQLString = $campos[$id].field+" "+signo1+" '"+text+"' ";
                    }


                }else{
                    $campos[$id].SQLString = "";
                }               


            break;
            case "ba_options":

                var val=$('#'+$ifields[$id].f_selectize + " option:selected").val();
                var text=$('#'+$ifields[$id].f_selectize + " option:selected").text();

                var signo1=" = ";
                if($('input[name="'+$id+'_not"]')[0].checked){
                    signo1=" <> ";
                }
                if(""!=val.length)
                {
                    if($campos[$id].val_text!=1)
                    {
                        $campos[$id].SQLString = $campos[$id].field+" "+signo1+" '"+val+"' ";
                    }else{
                        $campos[$id].SQLString = $campos[$id].field+" "+signo1+" '"+text+"' ";
                    }
                }else{
                    $campos[$id].SQLString = "";
                }
                break;

            case 'ba_input':
                var asm_monto=$('#'+$id).val(),
                    asm_comp=$('#'+$ifields[$id].f_comparador + " option:selected").val(),
                    asm_tipo=$('#'+$ifields[$id].f_tipo + " option:selected").val() || "";
                $campos[$id].SQLString="";

                if(""!=asm_monto.length)
                {
                    asm_monto = asm_monto.length ? vx_utils.parseFloat(asm_monto) : '';
                    $('#'+$id).val(CommaFormatted(asm_monto));
                    if ($campos[$id].table=="")
                    {
                        //$campos[$id].SQLString = $campos[$id].xtrasqlpre + "(" + $campos[$id].field + " " + obtenComparador(asm_comp) + "'"+asm_monto+"') " + $campos[$id].xtrasqlpost ;
                        $.each($campos[$id].$field, function(k,v){
                            $campos[$id].SQLString += "(" + v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"')   ";
                        });
                        $campos[$id].SQLString = $campos[$id].SQLString.length ? $campos[$id].SQLString.substring(0, $campos[$id].SQLString.length - 3) : $campos[$id].SQLString;
                        $campos[$id].SQLString = $campos[$id].xtrasqlpre + $campos[$id].SQLString + $campos[$id].xtrasqlpost;
                    }else{
                        $campos[$id].SQLString = $campos[$id].field+" IN (SELECT "+($campos[$id].extrafield.length ? $campos[$id].extrafield : $campos[$id].wfield)+" FROM "+$campos[$id].table+" WHERE "+$campos[$id].wfield+"='"+asm_monto+"')";
                    }

                }else{
                    $campos[$id].SQLString = "";
                }
                break;


        }
        //console.log($campos[$id].SQLString);

        if(posDo && !$campos[$id].doPosFn.hasOwnProperty($id) && $campos[$id].posFn.length)
            $campos[$id].doPosFn[$id] = $campos[$id].posFn;

        if(negDo && !$campos[$id].doNegFn.hasOwnProperty($id) && $campos[$id].negFn.length)
            $campos[$id].doNegFn[$id] = $campos[$id].negFn;

    };

    this.old_iacwhere = '';

    this.SQLString = function(){

        try {


            $(':focus').blur();
            var $campos = this.campos, $me = this;
            //Que siempre haga scroll hacia arriba.
            //if(($('#btn_ebr').offset().top - $(window).scrollTop()) < 950 )
            setTimeout(function () {
                $("html, body").animate({scrollTop: 0});
            }, 50);

            //setTimeout(function(){

            var AllSqlString = "",
                AllSqlStringsAND = [], AllSqlStringsOR = [], old_iacwhere = $gridParams.postData.iacwhere,
                iacwhere = ''
                , tipoDeBusqueda = $('input:radio[name=\'but_control\']:checked').val();

            var widget = null;
            //Recorre el array de widgets y toma su SQLString;
            for (var i in $campos) {
                // Se agrega clase para resaltar los widgets con busqueda
                $me.buildSQLString(i);
                widget = $('#' + $campos[i].$id + '_bt_fs');
                widget.removeClass('busqueda_access_active');

                /*
                                if(i === 'ba_remarks')
                                    console.log(i,$campos[i]);
                */

                if ($campos[i].SQLString !== "") {
                    tipo_busqueda = $('input:radio[name=\'' + $campos[i].$id + '_t_b\']:checked').val();
                    if (tipo_busqueda === "AND") {
                        AllSqlStringsAND.push($campos[i].SQLString);
                    } else if (tipo_busqueda === "OR") {
                        AllSqlStringsOR.push($campos[i].SQLString);
                    }

                    widget.addClass('busqueda_access_active');
                }
            }


            if (typeof giacwhere === 'undefined')
                giacwhere = '';

            if (typeof globalIACWhere === 'undefined')
                globalIACWhere = "";

            if (typeof defWhere === 'undefined')
                defWhere = "";

            if (typeof trim_giacwhere === 'undefined')
                trim_giacwhere = false;

            orGridTrigger = false;

            giacwhere = giacwhere.trim(giacwhere);

            if (!trim_giacwhere) {
                if (tipoDeBusqueda === "OR") {
                    if (giacwhere !== "")
                        AllSqlStringsOR.push(giacwhere);
                } else if (tipoDeBusqueda === "AND") {
                    if (giacwhere !== "")
                        AllSqlStringsAND.push(giacwhere);
                }
            }
            if (AllSqlStringsAND.length !== 0 && AllSqlStringsOR.length === 0) {
                AllSqlString = AllSqlStringsAND.join(" AND ");
            }

            if (AllSqlStringsAND.length === 0 && AllSqlStringsOR.length !== 0) {
                AllSqlString = AllSqlStringsOR.join(" OR ");
            }

            if (AllSqlStringsAND.length !== 0 && AllSqlStringsOR.length !== 0) {
                AllSqlString = AllSqlStringsAND.join(" AND ") + " OR " + AllSqlStringsOR.join(" OR ");
            }

            var iacwhere = AllSqlString.length ? AllSqlString : giacwhere;
            iacwhere = iacwhere.trim(iacwhere);
            // console.log('SQLString: this.old_iacwhere: ', $me.old_iacwhere);

            //console.log('me.old_iacwhere: ', $me.old_iacwhere);


            //if(iacwhere.length && iacwhere !== giacwhere )// && iacwhere !== old_iacwhere)
            if (iacwhere.length === 0 || iacwhere !== $me.old_iacwhere) //VCA Pruebo algo que dijo Pepe, que siempre busque.
            {
                $me.old_iacwhere = iacwhere;

                var d = new Date();
                var n = d.toUTCString() + " " + d.getMilliseconds();
                //var $run = Math.floor(Math.random() * 10000);
                console.log(n + ":\r\n" + ' SQLString _ iacwhere: ' + iacwhere); // + "\r\n" + 'old: ' , $me.old_iacwhere);
                if (typeof gridhandler === 'string')
                    gridhandler = $(gridhandler);

                //VCA iaSumaGridServer
                var newSortName = newSortName === undefined ? "" : newSortName,
                    newSortOrder = newSortOrder === undefined ? "" : newSortOrder,
                    doNewSort = doNewSort === undefined ? "" : doNewSort,
                    defSortName = defSortName === undefined ? $gridParams.sortname : defSortName,
                    defSortOrder = defSortOrder === undefined ? $gridParams.sortorder : defSortOrder,
                    $doFn = {};

                $gridParams.postData.old_iaarr_md5 = $gridParams.postData.iaarr_md5;
                $gridParams.postData.iaarr_md5 = '';

                delete $gridParams.postData.iacwhere;
                delete $gridParams.postData.filters;

                delete $gridParams.postData.orGridTrigger;
                delete $gridParams.postData.iaSoloSumas;
                delete $gridParams.postData.desdeBusquedaRapida;
                delete $gridParams.postData.iaGridInicial;
                delete $gridParams.postData.respetaLimit;

                $gridParams.postData.iaSoloSumas = 'NO';
                $gridParams.postData.orGridTrigger = "NO";
                $gridParams.postData.respetaLimit = "NO";

                $gridParams.postData.filters = '';
                //$gridParams.postData.iacwhere = iacwhere;
                $gridParams.postData.sidx = doNewSort ? newSortName : defSortName;
                $gridParams.postData.sord = doNewSort ? newSortOrder : defSortOrder;

                $gridParams.sortname = doNewSort ? newSortName : defSortName;
                $gridParams.sortorder = doNewSort ? newSortOrder : defSortOrder;
                doNewSort = false;


                $gridParams.postData.iacwhere = encodeURIComponent(iacwhere); // encodeURI(iacwhere);
                $gridParams.postData.iaSumaGridServer = 'SI';

                $gridParams.rowNum = vx_utils.parseInt(10000000);
                $('.ui-pg-selbox').val('10000000');

                $gridParams.postData.desdeBusquedaRapida = 'SI';
                $gridParams.postData.iaGridInicial = 'NO';

                orGridTrigger = false;

                if (typeof window['antesEjecutaBusquedaRapida'] === 'function')
                    window['antesEjecutaBusquedaRapida']();

                //Ejecutamos todas las funciones posFn y negFn que estén en la pila
                $doFn = $me._fieldFunctions();
                Object.getOwnPropertyNames($doFn.doPosFn).forEach(function (val, idx, array) {
                    if ($doFn.doPosFn[val].length && typeof window[$doFn.doPosFn[val]] === 'function') window[$doFn.doPosFn[val]]();
                });

                Object.getOwnPropertyNames($doFn.doNegFn).forEach(function (val, idx, array) {
                    if ($doFn.doNegFn[val].length && typeof window[$doFn.doNegFn[val]] === 'function') window[$doFn.doNegFn[val]]();
                });

                /**
                 * JJDPL:
                 */
                if ($me.setDataTypeToJsonLocal) {
                    gridhandler.jqGrid('setGridParam', {datatype: 'json'});
                    gridhandler.clearGridData();
                }

                //gridhandler[0].clearToolbar(); //VCA 28-11-2020 Esta limpieza del toolbar disparaba el reload del grid.
                // gridhandler.jqGrid('setGridParam',{datatype:'local'});
                // gridhandler[0].clearToolbar();
                // gridhandler.jqGrid('setGridParam',{datatype:'json'});
                //Hack para limpiar el toolbar
                //VCA 15-Jul-2020
                gridhandler.trigger('reloadGrid');
                //setTimeout(function(){ gridhandler.trigger('reloadGrid');}, 50);
                setTimeout(function () {
                    $gridParams.postData.desdeBusquedaRapida = 'NO';
                    $me.old_iacwhere = '';
                    $gridParams.postData.iacwhere = decodeURIComponent($gridParams.postData.iacwhere);
                }, 500);

                if (typeof window['despuesEjecutaBusquedaRapida'] === 'function') {
                    queueMicrotask(() => {
                        window['despuesEjecutaBusquedaRapida']();
                    });
                }
                //VCA iaSumaGridServer
                //trim_giacwhere = false;
            }
            //},10);
        }catch (e) {
            console.log(e);
        }

    };

    this.regex = function(id){

        var $me = this;

            var valor,
            sqlS="";

            var estado_val = '____________', valor = '', regexp = '', delim = '', val_def = "1", val_buscar = "1";
            estado_val = estado_val.split('');

        val_buscar = $("#" + $me.ifields[id].f_comparador).length && $("#" + $me.ifields[id].f_comparador).val().length ? $("#" + $me.ifields[id].f_comparador).val() : val_buscar;
        val_def = val_buscar == "1" ? val_def : "Z";

            if($('input:radio[name='+$me.ifields[id].f_o_estado_and+']:checked').val()=="AND")
                delim = '*';
            else
                delim = '|';

            $("#"+$me.ifields[id].f_o_estado+' option:selected').each(function() {
                valor = $(this).data('valor').split('');
                $.each(valor, function(i){
                    if(this==val_def)
                    {
                        if(delim === '|')
                            regexp += "^" + pad(i+1, val_buscar, '.') + delim;
                        else
                            estado_val[i] = val_buscar;
                        return false;
                    }
                });
            });

        var signo1="LIKE", signo2="";
        if($('input[name="'+id+'_not"]')[0].checked){
            signo1="NOT LIKE";
            signo2=" NOT ";
        }

            if(delim === '|')
            {
                regexp = regexp.slice(0, - 1);
                sqlS += ' ' + $me.campos[id].field;
                sqlS += signo2 +" REGEXP '"+regexp+"' ";
            }
            else
            {
                var signo1="LIKE";
                if($('input[name="'+id+'_not"]')[0].checked || val_buscar === 'Z'){
                    signo1="NOT LIKE";
                }
                estado_val = estado_val.join('');
                sqlS += ' ' + $me.campos[id].field;
                sqlS += " "+signo1+" '"+estado_val+"' ";
            }
            return sqlS;
        };

    this.cleanAll = function(cleanWhere){
        // Se quita clase para los widget con busqueda
        $(".busqueda_access_active").removeClass('busqueda_access_active');
        // console.log("cleanAll cleanWhere", cleanWhere);
        // console.log("cleanAll ini giacwhere", giacwhere);
        cleanWhere = typeof(cleanWhere) === 'undefined' ? 'SI' : cleanWhere;

        //console.log(obj);
        AllSqlStrings = [];
        for(var i in this.campos){
            this.campos[i].SQLString = "";
            if(!this.campos[i].hasOwnProperty('opt')){
                this.campos[i].opt = [];
            }
            this.campos[i].opt['doPosFn'] = [];
            this.campos[i].opt['doNegFn'] = [];
        }

        //VCA OCT2019
        if($("#macro_sel").length) $("#macro_sel").selectize()[0].selectize.reset2InitialValue();
        $('.vx_adcb_limpia').each(function(){this.click();});
        resetSelectize2InitialValue('vx_autoBusquedaRapidaSelectize');

        if(typeof giacwhere === 'undefined')
            giacwhere = '';

        if(typeof globalIACWhere === 'undefined')
            globalIACWhere = "";

        if(typeof defWhere === 'undefined')
            defWhere = "";

        if(cleanWhere === 'SI')
            $gridParams.postData.iacwhere = giacwhere + defWhere;
        // console.log("cleanAll ostData.iacwhere giacwhere", giacwhere + defWhere);
        $gridParams.postData.iaSumaGridServer = 'NO';
        $gridParams.postData.desdeBusquedaRapida = 'NO';
        $gridParams.postData.iaGridFiltros = 'NO';

        orGridTrigger = false;

        // quita palomitas de not
        $(".checkbox_not").prop('checked',false);
        // deja todos radios de union en cajitas en and  
        $("#tb_and").prop('checked',false).trigger('click');
        // la union de tags de tagify en or
        $(".toTagify").each(function(){ var id=$(this).attr("id"); $("#"+id+"_or").trigger('click');  });
        // quita la palomita de Mostrar Todos
        $("INPUT[type='checkbox'][data-filter='f1']").each(function(){var $el=$(this); if($el.prop('checked')) $el.trigger('click');  });
        
        // $gridParams.rowNum = 100;
        // $('.ui-pg-selbox').val('100');

        if(typeof window['antesLimpiaBusquedaRapida'] === 'function')
            window['antesLimpiaBusquedaRapida']();
    };

    this.cliente_init_autocomplete= function (type, field = ""){
        let $me = this, me_type = type;

        field = field.length ? field : "#"+$me.ifields[me_type].f_cliente_i;
        clientes = json_catalogos[type] || clientes_json;

        let altField = "#" + $me.ifields[me_type].f_cliente_i_id;

        $d.iOSinitAutoComplete(field, clientes, altField, cliente_init_autocompletecallBack, 280, 'label', false,'', false, null, true, 0, false, true, 'px', 0, 3, 0, 30);

        function cliente_init_autocompletecallBack(item){
            // console.trace(arguments);
            if(item == null)
                return;

            $(altField).val(item['cliente_id']);
            $(field).val(strip_tags(item['label']));
        }
    };


    this._cambiaFormatoFecha = function(fecha, formato){
        if (fecha.length < 10) return '';
        if (!formato || formato.length===0) var formato='MySQL';
        var cd='-',
            aFecha=fecha.split(cd),
            sDia=aFecha[0],
            sMes=aFecha[1],
            sAnio=aFecha[2],
            ff='';
        switch (formato){
            case 'MySQL':
                ff=sAnio + '-' + sMes + '-' + sDia;
                break;
            case 'JS':
                ff=sDia + '-' + sMes + '-' + sAnio;
                break;
            default:
                ff=sAnio + '-' + sMes + '-' + sDia;
                break;
        }
        return ff;
    };

    this._fieldFunctions = function(){
        var $doFn = {'doPosFn':[], 'doNegFn':[]};

        //Object.getOwnPropertyNames($me.options.posFn).forEach( function ($instance, idx, array) { $me.options.posFn = $.extend({}, $instance.options.posFn, $me.options.posFn); });
        //Object.getOwnPropertyNames($me.options.negFn).forEach( function ($instance, idx, array) { $me.options.negFn = $.extend({}, $instance.options.negFn, $me.options.negFn); });

        for (var instance in this.campos) {
            if (this.campos.hasOwnProperty(instance)) {
                $doFn.doPosFn = $.extend({}, this.campos[instance].doPosFn, $doFn.doPosFn);
                $doFn.doNegFn = $.extend({}, this.campos[instance].doNegFn, $doFn.doNegFn);
            }
        }

        return $doFn;
    };

    this.init_botones=function() {
        $('#btn_ebr').button();
        $('#btn_lbr').button();
        /*$('body').on('keydown', function (e) {



            var key = e.which;
            switch (key) {
                case 117:
                    $('#btn_ebr').click();
                    e.preventDefault();
                break;

                case 118:
                    $('#btn_lbr').click();
                    e.preventDefault();
                break;
            }

        });*/

    };


    this.Agrupar = function(opt,field,top,fiel2) {
        var gp = $(brGridHandler).jqGrid('getGridParam','postData');
        if(opt==1)
        {
            gp.iaccols = gp.iaccols.replace(field,top+"("+field+")");
            gp.iacgroupby = "GROUP BY DATE("+fiel2+")";
        }else{
            gp.iaccols = gp.iaccols.replace(top+"("+field+")",field);
            gp.iacgroupby = "";
        }

    };

    this.clientes_init_array = function (extraf,type) {

        console.log(extraf);
        if(extraf.hasOwnProperty('filePath')) {

            var json=extraf.filePath.split(',');
            var fileIndex = $('#'+this.ifields[type].f_cliente_c).is(':checked') ? 1:0;
            var url = './json/'+  json[fileIndex];

            if(clientesCatalogos.hasOwnProperty(json[fileIndex])){
                clientes_json = clientesCatalogos[json[fileIndex]];
            }
            else {
                url = url.replace("./json/../", "../");
                var stringData = $.ajax({
                    url: url,
                    //  cache:false,
                    async: false
                }).responseText;

                clientes_json = JSON.parse(stringData);
                clientesCatalogos[json[fileIndex]] = clientes_json;
            }

        }else if(extraf.hasOwnProperty('json_var')){
            if(extraf.hasOwnProperty('json_var') && typeof $vitex_globales[extraf.json_var] !== "undefined")
                clientes_json = $vitex_globales[extraf.json_var];
        }

        clientes = [];
        $.each(clientes_json, function(index, cliente)
        {
            clientes.push(
            {
                label: cliente.nombre || cliente.label,
                value: cliente.nombre || cliente.label,
                cliente:   cliente.nombre || cliente.label,
                cliente_id: cliente.cliente_id || cliente.real_data,
            });
        });
        json_catalogos[type] = clientes;
        $me.cliente_init_autocomplete(type);
    };

    this.all_and_or = function(){
        //console.log(obj);
        for(var i in this.campos){
            $('input:radio[name=\''+this.campos[i].$id+'_t_b\']').each(function(){
                if($('input:radio[name=\'but_control\']:checked').val() == $(this).val()){
                    $(this).prop('checked', true);
                }
            });


        }
    };

    this._deduce_tipo = function(colmodel = {}){
        let arr_ignora = ["rn", "iacsel", "actions", "subgrid"];
            nombre = colmodel.name || "", tipo = '', br_config = {}, dataUrl = "",
            cb_auto_com = colmodel.hasOwnProperty("comboBoxAutoComplete"),
            cb_json_var = cb_auto_com && colmodel.comboBoxAutoComplete.hasOwnProperty("json_var") ? true : false,
            cb_data_url = cb_auto_com && colmodel.comboBoxAutoComplete.hasOwnProperty("dataUrl") && colmodel.comboBoxAutoComplete.dataUrl.search(".html") >= 0 ? true : false;

        if(colmodel.hasOwnProperty("BusquedaRapida"))
            br_config = { ...br_config, ...colmodel.BusquedaRapida};
        else
            br_config = {
            'type' : '',
        };

        br_config.input = colmodel.index;
        br_config.field = colmodel.index;

        if(!nombre.length)
            return;
        if(arr_ignora.includes(nombre) || (br_config.hasOwnProperty("type") && br_config.type.length && br_config.type != "ba_yes_no") || (nombre.search("_id") > 0 && !cb_json_var && !cb_data_url))// || nombre.search("_id") > 0)
        {
            //console.log(nombre, colmodel);
            return;
        } //console.log(nombre);

            //Primer intento.
        if(br_config.type == "ba_yes_no")
            tipo = "ba_yes_no";
        else if(nombre.search("fecha") >= 0 || nombre.search("date") >= 0 || colmodel.hasOwnProperty("datefmt") || (colmodel.hasOwnProperty("formatter") && colmodel.formatter == "date") )
            tipo = "ba_fecha";
        else if(nombre.search("monto") >= 0 || nombre.search("quantity") >= 0 || nombre.search("payment") >= 0)
            tipo = "ba_monto";
        else if(colmodel.edittype == "select" ||
            (colmodel.hasOwnProperty("comboBoxAutoComplete") && colmodel.comboBoxAutoComplete.hasOwnProperty("json_var")) ||
            (colmodel.hasOwnProperty("comboBoxAutoComplete") && colmodel.comboBoxAutoComplete.hasOwnProperty("dataUrl") && colmodel.comboBoxAutoComplete.dataUrl.search(".html") >= 0)
        )
            tipo = "ba_multi";
        else if(colmodel.stype == "text")
            tipo = "ba_tagify";


        switch(tipo){
            case "ba_fecha":
                br_config['type'] = tipo;

                colmodel.BusquedaRapida = {...colmodel.BusquedaRapida, ...br_config};
                break;

            case "ba_monto":
                br_config['type'] = tipo;
                colmodel.BusquedaRapida = {...colmodel.BusquedaRapida, ...br_config};
                break;

            case "ba_multi":
                br_config['type'] = tipo;

                if(colmodel.hasOwnProperty("comboBoxAutoComplete") && colmodel.comboBoxAutoComplete.hasOwnProperty("dataUrl") && colmodel.comboBoxAutoComplete.dataUrl.search(".html") >= 0) {
                    dataUrl = colmodel.comboBoxAutoComplete.dataUrl;
                    if(dataUrl.lastIndexOf("/") >= 0)
                        dataUrl = dataUrl.substring(dataUrl.lastIndexOf("/")+1);

                    br_config.extraf = {"filePath": dataUrl};
                }else
                    br_config.extraf = {"options" : colmodel.editoptions.value};
                colmodel.BusquedaRapida = {...colmodel.BusquedaRapida, ...br_config};
                break;

            case "ba_tagify":
                br_config['type'] = tipo;
                colmodel.BusquedaRapida = {...colmodel.BusquedaRapida, ...br_config};
                break;

            case "ba_yes_no":
                br_config['type'] = tipo;
                colmodel.BusquedaRapida = {...colmodel.BusquedaRapida, ...br_config};
                break;

        }

        // console.log(nombre, colmodel);
            return;
    }
};


///Raul 03_09_19

function jquerytojson(jqcampos){
    //console.log(jqcampos);
    var jsoncamp=[];
    
    jqcampos.each(function() {
        var element=$(this);
        var objcamp=JSON.parse('{}');

        $.each(this.attributes, function() {            
            objcamp[this.name]=this.value;
            objcamp['val']=element.val();
            
            
        });
        jsoncamp.push(objcamp);
    });
    //console.log(jsoncamp);
    return jsoncamp;
}

function guardarAutoComplete(tabla,campos){
    var jsonarray=[];
    var data="";
    //console.log(campos);
    $.each(campos, function(k, campo){

        if(campo.type==='text' && campo.val!='' && !campo.hasOwnProperty('data-autonumeric')){
            
            //console.log(campo.val);
            jsonarray.push(JSON.parse('{"campo":"'+campo.val+'"}'));
        }
        
    });
    data=JSON.stringify(jsonarray);
    $.ajax({
        url: "ajax/autoComplete_acciones.php",
        cache: false,
        type: "post",
        async: true,
        data: {data:data,tabla:tabla,accion:"guarda_autocomplete"}
    }).done(function(res){ try {
            
    }catch(err){alert(err.message); console.log(res); }
    }).fail(function (xhr, ajaxOptions, thrownError){ try {
       
    }catch(err){alert(err.message); console.log(xhr); }
    }).always(function(res){ });

   
}

function incializaAutocomplete(tabla,campoDesc)
{
    // console.log(campoDesc);
    var valor_del_campo = $(campoDesc).val().toUpperCase();
    $(campoDesc).autocomplete({
        source: function( request, response ){
        if(request.term === '#@@#') request.term = '';
        $.ajax({
            url: "ajax/autoComplete_acciones.php",
            type: "post",
            dataType: "json",
            data: {
                term: request.term,
                accion: 'busca_autocomplete',
                valor: valor_del_campo,
                tabla: tabla
            },
            beforeSend: function(jqXHR, settings) {
                return true;
            }
        }).done(function(data) {
            try {
                response($.map(data.valoresEncontrados, function(item) {
                    return {
                    label: item.label,
                    value: item.value,
                    }
                }));
            }catch(err){alert(err.message); console.log(data);}
        });
        },
        minLength: 2,
        select: function(event, ui) {

        },
        change: function(event, ui) {

        }}).on('focus', function(){
            // if($(this).val().length === 0)
            //     $(this).autocomplete('search',$(this).val());
        }).on('dblclick', function(){
            $(this).autocomplete('search','#@@#');
    });
}

jQuery.ui.autocomplete.prototype._resizeMenu = function () {
    let ul = this.menu.element;
    if(!this.menu.element.hasOwnProperty('vxWidth'))
    {
        var vxW = 0;
        $.each(this.menu.element[0].children, function(k,v){vxW = v.innerText.length > vxW ? v.innerText.length : vxW;});
        this.menu.element.vxWidth = vxW * 11;
    }
    ul.outerWidth(this.menu.element.vxWidth + 40);
};

function getCaretPosition(ctrl) {
    // IE < 9 Support
    if (document.selection) {
        ctrl.focus();
        var range = document.selection.createRange();
        var rangelen = range.text.length;
        range.moveStart('character', -ctrl.value.length);
        var start = range.text.length - rangelen;
        return {
            'start': start,
            'end': start + rangelen
        };
    } // IE >=9 and other browsers
    else if (ctrl.selectionStart || ctrl.selectionStart == '0') {
        return {
            'start': ctrl.selectionStart,
            'end': ctrl.selectionEnd
        };
    } else {
        return {
            'start': 0,
            'end': 0
        };
    }
}

function setCaretPosition(ctrl, start, end) {
    // IE >= 9 and other browsers
    if (ctrl.setSelectionRange) {
        ctrl.focus();
        ctrl.setSelectionRange(start, end);
    }
    // IE < 9
    else if (ctrl.createTextRange) {
        var range = ctrl.createTextRange();
        range.collapse(true);
        range.moveEnd('character', end);
        range.moveStart('character', start);
        range.select();
    }
}
function modal_busqueda_key(){
    let modal_busqueda=$('#modal_busqueda_rapida');

    modal_busqueda.dialog({
        modal:true,
        width: '90%',
        height: $(window).height() - 100,
        title: 'Permisador de busqueda'
      });

}

function jqgrid_hidecol(colname) {
    gridhandler.jqGrid('hideCol',colname);
}


function addMinutes(date, minutes) {
    date = new Date(date);
    return new Date(date.getTime() + minutes*60000);
}

function diffTime(start_time, end_time) {
    const MILLISECONDS_OF_A_SECOND = 1000;
    const MILLISECONDS_OF_A_MINUTE = MILLISECONDS_OF_A_SECOND * 60;
    const MILLISECONDS_OF_A_HOUR = MILLISECONDS_OF_A_MINUTE * 60;
    const MILLISECONDS_OF_A_DAY = MILLISECONDS_OF_A_HOUR * 24;

    const DURATION = end_time - start_time;

    let days = DURATION / MILLISECONDS_OF_A_DAY, REMAINING_DAYS;
    if (days<0)
        REMAINING_DAYS = Math.ceil(days);
    else
        REMAINING_DAYS = Math.floor(days);

    let hours = (DURATION % MILLISECONDS_OF_A_DAY) / MILLISECONDS_OF_A_HOUR, REMAINING_HOURS;
    if (hours<0)
        REMAINING_HOURS = Math.ceil(hours);
    else
        REMAINING_HOURS = Math.floor(hours);

    let minutes = (DURATION % MILLISECONDS_OF_A_HOUR) / MILLISECONDS_OF_A_MINUTE, REMAINING_MINUTES;
    if (minutes<0)
        REMAINING_MINUTES = Math.ceil(minutes);
    else
        REMAINING_MINUTES = Math.floor(minutes);

    let seconds = (DURATION % MILLISECONDS_OF_A_MINUTE) / MILLISECONDS_OF_A_SECOND,
        REMAINING_SECONDS = Math.floor(seconds);

    let tiempo = '';
    var label = '';
    if (REMAINING_DAYS>0)
        label+=REMAINING_DAYS+" día"+(REMAINING_DAYS>1?'s':'')+", ";
    if (REMAINING_HOURS>0)
        label+=REMAINING_HOURS+" hora"+(REMAINING_HOURS>1?'s':'')+", ";
    if (REMAINING_MINUTES>0)
        label+=REMAINING_MINUTES+" minuto"+(REMAINING_MINUTES>1?'s':'')+", ";
    if (REMAINING_SECONDS>0)
        label+=REMAINING_SECONDS+" segundo"+(REMAINING_SECONDS>1?'s':'')+".";

    tiempo = label;

    let lable_negativo = '';

    if (REMAINING_SECONDS<0) {
        lable_negativo="Ha expidado hace ";
        tiempo = '';
        if (REMAINING_DAYS<0)
            lable_negativo+=tiempo+=Math.abs(REMAINING_DAYS)+" día"+(REMAINING_DAYS < -1 ? 's':'')+".";
        else if (REMAINING_HOURS<0)
            lable_negativo+=tiempo+=Math.abs(REMAINING_HOURS)+" hora"+(REMAINING_HOURS < -1 ? 's':'')+".";
        else if (REMAINING_MINUTES<0)
            lable_negativo+=tiempo+=Math.abs(REMAINING_MINUTES)+" minuto"+(REMAINING_MINUTES < -1 ? 's':'')+".";
        else if (REMAINING_SECONDS<0)
            lable_negativo+=tiempo+=Math.abs(REMAINING_SECONDS)+" segundo"+(REMAINING_SECONDS < -1 ? 's':'')+".";
    }

    return {
        'dias': REMAINING_DAYS,
        'horas': REMAINING_HOURS,
        'minutos': REMAINING_MINUTES,
        'segundos': REMAINING_SECONDS,
        'label': label,
        'negativo': REMAINING_SECONDS<0,
        'label_negativo': lable_negativo,
        'tiempo':tiempo
    }

}

function dateToString(date=null)
{
    if(date===null)
        date = new Date()

    let dia = ("0" + date.getDate()).slice(-2);
    let mes = ("0"+(date.getMonth()+1)).slice(-2);
    let anio = date.getFullYear();

    let hora = ("0" + date.getHours()).slice(-2);
    let minutos = ("0" + date.getMinutes()).slice(-2);
    let segundos = ("0" + date.getSeconds()).slice(-2);

    return anio+"-"+mes+"-"+dia+" "+hora+":"+minutos+":"+segundos;
}

function toFixed(x) {
    if (typeof x === 'undefined')
        return '';
    if(x === '' || x == null)
        return '';

    if (Math.abs(x) < 1.0) {
        let e = parseInt(x.toString().split('e-')[1]);
        if (e) {
            x *= Math.pow(10,e-1);
            x = '0.' + (new Array(e)).join('0') + x.toString().substring(2);
        }
    } else {
        let e = parseInt(x.toString().split('+')[1]);
        if (e > 20) {
            e -= 20;
            x /= Math.pow(10,e);
            x += (new Array(e+1)).join('0');
        }
    }
    return x;
}

function toFixedTrunc(x, n=2) {
    x = toFixed(x);
    if (x==='')
        return '';

    // From here on the code is the same than the original answer
    const v = (typeof x === 'string' ? x : x.toString()).split('.');
    if (n <= 0) return v[0];
    let f = v[1] || '';
    if (f.length > n) return `${v[0]}.${f.substr(0,n)}`;
    while (f.length < n) f += '0';
    return `${v[0]}.${f}`
}

function decodeUnicodeEscape(str) {
    return str.replace(/\\u[\dA-F]{4}/gi,
        match => String.fromCharCode(parseInt(match.replace('\\u', ''), 16)));
}