var isonArray_i, isonArray_length, ia = ia || {}, vx_utils = vx_utils || {};

function roundNumber(num, dec){
    var result=Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
    return result;
}

function CommaFormatted(amount, depth, delimiter){
    if(!depth) var depth=2;
    if(typeof delimiter=="undefined") var delimiter=",";
    amount=roundNumber(amount, depth)
    amount=amount.toFixed(depth)

    var a=amount.split('.', depth), d=a[1], i=parseInt(a[0]), minus='', n, nn;
    if(isNaN(i)) return '';
    if(i < 0) minus='-';
    i=Math.abs(i);
    n=new String(i);
    a=[];
    while (n.length > 3){
        nn=n.substr(n.length - 3);
        a.unshift(nn);
        n=n.substr(0, n.length - 3);
    }
    if(n.length > 0) a.unshift(n);
    n=a.join(delimiter);
    if(d.length < 1)
        amount=n;
    else
        amount=n + '.' + d;
    amount=minus + amount;
    return amount;
}

function numbersonly(e, decimal){
    var key;
    var keychar;
    if (window.event){
        key=window.event.keyCode;
    } else if (e){
        key=e.which;
    } else {
        return true;
    }
    keychar=String.fromCharCode(key);
    if ((key==null) || (key==0) || (key==8) || (key==9) || (key==13) || (key==27)){
        return true;
    } else if ((("0123456789").indexOf(keychar) > -1)){
        return true;
    } else if (decimal && ((keychar==".") || (keychar=="-"))){
        return true;
    } else
        return false;
}

function uppercase(){
    key=window.event.keyCode;
    if (((key > 0x60) && (key < 0x7B)) || ((key > 0xDF) && (key < 0xFD))) window.event.keyCode=key - 0x20;
    if (key==0xF1) window.event.keyCode=0xD1;
}

function strtrim(str){
    var str=str.replace(/^\s\s*/, ''),
        ws=/\s/,
        i=str.length;
    while (ws.test(str.charAt(--i)));
    return str.slice(0, i + 1);
}

function hasClass(ele, cls){
    return ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
}

function addClass(ele, cls){
    if (!this.hasClass(ele, cls)) ele.className += " " + cls;
}

function removeClass(ele, cls){
    if (hasClass(ele, cls)){
        var reg=new RegExp('(\\s|^)' + cls + '(\\s|$)');
        ele.className=ele.className.replace(reg, ' ');
    }
}

function FechaporDefault(ID){
    if (ID=='') return;
    if ($('#' + ID).val()==''){
        var now=new Date();
        //document.getElementById(ID).value=now.toString('dd-MM-yyyy');
        $('#' + ID).val($.datepicker.formatDate('dd-mm-yy', now));
    }
}

//VCA /////////////////////////////////////////////////////////
function VerificayCorrigeFecha(Fecha, campo, corrige, permiteVacio, formatoOrigen, formatoDestino){
    var FechaaCorregir=Fecha,
        CaracterDivisor='',
        aFecha,
        iDia,
        iMes,
        iAnio,
        sDia,
        sMes,
        sAnio,
        sFechaCorregida, sFechaCorregidaBW,
        sFechaCaret='dd-mm-AAAA',
        formatoFecha='mx',
        fechaAPDF = obtenFecha('mx');

    if (typeof _app!='undefined' && (_app=='edocta' || _app=='cuenta_t')){
        formatoFecha='mx';
        sFechaCaret='dd-mm-AAAA';
    } else {
        formatoFecha='mysql';
        sFechaCaret='AAAA-mm-dd';
    }

    if (!formatoOrigen) var formatoOrigen=formatoFecha;
    if (!formatoDestino) var formatoDestino=formatoFecha;

    if (!corrige) var corrige='SI';
    if (!permiteVacio) var permiteVacio='SI';
    if (FechaaCorregir.length==0){
        if (permiteVacio!='SI') vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        return fechaAPDF;
    }
    if (FechaaCorregir.length < 6 && FechaaCorregir.length > 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }

    //Vamos a buscar el carácter con que están dividiendo la fecha.
    FechaaCorregir=FechaaCorregir.replace(/\//g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\*/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\./g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\_/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\+/g, '-');
    FechaaCorregir=FechaaCorregir.replace(/\\/g, '-');
    CaracterDivisor='-';
    aFecha=FechaaCorregir.split(CaracterDivisor);
    if (aFecha.length > 3){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }

    //'mx'
    iDia=aFecha[0];
    iMes=aFecha[1];
    iAnio=aFecha[2];

    if(parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0 || parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0)
    {
        iDia=aFecha[2];
        iMes=aFecha[1];
        iAnio=aFecha[0];

        if(parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0 || parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0)
            return Fecha;
        else
            formatoOrigen = 'mysql';
    }
    else
        formatoOrigen = 'mx';

    switch (formatoOrigen){
        case 'mx':
            iDia=aFecha[0];
            iMes=aFecha[1];
            iAnio=aFecha[2];
            sFechaCaret='dd-mm-AAAA';
            break;
        case 'mysql':
            iDia=aFecha[2];
            iMes=aFecha[1];
            iAnio=aFecha[0];
            sFechaCaret='AAAA-mm-dd';
            break;
    }
    if (isNaN(iDia) || isNaN(iMes) || isNaN(iAnio)){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    if (parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    if (parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0){
        vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
        //document.getElementById(campo).focus();
        return fechaAPDF;
    }
    iDia=parseInt(iDia, 10);
    iMes=parseInt(iMes, 10);
    iAnio=parseInt(iAnio, 10);
    if(iAnio < 30)
        iAnio += 2000;
    else if(iAnio < 99)
        iAnio += 1900;
    if(iDia < 10)
        sDia='0' + iDia.toString();
    else
        sDia=iDia.toString();
    if(iMes < 10)
        sMes='0' + iMes.toString();
    else
        sMes=iMes.toString();

    sAnio=iAnio.toString();

    sFechaCorregida=sDia + '-' + sMes + '-' + sAnio;
    sFechaCorregidaBW=sAnio + '-' + sMes + '-' + sDia;

    //Metemos una verificación de restricción.
    if (typeof _app!='undefined' && _app=='edocta'){
        var cFecha=new Date(sFechaCorregidaBW + ' GMT-0600'),
            cFLPC=new Date(flpC + ' GMT-0600'),
            cFLFC=new Date(flfC + ' GMT-0600');
        if (cFecha < cFLPC || cFecha > cFLFC){
            //document.getElementById(campo).focus();
            vx_alert(divIDInfo, '<strong>Fecha fuera del rango permitido. Por favor, usa el calendario para elegir la fecha.</strong>', 'Captura de Estado de Cuenta.', campo, '', '', '');
            return fechaAPDF;
        }
    }
    if (corrige=='SI')
        document.getElementById(campo).value=sFechaCorregida;
    else
    {
        switch (formatoDestino){
            case 'mx':
                return sFechaCorregida;
                break;
            case 'mysql':
                return sFechaCorregidaBW;
                break;
        }
    }
    return sFechaCorregida;
}

function obtenFecha(formato, sep)
{
    var today = new Date(),
        dd = today.getDate();
    mm = today.getMonth()+1; //January is 0!
    yyyy = today.getFullYear();

    if(!formato) var formato = 'mx';
    if(!sep) var sep = '-';

    if(dd<10) {
        dd = '0'+dd
    }

    if(mm<10) {
        mm = '0'+mm
    }

    switch(formato)
    {
        case 'mx':
            return mm + sep + dd + sep + yyyy;
            break;

        case 'mysql':
            return yyyy + sep + mm + sep + dd;
            break;
    }

    return mm + sep + dd + sep + yyyy;
}
//VCA /////////////////////////////////////////////////////////

function trapEnterAsTab() // called from an onKeyDown in the body	statement
{
    evt=event || window.event;
    if (evt.keyCode==13 && TextAreaFocused==false /* enter */ ) evt.keyCode=9 /* tab */
    ;
}

function focusonTextArea(){
    TextAreaFocused=true;
}

function focusnotonTextArea(){
    TextAreaFocused=false;
}

function MostraruOcultarMenu(NombredelMenu, muo){
    muo=muo===undefined?'DEF':muo;

    if(muo=='DEF')
        $('#' + NombredelMenu).toggle('blind', 300);
    else
        $('#' + NombredelMenu).hide();
}

function nl2br(str){
    var breakTag='<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function vx_isOnArray(arr, val){
    for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
        if (arr[isonArray_i]==val) return isonArray_i;
    return -1;
}

function getposonArray(arr, val, pos){
    if (!pos) var pos=0;
    for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
        if (isArray(arr[isonArray_i])){
            if (arr[isonArray_i][pos]==val) return isonArray_i;
        } else
        if (arr[isonArray_i]==val) return isonArray_i;
    return false;
}

function InicializaWidthGrid(gh, forzar){
    if (!gh) var gh=gridhandler;
    if (!forzar) var forzar=false;
    if (!PrimeraVez || forzar){
        $(gh).setGridWidth($(gh).getGridParam('width') - 25, true);
        $(gh)[0].clearToolbar();
    }
    PrimeraVez=true;
}

function CambiaFormatoFecha(Fecha, formato){
    if (Fecha.length < 10) return '';
    if (!formato || formato.length==0) var formato='MySQL';
    var CaracterDivisor='-';
    var aFecha=Fecha.split(CaracterDivisor);
    var sDia=aFecha[0];
    var sMes=aFecha[1];
    var sAnio=aFecha[2];
    switch (formato){
        case 'MySQL':
            Fecha=sAnio + '-' + sMes + '-' + sDia;
            break;
        case 'JS':
            Fecha=sDia + '-' + sMes + '-' + sAnio;
            break;
        default:
            Fecha=sAnio + '-' + sMes + '-' + sDia;
            break;
    }
    return Fecha;
}

function RecuperaoEstableceEstilodeCampo(tabla, campo, id_nombre, id_valor, atributo, valor){
    if (!tabla || !campo || !id_nombre || !id_valor) return false;
    if (!valor) valor='read';
    if (!atributo) atributo='';
    if (window.XMLHttpRequest){
        xmlhttp=new XMLHttpRequest();
    } else {
        xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.open("POST", "ajax/iaestilos.php", false);
    xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    var parameters="tabla=" + tabla + "&campo=" + campo + "&id_nombre=" + id_nombre + "&id_valor=" + id_valor + "&atributo=" + atributo + "&valor=" + valor;
    xmlhttp.send(parameters);
    try { // Aquí va el código de respuesta del servidor. Tu código.
        var jsonresponse=eval('(' + xmlhttp.responseText + ')');
        if (jsonresponse.valor!="Error") return jsonresponse;
    } catch (err){
        alert(err.message);
    }
}

function EstilizaCampos(){
    //var campos=$("*:[data-color=='1']");
    $('*[data-color="1"]').each(function(k, v){
        var attr_arr=RecuperaoEstableceEstilodeCampo($(v).attr('data-tabla'), $(v).attr('data-campo'), $(v).attr('data-id_nombre'), $(v).attr('data-id_valor'), '', 'read');
        $.each(attr_arr, function(a, b){
            $(v).css(b['atributo'], b['valor']);
        });
        //alert($(v).attr('data-tabla'));
    });
}

function isArray(obj){
    return obj.constructor==Array;
}

function spanishDate(d, time){
    if (!time) var time=false;
    var weekday=["Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"];
    var monthname=["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
    if (time) return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear() + " : " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
    else
        return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear();
}

function vx_alert(divID, mensaje, titulo, focusafter, width, extraCloseFunc, extraOpenFunc, autoClose, autoClosemSecs){
    if (!focusafter) var focusafter='';
    if (!width) var width='400';
    if (!extraCloseFunc) var extraCloseFunc='';
    if (!extraOpenFunc) var extraOpenFunc='';
    if (!autoClose) var autoClose='NO';
    if (!autoClosemSecs) var autoClosemSecs=4500;
    if (divID!=divIDError && divID!=divIDInfo)
        autoClose='NO';
    else
        globDiv=divID;

    $("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        stack: false,
        resizable: false,
        width: width,
        title: titulo,
        open: function(event, ui){
            try {
                $zIndex = 99999;
                $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                    $(this).css('z-index',$zIndex++);
                });
                $zIndex-=2;
                $(".ui-widget-overlay").css('z-index',$zIndex);

                if (autoClose=='SI') setTimeout(function(){
                    if ($('#' + globDiv).data('ui-dialog') && $('#' + globDiv).dialog('isOpen')) $('#' + globDiv).dialog('close');
                }, autoClosemSecs);
                if (extraOpenFunc!='')
                    eval(extraOpenFunc);

                $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus(); //focus en el botón aceptar.

            } catch (er){ console.log(er); }
            //setTimeout(function(){ $('.ui-dialog :button')[1].focus(); },300); //focus en el botón aceptar.

        },
        close: function(event, ui){
            try {
                if (extraCloseFunc!='')
                    eval(extraCloseFunc);

                if(focusafter!=''){
                    if ($('#' + focusafter).hasClass('selectized')) $('#' + focusafter).selectize()[0].selectize.open();
                    else $('#' + focusafter).focus().select();
                }
                $(this).dialog("destroy");
                $("#" + divID).html('');

                $zIndex = 99999;
                $dS = $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable");
                $zIndex += $dS.length;

                $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                    $(this).css('z-index',$zIndex--);
                });
                $(".ui-widget-overlay").css('z-index',$zIndex);
            } catch (er){ console.log(er); };
        },
        buttons: {
            Aceptar: function(){
                $(this).dialog("close");
            }
        }
    });
}

function agregaDiasaFecha(Fecha, Dias, formato){
    if (Dias==0 || Dias=='') return Fecha;
    Dias=parseInt(Dias, 10);
    if (!formato) formato='dmA';
    var CaracterDivisor='-';
    var aFecha=Fecha.split(CaracterDivisor);
    var sDia='';
    var sMes='';
    var sAnio='';
    switch (formato){
        case 'dmA':
            sDia=aFecha[0];
            sMes=aFecha[1];
            sAnio=aFecha[2];
            Fecha=sMes + '-' + sDia + '-' + sAnio;
            var hoy=Date.parse(Fecha);
            var nvaFecha=new Date(hoy);
            nvaFecha.setDate(nvaFecha.getDate() + Dias);
            Fecha=nvaFecha.getDate() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getFullYear();
            break;
        case 'Amd':
            sDia=aFecha[2];
            sMes=aFecha[1];
            sAnio=aFecha[0];
            Fecha=sMes + '-' + sDia + '-' + sAnio;
            var hoy=Date.parse(Fecha);
            var nvaFecha=new Date(hoy);
            nvaFecha.setDate(nvaFecha.getDate() + Dias);
            Fecha=nvaFecha.getFullYear() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getDate();
            break;
        default:
            break;
    }
    return Fecha;
}
$.fn.makeAbsolute=function(rebase){
    return this.each(function(){
        var el=$(this);
        var pos=el.position();
        el.css({
            position: "absolute",
            marginLeft: 0,
            marginTop: 0,
            top: pos.top,
            left: pos.left
        });
        if (rebase) el.remove().appendTo("body");
    });
};

function getMondayOfCurrentWeek(d){
    var day=d.getDay();
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day==0 ? -6 : 1) - day);
}

function getSundayOfCurrentWeek(d){
    var day=d.getDay();
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day==0 ? 0 : 7) - day);
}
//Get the First and Last day of Current Month

function getDayOfMonth(d, dia, mes){
    dia = typeof dia === "undefined" ? "" : dia;
    mes = typeof mes === "undefined" ? "actual" : mes;

    var _day=0, _month=0, _year=0;

    switch(mes)
    {
        case "actual":
            _month = 0;
            break;

        case "pasado":
            _month = -1;
            break;

        case "proximo":
            _month = 1;
            break;

        default:
            _month = 0;
            break;

    }

    switch(dia)
    {
        case "primero":
            _day = 1;
            break;

        case "ultimo":
            _day = 0;
            _month++;
            break;

        default:
            _day = 0;
            break;
    }

    return new Date(d.getFullYear() + _year, d.getMonth() + _month, _day);
}

function getFistDayOfCurrentMonth(d){
    return new Date(d.getFullYear(), d.getMonth(), 1);
}


function getLastDayOfCurrentMonth(d){
    return new Date(d.getFullYear(), d.getMonth() + 1, 0);
}

function getLastXDays(d,days){
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() - days);
}

//VCA OCT2019
function getThisYear(d){
    return new Date(d.getFullYear(), 0, 1);
}

//VCA iaSumaGridServer
function buildStringwithDelimeters(str, origDelim, finalDelim, campoID, paraSQL, colSQL){
    if(typeof gridhandler === 'string')
        gridhandler=$(gridhandler);

    var finalStr='',
        tmpArr,
        tmpid = gridhandler.attr('id'),
        doctos = tmpid.search('doctos') >=0 ? true : false;
    matchAg = tmpid.search('pagare') >=0 || tmpid.search('cheque') >=0 || tmpid.search('vale') >=0 || tmpid.search('doctos') >=0 ? true : false;


    if(!origDelim) var origDelim=',';
    if(!finalDelim) var finalDelim=' ';
    if(!paraSQL) var paraSQL='NO';
    if(typeof colSQL !== Object && typeof colSQL !== 'string')
        colSQL = colSQL[0];
    if(!campoID){
        var campoID='';
        tmpArr=str.split(origDelim);
    } else if (campoID.length && paraSQL=='SI'){
        //if ($('#' + campoID + '_and').is(':checked')) finalDelim=' AND ';
        //else if ($('#' + campoID + '_or').is(':checked')) finalDelim=' OR ';
        finalDelim=$('input:radio[name='+campoID+'_rad]:checked').val() || " OR "; //Un hack para que jale. Arreglar abajo.
        tmpArr=$('#' + campoID).val().split(origDelim);
    }
    $.each(tmpArr, function(k, v){
        if (paraSQL=='SI')
        {
            if(colSQL.search('remarks') >=0 && (matchAg || doctos))
            {
                if(doctos && colSQL.search('remarks') >=0)
                {
                    finalStr=finalStr + " " + colSQL + "_wot LIKE '%25" + v.trim() + "%25' " + finalDelim;
                }
                else if(colSQL.search('remarks') >=0)
                    finalStr=finalStr + " MATCH (" + colSQL + "_wot) AGAINST ('\"" + v.trim() + "\"') " + finalDelim;
            }
            else
            {
                finalStr=finalStr + " " + colSQL + " LIKE '%25" + v.trim() + "%25' " + finalDelim;
            }
        }
        else
            finalStr=finalStr + v.trim() + finalDelim;
    });
    finalStr=finalStr.substring(0, finalStr.length - finalDelim.length);
    return finalStr;
}

function pad(width, string, padding){
    return (width <= string.length) ? string : pad(width, padding + string, padding)
}

function vx_confirmNONONO(divID, mensaje, titulo, yesFunc, noFunc){
    var width='400';
    if (!noFunc) var noFunc='';
    if (!yesFunc) var yesFunc='';
    $("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        modal: true,
        resizable: false,
        width: width,
        title: titulo,
        open: function(event, ui){},
        close: function(event, ui){
            $(this).dialog("destroy");
            $("#" + divID).html('');
        },
        buttons: {
            'Sí': function(){
                if (yesFunc!='') try {
                    eval(yesFunc);
                } catch (er){
                    console.log(er);
                }
                $(this).dialog("close");
            },
            'No': function(){
                if (noFunc!='') try {
                    eval(noFunc);
                } catch (er){
                    console.log(er);
                }
                $(this).dialog("close");
            }
        }
    });
}

function obtenComparador(str, tipo, val){
    if (!tipo) var tipo='num';
    if (!str || str.length==0) return '=';
    var co='';
    if (tipo=='num') switch (str){
        case'eq':co='=';break;
        case'ne':co='!=';break;
        case'lt':co='<';break;
        case'le':co='<=';break;
        case'gt':co='>';break;
        case 'ge':co='>=';break;
        default:co='=';break;
    } else switch (str){
        case 'eq':co=" LIKE '" + val + "%25' ";break;
        case 'ne':co=" NOT LIKE '" + val + "%25' ";break;
        case 'lt':co=" < '" + val + " 00:00:00' ";break;
        case 'le':co=" <= '" + val + " 23:59:59' ";break;
        case 'gt':co=" > '" + val + " 23:59:59' ";break;
        case 'ge':co=" >= '" + val + " 00:00:00' ";break;
        default:co=" LIKE '" + val + "%25' ";break;
    }
    return co;
}

function parseVxFloat(str){
    return vx_utils.parseFloat(str);
}


function vx_confirm(divID, mensaje, titulo, yesCallbackFunc, noCallbackFunc, width, onOpenFunc, onCloseFunc){
    divID=divID===undefined?'IA_INFO':divID;
    mensaje=mensaje===undefined?'':mensaje;
    titulo=titulo===undefined?'':titulo;
    width=width===undefined?'400':width;
    yesCallbackFunc=yesCallbackFunc===undefined?function(){return;}:yesCallbackFunc;
    noCallbackFunc=noCallbackFunc===undefined?function(){return;}:noCallbackFunc;
    onOpenFunc=onOpenFunc===undefined?function(){return;}:onOpenFunc;
    onCloseFunc=onCloseFunc===undefined?function(){return;}:onCloseFunc;


    $("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        modal: true,
        resizable: false,
        width: width,
        title: titulo,
        open: function(event, ui){
            try{
                $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus();
                onOpenFunc();
            } catch(er){ console.log(er); }
        },
        close: function(event, ui){
            try{
                $(this).dialog("destroy");
                $("#" + divID).html('');
                onCloseFunc();
            }catch(er){ console.log(er); }
        },
        buttons: {
            "Sí": function(){
                try{ yesCallbackFunc(); }
                catch(er){ console.log(er); }
                $(this).dialog("close");
            },
            "No": function(){
                try{ noCallbackFunc(); }
                catch(er){ console.log(er); }
                $(this).dialog("close");
            }
        }
    });
}

function vx_confirmation(question) {
    var defer = $.Deferred();
    $('<div></div>')
        .html(question)
        .dialog({
            autoOpen: true,
            modal: true,
            title: 'Por favor, confirma:',
            buttons: {
                "Sí": function () {
                    defer.resolve("true");//this text 'true' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                },
                "No": function () {
                    defer.resolve("false");//this text 'false' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                }
            },
            close: function () {
                $(this).remove();
            }
        });
    return defer.promise();
}

function vx_parseFloat(str){
    return vx_utils.parseFloat(str);
}

function strip_tags(str)
{
    if(!str || !str.length)
        return '';
    return str.replace(/<[^>]+>/g, '');
}

/**
 * Cross file utilities for working with arrays,
 * sorting and other fun stuff
 * @return {Object} vx_utils
 */
var vx_utils = {};
window.fbLoaded = {
    js: [],
    css: [],
}
window.fbEditors = {
    quill: {},
    tinymce: {},
}

// cleaner syntax for testing indexOf element
vx_utils.inArray = function(needle, haystack) {
    return haystack.indexOf(needle) !== -1
}

/**
 * Remove null or undefined values
 * @param  {Object} attrs {attrName: attrValue}
 * @return {Object}       Object trimmed of null or undefined values
 */
vx_utils.trimObj = function(attrs) {
    let xmlRemove = [null, undefined, '', false, 'false']
    for (let attr in attrs) {
        if (vx_utils.inArray(attrs[attr], xmlRemove)) {
            delete attrs[attr]
        } else if (Array.isArray(attrs[attr])) {
            if (!attrs[attr].length) {
                delete attrs[attr]
            }
        }
    }

    return attrs
}

/**
 * Test if attribute is a valid HTML attribute
 * @param  {String} attr
 * @return {Boolean}
 */
vx_utils.validAttr = function(attr) {
    let invalid = [
        'values',
        'enableOther',
        'other',
        'label',
        // 'style',
        'subtype',
    ]
    return !vx_utils.inArray(attr, invalid)
}

/**
 * Convert an attrs object into a string
 *
 * @param  {Object} attrs object of attributes for markup
 * @return {string}
 */
vx_utils.attrString = function(attrs) {
    let attributes = []

    for (let attr in attrs) {
        if (attrs.hasOwnProperty(attr) && vx_utils.validAttr(attr)) {
            attr = vx_utils.safeAttr(attr, attrs[attr])
            attributes.push(attr.name + attr.value)
        }
    }
    return attributes.join(' ')
}

/**
 * Convert attributes to markup safe strings
 * @param  {String} name  attribute name
 * @param  {String} value attribute value
 * @return {Object}       {attrName: attrValue}
 */
vx_utils.safeAttr = function(name, value) {
    name = vx_utils.safeAttrName(name)
    let valString

    if (value) {
        if (Array.isArray(value)) {
            valString = vx_utils.escapeAttr(value.join(' '))
        } else {
            if (typeof value === 'boolean') {
                value = value.toString()
            }
            valString = vx_utils.escapeAttr(value.replace(',', ' ').trim())
        }
    }

    value = value ? `="${valString}"` : ''
    return {
        name,
        value,
    }
}

vx_utils.safeAttrName = function(name) {
    let safeAttr = {
        className: 'class',
    }

    return safeAttr[name] || vx_utils.hyphenCase(name)
}

/**
 * Convert strings into lowercase-hyphen
 *
 * @param  {String} str
 * @return {String}
 */
vx_utils.hyphenCase = function(str) {
    str = str.replace(/[^\w\s\-]/gi, '');
    str = str.replace(/([A-Z])/g, function($1) {
        return '-' + $1.toLowerCase();
    })

    return str.replace(/\s/g, '-').replace(/^-+/g, '');
}

/**
 * convert a hyphenated string to camelCase
 * @param  {String} str
 * @return {String}
 */
vx_utils.camelCase = function(str) { return str.replace(/-([a-z])/g, (m, w) => w.toUpperCase()); }

/**
 * Determine content type
 * @param  {Node | String | Array | Object} content
 * @return {String}                         contentType for mapping
 */
vx_utils.contentType = function(content) {
    let type = typeof content;
    if (content instanceof Node || content instanceof HTMLElement) {
        type = 'node';
    } else if (Array.isArray(content)) {
        type = 'array';
    }

    return type;
}

/**
 * Bind events to an element
 * @param  {Object} element DOM element
 * @param  {Object} events  object full of events eg. {click: evt => callback}
 * @return {void}
 */
vx_utils.bindEvents = function(element, events) {
    if (events) {
        for (let event in events) {
            if (events.hasOwnProperty(event)) {
                element.addEventListener(event, function(evt){ return events[event](evt) });
            }
        }
    }
}

/**
 * Generate a unique name attribute
 * @param  {Object} field
 * @return {String}       name
 */
vx_utils.nameAttr = function(field) {
    let epoch = new Date().getTime();
    let prefix = field.type || vx_utils.hyphenCase(field.label);
    return prefix + '-' + epoch;
}

/**
 * Convert html element attributes to key/value object
 * @param  {Object} elem DOM element
 * @return {Object} ex: {attrName: attrValue}
 */
vx_utils.parseAttrs = function(elem) {
    let attrs = elem.attributes;
    let data = {};
    vx_utils.forEach(attrs, function(attr) {
        let attrVal = attrs[attr].value || '';
        if (attrVal.match(/false|true/g)) {
            attrVal = attrVal === 'true';
        } else if (attrVal.match(/undefined/g)) {
            attrVal = undefined;
        }

        if (attrVal) {
            data[attrs[attr].name] = attrVal;
        }
    })

    return data;
}

/**
 * Convert field options to optionData
 * @param  {NodeList} options  DOM elements
 * @return {Array} optionData array
 */
vx_utils.parseOptions = function(options) {
    let optionData = {};
    let data = [];

    for (let i = 0; i < options.length; i++) {
        optionData = vx_utils.parseAttrs(options[i]);
        optionData.label = options[i].textContent;
        data.push(optionData);
    }

    return data;
}

/**
 * Parse XML formData
 * @param  {String} xmlString
 * @return {Array}            formData array
 */
vx_utils.parseXML = function(xmlString) {
    const parser = new window.DOMParser();
    let xml = parser.parseFromString(xmlString, 'text/xml');
    let formData = [];

    if (xml) {
        let fields = xml.getElementsByTagName('field');
        for (let i = 0; i < fields.length; i++) {
            let fieldData = vx_utils.parseAttrs(fields[i]);
            const options = fields[i].getElementsByTagName('option');

            if (options && options.length) {
                fieldData.values = vx_utils.parseOptions(options);
            }

            formData.push(fieldData);
        }
    }

    return formData;
}

/**
 * Converts escaped HTML into usable HTML
 * @param  {String} html escaped HTML
 * @return {String}      parsed HTML
 */
vx_utils.parsedHtml = function(html) {
    let escapeElement = document.createElement('textarea');
    escapeElement.innerHTML = html;
    return escapeElement.textContent;
}

/**
 * Escape markup so it can be displayed rather than rendered
 * @param  {String} html markup
 * @return {String}      escaped html
 */
vx_utils.escapeHtml = function(html) {
    let escapeElement = document.createElement('textarea');
    escapeElement.textContent = html;
    return escapeElement.innerHTML;
}

// Escape an attribute
vx_utils.escapeAttr = function(str) {
    let match = {
        '"': '&quot;',
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
    };

    const replaceTag = tag => match[tag] || tag;

    return typeof str === 'string' ? str.replace(/["&<>]/g, replaceTag) : str;
}

// Escape attributes
vx_utils.escapeAttrs = function(attrs) {
    for (let attr in attrs) {
        if (attrs.hasOwnProperty(attr)) {
            attrs[attr] = vx_utils.escapeAttr(attrs[attr]);
        }
    }

    return attrs;
}

// forEach that can be used on nodeList
vx_utils.forEach = function(array, callback, scope) {
    for (let i = 0; i < array.length; i++) {
        callback.call(scope, i, array[i]) // passes back stuff we need
    }
}

/**
 * Remove duplicates from an array of elements
 * @param  {Array} array  array with possible duplicates
 * @return {Array}        array with only unique values
 */
vx_utils.unique = function(array) {
    return array.filter((elem, pos, arr) => arr.indexOf(elem) === pos);
}

/**
 * Removes a value from an array
 * @param  {String|Number} val
 * @param  {Array} arr
 */
vx_utils.remove = function(val, arr) {
    let index = arr.indexOf(val);

    if (index > -1) {
        arr.splice(index, 1);
    }
}

/**
 * Checks if remote resource is already loaded
 * @param  {String|Array} src  url of remote script or css
 * @param  {String}       type       'js' or 'css'
 * @return {Boolean}      isCached
 */
vx_utils.isCached = function(src, type = 'js') {
    let isCached = false;
    const cache = window.fbLoaded[$id];
    if (Array.isArray(src)) {
        isCached = src.every(s => vx_utils.inArray(s, cache));
    } else {
        isCached = vx_utils.inArray(src, cache);
    }
    return isCached;
}

/**
 * Appends stylesheets to the head
 * @param  {Array} scriptScr
 * @param  {String} path
 * @return {void}
 */
vx_utils.getStyles = function(scriptScr, path) {
    if (!Array.isArray(scriptScr)) {
        scriptScr = [scriptScr];
    }
    scriptScr.forEach(src => {
        // if a string is passed, assume a href URL
        let type = 'href';
        let key = src;
        let id = '';

        // if an object is passed, work out details from it's properties
        if (typeof src == 'object') {
            type = src.type || (src.style ? 'inline' : 'href');
            id = src.id;
            src = type == 'inline' ? src.style : src.href;
            key = id || src.href || src.style;
        }

        // check we haven't already loaded this css
        if (vx_utils.isCached(key, 'css')) {
            return;
        }

        // append the style into the head
        if (type == 'href') {
            let link = document.createElement('link');
            link.type = 'text/css';
            link.rel = 'stylesheet';
            link.href = (path || '') + src;
            document.head.appendChild(link);
        } else {
            $(`<style type="text/css">${src}</style>`)
                .attr('id', id)
                .appendTo($(document.head));
        }

        // record this is cached
        window.fbLoaded.css.push(key);
    })
}

/**
 * Capitalizes a string
 * @param  {String} str uncapitalized string
 * @return {String} str capitalized string
 */
vx_utils.capitalize = function(str) {
    return str.replace(/\b\w/g, function(m) {
        return m.toUpperCase();
    })
}

vx_utils.merge = function(obj1, obj2) {
    let mergedObj = Object.assign({}, obj1, obj2);
    for (let prop in obj2) {
        if (mergedObj.hasOwnProperty(prop)) {
            if (Array.isArray(obj2[prop])) {
                mergedObj[prop] = Array.isArray(obj1[prop]) ? vx_utils.unique(obj1[prop].concat(obj2[prop])) : obj2[prop];
            } else if (typeof obj2[prop] === 'object') {
                mergedObj[prop] = vx_utils.merge(obj1[prop], obj2[prop]);
            } else {
                mergedObj[prop] = obj2[prop];
            }
        }
    }
    return mergedObj;
}

vx_utils.addEventListeners = function(el, evts, fn) {
    return evts.split(' ').forEach(e => el.addEventListener(e, fn, false));
}

/**
 * Find the closest parent by class
 * @param  {Object} el  DOM element
 * @param  {String} cls class
 * @return {Object}     DOM Element
 */
vx_utils.closest = function(el, cls) {
    let className = cls.replace('.', '');
    while ((el = el.parentElement) && !el.classList.contains(className));
    return el;
}

/**
 * Convert converts messy `cl#ssNames` into valid `class-names`
 *
 * @param  {String} str
 * @return {String} hyphenated string
 */
vx_utils.makeClassName = function(str) {
    return vx_utils.hyphenCase(str.replace(/[^\w\s\-]/gi, ''));
}

/**
 * Make strings safe to be used as classes
 *
 * @param  {String} str string to be converted
 * @return {String}     converter string
 */
vx_utils.safename = function(str) {
    return str
        .replace(/\s/g, '-')
        .replace(/[^a-zA-Z0-9\[\]\_-]/g, '')
        .toLowerCase();
}

/**
 * Strips non-numbers from a number only input
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.forceNumber = function(str) {
    return str.replace(/[^0-9]/g, '');
}
/**
 * Converts a string into a float number.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseFloat = function(str) {
    if(typeof str === "string")
        if(!str || str.length===0)
            return 0.00;
        else
            str = parseFloat(str.replace(/[^0-9.]+/g, '').trim()); //.replace(/\,|\$| /g,'')
    return isNaN(str) ? 0.00 : str;
}
/**
 * Converts a string into an int number.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseInt = function(str) {
    if(typeof str === "string")
        if(!str || str.length===0)
            return 0;
        else
            str = parseInt(str.replace(/[^0-9.]+/g, '').trim()); //.replace(/\,|\$| /g,'')
    return isNaN(str) ? 0 : str;
}
/**
 * Adds slashes like PHP.
 *
 * @param  {string} str string
 * @return {string}     string with slashes
 */
vx_utils.addslashes = function(str) {
    if(!str || str.length===0)
        return "";
    return str.replace(/\\/g, '\\\\').
    replace(/\u0008/g, '\\b').
    replace(/\t/g, '\\t').
    replace(/\n/g, '\\n').
    replace(/\f/g, '\\f').
    replace(/\r/g, '\\r').
    replace(/'/g, '\\\'').
    replace(/"/g, '\\"');
}

/**
 * Camelliza una cadena de caracteres.
 *
 * @param  {string} str string
 * @return {string}     string camellizado
 */
vx_utils.toCamelCase = function(str) {
    if(!str || str.length===0)
        return "";
    return str.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
}

/**
 * Camelliza una cadena de caracteres.
 *
 * @param  {string} str string
 * @return {string}     string camellizado
 */
vx_utils.obtenFecha = function() {
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth()+1; //January is 0!
    var yyyy = today.getFullYear();

    if(dd<10) {
        dd = '0'+dd
    }

    if(mm<10) {
        mm = '0'+mm
    }

    today = dd + '-' + mm + '-' + yyyy;
    return today;
}

ia.alert = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    var defer = $.Deferred(), m=messageIconSpan==null ? '' : messageIconSpan+' ';
    $('<div/>')
        .html(m+(html===true ? message : message.replace(/</g,'&lt; '))).addClass(addClass==null ? '' : addClass)
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Aviso' : title,
            buttons: [
                {text:buttonText==null ? 'Ok' : buttonText,icon:buttonIcon==null ? 'ui-icon-check' : buttonIcon,
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.resolve("true");
                        $(this).dialog("close");
                    }
                },
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
};
ia.alertHighlight = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-info"></span>':messageIconSpan, addClass==null ? 'ui-state-highlight' : addClass, buttonText, buttonIcon);
};
ia.alertInfo = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-info"></span>':messageIconSpan, addClass, buttonText, buttonIcon);
};
ia.alertWarn = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-alert"></span>':messageIconSpan, addClass, buttonText, buttonIcon);
};
ia.alertError = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-alert"></span>':messageIconSpan,addClass==null ? 'ui-state-error-text' : addClass, buttonText, buttonIcon);
};

ia.confirm = function(message, title, html) {
    var defer = $.Deferred();
    $('<div/>')
        .html(html===true ? message : message.replace(/</g,'&lt; '))
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Por favor, confirma:' : title,
            buttons: [
                {text:'Si',icon:'ui-icon-check',
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.resolve("true");
                        $(this).dialog("close");
                    }
                },
                {text:'No',icon:'ui-icon-cancel',
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.reject();
                        $(this).dialog("close");
                    }
                }
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
};

ia.confirmDelete = function(message,title,html){
    var defer = $.Deferred();
    $("<div />").html('<span class="ui-icon ui-icon-trash"></span> ' + (html===true ? message : message.replace(/</g,'&lt; '))).addClass('ui-state-error-text')
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Confirme Eliminar:' : title,
            buttons: [
                {text: "Eliminar",icon:"ui-icon-trash",'class':"ui-state-error-text",
                    click: function(e) {
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.resolve("true");
                        $(this).dialog("close");
                    }
                },
                {text:'Cancelar',icon:'ui-icon-cancel',
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.reject();
                        $(this).dialog("close");
                    }
                }
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
};

ia.tagProtect = function(html) {
    var tags=['script','object','embed','iframe','frame','applet','button','input','form','base','param']   ;
    for(var i=0,tagsLen=tags.length; i<tagsLen; i++ ) {
        var regExp = new RegExp( '<(' + tags[i] + ')|<\/(' + tags[i] +')', 'gimu');
        html = html.replace(regExp, ' $1 /$2');
    }
    return html;
}

ia.textWidth = function(text,addClass){
    var calc = $('<span style="display:none">' + text + '</span>');
    if(typeof addClass!=='undefined')
        calc.addClass(addClass);
    else
        calc.addClass('ui-dialog-title-bar ui-widget-header ui-dialog-title'); // add 46 for dialog width
    $('body').append(calc);
    var width = calc.width();
    calc.remove();
    return width;
}

$.fn.reverse = [].reverse;

$.fn.ia = $.fn.ia || {};
$.fn.muestra = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.css('visibility')==='hidden')
            e.css({'visibility':'visible'}).data('iavisibility',1);
        if(e.css('display')==='none')
            if(wa)
                e.show(args);
            else
                e.show();
    });
};

$.fn.oculta = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.data('iavisibility')=='1')
            e.css({'visibility':'hidden'});
        else if(wa)
            e.hide(arguments);
        else
            e.hide();
    });
};

$.fn.muestraConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).muestra();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.muestra();
    });
};
$.fn.ocultaConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).oculta();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.oculta();
    });
};

$.fn.isHidden = function () {
    if(this.length === 1) {
        var el = $(this);
        return el.css('display')==='none' || el.css('visibility')==='hidden';
    }
    var r={};
    this.each(function() {
        var el = $(this);
        if(typeof el.type !== 'undefined' && el.type==='hidden')
            r = false;
        r = el.css('display')==='none' || el.css('visibility')==='hidden';
    });
    return r;
};

$.fn.valVisible = function(onHiddenReturn) {
    // only visible, onhidden dflt, unchecked checkedbox,
    // $("#valeIncome").find("INPUT").valVisible()
    var e = $(this);
    if(e.length === 0)
        return;
    var ret=[];
    this.each(function() {
        var e = $(this), name=e.attr('name'), r={};
        if(typeof name==='string' && name.length>0) {
            if(e.isHidden())
                r[this.id] = typeof onHiddenReturn === 'undefined' ? 0.00 : onHiddenReturn;
            else
                r[this.id] = myval(e);
            ret[ret.length] = r;
        }
    });
    return ret;
    function myval(el) {
        if(el.attr('type')==='checkbox' || el.attr('type')==='radio')
            if(el.prop('checked'))
                return el.val();
            else
                return;
        if(typeof el.data('autoNumeric') !== 'undefined')
            return el.autoNumeric('get');
        return el.val();
    }
};

function rgb2hex(rgb)
{
    if(rgb.search("rgb") == -1)
        return rgb;
    else
    {
        rgb = rgb.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+))?\)$/);
        function hex(x)
        {
            return ("0" + parseInt(x).toString(16)).slice(-2);
        }
        return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
    }
}

//Plugin Busqueda rápida inputs vx_autoBusquedaRapida
(function($, window, document, undefined) {
    /**
     * Store the plugin name in a variable. It helps you if later decide to
     * change the plugin's name
     * @type {String}
     */
    var pluginName = 'vx_autoBusquedaRapida';

    /**
     * The plugin constructor
     * @param {DOM Element} element The DOM element where plugin is applied
     * @param {Object} options Options passed to the constructor
     */
    function Plugin(element, options) {

        // Store a reference to the source element
        this.el = element;

        // Store a jQuery reference  to the source element
        this.$el = $(element);

        // Set the instance options extending the plugin defaults and
        // the options passed by the user
        this.options = $.extend({}, $.fn[pluginName].defaults, options);

        // Initialize the plugin instance
        this.init();
    }

    /**
     * Set up your Plugin prototype with desired methods.
     * It is a good practice to implement 'init' and 'destroy' methods.
     */
    Plugin.prototype = {

        /**
         * Initialize the plugin instance.
         * Set any other attribtes, store any other element reference, register
         * listeners, etc
         *
         * When bind listerners remember to name tag it with your plugin's name.
         * Elements can have more than one listener attached to the same event
         * so you need to tag it to unbind the appropriate listener on destroy:
         *
         * @example
         * this.$someSubElement.on('click.' + pluginName, function() {
         *      // Do something
         * });
         *
         */
        init: function() {
            //console.log('ok');
            var $me = this,
                $elem = $me.$el,
                $doWrap = $elem.data('dowrap'),
                $id = $elem.data('input'),
                $field = $elem.data('field'),
                $a={}, $fs_id=$id+'_bt_fs', $minime={};
            $place = $('#content');
            grupos={"ba_fecha":"Fechas","ba_monto":"Monto","ba_bancos":"Bancos","ba_tagify":"Tagify","ba_sn":"Yes_no","ba_multi":"Multi_Select","ba_cliente":"Cliente","ba_yes_no":"Yes_no_2","ba_estado":"Estados"};

            $field = $field.split(",");

            $me.options.tipodeBusqueda = typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
            $me.options.instances[$id] = {};
            $minime = $me.options.instances[$id];
            $minime.input = $id;
            $minime.field = $field;
            $minime.title = $elem.data('title') === undefined ? "" : $elem.data('title');
            $minime.xtrasqlpre = $elem.data('xtrasqlpre') === undefined ? "" : $elem.data('xtrasqlpre');
            $minime.xtrasqlpost = $elem.data('xtrasqlpost') === undefined ? "" : $elem.data('xtrasqlpost');
            $minime.extraf = $elem.data('extraf') === undefined ? "" : $elem.data('extraf');
            $minime.group = $elem.data('group') === undefined ? "" : $elem.data('group');
            $minime.type = $elem.data('type') === undefined ? "" : $elem.data('type');
            $minime.subtype = $elem.data('subtype') === undefined ? "" : $elem.data('subtype');
            $minime.top = $elem.data('top') === undefined ? "" : $elem.data('top');

            $minime.table = $elem.data('table') === undefined ? "" : $elem.data('table');
            $minime.extrafield = $elem.data('extrafield') === undefined ? "" : $elem.data('extrafield');
            $minime.wfield = $elem.data('wfield') === undefined ? "" : $elem.data('wfield');

            $minime.extras = $elem.data('options') === undefined ? "" : ",'"+$elem.data('options').replace(',','\',\'')+"'";

            //VCA /////////////////////////////////////////////////////////
            $minime.doPosFn = {};
            $minime.doNegFn = {};
            $minime.doPosOnChangeFn = {};
            $minime.doNegOnChangeFn = {};
            $minime.grouplbl = $minime.group;
            $minime.group = $minime.group.replace(/ /g, '_');

            $minime.lastFocus = '';

            if(typeof gridhandler === 'string')
                gridhandler = $(gridhandler);

            if(typeof $gridParams === 'undefined')
                $gridParams = gridhandler.jqGrid('getGridParam');


            //Funcion por si SÍ hay onChange
            if($minime.extraf.hasOwnProperty('posOnChangeFn') && window.hasOwnProperty("posOnChangeFn_" + $id) && typeof window["posOnChangeFn_" + $id] === 'function')
            {
                $minime.posOnChangeFn = "posOnChangeFn_" + $id;
            }
            else
            {
                $minime.posOnChangeFn = "";
            }

            //Funcion por si NO hay onChange
            if($minime.extraf.hasOwnProperty('negOnChangeFn') && window.hasOwnProperty("negOnChangeFn_" + $id) && typeof window["negOnChangeFn_" + $id] === 'function')
            {
                $minime.negOnChangeFn = "negOnChangeFn_" + $id;
            }
            else
            {
                $minime.negOnChangeFn = "";
            }

            //Funcion por SÍ se ejecuta el SQL
            if($minime.extraf.hasOwnProperty('posFn') && window.hasOwnProperty("posFn_" + $id) && typeof window["posFn_" + $id] === 'function')
            {
                $minime.posFn = "posFn_" + $id;
            }
            else
            {
                $minime.posFn = "";
            }

            //Funcion por NO se ejecuta el SQL
            if($minime.extraf.hasOwnProperty('negFn') && window.hasOwnProperty("negFn_" + $id) && typeof window["negFn_" + $id] === 'function')
            {
                $minime.negFn = "negFn_" + $id;
            }
            else
            {
                $minime.negFn = "";
            }

            //El elemento debe ejecutar el SQL incluso con valor en blanco
            $minime.emptyVal = $minime.extraf.hasOwnProperty('emptyVal') ? $minime.extraf.emptyVal : false;
            //VCA /////////////////////////////////////////////////////////


            $minime.sqlString = "";
            var ifields = new Object();

            var json = $minime.extraf;
            tam_pantalla=$( window ).width()-50;
            var tam_segundo='auto';

            /// Se crean los botones de control
            if($('#controles').length == 0)
            {


                var buttons='';
                buttons+='<a href="javascript:void(0);" style="background:red;" onclick="$.fn.vx_autoBusquedaRapida(\'Buscar\');" id="btn_ebr" class="ui-state-default ui-corner-all fm-button-icon-right">Buscar (F6)<span class="ui-icon ui-icon-search"></span></a>';
                buttons+='<a href="javascript:void(0);" onclick="$.fn.vx_autoBusquedaRapida(\'cleanAll\');" id="btn_lbr" class="ui-state-default ui-corner-all fm-button-icon-left"><span class="ui-icon ui-icon-arrowreturnthick-1-w"></span> Limpiar (F7)</a>';
                buttons+='<br /><br /><strong>Tipo de Búsqueda:</strong>';

                buttons+='<input name="but_control" value="AND" id="tb_and" type="radio" checked />';
                buttons+='<label for="tb_and"><strong>AND</strong></label>';
                buttons+='<input name="but_control" value="OR" id="tb_or" type="radio" />';
                buttons+='<label for="tb_or"><strong>OR</strong></label></div>';

                $controles = $('<div></div>').attr('style',' display:inline-block; float:left; width:305px;').attr('id','controles').append( $('<fieldset></fieldset>').attr('class','black').attr('id','f_controles').append( $('<legend>Controles</legend>').attr('class','lbl bold') ));

                $place.append($controles);
                $('#f_controles').append(buttons);
                this.init_botones();
                //tam_segundo=(tam_pantalla-350)+'px';
            }

            //VCA /////////////////////////////////////////////////////////
            var $div = $('<div />',{
                'class':"dved",
                'style':"display:inline-block; float: left; "
            });

            //Se crean los grupos dependiendo el tipo

            if($('#g_'+grupos[$minime.type]).length == 0 && $minime.group=="")
            {
                var fieldset = $('<fieldset></fieldset>').attr('class','black').attr('id','g_f_'+grupos[$minime.type]),
                    legend = $('<legend>'+grupos[$minime.type]+'</legend>').attr('class','lbl bold'),
                    div_g = $('<div/>',{
                        'style':'width:'+tam_segundo+' ; display:inline-block; float: left;',
                        'id':'g_f_'+grupos[$minime.type],
                        //'id':'g_'+grupos[$minime.type] //VCA
                    });
                //$(legend).appendTo(fieldset); //VCA
                //$(fieldset).appendTo(div_g); //VCA

                $place.append(div_g);
            }
            $gr = $('#g_f_'+grupos[$minime.type]); //VCA
            //$gr = $('<div/>');
            //VCA /////////////////////////////////////////////////////////

            //Se crean los grupos por por el data group
            if ($minime.group!="")
            {
                if($('#g_'+$minime.group).length == 0)
                {
                    var fieldset = $('<fieldset></fieldset>').attr('class','black').attr('id','g_f_'+$minime.group),
                        legend = $('<legend>'+$minime.grouplbl+'</legend>').attr('class','lbl bold'),
                        div_g = $('<div/>',{
                            'style':'width:'+tam_segundo+' ; display:inline-block; float: left;',
                            'id':'g_'+$minime.group,
                        });
                    $(legend).appendTo(fieldset);
                    $(fieldset).appendTo(div_g);
                    $place.append(div_g);
                }
                $gr = $('#g_f_'+$minime.group);

            }

            switch($minime.type){

                case "ba_fecha":

                    ifields[$minime.type] = {
                        f_fechaIni : $id + "_ini",
                        f_fechaFin : $id + "_fin",
                        f_horaIni : $id + "_time_ini",
                        f_horaFin : $id + "_time_fin"
                    };

                    $minime.ifields=ifields;


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_dates",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    $tmpHtml += '<tr><td><label for="'+$minime.ifields[$minime.type].f_fechaIni+'">Between</label>';
                    $tmpHtml += '<td><input autocomplete="off" name="'+$minime.ifields[$minime.type].f_fechaIni+'" id="'+$minime.ifields[$minime.type].f_fechaIni+'" type="text" size="15" maxlength="14" class="datepicker" />';
                    $tmpHtml += '<td><input autocomplete="off" name="'+$minime.ifields[$minime.type].f_horaIni+'" id="'+$minime.ifields[$minime.type].f_horaIni+'" type="text" size="5" class="auto" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';
                    $tmpHtml += '<tr><td><label for="'+$minime.ifields[$minime.type].f_fechaFin+'">and</label>';
                    $tmpHtml += '<td><input autocomplete="off" name="'+$minime.ifields[$minime.type].f_fechaFin+'" id="'+$minime.ifields[$minime.type].f_fechaFin+'" type="text" size="15" maxlength="14" class="datepicker" />';
                    $tmpHtml += '<td><input autocomplete="off" name="'+$minime.ifields[$minime.type].f_horaFin+'" id="'+$minime.ifields[$minime.type].f_horaFin+'" type="text" size="5" class="auto" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';

                    break;
                case "ba_monto":

                    ifields[$minime.type] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto :  $id + "_monto",
                        f_tipo :  $id + "_tipo"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+$minime.ifields[$minime.type].f_comparador+'" id="'+$minime.ifields[$minime.type].f_comparador+'" style="width:120px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select>';
                    $tmpHtml += '&nbsp;<input autocomplete="off" name="'+$minime.ifields[$minime.type].f_monto+'" id="'+$minime.ifields[$minime.type].f_monto+'" type="text" size="10" data-campo="'+$field+'" class="auto ignore-val" data-autonumeric="{mNum:10,mDec:2,aSep:\',\'}"/>';
                    $tmpHtml += '</td>';
                    break;

                case "ba_t_deposit":
                    ifields[$minime.type] = {
                        f_comparador :   $id + "_comp_sel",
                        f_monto :  $id + "_monto",
                        f_tipo :  $id + "_tipo"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"height: 120px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%; ",
                        }), $place,
                        $tmpHtml = '';

                    //var tipo = json.tag.type;



                    //$fs.append((select));

                    $tmpHtml += '<tr><td class="txt_centered"><strong>Tipo</strong></td><td>';
                    $tmpHtml += '<select id="'+$minime.ifields[$minime.type].f_tipo+'" name="'+$minime.ifields[$minime.type].f_tipo+'" class="vx_autoBusquedaRapidaSelectize" >';

                    $.each(json.tag.options,function(index,json){
                        $tmpHtml += '<option value="'+ json.value +'" >' + json.label + '</option>';
                    });
                    $tmpHtml += '</td></tr>';
                    $tmpHtml += '<tr><td>';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+$minime.ifields[$minime.type].f_comparador+'" id="'+$minime.ifields[$minime.type].f_comparador+'" style="width:120px;">';
                    $tmpHtml += '<option value="eq">equal</option>';
                    $tmpHtml += '<option value="ne">not equal</option>';
                    $tmpHtml += '<option value="lt">less</option>';
                    $tmpHtml += '<option value="le">less or equal</option>';
                    $tmpHtml += '<option value="gt">greater</option>';
                    $tmpHtml += '<option value="ge">grtr or equal</option>';
                    $tmpHtml += '</select></td><td>';
                    $tmpHtml += '&nbsp;<input autocomplete="off" name="'+$minime.ifields[$minime.type].f_monto+'" id="'+$minime.ifields[$minime.type].f_monto+'" type="text" size="10" data-campo="'+$field+'" class="auto ignore-val" data-autonumeric="{mNum:10,mDec:2,aSep:\',\'}"/>';
                    $tmpHtml += '</td></tr>';

                    break;

                case "ba_bancos":

                    ifields[$minime.type] = {
                        f_banco :  $id + "f_banco"
                    };

                    $minime.ifields=ifields;


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    var select = $("<select></select>").attr("id", $minime.ifields[$minime.type].f_banco).attr('name',$minime.ifields[$minime.type].f_banco).attr('class','vx_autoBusquedaRapidaSelectize');

                    //Vamos a revisar si viene el atributo filePath o ya viene el objecto.
                    //viene el filePath
                    if(json.hasOwnProperty('filePath'))
                    {
                        var stringData = $.ajax({
                            url: './json/'+json.filePath,
                            async: false
                        }).responseText;


                        json = JSON.parse(stringData);
                        for (var i in json) {
                            if(json.hasOwnProperty(i))
                                select.append($("<option></option>").attr("value", json[i].real_data).text(json[i].label));
                        }
                        $fs.append((select));

                    }
                    else
                    {
                        json=json.options[0];
                        for (var i in json)
                        {
                            select.append($("<option></option>").attr("value", json[i].real_data).text(json[i].label));
                            $fs.append((select));
                        }


                    }
                    break;

                case "ba_sn":

                    ifields[$minime.type] = {
                        f_sn :  $id + "_sn"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall", //VCA
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+$minime.ifields[$minime.type].f_sn+'" id="'+$minime.ifields[$minime.type].f_sn+'" style="width:120px;">';
                    $tmpHtml += '<option value="0">No importa</option>';
                    $tmpHtml += '<option value="No">No</option>';
                    $tmpHtml += '<option value="Si">Sí</option>';
                    $tmpHtml += '</select></td>';


                    break;


                case "ba_atrasado":
                    var arre=["Fiduciarios Expirados","Fiduciarios Expirados con Solicitud de Reembolso","Error en Contenedo"];

                    ifields[$minime.type] = {
                        f_sn :  $id + "_fid_exp_reem"
                    };

                    $minime.ifields=ifields;



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text(arre[$minime.title]),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    if($minime.title!=2)
                    {
                        $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+$minime.ifields[$minime.type].f_sn+'" id="'+$minime.ifields[$minime.type].f_sn+'" style="width:120px;">';
                        $tmpHtml += '<option value="0">No</option>';
                        $tmpHtml += '<option value="1">Sí</option>';
                        $tmpHtml += '<option value="2">Atrasado</option>';
                        $tmpHtml += '</select></td>';
                    }else{
                        $tmpHtml += '<select class="selectopts vx_autoBusquedaRapidaSelectize" name="'+$minime.ifields[$minime.type].f_sn+'" id="'+$minime.ifields[$minime.type].f_sn+'" style="width:120px;">';
                        $tmpHtml += '<option value="0">Todos</option>';
                        $tmpHtml += '<option value="1">No</option>';
                        $tmpHtml += '<option value="2">Sí</option>';
                        $tmpHtml += '</select></td>';
                    }

                    break;


                case "ba_yes_no":

                    ifields[$minime.type] = {
                        f_yes :  $id + "_yes",
                        f_no :  $id + "_no"
                    };

                    $minime.ifields=ifields;

                    //VCA iaSumaGridServer

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_selsinosmall",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    //VCA iaSumaGridServer

                    $tmpHtml += '<tr><td><form >';
                    $tmpHtml += '<input  name="'+$minime.ifields[$minime.type].f_yes+'" id="'+$minime.ifields[$minime.type].f_yes+'" type="radio" value="1" > Yes<br>';
                    $tmpHtml += '<input  name="'+$minime.ifields[$minime.type].f_yes+'" id="'+$minime.ifields[$minime.type].f_no+'" type="radio" value="0" > No<br>';
                    $tmpHtml += '</form></td></tr>';



                    break;

                case "ba_tagify":

                    ifields[$minime.type] = {
                        f_in_text :  $id + "",
                        f_in_rad : $id + "_rad"
                    };

                    $minime.ifields=ifields;


                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:407px; height:187px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<input autocomplete="off" name="'+$minime.ifields[$minime.type].f_in_text+'" id="'+$minime.ifields[$minime.type].f_in_text+'" type="text" class="toTagify" size="40" data-campo="remarks" />';
                    $tmpHtml+='<br />';
                    $tmpHtml+='<input onclick="if(this.checked){$('+$minime.ifields[$minime.type].f_in_text+').change();}" name="'+$minime.ifields[$minime.type].f_in_rad+'" id="ba_remarks_and" value="AND" type="radio" />';
                    $tmpHtml+='<label for="ba_remarks_and"><strong>AND</strong></label>';
                    $tmpHtml+='<input onclick="if(this.checked){$('+$minime.ifields[$minime.type].f_in_text+').change();}" name="'+$minime.ifields[$minime.type].f_in_rad+'" id="ba_remarks_or" value="OR" type="radio" checked />';
                    $tmpHtml+='<label for="ba_remarks_or"><strong>OR</strong></label>';


                    break;


                case "ba_multi":
                    ifields[$minime.type] = {
                        f_multi :  $id+"_id_sel"
                    };

                    $minime.ifields=ifields;



                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_multiselect",
                            'id':$fs_id,
                            //'style':"width:417px; height:257px;" //VCA
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place,
                        vxW = 0, vxH = 0, vxEl = 0, vxwEl = 0; //VCA
                    $tmpHtml = '';


                    var select = $('<select size="5" style="height: 200px;" multiple="multiple"></select>');
                    select.attr('id',$minime.ifields[$minime.type].f_multi);
                    select.attr('name',$minime.ifields[$minime.type].f_multi);

                    //select.css( 'width', '400px' ); //VCA
                    select.addClass('multiselect');
                    //select.multiselect({ locale: 'es' });
                    //Vamos a revisar si viene el atributo filePath o ya viene el objecto.
                    //viene el filePath
                    if(json.hasOwnProperty('filePath'))
                    {
                        var furl='./json/'+json.filePath;
                        furl=furl.replace("./json/../","../");

                        var stringData = $.ajax({
                            url: furl,
                            async: false,
                            success: function(stringData) {
                                if(stringData!="")
                                {
                                    json = JSON.parse(stringData);
                                    vxEl = Object.keys(json).length; //VCA OCT2019
                                    for (var i in json) {
                                        if(json.hasOwnProperty(i) && i!='md5') //VCA sumasGridServer
                                        {

                                            select.append($("<option/>").attr("value", json[i].real_data).text(json[i].label));
                                            vxwEl = json[i].label.length > vxwEl ? json[i].label.length : vxwEl;
                                        }
                                    }

                                }

                            },
                            error: function(){
                                alert("Falta el catalogo: "+furl);
                            }

                        });

                        //VCA SEP2019
                        vxH = vxEl < 8 ? 125 : 225;
                        vxW = vxwEl * 25; //VCA OCT2019
                        vxW = vxW < 250 ? 250 : (vxW > 450) ? 450 : vxW;
                        select.css('width', vxW + 'px').css('height', (vxH+10) + 'px');

                        $fs.css('width', (vxW+10)+ 'px').css('height', (vxH+40) + 'px');
                        $fs.append((select));
                        //VCA SEP2019
                    }
                    break;

                case "ba_cliente":

                    ifields[$minime.type] = {
                        f_cliente_i :  $id + "_in",
                        f_cliente_i_id :  $id + "_in_id",
                        f_cliente_c :  $id + "_che"
                    };

                    $minime.ifields=ifields;




                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_dates",
                            'id':$fs_id,
                            'style':"width:340; height:115px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $me.clientes_init_array();

                    $tmpHtml+='<input autocomplete="off" name="'+$minime.ifields[$minime.type].f_cliente_i+'" id="'+$minime.ifields[$minime.type].f_cliente_i+'" type="text" size="30" data-campo="cliente" onfocus="$(\'#'+$minime.ifields[$minime.type].f_cliente_i+'\').val(\'\'); if($(this).val()==\'\') { $(this).autocomplete(\'search\',$(this).val()); }" ondblclick="$(\'#'+$minime.ifields[$minime.type].f_cliente_i+'\').val(\'\'); $(this).autocomplete(\'search\',\'#@@#\');" onblur="if($(this).val()==\'\') { $(\'#'+$minime.ifields[$minime.type].f_cliente_i+'\').val(\'\'); } " />';
                    $tmpHtml+='<input type="hidden" name="'+$minime.ifields[$minime.type].f_cliente_i_id+'" id="'+$minime.ifields[$minime.type].f_cliente_i_id+'" size="30" data-campo="cliente"  />';
                    $tmpHtml+='<br />';
                    $tmpHtml+='<input name="'+$minime.ifields[$minime.type].f_cliente_c+'" id="'+$minime.ifields[$minime.type].f_cliente_c+'" type="checkbox" data-filter="f1"  data-campo="aplicado" value="ON"  >';
                    $tmpHtml+='<label for="v_cliente_todos">Mostrar Todos</label>';
                    $tmpHtml+='<br />';
                    break;

                case "ba_estado":

                    ifields[$minime.type] = {
                        f_estado :  $id + "_opt"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:407px; height:320px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+$minime.ifields[$minime.type].f_estado+'" id="'+$minime.ifields[$minime.type].f_estado+'" multiple="multiple" size="5" style="height: 240px; width:400px;" >';
                    $tmpHtml+='<option class="option_NEON" value="AA">AA</option>';
                    $tmpHtml+='<option class="option_NEON" value="COMMENTS">COMMENTS</option>';
                    $tmpHtml+='<option class="option_NEON" value="CONTRACT">CONTRACT</option>';
                    $tmpHtml+='<option class="option_NEON" value="GARANTIA">GARANTIA</option>';
                    $tmpHtml+='<option class="option_NEON" value="NAVIERA">NAVIERA</option>';
                    $tmpHtml+='<option class="option_NEON" value="RETORNO">RETORNO</option>';
                    $tmpHtml+='<option class="option_NEON" value="RONY">RONY</option>';
                    $tmpHtml+='<option class="option_ROJO" value="BLOCKED">BLOCKED</option>';
                    $tmpHtml+='<option class="option_ROJO" value="ERROR">ERROR</option>';
                    $tmpHtml+='<option class="option_ROJO" value="HOLD">HOLD</option>';
                    $tmpHtml+='<option class="option_ROJO" value="RETAIN">RETAIN</option>';
                    $tmpHtml+='<option class="option_ROJO" value="STOP">STOP</option>';
                    $tmpHtml+='<option value="APP">APP</option>';
                    $tmpHtml+='<option value="CORRECTED">CORRECTED</option>';
                    $tmpHtml+='<option value="DEV">DEVOLUCION</option>';
                    $tmpHtml+='<option value="INC">INC</option>';
                    $tmpHtml+='<option value="LT">LINK</option>';
                    $tmpHtml+='<option value="LP">PARCIAL</option>';
                    $tmpHtml+='<option value="NA">NA</option>';
                    $tmpHtml+='<option value="ND">ND</option>';
                    $tmpHtml+='<option value="NEW">NEW</option>';
                    $tmpHtml+='<option value="PEND">PEND</option>';
                    $tmpHtml+='<option value="Q">Q</option>';
                    $tmpHtml+='<option value="RJ">RJ</option>';
                    $tmpHtml+='<option value="SYS">SYS</option>';
                    $tmpHtml+='</select>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+$minime.ifields[$minime.type].f_estado+'\').closest(\'div\').find(\'[data-localekey=selectAll]\').click(); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=APP]\').prop(\'selected\',false); $(\'#'+$minime.ifields[$minime.type].f_estado+'\').multiselect(\'refresh\');" class="toButton">-APP</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+$minime.ifields[$minime.type].f_estado+'\').closest(\'div\').find(\'[data-localekey=selectAll]\').click(); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=APP]\').prop(\'selected\',false); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=RJ]\').prop(\'selected\',false); $(\'#'+$minime.ifields[$minime.type].f_estado+'\').multiselect(\'refresh\');" class="toButton">-APP,RJ</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+$minime.ifields[$minime.type].f_estado+'\').closest(\'div\').find(\'[data-localekey=deselectAll]\').click(); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=ND]\').prop(\'selected\',true); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=NA]\').prop(\'selected\',true); $(\'#'+$minime.ifields[$minime.type].f_estado+'\').multiselect(\'refresh\');" class="toButton">+ND,NA</a>';
                    $tmpHtml+='<a href="javascript:void(0);" onclick="$(\'#'+$minime.ifields[$minime.type].f_estado+'\').closest(\'div\').find(\'[data-localekey=deselectAll]\').click(); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=ND]\').prop(\'selected\',true); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=NA]\').prop(\'selected\',true); $(\'#'+$minime.ifields[$minime.type].f_estado+' option[value=SYS]\').prop(\'selected\',true); $(\'#'+$minime.ifields[$minime.type].f_estado+'\').multiselect(\'refresh\');" class="toButton">+ND,NA,SYS</a>';
                    break;


                case "ba_o_estado":
                    ifields[$minime.type] = {
                        f_o_estado :  $id + "_o_opt",
                        f_o_estado_and :  $id + "_and",
                        f_o_estado_or :  $id + "_or"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:407px; height:320px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+$minime.ifields[$minime.type].f_o_estado+'" id="'+$minime.ifields[$minime.type].f_o_estado+'" multiple="multiple" size="5" style="height: 240px; width:400px;">'+$minime.extraf;
                    $tmpHtml+='</select>';
                    $tmpHtml+='<div style="display:inline-block; float: left;">';
                    $tmpHtml+='<input value="AND" name="'+$minime.ifields[$minime.type].f_o_estado_and+'" id="'+$minime.ifields[$minime.type].f_o_estado_and+'" type="radio" checked />';
                    $tmpHtml+='<label for="ba_estado_and"><strong>AND</strong></label>';
                    $tmpHtml+='<input value="OR" name="'+$minime.ifields[$minime.type].f_o_estado_and+'" id="'+$minime.ifields[$minime.type].f_o_estado_or+'" type="radio" />';
                    $tmpHtml+='<label for="f_estado_and"><strong>OR</strong></label>';
                    break;

                case "ba_categorias":

                    ifields[$minime.type] = {
                        f_categorias :  $id + "_cat"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id,
                            'style':"width:349px; height:89px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';
                    $tmpHtml+='<select id="'+$minime.ifields[$minime.type].f_categorias+'" name="'+$minime.ifields[$minime.type].f_categorias+'" class="notSelectize" >';
                    $tmpHtml+='</select>';

                    break;

                case "ba_group":
                    ifields[$minime.type] = {
                        f_group_yes :  $id + "_yes",
                        f_group_no :  $id + "_no",
                        f_group :  $id + "_group"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_quantity_dep",
                            'id':$fs_id
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100%",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml += '<tr><td><form >';
                    $tmpHtml += '<input name="'+$minime.ifields[$minime.type].f_group+'" id="'+$minime.ifields[$minime.type].f_group_yes+'" type="radio" value="1" > Yes<br>';
                    $tmpHtml += '<input name="'+$minime.ifields[$minime.type].f_group+'" id="'+$minime.ifields[$minime.type].f_group_no+'" type="radio" value="0" > No<br>';
                    $tmpHtml += '</form></td></tr>';

                    break;

                case "ba_multi_color":
                    ifields[$minime.type] = {
                        f_multi :  $id + "_multi"
                    };

                    $minime.ifields=ifields;

                    var $fs = $('<fieldset />',{
                            'name':$fs_id,
                            'class':"busqueda_access ba_multiselect",
                            'id':$fs_id,
                            'style':"width:407px; height:320px;"
                        }),
                        $le = $('<legend />').text($minime.title),
                        $table = $('<table />',{
                            'style':"width: 100% ",
                        }), $place;
                    $tmpHtml = '';

                    $tmpHtml+='<select class="selectopts multiselect" name="'+$minime.ifields[$minime.type].f_multi+'" id="'+$minime.ifields[$minime.type].f_multi+'" multiple="multiple" size="5" style="height: 240px; width:400px;">'+$minime.extraf;

                    $tmpHtml += '</select>';

                    break;
            }

            //VCA /////////////////////////////////////////////////////////
            //VCA sumasGridServer.
            $a = $('<a />', {
                href:'javascript:void(0);',
                'class':'vx_adcb_limpia',
            }).append($('<img />', {
                src:'../img/16-refresh.png',
                title:'Limpiar',
                style:'padding-top: 3px;'
            })).on('click', function(){
                var $tmp = $('#'+$fs_id).find('input,i,button');//$elem.parent().find('input');
                switch($minime.type)
                {
                    case 'ba_multi': case 'ba_multi_color':case 'ba_estado': case 'ba_o_estado':
                        $tmp.filter("[data-localekey=deselectAll]").click();
                    break;

                    case 'ba_tagify':
                        $tmp.filter("[class=tagify-remove]").click();
                        $tmp.filter("[id$='_or']").prop('checked', true);
                    break;

                    default:
                        $tmp.filter("[type=text]").val('');
                        $tmp.filter("[type=radio]").prop('checked', false);
                        $('select').val(''); //VCA SEP2019
                        $('#'+$fs_id).find('select').not('.notSelectize').each(function(){$(this).selectize()[0].selectize.reset2InitialValue();});
                    break;
                }

                //$('#' + $minime.ifields[$minime.type][Object.keys($minime.ifields[$minime.type])[0]]).change();
                //$minime._buildSQLString();
                $minime.sqlString = "";
            });
            //VCA sumasGridServer.

            $table.append($tmpHtml);
            $fs.append($le);
            $fs.append($table);
            $fs.append($elem);
            $fs.append($a);
            $div.append($fs);
            $gr.append($div);

            //VCA /////////////////////////////////////////////////////////

            //$elem.after($a);

            setTimeout(function(){ //Para la inicialización. Algunos elementos todavía no existen.
                $.each($minime.ifields[$minime.type], function(k,v){
                    $('#'+v).on('change', function() { //Para el cambio. Algunos eventos aún no terminan.
                        setTimeout(function(){
                            if(v==$minime.ifields[$minime.type].f_cliente_c){
                                $me.clientes_init_array();
                            }
                            //Ejecutamos las funciones OnChangeFn
                            if($minime.posOnChangeFn.length && typeof window[$minime.posOnChangeFn] === 'function')
                                window[$minime.posOnChangeFn]();
                            $me._buildSQLString();
                        },100);
                    });
                })
            }, 100);

            this.cliente_init_autocomplete();
            init_multiselect($id+'_bt_fs');
            init_autoNumeric($id+'_bt_fs');
            init_datepicker($id+'_bt_fs');
            init_tagify($id+'_bt_fs');
            init_boton($id+'_bt_fs');
            this.init_categorias();

            $('.vx_autoBusquedaRapidaSelectize').filter('select:not(.notSelectize, [class^=ui-], [multiple])').selectize();
            $minime.icbs = [];
            $($me.options.cbs).reverse().each(function(k,v){
                var icbsid = $id + this.nombre, tmpel = {}, tmplbl = {};
                $minime.icbs[icbsid] = {
                    fn : this.fn
                    ,fi : this.fi
                    ,ff : this.ff
                };
                if($minime.type=="ba_fecha")
                {

                    tmpel = $('<input />', {
                        id:    icbsid
                        ,name:  $id + "_vx_autoBusquedaRapida"
                        ,value: 'ON'
                        ,type:  'radio'
                        ,checked:false
                        ,'class':"vx_adcb_class"
                    }).on('change', function(){
                        $('#'+$minime.ifields[$minime.type].f_fechaIni).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].fi]);
                        $('#'+$minime.ifields[$minime.type].f_fechaFin).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].ff]).change();
                        $me._buildSQLString();
                    });

                    tmplbl = $('<label />', { 'for': icbsid, 'class':"vx_adcb_class" }).html(this.label + '&nbsp;&nbsp;');
                }


                $elem.after(tmplbl).after(tmpel);
                if(k<4&&((k+1)%3==0) && ($minime.type=="ba_fecha") )
                    $elem.after("<br/>");
            });
        },

        /**
         * The 'destroy' method is were you free the resources used by your plugin:
         * references, unregister listeners, etc.
         *
         * Remember to unbind for your event:
         *
         * @example
         * this.$someSubElement.off('.' + pluginName);
         *
         * Above example will remove any listener from your plugin for on the given
         * element.
         */

        destroy: function() {

            // Remove any attached data from your plugin
            this.$el.removeData();
        },

        setTipodeBusqueda: function(tdB){
            var $me = this, tdB = tdB || window['tipodeBusqueda'];
            $me.options.tipodeBusqueda = tdB.length ? tdB : typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
        },

        /**
         * Write public methods within the plugin's prototype. They can
         * be called with:
         *
         * @example
         * $('#element').jqueryPlugin('somePublicMethod','Arguments', 'Here', 1001);
         *
         * @param  {[$id]} foo [some parameter]
         * @param  {[$id]} bar [some other parameter]
         * @return {[$id]}
         */
        _buildSQLString: function() {

            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime = $me.options.instances[$id],
                sqlS='', $txt='', posDo=false, negDo=false;

            $(':focus').blur();

            switch($minime.type)
            {
                case "ba_fecha":
                    var adbt_ini=$('#'+$minime.ifields[$minime.type].f_fechaIni).val(),
                        adbt_fin=$('#'+$minime.ifields[$minime.type].f_fechaFin).val(),
                        adbtt_ini=$('#'+$minime.ifields[$minime.type].f_horaIni).val(),
                        adbtt_fin=$('#'+$minime.ifields[$minime.type].f_horaFin).val();


                    if(!adbt_ini.length && !adbt_fin.length)
                        return $minime.sqlString = sqlS;

                    adbt_ini = adbt_ini.length ? $me._cambiaFormatoFecha(adbt_ini) : '2000-01-01';
                    adbt_fin = adbt_fin.length ? $me._cambiaFormatoFecha(adbt_fin) : '2100-12-31';

                    adbtt_ini = adbtt_ini.length ? adbtt_ini + ":00:00" : "00:00:00";
                    adbtt_fin = adbtt_fin.length && adbtt_fin < '24' ? adbtt_fin + ":00:00" : "23:59:59";

                    $.each($minime.field, function(k,v){
                        sqlS = $minime.xtrasqlpre + "(" + v + " >= '"+adbt_ini+" "+adbtt_ini+"' AND " + v + " <='"+adbt_fin+" "+adbtt_fin+"') " + $minime.xtrasqlpost + " "+$me.options.tipodeBusqueda+" ";
                    });

                    if(sqlS.length)
                        posDo = true;

                    break;
                //VCA /////////////////////////////////////////////////////////
                case "ba_monto":
                    var asm_monto=$('#'+$minime.ifields[$minime.type].f_monto).val(),
                        asm_comp=$('#'+$minime.ifields[$minime.type].f_comparador + " option:selected").val(),
                        asm_tipo=$('#'+$minime.ifields[$minime.type].f_tipo + " option:selected").val();

                    if(""!=asm_monto.length)
                    {
                        asm_monto = asm_monto.length ? vx_utils.parseFloat(asm_monto) : '';
                        if ($minime.table=="")
                        {
                            //sqlS = $minime.xtrasqlpre + "(" + $minime.field + " " + obtenComparador(asm_comp) + "'"+asm_monto+"') " + $minime.xtrasqlpost + " "+$me.options.tipodeBusqueda+" ";
                            sqlS = $minime.xtrasqlpre + $minime.field + " " + obtenComparador(asm_comp) + "'"+asm_monto+"' " + $minime.xtrasqlpost + " "+$me.options.tipodeBusqueda+" ";
                        }else{
                            sqlS = $minime.field+" IN (SELECT "+$minime.extrafield+" "+$minime.field+" FROM "+$minime.table+" WHERE "+$minime.wfield+"='"+asm_monto+"') "+$me.options.tipodeBusqueda+" ";
                        }

                    }

                    break;

                case "ba_t_deposit":
                    var asm_monto=$('#'+$minime.ifields[$minime.type].f_monto).val(),
                        asm_comp=$('#'+$minime.ifields[$minime.type].f_comparador + " option:selected").val(),
                        asm_tipo=$('#'+$minime.ifields[$minime.type].f_tipo + " option:selected").val();

                    if(!asm_monto.length)
                        return $minime.sqlString = sqlS;

                    asm_monto = asm_monto.length ? vx_utils.parseFloat(asm_monto) : '';
                    sqlS = $minime.xtrasqlpre;
                    $.each($minime.field, function(k,v){
                        if(asm_tipo=="")
                        {
                            //sqlS = $minime.xtrasqlpre + "(" + v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"') " + $minime.xtrasqlpost + " "+$me.options.tipodeBusqueda+" ";
                            sqlS += v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"' OR "
                        }
                        else
                        {
                            if(asm_tipo==v) {
                                sqlS += v + " " + obtenComparador(asm_comp) + "'" + asm_monto + "' OR ";
                                return false;
                            }
                        }
                    });
                    sqlS = sqlS.substring(0, sqlS.length - 3);
                    sqlS = "( " + sqlS + " )";
                    sqlS += $minime.xtrasqlpost + " "+$me.options.tipodeBusqueda+" ";
                    break;
                //VCA /////////////////////////////////////////////////////////

                case "ba_bancos":

                    var banco_id=$('#'+$minime.ifields[$minime.type].f_banco).val();
                    if (banco_id==0) {
                        sqlS = "";
                    }else{
                        sqlS = $minime.xtrasqlpre + "("+$minime.field+" = '"+banco_id+"')  OR ";
                    }




                    break;

                //VCA Había un error. No ponía el valor elegido. Estaba poniendo las reglas de cheque delivered.
                //VCA /////////////////////////////////////////////////////////
                //VCA sumasGridServer.
                case "ba_sn":

                    var ba_sn=$('#'+$minime.ifields[$minime.type].f_sn).val(),
                        arre= ['todos','no','si'],
                        dd = false;
                    ba_sn = ba_sn.toLowerCase();
                    dd = $minime.extraf.hasOwnProperty('cuentaT_deliveredto_id') ? true : false;
                    arre['todos'] = $minime.extraf.hasOwnProperty('TODOS') ? $minime.extraf['TODOS'] : 'TODOS';
                    arre['no'] = $minime.extraf.hasOwnProperty('NO') ? $minime.extraf['NO'] : 'NO';
                    arre['si'] = $minime.extraf.hasOwnProperty('SI') ? $minime.extraf['SI'] : 'SI';

                    switch(ba_sn)
                    {

                        case "no":
                            if(dd)
                                sqlS = arre[ba_sn] +" "+ $me.options.tipodeBusqueda;
                            else
                                sqlS =" "+$minime.field+"='"+ba_sn+"' "+$me.options.tipodeBusqueda+" ";

                            break;

                        case "si":
                            if(dd)
                                sqlS = arre[ba_sn] +" "+ $me.options.tipodeBusqueda;
                            else
                                sqlS =" "+$minime.field+"='"+ba_sn+"' "+$me.options.tipodeBusqueda+" ";
                            break;

                        case "todos":
                            sqlS ="";
                            break;
                    }

                    break;
                //VCA /////////////////////////////////////////////////////////
                //VCA sumasGridServer.

                case "ba_atrasado":

                    var delivered=$('#'+$minime.ifields[$minime.type].f_sn).val();
                    var arre=["","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND solicitud_reembolso_fecha IS NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))","( DATEDIFF(NOW(),fecha_retiro) > 180 AND terminado = 'No' AND solicitud_reembolso_fecha IS NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 180 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))"];
                    var arre2=["","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND solicitud_reembolso_fecha IS NOT NULL OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND solicitud_reembolso_fecha IS NOT NULL AND monto_reembolsado = 0 AND monto_cancelado = 0 ))","( DATEDIFF(NOW(),fecha_retiro) > 175 AND terminado = 'No' AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > 3 OR fiduciario_id IN ( SELECT fiduciario_id FROM fiduciario_contenedor WHERE DATEDIFF(NOW(),fecha_retiro) > 175 AND fiduciario_reembolso_id IS NULL AND DATEDIFF(NOW(),solicitud_reembolso_fecha) > 3 AND monto_reembolsado = 0 AND monto_cancelado = 0 ))"];
                    var arre3=["","( fiduciario_id IN (SELECT fiduciario_id FROM fiduciario_contenedor WHERE error='No' ))","( fiduciario_id IN (SELECT fiduciario_id FROM fiduciario_contenedor WHERE error IN ('Si','Tu') ))"];

                    switch($minime.title)
                    {

                        case 0:
                            sqlS =arre[delivered]+$me.options.tipodeBusqueda+" ";
                            break;

                        case 1:
                            sqlS =arre2[delivered]+$me.options.tipodeBusqueda+" ";
                            break;

                        case 2:
                            sqlS =arre3[delivered]+$me.options.tipodeBusqueda+" ";
                            break;
                    }



                    break;

                case "ba_yes_no":
                    var sqlS = "",
                        arre= ['NO','SI'],
                        yes_no=$('input:radio[name='+$minime.ifields[$minime.type].f_yes+']:checked').val();

                    arre[0] = $minime.extraf.hasOwnProperty('NO') ? $minime.extraf['NO'] : 'NO';
                    arre[1] = $minime.extraf.hasOwnProperty('SI') ? $minime.extraf['SI'] : 'SI';
                    arre[2] = $minime.extraf.hasOwnProperty('SI') || $minime.extraf.hasOwnProperty('NO') ? true : false


                    if(yes_no!=undefined){
                        //Porque hay campos de SI/NO YES/NO cuyo valor es 0,1 ó SI,NO
                        if(arre[2])
                            sqlS ="("+arre[yes_no]+$minime.extras+") "+$me.options.tipodeBusqueda;
                        else
                        {
                            if($minime.extraf.hasOwnProperty('resBinary'))
                                sqlS ="("+$minime.field+"='"+yes_no+"' "+$minime.extras+") "+$me.options.tipodeBusqueda;
                            else
                                sqlS ="("+$minime.field+"='"+yes_no+"' OR "+$minime.field+" IN ('"+arre[yes_no]+"'"+$minime.extras+")) "+$me.options.tipodeBusqueda;
                        }
                    }else{
                        sqlS ="";
                    }



                    break;

                case "ba_tagify":

                    if ($("#"+$minime.ifields[$minime.type].f_in_text).val()!="")
                    {

                        if ($minime.table=="")
                        {
                            sqlS = "("+ buildStringwithDelimeters('','','',$minime.ifields[$minime.type].f_in_text,'SI',$minime.field) +")" +$me.options.tipodeBusqueda+" ";
                        }else{
                            sqlS = $minime.field+" IN (SELECT "+$minime.extrafield+" "+$minime.field+" FROM "+$minime.table+" WHERE "+$minime.wfield+" LIKE '%25"+asm_monto+"%25') "+$me.options.tipodeBusqueda+" ";
                        }
                    }else{
                        sqlS = "";
                    }



                    break;

                case "ba_multi":
                    //VCA /////////////////////////////////////////////////////////
                    var m_selec=$("#"+$minime.ifields[$minime.type].f_multi).val();

                    if(m_selec.length || $minime.extraf.emptyVal){
                        if(!m_selec.length && $minime.extraf.emptyVal)
                            sqlS=$minime.field+" <> '' OR ";
                        else
                            sqlS=$minime.field+" IN ('"+m_selec.join('\',\'')+"')  OR ";
                        posDo = true;
                    }else{
                        sqlS="";
                        negDo = false;
                    }

                    //VCA /////////////////////////////////////////////////////////

                    break;

                case "ba_cliente":



                    if($("#"+$minime.ifields[$minime.type].f_cliente_i).val().length  && $("#"+$minime.ifields[$minime.type].f_cliente_i_id).val().length)
                    {
                        sqlS = " "+$minime.field+" = '"+ $("#"+$minime.ifields[$minime.type].f_cliente_i_id).val() +"' "+tipodeBusqueda+" ";
                    }
                    else if($("#"+$minime.ifields[$minime.type].f_cliente_i).val().length  )
                    {
                        sqlS = " "+$minime.field+" IN (SELECT "+$minime.field+" FROM cliente WHERE nombre LIKE '%25"+$("#"+$minime.ifields[$minime.type].f_cliente_i).val()+"%25') "+tipodeBusqueda+" ";
                    }else{
                        qlS = "";
                    }



                    break;


                case "ba_estado":

                    if ($("#"+$minime.ifields[$minime.type].f_estado).val().length>0) {
                        sqlS =  $minime.field+" IN (\'"+$("#"+$minime.ifields[$minime.type].f_estado).val().join('\',\'')+"\')  "+$me.options.tipodeBusqueda+" ";
                    }else{
                        sqlS = "";
                    }


                    break;

                case "ba_o_estado":


                    if ($("#"+$minime.ifields[$minime.type].f_o_estado).val().length>0) {

                        sqlS = this.regex(sqlS);
                    }else{
                        sqlS = "";
                    }



                    break;


                case "ba_categorias":

                    var categoria=$('#'+$minime.ifields[$minime.type].f_categorias).val();
                    if(categoria!="")
                    {
                        sqlS =  $minime.field+"=\'"+categoria+"\'  "+$me.options.tipodeBusqueda+" ";
                    }else{
                        sqlS = "";
                    }



                    break;

                case "ba_group":
                    var s_n=$("input:radio[name="+$minime.ifields[$minime.type].f_group+"]:checked").val();

                    if(s_n!=undefined)
                    {
                        this.Agrupar(s_n,$minime.field,$minime.top,$minime.extrafield);
                    }else
                    {
                        this.Agrupar(0,$minime.field,$minime.top,$minime.extrafield);
                    }

                    break;

                case "ba_multi_color":

                    if ($("#"+$minime.ifields[$minime.type].f_multi).val().length>0) {
                        sqlS =  $minime.field+" IN (\'"+$("#"+$minime.ifields[$minime.type].f_multi).val().join('\',\'')+"\')  "+$me.options.tipodeBusqueda+" ";
                    }else{
                        sqlS = "";
                    }


                    break;
            }

            sqlS = sqlS.slice(0, -4);
            //VCA /////////////////////////////////////////////////////////
            sqlS = $minime.field.length > 1 ? " ( " + sqlS + " ) " : sqlS;
            //sqlS = $minime.field.length > 1 && $minime.type != 'ba_t_deposit' ? " ( " + sqlS + " ) " : sqlS;
            //VCA /////////////////////////////////////////////////////////

            $minime.sqlString = sqlS;

            if(posDo && !$minime.doPosFn.hasOwnProperty($minime.posFn) && $minime.posFn.length)
                $minime.doPosFn[$id] = $minime.posFn;

            if(negDo && !$minime.doNegFn.hasOwnProperty($minime.negFn) && $minime.negFn.length)
                $minime.doNegFn[$id] = $minime.negFn;

            for (var key in $me.options.instances) {
                if ($me.options.instances.hasOwnProperty(key))
                {
                    $txt+=$me.options.instances[key].sqlString.length ? $me.options.instances[key].sqlString+" "+$me.options.tipodeBusqueda+" " : "";
                }
            }

            $me.options.sqlString = $txt;

            //console.log(sqlS);
            return sqlS;
        },

        /**
         * Another public method which acts as a getter method. You can call as any usual
         * public method:
         *
         * @example
         * $('#element').jqueryPlugin('someGetterMethod');
         *
         * to get some interesting info from your plugin.
         *
         * @return {[$id]} Return something
         */
        getOptions: function() {
            return this.options;
        },

        getSQLString: function() {
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input');
            return $me.options.instances[$id].sqlString;
        },

        //VCA /////////////////////////////////////////////////////////
        getSQLStringAll: function() {
            var $me = this,
                $minime = $me.options.instances,
                $li = {},
                $txt = '';
            var tipodeBusqueda = $('input:radio[name=but_control]:checked').val();

            if(typeof giacwhere === 'undefined')
                giacwhere = '';

            for (var key in $minime) {
                if ($minime.hasOwnProperty(key)) {
                    try {
                        //VCA OCT2019
                        $li = $('.vx_autoBusquedaRapida').filter('input,select#' + key);
                        if(!$li.length)
                            continue;
                        $li = $.data($li[0], 'plugin_vx_autoBusquedaRapida');
                        $li._buildSQLString();
                        $txt += $minime[key].sqlString.length ? $minime[key].sqlString + " " + tipodeBusqueda + " " : "";
                        //VCA OCT2019
                    }
                    catch(err){console.log(err)}
                }
            }
            $txt = $txt.trim();
            $txt = $txt.substring(0, $txt.lastIndexOf(tipodeBusqueda));
            $txt = $txt.trim();
            if($txt.length)
                if(giacwhere.length)
                    $me.options.sqlString = giacwhere + " AND (" + $txt + ")";
                else
                    $me.options.sqlString = $txt;

            //console.log("\r\nSQL:-"+$me.options.sqlString);
            return $me.options.sqlString;
        },
        //VCA /////////////////////////////////////////////////////////

        init_categorias:function()
        {
            //if (typeof jQuery.fn.tinymce == 'function') {
            if(typeof $.fn.Clasificator === 'function')
            {
                var $me = this,
                    $elem = $me.$el,
                    $id = $elem.data('input'),
                    $minime=$me.options.instances[$id] ;
                //console.log($me.options.instances[$id] );
                $('#'+$minime.ifields[$minime.type].f_categorias).Clasificator({
                    'readurl':'ajax/categoria_gasto_do.php',
                    editable:false,
                    maxLevel:3,
                    uniqueNameBy:'level',
                    topOffsetScroll:200,
                }).Clasificator('selectHeirarchy',true);
            }
        },



        regex : function(sqlS){

            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime=$me.options.instances[$id],
                valor;

            var estado_val = '____________', valor = '', regexp = '', delim = '';
            estado_val = estado_val.split('');

            if($('input:radio[name='+$minime.ifields[$minime.type].f_o_estado_and+']:checked').val()=="AND")
                delim = '*';
            else
                delim = '|';

            $("#"+$minime.ifields[$minime.type].f_o_estado+' option:selected').each(function() {
                valor = $(this).data('valor').split('');
                $.each(valor, function(i){
                    if(this=='1')
                    {
                        if(delim == '|')
                            regexp += "^" + pad(i+1, '1', '.') + delim;
                        else
                            estado_val[i] = '1';
                        return false;
                    }
                });
            });

            if(delim == '|')
            {
                regexp = regexp.slice(0, - 1);
                sqlS += ' estado';
                sqlS += " REGEXP '"+regexp+"' ";
                sqlS += " "+$me.options.tipodeBusqueda+" ";
            }
            else
            {
                estado_val = estado_val.join('');
                sqlS += ' estado';
                sqlS += " LIKE '"+estado_val+"' ";
                sqlS += " "+$me.options.tipodeBusqueda+" ";
            }
            return sqlS;

        },

        Agrupar: function(opt,field,top,fiel2)
        {
            //console.log(opt+"<<<>>>"+field);
            if(opt==1)
            {
                $gridParams.postData.iaccols = $gridParams.postData.iaccols.replace(field,top+"("+field+")");
                $gridParams.postData.iacgroupby = "GROUP BY DATE("+fiel2+")";
            }else{
                $gridParams.postData.iaccols = $gridParams.postData.iaccols.replace(top+"("+field+")",field);
                $gridParams.postData.iacgroupby = "";
            }

        },

        //VCA /////////////////////////////////////////////////////////
        Buscar: function()
        {
            //VCA iaSumaGridServer
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                //$minime=$me.options.instances[$id],
                $lf = $(':focus'),
                iacwhere = '';

            window['brLastFocus'] = $lf.hasOwnProperty(0) ? $lf[0].id : '';
            //console.log("follanos:", window['brLastFocus']);

            $(':focus').blur();

            if(typeof globalIACWhere === 'undefined')
                globalIACWhere = "";

            if(typeof defWhere === 'undefined')
                defWhere = "";

            orGridTrigger = false;

            $(".ui-jqgrid-ftable td").html("&#160;");
            gridhandler.jqGrid('clearGridData');
            iacJqGridSelectShow("","limpia");

            iacwhere=$me.getSQLStringAll() + (globalIACWhere.length ? " AND " : "" ) + globalIACWhere;

            if(($('#btn_ebr').offset().top - $(window).scrollTop()) < 950 )
                $("html, body").animate({ scrollTop: 0 });

            setTimeout(function(){
                if(iacwhere.length && iacwhere != giacwhere)
                {
                    //VCA iaSumaGridServer
                    var newSortName = newSortName === undefined ? "" : newSortName,
                        newSortOrder = newSortOrder === undefined ? "" : newSortOrder,
                        doNewSort = doNewSort === undefined ? "" : doNewSort,
                        defSortName = defSortName === undefined ? $gridParams.sortname : defSortName,
                        defSortOrder = defSortOrder === undefined ? $gridParams.sortorder : defSortOrder,
                        $doFn = {};

                    $gridParams.postData.old_iaarr_md5 = $gridParams.postData.iaarr_md5;
                    $gridParams.postData.iaarr_md5 = '';

                    delete $gridParams.postData.iacwhere;
                    delete $gridParams.postData.filters;

                    delete $gridParams.postData.orGridTrigger;
                    delete $gridParams.postData.iaSoloSumas;
                    delete $gridParams.postData.desdeBusquedaRapida;
                    delete $gridParams.postData.iaGridInicial;
                    delete $gridParams.postData.respetaLimit;

                    $gridParams.postData.iaSoloSumas = 'NO';
                    $gridParams.postData.orGridTrigger = "NO";
                    $gridParams.postData.respetaLimit = "NO";

                    $gridParams.postData.filters = '';
                    $gridParams.postData.iacwhere = iacwhere;
                    $gridParams.postData.sidx = doNewSort?newSortName:defSortName;
                    $gridParams.postData.sord = doNewSort?newSortOrder:defSortOrder;

                    $gridParams.sortname = doNewSort?newSortName:defSortName;
                    $gridParams.sortorder = doNewSort?newSortOrder:defSortOrder;
                    doNewSort=false;


                    $gridParams.postData.iacwhere=iacwhere;
                    $gridParams.postData.iaSumaGridServer = 'SI';
                    $gridParams.rowNum = vx_utils.parseFloat(10000000);
                    $('.ui-pg-selbox').val('10000000');

                    $gridParams.postData.desdeBusquedaRapida = 'SI';
                    $gridParams.postData.iaGridInicial = 'NO';

                    orGridTrigger = false;

                    if(typeof window['antesEjecutaBusquedaRapida'] === 'function')
                        window['antesEjecutaBusquedaRapida']();

                    //Ejecutamos todas las funciones posFn y negFn que estén en la pila
                    $doFn = $me._fieldFunctions();
                    Object.getOwnPropertyNames($doFn.doPosFn).forEach( function (val, idx, array) { if($doFn.doPosFn[val].length && typeof window[$doFn.doPosFn[val]] === 'function') window[$doFn.doPosFn[val]](); });

                    Object.getOwnPropertyNames($doFn.doNegFn).forEach( function (val, idx, array) { if($doFn.doNegFn[val].length && typeof window[$doFn.doNegFn[val]] === 'function') window[$doFn.doNegFn[val]](); });

                    gridhandler[0].clearToolbar();
                    gridhandler.trigger('reloadGrid');

                    setTimeout(function(){ $gridParams.postData.desdeBusquedaRapida = 'NO';}, 10);
                    //VCA iaSumaGridServer
                }

            },100);

        },
        //VCA /////////////////////////////////////////////////////////

        //VCA //////////////////////////////////
        cleanAll: function(cleanWhere) {
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime=$me.options.instances[$id];

            cleanWhere = typeof(cleanWhere) == 'undefined' ? 'SI' : cleanWhere;

            $me.options.sqlString = "";
            $me.sqlString = "";
            for(var $mm in $me.options.instances)
                $me.options.instances[$mm].sqlString = '';

            //VCA OCT2019
            if($("#macro_sel").length) $("#macro_sel").selectize()[0].selectize.reset2InitialValue();
            $('.vx_adcb_limpia').each(function(){this.click();});
            resetSelectize2InitialValue('vx_autoBusquedaRapidaSelectize');

            //"undefined" === typeof giacwhere && (giacwhere = "");
            if(typeof giacwhere === 'undefined')
                giacwhere = '';

            if(typeof globalIACWhere === 'undefined')
                globalIACWhere = "";

            if(typeof defWhere === 'undefined')
                defWhere = "";

            if(cleanWhere == 'SI')
                $gridParams.postData.iacwhere = giacwhere + defWhere;

            $gridParams.postData.iaSumaGridServer = 'NO';
            $gridParams.postData.desdeBusquedaRapida = 'NO';
            $gridParams.postData.iaGridFiltros = 'NO';

            orGridTrigger = false;


            $minime.doPosFn = [];
            $minime.doNegFn = [];
            $gridParams.rowNum = 100;
            $('.ui-pg-selbox').val('100');
            if(typeof window['antesLimpiaBusquedaRapida'] === 'function')
                window['antesLimpiaBusquedaRapida']();


        },
        //VCA //////////////////////////////////

        /**
         * You can use the name convention functions started with underscore are
         * private. Really calls to functions starting with underscore are
         * filtered, for example:
         *
         *  @example
         *  $('#element').jqueryPlugin('_pseudoPrivateMethod');  // Will not work
         */
        _cambiaFormatoFecha: function(fecha, formato){
            if (fecha.length < 10) return '';
            if (!formato || formato.length==0) var formato='MySQL';
            var cd='-',
                aFecha=fecha.split(cd),
                sDia=aFecha[0],
                sMes=aFecha[1],
                sAnio=aFecha[2],
                ff='';
            switch (formato){
                case 'MySQL':
                    ff=sAnio + '-' + sMes + '-' + sDia;
                    break;
                case 'JS':
                    ff=sDia + '-' + sMes + '-' + sAnio;
                    break;
                default:
                    ff=sAnio + '-' + sMes + '-' + sDia;
                    break;
            }
            return ff;
        },
        //VCA /////////////////////////////////////////////////////////
        //

        _fieldFunctions: function()
        {
            var $me = this,
                $minime = $me.options.instances,
                $doFn = {'doPosFn':[], 'doNegFn':[]};

            //Object.getOwnPropertyNames($me.options.posFn).forEach( function ($instance, idx, array) { $me.options.posFn = $.extend({}, $instance.options.posFn, $me.options.posFn); });
            //Object.getOwnPropertyNames($me.options.negFn).forEach( function ($instance, idx, array) { $me.options.negFn = $.extend({}, $instance.options.negFn, $me.options.negFn); });

            for (var instance in $minime) {
                if ($minime.hasOwnProperty(instance)) {
                    $doFn.doPosFn = $.extend({}, $minime[instance].doPosFn, $doFn.doPosFn);
                    $doFn.doNegFn = $.extend({}, $minime[instance].doNegFn, $doFn.doNegFn);
                }
            }

            return $doFn;
        },

        init_botones:function()
        {
            $('#btn_ebr').button();
            $('#btn_lbr').button();

            /**
             $('body').on('keydown', function (e) {

				var key = e.which;
				switch (key) {
			  		case 117:
                        $(':focus').blur();
			  			$('#btn_ebr').click();
			  			e.preventDefault();
			  		break;

			  		case 118:
                        $(':focus').blur();
			  			$('#btn_lbr').click();
			  			e.preventDefault();
			  		break;
		    	}

			});
             **/
        },

        cliente_init_autocomplete: function ()
        {

            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime = $me.options.instances[$id];



            $("#"+$minime.ifields[$minime.type].f_cliente_i).autocomplete({
                source: function( request, response ) {
                    if(request.term == '#@@#') request.term = '';
                    var matcher = new RegExp( $.ui.autocomplete.escapeRegex( request.term ), "i" );

                    response( $.grep( $minime.clientes, function( value ) {
                        value = value.label || value.value || value;
                        return matcher.test( value );
                    }) );
                },
                minLength: 0,
                select: function(event, ui) {
                    //$('#rmetodoDePago').val(ui.item.metodoDePago);
                    $('#'+$minime.ifields[$minime.type].f_cliente_i_id).val(ui.item.cliente_id);
                    $('#'+$minime.ifields[$minime.type].f_cliente_i_id).change();
                    //$('#v_cliente_de_paso').val(ui.item.cliente_de_paso);
                    //$('#btn_ebr').button('enable');
                    //$('#btn_lbr').button('enable');
                    //$("#rmetodoDePago").autocomplete("close");
                },
                change: function(event, ui) {
                    if($(this).val().length && ui.item != null)
                    {
                        $('#'+$minime.ifields[$minime.type].f_cliente_i_id).val(ui.item.cliente_id);
                        $('#'+$minime.ifields[$minime.type].f_cliente_i_id).change();
                        //$('#v_cliente_de_paso').val(ui.item.cliente_de_paso);
                        //$('#btn_ebr').button('enable');
                        //$('#btn_lbr').button('enable');
                    }
                }
            });
        },


        clientes_init_array: function ()
        {
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime = $me.options.instances[$id];

            if($minime.extraf.hasOwnProperty('filePath'))
            {
                var json=$minime.extraf.filePath.split(',');


                var stringData = $.ajax({
                    url: './json/'+  json[$('#'+$minime.ifields[$minime.type].f_cliente_c).is(':checked') ? 1:0] ,
                    async: false
                }).responseText;

                $minime.clientes_json = JSON.parse(stringData);
            }


            $minime.clientes = [];
            $.each($minime.clientes_json, function(index, cliente)
            {
                $minime.clientes.push(
                    {
                        label: cliente.nombre,
                        value: cliente.nombre,
                        cliente:   cliente.nombre,
                        cliente_id: cliente.cliente_id,

                    });
            });


        }
    };

    /**
     * This is a real private method. A plugin instance has access to it
     * @return {[$id]}
     */
    var privateMethod = function() {
        //console.log("privateMethod");
        //console.log(this);
    };

    /**
     * This is were we register our plugin withint jQuery plugins.
     * It is a plugin wrapper around the constructor and prevents agains multiple
     * plugin instantiation (soteing a plugin reference within the element's data)
     * and avoid any function starting with an underscore to be called (emulating
     * private functions).
     *
     * @example
     * $('#element').jqueryPlugin({
     *     defaultOption: 'this options overrides a default plugin option',
     *     additionalOption: 'this is a new option'
     * });
     */

    $.fn[pluginName] = function(options) {
        var args = arguments, thisZero = {}, instance = {};

        if (options === undefined || typeof options === 'object') {
            // Creates a new plugin instance, for each selected element, and
            // stores a reference withint the element's data
            return this.each(function() {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName, new Plugin(this, options));
                }
            });
        } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
            // Call a public pluguin method (not starting with an underscore) for each
            // selected element.
            if (Array.prototype.slice.call(args, 1).length == 0 && $.inArray(options, $.fn[pluginName].getters) != -1) {
                // If the user does not pass any arguments and the method allows to
                // work as a getter then break the chainability so we can return a value
                // instead the element reference.
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoBusquedaRapida')[0] !== "undefined" ? $('.vx_autoBusquedaRapida')[0] : undefined;
                instance = $.data(thisZero, 'plugin_' + pluginName);
                return instance[options].apply(instance, Array.prototype.slice.call(args, 1));
            } else {
                // Invoke the speficied method on each selected element
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoBusquedaRapida')[0] !== "undefined" ? $('.vx_autoBusquedaRapida')[0] : undefined;
                thisZero = $([thisZero]);
                return thisZero.each(function() {
                    instance = $.data(this, 'plugin_' + pluginName);
                    if (instance instanceof Plugin && typeof instance[options] === 'function') {
                        instance[options].apply(instance, Array.prototype.slice.call(args, 1));
                    }
                });
            }
        }
    };


    /**
     * Names of the pluguin methods that can act as a getter method.
     * @type {Array}
     */
    $.fn[pluginName].getters = ['getOptions','getSQLString','getSQLStringAll'];

    /**
     * Default optionsprimero     :   getFirstDayOfCurrentMonth(d),
     ultimo      :   getLastDayOfCurrentMonth(d),
     */
    var d = new Date();
    $.fn[pluginName].defaults = {
        posFn       :   [],
        negFn       :   [],
        doPosFn     :   [],
        doNegFn     :   [],
        instances   :   [],
        fns         :   {
            hoy         :   d,
            ayer        :   getLastXDays(d, 1),
            lunes       :   getMondayOfCurrentWeek(d),
            domingo     :   getSundayOfCurrentWeek(d),
            primero     :   getDayOfMonth(d, "primero"),
            ultimo      :   getDayOfMonth(d, "ultimo"),
            ultimos10   :   getLastXDays(d, 10),
            pripasado   :   getDayOfMonth(d, "primero", "pasado"),
            ultpasado   :   getDayOfMonth(d, "ultimo", "pasado"),
            primeroano  :   getThisYear(d), //VCA OCT2019
        },
        cbs         :   [
            {'nombre':'_cb_today', 'label':'Today', 'fn':'today', 'fi':'hoy', 'ff':'hoy'},
            {'nombre':'_cb_yesterday', 'label':'Yesterday', 'fn':'yesterday', 'fi':'ayer', 'ff':'ayer'},
            {'nombre':'_cb_thisweek', 'label':'This week', 'fn':'thisweek', 'fi':'lunes', 'ff':'domingo'},
            //{'nombre':'_cb_last10days', 'label':'Last 10 days', 'fn':'last10days', 'fi':'ultimos10', 'ff':'hoy'},
            {'nombre':'_cb_thismonth', 'label':'This month', 'fn':'thismonth', 'fi':'primero', 'ff':'ultimo'},
            {'nombre':'_cb_lastmonth', 'label':'Last month', 'fn':'lastmonth', 'fi':'pripasado', 'ff':'ultpasado'},
            {'nombre':'_cb_thisyear', 'label':'This year', 'fn':'thisyear', 'fi':'primeroano', 'ff':'hoy'},  //VCA OCT2019
        ],
        icbs        :   [],
        ifields     :   [],
        input       :   'input',
        field       :   'field',




        sqlString   :   '',
        tipodeBusqueda : 'AND',
        type : '',
    };


})(jQuery, window, document);

//VCA sumasGridServer.
if(typeof limpiaBusquedaRapida === 'undefined')
    limpiaBusquedaRapida = function(cleanWhere){
        cleanWhere = typeof(cleanWhere) == 'undefined' ? 'SI' : cleanWhere;
        $.fn.vx_autoBusquedaRapida('cleanAll',cleanWhere);
    };

if(typeof ejecutaBusquedaRapida === 'undefined')
    ejecutaBusquedaRapida = function(){
        $.fn.vx_autoBusquedaRapida('Buscar');
    };
//VCA sumasGridServer.
