<?php
/** @noinspection PhpDefineCanBeReplacedWithConstInspection */
/** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection PhpMissingFieldTypeInspection */
/** @noinspection RegExpRedundantEscape */
/** @noinspection PhpRedundantOptionalArgumentInspection */
/** @noinspection PhpDefineCanBeReplacedWithConstInspection */

/**
 * 2021-02-10 Negativos en color de su moneda.......
 *
 */
use ForceUTF8\Encoding;
use JetBrains\PhpStorm\NoReturn;

require_once("../inc/config.php");
require_once("../inc/Encoding.php");

global $gIAParametros;

error_reporting(0);
error_reporting(E_ALL);
ini_set('display_errors',"1");


if(!empty($_REQUEST['reportNamed'])) {
    require_once("xlsxwriter.class.php");
    switch($_REQUEST['reportNamed']) {
        case 'producto-loading_capacity-precio-precio_estimado-unidad':
            $header = [
              'ARTIUCLO' => 'string',
              'CANTIDAD' => '#,##0.00',
              'PRECIO' => '#,##0.00',
              'PRECIO ESTIMADO BLANQUEADO' => '#,##0.00',
              'PRECIO ESTIMADO TENIDO' => '#,##0.00',
              'Unidades' => 'string',
            ];
            $col_options = [
              'freeze_rows'=>1,
                'widths' => [43, 24, 12, 10, 10, 10, 8],
              'font-style'=>'bold', 'font-size'=>'14','font'=>'Calibri',
            ];
            $style = [];
            $styleRow = [
              ['font-style'=>'light','font-size'=>'18','font'=>'Calibri'],
              ['font-style'=>'normal','font-size'=>'14','font'=>'Calibri'],
              ['font-style'=>'normal','font-size'=>'14','font'=>'Calibri'],
              ['font-style'=>'normal','font-size'=>'14','font'=>'Calibri'],
              ['font-style'=>'normal','font-size'=>'14','font'=>'Calibri'],
              ['font-style'=>'normal','font-size'=>'14','font'=>'Calibri', 'halign' => 'center'],
            ];
            $tabs = [
              'All' =>
                ia_sqlArrayIndx("SELECT pg.producto as 'ARTICULO', pg.container_quantity as 'CANTIDAD', IFNULL(pcb.cost_cif, 0) as 'PRECIO',
                        pg.precio_estimado_usd as 'PRECIO ESTIMADO BLANQUEADO', pg.precio_estimado_usd_tenido as 'PRECIO ESTIMADO TENIDO', u.unidad as 'Unidades'
                    FROM producto_general pg JOIN unidades u ON u.unidades_id = pg.unidades_id
                        LEFT OUTER JOIN producto_costs_bodega pcb ON pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL
                    WHERE para_bodega = 'En Bodega' AND activo='Si'
                    ORDER BY producto"),
              'Kilos' =>
                ia_sqlArrayIndx("SELECT pg.producto as 'ARTICULO', pg.container_quantity as 'CANTIDAD', IFNULL(pcb.cost_cif, 0) as 'PRECIO',
                        pg.precio_estimado_usd as 'PRECIO ESTIMADO BLANQUEADO', pg.precio_estimado_usd_tenido as 'PRECIO ESTIMADO TENIDO', u.unidad as 'Unidades'
                    FROM producto_general pg JOIN unidades u ON u.unidades_id = pg.unidades_id
                        LEFT OUTER JOIN producto_costs_bodega pcb ON pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL
                    WHERE para_bodega = 'En Bodega' AND activo='Si' AND u.unidades_id = 1
                    ORDER BY producto"),
              'Metros' =>
                ia_sqlArrayIndx( "SELECT pg.producto as 'ARTICULO', pg.container_quantity as 'CANTIDAD', IFNULL(pcb.cost_cif, 0) as 'PRECIO',
                        pg.precio_estimado_usd as 'PRECIO ESTIMADO BLANQUEADO', pg.precio_estimado_usd_tenido as 'PRECIO ESTIMADO TENIDO', u.unidad as 'Unidades'
                    FROM producto_general pg JOIN unidades u ON u.unidades_id = pg.unidades_id
                        LEFT OUTER JOIN producto_costs_bodega pcb ON pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL
                    WHERE para_bodega = 'En Bodega' AND activo='Si' AND u.unidades_id <> 1
                    ORDER BY producto"),
            ];

            breaK;
        default: die("Unknown Report");
    }

    $xlsxWriter = new XLSXWriter();
    foreach($tabs as $tabName => $data) {
        $xlsxWriter->writeSheetHeader($tabName, $header, $col_options );
        foreach($data as $d) {
            $xlsxWriter->writeSheetRow($tabName, $d, $styleRow);
        }
    }

    $fileName = "Articulo Cantidad Precio Precio Estimado ".Date('Y m d \\a \\l\\a\\s H i').".xlsx";

    header('Content-Disposition: attachment; filename="'. $fileName .'"');
    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');

    $xlsxWriter->writeToStdOut();

    ia_errores_a_dime(false);
    exit(0);
    die();
}
if(strcasecmp( param('allRows'), 'true') === 0) {
    require_once('excelExportAllRows.php');
    $nada = new ExportAllRows($_REQUEST);
    die();
}
$perfil_solicitado = $_REQUEST['perfil_reporte_grid_id'] ?? null;
if($perfil_solicitado === '91ee6e9fb8b1763c8fa2a4bb6dcfe094' || $perfil_solicitado === '91ee6e9fb8b17acb8fa2a4bb6dcfe094') {
    $exportBuffer = new ExportBuffer();
    $decode = $exportBuffer->decode(json_decode(param("exportBuffer"), true));
    $reporte_vale = $exportBuffer->reporteVale_Datos( $decode );
    $exportBuffer->reporteVale_xlsx($reporte_vale, $decode);
    die();
}

$realTitle = $titulo = '';
$perfil_reporte_grid_id = '';
$perfil_reporte_grid = [];
$xlsxMergedCells = [];
$xlsHeaderRow = [];
global $xlsData; $xlsData=[];
global $xlsxHasMoneda; $xlsxHasMoneda = -1;
require_once("../inc/xlsxWrite.php");
$xlsxWriter = new xlsxWrite();

define('XLSX', '.xlsx');

define('at_colNombre',0);
define('at_Accion',1);
define('at_Label',2);
define('at_Display',3);
define('at_Style',4);
define('at_colNum',5);
define('at_Resultado',6);

define('at_ExtraClasses',7);
define('at_colNombreDif',9); //Diferenciador
define('at_ValDif',10); //Valor Diferenciador, como moneda

define('gb_Totales',1);
define('gb_Value',6);
define('gb_SortType',7);
define('gb_ValueType',8);
define('gb_StartingPos',12);
define('gb_TriggeredLGb',13);
define('gb_FechaTipoAgrupador',11);
//define('gb_LastFila',12);

define('arr_ValuePos',1);
define('arr_StylePos',0);
define('arr_ColorClassesPos',2);
define('arr_CC_ClassPos',0);
define('arr_CC_CondicionPos',1);
define('arr_CC_CampodeComparacion',2);
//trae de pdf
define('arr_CC_CondicionPosEx',3);
define('arr_CC_CampodeComparacionEx',4);

define('arr_colNombre',1);
define('arr_Hidden',3); //08/12

define('edr_colNombre',0);
define('edr_colPos',1);
define('edr_colSpan',2);
define('edr_colVal',3);
define('edr_colCompVal',4);
define('edr_colValFinal',5);


$huboMoneda=false;
$debug = false;
//$debug = true;
if($debug)
    $completaHeaders = 'SI';

// MONEDA 25/OCT
define('at_ResultadoPESOS',7);
define('at_ResultadoUSD',8);

$at_acciones = array('SUM','COUNT','MIN','MAX');
$at_acciones_desc = array('SUMA','CONTEO','MÍNIMO','MÁXIMO');

$exportType = param("exportType");
$fileName = param("fileName");
$html = param("html");
$htmlcss = param("css");

$origen = param("origen");
$hijos = param("hijos");
$campoID = param("campoID");

$completaHeaders = param('completaHeaders');

//$dateTimeFields = ['delivered el','alta db','alta','ultimo cambio','último cambio','delivered'];
//$dateTimeFields = ['delivered el'];
$dateTimeFields = [];

$exceldeRony = false;
$edR = array(   array('Tienda',0),
                array('CASH/NOTA',0)
            );
$edRcs = array( array('Balance',0,"",""),
                array('Fecha',0,"",""),
                array('Withdrawal',0," colspan='2' ","","==0",""),
                array('Deposit',0," colspan='2' ","","==0","")
                );
$edRrs = "";
$edRxtd = "";
$xlsColSpanedRxtd=1;

global $buffer, $css, $totales, $groupby, $exportType,$DoSaldoFileName,$SaldoFileName,$SaldoFechaIni,$SaldoFechaFin;
$SaldoFileName='';$SaldoFechaFin='';

$extraInfo = empty($_REQUEST['extraInfo']) ? [] : json_decode($_REQUEST['extraInfo'], true);
if('XLS' === $exportType) {
    if($perfil_solicitado === 'DeudorTdaChequeTab') {
        require_once("../inc/XLSXWriterClass.php");
        repoorteDeudoresPorTienda_mse('cheque', !empty($extraInfo['conRemarks']));
    }
    if($perfil_solicitado === 'DeudorTdaPagareTab') {
        require_once("../inc/XLSXWriterClass.php");
        repoorteDeudoresPorTienda_mse('pagare', !empty($extraInfo['conRemarks']));
    }
}

if($html == '')
{
    $buffer = param("exportBuffer");
    $buffer = json_decode($buffer);

    // echo "<pre>buffer=".print_r($buffer,true); die('buffersinfo');

    $titulo = param("titulo");

    $totales = param("totales");
    $totales = json_decode($totales);

    // checar el if the arriba que trae die!
    if($perfil_solicitado === '91ee6e9fb8b1763c8fa2a4bb6dcfe094' || $perfil_solicitado === '91ee6e9fb8b17acb8fa2a4bb6dcfe094') { // Vales

        $tmpTCActual = ia_singleread("SELECT tc FROM tc_log ORDER BY alta_db DESC LIMIT 1");
        $tempBufferLen = count($buffer[0]);
        $tempCols = ['Moneda'=>null, 'Debe' => null, 'Tipo Cambio' => null, 'Valor en USD' => null, 'Disponible Pesos' => $tempBufferLen];
        foreach($buffer[0] as $tempI => $tempD)
            if(array_key_exists($tempD[1], $tempCols))
                $tempCols[$tempD[1]] = $tempI;
        $valorUsdCol = $tempCols['Valor en USD'];

        foreach($buffer as $tempI => &$tempD) {
            if($tempI == '0')
                continue;
            $tempMoneda = $tempD[$tempCols['Moneda']][1];
            $tempTC = floatval( str_replace([",", "$"], "", $tempD[$tempCols['Tipo Cambio']][1]) );
            if(strcasecmp($tempMoneda, 'PESOS') === 0) {
                $tempTC = $tmpTCActual;
            } elseif($tempTC < 0.10) {
                $tempTC = $tmpTCActual;
            }
            $tempD[$tempCols['Tipo Cambio']][1]  = $tempTC;
            $tempDebe = str_replace([",", "$"], "", $tempD[$tempCols['Debe']][1]);
            if(strcasecmp($tempMoneda, 'PESOS') == 0) {
                $tempD[$tempBufferLen] = ['', $tempDebe];
                $tempD[$valorUsdCol] = ['',$tempDebe / $tempTC];

            } else {
                $tempD[$tempBufferLen] = ['', $tempDebe * $tempTC];
                $tempD[$valorUsdCol] = ['',$tempDebe];
            }
        }

        $buffer[0][$tempBufferLen] = ['bold txt_color_PESOS txt16px der number', 'Disponible Pesos', '', 1];
        $totales[] = [
            0 => 'Disponible Pesos',
            1 => 'SUM',
            2 => 'Disponible Pesos',
            3 => '1',
            4 => 'currency',
            5 => null,
            6 => null,
            7 => null,
            8 => null,
            9 => '',
            10 => '',
        ];
        unset($tempI, $tempD, $tempBufferLen, $tempCols);
    }


    //VCA 27-JUNIO-2022 totales diferenciados
    if(!empty($totales)) {
        foreach($totales as $k_tot => $v_tot) {

//            echo "<pre>$k_tot: <br />".print_r($v_tot, true)."</pre>";
//            echo "<pre>at_ValDif,".$v_tot[at_ValDif];

            $hay_valdiff_array = false;
            $arr_valdiff = false;
            $str_ori_valdiff = $v_tot[at_ValDif];
            if (str_contains($str_ori_valdiff, '=')) {
                if(!is_array($v_tot[at_ValDif]))
                    $v_tot[at_ValDif] = [];
                $arr_valdiff = explode(";", $str_ori_valdiff);
//                echo "<pre>$k_tot: <br />".print_r($arr_valdiff, true)."</pre>";
                if (!empty($arr_valdiff)) {
                    foreach ($arr_valdiff as $v_vd) {
                        $tmp_vd = explode("=", $v_vd);
                        $v_tot[at_ValDif][$tmp_vd[0]] = $tmp_vd[1] == "SUMA" ? "+" : "-";
                    }
                }
            }
        }
    }


    //print_r($totales);
    //echo json_encode($buffer).'<br><br>';
    $groupby = param("groupby");
    $groupby = json_decode($groupby);
    if($perfil_solicitado === '74867af2fe6090e711e53adf49956c66')
        $groupby = '';
    if($perfil_solicitado === 'DeudorTdaCheque') {
        $totales = [["Cliente","COUNT","#","1","numeric"],["Debe","SUM","Debe",1,"currency"]];
        $groupby = [["Moneda",[
                ["Cliente","COUNT","#","1","numeric"],
                ["Debe","SUM","Deben en Total","1","currency"]
            ],null,null,null,null,null,"ASC",null,null,null,"",null,null,""]];
    }
    if($perfil_solicitado === 'DeudorTdaPagare') {
        $totales = [["Cliente","COUNT","#","1","numeric"],["Saldo Pend","SUM","Saldo Pend",1,"currency"]];
        $groupby = [["Moneda",[
                ["Cliente","COUNT","#","1","numeric"],
                ["Saldo Pend","SUM","Deben en Total","1","currency"]
            ],null,null,null,null,null,"ASC",null,null,null,"",null,null,""]];
    }

    $totalsonly = param("totalsOnly");
    if($totalsonly == 'SI')
        $totalsonly = true;
    else
        $totalsonly = false;

    $datosAdicionales = param("datosAdicionales");
    $datosAdicionales = json_decode($datosAdicionales);


    $css = array("number"=>"background-color:#ffffff; color:#000000; font-weight:bolder; text-align: right;",
             "numeric"=>"background-color:#ffffff; color:#000000; font-weight:bolder; text-align: right;",
             "cash"=>"background-color:#29ff00; color:#052300; font-weight:bolder; text-align: right;",
             "deposit"=>"background-color:#021d93; color:#ffffff; font-weight:bolder; text-align: right;",
             "withdrawal"=>"background-color:#ff8181; color:#000000; font-weight:bolder; text-align: right;",
             "usado"=>"background-color:#1a1a1a; color:#ffffff; font-weight:bolder; text-align: right;",
             "balance"=>"background-color:yellow; color:#0000a2; font-weight:bolder; text-align: right;",
             "netdeposit"=>"background-color:#ffffff; color:#021d93; font-weight:bolder; text-align: right;",
             "ide"=>"background-color:#198d03; color:#000000; font-weight:bolder; text-align: right;",
             "link_vale_LP"=>"background-color:#fcff00; color:#000000; font-weight:bolder; text-align: center;",
             "link_vale_LT"=>"background-color:#ff7e00; color:#492400; font-weight:bolder; text-align: center;",
             "link_vale_Q"=>"background-color:#fc9fab; color:#9f191f; font-weight:bolder; text-align: center;",
             "link_vale_ND"=>"background-color:#540000; color:#ffffff; font-weight:bolder; text-align: center;",
             "link_vale_SBC"=>"background-color:#ff5353; color:#460000; font-weight:bolder; text-align: center;",
             "link_vale_RJ"=>"background-color:#4200af; color:#ffffff; font-weight:bolder; text-align: center;",
             "link_vale_BL"=>"background-color:#005baf; color:#ffffff; font-weight:bolder; text-align: center;",
             "txt_color_red"=>"color:red !important; ",
             "txt18px"=>"font-size:16px !important;",
             "txt17pxbold"=>"font-size:17px !important; font-weight:bolder !important; ",
             "centerd"=>"text-align: center;",
             );

    if($exportType === 'XLS')
    {
        // ya no se aplican ver $xlsxStyleNum y $xlsxHeaderRow
        $css['numeric'] .=  ' mso-number-format:"\#\,\#\#0"'; //"0" //UPDATED
        $css['number'] .=  ' mso-number-format:"\#\,\#\#0.00"'; //"0" //UPDATED
        $css['currency'] =  'mso-number-format:\#\,\#\#0\.00';
        $css['tipo_cambio'] =  'mso-number-format:\#\,\#\#0\.00';
        $css['date'] =  'mso-number-format:dd\/mm\/yy';
        $css['datetime'] =  'mso-number-format:dd\/mm\/yy\ h\:mm\ AM\/PM';
        $css['percent'] =  'mso-number-format:Percent';
    }
    else
    {
        $css['numeric'] .=  ' font-weight:bolder; text-align: right;';
        $css['number'] .=  ' font-weight:bolder; text-align: right;';
        $css['currency'] =  'font-weight:bolder; text-align: right;';
        $css['tipo_cambio'] =  'font-weight:bolder; text-align: right;';
        $css['date'] =  'font-weight:bolder; text-align: center;';
        $css['datetime'] =  'font-weight:bolder; text-align: center;';
        $css['percent'] =  'font-weight:bolder; text-align: right;';
    }
    $fontsize = ($exportType == 'DOC' ? '12px' : '16px');


    $todoAlineadoIzquierda = $perfil_solicitado === 'a0cec8d00965834311eb6b105250df3c';
    if($todoAlineadoIzquierda) {
        $xlsxStyleNum = [
            // 'normal'=>0,
          'normal' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'base' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),

          'string centered' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'string bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'int' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'int bold' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'int bold usd' => $xlsxWriter->xlsStyles->setStyle("#,##0;-#,##0;0;GENERAL", null, '#139312', true, null, null, null, null, null, null, null, 'left', 'center'),

          'numeric' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'numeric bold' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'numeric bold usd' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, '#139312', true, null, null, null, null, null, null, null, 'left', 'center'),

          'number' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'number bold' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'tipo_cambio' => $xlsxWriter->xlsStyles->setStyle("#,##0.000000;[Red]-#,##0.000000;0.000000;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'currency' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'left', 'center'),
          'currency bold' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'left', 'center'),
// date era dd/mm
          'date' => $xlsxWriter->xlsStyles->setStyle('d/mm/yy;GENERAL', null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'datetime' => $xlsxWriter->xlsStyles->setStyle('d/mm/yy h:mm;GENERAL', null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'percent' => $xlsxWriter->xlsStyles->setStyle('0.00%;[Red]-0.00%;', null, null, null, null, null, null, null, null, null, null, 'left', 'center'),


          'string right' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'string right bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'string left' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'string left bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'remarks' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'top'),

          'string total' => $xlsxWriter->xlsStyles->setStyle(0, 18, null, true, null, null, null, null, null, null, null, 'left', 'center', false),
          'currency total' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 18, null, true, null, null, null, null, null, null, null, 'left', 'center', false),
          'int total' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", 18, null, true, null, null, null, null, null, null, null, 'center', 'left', false),

          'usd string total' => $xlsxWriter->xlsStyles->setStyle(0, 18, '#139312', true, null, null, null, null, null, null, null, 'left', 'center', false),
          'usd currency total' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;-#,##0.00;0.00;GENERAL", 18, '#139312', true, null, null, null, null, null, null, null, 'left', 'center', false),
          'usd int total' => $xlsxWriter->xlsStyles->setStyle("#,##0;-#,##0;0;GENERAL", 18, '#139312', true, null, null, null, null, null, null, null, 'center', 'left', false),


        ];

    } else {
        $xlsxStyleNum = [
            // 'normal'=>0,
          'normal' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'center', 'center'),
          'base' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'center', 'center'),

          'string centered' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'center', 'center'),
          'string bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'int' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'int bold' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'int bold usd' => $xlsxWriter->xlsStyles->setStyle("#,##0;-#,##0;0;GENERAL", null, '#139312', true, null, null, null, null, null, null, null, 'center', 'center'),

          'numeric' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'numeric bold' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'numeric bold usd' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", null, '#139312', true, null, null, null, null, null, null, null, 'center', 'center'),

          'number' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'number bold' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'center', 'center'),

          'tipo_cambio' => $xlsxWriter->xlsStyles->setStyle("#,##0.000000;[Red]-#,##0.000000;0.000000;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'currency' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'center', 'center'),
          'currency bold' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 14, null, true, null, null, null, null, null, null, null, 'center', 'center'),
// date era dd/mm
          'date' => $xlsxWriter->xlsStyles->setStyle('d/mm/yy;GENERAL', null, null, null, null, null, null, null, null, null, null, 'center', 'center'),
          'datetime' => $xlsxWriter->xlsStyles->setStyle('d/mm/yy h:mm;GENERAL', null, null, null, null, null, null, null, null, null, null, 'center', 'center'),
          'percent' => $xlsxWriter->xlsStyles->setStyle('0.00%;[Red]-0.00%;', null, null, null, null, null, null, null, null, null, null, 'center', 'center'),


          'string right' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'right', 'center'),
          'string right bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'right', 'center'),

          'string left' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'center'),
          'string left bold' => $xlsxWriter->xlsStyles->setStyle(0, null, null, true, null, null, null, null, null, null, null, 'left', 'center'),

          'remarks' => $xlsxWriter->xlsStyles->setStyle(0, null, null, null, null, null, null, null, null, null, null, 'left', 'top'),

          'string total' => $xlsxWriter->xlsStyles->setStyle(0, 18, null, true, null, null, null, null, null, null, null, 'left', 'center', false),
          'currency total' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;[Red]-#,##0.00;0.00;GENERAL", 18, null, true, null, null, null, null, null, null, null, 'center', 'center', false),
          'int total' => $xlsxWriter->xlsStyles->setStyle("#,##0;[Red]-#,##0;0;GENERAL", 18, null, true, null, null, null, null, null, null, null, 'center', 'center', false),

          'usd string total' => $xlsxWriter->xlsStyles->setStyle(0, 18, '#139312', true, null, null, null, null, null, null, null, 'left', 'center', false),
          'usd currency total' => $xlsxWriter->xlsStyles->setStyle("#,##0.00;-#,##0.00;0.00;GENERAL", 18, '#139312', true, null, null, null, null, null, null, null, 'center', 'center', false),
          'usd int total' => $xlsxWriter->xlsStyles->setStyle("#,##0;-#,##0;0;GENERAL", 18, '#139312', true, null, null, null, null, null, null, null, 'center', 'center', false),


        ];
    }


    $xlsxWriter->xlsStyles->cssAddCssFile(__DIR__ . "/../css2/iastyles.css");
    if($todoAlineadoIzquierda)
        $xlsxWriter->xlsStyles->cssAddString("centerd {text-align:left;}");
    else
        $xlsxWriter->xlsStyles->cssAddString("centerd {text-align:center;}");


    /////Adición de Totales...
    /////Asumimos por completo que la primera fila de valores en el arreglo buffer son los nombres de las columnas.
    $nombresCols = arrayCopy($buffer[0] ?? []);
    $solonombresCols = obtenNombreColumnasReales_mse($nombresCols);//08/12
    //$cuantasCols = count($buffer[0]);
    //$cuantasColssinOcultas = $cuantasCols - cuantasColumnasOcultas_mse($nombresCols);
    $monedaHorizontalIndex = -1;
    foreach($solonombresCols as $index => $named) {
        if(strcasecmp('moneda', $named) === 0 || strcasecmp('moneda_id', $named) === 0) {
            $monedaHorizontalIndex = $index;
            break;
        }
    }

    if($monedaHorizontalIndex>=0) {
        foreach($buffer as $vertical => $d) {
            $tmpMonedaRow = $d[$monedaHorizontalIndex][ $vertical == 0 ? 3 : 1];
            if($tmpMonedaRow == "1") $tmpMonedaRow="MXP";
            if($tmpMonedaRow == "2") $tmpMonedaRow="USD";
            $monedarow[$vertical] = $tmpMonedaRow;

        }
    }


    //PRG
    $perfil_reporte_grid_id = param('perfil_reporte_grid_id');



    if(!empty($perfil_reporte_grid_id))
    {
        $perfil_reporte_grid = ia_singleton("SELECT * FROM perfil_reporte_grid WHERE perfil_reporte_grid_id=".strit($perfil_reporte_grid_id));


        if(!empty($perfil_reporte_grid))
        {
            if($perfil_reporte_grid['perfil'] == 'FICHAS PARA RONY' && $perfil_reporte_grid['grid_id'] == 'iajqgridtodoabanco_mov') {
                $DoSaldoFileName=true;
                $DoSaldoIniDate=null;
            }
            if($perfil_reporte_grid['perfil'] == 'EXCEL DE RONY')
            {
                $exceldeRony = true;
                $edRrs = " rowspan='2' ";
                $edRxtd = "<td style='' colspan='6'>&nbsp;</td>";
                $xlsColSpanedRxtd = 6;
                $realTitle = $titulo;
//                $titulo = '';
            }

            $sqlColsPerfil = "SELECT columna FROM perfil_reporte_grid_col WHERE perfil_reporte_grid_id=".strit($perfil_reporte_grid['perfil_reporte_grid_id'])." ORDER BY orden ";
            $arrColsPerfil = ia_sqlVector($sqlColsPerfil);
            if($arrColsPerfil === false)
                $arrColsPerfil = [];
            if(('DeudorTdaPagare' === $perfil_reporte_grid_id || 'DeudorTdaCheque' === $perfil_reporte_grid_id) && !in_array('Moneda', $arrColsPerfil))
            {
                /** @noinspection PhpAutovivificationOnFalseValuesInspection */
                $arrColsPerfil[] = 'Moneda';
            }
            if(!empty($extraInfo['conRemarks'])
            ) {
                /** @noinspection PhpAutovivificationOnFalseValuesInspection */
                $arrColsPerfil[] = 'Remarks';
            }
            $solonombresColsFlip = array_flip($solonombresCols);
            $arrColsPerfilFlip = array_flip($arrColsPerfil);

            foreach($solonombresCols as $k=>$col)
            {
                if($col == $campoID)
                {
                    $buffer[0][$k][arr_Hidden] = 0;
                    $nombresCols[$k][arr_Hidden] = 0;
                }

                $tmp = isValueonArray($arrColsPerfil,$col);
                if($tmp !== false || $nombresCols[$k][arr_Hidden] == 0)
                {
                    //echo "$tmp <br/>";
                    $arrColsPerfilFlip[$col] = $k;
                }
                else
                {
                    foreach($buffer as $bk=>$br)
                    {
                        foreach($br as $brk => $col)
                            if($brk == $k)
                                unset($buffer[$bk][$brk]);
                    }
                    unset($nombresCols[$k]);
                    unset($solonombresCols[$k]);
                    //echo "borrar $k <br/>";
                }
            }

            $arrColsPerfilFlip = array_keys(array_flip($arrColsPerfilFlip));

            //echo '<pre>'.print_r($arrColsPerfilFlip, true).'</pre>';
            //echo '<pre>'.print_r($buffer, true).'</pre>';

            foreach($buffer as $rn=>$row)
            {
                array_reorder_keys_mse($buffer[$rn],$arrColsPerfilFlip);
                $buffer[$rn] = array_values($buffer[$rn]);
            }

            array_reorder_keys_mse($nombresCols,$arrColsPerfilFlip);
            array_reorder_keys_mse($solonombresCols,$arrColsPerfilFlip);

            $solonombresCols = array_values($solonombresCols);
            $nombresCols = array_values($nombresCols);

/*
movimientos cualquier cta bancaria seleccionar excel de rony
    cada renglon en realidad tiene 2
    en rules viene que cols se juntan

*/
            if($exceldeRony)
            {
                foreach($nombresCols as $k=>$nC)
                {
                    foreach($edR as $kedR=>$vedR) //Las columnas que tienen RowSpan
                        if($nC[arr_colNombre] == $vedR[edr_colNombre])
                           $edR[$kedR][edr_colPos] = $k;

                    foreach($edRcs as $kedRcs=>$vedRcs) //Las columnas que tienen colSpan
                        if($nC[arr_colNombre] == $vedRcs[edr_colNombre])
                           $edRcs[$kedRcs][edr_colPos] = $k;
                }
               $xlsxMergedCells[] = array(0,2,0,3);
               $xlsxMergedCells[] = array(0,4,0,5);
            }


//            echo '<pre>'.print_r($nombresCols, true).'</pre>';
//            echo '<pre>'.print_r($edR, true).'</pre>';
//            echo '<pre>'.print_r($edRcs, true).'</pre>';
//            echo '<pre>'.print_r($solonombresCols, true).'</pre>';
//            echo '<pre>'.print_r($buffer, true).'</pre>';
//             die();
        }
    }

    $cuantasCols = empty($buffer[0])? 0 : count($buffer[0]);
    $cuantasColssinOcultas = $cuantasCols - cuantasColumnasOcultas_mse($nombresCols);

    $td_totales = '';
    $th_totales = '';
    if($totales) {$td_totales = '<td>&nbsp</td>'; $th_totales = '<th>&nbsp</th>';}




//UPDATED
    /** @noinspection HtmlRequiredTitleElement */
    $html = "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\"
xmlns:x=\"urn:schemas-microsoft-com:office:excel\"
xmlns=\"http://www.w3.org/TR/REC-html40\" lang=\"en\">
    <head>
    <meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\" />
    <meta http-equiv=\"Content-Language\" content=\"es-mx\">
    <style type=\"text/css\">
        body
        {margin:0;padding:0;font-size:$fontsize;font-family: \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, Arial, Helvetica, sans-serif;}
        tr
		  {mso-height-source:auto;}
		col
		  {mso-width-source:auto;}
		br
		  {mso-data-placement:same-cell;}
    </style>
    </head>
    <body>
    <table style=\"width: 100%\">
    <caption>-= $titulo =-</caption>";

    if($totales) $totales = calculaTotales_mse($totales, $solonombresCols, $buffer, 1, -1, 'Gran Total:');

//echo "<pre>solonombresCols=".print_r($solonombresCols, true)."</pre>";
//echo "<pre> =$huboMoneda= totales=".print_r($totales, true)."</pre>"; die();
    if($groupby) foreach($groupby as $k=>$v)
    {
        $pos = isValueonArray($solonombresCols, $v[at_colNombre]);

        $groupby[$k][at_colNum] = $pos;
        $groupby[$k][gb_Value] = -1;
        $groupby[$k][gb_ValueType] = trim($nombresCols[$pos][arr_StylePos]);

        if($groupby[$k][gb_Totales] != -1) foreach($groupby[$k][gb_Totales] as $ktot=>$vtot)
        {
            //$groupby[$k][gb_Totales][$ktot] = calculaTotales_mse($groupby[$k][gb_Totales][$ktot], $nombresCols, $buffer, 1, -1, 'Inicializando Gby:');
            $groupby[$k][gb_Totales][$ktot][gb_StartingPos] = 0;
        }
    }

    $html .= "<thead>\r\n";
    //Primera fila, para los nombres, siempre.
    $cfila = 0;
    //for($cfila=0;$cfila<1;$cfila++)
    //{
        $html .= '<tr>'.$th_totales; //Agregamos una celda para la descripción de los totales en línea.
        /**
        //Agregamos unas lineas col. A ver si así arregla el width y el height.
        for($horizontal=0;$horizontal<$cuantasCols;$horizontal++)
        {
            if(stripos($solonombresCols[$horizontal], 'remark') !== false || stripos($solonombresCols[$horizontal], 'comentario') !== false || stripos($solonombresCols[$horizontal], 'referencia') !== false)
                $html .= "<col height=27 width=391 style='mso-width-source:userset;mso-width-alt:14299;width:293pt' >\r\n";
            else
                $html .= "<col height=27 style='mso-width-source:userset;' >\r\n";
        }**/

        for($horizontal=0;$horizontal<$cuantasCols;$horizontal++)
        {
            if($buffer[$cfila][$horizontal][arr_Hidden] == 1)//08/12
            {
                $class = array_reverse(explode(" ", trim($buffer[$cfila][$horizontal][arr_StylePos])));
                $isCurrency=false;
                $style = '';
                $classes = '';
                foreach($class as $cv)
                    foreach($css as $k=>$v)
                    {
                        if($k == $cv) {
                            if($k === 'currency')
                                $isCurrency=true;
                            $style .= $v . ' ';
                            $classes .= " $k";
                        }
                }

                $value = $buffer[$cfila][$horizontal][arr_ValuePos];

                $value = Encoding::toUTF8($value);
                $value = strip_tags( str_replace(">", "> ",$value));

                //$value = html_entity_decode($value);
    			//$value = str_replace("&","&amp;",$value);

                //if($exceldeRony && $edR[1][edr_colPos] == $horizontal) continue; //Aquí quitamos la columna de CASH.

                $txtcolSpan = "";
                if($exceldeRony)
                    $txtcolSpan = $edRcs[$horizontal][edr_colSpan];

                $html .= "<th style='$style' $txtcolSpan >$value</th>\r\n";

                if($_REQUEST['fileName'] === 'ventas_bodegas.xls') {
                    $iPos = stripos($value, '<');
                    if($iPos > 0)
                        $value = substr($value, 0, $iPos);
                }
                $value = str_replace( ['<br>','<br/>','<br />', '<p>', '</p>', '<div>', '</div>'], "\r\n", $value );
                $value = str_ireplace(
                    ['&nbsp;','&gt;','&lt;','&Uacute;','&oacute;','&oacute;'],
                    [' ', '>', '<', 'Ú', 'ó','é'],
                    htmlspecialchars_decode($value, ENT_QUOTES | ENT_HTML5)
                );

                if(strtolower($value)=='moneda' || strtolower($value)=='moneda_id')
                    $xlsxHasMoneda = $horizontal;

                //deduce el tipo de la columna, para poner el estilo y tipo de dato
                if(str_contains(strtolower($value), "cambio")) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['tipo_cambio'],'cellType'=>'tipo_cambio','numFmt'=>'#,##0.000000;[Red]-#,##0.000000;0.000000', 'centered'=>true]; //;;@
                } elseif( esRemarkSimilar($value) ) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['remarks'],'cellType'=>'string','numFmt'=>0];
                } elseif(in_array( strtolower($value), ['original date', 'new date', 'fecha', 'deposit fecha', 'fecha depósito', 'fecha registro'], true) ) {
                    $tmpHeaderLabel = in_array($perfil_solicitado, ['DeudorTdaCheque','DeudorTdaPagare']) ? 'Fecha' : $value;
                    $xlsHeaderRow[] = ['label'=>$tmpHeaderLabel, 'colStyle'=>$xlsxStyleNum['date'],'cellType'=>'date','numFmt'=>'d/mm/y;;@', 'centered'=>true]; //;;@
                } elseif(in_array( strtolower($value), $dateTimeFields, true) ) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['datetime'],'cellType'=>'datetime','numFmt'=>'d/mm/y h:mm;;@', 'centered'=>true]; //;;@
                } elseif( $perfil_solicitado === 'DeudorTdaPagare' && $value==='Saldo Pend') {

                    $xlsHeaderRow[] = ['label'=>'Debe',  'colStyle'=>$xlsxStyleNum['currency'],'cellType'=>'currency','numFmt'=>"#,##0.00;[Red]-#,##0.00;0.00", 'centered'=>true];
                } elseif(strpos($value,'%')) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['percent'],'cellType'=>'percent','numFmt'=>"0.00%;[Red]-0.00%;", 'centered'=>true];
                } elseif($isCurrency) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['currency'],'cellType'=>'currency','numFmt'=>"#,##0.00;[Red]-#,##0.00;0.00", 'centered'=>true];
                    if($exceldeRony && $horizontal>1) {
                        $xlsHeaderRow[] = ['label' => $value, 'colStyle' => $xlsxStyleNum['number'], 'cellType' => 'numeric', 'numFmt' => "#,##0.00;[Red]-#,##0.00;0.00", 'centered' => true];
                    }
                } elseif( str_contains($style, "#") && str_contains($style, ".")) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['number'],'cellType'=>'numeric','numFmt'=>"#,##0.00;-#,##0.00;0.00", 'centered'=>true];
                    if($exceldeRony && $horizontal>1)
                        $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['number'],'cellType'=>'numeric','numFmt'=>"#,##0.00;-#,##0.00;0.00", 'centered'=>true];
                } elseif(str_contains($style, "#")) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['int'],'cellType'=>'numeric','numFmt'=>"#,##0;[Red]-#,##0;0", 'centered'=>true];

                } elseif(str_contains($style, "dd\\/m")) {
                    if(strpos($style, ':') > 8 || $value === 'Alta Db' || $value === 'Último Cambio') { // 17 por el mso-numbe... strpos($style,':') > 1 ||
                        $xlsHeaderRow[] = ['label' => $value, 'colStyle' => $xlsxStyleNum['string centered'], 'cellType' => 'string', 'numFmt' => 0, 'centered' => true]; //  yyyy-mm-dd h:mm;GENERAL
                    } else {
                        $xlsHeaderRow[] = ['label' => $value, 'colStyle' => $xlsxStyleNum['date'], 'cellType' => 'date', 'numFmt' => 'd/mm/y;;@', 'centered' => true]; //;;@
                    }
                }elseif(array_key_exists( strtolower($value), ['withdrawal'=>1, 'withdrawals' => 1 ,'monto'=>1, 'debe'=>1, 'saldo' => 1]  )) {
                    $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['currency'],'cellType'=>'currency','numFmt'=>"#,##0.00;[Red]-#,##0.00;0.00", 'centered'=>true];
                } else {
                    // centra estas columnas
                    if( array_key_exists( strtolower($value) ,array_flip(array(
                            'tienda',
                            'cuentat','cuenta t','cuenta t origen',
                            'paid','atrasado',	'super atrasado',	'pending', 'modificado',	'aviso',
                            'delivered', 'delivered directo','delivered to','accepted',
                            'link por',
                            'banco','estado','autorizado','moneda','status','tipo venta',
                            'alta por','último cambio por','¿iva incluido?','empresa',
                            'error',"capturado","terminado",'estado','bloqueado','warning','cancelado','pagado',
                            'tipo mov','cash/nota','importado por','origen',

                    ))) ){
                        // centrar estas
                        $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['string centered'],'cellType'=>'string','numFmt'=>0, 'centered'=>true];
                    } else {
                        $xlsHeaderRow[] = ['label'=>$value, 'colStyle'=>$xlsxStyleNum['base'],'cellType'=>'string','numFmt'=>0, 'centered'=>true];
                    }
                }

            }
        }
        $html .= "$edRxtd</tr>\r\n";

    //}

    $html .= "</thead>\r\n<tbody>\r\n";


    $html .= lineaSeparadora_mse($cuantasColssinOcultas, true, 1, $exportType === 'DOC');
    //Ordenamiento del array y quitamos la primera fila con los títulos.
    unset($buffer[0]);
    if($groupby) usort($buffer,'ordenaArray_mse');
    $lastgroupbyfila=0;

    /**
    //echo '<pre>'.print_r($groupby,true).'</pre>';
    //echo '<pre>'.print_r($nombresCols,true).'</pre>';
    //echo '<pre>'.print_r($totales,true).'</pre>';
    //echo '<pre>'.print_r($buffer,true).'</pre>';
    //*/
        $curRow=1;
        $iniGroupBy=1;
        $lastGroupBy=0;
        $xlsxVerticalRow=-1;
        $vertical = 0;
        if(is_array($buffer))
        foreach($buffer as $vertical=>$wev)
        {
            $hubogroupby = false;
            $hubogroupbydemayorprioridad = false;
            $groupby_html = '';
            $tr_html = "<tr>$td_totales\r\n";
            $xlsxDataRow= [];
            $xlsxVerticalRow+=2;
            $curRow++;


            $tmpMonedaDisplay='';
            $edR_td_html = "";
            $xlsxMonedaClass="";
            if($xlsxHasMoneda>=0 && isset($wev[$xlsxHasMoneda][arr_ValuePos])) {
                $tmpMoneda = strtolower( $wev[$xlsxHasMoneda][arr_ValuePos] ??  '');
                $tmpMonedaDisplay =  strcasecmp($tmpMoneda, 'usd') === 0 || $tmpMoneda==2 ? 'USD' : 'MXP';
                if($tmpMonedaDisplay === 'USD')
                    $xlsxMonedaClass="grid_usd";
            } elseif(isset($monedarow[$vertical]) && $monedarow[$vertical] === 'USD') {
                $xlsxMonedaClass="grid_usd";
            }



            for($horizontal=0;$horizontal<$cuantasCols;$horizontal++)
            {
                $cmpvalue = $value = $wev[$horizontal][arr_ValuePos];

                if(!empty($groupby) && is_array($groupby))
                foreach($groupby as $kgby => $vgby)
                {
                    $hubogroupbydemayorprioridad = false;
                    if($horizontal == $vgby[at_colNum] && !$hubogroupby) //En esta columna hay un groupby. Falta revisar que sí hay un break.
                    {
                        //Aquí hay que hacer una revisión en putiza para saber si más groupby de mayor prioridad.
                        //Si los hay y con cambio, entonces, debemos ignorar éste.
                        if($kgby > 0) //estamos en Groupby de prioridad menor a la principal.
                        {
                            for($prigby=0;$prigby<$kgby;$prigby++)
                            {
                                $tmpprivalue = $wev[$groupby[$prigby][at_colNum]][arr_ValuePos];
                                $tmpprivalue = formateaValorSegunTipoAgrupador_mse($groupby[$prigby][gb_FechaTipoAgrupador], $tmpprivalue);
                                if($groupby[$prigby][gb_Value] != $tmpprivalue && $vertical > 0)
                                {
                                    $hubogroupbydemayorprioridad = true;
                                    break;
                                }
                            }
                        }

                        if(!$hubogroupbydemayorprioridad)
                        {
                            $cmpvalue = formateaValorSegunTipoAgrupador_mse($vgby[gb_FechaTipoAgrupador], $cmpvalue);

                            if($vgby[gb_Value] != $cmpvalue && $vertical > 0)//Quiere decir que ya cambió, y debemos separar.
                            {

                                $vgby[gb_Value] = $cmpvalue;
                                $hubogroupby = true; //Sí hubo un GroupBy.


                                if($vgby[gb_Totales] != -1 && $vgby[gb_Totales] != null && $vgby[gb_Totales] != '' && sizeof($vgby[gb_Totales]) > 0)
                                {
                                    $groupby_html .= lineaSeparadora_mse($cuantasColssinOcultas, true, 1, $exportType === 'DOC', true);
                                    if($totales && !$totalsonly) {
                                        $xlsData[] = array('');
                                    }
                                    //Revisamos si hay más GroupBys de menor jerarquía. Si los hay, los ejecutamos de menor a mayor.
                                    for($x=sizeof($groupby)-1;$x>=$kgby;$x--)
                                    {
                                        if($groupby[$x][gb_Totales] != -1 && $groupby[$x][gb_Totales] != null && $groupby[$x][gb_Totales] != '' && sizeof($groupby[$x][gb_Totales]) > 0)
                                        {

                                            $groupby[$x][gb_Totales] = calculaTotales_mse($groupby[$x][gb_Totales], $solonombresCols, $buffer, $groupby[$x][gb_Totales][0][gb_StartingPos], $vertical, 'SubTotal: '.$groupby[$x][at_colNombre], false);
                                            foreach($groupby[$x][gb_Totales] as $ktot=>$vtot)
                                            {
                                                $groupby[$x][gb_Totales][$ktot][gb_StartingPos] = $vertical;
                                            }
                                            //Debemos generar una cadena que contenga todos los agrupadores, del que disparó y hacia abajo.
                                            //Del estilo: Fecha: 23-02-2012, Estado: ND, Comisión: 0.00.
                                            //Nos aventamos en putiza un for para recorrer el array $groupby de aquí para abajo.
                                            $nombreLineaSubtotal=''; // ' -= SUBTOTAL =-';
                                            for($cgby=0;$cgby<=$x;$cgby++)
                                            {
                                                if($groupby[$cgby][at_colNum] == $horizontal) {
                                                    $nombreLineaSubtotal .= '<em><b>'. $groupby[$cgby][at_colNombre] .'</b>: <b>'. quitaLineasNuevasHTML_mse(formateaValorSegunTipoAgrupador_mse($groupby[$cgby][gb_FechaTipoAgrupador], $buffer[$vertical-1][$groupby[$cgby][at_colNum]][arr_ValuePos])) .'</b></em>,';
                                                    $xlsTmpBold = true;
                                                } else {
                                                    $nombreLineaSubtotal .= ' *** '. $groupby[$cgby][at_colNombre] .': '. quitaLineasNuevasHTML_mse(formateaValorSegunTipoAgrupador_mse($groupby[$cgby][gb_FechaTipoAgrupador], $buffer[$vertical-1][$groupby[$cgby][at_colNum]][arr_ValuePos], true)) .',';
                                                    $xlsTmpBold = false;
                                                }
                                            }
                                            $nombreLineaSubtotal = substr_replace($nombreLineaSubtotal ,"",-1);

                                            //$groupby_html .= lineaSeparadora_mse($cuantasCols, true, 1, true);
                                            $groupby_html .= '<tr><td colspan="'.($totales?$cuantasColssinOcultas+1:$cuantasColssinOcultas).'">' .$nombreLineaSubtotal. "</td></tr>\r\n";

                                          //2020-07-21 ya no sacar este letrero  $xlsData[] = array(array('value'=>strip_tags($nombreLineaSubtotal.""), 'colStyle'=>$xlsxStyleNum['string bold'],'cellType'=>'string'));

                                            $groupby_html .= totalesenLinea_mse($at_acciones, $cuantasCols, $groupby[$x][gb_Totales]);

                                            //Actualizo el valor actual
                                            $groupby[$x][gb_Value] = formateaValorSegunTipoAgrupador_mse($groupby[$x][gb_FechaTipoAgrupador], $buffer[$vertical][$groupby[$x][at_colNum]][arr_ValuePos]);
                                        }
                                    }
                                    $lastgroupbyfila = $vertical;
                                }

                                for($x=sizeof($groupby)-1;$x>$kgby;$x--) {
                                    if(isset($buffer[$vertical+1][$groupby[$x][at_colNum]][arr_ValuePos])) { //FIXTOTALS
                                        $groupby[$x][gb_Value] = formateaValorSegunTipoAgrupador_mse(
                                            $groupby[$x][gb_FechaTipoAgrupador],
                                            $buffer[$vertical+1][$groupby[$x][at_colNum]][arr_ValuePos]
                                        );
                                    }
                                }

                                //Solución: Establecer un tipo de prioridad en los groupbys para que no se dispare uno de menor prioridad.
                                //echo '<pre>'.print_r($groupby).'</pre>';
                                if(!$exceldeRony) {
                                    $groupby_html .= lineaSeparadora_mse($cuantasColssinOcultas, false, 1, $exportType === 'DOC');
                                    if($totales && !$totalsonly) {
                                        $xlsData[] = array('');
                                    }
                                }
                                $cfila = $vertical;

                            }
                        }
                        if($vertical == 0)
                        {
                            $vgby[gb_Value] = $cmpvalue;
                        }
                    }
                }

                //Aquí metemos un código para calcular si lleva clase de color o no. Si la lleva, entonces la metemos en
                //$buffer[$vertical][$horizontal][arr_StylePos] y así no modificamos tanto código.
                //////////////////////////////////////////////////////////////////////////////////
                //echo '<pre>'.print_r($nombresCols[$horizontal][arr_ColorClassesPos],true).'</pre>';
                if(is_array($nombresCols[$horizontal][arr_ColorClassesPos]))
                    foreach($nombresCols[$horizontal][arr_ColorClassesPos] as $cck=>$ccv)
                    {
                        $cc_clase = $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_ClassPos];
                        $cc_cond = $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CondicionPos];

                        $cc_cond_ex = array_key_exists(arr_CC_CondicionPosEx, $nombresCols[$horizontal][arr_ColorClassesPos][$cck]) ? $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CondicionPosEx] : '';

                        //if(!array_key_exists(arr_CC_CampodeComparacion,$nombresCols[$horizontal][arr_ColorClassesPos][$cck]))
                            //$nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacion] = $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_ClassPos];

                        if($nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacion])
                        {
                            $cmp_field_pos = isValueonArray($solonombresCols, $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacion]);
                            //echo $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacion] . "<br/>";
                            $tmpvalue = $buffer[$vertical][$cmp_field_pos][arr_ValuePos];
                        }
                        else
                            $tmpvalue = $value;


                        if(array_key_exists(arr_CC_CampodeComparacionEx, $nombresCols[$horizontal][arr_ColorClassesPos][$cck]))
                        {
                            $cmp_field_pos = isValueonArray($solonombresCols, $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacionEx]);
                            //echo $nombresCols[$horizontal][arr_ColorClassesPos][$cck][arr_CC_CampodeComparacion] . "<br/>";
                            $tmpvalue_ex = $buffer[$vertical][$cmp_field_pos][arr_ValuePos];
                        }
                        else
                            $tmpvalue_ex = '';

                        if(strlen($cc_cond_ex) && strlen($tmpvalue_ex))
                            $cc_cond_ex = " && $tmpvalue_ex$cc_cond_ex";

                        $er = false;
                        if( !($nombresCols[$horizontal][arr_StylePos] == 'currency' ||
                            $nombresCols[$horizontal][arr_StylePos] == 'numeric' ||
                            $nombresCols[$horizontal][arr_StylePos] == 'boolean' ||
                            $nombresCols[$horizontal][arr_StylePos] == 'number')
                        )
                            $tmpvalue = "\"$tmpvalue\"";

                        $doEE = strip_tags($tmpvalue.$cc_cond.$cc_cond_ex);

                        if(strlen($doEE))
                        {
                            $ee = "\$er = ($doEE)? true:false;";
                            eval($ee);
                        }
                        //echo $no
                        //echo $nombresCols[$horizontal][arr_StylePos].'<br>'.$ee.'<br>';
                        $buffer[$vertical][$horizontal][arr_StylePos] .= ($er)? ' '.$cc_clase:'';
                    }

                //////////////////////////////////////////////////////////////////////////////////


                $xlsxBaseHeaderRow = $xlsHeaderRow[$horizontal] ?? array('colStyle' => $xlsxStyleNum['base'], 'numFmt' => 0, 'cellType' => 'string');
                $classPDF=trim($buffer[$vertical][$horizontal][arr_StylePos]." ".$xlsxMonedaClass);
                $xlsxCellStyleId = $xlsxStyleNum['base'];

                if(!empty($classPDF)) {
                    $tmpCentered = isset($xlsxBaseHeaderRow['centered']) ? ' centerd' : '';
                    $xlsxCellStyleId = $xlsxWriter->xlsStyles->classToStyle( $classPDF.$tmpCentered, $xlsxBaseHeaderRow['numFmt']);
                } else {
                    $xlsxCellStyleId = $xlsxBaseHeaderRow['colStyle'];
                }

                if(!empty($xlsHeaderRow[$horizontal]['label']))
                if( esRemarkSimilar($xlsHeaderRow[$horizontal]['label'])) {

                    $xlsxCellStyleId = $xlsxStyleNum['remarks'];

                }

                //echo $buffer[$vertical][$horizontal][arr_StylePos].'<br>';
                $class = array_reverse(explode(" ", trim($buffer[$vertical][$horizontal][arr_StylePos])));
                $xlsxClasses = '';
                $style = '';
                foreach($class as $cv)
                    foreach($css as $k=>$v)
                    {
                        if($k == $cv) {
                            $style .= $v . ' ';
                            $xlsxClasses.= " $k";
                        }
                    }

                //
                $array_style = trim($nombresCols[$horizontal][arr_StylePos]);
                $array_style = explode(" ", $array_style);
                foreach($array_style as $tmpcs) {
                    $style .= " " . (array_key_exists($tmpcs,$css) ? $css[$tmpcs] : '');
                }

                $style=trim($style);

                if($exportType === 'DOC')
                {
                    if(str_contains(trim($nombresCols[$horizontal][arr_StylePos]), 'currency'))
                        $value = is_numeric($value) ? number_format(floatval($value), 2, '.', ',') : $value;
                    if(str_contains(trim($nombresCols[$horizontal][arr_StylePos]), 'numeric'))
                        $value = is_numeric($value) ? number_format(floatval($value), 0, '.', ',') : $value;
                }
                if($nombresCols[$horizontal][arr_Hidden] == 1)//08/12
                {
                    //Modificacion 21-11-2013
                    $width = '';
                    if( esRemarkSimilar($solonombresCols[$horizontal]))
                    {
                        //$style .= " width:300pt; ";
                        //$width = " width=420 ";
                        $value = strip_tags($value,'<br>');
                        if(strlen($value)>$gIAParametros['numero_caracteres_remarks_pdf'])
                            $value=substr($value, 0, $gIAParametros['numero_caracteres_remarks_pdf'])."...";

                        if(stripos($solonombresCols[$horizontal], 'referencia') !== false)
                            $value = wordwrap($value, 40, "<br />");
                        else
                            $value = nl2br($value);
                    }

                    $style = trim($style);

                    if($exceldeRony)
                    {

                        $txtcolSpan = $edRcs[$horizontal][edr_colSpan];

                        if(strlen($edRcs[$horizontal][edr_colVal]))
                            $value = $edRcs[$horizontal][edr_colVal];

                        $edR_td_html = "<tr><td>&nbsp;</td>\r\n</tr>";

                        if(array_key_exists(edr_colCompVal,$edRcs[$horizontal]))
                        {
                            $ecomp = $edRcs[$horizontal][edr_colCompVal];
                            $evalf = $edRcs[$horizontal][edr_colValFinal];
                            $ee = "\$value = (\$value $ecomp)? \$evalf:\$value;";
                            eval($ee);
                        }

                        $tr_html .= "<td $width style='$style' $edRrs $txtcolSpan>$value</td>\r\n";
                            $xlsxTmpRow = array(
                              'value' => strip_tags( str_replace(array("<br>","<br />",". ","\r\n"),array("\r","\r",".\r","\r"),  $value) ),
                              'colStyle'=>$xlsxCellStyleId,
                              'cellType'=>$xlsxBaseHeaderRow['cellType'],
                              'wrap_text'=> true,
                            );

                            $xlsxDataRow[] = $xlsxTmpRow;

                            if($horizontal===2 || $horizontal===3)  {
                                $xlsxMergedCells[] = array(
                                    $xlsxVerticalRow, $horizontal+($horizontal===3 ? 1 : 0),
                                    $xlsxVerticalRow+1, $horizontal+($horizontal===3 ? 2 : 1)
                                );
                                $xlsxDataRow[] = '';
                            }  else {
                                $xlsxMergedCells[] = array(
                                    $xlsxVerticalRow, $horizontal,
                                    $xlsxVerticalRow+1, $horizontal
                                );
                            }
                    }
                    else {
                        $tr_html .= "<td $width style='$style'>$value</td>\r\n";
                        if(isset($DoSaldoFileName) && sizeof($xlsxDataRow)==1) {
                            if(empty($SaldoFechaIni))
                                $SaldoFechaIni = $value;
                            if($value > $SaldoFechaFin)
                                $SaldoFechaFin = $value;
                        }


                        $value = str_replace(["<",">","\n"], [" <", "> ", "\n "], $value);
                        $value = str_replace( ['<br>','<br/>','<br />', '<p>', '</p>', '<div>', '</div>'], " \r\n", $value );
                        $value = str_ireplace(
                            ['&nbsp;','&gt;','&lt;','&Uacute;', '&oacute;'],
                            [' ', '>', '<', 'Ú', 'ó'],
                            htmlspecialchars_decode($value, ENT_QUOTES | ENT_HTML5)
                        );


                        $xlsxDataRow[] = array(
                          'value' => strip_tags( str_replace(array("<br>","<br />",". ","\r\n"),array("\r","\r",".\r","\r"),  $value) ) ,
                          'colStyle'=>$xlsxCellStyleId,
                          'cellType'=>$xlsxBaseHeaderRow['cellType'],
                          'wrap_text'=> true,
                        );

                        // Para los reportes de deudores pon la moneda solo en excepcione: es cheques usd o
                        if($xlsxHasMoneda < 0 && $horizontal == 2 && $perfil_solicitado === 'DeudorTdaCheque' && isset($monedarow[$vertical]) && $monedarow[$vertical] === 'USD')
                            {$xlsxDataRow[] = 'USD';}
                        elseif($xlsxHasMoneda < 0 && $horizontal == 2 && $perfil_solicitado === 'DeudorTdaPagare' && isset($monedarow[$vertical]) && $monedarow[$vertical] !== 'USD')
                            {$xlsxDataRow[] = 'PESOS';}
                    }
                }
            }

            $tr_html .= "$edRxtd</tr>$edR_td_html\r\n";


            if($totalsonly === true && $totales) {
                $tr_html = $groupby_html = '';
            } else {
                $xlsData[] = $xlsxDataRow;
                if($exceldeRony)
                    $xlsData[] = array('','','','','','');
            }

            if($hubogroupby === true) { //UPDATED

                $html .= $groupby_html . $tr_html;
            } else
            {
                if($hijos != 'NO')
                {
                    //////////////////////////////////////////////////////////////
                    //////////////////////////////////////////////////////////////
                    $posCampoID = isValueonArray($solonombresCols, $campoID);
                    $hijoID = $buffer[$vertical][$posCampoID][arr_ValuePos];

                    //echo "<pre>".print_r($solonombresCols,true)."</pre>";
                    //echo "<li>campoID: $campoID";
                    //echo "<li>hijoID: $hijoID";
                    $tr_html .= obtenInfoHijo_mse($origen,$hijoID,($totales?$cuantasColssinOcultas+1:$cuantasColssinOcultas));
                }
                $html .= $tr_html;
            }



        }

        //El ultimo groupby
        $vertical++;
        $groupby_html = '';
        $hubogroupby = false;
        if(!empty($groupby) && is_array($groupby))
        for($horizontal=0;$horizontal<$cuantasCols;$horizontal++)
        foreach($groupby as $kgby => $vgby)
        {
            if($horizontal == $vgby[at_colNum] && !$hubogroupby)
            {
                $hubogroupby = true;
                //Debemos separar todos los valores de arriba, para lo cual generamos una fila nueva, y al final de la iteracion horizontal agregamos la fila que se estaba haciendo.
                if($vgby[gb_Totales] != -1 && $vgby[gb_Totales] != null && $vgby[gb_Totales] != '' && sizeof($vgby[gb_Totales]) > 0)
                {
                    $groupby_html .= lineaSeparadora_mse($cuantasColssinOcultas, true, 1, true, true);
                    if($totales && !$totalsonly) {
                        $xlsData[] = array('');
                    }
                    $vgby[gb_Totales] = calculaTotales_mse($vgby[gb_Totales], $solonombresCols, $buffer, $lastgroupbyfila, $vertical, 'SubTotal: '.$vgby[at_colNombre], false);

                    //Debemos generar una cadena que contenga todos los agrupadores, del que disparó y hacia abajo.
                    //Del estilo: Fecha: 23-02-2012, Estado: ND, Comisión: 0.00.
                    //Nos aventamos en putiza un for para recorrer el array $groupby de aquí para abajo.
                    $nombreLineaSubtotal= ''; //' -= SUBTOTAL =-';
                    for($cgby=0;$cgby<sizeof($groupby);$cgby++)
                    {
                        if($groupby[$cgby][at_colNum] == $horizontal)
                            $nombreLineaSubtotal .= ' <b>'. $groupby[$cgby][at_colNombre] .'</b>: <b>'. quitaLineasNuevasHTML_mse(formateaValorSegunTipoAgrupador_mse($groupby[$cgby][gb_FechaTipoAgrupador], $buffer[$vertical-1][$groupby[$cgby][at_colNum]][arr_ValuePos])) .'</b>,';
                        else
                            $nombreLineaSubtotal .= ' '. $groupby[$cgby][at_colNombre] .': '. quitaLineasNuevasHTML_mse(formateaValorSegunTipoAgrupador_mse($groupby[$cgby][gb_FechaTipoAgrupador], $buffer[$vertical-1][$groupby[$cgby][at_colNum]][arr_ValuePos], true)) .',';
                    }
                    $nombreLineaSubtotal = substr_replace($nombreLineaSubtotal ,"",-1);
                    $groupby_html .= '<tr><td colspan="'.($totales?$cuantasColssinOcultas+1:$cuantasColssinOcultas).'">' .$nombreLineaSubtotal. '</td></tr>';

                    //2020-07-21 ya no sacar este letrero $xlsData[] = [['value'=>strip_tags($nombreLineaSubtotal), 'colStyle'=>$xlsxStyleNum['string left bold'],'cellType'=>'string']];
                    $groupby_html .= totalesenLinea_mse($at_acciones, $cuantasCols, $vgby[gb_Totales]);
                            //Actualizo el valor actual

                }
                $lastgroupbyfila = $vertical;
            }
        }

        $groupby_html .= lineaSeparadora_mse($cuantasCols, false, 1, $exportType === 'DOC', false);
        if($totalsonly === true && $totales)
                $tr_html = $groupby_html = '';
        $html .= $groupby_html;


    //Para la linea que separa

    $html .= lineaSeparadora_mse($cuantasColssinOcultas, false, 1, $exportType === 'DOC');
    if($totales && !$totalsonly) {
        $xlsData[] = array('');
    }
    $html .= totalesenLinea_mse($at_acciones, $cuantasCols, $totales);

    $html .= "</tbody></table>\r\n";


    //print_r($totales);
    if($huboMoneda === false) {
        if($totales)
        {
            $html .= '<table style="width: 100%">' . lineaSeparadora_mse($cuantasColssinOcultas, false, 2, $exportType === 'DOC') . "</table>\r\n";
            $html .= "<table id=\"totales\" style=\"width: 50%\">\r\n";
            $html .= "<thead><tr><td colspan='$cuantasCols'><b>-= Totales =-</b></td></tr></thead>\r\n";
            $html .= "<tbody><tr><td>&nbsp;</td></tr>\r\n";

           // $xlsData[] = array('');
           // $xlsData[] = array(array('value'=>'Totales!', 'colStyle'=>$xlsxStyleNum['string left bold'],'cellType'=>'string') );

            foreach($totales as $k=>$v)
            {
                $TituloTotal ='';
                $html .= '<tr>';
                if($v[at_colNum] !== false && ($v[at_Display] == 1 || $v[at_Display] == 2))
                {
                    //$arr_total = generaArraydeunaColumna($buffer, $v[at_colNum], 1);
                    if($v[at_Label] == '' || $v[at_Label] == null)
                        $TituloTotal = $v[at_Accion]. '     de ' . $v[at_colNombre] .'s';
                    else
                        $TituloTotal = $v[at_Label];

                    $xlsxTmpStyle='string';
                    if(str_contains($v[at_Style], 'currency'))
                        $xlsxTmpStyle='currency';
                    if(str_contains($v[at_Style], 'numeric'))
                        $xlsxTmpStyle='int';

                    if(isset($DoSaldoFileName) && $TituloTotal==='SUMA APLICADO' && is_numeric($v[at_Resultado])) {
                        $SaldoFileName = number_format(floatval($v[at_Resultado]),2,'.',','). " ".$SaldoFileName;
                    }

                    $xlsData[]=array(
                        array('value'=>$TituloTotal, 'colStyle'=>$xlsxStyleNum['string total'],'cellType'=>'string'),
                        "","",
                        array('value'=>$v[at_Resultado], 'colStyle'=>$xlsxStyleNum[$xlsxTmpStyle.' total'],'cellType'=>'numeric'),
                    );

                    if(str_contains($v[at_Style], 'currency')) $v[at_Resultado] = number_format( floatval($v[at_Resultado]), 2, '.', ',');
                    if(str_contains($v[at_Style], 'numeric')) $v[at_Resultado] = number_format( floatval($v[at_Resultado]), 0, '.', ',');

                    //$colsRestantes = $cuantasCols - 3;
                    $html .= "<td colspan='3'><b>$TituloTotal</b>:</td><td colspan='3'><b>". $v[at_Resultado] ."</b></td>\r\n";

                }
                $html .= '</tr>';
            }
            $html .= "</tbody></table>\r\n";
        }
    } else {
            $html .= '<table id="totales" style="width: 80%; page-break-inside:avoid;">';
            $html .= "<thead><tr><td colspan='2' class='bold txt_color_PESOS txt_centered'>-== Totales PESOS ==-</td><td style='width: 20px;'>&nbsp;</td><td colspan='2' class='bold txt_color_USD txt_centered'>-== Totales USD ==-</td></tr></thead>";
            $html .= "<tbody><tr><td colspan='2'><hr/></td><td style='width: 20px;'>&nbsp;</td><td colspan='2'><hr/></td></tr>";

            $totalesFontSize = 14;
            $pesosString = $xlsxWriter->xlsStyles->classToStyle('bold txt_color_PESOS', '@', $totalesFontSize);
            $usdString = $xlsxWriter->xlsStyles->classToStyle('bold txt_color_USD', '@', $totalesFontSize);

            $pesosInt = $xlsxWriter->xlsStyles->classToStyle('bold txt_color_PESOS', '#,##0;[Red]-#,##0;0', $totalesFontSize);
            $usdInt = $xlsxWriter->xlsStyles->classToStyle('bold txt_color_USD', '#,##0;[Red]-#,##0;0', $totalesFontSize);

            $pesosNum = $xlsxWriter->xlsStyles->classToStyle('currency bold txt_color_PESOS', '#,##0.00;[Red]-#,##0.00;0.00', $totalesFontSize);
            $usdNum = $xlsxWriter->xlsStyles->classToStyle('currency bold txt_color_USD', '#,##0.00;-#,##0.00;0.00', $totalesFontSize);

            $xlsxPesos = [];
            $xlsxUsd = [];
            foreach($totales as $k=>$v)
            {
                $TituloTotal ='';
                $html .= '<tr>';
                if($v[at_colNum] !== false && ($v[at_Display] == 1 || $v[at_Display] == 2))
                {

                    if($v[at_Label] == '' || $v[at_Label] == null)
                        $TituloTotal = $v[at_Accion]. '     de ' . $v[at_colNombre] .'s';
                    else
                        $TituloTotal = $v[at_Label];

                        if(!isset($v[at_ResultadoPESOS]) && !isset($v[at_ResultadoUSD])) continue;
                        if(!isset($v[at_ResultadoPESOS])) $v[at_ResultadoPESOS] = '';
                        if(!isset($v[at_ResultadoUSD])) $v[at_ResultadoUSD] = '';

                        if(str_contains($v[at_Style], 'currency'))
                            $v[at_ResultadoPESOS] = number_format(floatval($v[at_ResultadoPESOS]), 2, '.', ',');
                        if(str_contains($v[at_Style], 'numeric')) $v[at_ResultadoPESOS] = number_format(floatval($v[at_ResultadoPESOS]), 0, '.', ',');
                        if(str_contains($v[at_Style], 'currency')) $v[at_ResultadoUSD] = number_format(floatval($v[at_ResultadoUSD]), 2, '.', ',');
                        if(str_contains($v[at_Style], 'numeric')) $v[at_ResultadoUSD] = number_format(floatval($v[at_ResultadoUSD]), 0, '.', ',');

                        $exClass = '';
                        if(array_key_exists(at_ExtraClasses, $v))
                            $exClass = $v[at_ExtraClasses];

                        $exClassPESOS = " class='$exClass txt_color_PESOS' ";
                        $exClassUSD = " class='$exClass txt_color_USD' ";

                        $html .= "<td $exClass ><b>$TituloTotal</b>:</td><td $exClassPESOS style='text-align:right;'><b>". $v[at_ResultadoPESOS] ."</b></td><td style='width: 20px;'>&nbsp;</td>";
                        $html .= "<td $exClass ><b>$TituloTotal</b>:</td><td $exClassUSD style='text-align:right;'><b>". $v[at_ResultadoUSD] ."</b></td>";

                        $xlsxTmpStyle='string';
                        if(str_contains($v[at_Style], 'currency'))
                            $xlsxTmpStyle='currency';
                        if(str_contains($v[at_Style], 'numeric'))
                            $xlsxTmpStyle='int';

                        $pesosTotal = empty($v[at_ResultadoPESOS])  ? 0 : $v[at_ResultadoPESOS];
                        if($pesosTotal != 0) {
                          $xlsxPesos[] = [
                          //  ['value' => empty($xlsxPesos) ? 'Total' : '', 'colStyle'=>$pesosString, 'cellType'=>'string' ],
                            ['value' => $TituloTotal, 'colStyle'=>$xlsxStyleNum['string total'], 'cellType'=>'string'],
                            "","",
                            ['value' => $pesosTotal, 'colStyle' => $TituloTotal === '#' ? $pesosInt : $pesosNum],
                          ];
                        }

                        $usdTotal =   empty($v[at_ResultadoUSD])  ?  0 : $v[at_ResultadoUSD];
                        if($usdTotal != 0) {
                           $xlsxUsd[] = [
                             //   ['value' => empty($xlsxUsd) ? 'Total' : '', 'colStyle'=>$usdString, 'cellType'=>'string' ],
                                ['value' => $TituloTotal, 'colStyle'=>$xlsxStyleNum['usd string total'],'cellType'=>'string'],
                                "","",
                                ['value' => $usdTotal, 'colStyle' =>  $TituloTotal === '#' ? $usdInt : $usdNum ],
                           ];
                        }
                }
                $html .= '</tr>';
            } // foreach
            if(!empty($xlsxPesos)) {
                foreach($xlsxPesos as $d)
                    $xlsData[] = $d;
            }

            if(!empty($xlsxUsd)) {
                if(!empty($xlsxPesos))
                    $xlsData[] = ['value' => ''];
                foreach($xlsxUsd as $d)
                    $xlsData[] = $d;
            }
        }

    $html .= ' </body> </html>';
}
elseif($completaHeaders == 'SI')
    {
        $htmlInico = '<!DOCTYPE html>
        <html lang="es">
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title></title>'.
        ($debug ? "<link href='$htmlcss' rel='stylesheet' type='text/css'/>":"")
        .'</head>

        <body><div>';

        $html=$htmlInico.$html.'</div></body></html>';
    }

    if($exportType == 'XLS') {
        $colWidth = colsWidths($xlsHeaderRow);
        // ajusta ancho de columnas con los datos
        foreach($xlsHeaderRow as $index => $h) {
            if(in_array(strtolower($h['label'] ??  ''), ['fecha','original date','date','new date'])) {
                $colWidth[$index]=11; // 11
            } elseif( str_contains(strtolower($h['label'] ??  ''), 'clien') || str_contains(strtolower($h['label']), 'nombr')) {
                $maxWidth = '';
                foreach($xlsData as $d) {
                    if(isset($d[$index])) {
                        if(is_array($d[$index])) {
                            if(isset($d[$index]['value']) && strlen($d[$index]['value']) > $maxWidth) {
                                $maxWidth = strlen($d[$index]['value']);
                            }
                        } elseif(strlen($d[$index]) > $maxWidth) {
                            $maxWidth = strlen($d[$index]);
                        }
                    }
                }
                if(!empty($maxWidth))
                    $colWidth[$index] = $maxWidth * 1.1;
                break;
            }
        }

        $xlsxWriter->setAuthor('Acme');

        // agrega 2 renglones en blanco:
        $xlsData[] = [];
        $xlsData[] = [];
        if(($perfil_reporte_grid['perfil'] ?? '') === 'EXCEL DE RONY') {
            $xlsData[] = ['', '', '', '', '','',$realTitle];
        } 
        $xlsData[] = [];
        $xlsData[] = [];
        $xlsxWriter->writeSheet($xlsData,'Hoja_1',$xlsHeaderRow,$xlsxMergedCells,$colWidth);

        $fileName = str_ireplace(array(XLSX,'.xls'),'',$fileName);

        if(($perfil_reporte_grid['perfil'] ?? '') !== 'EXCEL DE RONY')
           if(empty($titulo) || str_contains($titulo, '>'))
                $titulo = $fileName;

        $titulo = str_ireplace(array(XLSX,'.xls'),'',$titulo);
        if(empty($perfil_reporte_grid_id)) {
            $filename = trim("$titulo SIN PERFIL")." ".Date('Y-m-d G_i').XLSX;
        } elseif(!empty($perfil_reporte_grid['perfil'])) {
            $filename = $perfil_reporte_grid['perfil']." ".Date('Y-m-d G_i').XLSX;
        } else {
            if(!empty($perfil_reporte_grid_id))
                $nombreDownload = ia_singleread("select nombre from reportes_grid WHERE reporte_grid_id=".strit($perfil_reporte_grid['reporte_grid_id']) );
            $filename = !empty($nombreDownload) ? $nombreDownload." ".Date('Y-m-d G_i').XLSX : $titulo." ".Date('Y-m-d G_i').XLSX;
        }

        if( isset($DoSaldoFileName) && !empty($SaldoFileName)) {
            $filename = $SaldoFileName . " del " . fechame($SaldoFechaIni,$SaldoFechaFin) . XLSX;
        }
        if(isset($DoSaldoFileName)) {
            $colWidth[2] = 18.9;
            $colWidth[8] = 18.9;
        }

        header('Content-Disposition: attachment; filename="'. xlsxWrite::sanitize_filename($filename).'"');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        $xlsxWriter->writeToStdOut();
        ia_errores_a_dime();
        exit(0);
    }

if($completaHeaders == 'SI') {
    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header('Content-Type: application-download');
    header('Content-Length: ' . (strlen($html) + 100));
    header('Content-disposition: attachment; filename="' . strtolower($fileName) . '"');
    header("Content-Transfer-Encoding: binary");
}
echo $html;

function esRemarkSimilar($label) {
    return
        stripos($label, 'remark')!==false || stripos($label, 'referencia')!==false || stripos($label, 'comment')!==false ||
        stripos($label, 'coment')!==false || stripos($label, 'Poliza Contabilidad')!==false    || stripos($label, 'descrip')!==false
        ;
}

function colsWidths($headers) {
    $cols = array(
        'tienda'=>6.8,
        'cash/nota'=>11.5,
        '# cash/nota'=>13.2,
        '# Referencia'=>3.9,
        '# factura'=>13.9,
        'Comisión %' => 10.6,
        'iva %'=> 10.5,
        '% pagado'=> 8.8,
        'cuentat'=>10.6,
        'cuenta t origen'=> 10.6,
        'moneda'=> 0,
        'paid'=> 4.2,
        'estado'=> 6.2,
        'Autorizado'=> 10.1,
        'pendiente'=> 9.7,
        'banco'=> 5.7,
        'empresa'=> 11.5,
        'TC Sistema'=> 10,
        'TC Movimiento'=> 14,
        'Warning'=> 7.9,
        '# Cont.'=>6.5,
        '# Cont'=> 6.5,
        'Capturado'=> 9.5,
        'terminado'=> 9.9,
        'pagado'=>6.8,
        'error'=> 4.7,
        'cancelado'=>9.5,
        'delivered to'=>11.7,
        'accepted'=> 12.8,
        'constancia'=>9.9,
        'Alta por'=>11.3,
        'link por' => 11.3,
        'fecha'=>11,
        'fecha link' => 9.8,
        'Fecha retiro'=> 11.3,
        'rfc'=>19.8,
        'tipo venta'=>19,
        'tipo mov'=>8.6,
        'banco cuenta'=>19.43,

        'origen'=>9.2,
        'ultimo cambio'=>18,
        'último cambio'=>18,
        'delivered'=>18,

        'Documento' => 22,
        'Cuenta Bancaria' => 24,

        'Nombre' => 33,
        'Cliente' => 33,
        'Doc Cliente' => 33,

        'balance'=>18.9,
        'Doc Qty' => 19.5,
        'Saldo' => 19.5,
        'Debe' => 19.5,
        'A cuenta' => 19.5,
        'Monto' => 19.5,
        'Quantity' => 19.5,
        'Total payments' => 19.5,
        'Pagos' => 19.5,
        'Usado' => 19.5,
        'Disponible' => 19.5,
        'Withdrawal' => 19.5,
        'Withdrawals' => 19.5,

        'Remark' => 51,
        'Remarks' => 51,
        'Comment' => 51,
        'Comments' => 51,
        'Coment' => 51,
        'Coments' => 51,
        'Comentario' => 51,
        'Comentarios' => 51,
        'Referencia' => 51,
        'Poliza Contabilidad' => 51,

    );
    $colWidth=[];
    foreach($headers as $c) {
        $label = $c['label'];
        foreach($cols as $col=>$w)
            if(strcasecmp($col,$label)===0){
                $colWidth[] = $w;
                continue 2;
            }

        if($c['cellType'] === 'date')
            $colWidth[] = 11; // 10
        elseif($c['cellType'] === 'datetime')
            $colWidth[] = 14;

        elseif(stripos($label,'monto')===0 || stripos($label,'saldo')!==false)
            $colWidth[] = 19.5;
        elseif(strcasecmp('fecha',$label)===0)
            $colWidth[] = 11; // 17.8
        elseif(strcasecmp('remark',$label)===0)
            $colWidth[] = 51;
        else
            $colWidth[] = null;
    }

    return $colWidth;
}

function fechame($fechaIni,$fechaFin) {
    try {

        if(isset($_REQUEST['extraInfo']) && $_REQUEST['extraInfo']!="{}" ) { //UPDATED 23feb16 titular reporte fichas rony en todo_a_banco_list
            $fecha_deposit = json_decode($_REQUEST['extraInfo'],true);
            if(is_array($fecha_deposit)) {
                if(isset($fecha_deposit['fecha_deposit_ini']) && !empty($fecha_deposit['fecha_deposit_ini']))
                    $fechaIni = $fecha_deposit['fecha_deposit_ini']." 00:00:00";
                if(isset($fecha_deposit['fecha_deposit_fin']) && !empty($fecha_deposit['fecha_deposit_fin']))
                    $fechaFin = $fecha_deposit['fecha_deposit_fin']." 23:59:59";
            }
        }

        $f1 = new DateTime($fechaIni);
        $f2 = new DateTime($fechaFin);
        if($f1->format("M") == $f2->format("M"))
            return $f1->format("d") . " al " . $f2->format("d M y");
        return $f1->format("d M") . " al " . $f2->format("d M y");
    } catch(Exception) {}
    return '';
}

function calculaTotales_mse($totales, $nombresCols, $buffer, $startingpos = 0, $stoppingpos = -1, $cmnt = '', $own_ss = false)
{
    global $groupby, $huboMoneda;
    $arr_moneda=[];
    $arr_dif=[];
    $monedaCol=-1;
    $difCol=-1;
    $stoppingpos = $stoppingpos == -1 ? count($buffer) : $stoppingpos;

    foreach($groupby as $v) {
        if(stripos(strtolower($v[at_colNombre] ??  ''), 'moneda') !== false || strtolower($v[at_colNombre] ??  '') == 'moneda_id') {
            foreach($nombresCols as $kcn=>$vcn) {
                if(stripos(strtolower($vcn), 'moneda') !== false || strtolower($vcn) == 'moneda_id')
                    $monedaCol=$kcn;
            }

            $arr_moneda = generaArraydeunaColumna($buffer, $monedaCol, $startingpos, $stoppingpos);
            $huboMoneda = true;
            break;
        }
        elseif(!empty($v[at_colNombreDif])) {
            foreach($nombresCols as $kcn=>$vcn) {
                if(stripos(strtolower($vcn), strtolower($v[at_colNombreDif] ??  '')) !== false)
                    $difCol=$kcn;
            }

            $arr_dif = generaArraydeunaColumna($buffer, $difCol, $startingpos, $stoppingpos);
            break;
        }
    }

    foreach($totales as $v) {
        if(!empty($v[at_colNombreDif])) {
            foreach($nombresCols as $kcn=>$vcn) {
                if(stripos(strtolower($vcn), strtolower($v[at_colNombreDif] ??  '')) !== false)
                    $difCol = $kcn;
            }

            $arr_dif = generaArraydeunaColumna($buffer, $difCol, $startingpos, $stoppingpos);
            break;
        }
    }

    if(is_array($totales))
        foreach($totales as $v)
        {
            $pos = isValueonArray($nombresCols, $v[at_colNombre]);
            $v[at_colNum] = $pos;
            $v[at_Accion] = strtoupper($v[at_Accion] ?? '');

            //Calculo los Totales, y guardo el resultado en la posicion 6(at_Resultado)
            if($v[at_colNum] !== false)
            {
                if($own_ss)
                    foreach($groupby as  $vgby)
                        if($v[at_colNum] == $vgby[at_colNum])
                        {
                            $startingpos = $vgby[gb_Totales][0][gb_StartingPos];
                            break;
                        }
                $arr_total = generaArraydeunaColumna($buffer, $v[at_colNum], $startingpos, $stoppingpos);

                if($monedaCol>=0)
                {
                    $total_temp = doOperation($v[at_Accion], $arr_total, arr_ValuePos, $arr_moneda);
                    $v[at_ResultadoPESOS] = $total_temp[0];
                    $v[at_ResultadoUSD] = $total_temp[1];
                }
                elseif($difCol>=0)
                {
                    $v[at_Resultado] = doOperation($v[at_Accion], $arr_total, arr_ValuePos, false, $arr_dif, $v)[0];
                }
                else
                    $v[at_Resultado] = doOperation($v[at_Accion], $arr_total, arr_ValuePos);

            }
        }
    return $totales;
}

function lineaSeparadora_mse($cuantasCols, $splitted = false, $width = 1, $hr = true, $fortotals = false)
{

    global $totales;
    if($totales) $cuantasCols++;

    $html = '<tr>';
    if($splitted)
        for($horizontal=0;$horizontal<$cuantasCols;$horizontal++)
        {
            $html .= "<td style=''>";
            for($w=1;$w<=$width;$w++)
                if($hr)
                {
                    if($fortotals)
                        $html .= "<hr style='width:95%' ><hr style='width:95%' >";
                    else
                        $html .= "<hr style='width:95%' >";
                }
                else $html .= "&nbsp;";
            $html .= "</td>";
        }
    else
    {
        $html .= "<td colspan='$cuantasCols'>";
        for($w=1;$w<=$width;$w++)
            if($hr)
            {
                if($fortotals)
                    $html .= "<hr style='width:100%' ><hr style='width:95%' >";
                else
                    $html .= "<hr style='width:100%' >";
            }
            else $html .= "&nbsp;";

    }
    $html .= '</tr>';

    return $html;
}

function totalesenLinea_mse($at_acciones, $cuantasCols, $totales)
{
    //print_r($totales);
    //Para los totales en linea...
    global $css;
    global $at_acciones_desc;
    global $exportType;
    global $nombresCols;
    global $cuantasCols;

    $html = '';
    $td_html = '';
    for($caccion=0;$caccion<count($at_acciones);$caccion++) //Iteramos en las acciones disponibles
    {
        $huboaccion = false;

        $tr_html = "<tr><td><strong>$at_acciones_desc[$caccion]</strong></td>";

        for($horizontal=0;$horizontal<$cuantasCols-1;$horizontal++) //Recorremos todas las columnas
        {
            if($nombresCols[$horizontal][arr_Hidden] == 1)//08/12
            {
                $hubototal = false;
                if($totales && $totales != -1) foreach($totales as $tv) //Recorremos los totales, y si at_Display es 0 o 2, entonces lo mostramos.
                {
                    if($horizontal == $tv[at_colNum])
                        if(str_contains($tv[at_Accion] ?? '', $at_acciones[$caccion]) && ($tv[at_Display] == 0 || $tv[at_Display] == 2))
                        {
                            $style = '';
                            $class = array_reverse(explode(" ", trim($tv[at_Style])));
                            foreach($class as $cv)
                                foreach($css as $k=>$v)
                                    if($k == $cv)
                                        $style .= $v . ' ';


                            $tmpTv = $tv[at_Resultado] ?? ''; //FIXTOTALS en http://localhost/$gWebDir/backoffice/cuentat_a_banco_list.php fichas deposito con iva da undefined index
                            if($exportType == 'DOC')
                            {
                                if(str_contains(trim($nombresCols[$horizontal][arr_StylePos]), 'currency')) $tv[at_Resultado] = number_format(floatval($tv[at_Resultado]), 2, '.', ',');
                                if(str_contains(trim($nombresCols[$horizontal][arr_StylePos]), 'numeric')) $tv[at_Resultado] = number_format(floatval($tv[at_Resultado]), 0, '.', ',');
                            }

                            $td_html = "<td style='$style'><b>".$tmpTv."</b></td>";


                            $hubototal = true;
                        }
                }
                if($hubototal === true)
                {
                    $huboaccion = true;
                    $tr_html .= $td_html;
                }
                else {
                    $tr_html .= "<td>&nbsp;</td>";
                }

            }
        }
        $tr_html .= '</tr>';
        if( $huboaccion === true) {
            $html .= $tr_html;
        }
    }
    return $html;
}


function ordenaArray_mse($a,$b)
{
    return oaCompara_mse($a,$b,0);
}


function oaCompara_mse($a,$b,$nivel)
{
    global $groupby;

    if(str_contains($groupby[$nivel][gb_ValueType], 'datetime'))
        $gb_ValueType = 'datetime';
    elseif(str_contains($groupby[$nivel][gb_ValueType], 'date'))
        $gb_ValueType = 'date';
    elseif(str_contains($groupby[$nivel][gb_ValueType], 'currency'))
        $gb_ValueType = 'numeric';
    else $gb_ValueType = 'string';

    switch($gb_ValueType)
    {
        case 'date': case 'datetime':

            $va = strtotime($a[$groupby[$nivel][at_colNum]][arr_ValuePos]);
            $vb = strtotime($b[$groupby[$nivel][at_colNum]][arr_ValuePos]);
        break;

        case 'string':
            $va = strtolower($a[$groupby[$nivel][at_colNum]][arr_ValuePos] ??  '');
            $vb = strtolower($b[$groupby[$nivel][at_colNum]][arr_ValuePos] ??  '');
        break;

        default:
            $va = $a[$groupby[$nivel][at_colNum]][arr_ValuePos];
            $vb = $b[$groupby[$nivel][at_colNum]][arr_ValuePos];
        break;


    }

    if($va==$vb)
    {
        if($nivel == (sizeof($groupby)-1))
            return 0;
        else
            return oaCompara_mse($a,$b,$nivel+1);
    }
    else
    {
        if($groupby[$nivel][gb_SortType] == 'ASC')
        {
            if($va > $vb)
            {
                return 1;
            }
            else
            {
                return -1;
            }
        }
        else
        {
            if($va > $vb)
            {
                return -1;
            }
            else
            {
                return 1;
            }
        }
    }
}

function formateaValorSegunTipoAgrupador_mse($tipoAgrupador, $valor, $fechaexacta=false)
{
    if($fechaexacta && $tipoAgrupador != '')
        $tipoAgrupador = 'DIA';


    return match ($tipoAgrupador) {
        'DIA' => date('d-m-Y', strtotime($valor)),
        'MES' => date('m-Y', strtotime($valor)),
        'ANO' => date('Y', strtotime($valor)),
        default => $valor,
    };
}

function obtenNombreColumnasReales_mse($nombresCols):array
{
    $vnc = [];
    foreach($nombresCols as $v)
    {
        $vnc[] = $v[arr_colNombre];
    }
    return $vnc;
}

function cuantasColumnasOcultas_mse($nombresCols):int
{
    $cco = 0;
    foreach($nombresCols as $v)
    {
        if($v[arr_Hidden] == 0)
            $cco++;
    }
    return $cco;
}

function quitaLineasNuevasHTML_mse($str):string
{
    $str = str_replace('<br>',' - ',$str);
    $str = str_replace('<br/>',' - ',$str);
    return strip_tags($str);

}

function obtenInfoHijo_mse($origen,$id,$cuantasColssinOcultas):string
{
    $htmlConceptos = '';
    try
    {
        $app_doc = 'app_'.$origen;

        $doc2pdf = new $app_doc;

        $doc2pdf->id = $id;
        $doc2pdf->h = 'r';
        $doc2pdf->enDB=$doc2pdf->values=$doc2pdf->read_sql($id, $doc2pdf->h);
        $doc2pdf->doChilds=false;
        $doc2pdf->modoShow='pdf';

        $htmlConceptos = "<tr><td colspan='$cuantasColssinOcultas'><div style='width: 90%;'>";
        $htmlConceptos .= $doc2pdf->despliegaHijos();
        $htmlConceptos .= "</div></td></tr><tr><td colspan='$cuantasColssinOcultas'>&nbsp;</td></tr>";

    }catch(Exception){}
    return $htmlConceptos;
}

    /**
     * function array_reorder_keys_mse
     * reorder the keys of an array in order of specified keynames; all other nodes not in $keynames will come after last $keyname, in normal array order
     * @param array &$array - the array to reorder
     * @param mixed $keynames - a csv or array of keynames, in the order that keys should be reordered
     */
    function array_reorder_keys_mse(&$array, $keynames):void
    {
        if(empty($array) || !is_array($array) || empty($keynames)) return;
        if(!is_array($keynames)) $keynames = explode(',',$keynames);
        if(!empty($keynames)) $keynames = array_reverse($keynames);
        foreach($keynames as $n)
        {
            if(array_key_exists($n, $array))
            {
                $newarray = array($n=>$array[$n]); //copy the node before unsetting
                unset($array[$n]); //remove the node
                $array = $newarray + array_filter($array); //combine copy with filtered array
            }
        }
    }

    ia_errores_a_dime();

/**
 * @param $conRemarks
 * @return array
 */
function reporteDeudoresEnGetPorTienda_mse($conRemarks):array {
    $exportBuffer = json_decode($_REQUEST['exportBuffer']);
    $headers = [];
    $colNumber = 0;
    foreach(array_shift($exportBuffer) as $d) {
        $colName = $d[1];
        if($colName === 'Tienda' || $colName === 'Cliente' || $colName === 'Debe' || $colName === 'Moneda' || ($conRemarks && $colName === 'Remarks'))
            $headers[$colName] = $colNumber;
        elseif($colName === 'Saldo Pend')
            $headers['Debe'] = $colNumber;
        elseif($colName === 'Original Date')
            $headers['Fecha'] = $colNumber;
        $colNumber++;
    }

    $tiendaCol = 0;
    $fechaCol = $headers['Fecha'];
    $clienteCol = $headers['Cliente'];
    $debeCol = $headers['Debe'];
    $monedaCol = $headers['Moneda'];
    if($conRemarks)
        $remarksCol = $headers['Remarks'];

    $data = [];
    foreach($exportBuffer as $d) {
        $row = [
            'Fecha' => dateParse_mse($d[$fechaCol][1]),
            'Cliente'  => $d[$clienteCol][1],
            'Debe' => str_replace(['$',','], '', $d[$debeCol][1]),
            'Moneda' => $d[$monedaCol][1],
        ];
        if($conRemarks) {
            $s = str_replace( ['&nbsp;',"\t",'&gt;','&lt;'], [' ',' ','>','<'], $d[$remarksCol][1]);
            $row['Remarks'] = str_replace("..........................................", " ",
                strip_tags( str_replace(['<br>','<br/>','<br />','<p>','<div>','<ul>'], " \r\n", $s) )
            );
        }
        $data[$d[$tiendaCol][1]][] = $row;
    }
    return $data;
}

function dateParse_mse($date):string {
    static $meses =  [
        'ene'=>'01',
        'feb'=>'02',
        'mar'=>'03',
        'abr'=>'04',
        'may'=>'05',
        'jun'=>'06',
        'jul'=>'07',
        'ago'=>'08',
        'sep'=>'09',
        // 'oct'=>'10',
        // 'nov'=>'11',
        // 'dic'=>'12',

        //en
        'jan'=>'01',
        'apr'=>'04',
        'aug'=>'08',
        'sept'=>'09',
        'dec'=>'12',

        //de
        'jän'=>'01',
        'märz'=>'03',
        'marz'=>'03',
        'mai'=>'05',
        'juni'=>'06',
        'juli'=>'07',
        'okt'=>'10',
        // 'dez'=>'12',

        //fr
        'janv'=>'01',
        'févr'=>'02',
        'fevr'=>'02',
        'mars'=>'03',
        'avril'=>'04',
        'avr'=>'04',
        'juin'=>'06',
        'juil'=>'07',
        'août'=>'08',
        'aout'=>'08',
        'déc'=>'12',

        //pr
        // 'jan'=>'01',
        'fev'=>'02',
        'março'=>'03',
        'marco'=>'03',
        'abril'=>'04',
        'maio'=>'05',
        'junho'=>'06',
        'julho'=>'07',
        'agosto'=>'08',
        'set'=>'09',
        'out'=>'10',
        //'nov'=>'11',
        'dez'=>'12',


        // it 2 letras invnetado
        'genn'=>'01',
        'gen'=>'01',
        'ge'=>'01',
        'febbr'=>'02',
        'fe'=>'02',
        // 'mar'=>'03',
        // 'apr'=>'04',
        'magg'=>'05',
        'mag'=>'05',
        'giugno'=>'06',
        'giu'=>'06',
        'gi'=>'06',
        'luglio'=>'07',
        'lug'=>'07',
        'lu'=>'07',
        'ag'=>'08',
        'sett'=>'09',
        'se'=>'09',
        'ott'=>'10',
        'ot'=>'10',
        // 'nov'=>'11',
        'no'=>'11',
        // 'dic'=>'12',
        'di'=>'12',

        // nums
        '01'=>'01',
        '02'=>'02',
        '03'=>'03',
        '04'=>'04',
        '05'=>'05',
        '06'=>'06',
        '07'=>'07',
        '08'=>'08',
        '09'=>'09',
        'oct'=>'10',
        'nov'=>'11',
        'dic'=>'12',
        '1'=>'01',
        '2'=>'02',
        '3'=>'03',
        '4'=>'04',
        '5'=>'05',
        '6'=>'06',
        '7'=>'07',
        '8'=>'08',
        '9'=>'09',
    ];
    $date = trim($date);
    /** @noinspection RegExpRedundantEscape */
    if(preg_match('/^\d{4}[\.\-\/\\\\](0[1-9]|1[0-2])[\.\-\/](0[1-9]|[12]\d|3[01])/S', $date)) {
        $date[4] = '-';
        $date[7] = '-';
        return $date;
    }
    $timePart = preg_match('/([T ]([0-1]\d|2[0-3]):[0-5]\d.*)/S', $date, $matches) ? $matches[0] : '';

    if(stripos($date, '/')) {
        $parts = explode('/', $date);
    } elseif(stripos($date, '-')) {
        $parts = explode('-', $date);
    } elseif(stripos($date, ' ')) {
        $parts = explode(' ', $date);
    } elseif(stripos($date, '.')) {
        $parts = explode('.', $date);
    } else {
        $parts = [];
    }

    $m = count($parts)>1 ? str_replace('.', '', strtolower(trim($parts[1]  ??  '')) ) : null;
    if(3 !== count($parts) || $m === null || !array_key_exists($m, $meses)) {
        return $date;
    }
    return trim($parts[2]) .'-' .
        str_pad($meses[$m], 2, '0', STR_PAD_LEFT) .'-' .
        str_pad(trim($parts[0]), 2, '0', STR_PAD_LEFT) . $timePart
    ;
}

#[NoReturn] function repoorteDeudoresPorTienda_mse($tabla, $conRemarks) {
    $data = reporteDeudoresEnGetPorTienda_mse($conRemarks);
    $dateStyle = [  'halign'=>'center', 'valign'=>'center'];
    $cteStyle =  [  'halign'=>'center', 'valign'=>'center'];
    $debeStyle = [  'halign'=>'center', 'valign'=>'center', 'font-style'=>'bold'];
    // $debeUSDStyle = [  'halign'=>'center', 'valign'=>'center', 'font-style'=>'bold', 'color'=>'#139312'];
    $monedaStyle = [  'halign'=>'center', 'valign'=>'center'];
    // $monedaUSDStyle = [  'halign'=>'center', 'valign'=>'center', 'color'=>'#139312'];
    $remarksStyle =  [  'halign'=>'left',   'valign'=>'top' , 'wrap_text'=>true];
    $style = [$dateStyle, $cteStyle, $debeStyle, $monedaStyle];
    $styleUSD = $style;
    foreach($styleUSD as &$colStyle) {
        $colStyle['color'] = '#139312';
    }
    unset($colStyle);

    $widths = [12, 20, 12, 0];
    $header = array(
        'Fecha' => 'd/mm/yy;GENERAL',
        'Cliente' => 'string',
        'Debe' => '#,##0.00',
        'Moneda' => 'string',
    );

    if($conRemarks) {
        $header['Remarks'] = 'GENERAL';
        $style[] = $remarksStyle;
        $styleUSD[] = $remarksStyle;
        $widths[] = 60;
    }
    $monedaWidth = 0;

    $showColMoneda = $tabla === 'cheque' ? 'USD' : 'PESOS';
    $mainMoneda = $tabla === 'cheque' ? 'PESOS' : 'USD';

    $cteWidthAll = 0;
    $totalTabMonedaWidth = 0;
    $granTotalDebe = ['PESOS' => 0.00, 'USD' => 0.00];

    $xlsxWriter = new XLSXWriter();
    foreach($data as $tienda => $deudores) {
        $monedaWidth = 0;
        $cteWidth = 0;
        $totalDebe = ['PESOS' => 0.00, 'USD' => 0.00];
        foreach($deudores as $c) {
            $len = strlen($c['Cliente']);
            if($len > $cteWidth) {
                $cteWidth = $len + 5;
            }
            $totalDebe[$c['Moneda']] += $c['Debe'];

            if($c['Moneda'] === $showColMoneda) {
                $totalTabMonedaWidth = $monedaWidth = 9;
            }
        }
        if($cteWidth > $cteWidthAll) {
            $cteWidthAll = $cteWidth;
        }
        $widths[1] = $cteWidth;
        $widths[3] = $monedaWidth;
        $granTotalDebe['PESOS'] += $totalDebe['PESOS'];
        $granTotalDebe['USD'] += $totalDebe['USD'];

        $xlsxWriter->writeSheetHeader($tienda, $header, ['widths'=>$widths, 'style'=>$style  ]);
        foreach($deudores as $c) {
            $height = 25;
            if($conRemarks) {
                $chars = count_chars($c['Remarks']);
                if(!empty($chars[10]) && $chars[10] > 1 ) {
                    $height = 24.5 * $chars[10];
                }
                // $c['Remarks'] = mb_convert_encoding($c['Remarks'], 'UTF-8'); // = str_replace(['pagó:'], ['pago:::'], $c['Remarks']);
            }
            //$format = ['height'=>$height, 'wrap_text'=>true,'halign'=>'left','valign'=>'top'];
            $format = [
                    ['height'=>$height, 'halign'=>'center','valign'=>'center'],
                    ['height'=>$height, 'halign'=>'center','valign'=>'center'],
                    ['height'=>$height, 'halign'=>'center','valign'=>'center'],
             ];
             if($showColMoneda) {
                $format[] = ['height'=>$height, 'halign'=>'center','valign'=>'center'];
             }
             $format[] = ['height'=>$height, 'halign'=>'left','valign'=>'top', 'wrap_text'=>true];
            if($c['Moneda'] === 'USD')
                foreach($format as &$f)
                    $f['color'] = '#139312';
            unset($f);
            $xlsxWriter->writeSheetRow($tienda, $c, $format); //
        }
        unset($c);
        $xlsxWriter->writeSheetRow($tienda, ['','', '', '']);

        foreach($style as &$colStyle) {
            if(!in_array('bold', $colStyle)) {
                $colStyle['font-style'] = 'bold';
            }
        }
        foreach($styleUSD as &$colStyle) {
            if(!in_array('bold', $colStyle)) {
                $colStyle['font-style'] = 'bold';
            }
        }

        $totales = ['', 'Total', $totalDebe[$mainMoneda], $mainMoneda];
        if($mainMoneda === 'USD')
            $xlsxWriter->writeSheetRow($tienda, $totales,$styleUSD );
        else
            $xlsxWriter->writeSheetRow($tienda, $totales );

        if($monedaWidth > 0) {
            $totales = ['', 'Total', $totalDebe[$showColMoneda], $showColMoneda];
            if($mainMoneda === 'USD')
                $xlsxWriter->writeSheetRow($tienda, $totales);
            else
                $xlsxWriter->writeSheetRow($tienda, $totales, $styleUSD );
        }
    }


    if(usuarioTipoRony()) {
        unset($header['Remarks']);
        $header['Tienda'] = 'string';
        $widths = [12, 20, 12, 0, 11];
        $style = [$dateStyle, $cteStyle, $debeStyle, $monedaStyle, $monedaStyle];
        if($conRemarks) {
            $header['Remarks'] = 'GENERAL';
            $widths[] = 60;
            $style[] = $remarksStyle;
        }
        $styleUSD = $style;
        foreach($styleUSD as &$colStyle) {
            $colStyle['color'] = '#139312';
        }
        $tabName = "Todos $tabla";

        $widths[1] = $cteWidthAll;
        $widths[3] = $totalTabMonedaWidth;

        $xlsxWriter->writeSheetHeader($tabName, $header, ['widths'=>$widths, 'style'=>$style ]);

        foreach($data as $tienda => $deudores)
            foreach($deudores as $c) {
                if($conRemarks) {
                    $remarks = $c['Remarks'];
                    unset($c['Remarks']);
                }
                $c[] = $tienda;

                $height = 25;
                if($conRemarks) {
                    $c['remark'] = str_replace("..........................................", " ",  $remarks);
                    $chars = count_chars($remarks);
                    if(!empty($chars[10]) && $chars[10] > 1) {
                        $height = 24.6 * (int)$chars[10];
                    }
                }
                $format = ['height'=>$height, 'wrap_text'=>true,'halign'=>'left',   'valign'=>'top'];
                if($c['Moneda'] === 'USD')
                    $format['color'] = '#139312';
                $xlsxWriter->writeSheetRow($tabName, $c, $format);
            }
       $xlsxWriter->writeSheetRow($tabName, ['','', '', '', '']);


        foreach($style as &$colStyle) {
            if(!in_array('bold', $colStyle)) {
                $colStyle['font-style'] = 'bold';
            }
        }
        foreach($styleUSD as &$colStyle) {
            if(!in_array('bold', $colStyle)) {
                $colStyle['font-style'] = 'bold';
            }
        }
        $totales = ['', 'Total ', $granTotalDebe[$mainMoneda], $mainMoneda, ''];
        if($mainMoneda === 'USD')
            $xlsxWriter->writeSheetRow($tabName, $totales,$styleUSD );
        else
            $xlsxWriter->writeSheetRow($tabName, $totales );

        if($totalTabMonedaWidth > 0) {
            $totales = ['', 'Total', $granTotalDebe[$showColMoneda], $showColMoneda, ''];
            if($mainMoneda === 'USD')
                $xlsxWriter->writeSheetRow($tabName, $totales );
            else
                $xlsxWriter->writeSheetRow($tabName, $totales, $styleUSD );
        }
    }


    $fileName = "Deudores_por_Tienda_{$tabla}_".Date('Y_m_d').XLSX;

    header('Content-Disposition: attachment; filename="'. $fileName .'"');
    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');

    $xlsxWriter->writeToStdOut();


    ia_errores_a_dime(false);
    exit(0);
}



#[NoReturn] function reporteDuedoresTabPorTienda($tabla) {
     $xlsxWriter = new XLSXWriter();

     $dateStyle = [  'halign'=>'center', 'valign'=>'center'];
     $cteStyle =  [  'halign'=>'left',   'valign'=>'center'];
     $debeStyle = [  'halign'=>'right',  'valign'=>'center', 'font-style'=>'bold'];
     $monedaStyle = [  'halign'=>'center', 'valign'=>'center'];
    $header = array(
      'Fecha' => 'DD-MM-YY',
      'Cliente' => 'string',
      'Debe' => '#,##0.00',
      'Moneda' => 'string',
    );

    $showColMoneda = $tabla === 'cheque' ? 'USD' : 'PESOS';
    $mainMoneda = $tabla === 'cheque' ? 'PESOS' : 'USD';

    $cteWidthAll = 0;
    $totalTabMonedaWidth = 0;
    $granTotalDebe = ['PESOS' => 0.00, 'USD' => 0.00];
    $categoria_id = strit( ia_singleread("SELECT categoria_id FROM categoria WHERE categoria='ATRASADO'") );
    $queryTiendas = usuarioTipoRony() ?
        "SELECT tienda_id, clave FROM tienda ORDER BY 2" :
        "SELECT t.tienda_id, t.clave 
         FROM tienda t 
            JOIN plantilla_cobranza pc ON pc.tienda_id = t.tienda_id 
            JOIN plantillatienda pt ON  pc.plantillatienda_id=pt.plantillatienda_id
            JOIN iac_usr u ON u.plantillatienda_id = pt.plantillatienda_id 
         WHERE pc.permiso_$tabla IN ('Consultar','Editar') AND iac_usr_id = ".strit($_SESSION['usuario_id'])."
         ORDER BY 2";
    $filtroCategoria = usuarioTipoRony() ? '' :
        " AND doc.categoria_id IN(SELECT cc.categoria_id FROM categoria cc WHERE cc.='Todos')";

    foreach(ia_sqlArray($queryTiendas, 'tienda_id') as $tienda_id => $tienda) {
        /** @noinspection SqlResolve */
        $sql = "SELECT doc.original_date, cliente.nombre as Cliente, doc.quantity - doc.total_payments as Debe, IF(moneda_id=1,'PESOS','USD') as Moneda 
            FROM $tabla doc JOIN cliente ON doc.cliente_id = cliente.cliente_id
            WHERE doc.categoria_id<>$categoria_id AND doc.tienda_id = $tienda_id AND doc.paid=0 $filtroCategoria
            ORDER BY 1 , doc.quantity DESC, doc.alta_db ";
        $deudores = ia_sqlArrayIndx($sql);
        if(!empty($deudores)) {
            $monedaWidth = 0;
            $cteWidth = 0;
            $totalDebe = ['PESOS' => 0.00, 'USD' => 0.00];
            foreach($deudores as $c) {
                $len = strlen($c['Cliente']);
                if($len > $cteWidth) {
                    $cteWidth = $len + 5;
                }
                $totalDebe[$c['Moneda']] += $c['Debe'];

                if($c['Moneda'] === $showColMoneda) {
                    $totalTabMonedaWidth = $monedaWidth = 9;
                }
            }
            if($cteWidth > $cteWidthAll) {
                $cteWidthAll = $cteWidth;
            }
            $granTotalDebe['PESOS'] += $totalDebe['PESOS'];
            $granTotalDebe['USD'] += $totalDebe['USD'];

            $xlsxWriter->writeSheetHeader($tienda['clave'], $header, ['widths'=>[11, $cteWidth, 12, $monedaWidth], 'style'=>[$dateStyle, $cteStyle, $debeStyle, $monedaStyle]  ]);
            foreach($deudores as $c) {

                $xlsxWriter->writeSheetRow($tienda['clave'], $c, [ 'style'=>[ $dateStyle, $cteStyle, $debeStyle ] ]);
            }
            $xlsxWriter->writeSheetRow($tienda['clave'], ['','', '', '']);

            $totales = ['', 'Total', $totalDebe[$mainMoneda], $mainMoneda];
            $xlsxWriter->writeSheetRow($tienda['clave'], $totales ); // , [ 'font-style'=>'bold' ]

            if($monedaWidth > 0) {
                $totales = ['', 'Total', $totalDebe[$showColMoneda], $showColMoneda];
                $xlsxWriter->writeSheetRow($tienda['clave'], $totales ); // , [ 'font-style'=>'bold' ]
            }

        }
    }

    if(usuarioTipoRony()) {

        $header['Tienda'] = 'string';
        $tabName = "Todos $tabla";
        /** @noinspection SqlResolve */
        $sql = "SELECT doc.original_date, cliente.nombre as Cliente, doc.quantity - doc.total_payments as Debe,IF(moneda_id=1,'PESOS','USD') as Moneda , t.clave
            FROM $tabla doc JOIN cliente ON doc.cliente_id = cliente.cliente_id JOIN tienda t ON doc.tienda_id=t.tienda_id
            WHERE doc.paid=0 AND doc.categoria_id<>$categoria_id  
            ORDER BY 1, doc.quantity DESC, doc.alta_db";

        $deudores = ia_sqlArrayIndx($sql);
        $xlsxWriter->writeSheetHeader($tabName, $header, ['widths'=>[11,$cteWidthAll,13, $totalTabMonedaWidth, 8], 'style'=>[$dateStyle, $cteStyle, $debeStyle, $dateStyle, $dateStyle,]]);

        foreach($deudores as $c) {
            $xlsxWriter->writeSheetRow($tabName, $c, ['style'=>[$dateStyle, $cteStyle, $debeStyle, $dateStyle, $dateStyle,]]);
        }
       $xlsxWriter->writeSheetRow($tabName, ['','', '', '', '']);

        $totales = ['', 'Total', $granTotalDebe[$mainMoneda], $mainMoneda, ''];
        $xlsxWriter->writeSheetRow($tabName, $totales );

        if($totalTabMonedaWidth > 0) {
            $totales = ['', 'Total', $granTotalDebe[$showColMoneda], $showColMoneda, ''];
            $xlsxWriter->writeSheetRow($tabName, $totales );
        }

    }

    $fileName = "Deudores_por_Tienda_{$tabla}_".Date('Y_m_d').XLSX;

    header('Content-Disposition: attachment; filename="'. $fileName .'"');
    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');

    $xlsxWriter->writeToStdOut();


    ia_errores_a_dime(false);
    exit(0);
}
ia_errores_a_dime();
