<?php
require_once('../inc/config.php');

session_write_close();
ignore_user_abort(true);


$path_arg = param("path");

$path_arg = json_decode($path_arg);


reset_opcache_files($sortingOrder = 0, $path_arg);


function reset_opcache_files($sortingOrder, $path_arg)
{
    if(empty($path_arg))
        return;
    $included = array_flip( get_included_files() );
    $exclude = array_flip([
        'css', 'css2', 'saas', 'demo', 'font', 'fonts', 'htmltest', 'js', 'js2', 'js_ia', 'locale',
        'test', 'testie', 'tests', 'example', 'examples', 'tutorial', 'doing', 'db', 'debug',
        'img', 'image', 'images', 'jquery-ui-themes', 'PHPExcel', 'json', 'pdfs', 'txt', 'cacheador', 'tools', 'uploads', 'vendor', 'crons', '.git', '.idea',
    ]);
    $excludeFiles = array_flip([
        'limpiar_prog.php', 'warmUp.php', 'lintme.php',

    ]);

    $phpFilesFound = 0;
    $phpFilesWithErrors = 0;
    $filesWithErrors = array();

    if(!is_array($path_arg))
        $path_arg = array($path_arg);

    foreach($path_arg as $k=>$path)
    foreach (scandir($path, $sortingOrder) as $file) {
        if (empty($file) || $file[0] === '.' ||
            array_key_exists(strtolower($file), $exclude) ||
            array_key_exists($file, $excludeFiles) ||
            strcasecmp($file, 'PHPExcel') === 0
        )
            continue;
        if (is_dir($path . $file)) {
            reset_opcache_files($sortingOrder,$path . $file . '/');
            continue;
        }
        if(strstr($file, '.php') !== '.php' ||
            stripos($file, "old.php") !== false ||
            stripos($file, " Copy") !== false||
            stripos($file, "-1") !== false||
            stripos($file, "supervisor") !== false
        )
            continue;

        $phpFilesFound++;
        $filePath = $path . $file;

        opcache_invalidate($filePath, true);


        exec('C:\wamp\bin\php\php5.6.16\php.exe -l ' . $filePath, $output, $lint);

        try {
            if(!opcache_is_script_cached($filePath) && !array_key_exists(realpath($filePath), $included))
                opcache_compile_file($filePath);
        } catch(Throwable $e) {
            $phpFilesWithErrors++;
            $filesWithErrors[$filePath] = $filePath . " <i>al opcachear</i>";
            echo "<li>Error al cachear: " . $e->getMessage() . "</li>";
        }
        unset($output, $lint);
        echo "<li>$filePath";
        $blanks = str_pad('', 4096, '&nbsp;');
        echo $blanks;
        ob_flush();
        flush();
    }
}
die();