// import {Fmt as Fmt} from "./Fmt.js";

/*


    _count problems
    drill re-drill
    drill table expand to level
    drill table buttons expandAll, collapseAll, show to level
    drill table sort
    drill: pie, bar, stacked,...


    table-totales-sub Totales

    pivot table

    TableSorter: filtros (ancho de columnas), sort fechas
    Totales Break
    Export buttons

 */

/*
    https://vishwas-r.medium.com/creating-sparkline-charts-with-canvasjs-c9ae16b62ebf
    https://github.com/fnando/sparkline
    * https://codepen.io/nikomccarty/pen/OJRzxrM
    * https://www.essycode.com/posts/create-sparkline-charts-d3/
    ** https://github.com/DKirwan/reusable-d3-sparkline

    sparkliner
        https://travishorn.com/d3-line-chart-with-forecast-90507cb27ef2
        ** http://reichlab.io/d3-foresight/  https://github.com/reichlab/d3-foresight
https://medium.com/geekculture/create-simple-observable-object-in-javascript-48886b7b2f98
https://medium.com/geekculture/create-simple-observable-object-in-javascript-48886b7b2f98

        pa axes
        https://ghenshaw-work.medium.com/customizing-axes-in-d3-js-99d58863738b
        ** https://github.com/d3/d3#wiki-tickValues https://github.com/mbostock/d3/wiki/SVG-Axes#tickFormat
https://jsfiddle.net/sc3Lrsa1/2/
var monthFormat = d3.time.format("%B");
var xAxis = d3.svg.axis()
    .scale(xScale)
    .orient("bottom")
    .ticks(6)
   .innerTickSize(-height)
    .outerTickSize(0)
    .tickPadding(10)
    .tickFormat(monthFormat)
    .tickValues([
    new Date(2011, 11, 1),new Date(2013, 1, 1)
    ]);
o
  .tickSize(0)
  .tickFormat(function(d, i){
    var rounded = (Math.round((d/10000) * 10) / 10).toFixed(1);
    return i == 0 || i == 4 ? rounded + "M": "";
  });

 */
/*
    @TODO table: colName => label, Fmt option
    @TODO a table grouped with totals by group, no drill. Sin sort o childrows sort
    @TODO totals-break ie moneda, units
    @TODO Fmt sparkliner
    @TODO Exporter: copy, print, csv, pdf, xslx



 */
class Reporter {
    dataNotAvailble= "n/a";
    #settings = {
        init_expand_level: 1,
        toggle_expand_levels: 1,
        drillSymbolClosed: "⇨",
        drillSymbolOpened: "⇩",
        drillSymbolLeaf: "⚬",
        drillSymbolOneChlild: "",
        cssPrefix: 'drill_', // classes drill_Leaf, drill_Close, drill_Open, drill_OneChild each one for TR, TD, SPAN
        dataPrefix: "d", // data-level, data-colname
    };

    #dataKeys = {
        level: `${this.#settings.dataPrefix}level`,
        leaf: `${this.#settings.dataPrefix}leaf`,
        drill: `${this.#settings.dataPrefix}drill`,
        drillButton: `${this.#settings.dataPrefix}button`,
        drillCell: `${this.#settings.dataPrefix}cell`,
        drillBreadcrumbs: `${this.#settings.dataPrefix}breadcrumbs`,
        colname: `${this.#settings.dataPrefix}colname`,
    };

    #totals = {}
    #zeros = {};
    #grandTotals = {}
    #dimensionTotals = {}
    /**
     * The `#fmt` variable is used to format strings in a specified way.
     *
     * @type {object} class Fmt
     */
    #fmt;
    #myVarName = "";
    #drillTableId = "drillTable";
    constructor(myVarName, totals = [], settings ={}, fmt) {
        this.#myVarName = myVarName;
        this.#setTotals(totals);
        if(typeof settings !== 'object' || settings === null)
            throw new Error("Driller.constructor Parameter 'settings' should be an Object");
        Object.assign(this.#settings, settings);
        this.#setDataKeys();

        this.#fmt = typeof fmt === 'undefined' ? new Fmt() : fmt;
    }

    getGrandTotals() {return {...this.#grandTotals}}
    getDimensionTotals() {return {...this.#dimensionTotals}}
    getSettings() {return {...this.#settings}}

    //<editor-fold desc="Table">
    table(data, caption= "", tableId = "tableIt", tableClass = "laTabla") {
        this.#setTotals(this.#totals);
        let ths = [`<tr class="tablesorter-headerRow">`];
        let firstRow = {};
        let trs = [];
        for(let row of data) {
            if(ths.length === 1) {
                firstRow = {...row};
                for(let colName in row)
                    if(row.hasOwnProperty(colName))
                        ths.push(this.#fmt.label(colName, row, {tag: "TH", class:"tablesorter-header tablesorter-headerUnSorted" }));
            }
            this.#totalsDo(row);
            let tds = [];
            for(let colName in row)
                if(row.hasOwnProperty(colName))
                   tds.push( this.#fmt.col(colName, row[colName] || "", row, {tag:"TD", "data-value": row[colName] || ""}) );
            trs.push(`<tr>${tds.join(" ")}`);
        }
        let tfs = [];
        for(let colName in firstRow)
            if(this.#grandTotals.hasOwnProperty(colName))
                tfs.push(this.#fmt.col(colName, this.#grandTotals[colName], this.#grandTotals, {tag:"TH class='laTablaFoot'"}));
            else
                tfs.push("<TH class='laTablaFoot'>");
        let tfoot = tfs.length ? `<tfoot><tr>${tfs.join(" ")}</tr></tfoot>` : "";
        return `<table id="${tableId}" class="${tableClass}">
            <caption>${caption}</caption>
            <thead>${ths.join(" ")}</tr></thead>
            <tbody>${trs.join(" ")}</tbody>
            ${tfoot}
        </table>`;
    }
    //</editor-fold>

    //<editor-fold desc="Drill Table">
    drillTable(tableId, data, dimensions, columns=[], sortByTree = []) {
        this.#drillTableId = tableId;
        let grouped = this.#toArray(this.tree(data, dimensions));
        if(sortByTree.length)
            grouped = this.sortTree(grouped, sortByTree);

        let totals = ["<TR>", this.#fmt.col("count", this.#grandTotals._count, {}, {tag:"TH"})];
        let labels = ["<TR>", "<TH>"];
        for(let columnName of columns) {
            labels.push(this.#fmt.label(columnName, {}, {tag: "TH"}));
            totals.push( this.#fmt.col(columnName, this.#grandTotals[columnName] || "", {}, {tag: "TH"}) );
        }

        return {
            labels,
            totals,
            data: this.#drillRows(grouped, columns, dimensions),
            toolbox: this.#drillToolbox(dimensions),
        };
    }

    #drillToolbox(dimensions) {
        let toLevel = [];
        let level = 0;
        for(let dim of dimensions)
            toLevel.push(`<u style="cursor: pointer;"  title="Show at ${dim} level" onclick="${this.#myVarName}.expandToLevel(${++level})">${dim}</u>`);
        toLevel.push(`<u style="cursor: pointer;"  title="Show data" onclick="${this.#myVarName}.expandToLevel(${++level})">Datos</u>`);
        return `<div class="drill_Toolbox">
                <div title="Mostrar al nivel de:">👁</div>
                <div style="padding-left:0.5em;font-weight:100;font-size:0.8em;vertical-align: bottom">${toLevel.join(" &rarr; ")}</div>
            </div>`;
    }

    #drillRows(groupedArray, columns, dimensions, level = 1) {
        let trs =[];
        let drillDimension = dimensions[level - 1] || null;
        for(let row of groupedArray) {
            let title= [];
            let breadcrumbs = {};
            for(let dim of dimensions) {
                title.push(row[dim] || this.dataNotAvailble);
                breadcrumbs[dim] = row[dim] || this.dataNotAvailble;
                if(dim === drillDimension)
                    break;
            }
            let p = this.#drillDownRowSettings(row,level, drillDimension);
            if(!p.is_leaf)
                this.#getRowLevelTotals(row, dimensions, level);

            let tdDrill = `<td class="${p.tdClass}" data-${this.#dataKeys.drillCell} data-${this.#dataKeys.drillBreadcrumbs}='${JSON.stringify(breadcrumbs)}' title="${title.join(' &rarr; ')}"><span class="${p.setClass}"${p.onclick}${p.dataClickButton} style="padding-left:${(level - 1)}em">${p.symbol}</span> ${p.drillLabel}${p.counter}`;
            
            let tds = [tdDrill];
            for(let columnName of columns) {
                let htmlAttributes = {tag:"TD", "data-name":columnName};
                htmlAttributes[` data-${this.#dataKeys.colname}`] = columnName;
                tds.push(this.#fmt.col(columnName, row[columnName] || "", row, htmlAttributes));
            }
            trs.push(`<tr class="${p.trClass}" data-${this.#dataKeys.level}="${level}" data-${this.#dataKeys.leaf}="${p.is_leaf}">${tds.join(" ")}`);
            if(Object.keys(row._children || {}).length > 0)
                trs.push( ...this.#drillRows(row._children, columns, dimensions, level + 1));
            if( (row._rows || []).length)
                trs.push( ...this.#drillRows(row._rows, columns, dimensions, level + 1));
        
        }
        return trs;
    }

    #getRowLevelTotals(row, dimensions = [], level = 0) {
        if(dimensions.length === 0)
            return;
        let totalLevel = this.#dimensionTotals;
        for(let atLevel = 0; atLevel < level; ++atLevel) {
            let dimValue = row[dimensions[atLevel]]
            if(!totalLevel.hasOwnProperty(dimValue)) {
                console.log(`DIMVALUE NOT FOUND atLevel=${atLevel} level=${level}`, dimValue);
                return;
            }
            totalLevel = totalLevel[dimValue];
        }
        Object.assign(row, totalLevel);
    }

    #drillDownRowSettings(row, level, drillDimension) {
        let drillLabel = drillDimension === null ? " " : row[drillDimension] ?? this.dataNotAvailble;
        let counter = (row._count || 0) ? ` <sup>${row._count}</sup>` : "";
        let is_leaf = Object.keys(row._children || {}).length === 0 && (row._rows || []).length === 0;
        let onclick;
        let dataClickButton;
        let dataDrillCell;
        let symbol;
        let setClass;
        let tdClass = "";
        let trClass;
        if(is_leaf) {
            onclick = dataClickButton = dataDrillCell = "";
            symbol = this.#settings.drillSymbolLeaf;
            setClass = `${this.#settings.cssPrefix}Leaf`;
            tdClass = `${this.#settings.cssPrefix}Leaf`;
            trClass = `${this.#settings.cssPrefix}Hide`;
        } else {
            onclick = ` onclick="${this.#myVarName}.toggle(this)"`;
            dataDrillCell = ` data-${this.#dataKeys.drillCell}`;
            dataClickButton = ` data-${this.#dataKeys.drillButton}`;
            if(level < this.#settings.init_expand_level) {
                trClass = `${this.#settings.cssPrefix}Row ${this.#settings.cssPrefix}Show`;
                symbol = this.#settings.drillSymbolOpened;
                setClass = `${this.#settings.cssPrefix}Open`;
            }
            else if(level === this.#settings.init_expand_level) {
                trClass = `${this.#settings.cssPrefix}Row ${this.#settings.cssPrefix}Show`;
                symbol = this.#settings.drillSymbolClosed;
                setClass = `${this.#settings.cssPrefix}Close`;
            } else {
                trClass = `${this.#settings.cssPrefix}Row ${this.#settings.cssPrefix}Hide`;
                symbol = this.#settings.drillSymbolClosed;
                setClass = `${this.#settings.cssPrefix}Close`;
            }
        }
        if(parseInt(row._count || 0) === 1)
            setClass +=  ` ${this.#settings.cssPrefix}OneChild`;
        return {drillLabel, counter, is_leaf, onclick, dataClickButton, dataDrillCell, symbol, setClass, tdClass, trClass}
    }

    toggle(element) {
        if(!element.dataset.hasOwnProperty(this.#dataKeys.drillButton)) {
            element = this.#getDrill(element);
            if(element === null) {
                console.log(`driller.toggle click received element with data-${this.#dataKeys.drillButton} not found:`, element);
                return;
            }
        }
        if(element.innerHTML === this.#settings.drillSymbolClosed )
            this.expand(element, this.#settings.toggle_expand_levels);
        else
            this.collapse(element);
    }
    collapse(element) {
        let drill = element.dataset.hasOwnProperty(this.#dataKeys.drillButton) ? element : this.#getDrill(element);
        if(drill !== null) {
            drill.innerHTML = this.#settings.drillSymbolClosed;
            drill.classList.add(`${this.#settings.cssPrefix}Close`);
            drill.classList.remove(`${this.#settings.cssPrefix}Open`);
        }
        let tr = this.#getParentTR(element);
        let level = parseInt( tr.dataset[this.#dataKeys.level] );
        let nextSibling = tr.nextElementSibling;
        while(nextSibling) {
            let l = parseInt(nextSibling.dataset[this.#dataKeys.level]);
            if(l <= level || isNaN(l))
                break;
            nextSibling.classList.remove(`${this.#settings.cssPrefix}Show`);
            nextSibling.classList.add(`${this.#settings.cssPrefix}Hide`);
            nextSibling = nextSibling.nextElementSibling;
        }
    }

    expand(element, numGenerations) {
        let drill = element.dataset.hasOwnProperty(this.#dataKeys.drillButton) ? element : this.#getDrill(element);
        if(drill !== null) {
            drill.innerHTML = this.#settings.drillSymbolOpened;
            drill.classList.add(`${this.#settings.cssPrefix}Open`);
            drill.classList.remove(`${this.#settings.cssPrefix}Close`);
        }
        let tr = this.#getParentTR(element);
        let level = parseInt( tr.dataset[this.#dataKeys.level] );
        let showUpTo = level + (isNaN(numGenerations) ? 1 : numGenerations);
        let nextSibling = tr.nextElementSibling;
        while(nextSibling) {
            let l = parseInt(nextSibling.dataset[this.#dataKeys.level]);
            if(l <= level || isNaN(l))
                break;
            if(l === showUpTo) {
                nextSibling.classList.add(`${this.#settings.cssPrefix}Show`);
                nextSibling.classList.remove(`${this.#settings.cssPrefix}Hide`);
                let symbol = this.#getDrill(nextSibling);
                if(symbol) {
                    symbol.innerHTML = this.#settings.drillSymbolClosed;
                    symbol.classList.add(`${this.#settings.cssPrefix}Close`);
                    symbol.classList.remove(`${this.#settings.cssPrefix}Open`);
                }
                nextSibling = nextSibling.nextElementSibling;
                continue;
            }
            nextSibling.classList.remove(`${this.#settings.cssPrefix}Show`);
            nextSibling.classList.add(`${this.#settings.cssPrefix}Hide`);
            nextSibling = nextSibling.nextElementSibling;
        }
    }

    expandToLevel(toLevel) {
        if(isNaN(toLevel) || toLevel < 1)
            toLevel = 1;
        toLevel = parseInt(toLevel);
        const table = document.querySelector(`#${this.#drillTableId}`);
        const tbody = table.getElementsByTagName("tbody")[0];
        const rows = tbody.rows;
        for(let tr of rows) {
            let trLevel = parseInt(tr.dataset[`${this.#settings.dataPrefix}level`]);
            if( trLevel > toLevel) {
                tr.classList.add(`${this.#settings.cssPrefix}Hide`);
                tr.classList.remove(`${this.#settings.cssPrefix}Show`);
                continue;
            }
            if( trLevel === toLevel) {
                tr.classList.add(`${this.#settings.cssPrefix}Show`);
                tr.classList.remove(`${this.#settings.cssPrefix}Hide`);
                let symbol = this.#getDrill(tr);
                if(symbol) {
                    symbol.innerHTML = this.#settings.drillSymbolClosed;
                    symbol.classList.add(`${this.#settings.cssPrefix}Close`);
                    symbol.classList.remove(`${this.#settings.cssPrefix}Open`);
                }
                continue;
            }
            tr.classList.add(`${this.#settings.cssPrefix}Show`);
            tr.classList.remove(`${this.#settings.cssPrefix}Hide`);
            let symbol = this.#getDrill(tr);
            if(symbol) {
                symbol.innerHTML = this.#settings.drillSymbolOpened;
                symbol.classList.add(`${this.#settings.cssPrefix}Open`);
                symbol.classList.remove(`${this.#settings.cssPrefix}Close`);
            }
        }
    }

    //</editor-fold>

    //<editor-fold desc="Pivot Table">
    pivotTable(data, rowDimensions, colDimensions) {
        const dimensions = [...rowDimensions, ...colDimensions];
        return  this.tree(data, dimensions);
    }
    //</editor-fold>

    tree(data, dimensions = []) {
        this.#setTotals(this.#totals);

        let n;
        const tree = {}
        for(let row of data) {
            let dimValueParent = "";
            let node = tree;
            let rowDimensions = {};
            for(let dim of dimensions) {
                let dimValue = row[dim] || this.dataNotAvailble;
                rowDimensions[dim] = dimValue;
                if(!node.hasOwnProperty(dimValue)) {
                    let obj = {}
                    obj[dim] = dimValue;
                    node[dimValue] = {_children: {}, _rows:[], ...rowDimensions, ...this.#zeros, _parent:dimValueParent};
                }
                n = node[dimValue];
                dimValueParent = dimValue;
                node = n._children;
            }
            this.#totalsDo(row, dimensions);
            // noinspection JSUnusedAssignment
            n._rows.push(row);
        }
        return tree;
    }

    sortArray(data, sortBy) {
        if(sortBy === null || sortBy.length === 0)
            return data;
        if(typeof sortBy === "string")
            sortBy = [ sortBy.split(",").map(item => item.trim()) ];
        if(!Array.isArray(data))
            throw new Error("driller.sort Parameter datashould be an Array");
        if(!Array.isArray(sortBy))
            throw new Error("driller.sort Parameter sortBy should be an Array or String");
        function sortItem(a, b){
            for(let f of sortBy) {
                let ascending = true;
                let lowerCase = f.toLowerCase();
                if(lowerCase.endsWith(" asc")) {
                    f = f.substring(0, f.length - 4).trim();
                } else if(lowerCase.endsWith(" desc")) {
                    ascending = false;
                    f = f.substring(0, f.length - 5).trim();
                }
                let aSort = isNaN(a[f] || null) ? a[f] : parseFloat(a[f] || 0.00);
                let bSort = isNaN(b[f] || null) ? b[f] : parseFloat(b[f] || 0.00);
                if(ascending) {
                    if(aSort < bSort) return -1;
                    if(aSort > bSort) return 1;
                } else {
                    if(aSort < bSort) return 1;
                    if(aSort > bSort) return -1;
                }
            }
            return 0;
        }
        return data.sort(sortItem);
    }

    sortTree(tree, sortByTree) {
        function sortItem(a, b){
            for(let f of sorter) {
                let ascending = true;
                let lowerCase = f.toLowerCase();
                if(lowerCase.endsWith(" asc")) {
                    f = f.substring(0, f.length - 4).trim();
                } else if(lowerCase.endsWith(" desc")) {
                    ascending = false;
                    f = f.substring(0, f.length - 5).trim();
                }
                let aSort = isNaN(a[f] || null) ? a[f] : parseFloat(a[f] || 0.00);
                let bSort = isNaN(b[f] || null) ? b[f] : parseFloat(b[f] || 0.00);
                if(ascending) {
                    if(aSort < bSort) return -1;
                    if(aSort > bSort) return 1;
                } else {
                    if(aSort < bSort) return 1;
                    if(aSort > bSort) return -1;
                }
            }
            return 0;
        }

        if(sortByTree === null || sortByTree.length === 0)
            return tree;
        if(typeof sortByTree === "string")
            sortByTree = [ sortByTree.split(",").map(item => item.trim()) ];

        if(!Array.isArray(tree))
            throw new Error("driller.sortTree Parameter groupedArray should be an Array");
        if(!Array.isArray(sortByTree))
            throw new Error("driller.sortTree Parameter sortBy should be an Array");

        let sorter = sortByTree[0];
        let sorted = tree.sort(sortItem);

        if(sortByTree.length > 1) {
            sorter = sortByTree[1];
            for(let row of sorted) {
                row._children = row._children.sort(sortItem);
            }
        }

        return sorted;
    }

    //<editor-fold desc="Utility/helper functions">
    #totalsDo(row, dimensions = []) {
        this.#grandTotals._count++;
        for(let t of this.#totals) {
            if(!row.hasOwnProperty(t))
                row[t] = 0.00;
            let v = row[t] || null;
            if(isNaN(v) || v === null)
                continue;
            v = parseFloat(v);
            this.#grandTotals[t] += v;
            let dimPointer = this.#dimensionTotals;
            for(let dim of dimensions) {
                let dimValue = row[dim] || this.dataNotAvailble;
                if(!dimPointer.hasOwnProperty(dimValue))
                    dimPointer[dimValue] = { ...this.#zeros};
                dimPointer[dimValue][t] += v;
                dimPointer = dimPointer[dimValue];
            }
        }
    }

    #setTotals(totals) {
        this.#zeros = {_count: 0};
        if(typeof totals === "string")
            totals = [ totals.split(",").map(item => item.trim()) ];
        this.#totals = totals; // colName:{sum,max,min, subtotalby} ['colName', {colName:[subTotal1, subsubTotal]}]
        // {min:-Infinity, max:Infinity, sum:0, _count:0, ¿sumSquared pa stdDev?, ¿subTotals:{dim:... recursively}?}
        for(let z of totals) {
            if(typeof z === 'object') {
                for(let zKey of z)
                    if(z.hasOwnProperty(zKey)) {
                        this.#zeros[zKey] = {_subTotalsBy: z[zKey]};
                        this.#zeros[zKey] = 0.00;
                    }
            } else
                this.#zeros[z] = 0.00;
        }
        this.#grandTotals = {...this.#zeros};
        this.#dimensionTotals = {}
    }

    #setDataKeys() {
        this.#dataKeys = {
            level: `${this.#settings.dataPrefix}level`,
            leaf: `${this.#settings.dataPrefix}leaf`,
            drill: `${this.#settings.dataPrefix}drill`,
            drillButton: `${this.#settings.dataPrefix}button`,
            drillCell: `${this.#settings.dataPrefix}cell`,
            drillBreadcrumbs: `${this.#settings.dataPrefix}breadcrumbs`,
            colname: `${this.#settings.dataPrefix}colname`,
        }
    }

    #toArray(groupedObject) {
        let arr = [];
        for(let o in groupedObject)
            if(groupedObject.hasOwnProperty(o)) {
                let row = groupedObject[o];
                if(row.hasOwnProperty("_children"))
                    row._children = this.#toArray(row._children);
                arr.push(row);
            }
        return arr;
    }

    #getParentTR(element) {
        let el = element;
        while(el.tagName !== "TR") {
            if(el.tagName === "BODY")
                return null;
            el = el.parentElement;
            if(el === null)
                return null;
        }
        return el;
    }

    #getDrill(element) {
        if(element.dataset.hasOwnProperty(this.#dataKeys.drillButton))
            return element;
        return $(`[data-${this.#dataKeys.drillButton}]`, element).first()[0];
    }
    //</editor-fold>

}
