
jQuery(function($){
    listaPrecios.init();
});
const ListPast={
    id_list: null,
    id_prod: null,
    precio: null,
    moneda: null,
    tc: null,
    mxn: null,
}
class CrudListaPrecios{
    AllListas= [];
    listaPrecios = [];
    id_default=1;
    id_list;
    tiendas_list= [];
    listName=[];
    AllListasSelected=[];
    tc_opc= [];
    parametros= [];
    defaults;
    temporal_mxn;
    producto_general_id;
    cambios; 
    transicion;
    tomorrow=0;

    constructor(){
        this.inicializandoVariables();
    }
    async inicializandoVariables(){
        this.defaults= await this.getDef();
        this.listaPrecios = await this.obteniendoListasDefault(this.id_default);
        this.AllListas = await this.obteniendoListas(this.id_default);
        this.listName= await this.listAllNames();
        this.tc_opc= await this.obteniendoTc();
        this.parametros= await this.obteniendoParametros();
       // this.pintandoWarnings();
      
    };

    async getDef() {
        let me= this;
        let lista= []
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "GET",
                async: false,
                data: {'accion':'getDef'},

                success: function(response, textStatus, jqXHR){
                    if (response.data)
                    me.id_default = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        return lista;
    }
    async obteniendoListasDefault(id_list=1) {
        let lista= []
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'getListDef',id_list},

                success: function(response, textStatus, jqXHR){
                    lista = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

            return lista;
    }
    async obteniendoListas(id_default) {
        let lista= []
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "GET",
                async: false,
                data: {'accion':'AllListas', id_default},

                success: function(response, textStatus, jqXHR){
                    lista = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        return lista;
    }

    async obteniendoTc() {
        let lista= []
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "GET",
                async: false,
                data: {'accion':'ObteniendoTc'},

                success: function(response, textStatus, jqXHR){
                    if (response.data)
                    lista = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        return lista;
    }
    buscarProducto(event){
        let busqueda=$(event.target).val().toUpperCase();
        $('.alert').remove();
        if(!busqueda.length) {
            $('#def_body tr').show();
            $('#precios_rows tr').show();
            return;
        }
        $('#def_body tr').hide();
        $('#precios_rows tr').hide();
        $('#def_body th.producto').each(function(){
           if($(this).text().toUpperCase().includes(busqueda)){
            let producto_general_id= $(this).data('producto_general_id');
            $(`#def_body tr[data-producto_general_id='${producto_general_id}']`).show();
            $(`#precios_rows tr[data-producto_general_id='${producto_general_id}']`).show();
            }
        });
        if($('#def_body tr:visible').length===0){
            $('#def_body tr').show();
            $('#precios_rows tr').show();
            let alerta= $(`<div class="alert alert-danger" role="alert">No hay productos que mostrar</div>`);
           $('div.actions_tables').append(alerta);
           setTimeout(() => {
            alerta.animate({opacity: 0}, 1000);
           }, 3000);
           $('#buscador').val('');
        }
    }
    cleanProducto(){
        $('#def_body tr').show();
        $('#precios_rows tr').show();
        $('#buscador').val('');
    }
    async obteniendoParametros() {
        let lista= []
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "GET",
                async: false,
                data: {'accion':'getParametros'},

                success: function(response, textStatus, jqXHR){
                    if (response.data)
                    lista = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        return lista;
    }


    async listAllNames() {
        let lista= []
        let me= this;
        await $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "GET",
                async: false,
                data: {'accion':'AllListasNames'},

                success: function(response, textStatus, jqXHR){
                    if(!response.status){
                        setAlerta('alerta-danger', response.message);
                        return;
                    }
                    lista = response.data;
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        return lista;
    }
    copyVersionList(id_list, nameList){
        $('.ui-dialog-titlebar-close:visible').trigger('click');
        let me= this;
        let fecha_list= $('tr#title_list').find(`th[data-list='${id_list}']`).find('span').last().text().trim();
        let fecha_hoy= obteniendoFechaHoy();

        fecha_list= new Date(fecha_list);
        console.log('fecha_list', fecha_list);
        fecha_list= fecha_list.setDate(fecha_list.getDate() + 2);
        console.log('fecha_list', fecha_list);
        fecha_list= new Date(fecha_list);
        fecha_hoy= new Date(fecha_hoy);

        
        console.log('fecha_list', fecha_list);
        console.log('fecha_hoy', fecha_hoy);

        let fecha_minima= fecha_list > fecha_hoy ? fecha_list : fecha_hoy;

        $("BODY").append(
            `<div id='versionListDialog' class='jqgridcolssorter_dialog'>
              <div class="font-bold mb-2"> Crea una nueva version de la lista "${nameList}"</div>
              <div class="nota_warn">Nota: Al crear una nueva version de esta lista, "${nameList}" ya no estará disponible, la nueva lista usará la fecha de vigencia de "${nameList}" como fecha inicial será reemplazada por la nueva lista que se cree, tomando las tiendas que tiene asignadas para reasignarlas a la nueva lista</div>
                <div style="display: flex;justify-content: space-between;align-items: center;padding:5px 10px;gap:5px;" >
                    <label for="new_name">Asignale un nuevo nombre</label>
                    <input class="input-custum date_list" id="new_name" type="text">
                </div>
                <div style="display: flex;justify-content: space-between;align-items: center;padding:5px 10px;gap:5px;">
                    <label for="new_fecha_fin">Fecha de vigencia</label>
                    <input class="input-custum date_list" id="new_fecha_fin" type="text">
                </div>
            </div>`
        );
      
        $("#versionListDialog").dialog({
            title:  `Crea una nueva version de una lista`,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    id: "botonGuardarColor",
                    click: function() {
                        if(!$('#new_name').val().length || !$('#new_fecha_fin').datepicker('getDate')){
                            setAlerta('alerta-danger', 'Todos los campos son obligatorios');
                            return;
                        }
                        me.generandoVersionList(id_list, nameList);
                    }
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                        $("#versionListDialog").remove();
                    }
                },
            ],
            close: function() {
                $("#versionListDialog").remove();
            },
        });
         $("#new_fecha_fin").datepicker({
            minDate: fecha_minima,
         });
    }
    generandoVersionList(id_list, nameList){
        let me= this;


        let fecha_fin= $('#new_fecha_fin').datepicker('getDate');
        fecha_fin= formmat_fecha(fecha_fin);
        let new_name= $('#new_name').val();
        let id_default= parseInt($('#listas-caption').data('n-list')) + 1;
        $.ajax({
            url: "../../backoffice/ajax/saveList.php",
            cache: false,
            type: "post",
            async: false,
            data: {'accion':'generandoVersionList','listId': id_list, fecha_fin, new_name, id_default},

            success: function(response, textStatus, jqXHR){
                if(!response.status){
                    setAlerta('alerta-danger', response.message);
                    return;
                }
                me.generandoVistaVersion(id_list, nameList);

                $("#versionListDialog").remove();
            },
            error: function (xhr, ajaxOptions, thrownError){
                console.log('xhr', xhr);
                console.log('ajaxOptions', ajaxOptions);
                console.log('thrownError', thrownError);
            }
        });

    }
    generandoVistaVersion(id_list, nameList){
        let me = this;
        let encabezado= $('tr#title_list').find(`th[data-list='${id_list}']`)
        let es_default= encabezado.find('span.es_default');
        let fecha_antes= encabezado.find('span').last().text();
        let new_default= parseInt($('#listas-caption').data('n-list')) + 1;
        let new_name= $('#new_name').val();
        let fecha_fin= $('#fecha_fin').val();

        let th_precio= `<th class="border-left" id="precio_${new_default}">Precio <i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSort(event, '${new_default}')"></i></th>`
        let th_moneda= `<th id="moneda_${new_default}">Moneda <i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortMoneda(event, '${new_default}')"></i></th>`
        let th_tc=`<th id="tc_tipo_${new_default}">TC <i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortTC(event, '${new_default}')"></i></th>`
        let th_pesos=`<th class="border-rigth" style="min-width: 90px;" id="precio_pesos_${new_default}">Pesos <i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortMXN(event, '${new_default}')"></i></th>`

        let act_precio= $(`th#precio_${id_list}`);
        let act_moneda= $(`th#moneda_${id_list}`);
        let act_tc= $(`th#tc_tipo_${id_list}`);
        let act_pesos= $(`th#precio_pesos_${id_list}`);

        if (es_default.length && id_list==me.id_default) {
            console.log('es default');
            let new_encabezado= `<th style="height: 80.25px;" class="border-left border-rigth" colspan="4" data-list="${id_list}">
                                <span id="listaName_${new_default}" class="encabezado_list">${new_name} <span class="es_default">(Default)</span></span>
                                                <i class="fa-solid fa-share copy_price" title="Copiar precios a una lista" onclick="Liprecios.copyPriceList('${id_list}', '${new_name}')"></i>
                                                <i class="fa-solid fa-file-import send_price" title="Copiar precios de una lista" onclick="Liprecios.sendPriceList('${id_list}', '${new_name}')"></i>
                                <i class="fa-solid fa-broom-wide version_list" title="Haz un reset a esta lista" onclick="Liprecios.resetList('${id_list}', '${new_name}')"></i>
                                <div id="listaTiendas${new_default}" class="fs-7">SV, UG, SIM </div>
                                    <div class="formmat_fecha"> Fecha de inicio: <span>${fecha_antes}</span>, Fecha de vigencia: <span>${fecha_fin} </span> </div>
                            </th>`;
            encabezado.replaceWith(new_encabezado);
            act_precio.replaceWith(th_precio);
            act_moneda.replaceWith(th_moneda);
            act_tc.replaceWith(th_tc);
            act_pesos.replaceWith(th_pesos);
            me.inserRows(new_default, new_name, fecha_fin,id_list, true);
            me.id_default= new_default;
         
        }else{
            console.log('no es default');
            let new_encabezado= `<th style="height: 80.25px;" class="border-left border-rigth" colspan="4" data-list="${new_default}">
                                    <span id="listaName_${new_default}" class="encabezado_list">${new_name} <i onclick="delete_list(${new_default},'${new_name}')" title="Borrar Lista: ${new_name}" class="fa-solid fa-trash delete-list" style="color: #ffffff;"></i></span>
                                    <div onclick="Liprecios.creadoClasificador('${new_default}','${new_name}' )" class="btn_abs" title="asigna tiendas"><i class=" fa-solid fa-bags-shopping"></i></div>                <i class="fa-solid fa-share copy_price" title="Copiar precios a una lista" onclick="Liprecios.copyPriceList('${new_default}', '${new_name}')"></i> <i class="fa-solid fa-file-import send_price" title="Copiar precios de una lista" onclick="Liprecios.sendPriceList('${new_default}', '${new_name}')"></i>
                                    <i class="fa-solid fa-broom-wide version_list" title="Haz un reset a esta lista" onclick="Liprecios.resetList('${id_list}', '${new_name}')"></i>
                                    <div id="listaTiendas${new_default}" class="fs-7">OFI, CH, AL </div>
                                        <div class="formmat_fecha"> Fecha de inicio: <span>2023-09-29</span>, Fecha de vigencia: <span>2023-09-25</span> </div>
                                </th>`
            encabezado.remove();
            act_precio.remove();
            act_moneda.remove();
            act_tc.remove();
            act_pesos.remove();

            $('.head_info').before(new_encabezado);
            $('.head_producto').before(th_precio);
            $('.head_producto').before(th_moneda);
            $('.head_producto').before(th_tc);
            $('.head_producto').before(th_pesos);

            $("#table_listas").animate({ scrollLeft: $('.head_info').position().left }, "slow");
            me.inserRows(new_default, new_name, fecha_fin, id_list);
            
        }
    }
    inserRows(new_default, new_name, fecha_fin, id_list,es_default=false){
       let me= this;
       let tr_replace= $(`#table_listas tbody tr`);
       tr_replace.each(function () {
        let th_replace= $(this).find(`td[data-list='${id_list}']`);
        let row = `
            <td data-list="{LID}"><input data-list="{LID}" type='text' onfocus="setFocusClass(event)"  onkeydown="direccionandoEnter(event, 'precio_list_{LID}')" onblur="isNumberKey(event, 'precio')" id='precio_{PID}_{LID}' name='precio_{PID}_{LID}' value='{PANT}' type='text' class='notSelectize w-120 txt_rigth precio_list precio_list_{LID} input-custum'>
            <td data-list="{LID}"><select data-list="{LID}" onfocus="setFocusClass(event)"  onchange="selectDivisa(event)"  id='moneda_{PID}_{LID}' name='moneda_{PID}_{LID}'  class='notSelectize moneda moneda_list_{LID}' onkeydown="direccionandoEnter(event, 'moneda_list_{LID}')">
            <option value="1" {SUSD}>USD</option>
            <option value="2" {SMX}>Pesos</option>
            </select>
        <td data-list="{LID}"><select onfocus="setFocusClass(event)"  onchange="selectCambioTC(event)" data-list="{LID}" id='tcforma_{PID}_{LID}' name='tcforma_{PID}_{LID}' class='{TCT_NONE} forma_list_{LID} forma_tc notSelectize' onkeydown="direccionandoEnter(event, 'forma_list_{LID}')">
            {TCOPC}
            </select>
            <div class="mxn_moneda_{LID} {TC_MXN} txt_center">-</div>
                <td data-list="{LID}"><div data-list="{LID}" id='mxn_{PID}_{LID}' style="width: 80px;" class='txt_rigth mxn_list_{LID}' name='tc_{PID}_{LID}'>{MXN}</div></td>
        `;

        let $tr = $(this);
        let producto_general_id = $tr.data('producto_general_id');
        let moneda= $(`#moneda_${producto_general_id}_${id_list}`).val();
        let tct= moneda==='2' ? 'none' : '';
        let tcmx= moneda==='2' ? '' : 'none';
        let tc= $(`#tcforma_${producto_general_id}_${id_list}`).val();
        let act_none= tc==='Actual' && moneda==='1' ? '' : 'none';
        let tc_actual= $(`#tc_${producto_general_id}_${id_list}`).parent().find(`.actual_${id_list}`).text();
        let tc_na= moneda==='1' ? 'none' : '';
        let fijo_tc= tc==='Actual' || moneda==='2' ? 'none' : '';
        let fijo= $(`#tc_${producto_general_id}_${id_list}`).val();
        let mxn= $(`#mxn_${producto_general_id}_${id_list}`).text();
        let susd= moneda==='1' ? 'selected' : '';
        let smx= moneda==='2' ? 'selected' : '';

        let opc_new= '';
        Liprecios.tc_opc.forEach(element => {
            let selected= element.id===tc ? 'selected' : '';
            opc_new+=  ` <option value="${element.id}" ${selected}>${element.nombre}</option>`
          });

          
        let pant =$(`#precio_${producto_general_id}_${id_list}`).val();
        let tct_row= row.replaceAll('{PID}', producto_general_id).replaceAll('{LID}', new_default).replaceAll('{PANT}', pant).replaceAll('{TCT_NONE}', tct).replaceAll('{TC_MXN}', tcmx)
        .replaceAll('{TC_NONE}',act_none).replaceAll('{TC_ACT}', tc_actual).replaceAll('{TC_NA}', tc_na).replaceAll('{FIJO_TC}', fijo_tc).replaceAll('{FIJO}', fijo).replaceAll('{MXN}', mxn)
        .replaceAll('{SUSD}', susd).replaceAll('{SMX}', smx).replaceAll('{TCOPC}', opc_new);

       th_replace.remove()
       if(es_default)
         $tr.prepend(tct_row);
        else
         $tr.find('.productos_table').last().before(tct_row);

       });
     
      // me.pintandoWarnings();
    }
   async creadoClasificador(id_list, liName='Default'){
    console.log('id_list rdesr', id_list);
    let me= this;
        let array_def= this.listaPrecios;
        let opciones= [];
        let tiendas_def= await this.obteniendoListasDefault(id_list);
        this.tiendas_list= tiendas_def;
        array_def.forEach(element => {
            let new_opc= {...element, activo:'No'}
            opciones.push(new_opc);
        });
        tiendas_def.forEach(element => {
            let new_opc= {...element, activo:'Si'}
            opciones.push(new_opc);
        });
        $('.ui-dialog-titlebar-close:visible').trigger('click');
        // let instance = new ProductoGeneralUtil()
         $("#asignaTiendaDialog").remove();
         $("BODY").append(
             `<div id='asignaTiendaDialog' class='jqgridcolssorter_dialog'>
                 <div>
                     <div id='asignaTiendaDialog_clasificame'></div>
                 </div>
             </div>`
         );


         let clasificame = $(`#asignaTiendaDialog`).clasificame({
            'clasificacion': [
                {clasificaId:'Si', label:'Si', title:'Si',},
                {clasificaId:'No', label:'No', title: 'No'},
            ],
            valueId: 'tienda_id',
            valueDisplay: 'tienda',
            valueColumnKey: 'activo',
            values: opciones,
            title: `Asigna Tiendas a ${liName}`,
            label_sort:'Tiendas',
            editable:true,
            resumen:"Nota: Para que una tienda apareza en la lista, debe estar activa en la lista default de tiendas",
        });
        $('#select_grupos').parent().parent().hide();

        $("#asignaTiendaDialog").dialog({
            title:  `Asigna Tiendas a ${liName}`,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    class: 'none',
                    id: "botonGuardarColor",
                    click: function() {
                        console.log("boton dentro de dialogo");
                    }
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],
            close: function() {
                $("#asignaTiendaDialog").remove();
            },
        });

        let boton=$(`<button type="button" id="btnColoresGuardar" class="ui-button ui-corner-all ui-widget "><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`).insertAfter("#botonGuardarColor")

        boton.on('click', function(e){
            me.updtList(id_list, clasificame.clasificame("value"));
        })
    }
    subiendoServ(id_list, id_prod, mxn=null){
        const precio= $(`#precio_${id_prod}_${id_list}`).autoNumeric('get') ;
        const parsearPrecio= parseFloat(precio).toFixed(5);
        if(precio==='' || precio===0) return;
        const moneda= $(`#moneda_${id_prod}_${id_list}`).val();
        const tc_tipo= $(`#tcforma_${id_prod}_${id_list}`).val();
        if(this.tomorrow===1 && !$(`#precio_${id_prod}_${id_list}`).parent().hasClass('tomorrow_price')){
           this.setTomorrowJs(id_prod, id_list);
        }
        

        this.actualizandoRegistro(id_prod, id_list, parsearPrecio, moneda, tc_tipo, mxn);
     }

     actualizandoRegistro(id_prod, id_list, precio, moneda, tc_tipo, mxn){
        let id_tomorrow= this.tomorrow;

        $.ajax({
            url: "../../backoffice/ajax/saveList.php",
            cache: false,
            type: "post",
            async: false,
            data: {'accion':'updtRegistro',id_prod, id_list, precio, moneda, tc_tipo, mxn, id_tomorrow},

            success: function(response, textStatus, jqXHR){
                console.log('response', response);
                if(!response.status){
                    setAlerta('alerta-danger', response.message);
                    return;
                }
                console.log('response', response);
            },
            error: function (xhr, ajaxOptions, thrownError){
                console.log('xhr', xhr);
                console.log('ajaxOptions', ajaxOptions);
                console.log('thrownError', thrownError);
            }
        });
     }

    async updtList(id_list, tiendas){
        let me= this;
        let id_default= this.id_default;
        let join_tiendas= tiendas['Si'].join(',');
        let tiendas_no =tiendas['No'].join(',');
        let array_def= await me.obteniendoListasDefault(me.id_default);
        let array_list= await me.obteniendoListasDefault(id_list);
     $.ajax({
         url: "../../backoffice/ajax/saveList.php",
         cache: false,
         type: "post",
         async: false,
         data: {'accion':'updtList',id_list, 'tiendas':join_tiendas ?? [], tiendas_no: tiendas_no ?? [], id_default},

         success: function(response, textStatus, jqXHR){
            if(!response.status){
                setAlerta('alerta-danger', 'hubo un error al actualizar la lista');
                return;
            }
    
    
            let tienas_si =tiendas['Si'];

             array_def= array_def.concat(array_list);
            let tiendas_def=$(`#listaTiendas${id_default}`).text().replaceAll(', ', ',');
            tiendas_def= tiendas_def.split(',');
            let clavesACT= [];
            let clavesNO= [];
            let elementos_act= [];
            array_def.forEach(element => {
                let {clave, tienda_id}= element;
                if(tienas_si.indexOf(parseInt(tienda_id))===-1){
                    elementos_act.push(element);
                    clavesNO.push(clave);
                }else{
                    clavesACT.push(clave);
                }
            })
    
            setAlerta('alerta-success', 'Lista actualizada correctamente');
                let clavesACT_str= clavesACT.join(',');
                
                let clavesNO_str= clavesNO.join(',');
                me.listaPrecios= elementos_act;
                $(`#listaTiendas${id_default}`).text(clavesNO_str)
                $(`#listaTiendas${id_list}`).text(clavesACT_str)
                $(`#listaTiendas${id_list}`).find('.sin_tiendas').remove();

         },
         error: function (xhr, ajaxOptions, thrownError){
             console.log('xhr', xhr);
             console.log('ajaxOptions', ajaxOptions);
             console.log('thrownError', thrownError);
         }
     });


    }
    async borrandoList(id_list, name){
        let me= this;
        let id_default= this.id_default
        $.ajax({
            url: "../../backoffice/ajax/saveList.php",
            cache: false,
            type: "post",
            async: false,
            data: {'accion':'deleteList','listId': id_list, 'listName':name,'listDef': id_default},

            success: function(response, textStatus, jqXHR){
                console.log('response', response);

                let txt_ant=$(`#listaTiendas${id_list}`).text();
                let txt_def=$(`#listaTiendas1`).text();

                let new_txt= txt_def;
                if(!txt_ant.includes('No tiene tiendas asignadas'))
                    new_txt= `${txt_def}, ${txt_ant}`;
                $(`#listaTiendas1`).text(new_txt);

                $(`th[data-list='${id_list}']`).remove();
                $(`td[data-list='${id_list}']`).remove();
                $(`th#precio_${id_list}`).remove();
                $(`th#moneda_${id_list}`).remove();
                $(`th#tc_tipo_${id_list}`).remove();
                $(`th#tc_${id_list}`).remove();
                $(`th#precio_pesos_${id_list}`).remove();

                me.listaPrecios= response.listaDef;

            },
            error: function (xhr, ajaxOptions, thrownError){
                console.log('xhr', xhr);
                console.log('ajaxOptions', ajaxOptions);
                console.log('thrownError', thrownError);
            }
        });
       }
       asignadoValoresListas(listas, id_list, nameList, me, btn_guardar){
        let rows_obj= [];
            $("#precios_rows").children("TR").each(function () {
                let obj_row= {};
               let producto_general_id= $(this).data('producto_general_id');
               listas.forEach(element => {
                let style= $(`#precio_${producto_general_id}_${id_list}`).attr('style');
                let precio_aprobar=$(`#precio_${producto_general_id}_${id_list}`).parent().find('.aprobar');
                if(precio_aprobar.length) {
                    let aprobar= $(`<i class="fa-solid fa-shield-check aprobar" title="Este precio necesita aprobación" onclick="setEnterado(event, ${element}, '${producto_general_id}')"></i>`)
                    $(`#precio_${producto_general_id}_${element}`).parent().find('.aprobar').remove()
                    $(`#precio_${producto_general_id}_${element}`).parent().append(aprobar);
                }
                else $(`#precio_${producto_general_id}_${element}`).parent().find('.aprobar').remove();
            
                $(this).find(`#precio_${producto_general_id}_${element}`).val($(`#precio_${producto_general_id}_${id_list}`).val()).removeAttr('style').attr('style', style);
                $(this).find(`#moneda_${producto_general_id}_${element}`).val($(`#moneda_${producto_general_id}_${id_list}`).val());
                $(this).find(`#mxn_${producto_general_id}_${element}`).text($(`#mxn_${producto_general_id}_${id_list}`).text());
                
               
                if($(`#moneda_${producto_general_id}_${id_list}`).val()==="2"){
                    $(this).find(`.mxn_moneda_${element}`).show();
                    $(this).find(`.mxn_tc_${element}`).show();
                    $(this).find(`.actual_${element}`).hide();
                    $(this).find(`.tc_list_${element}`).hide();
                    $(this).find(`#tcforma_${producto_general_id}_${element}`).hide();
                    $(this).find(`#tc_${producto_general_id}_${element}`).hide();
                    let mxn_val=$(`#precio_${producto_general_id}_${id_list}`).val()
                    $(this).find(`#mxn_${producto_general_id}_${element}`).text(mxn_val);
                }else{
                    $(this).find(`#tcforma_${producto_general_id}_${element}`).show();
                    $(this).find(`#tc_${producto_general_id}_${element}`).show();
                    $(this).find(`.mxn_moneda_${element}`).hide();
                    $(this).find(`.mxn_tc_${element}`).hide();
                    $(this).find(`#tcforma_${producto_general_id}_${element}`).val($(`#tcforma_${producto_general_id}_${id_list}`).val())
                    

                }
                let spack= $(this).find(`#mxn_${producto_general_id}_${id_list}`).find('.mxn_manual')
                if(spack.length){
                    $(this).find(`#mxn_${producto_general_id}_${element}`).find('.mxn_manual').remove();
                   let icono = $('<i class="fa-solid fa-hand-sparkles mxn_manual" onclick="Liprecios.deleteManual(event)" title="Este precio fue puesto a mano"></i>')
                    $(this).find(`#mxn_${producto_general_id}_${element}`).append(icono);
                }
                
              
               });
               
               let spack= $(this).find(`#mxn_${producto_general_id}_${id_list}`).find('.mxn_manual')
               let mxn_val= spack.length ? $(`#mxn_${producto_general_id}_${id_list}`).text() : null;
               
               obj_row= {
                   precio: $(`#precio_${producto_general_id}_${id_list}`).autoNumeric('get'),
                   producto_general_id,
                   moneda: $(`#moneda_${producto_general_id}_${id_list}`).val(),
                   tx_modo: $(`#tcforma_${producto_general_id}_${id_list}`).val(),
                   pesos: mxn_val
               }
                rows_obj.push(obj_row);
                //console.log('rows_obj', obj_row);
               
            })

            Liprecios.pintadoAlerts(listas)
            me.setServValoresListas(rows_obj, listas, id_list, btn_guardar);
            
        }
        pintadoAlerts(listas){
            listas.forEach(element => {
              let inputs=$(`.notificado_No[value='0.00'][data-list='${element}']`);

              inputs.each(function(){

              })
            })
        }

        setEditarTD(event){
            let me= this;
            let id_list= $(event.target).data('list');
            let id_prod= $(event.target).closest("tr").data('producto_general_id');
            console.log('id_prod', $(event.target).closest("tr"));
            me.producto_general_id= id_prod;
            let td= $(event.target);
            let price= $(event.target).find('div');
            me.transicion= price.text();
            let spack= $(event.target).find('.mxn_manual');
            let manual= spack.length ? true : false;

            let input= $(`<input type="text" class="notSelectize w-120 txt_rigth pesos_list pesos_list_${id_list}" data-list="${id_list}"  id="pesos_${id_prod}_${id_list}" value="${$(event.target).text()}">`);
            td.html(input);
            input.focus();
            input.autoNumeric('init', {aSep: ',', aDec: '.', mDec: '2', vMin: '0.00', vMax: '999999999.99'});
            input.on('blur', function(e){
                me.returnInput(e, price,manual , me);
            });
        }
        returnInput(event, price, manual, me){
            if($(event.target).val()===me.transicion || $(event.target).val()===''){
                me.setModeVista(price, event.target, me);
                return;
            }
 
            let value= $(event.target).autoNumeric('get');
            let floatValue= parseFloat(value);
            me.temporal_mxn= floatValue;
            let id_list= $(event.target).data('list');
            let id_prod= me.producto_general_id;

            let moneda= $(`#moneda_${id_prod}_${id_list}`).val();
             if(moneda==='2'){
                $(`#precio_${id_prod}_${id_list}`).val(me.temporal_mxn.toFixed(5));
                 me.setModeVista(price, event.target, me)
                 let icono= $('<i class="fa-solid fa-hand-sparkles mxn_manual" onclick="Liprecios.deleteManual(event)" title="Este precio fue puesto a mano"></i>');
                 $(`#mxn_${id_prod}_${id_list}`).text(me.temporal_mxn.toFixed(2)).append(icono);
                 me.temporal_mxn= 0;
             }else{
                let tc= $(`#tcforma_${id_prod}_${id_list}`).val();
                let tc_value= $('.encabezado_tc').find(`input[data-tc='${tc}']`).autoNumeric('get');
                //calculando dolares
                let dolares= me.temporal_mxn / tc_value;
                dolares= dolares.toFixed(5);

                me.setModeVista(price, event.target, me)
                $(`#precio_${id_prod}_${id_list}`).val(dolares);

                let icono= $('<i class="fa-solid fa-hand-sparkles mxn_manual" onclick="Liprecios.deleteManual(event)" title="Este precio fue puesto a mano"></i>');
                $(`#mxn_${id_prod}_${id_list}`).text(me.temporal_mxn.toFixed(2)).append(icono);
                me.temporal_mxn= 0;

             }
             $(`#precio_${id_prod}_${id_list}`).prop('style', '').removeAttr('title');
             $(`#precio_${id_prod}_${id_list}`).parent().find('.aprobar').remove();
             console.log('me.temporal_mxn', $(`#precio_${id_prod}_${id_list}`));

             paintCostList($(`#precio_${id_prod}_${id_list}`),me.producto_general_id, id_list);
             me.producto_general_id= '';
             this.subiendoServ(id_list, id_prod, $(`#mxn_${id_prod}_${id_list}`).text());
             $('.mxn_manual').tooltip();
        }
        setModeVista(price, event_target, me){
           $(event_target).parent().html(price);
           me.transicion= '';
           
        }
        setServValoresListas(rows_obj, listas, id_list, btn_guardar){
            
            let explodeListas= listas.join("','");
            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'CopyList','listId': id_list, 'listas':explodeListas, 'productos':  rows_obj},
        
                success: function(response, textStatus, jqXHR){
                    if(!response.status){
                        setAlerta('alerta-danger', response.message);
                        return;
                    }
                    setAlerta('alerta-success', 'Listas actualizadas correctamente');
                    $(btn_guardar).prop('disabled', false).css('cursor', 'default');
                        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });
           
           
        }
       async copyPriceList(id_list, nameList){
        await this.trayerListasPrecios(id_list);
        let me= this;

        
        $('#dialogoListaPrecios').remove();
        $("BODY").append(
            `<div id='asignaDialog' class='jqgridcolssorter_dialog'>
                <div>
                    <div id='asignaListDialog_clasificame'></div>
                </div>
            </div>`
        );
        let clasificame = $(`#asignaListDialog_clasificame`).clasificame({
            'clasificacion': [
                {clasificaId:'Si', label:`Si`, title:`Copiar precios de ${nameList} a:`,},
                {clasificaId:'No', label:'No', title: 'Quedarse igual'},
            ],
            valueId: 'lista_precios_id',
            valueDisplay: 'nombre',
            valueColumnKey: 'activo',
            values: me.AllListasSelected,
            title: `Copia los valores de ${nameList} a:`,
            label_sort:'Listas',
            editable:true,
        });

        $("#asignaDialog").dialog({
            title:  `Copia valores de una lista a otra`,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    class: 'none',
                    id: "botonGuardarColor",
                    click: function() {
                        console.log("boton dentro de dialogo");
                    }
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],
            close: function() {
                $("#asignaDialog").remove();
            },
        });
        $('#select_grupos').parent().parent().remove();

        let boton=$(`<button type="button" id="btnColoresGuardar" class="ui-button ui-corner-all ui-widget "><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`).insertAfter("#botonGuardarColor")

        boton.on('click', function(e){
           let valuesAsignar=clasificame.clasificame("value");
           if(!valuesAsignar['Si'].length) {
            setAlerta('alerta-warning', 'Debe seleccionar al menos una lista')
            return;
           };
           $(e.target).prop('disabled', true).css('cursor', 'wait');
        
           me.asignadoValoresListas(valuesAsignar['Si'], id_list, nameList, me, e.target);
        })
       }
         async trayerListasPrecios(id_list){
            let me= this;
            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'FilterList','listId': id_list},
        
                success: function(response, textStatus, jqXHR){
                    if(!response.status){
                        ia.alertError(response.message, "Hubo un error", true)
                        return;
                    }
                    if (response.data.length===0) {
                        ia.alertError("No se encontraron registros", "Error", true)
                        return;
                    }
                   me.AllListasSelected= response.data;
                        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });
        }
       async AllListasFind(){
            let listas=[];
          await  $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'findListas'},
        
                success: function(response, textStatus, jqXHR){
                    if(!response.status){
                        ia.alertError(response.message, "Hubo un error al obtener las listas", true)
                        return;
                    }
                    listas= response.data;
                    
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

            return listas;
        }

         updtTC(id) {
            let me = this;
            let tc_val = $(`.tc_forma[data-tc="${id}"]`).autoNumeric('get');

            //const parametros= this.pintandoWarnings();


            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'setTCDinamico',id, tc: tc_val},
        
                success: function(response, textStatus, jqXHR){
                    if(!response.status){
                        ia.alertError(response.message, "Hubo un error", true)
                        return;
                    }
                    
                    
                    let option_select=$(`.forma_tc option[value="${id}"]:selected`).parent();
                    option_select.each(function () {
                    
                    const dataList= $(this).data('list');
                    const id_prod= $(this).parent().parent().data('producto_general_id');
                    
                    let precio= $(`#precio_${id_prod}_${dataList}`).autoNumeric('get');
                    let moneda= $(`#moneda_${id_prod}_${dataList}`).val();
                    if(moneda==='1'){
                        let manual= $(`#mxn_${id_prod}_${dataList}`).find('.mxn_manual');
                        if(manual.length){
                            let mxn_val= $(`#mxn_${id_prod}_${dataList}`).text();
                            let tc_change= parseFloat(mxn_val) / parseFloat(tc_val);
                            tc_change= tc_change.toFixed(5);
                            $(`#precio_${id_prod}_${dataList}`).val(tc_change);

                            me.updtTCPrice(id_prod, dataList, tc_change, mxn_val);
                            return;
                        }
                        $(`#mxn_${id_prod}_${dataList}`).text(parseFloat(precio*tc_val).toFixed(2));
                    }
        
                });
                        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        }
        updtTCPrice(id_prod, id_list, tc_change, mxn_val){
            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'setTCPrice',id_prod, id_list, tc_change, mxn_val},
        
                success: function(response, textStatus, jqXHR){
                    console.log('response', response);
                    if(!response.status){
                        ia.alertError(response.message, "Hubo un error", true)
                        return;
                    }
                        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        }
        async sendPriceList(id_list, listName){
        await this.trayerListasPrecios(id_list);
           let me= this;
           let listas= this.AllListasSelected;
           let options= '';
           console.log('listas', listas);
           listas.forEach(element => {
               options+= `<option value="${element.lista_precios_id}">${element.nombre}</option>`
           });
           let modal =`
              <div id="dialogoListaPrecios" title="Copiar precios de una lista"> 
                <p class="font-bold">Copiar precios de una lista</p>
                <p class="nota_warn"style="margin-bottom: 10px;">Todos los valores de la lista "${listName}" serán reemplazados por los valores de la lista que seleccione</p>
                <div class="d-flex">
                        <label for="tiendas_send">Listas disponibles</label>
                        <select id="tiendas_send" class="notSelectize">
                            <option value="">Seleccione una opcion</option>
                            ${options}
                        </select>
                    </div>
                </div>
           `;
              $('body').append(modal);
              


                $('#dialogoListaPrecios').dialog({
                    title: '¡Atención!',
                    autoOpen: true,
                    width: 500,
                    buttons:[
                        {
                            text: "Copiar",
                            icon: "ui-icon-transfer-e-w",
                            click: function() {
            
                              let select_list=  $('#tiendas_send');
                              if (!select_list.val()) {
                                  setAlerta('alerta-warning', 'Debe seleccionar una lista');
                                  return;
                              }
                              $(this).prop('disabled', true).css('cursor', 'wait');
                              Liprecios.asignadoValoresListas([id_list], select_list.val(), listName, me, $(this));
            
                            }
                        },
                        {
                            text: "Cancelar",
                            icon: "ui-icon-cancel",
                            click: function() {
                                $('#dialogoListaPrecios').dialog( "close" );
                            }
                        }
            
                    ],
                    close: function() {
                        $("#dialogoListaPrecios").remove();
                    },
                });
        }
        pintandoWarnings(){
            const puntos_warning_abajo= parseFloat(this.parametros.puntos_warning_abajo) / 100;
            const puntos_warning_arriba= parseFloat(this.parametros.puntos_warning_arriba) / 100;
            const puntos_limite_abajo= parseFloat(this.parametros.puntos_limite_abajo) / 100;
            const puntos_limite_arriba= parseFloat(this.parametros.puntos_limite_arriba) / 100;

            let limite_warning_abajo= parseFloat($(`.tc_forma[data-tc="1"]`).autoNumeric('get'))-puntos_warning_abajo;
            let limite_warning_arriba= parseFloat($(`.tc_forma[data-tc="1"]`).autoNumeric('get'))+puntos_warning_arriba;
            let limite_abajo= parseFloat($(`.tc_forma[data-tc="1"]`).autoNumeric('get'))-parseFloat(puntos_limite_abajo);
            let limite_arriba= parseFloat($(`.tc_forma[data-tc="1"]`).autoNumeric('get'))+parseFloat(puntos_limite_arriba);

            limite_warning_abajo= limite_warning_abajo.toFixed(4);
            limite_warning_arriba= limite_warning_arriba.toFixed(4);
            limite_abajo= limite_abajo.toFixed(4);
            limite_arriba= limite_arriba.toFixed(4);

             $('.tc_forma:visible').each(function () {
                if($(this).autoNumeric('get') < limite_abajo || $(this).autoNumeric('get') > limite_arriba){
                    
                    $(this).prop('title', '');
                    $(this).prop('style', '').css('width', '100px');
                    $(this).css('color', 'rgb(199 0 0)');
                    $(this).css('font-weight', 'bold');
                    $(this).css('border', '2px solid rgb(199 0 0)');
                    $(this).prop('title', 'El TC esta fuera del rango de limite, favor de revisar');
                    $(this).tooltip();
                  
                   
                }else if($(this).autoNumeric('get') < limite_warning_abajo || $(this).autoNumeric('get') > limite_warning_arriba){
                    $(this).prop('title', '');
                    $(this).prop('style', '').css('width', '100px');
                    $(this).css('color', 'rgb(199 149 0)');
                    $(this).css('font-weight', 'bold');
                    $(this).css('border', '2px solid #ad9800');
                    $(this).prop('title', 'El TC esta fuera del rango de advertencia');
                    $(this).tooltip();
                }
                else{
                    $(this).prop('title', '');
                    $(this).prop('style', '').css('width', '100px');
                    $(this).tooltip();
                    $(this).tooltip('destroy');
                }

             });


            return {limite_warning_abajo, limite_warning_arriba, limite_abajo, limite_arriba};
        }
        sortPrecioASC(e, id_list){
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
           

            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                let findA= $(a).find('.precio_list_'+id_list).val().length ? $(a).find('.precio_list_'+id_list).autoNumeric('get'): -1;
                let findB= $(b).find('.precio_list_'+id_list).val().length ? $(b).find('.precio_list_'+id_list).autoNumeric('get'): -1;
                var precioA =  parseFloat(findA);
                var precioB = parseFloat(findB);

                return precioB - precioA;
            });

            // Vuelve a agregar las filas ordenadas a la tabla
            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        sortPrecioDESC(e, id_list){
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
           

            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                 let findA= $(a).find('.precio_list_'+id_list).val().length ? $(a).find('.precio_list_'+id_list).autoNumeric('get'): -1;
                let findB= $(b).find('.precio_list_'+id_list).val().length ? $(b).find('.precio_list_'+id_list).autoNumeric('get'): -1;
                var precioA =  parseFloat(findA);
                var precioB = parseFloat(findB);

                return precioA - precioB;
            });

            // Vuelve a agregar las filas ordenadas a la tabla
            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        sortMonedaASC(e, id_list){
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var precioA = parseInt($(a).find('.moneda_list_'+id_list).val());
                var precioB = parseInt($(b).find('.moneda_list_'+id_list).val());
                return precioB - precioA;
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        sortMonedaDESC(e, id_list){
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var precioA = parseInt($(a).find('.moneda_list_'+id_list).val());
                var precioB = parseInt($(b).find('.moneda_list_'+id_list).val());
                return precioA - precioB;
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        sortTCASC(e, id_list) {
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var formaListA = $(a).find('.forma_list_' + id_list);
                var formaListB = $(b).find('.forma_list_' + id_list);
                
                var precioA = formaListA.is(':visible') ? parseFloat(formaListA.val()) : 0;
                var precioB = formaListB.is(':visible') ? parseFloat(formaListB.val()) : 0;

                return precioB - precioA;
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }            
        }
        sortTCDESC(e, id_list) {
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var formaListA = $(a).find('.forma_list_' + id_list);
                var formaListB = $(b).find('.forma_list_' + id_list);
                
                var precioA = formaListA.is(':visible') ? parseFloat(formaListA.val()) : 0;
                var precioB = formaListB.is(':visible') ? parseFloat(formaListB.val()) : 0;

                return precioA - precioB;
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }            
        }
        sortMxnASC(e, id_list) {
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var precioA = parseFloat($(a).find('.mxn_list_' + id_list).text().replaceAll(',', ''));
                var precioB = parseFloat($(b).find('.mxn_list_' + id_list).text().replaceAll(',', ''));

                return precioB - precioA;

                
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        sortMxnDESC(e, id_list) {
            // Obtén todas las filas de la tabla y las convierte en un array
            var rows = $('#table_listas tbody tr').toArray();
            var rows_producto = $('#table_productos tbody');
            // Ordena las filas en función del valor de precio (de mayor a menor)
            rows.sort(function(a, b) {
                var precioA = parseFloat($(a).find('.mxn_list_' + id_list).text().replaceAll(',', ''));
                var precioB = parseFloat($(b).find('.mxn_list_' + id_list).text().replaceAll(',', ''));

                console.log('precioA', precioA);
                return precioA - precioB;
            });

            for (var i = 0; i < rows.length; i++) {
                let sortkey= rows[i].dataset.producto_general_id;
                ;
                rows_producto.find(`tr[data-producto_general_id="${sortkey}"]`).remove().appendTo(rows_producto);
                $('#table_listas tbody').append(rows[i]);
            }
        }
        setRead_only(event){
            $('i').hide();
            $('button').hide();
            $('.btn_abs').hide();
            $('.fs-7').hide();
            $(event.target).hide();
            $('.edit_mode').show();
            $('.formmat_fecha').hide();
            $('.encabezado_tc').hide();
            $('.china').parent().hide();
            $('#td_china').hide();
            $('#td_death').hide();
            $('#td_unidades').hide();
            $('.colores_saldo').hide();
            $('.unidades').hide();
            $('.precio_list').parent().hide();
            $('.moneda').parent().hide();
            $('.forma_tc').parent().hide();
            $('th[id^="precio"]').hide();
            $('th[id^="moneda"]').hide();
            $('th[id^="tc_tipo"]').hide();
            $('th[id^="precio_pesos"]').show();
            $('div[id^="listaTiendas"]').show();
            $('div[id^="mxn_"]').css('width', '200px');
            $('input[name="direccional"]').hide();
            
            $('th').prop('colspan', 1);
        }
        setEditarMode(event) {
            console.log('event', event);
            $('i').show();
            $('button').show();
            $('.btn_abs').show();
            $('.fs-7').show();
            $('.formmat_fecha').show();
            $(event.target).hide();
            $('#td_unidades').show();
            $('.colores_saldo').show();
            $('.edit_mode').hide();
            $('.encabezado_tc').show();
            $('.china').parent().show();
            $('.unidades').show();
            $('.precio_list').parent().show();
            $('.moneda').parent().show();
            $('.forma_tc').parent().show();
            $('div[id^="mxn_"]').css('width', '100px');
            $('input[name="direccional"]').show();
            $('th').prop('colspan', 4);
            $('#table_productos th').first().prop('colspan', 4);
            $('th[id^="precio"]').show().prop('colspan', 1);
            $('th[id^="moneda"]').show().prop('colspan', 1);
            $('th[id^="tc_tipo"]').show().prop('colspan', 1);
            $('th[id^="precio_pesos"]').prop('colspan', 1);
            $('div[id^="listaTiendas"]').show();
            $('#precios_header1 th').show().prop('colspan', 1);
            $('.producto').prop('colspan', 1);

            if(!$('#table_productos').find('th[id^="precio"]').length){
                $('.fa-anchor-lock').show();
                $('.fa-anchor-circle-xmark').hide();
            }else{
                $('.fa-anchor-lock').hide();
                $('.fa-anchor-circle-xmark').show();
            }
        }
        deleteManual(event){
            let td_near= $(event.target).closest("td")
            let list= td_near.data('list');
            let tr_near = $(event.target).closest("tr");
            let id_prod= tr_near.data('producto_general_id');
            let me= this;
            let tomorrow= this.tomorrow;

            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'deleteManual','listId': list, 'id_prod': id_prod, 'tomorrow': tomorrow},
        
                success: function(response, textStatus, jqXHR){
                   if(!response.status){
                       ia.alertError(response.message, "Hubo un error al actualizar el precio", true)
                       return;
                   }
                   $(event.target).remove();
        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });
           

        }
        resetList(id_list, listName){
            let me= this;
            $('#dialogoReset').remove();
  

            let dialogoReset= $(`<div>
            <p style="margin: 10px 0"><span class='ui-icon ui-icon-alert' style='float:left; margin:0 7px 20px 0;'></span>¿Esta seguro de querer borrar los valores de <span class="font-bold">"${listName}"</span>?.</p>
            </div>`, {id: 'dialogoReset', title: 'Resetear lista de precios'}).css({
                "display": "flex",
                "flex-direction": "column",
                "justify-content": "center",
                "align-items": "center",
            });

            $('body').append(dialogoReset);

            dialogoReset.dialog({
                autoOpen: true,
                width: 500,
                title: 'Resetear lista de precios',
                buttons:[
                    {
                        text: "Resetear",
                        icon: "ui-icon-refresh",
                        click: function() {
                            me.applyResetList(id_list, listName);
                           // dialogoReset.dialog( "close" );
                        }
                    },
                    {
                        text: "Cancelar",
                        icon: "ui-icon-cancel",
                        click: function() {
                            $(this).remove();
                        }
                    }
                ],
                close: function() {
                    $(this).remove();
                },
            });

        }
        applyResetList(id_list, listName){
            let me= this;
            
            $.ajax({
                url: "../../backoffice/ajax/saveList.php",
                cache: false,
                type: "post",
                async: false,
                data: {'accion':'setResetList','listId': id_list},
        
                success: function(response, textStatus, jqXHR){
                   if(!response.status){
                       ia.alertError(response.message, "Hubo un error al actualizar el precio", true)
                       return;
                   }
                   $(`.precio_list_${id_list}`).val('').autoNumeric('update').attr('style', '');
                   $(`.precio_list_${id_list}`).parent().find('i').remove();
                   $('.moneda_list_'+id_list).val('1');
                   $(`.mxn_moneda_${id_list}`).hide();
                   $(`.forma_list_${id_list}`).val(2);
                   $(`.forma_list_${id_list}:hidden`).show();
                   $('.mxn_list_'+id_list).html('0.00');
        
                },
                error: function (xhr, ajaxOptions, thrownError){
                    console.log('xhr', xhr);
                    console.log('ajaxOptions', ajaxOptions);
                    console.log('thrownError', thrownError);
                }
            });

        }
        setTomorrow(event){
            $('#alert_m').remove();
           if(this.tomorrow===1){
                this.tomorrow=0;
                $(event.target).removeClass('toggle-on').addClass('toggle-off').removeAttr('title').prop('title','Programar precios para mañana');
                this.hideTomorrowPrices();
           }else{
                this.tomorrow=1;
                let fecha= new Date();
                let fecha_manana= new Date(fecha.setDate(fecha.getDate() + 1));
                fecha_manana= formmat_fecha(fecha_manana);
                $(event.target).removeClass('toggle-off').addClass('toggle-on').removeAttr('title').prop('title','Programar precios para hoy');
                let alert_m=$(`<div id="alert_m" class="alert-warning-fix">Los precios ingresados desde ahora tendrán "${fecha_manana}" como fecha de inicio, al modificar un precio que ya es de mañana no afectarán al de hoy </div>`);
                $('#table_listas caption').append(alert_m);
                this.showTomorrowPrices();
            }

           
        }
        showTomorrowPrices(){
            let me = this;
            let dataPrices= $(`input[data-price]`);
            dataPrices.each(function () {
                let price_tomorrow= $(this).data('price');
                let price_actual= $(this).autoNumeric('get');
                if(price_tomorrow){
                    let set_data= price_actual;
                    let id_list= $(this).parent().data('list');
                    let id_prod= $(this).parent().parent().data('producto_general_id');
                    set_data= set_data.length ? set_data : '-1';
                    
                    $(this).data('price', set_data);
                

                    $(this).val(price_tomorrow).autoNumeric('update');
                    $(this).parent().addClass('tomorrow_price')
                    $('tr[data-producto_general_id="'+id_prod+'"]').find(`td[data-list="${id_list}"]`).addClass('tomorrow_price')

                    let mensaje= price_actual.length ? 'el precio de hoy es de: $'+price_actual : 'el precio de hoy no ha sido asignado';
                    $(this).parent().prop('title', 'Se esta mostrando el precio que estará vigente a partir de mañana, '+mensaje);
                    $(this).parent().tooltip();

                    me.setTomorrowValues(id_prod, id_list);
                }

               
            })
        }
        setTomorrowValues(id_prod, id_list){
            //set values tc forma
            let tc_forma= $(`#tcforma_${id_prod}_${id_list}`);
            let tc_tomorrow= tc_forma.parent().data('tc');
            if(tc_forma.is(':visible')){
                tc_forma.parent().data('tc', tc_forma.val());
                tc_forma.val(tc_tomorrow)
            }

            //set values mxn
            let mxn= $(`#mxn_${id_prod}_${id_list}`);
            let mxn_tomorrow= mxn.parent().data('pesos');

            let icono=$(`#mxn_${id_prod}_${id_list}`).find('i')
         
            let mxn_val= icono.length ? mxn.text() : -1;
            $(`#mxn_${id_prod}_${id_list}`).parent().data('pesos', mxn_val);

            if(mxn_tomorrow!== -1){
               $(`#mxn_${id_prod}_${id_list}`).text(mxn_tomorrow)
               let icono= $('<i class="fa-solid fa-hand-sparkles mxn_manual" onclick="Liprecios.deleteManual(event)" title="Este precio fue puesto a mano"></i>');
                $(`#mxn_${id_prod}_${id_list}`).append(icono);
                icono.tooltip();
            }else{
                $(`#mxn_${id_prod}_${id_list}`).find('i').remove();
            }
            

            let moneda= $(`#moneda_${id_prod}_${id_list}`);
            let dataMoneda= moneda.parent().data('moneda');
            let moneda_val= moneda.val();

            if(dataMoneda){
                moneda.parent().data('moneda', moneda_val);
                moneda.parent().addClass('tomorrow_price');
                moneda.val(dataMoneda);
                if(dataMoneda==2){
                    $(`#tcforma_${id_prod}_${id_list}`).hide();
                    $(`#tcforma_${id_prod}_${id_list}`).parent().find(`.mxn_moneda_${id_list}`).show();
                    if(mxn_tomorrow== -1){
                        let precio= parseFloat($(`#precio_${id_prod}_${id_list}`).autoNumeric('get'));
                        $(`#mxn_${id_prod}_${id_list}`).text((precio).toFixed(2));
                    }
                }else{
                    $(`#tcforma_${id_prod}_${id_list}`).show();
                    $(`#tcforma_${id_prod}_${id_list}`).parent().find(`.mxn_moneda_${id_list}`).hide();
                    if(mxn_tomorrow== -1){
                        let precio= parseFloat($(`#precio_${id_prod}_${id_list}`).autoNumeric('get'));
                        let tc= $(`#tcforma_${id_prod}_${id_list}`).val();

                        //calculando precio en mxn
                        let tc_cambio= parseFloat($('.encabezado_tc').find(`.tc_forma[data-tc="${tc}"]`).autoNumeric('get'));

                        let precio_mxn= precio * tc_cambio;
                        $(`#mxn_${id_prod}_${id_list}`).text((precio_mxn).toFixed(2));
                    }
                }
            }
            
        }
        hideTomorrowPrices(){
            let me = this;
            let dataPrices= $(`input[data-price]`);
            dataPrices.each(function () {
                let price_actual= $(this).data('price');
                let price_tomorrow= $(this).autoNumeric('get');
                let id_list= $(this).parent().data('list');
                let id_prod= $(this).closest('tr').data('producto_general_id');
                if(price_actual){
                    price_actual= price_actual =='-1' ?  null : price_actual;
                    $(this).val(price_actual).autoNumeric('update');
                    $(this).parent().removeClass('tomorrow_price');
                    

                    $(this).data('price', price_tomorrow);
                }

                me.setTomorrowValues(id_prod, id_list);
                me.setOriginalValues(id_prod, id_list);
            })
        }
        setOriginalValues(id_prod, id_list){
            $(`#precio_${id_prod}_${id_list}`).parent().removeClass('tomorrow_price').attr('title', '').tooltip('destroy');
            $(`#moneda_${id_prod}_${id_list}`).parent().removeClass('tomorrow_price').attr('title', '');
            $(`#tcforma_${id_prod}_${id_list}`).parent().removeClass('tomorrow_price').attr('title', '');
            $(`#mxn_${id_prod}_${id_list}`).parent().removeClass('tomorrow_price').attr('title', '');
        }
        setTomorrowJs(id_prod, id_list){
          let precio= !ListPast.precio ? '-1' : ListPast.precio;
            $(`#precio_${id_prod}_${id_list}`)
                .attr('data-price', precio)
                .parent().addClass('tomorrow_price').attr('title','Se esta mostrando el precio que estará vigente a partir de mañana, el precio de hoy es de: $'+ListPast.precio).tooltip();
            $(`#moneda_${id_prod}_${id_list}`).parent().data('moneda', ListPast.moneda).addClass('tomorrow_price');
            $(`#tcforma_${id_prod}_${id_list}`).parent().data('tc', Liprecios.tc).addClass('tomorrow_price');
            $(`#mxn_${id_prod}_${id_list}`).parent().data('pesos', ListPast.mxn ?? '-1').addClass('tomorrow_price');
            
        }
      
}


let Liprecios = new CrudListaPrecios();
let listaPrecios = {
    init:function() {
        listaPrecios.add('1', 'Base, default');
        disparandoEvts();
        sincronizarscroll();
        $('i').tooltip()
        $('input[title]').tooltip()
        $('.colores_saldo').tooltip()

        // $('.moneda').on('change', selectDivisa)
    },
    add: async function(listaId, listaName)
        {
            

            let dialogo_list;
            let body_dialogo_list;
            $('#dialogoListaPrecios').remove();
            if (listaId==='1')
            console.log('listaId', listaId);
                // addListaPrecios(listaId, listaName);


            else{
                let AllListas= await Liprecios.AllListasFind();

                let opc_listas= '';
                AllListas.forEach(element => {
                    opc_listas+= `<option value="${element.lista_precios_id}">${element.nombre}</option>`
                })
                let form_list = $(`<form>
                                    <p class="font-bold">Crea una nueva lista</p>
                                    <div>
                                        <label>Elija un nombre para su lista</label> 
                                        <input class="input-custum" type="text" id="listName">
                                    </div>
                                    <div>
                                        <label>Copiar de la lista</label> 
                                        <select id="listas_copy" class="notSelectize">
                                            <option value="">Seleccione una opcion</option>
                                            ${opc_listas}
                                        </select>
                                    </div>
                            </form>`, {id: 'formListaPrecios'}).css({
                                    "display": "flex",
                                    "flex-direction": "column",
                                    "justify-content": "space-evenly",
                                    "align-items": "center",
                                   "height": 160
                            });

              dialogo_list= $('<div></div>', {id: 'dialogoListaPrecios', title: 'Agregar lista de precios'});
                body_dialogo_list = $('<div></div>', {id: 'body_dialogo_list'}).css({
                    "display": "flex",
                    "flex-direction": "column",
                    "justify-content": "center",
                    "align-items": "center",
                });

                dialogo_list.append(form_list);
                dialogo_list.append(body_dialogo_list);
                dialogo_list.dialog({
                    autoOpen: true,
                    width: 500,
                    height: 280,
                    buttons:[
                        {
                            text: "Agregar",
                            icon: "ui-icon-plus",
                            click: function() {
                                if($('#listName').val()===''){
                                    setAlerta('alerta-warning', 'Debe ingresar un nombre para la lista');
                                    return;
                                }
                                if(!$('#listas_copy').val() || $('#listas_copy').val()===''){
                                    setAlerta('alerta-warning', 'Debe ingresar fechas de inicio y de vigencia');
                                    return;
                                }

                                addListaPrecios(listaId, $('#listName').val(), false, false, $('#listas_copy').val());
                                dialogo_list.dialog( "close" );
                            }
                        },
                        {
                            text: "Cancelar",
                            icon: "ui-icon-cancel",
                            click: function() {
                                dialogo_list.dialog( "close" );
                            }
                        }

                    ]
                });
               


            }
        }


}
function ValidandoFecha(event) {
    let fecha_minima= $(event.target).val();

    $('#fecha_fin').datepicker('option','minDate', fecha_minima).prop('disabled', false).removeClass('disabled');
    // console.log('fecha_minima', fecha_minima);
}
function formmat_fecha(fecha) {
    let fechaActual = new Date(fecha);

    // Obtener el año, mes y día de la fecha actual.
    var año = fechaActual.getFullYear();
    var mes = fechaActual.getMonth() + 1; // Los meses comienzan en 0 (enero es 0), así que sumamos 1.
    var dia = fechaActual.getDate();

    // Formatear la fecha en un formato legible, por ejemplo, "YYYY-MM-DD".
    var fechaFormateada = año + "-" + (mes < 10 ? "0" : "") + mes + "-" + (dia < 10 ? "0" : "") + dia;

    return fechaFormateada;
}

function obteniendoFechaHoy() {
    // Crear una instancia del objeto Date, que representa la fecha y hora actuales.
var fechaActual = new Date();

// Obtener el año, mes y día de la fecha actual.
var año = fechaActual.getFullYear();
var mes = fechaActual.getMonth() + 1; // Los meses comienzan en 0 (enero es 0), así que sumamos 1.
var dia = fechaActual.getDate();

// Formatear la fecha en un formato legible, por ejemplo, "YYYY-MM-DD".
var fechaFormateada = año + "-" + (mes < 10 ? "0" : "") + mes + "-" + (dia < 10 ? "0" : "") + dia;

return fechaFormateada;
}

function selectCambioTC(event){
    let target= $(event.target);
    calculandoTC(target.data('list'),get_idproducto(event.target),target.val())
}
function selectDivisa(event){
    const id_moneda= $(event.target).val();
    const td_actual= $(event.target).parent().parent();
    const lista=$(event.target).data('list');
    const id_prod= get_idproducto(event.target);
    if(id_moneda==='2'){
        $(`#tcforma_${id_prod}_${lista}`).hide();
        td_actual.find(`.mxn_moneda_${lista}`).show();
        td_actual.find(`.mxn_tc_${lista}`).show();
        td_actual.find(`.actual_${lista}`).hide();
        td_actual.find(`.tc_list_${lista}`).hide();
        td_actual.find(`#tc_${id_prod}_${lista}`).hide();
        let mxn_val=$(`#precio_${id_prod}_${lista}`).val()
        $(`#mxn_${id_prod}_${lista}`).text(mxn_val);
        Liprecios.subiendoServ(lista, id_prod);
        return;
    }else{
        $(`#tcforma_${id_prod}_${lista}`).show();
        td_actual.find(`.mxn_moneda_${lista}`).hide();
        td_actual.find(`.mxn_tc_${lista}`).hide();
    }

    calculandoTC(lista,id_prod)
}
function init_autoNumeric(){
    if(jQuery().autoNumeric){
        $('.precio_list').autoNumeric('init', {aSep: ',', aDec: '.', mDec: '5', vMin:0,vMax:999999999});
        $('.mxp-list').autoNumeric('init', {aSep: ',', aDec: '.', mDec: '2', vMin:0,vMax:999999999});
        $('.tc_forma').autoNumeric('init', {aSep: ',', aDec: '.', mDec: '6', vMin:0,vMax:999999999});
    }
}
function disparandoEvts(){
    init_autoNumeric()
}

function get_idproducto(element){
    return $(element).parent().parent().data('producto_general_id');
}
function sincronizarscroll() {
    const $div1 = $('#table_listas');
    const $div2 = $('#table_productos');

    $div1.on('scroll', function() {
      $div2.scrollTop($div1.scrollTop());
    });

    $div2.on('scroll', function() {
        $div1.scrollTop($div2.scrollTop());
    });
}
function setAlerta(alerta, msj) {
        let background= alerta==='alerta-success' ? 'rgb(228 255 223)' : 'rgb(255 202 202)';
        let color= alerta==='alerta-success' ? '#125e00' : '#c33232';

    $('#alerta_list').remove();
    let alertaDiv = $("<div></div>", { id: "alerta_list" }).css({
        "position": "absolute",
        "top": "0px",
        "left": "0px",
        "background-color": background,
        "max-width": "180px",
        "padding": "5px",
        "font-size": "12px",
        "font-weight": "bold",
        "color": color,
        "border-radius": "5px",
        "border-left": `5px solid ${color}`,
    });
    alertaDiv.addClass(alerta);
    alertaDiv.html(msj);
    alertaDiv.show();
   $div_sialogo= $('div.ui-dialog-buttonpane').css('position', 'relative');
    $div_sialogo.append(alertaDiv);
    setTimeout(function () {
        alertaDiv.hide();
    }, 5000);
 }
async function addListaPrecios(listaId, listaName, is_first_list=false, prepend=false, copy=1) {
    let conteo_encabezados = !is_first_list && !prepend ? parseInt($('#listas-caption').data('n-list')) : Liprecios.id_default;
     if(!is_first_list && !prepend) conteo_encabezados++ ;

    let id_default= Liprecios.id_default;

    const txt_TiendasDef= $('#listaTiendas'+id_default).text();
    const txt_default= $('#listaTiendas'+id_default).parent().find('.es_default');

    let div_def= txt_default.length && (prepend || is_first_list) ? `<span class="es_default">(Default)</span>` : '';

    let btn_actions_list= `<div id='listaTiendas${id_default}' >${txt_TiendasDef}</div>
            `;
    if(!is_first_list && !prepend){
      btn_actions_list= `
        <i onclick="delete_list(${conteo_encabezados},'${listaName}')" title="Borrar Lista: ${listaName}" class="fa-solid fa-trash delete-list" style="color: #ffffff;"></i>
            <div class="btn_abs" title="asigna tiendas"><i <div onclick="Liprecios.creadoClasificador(${conteo_encabezados},'${listaName}')" class=" fa-solid fa-bags-shopping"></i></div>
            <div class="listaTiendas" id='listaTiendas${conteo_encabezados}'><span class="sin_tiendas fs-7"><i class="fa-solid fa-circle-exclamation"></i> (No tiene tiendas asignadas)</span></div>
        `
    }
    if(prepend || is_first_list){
        btn_actions_list+=`<i class="fa-solid fa-broom-wide version_list" title="Haz un reset a esta lista" onclick="Liprecios.resetList('${id_default}', '${listaName}')"></i>`
    }else if(!prepend && !is_first_list){
        btn_actions_list+=`<i class="fa-solid fa-broom-wide version_list" title="Haz un reset a esta lista" onclick="Liprecios.resetList('${conteo_encabezados}', '${listaName}')"></i>`
    }
    let header1 = `<th colspan='4' data-list="${conteo_encabezados}">
        <span id='listaName${conteo_encabezados}'>${listaName} ${div_def}</span>
        <i class="fa-solid fa-share copy_price" title="Copiar precios a una lista" onclick="Liprecios.copyPriceList('${conteo_encabezados}','${listaName}')"></i>
        <i class="fa-solid fa-file-import send_price" title="Copiar precios de una lista" onclick="Liprecios.sendPriceList('${conteo_encabezados}','${listaName}')"></i>
        ${btn_actions_list}
            `
      

    let row_head= !is_first_list ? $("#title_list") : $("#list_head");
    if(prepend) row_head.prepend(header1);
    else if(!prepend && !is_first_list) $('.head_info').before(header1);
    else row_head.append(header1);


    let sortPrecio= (!is_first_list) ? `<i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSort(event, '${conteo_encabezados}')" </i>` : '';
    let sortMoneda= (!is_first_list) ? `<i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortMoneda(event, '${conteo_encabezados}')" </i>` : '';
    let sortTC= (!is_first_list) ? `<i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortTC(event, '${conteo_encabezados}')" </i>` : '';
    let sortMXN= (!is_first_list) ? `<i class="fa-solid fa-circle-sort sort_table" onclick="llamandoSortMXN(event, '${conteo_encabezados}')" </i>` : '';

    let header2 = `<th id='precio_${conteo_encabezados}'>Precio ${sortPrecio}
            <th id='moneda_${conteo_encabezados}'>Moneda  ${sortMoneda} 
            <th id='tc_tipo_${conteo_encabezados}'>tc  ${sortTC} 
            <th id='precio_pesos_${conteo_encabezados}'>Pesos  ${sortMXN}
    `;
    let headerAppend= !is_first_list ? $("#header2") : $("#precios_header1");

    if(prepend) headerAppend.prepend(header2);
    else if(!prepend && !is_first_list) $('.head_producto').before(header2);
    else  $('#precios_header1').append(header2);

    let row = `
        <td data-list="{LID}"><input data-list="{LID}" type='text' onfocus="setFocusClass(event)"  {TITLE}  onkeydown="direccionandoEnter(event, 'precio_list_{LID}')" onblur="isNumberKey(event, 'precio')" id='precio_{PID}_{LID}' {STYLE} name='precio_{PID}_{LID}' value='{PANT}' type='text' class='notSelectize w-120 precio_list precio_list_{LID} input-custum'> {ICON_APROBADO}
        <td data-list="{LID}"><select data-list="{LID}" onfocus="setFocusClass(event)"  onchange="selectDivisa(event)"  id='moneda_{PID}_{LID}' name='moneda_{PID}_{LID}'  class='notSelectize moneda moneda_list_{LID}' onkeydown="direccionandoEnter(event, 'moneda_list_{LID}')">
        <option value="1" {SUSD}>USD</option>
        <option value="2" {SMX}>Pesos</option>
        </select>
    <td data-list="{LID}"><select onfocus="setFocusClass(event)"  onchange="selectCambioTC(event)" data-list="{LID}" id='tcforma_{PID}_{LID}' name='tcforma_{PID}_{LID}' class='{TCT_NONE} forma_list_{LID} forma_tc notSelectize' onkeydown="direccionandoEnter(event, 'forma_list_{LID}')">
        {TCOPC}
        </select>
        <div class="mxn_moneda_{LID} {TC_MXN} txt_center">-</div>
            <td data-list="{LID}" style="position: relative;"><div data-list="{LID}" id='mxn_{PID}_{LID}' style="width: 80px;" class='txt_rigth mxn_list_{LID}' name='tc_{PID}_{LID}'>{MXN} {HAND}</div></td>
    `;
    const array_rows=[];
    let obj_row={}

    $("#precios_rows").children("TR").each(function () {
        let opc_new='';
        let $tr = $(this);
        let producto_general_id = $tr.data('producto_general_id');
        let precio_style= $(`#precio_${producto_general_id}_${copy}`).attr('style');
        let title_precio= $(`#precio_${producto_general_id}_${copy}`).attr('title');
        let precio_icon= $(`#precio_${producto_general_id}_${copy}`).parent().find('i').length ? `<i class="fa-solid fa-shield-check aprobar" title="Este precio necesita aprobación" onclick="setEnterado(event, ${conteo_encabezados}, '${producto_general_id}')"></i>` : '';
        let moneda= $(`#moneda_${producto_general_id}_${copy}`).val();
        let tct= moneda==='2' ? 'none' : '';
        let tcmx= moneda==='2' ? '' : 'none';
        let tc= $(`#tcforma_${producto_general_id}_${copy}`).val();
        let act_none= tc==='Actual' && moneda==='1' ? '' : 'none';
        let tc_actual= $(`#tc_${producto_general_id}_${copy}`).parent().find(`.actual_${copy}`).text();
        let tc_na= moneda==='1' ? 'none' : '';
        let fijo_tc= tc==='Actual' || moneda==='2' ? 'none' : '';
        let fijo= $(`#tc_${producto_general_id}_${copy}`).val();
        let mxn= $(`#mxn_${producto_general_id}_${copy}`).text();
        let susd= moneda==='1' ? 'selected' : '';
        let smx= moneda==='2' ? 'selected' : '';
        let icon_mxn= $(`#mxn_${producto_general_id}_${copy}`).find('i').length ? `<i class="fa-solid fa-hand-sparkles mxn_manual" onclick="Liprecios.deleteManual(event)" title="Este precio fue puesto a mano"></i>` : '';
        let pesos= $(`#mxn_${producto_general_id}_${copy}`).find('i').length ? $(`#mxn_${producto_general_id}_${copy}`).text() : null;

        const style_add= precio_style===undefined ? '' : `style="${precio_style}"`;
        const title_add= title_precio===undefined ? '' : `title="${title_precio}"`;

        Liprecios.tc_opc.forEach(element => {
            let selected= element.id===tc ? 'selected' : '';
            opc_new+=  ` <option value="${element.id}" ${selected}>${element.nombre}</option>`
          });


        obj_row= {
            precio: $(`#precio_${producto_general_id}_${copy}`).val(),
            producto_general_id,
            moneda,
            tx_modo: tc,
            pesos
        }


        array_rows.push(obj_row);

        let pant =$(`#precio_${producto_general_id}_${copy}`).val();
        tct_row= row.replaceAll('{PID}', producto_general_id).replaceAll('{LID}', conteo_encabezados).replaceAll('{PANT}', pant).replaceAll('{TCT_NONE}', tct).replaceAll('{TC_MXN}', tcmx)
        .replaceAll('{TC_NONE}',act_none).replaceAll('{TC_ACT}', tc_actual).replaceAll('{TC_NA}', tc_na).replaceAll('{FIJO_TC}', fijo_tc).replaceAll('{FIJO}', fijo).replaceAll('{MXN}', mxn)
        .replaceAll('{SUSD}', susd).replaceAll('{SMX}', smx).replaceAll('{TCOPC}', opc_new).replaceAll('{STYLE}', style_add).replaceAll('{ICON_APROBADO}', precio_icon).replaceAll('{TITLE}', title_add)
        .replaceAll('{HAND}', icon_mxn);
        if(!is_first_list && !prepend){
            $tr.find('.productos_table').before(tct_row);
        }
        else if(prepend)
            $('#precios_rows').find('TR[data-producto_general_id="'+producto_general_id+'"]').prepend(tct_row);
        else
        {
           $('#def_body').find('TR[data-producto_general_id="'+producto_general_id+'"]').append(tct_row);
        }
        
        

    });
    $('i').tooltip()
    $('input[title]').tooltip()

    if(!is_first_list && !prepend) $('#listas-caption').data('n-list', conteo_encabezados);
    disparandoEvts();
    
    if(!is_first_list) subiendoServ(conteo_encabezados, listaName, array_rows);
    if(is_first_list || prepend) modificandoTables(is_first_list);

}
function modificandoTables(bandera) {
    if(bandera){ 
        $('#anclar_def').hide();
        $('#desanclar_def').show();
    }
    else {
        $('#anclar_def').show();
        $('#desanclar_def').hide();
    }
    let id_default= Liprecios.id_default;
    let table_delete= bandera ? $('#table_listas') : $('#table_productos');
    let table_width= !bandera ? $('#table_listas') : $('#table_productos');
    $(`td[data-list="${id_default}"]`, table_delete).remove();
    $(`#precio_${id_default}`, table_delete).remove();
    $(`#moneda_${id_default}`, table_delete).remove();
    $(`#tc_tipo_${id_default}`, table_delete).remove();
    $(`#tc_${id_default}`, table_delete).remove();
    $(`#precio_pesos_${id_default}`,table_delete).remove();
    $(`th[data-list="${id_default}"]` ,table_delete).remove();
    let setWidth= !bandera ? '75%' : '55%';
    let setOtherWidth= !bandera ?'30%'  : '75%';
    table_width.css('max-width', setWidth);
    table_delete.css('max-width', setOtherWidth);


}

function subiendoServ(listId,ListName, array_rows, fecha_inicio, fecha_fin) {
    if(ListName==='Default') {setAlerta('alerta-warning', 'No se puede modificar la lista Default')
    return;}

    if(Liprecios.listName.indexOf(ListName)!==-1){
        setAlerta('alerta-warning', 'Ya existe una lista con ese nombre');
        return;
    }

    $.ajax({
        url: "../../backoffice/ajax/saveList.php",
        cache: false,
        type: "post",
        async: false,
        data: {'accion':'newList','listId': listId, 'listName':ListName, 'productos':JSON.stringify(array_rows), fecha_inicio, fecha_fin},

        success: function(response, textStatus, jqXHR){
            if(!response.status){
                setAlerta('alerta-danger', response.message);
                return;
            }
            Liprecios.listName.push(ListName);

        },
        error: function (xhr, ajaxOptions, thrownError){
            console.log('xhr', xhr);
            console.log('ajaxOptions', ajaxOptions);
            console.log('thrownError', thrownError);
        }
    });
}

  function calculandoDesdeTc(event){
    let target= $(event.target);
    let parent = get_idproducto(event.target);
    let lista= target.data('list');

    if(target.val()==='') return;
    calculandoTC(lista,parent,'Fijo');
  }

  function direccionandoEnter(event, tipo=null){
    if(event.keyCode===9) {
        moveExcelRigth(event);
    };
    let direccional=$('input[name="direccional"]:checked').val();
    if(event.keyCode!==13 && direccional!=='') return;
        event.preventDefault();
        event.stopPropagation();
        event.stopImmediatePropagation();
        let currentFocus =''
        let elements= direccional=== '1' ? $('.table_tiendas tbody').find("input:visible, select:visible") : $(`.${tipo}:visible`);
       let currentIndex = elements.index($(event.target));
        if (currentIndex !== -1) {
            if (currentIndex + 1 < elements.length) {
                currentFocus=  false;
                elements[currentIndex + 1].focus();
            } else {
                currentFocus=  true;
                elements[0].focus();
            }
            
            if(direccional==='0') moveExcel(event, currentFocus);
            if(direccional==='1') moveExcelRigth(event, currentIndex);

        }
    
    
  }
  function moveExcelRigth(event) {
    let table= $(event.target).parent().parent().parent().parent().parent();
    let currentScrollTop = table.scrollTop();
    let newScrollTop = currentScrollTop+60;
    let elements= $('.table_tiendas tbody').find("input:visible, select:visible");
    let currentIndex = elements.index($(event.target));
    if(currentIndex===elements.length-1) {
        console.log( currentIndex , elements.length-1);
        newScrollTop = 0;
        table.scrollTop(newScrollTop);
    }else{
        let producto_general_id= $(event.target).parent().parent().data('producto_general_id');
        let next_pg= $(elements[currentIndex + 1]).parent().parent().data('producto_general_id');
        if(producto_general_id!==next_pg){
            table.scrollTop(newScrollTop);
        }
    }

    }
  function moveExcel(event, currentFocus) {
    let table= $(event.target).parent().parent().parent().parent().parent();
    let currentScrollTop = table.scrollTop();
    let newScrollTop = currentScrollTop + 60; // 60 píxeles hacia abajo
    if(currentFocus) newScrollTop = 0; // 60 píxeles hacia arriba
    table.scrollTop(newScrollTop);
  }

  function isNumberKey(event,type, fix=2, me=this) {
   if(event.keyCode===13) return;
   if(me.cambios==event.target.value) return;
   if(event.target.value==='') return;
   let price= ($(event.target).autoNumeric('get'));
   


   let producto_general_id = $(event.target).parent().parent().data('producto_general_id');
   const lista=$(event.target).data('list');
    paintCostList(event.target,producto_general_id, lista);


   const get_value = parseFloat(price).toFixed(fix);
    const moneda= $(`#moneda_${producto_general_id}_${lista}`).val();
    if (moneda==='2') {
        $(`#mxn_${producto_general_id}_${lista}`).text(get_value);
    }else{

        let id_tc=$(`#tcforma_${producto_general_id}_${lista}`).val();
        let real_tc= $(`.tc_forma[data-tc="${id_tc}"]`).autoNumeric('get');
        $(`#mxn_${producto_general_id}_${lista}`).text((get_value*parseFloat(real_tc)).toFixed(2));

    }

    
    if(event.target.value==='0.00000')coloreandoInput(event.target);
    Liprecios.subiendoServ(lista, producto_general_id);

  }

  

  function paintCostList(input, producto_general_id, list) {
        let dolar_tr= $('#table_productos').find(`tr[data-producto_general_id="${producto_general_id}"]`).find('p.cost_dolar');
        let dolar_cost= dolar_tr.length ? $(dolar_tr).data('dolar') : 0;
        
        let moneda= $(`#moneda_${producto_general_id}_${list}`).val();
        console.log('entro', producto_general_id);
            if(moneda==='1'){
                let montoIngresado= $(input).autoNumeric('get');
                if(parseFloat(montoIngresado)<parseFloat(dolar_cost)){
                    $(input).css({
                        color: 'rgb(255 107 107)',
                        border: '1px solid rgb(255 107 107)',
                    });
                    $(input).attr('title', 'Esta poniendo un precio menor al costo en dolares');
                    $(input).tooltip();
            } else{
                $(input).css({
                    color: '#000000',
                    border: '1px solid #ced4da',
                });
                $(input).removeAttr('title');
            }
        }
        if(moneda==='2'){
            let tc_actual= $('.tc_forma[data-tc="1"]').autoNumeric('get');
            let costo_mxn= parseFloat(dolar_cost)*parseFloat(tc_actual);

            let montoIngresado= $(input).autoNumeric('get');

            if(parseFloat(montoIngresado)<parseFloat(costo_mxn)){
                $(input).css({
                    color: 'rgb(255 107 107)',
                    border: '1px solid rgb(255 107 107)',
                });
                $(input).attr('title', 'Esta poniendo un precio menor al costo en pesos');
                $(input).tooltip();
            }else{
                $(input).css({
                    color: '#000000',
                    border: '1px solid #ced4da',
                });
                $(input).removeAttr('title');
            }
        }

    }

   
  function coloreandoInput(input){
    const tr= $(input).parent().parent();
    const lista= $(input).data('list');
    const saldo= tr.data('saldo');
    const total= tr.data('total');
    const id_prod= tr.data('producto_general_id');

    if(saldo===total || !$(input).hasClass('notificado_No')) return;

    if(saldo===0){
        $(input).css({
            color: 'rgb(255 107 107)',
            border: '1px solid rgb(255 107 107)',
            width: '45px'
        });
        $(input).attr('title', 'Esta poniendo en cero el precio de un producto que no tiene death stock');
        $(input).tooltip();
    }else{
        $(input).css({
            color: 'rgb(217 180 0)',
            border: '1px solid rgb(217 180 0)',
            width: '45px'
        });
        $(input).attr('title', 'Esta poniendo en cero el precio de un producto que no tiene todos sus colores en death stock');
        $(input).tooltip();
    }
    let icon= $(`<i class="fa-solid fa-shield-check aprobar" title="Este precio necesita aprobación" onclick="setEnterado(event, ${lista}, '${id_prod}')" onclick="setEnterado(${lista})"></i>`);
    $(input).parent().find('.aprobar').remove();
    $(input).parent().append(icon);

    $('.aprobar').tooltip();
  }

 async function setEnterado(event, id_list, id_prod) {
    await $.ajax({
        url: "../../backoffice/ajax/saveList.php",
        cache: false,
        type: "post",
        async: false,
        data: {'accion':'setEnterado',id_list,id_prod},

        success: function(response, textStatus, jqXHR){
           $(event.target).remove();
           $('#precio_'+id_prod+'_'+id_list).prop('style', '').removeClass('notificado_No').removeAttr('title');
        },
        error: function (xhr, ajaxOptions, thrownError){
            console.log('xhr', xhr);
            console.log('ajaxOptions', ajaxOptions);
            console.log('thrownError', thrownError);
        }
    });
  }
   calculandoTC = function (list,id_prod) {

    let price= $(`#precio_${id_prod}_${list}`).val()
    let id_tc=$(`#tcforma_${id_prod}_${list}`).val();
    let real_tc= $(`.tc_forma[data-tc="${id_tc}"]`).autoNumeric('get');
    $(`#mxn_${id_prod}_${list}`).text((price*parseFloat(real_tc)).toFixed(2));

     Liprecios.subiendoServ(list, id_prod);
   }



   function delete_list(id_list, name){

    dialogo_list= $('<div></div>', {id: 'dialogoListaPrecios', title: 'Agregar lista de precios'});
    body_dialogo_list = $(`<div><p class="font-bold"><span class="ui-icon ui-icon-alert" style="float: left; margin-right: 10px;"></span>¿Estas seguro de querer realizar esta accion?</p><p>Esta a punto de borrar la lista de precios: ${name}</p>`, {id: 'body_dialogo_list'}).css({
        "display": "flex",
        "flex-direction": "column",
        "justify-content": "center",
        "align-items": "center",
    });
    dialogo_list.append(body_dialogo_list);
    dialogo_list.dialog({
        title: '¡Atención!',
        autoOpen: true,
        width: 500,
        height: 180,
        buttons:[
            {
                text: "Borrar",
                icon: "ui-icon-trash",
                click: function() {

                    Liprecios.borrandoList(id_list, name);
                    dialogo_list.dialog( "close" );

                }
            },
            {
                text: "Cancelar",
                icon: "ui-icon-cancel",
                click: function() {
                    dialogo_list.dialog( "close" );
                }
            }

        ]
    });

   }
function llamandoSort(event, id_list) {
    


    if ($(event.target).hasClass('fa-circle-sort') || $(event.target).hasClass('fa-circle-sort-down')) {
        activandoIconoASC(event);
        Liprecios.sortPrecioASC(event, id_list);
    }else if($(event.target).hasClass('fa-circle-sort-up')){
        inactivandoIconoDESC(event);
        Liprecios.sortPrecioDESC(event, id_list);

    }
}
function llamandoSortMoneda(event, id_list) {
    if ($(event.target).hasClass('fa-circle-sort') || $(event.target).hasClass('fa-circle-sort-down')) {
        activandoIconoASC(event);
        Liprecios.sortMonedaDESC(event, id_list);
    }else if($(event.target).hasClass('fa-circle-sort-up')){
        inactivandoIconoDESC(event);
        Liprecios.sortMonedaASC(event, id_list);
    }
}

function llamandoSortTC(event, id_list) {
    if ($(event.target).hasClass('fa-circle-sort') || $(event.target).hasClass('fa-circle-sort-down')) {
        activandoIconoASC(event);
        Liprecios.sortTCASC(event, id_list);
    }else if($(event.target).hasClass('fa-circle-sort-up')){
        inactivandoIconoDESC(event);
        Liprecios.sortTCDESC(event, id_list);
    }
}
function llamandoSortMXN(event, id_list) {
    if ($(event.target).hasClass('fa-circle-sort') || $(event.target).hasClass('fa-circle-sort-down')) {
        activandoIconoASC(event);
        Liprecios.sortMxnASC(event, id_list);
    }else if($(event.target).hasClass('fa-circle-sort-up')){
        inactivandoIconoDESC(event);
        Liprecios.sortMxnDESC(event, id_list);
    }
}
function activandoIconoASC(event){
    $('.fa-circle-sort-up').removeClass('fa-circle-sort-up').css('color', '#7c7c7c').addClass('fa-circle-sort');
        $('.fa-circle-sort-down').removeClass('fa-circle-sort-down').css('color', '#7c7c7c').addClass('fa-circle-sort');
        $(event.target).removeClass('fa-circle-sort');
        $(event.target).removeClass('fa-circle-sort-down');
        $(event.target).addClass('fa-circle-sort-up').css('color', '#0073ff');
}
function inactivandoIconoDESC(event) {
       $(event.target).removeClass('fa-circle-sort-up');
        $(event.target).addClass('fa-circle-sort-down').css('color', '#0073ff');
}
function setFocusClass(event, me=this){
    me.cambios= $(event.target).val();
    let id_list= $(event.target).data('list');
    let tr= $(event.target).parent().parent();
    let producto_general_id= tr.data('producto_general_id');
    const tr_tables= $('tr[data-producto_general_id="'+producto_general_id+'"]');
    $('tr').removeClass('focus_table');
    tr_tables.addClass('focus_table');

    if(Liprecios.tomorrow===0) return;
    
    if(!ListPast.id_list || (ListPast.id_list !== id_list && ListPast.id_prod !== producto_general_id)){
    ListPast.id_list= id_list;
    ListPast.id_prod= producto_general_id;
    ListPast.precio= null;
    ListPast.moneda= null;
    ListPast.tc_forma= null;
    ListPast.mxn= null;
    }
        let mxn= $(`#mxn_${producto_general_id}_${id_list}`).find('i').length ? $(`#mxn_${producto_general_id}_${id_list}`).text() : null;

        ListPast.precio= $(`#precio_${producto_general_id}_${id_list}`).autoNumeric('get');
        ListPast.moneda= $(`#moneda_${producto_general_id}_${id_list}`).val();
        ListPast.tc= $(`#tcforma_${producto_general_id}_${id_list}`).val();
        ListPast.mxn= mxn;
    
}



