<?php
/** @noinspection PhpMissingReturnTypeInspection */
// https://github.com/moebiusphp/moebius

use Iac\inc\sql\IacSqlBuilder;
// use JetBrains\PhpStorm\Pure;

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);


/**
 * A case and accent insensitivity, natural sorting -numeric strings and substrings collator and multi key array sort
 */
class Sorter {
    protected Collator $collator;

    public function __construct(string $locale = 'es-MX') { $this->collator = $this->getCollator($locale); }

    /**
     * Array multikeys natural, case and accent, diacritics insensitive
     *  handles numbers and number substrings gracefully.
     *
     * @param array<int|string, array<int|string, string|int|float|bool>> &$arrayToSort
     * @param array<int|string, 'asc'|'desc'> $keys Key1=>asc|desc, Key2=>asc|desc
     * @return array sorted $arrayToSort
     * @example
     *  $sorter = new Sorter();
     *  $data = [
     *      ['name' => 'Carloine', 'age' => 30],
     *      ['name' => 'Bob', 'age' => 30],
     *      ['name' => 'Charlie', 'age' => 35]
     *  ];
     *  $sorter->sort($data, ['age' => 'asc', 'name'=>'asc']);
     */
    public function sort(array &$arrayToSort, array $keys):array {

        $keyed = [];
        foreach($keys as $k => $order)
            $keyed[$k] = $this->collator->compare($order, 'asc') === 0;

        uasort($arrayToSort, function($a, $b) use($keyed){
            foreach($keyed as $k => $order) {
                $result = $order ?
                  $this->collator->compare($a[$k] ?? '', $b[$k] ?? '') :
                  $this->collator->compare($b[$k] ?? '', $a[$k] ?? '');
                if($result)
                    return $result;
            }
            return 0;
        });
        return$arrayToSort;
    }

    /**
     * Natural, case and accent, diacritics insensitive collator and numeric strings or substrings
     * Tip use instead of <=> and strcasecmp: $sorter->collator->compare('si', 'Sí');
     *
     * @param string $locale default "es-MX"
     * @return Collator
     * @example
     *    $collator = Arr::getCollator();
     *    $array = ['a10', 'A9', 'á2', 'Á1'];
     *    $collator->sort($array);
     *    print_r($array);
     *    echo "0=" . $collator->compare("a", "Á");
     */
    public function getCollator(string $locale = 'es-MX'): Collator {
        $collator = new Collator($locale);
        if(null === $collator)
            $collator = new Collator('root');
        $collator->setAttribute(Collator::STRENGTH, Collator::PRIMARY);
        $collator->setAttribute(Collator::CASE_FIRST, Collator::ON);
        $collator->setAttribute(Collator::NUMERIC_COLLATION, Collator::ON);
        return $collator;
    }

}

function snake2Camel($string) {
    if($string === null)
        return "";
    return lcfirst( str_replace('_', '', ucwords(strtolower($string), "_\t\r\n\f\v" )));
}
// document.getElementById("numero").classList.remove("Inactive") .add() .classList.contains("class-name") toggle
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
//  global $gSoyWorker; $gSoyWorker=true;
require_once('../../inc/config.php');
//  echo ia_singleread("SELECT MAX(ultimo_cambio) FROM cliente");
//  ia_errores_a_dime();
// die("<hr>The End</hr>");//

global $gDebugging; $gDebugging = true;
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
if(!usuarioTipoRony()) die("SIN PREMISO");
ignore_user_abort(false);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
?><!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <title>Pepe</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <?php
    global $gIaHeader, $verJS;
    $gIaHeader->html_head_add(['jqgrid', 'ia', 'highlightor', 'multiselect']);
    $gIaHeader->html_head_echo();
    ?>

    <?php echo "<style>" . iaTableIt::getCssClases() . "</style>"; ?>
    <!--suppress CssUnusedSymbol -->
    <style>
        .marmol {background-color:  #e6e4d8}
        BUTTON {cursor:pointer}
    </style>
    <!--suppress CssUnusedSymbol -->
    <style id="tabler_styles">
        TABLE.tabler {border:1px darkblue solid; border-collapse: collapse;box-shadow:darkblue 4px 4px 0 0}
        TABLE.tabler {border:1px darkblue solid; border-collapse: collapse;box-shadow: 3px 3px 0 0 rgba(0, 0, 139, 0.6), 0 2px 2px rgba(0, 0, 139, 0.7)}
        TABLE.tabler CAPTION {border:1px darkblue solid; font-weight: 800; font-size:1.3em }
        TABLE.tabler TD {border:1px darkblue solid; text-align: left; vertical-align: top; padding:0.4em; }
        TABLE.tabler TH {border:1px darkblue solid; text-align: center; vertical-align: middle; padding:0.4em; font-weight: bold;color:#00F}
        TABLE.tabler TD.izq {text-align: left; }
        TABLE.tabler TD.lft {text-align: left;}
        TABLE.tabler TD.cen {text-align: center;}
        TABLE.tabler TD.der {text-align: right; }
        TABLE.tabler TD.rgt {text-align: right; }
        TABLE.tabler TR.totalAbove TD {font-weight: bold;border-bottom: 8px double darkgray!important;}
        TABLE.tabler TR.totalBelow TD {font-weight: bold;border-TOP: 8px double darkgray!important;}

        .laTabla {border-collapse: collapse;border:1px silver solid;margin:1em;width:fit-content}
        .laTabla TH {border:1px silver solid;vertical-align:middle;padding:0.1em 0.3em;}
        .laTabla THEAD TH {border:1px silver solid;vertical-align:middle;padding:0.1em 0.3em;}
        .laTabla TD {border:1px silver solid;vertical-align:top;text-align:left;padding:0.4em 0.3em}
        .laTabla TD.cen {text-align: center}
        .laTabla TD.der {text-align: right}
        .laTabla TD.rgt {text-align: right}
        TABLE.laTabla TH.cmpdiff {color:#0000FF}
        TABLE.laTabla TD.cmpdiff {color:#0000FF}
        TABLE.laTabla TD.negativo {color:red}
        TABLE.laTabla TR.totalAbove TD {font-weight: bold;border-bottom: 8px double darkgray!important;}
        TABLE.laTabla TR.totalBelow TD {font-weight: bold;border-TOP: 8px double darkgray!important;}
        .laTabla_collapseExpand {cursor:pointer;color:green}
        .laTabla_collapseExpand:hover {background-color: whitesmoke}
        .laTabla_collapseAll {cursor:pointer;color:green;font-size:1.2em;border:1px green solid}
        .laTabla_collapseAll:hover {background-color: whitesmoke}
        .laTabla_expandAll {cursor:pointer;color:green;font-size:1.2em;border:1px green solid}
        .laTabla_expandAll:hover {background-color: whitesmoke}
    </style>

    <style>
        .timer-container {
            position: relative;
            width: 32px;
            height: 32px;
            cursor: pointer;
            border: 3px inset cyan;
            border-radius: 32px;
            padding:0;
        }
        .triangle {
            position: absolute;
            top: 0;
            left: 50%;
            width: 0;
            height: 0;
            border-left: 2px solid transparent;
            border-right: 2px solid transparent;
            border-bottom: 16px solid #007bff;
            transform-origin: 50% 100%;
        }
        .dot {
            position: absolute;
            top: 2px;
            left: 50%;
            width: 4px;
            height: 4px;
            background-color: #ff0000;
            border-radius: 50%;
            transform: translateX(-50%);
        }
    </style>
    <style>
       .laTabla TR.total {font-weight: bold;border-top:6px black double}
    </style>
</head>
<body>
<pre class="code">
<?php
require_once 'JqGrider.php';
$j = new JqGrider();
$tda = $j->readTable("tienda");
//echo ToCode::variable("tda", $tda);
?>
</pre>
<style>
    .itButton {cursor:pointer;border-color: lightgrey;border-width:3px ;padding:0.2em;margin:0;}
    .itButtonOff {cursor:pointer;border-style: outset;background-color:whitesmoke;}
    .itButtonOn {cursor:pointer;border-style: inset;background-color: #f0f0f0}
    .itButton:hover {border-style: inset;background-color: #f0f0f0}
</style>
<div class="itollbar" style="width:fit-content; border:1px darkmagenta solid;margin:1em;padding:0.2em; display:flex;flex-direction:row;flex-wrap:wrap;justify-content:start;align-content:flex-start;align-items:start;gap:0.1em">
    <div><i class="fa-thin fa-trash fa-lg itButton itButtonOn" style="color: #800040;"></i></div>
    <div><i class="fa-thin fa-pen itButton itButtonOn" style="color: #0000ff;"></i></div>
    <div><i class="fa-thin fa-pen itButton itButtonOff" style="color: #0000ff;"></i></div>
    <div><i class="fa-thin fa-album-collection-circle-plus itButton itButtonOn" style="color: #8000ff;"></i></div>

    <div><i class="fa-thin fa-snowflak itButtone"></i></div>
</div>  
<div><i class="fa-thin fa-arrows-alt handle itButton itButtonOn"></i></div>

<hr>
<script>
    var colModelT = [
        {name:"Max Min",},
        {name:"Fecha",},
        {name:"Grupo",},
        {name:"Bodega",},
        {name:"Rolls",},
        {name:"Containers",},
        {name:"Qty Mts",},
        {name:"Qty Kg",},
        {name:"Kilos",},
        {name:"El",},
    ];
</script>
<hr>
<?php
    function id2label() {
        $translator['color_id'] = ia_sqlKeyValue("SELECT color_id, color FROM color");
        $translator['producto_general_id'] = ia_sqlKeyValue("SELECT producto_general_id, producto FROM producto_general");
        $translator['bodega_id'] = ia_sqlKeyValue("SELECT bodega_id, bodega FROM bodega");
        $translator['tienda_id'] = ia_sqlKeyValue("SELECT tienda_id, clave FROM tienda");
        $translator['empresa_id'] = ia_sqlKeyValue("SELECT empresa_id, empresa FROM empresa");
        $translator['cliente_id'] = ia_sqlKeyValue("SELECT cliente_id, nombre FROM cliente");
        $translator['origen_id'] = $translator['origen_bodega_id'] = ia_sqlKeyValue("SELECT origen_bodega_id, clave FROM origen_bodega");
        return $translator;
    }
    function hist_get($history) {
        $translator = id2label();

        $out = [];
        foreach($history as $h)
            $out[] = "<div style='border:1px silver solid;padding:0.3em'>$h[date] $h[action]: " . hist_ul(json_decode($h['record'], true), $translator) . "</div>";
        return "<div style='display:flex;flex-direction:row;flex-wrap:wrap;justify-content:flex-start;align-content:flex-start;align-items:start;'>'" .
             implode("\r\n", $out) . "'</div>";
    }
    function hist_ul($data, $translator):string {

        $out = ["<ul style='border-bottom:1px solid silver;'>"];
        ksort($data, SORT_NATURAL | SORT_FLAG_CASE );
        foreach($data as $k => $d) {
            if(is_array($d)) {
                $out[] = "<li>$k<ul>" .  hist_ul($d, $translator) . "</ul>";
                continue;
            }
            if($k !== "" && array_key_exists($k, $translator))
                $out[] = "<li>$k = " . $translator[$k][$d] ?? "¿$d?";
            elseif(!str_ends_with($k, "_id"))
                $out[] = "<li>$k = " . $d;
        }
        return implode("\r\n", $out) . "</ul>";
    }
    //echo hist_get(ia_sqlArrayIndx("SELECT * FROM ajuste_hist WHERE pk = 'cc483a12801a9da011ef4abf22ce0b82' ORDER BY date"));


?>

<script>
    $(document).ready(function() {
        $('.myIconInput').iconer_fontawsome({
            icons: {
                'iconer_fontawsome': [
                    'fa-regular fa-star',
                    'fa-solid fa-heart',
                    'fa-solid fa-user',
                    'fa-solid fa-home',
                    'fa-solid fa-cog',
                    'fa-solid fa-envelope',
                    'fa-solid fa-bell',
                    'fa-solid fa-calendar',
                    'fa-solid fa-search',
                    'fa-solid fa-trash'
                ]
            },
            buttonText: 'Icono'
        });

    });
</script>
<hr>



<hr>
<?php
    function existenciaDiaria() {
        $method = basename(__FILE__) . '.' . __FUNCTION__;
        $sqlExistenciaHoy =
          "SELECT /*$method*/ CURRENT_DATE as Fecha, b.Grupo, b.Bodega,
           SUM(pb.existencia_rollos) as Rolls,
           SUM(IF(pg.container_quantity = 0, 0, ROUND(pb.existencia_quantity / pg.container_quantity, 2) )) as 'Containers',
           SUM(IF(pg.unidades_id = 1, 0, pb.existencia_quantity)) as 'Qty Mts',
           SUM(IF(pg.unidades_id = 1, pb.existencia_quantity, 0)) as 'Qty Kg',
           SUM(IF(pg.unidades_id = 1, pb.existencia_quantity, ROUND(pb.existencia_quantity * pg.weight_per_m ,2)  )) as 'Kilos'
        FROM producto_bodega pb
            JOIN bodega b ON b.bodega_id = pb.bodega_id
            JOIN producto_general pg ON pg.producto_general_id = pb.producto_general_id
        GROUP BY 1,2,3
        ORDER BY 2,3";
        $hoy = ia_sqlArrayIndx($sqlExistenciaHoy);
        if($hoy === false)
            $hoy = [];
        $sqlExistencia =
          "SELECT /*$method*/ bxd.Fecha, IFNULL(b.grupo, '-') as Grupo, b.Bodega, 
                 bxd.Existencia_Rollos as 'Rolls', 
                 bxd.Existencia_Containers as 'Containers', 
                 bxd.Existencia_Quantity_Mts as 'Qty Mts',
                 bxd.Existencia_Quantity_Kg as 'Qty Kg', 
                 bxd.Existencia_Kg as 'Kilos'
        FROM bodega_x_dia bxd
            LEFT OUTER JOIN bodega b ON bxd.Bodega = b.Bodega
        WHERE bxd.fecha > '2022-08-31' AND bxd.fecha < CURRENT_DATE
        ORDER BY bxd.fecha DESC, b.grupo, b.Bodega";
        bodega_x_dia_cache();
        return array_merge( $hoy, ia_sqlArrayIndx($sqlExistencia));
    }
    function existenciaFinalDelMes($data, $incluyeHoy = true) {
        $ultimoDiaDelMes = [
            '01-31' => 1,
            '02-29' => 2,
            '03-31' => 3,
            '04-30' => 4,
            '05-31' => 5,
            '06-30' => 6,
            '07-31' => 7,
            '08-31' => 8,
            '09-30' => 9,
            '10-31' => 10,
            '11-30' => 11,
            '12-31' => 12
        ];
        $hoy = Date('Y-m-d');
        $mensual = [];
        foreach($data as $d) {
            $fecha = explode('-', $d['Fecha']);
            $mesDia = "$fecha[1]-$fecha[2]";
            if(array_key_exists($mesDia, $ultimoDiaDelMes) || "02-28" === $mesDia || ($incluyeHoy && $d['Fecha'] === $hoy))
                $mensual[] = $d;
        }
        return $mensual;
    }
    function existenciaFinalDeLaSemana(array $data, bool $incluyeHoy = true, string $lastDayOfWeek = "6") {
        $hoy = Date('Y-m-d');
        $semanal = [];
        foreach($data as $d) {
            if(Date('w', strtotime($d['Fecha'])) === $lastDayOfWeek || ($incluyeHoy && $d['Fecha'] === $hoy)) {
                $semanal[] = array_merge(
                    ['Semana' => Date('Y-W', strtotime($d['Fecha']))],
                   ['Dia' => Date('D', strtotime($d['Fecha']))],$d,
                );
            }
        }
        return $semanal;
    }
    function existenciaMaxima($data) {
        $maxInit = ['Rolls' => -1e9, 'Containers' => -1e9, 'Kilos' => -1e9 ];
        $medidas = $maxInit;
        $maxMinGlobal = [];
        $minInit = ['Rolls' => 1e9, 'Containers' => 1e9, 'Kilos' => 1e9 ];
        $medidasMin = $minInit;
        $medidasMaxPorBodega = [];
        $medidasMinPorBodega = [];
        $maxMinPorBodega = [];
        foreach($data as $d) {
            foreach($medidas as $medida => &$m) {
                $bodega = $d['Bodega'];
                $cantidad = floatval($d[$medida]);
                if(empty($cantidad) && $bodega == "CORPORACION RC")
                    continue;

                if(!isset($maxMinGlobal["max $medida"]))
                    $maxMinGlobal["max $medida"] = '';
               if($cantidad > $m ) {
                   $m = $cantidad;
                   $d['En'] = "$d[Fecha] $bodega";
                   $maxMinGlobal["max $medida"] = array_merge(["Max_Min" => "$medida Max"],$d);
               } elseif($cantidad == $m && strlen($maxMinGlobal["min $medida"]['En']) < 64)
                   $maxMinGlobal["max $medida"]['En'] .= ", $d[Fecha] $bodega";

               if(!isset($maxMinGlobal["min $medida"]))
                    $maxMinGlobal["min $medida"] = '';
               if($cantidad < $medidasMin[$medida]) {
                   $medidasMin[$medida] = $cantidad;
                   $d['En'] = "$d[Fecha] $bodega";
                   $maxMinGlobal["min $medida"] = array_merge(["Max_Min" => "$medida Min"], $d);
               } elseif($cantidad == $medidasMin[$medida] && strlen($maxMinGlobal["min $medida"]['En']) < 64)
                   $maxMinGlobal["min $medida"]['En'] .= ", $d[Fecha] $bodega";

               if(!isset($medidasMaxPorBodega[$bodega])) {
                   $medidasMaxPorBodega[$bodega] = $maxInit;
                   $medidasMinPorBodega[$bodega] = $minInit;
               }

                unset($d['En']);
                $key = "$bodega $medida Max";
                if($cantidad > $medidasMaxPorBodega[$bodega][$medida]) {
                    $medidasMaxPorBodega[$bodega][$medida] = $cantidad;
                    $d['El'] = $d['Fecha'];
                    $maxMinPorBodega[$key] = array_merge(["Max_Min" => "$medida Max"],$d);
                } elseif($cantidad == $medidasMaxPorBodega[$bodega][$medida] && strlen($maxMinPorBodega[$key]['El']) < 64)
                    $maxMinPorBodega[$key]['El'] .= ", $d[Fecha]";

                $key = "$bodega $medida Min";
                if($cantidad < $medidasMinPorBodega[$bodega][$medida]) {
                    $medidasMinPorBodega[$bodega][$medida] = $cantidad;
                    $d['El'] = $d['Fecha'];
                    $maxMinPorBodega[$key] = array_merge(["Max_Min" => "$medida Min"],$d);
                } elseif($cantidad == $medidasMinPorBodega[$bodega][$medida] && strlen($maxMinPorBodega[$key]['El']) < 64)
                    $maxMinPorBodega[$key]['El'] .= ", $d[Fecha]";
            }
        }
        uasort($maxMinGlobal, "existenciaTotalSort");
        uasort($maxMinPorBodega, "existenciaPorBodegaSort");
        return ['total' => $maxMinGlobal, 'por_bodega' => $maxMinPorBodega];
    }
    function existenciaTotalSort($a, $b) {
        $compare = $a['Max_Min'] <=> $b['Max_Min'];
        if($compare)
            return $compare;
        $compare = $b['Fecha'] <=> $a['Fecha'];
        if($compare)
            return $compare;
        $compare = $a['Grupo'] <=> $b['Grupo'];
        if($compare)
            return $compare;
        return $a['Bodega'] <=> $b['Bodega'];
    }
    function existenciaPorBodegaSort($a, $b) {
        $compare = $a['Grupo'] <=> $b['Grupo'];
        if($compare)
            return $compare;
        $compare = $a['Bodega'] <=> $b['Bodega'];
        if($compare)
            return $compare;
        $compare = $a['Max_Min'] <=> $b['Max_Min'];
        if($compare)
            return $compare;
        return $b['Fecha'] <=> $a['Fecha'];
    }

    $data = existenciaDiaria();
    $maxMin = existenciaMaxima($data);
    //echo iaTableIt::getTableIt($maxMin['por_bodega'], 'Máximos y Mínimos por Bodega');
    // //  echo iaTableIt::getTableIt(existenciaFinalDelMes($data), 'Existencia al Final del Mes');
    //echo iaTableIt::getTableIt(existenciaFinalDeLaSemana($data), 'Existencia al Final de la Semana');

?>
<hr>
<?php menuAndExecute(); ?>

<?php
echo "<h1>" . php_uname("n") . "</h1>";
?>

<style>
    .itCata_Container {
        display: flex; flex-direction: row; flex-wrap: wrap;
        justify-content: flex-start; align-content: flex-start; align-items: stretch;
        column-gap: 0; row-gap: 0;

        width:fit-content; padding:0;margin:0;
    }
    .itCata_Agrega {}
    .itCata_Descarta {}
    .itCata_DragDropTo {border:3px whitesmoke outset;padding:0.3em;height:8em;overflow-y:scroll}
    .itCata_Categoria {
        display: flex; flex-direction: row; flex-wrap: wrap;
        justify-content: space-between; align-content: flex-start;
        column-gap: 0; row-gap: 0;
        padding:0.3em;border:2px whitesmoke outset;
    }
    .itCata_Footer{
        display: flex; flex-direction: row; flex-wrap: wrap;
        justify-content: space-between; align-content: flex-start;
        font-weight:200; font-size:0.8em;
    }
    .itCata_Button {vertical-align: middle; cursor: pointer;}
    @media (pointer: coarse) {
        .itCata_Button {
            min-width: 48px;
            min-height: 48px;
        }
    }
</style>
<script>
    var it = it || {};
    it.CLICK_BLOCK_DURATION = {
        RAPID: 200,
        STANDARD: 300,
        FORM: 500
    };

    function itToggleVisibilityFirstSibling(event) {
        var target = event.target || event;
        var currentTime = new Date().getTime();
        if(currentTime - (target.lastClickTime || 0) < it.CLICK_BLOCK_DURATION)
            return;
        target.lastClickTime = currentTime;
        var firstSibling = target.nextElementSibling;
        if(firstSibling) {
            if(window.getComputedStyle(firstSibling).visibility === 'visible') {
                firstSibling.style.visibility = 'hidden';
            } else {
                firstSibling.style.visibility = 'visible';
            }
        }
    }
    function itVisibilityHiddenParent(event) {
        var target = event.target || event;
        var parent = target.parentElement;
        if(parent)
            parent.style.visibility = 'hidden';
    }
</script>
<hr>
<?php
// tipo de Clases es normalmente singleton instance
// debe ocultarle al usuario si es tabla-campo o tabla!
class ItCatalog {
    // table(unique entry) o generico (unique catalogo_internal_name->entry)
    // catalogo_internal_name o table name?
    // label, plural label, alta label, edit label,
    // permisos: Read, Insert, Edit, Inactivar, Delete
    // reglas delete?
    // additional fields
}
class Dato {
    // string(length), number(decimals),boolea(true/false), date, dateTime, time, enum/set, text,
}
?>

<?php
    function pluraliza($label) {
        $lastChar = $label[strlen($label)-1];
        switch($lastChar) {
            case 'a': case 'e':case 'i':case 'o':case 'u':
                return $label.'s';
            case 's':
                return $label;
            case 'j':
            case 'l':
            case 'n':
            case 'r':
            case 'y':
                return $label.'es';
            default:
                if(extension_loaded('ctype')) {
                    if(ctype_punct($lastChar) || ctype_digit($lastChar) || ctype_space($lastChar))
                        return $label;
                }
            return $label.'as';
        }

    }
    function itCata($catalogLabel, $plural = '') {
        if(empty($plural))
            $plural = pluraliza($catalogLabel);
        return <<< HTML
        <fieldset style="border:1px silver inset;width:fit-content;">
    <legend>$catalogLabel
        <button type="button" class="itCata_Button" onclick="itToggleVisibilityFirstSibling(this)"><i class="fa-regular fa-plus-large"></i> Nueva</button>
        <span id="itCataNew" style="visibility: hidden"><input type="text" placeholder="nueva categoría" value="">
            <button type="button" class="itCata_Button"><i class="fa-regular fa-floppy-disk"></i></button>
            <button type="button" class="itCata_Button" onclick="itVisibilityHiddenParent(this)"><i class="fa-regular fa-cancel"></i></button>
        </span>
    </legend>
    <select style="display:none" multiple="multiple" name="categoria" id="categoria">
        <option selected="selected">Category 1</option>
        <option>Category 2</option>
        <option>Category</option>
    </select>
    <div><input type="search" placeholder="buscar tiene" value=""></div>
    <div class="itCata_Container">
        <div style="margin:0;padding:0.3em; border:1px silver solid;">
        <div> <label>Agregar<br></label> </div>
        <div class="itCata_DragDropTo itCata_Agrega">
            <div class="itCata_Categoria">
                <span>Category 1 name</span> <button type="button" class="fa-regular fa-arrow-right itCata_Button"></button>
            </div>
        </div>
        <div class="itCata_Footer">
            <div>3 $catalogLabel</div>
            <div><button type="button" class="fa-regular fa-arrow-right itCata_Button"></button></div> 
        </div>
    </div>
        <div style="margin:0;padding:0.3em; border:1px silver solid">
        <div> <label>Descartar</label> </div>
        <div class="itCata_DragDropTo itCata_Descarta">
            <div  class="itCata_Categoria">
                <button type="button" class="fa-regular fa-arrow-left itCata_Button"></button><span>Category 1 name</span>
            </div>
            <div class="itCata_Categoria">
                <button type="button" class="fa-regular fa-arrow-left itCata_Button"></button><span>Category</span>
            </div>
        </div>
        <div class="itCata_Footer">
            <div><button type="button" class="fa-regular fa-arrow-left itCata_Button"></button></div> 
            <div>$catalogLabel</div>
        </div>
    </div>
    </div>
</fieldset>
HTML;

    }
?>
<?php echo
itCata('Categoría'); ?>

<hr>

<div>
    <button class="btn" id="add-category"><i class="icon fas fa-plus"></i>Add Category</button>
    <button class="btn" id="edit-category"><i class="icon fas fa-pencil-alt"></i>Edit Category</button>
    <button class="btn" id="delete-category"><i class="icon fas fa-trash"></i>Delete Category</button>
</div>
<div>
    <button class="btn" id="create-set"><i class="icon fas fa-layer-group"></i>Create Set</button>
    <button class="btn" id="manage-sets"><i class="icon fas fa-cog"></i>Manage Sets</button>
    <button class="btn" id="apply-set"><i class="icon fas fa-check-square"></i>Apply Set</button>
</div>
<?php

// este es el bueno
    $sql = "
    WITH existencia AS (
        SELECT pb.producto_general_id,
               b.grupo,
               b.bodega,
               SUM(pb.existencia_rollos)   AS rollos,
               SUM(pb.existencia_quantity) AS quantity
        FROM producto_bodega pb
                 JOIN producto_general pg ON pb.producto_general_id = pg.producto_general_id
                 JOIN bodega b ON pb.bodega_id = b.bodega_id
        WHERE pb.existencia_rollos <> 0 OR pb.existencia_quantity <> 0.00         
        GROUP BY pb.producto_general_id, b.grupo, b.bodega
    )
    SELECT e.Grupo, e.Bodega, pg.Producto, e.Rollos,
           IF(u.unidad = 'Kg', e.quantity, ROUND(e.quantity * pg.weight_per_m,2)) as Kg, u.Unidad,
           IF(pg.weight_per_m <= 0.00, '💣', pg.weight_per_m) AS 'Weight per mt',
           ROUND(e.quantity/pg.container_quantity,2) as Containers,
           IF(pg.container_quantity <= 0.00, '💣', pg.container_quantity) AS 'Loading Capacity'
    FROM existencia e
             JOIN producto_general pg ON e.producto_general_id = pg.producto_general_id
             JOIN unidades u ON pg.unidades_id = u.unidades_id
    ORDER BY e.grupo, e.bodega, pg.producto;
    ";

?>

<?php

function hayBodega($bodega_id, $fechaIni = "", $fechaFin = "") {
    $sqlBuilder = new IacSqlBuilder();
    global $gStrIt;
    $sqlExistencia =
        "SELECT CONCAT(pg.producto_general_id, c.color_id) as key, pg.producto, c.color, pb.existencia_quantity, pb.existencia_rollos,
            pc.lento, pc.super_lento, pc.en_remate, pc.es_saldo, pc.pedir
        FROM producto_bodega pb
            JOIN producto_general pg ON pg.producto_general_id=pb.producto_general_id
            JOIN color c ON c.color_id = pb.color_id
            JOIN producto_color pc ON pc.producto_color_id = pb.producto_color_id
        WHERE pb.bodega_id={$gStrIt($bodega_id)} AND pg.activo = 'Si' AND c.activo = 'Si'";
    $data = ia_sqlArray($sqlExistencia, "key");
    if($data === false) $data = ia_sqlArray($sqlExistencia, "key");
    if($data === false) $data = [];

    if(!empty($fechaIni))
        $whereFechaIni = " AND nb.fecha >= " . strit($fechaIni);
    if(!empty($fechaFin))
        $whereFechaFin = " AND nb.fecha <= " . strit($fechaFin);
    $sqlVentaNeta =
        "SELECT CONCAT(nb.producto_general_id, nbi.color_id) as key,
               SUM(IF(nb.tipo = 'Movimiento', nbi.quantity, -1 * nbi.quantity)) AS ventas_quantity,
               SUM(IF(nb.tipo = 'Movimiento', nbi.rollos, -1 * nbi.rollos)) AS ventas_rollos
        FROM nota_bodega nb
            JOIN nota_bodega_items nbi ON nbi.nota_bodega_id = nb.nota_bodega_id
        WHERE nb.bodega_id = {$gStrIt($bodega_id)} AND tipo  IN ('Movimiento', 'Devolucion') $whereFechaIni $whereFechaFin
        GROUP BY 1";
    $ventaNeta = ia_sqlArray($sqlVentaNeta, "key");
    if($ventaNeta === false) $ventaNeta = ia_sqlArray($sqlVentaNeta, "key");
    if($ventaNeta === false) $ventaNeta = [];
    return array_replace_recursive($data, $ventaNeta);
}
function cronToca() {
    $method = __FUNCTION__;
    $sql = "
    SELECT ats_id, funcion, intervalo
    FROM ats
    WHERE es = 'chron' AND ((siguiente_el <= NOW() AND termino = 'Si')) -- OR corrio y ya se tardo no termino!
    ";
    $chrons = ia_sqlArrayIndx($sql);
}
function recount() {
    $method = __FUNCTION__;
    echo "<ul><li><i>create index XXentrada_salidaTipo ON nota_bodega(bodega_id, entrada_salida, tipo, numero_real);</i></li></ul>";
    ia_query("FLUSH TABLES /*$method elimina buffers */");

    $start = microtime(true);
    $sql =
      "
SELECT /*$method*/ nb.bodega_id, entrada_salida, tipo, COUNT(*) nv_all,
       MAX(nb.numero_real) max_num,  MIN(nb.numero_real) min_num
FROM nota_bodega nb
GROUP BY 1,2,3 WITH ROLLUP ORDER BY 1,2,3";
    // /* qt=0.08653712272644 q2DSt=-1.6927719116211E-5 */ sin rollup
    //  WITH ROLLUP sin order by/* qt=0.15416216850281 q2DSt=-2.0980834960938E-5 */
    //  WITH ROLLUP CON ORDER BY by /* qt=0.11394190788269 q2DSt=-2.0980834960938E-5 */
    $hay = ia_sqlArrayIndx($sql);

    $numeros_bodega = [];
    foreach ($hay as $row) {
        $bodega_id = $row['bodega_id'];
        if($row['entrada_salida'] === NULL && $row['tipo'] === NULL) {
            $numeros_bodega[$bodega_id] = [
              'bodega_id' => $bodega_id,  
              'nva_all' => $row['nv_all'],
              'max_num' => $row['max_num'],
              'min_num' => $row['min_num'],
              'maximo_numero_all' => $row['max_num'],
              'minimo_numero_all' => $row['min_num'],
            ];
            continue;
        }
        if($row['tipo'] === NULL) {
           $entrada_salida = $row['entrada_salida'];
            $numeros_bodega[$bodega_id] = array_merge($numeros_bodega[$bodega_id], [
              "nv_$entrada_salida" => $row['nv_all'],
              "maximo_numero_$entrada_salida" => $row['max_num'],
              "minimo_numero_$entrada_salida" => $row['min_num']
            ]);
            continue;
        }
        $tipo = $row['tipo'];
        switch($tipo) {
            case 'Movimiento':
            case 'Traslado':
            case 'Devolucion':
            case 'Correccion':
                $numeros_bodega[$bodega_id] = array_merge($numeros_bodega[$bodega_id], [
                  "nv_$tipo" => $row['nv_all'],
                  "maximo_numero_$tipo" => $row['max_num'],
                  "minimo_numero_$tipo" => $row['min_num']
                ]);
                break;
            case 'Cancelacion':
            case 'Borrado':
                $numeros_bodega[$bodega_id]["maximo_numero_cancelacion_borrado"] = MAX($numeros_bodega[$bodega_id]["nv_cancelacion_borrado"] ?? 0, $row['nv_all']);
                $numeros_bodega[$bodega_id]["minimo_numero_cancelacion_borrado"] = MIN($numeros_bodega[$bodega_id]["nv_cancelacion_borrado"] ?? 0, $row['nv_all']);
        }
    }
    $end = microtime(true);
    echo "<h2 style='text-align: center'>total, entradas, salidas, venta tienda, traslados,devoulciones, ajuste, cancelaciones y borrados:<p>" . ($end - $start) . "ms</h2>";
    file_debug_reporte();
    echo iaTableIt::tableIt($hay, "El query");
    iaTableIt::tableIt($numeros_bodega, "Números por bodega");
}


//preg_match_all("/\\bFR|\\bRA|\\bta/i", "Fredy gabriel ramirex", $matches, PREG_OFFSET_CAPTURE);
////echo "<pre class='code'>" . print_r($matches, true) . "</pre><hr>";
//preg_match_all("/\\bFR|\\bRA|\\bta/i", "ramon frateli", $matches,  PREG_OFFSET_CAPTURE);
//echo "<pre class='code'>" . print_r($matches, true) . "</pre>";

$data =  [
  0 => [
    'label' => 'ISABELLA SANCHEZ',
  ],
  1 => [
    'label' => 'ISIDORO SANCHEZ GARCIA',
  ],
  2 => [
    'label' => 'ISAAC GARCIA SANCHEZ',
  ],
  3 => [
    'label' => 'ISIDRO SANCHEZ',
  ],
  4 => [
    'label' => 'JORGE SALOMON ISLAS',
  ],
  5 => [
    'label' => 'Sánches Amaro ISrael',
  ],
  6 => [
    'label' => 'ALEJANDRO SALOMON ISLAS',
  ],
  7 => [
    'label' => 'ISABEL SANCHEZ PEDROZA',
  ],
  8 => [
    'label' => 'pa nada ta',
  ],

];


?>





<div style="margin:2em;padding:0;width:fit-content">

<script>

    const container = document.querySelector('.timer-container');
    let startTime;
    let animationFrameId;
    function rotateTriangle(timestamp) {
        if (!startTime) startTime = timestamp;
        const elapsed = timestamp - startTime;
        const rotation = (elapsed / 60000) * 360; // 60000ms = 1 minute
        const triangle = document.querySelector('.triangle');
        triangle.style.transform = `translateX(-50%) rotate(${rotation}deg)`;
        animationFrameId = requestAnimationFrame(rotateTriangle);
    }
    function resetAndContinueRotation() {
        cancelAnimationFrame(animationFrameId);
        startTime = null;
        const triangle = document.querySelector('.triangle');
        triangle.style.transform = 'translateX(-50%) rotate(0deg)';
        requestAnimationFrame(rotateTriangle);
    }
    container.addEventListener('click', resetAndContinueRotation);
    requestAnimationFrame(rotateTriangle);
</script>


<h1>Ete</h1>
<style>
    .ItMultiSwitch {border:2px silver solid;border-radius: 12px; padding:0.3em 0.5em;cursor:pointer;width:4em;display:inline-block}
    .ItMultiSwitch:hover {box-shadow: 2px 2px 0 0 rgba(0, 0, 0, 0.4)}
</style>
<script>
    valueIconSiNo = [
       {value:'Si',
           icon:{class:"fa-solid fa-check fa-2xl", css:{color:'darkgreen'} },
           label:{html:"Si", class:"", css:{color:'darkgreen'} },
           element:{class:"",  css:{color:'darkgreen',"border-color":"darkgreen"} }
        },
        {value:'No',
            icon:{class:"fa-solid fa-xmark fa-2xl", css:{color:'red'} },
            label:{html:"No", class:"",  css:{color:'red'} },
            element:{class:"",  css:{"border-color":"red"} }
        },
        {value:'?',
            icon:{class:"fa-solid fa-question fa-xl", css:{color:'orange'} },
            label:{html:"", class:"",  css:{color:'orange'} },
            element:{class:"",  css:{"border-color":"orange"} }
        },
    ];

    function ItMultiSwitch(elementId,  valueIcon, defaultValue ) {
        if( !(this instanceof ItMultiSwitch ))
            return new ItMultiSwitch(elementId,  valueIcon, defaultValue);

        if(defaultValue === 'undefined')
            defaultValue = val();
        if(getFor(defaultValue) === null)
            defaultValue = nextValue();

        val(val());
        if(getFor(val()) === null )
            val(defaultValue)

        $("#" + elementId).off("click", click).on("click", click);

        function val(value) {
            var $el = $("#" + elementId);
            if(typeof value === 'undefined')
                return $el.find("input").val();

            var $icon = $el.find("i");
            var $label = $el.find("span");

            var tiene = getFor($el.find("input").val());
            if(tiene !== null && typeof tiene === 'object') {
                if(typeof tiene.icon.class === 'string' && tiene.icon.class.length)
                    $icon.removeClass(tiene.icon.class);
                if(typeof tiene.label.class === 'string' && tiene.label.class.length)
                    $label.removeClass(tiene.label.class);
                if(typeof tiene.element.class === 'string' && tiene.element.class.length)
                    $el.removeClass(tiene.element.class);
            }

            tiene = getFor(value);
            if(tiene !== null && typeof tiene === 'object') {
                if(typeof tiene.icon.class === 'string' && tiene.icon.class.length)
                    $icon.addClass(tiene.icon.class);
                if(typeof tiene.icon.css === 'object' && tiene.icon.css !== null)
                    $icon.css(tiene.icon.css);
                if(typeof tiene.icon.html !== 'undefined')
                    $icon.html(tiene.icon.html);

                if(typeof tiene.label.class === 'string' && tiene.label.class.length)
                    $label.addClass(tiene.label.class);
                if(typeof tiene.label.css === 'object' && tiene.label.css !== null)
                    $label.css(tiene.label.css);
                if(typeof tiene.label.html !== 'undefined')
                    $label.html(tiene.label.html);

                if(typeof tiene.element.class === 'string' && tiene.element.class.length)
                    $el.addClass(tiene.element.class);
                if(typeof tiene.element.css === 'object' && tiene.element.css !== null)
                    $el.css(tiene.element.css);
            }
            $el.find("input").val(value);
        }

        function getFor(value) {
            var i;
            var len = valueIcon.length;
            for(i = 0; i < len; ++i)
                if(valueIcon[i].value == value)
                    return valueIcon[i];
            return null;
        }

        function nextValue(value) { return getNext(value).value || defaultValue; }
        
        function getNext(value) {
            if(typeof value === 'undefined')
                value = val();
            var i;
            var len = valueIcon.length;
            for(i = 0; i < len; ++i)
                if(valueIcon[i].value == value)
                    return  i >= len - 1 ? valueIcon[0] : valueIcon[i + 1];
            return valueIcon[0];
        }

        function click() { val(nextValue()); }

        function id() {return elementId}
        return {
            val: val,
            nextValue: nextValue,
            click: click,
            getFor: getFor,
            id: id
        }

    }
</script>
<fieldset style="margin:1em;padding:1em;width:fit-content"><legend>Some ItMultiSwitchs</legend>
    <span id="tanga"  class="ItMultiSwitch">
        <input type="hidden" value="No" name="tanga"><i class="fa-solid fa-xmark fa-2xl" style="color: red;"></i> <span>N/A</span>
    </span>
    <span id="tanga2" class="ItMultiSwitch">
        <input type="hidden" value="" name="tanga2"><i class="fa-solid fa-check" style="color: #008000;"></i> <span>Con</span>
    </span>
</fieldset>
<script>

</script>
<hr>
    <!-- ul>
        <h1>Tabler Nested headers</h1>
        <li><b><i><code>Input:</code></i></b>
            <ul>
                <li><i><code>data</code></i> [[colName:value,..], [colName:value,..],]</li>
                <li><i><code>columnsDef</code></i> [colName:colLabel, colNameAgrupado:[colName:colLabel,...]</li>
                <li><i><code>rowsDef</code></i> [ colNameAgrupado:[colName:colLabel,...], colName:colLabel,</li>
                <li><i><code>class</code></i> css class for table, default laTabla</li>
            </ul>
        <li><b><i><code>Output:</code></i></b> Array el table en cada posicion del array
        <li><b><i><code>Pasos:</code></i></b>
            <ol>
                <li>Hacer el columnsDef y rowsDef con los valores de los rows, en los agrupados poner cada valor del colName agrupado</li>
            </ol>
            <ol>
                <li>De data formar colDef y rowDef</li>
            </ol>
    </ul -->
<?php

class Tabler {
    protected array $data;
    protected array $colFormat;
    protected array $colTitles;
    protected array $rowTitles;
    protected string $tableCssClass;

    protected array $colHeader;
    /**
     * @param array $data
     * @param array $colFormat
     * @param array $colTitles
     * @param array $rowTitles
     * @param string $tableCssClass
     */
    public function __construct(array $data, array $colFormat = [], array $colTitles = [], array $rowTitles = [], string $tableCssClass = "laTabla") {
        $this->data = $data;
        $this->colFormat = $colFormat;
        $this->columnTitles( empty($colTitles) ? array_keys(reset($data)) : $colTitles);
        $this->rowTitles = $rowTitles;
        $this->tableCssClass = $tableCssClass;
    }

    /**
     * Convierte columnTitles para obtener headers y grouping
     *
     * @param array $columnTitles ['fieldName'|'fieldName'=>'fieldLabel'|'groupedColumnsTitle'=>['fieldNameValue']|'groupedColumnsTitle'=>['fieldName' => ['values']]
     * @return void
     */
    protected function columnTitles(array $columnTitles):void {
        $columnDef = [];
        foreach($columnTitles as $key => $value) {
            if(is_array($value)) {
                $entries = reset($value);
                if(is_array($entries)) {
                    $columnDef[$key] = $entries;
                    continue;
                }
                $columnDef[$key] = $this->valuesPerColumn($entries);
                continue;
            }
            $columnDef[is_int($key) ? $value : $key] = $this->toTitle($value);
        }
        $this->columnDefiner($columnDef);
    }

    /**
     * @param array $columnDef ['a_id' => 'La A', 'grouped' => ['b_1_id' => 'B#1', 'subgrouped' => ['b.1.2_1_id' => 'B#2_1', 'b.1.2_2_id' => 'B#2_2']] ]
     * @return void
     */
    protected function columnDefiner(array $columnDef):void {
        $group = [ 'levels'=>0, 'headers'=>[], 'columns' => [] ];
        $headers = $this->headerDefine($columnDef, $group, [], 1);
        $maxLevel = $group['levels'];
        if($maxLevel > 1)
            foreach($headers['headers'] as $level => &$tr) {
                if($level < $maxLevel)
                    foreach($tr as &$td)
                        if($td['span'] === 1 && $td)
                            $td['altSpan'] = $maxLevel - $level + 1;
            }
        $this->colHeader = $headers['headers'];
        $this->colTitles = $headers['columns'];
    }

    protected function headerDefine(array $columnDef, array &$group, array $grouped, int $level):array {
        if(!empty($columnDef) && $level > $group['levels'])
            $group['levels'] = $level;
        foreach($columnDef as $name => $label) {
            if(is_array($label)) {
                $g = $grouped;
                $g[] = $name;
                $group['headers'][$level][$name] = ['label' => $name, 'span' => 0, 'altSpan' => 1, 'g' => $g];
                $this->headerDefine($label, $group, $g, $level + 1);
                continue;
            }
            $g = $grouped;
            $g[] = $name;
            $group['headers'][$level][$name] = ['label' => $label, 'span' => 1, 'altSpan' => 1, 'g' => $g];
            if($level > 1) {
                $iLevel = $level -1;
                foreach(array_reverse($grouped) as $p) {
                    if($p === '')
                        continue;
                    $group['headers'][$iLevel][$p]['span']++;
                    $iLevel--;
                };
            }
            $group['columns'][$name] = ['label' => $label, 'level' => $level, 'g' => $g];
        }
        return $group;
    }

    protected function valuesPerColumn($columnName) {
        $grupos = array_unique(array_column($this->data, $columnName));
        asort($grupos);
        return array_combine($grupos, $grupos);
    }

    protected function toTitle(int|float|bool|string|null $title):string {
        if($title === null)
            return '';
        $title = "$title";
        if(endsWith($title, "_id"))
            $title = substr($title, 0, -3);
        return ucwords( str_replace("_", " ", "$title") );
    }

}

class tk {
    protected array $data;
    protected array $colDefiner;
    protected array $rowDefiner;

    protected string $tableClass;


    public function headerRow($defined):array {
        $header = [];
        foreach($defined['headers'] as $tr) {
            $header[] = "<tr>";
            foreach($tr as $id => $th) {
                $grouped =  json_encode($th['g'] ?? []);
                $header[] = "<th rowspan='$th[altSpan]' colspan='$th[span]' data-tkid='$id' data-tkg='$grouped'>".$th['label']."</th>";
            }
        }
        return $header;
    }

    public function columnDefiner(array $columnDef):array {
        $group = [ 'levels'=>0, 'headers'=>[], 'columns' => [] ];
        $headers = $this->headerDefine($columnDef, $group, [], 1);
        $maxLevel = $group['levels'];
        if($maxLevel > 1)
            foreach($headers['headers'] as $level => &$tr) {
                if($level < $maxLevel)
                    foreach($tr as &$td)
                        if($td['span'] === 1 && $td)
                            $td['altSpan'] = $maxLevel - $level + 1;
            }
        return $headers;
    }

    protected function headerDefine(array $columnDef, array &$group, array $grouped, int $level):array {
        if(!empty($columnDef) && $level > $group['levels'])
            $group['levels'] = $level;
        foreach($columnDef as $name => $label) {
            if(is_array($label)) {
                $g = $grouped;
                $g[] = $name;
                $group['headers'][$level][$name] = ['label' => $name, 'span' => 0, 'altSpan' => 1, 'g' => $g];
                $this->headerDefine($label, $group, $g, $level + 1);
                continue;
            }
            $g = $grouped;
            $g[] = $name;
            $group['headers'][$level][$name] = ['label' => $label, 'span' => 1, 'altSpan' => 1, 'g' => $g];
            if($level > 1) {
                $iLevel = $level -1;
                foreach(array_reverse($grouped) as $p) {
                    if($p === '')
                        continue;
                    $group['headers'][$iLevel][$p]['span']++;
                    $iLevel--;
                };
            }
            $group['columns'][$name] = ['label' => $label, 'level' => $level, 'g' => $g];
        }
        return $group;
    }

    protected function valuesPerColumn($columnName) {
        $grupos = array_unique(array_column($this->data, $columnName));
        asort($grupos);
        return array_combine($grupos, $grupos);
    }
}


$columnDef = [
  'a_id' => 'La A(a_id)',
  'Agrupado'=>['PorColName'=>['valor A de PorColName', 'valor B  de PorColName' ]],
  'grouped' => ['b_1_id' => 'B valor de b_1_id', 'subgrouped' => ['b.1.2_1_id' => 'B#2_1 Valor de b.1.2_1_id', 'b.1.2_2_id' => 'B#2_2']]
];
$tk = new tk();
$group = $tk->columnDefiner($columnDef);

echo "<div class='cen' style='margin: 1em 2em'><table class='tabler'>";
echo "<thead>";
echo "<thead>";
echo implode("\r\n\t\t", $tk->headerRow($group));
echo "</thead>";
echo "</table></div>";
echo "<pre class='code'><h2>Define columns: ['colId'=>'col Label', 'grouped'=>...]</h2>". print_r($columnDef, true)."</pre>";
echo "<pre class='code'><h2>Struct headers, y columnas</h2>". print_r($group, true)."</pre>";
?>


<!--suppress CssUnusedSymbol -->
<style>
    .editTabler {cursor:pointer;color:#00F}
    .editInconsitencia {cursor:pointer}
    .ayudantesDefineHighlight {background-color: lightyellow!important;}
    .tablerSticky {  background: whitesmoke;
        position: sticky;
        top: 0;
        box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.4);
        opacity: 1;
    }
    .tablerSticky2 {  background: whitesmoke;
        position: sticky;
        top: 2.15em;
        box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.4);
        opacity: 1;
    }
</style>
<script>

    var ayudantesDefine = {
        iconos:{
            'visible': {
                '0': '<i class="fa-solid fa-eye-slash" style="color:red;"></i>',
                '1': '<i class="fa-solid fa-eye" style="color:darkgreen;"></i>',
            },
            '0': '<i class="fa-duotone fa-triangle-exclamation" style="--fa-primary-color: #400040; --fa-secondary-color: orange; --fa-secondary-opacity: 1;"></i>',
            '1': '<i class="fa-solid fa-check" style="color: darkgreen;"></i>',
        },
        title: {
            '0': " CAUSA INCONCISTENCIA",
            '1': " VALE",
        },
        dialogo: function(el) {
            let $el = $(el);
            let $ayudantesDefineTable = $("#ayudantesDefineTable");
            let data = $el.data();
            $("#ayudantesDialogTitle").html(data.label + ", " + data.soy);
            $("#ayudantesDialog").dialog({
                title:"Conceptos de Ayudantes", width:700, height:500,
                modal:true,
                closeOnEscape:true,
                buttons: [
                    {
                        text: "Set",
                        icon: "ui-icon-disk",
                        click: function() {
                            var campo;
                            var valor;
                            $("LI[data-campo]", $(this)).each(function(){
                               let $concepto = $(this);
                               campo = $concepto.data('campo');
                               valor  = $concepto.data('valor');
                               $(`LI[data-para~='${data.id}']`, $ayudantesDefineTable).filter(`LI[data-campo='${campo}']`).each(function(){
                                    ayudantesDefine.editaCampo(this, campo, valor);
                                });
                            });
                        }
                    },
                    {
                        text: "Cerrar",
                        icon: "ui-icon-closethick",
                        click: function() {$(this).dialog("close");}
                    },

                ],
                open: function() {
                    $(".ayudantesDefineHighlight", $ayudantesDefineTable).removeClass("ayudantesDefineHighlight");
                    $(`TH[data-para~='${data.id}']`, $ayudantesDefineTable).addClass("ayudantesDefineHighlight");
                    $(`TD[data-para~='${data.id}']`, $ayudantesDefineTable).addClass("ayudantesDefineHighlight");
                    let $this = $(this);
                    var camposValor = ayudantesDefine.getCamposConValorMasSeleccionado(data.id);
                    for(let campo in camposValor)
                        if(camposValor.hasOwnProperty(campo)) {
                            ayudantesDefine.editaCampo(
                                $("UL[data-para~='dialogo']", $this).children(`LI[data-campo='${campo}']`),
                                "",
                                camposValor[campo]
                            );
                        }
                },
                close: function() {
                    $(".ayudantesDefineHighlight", $ayudantesDefineTable).removeClass("ayudantesDefineHighlight");
                },
            });
        },

        getCamposConValorMasSeleccionado: function(para) {
            const valores = {};
            $(`UL[data-para~='${para}']`, $("#ayudantesDefineTable")).children("LI[data-campo]").each(function() {
                let $el = $(this);
                let campo = $el.data('campo');
                if(!valores.hasOwnProperty(campo))
                    valores[campo] = {};
                let valor = $el.data('valor');
                if(valores[campo].hasOwnProperty(valor))
                    valores[campo][valor]++;
                else
                    valores[campo][valor] = 1;
            });
            const result = {};
            for(const campo in valores) {
                if(valores.hasOwnProperty(campo)) {
                    const valoresDelCampo = valores[campo];
                    let maxValor = null;
                    let maxCuenta = -Infinity;
                    for(const valor in valoresDelCampo) {
                        if(valoresDelCampo.hasOwnProperty(valor)) {
                            const value = valoresDelCampo[valor];
                            if (value > maxCuenta) {
                                maxCuenta = value;
                                maxValor = valor;
                            }
                        }
                    }
                    result[campo] = maxValor;
                }
            }
            return result;
        },

        editaCampo: function(el, title, ponValor) {
            let $el = $(el);
            let nuevoValor = typeof ponValor === 'undefined' ? ($el.data("valor") == '1' ? '0' : '1') : ponValor;
            nuevoValor = nuevoValor.toString();
            $el.data('valor', nuevoValor);
            let campo = $el.data("campo");
            if(ayudantesDefine.title.hasOwnProperty(campo))
                $el.attr("title", title + " " +  (ayudantesDefine.title[campo][nuevoValor] || " (" + nuevoValor + ")") );
            else
                $el.attr("title", title + " " + (ayudantesDefine.title[nuevoValor] || " (" + nuevoValor + ")") );
            if(ayudantesDefine.iconos.hasOwnProperty(title)) {
                $el.children().attr("title",globito).first().html(ayudantesDefine.iconos[title][nuevoValor]);
                if(campo === 'visible') {
                    if(nuevoValor === '1') {
                        $el.children()[1].innerHTML = 'Visible';
                        $el.siblings().each(function(){$(this).show();});
                        return;
                    }
                    $el.children()[1].innerHTML = 'Oculto';
                    $el.siblings().each(function(){$(this).hide();});
                }
                return;
            }
            $el.children().first().html(ayudantesDefine.iconos[nuevoValor]);
        },
    }
</script>


<hr>
<ol>
    <li>Dialogo pone oculto como que no regresa  a visible</li>
    <li>Dialogo visible brajan</li>
    <li>llenalo tu es un click flag
    <li>ayudante puede quedar en blanco
</ol>

<?php
class AyudantesReglas {
    protected array $bodegas = [];

    public function getBodegas() {
        if(empty($this->bodegas)) {
            $this->bodegas = ia_sqlArray("SELECT bodega_id, bodega, color, grupo FROM bodega WHERE activo='Si' ORDER BY grupo,bodega", "bodega_id");
            foreach($this->bodegas as &$b) {
                $b['grupo'] = empty($b['grupo']) ?  'Sin Grupo' : $b['grupo'];
                $b['paraGrupo'] = "GB_COL_" . preg_replace( '/\s+/', '', $b['grupo']);
            }
        }
        return $this->bodegas;
    }
    public function getHeader(): string {
        $this->getBodegas();
        $theadGrupo = ["<th class='tablerSticky' rowspan='2' colspan='2' style='vertical-align: middle'>Destino/Bodega"];
        $thead2 = [];

        $prevGrupo = null;
        $prevGroupColspan = 0;
        foreach($this->getBodegas() as $bodega_id => $b) {
            $grupo = $b['grupo'];
            $paraGrupo = $b['paraGrupo'];
            if($prevGrupo !== $paraGrupo) {
                $prevGrupo = $paraGrupo;
                $prevGroupColspan = 1;
                $theadGrupo[$paraGrupo] = "<th class='tablerSticky' colspan='1' data-para='$paraGrupo'>". htmlentities($grupo)." <span title='Editar TODAS las bodegas del grupo' class='fa-duotone fa-solid fa-pencil noprint' style='--fa-primary-color: #FFD43B; --fa-secondary-color: #cdbe89; cursor: pointer;' data-soy='Grupo de Bodegas' data-id='$paraGrupo' data-label='$grupo' onclick='ayudantesDefine.dialogo(this)'></span></th>";
            } else {
                $prevGroupColspan++;
                $theadGrupo[$paraGrupo] =  preg_replace("/colspan='\d+'/mS", "colspan='$prevGroupColspan'", $theadGrupo[$paraGrupo]);
            }
            $thead2[] = "<th class='tablerSticky2'   data-para='$bodega_id $paraGrupo'>" . htmlentities($b['bodega']) . "<p><span title='Editar la bodega' class='editTabler fa-duotone fa-solid fa-pencil noprint' style='--fa-primary-color: #e78413; --fa-secondary-color: #cdbe89;' data-soy='Bodega' data-id='$bodega_id' data-label='$b[bodega]' onclick='ayudantesDefine.dialogo(this)'></span></li></th>";
        }
        return
          "<thead>
            <tr>" . implode("\r\n\t\t\t", $theadGrupo) . "</tr>
            <tr>" . implode("\r\n\t\t\t", $thead2) . "</tr>
        </thead>";
    }
    public static function getTiendas():array {
        $tiendas = ia_sqlArray("SELECT tienda_id, clave, tienda, inconsistencia_pina FROM tienda WHERE vale='Active' AND vale_origen_destino = 'Si' AND tienda_id <> 1 ORDER BY clave ", "tienda_id");
        foreach($tiendas as &$t) {
            switch($t['clave']) {
                case 'SIM':  $t['cat1'] = 'Externa'; break;
                case 'GDL':
                case 'PALACIOS (TIENDA)':
                case 'CH':
                    $t['cat1'] = 'Foránea'; break;
                default:
                    $t['cat1'] = 'Centro';
            }
        }
        uasort($tiendas, function($a, $b) {
            if($a['cat1'] === $b['cat1'])
                return strcmp($a['clave'], $b['clave']);
            if($a['cat1'] === 'Externa')
                return 1;
            if($b['cat1'] === 'Externa')
                return -1;
            return strcmp($a['cat1'], $b['cat1']);
        });
        return $tiendas;
    }
}
    $ayudantesReglas = new AyudantesReglas();

    $iconInconsistencia = '<b><i class="fa-duotone fa-triangle-exclamation" style="--fa-primary-color: #400040; --fa-secondary-color: orange; --fa-secondary-opacity: 1;"></i></b>';
    $iconOk = '<b><i class="fa-solid fa-check" style="color: darkgreen;"></i></b>';
    $iconVisible = '<b><i class="fa-solid fa-eye" style="color:darkgreen;"></i></b>';
    $iconOculto = '<b><i class="fa-solid fa-eye-slash" style="color:red;"></i></b>';

    $tbody = [];
    $prevGrupo = null;
    $prevGroupColspan = 0;
    $tiendas = AyudantesReglas::getTiendas();

    foreach($tiendas as $tienda_id => $t) {
        $tbody[] = "<tr data-origenid='$tienda_id'>";
        $grupoTienda = $t['cat1'] ?? '';
        $paraTienda = 'THT' . htmlentities($grupoTienda);
        if($prevGrupo !== $paraTienda) {
            $prevGrupo = $paraTienda;
            $prevGroupColspan = 1;
            $tbody[$paraTienda]= "<th rowspan='1' data-para='$paraTienda' style='width:2.5em'>" .
              "<span class='editTabler fa-duotone fa-solid fa-pencil noprint' style='--fa-primary-color: #FFD43B; --fa-secondary-color: #cdbe89; cursor: pointer;' data-soy='Grupo de Tiendas' data-id='$paraTienda' data-label='$grupoTienda' onclick='ayudantesDefine.dialogo(this)'></span>" .
              "<span style='writing-mode: vertical-rl;text-orientation: mixed;width:2.5em'>&nbsp;" .  htmlentities($grupoTienda). "</span></th>";
        } else {
            $prevGroupColspan++;
            $tbody[$paraTienda] =  preg_replace("/rowspan='\d+'/mS", "rowspan='$prevGroupColspan'", $tbody[$paraTienda]);
        }

        $tr = ["<th data-para='$tienda_id $paraTienda' title='" . htmlentities($t['tienda']) . "'>" . htmlentities($t['clave']) .
          "<span class='editTabler fa-duotone fa-solid fa-pencil noprint' style='--fa-primary-color: #e78413; --fa-secondary-color: #cdbe89;' data-soy='Tienda' data-id='$tienda_id' data-label='$t[clave]' onclick='ayudantesDefine.dialogo(this)'></span>",
          ];

        foreach($ayudantesReglas->getBodegas() as $bodega_id => $b) {
            $dataPara = "data-para='$tienda_id $bodega_id $b[paraGrupo] $paraTienda'";
            $data = " data-destino='$tienda_id' data-bodega='$bodega_id' $dataPara";
            $delGrupo = empty($b['grupo']) ?  '' :
              "<li data-valor='1' data-campo='grupo' title='Ayudantes del GRUPO VALIDOS' $data class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes del GRUPO\")'>$iconOk Del Grupo</li>";
            $tr[] = "<td $dataPara style='padding:0.3em'><ul $dataPara style='list-style-type:none;padding:0 0 0 0.3em;margin:0;line-height: 1.6em'>
                    <li $data data-campo='visible' data-valor='1'  class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"visible\")'>$iconVisible <span> Visible</span></li>
                    <li title='Del destino' $data data-campo='destino' data-valor='1' class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"Ayudante del Destino, El destino lo llena\")'>$iconOk Destino llena</li>
                    <li title='SIN AYUDANTES ES VÁlIDO' $data data-campo='sin' data-valor='1' class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"SIN Ayudantes\")'>$iconOk Sin Ayudante</li>
                    <li title='DEL CLIENTE ES VÁLIDO' $data data-campo='cliente' data-valor='1' class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes del CLIENTE\")'>$iconOk del Cliente</li>
                    <li title='Bodega Entrega ES VÁLIDO' $data data-campo='entrega' data-valor='1' class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"La Bodega ENTREGA\")'>$iconOk ENTREGA</li>
                    <li title='Ayudantes de la BODEGA VÁLIDO' $data data-campo='bodega' data-valor='1' class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes de la BODEGA\")'>$iconOk De la Bodega</li>
                    $delGrupo
                    </ul>";
        }
        $tbody[] = implode("", $tr);
    }

    $data = " data-destino='dialogo_destino' data-bodega='dialogo_bodega' data-para='$tienda_id $bodega_id'";
    echo "
    <div id='ayudantesDialog' style='padding:0 1.5em 1.5em 1.5em;display:none'>
        <h1 id='ayudantesDialogTitle' style='margin-top:0;padding:0;text-align: center'></h1>
        <ul>
            <li>$iconInconsistencia SI Causa Inconcistencia.
            <li>$iconOk Es un dato opcional, NO CAUSA INCONSISTENCIA.</li>
        </ul>
        <div style='padding:0.5em;margin:0.5em;border:1px darkblue solid'>
        <table><tr><td>
            <ul data-para='dialogo' style='list-style-type:none;padding:0 0 0 0.3em;margin:0;line-height: 2em;'>
                <li $data data-campo='visible' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"visible\")'>$iconVisible <span > Visible</span></li>
                <li $data  title='Del destino' data-campo='destino' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"Ayudante del Destino, lo llena el destino\")'>$iconOk Destino llena</li>
                <li $data data-campo='sin'  title='SIN AYUDANTES ES VÁlIDO' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"SIN Ayudantes\")'>$iconOk Sin Ayudante</li>
                <li $data data-campo='cliente' title='DEL CLIENTE ES VÁLIDO' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes del CLIENTE\")'>$iconOk Cliente</li>
                <li $data data-campo='entrega' title='Bodega Entrega ES VÁLIDO' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"La Bodega ENTREGA\")'>$iconOk ENTREGA</li>
                <li $data data-campo='bodega' title='Ayudantes de la BODEGA VÁLIDO' class='editInconsitencia' data-valor='1' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes de la BODEGA\")'>$iconOk de la Bodega</li>
                <li id='liGrupo' data-campo='grupo' data-valor='1' title='Ayudantes del GRUPO VALIDOS' $data class='editInconsitencia' onclick='ayudantesDefine.editaCampo(this, \"Ayudantes del GRUPO\")'>$iconOk Del Grupo</li>
            </ul>
            </td></tr></table>
        </div>
    </div>
    
    <div style='margin:1em 0.5em;font-size:0.9em'>
    <table id='ayudantesDefineTable' class='tabler'>
        <caption><h2 style='margin:0;padding:0'>Ayudantes</h2>         
        <ul style='list-style-type:none'>
            <li>$iconInconsistencia SI Causa Inconcistencia.
            <li>$iconOk Es un dato opcional, NO CAUSA INCONSISTENCIA</li>
        </ul>
        </caption>" . $ayudantesReglas->getHeader() .
        "<tbody>" . implode("\r\n\t\t\t", $tbody) . "</tbody>
        </table>
        </div>";


?>
<hr>
<script>
    let iaHtml = {
        jsLoadOnce: function(src) {
            const scripts = document.getElementsByTagName('script');
            for (let script of scripts)
                if (src === script.src)
                    return;
            const tag = document.createElement('script');
            tag.src = src;
            document.getElementsByTagName('body')[0].appendChild(tag);
        },
        cssLoadOnce: function(href, media) {
            const links = document.getElementsByTagName('link');
            for (let link of links)
                if (href === link.href)
                    return;
            const tag = document.createElement('link');
            tag.rel = 'stylesheet';
            tag.type = 'text/css';
            if(typeof media === 'string')
                tag.media = media;
            tag.href = href;
            document.getElementsByTagName('body')[0].appendChild(tag);
        },
    };
    Object.freeze(iaHtml);

    const debugIt = {
        logEvents: function (eventNamePart) {
            let events = debugIt.getEvents(window, eventNamePart);
            for (let ev of events)
                console.log("events for := " + eventNamePart + " ev=", ev);
        },
        getEvents: function (root, eventNamePart) {
            let events = [];
            let regExp = typeof eventNamePart === 'string' ? new RegExp(eventNamePart, 'i') : '';
            const objectHasSubPrototype = (object, comp) => {
                let proto = Object.getPrototypeOf(object);
                while (proto !== null && proto !== EventTarget) {
                    proto = Object.getPrototypeOf(proto);
                }
                return (proto !== null);
            };
            const addEventNames = (propNames) => {
                propNames.filter(x => x.match(/^on\w+$/)).forEach((propName) => {
                    propName = propName.substr(2);
                    if (events.indexOf(propName) === -1 && (typeof eventNamePart !== 'string' || propName.search(regExp) > 0))
                        events.push(propName);
                });
            };

            Object.getOwnPropertyNames(root).forEach((name) => {
                let value = root[name];
                if (value) {
                    if (objectHasSubPrototype(value, EventTarget)) {
                        let propNames = Object.getOwnPropertyNames(Object.getPrototypeOf(value).prototype);
                        addEventNames(propNames);
                        propNames = Object.getOwnPropertyNames(window);
                        addEventNames(propNames);
                    }
                }
            });
            return events;
        }
    }
    Object.freeze(debugIt);
</script>
<script>
    function jsLoadOnce(src) {
        let paramsAt = fileName.lastIndexOf('?');
        const base = urlOnly(src);
        const scripts = document.getElementsByTagName('script');
        for (let script of scripts)
            if (src === script.src || urlOnly(script.src) === base)
                return;
        const tag = document.createElement('script');
        tag.src = src;
        document.getElementsByTagName('body')[0].appendChild(tag);
        function urlOnly(url) {
            let upTo = url.lastIndexOf('?');
            if(upTo !== -1)
                url = url.substring(0, upTo)
            upTo = fileName.lastIndexOf('#');
            return upTo === -1 ? url : url.substring(0, upTo);
        }
    }
    function basename(url) {
        var fileName = url.substring(url.lastIndexOf('/') + 1);
        var params = fileName.lastIndexOf('?');
        return params === -1 ? fileName : fileName.substring(0, params);
    }
</script>
<?php
echo require_once('../../backoffice/view/component/commons/dialog_consulta_existenciaColapsable.php');
?>
<hr>

<hr>

<?php

//compara_bed_producto_bodega_display();

function balanace_valor() {
    $balances = ia_sqlArray("SELECT * FROM campos_kv WHERE  concepto LIKE 'Balance%'", 'campos_kv_id');
    foreach($balances as $campos_kv_id => $b) {
        $valor = array_sum( array_column( json_decode($b['extras'], true), 'Saldo USD') );
        ia_query("UPDATE campos_kv SET valor=$valor WHERE campos_kv_id=$campos_kv_id");

    }
}
echo "<h3>En  php_uname('n') = " . php_uname("n") . " vs \$_SERVER['SERVER_NAME'] = " . ($_SERVER['SERVER_NAME'] ?? '') . "</h3>";

function menuAndExecute() {
    $menu = [
         //   'fixExistencias' => 'Fix Existencias',
          'bed' => 'Recalcular: Bodega Existencia Diaria',
        // 'bed_ver' => 'Ver BED',
        //'bem' => 'Recalcular: Bodega Existencia Mensual',
        'cont_cap' => 'Recalcular: Container Capacity',
        'bodega_x_dia' => 'Recalcular: Bodega x Día',
     //   'fixExistencias' => 'Fix Existencia',
    ];
    echo "<hr><fieldset style='margin:1em;padding:1em;width:fit-content;line-height: 3em'><legend>Menú</legend><ol>";
    foreach($menu as $value => $label)
        echo "<li><form method='POST'><input type='hidden' name='recalc' value='$value'><input type='submit' value='$label'></form>";
    echo "</ol></fieldset><hr>";
    if( !empty($_REQUEST['recalc'])) {
        echo "<h1>Doing: " . ($menu[$_REQUEST['recalc']] ?? "N/A") . Date(" H:i:s ") . "</h1>";
        switch($_REQUEST['recalc']) {
            case 'bed':
                $i = 0;
                bodega_existencia_diaria_recalcula(true, $i, false);
                diaVer("Amarilla", "Azucena", "Agua");
                diaVer("Virgoma", "Torneo", "Cielo");
                break;
            case 'bed_ver':
                diaVer("Amarilla", "Azucena", "Agua");
                diaVer("Virgoma", "Torneo", "Cielo");
                break;
            case 'fixExistencias': fixExistencias(); break;
            case 'bem': bodega_existencia_mensual(); break;
            case 'cont_cap': container_quantity_calculate(); break;
            case 'bodega_x_dia': bodega_x_dia_cache('2022-09-01'); break;
            default:
                echo "<h1>Unknown Option: " . htmlentities($_REQUEST['recalc']) . "</h1>";
        }
        echo "<h1>Done: " . ($menu[$_REQUEST['recalc']] ?? "N/A") . Date(" H:i:s ") . "</h1>";
    }
}

?>



<style>
    ul.tree, ul.tree ul {
        list-style: none;
        margin: 0;
        padding: 0;
    }
    ul.tree ul {
        margin-left: 10px;
    }
    ul.tree li {
        margin: 0;
        padding: 0 7px;
        line-height: 20px;
        color: #369;
        font-weight: bold;
        border-left:1px solid rgb(100,100,100);

    }
    ul.tree li:last-child {
        border-left:none;
    }
    ul.tree li:before {
        position:relative;
        top:-0.3em;
        height:1em;
        width:12px;
        color:white;
        border-bottom:1px solid rgb(100,100,100);
        content:"";
        display:inline-block;
        left:-7px;
    }
    ul.tree li:last-child:before {
        border-left:1px solid rgb(100,100,100);
    }
</style>
<div style="margin-left:4em;padding:1em;text-align: left;border:1px darkblue solid;width: fit-content">
    <ul class="tree">
        <li>All
            <ul>
                <li>Empresa<ul>
                        <li>Bodega<ul><li>Producto<ul><li>Color</ul><li>Color<ul><li>Producto</ul></ul>
                        <li>Producto<ul><li>Color</ul>
                        <li>Color<ul><li>Producto</ul>
                    </ul>
                <li>Grupo<ul>
                        <li>Bodega<ul><li>Producto<ul><li>Color</ul><li>Color<ul><li>Producto</ul></ul>
                        <li>Producto<ul><li>Color</ul>
                        <li>Color<ul><li>Producto</ul>
                    </ul>
                <li>Bodega<ul><li>Producto<ul><li>Color</ul><li>Color<ul><li>Producto</ul></ul>
                <li>Producto<ul><li>Color</ul>
                <li>Color<ul><li>Producto</ul>
            </ul>
        </li>
    </ul>
</div>
<hr>


<?php



function diaVer($bodega, $producto, $color) {
    $builder = new IacSqlBuilder();
    $where = $builder->where(['bodega' => $bodega, 'producto' => $producto, 'color' => $color]);
    $sql =
        "SELECT fecha,
                existencia_rollos as R_final,  
                    entrada_rollos as R_entrada, 
                    salida_rollos as R_Salidas,
                existencia_rollos_inicial as R_inicial,
                '' as R_Ok,

                existencia_quantity as Q_final,  
                    entrada_quantity as Q_entrada, 
                    salida_quantity as Q_Salidas,
                existencia_quantity_inicial as Q_inicial,
                '' as Q_Ok
         FROM bodega_existencia_diaria
         WHERE $where
         ORDER BY fecha DESC";
    echo iaTableIt::getTableIt(ia_sqlArrayIndx($sql), "$bodega $producto $color");
}

function bodega_existencia_diaria_recalcula($showProgress, &$i, $useNewClass) {
    $bed =  new BodegaExistenciaDiaria(false);
    $resets = ia_sqlArrayIndx(
        "SELECT DATE(alta_db) as fecha, bodega_id, producto_general_id, color_id, rollos, quantity, alta_por as usuario_por 
            FROM reset_history 
            ORDER BY alta_db");

    $notas = ia_sqlArray(
        "SELECT nb.nota_bodega_id, nb.fecha, nb.bodega_id, nb.producto_general_id, nb.entrada_salida, nb.tipo, nb.origen_id, nb.por_sistema 
        FROM nota_bodega nb
        WHERE nb.tipo NOT IN ('Cancelacion', 'Borrado')    
        ORDER BY fecha", 'nota_bodega_id'
    );

    global $gSqlClass;
    $gSqlClass->traceOn = false;

    if($showProgress)
        echo "<div style='padding:1em;margin:1em'><h1>Recalculando Bodega Existencia Diaria: <span id='van'></span> nota de " . bcformat(count($notas) + count($resets), 0) . " notas y resets</h1></div>";
    else
        echo "<h1>" . __FUNCTION__ . "</h1>";
    
    ia_query("DELETE FROM bodega_existencia_diaria");

    foreach($notas as $nota_bodega_id => $nota) {
        $items = ia_sqlArrayIndx("SELECT * FROM nota_bodega_items WHERE nota_bodega_id='$nota_bodega_id'");

            $queries = [];
            foreach($items as $item) {
                if($nota['tipo'] === 'Correccion' && $nota['por_sistema'] === '1')
                    $queries[] = $bed->sqlNotaAjustaItem($nota, $item);
                else
                    $queries[] = $bed->sqlRegistraItem($nota, $item);
                $next = $bed->updateRegistraExistenciaInicial($nota, $item);
                if(!empty($next))
                    $queries[] = $next;
            }

        if( !empty($queries))
            ia_transaction($queries);
        if( !empty($gSqlClass->errorLog_get())) {
            break;
        }
        if((++$i % 100) === 0 && $showProgress) {
            echo "<script>document.getElementById('van').innerHTML = '" . bcformat($i, 0) . "';</script>";
            ob_flush();
            flush();
        }
    }
    unset($notas);
    if($showProgress)
        echo "<script>document.getElementById('van').innerHTML = '" . bcformat($i, 0) . "';</script>";

    global $gDime;
    $gDime[] = "<h2>Resets</h2>";
    $gDime['resets'] = 0;

    foreach($resets as $r) {
        $gDime['resets']++;
        $r['rollos'] = bcmul("-1", $r['rollos'] ?? '0', 0);
        $r['quantity'] = bcmul("-1", $r['quantity'] ?? '0.00', 2);
        $queries = $bed->sqlResetItem($r);
if($r['bodega_id'] === '74867af2fe60ad6b11ec6d7b3badcba6' && $r['producto_general_id'] === '54bf6469e2cc850b11ec1ca9fdfac21f' && $r['color_id'] === '54bf6469e2cc850b11ec1c9224a12ebf') {
    $gDime[] = "<hr>";
    $gDime[] = $r;
    $gDime[] = $queries;
   // echo "<hr><pre>" . print_r($r, true) . print_r($queries, true) . "</pre>";
}
        if( !empty($queries))
            ia_transaction($queries);
        if( !empty($gSqlClass->errorLog_get())) {
            break;
        }
        if((++$i % 100) === 0) {
            echo "<script>document.getElementById('van').innerHTML = '" . bcformat($i, 0) . "';</script>";
            ob_flush();
            flush();
        }
    }
    if($showProgress)
        echo "<script>document.getElementById('van').innerHTML = '" . bcformat($i, 0) . "';</script>";

    if($showProgress)
        echo "<h1>DONE</h1>";
}



echo "<hr>";
ia_errores_a_dime();
echo ia_report_status_collapsable();
?>


<?php
function productoPerContainerMaxDefault() {
    $sql =
        "SELECT cont.producto_general_id, MAX(quantity) as max_quantity
        FROM (SELECT nb.producto_general_id,
                     SUM(nb.total_rolls) as rolls,
                     SUM(nb.total_quantity) as quantity,
                     u.unidad, nb.numero_contenedor,
                     (SELECT GROUP_CONCAT(pg1.producto)
                      FROM nota_bodega nb2 JOIN producto_general pg1 ON pg1.producto_general_id=nb2.producto_general_id
                      WHERE nb2.tipo = 'Container' AND nb2.numero_contenedor = nb.numero_contenedor) as productos_en_conentedor,
                     (SELECT COUNT(DISTINCT nb3.producto_general_id)
                      FROM nota_bodega nb3
                      WHERE nb3.tipo='Container' AND nb3.numero_contenedor  = nb.numero_contenedor) as
                         productos_en_contedor
              FROM nota_bodega nb
                       JOIN producto_general pg ON pg.producto_general_id = nb.producto_general_id
                       JOIN unidades u ON pg.unidades_id = u.unidades_id
              WHERE nb.tipo = 'Container'
              GROUP BY nb.producto_general_id, u.unidad, nb.numero_contenedor, 6, 7
              HAVING
                      (SELECT COUNT(DISTINCT nb3.producto_general_id)
                       FROM nota_bodega nb3
                       WHERE nb3.tipo='Container' AND nb3.numero_contenedor  = nb.numero_contenedor) = 1
             ) cont
        GROUP BY producto_general_id, unidad";
}

function container_quantity_calculate() {
    //ia_query("ALTER TABLE producto_general ADD COLUMN container_quantity_default DECIMAL(14,2) NOT NULL DEFAULT '0.00'");
    $sql =
        "SELECT cont.producto,
       MIN(rolls) as min_rolls, AVG(rolls) avg_rolls, MAX(rolls) as max_rolls,
       MIN(quantity) as min_quantity, AVG(quantity) avg_quantity, MAX(quantity) as max_quantity,
       unidad
FROM (SELECT pg.producto,
             SUM(nb.total_rolls) as rolls,
             SUM(nb.total_quantity) as quantity,
             u.unidad, nb.numero_contenedor,
             (SELECT GROUP_CONCAT(pg1.producto)
              FROM nota_bodega nb2 JOIN producto_general pg1 ON pg1.producto_general_id=nb2.producto_general_id
              WHERE nb2.tipo = 'Container' AND nb2.numero_contenedor = nb.numero_contenedor) as productos_en_conentedor,
             (SELECT COUNT(DISTINCT nb3.producto_general_id)
              FROM nota_bodega nb3
              WHERE nb3.tipo='Container' AND nb3.numero_contenedor  = nb.numero_contenedor) as
                 productos_en_contedor
      FROM nota_bodega nb
               JOIN producto_general pg ON pg.producto_general_id = nb.producto_general_id
               JOIN unidades u ON pg.unidades_id = u.unidades_id
      WHERE nb.tipo = 'Container'
      GROUP BY pg.producto, u.unidad, nb.numero_contenedor, 6, 7
      HAVING
              (SELECT COUNT(DISTINCT nb3.producto_general_id)
               FROM nota_bodega nb3
               WHERE nb3.tipo='Container' AND nb3.numero_contenedor  = nb.numero_contenedor) = 1
     ) cont
GROUP BY producto, unidad
ORDER BY 1";
    $perContainer = ia_sqlArray($sql, 'producto');
    foreach($perContainer as $producto => $p) {
        ia_query("UPDATE producto_general SET container_quantity_default = $p[max_quantity] WHERE producto = " . strit($producto));
    }
    iaTableIt::tableIt($perContainer, 'Container Quantity Per Product Recalculada');
}
?>
<?php

/**
 * GROUP BY (totals) por ..., ademas de Unit unidad_id que es por default)
 *
 */
enum BodegaExistenciaBy:string {
    case SIN = '';
    case EMPRESA = ', bm.Empresa';
    case GRUPO = ', bm.Grupo';
    case BODEGA = ', bm.Bodega';
    case PRODUCTO = ', bm.Producto';
    case EMPRESA_GRUPO = ', bm.Empresa, bm.Grupo';
    case EMPRESA_GRUPO_BODEGA = ', bm.Empresa, bm.Grupo, bm.Bodega';
    case EMPRESA_BODEGA = ', bm.Empresa, bm.Bodega';
    case EMPRESA_PRODUCTO = ', bm.Empresa, bm.Producto';
    case EMPRESA_BODEGA_PRODUCTO = ', bm.Empresa, bm.Bodega, bm.Producto';
    case BODEGA_PRODUCTO = ', bm.Bodega, bm.Producto';
    case PRODUCTO_BODEGA = ', bm.Producto, bm.Bodega';
    case ALL = ', bm.Empresa, bm.Grupo, bm.Bodega, bm.Producto';
}

class BodegaExistencia {

    public function dataset_dia($fecha, $bedBy, $dataset_id = ''):array {
        $method = __METHOD__;
        $sql = "";
        $ret = ia_sqlArrayIndx($sql);
        if($ret === false)
            throw new ErrorException("SQL Error");
        return [
            "id" => $bedBy instanceof BodegaExistenciaBy ? $bedBy->name : $dataset_id,
            "dimensions" => array_keys(reset($ret)),
            "source" => $ret
        ];
    }

    /**
     * @param BodegaExistenciaBy|String|Stringable $bedBy
     * @param String|Stringable $dataset_id en enum Bed_by defaults al nombre del case
     * @return array
     * @throws ErrorException
     */
    public function dataset_mensual($bedBy):array {
        $method = __METHOD__;
        $extraDimensions = ltrim($bedBy instanceof BodegaExistenciaBy ? $bedBy->value : "$bedBy");
        if(strlen($extraDimensions) > 0 &&  $extraDimensions[0] !== ',')
            $extraDimensions = ", $extraDimensions";
        $groupBy = implode(",", range(1, substr_count($extraDimensions, ",") + 2));
        $sql =
            "SELECT /*$method*/ 
                       bm.lastDayOfMonth as Month, IFNULL(u.Unidad, 'N/A') as Units $extraDimensions, 
                       SUM(existencia_rollos) as '∃ Rolls', SUM(existencia_quantity) as '∃ Qty',
                       SUM(salida_venta_rollos - entrada_devolucion_rollos) as 'Vta Rolls',
                       SUM(salida_venta_quantity - entrada_devolucion_quantity) as 'Vta Qty',
                       SUM(entrada_container_rollos) as 'Cnt Rolls', SUM(entrada_container_quantity) as 'Cnt Qty'
                FROM bodega_existencia_mensual bm
                         LEFT OUTER JOIN producto_general pg ON pg.producto_general_id = bm.producto_general_id
                         LEFT OUTER JOIN unidades u ON u.unidades_id = pg.unidades_id
                GROUP BY $groupBy
                ORDER BY 1";
        $data = ia_sqlArrayIndx($sql);
        if($data === false)
            throw new ErrorException("SQL Error");
        $porUnit = [];
        foreach($data as $d) {
            if(empty($porUnit))
                $porUnit[] = array_keys($d);
            $porUnit[] = array_values($d);
        }
        $groupBy = implode(",", range(1, substr_count($extraDimensions, ",") + 1));
        $sql =
            "SELECT /*$method*/ 
                       bm.lastDayOfMonth as Month $extraDimensions, 
                       SUM(existencia_rollos) as '∃ Rolls', 
                       SUM(salida_venta_rollos - entrada_devolucion_rollos) as 'Vta Rolls',
                       SUM(entrada_container_rollos) as 'Cnt Rolls'
                FROM bodega_existencia_mensual bm
                         LEFT OUTER JOIN producto_general pg ON pg.producto_general_id = bm.producto_general_id
                         LEFT OUTER JOIN unidades u ON u.unidades_id = pg.unidades_id
                GROUP BY $groupBy
                ORDER BY 1";
        $data = ia_sqlArrayIndx($sql);
        if($data === false)
            throw new ErrorException("SQL Error");
        $sinUnit = [];
        foreach($data as $d) {
            if(empty($sinUnit))
                $sinUnit[] = array_keys($d);
            $sinUnit[] = array_values($d);
        }

        return [
            "porUnit" => $porUnit,
            "sinUnit" => $sinUnit,
        ];
    }

}
?>
<!--suppress CssUnusedSymbol -->
<style id="grider_styles">
    .grider_grid-auto {
        --auto-grid-min-size: 4em;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(var(--auto-grid-min-size), 1fr));
        grid-gap: 1em;
    }

    /* a table */
    .grider_table {
        --auto-grid-min-size: 4em;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(var(--auto-grid-min-size), 1fr));
        grid-gap: 0;
        border:1px darkblue solid;
        border-collapse: collapse;
    }

    .grider_table DIV {
        padding:0.3em;
        border:1px darkblue solid;
    }

    /* masonry: https://css-tricks.com/a-lightweight-masonry-solution/ */

    /* toolbar */
    .grider_toolbar {
        --auto-grid-min-size: 4em;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(var(--auto-grid-min-size), 1fr));
        grid-gap: 0;
    }

    /* calendario */
    .ppSched {
        margin:0;
        padding:0.3em;
        border:1px darkblue solid;
        font-family: "Courier New", Courier, monospace;
    }
    .ppSched_titulo_mes {color:blue;text-align: center;width:100%}
    .ppSched_titulo_dias {
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        gap:0.5em;
        background-color:whitesmoke;
        margin-bottom:0.5em
    }
    .ppSched_days {
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        gap:0.2em
    }
    .ppSched_days DIV:first-child  { grid-column-start: 6; }
    .ppSched_day  {
        padding:0 0.5em 0.5em 0;
        border:1px darkblue solid;
        color:blue;
    }
    .ppSched_dayNum {
        width:fit-content;
        padding: 0.1em; color:#0000FF;
        border-bottom:1px blue solid;
        border-right:1px blue solid;
    }
    .ppSched_dayContent {
        background-color:whitesmoke;
    }


<?php

$i = 0;
function fixExistencias() {
    global $i;
    echo "<h2>1/5 Preparando " . Date(" H:i:s ") . "</h2>";
    $i = 0; bodega_existencia_diaria_recalcula(true, $i, false);
    echo "<h2>2/5 Inactve2fix " .  Date(" H:i:s ") . "</h2>";
    fixInactive();
    echo "<h2>3/5 Registrando " . Date(" H:i:s ") . "</h2>";
    $i = 0; bodega_existencia_diaria_recalcula(true, $i, false);

    echo "<h1>4/5 Missing Resets " . Date(" H:i:s ") . "</h1>";
    fixResetsMissing();
    echo "<h2>5/5 Registrando " . Date(" H:i:s ") . "</h2>";
    $i = 0; bodega_existencia_diaria_recalcula(true, $i, false);
}

function fixInactive() {
    $method = __METHOD__;
    $builder = new IacSqlBuilder();
    $inactiveConExistencia = ia_sqlArrayIndx(
        "SELECT /*$method inactive con existencia arregla */ MAX(bed.fecha) as fecha,
               bed.bodega, bed.producto, bed.color,
               bed.bodega_id, bed.producto_general_id, bed.color_id
        FROM bodega_existencia_diaria bed
        JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
        JOIN color c on bed.color_id = c.color_id
        WHERE (pg.activo = 'No' OR c.activo = 'No') 
        GROUP BY bed.bodega, bed.producto, bed.color,  bed.bodega_id, bed.producto_general_id, bed.color_id
        HAVING MAX(bed.fecha)
        ORDER BY bed.producto, bed.color");

    echo "<ol>";
    foreach($inactiveConExistencia as $d) {
        $where = [
            'bodega_id' => $d['bodega_id'],
            'producto_general_id' => $d['producto_general_id'],
            'color_id' => $d['color_id'],
            'fecha' => $d['fecha'],
        ];
        $q = ia_singletonFull(
                "SELECT /*$method inactive con existencia arregla */  existencia_quantity, existencia_rollos 
                    FROM bodega_existencia_diaria 
                    WHERE " . $builder->where($where), '0'
        );
        if(!is_array($q) || empty($q))
            continue;
        if(floatval($q['existencia_rollos']) == 0.00 && floatval($q['existencia_quantity']) === 0.00 )
            continue;
        echo "<li>$d[bodega] $d[producto] $d[color] $q[existencia_rollos] rollos $q[existencia_quantity] qty</li>";
        $reset = [
            'bodega_id' => $d['bodega_id'],
            'producto_general_id' => $d['producto_general_id'],
            'color_id' => $d['color_id'],
            'alta_db' => $d['fecha'],
            'alta_por' => 'sistema',
            'rollos' =>  floatval($q['existencia_rollos'] ?? 0),
            'quantity' =>  floatval($q['existencia_quantity'] ?? 0),
        ];
        ia_query($builder->insert('reset_history', $reset));
    }
    echo "</ol><hr>";

}

function fixResetsMissing() {

    $n = 0;
    $builder = new IacSqlBuilder();
    $sql = compara_bed_producto_bodega_sql();
    $bed = ia_sqlArray($sql['sql_bed'], 'id');
    $producto_bodega = ia_sqlArray($sql['sql_producto_bodega'], 'id');
    echo "<ol>";
    foreach($producto_bodega as $id => $pb) {
        if(!array_key_exists($id, $bed))
            continue;
        $pb['Rolls'] = intval($pb['Rolls']);
        $pb['Quantity'] = floatval($pb['Quantity']);
        $b = $bed[$id];
        $b['Rolls'] = intval($b['Rolls']);
        $b['Quantity'] = floatval($b['Quantity']);
        if($pb['Quantity'] === $b['Quantity'] && $pb['Rolls'] === $b['Rolls'])
            continue;
        if(abs($pb['Quantity'] - $b['Quantity']) > 50 || abs($pb['Rolls'] - $b['Rolls']) > 3)
            continue;
        $reset = [
            'bodega_id' => $pb['bodega_id'],
            'producto_general_id' => $pb['producto_general_id'],
            'color_id' => $pb['color_id'],
            'alta_db' => '2023-05-01',
            'alta_por' => 'sistema',
            'rollos' =>  $b['Rolls'] - $pb['Rolls'],
            'quantity' =>  $b['Quantity'] - $pb['Quantity'],
        ];
        $n++;
        ia_query($builder->insert('reset_history', $reset));
        echo "<li>$id q=" . ($b['Quantity'] - $pb['Quantity']) . ", r=" . ($b['Rolls'] - $pb['Rolls']) . "</li>";
    }
    echo "</ol>";
    echo "<h3>Done n=$n " . Date(" H:i ") . "</h3>";
}

function compara_bed_producto_bodega_sql():array {
    $sql['sql_producto_bodega'] =
        "SELECT CONCAT_WS('_', b.Bodega, pg.Producto, c.Color) as id,
                pb.bodega_id, pb.producto_general_id, pb.color_id,
               SUM(pb.existencia_rollos) as Rolls,
               SUM(pb.existencia_quantity) as Quantity,
               SUM(IF(pg.container_quantity = 0, 0, pb.existencia_quantity/pg.container_quantity)) as Containers,
               SUM(pb.existencia_quantity * IFNULL(pbc.cost_cif, 0)) AS CIF,
               SUM(IF(pb.existencia_rollos < 0, pb.existencia_rollos, 0.00)) as Neg_Rolls,
               SUM(IF(pb.existencia_quantity < 0, pb.existencia_quantity, 0.00)) as Neg_Qty
        FROM producto_bodega pb
            JOIN producto_general pg ON pb.producto_general_id = pg.producto_general_id
            JOIN unidades u ON u.unidades_id = pg.unidades_id
            JOIN color c ON c.color_id = pb.color_id
            JOIN bodega b ON b.bodega_id = pb.bodega_id
            JOIN empresa e ON e.empresa_id = b.empresa_id
            LEFT OUTER JOIN producto_costs_bodega pbc ON pb.producto_general_id = pbc.producto_general_id AND fecha_fin IS NULL
        GROUP BY CONCAT_WS('_', b.Bodega, pg.Producto, c.Color),pb.bodega_id, pb.producto_general_id, pb.color_id
        ";

    global $gStrIt;
    $fecha = Date('Y-m-d');
    $sql['sql_bed'] =
        "WITH dia as  (
            SELECT MAX(fecha) as fecha, bodega_id, producto_general_id, color_id
            FROM bodega_existencia_diaria
            WHERE fecha <= {$gStrIt($fecha)}
            GROUP BY bodega_id, producto_general_id, color_id
            HAVING MAX(fecha)
        )
        SELECT CONCAT_WS('_', b.Bodega, pg.Producto, c.Color) as id,
               SUM(bed.existencia_rollos) as Rolls, SUM(bed.existencia_quantity) as Quantity,
               SUM(IF(pg.container_quantity = 0, 0,  bed.existencia_quantity/pg.container_quantity)) as Containers
            -- TODO cost * cost_inventory
            FROM bodega_existencia_diaria bed
                JOIN dia ON
                    bed.fecha = dia.fecha
                    AND bed.bodega_id = dia.bodega_id
                    AND bed.producto_general_id = dia.producto_general_id
                    AND bed.color_id = dia.color_id
                JOIN producto_general pg ON pg.producto_general_id = dia.producto_general_id
                JOIN unidades u ON u.unidades_id = pg.unidades_id
                JOIN bodega b ON b.bodega_id = bed.bodega_id
                JOIN empresa e ON e.empresa_id = b.empresa_id
                JOIN color c ON c.color_id = bed.color_id
        GROUP BY  1";
    return $sql;
}

function compara_bed_producto_bodega_display() {
    $sql = compara_bed_producto_bodega_sql();

    $bed = ia_sqlArray($sql['sql_bed'], 'id');
    $producto_bodega = ia_sqlArray($sql['sql_producto_bodega'], 'id');
    echo "<h1>bed vs pb " . Date(" H:i ") ."</h1><ul>";
    echo "<li>bed: " . count($bed) . ", pb: " . count($producto_bodega) . "</li>";
    echo "<ol>";
    foreach($producto_bodega as $id => $pb) {
        if(!array_key_exists($id, $bed)) {
            if($pb['Rolls']!=0 || $pb['Quantity']!=0)
                echo "<li>$id in pb <span style='color:red'>not in bed</span>";
            continue;
        }
        $b = $bed[$id];
        if($b['Rolls'] !== $pb['Rolls']) {
            if($b['Quantity'] !== $pb['Quantity'])
                echo "<li><b>$id</b> <b style='color:red'>Rolls: pb/bed $pb[Rolls]/$b[Rolls] Qty: $pb[Quantity]/$b[Quantity]</b>";
            else
                echo "<li><b>$id</b> <b>Rolls: pb/bed $pb[Rolls]/$b[Rolls]</b> Qty: $pb[Quantity]/$b[Quantity]";
        } elseif($b['Quantity'] !== $pb['Quantity'])
            echo "<li><b>$id</b> Rolls: pb/bed $pb[Rolls]/$b[Rolls] <b>Qty: $pb[Quantity]/$b[Quantity]</b>";
    }
    $d2 = array_diff_key($producto_bodega,$bed);
    echo "<li>bed vs pb: " . implode(", ", array_keys($d2));
    echo "</ol>";
}
?>
<hr>,
    <div style="margin:2em">
    <div style="padding:0.5em;width:21em;background-color: silver;display:flex;flex-direction: row;flex-wrap: nowrap;justify-content: space-between;align-items:flex-end">
        <div style="left:0">149,195</div>        <div>151,401</div>        <div>153,687</div>  </div>  </div>,
<style>
    .boxPlot1Container {margin:0.3em;padding:0.3em; min-width: 8em; width:fit-content;}
    .boxPlot1Plot      {margin:0 1em 0 1em;padding:0; border:3px silver outset;height:1.5em }
    .boxPlot1Legend    {margin:0;padding:0; font-size:0.7em;
        font-family: "SFMono-Regular",  lato, sans-serif;
        display:flex;flex-direction:row;flex-wrap:nowrap;gap:0.5em; justify-content:space-between;
    }
    .boxPlot1Legend p {text-align: center;margin:0;padding:0;font-size:0.9em;color:black}
</style>
<div class="boxPlot1Container">
    <div id="" class="boxPlot1Plot" style='background:linear-gradient(90deg, green 30%, red 10%)'></div>
    <div class='boxPlot1Legend'>
        <div style="color:blue;text-align: left">0</div>
        <div style='color:black;text-align: center'>0%<p>Usado</div>
        <div style='color:red;text-align: right'>100%<p>Libre</p></div>
    </div>
</div>

<script>try {history.replaceState({content: document.title}, document.title, document.location.href);} catch(e) {}</script>
<script src="/vitex/js2/clipboard.js"></script>
</body>
</html>