<?php
require_once('../../inc/config.php');
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Try Me</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <?php
    global $gIaHeader;
    $gIaHeader->html_head_add(['jquery-ui', 'multiselect', 'ia']);
    $gIaHeader->html_head_echo();
    ?>
    <link rel="stylesheet" href="../../js2/clasificame/clasificame.css" crossorigin="anonymous"
          referrerpolicy="no-referrer"/>
    <script src="../../js2/clasificame/clasificame.js"></script>
</head>
<body>
<h1>Try Me</h1>
<?php
$f = new iacase_base();
$f->label = "Traslados entre Bodegas";
$f->permiso_insert = $f->permiso_delete = $f->permiso_list = $f->permiso_read = $f->permiso_read = false;
$f->process_action();
$f->h = 'x';
$f->toolbar_set();
include('../../backoffice/header.php');
echo $f->form_tag();
$f->display_toolbar();
echo '</form>';
?>
<?php


$permisador = new Permisador();
$users = $permisador->getUsers();
$puede = $permisador->getPuede();
$porBodega = $permisador->getPorBodega();
?>
<script>
    let permisa_iac_usr = {
        gUsr: <?php echo json_encode($users); ?>,
        bodegas: <?php echo json_encode(ia_sqlKeyValue("SELECT bodega_id, bodega FROM bodega WHERE activo='Si' ORDER BY 2")); ?>,
        tiendas: <?php echo json_encode(ia_sqlKeyValue("SELECT tienda_id, clave FROM tienda WHERE vale='Active' ORDER BY 2")); ?>,

        _opciones: function (permiso) {
            const puede = <?php echo json_encode($puede); ?>;
            if (puede.hasOwnProperty(permiso))
                return puede[permiso];
            return 'sino';
        },
        _values: function (permiso) {
            let ret = [];
            for (let aUsr in this.gUsr)
                if (this.gUsr.hasOwnProperty(aUsr)) {
                    let a = this.gUsr[aUsr];
                    let p = {iac_usr_id: a.iac_usr_id, nick: a.nick}
                    p[permiso] = a[permiso];
                    ret.push(p);
                }
            return ret;
        },

        controles: function (que, enTienda_id, enBodega_id) {
            let clasif = {
                rorw: [
                    {clasificaId: 'Nada', label: 'X', title: 'Sin Permiso'},
                    {clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura'},
                    {clasificaId: 'RW', label: 'RW', title: 'Editar'},
                ],
                nosi: [
                    {clasificaId: 'No', label: 'No', title: 'No puede'},
                    {clasificaId: 'Si', label: 'Si', title: 'Si puede'},
                ],
                norosi: [
                    {clasificaId: 'No', label: 'No', title: 'No puede'},
                    {clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura'},
                    {clasificaId: 'Si', label: 'Si', title: 'Si puede'},
                ],
                sino: [
                    {clasificaId: 'Si', label: 'Si', title: 'Si puede'},
                    {clasificaId: 'No', label: 'No', title: 'No puede'},
                ],
                rorwcontsino: [
                    {clasificaId: 'No', label: 'No', title: 'No puede'},
                    {clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura'},
                    {clasificaId: 'CONT', label: 'CONT', title: 'Contabilidad'},
                    {clasificaId: 'RW', label: 'RW', title: 'Editar'},
                    {clasificaId: 'Si', label: 'Si', title: 'Si puede'},

                ],
            }
            let control = [];
            for (let permiso of que) {
                let c = permisa_iac_usr._opciones(permiso);
                let clasificacion = typeof c === 'string' ?
                    clasif[c] : c;

                control.push(
                    $(`<div id='${permiso}'/>`).clasificame({
                        'clasificacion': clasificacion,
                        valueId: 'iac_usr_id',
                        valueDisplay: 'nick',
                        valueColumnKey: permiso,
                        values: permisa_iac_usr._values(permiso),
                    })
                );
            }
            return control;
        },

        removeParentLi: function(el) {
            let $li = $(el).parents("li").first();
            if (!$li.parent().hasClass('ui-droppable'))
                return;
            $li.addClass('backgroundRed').effect("pulsate", {}, 1000,
                function () {
                    $li.remove();
                }
            )
        },
    }


    function taka(permisos, enTienda, enBodega) {
        let pon = $('<div id="pon" style="margin:1em;border:1px silver solid;display: flex;"></div>');
        let da = permisa_iac_usr.controles(permisos, enTienda, enBodega);
        for (let d of da)
            pon.append(d);
        pon.dialog({
            modal: true,
            closeOnEscape: true,
            title: "Permisador",
            draggable: true,
            resizable: true,
            width: '95%',
            buttons: [
                {
                    text: "Guardar",
                    icon: "ui-icon-check",
                    click: function () {
                        let cambios = {};
                        for (let d of da) {
                            cambios[d.clasificame('option', 'valueColumnKey')] = d.clasificame('value');
                        }
                        $("#per").html("<h1>Permisos Quedaron</h1>" + print_r(cambios));
                        console.log("cambiar esto: ", cambios);
                        $(this).dialog("close");
                    },

                },
                {
                    text: "Cancelar",
                    icon: "ui-icon-closethick",
                    click: function () {
                        $("#per").html("Canceled clicked");
                        $(this).dialog("close");
                    },
                }
            ],
            close() {
            },
        })
    }

    function print_r(obj, returnTheValue, consoleLogTag) {
        if(returnTheValue)
            return dump(obj);
        console.log(consoleLogTag || '', obj);
        function dump(obj) {
            if (obj === null)
                return 'null';
            if (typeof obj !== 'object')
                return obj;
            let tab = arguments[1] || '';
            if (Array.isArray(obj)) {
                let outAr = [];
                for (let e of obj)
                    outAr.push(dump(e, typeof e === 'object' ? "\t" + tab : ""));
                return "[" + outAr.join(", ") + "]";
            }
            if (obj instanceof Date)
                return `new Date(${obj.getTime()})`;
            let tab2 = tab + (tab === '' ? '\t' : tab);
            let out = [];
            for (let e in obj)
                if (obj.hasOwnProperty(e))
                    out.push(e + ": " + dump(obj[e], tab2));
            return "{\n" + tab2 + out.join(",\n" + tab2) + "\n" + tab + "}\n";
        }
    }
    var data={a:1,x:2,d:[1,2,3,{z:1,y:[1,2]}],f:new Date(), h:{b:1,c:2,h:false}};
    print_r(data);
</script>
<button style="padding:1em;margin:1em" type="button" onclick="taka(['puede_clientes', 'puede_banco_china'])">
    taka(['puede_clientes', 'puede_banco_china']);
</button>

<pre id="per" style="margin:1em;padding:1em;font-family: 'Courier New', monospace;border:1px silver solid"></pre>
<hr>

<style>
    .flexBoxRow {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: flex-start;
        align-items: stretch;
        align-content: stretch;
    }
    .flexBoxCol {
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
        justify-content: flex-start;
        align-items: stretch;
        align-content: stretch;
    }
    .grabme {cursor:grab}
    .backgroundRed{background-color: red!important;color:yellow!important;}
    .showNoDrag {background-color: lightyellow!important;}
</style>

<fieldset id="permisadorRegistraNotasBodega" style="margin:1em;border:1px silver solid;" class="flexBoxRow"><legend>Permisos: Notas de Bodega</legend>
    <div style='margin:1em;border:1px blue solid;'>
        <ul class="clasificaItemList permisadorUserDragger"  style="max-height:initial!important;height:initial!important;">
            <?php
            foreach($permisador->getUsers() as $id => $u) {
                $tache = "<span class='' title='Quitar' style='float:right;cursor:pointer;color:red;' onclick='permisa_iac_usr.removeParentLi(this)'>⭙</span>";

                if($u['puede_supervisar_bodega'] !== 'Si' && $u['puede_registrar_todas_bodegas'] !== 'Si' && $u['puede_solo_consultar_bodegas'] !== 'Si')
                    echo "<li class='liUser grabme' data-id='$id' style='max-width: 9em'>$u[nick] $tache</li>";
            }
            ?>
        </ul>
    </div>
    <fieldset style="margin:1em;padding:0.1em;width:fit-content;border:1px red solid" class="flexBoxCol"><legend>Por Bodega</legend>
        <?php
            $prevGrupo = null;
            foreach(ia_sqlArray("SELECT bodega_id, grupo, bodega FROM bodega WHERE activo='Si' ORDER BY grupo, bodega", 'bodega_id') as $bodega_id=>$b) {
                if($prevGrupo !== $b['grupo']) {
                    if($prevGrupo !== null)
                        echo "\r\n</fieldset>";
                    $prevGrupo = $b['grupo'];
                    echo '<fieldset style="margin:1em;padding:0.1em;width:fit-content" class="flexBoxRow"><legend>' . $b['grupo'] . '</legend>';
                }
                $ro = $permisador->liPorBodega($bodega_id, 'puede_movimientos', 'R/O');
                $rw = $permisador->liPorBodega($bodega_id, 'puede_movimientos', 'R/W');
                echo "<div style='margin:1em;border:1px blue solid;'>
                    <table id='permisador$bodega_id'><caption>$b[bodega]</caption><th>RO</th><th>RW</th><tr>
                        <td><ul id='ro$bodega_id' data-to='rw$bodega_id' class='clasificaItemList permisadorUserDroppable'>$ro</ul></td>
                        <td><ul id='rw$bodega_id' data-to='ro$bodega_id' class='clasificaItemList permisadorUserDroppable'>$rw</ul></td>
                        </tr></table></div>";
            }
            echo "</fieldset>";
        ?>
    </fieldset>
</fieldset>
<script>
    jQuery(function($){
        dotit();
    });
    function dotit() {
        $(".permisadorUserDragger LI").draggable({
            scroll: true,
            cancel: ".noDrag", // clicking div toolbar no inicia drag
            revert: "invalid", // when not dropped, the item will be returned to its initial position
            containment: "document",
            helper: "clone",
            cursor: "move",
        });
        $(".permisadorUserDroppable LI").draggable({
            scroll: true,
            cancel: ".noDrag", // clicking div toolbar no inicia drag
            revert: "invalid", // when not dropped, the item will be returned to its initial position
            containment: "document",
            helper: "clone",
            cursor: "move",
        });
        $(".permisadorUserDroppable").droppable({
            accept: `.liUser`,
            drop: function( event, ui ) {
                let id = ui.draggable.data('id')
                let $to = $(event.target);
                let hay = $to.parents("TD").find(`LI[data-id='${id}']`);
                if(hay.length) {
                    hay.addClass('backgroundRed').effect( "pulsate", {}, 1000,
                        function(){ hay.removeClass('backgroundRed'); }
                    );
                } else {
                    let matame =  $to.parents("TR").find(`LI[data-id='${id}']`);
                    if(matame.length)
                        matame.remove();
                    let n = ui.draggable.clone();
                    $to.append(n);
                    n.draggable({
                        scroll: true,
                        cancel: ".noDrag", // clicking no inicia drag
                        revert: "invalid", // when not dropped, the item will be returned to its initial position
                        containment: "document",
                        helper: "clone",
                        cursor: "move",
                    })
                }
            },
            classes: {"ui-droppable-active": "custom-state-active"},
        });
    }
</script>
<?php
//include('../../backoffice/footer.php');
?>
</body>
</html>
