<!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <title>Styler</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <link href="../../../jquery-ui-themes/themes/redmond/jquery-ui.min.css" rel="stylesheet"  type="text/css"/>
    <link href="../../css2/jquery-ui-1.12.icon-font.min.css" rel="stylesheet"  type="text/css"/>


    <script src="../../js2/jquery-3.6.4.min.js"></script>
    <script src="../../js2/jquery-ui-1.13.2.redmond/jquery-ui.min.js"></script>

    <link rel="stylesheet" href="../../js2/spectrum/spectrum.css">
    <script src="../../js2/spectrum/spectrum.js"></script>
    <script src="../../js2/js_libs/styleSheet/styleSheet.js"></script>


    <style id="styler_css">
        #styler LABEL {cursor:pointer}
        .stylerColorClick {border:3px #d1cbd1 inset;background-color: #e6e6e6;}
        .stylerStatusButton {display:none}
        .stylerStatusButton + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 inset; background-color: #e6e6e6}
        .stylerStatusButton:checked + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 outset;background-color: silver}
        .stylerLabelHasChecked {}
        INPUT[name="styler_text-decoration"]:checked {box-shadow: 0 0 0 3px blue;cursor:pointer}
    </style>


</head>
<body>
    <div id="styler" title="Styler" style="display:none">
        <fieldset>
            <div style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start">
                <fieldset><legend>Ejemplo</legend>
                    <div id="styler_ejemplo" style="border:1px silver solid;width:8em">Text 1,234.56</div>
                </fieldset>
                <fieldset style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start"><legend>Texto</legend>
                    <div>
                        <input type="text" class="spectrumColorPicker" id="styler_color" value="#000">
                        <input id="styler_font-weight" type="checkbox" class="stylerStatusButton"
                               value="900"><label title="Negrita, Bold" for="styler_font-weight" style="font-weight: bold">B</label
                        ><input id="styler_font-style" type="checkbox" class="stylerStatusButton"
                                value="italic"><label title="Cursiva, Italica" for="styler_font-style" style="font-style:italic">I</label
                        >
                        <input id="styler_text-align_left" name="styler_text-align" type="radio" class="stylerStatusButton"
                               checked="checked"
                                value="left"><label title="Alinear a la izquierda" for="styler_text-align_left" style="text-align: left;padding-left:0.1em;padding-right:0.9em">&equiv;</label
                        ><input id="styler_text-align_center" name="styler_text-align" type="radio" class="stylerStatusButton"
                                value="center"><label title="Centrado" for="styler_text-align_center" style="text-align: center">&equiv;</label
                        ><input id="styler_text-align_right" name="styler_text-align" type="radio" class="stylerStatusButton"
                                value="right"><label title="Alinear a la derecha" for="styler_text-align_right" style="text-align: right;padding-right:0.1em;padding-left:0.9em">&equiv;</label>
                            <select id="styler_font-size">
                                <option style="0.6em" value="smaller">60%</option>
                                <option style="0.8em" value="smaller">80%</option>
                                <option style="0.9em" value="smaller">90%</option>
                                <option style="0.95em" value="smaller">95%</option>
                                <option style="1em" value="1em">Normal</option>
                                <option style="1.10em" value="1.1em">110%</option>
                                <option style="1.5em" value="1.5em">150%</option>
                                <option style="1.75em" value="1.75em">175%</option>
                                <option style="2em" value="2em">200%</option>
                                <option style="2.5em" value="2.5em">250%</option>
                            </select>
                    </div>
                </fieldset>
                <fieldset><legend>Fondo</legend>
                    <input id="styler_background-color1" type="text" class="spectrumColorPicker" value="">
                    <select id="styler_background-per1"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>30%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                    <p>
                        <input id="styler_background-color2" class="spectrumColorPicker" value="">
                        <select id="styler_background-per2"><option></option><option>0%</option><option>5%</option>
                            <option>10%</option><option>20%</option><option>30%</option>
                            <option>40%</option><option>50%</option><option>60%</option>
                            <option>70%</option><option>80%</option><option>90%</option>
                        </select>
                    <p>
                        <input id="styler_background-color3" class="spectrumColorPicker" value="">

                        <select id="styler_background-per3"><option></option><option>0%</option><option>5%</option>
                            <option>10%</option><option>20%</option><option>30%</option>
                            <option>40%</option><option>50%</option><option>60%</option>
                            <option>70%</option><option>80%</option><option>90%</option>
                        </select>
                    <p>
                        <input id="styler_background-color4" class="spectrumColorPicker" value="">
                        <select id="styler_background-per4"><option></option><option>0%</option><option>5%</option>
                            <option>10%</option><option>20%</option><option>25%</option>
                            <option>30%</option><option>33%</option>
                            <option>40%</option><option>50%</option><option>60%</option>
                            <option>70%</option><option>80%</option><option>90%</option>
                        </select>
                    <p>
                        <select id="styler_background_gradient">
                            <option value="">Solid</option>
                            <option value="conic-gradient">Cónico</option>
                            <option value="repeating-conic-gradient">Cónico R</option>
                            <option value="linear-gradient">Lineal</option>
                            <option value="repeating-linear-gradient">Lineal R</option>
                            <option value="radial-gradient">Radial</option>
                            <option value="repeating-radial-gradient">Radial R</option>
                        </select>
                        <select id="styler_background_gradient_tag">
                        </select>
                </fieldset>
                <div>
                    <label>Margen<br><select id="styler_padding">
                            <option style="padding:inherit" value="inherit">Default</option>
                            <option value="0.3em">Poco</option>
                            <option value="0.5em">Mediano</option>
                            <option value="1em">Grande</option>
                        </select>
                    </label>
                </div>
                <fieldset><legend>Énfasis</legend>
                    <div>
                        <div><select id="styler_text-emphasis-style">
                                <option value="none">Sin</option>
                                <option value="'✄'">✄</option>
                                <option value="'⚐'">⚐</option>
                                <option value="'⚑'">⚑</option>
                                <option value="'☂'">☂</option>
                                <option value="'♪'">♪</option>
                                <option value="'+'">+</option>
                                <option value="'*'">*</option>
                                <option value="'^'">^</option>
                                <option value="'|'">|</option>
                                <option value="'~'">~</option>
                                <option value="'´'">´</option>
                                <option value="'`'">`</option>
                                <option value="'¨'">¨</option>
                                <option value="double circle open">Ojo</option>
                            </select>
                            <input id="styler_text-emphasis-color" type="text" class="spectrumColorPicker" value="">
                            <input id="styler_text-emphasis-position_over" name="styler_text-emphasis-position" type="radio"
                                   class="stylerStatusButton" value="over" checked="checked"><label
                                    title="Poner en énfasis arriba. Tipo cambié el margen"
                                    for="styler_text-emphasis-position_over"><sup>&OverBracket;</sup></label
                            ><input id="styler_text-emphasis-position_under" name="styler_text-emphasis-position" type="radio" class="stylerStatusButton"
                                    value="under"><label title="Poner en énfasis abajo.  Tipo cambié el margen" for="styler_text-emphasis-position_under"
                            ><sub>&UnderBracket;</sub></label>
                        </div>
                </div>
                </fieldset>
                <fieldset><legend>Lineado</legend>
                    <table style="border:4px inset silver;padding-left:0.5em;padding-right:0.5em">
                    <tr>
                        <td><label class="stylerLabelHasChecked"><input type="radio" checked="checked" name="styler_text-decoration" value="none"> Normal</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:line-through"><input type="radio" name="styler_text-decoration" value="line-through"> Tachado</label>
                        <td>
                            <input id="styler_text-decoration-color" class="spectrumColorPicker" value="">
                        <td>
                            <select id="styler_text-decoration-thickness">
                                    <option style="text-decoration-thickness:from-font" value="from-font">Ancho</option>
                                    <option style="text-decoration-thickness:1px" value="1px">1px</option>
                                    <option style="text-decoration-thickness:4px" value="2px">2px</option>
                                    <option style="text-decoration-thickness:4px" value="3px">3px</option>
                                    <option style="text-decoration-thickness:4px" value="4px">4px</option>
                                    <option style="text-decoration-thickness:5px" value="4px">5px</option>
                                    <option style="text-decoration-thickness:6px" value="4px">6px</option>
                                </select>
                    </tr>
                    <tr style="line-height: 2em">
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline solid"><input type="radio" name="styler_text-decoration" value="underline solid"> Subrayado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline double"><input type="radio" name="styler_text-decoration" value="underline double"> Doble</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline dotted"><input type="radio" name="styler_text-decoration" value="underline dotted"> Punteado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline wavy"><input type="radio" name="styler_text-decoration" value="underline wavy"> Ondulado</label>
                    <tr style="line-height: 2em">
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:overline solid;" ><input type="radio" name="styler_text-decoration" value="overline solid"> Testado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:overline double" ><input type="radio" name="styler_text-decoration" value="overline double"> Doble</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:overline dotted" ><input type="radio" name="styler_text-decoration" value="overline dotted"> Punteado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:overline wavy" ><input type="radio" name="styler_text-decoration" value="overline wavy"> Ondulado</label>
                    <tr style="line-height: 2em">
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline" ><input type="radio" name="styler_text-decoration" value="underline overline solid"> Marcado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline double" ><input type="radio" name="styler_text-decoration" value="underline overline double"> Doble</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline dotted" ><input type="radio" name="styler_text-decoration" value="underline overline dotted"> Punteado</label>
                        <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline wavy" ><input type="radio" name="styler_text-decoration" value="underline overline wavy"> Ondulado</label>
                </table>
                </fieldset>
            </div>
        </fieldset>
    </div>
    <script id="styler_js_code">
        let styler = {
            defaults: {
                borders:false, // allow border styling
                element_id: null, // addclass cssName to element_id
                jqGrid: null, // grid_id or $grid
                jqGrid_column_name: null, // add class tojqGrid.jqGrid_column_name
                dialog: {},
            },
            needInit: true,
            settings: {},

            dialog: function(options, cssName) {
                styler.settings = {};
                $.extend(styler.settings, styler.defaults, {cssName:cssName  || ""}, options || {});
                styler.settings.done = false;
                if(styler.needInit)
                    styler._dialog_init();
                if(styler.settings.cssName.length)
                    styler.setValues(styleSheetsHelper.getStyleObject("." + styler.settings.cssName));
                styler._formatForm();
                $("#styler").dialog($.extend({},
                    {
                        close: function() {
                            let styles = styler.getStyles(), styleLine = styler.getStyleLine(styles);
                            let sendEvent ='stylerCancel';
                            let cssName = styler.settings.cssName;
                            if(styler.settings.done) {
                                sendEvent = 'stylerDone';
                                if(cssName.length) {
                                    styleSheetsHelper.setStyle('.' + cssName, styleLine);
                                    styler.settings.cssNameAdded = true;
                                    if(styler.settings.element_id !== null)
                                        $("#" + styler.settings.element_id).addClass(cssName);
                                    if(styler.settings.jqGrid !== null && styler.settings.jqGrid_column_name !== '') {
                                        let grid = typeof styler.settings.jqGrid === 'string' ?
                                            $("#" + styler.settings.jqGrid) : $(styler.settings.jqGrid);
                                        let col = styler.settings.jqGrid_column_name;
                                        let colModel = grid.jqGrid("getColProp", col);
                                        if(colModel.classes.search(cssName) < 0) {
                                            colModel.classes = colModel.classes + " " + cssName;
                                            grid.jqGrid("setColProp", col);
                                        }
                                    }
                                }
                            }
                            $("#styler")
                                .trigger(sendEvent,
                                    {styles, styleLine, settings:styler.settings});
                        },
                        closeOnEscape: true,
                        width: "95%", height: window.innerHeight - 200,
                        buttons: [
                            {
                                text: 'Ok',
                                icon: "ui-icon-check",
                                click: function () {
                                    styler.settings.done = true;
                                    $("#styler").dialog( "close" );
                                }
                            },
                            {
                                text: "Cancel",
                                id:"dialogme_cancel",
                                icon: "ui-icon-close",
                                click: function () {
                                    $("#styler").dialog("close");
                                }
                            },
                        ],
                },
                    styler.settings.dialog
                )).dialog("moveToTop");
            },

            getStyles:function() {
                let $styler = $("#styler");
                let styles = {
                    'color': $("#styler_color", $styler).val(),
                    'text-emphasis-color': $("#styler_text-emphasis-color", $styler).val(),
                    'font-weight': $("#styler_font-weight", $styler).is(":checked") ? "900" : '400',
                    'font-style': $("#styler_font-style", $styler).is(":checked") ? "italic" : 'normal',
                    'font-size': $("#styler_font-size", $styler).val(),
                    'text-align': $("input[name='styler_text-align']:checked", $styler).val(),
                    'padding': $("#styler_padding", $styler).val(),

                    'text-decoration': $("input[name='styler_text-decoration']:checked", $styler).val(),
                    'text-decoration-thickness': $("#styler_text-decoration-thickness", $styler).val(),
                    'text-decoration-color': $("#styler_text-decoration-color", $styler).val(),
                    'text-emphasis-style': $("#styler_text-emphasis-style", $styler).val(),
                    'text-emphasis-position': $("input[name='styler_text-emphasis-position']:checked").val(),
                    'text-decoration-skip-ink': 'none',
                    'background-color': '',
                    'background': '',
                };
                if(styles["text-decoration-color"] === "" || styles["text-decoration-color"] === "none")
                    styles["text-decoration-color"] = "inherit";
                let bk = [];
                for(let i=1; i<=4; ++i) {
                    let bakcgroundColor = $(`#styler_background-color${i}`, $styler).val();
                    if(bakcgroundColor.length === 0)
                        continue;
                    bk.push( bakcgroundColor + ' ' +
                        $(`#styler_background-per${i}`, $styler).val()
                    );
                }
                let gradient = $("#styler_background_gradient", $styler).val();
                // console.log(`________set para grad ${gradient}`, bk);
                if(bk.length === 1 || gradient === '') {
                    styles['background-color'] = $("#styler_background-color1", $styler).val();
                    // console.log(" 1 color sin gradientes background-color:", styles['background-color'])
                } else if(bk.length > 1) {
                    if(gradient === '')
                        gradient = 'linear-gradient';
                    let angle = $("#styler_background_gradient_tag", $styler).val();
                    if(angle === null)
                        angle = '';
                    if(angle.length)
                        angle += ',';
                    styles['background'] = `${gradient}(${angle} ${bk.join(', ')})`; // ${angle}
                }
                if(styles['text-decoration-color'] === '')
                    styles['text-decoration-color'] = 'none';
                for(let s in styles)
                    if(styles.hasOwnProperty(s) && styles[s] === '')
                        delete(styles[s]);
                return styles;
            },

            getStyleLine: function(styles) {
                let cssClass = [];
                for(let c in styles)
                    if(styles.hasOwnProperty(c)) {
                        if (styles[c] === '')
                            cssClass.push(`${c}:inherit`);
                        else
                            cssClass.push(`${c}:${styles[c]}`);
                    }
                return cssClass.join(';');
            },

            setValues:function(values) {
                console.log("styler.setValues @TODO llenar forma de: ", values);
                let $styler = $("#styler");
                for(let k in values)
                    if(values.hasOwnProperty(k)) {
                        let id = `styler_${k}`;
                        let $el = $(`#${id}`, $styler);
                        if($el.length) {
                            switch ($el[0].type) {
                                case 'checkbox':
                                    $el[0].checked = $el.val() === values[k];
                                    break;
                                default:
                                    if($el.hasClass("spectrumColorPicker"))
                                        $el.spectrum("set",values[k]);
                                    else
                                        $el.val(values[k]);
                            }
                            continue;
                        }
                        if(document.getElementsByName(id)) {
                            // console.log("____ " + id + " found radio setting", values[k])
                            $(`input[name='${id}'][value='${values[k]}']`).prop('checked',true);
                        }
                    }
            },

            _dialog_init: function() {
                styler.needInit = true;
                let $styler = $("#styler");
                $(".spectrumColorPicker", $styler).spectrum({
                    preferredFormat: "hex",
                    chooseText: "Ok",
                    cancelText: "Cancela",
                    showInput: true,
                    showAlpha: true,
                    allowEmpty: true,
                    change: function() {
                        styler._formatForm();
                    },
                    replacercssName: "stylerColorClick",

                    clickoutFiresChange: true,
                    showPaletteOnly: true,
                    showPalette: true,
                    hideAfterPaletteSelect: true,
                    togglePaletteOnly: true,
                    togglePaletteMoreText: '>>',
                    togglePaletteLessText: '<<',
                    palette: [
                        '000000', '7E8C8D', '95A5A6', '808080', 'ECF0F1', 'CED4D9', 'FFFF99', 'FFFF66', 'FBEE33',
                        'F0E68C', 'FAFAD2', 'FFFF00', '169179', '008000', '00D000', '98FB98', '7CFC00', 'BFEDD2',
                        '236FA1', '34495E', '00BFFF', '0000FF', 'C2E0F4', 'B0E0E6', '843FA1', '4B0082', '000080',
                        'B96AD9', '6495ED', 'ECCAFA', 'BA372A', 'B22222', 'FF0000', 'DC143C', 'F8CAC6', 'E67E23',
                        'FFFFFF','rgba(256, 256, 256, 0)',
                    ],
                });

                $("SELECT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
                $("INPUT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
                let gradientTag = {
                    'conic-gradient': ['',
                        'at left top', 'at left center', 'at left bottom',
                        'at center top', 'at center center', 'at center bottom',
                        'at right top', 'at right center', 'at right bottom',
                        // from 0deg at 0% 25%,
                    ],
                    'repeating-conic-gradient': ['',
                        'at left top', 'at left center', 'at left bottom',
                        'at center top', 'at center center', 'at center bottom',
                        'at right top', 'at right center', 'at right bottom',
                    ],
                    'linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom',
                        // .25turn 45deg,
                    ],
                    'repeating-linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom' ],
                    'radial-gradient': ['',
                        'circle at center', 'circle at left', 'circle at right',
                        'ellipse at center', 'ellipse at left', 'ellipse at right',
                    ],
                    'repeating-radial-gradient': ['',
                        'circle at center', 'circle at left', 'circle at right',
                        'ellipse at center', 'ellipse at left', 'ellipse at right',
                    ],
                };
                styler._dependantSelects(
                    document.getElementById('styler_background_gradient'),
                    document.getElementById('styler_background_gradient_tag'),
                    gradientTag
                );
            },

            _formatForm: function() {
                let $styler = $("#styler");
                const styles = styler.getStyles();
                $("INPUT[name='styler_text-decoration']", $styler).each(function() {
                    $(this).parent().css(
                        {
                            'text-decoration-color': styles['text-decoration-color'],
                            'text-decoration-thickness': styles['text-decoration-thickness'],
                        }
                    );
                });
                $("#styler_ejemplo").css(styles);
                // console.log("styler form format", styler.getStyleLine(styles));
                $styler.trigger('stylerChange', {styles, styleString:styler.getStyleLine(styles), settings:styler.settings});
            },

            _dependantSelects: function(parent, child, parentChildValues) {
                parent.addEventListener('change', function populate_child(event){
                    child.innerHTML = '';
                    let lst = parentChildValues[event.target.value] || [];
                    for(let k of lst)
                        child.innerHTML += '<option>'+ k +'</option>';

                });
            },
        }
        Object.freeze(styler);
    </script>

    <style id="styler_example_css">
        BODY {margin:1em;padding:1em}
        FIELDSET {margin:1em}
        PRE {white-space:pre-wrap;color:blue; font-family: 'Courier New', Courier, monospace}
        .addedClass1 {
            color: blue;
            text-emphasis-color: yellow;
            font-weight: 400;
            font-style: normal;
            font-size: smaller;
            text-align: right;
            padding: inherit;
            text-decoration: underline;
            text-decoration-thickness: from-font;
            text-decoration-color: red;
            text-emphasis-style: '~';
            text-emphasis-position: over;
            text-decoration-skip-ink: none;
            background-color: whitesmoke;
        }
    </style>
    <section id="styler_example_code">


        <div class="addedClass1">Este text dice:<p>Sono do style</p></div>
        <fieldset id="styler_example_html">
            <legend>Styler</legend>
            <fieldset><legend>onclick="styler.dialog( {borders:false, miInfo1:1, dialog:{modal:true,closeOnEscape:false} })"</legend>
                <button type="button" onclick="clearEventMessages();
                styler.dialog({aMiInfo1:1, borders:false,  dialog:{closeOnEscape:false} }, 'addedClass1');">StyleIt</button>
            </fieldset>
            <fieldset><legend>Events</legend>
                <fieldset><legend>User Changes: $("#styler").on('stylerChange', function(ev, styles){$("#Changed").html(styles.styleString);}</legend>
                    <pre id="Changed"></pre>
                </fieldset>
                <fieldset><legend>User Clicks Done: $("#styler").on('stylerDone', function(ev, styles){$("#Done").html(styles.styleString);}</legend>
                    <pre id="Done"></pre>
                </fieldset>
                <fieldset><legend>User Cancels or Closes: $("#styler").on('stylerCancel', function(ev, styles){$("#Cancel").html(styles.styleString);}</legend>
                    <pre id="Cancel"></pre>
                </fieldset>
            </fieldset>
        </fieldset>
        <script id="styler_example_js">
            $("#styler").on('stylerChange', function(ev, styles){
                console.log(" event:stylerChange", arguments)
                $("#Changed").html(print_r(styles));
            });
            $("#styler").on('stylerDone', function(ev, styles){
                console.log(" event:stylerDone", arguments)
                $("#Done").html(print_r(styles));
            });
            $("#styler").on('stylerCancel', function(ev, styles){
                console.log(" event:stylerCancel", arguments)
                $("#Cancel").html(print_r(styles));
            });
            function clearEventMessages() {
                $("#Changed").html("");
                $("#Done").html("");
                $("#Cancel").html("");
            }
        </script>
        <script id="styler_ejemplo_helpers">
            function print_r(obj) {
                return dump(obj);
                function dump(obj) {
                    if (obj === null)
                        return 'null';
                    if (typeof obj !== 'object')
                        return obj;
                    let tab = arguments[1] || '';
                    if (Array.isArray(obj)) {
                        let outAr = [];
                        for (let e of obj)
                            outAr.push(dump(e, typeof e === 'object' ? "\t" + tab : ""));
                        return "[" + outAr.join(", ") + "]";
                    }
                    if (obj instanceof Date)
                        return `new Date(${obj.getTime()})`;
                    let tab2 = tab + (tab === '' ? '\t' : tab);
                    let out = [];
                    for (let e in obj)
                        if (obj.hasOwnProperty(e))
                            out.push(e + ": " + dump(obj[e], tab2));
                    return "{\n" + tab2 + out.join(",\n" + tab2) + "\n" + tab + "}\n";
                }
            }
        </script>
    </section>

</body>
</html>
