<!--
se vale no recibir el cssName se deduce el element_id o gridid + columnName
Lo puedes volver clase o jquery widget

    @TODO 1 arreglar errores
    @TODO 2 como forzar repaint sin reload
    @TODO 2 la clase de una columna deberia ser gridId_columnName
    @TODO 3 No guarda crear la tabla saber grid columna y nombre
    @TODO 3 Iniciar lee las clases de este grid, las agrega al css y a cada columna del grid le arregla el classes
    @TODO 3 Iniciar
    @TODO tiene suficientes triggers

    @TODO diseñar borders pero con un un flag si se muestran o no, de ser sin borders no llenrlo en style object ni line
-->
<!--suppress CssUnusedSymbol -->
<style id="styler_css">
    #styler LABEL {cursor:pointer}
    .stylerColorClick {border:3px #d1cbd1 inset;background-color: #e6e6e6;}
    .stylerStatusButton {display:none}
    .stylerStatusButton + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 inset; background-color: #e6e6e6}
    .stylerStatusButton:checked + label {margin:auto 0;padding:0.5em;border:3px #d1cbd1 outset;background-color: silver}
    .stylerLabelHasChecked {}
    INPUT[name="styler_text-decoration"]:checked {box-shadow: 0 0 0 3px blue;cursor:pointer}
</style>
<script>
    console.log("styler_widget.php");
</script>
<!--suppress HtmlFormInputWithoutLabel -->
<div id="styler" title="Styler" style="display:none">
    <fieldset>
        <div style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start">
            <fieldset><legend>Ejemplo</legend>
                <div id="styler_ejemplo" style="border:1px silver solid;width:8em">Text 1,234.56</div>
            </fieldset>
            <fieldset style="display:flex;flex-wrap: wrap; flex-direction: row;gap:1em;align-items: start"><legend>Texto</legend>
                <div>
                    <input type="text" class="spectrumColorPicker" id="styler_color" value="#000">
                    <input id="styler_font-weight" type="checkbox" class="stylerStatusButton"
                           value="900"><label title="Negrita, Bold" for="styler_font-weight" style="font-weight: bold">B</label
                    ><input id="styler_font-style" type="checkbox" class="stylerStatusButton"
                            value="italic"><label title="Cursiva, Italica" for="styler_font-style" style="font-style:italic">I</label
                    >
                    <input id="styler_text-align_left" name="styler_text-align" type="radio" class="stylerStatusButton"
                           checked="checked"
                            value="left"><label title="Alinear a la izquierda" for="styler_text-align_left" style="text-align: left;padding-left:0.1em;padding-right:0.9em">&equiv;</label
                    ><input id="styler_text-align_center" name="styler_text-align" type="radio" class="stylerStatusButton"
                            value="center"><label title="Centrado" for="styler_text-align_center" style="text-align: center">&equiv;</label
                    ><input id="styler_text-align_right" name="styler_text-align" type="radio" class="stylerStatusButton"
                            value="right"><label title="Alinear a la derecha" for="styler_text-align_right" style="text-align: right;padding-right:0.1em;padding-left:0.9em">&equiv;</label>
                        <select id="styler_font-size" class="notSelectize">
                            <option data-style="0.6em" value="smaller">60%</option>
                            <option data-style="0.8em" value="smaller">80%</option>
                            <option data-style="0.9em" value="smaller">90%</option>
                            <option data-style="1em" value="1em">Normal</option>
                            <option data-style="1.1em" value="1.1em">110%</option>
                            <option data-style="1.5em" value="1.5em">150%</option>
                            <option data-style="1.7em" value="1.75em">175%</option>
                            <option data-style="2em" value="2em">200%</option>
                            <option data-style="2.5em" value="2.5em">250%</option>
                        </select>
                </div>
            </fieldset>
            <fieldset><legend>Fondo</legend>
                <input id="styler_background-color1" type="text" class="spectrumColorPicker" value="">
                <select id="styler_background-per1" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                    <option>10%</option><option>20%</option><option>30%</option>
                    <option>40%</option><option>50%</option><option>60%</option>
                    <option>70%</option><option>80%</option><option>90%</option>
                </select>
                <p>
                    <input id="styler_background-color2" class="spectrumColorPicker" value="">
                    <select id="styler_background-per2" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>30%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <input id="styler_background-color3" class="spectrumColorPicker" value="">

                    <select id="styler_background-per3" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>30%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <input id="styler_background-color4" class="spectrumColorPicker" value="">
                    <select id="styler_background-per4" class="notSelectize"><option></option><option>0%</option><option>5%</option>
                        <option>10%</option><option>20%</option><option>25%</option>
                        <option>30%</option><option>33%</option>
                        <option>40%</option><option>50%</option><option>60%</option>
                        <option>70%</option><option>80%</option><option>90%</option>
                    </select>
                <p>
                    <select class="notSelectize" id="styler_background_gradient">
                        <option value="">Solid</option>
                        <option value="conic-gradient">Cónico</option>
                        <option value="repeating-conic-gradient">Cónico R</option>
                        <option value="linear-gradient">Lineal</option>
                        <option value="repeating-linear-gradient">Lineal R</option>
                        <option value="radial-gradient">Radial</option>
                        <option value="repeating-radial-gradient">Radial R</option>
                    </select>
                    <select id="styler_background_gradient_tag" class="notSelectize">
                    </select>
            </fieldset>
            <div>
                <label>Margen<br><select id="styler_padding" class="notSelectize">
                        <option style="padding:inherit" value="inherit">Default</option>
                        <option value="0.3em">Poco</option>
                        <option value="0.5em">Mediano</option>
                        <option value="1em">Grande</option>
                    </select>
                </label>
            </div>
            <fieldset><legend>Énfasis</legend>
                <div>
                    <div><select id="styler_text-emphasis-style" class="notSelectize">
                            <option value="none">Sin</option>
                            <option value="'✄'">✄</option>
                            <option value="'⚐'">⚐</option>
                            <option value="'⚑'">⚑</option>
                            <option value="'☂'">☂</option>
                            <option value="'♪'">♪</option>
                            <option value="'+'">+</option>
                            <option value="'*'">*</option>
                            <option value="'^'">^</option>
                            <option value="'|'">|</option>
                            <option value="'~'">~</option>
                            <option value="'´'">´</option>
                            <option value="'`'">`</option>
                            <option value="'✦'">✦</option>
                            <option value="double circle open">Ojo</option>
                        </select>
                        <input id="styler_text-emphasis-color" type="text" class="spectrumColorPicker" value="">
                        <input id="styler_text-emphasis-position_over" name="styler_text-emphasis-position" type="radio"
                               class="stylerStatusButton" value="over" checked="checked"><label
                                title="Poner en énfasis arriba. Tipo cambié el margen"
                                for="styler_text-emphasis-position_over"><sup>&OverBracket;</sup></label
                        ><input id="styler_text-emphasis-position_under" name="styler_text-emphasis-position" type="radio" class="stylerStatusButton"
                                value="under"><label title="Poner en énfasis abajo.  Tipo cambié el margen" for="styler_text-emphasis-position_under"
                        ><sub>&UnderBracket;</sub></label>
                    </div>
            </div>
            </fieldset>
            <fieldset><legend>Lineado</legend>
                <table style="border:4px inset silver;padding-left:0.5em;padding-right:0.5em" class="notSelectize">
                <tr>
                    <td><label class="stylerLabelHasChecked"><input type="radio" checked="checked" name="styler_text-decoration" value="none"> Normal</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:line-through"><input type="radio" name="styler_text-decoration" value="line-through"> Tachado</label>
                    <td>
                        <input id="styler_text-decoration-color" class="spectrumColorPicker" value="">
                    <td>
                        <select id="styler_text-decoration-thickness">
                                <option style="text-decoration-thickness:from-font" value="from-font">Ancho</option>
                                <option style="text-decoration-thickness:1px" value="1px">1px</option>
                                <option style="text-decoration-thickness:4px" value="2px">2px</option>
                                <option style="text-decoration-thickness:4px" value="3px">3px</option>
                                <option style="text-decoration-thickness:4px" value="4px">4px</option>
                                <option style="text-decoration-thickness:5px" value="4px">5px</option>
                                <option style="text-decoration-thickness:6px" value="4px">6px</option>
                            </select>
                </tr>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline solid"><input type="radio" name="styler_text-decoration" value="underline solid"> Subrayado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline double"><input type="radio" name="styler_text-decoration" value="underline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline dotted"><input type="radio" name="styler_text-decoration" value="underline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline wavy"><input type="radio" name="styler_text-decoration" value="underline wavy"> Ondulado</label>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline solid;" ><input type="radio" name="styler_text-decoration" value="overline solid"> Testado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline double" ><input type="radio" name="styler_text-decoration" value="overline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline dotted" ><input type="radio" name="styler_text-decoration" value="overline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:overline wavy" ><input type="radio" name="styler_text-decoration" value="overline wavy"> Ondulado</label>
                <tr style="line-height: 2em">
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline" ><input type="radio" name="styler_text-decoration" value="underline overline solid"> Marcado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline double" ><input type="radio" name="styler_text-decoration" value="underline overline double"> Doble</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline dotted" ><input type="radio" name="styler_text-decoration" value="underline overline dotted"> Punteado</label>
                    <td><label  class="stylerLabelHasChecked" style="text-decoration:underline overline wavy" ><input type="radio" name="styler_text-decoration" value="underline overline wavy"> Ondulado</label>
            </table>
            </fieldset>
        </div>
    </fieldset>
</div>
<script id="styler_js_code">
    let styler = {
        defaults: {
            borders:false, // allow border styling
            element_id: null, // addclass cssName to element_id
            jqGrid: null, // grid_id or $grid
            jqGrid_column_name: null, // add class tojqGrid.jqGrid_column_name
            dialog: {},
            save:{url:'../backoffice/ajax/styler_actions.php', data:{'accion':'stylerColumnSet'}}
        },
        needInit: true,
        settings: {},

        dialog: function(options, cssName) {
            
            styler.settings = {};
            $.extend(styler.settings, styler.defaults, {cssName:cssName  || ""}, options || {});
            styler.settings.done = false;
            if(styler.settings.cssName.length === 0) {
                if(styler.settings.jqGrid !== null && styler.settings.jqGrid_column_name !== '')
                    styler.settings.cssName = styler.settings.jqGrid_column_name;
                else if(styler.settings.element_id === '')
                    styler.settings.cssName = styler.settings.element_id
            }
            if(styler.needInit)
                styler._dialog_init(options);
            if(styler.settings.cssName.length)
                    styler.setValues(styleSheetsHelper.getStyleObject("." + styler.settings.cssName));
            styler._formatForm();
            
            $("#styler").dialog($.extend({},
                {
                    close: function() {
                        let styles = styler.getStyles();
                        let styleLine = styler.getStyleLine(styles);
                        let sendEvent ='stylerCancel';
                        let cssName = `col_${options.jqGrid_column_name}`;


                        if(styler.settings.done) {
                            sendEvent = 'stylerDone';
                            if (cssName.length) {
                                styleSheetsHelper.setStyle('.' + cssName, styleLine);
                                styler.settings.cssNameAdded = true;
                                if (styler.settings.element_id !== null)
                                    $("#" + styler.settings.element_id).addClass(cssName);

                                $(`#${options.jqGrid}`).find(`td[aria-describedby="${options.jqGrid}_${options.jqGrid_column_name}"]`).addClass(`${cssName}`).removeClass('.ui-jqgrid .ui-row-ltr ');

                                let columnName = styler.settings.jqGrid_column_name;
                                if (styler.settings.jqGrid !== null && columnName !== '') {
                                    let grid = typeof styler.settings.jqGrid === 'string' ?
                                        $("#" + styler.settings.jqGrid) : $(styler.settings.jqGrid);
                                    let colModel = grid.jqGrid("getColProp", columnName);
                                    let classes = colModel.classes || '';
                                    if (classes.search(cssName) < 0) {
                                        colModel.classes = (classes + " " + cssName).trim();
                                        grid.jqGrid("setColProp", columnName, colModel);
                                        //@TODO force repaint
                                    }
                                }
                            }
                        }
                        $("#styler").trigger(sendEvent, {styles, styleLine, settings:styler.settings});
                    },
                    closeOnEscape: true,
                    width: "95%", height: window.innerHeight - 200,
                    buttons: [
                        {
                            text: 'Ok',
                            icon: "ui-icon-check",
                            click: function () {
                                styler.settings.done = true;
                                console.log(styler.settings);
                                $("#styler").dialog( "close" );
                                //console.log(styler.getStyles());
                                let rutaCSS= styler.getURL();

                                styler.saveStyles(options.jqGrid_column_name, styler.getStyles(), rutaCSS, options.col);
                            }
                        },
                        {
                            text: "Cancel",
                            id:"dialogme_cancel",
                            icon: "ui-icon-close",
                            click: function () {
                                $("#styler").dialog("close");
                            }
                        },
                    ],
            },
                styler.settings.dialog
            )).dialog("moveToTop");
        },


        getStyles:function() {
            let $styler = $("#styler");
            let styles = {
                'color': $("#styler_color", $styler).val(),
                'text-emphasis-color': $("#styler_text-emphasis-color", $styler).val(),
                'font-weight': $("#styler_font-weight", $styler).is(":checked") ? "900" : '400',
                'font-style': $("#styler_font-style", $styler).is(":checked") ? "italic" : 'normal',
                'font-size': $("#styler_font-size", $styler).val(),
                'text-align': $("input[name='styler_text-align']:checked", $styler).val(),
                'padding': $("#styler_padding", $styler).val(),

                'text-decoration': $("input[name='styler_text-decoration']:checked", $styler).val(),
                'text-decoration-thickness': $("#styler_text-decoration-thickness", $styler).val(),
                'text-decoration-color': $("#styler_text-decoration-color", $styler).val(),
                'text-emphasis-style': $("#styler_text-emphasis-style", $styler).val(),
                'text-emphasis-position': $("input[name='styler_text-emphasis-position']:checked").val(),
                'text-decoration-skip-ink': 'none',
                'background-color': '',
                'background': '',
            };
            if(styles["text-decoration-color"] === "" || styles["text-decoration-color"] === "none")
                styles["text-decoration-color"] = "inherit";
            let bk = [];
            for(let i=1; i<=4; ++i) {
                let bakcgroundColor = $(`#styler_background-color${i}`, $styler).val();
                if(bakcgroundColor.length === 0)
                    continue;
                bk.push( bakcgroundColor + ' ' +
                    $(`#styler_background-per${i}`, $styler).val()
                );
            }
            let gradient = $("#styler_background_gradient", $styler).val();
            // console.log(`________set para grad ${gradient}`, bk);
            if(bk.length === 1 || gradient === '') {
                styles['background-color'] = $("#styler_background-color1", $styler).val();
                // console.log(" 1 color sin gradientes background-color:", styles['background-color'])
            } else if(bk.length > 1) {
                if(gradient === '')
                    gradient = 'linear-gradient';
                let angle = $("#styler_background_gradient_tag", $styler).val();
                if(angle === null)
                    angle = '';
                if(angle.length)
                    angle += ',';
                styles['background'] = `${gradient}(${angle} ${bk.join(', ')})`; // ${angle}
            }
            if(styles['text-decoration-color'] === '')
                styles['text-decoration-color'] = 'none';
            for(let s in styles)
                if(styles.hasOwnProperty(s) && styles[s] === '')
                    delete(styles[s]);
            return styles;
        },

        getURL: function(){
            let rutaActual = window.location.pathname; // Obtiene la ruta de la página sin el dominio ni los parámetros

            // Dividir la ruta en segmentos utilizando el carácter de barra "/"
            let segmentos = rutaActual.split('/');

            // Eliminar elementos vacíos del array resultante
            segmentos = segmentos.filter(function(segmento) {
                return segmento.trim() !== '';
            });

            // Obtener el último segmento (última carpeta)
            let ultimaCarpeta = segmentos[segmentos.length - 1];

            return ultimaCarpeta.replace(".php", "");
           
        },


        saveStyles: function (colDB, estilos, ruta, col) {
          //console.log(colDB, estilos);  

          $.ajax({
              url: styler.defaults.save.url,
              type: 'POST',
              data: {
                  accion: 'stylerColumnSet',
                  colDB,
                  estilos: JSON.stringify(estilos),
                  ruta,
                  col
              },
              success: function (data) {
                  console.log(data);
              },
              error: function (jqXHR, textStatus, errorThrown) {
                  console.log(jqXHR, textStatus, errorThrown);
              }
          });
        },

        getStyleLine: function(styles) {
            let cssClass = [];
            for(let c in styles)
                if(styles.hasOwnProperty(c)) {
                    if (styles[c] === '')
                        cssClass.push(`${c}:inherit`);
                    else
                        cssClass.push(`${c}:${styles[c]}`);
                }
            return cssClass.join(';');
        },

        setValues:function(values) {
            let $styler = $("#styler");
            for(let k in values)
                if(values.hasOwnProperty(k)) {
                    let id = `styler_${k}`;
                    let $el = $(`#${id}`, $styler);
                    if($el.length) {
                        switch ($el[0].type) {
                            case 'checkbox':
                                $el[0].checked = $el.val() === values[k];
                                break;
                            default:
                                if($el.hasClass("spectrumColorPicker"))
                                    $el.spectrum("set",values[k]);
                                else
                                    $el.val(values[k]);
                        }
                        continue;
                    }
                    if(document.getElementsByName(id)) {
                        // console.log("____ " + id + " found radio setting", values[k])
                        $(`input[name='${id}'][value='${values[k]}']`).prop('checked',true);
                    }
                }
        },

        _dialog_init: function(options) {
            $('select').addClass('notSelectize').removeClass('selectized');



            styler.needInit = true;
            let $styler = $("#styler");
            $(".spectrumColorPicker", $styler).spectrum({
                preferredFormat: "hex",
                chooseText: "Ok",
                cancelText: "Cancela",
                showInput: true,
                showAlpha: true,
                allowEmpty: true,
                change: function() {
                    styler._formatForm();
                },
                replacercssName: "stylerColorClick",

                clickoutFiresChange: true,
                showPaletteOnly: true,
                showPalette: true,
                hideAfterPaletteSelect: true,
                togglePaletteOnly: true,
                togglePaletteMoreText: '>>',
                togglePaletteLessText: '<<',
                palette: [
                    '000000', '7E8C8D', '95A5A6', '808080', 'ECF0F1', 'CED4D9', 'FFFF99', 'FFFF66', 'FBEE33',
                    'F0E68C', 'FAFAD2', 'FFFF00', '169179', '008000', '00D000', '98FB98', '7CFC00', 'BFEDD2',
                    '236FA1', '34495E', '00BFFF', '0000FF', 'C2E0F4', 'B0E0E6', '843FA1', '4B0082', '000080',
                    'B96AD9', '6495ED', 'ECCAFA', 'BA372A', 'B22222', 'FF0000', 'DC143C', 'F8CAC6', 'E67E23',
                    'FFFFFF','rgba(256, 256, 256, 0)',
                ],
            });

            $("SELECT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
            $("INPUT", $styler).off('change', styler._formatForm).on('change', styler._formatForm);
            let gradientTag = {
                'conic-gradient': ['',
                    'at left top', 'at left center', 'at left bottom',
                    'at center top', 'at center center', 'at center bottom',
                    'at right top', 'at right center', 'at right bottom',
                    // from 0deg at 0% 25%,
                ],
                'repeating-conic-gradient': ['',
                    'at left top', 'at left center', 'at left bottom',
                    'at center top', 'at center center', 'at center bottom',
                    'at right top', 'at right center', 'at right bottom',
                ],
                'linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom',
                    // .25turn 45deg,
                ],
                'repeating-linear-gradient': ['', 'to left top', 'to right top', 'to left bottom', 'to right bottom' ],
                'radial-gradient': ['',
                    'circle at center', 'circle at left', 'circle at right',
                    'ellipse at center', 'ellipse at left', 'ellipse at right',
                ],
                'repeating-radial-gradient': ['',
                    'circle at center', 'circle at left', 'circle at right',
                    'ellipse at center', 'ellipse at left', 'ellipse at right',
                ],
            };
            styler._dependantSelects(
                document.getElementById('styler_background_gradient'),
                document.getElementById('styler_background_gradient_tag'),
                gradientTag
            );
           
            styler.setColorSelect(options)
           
            
        },
        setColorSelect: function(options){
            $('.spectrumColorPicker').spectrum("set", null);
            let color = $(options.col).css("color");
            let bg_color = $(options.col).css("background");
            let font_w = $(options.col).css("font-weight");
            let font_s = $(options.col).css("font-style");
            let font_size = $(options.col).css("font-size");
            let parent_font = $(options.col).parent().parent().css("font-size");
            let align = $(options.col).css("text-align");

            if(align==="left") $("#styler_text-align_left").prop("checked", true);
            else if(align==="center") $("#styler_text-align_center").prop("checked", true);
            else if(align==="right") $("#styler_text-align_right").prop("checked", true);

            let fontAnt= (parseInt(font_size) / parseInt(parent_font)  ).toFixed(1);
            $(`#styler_font-size`).find(`option[data-style="${fontAnt}em"]`).prop("selected", true);
            
            if(font_s==="italic") $("#styler_font-style").prop("checked", true);
            else $("#styler_font-style").prop("checked", false);

            if(font_w==="900") $("#styler_font-weight").prop("checked", true);
            else $("#styler_font-weight").prop("checked", false);

            const bg_colors= bg_color.split(' r');
            $('#styler_background-color1').spectrum("set", null);

            if(bg_colors[0].includes("rgba(0, 0, 0, 0)")) {
                $('#styler_background-color1').spectrum("set", null);
                if(!bg_colors[0].includes("none")) {
                        let regex = /^(.*?)(?=\()/; 
                        let match = bg_colors[1].match(regex);
                        let textoAntesDelParentesis = match[1].trim();
                        if (match) $("#styler_background_gradient").val(`r${textoAntesDelParentesis}`); 
                        let obteniendoDeg = bg_color.replace(`rgba(0, 0, 0, 0) r${textoAntesDelParentesis}`,"");
                        
                        let regex_bg = /^(.*?)(?=\s+repeat)/i;  // Esta expresión busca cualquier texto antes de "repeat"
                        match = obteniendoDeg.match(regex_bg);
                        if(match){
                            let colors=match[1].trim().slice(0, -1).substring(1, match[1].length);
                            colors=colors.split(', r');
                            colors.forEach((only, index) => {
                                if(index!==0) only="r"+only;
                                $(`#styler_background-color${index+1}`).spectrum("set", only);
                            });
                        }

                   }

                
            }else{
                $('#styler_background-color1').spectrum("set", bg_colors[0]);
                $("#styler_background_gradient").val(``); 

            }
           
            $("#styler_color").spectrum("set", color);

        },

        _formatForm: function() {
            let $styler = $("#styler");
            const styles = styler.getStyles();
            $("INPUT[name='styler_text-decoration']", $styler).each(function() {
                $(this).parent().css(
                    {
                        'text-decoration-color': styles['text-decoration-color'],
                        'text-decoration-thickness': styles['text-decoration-thickness'],
                    }
                );
            });
            $("#styler_ejemplo").css(styles);
            $styler.trigger('stylerChange', {styles, styleString:styler.getStyleLine(styles), settings:styler.settings});
        },

        _dependantSelects: function(parent, child, parentChildValues) {
            parent.addEventListener('change', function populate_child(event){
                child.innerHTML = '';
                let lst = parentChildValues[event.target.value] || [];
                for(let k of lst)
                    child.innerHTML += '<option>'+ k +'</option>';

            });
        },
    }
    Object.freeze(styler);
</script>

