<?php

class CostosContenedor {

    public static string $msg_error = '';
    public static string $id_insert = '';

    public static string $msg = '';

    public static $campos_para_pedimento_validar = [
        'empresa_id' => 'Empresa',
        'numero_contenedor' => 'Número Contenedor',
        'fecha_entrada' => 'Fecha de Entrada',
        'numero_pedimento' => 'Número de Pedimento',
        'fabrica_id' => 'Fabrica',
        'fabrica_numero' => 'Número de Fabrica',
        'numero_pi' => 'Pi #',
        'valor_pedimento_exportacion_usd' => 'Export Copy Value',
        'diferencia_exportacion_usd' => 'Difference Copy Value',
        'presento_exportacion_china' => 'Se presento Export Copy Value',
        'proveedor_id' => 'Proveedor',
        'invoice_numero' => 'Invoice #',
        'own_reference' => 'Our Reference',
        'agente_aduanal_id' => 'Agent Aduanal',
        'agente_aduanal_razon_social' => 'A.A razon social',
        'aduana_id' => 'Puerto/Aduana',
        'peso_bruto' => 'Peso Bruto',
        'valor_dolares' => 'Valor en Dólares',
        'incoterm' => 'INCOTERM',
        'shipping_line_id' => 'Shipping Line',
        'bl_number' => 'B/L Number'
    ];
    /**
     * @var false
     */
    public static bool $diff=false;

    function __construct()
    {

    }

    public static function jqgrid_read(): bool|array
    {
        $per_page = param('rows', 50);
        $page = param('page', 1);

        $querys = self::prepare_querys_jqgrid();

        $query_select = $querys['select'];
        $rows = ia_sqlArrayIndx($query_select);
        if ($rows === false)
            return false;

        $count = ia_singleread($querys['count']);

        $total_pages = ceil($count/$per_page);
        return ['query' => $query_select,
            'page' => $page,
            'records' => $count,
            'rows' => $rows,
            'total' => $total_pages,
            'userdata' => []
        ];
    }

    private static function prepare_query_count(): string
    {
        $tabla = param('iactbl');
        $where = self::prepare_where();
        return "SELECT count(*) FROM $tabla $where";
    }
    private static function prepare_querys_jqgrid(): array
    {
        global $gParams;
        $gParams = [
            'iacc' => '',
            'iasum' => '',
            'iactbl' => param('iactbl'),
        ];
        return [
            'select' => self::prepare_query_select(),
            'count' => self::prepare_query_count()
        ];
    }

    private static function prepare_query_select():string
    {
        $tabla = param('iactbl');
        $per_page = param('rows', 50);

        $extra_cols = [];
        if ($tabla === 'calculadora_igi')
            $extra_cols[] = "files as files_org";



        $cols_extra = "";
        if (!empty($extra_cols))
            $cols_extra = ", ".implode(', ', $extra_cols);

        $method = __METHOD__;
        $partes = [
            'select' => "SELECT /*$method*/ * $cols_extra  FROM $tabla",
            'where' => self::prepare_where(),
            'order_by' => "",
            'limit' => "LIMIT 0, $per_page"
        ];

        // Preparando el limit
        $page = param('page', 1);
        $page_anterior = $page-1;
        $desde = 0;
        if ($page_anterior>0) {
            $desde = $page == 1?0:($per_page*$page_anterior);
        }

        $partes['limit'] = "LIMIT $desde, $per_page";

        // Preparando el order
        $sidx = param('sidx');
        $sort = param('sord');
        if (!empty($sidx)) {
            $partes['order_by'] = "ORDER BY $sidx $sort";
        }

        return implode(" ", $partes);
    }

    private static function prepare_where(): string
    {
        $iacwhere = urldecode(param('iacwhere'));
        $wheres = [];
        if (!empty($iacwhere))
            $wheres[] = $iacwhere;

        $iacwhere = implode(" AND ", $wheres);
        $where_filters = self::apply_filters();

        $wheres_concat = [];
        if (!empty($iacwhere))
            $wheres_concat[] = "($iacwhere)";

        if (!empty($where_filters))
            $wheres_concat[] = $where_filters;

        $where = "";
        if (!empty($wheres_concat))
            $where = "WHERE ".implode(" AND ", $wheres_concat);

        return $where;
    }

    private static function apply_filters(&$wheres=[]): string
    {
        $filters = param('filters');
        $iacase = null;
        $tablePrefix='';
        $where='';
        if (!empty($filters)) {
            $tmp = '';
            $f = @json_decode($filters);
            $json = json_last_error();
            if($json) {
                if($json === JSON_ERROR_DEPTH)
                    $jsonerr = "\r\nJSON ERROR: The maximum stack depth has been exceeded";
                elseif($json === JSON_ERROR_STATE_MISMATCH)
                    $jsonerr = "\r\nJSON ERROR: Invalid or malformed JSON";
                elseif($json === JSON_ERROR_CTRL_CHAR)
                    $jsonerr = "\r\nJSON ERROR: Control character error, possibly incorrectly encoded";
                elseif($json === JSON_ERROR_SYNTAX)
                    $jsonerr = "\r\nJSON ERROR: Syntax error";
                elseif($json === JSON_ERROR_UTF8)
                    $jsonerr = "\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded";
                else
                    $jsonerr = "\r\nJSON ERROR: unkown $json";
                ia_errores_a_dime($jsonerr);
            }

            if(isset($f->groupOp))
                $op = $f->groupOp;
            else
                $op = 'AND';
            if($op != 'AND' && $op != 'OR')
                $op = 'AND';

            if( $f->rules ) {
                foreach( $f->rules as $rule ) {
                    $tiene=$rule->data;
                    if (!is_array($rule->data))
                        $tiene=trim($rule->data);

                    if( $tiene !== '' || ( $rule->op === 'nu' || $rule->op === 'nn' || $rule->op === 'nu_bodega' || $rule->op === 'nn_bodega' ) ) {
                        if ($tiene === '@_#empty#_@') // paa indicar que esta vacio
                            $tiene = '';


                        where_op($tmp,$op);
                        $prefix = strpos($rule->field,'.') === false ? $tablePrefix : '';
                        if($rule->op  ===  'eq')
                            $tiene = str_replace(",","",$tiene);
                        $oldName = $rule->field;
                        $rule->field = solveVirtualField($rule->field);
                        if($oldName === $rule->field && $iacase !== null && !empty($iacase->campos[$rule->field]['virtual_sql'])  ) {
                            $tmpFieldName = preg_replace('/\)\s*as\s+[\'a-z0-9]+\s*$/miUuS', ")",
                                $iacase->campos[$rule->field]['virtual_sql']);
                            $tmpFieldName =  str_replace("as " . $rule->field,"", $tmpFieldName);

                            $tmp.=where_clause($tmpFieldName,$rule->op,$tiene);
                            continue;
                        }

                        $tiene = str_replace("," ,"", $tiene);
                        $apps_de_nota_bodega = ['nota_bodega', 'nota_bodega_verificacion'];
                        if ($iacase !== null && in_array($iacase->table, $apps_de_nota_bodega) && ($rule->field === 'numero')) {
                            $numero_search = $tiene;
                            $parts = explode("-", $numero_search);
                            $contiene_ajuste = str_contains($numero_search, strtolower('ajuste'));
                            if (count($parts)>1 || $contiene_ajuste || !is_numeric($parts[0]))
                                $rule->op = 'cn';

                            if (count($parts) == 1 && is_numeric($parts[0])) {
                                $rule->field = 'numero_real';
                                // $valor = strit("$numero_search%");
                                // $tmp.= fieldit($prefix.$rule->field). " LIKE $valor";
                                // continue;
                            }
                        }
                        if(strpos($rule->field,"remarks") !== false) {
                            $tmp_tiene = preg_replace_callback('/(\d+(.|,))+(\d)+/m', function ($matches) {
                                $monto = echonf(limpiaCantidad($matches[0]), true);
                                return substr($monto, -3) == ".00" ? substr_replace($monto ,"", -3) : $monto;
                            }, $tiene);

                            if ($tmp_tiene != $tiene) {
                                $tiene_where=where_clause($prefix.$rule->field,$rule->op,$tiene);
                                where_op($tiene_where, 'OR');
                                $tiene_where .= where_clause($prefix . $rule->field, $rule->op, $tmp_tiene);


                                $tmp .= "($tiene_where)";
                            }
                            else
                                $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);
                        }
                        else
                            $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);


                        //echo "<li>$gParams[iactbl]";
                        if(($rule->field === 'cliente' || $rule->field === 'cliente_id') && isset($iacase) && !empty($iacase) && ($iacase->table === 'cheque' || $iacase->table === 'pagare' || $iacase->table === 'vale' || $iacase->table === 'compra')) {
                            $tmpNombre = where_clause('nombre',$rule->op,$tiene);
                            $tmp = "($tmp OR cliente_id IN(SELECT cliente_id FROM cliente WHERE $tmpNombre ))";
                        }
                    }
                }
                if($tmp!='') {
                    where_op($where,'AND');
                    $where.="($tmp)";
                    return $where;
                }
            }
        }
        return '';
    }


    public static function save_calculadora(array $values): bool|int
    {
        return CalculadoraIGI::save($values);
    }

    public static function update_calculadora($id, array $values): bool|int
    {
        return CalculadoraIGI::update($id, $values);
    }

    public static function delete_calculadora($calculadora_id, $hard_delete = false): bool|int
    {
        return CalculadoraIGI::delete($calculadora_id, $hard_delete);
    }

    public static function activa_calculadora($calculadora_id): bool|int
    {
        return CalculadoraIGI::activa($calculadora_id);
    }

    public static function delete_calculadoras($ids, bool $para_pedimento = false, $hard_delete = false): bool|int
    {
        return CalculadoraIGI::delete_ids($ids, $para_pedimento, $hard_delete);
    }

    public static function lock_unlock_calculadoras_editar($ids, bool $para_pedimento = false, $lock = true): bool|int
    {
        return CalculadoraIGI::lock_unlock_calculadoras_editar($ids, $para_pedimento, $lock);
    }

    public static function lock_unlock_calculadoras_borrar($ids, bool $para_pedimento = false, $lock = true): bool|int
    {
        return CalculadoraIGI::lock_unlock_calculadoras_borrar($ids, $para_pedimento, $lock);
    }

    public static function save_pasada_tercero(array $values): bool|int
    {
        return PasadaTercero::save($values);
    }

    public static function delete_pasada_tercero(string $pasada_tercero_id): bool|int
    {
        return PasadaTercero::delete($pasada_tercero_id);
    }

    public static function update_pasada_tercero(string $id, array $values): bool|int
    {
        return PasadaTercero::update($id, $values);
    }

    public static function save_precio_venta(array $values): bool|int
    {
        return PrecioVenta::save($values);
    }

    public static function update_precio_venta(string $id, array $values): bool|int
    {
        return PrecioVenta::update($id, $values);
    }

    public static function delete_precio_venta(string $id): bool|int
    {
        return PrecioVenta::delete($id);
    }


    public static function get_info_producto(string $producto_id, array $producto = [], $liHelpers=null): bool|array
    {
        $method = __METHOD__;
        if (empty($producto)) {
            $select = "SELECT /*$method*/ pg.*,
                 IFNULL(pcb.cost_cif, '0.00') as cost_cif,
                 IFNULL(pcb.cost_cif_blanco, '0.00') as cost_cif_blanco, u.unidad as unidad,
                 pg.precio_estimado_usd as precio_estimado_igi_10, pg.precio_estimado_usd_tenido as precio_estimado_igi_15,
                 pg.cost_variant
            FROM producto_general pg
            LEFT JOIN producto_costs_bodega pcb ON (pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL)
            LEFT JOIN unidades u ON u.unidades_id = pg.unidades_id
            WHERE pg.producto_general_id =".strit($producto_id);
            $producto = ia_singleton($select);
        }
        $app = (object)[
            'id' => $producto_id,
            'values' => $producto
        ];

        if (empty($app->values))
            return false;


        if (strlen($app->values['cost_cif'])===0)
            $app->values['cost_cif'] = ia_singleread("SELECT /*$method*/ IFNULL(cost_cif, '0.00') FROM producto_costs_bodega WHERE producto_general_id = ".strit($producto_id) ." AND fecha_fin IS NULL");

        if (strlen($app->values['cost_cif_blanco'])===0)
            $app->values['cost_cif_blanco'] = ia_singleread("SELECT /*$method*/ IFNULL(cost_cif_blanco, '0.00') FROM producto_costs_bodega WHERE producto_general_id = ".strit($producto_id) ." AND fecha_fin IS NULL");

        $app->values['precio_estimado_igi_10'] = $app->values['precio_estimado_usd']??'';
        $app->values['precio_estimado_igi_15'] = $app->values['precio_estimado_usd_tenido']??'';
        $app->values['precio_estimado_blanco'] = $app->values['precio_estimado_igi_10'];
        $app->values['precio_estimado_tenido'] = $app->values['precio_estimado_igi_15'];

        $campos_info = [
            'producto_general_id', 'producto',
            'fraccion_arancelaria', 'igi_blanco', 'precio_estimado_usd',
            'fraccion_arancelaria_tenido', 'igi_tenido', 'precio_estimado_usd_tenido',
            'cost_cif', 'container_quantity',
            'precio_estimado_igi_10', 'precio_estimado_igi_15',
            'precio_estimado_blanco', 'precio_estimado_tenido',
            'unidades_id', 'unidad',
            'umt', 'umc',
            'ancho_tela_importacion', 'peso_tela_importacion',
            'fraccion_arancelaria_desc', 'fraccion_arancelaria_tenido_desc'
        ];
        // Crear un array con valores predeterminados
        /*$defaultValues = array_fill_keys($campos_info, '');
        $info = array_merge($defaultValues, array_intersect_key($app->values, array_flip($campos_info)));*/
        $info = $app->values;

        $info['producto_general_id'] = $producto_id;
        $info['descripcion_blanco'] = $info['fraccion_arancelaria_desc']??'';
        $info['descripcion_tenido'] = $info['fraccion_arancelaria_tenido_desc']??'';

        if (strlen($info['unidad'])===0)
            $info['unidad'] = ia_singleread("SELECT /*$method*/ unidad FROM unidades WHERE unidades_id = $info[unidades_id]");

        if ($liHelpers === null)
            $liHelpers = new ProductoListaPrecios(null, false);

        $producto_precio_lista = $liHelpers->getProductosPLista($liHelpers->default_activa, $producto_id, '');
        if ($producto_precio_lista !== false) {
            $tc_value= $liHelpers->getTCValue($liHelpers->default_activa, $producto_precio_lista['tc_modo'], true);

            $producto_precio_lista['precio_usd'] = $liHelpers->calculandoDolares($producto_precio_lista['precio'], $producto_precio_lista['pesos'], $tc_value['tc_valor']);

            $producto_precio_lista['precio_pesos'] = $producto_precio_lista['pesos'];
            if(!$producto_precio_lista['precio'])
                $producto_precio_lista['precio_pesos'] = '0.00';
            elseif($producto_precio_lista['pesos']) {
                $producto_precio_lista['precio_pesos'] = $producto_precio_lista['pesos'];
                $producto_precio_lista['precio_pesos_a_mano'] = true;
            }
            else {
                $producto_precio_lista['precio_pesos'] = $liHelpers->calculandoPesos($producto_precio_lista['precio'], $producto_precio_lista['tc_modo'], $producto_precio_lista['moneda_id'], $tc_value['tc_valor']);
            }
        }
        else {
            $producto_precio_lista = [];
            $producto_precio_lista['precio_pesos'] = '0.00';
            $producto_precio_lista['precio_usd'] = '0.00';
        }

        $info['lista_precios'] = $producto_precio_lista;


        $igis = [];
        $igis_reales = [];
        $precios_estimados = [];
        $info['igi_blanco'] = limpiaCantidad_($info['igi_blanco']);
        $info['igi_tenido'] = limpiaCantidad_($info['igi_tenido']);

        $info['se_dividio'] = false;

        if (!empty($app->values['igi_blanco']))
            $igis[limpiaCantidad_(str_replace("%", "", $app->values['igi_blanco']))] = [
                'igi' => limpiaCantidad_(str_replace("%", "", $app->values['igi_blanco'])),
                'precio_estimado' => $app->values['precio_estimado_igi_10'],
            ];

        if (!empty($app->values['igi_tenido']))
            $igis[limpiaCantidad_(str_replace("%", "", $app->values['igi_tenido']))] = [
                'igi' => limpiaCantidad_(str_replace("%", "", $app->values['igi_tenido'])),
                'precio_estimado' => $app->values['precio_estimado_igi_15'],
            ];

        if (!empty($app->values['igi_blanco']))
            $igis_reales[] = [
                'tipo' => 'blanco',
                'igi' => limpiaCantidad_(str_replace("%", "", $app->values['igi_blanco'])),
                'precio_estimado' => $app->values['precio_estimado_igi_10'],
            ];

        if (!empty($app->values['igi_tenido']))
            $igis_reales[] = [
                'tipo' => 'tenido',
                'igi' => limpiaCantidad_(str_replace("%", "", $app->values['igi_tenido'])),
                'precio_estimado' => $app->values['precio_estimado_igi_15'],
            ];

        if (!empty($app->values['precio_estimado_usd']))
            $precios_estimados[$app->values['precio_estimado_usd']] = $app->values['precio_estimado_igi_10'];

        if (!empty($app->values['precio_estimado_usd_tenido']))
            $precios_estimados[$app->values['precio_estimado_usd_tenido']] = $app->values['precio_estimado_igi_15'];


        foreach ($igis_reales as $igi_key => &$igi) {
            $tipo = $igi['tipo'];
            $producto = [
                'umt' => $info['umt'],
                'umc' => $info['umc'],
                'ancho_tela_importacion' => $info['ancho_tela_importacion']/100, // el ancho viene en centímetros (150/100=1.5MT)
                'peso_tela_importacion' => $info['peso_tela_importacion']/1000, // el peso viene en gramos (1500/1000=1.5KG)
                'precio_estimado' => $igi['precio_estimado']
            ];
            $precio_estimado_umt = ProductoGeneral::get_precio_en_umt($producto);
            if (is_array($precio_estimado_umt)) {
                $igi['precio_estimado_umt_fail'] = $precio_estimado_umt['reason'];
                $info['precio_estimado_igi_'.$tipo."_umt_fail"] = $precio_estimado_umt['reason'];
                $precio_estimado_umt = '';
            }
            $info['precio_estimado_igi_'.$tipo."_umt"] = strval($precio_estimado_umt);
            $igi['precio_estimado_umt'] = strval($precio_estimado_umt);
        }
        unset($igi);

        if (count($igis)>1 || count($precios_estimados)>1)
            $info['se_dividio'] = true;


        $info['igis'] = $igis;
        $info['precios_estimados'] = $precios_estimados;
        $info['igis_reales'] = $igis_reales;

        return $info;
    }

    public static function get_productos($para = '', $productos_id = [])
    {
        $method = __METHOD__;

        $campos_info = [
            'pg.producto_general_id', 'pg.producto',
            'pg.fraccion_arancelaria', 'pg.igi_blanco', 'pg.precio_estimado_usd',
            'pg.fraccion_arancelaria_tenido', 'pg.igi_tenido', 'pg.precio_estimado_usd_tenido',
            'pg.umt', 'pg.umc',
            'u.unidad as unidad',
        ];

        $campos = implode(", ", $campos_info);

        $where = "";

        if ($para === 'pedimento') {
            $where.=" AND para_pedimento = 'Visible'";
        }

        if ($para === 'precio_venta' || $para === 'importar_precio_venta') {
            $where.=" AND para_precio_venta = 'Visible'";
        }

        /*if (!empty($productos_id)) {
            $where.=" AND producto_general_id IN (".parseClauseIn($productos_id).")";
        }*/




        $productos_ = ia_sqlArrayIndx("SELECT /*$method*/ $campos
        FROM producto_general pg
        LEFT JOIN unidades u ON u.unidades_id = pg.unidades_id
        WHERE pg.activo = 'Si' AND pg.solo_carta_porte = 'No' $where ORDER BY producto");

        /*if ($para === 'importar_precio_venta') {
            $lista_preciosH = new ProductoListaPrecios(null, false);
        }*/


        $productos = [];
        // Recorremos los productos para saber si se pueden separar
        // Si tienen distinto igi o distinto precio estimado
        foreach ($productos_ as $producto_id => $producto){
            $producto['tipo_producto'] = 'general';
            $producto['label'] = $producto['producto'];
            $producto['real_data'] = $producto['producto_general_id'];
            $producto['value'] = $producto['producto_general_id'];

            $igis_del_producto = [];
            $precios_estimados = [];

            if (!empty($producto['igi_blanco']))
                $igis_del_producto[limpiaCantidad_($producto['igi_blanco'])] = limpiaCantidad_($producto['igi_blanco']);

            if (!empty($producto['igi_tenido']))
                $igis_del_producto[limpiaCantidad_($producto['igi_tenido'])] = limpiaCantidad_($producto['igi_tenido']);

            if (!empty($producto['precio_estimado_usd']))
                $precios_estimados[$producto['precio_estimado_usd']] = $producto['precio_estimado_usd'];

            if (!empty($producto['precio_estimado_usd_tenido']))
                $precios_estimados[$producto['precio_estimado_usd_tenido']] = $producto['precio_estimado_usd_tenido'];

            $producto['igi_blanco'] = limpiaCantidad_($producto['igi_blanco']);
            $producto['igi_tenido'] = limpiaCantidad_($producto['igi_tenido']);

            $producto['se_dividio'] = false;

            $productos[] = $producto;
            // validamos si el producto se puede dividir
            // Debe tener dos igis o dos precios estimados diferentes
            if (count($igis_del_producto)>1 || count($precios_estimados)>1) {
                // renombramos el producto para indicar el blanco
                $productos[(count($productos)-1)]['producto'] = $producto['producto']. " BLANCO";
                $productos[(count($productos)-1)]['tipo_producto'] = "blanco";
                $productos[(count($productos)-1)]['label'] = $producto['producto']. " BLANCO";
                $productos[(count($productos)-1)]['real_data'] = $producto['real_data']. "_blanco";
                $productos[(count($productos)-1)]['value'] = $producto['value']. "_blanco";
                $productos[(count($productos)-1)]['se_dividio'] = true;

                // agregamos el producto con su nombre en teñido
                $producto['producto'] = $producto['producto']. " TEÑIDO";
                $producto['tipo_producto'] = 'tenido';
                $producto['label'] = $producto['producto'];
                $producto['real_data'] = $producto['real_data']. "_tenido";
                $producto['value'] = $producto['value']. "_tenido";
                $producto['se_dividio'] = true;
                $productos[] = $producto;
            }
        }
        return $productos;
    }

    public static function remove_files_temps_calculadora(string $id): void
    {
        CalculadoraIGI::remove_files_temps($id);
    }

    public static function calculadora_genera_historian(string $id, string $accion, string $desc_motivo = ''): void
    {
        CalculadoraIGI::genera_historian($id, $accion, $desc_motivo);
    }

    public static function calculadora_update_puede_borrar_editar($execute = true): null|array
    {
        if ($execute) {
            CalculadoraIGI::update_puede_borrar();
            CalculadoraIGI::update_puede_editar();
            return null;
        }
        else {
            $queries_borrar = CalculadoraIGI::update_puede_borrar($execute);
            $queries_editar = CalculadoraIGI::update_puede_editar($execute);

            return array_merge($queries_borrar, $queries_editar);
        }
    }

    public static function calculadora_set_puede_borrar(string $id, string $set_puede): bool|int
    {
        return CalculadoraIGI::set_puede_borrar($id, $set_puede);
    }

    public static function calculadora_set_puede_editar(string $id, string $set_puede): bool|int
    {
        return CalculadoraIGI::set_puede_editar($id, $set_puede);
    }

    public static function set_calculadora_archivos_no_aplica(string $id, $tipo_archivo_id, $por_sistema = false)
    {
        return CalculadoraIGI::set_no_aplica($id, $tipo_archivo_id, $por_sistema);
    }


}


class CalculadoraIGI
{
    public static function save($values): bool|int
    {
        global $gIApath;
        global $gWebDir;

        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $valores_limpios = ['calculadora_igi_id', 'numero_contenedor', 'nombre', 'tipo_captura', 'productos_buscados', 'con_fiduciario', 'con_precio_venta', 'config', 'numero_pi', 'own_reference', 'fabrica_id', 'fabrica_numero', 'remarks', 'para_pedimento', 'tipo_archivo_no_aplica', 'tipo_archivo_no_aplica_por_sistema'];
        $campos_para_pedimento_limpios = [
            'empresa_id', 'numero_contenedor', 'fecha_entrada', 'numero_pedimento', 'fabrica_id', 'fabrica_numero', 'numero_pi', 'proveedor_id', 'id_fiscal_proveedor', 'invoice_numero', 'own_reference', 'agente_aduanal_id', 'agente_aduanal_nombre', 'agente_aduanal_razon_social', 'aduana_id', 'peso_bruto', 'incoterm', 'bl_number', 'shipping_line_id', 'pedimento_exportacion_china', 'diferencia_exportacion_usd', 'presento_exportacion_china', 'campos_pedimento_config'
        ];
        $valores_limpios = array_merge($valores_limpios, $campos_para_pedimento_limpios);

        $items = $values['items']??[];
        unset($values['items']);
        foreach ($values as $key => $value) {
            if (in_array($key, $valores_limpios))
                continue;
            $values[$key] = limpiaCantidad_($value);
        }
        if (empty($values['calculadora_igi_id']))
            $values['calculadora_igi_id'] = ia_guid();

        $calculadora_id = $values['calculadora_igi_id'];
        $queries = ['insert_calculadora'];
        $now = date('Y-m-d H:i:s');
        $total = $total_fact = $total_igi = $total_dta = $total_iva =  $total_fid = $total_fid_usd = '0.00';
        $total_usd = '0.00';
        $impuestos_sin_fiduciario_usd = $impuestos_sin_fiduciario_pesos = '0.00';

        $valores_limpios_item = ['producto_general_id', 'row_tipo', 'fiduciario_details', 'modo', 'definicion', 'config', 'hash', 'tipo_producto', 'tipo_igi', 'files', 'calculadora_igi_item_id', 'tipo_unidad_inteligente', 'remarks', 'fraccion_arancelaria', 'producto_descripcion', 'producto_descripcion_pedimento', 'producto_gsm', 'producto_umc', 'producto_umt', 'producto_unidad'];
        foreach ($items as $key => &$item) {
            /*if (empty($item['valor_factura']) && empty($item['total']))
                continue;*/

            $item['producto_general_id'] = strip_tags(vx_trim($item['producto_general_id']));
            $producto_label = $item['producto_general_label'] ?? '';
            unset(
                $item['producto_general_label'],
                $item['id'],
                $item['cambio'],
            );

            if (empty($item['producto_general_id'])) {
                $producto_label = strip_tags(vx_trim($producto_label));
                $producto_label = preg_replace('/&amp;nbsp;/i', '', $producto_label);
                $producto_label = preg_replace('/&nbsp;/i', '', $producto_label);
                $item['producto_general_id'] = $producto_label;
            }



            foreach ($item as $campo => $valor) {
                $item[$campo] = strlen($valor)>0?limpiaCantidad_($valor):$valor;
                if (in_array($campo, $valores_limpios_item)) {
                    $item[$campo] = $valor;
                }
            }
            if (empty($item['calculadora_igi_item_id']))
                $item['calculadora_igi_item_id'] = ia_guid();


            $item_id = $item['calculadora_igi_item_id'];

            $set_alta_cambio_date = addSeconds($now, $key);
            $item['calculadora_igi_id'] = $calculadora_id;
            if (empty($item['moneda_id'])) {
                $item['moneda_id'] = $values['moneda_id']??1;
            }

            $item['alta_db'] = $set_alta_cambio_date;
            $item['alta_por'] = $_SESSION['usuario'];
            $item['ultimo_cambio'] = $set_alta_cambio_date;
            $item['ultimo_cambio_por'] = $_SESSION['usuario'];

            // obtenemos los archivos del item
            // dd_($item);
            /*dd_($item['files']);
            $files = json_decode($item['files'], true);
            foreach ($files as &$file) {
                $url_origen = $gIApath['FilePath'].str_replace("../", "", $file['path4File'].$file['nombre']);

                $file['path4File'] = str_replace("/temp_items/", "/items/$item_id/", $file['path4File']);
                $path_destino = $gIApath['FilePath'].str_replace("../", "", $file['path4File']);
                $url_destino = $path_destino.$file['nombre'];
                // para crear la carpeta del item
                ia_fileName($path_destino, $file['nombre'], $gWebDir);
                copy($url_origen, $url_destino);
            }
            unset($file);
            $item['files'] = json_encode($files, JSON_OPTIONS_FOR_MYSQL);*/

            // unset($item['orden']);

            $queries[] = $sql_builder->insert('calculadora_igi_item', $item);

            $total_fact = bcadd($total_fact, $item['valor_factura'], 2);
            $total_igi = bcadd($total_igi, $item['igi'], 2);
            $total_dta = bcadd($total_dta, $item['dta'], 2);
            $total_iva = bcadd($total_iva, $item['iva'], 2);
            $total_fid = bcadd($total_fid, $item['fiduciario_pesos']??'0', 2);
            $total_fid_usd = bcadd($total_fid_usd, $item['fiduciario_usd']??'0', 2);

            $total = bcadd($total, $item['total'], 2);
            $total_usd = bcadd($total_usd, $item['total_usd']??'0', 2);

            $impuestos_sin_fiduciario_usd = bcadd($impuestos_sin_fiduciario_usd, $item['impuestos_sin_fiduciario_usd']??'0', 2);
            $impuestos_sin_fiduciario_pesos = bcadd($impuestos_sin_fiduciario_pesos, $item['impuestos_sin_fiduciario_pesos']??'0', 2);
        }
        unset($item);
        $values['total_factura'] = $total_fact;
        $values['igi'] = $total_igi;
        $values['dta'] = $total_dta;
        $values['iva'] = $total_iva;
        $values['total'] = $total;
        $values['total_usd'] = $total_usd;
        if ($values['para_pedimento'] === 'Si') {
            $values['total'] = bcadd($total, ($values['prevalidacion_pesos']??'0'));
            $values['total_usd'] = bcadd($total_usd, ($values['prevalidacion_usd']??'0'));
        }
        $values['fiduciario_pesos'] = $total_fid;
        $values['fiduciario_usd'] = $total_fid_usd;
        $values['impuestos_sin_fiduciario_usd'] = $impuestos_sin_fiduciario_usd;
        $values['impuestos_sin_fiduciario_pesos'] = $impuestos_sin_fiduciario_pesos;

        // $values['items'] = json_encode($items_save, JSON_OPTIONS_FOR_MYSQL);;
        $values['alta_db'] = $values['ultimo_cambio'] = date("Y-m-d H:i:s");
        $values['alta_por'] =  $values['ultimo_cambio_por'] = $_SESSION['usuario'];

        // obtenemos los archivos
        $path_files = "uploads/calculadora_igi/$calculadora_id/temp_anexos/";
        $files = self::getFiles($path_files);
        if ($values['para_pedimento'] === 'Si') {
            $files_set = [];
            foreach ($files as $dir) {
                $dir_name = $dir['nombre'];
                $tipo_archivo_id = explode("_", $dir_name)[1]??'';
                $path = $path_files."$dir_name/";
                $files_from_dir = self::getFiles($path);
                if (empty($files_from_dir)) {
                    rmdir($path);
                    continue;
                }


                foreach ($files_from_dir as &$file) {
                    $url_origen = $gIApath['FilePath'].str_replace("../", "", $file['path4File'].$file['nombre']);

                    $file['path4File'] = str_replace("/temp_anexos/$dir_name/", "/anexos/", $file['path4File']);
                    $path_destino = $gIApath['FilePath'].str_replace("../", "", $file['path4File']);
                    $url_destino = $path_destino.$file['nombre'];


                    $file['tipo_archivo_id'] = $tipo_archivo_id;

                    // para crear la carpeta de anexos si no existe
                    ia_fileName($path_destino, $file['nombre'], $gWebDir);
                    copy($url_origen, $url_destino);

                    $files_set[] = $file;
                }
                unset($file);
            }
            $files = $files_set;
        }
        else {
            foreach ($files as &$file) {
                $url_origen = $gIApath['FilePath'].str_replace("../", "", $file['path4File'].$file['nombre']);

                $file['path4File'] = str_replace("/temp_anexos/", "/anexos/", $file['path4File']);
                $path_destino = $gIApath['FilePath'].str_replace("../", "", $file['path4File']);
                $url_destino = $path_destino.$file['nombre'];
                // para crear la carpeta de anexos si no existe
                ia_fileName($path_destino, $file['nombre'], $gWebDir);
                copy($url_origen, $url_destino);
            }
            unset($file);
        }
        $values['files'] = json_encode($files, JSON_OPTIONS_FOR_MYSQL);




        if(empty($values['nombre'])) {
            $total_label = $values['moneda_id'] == '1' ? number_format($total, 2): number_format($total_usd, 2);
            $values['nombre'] = $_SESSION['usuario'].", ".date("Y-m-d H:i:s");
        }
        /*if(empty($values['numero_contenedor'])) {
            $total_label = $values['moneda_id'] == '1' ? number_format($total, 2): number_format($total_usd, 2);
            $values['numero_contenedor'] = $_SESSION['usuario'].", ".date("Y-m-d H:i:s");
        }*/

        // if (!empty($values['productos_buscados'])) {
            $productos = $values['productos_buscados']??[];
            if (is_array($productos)) {
                $productos = json_encode($productos, JSON_OPTIONS_FOR_MYSQL);
                $values['productos_buscados'] = $productos;
            }
        // }

        $campos_pedimento_config = $values['campos_pedimento_config']??[];
        if (is_array($campos_pedimento_config)) {
            $campos_pedimento_config = json_encode($campos_pedimento_config, JSON_OPTIONS_FOR_MYSQL);
            $values['campos_pedimento_config'] = $campos_pedimento_config;
        }

        if (!empty($values['fecha_entrada']))
            $values['fecha_entrada'] = date('Y-m-d', strtotime($values['fecha_entrada']));


        if (strlen($values['valor_pedimento_exportacion_usd']) === 0)
            $values['diferencia_exportacion_usd'] = '';
        $campos_falta_llenar = [];
        if ($values['para_pedimento'] === 'Si') {
            // obtenemos los consecutivos
            $values['consecutivo_pedimento'] = "(SELECT IFNULL(MAX(ci.consecutivo_pedimento), 0)+1 FROM calculadora_igi ci WHERE ci.para_pedimento = 'Si')";

            if ($values['empresa_id'] != '0') {
                $empresa_id = $values['empresa_id'];
                $values['consecutivo_pedimento_empresa'] = "(SELECT IFNULL(MAX(ci2.consecutivo_pedimento_empresa), 0)+1 FROM calculadora_igi as ci2 WHERE ci2.para_pedimento = 'Si' AND ci2.empresa_id = '$empresa_id')";
            }


            foreach (CostosContenedor::$campos_para_pedimento_validar as $campo => $label) {
                if (isset($values[$campo]) && strlen($values[$campo])===0)
                    $campos_falta_llenar[$campo] = $label;
            }

        }
        $values['falta_llenar'] = json_encode($campos_falta_llenar, JSON_OPTIONS_FOR_MYSQL);

        if (empty($values['tipo_archivo_no_aplica_por_sistema']) || (!is_array($values['tipo_archivo_no_aplica_por_sistema']) && strlen($values['tipo_archivo_no_aplica_por_sistema'])===0))
            $values['tipo_archivo_no_aplica_por_sistema'] = [];

        if (empty($values['tipo_archivo_no_aplica']) || (!is_array($values['tipo_archivo_no_aplica']) && strlen($values['tipo_archivo_no_aplica'])===0))
            $values['tipo_archivo_no_aplica'] = [];

        $values['tipo_archivo_no_aplica_por_sistema'] = json_encode($values['tipo_archivo_no_aplica_por_sistema'], JSON_OPTIONS_FOR_MYSQL);
        $values['tipo_archivo_no_aplica'] = json_encode($values['tipo_archivo_no_aplica'], JSON_OPTIONS_FOR_MYSQL);

        /*if ($values['tipo_captura']==='grid') {
            $values['moneda_id']=999;
        }*/
        $insert = $sql_builder->insert('calculadora_igi', $values, fieldNameDontQuote: ['consecutivo_pedimento', 'consecutivo_pedimento_empresa']);
        $queries[0] = $insert;

        if (ia_transaction($queries))
            return 409;

        CostosContenedor::$id_insert = $values['calculadora_igi_id'];
        self::genera_historian($values['calculadora_igi_id'], 'insert');
        return true;
    }

    public static function delete($calculadora_id, $hard_delete = false): bool|int
    {
        $calculadora_id_it = strit($calculadora_id);
        $calculadora = ia_singleton("SELECT puede_borrar, para_pedimento FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it");
        if (empty($calculadora)) // no existe
            return 404;

        if (!$hard_delete) {
            if ($calculadora['para_pedimento'] === 'Si' && $calculadora['puede_borrar'] === 'No') {
                CostosContenedor::$msg_error = 'El pedimento ya no se puede borrar';
                return 406;
            }
        }



        $accion = 'delete';

        $nick = $_SESSION['usuario'];
        $now = date("Y-m-d H:i:s");
        $campos_set = [
            "activo = 'No'",
            "activo_el = '$now'",
            "activo_por = '$nick'"
        ];

        if ($hard_delete) {
            $campos_set[] = "eliminado = 'Si'";
            $campos_set[] = "eliminado_el = '$now'";
            $campos_set[] = "eliminado_por = '$nick'";
            $accion = 'hard_delete';
        }


        $set_campos = implode(', ', $campos_set);

        $queries = [
            "UPDATE calculadora_igi SET $set_campos WHERE calculadora_igi_id = $calculadora_id_it",
            "UPDATE calculadora_igi_item SET activo = 'No' WHERE calculadora_igi_id = $calculadora_id_it",
        ];
        if (ia_transaction($queries))
            return 409;

        self::genera_historian($calculadora_id, $accion);
        return true;
    }

    public static function delete_ids($ids, bool $para_pedimento = false, $hard_delete = false): bool|int
    {
        $ids_in = parseClauseIn($ids);

        $accion = 'delete';

        $nick = $_SESSION['usuario'];
        $now = date("Y-m-d H:i:s");
        $campos_set = [
            "activo = 'No'",
            "activo_el = '$now'",
            "activo_por = '$nick'"
        ];

        $and_where = '';

        if ($hard_delete) {
            $campos_set[] = "eliminado = 'Si'";
            $campos_set[] = "eliminado_el = '$now'";
            $campos_set[] = "eliminado_por = '$nick'";
            $accion = 'hard_delete';
        }
        else {
            $and_where = " AND puede_borrar = 'Si'";

            $ids_pueden_borrar = ia_sqlVector("SELECT calculadora_igi_id FROM calculadora_igi WHERE calculadora_igi_id IN ($ids_in) $and_where");

            $counter = count($ids_pueden_borrar);
            if ($counter == 0) {
                CostosContenedor::$msg_error = 'Los documentos ya están bloqueado para borrar';
                return 406;
            }

            CostosContenedor::$msg = "Solo se borrarón $counter de ".count($ids). "<br>Los otros ya estaán bloqueado para borrar";

            $ids = $ids_pueden_borrar;
            $ids_in = parseClauseIn($ids_pueden_borrar);
        }

        $set_campos = implode(', ', $campos_set);

        $updates = [
            "UPDATE calculadora_igi SET $set_campos WHERE calculadora_igi_id IN ($ids_in) $and_where",
            "UPDATE calculadora_igi_item SET activo = 'No' WHERE calculadora_igi_id IN ($ids_in)",
            // "DELETE FROM calculadora_igi_item WHERE calculadora_igi_id IN ($ids_in)"
        ];

        if (ia_transaction($updates))
            return 409;

        foreach ($ids as $id) {
            self::genera_historian($id, $accion);
        }

        return true;
    }

    public static function lock_unlock_calculadoras_editar($ids, bool $para_pedimento = false, $lock = true): bool|int
    {
        $ids_in = parseClauseIn($ids);

        $accion = 'lock_editar';

        $nick = $_SESSION['usuario'];
        $now = date("Y-m-d H:i:s");

        $set_puede = $lock ? 'No':'Si';

        if ($set_puede === 'Si')
            $accion = 'unlock_editar';

        $campos_set = [
            "puede_editar = '$set_puede'",
            "puede_editar_el = '$now'",
            "puede_editar_por = '$nick'"
        ];

        $set_campos = implode(', ', $campos_set);

        $updates = [
            "UPDATE calculadora_igi SET $set_campos WHERE calculadora_igi_id IN ($ids_in)",
        ];

        if (ia_transaction($updates))
            return 409;

        foreach ($ids as $id) {
            self::genera_historian($id, $accion);
        }

        return true;
    }

    public static function lock_unlock_calculadoras_borrar($ids, bool $para_pedimento = false, $lock = true): bool|int
    {
        $ids_in = parseClauseIn($ids);

        $accion = 'lock_borrar';

        $nick = $_SESSION['usuario'];
        $now = date("Y-m-d H:i:s");

        $set_puede = $lock ? 'No':'Si';

        if ($set_puede === 'Si')
            $accion = 'unlock_borrar';

        $campos_set = [
            "puede_borrar = '$set_puede'",
            "puede_borrar_el = '$now'",
            "puede_borrar_por = '$nick'"
        ];

        $set_campos = implode(', ', $campos_set);

        $updates = [
            "UPDATE calculadora_igi SET $set_campos WHERE calculadora_igi_id IN ($ids_in)",
        ];

        if (ia_transaction($updates))
            return 409;

        foreach ($ids as $id) {
            self::genera_historian($id, $accion);
        }

        return true;
    }

    public static function activa(string $calculadora_id): bool|int
    {
        $calculadora_id_it = strit($calculadora_id);
        $existe = ia_singleread("SELECT 1 FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it")==1;
        if (!$existe)
            return 404;

        $nick = $_SESSION['usuario'];
        $now = date("Y-m-d H:i:s");
        $campos_set = [
            "activo = 'Si'",
            "activo_el = '$now'",
            "activo_por = '$nick'",
            "puede_borrar = 'Si'",
            "puede_borrar_el = '$now'",
            "puede_borrar_por = 'sistmema'",
            "puede_editar = 'Si'",
            "puede_editar_el = '$now'",
            "puede_editar_por = 'sistmema'"
        ];

        $set_campos = implode(', ', $campos_set);

        $queries = [
            "UPDATE calculadora_igi SET $set_campos WHERE calculadora_igi_id = $calculadora_id_it",
            "UPDATE calculadora_igi_item SET activo = 'Si' WHERE calculadora_igi_id = $calculadora_id_it",
        ];
        if (ia_transaction($queries))
            return 409;

        self::genera_historian($calculadora_id, 'restore');
        return true;
    }

    public static function update($calculadora_id, $values): bool|int
    {
        global $gIApath;
        global $gWebDir;

        $calculadora_id_it = strit($calculadora_id);
        $calculadora_db = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it");
        if (empty($calculadora_db)) // no existe
            return 404;

        if ($calculadora_db['para_pedimento'] === 'Si' && $calculadora_db['puede_editar'] === 'No') {
            CostosContenedor::$msg_error = 'El pedimento ya no se puede editar';
            return 406;
        }

        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $valores_limpios = ['numero_contenedor', 'nombre', 'tipo_captura', 'productos_buscados', 'config', 'numero_pi', 'own_reference', 'fabrica_id', 'fabrica_numero', 'remarks'];
        $campos_para_pedimento_limpios = [
            'empresa_id', 'numero_contenedor', 'fecha_entrada', 'numero_pedimento', 'fabrica_id', 'fabrica_numero', 'numero_pi', 'proveedor_id', 'id_fiscal_proveedor', 'invoice_numero', 'own_reference', 'agente_aduanal_id', 'agente_aduanal_nombre', 'agente_aduanal_razon_social', 'aduana_id', 'peso_bruto', 'incoterm', 'bl_number', 'shipping_line_id', 'pedimento_exportacion_china', 'diferencia_exportacion_usd', 'presento_exportacion_china', 'campos_pedimento_config'
        ];
        $valores_limpios = array_merge($valores_limpios, $campos_para_pedimento_limpios);

        $items = $values['items']??[];
        unset($values['items']);
        foreach ($values as $key => $value) {
            if (in_array($key, $valores_limpios))
                continue;
            $values[$key] = limpiaCantidad_($value);
        }

        // $queries = ["DELETE FROM calculadora_igi_item WHERE calculadora_igi_id = $calculadora_id_it"];
        $queries = [];

        $items_id_db = ia_sqlVector("SELECT calculadora_igi_item_id FROM calculadora_igi_item WHERE calculadora_igi_id = $calculadora_id_it");

        $ids_que_vienen = array_filter(array_column($items, 'id'));
        // 1.- Eliminamos los items que ya no vienen
        foreach ($items_id_db as $id) {
            if(!in_array($id, $ids_que_vienen))
                $queries[] = "DELETE FROM calculadora_igi_item WHERE calculadora_igi_item_id = '$id'";
        }

        // 2.- Recorremos los items que vienen
        //  Validamos si es un update o un insert
        //      INSERT: es un insert de los datos, no hay nada que hacer
        //      UPDATE: Validamos si cambio el registro para hacer update. **SÍ NO CAMBIO LA CONFIGURACIÓN NO SE ACTULIZA EL CAMPO 'config'
        // dd_($items);
        $now = date('Y-m-d H:i:s');
        $total = $total_fact = $total_igi = $total_dta = $total_iva =  $total_fid = $total_fid_usd = '0.00';
        $total_usd = $impuestos_sin_fiduciario_usd = $impuestos_sin_fiduciario_pesos = '0.00';

        $valores_limpios_item = ['producto_general_id', 'row_tipo', 'fiduciario_details', 'modo', 'definicion', 'config', 'hash', 'cambio_config', 'tipo_producto', 'tipo_igi', 'files', 'calculadora_igi_item_id', 'tipo_unidad_inteligente', 'remarks', 'fraccion_arancelaria', 'producto_descripcion', 'producto_descripcion_pedimento', 'producto_gsm', 'producto_umc', 'producto_umt', 'producto_unidad'];
        foreach ($items as $key => &$item) {
            $item['producto_general_id'] = strip_tags(vx_trim($item['producto_general_id']));
            // $item['producto_general_id'] = str_replace(["&NBSP;", "&nbsp;"], ["", ""], $item['producto_general_id']);
            /*if (empty($item['valor_factura']) && empty($item['total']))
                continue;*/
            $es_nuevo = false;
            $id_item = $item['id'];
            if (empty($item['id'])) { // es un insert (nuevo item)
                $es_nuevo = true;
            }

            $producto_label = $item['producto_general_label'] ?? '';
            $item_cambio = strcasecmp($item['cambio'], 'si')===0;
            unset(
                $item['producto_general_label'],
                $item['id'],
                $item['cambio'],
            );

            if (empty($item['producto_general_id'])) {
                $producto_label = strip_tags(vx_trim($producto_label));
                $producto_label = preg_replace('/&amp;nbsp;/i', '', $producto_label);
                $producto_label = preg_replace('/&nbsp;/i', '', $producto_label);
                $item['producto_general_id'] = $producto_label;
            }


            foreach ($item as $campo => $valor) {
                $item[$campo] = strlen($valor)>0?limpiaCantidad_($valor):$valor;
                if (in_array($campo, $valores_limpios_item)) {
                    $item[$campo] = $valor;
                }
            }


            if (empty($item['calculadora_igi_item_id']))
                $item['calculadora_igi_item_id'] = ia_guid();



            $set_alta_cambio_date = addSeconds($now, $key);
            $item['calculadora_igi_id'] = $calculadora_id;
            /*if (empty($item['moneda_id'])) {
                $item['moneda_id'] = $values['moneda_id'];
            }*/
            if ($es_nuevo) {
                $item['alta_db'] = $set_alta_cambio_date;
                $item['alta_por'] = $_SESSION['usuario'];
                $item['ultimo_cambio'] = $set_alta_cambio_date;
                $item['ultimo_cambio_por'] = $_SESSION['usuario'];

                // $item_id = $item['calculadora_igi_item_id'];

                // obtenemos los archivos del item
                /*$path_files = "uploads/calculadora_igi/$calculadora_id/temp_items/{$key}__/";
                $files = self::getFiles($path_files);
                foreach ($files as &$file) {
                    $url_origen = $gIApath['FilePath'].str_replace("../", "", $file['path4File'].$file['nombre']);

                    $file['path4File'] = str_replace("/temp_items/{$key}__/", "/items/$item_id/", $file['path4File']);
                    $path_destino = $gIApath['FilePath'].str_replace("../", "", $file['path4File']);
                    $url_destino = $path_destino.$file['nombre'];
                    // para crear la carpeta del item
                    ia_fileName($path_destino, $file['nombre'], $gWebDir);
                    copy($url_origen, $url_destino);
                }
                unset($file);
                $item['files'] = json_encode($files, JSON_OPTIONS_FOR_MYSQL);*/
            }
            else {
                $item['ultimo_cambio'] = $now;
                $item['ultimo_cambio_por'] = $_SESSION['usuario'];
            }

            // unset($item['orden']);
            if ($es_nuevo) {
                $queries[] = $sql_builder->insert('calculadora_igi_item', $item);
            }
            else {
                unset(
                    $item['calculadora_igi_item_id'],
                    $item['calculadora_igi_id']
                );
                if ($item_cambio) {
                    // ** Validamos si el config cambio
                    if (strcasecmp($item['cambio_config'], 'No') === 0) { // **si no cambio el config, no actulizamos el campo
                        unset($item['config']);
                    }
                    $queries[] = $sql_builder->update('calculadora_igi_item', $item, ['calculadora_igi_item_id' => $id_item]);
                }
            }


            $total_fact = bcadd($total_fact, $item['valor_factura'], 2);
            $total_igi = bcadd($total_igi, $item['igi'], 2);
            $total_dta = bcadd($total_dta, $item['dta'], 2);
            $total_iva = bcadd($total_iva, $item['iva'], 2);
            $total_fid = bcadd($total_fid, $item['fiduciario_pesos']??'0', 2);
            $total_fid_usd = bcadd($total_fid_usd, $item['fiduciario_usd']??'0', 2);

            $total = bcadd($total, $item['total'], 2);
            $total_usd = bcadd($total_usd, $item['total_usd']??'0', 2);

            $impuestos_sin_fiduciario_usd = bcadd($impuestos_sin_fiduciario_usd, $item['impuestos_sin_fiduciario_usd']??'0', 2);
            $impuestos_sin_fiduciario_pesos = bcadd($impuestos_sin_fiduciario_pesos, $item['impuestos_sin_fiduciario_pesos']??'0', 2);
        }
        unset($item);

        $values['total_factura'] = $total_fact;
        $values['igi'] = $total_igi;
        $values['dta'] = $total_dta;
        $values['iva'] = $total_iva;
        $values['total'] = $total;
        $values['total_usd'] = $total_usd;

        if ($calculadora_db['para_pedimento'] === 'Si') {
            $values['total'] = bcadd($total, ($values['prevalidacion_pesos']??'0'));
            $values['total_usd'] = bcadd($total_usd, ($values['prevalidacion_usd']??'0'));
        }
        $values['fiduciario_pesos'] = $total_fid;
        $values['fiduciario_usd'] = $total_fid_usd;
        $values['impuestos_sin_fiduciario_usd'] = $impuestos_sin_fiduciario_usd;
        $values['impuestos_sin_fiduciario_pesos'] = $impuestos_sin_fiduciario_pesos;

        // if (!empty($values['productos_buscados'])) {
            $productos = $values['productos_buscados']??[];
            if (is_array($productos)) {
                $productos = json_encode($productos, JSON_OPTIONS_FOR_MYSQL);
                $values['productos_buscados'] = $productos;
            }
        // }
        $campos_pedimento_config = $values['campos_pedimento_config']??[];
        if (is_array($campos_pedimento_config)) {
            $campos_pedimento_config = json_encode($campos_pedimento_config, JSON_OPTIONS_FOR_MYSQL);
            $values['campos_pedimento_config'] = $campos_pedimento_config;
        }

        if (!empty($values['fecha_entrada']))
            $values['fecha_entrada'] = date('Y-m-d', strtotime($values['fecha_entrada']));

        if (strlen($values['valor_pedimento_exportacion_usd']) === 0)
            $values['diferencia_exportacion_usd'] = '';

        $campos_falta_llenar = [];
        if ($calculadora_db['para_pedimento'] === 'Si') {
            // Sí cambio la empresa/importadora, recalculamos su consecutivo (consecutivo_pedimento_empresa)
            if ($values['empresa_id'] == '0' || $values['empresa_id'] == '') { // si no trae empresa le quitamos el consecutivo
                $values['consecutivo_pedimento_empresa'] = "0";
            }
            else {
                if ($values['empresa_id'] != $calculadora_db['empresa_id']) {
                    $empresa_id = $values['empresa_id'];
                    $values['consecutivo_pedimento_empresa'] = "(SELECT consec_empresa FROM(SELECT IFNULL(MAX(ci.consecutivo_pedimento_empresa), 0)+1 as consec_empresa FROM calculadora_igi as ci WHERE ci.para_pedimento = 'Si' AND ci.empresa_id = '$empresa_id') as x)";
                }
            }


            foreach (CostosContenedor::$campos_para_pedimento_validar as $campo => $label) {
                if (isset($values[$campo]) && strlen($values[$campo])===0)
                    $campos_falta_llenar[$campo] = $label;
            }
        }
        $values['falta_llenar'] = json_encode($campos_falta_llenar, JSON_OPTIONS_FOR_MYSQL);

        $values['ultimo_cambio'] = 'NOW()';
        $values['ultimo_cambio_por'] = $_SESSION['usuario'];



        $update = $sql_builder->update('calculadora_igi', $values, ['calculadora_igi_id'=>$calculadora_id], ['consecutivo_pedimento_empresa']);
        $queries[] = $update;

        if (ia_transaction($queries))
            return 409;

        self::genera_historian($calculadora_id, 'update');

        return true;
    }

    public static function genera_historian(string $calculadora_id, string $accion, string $motive='', string $nick = '')
    {
        $id_it = strit($calculadora_id);
        $historian = new Historian('calculadora_igi', ['calculadora_igi_id']);
        $record = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = $id_it");
        if (!empty($record)) {
            $record['items'] = ia_sqlArrayIndx("SELECT * FROM calculadora_igi_item WHERE calculadora_igi_id = $id_it");
            $historian->set($accion, ['calculadora_igi_id' => $calculadora_id], $record, $motive, $nick);
        }
    }

    public static function after_save_calculadora(string $calculadora_id): void
    {
        self::remove_files_temps($calculadora_id);
    }

    public static function after_update_calculadora(string $calculadora_id): void
    {
        self::remove_files_temps($calculadora_id);
    }



    public static function remove_files_temps(string $calculadora_id): void
    {
        global $gIApath;
        $base_path = $gIApath['FilePath']."uploads/calculadora_igi/$calculadora_id";
        $path_files_items_temp = "$base_path/temp_items";
        $path_files_temp = "$base_path/temp_anexos";

        $paths_to_delete = [
            $path_files_items_temp,
            $path_files_temp
        ];

        $os = strtoupper(substr(PHP_OS, 0, 3));

        foreach ($paths_to_delete as $path_delete) {
            if ($os === 'WIN')
                exec(sprintf("rd /s /q %s", escapeshellarg($path_delete)));
            else
                exec(sprintf("rm -rf %s", escapeshellarg($path_delete)));
        }
        clearstatcache(true, $base_path);
    }

    public static function getFiles($path)
    {
        global $gIApath;
        if (empty($path))
            return [];

        $dir=$gIApath['FilePath']. $path;
        $files = [];
        if(is_file($dir))
            $dir=dirname($dir);

        if (!file_exists($dir))
            return $files;

        if (is_dir($dir)) {
            $files_scan = getFilesFromDir($dir);

            if ($files_scan) {
                foreach ($files_scan as $file_name)
                {
                    $time = filemtime($dir.'/'.$file_name);
                    $files[] = [
                        'id' => ia_guid(),
                        'nombre' => $file_name,
                        'path4File' => "../".str_replace("/vitex/", "../", $path),
                        'time' => $time
                    ];
                }
            }
        }
        return $files;
    }

    public static function update_puede_borrar($execute = true): array|bool|int
    {
        global $gIAParametros;

        if ($gIAParametros['activar_tiempo_para_eliminar_pedimento'] === 'No')
            return $execute?true:[];

        $ahora = new DateTime();
        $ahora->modify("-". $gIAParametros['tiempo_para_eliminar_pedimento']." minutes");

        $ids_set_borrar = ia_sqlVector("SELECT calculadora_igi_id FROM calculadora_igi WHERE puede_borrar = 'Si' AND IF(puede_borrar_el>alta_db, puede_borrar_el, alta_db)<".strit($ahora->format('Y-m-d H:i:s')));

        $ids_in = parseClauseIn($ids_set_borrar);

        $method = __METHOD__;
        $now = date("Y-m-d H:i:s");
        $set_campos = [
            "puede_borrar = 'No'", "puede_borrar_el = '$now'", "puede_borrar_por = 'sistema'"
        ];
        $queries = [
            "UPDATE /*$method*/ calculadora_igi SET ".implode(", ", $set_campos)." WHERE calculadora_igi_id IN($ids_in)"
        ];

        $historian = new Historian('calculadora_igi', ['calculadora_igi_id']);
        foreach ($ids_set_borrar as $id) {
            $record = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = '$id'");
            if (empty($record))
                continue;

            $record['puede_borrar'] = 'No';
            $record['puede_borrar_el'] = $now;
            $record['puede_borrar_por'] = 'sistema';
            $record['items'] = ia_sqlArrayIndx("SELECT * FROM calculadora_igi_item WHERE calculadora_igi_id = '$id'");
            $motivo = 'El sistema bloqueo el documento para que ya no se pueda borrar';
            $queries[] = $historian->getInsertHistorian('lock_borrar', ['calculadora_igi_id' => $id], $record, $motivo, true, 'sistema')['insert'];
        }

        if (!$execute)
            return $queries;


        if (ia_transaction($queries))
            return 409;

        return true;
    }

    public static function update_puede_editar($execute = true): array|bool|int
    {
        global $gIAParametros;

        if ($gIAParametros['activar_tiempo_para_editar_pedimento'] === 'No')
            return $execute?true:[];

        $ahora = new DateTime();
        $ahora->modify("-". $gIAParametros['tiempo_para_editar_pedimento']." minutes");

        $ids_set_editar = ia_sqlVector("SELECT calculadora_igi_id FROM calculadora_igi WHERE puede_editar = 'Si' AND IF(puede_editar_el>alta_db, puede_editar_el, alta_db)<".strit($ahora->format('Y-m-d H:i:s')));

        $ids_in = parseClauseIn($ids_set_editar);

        $now = date("Y-m-d H:i:s");

        $set_campos = [
            "puede_editar = 'No'", "puede_editar_el = '$now'", "puede_editar_por = 'sistema'"
        ];

        $method = __METHOD__;
        $queries = [
            "UPDATE /*$method*/ calculadora_igi SET ".implode(", ", $set_campos)." WHERE calculadora_igi_id IN($ids_in)"
        ];

        $historian = new Historian('calculadora_igi', ['calculadora_igi_id']);
        foreach ($ids_set_editar as $id) {
            $record = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = '$id'");
            if (empty($record))
                continue;

            $record['puede_editar'] = 'No';
            $record['puede_editar_el'] = $now;
            $record['puede_editar_por'] = 'sistema';
            $record['items'] = ia_sqlArrayIndx("SELECT * FROM calculadora_igi_item WHERE calculadora_igi_id = '$id'");
            $motivo = 'El sistema bloqueo el documento para que ya no se pueda editar';
            $queries[] = $historian->getInsertHistorian('lock_editar', ['calculadora_igi_id' => $id], $record, $motivo, true, 'sistema')['insert'];
        }

        if (!$execute)
            return $queries;

        if (ia_transaction($queries))
            return 409;

        return true;
    }

    public static function set_puede_borrar(string $calculadora_id, string $set_puede): bool|int
    {
        $calculadora_id_it = strit($calculadora_id);
        $existe = ia_singleread("SELECT 1 FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it")==1;
        if (!$existe)
            return 404;

        $method = __METHOD__;

        $accion = 'lock_borrar';

        if ($set_puede === 'Si')
            $accion = 'unlock_borrar';

        $now = date("Y-m-d H:i:s");
        $set_puede_it = strit($set_puede);
        $set_campos = [
            "puede_borrar = $set_puede_it", "puede_borrar_el = '$now'", "puede_borrar_por = '$_SESSION[usuario]'"
        ];
        $update = "UPDATE /*$method*/ calculadora_igi SET ".implode(", ", $set_campos)." WHERE calculadora_igi_id = $calculadora_id_it";

        if (ia_query($update))
            return 409;

        self::genera_historian($calculadora_id, $accion);
        return true;
    }

    public static function set_puede_editar(string $calculadora_id, string $set_puede): bool|int
    {
        $calculadora_id_it = strit($calculadora_id);
        $existe = ia_singleread("SELECT 1 FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it")==1;
        if (!$existe)
            return 404;

        $method = __METHOD__;

        $accion = 'lock_editar';

        if ($set_puede === 'Si')
            $accion = 'unlock_editar';

        $now = date("Y-m-d H:i:s");
        $set_puede_it = strit($set_puede);
        $set_campos = [
            "puede_editar = $set_puede_it", "puede_editar_el = '$now'", "puede_editar_por = '$_SESSION[usuario]'"
        ];
        $update = "UPDATE /*$method*/ calculadora_igi SET ".implode(", ", $set_campos)." WHERE calculadora_igi_id = $calculadora_id_it";

        if (ia_query($update))
            return 409;

        self::genera_historian($calculadora_id, $accion);
        return true;
    }

    public static function set_no_aplica(string $id, $tipo_archivo_id, $por_sistema = false)
    {
        $method = __METHOD__;
        $calculadora_id_it = strit($id);
        $record = ia_singleton("SELECT /*$method*/ tipo_archivo_no_aplica, tipo_archivo_no_aplica_por_sistema FROM calculadora_igi WHERE calculadora_igi_id = $calculadora_id_it");
        if (empty($record))
            return 404;

        if (!is_array($tipo_archivo_id)) {
            if (empty($tipo_archivo_id))
                $tipo_archivo_id = [];
            else
                $tipo_archivo_id = [$tipo_archivo_id];
        }

        $tp_id = $tipo_archivo_id;

        $tipo_archivo_id = json_encode($tipo_archivo_id, JSON_OPTIONS_FOR_MYSQL);
        $campos = [];
        if ($por_sistema) {
            $endb = $record['tipo_archivo_no_aplica_por_sistema']??'[]';
            if(strlen($endb)===0)
                $endb = '[]';

            $no_aplica_sistema_db = json_decode($endb, true);
            if (!is_array($no_aplica_sistema_db))
                $no_aplica_sistema_db = json_decode($no_aplica_sistema_db, true);

            $diff = array_diff($no_aplica_sistema_db, $tp_id);
            if (empty($diff)) {
                CostosContenedor::$diff= false;
                return true;
            }

            $campos[] = "tipo_archivo_no_aplica_por_sistema = '$tipo_archivo_id'";
            if (empty($record['tipo_archivo_no_aplica'])) {
                $campos[] = "tipo_archivo_no_aplica = '$tipo_archivo_id'";
            }
        }
        else {
            $campos[] = "tipo_archivo_no_aplica = '$tipo_archivo_id'";
        }
        $campos = implode(", ", $campos);
        $update = "UPDATE calculadora_igi SET $campos WHERE calculadora_igi_id = $calculadora_id_it";
        if (ia_query($update))
            return 409;

        $tipo_archivo = "TODOS";
        if(!empty($tp_id)) {
            $tipo_archivo_id_in = parseClauseIn($tp_id);
            $tipo_archivo = ia_sqlVector("SELECT nombre FROM tipo_archivo WHERE tipo_archivo_id IN($tipo_archivo_id_in)");
            $tipo_archivo = implode(", ", $tipo_archivo);
        }

        $nick = $por_sistema? 'sistema':'';
        $motivo = "Se puso NO APLICA, para los arhivos de $tipo_archivo";
        if ($por_sistema) {
            $motivo = "El sistema puso NO APLICA, para los arhivos de $tipo_archivo";
        }

        self::genera_historian($id, 'set_aplica_adjuntos', $motivo, $nick);
        return true;
    }
}

class PasadaTercero
{
    public static function save($values): bool|int
    {
        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $items = $values['items']??[];
        unset($values['items']);

        if (empty($values['pasada_tercero_id']))
            $values['pasada_tercero_id'] = ia_guid();

        if (!self::_validate_items($items))
            return 400;

        $queries = ['insert_pasada_tercero'];
        $now = date('Y-m-d H:i:s');
        $total = [
            'cantidad' => '0',
            'precio' => '0',
            'total' => '0',
            'ganancia' => '0',
            'pasada_usd' => '0',
        ];
        foreach ($items as $key => $item) {
            $set_alta_cambio_date = addSeconds($now, $key);
            $item['pasada_tercero_id'] = $values['pasada_tercero_id'];
            $item['alta_db'] = $set_alta_cambio_date;
            $item['alta_por'] = $_SESSION['usuario'];
            $item['ultimo_cambio'] = $set_alta_cambio_date;
            $item['ultimo_cambio_por'] = $_SESSION['usuario'];
            $queries[] = $sql_builder->insert('pasada_tercero_item', $item);

            $total['cantidad'] = bcadd($total['cantidad'], $item['cantidad'], 2);
            $total['precio'] = bcadd($total['precio'], $item['precio'], 2);
            $total['total'] = bcadd($total['total'], $item['total'], 2);
            $total['ganancia'] = bcadd($total['ganancia'], $item['ganancia'], 2);
            $total['pasada_usd'] = bcadd($total['pasada_usd'], $item['pasada_usd'], 2);
        }

        $values = array_merge($values, $total);
        $values['registros'] = count($items);
        $values['alta_db'] = $values['ultimo_cambio'] = $now;
        $values['alta_por'] =  $values['ultimo_cambio_por'] = $_SESSION['usuario'];
        $queries[0] = $sql_builder->insert('pasada_tercero', $values);

        if (ia_transaction($queries))
            return 409;

        self::genera_historian($values['pasada_tercero_id'], 'insert');

        CostosContenedor::$id_insert = $values['pasada_tercero_id'];
        return true;
    }

    protected static function _validate_items(array &$items): bool
    {
        if (empty($items)) {
            CostosContenedor::$msg_error = 'No hay articulos para guardar';
            return false;
        }
        $productos_generales_id = array_column($items, 'producto_general_id');
        $productos_generales_id_unicos = array_unique($productos_generales_id);
        if (count($productos_generales_id)!=count($productos_generales_id_unicos)) {
            CostosContenedor::$msg_error = "HAY PRODUCTOS REPETIDOS.<br><br><br> Por favor revisa la captura";
            return false;
        }
        /*$nombre2 = array_unique($productos_generales_id);
        $v_comunes1 = array_diff_assoc($productos_generales_id, $nombre2);
        $v_comunes2 = array_unique($v_comunes1);*/

        $campos_validar = [
            'precio_venta' => [
                'msg_captura' => 'No se calculo el precio de venta',
                'msg_invalid' => 'El precio de venta debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'producto_general_id' => [
                'msg_captura' => 'No se ha seleccionado Articulo',
            ],
            'cantidad' => [
                'msg_captura' => 'No se capturo cantidad',
                'msg_invalid' => 'La cantidad debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'precio' => [
                'msg_captura' => 'No se capturo precio',
                'msg_invalid' => 'El precio debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'total' => [
                'msg_captura' => 'No se calculo total',
                'msg_invalid' => 'El total debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'ganancia' => [
                'msg_captura' => 'No se capturo ganancia',
                'msg_invalid' => 'La ganancia debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'pasada_usd' => [
                'msg_captura' => 'No se capturo el valor de Pasada',
                'msg_invalid' => 'El valor de Pasada debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
        ];
        foreach ($items as &$item) {
            foreach ($campos_validar as $campo_name => $config) {
                if (($item[$campo_name]??'') === '') {
                    CostosContenedor::$msg_error = $config['msg_captura'];
                    return false;
                }
                if (($item[$campo_name]??'') == 0) {
                    CostosContenedor::$msg_error = $config['msg_invalid'];
                    return false;
                }

                if ($config['limpiar_cantidad']??false) {
                    $item[$campo_name] = limpiaCantidad_($item[$campo_name]);
                }
            }
            if (empty($item['pasada_tercero_item_id']))
                $item['pasada_tercero_item_id'] = ia_guid();
        }
        unset($item);
        return true;
    }

    public static function delete(string $pasada_tercero_id): bool|int
    {
        $id_it = strit($pasada_tercero_id);
        $existe = ia_singleread("SELECT 1 FROM pasada_tercero WHERE pasada_tercero_id = $id_it")==1;
        if (!$existe)
            return 404;

        $updates = [
            "UPDATE pasada_tercero SET activo = 'No' WHERE pasada_tercero_id = $id_it",
            "DELETE FROM pasada_tercero_item WHERE pasada_tercero_id = $id_it",
        ];
        if (ia_transaction($updates))
            return 409;

        self::genera_historian($pasada_tercero_id, 'delete');

        return true;
    }

    public static function update(string $pasada_tercero_id, $values): bool|int
    {
        $id_it = strit($pasada_tercero_id);
        $existe = ia_singleread("SELECT 1 FROM pasada_tercero WHERE pasada_tercero_id = $id_it")==1;
        if (!$existe)
            return 404;

        $items = $values['items']??[];
        unset($values['items']);
        if (!self::_validate_items($items))
            return 400;

        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $queries = ["DELETE FROM pasada_tercero_item WHERE pasada_tercero_id = $id_it"];

        $now = date('Y-m-d H:i:s');
        $total = [
            'cantidad' => '0',
            'precio' => '0',
            'total' => '0',
            'ganancia' => '0',
            'pasada_usd' => '0',
        ];
        foreach ($items as $key => $item) {
            $set_alta_cambio_date = addSeconds($now, $key);
            $item['pasada_tercero_id'] = $pasada_tercero_id;
            $item['alta_db'] = $set_alta_cambio_date;
            $item['alta_por'] = $_SESSION['usuario'];
            $item['ultimo_cambio'] = $set_alta_cambio_date;
            $item['ultimo_cambio_por'] = $_SESSION['usuario'];
            $queries[] = $sql_builder->insert('pasada_tercero_item', $item);

            $total['cantidad'] = bcadd($total['cantidad'], $item['cantidad'], 2);
            $total['precio'] = bcadd($total['precio'], $item['precio'], 2);
            $total['total'] = bcadd($total['total'], $item['total'], 2);
            $total['ganancia'] = bcadd($total['ganancia'], $item['ganancia'], 2);
            $total['pasada_usd'] = bcadd($total['pasada_usd'], $item['pasada_usd'], 2);
        }

        $values = array_merge($values, $total);
        $values['registros'] = count($items);
        $values['ultimo_cambio'] = $now;
        $values['ultimo_cambio_por'] = $_SESSION['usuario'];

        unset($values['pasada_tercero_id']);
        $queries[] = $sql_builder->update('pasada_tercero', $values, ['pasada_tercero_id' => $pasada_tercero_id]);

        if (ia_transaction($queries))
            return 409;

        self::genera_historian($pasada_tercero_id, 'update');

        return true;
    }

    private static function genera_historian(string $pasada_tercero_id, string $accion)
    {
        $id_it = strit($pasada_tercero_id);
        $historian = new Historian('pasada_tercero', ['pasada_tercero_id']);
        $record = ia_singleton("SELECT * FROM pasada_tercero WHERE pasada_tercero_id = $id_it");
        $record['items'] = ia_sqlArrayIndx("SELECT * FROM pasada_tercero_item WHERE pasada_tercero_id = $id_it");
        $historian->set($accion, ['pasada_tercero_id' => $pasada_tercero_id], $record);
    }
}

class PrecioVenta
{
    public static function save($values): bool|int
    {
        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $items = $values['items']??[];
        unset($values['items']);

        if (empty($values['precio_venta_id']))
            $values['precio_venta_id'] = ia_guid();

        if (!self::_validate_items($items))
            return 400;

        $queries = ['insert_pasada_tercero'];
        $now = date('Y-m-d H:i:s');
        $total = [
            'registros' => count($items),
            'cantidad' => array_sum(array_column($items, 'cantidad')),
            'precio' => array_sum(array_column($items, 'precio')),
            'total_factura_fabrica' => array_sum(array_column($items, 'total_factura_fabrica')),
            'precio_estimado' => array_sum(array_column($items, 'precio_estimado')),
            'ganancia' => array_sum(array_column($items, 'ganancia')),
            'fiduciario_usd' => array_sum(array_column($items, 'fiduciario_usd')),
            'fiduciario_pesos' => array_sum(array_column($items, 'fiduciario_pesos')),
            'impuestos' => array_sum(array_column($items, 'impuestos')),
            'total_factura_aduana' => array_sum(array_column($items, 'total_factura_aduana')),
            'diferencia_precio' => array_sum(array_column($items, 'diferencia_precio')),
        ];
        foreach ($items as $key => $item) {
            $set_alta_cambio_date = addSeconds($now, $key);
            $item['precio_venta_id'] = $values['precio_venta_id'];
            $item['alta_db'] = $set_alta_cambio_date;
            $item['alta_por'] = $_SESSION['usuario'];
            $item['ultimo_cambio'] = $set_alta_cambio_date;
            $item['ultimo_cambio_por'] = $_SESSION['usuario'];
            $queries[] = $sql_builder->insert('precio_venta_item', $item);
        }

        $values = array_merge($values, $total);
        $values['alta_db'] = $values['ultimo_cambio'] = $now;
        $values['alta_por'] =  $values['ultimo_cambio_por'] = $_SESSION['usuario'];
        $queries[0] = $sql_builder->insert('precio_venta', $values);

        if (ia_transaction($queries))
            return 409;

        self::genera_historian($values['precio_venta_id'], 'insert');

        CostosContenedor::$id_insert = $values['precio_venta_id'];
        return true;
    }

    public static function update(string $precio_venta_id, $values): bool|int
    {
        $id_it = strit($precio_venta_id);
        $existe = ia_singleread("SELECT 1 FROM precio_venta WHERE precio_venta_id = $id_it")==1;
        if (!$existe)
            return 404;

        $items = $values['items']??[];
        unset($values['items']);
        if (!self::_validate_items($items))
            return 400;

        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $queries = ["DELETE FROM precio_venta_item WHERE precio_venta_id = $id_it"];

        $now = date('Y-m-d H:i:s');
        $total = [
            'registros' => count($items),
            'cantidad' => array_sum(array_column($items, 'cantidad')),
            'precio' => array_sum(array_column($items, 'precio')),
            'total_factura_fabrica' => array_sum(array_column($items, 'total_factura_fabrica')),
            'precio_estimado' => array_sum(array_column($items, 'precio_estimado')),
            'ganancia' => array_sum(array_column($items, 'ganancia')),
            'fiduciario_usd' => array_sum(array_column($items, 'fiduciario_usd')),
            'fiduciario_pesos' => array_sum(array_column($items, 'fiduciario_pesos')),
            'impuestos' => array_sum(array_column($items, 'impuestos')),
            'total_factura_aduana' => array_sum(array_column($items, 'total_factura_aduana')),
            'diferencia_precio' => array_sum(array_column($items, 'diferencia_precio')),
        ];
        foreach ($items as $key => $item) {
            $set_alta_cambio_date = addSeconds($now, $key);
            $item['precio_venta_id'] = $precio_venta_id;
            $item['alta_db'] = $set_alta_cambio_date;
            $item['alta_por'] = $_SESSION['usuario'];
            $item['ultimo_cambio'] = $set_alta_cambio_date;
            $item['ultimo_cambio_por'] = $_SESSION['usuario'];
            $queries[] = $sql_builder->insert('precio_venta_item', $item);
        }

        $values = array_merge($values, $total);
        $values['ultimo_cambio'] = $now;
        $values['ultimo_cambio_por'] = $_SESSION['usuario'];

        unset($values['precio_venta_id']);
        $queries[] = $sql_builder->update('precio_venta', $values, ['precio_venta_id' => $precio_venta_id]);

        if (ia_transaction($queries))
            return 409;

        self::genera_historian($precio_venta_id, 'update');

        return true;
    }

    public static function delete(string $precio_venta_id): bool|int
    {
        $id_it = strit($precio_venta_id);
        $existe = ia_singleread("SELECT 1 FROM precio_venta WHERE precio_venta_id = $id_it")==1;
        if (!$existe)
            return 404;

        $updates = [
            "UPDATE precio_venta SET activo = 'No' WHERE precio_venta_id = $id_it",
            "DELETE FROM precio_venta_item WHERE precio_venta_id = $id_it",
        ];
        if (ia_transaction($updates))
            return 409;

        self::genera_historian($precio_venta_id, 'delete');

        return true;
    }

    protected static function _validate_items(array &$items): bool
    {
        if (empty($items)) {
            CostosContenedor::$msg_error = 'No hay articulos para guardar';
            return false;
        }
        $productos_generales_id = array_column($items, 'producto_general_id');
        $productos_generales_id_unicos = array_unique($productos_generales_id);
        if (count($productos_generales_id)!=count($productos_generales_id_unicos)) {
            CostosContenedor::$msg_error = "HAY PRODUCTOS REPETIDOS.<br><br><br> Por favor revisa la captura";
            return false;
        }
        /*$nombre2 = array_unique($productos_generales_id);
        $v_comunes1 = array_diff_assoc($productos_generales_id, $nombre2);
        $v_comunes2 = array_unique($v_comunes1);*/

        $campos_validar = [
            'precio_venta' => [
                'msg_captura' => 'No se calculo el precio de venta',
                'msg_invalid' => 'El precio de venta debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'producto_general_id' => [
                'msg_captura' => 'No se ha seleccionado Articulo',
            ],
            'cantidad' => [
                'msg_captura' => 'No se capturo cantidad',
                'msg_invalid' => 'La cantidad debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'precio' => [
                'msg_captura' => 'No se capturo precio',
                'msg_invalid' => 'El precio debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'total_factura_fabrica' => [
                'msg_captura' => 'No se calculo total',
                'msg_invalid' => 'El total debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'precio_estimado' => [
                'msg_captura' => 'No se capturo precio estimado',
                'msg_invalid' => 'El precio estimado debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'ganancia' => [
                'msg_captura' => 'No se capturo ganancia',
                'msg_invalid' => 'La ganancia debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'fiduciario_usd' => [
                'msg_captura' => 'No se calculo el valor de fiduciario dolares',
                'msg_invalid' => 'El valor de fiduciario dolares debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'fiduciario_pesos' => [
                'msg_captura' => 'No se calculo el valor de fiduciario pesos',
                'msg_invalid' => 'El valor de fiduciario pesos debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'impuestos' => [
                'msg_captura' => 'No se calculo el valor de impuestos',
                'msg_invalid' => 'El valor de impuestos debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'total_factura_aduana' => [
                'msg_captura' => 'No se capturo el valor de factura aduana',
                'msg_invalid' => 'El valor de factura aduana debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ],
            'diferencia_precio' => [
                'msg_captura' => 'No se calculo el valor de diferencia_precio',
                'msg_invalid' => 'El valor de diferencia_precio debe ser mayor que 0',
                'limpiar_cantidad' => true,
            ]
        ];
        foreach ($items as &$item) {
            foreach ($campos_validar as $campo_name => $config) {
                if (($item[$campo_name]??'') === '') {
                    CostosContenedor::$msg_error = $config['msg_captura'];
                    return false;
                }
                if ($campo_name!== 'ganancia' && ($item[$campo_name]??'') == 0) {
                    CostosContenedor::$msg_error = $config['msg_invalid'];
                    return false;
                }

                if ($config['limpiar_cantidad']??false) {
                    $item[$campo_name] = limpiaCantidad_($item[$campo_name]);
                }
            }
            if (empty($item['precio_venta_item_id']))
                $item['precio_venta_item_id'] = ia_guid();
        }
        unset($item);
        return true;
    }
    private static function genera_historian(string $precio_venta_id, string $accion): void
    {
        $id_it = strit($precio_venta_id);
        $historian = new Historian('precio_venta', ['precio_venta_id']);
        $record = ia_singleton("SELECT * FROM precio_venta WHERE precio_venta_id = $id_it");
        $record['items'] = ia_sqlArrayIndx("SELECT * FROM precio_venta_item WHERE precio_venta_id = $id_it");
        $historian->set($accion, ['precio_venta_id' => $precio_venta_id], $record);
    }
}