<?php

class CostosContenedorHist extends HistTable
{

    public function __construct( string $table_hist, int $resaltaHaceSegundos = 10*60, string $pk = '') {
        parent::__construct( $table_hist, $resaltaHaceSegundos, $pk );

        $this->addIgnoreFields(['tiene_pedimento', 'consecutivo_pedimento_empresa', 'consecutivo_pedimento', 'campos_pedimento_config', 'falta_llenar', 'items']); // en estos no muestra diferencia;
    }
    public function getDiferencesTable(int|string $id):string {
        $table = [];
        $ignore = array_flip($this->ignoreFields);
        $diferencias = array_reverse($this->getDiferences($id));

        foreach($diferencias as $d) {
            $classDate = '';
            $classAction = '';
            $classNick = '';
            $muestra = [];
            $nick = ucwords($d['user_nick']);
            if ($d['action'] === 'insert') {
                $muestra[] = "<td class='diff' colspan='3'>$nick creo el registro";
            }
            elseif ($d['action'] === 'delete') {
                $muestra[] = "<td class='diff' colspan='3' style='background:darkred;color: yellow'>$nick Borró el registro";
            }
            elseif ($d['action'] === 'restore') {
                $muestra[] = "<td class='diff' colspan='3' style='background:darkgreen;color: white'>$nick Resturó el registro";
            }
            elseif ($d['action'] === 'set_aplica_adjuntos') {
                $muestra[] = "<td class='diff' colspan='3'>$d[motive]";
            }
            else {
                foreach($d['delta'] as $fieldName => $diff) {
                    if(array_key_exists($fieldName, $ignore))
                        continue;
                    if(empty($diff['es']) && empty($diff['era']))
                        continue;

                    if ($fieldName === 'tipo_archivo_no_aplica_por_sistema' ){
                        $era = [];
                        $es = [];
                        if (strlen($diff['era'])>0) {
                            $era = json_decode($diff['era'], true);
                            if (!is_array($era))
                                $era = json_decode($era, true);
                        }

                        if (strlen($diff['es'])>0) {
                            $es = json_decode($diff['es'], true);
                            if (!is_array($es))
                                $es = json_decode($es, true);
                        }

                        if ($era === $es)
                            continue;
                    }

                    if ($fieldName === 'files') {
                        $muestra[] = "<td class='diff' colspan='3'>$d[motive]";
                    }
                    else {
                        if(empty($diff['es'])) {
                            $muestra[] = "<td><i>" . $this->toLabel($fieldName) . "</i><td class='diff' colspan='2'><b>BORRO: </b>" .
                                $diff['diff_era'];
                            continue;
                        }
                        if(empty($diff['era'])) {
                            $muestra[] =  "<td><i>" . $this->toLabel($fieldName) . "</i><td colspan='2'><b>REGISTRO: </b>" .
                                ($diff['diff_es'] ?? "<pre class='code'>" . print_r($diff, true). "</pre>" ) ;
                            continue;
                        }
                        $muestra[] = "<td><i>" . $this->toLabel($fieldName). "</i>" .
                            "<td class='diff'><b>ERA: </b>" . $diff['diff_era'] .
                            "<td class='diff'><b>A: </b>" . $diff['diff_es'];
                    }
                }
            }

            if(empty($muestra) && strcasecmp($d['action'], 'update') )
                $muestra[] = "<td><i>$d[action]<td colspan='2' class='diff'>$d[motive]";
            if(empty($muestra))
                continue;
            $cambios = "<table class='laTabla'><tr>" . implode("<tr>", $muestra) . "</tr></table>";

            $tiempoHace = fechaDiff($d['date_prev'], $d['date']);
            $segundosHace = abs(strtotime($d['date_prev']) - strtotime($d['date']));
            if($segundosHace >= $this->resaltaHaceSegundos)
                $tiempoHace = "<span style='color:red'>$tiempoHace</span>";
            $table[] =
                "<tr>" .
                "<td class='cen'><span$classDate>" . mysqlDateTime2display($d['date']) . "<div$classAction>$d[action]</div>$tiempoHace" . "</td>" .
                "<td class='cen$classNick'>" . ucwords($d['user_nick']) . "</td>" .
                "<td class='diff'>$cambios";
        }
        return
            "<table class='laTabla'><thead><tr><th>Fecha</th><th>Usuario</th><th>Info</th></tr></thead>" .
            "<tbody>" . implode("", $table) . "</tbody>" .
            "</table>";
    }

    protected function toLabel(string $s):string {
        $upper=['eta'=>true];
        if(array_key_exists(strtolower($s),  $upper))
            return strtoupper($s);
        return ucwords(str_replace(
                ['own_reference', '_id', '_'],
                ['our_reference', ' ',' '],
                $s)
        );
    }
}