<?php
class ProductosChinaCif extends ProductoCostsBodegaReport
{
    private array $productos = [];
    public function __construct(private array $productos_id_in=[]){
        $this->llenaProductos();
    }

    protected function llenaProductos(): void
    {
        $method = __METHOD__;
        $sql = $this->getProductCostsQuery();
        $otherCif = ProductoCostsBodega::getOtherCif();

        $productoStatus = ia_sqlArray(
            "SELECT /*$method*/ producto_general_id,
                        SUM(IF(activo = 'Si' AND en_remate = 'Si', 1, 0)) as num_super_saldo,
                        SUM(IF(activo = 'Si' AND es_saldo = 'Si', 1, 0)) as num_saldo,
                        SUM(IF(activo = 'Si' AND super_lento = 'Si', 1, 0)) as num_super_lento,
                        SUM(IF(activo = 'Si' AND lento = 'Si', 1, 0)) as num_lento,
                        SUM(IF(activo = 'Si' AND pedir = 'No', 1, 0)) as num_no_pedir,
                        SUM(IF(activo = 'Si' AND prohibido = 'No', 1, 0)) as num_colores
                    FROM producto_color
                    WHERE activo = 'Si' AND prohibido = 'No'
                    GROUP BY 1",
            'producto_general_id'
        );

        $productos = ia_sqlArray($sql, 'producto_general_id');
        foreach($productos as $producto_general_id => $p) {
            $productoDeadStock = '';
            if(array_key_exists($producto_general_id, $productoStatus)) {
                $status = $productoStatus[$producto_general_id];
                if($status['num_colores'] == 0) {
                    $productoDeadStock = "<span style='color:red' title='Sin colores'>(0)</span>";
                } elseif($status['num_saldo'] === $status['num_colores']) {
                    $productoDeadStock = '<i title="Dead Stock" style="color:red" class="fa-duotone fa-skull"></i>';
                } elseif($status['num_saldo'] != 0) {
                    $productoDeadStock = "<span style='color:orange' title='$status[num_saldo] Colores en Dead Stock del total de $status[num_colores] colores'><i class='fa-duotone fa-skull'></i> $status[num_saldo]/$status[num_colores]</span>";
                }
            }

            $set_producto = [
                'producto_general_id' => $producto_general_id,
                'producto' => $p['producto_nombre'],
                'producto_dead_stock' => $productoDeadStock,
                'existencia' => $p['existencia_quantity'],
                'cost_cif' => $p['cost_cif'],
                'wh_cif' => $p['para_cif'] === 'Oculto'?'':($otherCif[$producto_general_id]['cost_cif'] ?? "0.00"),
                'loading_capacity' => $p['container_quantity'] ?? '0',
                'costs_loading_capacity' => $p['container_quantity_costs'] ?? '0',
                'container_quantity_costs' => $p['container_quantity_costs'] ?? '0',
                'para_bodega' => $p['para_bodega'],
                'real_data' => $producto_general_id,
                "real_value" => "cc483a12801ab83811ef4baffea1b284",
                'label' => $p['producto_nombre'],
                'value' => $p['producto_nombre'],
                'unidad' => $p['unidad'],
                'estado' => '000000000000',
                'estado_potencia' => '0',
                'tiene_opciones' => 'No',
                'esta_marcado' => 'No',
            ];
            $this->productos[] = $set_producto;
        }
    }

    public function get_productos():array { return $this->productos; }


    public function getProductCostsQuery(): string
    {
        /*
         * PREGUNTAR CON PEPE QUE CAMPO OCUPAR PARA LA LOGICA DE LA IMPORTACIÓN DE PRODUCTOS DE CHINA CIF PARA PRECIOS DE VENTA
         */
        $where_productos_in = "";
        if (!empty($this->productos_id_in)) {
            $where_productos_in = "AND pg.producto_general_id IN(".parseClauseIn($this->productos_id_in).")";
        }
        return <<< SQL
        WITH nums AS (
            SELECT 
                   pg.producto_general_id,
                   CONCAT(pg.producto, ' <span class="gsm_producto">', gsm, '</span>') AS 'producto', CONCAT(pg.producto, ' ', gsm) as producto_bare,
                   u.unidad,
                   IF(pg.para_cif = 'Oculto', '', IFNULL(pcb.cost_cif, 0.00)) as cost_cif,
                   pcb.fecha as Since,
                   IFNULL(pb.existencia_rollos, 0.00) as 'existencia_rollos',
                   IFNULL(pb.existencia_quantity, 0.00) as 'existencia_quantity',
                   IFNULL( CONVERT(pb.existencia_quantity * IFNULL(pcb.cost_cif, 0.00), DECIMAL(16,2)), 0.00) AS total_cif,
                   pg.gsm, pg.container_quantity,
                   pg.container_quantity_costs,
                   pg.producto as producto_nombre,
                   pg.para_cif,
                   pg.para_bodega
            FROM producto_general pg 
                JOIN unidades u ON u.unidades_id = pg.unidades_id
                    LEFT OUTER JOIN producto_bodega pb ON pg.producto_general_id = pb.producto_general_id        
                    LEFT OUTER JOIN producto_costs_bodega pcb
                             ON pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL
            WHERE pg.activo = 'Si' AND pg.para_precio_venta = 'Visible' $where_productos_in
        )
        SELECT
            nums.producto_general_id, nums.producto, nums.unidad, nums.Since as desde, nums.cost_cif,
            SUM(nums.existencia_rollos) as existencia_rollos,
            SUM(nums.existencia_quantity) as existencia_quantity,
            SUM(nums.total_cif) as total_cif,
            nums.gsm,
            nums.container_quantity,
            nums.container_quantity_costs,
            nums.producto_nombre,
            nums.para_cif,
            nums.para_bodega
        FROM nums
        GROUP BY nums.producto_general_id, nums.producto, nums.unidad, nums.Since, nums.cost_cif, nums.gsm, nums.container_quantity
        ORDER BY nums.producto
        SQL;
    }
}