<?php

class UICostosContenedor
{
    public static $add_choser = true; // para agregar seleccionador de columnas en el grid

    public static $app = null;

    public static $title = 'Imp. DE CONTENEDORES';
    static function load_libs(): void
    {
        $modulo = empty($modulo) ? param('modulo') : $modulo;
        $iah = param('iah', '');
        $primary_key = match($modulo) {
            'calculadora_igi', 'calculadora_igi_multiple' => 'calculadora_igi_id',
            'pasada_por_tercero' => 'pasada_tercero_id',
            'precio_venta' => 'precio_venta_id',
            'configuracion_importacion' => 'id'
        };
        $chooser_colum = '';
        if (empty($iah) && self::$add_choser) {
            $chooser_colum = jsCodeColChooser("table_calculadoras", '$("#putColsChooser_").prepend("<div id=\'putColsChooser\'>");', $primary_key).<<<JS
                $(".jqgridcolssorter_container").find(".jqgridcolssorter_del").insertAfter($(".jqgridcolssorter_container").find(".jqgridcolssorter_button")).css({'visibility':'visible', 'padding':'0.5em'});
                $(".jqgridcolssorter_label").remove();
            JS;
        }

        $token_assets = bin2hex(random_bytes(16));
        global $gIAParametros;
        $gIAParametros_js = json_encode($gIAParametros);
        echo <<<HTL
        <link rel="stylesheet" href="/vitex/css2/libs/front/bootstrap.css">
        <style>
            div.ui-jqgrid-hdiv {
                color: #495057 !important;
                background: #e9ecef !important;
                border-color: #dee2e6 !important;
            }
            table.ui-jqgrid-htable thead th {
                color: #495057 !important;
                background: #e9ecef !important;
                border-color: #dee2e6 !important;
                padding: 0 !important;
            }
            .jqgrid-rownum {
                color: #495057 !important;
                background: #e9ecef !important;
                border-color: #dee2e6 !important;
            }
            
            .ui-jqgrid-pager {
                color: #495057 !important;
                background: #e9ecef !important;
                border-color: #dee2e6 !important;
            }
            
            .ui-jqgrid-pager .ui-icon {
                color: #495057 !important;
            }
            
            .ui-jqgrid-pager .ui-state-hover {
                color: #495057 !important;
                background: #8a8a8a !important;
                border: none !important;
            }
            
            .ui-widget {
                font-family: segoe ui, Arial, sans-serif;
            }
            .ui-search-clear .clearsearchclass {
                padding-left: 0 !important;
            }
        </style>
        <!--<script src="/vitex/css2/libs/front/bootstrap.bundle.js"></script>-->
        <!--<link rel="stylesheet" href="/vitex/css2/libs/front/b-select.min.css">
        <script src="/vitex/css2/libs/front/b-select.min.js"></script>-->
        
        <!--<link href="./assets/libs/bootstrap4-toggle/bootstrap4-toggle.min.css" rel="stylesheet">
        <script src="./assets/libs/bootstrap4-toggle/bootstrap4-toggle.min.js"></script>-->
        
        <script >
        const gIAParametros = $gIAParametros_js;
        var iah = '$iah';
        $(document).ready( function() {
            $chooser_colum
            /* if (iah === '')
            {
                $('#iaGridGeneral, #iaGridFracciones').parent().css('width', '120px');
            } */
        });
        </script>
        <script src="./assets/uicostoscontenedor.js?version=$token_assets"></script>
        <script src="/vitex/js2/pulginFileAttachments.js?version=$token_assets"></script>
        HTL;
    }

    static function prepare_permisos(&$app, $modulo=''): void
    {
        $modulo = empty($modulo) ? param('modulo') : $modulo;
        // permisos default
        $app->permiso_insert = false;
        $app->permiso_update = false;
        $app->permiso_list = false;
        $app->permiso_read = false;
        $app->permiso_export = false;
        $app->permiso_app = puede_entrar_a_costos_contenedor();

        $para_precio_venta = param('precio_venta')==='si';

        if ((str_contains($modulo, "calculadora_igi") && $para_precio_venta)||str_contains($modulo, "configuracion_importacion")) {
            $app->permiso_app = puede_entrar_a_precios_de_venta();
        }

        // Solo Rony puede ver los borrados
        $en_borrados = param('borrados') === 'si';
        if ($en_borrados)
            $app->permiso_app = puede_ver_pedimentos_borrados();


        // si puede entrar al módulo definimos sus permisos
        if ($app->permiso_app) {
            $app->permiso_insert = true;
            $app->permiso_read = true;
            $app->permiso_update = true;
        }


    }

    static function get_title(): string
    { return self::$title; }

    static function prepare_toolbar(&$app, $modulo='')
    {
        global $gIAParametros, $gWebDir;
        $modulo = empty($modulo) ? param('modulo') : $modulo;

        $para_fiduciario = param('con_fiduciario', param('fiduciario'))==='si';
        $para_precio_venta = param('precio_venta')==='si';
        $para_pedimento = param('pedimento')==='si';

        $para_calculadora = false;

        $id = param('id', param('iaid'));
        $record = [];
        $en_borrados = param('borrados') === 'si';
        if (!empty($id)) {
            if ($modulo==='calculadora_igi' || $modulo==='calculadora_igi_multiple') {
                $para_calculadora = true;
                $record = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id =".strit($id));
                $app->enDB = $record;
                if (!empty($record)) {
                    if (($record['tipo_captura']??'')==='grid')
                        $modulo = 'calculadora_igi_multiple';

                    $para_precio_venta = $record['con_precio_venta'] === 'Si';
                    $para_fiduciario = $record['con_fiduciario'] === 'Si' && $record['con_precio_venta'] !== 'Si';
                    $para_pedimento = $record['para_pedimento'] === 'Si';


                    if ($para_pedimento && $record['puede_editar'] === 'No')
                        $app->permiso_update = false;

                    if ($para_pedimento && $record['puede_borrar'] === 'No')
                        $app->permiso_delete = false;
                }
            }
        }

        if ($para_fiduciario) {
            self::$title = 'Imp. de Pedimento';
        }

        if ($para_precio_venta)
            self::$title = 'Imp. Con Precio de Venta';

        if ($para_pedimento)
            self::$title = 'Pedimentos';

        if ($en_borrados)
            self::$title.=" BORRADOS";

        $titulo = "IMPUESTOS DE CONTENEDORES";
        $subtitle = match ($modulo) {
            'calculadora_igi' => 'Calculadora IGI',
            'calculadora_igi_multiple' => "Calculadora IGI Multiple",
            'pasada_por_tercero' => 'Pasada Por Tercero',
            'precio_venta' => 'Precios de Venta',
            'configuracion_importacion' => 'Configuración de Importación'
        };

        if ($para_fiduciario) {
            $para_pedimento = true;
            $subtitle = "Calculadora de Impuestos <br>Con Fiduciario";
            $subtitle = "Calculadora de Impuestos <br>De Pedimento";
        }
        if ($para_precio_venta) {
            $subtitle = "Calculadora de Impuestos <br>Con Precio de Venta";
        }

        $iah = param('iah', '');

        if ($para_pedimento) {
            $titulo = "PEDIMENTO". (empty($iah)?'S CAPTURADOS':'');

            if ($en_borrados)
                $titulo = "PEDIMENTO". (empty($iah)?'S BORRADOS':'');
            $empresa_id = param("empresa_id");
            $options_empresas = ia_SqlOptions("SELECT empresa_id, empresa FROM empresa WHERE vale = 'Active'", $empresa_id);

            $subtitle = '<form action="" method="get"><input type="hidden" name="modulo" value="calculadora_igi"><input type="hidden" name="fiduciario" value="si">Empresa: <select class="notSelectize" name="empresa_id" id="cc_empresa_id" onchange="this.form.submit();"><option value="">Todas Las Empresas</option>'.$options_empresas.'</select></form><script >
                $(function () {
                    $("#cc_empresa_id").selectize({
                        inToolbar: true,
                        itemIsHtml: true
                    });
                });
            </script>';
            if (!empty($iah)) {
                $subtitle = 'Datos del Pedimento';
                if ($iah === 'a') {
                    $subtitle = 'Captura de Pedimento';
                }
            }
            
        }
        /*$titulo_add = match ($modulo) {
            'calculadora_igi' => 'Nueva Calculadora',
            'pasada_por_tercero' => 'Nueva Pasada Por Tercero',
        };*/
        $titulo_add = 'Nuevo';

        $object_methods = match ($modulo) {
            'calculadora_igi' => 'calculadora_igi',
            'calculadora_igi_multiple' => 'calculadora_igi_multiple',
            'pasada_por_tercero' => 'pasada_tercero',
            'precio_venta' => 'precio_venta',
            'configuracion_importacion' => 'cip'
        };

        $registro_id = $app->id;

        if (!$app->permiso_app) {
            $app->toolbar['title'] = [
                'html' => "<div class='toolbarTitle' id='toolbarTitle' style='position: relative'>SIN PERMISO<br>Por favor sal de aquí!</div>",
                'TDstyle' => " width:380px;"
            ];
            return $app->toolbar;
        }

        if ($en_borrados) {
            $app->permiso_update = false;
            // $app->permiso_delete=false;

            if(!empty($app->id)) {
                $app->toolbar['search']['condition'] = "return true;";
                $id = base64_encode(base64_encode($registro_id));
                $app->toolbar['search']['html'] = "<a href='../backoffice/ajax/costos_contenedor_acciones.php?accion=activa_calculadora&id=$id' id='iaReactivaCalculadora' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Restaurar el Pedimento</div>'><i class='fa-icon fa-solid fa-trash-restore p-1 rounded bg-white text-success txt_1_5em'></i><br/>RESTAURAR</a>";
            }

        }

        $anchor_params = "<a target='_blank' rel='opener refferer' href='/$gWebDir/backoffice/iac_parametros.php?id=1&iah=e&seccion=impuestos_contenedor' title='<div class=\"alert alert-warning\">Parámetros</div>' class='tooltip_toolbar txt_1_5em' style='position: absolute; right: 10px; top: 10px'><i class='fa-icon fa-solid fa-cog'></i></a>";;
        if (!usuarioTipoRony())
            $anchor_params = '';

        $app->toolbar['title'] = [
            'html' => "<div class='toolbarTitle' id='toolbarTitle' style='position: relative'>$titulo<br>$subtitle$anchor_params</div>",
            'TDstyle' => " width:380px;"
        ];

        $app->toolbar['add']['html'] = "<a target='_blank' rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=$modulo&iah=a' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro (En otra pestaña)'><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i></a><br /><a href='../costos_contenedor/costos_contenedor.php?modulo=$modulo&iah=a' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro'>$titulo_add<br><strong style='display: none'>(F3)</strong></a>";

        if ($modulo === 'calculadora_igi' || $modulo === 'calculadora_igi_multiple') {
            $app->toolbar['add']['html']= "<a rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi&iah=a' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro Simple' style='float: left'><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i><br />$titulo_add <br><strong style='display: none'>(F3)</strong></a>"."<a rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro Multiple'><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i><br />$titulo_add <br><strong style='display: none'>(F3)</strong></a>";

            if ($para_precio_venta) {
                $app->toolbar['add']['html'] = "<div style='display: table'><a target='_blank' rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&precio_venta=si' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro Con PRECIO DE VENTA (En otra Pestaña)'><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i></a><a href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&precio_venta=si' title='Crear Nuevo Registro Con PRECIO DE VENTA' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold'><br />$titulo_add <br><strong style='display: none'>(F3)</strong></a></div>";
            }

            if ($para_fiduciario) {
                $app->toolbar['add']['html'] = "<div style='display: table'><a target='_blank' rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&con_fiduciario=si' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Crear Nuevo Registro Con FIDUCIARIO (En otra pestaña)'><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i></a><br /><a href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&con_fiduciario=si' title='Crear Nuevo Registro Con FIDUCIARIO' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold'>$titulo_add <br><strong style='display: none'>(F3)</strong></a></div>";
            }

            if ($para_pedimento) {
                $app->toolbar['add']['html'] = "<a target='_blank' rel='opener refferer' href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&pedimento=si' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold' title='Capturar Nuevo Pedimento (En otra pestaña)' style=''><i class='fa-icon fa-duotone fa-solid fa-file-circle-plus p-1 rounded txt_1_5em bg-white' style='--fa-primary-color: var(--success); --fa-secondary-color: var(--success)'></i></a><br /><a href='../costos_contenedor/costos_contenedor.php?modulo=calculadora_igi_multiple&iah=a&moneda_id=2&pedimento=si' title='Capturar Nuevo Pedimento' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold'>$titulo_add <br><strong style='display: none'>(F3)</strong></a>";
            }
        }
        $app->toolbar['add']['condition'] = "return true;";

        $label_delete = "Borrar";
        $title_delete = "Solicitar Borrar";
        $hard_delete = 'false';
        if ($en_borrados) {
            $app->toolbar['add']['condition'] = "return false;";
            $label_delete = "ELIMINAR";
            $title_delete = "ELIMINAR";
            $hard_delete = 'true';
        }

        $handle_save_action = empty($registro_id) ? 'handle_save()': "handle_update(\"$registro_id\")";
        $handle_delete_action = "handle_delete";
        if ($modulo === 'configuracion_importacion') {
            $handle_save_action = empty($registro_id) ? 'forma.save()': "forma.update(\"$registro_id\")";
            $handle_delete_action = "delete";


            if (puede_entrar_a_estados()) {
                $imgPath='/img';
                $app->toolbar = addAfterKey([
                    'estado' => [
                        'html'=>"<a href='../backoffice/estado.php?origen=template_import_productos_pv' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Cambiar<br/>Estados</strong></a>"
                    ]
                ], 'close', $app->toolbar);
            }
        }

        $app->toolbar['delete_ask']['condition'] = "return !empty(\$id) && \$this->may_delete();";
        $app->toolbar['delete_ask']['html'] = "<a href='javascript:$object_methods.$handle_delete_action(\"$registro_id\", $hard_delete)' id='iaDeleteRecord' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_notas_inconsistenticias_danger bold\">$title_delete Registro</div>'><i class='fa-icon fa-duotone fa-solid fa-trash-can p-1 rounded bg-white text-danger txt_1_5em'></i><br />$label_delete</a>";

        if (self::$add_choser) {
            $app->toolbar['extraFirstTD'] = "<td id='putColsChooser_' style='width: 150px;'></td>";
        }

        $app->toolbar['save']['html'] = "<figure id='iaGuardar' onclick='$object_methods.$handle_save_action' class='pointer bold txt_1_1em' style='display:none; width: max-content;'><i class='fa-icon fa-solid fa-floppy-disk txt_1_1em tooltip_toolbar_wohtml tooltip_toolbar p-1 bg-white rounded txt_1_5em' title='Guardar datos'></i><figcaption>Guardar <strong style='display: none'>(F2)</strong></figcaption></figure>
        <script>
            $(function () {
                $('#iaGuardar').parent().addClass('d-flex justify-content-center');
                // $('input:not(#moneda_id),select', '#content_costos_contenedor').change(function () {iaFormSetDirty(true);});
            })
        </script>";

        $app->toolbar['edit']['html'] = "<a href='../costos_contenedor/costos_contenedor.php?modulo=$modulo&iah=e&iaid=$registro_id' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa bold\">Editar Registro</div>'><i class='fa-icon fa-duotone fa-solid fa-pen-to-square p-1 rounded bg-white text-primary txt_1_5em'></i><br />Editar</a>";

        $app->toolbar['read']['condition'] = "return false;";
        $app->toolbar['read']['html'] = "<a href='../costos_contenedor/costos_contenedor.php?modulo=$modulo&iah=r&iaid=$registro_id' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa bold\">Ver Registro</div>'><i class='fa-icon fa-solid fa-eye p-1 rounded bg-white text-info txt_1_5em'></i><br />Consultar</a>";

        $href_list = "../costos_contenedor/costos_contenedor.php?modulo=$modulo";
        $label_grid = '';

        if ($para_precio_venta) {
            $href_list = "../costos_contenedor/costos_contenedor.php?modulo=$modulo&precio_venta=si";
            $label_grid = 'Precios de Venta';
        }
        if ($para_fiduciario) {
            $href_list = "../costos_contenedor/costos_contenedor.php?modulo=$modulo&fiduciario=si";
            $label_grid = 'Imp. de Fiduciario';
        }

        if ($para_pedimento) {
            $href_list = "../costos_contenedor/costos_contenedor.php?modulo=$modulo&pedimento=si";
            $label_grid = 'Pedimentos';
        }

        $app->toolbar['close']['condition'] = "return (\$h!=='');";
        if ($en_borrados) {
            //     $href_list.= '&borrados=si';
            $app->toolbar['close']['condition'] = "return true;";
        }

        $app->toolbar['close']['html'] = "<a target='_blank' href='$href_list' id='iaCloseItem' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Listado (En otra pestaña)</div>'><i class='fa-icon fa-solid fa-database p-1 rounded bg-white text-secondary txt_1_5em'></i></a><br/><a href='$href_list' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Listado</div>'>Grid $label_grid<strong style='display: none'>(F4)</strong></a>";

        /*$app->toolbar['search']['condition'] = "return true;";
        $app->toolbar['search']['html'] = "<a href='$href_list' id='iaGridGeneral' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Pedimentos (General)</div>'><i class='fa-icon fa-solid fa-database p-1 rounded bg-secondary text-white'></i><br/>Grid General</a>";*/

        if (!$en_borrados && $para_pedimento) {
            $app->toolbar['log_all']['condition'] = "return true;";
            $app->toolbar['log_all']['html']= "<a target='_blank' href='../backoffice/calculadora_igi_item.php?fiduciario=si' id='iaGridFracciones' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Fracciones de Pedimentos (En otra pestaña)</div>'><i class='fa-icon fa-duotone fa-solid fa-table-rows p-1 rounded bg-white text-secondary txt_1_5em'></i></a><br/><a href='../backoffice/calculadora_igi_item.php?fiduciario=si' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Fracciones de Pedimentos</div>' class='txt_1_1em tooltip_toolbar bold'>Grid Fracciones</a>";
        }

        if ($en_borrados && $para_pedimento) {
            $href_list.= '&borrados=si';

            $app->toolbar['log_all']['condition'] = "return (\$h!=='');";
            $app->toolbar['log_all']['html']= "<a target='_blank' href='$href_list' id='iaCloseItemBorrados' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Listado de Borrados (En otra pestaña)</div>'><i class='fa-icon fa-solid fa-database p-1 rounded bg-white text-danger txt_1_5em'></i></a><br/><a href='$href_list' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Listado de Borrados</div>'>Grid $label_grid <b class='text-danger'>Borrados</b><strong style='display: none'>(F4)</strong></a>";
        }

        return $app->toolbar;
    }

    static function prepare_ui($app, $modulo = '' ): string
    {
        $modulo = empty($modulo) ? param('modulo') : $modulo;
        if (!$app->permiso_app) {
            $error['title'] = "Sin permiso";
            $error['message'] = "No tienes permisos para entrar a este módulo<br><div style='text-align: center'><a href='../backoffice/' class='bold'>IR A INICIO</a></div>";
            include "../backoffice/view/component/errors/errors.php";
            die_Script();
        }
        self::$app = $app;
        return match ($modulo) {
            'calculadora_igi', 'calculadora_igi_multiple' => self::ui_calculadora_igi(),
            'pasada_por_tercero' => self::ui_pasada_por_tercero(),
            'precio_venta' => self::ui_precio_venta(),
            'configuracion_importacion' => self::ui_configuracion_importacion_productos(),
        };
    }

    static function ui_calculadora_igi(): string
    {
        $iah = param('iah', '');
        $id = param('id', param('iaid'));
        $modulo = param('modulo');
        // if (!empty($iah)) {
        //     return self::ui_forma_calculadora($iah, $id, $modulo);
        //     /*if ($modulo === 'calculadora_igi')
        //         return self::ui_forma_calculadora_igi(iah:$iah,id:$id);
        //
        //     if ($modulo === 'calculadora_igi_multiple')
        //         return self::ui_forma_calculadora_igi_multiple(iah:$iah,id:$id);*/
        // }
        // return self::ui_list_calculadora_igi();
        return match ($iah) {
            'a', 'r', 'e', !empty($modulo) => self::ui_forma_calculadora_igi(iah:$iah,id:$id),
            default => self::ui_list_calculadora_igi(),
        };
    }

    static function ui_list_calculadora_igi(): string
    {
        return self::renderView('jqgrid_calculadora_igi.phtml');
    }

    static function ui_forma_calculadora_igi($independiente = true, $iah = 'a', $id = ''): string
    {
        $calculadora = [];
        $moneda_id = param('moneda_id');
        $multiple = '';
        if ($iah === 'r' || $iah === 'e') {
            if (empty($id))
                return "<h3>Falta id de registro</h3>";

            $calculadora = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = ".strit($id));
            if (empty($calculadora))
                return "<h3>No existe el registro</h3>";

            $en_borrados = param('borrados') === 'si';

            if (!$en_borrados && $calculadora['activo'] !== 'Si')
                return "<h3>EL REGISTRO FUE BORRADO</h3>";


            if ($calculadora['eliminado'] === 'Si')
                return "<h3>EL REGISTRO FUE ELIMINADO</h3>";

            if ($calculadora['tipo_captura'] === 'grid')
                $multiple = '_multiple';

           /* dd_("SELECT cii.*,
                IFNULL(pg.producto, UPPER(cii.producto_general_id)) as producto,
                IF(pg.producto IS NULL AND cii.producto_general_id <> '', 'true', 'false') producto_a_mano,
                pg.umt,
                IF(pg.producto IS NOT NULL OR pg.producto <> '', IF(pg.umt = '' OR pg.umt IS NULL, '', CONCAT(pg.producto, ' (', pg.umt,')')),UPPER(cii.producto_general_id)) as producto_fiduciario
            FROM calculadora_igi_item cii left join producto_general pg on pg.producto_general_id = cii.producto_general_id WHERE calculadora_igi_id = ".strit($id). " ORDER BY orden, alta_db");*/

            $calculadora['items'] = ia_sqlArrayIndx("SELECT cii.*,
                IFNULL(pg.producto, UPPER(cii.producto_general_id)) as producto,
                IF(pg.producto IS NULL AND cii.producto_general_id <> '', 'true', 'false') producto_a_mano,
                pg.umt,
                IF(pg.producto IS NOT NULL OR pg.producto <> '', IF(pg.umt = '' OR pg.umt IS NULL, '', CONCAT(pg.producto, ' (', pg.umt,')')),UPPER(cii.producto_general_id)) as producto_fiduciario
            FROM calculadora_igi_item cii left join producto_general pg on pg.producto_general_id = cii.producto_general_id WHERE calculadora_igi_id = ".strit($id). " ORDER BY orden, alta_db");
            $moneda_id = $calculadora['moneda_id']??'1';
        }
        else {
            $modulo = param('modulo');
            if ($modulo === 'calculadora_igi_multiple')
                $multiple = '_multiple';
        }
        $file = "forma_calculadora_igi$multiple.phtml";
        return self::renderView($file, [
            'independiente' => $independiente,
            'calculadora' => $calculadora,
            'iah' => $iah,
            'id' => $id,
            'moneda_id' => $moneda_id
        ]);
    }

    static function ui_configuracion_importacion_productos(): string
    {
        $iah = param('iah', '');
        $id = param('id', param('iaid'));
        return match ($iah) {
            'a', 'r', 'e' => self::ui_forma_configuracion_importacion_productos(iah:$iah,id:$id),
            default => self::ui_list_configuracion_importacion_productos(),
            // default => self::ui_list_pasada_tercero(),
        };
    }

    static function ui_forma_configuracion_importacion_productos($iah = 'a', $id = ''): string
    {
        $record = [];
        if ($iah === 'r' || $iah === 'e') {
            if (empty($id))
                return "<h3>Falta id de registro</h3>";

            $record =  ia_singleton("SELECT * FROM template_importar_productos_pv WHERE template_importar_productos_pv_id = ".strit($id));
            if (empty($record))
                return "<h3>No existe el registro</h3>";
            if ($record['activo'] !== 'Si')
                return "<h3>EL REGISTRO FUE ELIMINADO</h3>";;
        }
        return self::renderView('forma_configuracion_importacion_productos.phtml', [
            'record' => $record,
            'iah' => $iah,
            'id' => $id
        ]);
    }

    static function ui_list_configuracion_importacion_productos(): string
    {
        return self::renderView('jqgrid_configuracion_importacion_productos.phtml');
    }

    /*static function ui_forma_calculadora_igi_multiple($iah = 'a', $id = '')
    {
        $calculadora = [];
        $moneda_id = param('moneda_id');
        if ($iah === 'r' || $iah === 'e') {
            if (empty($id))
                return "<h3>Falta id de registro</h3>";

            $id_it = strit($id);
            $calculadora = ia_singleton("SELECT * FROM calculadora_igi WHERE calculadora_igi_id = $id_it");
            if (empty($calculadora))
                return "<h3>No existe el registro</h3>";
            if ($calculadora['activo'] !== 'Si')
                return "<h3>EL REGISTRO FUE ELIMINADO</h3>";;

            $calculadora['items'] = ia_sqlArrayIndx("SELECT * FROM calculadora_igi_item WHERE calculadora_igi_id = $id_it");
            $moneda_id = $calculadora['moneda_id']??'1';
        }
        return self::renderView('forma_calculadora_igi_multiple.phtml', [
            'calculadora' => $calculadora,
            'iah' => $iah,
            'id' => $id,
            'moneda_id' => $moneda_id
        ]);
    }*/

    static function ui_pasada_por_tercero(): string
    {
        $iah = param('iah', '');
        $id = param('id', param('iaid'));
        return match ($iah) {
            'a', 'r', 'e' => self::ui_forma_pasada_tercero(iah:$iah,id:$id),
            default => self::ui_list_pasada_tercero(),
            // default => self::ui_list_pasada_tercero(),
        };
    }

    static function ui_forma_pasada_tercero($iah = 'a', $id = ''): string
    {
        $pasada_tercero = [];
        if ($iah === 'r' || $iah === 'e') {
            if (empty($id))
                return "<h3>Falta id de registro</h3>";

            $pasada_tercero = ia_singleton("SELECT * FROM pasada_tercero WHERE pasada_tercero_id = ".strit($id));
            if (empty($pasada_tercero))
                return "<h3>No existe el registro</h3>";
            if ($pasada_tercero['activo'] !== 'Si')
                return "<h3>EL REGISTRO FUE ELIMINADO</h3>";;

            $pasada_tercero['items'] = ia_sqlArrayIndx("SELECT pti.*, IFNULL(pg.producto, UPPER(pti.producto_general_id)) as producto FROM pasada_tercero_item pti left join producto_general pg on pg.producto_general_id = pti.producto_general_id  WHERE pti.pasada_tercero_id = ".strit($id));
        }
        return self::renderView('forma_pasada_tercero.phtml', [
            'pasada_tercero' => $pasada_tercero,
            'iah' => $iah,
            'id' => $id
        ]);
    }

    static function ui_list_pasada_tercero(): string
    {
        return self::renderView('jqgrid_pasada_tercero.phtml');
    }

    static function ui_precio_venta(): string
    {
        $iah = param('iah', '');
        $id = param('id', param('iaid'));
        return match ($iah) {
            'a', 'r', 'e' => self::ui_forma_precio_venta(iah:$iah,id:$id),
            default => self::ui_list_precio_venta(),
            // default => self::ui_list_pasada_tercero(),
        };
    }

    static function ui_forma_precio_venta($iah = 'a', $id = ''): string
    {
        $precio_venta = [];
        if ($iah === 'r' || $iah === 'e') {
            if (empty($id))
                return "<h3>Falta id de registro</h3>";

            $precio_venta = ia_singleton("SELECT * FROM precio_venta WHERE precio_venta_id = ".strit($id));
            if (empty($precio_venta))
                return "<h3>No existe el registro</h3>";
            if ($precio_venta['activo'] !== 'Si')
                return "<h3>EL REGISTRO FUE ELIMINADO</h3>";;

            $precio_venta['items'] = ia_sqlArrayIndx("SELECT pti.*, IFNULL(pg.producto, UPPER(pti.producto_general_id)) as producto FROM precio_venta_item pti left join producto_general pg on pg.producto_general_id = pti.producto_general_id  WHERE pti.precio_venta_id = ".strit($id));
        }
        return self::renderView('forma_precio_venta.phtml', [
            'precio_venta' => $precio_venta,
            'iah' => $iah,
            'id' => $id
        ]);
    }

    static function ui_list_precio_venta(): string
    {
        return self::renderView('jqgrid_precio_venta.phtml');
    }

    static protected function renderView($view = null, $data = []): string
    {
        $dirViews = './componentes/';
        $data['date'] = date("Y-m-d H:i:s");
        $path = $dirViews . $view ;
        $path = str_replace('\\', '/', $path);
        extract($data);
        ob_start();
        include_once $path;
        $view = str_replace('\"','"',trim(ob_get_contents()));
        ob_end_clean();
        return $view;
    }
}