const calculadora_igi = {
    place_holders: {},
    moneda_id: moneda_id_default,
    igis: {},
    init: function () {
        this.init_igis();
        this.initContollers();
    },
    init_igis: function (from_remove_all = false) {
        const self = this;
        // this.igis = {};
        this.place_holders = {};

        let containers = !from_remove_all?$('.container_igi'):$('.container_igi:not(:first)');
        containers.each(function () {
            let id = this.id;
            self.igis[id] = new igi(this);
            $.each(self.igis[id].campos, function (campo_name, campo) {
                if (!self.place_holders[id])
                    self.place_holders[id] = {};

                self.place_holders[id][campo_name] = campo.attr('placeholder')||'';
            });
        });
        console.log(this.igis);
    },
    initContollers: function () {
        const self = this;

        $('#btn_add_item').click(function () { self.add_new_item(); });
        $('#btn_remove_items').click(function () { self.remove_items(); });

        $('.tipo_moneda').click(function () {
            if (self.moneda_id == this.dataset.value)
                return;
            $('#moneda_id').prop('checked', (this.dataset.value == 2));
            self.change_moneda(this.dataset.value);
        });

        $('#moneda_id').change(function () {
            self.change_moneda(this.checked?2:1);
        });
        // $('#moneda_id').bootstrapToggle(moneda_id_default==1?'on':'off');

        this.add_printer_igis();

        if (iah !== 'r') {
            $('#contenedor').change('input', function () {
                $(this).removeClass('is-valid is-invalid border-danger');
                let valor = this.value.toUpperCase().fulltrim();
                $('.mask_contenedor').text(valor);
                /* if (this.value.length > 0) {
                    if(is_container_number(valor, true)) {
                        this.value = valor.fulltrim();
                    }
                    else {
                        $(this).addClass('is-invalid');
                    }
                } */
            });
            $('#btn_save_calculadora').click(function () {self.handle_do_save();});
            $('#btn_cancel_calculadora').click(function () {self.cancel_save();});

        }
        else {
            let inputs = $('#container_modulo_calculadora_igi input');
            inputs.attr('disabled', '').attr('readonly', '').attr('placeholder', '');
            inputs.addClass('border-0 r-o');
            inputs.attr('style', 'background-color: white !important');
            $('.input_percent.r-o, .input_data.r-o').each(function () {
                $(this).before(this.value);
                $(this).remove();
            });

            $('#btn_add_item').remove();
            $('#btn_remove_items').remove();
            $('div.actions').remove();
        }
    },

    add_printer_igis: function () {
        const self = this;

        $('#printer_snap_shot').html(exporter.toolBar('#container_modulo_calculadora_igi', {
            print: false,
            fileName: 'Costos Contenedor Calculadora IGI',
            beforePrint: _before_print,
            afterPrint: _after_print
        }));


        $.each(self.igis, function (index, igi) {
            $('#printer_'+index).html(exporter.toolBar(('#'+index), {
                fileName: 'Costos Contenedor IGI '+igi.getValue('igi_porcentaje'),
                beforePrint: _before_print,
                afterPrint: _after_print
            }));
        });

        function _before_print() {
            $('.card', '#calculadora_igi').removeClass('shadow');
            $('#calculadora_igi input, #contenedor').addClass('border-0');
            $('#calculadora_igi input').attr('placeholder', '');
            $('.printOnly').show();
        }
        function _after_print() {
            $('.card', '#calculadora_igi').addClass('shadow');
            $('.invalid-feedback.noprint').hide();
            $('.printOnly').hide();
            if (iah !== 'r') {
                $('#calculadora_igi input, #contenedor').removeClass('border-0');

                $.each(self.igis, function (index, igi) {
                    $.each(igi.campos, function (campo_name, campo) {
                        campo.attr('placeholder', (self.place_holders[index][campo_name]||''));
                    });
                });
            }
        }
    },

    add_new_item: function ()
    {
        const self = this;
        let counter =  ($('.container_igi').length??0)+1
        let calculadora_new = $($('.calculadora_inicial')[0].outerHTML);
        let id = ('container_igi_'+counter);
        calculadora_new.find('.container_igi').attr('id', id);
        $('#calculadora_igi').append(calculadora_new);

        calculadora_new.find("div.actions").removeClass('d-none');
        calculadora_new.find("div.actions .btn-remove-item").removeClass('d-none');
        calculadora_new.find('div.printer').empty().html('').attr('id', ('printer_'+id));

        self.igis[id] = new igi(calculadora_new.find('.container_igi')[0]);
        self.igis[id]._clearForm();
        self.igis[id].campos.valor_factura.focus();
        $.each(self.igis[id].campos, function (campo_name, campo) {
            if (!self.place_holders[id])
                self.place_holders[id] = {};

            self.place_holders[id][campo_name] = campo.attr('placeholder')||'';
        });
        incializaHotKeysInputs('#'+id);
        self.add_printer_igis();
        calculadora_new.find("div.actions .tooltip_toolbar").tooltip({
            appendTo: "body",
            hide: { effect: "slideUp", duration: 150 },
            track: true,
            show: {delay: 100},
            open: function (event, ui) {
                setTimeout(function () {
                    $(ui.tooltip).hide("slideUp");
                }, 10000);
            },
            classes: {'ui-tooltip': 'transparent-tooltip'},
            content: function (callback) {
                callback($(this).prop('title'));
            }
        });
    },

    remove_items: function () {
        const self = this;
        $('.container_igi:not(:first)').each(function () {
            delete self.igis[this.id];
            $(this).parent().remove();
        });
        $.each(self.igis, function (index, igi) {
            igi._clearForm();
        });
        self.init_igis(true);
        self.calcula_totales();
        // self.init_igis();
        /* $('.container_igi:not(:first)').each(function () {
            delete calculadora_igi.igis[this.id];
            $(this).remove();
        });
        setTimeout(function () {
            console.log("init igis");
            self.init_igis();
            $.each(self.igis, function (index, igi) {
                igi._clearForm();
            });
            self.init_igis();
        }, 1000); */

    },

    change_moneda: function (set_moneda) {
        const self = this;
        if (iaFormDirty) {
            uicostoscontenedor.alert({
                titulo: 'Cambiar Moneda',
                mensaje: '<br><span class="txt_1_3em"><b>Se perderá el avance</b><br>¿Quieres continuar? </span><br><br>',
                type: 'ask',
            }).then(function () {
                do_change_moneda();
            }).fail(function () {
                $('#moneda_id').prop('checked', (set_moneda==2)?false:true);
            });
        }
        else {
            do_change_moneda();
        }
        function do_change_moneda() {
            self.moneda_id = set_moneda;
            let params = getQueryParams();
            params.moneda_id = set_moneda;
            vx_asyncFunction(() => {
                window.location.href = prepareUrl(getUrlOrigin(), params);
            }, 100);
            /* self.remove_items();
            let moneda_id = $('#moneda_id').is(':checked') ? 1: 2;
            self.moneda_id = moneda_id;
            $.each(self.igis, function (index, igi) {
                self.moneda_id = moneda_id;
                igi.campos.valor_factura.attr('placeholder', moneda_id==1?'Valor en Pesos':'Valor en USD');
                $('.title_igi_porcentaje', ('#'+index)).html(igi.getValue('igi_porcentaje') + (moneda_id==1?' <b class="txt_color_PESOS">PESOS</b>':' <b class="txt_color_USD">USD</b>'));

                igi.change_moneda();

                $.each(igi.campos, function (campo_name, campo) {
                    if (!self.place_holders[index])
                        self.place_holders[index] = {};

                    self.place_holders[index][campo_name] = campo.attr('placeholder')||'';
                });
            }); */
        }

    },

    handle_save: function () {
        if (iah === 'r' || iah === 'e')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en este modo',
                type: 'danger',
            });
        // primero vamos a validar formularios
        let validacion = this.validate_forms();
        if (validacion === true) {
            // si pasa la validacion preparamos los datos para guardar;
            this.preparare_data();
            // $('#modal_save_calculadora').modal();
            this.handle_do_save();
        }
        else if (validacion.length>0) {
            $d.notify("Guardar datos", "Hay algunos datos incompletos ó invalidos", 'warning')
            validacion.some(function (error) {
                if (error.campo) {
                    if (error.campo.prop('tagName') === 'INPUT') {
                        error.campo.focus();
                        return true;
                    }
                }
                return false;
            });
        }
    },

    validate_forms: function (){
        const self = this;
        let campos_validar = ['igi', 'dta', 'iva', 'total', 'total_usd'];
        if (self.moneda_id == 1) {
            campos_validar.push('tipo_cambio');
        }
        let errors = [];
        let hay_validacion = false;

        let input_contenedor = $('#contenedor');

        /* if (input_contenedor.val() === '') {
            input_contenedor.addClass('border-danger');
            errors.push({
                campo: input_contenedor,
                'error': 'El campo no debe estar vacio'
            });
            // return (errors.length>0?errors:true);
            hay_validacion = true;
            return (errors.length>0?errors:true);
        }
        else {
            if (!is_container_number(input_contenedor.val(), true)) {
                input_contenedor.addClass('border-danger');
                errors.push({
                    campo: input_contenedor,
                    'error': 'Número de contenedor invalido!'
                });
                return (errors.length>0?errors:true);
            }
            hay_validacion = true;
        } */
        $.each(self.igis, function (key, igi) {
            const values = igi.getValues();
            $('input[data-campo]', ('#'+key)).removeClass('border-danger');
            $('#'+key).removeClass('border-danger');
            if (values.valor_factura.length === 0) {
                console.log(key);
                hay_validacion = true;
                errors.push({
                    'error': 'El formulario no tiene datos'
                });
                $('#'+key).addClass('border-danger');
                Swal.fire({
                    title: "Advertencia",
                    html: "<b>Ingresa datos para guardar</b>",
                    icon: "warning",
                    showCloseButton: true,
                    focusConfirm: true,
                    customClass: {
                        confirmButton: "btn btn-secondary",
                    },
                    buttonsStyling: false,
                    allowOutsideClick: false,
                }).then((result) => {
                    setTimeout(() => {
                        igi.campos.valor_factura.focus();
                    }, 500)
                });
                return false;
            }
            else {
                if (values.valor_factura>0) {
                    hay_validacion = true;
                    campos_validar.forEach(function (campo_name) {
                        let campo = igi.campos[campo_name];
                        campo.removeClass('border-danger');
                        if (values[campo_name].length === 0) {
                            campo.addClass('border-danger');
                            errors.push({
                                campo: campo,
                                'error': 'El campo no debe estar vacio'
                            });
                            return;
                        }
                        if (values[campo_name] <= 0) {
                            let campo = igi.campos[campo_name];
                            campo.addClass('border-danger');
                            errors.push({
                                campo: campo,
                                'error': 'El valor debe ser mayor a 0'
                            });
                            return;
                        }
                    });
                }
                else {
                    hay_validacion = true;
                    igi.campos.valor_factura.addClass('border-danger');
                    errors.push({
                        campo: igi.campos.valor_factura,
                        'error': 'El valor debe ser mayor a 0'
                    });
                    return false;
                }
            }
        });

        return hay_validacion ? (errors.length>0?errors:true): false;
    },

    preparare_data: function () {
        const self = this;
        let items = [];
        $.each(self.igis, function () {
            items.push(this.getValues());
        });
        this.data_save = {
            nombre: $('#nombre_calculadora').val(),
            contenedor: $('#contenedor').val(),
            moneda_id: self.moneda_id,
            tc_sistema: tc_sistema,
            items: items,
        };
    },

    handle_do_save: function () {
        const self = this;
        if (typeof self.data_save == 'undefined') {
            console.log("NAAAAHHHHHH!", '*** NO TIENES DATOS PARA GUARDAR ***');
            return;
        }

        self.data_save.nombre = $('#nombre_calculadora').val();

        let request = {
            url: getUrlForAjax('costos_contenedor_acciones'),
            data: {
                accion: 'save_calculadora',
                data: self.data_save
            },
        };

        jqAjax(request, function (res) {
            if (res.status) {
                $('#modal_save_calculadora').modal('hide');
                /* Swal.fire({
                    title: "",
                    icon: "success",
                    html: "<b>"+res.message+"</b>",
                    focusConfirm: true,
                    customClass: {
                        confirmButton: "btn btn-success",
                    },
                    buttonsStyling: false,
                    allowOutsideClick: false,
                }); */
                window.location.href = window.location.href.replace('iah=a','iah=e')+"&id="+res.id;
            }
        });
    },

    cancel_save: function () {
        // alert("Cancela el save");
    },

    handle_delete: function(id) {
        uicostoscontenedor.alert({
            titulo: 'Confirma Eliminar Registro',
            mensaje: '<br><span class="txt_1_3em">¿Deseas eliminar el registro? </span><br><br>',
            type: 'ask',
        }).then(function () {
            do_delete();
        });

        function do_delete() {
            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'delete_calculadora',
                    id: id
                }
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    $d.notify('OK', 'Registro eliminado', 'success');
                    setTimeout(function () {
                        window.location.href = $('#iaCloseItem').attr('href');
                    }, 2000);
                }
            });
        }
    },

    handle_update: function (id) {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en este modo',
                type: 'danger',
            });

        if (typeof id === 'undefined')
            return uicostoscontenedor.alert({
                titulo: 'Error!',
                mensaje: 'Falta ID del registro',
                type: 'danger',
            });
        const self = this;

        // primero vamos a validar formularios
        let validacion = this.validate_forms();
        console.log(validacion);
        if (validacion === true) {
            // si pasa la validacion preparamos los datos para guardar;
            this.preparare_data();
            do_update();
        }
        else if (validacion.length>0) {
            $d.notify("Guardar datos", "Hay algunos datos incompletos ó invalidos", 'warning')
            validacion.some(function (error) {
                if (error.campo.prop('tagName') === 'INPUT') {
                    error.campo.focus();
                    return true;
                }
                return false;
            });
        }

        function do_update()
        {
            if (typeof self.data_save == 'undefined') {
                console.log("NAAAAHHHHHH!", '*** NO TIENES DATOS PARA GUARDAR ***');
                return uicostoscontenedor.alert({
                    titulo: 'Error!',
                    mensaje: 'No hay datos para guardar',
                    type: 'danger',
                });
            }

            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'update_calculadora',
                    id: id,
                    data: self.data_save
                }
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    window.location.reload();
                    // window.location.href = window.location.href.replace('iah=e','iah=r');
                }
            });
        }
    },

    calcula_totales: function () {
        let total = {
            pesos: 0,
            usd: 0
        };
        $.each(this.igis, function () {
            total.pesos = stringToNumber(total.pesos)+ stringToNumber(this.getValue('total'))
            total.usd = stringToNumber(total.usd)+ stringToNumber(this.getValue('total_usd'))
        });
        $('#total_pesos').html("TOTAL PESOS: "+CommaFormatted(total.pesos)+"<br>");
        $('#total_usd').text("TOTAL USD: "+CommaFormatted(total.usd));
        $('#total_registros').text("REGISTROS: "+Object.keys(this.igis).length);
    },

    active_save: function ()
    {
        let validacion = this.validate_forms();
        iaFormSetDirty(false);
        if (validacion === true) {
            console.log('show save');
            iaFormSetDirty(true);
        }
        else {
            iaFormSetDirty(false);
        }
    }
};

function igi(_context, _10_or_15 = '10')
{
    const self = this;
    this.version_igi = _10_or_15;
    this.campos = prepareCampos();
    this.values = prepareValuesInit();
    initControllers();
    change_moneda();

    function prepareCampos()
    {
        let campos = {};
        $('[data-campo]', _context).each(function (i, campo) {
            let _campo = $(campo);
            let valanterior = normalizaQuantity(_campo.val()||_campo.text());
            _campo.data('oldvalue', valanterior).attr('data-oldvalue', valanterior);
            campos[campo.dataset.campo] = _campo;
        });
        return campos;
    }

    function prepareValuesInit()
    {
        let values = {};
        $.each(self.campos, function (campo_name, campo) {
            values[campo_name] = normalizaQuantity(campo.val() || campo.text());
        });
        return values;
    }

    function initControllers()
    {
        let inputs_igi = $('input[data-campo]:not([data-campo="tipo_cambio"])', _context);
        inputs_igi.vx_auto_numeric({es_decimal:true, decimales: 2, paste:true});
        inputs_igi.attr('autocomplete', 'off');

        $('input[data-campo="tipo_cambio"]', _context).vx_auto_numeric({es_decimal:true, decimales: 4, paste:true}).attr('autocomplete', 'off');

        $('input[data-campo]', _context).blur(function () {
            let campo_name = this.dataset.campo;
            if (self.cambioValor(campo_name)) {
                self.setVal(campo_name, this.value);
                console.log('cambioValor', campo_name);
                $(this).removeClass('border-danger');
                self.handle_change_value(campo_name);
                calculadora_igi.active_save();
                // iaFormSetDirty(true);
            }
        });
        $('input[data-campo]', _context).focusin(function () {
            vx_asyncFunction(function () {
                let old_value = normalizaQuantity(this.value);
                $(this).data('oldvalue', old_value).attr('data-oldvalue', old_value);
            }, 5, this)
        });

        $('.btn-remove-item', _context).click(function () {
            let id = _context.id;
            delete calculadora_igi.igis[id];
            $(_context).parent().remove();
            calculadora_igi.calcula_totales();
        });
        $('.btn-clear-item', _context).click(function () { self._clearForm(); });
    }

    function change_moneda () {
        self.campos.total_usd.parent().show();
        self.campos.tipo_cambio.parents('tr').show();
        if (self.campos.total_aproximado) {
            self.campos.total_aproximado.parents('tr').show();
            self.campos.total_aproximado.parents('tr').prev().show();
        }

        // self.campos.total.addClass('txt_color_PESOS').removeClass('txt_color_USD');
        // if (calculadora_igi.moneda_id == 2) {
        //     self.campos.total_usd.parent().hide();
        //     // self.campos.tipo_cambio.parents('tr').hide();
        //     self.campos.total_aproximado.parents('tr').hide();
        //     self.campos.total_aproximado.parents('tr').prev().hide();
        //     self.campos.total.addClass('txt_color_USD').removeClass('txt_color_PESOS');
        // }

        $('.title_igi_porcentaje', _context).html(self.values.igi_porcentaje + (calculadora_igi.moneda_id==1?' <b class="txt_color_PESOS">PESOS</b>':' <b class="txt_color_USD">USD</b>'));

    }

    this._clearForm = function () {
        _context.reset();
        $('[data-campo]', _context).data('oldvalue', '').attr('data-oldvalue', '');
        $('[data-campo]', _context).val('');
        $('[data-campo]', _context).text('');
        $('input[data-campo][data-default]', _context).each(function () {
            this.value = this.dataset.default;
        });
        this.values = prepareValuesInit();

        calculadora_igi.calcula_totales();
    };

    this.after_change_value = function (campo_name) {};

    this.handle_change_value = function (campo_name)
    {
        switch (campo_name) {
            case 'valor_factura':
                this.calcula_igi();
                this.calcula_dta();
                this.calcula_iva();
                this.calcula_totales();
                break;
            case 'prevalidacion':
            case 'agente_aduanal':
                if (campo_name === 'prevalidacion') {
                    this.campos.prevalidacion_pesos.addClass('border-warning');
                }
                this.calcula_totales();
                break;
            case 'tipo_cambio':
                this.calcula_prevalidacion();
                this.calcula_totales();
                /* if (calculadora_igi.moneda_id == '1')
                    this.calcula_total_usd();
                else {
                    this.calcula_total();
                } */
                break;
            case 'igi_porcentaje':
                this.handle_change_igi_porcentaje();
                break;
            case 'dta_unidad':
                this.calcula_dta();
                this.calcula_iva();
                this.calcula_totales();
                break;
            case 'prevalidacion_pesos':
                this.calcula_prevalidacion();
                this.calcula_totales();
                break;
            case 'iva_porcentaje':
                this.calcula_iva();
                this.calcula_totales();
                break;
            case 'igi':
                this.handle_change_igi();
                break;
            case 'dta':
                this.handle_change_dta();
                break;
            case 'iva':
                this.handle_change_iva();
                break;
        }

        this.after_change_value(campo_name);

    };

    this.setVal = function (campo, valor)
    {
        valor = normalizaQuantity(valor);
        this.values[campo] = valor;
        let valor_label = valor
        if (this.campos[campo]) {
            let $campo = this.campos[campo];
            let valanterior = normalizaQuantity($campo.val() || $campo.text());
            let decimales = 2;
            if (campo==='tipo_cambio')
                decimales = 4;
            if (!$campo.hasClass('input_percent')) {
                valanterior = normalizaQuantity(CommaFormatted(valanterior, decimales));

                valor_label = CommaFormatted(valor_label, decimales);
            }
            $campo.data('oldvalue', valanterior).attr('data-oldvalue', valanterior);
            $campo.val(valor_label);
            $campo.text(valor_label);
        }
    }
    this.getValue = function (campo_name) { return this.values[campo_name]||'' };
    this.getValues = function () { return this.values };

    this.cambioValor = function (campo_name) {
        let $campo = this.campos[campo_name];
        let old_value = normalizaQuantity($campo.data('oldvalue')||$campo[0].dataset.oldvalue).fulltrim();
        let new_val = normalizaQuantity($campo.val());
        if (!$campo.hasClass('input_percent'))
            new_val = CommaFormatted(new_val);

        new_val = normalizaQuantity(new_val).fulltrim();
        return old_value.fulltrim() !== new_val.fulltrim();
    };

    this.handle_change_igi_porcentaje = function ()
    {
        this.calcula_igi();
        this.calcula_iva();
        this.calcula_totales();

        let moneda = '<b class="txt_color_USD">USD</b>';
        if (calculadora_igi.moneda_id == 1)
            moneda = '<b class="txt_color_PESOS">PESOS</b>';


        $('.title_igi_porcentaje', _context).html(this.values.igi_porcentaje+" "+moneda);
    };

    this.calcula_igi = function ()
    {
        let valor = 0;
        valor = stringToNumber(this.values.valor_factura)*(stringToNumber(this.values.igi_porcentaje)/100);
        this.setVal('igi', uicostoscontenedor.roundNumber(valor));
        return this.values.igi;
    }

    this.calcula_dta = function ()
    {
        let valor = 0;
        valor = stringToNumber(this.values.valor_factura)*(stringToNumber(this.values.dta_unidad)/1000);
        this.setVal('dta', uicostoscontenedor.roundNumber(valor));
        return this.values.dta;
    };

    this.calcula_iva = function ()
    {
        let valor = 0;
        valor = (stringToNumber(this.values.valor_factura)+stringToNumber(this.values.igi)+stringToNumber(this.values.dta))*(stringToNumber(this.values.iva_porcentaje)/100);
        this.setVal('iva', uicostoscontenedor.roundNumber(valor));
        return this.values.iva;
    };

    this.calcula_totales = function()
    {
        this.calcula_total();
        this.calcula_total_usd();
        this.calcula_total_aproximado();
        calculadora_igi.calcula_totales();
    }

    this.calcula_total = function ()
    {
        let valor = 0;
        let campos_suma = ['igi', 'dta', 'iva', 'prevalidacion', 'agente_aduanal'];
        campos_suma.forEach(function (campo_name) {
            valor = valor + stringToNumber(self.values[campo_name]||0);
        });
        if (calculadora_igi.moneda_id == '2') {
            valor = valor*stringToNumber(this.values.tipo_cambio);
        }
        this.setVal('total', uicostoscontenedor.roundNumber(valor));
        return this.values.total;
    };

    this.calcula_total_usd = function ()
    {
        let valor = 0;
        let campos_suma = ['igi', 'dta', 'iva', 'prevalidacion', 'agente_aduanal'];
        campos_suma.forEach(function (campo_name) {
            valor = valor + stringToNumber(self.values[campo_name]||0);
        });
        if (calculadora_igi.moneda_id == '1') {
            valor = valor/stringToNumber(this.values.tipo_cambio);
        }

        if (this.values.tipo_cambio.length === 0) {
            this.setVal('total_usd', '');
            calculadora_igi.calcula_totales();
            return '';
        }
        // let valor = total/stringToNumber(this.values.tipo_cambio);
        this.setVal('total_usd', uicostoscontenedor.roundNumber(valor));
        calculadora_igi.calcula_totales();
        return this.values.total_usd;
    };

    this.calcula_total_aproximado = function ()
    {
        // if (calculadora_igi.moneda_id == 2)
        //     return '';

        if (tc_sistema.length === 0)
            return '';

        let total = stringToNumber(this.values.total)
        let valor = total/tc_sistema;
        this.setVal('total_aproximado', uicostoscontenedor.roundNumber(valor));
        return this.values.total_aproximado;
    };

    this.handle_change_igi = function ()
    {
        this.campos.igi_porcentaje.addClass('border-warning');
        this.calcula_iva();
        this.calcula_totales();
    };

    this.handle_change_dta = function ()
    {
        this.campos.dta_unidad.addClass('border-warning');

        this.calcula_iva();
        this.calcula_totales();
    };

    this.handle_change_iva = function ()
    {
        this.campos.iva_porcentaje.addClass('border-warning');
        this.calcula_totales();
    };

    this.calcula_prevalidacion = function ()
    {
        let valor = '';
        if (calculadora_igi.moneda_id == 2)
        {
            valor = uicostoscontenedor.roundNumber(stringToNumber(this.values.prevalidacion_pesos)/stringToNumber(this.values.tipo_cambio));
        }
        else {
            valor = stringToNumber(this.values.prevalidacion_pesos);
        }

        this.setVal('prevalidacion', valor);
        return this.values.prevalidacion;
    };
}