$vitex_globales['hot_keys_onini_load'] = false;

const cip = {
    url_to_producto: '',
    forma: {
        producto_opciones_importacion: {},
        init: function ()
        {
            console.log('___forma.'+arguments.callee.name);
            cip.url_to_producto = getUrlBase('backoffice/producto_general.php')

            if ((template.es_default||'') === 'Si') {
                $('#iaDeleteRecord').hide();
            }


            if (iah !== 'a') {
                this.prepara_productos();
            }

            this.init_grid();
            this.init_labels();

            if (iah !== 'r') {
                $('#clear_estados').click(function () {
                    confirmaLimpiaEstado();
                }).button();
            }


            if (iah === 'e')
                this.set_edit_mode();

            if (iah === 'r')
                this.set_read_mode();

            if (iah === 'a')
                this.set_create_mode();

        },
        prepara_productos: function ()
        {
            const forma = this;
            $.each(template.productos, function (producto_id, config) {
                forma.producto_opciones_importacion[producto_id] = config.opciones;
            });
        },

        init_grid: function ()
        {
            console.log('___forma.'+arguments.callee.name);
            const forma = this;
            this.prepare_colModel();
            gridhandler = $('#table_productos_china_cif');
            gridhandler.data('firstLoad',true);

            let configJqgrid = {
                regional: 'en',
                loadonce: true,
                datatype: 'local',
                data: productos,
                rowNum: 500,
                colModel: this.colModel,
                beforeProcessing: function(data, status, xhr){},
                beforeRequest: function(){
                    if (typeof $gridParams === 'undefined')
                        $gridParams = $(this).jqGrid('getGridParam');

                    let filters = JSON.parse($gridParams.postData.filters||'{}');
                    if (iah === 'r') {
                        if (!empty(filters)) {
                            $('#_table_productos_china_cifiasl_all').click();
                            // $('#_table_productos_china_cifiasl_sel').click();
                        }
                    }

                    if (!empty(filters)) {
                        let rules = filters.rules;
                        let set_rules = [];
                        rules.forEach(function (rule, i) {
                            if (rule.field === 'estado') {
                                set_rules.push({
                                    field: 'estado_potencia',
                                    op: $('td[columname="estado_potencia"] a').attr('soper'),
                                    data: rule.data
                                });
                            }
                            else
                                set_rules.push(rule);
                        });
                        filters.rules = set_rules;
                        $gridParams.postData.filters = JSON.stringify(filters);
                    }
                    /* if (typeof jqGridBeforeSearch !== "undefined" && $gridParams.datatype === 'json')
                        jqGridBeforeSearch(gridhandler); */
                },
                loadComplete: function (data){
                    $gridParams = $(this).getGridParam();
                    if(selected_row_id.length)
                        setGridSelectedRow(selected_row_id);
                    else
                        setGridSelectedRow(gridhandler.getDataIDs()[0]);

                    if (gridhandler.data('firstLoad')) {
                        gridhandler.data('firstLoad',false);
                        initAutoCompleteToolBarjqGrid();
                        bindInputEvents();
                    }
                    else {
                        forma.create_controls_check();
                    }
                    setTimeout(function () {
                        forma.set_actions_rows(data.rows);
                        inicializa_ui_tooltip('.ui-jqgrid-bdiv .grid_tooltip_', '', false, 10000, true);
                    }, 0);


                    if (iah === 'r') {
                        $('#_table_productos_china_cifiasl_sel').click();
                        $('.dropdown-item-iacsel').off('click').css('cursor', 'default').attr('title', '');
                        $('.opciones_importar .btn-opcion-importar').removeAttr('onclick').css({'cursor':'default', 'pointer-events': 'none'});
                    }
                },
                height: 'calc(72vh - 100px)',
                caption: forma.caption_para_grid_captura(),
                // gridComplete: function ()
                // {
                //     if (!gridhandler.data('firstLoad')) {
                //         forma.create_controls_check();
                //     }
                // },
            };

            initJqGrig('#table_productos_china_cif', configJqgrid);

            $('#gbox_table_productos_china_cif .ui-jqgrid-caption').css('background', '#e9ecef');
        },

        prepare_colModel: function ()
        {
            let productos_search = productos.map(function (p) {return `${p.producto}:${p.producto}`});
            productos_search = productos_search.join(";")
            this.colModel = [
                {
                    name: 'producto_general_id',
                    index: 'producto_general_id',
                    key: true,
                    search: false,
                    hidden: true
                },
                {
                    name: 'producto',
                    index: 'producto',
                    label: 'Producto',
                    search: true,
                    width: 400,
                    formatter: this.fmt.name_prod,
                    // comboBoxAutoComplete: {json_var:'g_cat_productos_cif'},
                    stype: "select",
                    searchoptions:{
                        sopt:['eq'],
                        multiple: true, size: '5',
                        value:':;'+productos_search,
                    },
                    colmenu: false,
                },
                {
                    name: "iacsel", index:"iacsel", label:"IMPORT.",
                    template:iacJqGridSelect().iacselColTemplate,
                    ctrl:true,
                    ctrlId:'#iactoolbarselect',
                    ctrlButtonset:true,
                    colmenu: false,
                    width: 100
                },
                {
                    name: 'options_import',
                    index: 'options_import',
                    label: 'Opciones',
                    align: "center",
                    hidden: false,
                    stype: "text",
                    width: 530,
                    title: true,
                    search:false
                },
                {
                    name: 'tiene_opciones',
                    index: 'tiene_opciones',
                    label: 'Tiene Opciones',
                    search: true,
                    hidden: true,
                    width: 75,
                    template: colFmt.SiNo,
                    searchoptions:{searchOperMenu: false},
                },
                {
                    name: 'esta_marcado',
                    index: 'esta_marcado',
                    label: 'Esta Marcado',
                    search: true,
                    hidden: true,
                    width: 75,
                    template: colFmt.SiNo,
                    searchoptions:{searchOperMenu: false},
                },
                {
                    name: 'unidad',
                    index: 'unidad',
                    label: 'Unidad',
                    search: true,
                    width: 70,
                    align: "center",
                    formatter: "select",
                    stype: "select",
                    editoptions: {
                        value: {'Kg':'Kg', 'mts':'mts'}, multiple: false, size: '1',
                    },
                    searchoptions:{
                        sopt:['eq'],
                        value:':;Kg:Kg;mts:mts',
                        searchOperMenu:false,
                        // multiple: true, size: 5,
                    },
                },
                {
                    name: 'para_bodega',
                    index: 'para_bodega',
                    label: 'Para Bodega',
                    search: true,
                    width: 150,
                    align: "center",
                    formatter: "select",
                    edittype: 'select',
                    stype: "select",
                    editoptions: {
                        value: {'No para Bodega':'No para Bodega', 'En Bodega':'En Bodega', 'Informativo':'Informativo'}, multiple: false, size: '1',
                    },
                    searchoptions:{
                        sopt:['eq'],
                        value:':;No para Bodega:No para Bodega;En Bodega:En Bodega;Informativo:Informativo',
                        searchOperMenu:false,
                    },
                },
                {
                    name:'estado',
                    index:'estado',
                    label: 'Estado',
                    search:true,
                    width:190,
                    formatter:_estadoFormatter,
                    unformat:estadoUnFormatter,
                    estadoData: estados,
                    stype: 'select',
                    searchoptions: {
                        sopt: ['cn'],
                        value: grid_cm_estados,
                        searchOperMenu:false,
                    }
                },
                {
                    name: 'estado_potencia',
                    index: 'estado_potencia',
                    label: 'Potencia',
                    classes: 'bold',
                    search: true,
                    hidden: true,
                    width: 65,
                    searchoptions: {
                        defaultSearch: 'estadoOr',
                        sopt: ['estadoOr', 'estadoAnd', 'estadoSoloAnd', 'estadoNotOr', 'estadoNotAnd', 'conAlgunEstado', 'sinAlgunEstado', ],
                        searchOperMenu:true,
                    }
                    // formatter: this.fmt.cost_cif
                    /* cellattr: function(id, val, rowData, colDef, colModel) {
                        return '';
                    } */
                },
                {
                    name: 'existencia',
                    index: 'existencia',
                    label: 'Existencia',
                    search: true,
                    template: colFmt.decimal,
                    width: 115,
                    cellattr: function(id, val, rowData, colDef, colModel) {
                        let clases = ['bold'];
                        let existencia = stringToNumber(val);
                        if (rowData.para_bodega === 'No para Bodega' && existencia>0)
                            clases.push("text-danger");

                        return `class="${clases.join(' ')}"`;
                    }
                },
                {
                    name: 'cost_cif',
                    index: 'cost_cif',
                    label: 'China CIF',
                    classes: 'lbl bold',
                    search: true,
                    template: colFmt.decimal,
                    width: 100,
                    formatter: this.fmt.cost_cif
                    /* cellattr: function(id, val, rowData, colDef, colModel) {
                        return '';
                    } */
                },
                {
                    name: 'wh_cif',
                    index: 'wh_cif',
                    label: 'WH CIF',
                    search: true,
                    template: colFmt.decimal,
                    width: 65,
                    formatter: this.fmt.cost_cif,
                    cellattr: function(id, val, rowData, colDef, colModel) {
                        return 'style="color:darkmagenta"';
                    },
                    hidden: true
                },
                {
                    name: 'costs_loading_capacity',
                    index: 'costs_loading_capacity',
                    label: 'COSTS Loading Capacity',
                    width: 85,
                    search: true,
                    template: colFmt.decimal,
                },
            ];
        },

        caption_para_grid_captura: function()
        {
            return `<div class="row">
                <div class="col-md-3">
                    <div class="form-group d-flex mb-0">
                        <label for="nombre" class="txt_1_3em bold">Nombre del Template: </label>
                        <input type="text" class="form-control form-control-sm text-uppercase py-0 w-50" id="nombre" name="nombre" autocomplete="off" style="font-size: 1rem" value="${template.nombre||''}">
                    </div>
                </div>
                <div class="col-md-3">
                    <fieldset class="border border-dark px-1" id="container-search-prods">
                        <legend class="w-auto border border-dark">🔍 Search</legend>
                        <select name="productos_search" id="productos_search" class="notSelectize" autocomplete="off" type="text" multiple="multiple" size="1" style="width:30em;">
                        ${productos.map(function (p) {
                            return `<option value="${p.producto_general_id}">${p.producto.toUpperCase()}</option>`
                        })}
                        </select>
                    </fieldset>
                </div>
                <div class="col-md-2">
                    <div class="form-group d-flex mb-1" style="gap: 0.5rem">
                        <button type="button" id="toggle_set_default" class="p-0 hpButtonFlag ${(template.es_default||'') === 'Si'?'hpButtonFlagPressed':''} toggle_default_${template_id}" title="Set Default" data-accion="set_template_as_default" style="border: 2px solid #808080; width: 20px"><i class="fa fa-star-of-life" style="line-height: 14px;"></i></button>
                        <label for="toggle_set_default" class="txt_1_3em mb-0">SET TEMPLATE <b>DEFAULT</b></label>
                    </div>
                    <div class="form-group d-flex mb-0" style="gap: 0.5rem">
                        <input type="checkbox" id="toggle_import_no_para_bodega" class="form-control form-control-sm" style="height: 20px !important;width: 20px !important;" ${(template.import_no_para_bodega||'') === 'Si'?'checked':''}>
                        <label for="toggle_import_no_para_bodega" class="txt_1_3em mb-0">Importar <b>NO PARA BODEGA</b></label>
                    </div>
                </div>
                <div class="col-md-2">
                    <button id="clear_estados">Limpiar Estados</button>
                </div>
            </div>`;
        },

        set_create_mode: function ()
        {
            console.log('___forma.'+arguments.callee.name);
            const forma = this;
            vx_asyncFunction(function () {
                $('#iacselall').click();
                $('#iacselall').click(function () {
                    if (this.checked) {
                        $('.dropdown-item-iacsel').addClass('active');
                        $('.opciones_importar .btn-opcion-importar').removeAttr('disabled')._show();
                    }
                    else {
                        $('.dropdown-item-iacsel').removeClass('active');
                        $('.opciones_importar .btn-opcion-importar').removeClass('active').attr('disabled', true)._hide();
                        forma.producto_opciones_importacion = {};
                    }
                });
                this.create_controls_check();
                this.create_options_header();
                this.init_controls();
            }, 0, this);
        },

        set_edit_mode: function ()
        {
            const forma = this;
            this.create_controls_check();
            this.create_options_header();
            this.init_controls();

            vx_asyncFunction(function () {
                $('#iacselall').click(function () {
                    if (this.checked) {
                        $('.dropdown-item-iacsel').addClass('active');
                        $('.opciones_importar .btn-opcion-importar').removeAttr('disabled')._show();
                    }
                    else {
                        $('.dropdown-item-iacsel').removeClass('active');
                        $('.opciones_importar .btn-opcion-importar').removeClass('active').attr('disabled', true)._hide();
                        forma.producto_opciones_importacion = {};
                    }
                });
            }, 0);
        },

        set_read_mode: function ()
        {
            this.create_controls_check();
            vx_asyncFunction(function () {
                $('#_table_productos_china_cifiasl_sel').click();
                $('#iacselall').parent().parent().remove();
                $('.dropdown-item-iacsel').off('click').css('cursor', 'default').attr('title', '');
                $('.opciones_importar .btn-opcion-importar').removeAttr('onclick').css({'cursor':'default', 'pointer-events': 'none'});
                $('#nombre').addClass('border-0 disabled readonly bg-white').attr('disabled', true).attr('readonly', true);
                $('#toggle_import_no_para_bodega').addClass('disabled readonly').attr('disabled', true).attr('readonly', true);
            }, 0);

            this.init_controls();
        },

        set_actions_rows: function (items = [])
        {
            const forma = this;
            let url_full = window.location.href;
            items.forEach(function (item) {
                let row_id = item.producto_general_id;
                var newDiv = $(`<div id="opciones_importar_${row_id}" class="opciones_importar">`);
                let css = Object.assign({'margin-top': '5px', 'margin-left': '4px'}, {});

                let opciones_para_row = forma.producto_opciones_importacion[row_id]||{};

                let active = (opciones_para_row['igi-inteligente-umt']) ?'active':'';

                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-purple p-1\'>IGI UMT INTELIGENTE</div>',
                    html: 'IGI UMT<br>INTEL.',
                    'data-type': 'igi',
                    'data-modo': 'inteligente',
                    'data-tipounidad': 'umt',
                    'data-definicion': 'igi-inteligente-umt',
                    'data-orden': '1'
                })
                    .addClass(`actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-purple grid_tooltip_ igi-inteligente-umt ${active}`)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-inteligente-umc']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-violet p-1 \'>IGI UMC INTELIGENTE</div>',
                    html: 'IGI UMC<br>INTEL.',
                    'data-type': 'igi',
                    'data-modo': 'inteligente',
                    'data-tipounidad': 'umc',
                    'data-definicion': 'igi-inteligente-umc',
                    'data-orden': '2'
                })
                    .addClass(`actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-violet grid_tooltip_ igi-inteligente-umc ${active}`)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-normal-blanco']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-success p-1\'>IGI 10 (BLANCO)</div>',
                    html: 'IGI 10<br>BLANCO',
                    'data-type': 'igi',
                    'data-modo': 'normal',
                    'data-igi': 'blanco',
                    'data-definicion': 'igi-normal-blanco',
                    'data-orden': '3'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-success grid_tooltip_ igi-normal-blanco '+active)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-normal-tenido']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-success p-1\'>IGI 15 (TEÑIDO)</div>',
                    html: 'IGI 15<br>TEÑIDO',
                    'data-type': 'igi',
                    'data-modo': 'normal',
                    'data-igi': 'tenido',
                    'data-definicion': 'igi-normal-tenido',
                    'data-orden': '4'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-success grid_tooltip_ igi-normal-tenido '+active)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['pasada_tercero']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-primary p-1 \'>PASADA TERCERO</div>',
                    html: 'TERCERO',
                    'data-type': 'pasada_tercero',
                    'data-modo': 'normal',
                    'data-definicion': 'pasada_tercero',
                    'data-orden': '5'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-pasadausd grid_tooltip_ pasada_tercero '+active)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-umt-blanco']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-orange p-1 \'>IGI UMT BLANCO</div>',
                    html: 'IGI UMT<br>BLANCO',
                    'data-type': 'igi',
                    'data-modo': 'umt',
                    'data-igi': 'blanco',
                    'data-definicion': 'igi-umt-blanco',
                    'data-orden': '6'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-orange grid_tooltip_ pasada_tercero '+active)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-umt-tenido']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-orange p-1 \'>IGI UMT TEÑIDO</div>',
                    html: 'IGI UMT<br>TEÑIDO',
                    'data-type': 'igi',
                    'data-modo': 'umt',
                    'data-igi': 'tenido',
                    'data-definicion': 'igi-umt-tenido',
                    'data-orden': '7'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-orange grid_tooltip_ pasada_tercero '+active)
                    .css(css)
                    .appendTo(newDiv);


                active = (opciones_para_row['igi-umc-blanco']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-info p-1 \'>IGI UMC BLANCO</div>',
                    html: 'IGI UMC<br>BLANCO',
                    'data-type': 'igi',
                    'data-modo': 'umc',
                    'data-igi': 'blanco',
                    'data-definicion': 'igi-umc-blanco',
                    'data-orden': '8'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-info grid_tooltip_ pasada_tercero '+active)
                    .css(css)
                    .appendTo(newDiv);

                active = (opciones_para_row['igi-umc-tenido']) ?'active':'';
                $('<button>', {
                    onclick:`cip.forma.toggle_opcion_importar('${row_id}', this);`,
                    title: '<div class=\'alert alert-info p-1 \'>IGI UMC TEÑIDO</div>',
                    html: 'IGI UMC<br>TEÑIDO',
                    'data-type': 'igi',
                    'data-modo': 'umc',
                    'data-igi': 'tenido',
                    'data-definicion': 'igi-umc-tenido',
                    'data-orden': '9'
                })
                    .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-info grid_tooltip_ pasada_tercero '+active)
                    .css(css)
                    .appendTo(newDiv);

               /*  // Eliminar registro
                anchor_action = $('<a>', {
                        href: `javascript:jqgridCalculadora.delete_calculadora('${row_id}', true)`,
                        title: '<div class=\'ui_tooltip_grid_notas_inconsistenticias_danger \'>Eliminar registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-trash-can txt_shadow_brown grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv); */

                $('tr#' + row_id).find('td[aria-describedby="table_productos_china_cif_options_import"]').html(newDiv);

                if (iah==='e') {
                    let check = $('#iacsel'+row_id)[0];
                    if (!check.checked) {
                        $('tr#' + row_id).find('.opciones_importar .btn-opcion-importar').removeClass('active').attr('disabled', true)._hide();
                        delete forma.producto_opciones_importacion[row_id];
                        $('tr#' + row_id).find('.dropdown-item-iacsel').removeClass('active');
                    }
                }
            });
        },


        create_controls_check: function ()
        {
            const forma = this;
            $('.selecting').each(function (){
                if (iah === 'e' || iah === 'r') {
                    let row_id = (this.id).replace('iacsel', '');
                    if (typeof forma.producto_opciones_importacion[row_id] !== 'undefined')
                        this.checked = true;
                }

                $(this).after(`<label for="${this.id}" class="dropdown-item dropdown-item-iacsel p-0 mx-auto ${this.checked?'active':''}" type="button" title="<div class='alert alert-info'>Agregar/Quitar producto para importar<div>" style="width: min-content; margin-top: -0.7em"></label>`);

                $(this)._hide();
            });

            $('.dropdown-item-iacsel').click(function () {
                $(this).toggleClass('active');
                let tr = $(this).closest('tr');
                let buttons = tr.find('.opciones_importar .btn-opcion-importar');
                if (!$(this).hasClass('active')) {
                    buttons.removeClass('active').attr('disabled', true)._hide();
                    delete forma.producto_opciones_importacion[tr[0].id];
                }
                else {
                    if (typeof forma.producto_opciones_importacion[tr[0].id] === 'undefined')
                        forma.producto_opciones_importacion[tr[0].id] = {};

                    buttons.removeAttr('disabled')._show();
                }
                iaFormSetDirty(true);
                forma.init_labels();
            });
            inicializa_ui_tooltip('.dropdown-item-iacsel', '', false, 10000, true);
        },

        create_options_header: function ()
        {
            let header_options = $('#gsh_table_productos_china_cif_options_import');
            let css = Object.assign({'margin-top': '5px', 'margin-left': '4px'}, {});

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-purple p-1\'>IGI UMT INTELIGENTE</div>',
                html: 'IGI UMT<br>INTEL.',
                'data-type': 'igi',
                'data-modo': 'inteligente',
                'data-tipounidad': 'umt',
                'data-definicion': 'igi-inteligente-umt',
                'data-orden': '1'
            })
                .addClass(`actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-purple grid_tooltip_ igi-inteligente-umt`)
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-violet p-1 \'>IGI UMC INTELIGENTE</div>',
                html: 'IGI UMC<br>INTEL.',
                'data-type': 'igi',
                'data-modo': 'inteligente',
                'data-tipounidad': 'umc',
                'data-definicion': 'igi-inteligente-umc',
                'data-orden': '2'
            })
                .addClass(`actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-violet grid_tooltip_ igi-inteligente-umc`)
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-success p-1\'>IGI 10 (BLANCO)</div>',
                html: 'IGI 10<br>BLANCO',
                'data-type': 'igi',
                'data-modo': 'normal',
                'data-igi': 'blanco',
                'data-definicion': 'igi-normal-blanco',
                'data-orden': '3'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-success grid_tooltip_ igi-normal-blanco ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-success p-1\'>IGI 15 (TEÑIDO)</div>',
                html: 'IGI 15<br>TEÑIDO',
                'data-type': 'igi',
                'data-modo': 'normal',
                'data-igi': 'tenido',
                'data-definicion': 'igi-normal-tenido',
                'data-orden': '4'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-success grid_tooltip_ igi-normal-tenido ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-primary p-1 \'>PASADA TERCERO</div>',
                html: 'TERCERO',
                'data-type': 'pasada_tercero',
                'data-modo': 'normal',
                'data-definicion': 'pasada_tercero',
                'data-orden': '5'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-pasadausd grid_tooltip_ pasada_tercero ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-orange p-1 \'>IGI UMT BLANCO</div>',
                html: 'IGI UMT<br>BLANCO',
                'data-type': 'igi',
                'data-modo': 'umt',
                'data-igi': 'blanco',
                'data-definicion': 'igi-umt-blanco',
                'data-orden': '6'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-orange grid_tooltip_ pasada_tercero ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-orange p-1 \'>IGI UMT TEÑIDO</div>',
                html: 'IGI UMT<br>TEÑIDO',
                'data-type': 'igi',
                'data-modo': 'umt',
                'data-igi': 'tenido',
                'data-definicion': 'igi-umt-tenido',
                'data-orden': '7'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-orange grid_tooltip_ pasada_tercero ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-info p-1 \'>IGI UMC BLANCO</div>',
                html: 'IGI UMC<br>BLANCO',
                'data-type': 'igi',
                'data-modo': 'umc',
                'data-igi': 'blanco',
                'data-definicion': 'igi-umc-blanco',
                'data-orden': '8'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-info grid_tooltip_ pasada_tercero ')
                .appendTo(header_options);

            $('<button>', {
                onclick:`cip.forma.toggleAll_opcion_importar(this);`,
                title: '<div class=\'alert alert-info p-1 \'>IGI UMC TEÑIDO</div>',
                html: 'IGI UMC<br>TEÑIDO',
                'data-type': 'igi',
                'data-modo': 'umc',
                'data-igi': 'tenido',
                'data-definicion': 'igi-umc-tenido',
                'data-orden': '9'
            })
                .addClass('actions_col btn btn-xs btn-opcion-importar px-1 btn-outline-info grid_tooltip_ pasada_tercero ')
                .appendTo(header_options);

            header_options.find('button.btn-opcion-importar').css(css);
            inicializa_ui_tooltip('#gsh_table_productos_china_cif_options_import .grid_tooltip_', '', false, 10000, true);
        },

        init_controls: function ()
        {
            const forma = this;
            $('#nombre').change(function () {
                iaFormSetDirty(true);
            });
            $('#toggle_import_no_para_bodega').change(function () {
                $gridParams.postData.filters = '';
                let checked = this.checked;
                iaFormSetDirty(true);
                $('#gs_para_bodega').val('No para Bodega');
                gridhandler[0].triggerToolbar();
                let ids = getGridVisibleIds(gridhandler);
                ids.forEach(function (id) {
                    $('#iacsel'+id)[0].checked = checked;
                    if (!checked) {
                        delete forma.producto_opciones_importacion[id];
                    }
                    else {
                        vx_asyncFunction(function () {
                            let button = $('#opciones_importar_'+id).find('button.igi-inteligente-umt');
                            button.addClass('active');
                            let data = button[0].dataset;
                            if (!forma.producto_opciones_importacion[id])
                                forma.producto_opciones_importacion[id] = {};

                            forma.producto_opciones_importacion[id][data.definicion] = data;
                        }, 0);
                    }
                });
                if (checked) {
                    $('.dropdown-item-iacsel').addClass('active');
                }
                // vx_asyncFunction(function () {
                //     $('#gs_para_bodega').val('');
                //     gridhandler[0].triggerToolbar();
                // }, 2000);

            });

            $('#toggle_set_default').click(function () {
                this.classList.toggle('hpButtonFlagPressed');
                iaFormSetDirty(true);
                $('.notifyjs-wrapper').remove();
                $(this).parent().notify('DEBE GUARDAR LOS DATOS', {position:'rigth', className:'info'});
                // cip.toggle_set_default(template_id);
            });

            $('#gsh_table_productos_china_cif_producto div').hide();
            let buscador = $("#productos_search");
            const buscar_productos = {
                _producto_changed: function () {
                    let productos_labels_search = $('option:selected', buscador).map(function (i, option) {return option.innerText}).get();
                    $("#gs_producto").val(productos_labels_search);
                    gridhandler[0].triggerToolbar();
                    buscador[0].selectize.open()
                }
            };
            buscador.off('change', buscar_productos._producto_changed).on('change', buscar_productos._producto_changed);
            buscador.selectize({
                create: buscador.data('create') === '',
                placeholder: 'Producto, en blanco todos',
                plugins: ["remove_button"],
                delimiter: ",",
                persist: false,
            });

            /* let f_select_estado = $('#gs_estado');
            f_select_estado.change(function () {
                $('#gs_estado_potencia').val(this.value);
                this.value = '';
            }); */
        },

        init_labels: function ()
        {
            const forma = this;
            let total_productos = productos.length;
            let prod_configurados = Object.keys(this.producto_opciones_importacion).length;

            $('.counter-label').remove();
            // let header_producto = $('#table_productos_china_cif_producto');
            // header_producto.append(`<div class="row"><div class="col-md-12 text-orange">Tiene ${prod_configurados} Productos configurados de ${total_productos}</div></div>`);

            let header_import = $('#table_productos_china_cif_iacsel');
            header_import.append(`<div class="row text-left counter-label">
                <div class="col-md-12 text-orange cursor_pointer label_tooltip" id="productos_check" title="<div class='aler alert-info'>VER LOS QUE TIENE PALOMITA</div>">Tiene ${prod_configurados} <b class="text-info">✓</b></div>
                <div class="col-md-12 text-orange cursor_pointer label_tooltip" id="productos_no_check" title="<div class='aler alert-info'>VER LOS QUE <b>NO</b> TIENE PALOMITA</div>">Faltan ${total_productos-prod_configurados}</div>
            </div>`);


            const vacios = Object.keys(forma.producto_opciones_importacion).filter(key =>
                Object.keys(forma.producto_opciones_importacion[key]).length === 0
            );

            if (vacios.length>0) {
                $('#table_productos_china_cif_options_import').append(`<div class="row text-left counter-label" >
                    <div class="col-md-12">
                        <div class="text-orange cursor_pointer label_tooltip width-max-content" id="productos_checked_no_options" title="<div class='aler alert-info'>VER LOS PRODUCTOS QUE TIENEN PALOMITA Y NO TIENE OPCIONES</div>">
                            ${vacios.length} Tiene <b class="text-info">✓</b> Y NO TIENE OPCIONES                        
                        </div>
                    </div>
                </div>`);
            }
            const existencias_empty = productos.filter( producto => stringToNumber(producto.existencia) === 0 );
            $('#table_productos_china_cif_existencia').append(`<div class="row text-left counter-label" >
                <div class="col-md-12">
                    <div class="text-orange cursor_pointer label_tooltip width-max-content" id="productos_no_existencia" title="<div class='aler alert-info'>VER LOS PRODUCTOS QUE NO TIENEN EXISTENCIA</div>">
                        ${existencias_empty.length} Productos<br>Sin Existencia                      
                    </div>
                </div>
            </div>`);

            const cif_empty = productos.filter( producto => stringToNumber(producto.cost_cif) === 0 );
            $('#table_productos_china_cif_cost_cif').append(`<div class="row text-left counter-label" >
                <div class="col-md-12">
                    <div class="text-orange cursor_pointer label_tooltip width-max-content" id="productos_no_cif" title="<div class='aler alert-info'>VER LOS PRODUCTOS QUE NO TIENEN CIF</div>">
                        ${cif_empty.length} Productos<br>Sin CIF                     
                    </div>
                </div>
            </div>`);

            $('#productos_check').click(function () {
                $('#productos_no_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_checked_no_options').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_existencia').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_cif').removeClass('active bg-orange text-white rounded-active');

                gridhandler[0].triggerToolbar();
                $(this).toggleClass('active bg-orange text-white rounded-active');
                if (this.classList.contains('active')) {
                    iacJqGridSelectShow('table_productos_china_cif','selected');
                }
                else {
                    iacJqGridSelectShow('table_productos_china_cif','all');
                }
            });

            $('#productos_no_check').click(function () {
                $('#productos_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_checked_no_options').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_existencia').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_cif').removeClass('active bg-orange text-white rounded-active');

                gridhandler[0].triggerToolbar();
                $(this).toggleClass('active bg-orange text-white rounded-active');
                if (this.classList.contains('active')) {
                    iacJqGridSelectShow('table_productos_china_cif','unselected');
                }
                else {
                    iacJqGridSelectShow('table_productos_china_cif','all');
                }
            });

            $('#productos_checked_no_options').click(function () {
                iacJqGridSelectShow('table_productos_china_cif','all');

                $('#productos_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_existencia').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_cif').removeClass('active bg-orange text-white rounded-active');

                $(this).toggleClass('active bg-orange text-white rounded-active');
                if (this.classList.contains('active')) {
                    $('#gs_esta_marcado').val('Si');
                    $('#gs_tiene_opciones').val('No');
                    gridhandler[0].triggerToolbar();
                    $('#gs_esta_marcado').val('');
                    $('#gs_tiene_opciones').val('');
                }
                else {
                    $('#gs_esta_marcado').val('');
                    $('#gs_tiene_opciones').val('');
                    gridhandler[0].triggerToolbar();
                }
            });

            $('#productos_no_existencia').click(function () {
                $('#productos_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_checked_no_options').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_cif').removeClass('active bg-orange text-white rounded-active');

                // vx_asyncFunction(function () {
                    $(this).toggleClass('active bg-orange text-white rounded-active');
                    if (this.classList.contains('active')) {
                        $('#gs_existencia').val('0');
                        gridhandler[0].triggerToolbar();
                        $('#gs_existencia').val('');
                    }
                    else {
                        $('#gs_existencia').val('');
                        gridhandler[0].triggerToolbar();
                    }
                // });
            });

            $('#productos_no_cif').click(function () {
                $('#productos_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_check').removeClass('active bg-orange text-white rounded-active');
                $('#productos_checked_no_options').removeClass('active bg-orange text-white rounded-active');
                $('#productos_no_existencia').removeClass('active bg-orange text-white rounded-active');


                // vx_asyncFunction(function () {
                $(this).toggleClass('active bg-orange text-white rounded-active');
                if (this.classList.contains('active')) {
                    $('#gs_cost_cif').val('0');
                    gridhandler[0].triggerToolbar();
                    $('#gs_cost_cif').val('');
                }
                else {
                    $('#gs_cost_cif').val('');
                    gridhandler[0].triggerToolbar();
                }
                // });
            });



            inicializa_ui_tooltip('.label_tooltip', '', true, 10000, true);
        },

        toggle_opcion_importar: function (producto_id, _button)
        {
            $(_button).toggleClass('active');

            if (!this.producto_opciones_importacion[producto_id])
                this.producto_opciones_importacion[producto_id] = {};

            let data = _button.dataset;
            if ($(_button).hasClass('active')) {
                this.producto_opciones_importacion[producto_id][data.definicion] = data;
            }
            else {
                delete this.producto_opciones_importacion[producto_id][data.definicion];
                let keys = Object.keys(this.producto_opciones_importacion[producto_id]);
                if (keys.length === 0) {
                    this.producto_opciones_importacion[producto_id] = {};
                }
            }

            iaFormSetDirty(true);
            this.init_labels();
        },

        toggleAll_opcion_importar: function (_button)
        {
            const self = this;
            $(_button).toggleClass('active');

            // let ids = getGridVisibleIds(gridhandler); // todos los visibles
            let ids = getGridVisibleSelectedIds(gridhandler); // todos los visibles seleccionados
            let data = _button.dataset;


            ids.forEach(function (producto_id) {

                if (!self.producto_opciones_importacion[producto_id])
                    self.producto_opciones_importacion[producto_id] = {};

                if ($(_button).hasClass('active')) {
                    self.producto_opciones_importacion[producto_id][data.definicion] = data;
                    $('#opciones_importar_'+producto_id).find('button[data-definicion="'+data.definicion+'"]').addClass('active');
                }
                else {
                    delete self.producto_opciones_importacion[producto_id][data.definicion];
                    let keys = Object.keys(self.producto_opciones_importacion[producto_id]);
                    if (keys.length === 0)
                        self.producto_opciones_importacion[producto_id] = {};
                        // delete self.producto_opciones_importacion[producto_id];

                    $('#opciones_importar_'+producto_id).find('button[data-definicion="'+data.definicion+'"]').removeClass('active');
                }
            });
            iaFormSetDirty(true);
            this.init_labels();
        },

        _get_values: function ()
        {
            let values = {};
            $.each(this.producto_opciones_importacion, function (key, value) {
                // if (!empty(value)) {
                    let tr = $('tr#'+key+' td .estadoPersonalizadoRegistro');
                    let set_value = {
                        producto_general_id: key,
                        opciones: JSON.parse(JSON.stringify(value)),
                        estado: tr.data('estado').toString(),
                        estado_potencia: tr.data('potencia').toString()
                    };
                    values[key] = set_value;
                // }
            });
            return values;
        },

        save: function ()
        {
            let data_send = {
                nombre: $('#nombre').val(),
                es_default: $('#toggle_set_default').hasClass('hpButtonFlagPressed') ? 'Si': 'No',
                import_no_para_bodega: $('#toggle_import_no_para_bodega').is(':checked')?'Si':'No',
                productos: this._get_values(),
            };
            if (empty(data_send.productos)) {
                iaFormSetDirty(false);
                return $d.notify('ALERTA!', 'No hay productos configurados', 'warning');
            }
            jqBlockUI();
            let data_compressed = uicostoscontenedor.compress_data(data_send);
            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'save_template_importar_productos_pv',
                    data: data_compressed,
                    // data: data_send
                },
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    window.location.href = window.location.href.replace('iah=a','iah=e')+"&id="+res.id;
                }
                jqUnBlockUI();
            });
        },

        update: function ()
        {
            let data_send = {
                id: template.template_importar_productos_pv_id,
                nombre: $('#nombre').val(),
                es_default: $('#toggle_set_default').hasClass('hpButtonFlagPressed') ? 'Si': 'No',
                import_no_para_bodega: $('#toggle_import_no_para_bodega').is(':checked')?'Si':'No',
                productos: this._get_values(),
            };

            if (empty(data_send.productos)) {
                iaFormSetDirty(false);
                return $d.notify('ALERTA!', 'No hay productos configurados', 'warning');
            }
            jqBlockUI();

            let data_compressed = uicostoscontenedor.compress_data(data_send);
            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'update_template_importar_productos_pv',
                    data: data_compressed,
                    // data: data_send
                },
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    window.location.reload();
                    // window.location.href = window.location.href.replace('iah=a','iah=e')+"&id="+res.id;
                }
                jqUnBlockUI();
            });
        },

        fmt: {
            cost_cif: function (cellvalue, options, rowObject) {
                return CommaFormatted(cellvalue, 2);
            },
            name_prod: function (cellvalue, options, rowObject) {
                let c = '';
                if (rowObject.para_bodega === 'No para Bodega')
                    c = `<sup class="text-danger txt_1_3em pointer grid_tooltip_" title="<div class='alert alert-danger'>Producto NO PARA BODEGA</div>"> *</sup>`;
                return `<a href="${cip.url_to_producto}?iah=e&producto_general_id=${options.rowId}" target="_blank" title="Ver producto">${cellvalue+c}</a>`
            },
        }

    },

    jqgrid: {
        colModel: [],
        init: function ()
        {
            const jqgrid = this;
            this.prepare_colModel();

            let wheres = [`activo = 'Si'`];
            globalIACWhere = giacwhere = wheres.join(" AND ");

            gridhandler = $('#table_templates');
            gridhandler.data('firstLoad', true);

            let configJqgrid = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                // loadonce: false,
                regional: 'en',
                datatype: 'local',
                data: [],
                postData: {
                    accion: 'jqgrid_read',
                    iactbl:'template_importar_productos_pv',
                    iacpk: 'template_importar_productos_pv_id',
                    iacwhere: encodeURIComponent(globalIACWhere),
                    /*  iaccols: cols.join(","),
                     iaccolse: 'iacsel,actions' */
                },
                colModel: this.colModel,
                sortname: 'es_default, alta_db',
                sortorder: "DESC",
                beforeProcessing: function(data, status, xhr){
                },
                beforeRequest: function(){
                    if (typeof jqGridBeforeSearch !== "undefined")
                        jqGridBeforeSearch(gridhandler);
                },
                loadComplete: function (data){
                    $gridParams = $(this).getGridParam();
                    if(selected_row_id.length)
                        setGridSelectedRow(selected_row_id);
                    else
                        setGridSelectedRow(gridhandler.getDataIDs()[0]);

                    if (gridhandler.data('firstLoad')) {
                        gridhandler.data('firstLoad',false);
                        initAutoCompleteToolBarjqGrid();
                        bindInputEvents();

                        vx_asyncFunction(function () {
                            gridhandler.jqGrid('setGridParam', {'datatype':'json'});
                            gridhandler.trigger('reloadGrid'); // para recargar todo el grid sin filtros
                            // gridhandler[0].triggerToolbar(); // para cuando se agrega un filtro desde el inicio
                        }, 10);
                        return false;
                    }
                    jqgrid.set_actions_rows(data.rows);
                    inicializa_ui_tooltip('.grid_tooltip_', '', false, 10000, true);
                },
                sortable:true,
                name_reporst: 'TEMPLATES',
                rowNum: 50,
                /* subGrid: true,
                subGridOptions: { selectOnExpand : true },
                subGridBeforeExpand: function (subgrid_id, row_id) {ia_beforeSubGridItemsNota(subgrid_id, row_id)},
                subGridRowExpanded: function (subgrid_id, row_id){ia_SubGridItemsNota(subgrid_id, row_id)}, */
            };
            let navConfig = {
                filterHide: true,
                filterClear: true,
            };
            initJqGrig('#table_templates', configJqgrid, navConfig);

        },

        prepare_colModel: function ()
        {
            this.colModel = [
                {
                    name: "iacsel", index:"iacsel", label:"&Sigma;",
                    template:iacJqGridSelect().iacselColTemplate,
                    ctrl:true,
                    ctrlId:'#iactoolbarselect',
                    ctrlButtonset:true,
                    colmenu: false,
                },
                {
                    name: 'actions',
                    index: 'actions',
                    label: 'Actions',
                    align: "center",
                    hidden: false,
                    stype: "text",
                    width: 90,
                    title: true,
                    search:false
                },
                {
                    name: 'template_importar_productos_pv_id',
                    index: 'template_importar_productos_pv_id',
                    key: true,
                    search: false,
                    hidden: true
                },
                {
                    name: 'nombre',
                    index: 'nombre',
                    label: 'Nombre',
                    search: true,
                    width: 200,
                    /* comboBoxAutoComplete: {'dataUrl': '../backoffice/json/producto_general.html'},
                    searchoptions:{ sopt:['eq']},
                    colmenu: false, */
                },
                {
                    name: 'es_default',
                    index: 'es_default',
                    label: 'Es DEFAULT',
                    search: true,
                    width: 75,
                    template: colFmt.SiNo,
                    searchoptions:{searchOperMenu: false},
                },
                {
                    name: 'import_no_para_bodega',
                    index: 'import_no_para_bodega',
                    label: 'Prods. "NO PARA BODEGA"',
                    search: true,
                    width: 75,
                    template: colFmt.SiNo,
                    searchoptions:{searchOperMenu: false},
                },
                {
                    name: 'productos',
                    index: 'productos',
                    label: 'Productos',
                    search: true,
                    width: 300,
                    template:colFmt.text,
                    formatter: this.fmt.iaFmtProductos,
                    /* comboBoxAutoComplete: {'dataUrl': '../backoffice/json/producto_general.html'},
                    searchoptions:{ sopt:['eq']},
                    colmenu: false, */
                },
                {
                    name: 'alta_db',
                    index: 'alta_db',
                    label: 'Alta',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                    BusquedaRapida: {
                        group: "C O N T R O L"
                    }
                },
                {
                    name: 'alta_por',
                    index: 'alta_por',
                    label: 'Alta por',
                    template:colFmt.text,
                    search: false,
                    BusquedaRapida: {
                        group: "C O N T R O L"
                    }
                },
                {
                    name: 'ultimo_cambio',
                    index: 'ultimo_cambio',
                    label: 'Ultimo Cambio',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                    BusquedaRapida: {
                        group: "C O N T R O L"
                    }
                },
                {
                    name: 'ultimo_cambio_por',
                    index: 'ultimo_cambio_por',
                    label: 'Ultimo Cambio por',
                    template:colFmt.text,
                    search: false,
                    BusquedaRapida: {
                        group: "C O N T R O L"
                    }
                },
            ];
        },

        set_actions_rows: function (items = [])
        {
            console.log('hola');
            const self = this;
            let url_full = window.location.href;
            items.forEach(function (item) {
                let row_id = item.template_importar_productos_pv_id;
                var newDiv = $('<div>');
                let css = Object.assign({'padding-top': '5px', 'padding-left': '4px'}, {});
                    /* url_full = window.location.href;
                    if (item.tipo_captura === 'grid') {
                        url_full = url_full.replace("calculadora_igi", "calculadora_igi_multiple");
                    } */

                // Ver registro
                let anchor_action = $('<a>', {
                        href: `${url_full}&id=${row_id}&iah=r`,
                        target: '_blank',
                        title: '<div class=\'ui_tooltip_grid_nota_bodega_consultar_nota \'>Ver registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-file txt_shadow_turquoise grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);

                // Editar registro
                anchor_action = $('<a>', {
                        href: `${url_full}&id=${row_id}&iah=e`,
                        target: '_blank',
                        title: '<div class=\'ui_tooltip_grid_notas_verificacion_completa \'>Editar registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col action_edit');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-pen-to-square noprint txt_shadow_blue grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);
                delete css.display;

                // set default registro
                anchor_action = $('<a>', {
                        href: `javascript:cip.toggle_set_default('${row_id}')`,
                        title: '<div class=\'alert alert-warning text-danger px-1\'>SWITCH SET TEMPLATE DEFAULT</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col action_set_default');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-star-of-life noprint grid_tooltip_ border border-secondary hpButtonFlag ${item.es_default==='Si'?'hpButtonFlagPressed':''} toggle_default_${row_id}" style="padding: 2px;"></i>`);
                anchor_action.appendTo(newDiv);
                delete css.display;

                // Borrar registro
                if (item.es_default === 'Si')
                    css.display = 'none';

                anchor_action = $('<a>', {
                        href: `javascript:cip.delete('${row_id}', true)`,
                        title: '<div class=\'ui_tooltip_grid_notas_inconsistenticias_danger \'>Borrar registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col action_delete');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-trash-can txt_shadow_brown grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);

                $('tr#' + row_id).find('td[aria-describedby="table_templates_actions"]').html(newDiv);
            });
        },

        fmt: {
            iaFmtProductos: function(cellvalue, options, rowObject)
            {
                try {
                    if(cellvalue==null || cellvalue=='null') return '';

                    let productos = JSON.parse(cellvalue);

                    let producto_ = [];
                    $.each(productos, function (key, value) {
                        producto_.push((productos_generales[key]??key));
                    })



                    // return `<div class="jqgRZ jqgRS cellGrowShrink cellGrowFull">${cellvalue}</div>`;

                    return `<details style="max-height: 180px;overflow: auto;">
                        <summary style="position: sticky; top: 10px; background: white;">${Object.keys(productos).length} Productos</summary>
                        <div style="margin-top: -65px"><ul style="margin-bottom: 0"><li>${producto_.join('<li>')}</ul></div>
                    </details>`;

                    // return '<span class="jqgRZ jqgRS grid_tooltip_" title="<div class=\'ui_tooltip_grid_notas_inconsistenticias_info\'>Falta llenar los campos: <br><li>'+Object.values(campos).join("<li>")+'</div>">'+faltan+' campos <i class="fa fa-circle-info"></i></span>';
                } catch(er) {console.log('iaFmtFaltan',er); return cellvalue;}
            }
        }
    },

    delete: function (id, desde_grid = false)
    {
        let mensaje = '<br><span class="txt_1_3em">¿Deseas eliminar el registro? </span><br><br>';

        uicostoscontenedor.alert({
            titulo: 'Confirma Eliminar Registro',
            mensaje: mensaje,
            type: 'ask',
            options_btn: {
                textButtonConfirm: 'Si, eliminar',
                textButtonCancel: 'Cancelar'
            }
        }).then(function () {
            do_delete();
        });

        function do_delete() {
            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'delete_template_importar_productos_pv',
                    id: id
                }
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    $d.notify('OK', (res.message||('Registro eliminado')), 'success');
                    if (desde_grid) {
                        gridhandler.trigger('reloadGrid');
                    }
                    else {
                        if (window.opener.gridhandler) {
                            window.opener.$d.notify('OK', (res.message||('Registro eliminado')), 'success');
                            window.opener.gridhandler.trigger('reloadGrid');
                            window.close();
                        }
                        else {
                            setTimeout(function () {
                                window.location.href = $('#iaCloseItem').attr('href');
                            }, 1500);

                        }
                    }
                }
            }, null, null,function (response) {
                if (typeof response.puede_eliminar && response.puede_eliminar===false) {
                    if (desde_grid) {
                        $('tr#'+id+" .actions_col.action_delete").hide();
                    }
                    else {
                        $('#iaDeleteRecord').hide().hide();
                    }
                }
            });
        }
    },

    toggle_set_default: function (id, desde_grid = true)
    {
        let es_default = $('.toggle_default_'+id).hasClass('hpButtonFlagPressed')?'No':'Si';
        let request = {
            url: getUrlForAjax('costos_contenedor_acciones'),
            data: {
                accion: 'set_default_template_importar_productos_pv',
                id: id,
                es_default: es_default,
            }
        };
        jqAjax(request, function (res) {
            if (res.status) {
                $d.notify('OK', (res.message||('Template set default')), 'success');
                let not = '.toggle_default_'+id;

                if (!desde_grid) {
                    if (window.opener.gridhandler) {
                        window.opener.$d.notify('OK', (res.message||('Template set default')), 'success');
                        // window.opener.gridhandler.trigger('reloadGrid');
                        window.close();
                    }
                    else {
                        setTimeout(function () {
                            window.location.href = $('#iaCloseItem').attr('href');
                        }, 1500);

                    }
                }
                else {
                    gridhandler.setRowData(id, {
                        es_default: es_default,
                    });
                    if (es_default === 'Si')
                        $('tr#'+id+" .actions_col.action_delete").hide();
                    else
                        $('tr#'+id+" .actions_col.action_delete").show();
                    $('.actions_col.action_set_default .hpButtonFlagPressed:not('+not+')').closest('tr').each(function () {
                        gridhandler.setRowData(this.id, {
                            es_default: 'No',
                        });
                        $('.actions_col.action_delete', this).show();
                    });
                }
                $('.toggle_default_'+id).toggleClass('hpButtonFlagPressed');
                $('.actions_col.action_set_default .hpButtonFlagPressed:not('+not+')').removeClass('hpButtonFlagPressed');
            }
        }, null, null,function () {
            $('#iaDeleteRecord').hide().remove();
        });

    }
};

function _preparaEstadoFormatter(colName)
{
    // console.log(arrEstadoConf, _app);
    if (_app === 'iacase') {
        _app = 'cuentat_gasto'
    }
    let onclick = "cambiaEstadoPR(this)";
    if (colName === 'asignacion' || colName === 'supervision') {
        onclick = "asignarGasto(this)";
    }
    var valorEstado="".split('000000000000'),
        rId="%13",
        colName = colName || "PEF_COLNAME",
        ht_div='<div>',
        ht_table='<table data-estado="%14" data-potencia="%15" class="estadoPersonalizadoRegistro">',
        tRow='',
        numCols= arrEstadoConf[_app].numcols,
        ed_offSet = arrEstadoConf[_app].offSet,
        /** Variables del Loop **/
        eC={}, onoff='0', tEvents='', tcStyle= '', tCell='', eCv='', ed_i = 0;
        ed_offSet = 15;
    // alert(estadoData);
    $.each(estadoData[colName], function(i){
        ed_i++;
        eC=this;
        onoff='0';
        tEvents='';
        tcStyle= 'style="width:26px !important; height:23px !important; text-align: center; padding: 0 2px 0 2px !important;';
        tCell='<td';
        //eCv=eC.valor.split('');

        if(!((ed_i-1)%numCols)) tRow += '<tr>';

        /** En el preparador siempre el 0. En vez de usar la variable onoff, ponemos la constante PEF_ONOFF
         $.each(eCv, function(j){
         if(this[0]=='1' && valorEstado[j]=='1')
         onoff='1';
         });**/

        tCell += ' title="'+ eC.descripcion + '" id="'+ ed_i + "-" + rId +'" data-pos="'+ ed_i +
            '" data-orden="'+ eC.orden +'" data-celval="%14" data-val="%' + ed_i +
            '" data-user="'+ eC.usuario_id +
            '" data-potencia="'+ eC.potencia +
            '" data-estadovalor="' + eC.valor + '" data-colname="'+ colName +'" data-rid="'+ rId +'" ';
        if(eC.click==='SI' && eC.clave.length)
        {
            // tEvents='onmouseover=\'$(this).addClass("ui-state-hover");\' onmouseout=\'$(this).removeClass("ui-state-hover")\' onclick=\'cambiaEstadoPR(this)\' ';
            tEvents=`onmouseover="$(this).addClass('ui-state-hover');" onmouseout="$(this).removeClass('ui-state-hover')" onclick="${onclick}"`;
            tcStyle += 'cursor:pointer;';
        }
        else
        {
            tcStyle += 'cursor:default;';
        }
        tCell += tEvents;

        g_valorEstadoStyle.push('background-color:#'+eC.bkgcolor+' !important;color:#'+eC.color + ';');

        if(onoff==1)
        {
            tcStyle += 'background-color:#'+eC.bkgcolor+' !important;color:#'+eC.color + ';';
        }
        else
        {
            tcStyle += '%' + (ed_i + ed_offSet);
        }
        tCell=tCell + tcStyle + '" ><strong>' + eC.clave + '</strong></td>';
        tRow += tCell;
    });
    ht_table+=tRow+'</table>';
    ht_div += ht_table+'</div>';
    return ht_div;
}

function _estadoFormatter(cellvalue, options, rowObject)
{
    var valorEstado=cellvalue.toString().split(''),
        valorEstadoStyle = [],
        rId=options.rowId,
        nuevoEstado = (typeof g_pefEstadoDef[options.colModel.index] === 'undefined') ? g_pefEstadoDef : g_pefEstadoDef[options.colModel.index];
    // nuevoEstado = g_pefEstadoDef;

    valorEstado.forEach(function(item, index){
        if(item == "1")
            valorEstadoStyle.push(g_valorEstadoStyle[index]);
        else
            valorEstadoStyle.push('background-color:#ffffff;color:#c0c0c0;');
    });

    if (_app === 'edocta' && rId.length != 32)
    {
        rId = rowObject.banco_cuenta_mov_id || rowObject[0];
    }


    valorEstado.push(rId);
    valorEstado.push(cellvalue);
    valorEstado.push(rowObject.estado_potencia);

    valorEstado = valorEstado.concat(valorEstadoStyle);
    nuevoEstado = nuevoEstado.replace(/%(\d+)/g, (_, n) => valorEstado[+n-1]);
    return nuevoEstado;
}


function cambiaEstadoPR(cellObject)
{
    let cellData=$(cellObject).data();
    if(cellData.rid.length===0)
        return;

    let estadoRegistro=cellData.celval.toString().split(''),
        estadoValor=cellData.estadovalor.toString().split(''),
        onoff=cellData.val.toString();


    let estado_potencia = 0;
    $.each(estadoValor, function(i){
        let x = this;
        if(x == '1')
        {
            if(onoff =='1')
                estadoRegistro[i]='0';
            else {
                estadoRegistro[i]='1';
            }
        }
    });
    estadoRegistro=estadoRegistro.join('');
    $(gridhandler).setRowData(cellData.rid,{estado:estadoRegistro});

    let table_estados = $('tr#'+cellData.rid+ ' .estadoPersonalizadoRegistro');
    let estados_activos = $('tbody tr td[data-val="1"]', table_estados).map(function (i, td) {
        return td.dataset.potencia;
    }).get();
    let potencia = 0;
    if (!empty(estados_activos))
        potencia = estados_activos.reduce(function(a, b) {return parseInt(a, 10) + parseInt(b, 10);});

    table_estados.attr('data-potencia', potencia).data('potencia', potencia);

    $(gridhandler).setRowData(cellData.rid,{estado_potencia:potencia});

    iaFormSetDirty(true);
}

function confirmaLimpiaEstado()
{
    let message='<br/>¿Confirmas <strong>Limpiar el Estado de todos</strong> los registros visibles en el Grid</strong>?';

    ia.confirm(message, 'Limpiar el Estado', true).then(function () {
        $('.estadoPersonalizadoRegistro').each(function(){
            $(this).data('estado','000000000000').attr('data-estado', '000000000000');
            $(this).data('potencia','0').attr('data-potencia', '0');
            $('td', this).each(function () {
                $(this).css({
                    "background-color": "#ffffff",
                    "color": "#c0c0c0"
                });
                $(this).data('celval', '000000000000').attr('000000000000');
            });
        });
        iaFormSetDirty(true);
    });
}