$vitex_globales['hot_keys_onini_load'] = false;
const pasada_tercero = {
    inputs_grid_captura: [],
    campos_captura: {},
    init_grid_captura: function () {
        console.log('___'+arguments.callee.name);
        const self = this;
        this.init_controls_captura();
        this.init_hot_keys_captura();
    },

    init_controls_captura: function () {
        console.log('___'+arguments.callee.name);
        const self = this;
        runAfterFetchingCatalogs(() => {
            let productos_generales = $vitex_globales.g_cat_producto_general;
            let buscadores_productos = $(".buscador_productos_selectpicker");
            let value_selected = '';
            buscadores_productos.each(function (index, select) {
                productos_generales = $vitex_globales.g_cat_producto_general;
                value_selected = ($(select).attr('value') || '').fulltrim();

                if (!empty(value_selected)) {
                    let productos_ids = productos_generales.map(prod => prod.producto_general_id);
                    if (!productos_ids.includes(value_selected)) {
                        productos_generales.push({
                            producto: value_selected.toUpperCase(),
                            producto_general: value_selected.toUpperCase(),
                            producto_general_id: value_selected,
                            real_data: value_selected,
                            real_value: value_selected,
                            value: value_selected.toUpperCase(),
                        });
                    }
                }
                productos_generales.forEach(items => {
                    let attr = {value: items.producto_general_id, text: items.producto_general};
                    if (value_selected.strcasecmp(items.producto_general_id) === 0)
                        attr.selected = true;
                    $(select).append($('<option>', attr));
                });
            });
            if (iah !== 'r') {
                self.init_selectpicker(buscadores_productos);
            }
        }, 'g_cat_producto_general');

        if (iah !== 'r') {
            $('#nombre_pasada_tercero').focus().keypress(function () {
                if (event.code === 'Enter') {
                    // $('#tabla_pasada_tercero tbody input:not([type="search"])').first().focus();
                    setTimeout(() => {
                        let select = $('#tabla_pasada_tercero tbody select:first');
                        select.focus();
                        let select2 = select.next();
                        select2.off('keypress').on('keypress', function (e) {
                            let event_code = e.originalEvent.code;
                            let exclude = ['Space', 'Enter', 'ArrowDown', 'ArrowUp', 'ArrowRight', 'ArrowLeft'];
                            if (!exclude.includes(event_code)) {
                                // para buscar
                                let key = e.originalEvent.key;
                                if (/^[a-zA-Z]$/.test(key)) {
                                    select.off('select2:open').on('select2:open', function () {
                                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').addClass('form-control');
                                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').val(e.originalEvent.key);
                                    });
                                    select.select2('open');
                                }
                            }
                        });
                    }, 100);
                }
            });

            let inputs_captura = $('#tabla_pasada_tercero tbody input:not([type="search"])');
            this.init_inputs_captura(inputs_captura);

            $('button[data-accion="clear_all"]').off('click').click(function () {
                self.handle_click_action_grid_captura(this.dataset.accion||'', this);
            });
            this.init_controls_actions_grid_captura();
        }

        let file_name = $("title").text()+"_Pasada Por Tercero";
        $('#printer_snap_shot').html(exporter.toolBar('#container_grid_captura', {
            fileName: file_name,
            print: false,
            pdf_table: false,
            excel_table:true,
            query_selector4pdf_table: '#tabla_pasada_tercero',
            beforePrint: function () {
                $('input', '#container_grid_captura').addClass('border-0 bg-c-transparent');
                $('button.is-selectpicker', '#container_grid_captura').each(function () {
                    $(this).parent().addClass('hide');
                    $(this).parents('td').prepend('<span class="placeholder">'+$(this).text().fulltrim()+'</span>');
                });
            },
            afterPrint: function () {
                $('input', '#container_grid_captura').removeClass('border-0 bg-c-transparent');
                $('button.is-selectpicker', '#container_grid_captura').each(function () {
                    $(this).parent().removeClass('hide');
                    $(this).parents('td').find('span.placeholder').remove();
                });
            }
        }));
        $('#printer_snap_shot .ui-icon').addClass('bg-primary text-white rounded txt_1_7em').tooltip();

        if (iah === 'e')
            this.set_edit_mode();

        if (iah === 'r')
            this.set_read_mode();
    },

    set_read_mode: function (para_export=false) {
        console.log('___pasada_tercero.set_read_mode()');
        let inputs = $('#content_costos_contenedor input');
        inputs.attr('disabled', '').attr('readonly', '').attr('placeholder', '');
        inputs.addClass('border-0 r-o bg-c-transparent');
        inputs.attr('style', 'background-color: transparent !important');
        inputs.each(function () {
            $(this).hide();
            if (para_export) {
                $(this).parents('td').prepend('<span class="value_ro">'+this.value+'</span>');
            }
            else {
                $(this).parents('td').text(this.value);
            }
        });

        $('.buscador_productos_selectpicker', '#container_grid_captura').each(function () {
            $(this).hide();
            if (para_export) {
                $(this).parents('td').prepend('<span class="value_ro">'+$(':selected', this).text()+'</span>');
            }
            else {
                $(this).parents('td').text($(':selected', this).text());
            }
        });
    },

    set_edit_mode: function (para_export = false) {
        console.log('___pasada_tercero.set_edit_mode()');
        $('#tabla_pasada_tercero tbody tr:last button[data-accion="add_row"]')._show();

        let inputs = $('#content_costos_contenedor input');
        inputs.attr('disabled', false).attr('readonly', false);
        inputs.removeClass('border-0 r-o bg-c-transparent');
        inputs.attr('style', 'background-color: white !important');
        inputs.show();
        $('#tabla_pasada_tercero tbody tr td .value_ro').remove();

        $('.buscador_productos_selectpicker', '#container_grid_captura').show();

        /* $('.buscador_productos_selectpicker', '#container_grid_captura').each(function () {
            $(this).hide();
            if (para_export) {
                $(this).parents('td').prepend('<span class="value_ro">'+$(':selected', this).text()+'</span>');
            }
            else {
                $(this).parents('td').text($(':selected', this).text());
            }
        }); */
    },

    init_selectpicker: function(selects) {
        let buscadores_productos = $(".buscador_productos_selectpicker");
        buscadores_productos.each(function () {
            if ($(this).hasClass('select2-hidden-accessible')) {
                $(this).select2('destroy');
            }
        });

        buscadores_productos.select2({
            tags: true,
            placeholder: "Seleccione Producto",
            dropdownParent: '#tabla_pasada_tercero',
            dropdownCssClass: '',
            selectionCssClass: ':all:',
            matcher: uicostoscontenedor.matchCustomSearchProductos
        })
            .addClass('is-selectpicker')
            .off('select2:select')
            .on('select2:select', function (e) {
                let button = $(this).next();
                let element = button.find('.select2-selection--single');
                element.removeClass('border-danger');
                iaFormSetDirty(true);
                let tr = $(this).parents('tr');
                tr.find('td.articulo-label').text($('option:selected', this).text());
                if (this.value.length === 0){
                    tr.attr('id', '');
                    return;
                }
                let tr_existe = $('#tabla_pasada_tercero tbody tr#'+this.value);
                if (tr_existe.length === 0) {
                    tr.attr('id', this.value);
                    vx_asyncFunction(function () {
                        tr.find('[data-campo="cantidad"]').focus();
                    }, 0, this);
                }
                else {
                    $(this).val('').trigger('change');
                    $(this).notify('El producto ya existe en la tabla', 'error');
                    tr_existe.addClass('blink_');
                    setTimeout(function () { tr_existe.removeClass('blink_') }, 2000);
                }
            })
            .on("select2:open", function (e) {
                $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').addClass('form-control');
            });

    /* .off('change').on('change', function () {
            let button = $(this).next();
            let element = button.find('.select2-selection--single');
            element.removeClass('border-danger');
            iaFormSetDirty(true);
            if (this.value.length === 0){
                $(this).parents('tr').attr('id', '');
                return;
            }
            let tr = $('#tabla_pasada_tercero tbody tr#'+this.value);
            if (tr.length === 0) {
                $(this).parents('tr').attr('id', this.value);
                console.log($(this).parents('tr').find('[data-campo="cantidad"]'));
                vx_asyncFunction(function () {
                    $(this).parents('tr').find('[data-campo="cantidad"]').focus();
                }, 0, this);
            }
            else {
                $(this).val('').trigger('change');
                $(this).notify('El producto ya existe en la tabla', 'error');
                tr.addClass('blink_');
                setTimeout(function () { tr.removeClass('blink_') }, 2000);
            }
        }) */
    },

    init_inputs_captura: function (inputs) {
        console.log(inputs);
        const self = this;
        inputs.vx_auto_numeric({es_decimal:true, decimales: 2, paste:true})

        inputs.blur(function () {
            let campo_name = this.dataset.campo;
            $(this).removeClass('is-invalid');
            if (cambioValor_(this)) {
                self.set_val(this, this.value);
                console.log('cambioValor', this);
                $(this).removeClass('border-danger');
                self.handle_change_value(campo_name, this);
                iaFormSetDirty(true);
            }
        });
        inputs.each(function () {
            let _campo = $(this);
            let valor_anterior = normalizaQuantity(_campo.val()||_campo.text());
            _campo.data('oldvalue', valor_anterior).attr('data-oldvalue', valor_anterior);
        });

        function cambioValor_(input_) {
            let $campo = $(input_);
            let old_value = normalizaQuantity($campo.data('oldvalue')||$campo[0].dataset.oldvalue).fulltrim();
            let new_val = normalizaQuantity($campo.val());
            if (!$campo.hasClass('input_percent'))
                new_val = CommaFormatted(new_val);

            new_val = normalizaQuantity(new_val).fulltrim();
            return old_value.fulltrim() !== new_val.fulltrim();
        }
    },

    init_controls_actions_grid_captura: function () {
        const self = this;
        $('#tabla_pasada_tercero tbody .col-actions button').off('click').click(function () {
            self.handle_click_action_grid_captura(this.dataset.accion||'', this);
        });
    },

    _get_inputs_grid_captura: function () {
        let selector = '#tabla_pasada_tercero tbody', np_field_prefix = '', exclude='';
        let selecto_tmp;
        if (selector === undefined) {
            selecto_tmp = $("input, select");
        }
        else {
            let first_character = selector.charAt(0);
            if (first_character!=='#' && first_character!=='.')
                selector = "#"+selector;
            let elements = ['input', 'select'];
            if(first_character === '.') {
                selecto_tmp = $(elements.join(".clase, ")+".clase");
            }
            else {
                selecto_tmp = $(elements.join(", "), selector);
            }
        }
        let filter = '[id^=gs_], [id^=iacsel], .ui-pg-input, [class^=buscador_], .ignore_hotkey, [type="checkbox"], [type="radio"], .tagify-input, .ui-pg-input, [readonly], [disabled], [type="hidden"], [style*="display:none"], [type="search"]'+(!empty(exclude)?(', '+exclude):'');
        let selector_inputs = selecto_tmp.not(filter);

        selector_inputs =  [].filter.call(selector_inputs, function(input) {
            var style = window.getComputedStyle(input);

            return (style.display !== 'none')
        });

        this.inputs_grid_captura = selector_inputs;

        return selector_inputs;
    },

    init_hot_keys_captura: function (inputs = null, index_init = null, off=false) {
        if (iah === 'r')
            return;

        console.log('___pasada_tercero.init_hot_keys_captura()');
        const self = this;
        this.inputs_grid_captura = this._get_inputs_grid_captura();
        if (inputs !== null) {
            inputs.forEach(function (input, index) {
                if (index_init === null)
                    index_init = index;
                input_add_events(input, index_init);
                if (index_init != null)
                    index_init = index_init+1;
                else
                    index_init = index;
            });
        }
        else {
            this.inputs_grid_captura.forEach(function (input, index) {
                input_add_events(input, index);
            });
        }

        function input_add_events(input_, index) {
            if (off) {
                $(input_).off('keydown');
            }
            $(input_).on('keydown', function (e) {checkCursorPosition(event, this, index);});

            if (input_.tagName === 'SELECT') {
                if(off) {
                    $(input_).off('change');
                }
                $(input_).on('change', function () {change_event(index);});
                if ($(input_).hasClass('buscador_productos_selectpicker')) {
                    setTimeout(() => {
                        input_add_events($(input_).next(), index);
                    }, 200)
                }
            }
        }
        function change_event(index)
        {
            let next_field = self.inputs_grid_captura[index+1];
            next_field.focus();
        }

        const salto = 5;

        function checkCursorPosition(event, input, index) {
            let selector_inputs = self._get_inputs_grid_captura();
            let max_inputs = selector_inputs.length;
            const cursorPosition = input.selectionStart||0;
            const inputLength = input.value?.length||0;
            if (event.key === 'ArrowUp') { // up field
                let prev_idx = index-salto;
                if (prev_idx<0)
                    prev_idx = max_inputs+prev_idx;

                let prev_field = selector_inputs[prev_idx];

                let disable = prev_field.classList.contains('readonly') || (prev_field.readOnly === true) || (prev_field.disabled === true);
                while (disable) {
                    prev_idx = prev_idx-salto;
                    if (prev_idx<0)
                        prev_idx = max_inputs+prev_idx;

                    prev_field = selector_inputs[prev_idx];
                    disable = prev_field.classList.contains('readonly') || (prev_field.readOnly === true) || (prev_field.disabled === true);
                }


                if (prev_field.tagName === 'SELECT' && $(prev_field).hasClass('is-selectpicker')) {
                    event.preventDefault();
                    let button = $(prev_field).next();
                    button.focus();
                    prev_field.focus();
                    _set_events_selecpicker(button, prev_field, event.key, prev_idx);
                    return;
                }
                prev_field.focus();
                if (input.tagName === 'SELECT') {
                    event.preventDefault();
                }
            }
            else if (event.key === 'ArrowRight' || event.key === 'Tab' || event.key === 'Enter') { // next field
                if (event.key === 'Tab') {
                    event.preventDefault();
                }

                let next_idx = index+1;
                if (next_idx>=max_inputs)
                    next_idx = 0;

                let next_field = selector_inputs[next_idx];
                let disable = next_field.classList.contains('readonly') || (next_field.readOnly === true) || (next_field.disabled === true);
                while (disable) {
                    next_idx = next_idx+1;
                    next_field = selector_inputs[next_idx];
                    disable = next_field.classList.contains('readonly') || (next_field.readOnly === true) || (next_field.disabled === true);
                }

                if (input.tagName === 'SELECT') {
                    next_field.focus();
                    event.preventDefault();
                    return;
                }

                let pasar_al_siguiente =  cursorPosition === inputLength;
                if (event.key === 'Tab' || event.key === 'Enter')
                    pasar_al_siguiente=true;

                if (pasar_al_siguiente) {
                    if ($(input).data('datepicker') && $(input).datepicker("widget").is(":visible"))
                        $(input).datepicker("hide");

                    if (next_field.tagName === 'SELECT' && $(next_field).hasClass('is-selectpicker')) {
                        // next_field.focus();
                        event.preventDefault();
                        let button = $(next_field).next();
                        button.focus();
                        next_field.focus();
                        _set_events_selecpicker(button, next_field, event.key, next_idx);
                    }
                    else {
                        next_field.focus();
                        setTimeout(function () {next_field.selectionStart = next_field.selectionEnd = 0}, 0);
                    }
                }
            }
            else if (event.key === 'ArrowDown') { // down field
                let next_idx = index+salto;
                if (next_idx>(max_inputs-1))
                    next_idx = -1*(max_inputs-next_idx);

                let next_field = selector_inputs[next_idx];

                let disable = next_field.classList.contains('readonly') || (next_field.readOnly === true) || (next_field.disabled === true);
                while (disable) {
                    next_idx = next_idx+salto;
                    if (next_idx>max_inputs)
                        next_idx = -1*(max_inputs-next_idx);

                    next_field = selector_inputs[next_idx];
                    disable = next_field.classList.contains('readonly') || (next_field.readOnly === true) || (next_field.disabled === true);
                }

                if (next_field.tagName === 'SELECT' && $(next_field).hasClass('is-selectpicker')) {
                    event.preventDefault();
                    let button = $(next_field).next();
                    button.focus();
                    next_field.focus();
                    _set_events_selecpicker(button, next_field, event.key, next_idx);
                    return;
                }
                next_field.focus();
                if (input.tagName === 'SELECT') {
                    event.preventDefault();
                }

            }
            else if (event.key === 'ArrowLeft') { // prev field
                let prev_idx = index-1;
                if (prev_idx<0)
                    prev_idx = max_inputs-1;

                let prev_field = selector_inputs[prev_idx];
                let disable = prev_field.classList.contains('readonly') || (prev_field.readOnly === true) || (prev_field.disabled === true);
                while (disable) {
                    prev_idx = prev_idx-1;
                    prev_field = selector_inputs[prev_idx];
                    disable = prev_field.classList.contains('readonly') || (prev_field.readOnly === true) || (prev_field.disabled === true);
                }

                if (input.tagName === 'SELECT') {
                    prev_field.focus();
                    event.preventDefault();
                    return;
                }
                if (cursorPosition === 0) {
                    if ($(input).data('datepicker') && $(input).datepicker("widget").is(":visible"))
                        $(input).datepicker("hide");

                    if (prev_field.tagName === 'SELECT' && $(prev_field).hasClass('is-selectpicker')) {
                        prev_field.focus();
                        let button = $(prev_field).next();
                        button.focus();
                        _set_events_selecpicker(button, prev_field, event.key, prev_idx);
                    }
                    else {
                        prev_field.focus();
                        setTimeout(function () {prev_field.selectionStart = prev_field.selectionEnd = prev_field.value.length}, 0);
                    }
                }
            }
        }

        function _set_events_selecpicker(button_, next_field_, from_code, current_index) {
            button_.off('keydown').on('keydown', function (e) {
                let event_code = e.originalEvent.code;
                console.log(e);
                if (event_code === 'Space' || event_code === 'Enter') {
                    // solo me funciono así para abrilo de manera automática
                    button_.click();
                    // $(next_field_).selectpicker('toggle');
                    return;
                }
                if (event_code === 'ArrowDown' || event_code === 'ArrowUp') {
                    e.originalEvent.stopImmediatePropagation();
                    e.originalEvent.preventDefault();
                }
                if (event_code === 'ArrowDown' || event_code === 'ArrowUp' || event_code === 'ArrowRight' || event_code === 'ArrowLeft') {
                    checkCursorPosition(e.originalEvent, this, current_index);
                    return;
                }
                // para buscar
                let key = e.originalEvent.key;
                if (/^[a-zA-Z]$/.test(key)) {
                    $(next_field_).off('select2:open').on('select2:open', function () {
                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').addClass('form-control');
                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').val(e.originalEvent.key);
                    });
                    $(next_field_).select2('open');
                }
            });
        }
    },

    handle_click_action_grid_captura: function (accion='', button = null)
    {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en modo lectura',
                type: 'danger',
            });

        console.log('___pasada_tercero.handle_click_action_grid_captura()');
        let tr_current = button !== null ? $(button).parents('tr'): null;
        switch (accion) {
            case 'remove_row':
                this.action_remove_row(button, tr_current);
                this.calcula_totales();
                break;
            case 'add_row':
                this.action_add_row(tr_current);
                this.calcula_totales();
                break;
            case 'clear_all':
                this.action_clear_grid();
                this.calcula_totales();
                break;
            default: alert('Ho hay acción definida'); break;
        }
    },

    action_remove_row: function (button= null, row) {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en modo lectura',
                type: 'danger',
            });

        console.log('___pasada_tercero.action_remove_row()');
        if ($('#tabla_pasada_tercero tbody tr').length == 1) {
            $('#tabla_pasada_tercero tbody tr:last button[data-accion="remove_row"]')._hide();
            $('#tabla_pasada_tercero tbody tr:last button[data-accion="add_row"]')._show();
            if (button !== null)
                $(button)._hide();
            return;
        }
        row.remove();
        $('#tabla_pasada_tercero tbody tr:last button[data-accion="add_row"]')._show();

        if ($('#tabla_pasada_tercero tbody tr').length == 1) {
            $('#tabla_pasada_tercero tbody tr:last button[data-accion="remove_row"]')._hide();
            $('#tabla_pasada_tercero tbody tr:last button[data-accion="add_row"]')._show();
            if (button !== null)
                $(button)._hide();
        }
        this._counter_grid_captura();

        if (iah === 'e')
            iaFormSetDirty(true);
    },

    action_add_row: function (button= null, row) {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en modo lectura',
                type: 'danger',
            });

        const self = this;
        console.log('___pasada_tercero.action_add_row()');
        let tr_last = $('#tabla_pasada_tercero tbody tr:last');
        let tr_new = $(tr_last[0].outerHTML);
        tr_new.attr('id', '');
        tr_last.after(tr_new);
        this.init_controls_actions_grid_captura();

        let select_producto = $(".buscador_productos_selectpicker", tr_new);
        select_producto.parents('td').html(select_producto[0].outerHTML);
        let select_producto_picker = $(".buscador_productos_selectpicker", tr_new);
        select_producto_picker.val('');
        select_producto_picker.removeClass('select2-hidden-accessible is-selectpicker');
        this.init_selectpicker(select_producto_picker);

        let inputs_captura = $('input:not([type="search"])', tr_new);
        inputs_captura.val('').data('oldvalue', '').attr('data-oldvalue', '');
        this.init_inputs_captura(inputs_captura);

        $('#tabla_pasada_tercero tbody td.col-actions button:not([data-accion="remove_row"])')._hide();
        $('#tabla_pasada_tercero tbody td.col-actions button[data-accion="remove_row"]').attr('title', "<div class='alert alert-danger p-1'>Eliminar Row</div>")._show();
        $('#tabla_pasada_tercero tbody tr:last button[data-accion="add_row"]').attr('title', "<div class='alert alert-success p-1'>Agregar Row</div>")._show();
        this._counter_grid_captura();
        inicializa_ui_tooltip('#tabla_pasada_tercero tbody tr:last td.col-actions button', '', false, 10000, true);

        let elements = ['input', 'select'];
        let inputs_on_tr = $(elements.join(", "), tr_new);

        let filter = '[id^=gs_], [id^=iacsel], .ui-pg-input, [class^=buscador_], .ignore_hotkey, [type="checkbox"], [type="radio"], .tagify-input, .ui-pg-input, [readonly], [disabled], [type="hidden"], [style*="display:none"], [type="search"]';
        inputs_on_tr = inputs_on_tr.not(filter);

        inputs_on_tr =  [].filter.call(inputs_on_tr, function(input) {
            let style = window.getComputedStyle(input);
            return (style.display !== 'none')
        });
        select_producto_picker.focus();

        let select2 = select_producto_picker.next();
        select2.off('keypress').on('keypress', function (e) {
            let event_code = e.originalEvent.code;
            let exclude = ['Space', 'Enter', 'ArrowDown', 'ArrowUp', 'ArrowRight', 'ArrowLeft'];
            if (!exclude.includes(event_code)) {
                // para buscar
                let key = e.originalEvent.key;
                if (/^[a-zA-Z]$/.test(key)) {
                    select_producto_picker.off('select2:open').on('select2:open', function () {
                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').addClass('form-control');
                        $('#tabla_pasada_tercero .select2-dropdown--below input.select2-search__field').val(e.originalEvent.key);
                    });
                    select_producto_picker.select2('open');
                }
            }
        });

        this.init_hot_keys_captura(inputs_on_tr, this.inputs_grid_captura.length);
        // setTimeout(() => {
        //     select_producto_picker.selectpicker('toggle');
        // }, 100);
    },

    _counter_grid_captura: function () {
        $('#tabla_pasada_tercero tbody tr').each(function (index, tr) {
            $(tr).children(':first').text(index+1);
        });
    },

    action_clear_grid: function () {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en modo lectura',
                type: 'danger',
            });

        console.log('___pasada_tercero.action_clear_grid()');
        $('#tabla_pasada_tercero tbody tr:not(:first)').remove();
        $('#tabla_pasada_tercero tbody td:last button:not([data-accion])')._hide();
        $('#tabla_pasada_tercero tbody td:last button[data-accion="add_row"]')._show();
        $('#tabla_pasada_tercero tbody tr:last [data-campo]').val('').data('oldvalue', '').attr('data-oldvalue', '');
        // $(".buscador_productos_selectpicker").selectpicker('val', '');
        return iaFormSetDirty(false);
    },

    _get_values: function (tr) {
        const self = this;
        let values = {};
        this.campos_tr_current = {};
        $('[data-campo]', tr).each( function () {
            self.campos_tr_current[this.dataset.campo] = $(this);
            values[this.dataset.campo] = normalizaQuantity(this.value);
        });
        return values;
    },

    handle_change_value: function (campo_name, _input) {
        let tr_current = $(_input).parents('tr');
        switch (campo_name) {
            case 'precio':
            case 'cantidad':
                this.calcula_total(tr_current);
                this.calcula_precio_venta(tr_current);
                this.calcula_totales();
                break;
            case 'ganancia':
            case 'pasada_usd':
                this.calcula_precio_venta(tr_current);
                this.calcula_totales();
                break;
        }
    },

    set_val: function (_input, valor) {
        let valor_label = normalizaQuantity(valor)
        // if (this.campos[campo]) {
        let $campo = $(_input);
        let valor_anterior = normalizaQuantity($campo.val() || $campo.text());
        if (!$campo.hasClass('input_percent')) {
            valor_anterior = normalizaQuantity(CommaFormatted(valor_anterior));

            valor_label = CommaFormatted(valor_label);
        }
        $campo.data('oldvalue', valor_anterior).attr('data-oldvalue', valor_anterior);
        $campo.val(valor_label);
        $campo.text(valor_label);
        // }
    },

    calcula_total: function (tr_current) {
        let values = this._get_values(tr_current);
        let valor = '';
        if (stringToNumber(values.cantidad)>0 && stringToNumber(values.precio)>0) {
            valor = roundNumber(stringToNumber(values.cantidad) * stringToNumber(values.precio));
        }
        this.set_val(this.campos_tr_current.total[0], valor);
    },

    calcula_precio_venta: function (tr_current) {
        let values = this._get_values(tr_current);
        let valor = '';
        let total = stringToNumber(values.total);
        let ganancia = stringToNumber(values.ganancia);
        let pasada_usd = stringToNumber(values.pasada_usd);
        let cantidad = stringToNumber(values.cantidad);
        if (total>0 && ganancia>0 && pasada_usd>0 && cantidad>0) {
            valor = (total+ganancia+pasada_usd)/cantidad
        }
        this.set_val(this.campos_tr_current.precio_venta[0], uicostoscontenedor.roundNumber(valor));
    },

    calcula_totales: function ()
    {
        const registros = this._get_all_values(false);
        $('th[data-total="registros"]').html(registros.length);
        var totales = {
            cantidad: 0,
            precio: 0,
            total: 0,
            ganancia: 0,
            pasada_usd: 0,
        };
        registros.forEach(function (row) {
            $.each(totales, function (key, valor) {
                totales[key] = stringToNumber(totales[key])+stringToNumber(row[key]);
                $('th[data-total="'+key+'"]').html(CommaFormatted(totales[key]));
            });
        });
    },

    _get_all_values: function (con_validacion = false) {
        const self = this;
        let values = [];
        let grid_mal = false;
        $('#tabla_pasada_tercero tbody tr').each(function (index) {
            if (con_validacion) {
                if (!self._validate_tr_current(this)) {
                    grid_mal = true;
                    return false
                }
                else {
                    let values_tr = self._get_values($(this));
                    values_tr.orden = index+1;
                    values.push(values_tr);
                }
            }
            else {
                let values_tr = self._get_values($(this));
                values_tr.orden = index+1;
                values.push(values_tr);
            }
        });

        if (grid_mal)
            return false;

        return values;
    },

    _validate_tr_current: function (_tr) {
        const self = this;
        const values_tr = this._get_values($(_tr));

        let campos_validar = {
            precio_venta: {
                msg_captura: 'No se calculo el precio de venta',
                msg_invalid: 'El precio de venta debe ser mayor que 0'
            },
            producto_general_id: {
                msg_captura: 'No se ha seleccionado Articulo',
            },
            cantidad: {
                msg_captura: 'No se capturo cantidad',
                msg_invalid: 'La cantidad debe ser mayor que 0'
            },
            precio: {
                msg_captura: 'No se capturo precio',
                msg_invalid: 'El precio debe ser mayor que 0'
            },
            total: {
                msg_captura: 'No se calculo total',
                msg_invalid: 'El total debe ser mayor que 0'
            },
            ganancia: {
                msg_captura: 'No se capturo ganancia',
                msg_invalid: 'La ganancia debe ser mayor que 0'
            },
            pasada_usd: {
                msg_captura: 'No se capturo el valor de Pasada',
                msg_invalid: 'El valor de Pasada debe ser mayor que 0'
            },
        };

        let ok_validation = true;

        if (
            (values_tr.precio_venta||'').length === 0 &&
            (values_tr.producto_general_id||'').length === 0 &&
            (values_tr.cantidad||'').length === 0 &&
            (values_tr.precio||'').length === 0 &&
            (values_tr.total||'').length === 0 &&
            (values_tr.ganancia||'').length === 0 &&
            (values_tr.pasada_usd||'').length === 0
        ) {
            $.notify('DATOS INCOMPLETOS', 'warning');
            $(_tr).addClass('blink_');
            setTimeout(function () { $(_tr).removeClass('blink_') }, 3000);
            ok_validation = false;
            return false;
        }


        $.each(campos_validar, function (campo_name) {
            let $campo = self.campos_tr_current[campo_name];
            if (campo_name === 'producto_general_id') {
                if ((values_tr.producto_general_id||'').length === 0) {
                    let button = $campo.next();
                    let element = button.find('.select2-selection--single');
                    element.notify(this.msg_captura, {className: 'error', autoHideDelay: 3500}).addClass('border-danger parpadea').focus();
                    setTimeout(function () { element.removeClass('parpadea') }, 3000);
                    ok_validation = false;
                    return false;
                }
                return;
            }

            if ((values_tr[campo_name]||'').length === 0) {
                $campo.notify(this.msg_captura, {className: 'error', autoHideDelay: 3500}).addClass('is-invalid parpadea').focus();
                ok_validation = false;
                setTimeout(function () { $campo.removeClass('parpadea') }, 3000);
                return false;
            }
            if (values_tr[campo_name] == 0) {
                $campo.notify(this.msg_invalid, {className: 'error', autoHideDelay: 3500}).addClass('is-invalid parpadea').focus();
                ok_validation = false;
                setTimeout(function () { $campo.removeClass('parpadea') }, 3000);
                return false;
            }
        });
        return ok_validation;
    },

    _validate_grid_captura: function () {
        return this._get_all_values(true);
    },

    handle_save: function () {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en modo lectura',
                type: 'danger',
            });

        console.log('___pasada_tercero.handle_save()');
        const self = this;
        const nombre_pasada = $('#nombre_pasada_tercero').val();
        if (nombre_pasada.length === 0) {
            $('#nombre_pasada_tercero').addClass('is-invalid').focus();
            return iaFormSetDirty(false);
        }
        if (!this._validate_grid_captura())
            return iaFormSetDirty(false);

        jqBlockUI();
        const values = this._get_all_values();
        console.log(values);
        let request = {
            url: getUrlForAjax('costos_contenedor_acciones'),
            data: {
                accion: 'save_pasada_tercero',
                nombre: nombre_pasada,
                items: values
            },
        };
        jqAjax(request, function (res) {
            if (res.status) {
                window.location.href = window.location.href.replace('iah=a','iah=r')+"&id="+res.id;
            }
            jqUnBlockUI();
        });
    },

    handle_delete: function(id, from_jqgrid = false) {
        uicostoscontenedor.alert({
            titulo: 'Confirma Eliminar Registro',
            mensaje: '<br><span class="txt_1_3em">¿Deseas eliminar el registro? </span><br><br>',
            type: 'ask',
        }).then(function () {
            do_delete();
        });

        function do_delete() {
            let request = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                data: {
                    accion: 'delete_pasada_tercero',
                    id: id
                }
            };
            jqAjax(request, function (res) {
                if (res.status) {
                    if (!from_jqgrid) {
                        $d.notify('OK', 'Registro eliminado', 'success');
                        setTimeout(function () {
                            window.location.href = $('#iaCloseItem').attr('href');
                        }, 2500);
                        return;
                    }
                    gridhandler.trigger('reloadGrid');
                }
            });
        }
    },

    handle_update: function (id) {
        if (iah === 'r')
            return uicostoscontenedor.alert({
                titulo: 'Alerta!',
                mensaje: 'No se puede realizar esta acción en este modo',
                type: 'danger',
            });

        if (typeof id === 'undefined')
            return uicostoscontenedor.alert({
                titulo: 'Error!',
                mensaje: 'Falta ID del registro',
                type: 'danger',
            });

        const self = this;
        const nombre_pasada = $('#nombre_pasada_tercero').val();
        if (nombre_pasada.length === 0) {
            $('#nombre_pasada_tercero').addClass('is-invalid').focus();
            return iaFormSetDirty(false);
        }
        if (!this._validate_grid_captura())
            return iaFormSetDirty(false);

        const values = this._get_all_values();
        console.log(values);
        let request = {
            url: getUrlForAjax('costos_contenedor_acciones'),
            data: {
                accion: 'update_pasada_tercero',
                id: id,
                nombre: nombre_pasada,
                items: values
            },
        };
        jqAjax(request, function (res) {
            if (res.status) {
                window.location.href = window.location.href.replace('iah=e','iah=r');
            }
        });
    },

    jqgrid: {
        colModel: [],
        init: function () {
            const self = this;
            this.prepare_colModel();
            let cols = this.colModel.map(function (col) { return col.index})
            delete cols[0];
            cols = cols.filter(function (value) { return value!==''});
            cols[0] = "'' as Actions";
            gridhandler = $('#table_pasada_tercero');
            gridhandler.data('firstLoad',true);
            let configJqgrid = {
                url: getUrlForAjax('costos_contenedor_acciones'),
                // loadonce: false,
                regional: 'en',
                datatype: 'local',
                data: [],
                postData: {
                    accion: 'jqgrid_read',
                    iactbl:'pasada_tercero',
                    iacpk: 'pasada_tercero_id',
                    iacwhere: "activo = 'Si'",
                    /*  iaccols: cols.join(","),
                     iaccolse: 'iacsel,actions' */
                },
                colModel: this.colModel,
                sortname:"alta_db",
                sortorder: "DESC",
                rowattr: function(rd, rowData) {
                    // if(rd.existencia_rollos < 0 || rd.existencia_quantity < 0 || rd.quantity_bodega < 0)
                    //     return {"style":"color:red"};
                },
                beforeProcessing: function(data, status, xhr){
                },
                beforeRequest: function(){
                    if (typeof jqGridBeforeSearch !== "undefined")
                        jqGridBeforeSearch(gridhandler);
                },
                loadComplete: function (data){
                    $gridParams = $(this).getGridParam();
                    if (gridhandler.data('firstLoad')) {
                        gridhandler.data('firstLoad',false);
                        initAutoCompleteToolBarjqGrid();

                        vx_asyncFunction(function () {
                            gridhandler.jqGrid('setGridParam', {'datatype':'json'});
                            gridhandler.trigger('reloadGrid'); // para recargar toto el grid sin filtros
                            // gridhandler[0].triggerToolbar(); // para cuando se agrega un filtro desde el inicio
                        }, 10);
                        return false;
                    }
                    self.set_actions_rows(data.rows);
                    inicializa_ui_tooltip('.grid_tooltip_', '', false, 10000, true);
                },
                sortable:true,
                name_reporst: 'Pasada Terceros',
                rowNum: 50
            };
            let navConfig = {
                filterHide: true,
                filterClear: true,
            };
            initJqGrig('#table_pasada_tercero', configJqgrid, navConfig);
        },

        prepare_colModel: function ()
        {
            this.colModel = [
                {
                    name: "iacsel", index:"iacsel", label:"&Sigma;",
                    template:iacJqGridSelect().iacselColTemplate,
                    ctrl:true,
                    ctrlId:'#iactoolbarselect',
                    ctrlButtonset:true,
                    // sumCols: {total_10: {f:'sum'}},
                    colmenu: false
                },
                {
                    name: 'actions',
                    index: 'actions',
                    label: 'Actions',
                    align: "center",
                    hidden: false,
                    stype: "text",
                    width: 110,
                    title: true,
                    search:false
                },
                {
                    name: 'pasada_tercero_id',
                    index: 'pasada_tercero_id',
                    key: true,
                    search: false,
                    hidden: true
                },
                {
                    name: 'nombre',
                    index: 'nombre',
                    label: 'Nombre',
                    search: true,
                },
                {
                    name: 'registros',
                    index: 'registros',
                    label: 'Registros',
                    search: false,
                    template:colFmt.entero,
                },
                {
                    name: 'cantidad',
                    index: 'cantidad',
                    label: 'Cantidad',
                    search: false,
                    template:colFmt.decimal,
                },
                {
                    name: 'precio',
                    index: 'precio',
                    label: 'Precio',
                    search: false,
                    template:colFmt.decimal,
                },
                {
                    name: 'total',
                    index: 'total',
                    label: 'Total',
                    classes: 'text-danger bold',
                    search: false,
                    template:colFmt.decimal,
                },
                {
                    name: 'ganancia',
                    index: 'ganancia',
                    label: 'Ganancia',
                    classes: 'txt_USD bold',
                    search: false,
                    template:colFmt.decimal,
                },
                {
                    name: 'pasada_usd',
                    index: 'pasada_usd',
                    label: 'Pasada Usd',
                    classes: 'txt_USD bold',
                    search: false,
                    template:colFmt.decimal,
                },
                {
                    name: 'alta_db',
                    index: 'alta_db',
                    label: 'Alta',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                },
                {
                    name: 'alta_por',
                    index: 'alta_por',
                    label: 'Alta por',
                    template:colFmt.text,
                    search: false,
                },
                {
                    name: 'ultimo_cambio',
                    index: 'ultimo_cambio',
                    label: 'Ultimo Cambio',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                },
                {
                    name: 'ultimo_cambio_por',
                    index: 'ultimo_cambio_por',
                    label: 'Ultimo Cambio por',
                    template:colFmt.text,
                    search: false,
                },
            ];
        },

        set_actions_rows: function (items = [])
        {
            let url_full = window.location.href;
            items.forEach(function (item) {
                let row_id = item.pasada_tercero_id;
                var newDiv = $('<div>');

                let css = Object.assign({'padding-top': '5px', 'padding-left': '4px'}, {});
                // Ver registro
                let anchor_action = $('<a>', {
                        href: `${url_full}&id=${row_id}&iah=r`,
                        target: '_blank',
                        title: '<div class=\'ui_tooltip_grid_nota_bodega_consultar_nota \'>Ver registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-file txt_shadow_turquoise grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);

                // Editar registro
                anchor_action = $('<a>', {
                        href: `${url_full}&id=${row_id}&iah=e`,
                        target: '_blank',
                        title: '<div class=\'ui_tooltip_grid_notas_verificacion_completa \'>Editar registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-pen-to-square noprint txt_shadow_blue grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);

                // Eliminar registro
                anchor_action = $('<a>', {
                        href: `javascript:pasada_tercero.handle_delete('${row_id}', true)`,
                        title: '<div class=\'ui_tooltip_grid_notas_inconsistenticias_danger \'>Eliminar registro</div>',
                        rel: 'opener referrer',
                    }
                ).addClass('actions_col');
                anchor_action.css(css);
                anchor_action.append(`<i class="fa-icon fa-duotone fa-trash-can txt_shadow_brown grid_tooltip_ txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv);

                $('tr#' + row_id).find('td[aria-describedby="table_pasada_tercero_actions"]').html(newDiv);
            });
        },

        delete_calculadora: function (row_id)
        {
            // let row_data =gridhandler.getRowData(row_id);
            let confirm = $(`<div class="modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body p-0">
                            <div class="card">
                                <h4 class="card-header py-1">
                                    Confirma Eliminar Registro
                                    <button type="button" class="close border-secondary border rounded" data-dismiss="modal" aria-label="Close">
                                        <i class="fa-icon fa-solid fa-close"></i>
                                    </button>
                                </h4>
                                <div class="card-body p-2">
                                    <br>
                                    ¿Deseas eliminar el registro?
                                    <br>
                                    <br>
                                </div>
                                <div class="card-footer text-muted text-right py-1">
                                    <button type="button" class="btn btn-sm btn-primary p-1" id="btn_confirm_delete">Sí, Eliminar</button>
                                    <button type="button" class="btn btn-sm btn-secondary p-1" data-dismiss="modal" id="btn_cancel_delete">Cancelar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`).modal();
            $('#btn_confirm_delete', confirm).click(function () {
                confirm.modal('hide');
                do_delete();
            });
            confirm.on('hidden.bs.modal', function (e) {confirm.remove();});

            function do_delete() {
                let request = {
                    url: getUrlForAjax('costos_contenedor_acciones'),
                    data: {
                        accion: 'delete_calculadora',
                        id: row_id
                    }
                };
                jqAjax(request, function (res) {
                    if (res.status) {
                        $d.notify('OK', (res.message||'Registro eliminado'), 'success');
                        gridhandler.trigger('reloadGrid');
                    }
                });
            }
        },

        delete_rows_selected: function ()
        {
            const ids = getGridVisibleSelectedIds(gridhandler);
            // const ids = getGridVisibleIds(gridhandler);
            if (empty(ids)) {
                return uicostoscontenedor.alert({
                    titulo: 'Alerta!',
                    mensaje: '<b>NO HAY REGISTROS SELECCIONADOS.</b><br>Seleccione registros para eliminar',
                    type: 'warning',
                });
            }
            const html = `<br>¿Deseas eliminar los registros seleccionados?<br><br>`;
            const confirm = uicostoscontenedor.alert({
                titulo: 'Eliminar registros',
                mensaje: html,
                type: 'ask',
                options_btn: {
                    textButtonConfirm: 'Sí, eliminar',
                    textButtonCancel: 'Cancelar',
                }
            });
            confirm.then(function () {
                let request = {
                    url: getUrlForAjax('costos_contenedor_acciones'),
                    data: {
                        accion: 'delete_calculadoras',
                        ids: ids
                    }
                };
                jqAjax(request, function (res) {
                    if (res.status) {
                        $d.notify('OK', (res.message||'Registros eliminados'), 'success');
                        gridhandler.trigger('reloadGrid');
                    }
                });
            });
        }
    },
};

exporter.excel_table = function () {
    let file_name = $('#nombre_pasada_tercero').val();
    if (empty(file_name)) {
        let date = getDate();
        file_name = 'Pasada Por Tercero_'+date;
    }

    uicostoscontenedor.export2Excel({
        tableId: 'tabla_pasada_tercero',
        fileName: file_name,
        selectorHeader: 'tr.real-header',
        camposNumeroUsd: ['Precio de Venta', 'Total', 'Ganancia', 'Pasada USD'],
        beforeExport: function () {
            pasada_tercero.set_read_mode(true);
            $('.noprint').hide();
            $('.articulo-label').show();
            $('.articulo').hide();
        },
        afterExport: function () {
            pasada_tercero.set_edit_mode(true);
            $('.noprint').show();
            $('.articulo-label').hide();
            $('.articulo').show();
        },
        colWidths: {'Precio de Venta': 80, Articulo: 200, Cantidad: 100, Precio: 100, Total: 120, Ganancia: 100, 'Pasada USD': 150},
    });

}