const uicostoscontenedor = {
    alert: function (config)
    {
        console.log('uicostoscontenedor.alert()');
        let options = {...{
                titulo: 'Titulo',
                mensaje: 'mensaje',
                type: '',
                options_btn: {},
                autoClose: true,
                recursive: false,
                onOpen: function (dialogo){},
                beforeOpen: function (dialogo){},
                /* backdrop: 'static',
                draggable: false, */
        }, ...config};

        let options_btn_ = {...{
                addButtonConfirm: true,
                textButtonConfirm: 'OK',
                idButtonConfirm: 'btn_confirm',
                clasesButtonConfirm: 'btn-primary',
                addButtonCancel: true,
                textButtonCancel: 'Cancel',
                idButtonCancel: 'btn_cancel',
                clasesButtonCancel: 'btn-secondary',
            }, ...options.options_btn};

        const icons = {
            warning: '<i class="fa-icon fa-solid fa-triangle-exclamation text-warning txt_2em"></i>',
            danger: '<i class="fa-icon fa-solid fa-triangle-exclamation text-danger txt_2em"></i>',
            error: '<i class="fa-icon fa-solid fa-triangle-exclamation text-danger txt_2em"></i>',
            ask: '<svg aria-hidden="true" focusable="false" data-prefix="fad" data-icon="face-thinking" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="svg-inline--fa fa-face-thinking fa-4x text-warning fa-icon" style="width: 2.5rem;"><g class="fa-duotone-group"><path fill="currentColor" d="M0 256c0 45 11.6 87.3 32 124l0-28c0-30.9 25.1-56 56-56s56 25.1 56 56l0 3 92.2-33.5-82.4-34.7c-8.1-3.4-12-12.8-8.5-21s12.8-12 21-8.5l122.5 51.6c22.7 9.6 37.9 31.2 39.2 55.6c1.5 24.2-12.9 47.4-36.8 56.1l-35.8 13-21 57.7c-2.5 6.8-5.8 13.1-9.8 18.8c10.3 1.3 20.8 1.9 31.4 1.9c141.4 0 256-114.6 256-256S397.4 0 256 0S0 114.6 0 256zM114.1 119.9c-4.4-7.7-1.7-17.4 6-21.8l7.1-4c35.2-20.1 79.3-15.9 110.1 10.5c4.4 3.8 8.8 7.5 13.2 11.3c6.7 5.8 7.5 15.9 1.7 22.6s-15.9 7.5-22.6 1.7l-13.2-11.3c-20.5-17.6-49.9-20.4-73.4-7l-7.1 4c-7.7 4.4-17.4 1.7-21.8-6zM208.4 176a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z" class="fa-secondary"></path><path fill="currentColor" d="M143 121.9c23.5-13.4 52.9-10.6 73.4 7l13.2 11.3c6.7 5.8 16.8 5 22.6-1.7s5-16.8-1.7-22.6l-13.2-11.3C206.4 78.1 162.3 74 127.1 94.1l-7.1 4c-7.7 4.4-10.3 14.2-6 21.8s14.2 10.3 21.8 6l7.1-4zM176.4 208a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM112 352c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 26.5 21.5 48 48 48l47.2 0c20.2 0 38.2-12.6 45.1-31.6l26.1-71.7 49.8-18.1c12.5-4.5 18.9-18.3 14.4-30.8s-18.3-18.9-30.8-14.4L112 400.6l0-48.6zM368.4 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z" style="fill: #183153"></path></g></svg>'
        };

        if (options.type === '' || options.type === 'warning' || options.type === 'alert' || options.type === 'error' || options.type === 'danger') {
            options_btn_.addButtonConfirm = false;
            options_btn_.textButtonCancel = options_btn_.textButtonCancel||'OK';
            options_btn_.clasesButtonCancel = 'btn-primary';
        }

        let buttons = [];
        if (options_btn_.addButtonConfirm) {
            buttons.push(`<button type="button" class="btn btn-sm ${options_btn_.clasesButtonConfirm} p-1" id="${options_btn_.idButtonConfirm}">${options_btn_.textButtonConfirm}</button>`);
        }
        if (options_btn_.addButtonCancel) {
            buttons.push(`<button type="button" class="btn btn-sm ${options_btn_.clasesButtonCancel} p-1" data-dismiss="modal" id="${options_btn_.idButtonCancel}">${options_btn_.textButtonCancel}</button>`);
        }

        var defer = $.Deferred();

        let icon = icons[options.type]||'';

        const dialog = $(`<div class="modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-body p-0">
                                    <div class="card">
                                        <h4 class="card-header py-1 px-1">
                                            ${options.titulo}
                                            <button type="button" class="close border-secondary border rounded" data-dismiss="modal" aria-label="Close">
                                                <i class="fa-icon fa-solid fa-close"></i>
                                            </button>
                                        </h4>
                                        <div class="card-body p-2" style="font-size: initial">
                                            ${icon+ (icon.length>0?'<br>':'')}
                                            ${options.mensaje}
                                        </div>
                                        <div class="card-footer text-muted text-right py-1 d-inline-flex justify-content-end">
                                            <div>${buttons.join('</div><div class="ml-3">')}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>`).modal({show:false});
        dialog.on('hidden.bs.modal', function (e) {
            dialog.remove();
        });
        dialog.on('shown.bs.modal', function (e) { // ya es visible para el usuario
            dialog.find('.card-footer button')[0].focus();
            options.onOpen(dialog);
        });
        dialog.on('show.bs.modal', function (e) { // se ejecuta inmediamente cuando el show es llamado (before show/before open)
            options.beforeOpen(dialog);
        });

        dialog.modal('show');

        $('#'+options_btn_.idButtonConfirm).click(function (e) {
            e.target.disabled = true;
            if(!defer.isResolved && !defer.isRejected) {
                if(!options.recursive) {
                    defer.resolve(dialog);
                }
                else
                    defer.notify(dialog);
            }


            if (options.autoClose)
                dialog.modal('hide');
        });

        $('#'+options_btn_.idButtonCancel).click(function (e) {
            e.target.disabled = true;
            if(!defer.isResolved && !defer.isRejected)
                defer.reject(dialog);

            dialog.modal('hide');
        });

        return defer.promise();
    },

    roundNumber: function (num, dec=2){
        return Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
    },

    matchCustomSearchProductos: function (params, data, initials=false) {
        // If there are no search terms, return all of the data
        delete data._normalized;
        delete data.matches;
        delete data._starts;
        delete data.matchPriority;

        if ($.trim(params.term) === '') {
            return data;
        }

        // Do not display the item if there is no 'text' property
        if (typeof data.text === 'undefined') {
            return null;
        }

        var iOSremoveAccents = function(str) {
            return strip_tags(str.normalize("NFD").replace(/[\u0300-\u036f]/g, "")).toUpperCase();
        };

        // `params.term` should be the term that is used for searching
        // `data.text` is the text that is displayed for the data object
        var terms = params.term.split(' ').map(iOSremoveAccents);
        var normalizedItem = iOSremoveAccents(data.text).toUpperCase();
        data._normalized = normalizedItem;

        let ok = false;
        if (initials) {
            var starts = terms[0];
            var regExp = buildRegExp(terms);
            let match_ = false;
            try {
                var matches = normalizedItem.match(regExp);
                if(matches === null)
                    match_ = false;
                else {
                    ok = true;
                    match_ = true;
                    data.matches = matches.length;
                }
            } catch (e) {}
            if (match_) {
                data._starts = normalizedItem.indexOf(starts) === 0;
                data.matchPriority = 0;
                let words = normalizedItem.split(/\b/);
                for (let i = 0; i < words.length; i++) {
                    let w = words[i];
                    if (w !== '' && w !== '-') {
                        if (regExp.test(w)) {
                            data.matchPriority += 1000 - i;
                        }
                    }
                }
            }
        }
        else {
            ok = terms.every(function (term, index) {
                var regex = new RegExp("\\b" + $.ui.autocomplete.escapeRegex(iOSremoveAccents(term)), "i");
                return regex.test(normalizedItem);
            });
        }

        if (ok) {
            return data;
        }

        function buildRegExp(initials) {
            let re = [];
            for(let c of initials)
                re.push("\\b" + pregQuote(c));
            return new RegExp(re.join("|"), "giu");
        }

        function pregQuote(str) {
            var term =  strip_tags(str.normalize("NFD").replace(/[\u0300-\u036f]/g, ""));
            return term.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        }

        // Return `null` if the term should not be displayed
        return null;
    },

    sorterProductos:  function (data) {
        data.sort(function(rowA, rowB) {
            if (typeof rowB.selected === 'undefined')
                return 0;

            if(rowA._starts && rowB._starts) {
                let matchPriority = rowB.matchPriority - rowA.matchPriority;
                if(matchPriority)
                    return matchPriority;
                let len = rowA._normalized.length - rowB._normalized.length;
                if(len)
                    return len;
                return rowA._normalized < rowB._normalized ? -1 : +(rowA._normalized > rowB._normalized);
            }
            if(rowA._starts)
                return -1;
            if(rowB._starts)
                return 1;
            let matchesCount = rowB['matches'] - rowA['matches'];
            if(matchesCount)
                return matchesCount;
            let matchPriority = rowB.matchPriority - rowA.matchPriority;
            if(matchPriority)
                return matchPriority;
            return rowA._normalized < rowB._normalized ? -1 : +(rowA._normalized > rowB._normalized);
        })
        return data;
    },

    export2Excel:function (conf_={}){
        const conf = {...{
                tableId: null,
                selectorHeader: null,
                sheetName: '',
                fileName: '',
                camposNumeroUsd: [],
                camposNumeroPesos: [],
                camposMonedaUSD: [],
                camposTextUsd: [],
                camposTextPesos: [],
                data: null,
                setCellStyle: function (item, header, cell, styles_default, row) {return null},
                setCellStyleEnd: function (cell, definicion, row) {return null},
                beforeExport: function () {},
                afterExport: function () {},
                beforeDownload: function () {},
                colWidths: [],
                colsStyles: {},
                headerStyles: {},
                extraSheets: [],
                return: 'download', // 'download' => descarga el archivo || 'file' => el archivo en base64, 'wsheet' => la hoja que genera || 'wbook' => el libro que se genera
            }, ...conf_};

        if (conf.return === 'download') {
            jqBlockUI("Generando excel");
        }


        if(conf.fileName.length===0){
            conf.fileName = document.title.replaceAll(" ", "_")+getDate();
        }
        if (conf.sheetName.length === 0) {
            conf.sheetName = document.title;
        }

        conf.sheetName = conf.sheetName.length > 30? conf.sheetName.substring(0, 30): conf.sheetName;

        const table = document.querySelector("#"+conf.tableId);
        const abc = [
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
        ];

        conf.beforeExport();
        try {
            let styles_default = _getstylesDefault();
            let headers = conf.headers||_getHeaders();

            let styles = {};
            let type = 'xlsx';
            let wb, ws;
            let key_header = 'key';
            if (conf.data === null) {
                wb = XLSX.utils.table_to_book(table, { sheet: conf.sheetName, display:false, raw:true, cellStyles:true,  cellText:true, cellHTML:true, cellNF: true});
                ws = wb.Sheets[conf.sheetName];
                let data = XLSX.utils.sheet_to_json(ws);
                key_header = 'label';
                data.forEach(function (item, row) {
                    headers.forEach(function (header, column) {
                        let valor = item[header.label]||'';
                        let cell = header.column+(row+2);
                        if (header.label === '#' || header.label === 'rn' ) {
                            styles[cell] = styles_default.rn;
                        }
                        else {
                            if(isNumber(valor)){
                                styles[cell] = styles_default.numero;
                            }
                            else {
                                styles[cell] = styles_default.default_;
                            }
                            if (conf.camposNumeroUsd.includes(header.label)){
                                styles[cell] = styles_default.numero_usd;
                            }
                            if (conf.camposNumeroPesos.includes(header.label)){
                                styles[cell] = styles_default.numero_pesos;
                            }

                            if (conf.camposTextUsd.includes(header.label)){
                                styles[cell] = styles_default.text_usd;
                            }
                            if (conf.camposTextPesos.includes(header.label)){
                                styles[cell] = styles_default.text_pesos;
                            }
                            if (conf.camposMonedaUSD.includes(header.label)){
                                styles[cell] = styles_default.moneda_usd;
                                ws[cell].z = '"USD" #,##0.00';
                            }
                        }

                        if (conf.colsStyles[header.label])
                            styles[cell] = conf.colsStyles[header.label];

                        let set_cell_style = conf.setCellStyle(item, header, cell, styles_default, row);
                        if (set_cell_style !== null && typeof set_cell_style === 'object')
                            styles[cell] = set_cell_style;

                    });
                });
            }
            else if(Array.isArray(conf.data)) {
                let data = [];
                conf.data.forEach(function (item, row) {
                    let set_item = {};
                    headers.forEach(function (header, column) {
                        let valor = item[header.key]||'';
                        let cell = header.column+(row+2);
                        if (header.key === '#' || header.key === 'rn' ) {
                            valor = (row+1);
                            styles[cell] = styles_default.rn;
                        }
                        else {
                            if(isNumber(valor)){
                                styles[cell] = styles_default.numero;
                                valor = _addCommas(valor);
                            }
                            else {
                                styles[cell] = styles_default.default_;
                            }
                            if (conf.camposNumeroUsd.includes(header.key)){
                                styles[cell] = styles_default.numero_usd;
                            }
                            if (conf.camposNumeroPesos.includes(header.key)){
                                styles[cell] = styles_default.numero_pesos;
                            }

                            if (conf.camposTextUsd.includes(header.key)){
                                styles[cell] = styles_default.text_usd;
                            }
                            if (conf.camposTextPesos.includes(header.key)){
                                styles[cell] = styles_default.text_pesos;
                            }

                            if (conf.camposMonedaUSD.includes(header.label)){
                                styles[cell] = styles_default.moneda_usd;
                                ws[cell].z = '"USD" #,##0.00';
                            }
                        }

                        if (conf.colsStyles[header.key])
                            styles[cell] = conf.colsStyles[header.key];

                        let set_cell_style = conf.setCellStyle(item, header, cell, styles_default, row);
                        if (set_cell_style !== null && typeof set_cell_style === 'object')
                            styles[cell] = set_cell_style;

                        set_item[header.label] = valor;
                    });
                    data.push(set_item);
                });

                wb = XLSX.utils.book_new();
                ws = XLSX.utils.json_to_sheet(data);
                XLSX.utils.book_append_sheet(wb, ws, conf.sheetName); // add worksheet to workbook
            }

            let wscols = [];
            try {
                headers.forEach(function (header, i) {
                    let cell = header.column+"1";
                    if (ws[cell])
                        ws[cell].s = styles_default.header;

                    if (conf.headerStyles[header[key_header]])
                        styles[cell] = conf.headerStyles[header[key_header]];

                    if (Array.isArray(conf.colWidths)) {
                        header.width = conf.colWidths[i]||header.width;
                    }
                    else if(typeof conf.colWidths === 'object') {
                        header.width = conf.colWidths[header[key_header]]||header.width;
                    }

                    if (header.width) {
                        wscols.push({ wpx: header.width });
                    }
                    else {
                        wscols.push({ wch: (header.label.length + 5) });
                    }
                });
            }catch (e) {console.log(e);}


            $.each(styles, function (cell, style) {
                if (ws[cell])
                    ws[cell].s = style;
            });

            let inc_ = 0;
            $.each(ws, function (key, def) {
                if (key.includes('!ref') || key.includes('!merges'))
                    return;

                let set_cell_style = conf.setCellStyleEnd(key, def, inc_);
                if (set_cell_style !== null && typeof set_cell_style === 'object')
                    ws[key].s = set_cell_style;

                inc_++;
            });

            ws["!cols"] = wscols;
            ws["!headers"] = headers;

            // add extra sheet´s to workbook
            /* conf.extraSheets.forEach(function (sheet, i) {
                XLSX.utils.book_append_sheet(wb, sheet, sheet.sheetName);
            }); */

            let response = null;
            if (conf.return === 'download') {
                conf.beforeDownload(wb);
                let archivo= XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' });
                let a = document.createElement('a');
                $(a).attr('href', 'data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64,' + archivo);
                $(a).attr('download', conf.fileName+'.xlsx');
                a.click();
                a.remove();
                jqUnBlockUI();
            }
            else {
                if (conf.return === 'file')
                    response = XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' });

                if (conf.return === 'wsheet') {
                    response = {};
                    response[conf.sheetName] = ws;
                }

                if (conf.return === 'wbook')
                    response = wb;

            }
            conf.afterExport();
            if (conf.return !== 'download') {
                return response;
            }
        }
        catch (e) {
            console.log(e);
            jqUnBlockUI();
            conf.afterExport();
        }

        function _getstylesDefault()
        {
            return {
                default_: {
                    alignment: {
                        wrapText: true,
                        vertical: 'center',
                    },
                },
                header: {
                    font: {bold: true,/*  sz: 10 */},
                    fill: {fgColor: {rgb: "e9ecef"}},
                    alignment: {
                        wrapText: true,
                        horizontal: 'center',
                        vertical: 'center'
                    },
                    border: {
                        // top: { style: "thin", color: { rgb: "000000" } }, // Borde superior
                        bottom: { style: "medium", color: { rgb: "dee2e6" } }, // Borde inferior
                        left: { style: "thin", color: { rgb: "dee2e6" } }, // Borde izquierdo
                        right: { style: "thin", color: { rgb: "dee2e6" } } // Borde derecho
                    }
                },
                rn: {
                    alignment: {
                        wrapText: true,
                        horizontal: 'center',
                        vertical: 'center'
                    },
                },
                numero: {
                    numFmt: '#,##0.00',
                    alignment: {
                        wrapText: true,
                        horizontal: 'right',
                        vertical: 'center'
                    },
                },
                numero_usd: {
                    numFmt: '#,##0.00',
                    font: {color: {rgb: "139312"}},
                    alignment: {
                        wrapText: true,
                        horizontal: 'right',
                        vertical: 'center'
                    },
                },
                numero_pesos: {
                    numFmt: '#,##0.00',
                    font: {color: {rgb: "0000a2"}},
                    alignment: {
                        wrapText: true,
                        horizontal: 'right',
                        vertical: 'center'
                    },
                },
                text_usd: {
                    font: {color: {rgb: "139312"}},
                    alignment: {
                        wrapText: true,
                        vertical: 'center'
                    },
                },
                text_pesos: {
                    font: {color: {rgb: "0000a2"}},
                    alignment: {
                        wrapText: true,
                        vertical: 'center'
                    },
                },
                moneda_usd: {
                    numFmt: 'USD #,##0.00',
                    font: {color: {rgb: "139312"}},
                    alignment: {
                        wrapText: true,
                        horizontal: 'right',
                        vertical: 'center'
                    },
                },
            }
        }
        function _getHeaders()
        {
            let headers = conf.selectorHeader == null ? $('thead tr:first th', table): $(conf.selectorHeader +" th");
            return headers.filter(function(){
                return $(this).css('visibility') != 'hidden' && $(this).css('display') != 'none' && !$(this).is(':hidden') && $(this).attr('tabindex')!="-1"
            }).map(function (i) {
                let div_ = $('<div>');
                div_.html($(this).html());
                div_.find('.filter').remove();
                div_.find('.span-sorter-column').remove();
                let header_text = div_.text().fulltrim();
                div_.remove();
                
                return {
                    label: header_text,
                    key: this.dataset.column||i,
                    column:abc[i],
                    width: this.clientWidth
                }
            }).get();
        }

        function _addCommas(nStr)
        {
            nStr += '';
            x = nStr.split('.');
            x1 = x[0];
            x2 = x.length > 1 ? '.' + x[1] : '';
            var rgx = /(\d+)(\d{3})/;
            while (rgx.test(x1)) {
                x1 = x1.replace(rgx, '$1' + ',' + '$2');
            }
            return x1 + x2;
        }

        function getContentWidth (element) {
            var styles = getComputedStyle(element);
            // console.log(element.clientWidth);

            return element.clientWidth
                - parseFloat(styles.paddingLeft)
                - parseFloat(styles.paddingRight)
        }

    },

    compress_data: function (data)
    {
        let jsonString = JSON.stringify(data);
        let compressedData = pako.gzip(jsonString);
        let base64 = btoa(String.fromCharCode.apply(null, compressedData));
        console.log('compress string => ', base64);
        return base64;
    }


};