ALTER TABLE `vitex`.`grupos_de` 
ADD COLUMN `id` INT NOT NULL FIRST;


ALTER TABLE `grupos_de`
CHANGE COLUMN `id` `id` INT NOT NULL AUTO_INCREMENT,
DROP PRIMARY KEY,
ADD PRIMARY KEY (`id`),  -- Aquí `id` es la única clave primaria
ADD UNIQUE KEY `unique_key` (`tipo_grupo`, `grupo`, `item_id`);

CREATE TABLE `vitex`.`grupos` (
  `id` INT NOT NULL,
  `grupo` VARCHAR(64) NOT NULL,
  `user_create` VARCHAR(45) NOT NULL,
  `alta_db` VARCHAR(45) NOT NULL,
  `last_user` VARCHAR(45) NOT NULL,
  `last_change` VARCHAR(45) NULL,
  `privado` TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`));


ALTER TABLE `vitex`.`grupos` 
CHANGE COLUMN `user_create` `user_create` VARCHAR(45) NOT NULL DEFAULT 'sistema' ,
CHANGE COLUMN `alta_db` `alta_db` TIMESTAMP NOT NULL ,
CHANGE COLUMN `last_user` `last_user` VARCHAR(45) NOT NULL DEFAULT 'sistema' ,
CHANGE COLUMN `last_change` `last_change` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ;

ALTER TABLE `vitex`.`grupos` 
ADD COLUMN `tipo_grupo` VARCHAR(64) NOT NULL AFTER `privado`;

ALTER TABLE `vitex`.`grupos` 
CHANGE COLUMN `id` `id` INT NOT NULL AUTO_INCREMENT ;

INSERT INTO vitex.grupos(tipo_grupo,grupo,alta_db)
SELECT DISTINCT tipo_grupo, grupo, NOW() FROM grupos_de;

ALTER TABLE `vitex`.`grupos_de` 
ADD COLUMN `id_grupo` INT NULL AFTER `activo`;

UPDATE grupos_de gd
JOIN grupos g
ON gd.tipo_grupo COLLATE utf8mb4_unicode_ci = g.tipo_grupo COLLATE utf8mb4_unicode_ci
AND gd.grupo COLLATE utf8mb4_unicode_ci = g.grupo COLLATE utf8mb4_unicode_ci
SET gd.id_grupo = g.id;


ALTER TABLE `vitex`.`grupos_de` 
CHANGE COLUMN `id_grupo` `id_grupo` INT NOT NULL ;

ALTER TABLE grupos_de
ADD CONSTRAINT fk_grupos_de_id_grupo
FOREIGN KEY (id_grupo)
REFERENCES grupos(id)
ON DELETE CASCADE
ON UPDATE CASCADE;
